/* Analytic results for G-type functions, including value at small,
   non-zero t. */

/* Need to check data types on everything here... */

#include "internal.h"

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00000 (void) { 
  return 0.0L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G0000x (TVIL_REAL x, TVIL_REAL qq)
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return (-15.L*x)/2.L - (PI2*x)/2.L + (11.L*x*lnbarx)/2.L + (PI2*x*lnbarx)/6.L -
    (3.L*x*lnbarx2)/2.L + (x*lnbarx2*lnbarx)/6.L + (2.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G000xx (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return -15.L*x + 11.L*x*lnbarx - 3.L*x*lnbarx2 + (x*lnbarx2*lnbarx)/3.L -
    (8.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00x0x (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return -15.L*x - (PI2*x)/3.L + 11.L*x*lnbarx + (PI2*x*lnbarx)/3.L - 
    3.L*x*lnbarx2 + (x*lnbarx2*lnbarx)/3.L + (16.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00xxx (TVIL_REAL x, TVIL_REAL qq)
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return (-45.L*x)/2.L + (33.L*x*lnbarx)/2.L + (PI2*x*lnbarx)/6.L - 
    (9.L*x*lnbarx2)/2.L + (x*lnbarx2*lnbarx)/2.L + 9.L*SQRT3*x*LS2;
}

/* ****************************************************************** */ 

TVIL_COMPLEX TVIL_G0xxxx (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return -30.L*x + 22.L*x*lnbarx - 6.L*x*lnbarx2 + 
    (2.L*x*lnbarx2*lnbarx)/3.L + (56.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */
 
TVIL_COMPLEX TVIL_Gx0000 (TVIL_REAL x, TVIL_REAL qq) 
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-7.L*x)/3.L - (2.L*PI2*x)/3.L + 4.L*x*lnbarx + (PI2*x*lnbarx)/3.L - 
    2.L*x*lnbarx2 + (x*lnbarx2*lnbarx)/3.L - (2.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */
 
TVIL_COMPLEX TVIL_Gx000x (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-59.L*x)/6.L - (PI2*x)/2.L + (19.L*x*lnbarx)/2.L + 
    (PI2*x*lnbarx)/6.L - (7.L*x*lnbarx2)/2.L + (x*lnbarx2*lnbarx)/2.L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx00xx (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-52.L*x)/3.L - (PI2*x)/3.L - (2.L*PI*PI2*x)/(9.L*SQRT3) + 
     15.L*x*lnbarx + (PI2*x*lnbarx)/6.L - 5.L*x*lnbarx2 + 
     (2.L*x*lnbarx2*lnbarx)/3.L + 6.L*SQRT3*x*LS2 - 
     3.L*SQRT3*x*lnbarx*LS2 - (4.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */
 
TVIL_COMPLEX TVIL_Gx0x0x (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-52.L*x)/3.L + 15.L*x*lnbarx - 5.L*x*lnbarx2 + 
    (2.L*x*lnbarx2*lnbarx)/3.L + (8.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */
 
TVIL_COMPLEX TVIL_Gx0xxx (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-149*x)/6 + (41*x*lnbarx)/2 - (13*x*lnbarx2)/2 + 
    (5*x*lnbarx2*lnbarx)/6 + 9*SQRT3*x*LS2 - 3*SQRT3*x*lnbarx*LS2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gxxxxx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-97.*x)/3 + 26*x*lnbarx - 8*x*lnbarx2 + x*lnbarx2*lnbarx + 
    12*SQRT3*x*LS2 - 6*SQRT3*x*lnbarx*LS2 + 6*x*Zeta3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G000xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX result;

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = 2*y*TVIL_Trilog(1 - x/y) + 2*x*TVIL_Trilog(1 - y/x) +
    (3*(x - y) - x*lnbarx + y*lnbary)*TVIL_Dilog(1 - x/y) + 
    (-15*(x + y))/2 + (11*x*lnbarx)/2 - (x*lnbarx*lnbarx2)/3. + 
    (11.*y*lnbary)/2. - 3*x*lnbarx*lnbary + x*lnbarx2*lnbary + 
    (3*(x - y)*lnbary2)/2. - x*lnbarx*lnbary2/2 + y*lnbary*lnbary2/6. + 
    - (4*(x + y)*Zeta3)/3.;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00x0y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{ 
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX result;

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = -2*(x + y)*(TVIL_Trilog(1 - x/y) + TVIL_Trilog(1 - y/x)) +
  + (2*(x - y) + (x + y)*TVIL_CLOG(x/y))*TVIL_Dilog(1 - x/y) +  
  -((45 + PI2)*(x + y))/6 + ((33*x + PI2*y)*lnbarx)/6 - (x*lnbarx2)/2 + 
  ((x + y)*lnbarx*lnbarx2)/3 + ((PI2*x + 33*y)*lnbary)/6 - 2*x*lnbarx*lnbary + 
  ((-x - 2*y)*lnbarx2*lnbary)/2 + ((2*x - 3*y)*lnbary2)/2 + 
  ((x + 2*y)*lnbarx*lnbary2)/2 + ((-x - y)*lnbary*lnbary2)/6 + 
  (8*(x + y)*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx000y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX result;

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = (y-x)*(TVIL_Trilog(1-x/y) + TVIL_Trilog(1-y/x) + (lnbary - 2)*TVIL_Dilog(1-x/y) +
  (-1./6.)*lnbarx*lnbarx2 + (1./3.)*lnbary*lnbary2 - 0.5L*lnbarx*lnbary2 - (PI2/6)*lnbarx +
    - Zeta3/3.) + (-14*x - 2*PI2*x - 45*y - PI2*y)/6 + 4*x*lnbarx - x*lnbarx2 + 
    + ((33 + PI2)*y*lnbary)/6. - 2.*x*lnbarx*lnbary + (y*lnbarx2*lnbary)/2. + 
    ((2*x - 3*y)*lnbary2)/2;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx00yy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq) 
{
  TVIL_REAL lnxoy, lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX k, lnk, sqrt, result;

  k = (1 - TVIL_CSQRT(1-4*y/x))/(1 + TVIL_CSQRT(1-4*y/x));

  /* This shouldn't be necessary, but just in case... */
  if (TVIL_CIMAG(k) > 0) k = TVIL_CONJ(k);

  lnk = TVIL_CLOG (k);
  sqrt = x * (1.L - k)/(1.L + k);  

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;
  lnxoy = lnbarx - lnbary;

  result = 
    sqrt*(2*TVIL_Trilog(-k) + 4*TVIL_Trilog(k/(1+k))
   	 + TVIL_Dilog(-k)*(2*lnbary - 4)
    + (1./12.)*lnk*lnk*lnk + (lnbarx/4 + lnbary/4 - 1)*lnk*lnk
   - (PI2/6 + (1./4.)*lnxoy*lnxoy)*lnk - (1./12.)*lnxoy*lnxoy*lnxoy 
	   + (PI2/6)*(lnbarx - 2) - 2*Zeta3)
    + (y/3 - x/6)*lnbary2*lnbary + (x/2)*lnbarx2*lnbary
    + (x - 3*y)*lnbary2 - 2*x*lnbarx*lnbary
    - x*lnbarx2 + ((PI2/6) * x + 11*y)*lnbary + 4*x*lnbarx 
    + (4*(x-2*y)/3)*Zeta3 - (7 + PI2)*x/3 - 15*y;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0x0y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq) 
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = -2*y*TVIL_Trilog(1-x/y) -2*y*TVIL_Trilog(1-y/x) + 
    (3*x-3*y + (2*y-x)*lnbarx - y*lnbary)*TVIL_Dilog(1-x/y) +
    (-59*x - 45*y)/6 + (19*x*lnbarx)/2 - 2*x*lnbarx2 + (y*lnbarx*lnbarx2)/3 + 
    (11*y*lnbary)/2 - 3*x*lnbarx*lnbary + (x - y)*lnbarx2*lnbary + 
    (3.*(x - y)*lnbary2)/2 + ((-x + 2*y)*lnbarx*lnbary2)/2 - (y*lnbary*lnbary2)/6. + 
    (8.*y*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0y0y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq) 
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbary, lnbary2;

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = -2.L * (x-y) * (x-y) * TVIL_Trilog(1-x/y)/x +
           2.L * (x-y) * (2 - lnbary) * TVIL_Dilog(1-x/y) +
           ((y - 2.L * x)/3.L) * lnbary * lnbary2 +
           (x * lnbarx + 2.L * x - 3.L * y) * lnbary2 +
           4.L * x * lnbarx * (1.L - lnbary) + 11.L * y * lnbary +
           -7.L * x/3.L - 15.L * y + 
           2.L * (1.L + y/x) * (3.L * y - x) * Zeta3/3.L;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G0xxyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL lnxoy, lnyox, lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX result;

  lnxoy = TVIL_LOG (x/y);
  lnyox = -lnxoy;
  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = TVIL_POW(TVIL_SQRT(x) - TVIL_SQRT(y), 2) *
    (2*TVIL_Trilog(1-x/y) + 2*TVIL_Trilog(1-y/x) + 
     2*lnyox*TVIL_Dilog(1-x/y) - (1./3.)*lnbarx*lnbarx2) + 
    TVIL_SQRT(x)*TVIL_SQRT(y)*(-32*TVIL_Trilog(-TVIL_CSQRT(x/y)) + 
			       16*lnxoy*TVIL_Dilog(-TVIL_SQRT(x/y)) +
			       + 4*lnxoy*lnxoy*TVIL_LOG(1 + TVIL_SQRT(x/y)) + 
			       2*lnbarx*lnbary*lnyox - (2./3.)*lnbary*lnbary2 + 
			       4*Zeta3) +
    -15*(x + y) + 11*x*lnbarx - 3*x*lnbarx2 + 11*y*lnbary + 
    (2*x + y)*lnbarx2*lnbary - 3*y*lnbary2 + (-2*x - y)*lnbarx*lnbary2 + 
    (2*(x + y)*lnbary*lnbary2)/3 - (14*(x + y)*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G0xyxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX Ax, Ay, result;
  if (SAME2(x,y)) return TVIL_G0xxxx(x,qq);
  if (SAME2(0,x)) return TVIL_G00x0x(y,qq);
  if (SAME2(0,y)) return TVIL_G00x0x(x,qq);

  Ax = TVIL_A (x, qq);
  Ay = TVIL_A (y, qq);

  result = 2.L * (y * TVIL_FBARxxyy(y,x,qq) - x * TVIL_FBARxxyy(x,y,qq)
           + (x + Ax) * TVIL_I2(x,y,y,qq) - (y + Ay) * TVIL_I2(x,x,y,qq)
           + (Ay - Ax) * TVIL_I2(0,x,y,qq) 
           + (2.L/3.L) * (y*y - x*x) + 0.25L * (x * Ax - y * Ay))/(x-y);
 
  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00yxx (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx, lnbary, result;
  if (SAME2(x,y)) return TVIL_G00xxx(x,qq);
  if (SAME2(0,x)) return TVIL_G0000x(y,qq);
  if (SAME2(0,y)) return TVIL_G000xx(x,qq);

  lnbarx = TVIL_Ap (x, qq);
  lnbary = TVIL_Ap (y, qq);

  result = (-1.L - 0.5L * y/x) * TVIL_FBARx0yy(y,x,qq) +
           (2.L - 0.5L * y/x) * TVIL_I2(x,x,y,qq) +
           (2.L * x + 1.5L * y + Zeta2 * y) * lnbarx +
           y * (-1.25L - 0.375L * y/x) * lnbary +
           0.5L * y * lnbarx * lnbary * (lnbary - lnbarx) + 
           -14.L*x/3.L - 11.L * y/12.L + 17.L * y * y/(24.L * x);

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00xxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx, lnbary, result;
  if (SAME2(x,y)) return TVIL_G00xxx(x,qq);
  if (SAME2(0,x)) return TVIL_G0000x(y,qq);
  if (SAME2(0,y)) return TVIL_G00x0x(x,qq);

  lnbarx = TVIL_Ap (x, qq);
  lnbary = TVIL_Ap (y, qq);

  result = ( (-13.L/3.L - Zeta2 + (5.L + Zeta2) * lnbarx
             - 2.5L * lnbarx * lnbarx + 0.5 * lnbarx * lnbarx * lnbarx)*x*x 
           + (41.L/12.L + Zeta2 - (9.L/4.L) * lnbarx 
             + 0.5L * lnbarx * lnbarx + (2.5L - Zeta2) * lnbary
             -2.L * lnbarx * lnbary + 0.5L * lnbarx * lnbarx * lnbary)*x*y 
           + (11.L/12.L - 0.25L * lnbary) * y * y 
           + (y - 2.L*x) * TVIL_FBARx0xy (x, y, qq) 
           + y * TVIL_FBARx0yy (y, x, qq) +  
           + TVIL_I2(0, x, y, qq)*(x - y + x*lnbarx) )/(x-y);

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G0xxxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx, lnbary, result;
  if (SAME2(x,y)) return TVIL_G0xxxx(x,qq);
  if (SAME2(0,x)) return TVIL_G0000x(y,qq);
  if (SAME2(0,y)) return TVIL_G00xxx(x,qq);

  lnbarx = TVIL_Ap (x, qq);
  lnbary = TVIL_Ap (y, qq);

  result = (-39.L*x*x/4.L + 71.L*lnbarx*x*x/4.L - 10.L*lnbarx*lnbarx*x*x + 
    2.L*lnbarx*lnbarx*lnbarx*x*x + 41.L*x*y/4.L - 29.L*lnbarx*x*y/4.L + 
    2.L*lnbarx*lnbarx*x*y - 11.L*lnbary*x*y + 8.L*lnbarx*lnbary*x*y 
    - 2.L*lnbarx*lnbarx*lnbary*x*y - y*y/2.L + lnbary*y*y/2.L + 
    (y - 3.L*x)*TVIL_FBARxxxy(x, y, qq) + 2.L*y*TVIL_FBARyxxx(x, y, qq) + 
    lnbarx*(y-x)*TVIL_I2(0, x, y, qq) - 2.L*lnbary*y*TVIL_I2(x, x, x, qq) + 
    lnbarx * (3.L*x - y)*TVIL_I2(x, x, y, qq))/(x-y);

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0xxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_Ap(x,qq);

  return -13.L*x/4.L - 7.L*y/3.L - TVIL_Fy0xy (y, x, qq) + 
           (2.L - lnbarx) * TVIL_I2 (x, x, y, qq) +
           1.25L * x * lnbarx + TVIL_A(y,qq) + y;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0xyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_Ap(x,qq);
  TVIL_COMPLEX lnbary = TVIL_Ap(y,qq);

  return (-TVIL_FBARx0yy(x,y,qq) + (2.L - lnbarx) * TVIL_I2(x,y,y,qq) 
          + x * (0.25L * lnbarx - 11.L/12.L) 
          + y * (-14.L/3.L - 5.L * lnbarx + (2.L  
            + 4.L * lnbarx - lnbarx * lnbary) * lnbary));
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gyxxxx (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_Ap(x,qq);
  TVIL_COMPLEX lnbary = TVIL_Ap(y,qq);
  TVIL_COMPLEX lnbarx2 = lnbarx * lnbarx;

  return ((26.L*x - 8.L*y)/3.L + 17.L*y*y/(12.L*x) + 
    (4.L - y/x)*TVIL_FBARx0yy(y,x,qq) +
    TVIL_I2(x, x, y, qq)*(8.L - y/x - 2.L*lnbarx) 
    - (16.L*x + 2*y)*lnbarx + 6.L*x*lnbarx2 - y*lnbary 
    - 0.75L*y*y*lnbary/x + 4.L*y*lnbarx*lnbary - y*lnbarx2*lnbary +
    (8.L*x - 2.L*y)*Zeta3);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gxxyxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_Ap(x,qq);
  TVIL_COMPLEX lnbary = TVIL_Ap(y,qq);
  TVIL_COMPLEX lnbarx2 = lnbarx * lnbarx;
  TVIL_COMPLEX lnbary2 = lnbary * lnbary;
  TVIL_COMPLEX result;

  result = (y/x - 1.L) *  TVIL_FBARxxyy (x,y,qq) 
    + y * (y - 4.L*x) * TVIL_FBARx0yy (y,x,qq)/(2.L * x * x) 
    + (1.L - y/x) *  TVIL_I2(x, y, y, qq) * lnbarx - x * lnbarx2 * lnbarx 
    + (2.L * x - y) * lnbarx2 * (6.L*x - y * lnbary)/(2.L*x) 
    - (lnbarx * (47.L * x * x - 47.L * x * y + 16.L * y * y 
      - 8.L * y * (2.L * x + y) * lnbary + 4.L * y * y * lnbary2))/(4.L*x) 
    + (162.L*x*x*x - 434.L*x*x*y + 116.L*x*y*y - 17.L*y*y*y +
      9.L*y*(-8.L*x*x - 8.L*x*y + y*y)*lnbary + 
      24.L*x*y*y*lnbary2)/(24.L*x*x) 
    + TVIL_I2(x, x, y, qq) * ((-2.L + y/x)*lnbarx + (8.L*x*x - 4*x*y + 
      y*y - 2*x*y*lnbary)/(2.L*x*x)) + 2.L*y*(4.L - y/x)*Zeta3;

  return result;
}

/* ****************************************************************** */
TVIL_COMPLEX TVIL_Gx00xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  TVIL_REAL Gx00xytableA[] = 
     {0, 0, -0.42391086660614674, -0.11127997554950356, 
     -0.024135990460208746, -0.006179852025555073, -0.0018852354594541955, 
     -0.0006831582249035862, -0.00028942688451065067, 
     -0.00013956909499487203, -0.00007443846530068568, 
     -0.000042869191803686065, -0.000026192600294754784, 
     -0.000016769610835324743, -0.000011152835844418036, 
     -7.656128840949065e-6, -5.399085279105823e-6, -3.89678257643342e-6, 
     -2.8699987620183548e-6, -2.1517931901416006e-6, 
     -1.639068737823178e-6, -1.2663280153262696e-6, -9.909070329018485e-7, 
     -7.843886650607117e-7, -6.274624076051258e-7, -5.067664547070383e-7, 
     -4.129019029065727e-7, -3.3915742127635767e-7, -2.806743348018197e-7, 
     -2.3389035491556021e-7, -1.9616293791864537e-7, 
     -1.6551044779401232e-7, -1.4043181381102468e-7, 
     -1.1977926451059578e-7, -1.0266744385301198e-7, 
     -8.840778519764158e-8, -7.646062957984981e-8, -6.639994911589195e-8, 
     -5.788711862640341e-8, -5.0651246222576827e-8, -4.447430251205685e-8, 
     -3.9179791250900086e-8, -3.462405523977762e-8, 
     -3.0689558491722316e-8, -2.727966147750733e-8, 
     -2.4314532339111566e-8, -2.1727928160492092e-8, 
     -1.946464687685294e-8, -1.747849925026189e-8, -1.5730686483026487e-8, 
     -1.4188495968792124e-8, -1.2824247876456773e-8, 
     -1.161444050275335e-8, -1.0539053900464956e-8, -9.580980124977293e-9, 
     -8.725555226196033e-9, -7.960173349700461e-9, -7.273967373950139e-9, 
     -6.657543677997012e-9, -6.102761115411155e-9, -5.6025462225509675e-9, 
     -5.150738232323738e-9, -4.74195868917736e-9, -4.371501436898984e-9, 
     -4.0352395314541885e-9, -3.729546257985133e-9, 
     -3.4512279363314724e-9, -3.197466608088614e-9, 
     -2.9657710298738773e-9, -2.7539346675320663e-9, 
     -2.5599996066237754e-9, -2.38222547531801e-9, -2.219062624394845e-9, 
     -2.0691289315449607e-9, -1.931189698403583e-9, 
     -1.8041401926876262e-9, -1.686990457565746e-9, 
     -1.5788520685249685e-9, -1.4789265665651255e-9, 
     -1.3864953372275866e-9, -1.3009107391119031e-9, 
     -1.2215883142675028e-9, -1.147999937080662e-9, 
     -1.0796677787597145e-9, -1.0161589818715223e-9, 
     -9.57080954109633e-10, -9.020772030012934e-10, 
     -8.508236439367154e-10, -8.030253230207482e-10, 
     -7.58413504047035e-10, -7.167430755803727e-10, 
     -6.777902398739345e-10, -6.413504502864571e-10, 
     -6.072365681199791e-10, -5.752772134718601e-10, 
     -5.453152878705661e-10, -5.172066492148389e-10, 
     -4.908189219211964e-10, -4.660304272568141e-10, 
     -4.4272922063757073e-10, -4.208122242417429e-10};
 
  TVIL_REAL Gx00xytableALx[] = 
     {0, 0, 0.1111111111111111, -0.04055555555555555, 
     -0.014240362811791384, -0.0049637818090199045, -0.0019680311671653665, 
     -0.0008980334363284747, -0.0004631458993763356, -0.00026314341415798495, 
     -0.00016098903161433585, -0.00010424312848813507, 
     -0.00007057155208741928, -0.0000495195389003308, 
     -0.00003578962570974795, -0.0000265172749928703, 
     -0.00002006867304609257, -0.000015469781623451876, 
     -0.000012117814207414963, -9.627611277104734e-6, 
     -7.746138704409993e-6, -6.3030587908566185e-6, -5.181196789661933e-6, 
     -4.298375884489631e-6, -3.595953371105364e-6, -3.0314174307322323e-6, 
     -2.5735059615800472e-6, -2.198927163458428e-6, 
     -1.8901181611959221e-6, -1.6336888595888343e-6, 
     -1.4193258393614365e-6, -1.2390099459042004e-6, 
     -1.086450870238933e-6, -9.56673839746502e-7, -8.457142618810274e-7, 
     -7.503898695409262e-7, -6.681291079495113e-7, -5.968407479392464e-7, 
     -5.348140060705333e-7, -4.806414407373761e-7, -4.331589954369755e-7, 
     -3.9139905386254226e-7, -3.545534428042866e-7, -3.219440943270408e-7, 
     -2.929996448571722e-7, -2.672366655243137e-7, -2.4424452718777453e-7, 
     -2.2367313451634202e-7, -2.0522293724760633e-7, 
     -1.8863675835830533e-7, -1.7369307918967118e-7, 
     -1.602004984961399e-7, -1.4799314171726605e-7, -1.369268427888781e-7, 
     -1.268759566884349e-7, -1.1773068902704233e-7, 
     -1.0939485114343175e-7, -1.0178396667487316e-7, 
     -9.482366950436339e-8, -8.844834409838618e-8, -8.259996815902672e-8, 
     -7.722712468463245e-8, -7.228415632641669e-8, -6.773043962645792e-8, 
     -6.352976054626509e-8, -5.964977581805018e-8, -5.6061547210109825e-8, 
     -5.273913790186778e-8, -4.965926189956972e-8, -4.6800978859336765e-8, 
     -4.4145427875561404e-8, -4.1675594783921527e-8, 
     -3.9376108355467305e-8, -3.723306145033314e-8, -3.523385378022152e-8, 
     -3.336705341710071e-8, -3.162227459724262e-8, -2.99900697176534e-8, 
     -2.8461833716680307e-8, -2.702971928081242e-8, -2.568656153261892e-8, 
     -2.442581103633771e-8, -2.3241474112782058e-8, 
     -2.2128059588086284e-8, -2.1080531214795298e-8, 
     -2.009426510178616e-8, -1.916501157389842e-8, -1.82888609549633e-8, 
     -1.7462212830860838e-8, -1.6681748403733373e-8, 
     -1.5944405595755333e-8, -1.5247356601930896e-8, 
     -1.4587987627133414e-8, -1.3963880573755371e-8, 
     -1.3372796473535593e-8, -1.2812660480910617e-8, 
     -1.2281548266059747e-8, -1.1777673664072968e-8, 
     -1.1299377452705673e-8, -1.084511714528497e-8, -1.0413457697749275e-8};
 
  TVIL_REAL Gx00xytableALy[] = 
     {0, 0, 0.3333333333333333, 0.075, 0.01865079365079365, 
     0.005654761904761905, 0.0020887445887445887, 0.0009206071706071706, 
     0.0004675681461395747, 0.0002640394735982971, 0.0001611753017841769, 
     0.00010428263441310766, 0.0000705800672487472, 0.000049521398788508376, 
     0.0000357900364818728, 0.000026517366573911166, 0.000020068693629848862, 
     0.00001546978628248199, 0.000012117815268477894, 9.627611520073316e-6, 
     7.746138760316498e-6, 6.303058803776496e-6, 5.1811967926593786e-6, 
     4.298375885187511e-6, 3.5959533712683713e-6, 3.031417430770419e-6, 
     2.5735059615890177e-6, 2.1989271634605405e-6, 1.8901181611964206e-6, 
     1.633688859588952e-6, 1.4193258393614645e-6, 1.2390099459042071e-6, 
     1.0864508702389344e-6, 9.566738397465024e-7, 8.457142618810276e-7, 
     7.503898695409263e-7, 6.681291079495113e-7, 5.968407479392464e-7, 
     5.348140060705333e-7, 4.806414407373761e-7, 4.3315899543697546e-7, 
     3.9139905386254226e-7, 3.545534428042866e-7, 3.219440943270408e-7, 
     2.929996448571722e-7, 2.672366655243137e-7, 2.442445271877745e-7, 
     2.2367313451634197e-7, 2.052229372476063e-7, 1.8863675835830533e-7, 
     1.7369307918967118e-7, 1.6020049849613989e-7, 1.4799314171726605e-7, 
     1.369268427888781e-7, 1.268759566884349e-7, 1.1773068902704233e-7, 
     1.0939485114343176e-7, 1.0178396667487316e-7, 9.48236695043634e-8, 
     8.844834409838618e-8, 8.259996815902672e-8, 7.722712468463247e-8, 
     7.228415632641669e-8, 6.773043962645792e-8, 6.352976054626508e-8, 
     5.964977581805018e-8, 5.606154721010982e-8, 5.273913790186779e-8, 
     4.965926189956972e-8, 4.680097885933678e-8, 4.414542787556141e-8, 
     4.1675594783921527e-8, 3.93761083554673e-8, 3.723306145033315e-8, 
     3.523385378022152e-8, 3.336705341710071e-8, 3.162227459724261e-8, 
     2.99900697176534e-8, 2.8461833716680307e-8, 2.702971928081242e-8, 
     2.568656153261892e-8, 2.4425811036337706e-8, 2.324147411278205e-8, 
     2.2128059588086287e-8, 2.1080531214795298e-8, 2.009426510178616e-8, 
     1.916501157389842e-8, 1.82888609549633e-8, 1.7462212830860838e-8, 
     1.6681748403733373e-8, 1.5944405595755333e-8, 1.5247356601930896e-8, 
     1.4587987627133412e-8, 1.3963880573755371e-8, 1.337279647353559e-8, 
     1.2812660480910617e-8, 1.2281548266059747e-8, 1.1777673664072968e-8, 
     1.1299377452705674e-8, 1.0845117145284969e-8, 1.0413457697749277e-8};
 
  TVIL_REAL Gx00xytableALx2[] = 
     {0, 0, 0.16666666666666666, 0.016666666666666666, 
     0.002380952380952381, 0.0003968253968253968, 0.00007215007215007215, 
     0.000013875013875013875, 2.775002775002775e-6, 5.713241007358655e-7, 
     1.202787580496559e-7, 2.577401958206912e-8, 5.603047735232417e-9, 
     1.2326705017511316e-9, 2.7392677816691816e-10, 6.139738131327476e-11, 
     1.3863924812674945e-11, 3.1508920028806695e-12, 
     7.202038863727245e-13, 1.6545224416670698e-13, 
     3.8181287115393914e-14, 8.846883599908346e-15, 
     2.0574147906763594e-15, 4.800634511578173e-16, 1.123552758028934e-16, 
     2.636909534149539e-17, 6.204493021528327e-18, 1.4633238258321526e-18, 
     3.4587654065123604e-19, 8.191812804897696e-20, 1.943819987602843e-20, 
     4.6205557082362665e-21, 1.1001323114848254e-21, 
     2.623392435079199e-22, 6.264817755413012e-23, 1.4981085936857203e-23, 
     3.587020576430598e-24, 8.59902192979938e-25, 2.0637652631518508e-25, 
     4.9583970608193825e-26, 1.19252587538694e-26, 2.8708956259315225e-27, 
     6.917820785377162e-28, 1.6684156011791979e-28, 4.027210071811857e-29, 
     9.728653544264599e-30, 2.3519821755364965e-30, 5.690279456943136e-31, 
     1.3776466053651805e-31, 3.3375974459878077e-32, 
     8.091145323606808e-33, 1.962703568597691e-33, 4.763843613101192e-34, 
     1.1569334488960036e-34, 2.811240156195897e-35, 6.83466643478819e-36, 
     1.6624864300836136e-36, 4.045874055513219e-37, 9.850823787336533e-38, 
     2.399559640505053e-38, 5.847666350810633e-39, 1.4256707218918484e-39, 
     3.47724566315085e-40, 8.484479418088074e-41, 2.0710146611081128e-41, 
     5.057128823636089e-42, 1.2353291782927851e-42, 
     3.0186615259034222e-43, 7.37895039665281e-44, 1.8043418853129132e-44, 
     4.4134981367366226e-45, 1.0798984802653439e-45, 
     2.643108168481611e-46, 6.471057929730841e-47, 1.58474888075041e-47, 
     3.882102962912078e-48, 9.512437723691846e-49, 2.3314798342381977e-49, 
     5.71588604522913e-50, 1.4016663231931305e-50, 3.4380494719831504e-51, 
     8.434966095859281e-52, 2.0699303302722166e-52, 5.08073808339544e-53, 
     1.2473668348455872e-53, 3.063060570774667e-54, 7.523306665060585e-55, 
     1.8482111749426293e-55, 4.541318887001889e-56, 
     1.1160868451106337e-56, 2.7434536974786526e-57, 
     6.744955223082876e-58, 1.6585955466597236e-58, 4.07924850664959e-59, 
     1.0034515043095249e-59, 2.4688092566345452e-60, 
     6.0750803697289855e-61, 1.4951622671612789e-61, 
     3.6803994268585327e-62, 9.060881837697403e-63, 2.231071407272225e-63};
 
  TVIL_REAL Gx00xytableB[] = 
     {0, -1.1477714348244796, 3.3913041288711554, -1.000448919580449, 
     0.5325349536523081, -0.3367532355844961, 0.23324577803444746, 
     -0.17137622734754943, 0.13132956626562065, -0.1038857099308107, 
     0.08424557176091407, -0.06970138558120559, 0.05862816425056977, 
     -0.050001684577842154, 0.043149953688130654, -0.037617051766323906, 
     0.033084727513553625, -0.02932532053226064, 0.02617246600730211, 
     -0.023502293022702223, 0.02122102731993511, -0.019256619758922205, 
     0.017552972085492696, -0.016065877811147516, 0.014760119504507882, 
     -0.013607360595938381, 0.012584592449200405, -0.011672975582112596, 
     0.01085696468344427, -0.010123640663246183, 0.009462195572761359, 
     -0.008863531669441177, 0.008319946601299102, -0.00782488419662429, 
     0.007372735684148202, -0.0069586800070578075, 0.006578554683178389, 
     -0.00622875071045996, 0.005906126533162623, -0.005607937217356342, 
     0.005331775838336564, -0.0050755247311897525, 0.004837314752056135, 
     -0.004615491080099898, 0.004408584386885198, -0.004215286431441034, 
     0.004034429321212549, -0.0038649678227770726, 0.0037059642202639624, 
     -0.0035565753106036324, 0.0034160411977307154, -0.0032836756068453307, 
     0.003158857487576234, -0.003041023713648054, 0.0029296627183932125, 
     -0.0028243089315095338, 0.0027245379037525302, -0.0026299620240887236, 
     0.002540226748401552, -0.002455007270969166, 0.0023740055806565144, 
     -0.002296947851309565, 0.0022235821240026397, -0.0021536762445450684, 
     0.002087016023983989};
 
  TVIL_REAL Gx00xytableBL[] = 
     {0, 4.454822555520438, 0.36345162965304123, 0.2546193481387835, 
     -0.19311581798406674, 0.13615128606345184, -0.09901911713705586, 
     0.07470335017868768, -0.05817537855564853, 0.04650857505703268, 
     -0.03799552519422639, 0.03160559206162164, -0.02669260969785281, 
     0.022836815881429842, -0.019756724685270413, 0.017258207883800614, 
     -0.01520403415618242, 0.013495051847272205, -0.012058221072688072, 
     0.010838799676292504, -0.00979511932932324, 0.008895017988336619, 
     -0.008113356107140882, 0.007430256862137136, -0.006829839322959434, 
     0.0062992931118229095, -0.0058281934164567464, 0.005407987661066281, 
     -0.005031606434517132, 0.004693165489873384, -0.004387735266667837, 
     0.0041111610157234975, -0.003859921226785648, 0.003631015320401637, 
     -0.003421873894263981, 0.003230286495437114, -0.0030543431160780926, 
     0.002892386513228269, -0.0027429731242443675, 0.002604840852323674, 
     -0.0024768823765260774, 0.002358122929956883, -0.002247701711591034, 
     0.0021448562684866015, -0.002048909318236442, 0.0019592575855893607, 
     -0.0018753623090438723, 0.0017967411379811223, -0.001722961192409547, 
     0.0016536330985665072, -0.001588405846696249, 0.0015269623440172311, 
     -0.0014690155575325815, 0.0014143051589580995, -0.0013625945984484158, 
     0.0013136685456274777, -0.0012673306461735753, 0.0012234015502677435, 
     -0.001181717175902713, 0.0011421271756194007, -0.0011044935798920283, 
     0.0010686895942836287, -0.0010345985307733847, 0.0010021128564228782, 
     -0.0009711333448868924};
 
  TVIL_REAL Gx00xytableBL2[] = 
     {0, -1.2274112777602189, 1., -0.3333333333333333, 
     0.16666666666666666, -0.1, 0.06666666666666667, -0.047619047619047616, 
     0.03571428571428571, -0.027777777777777776, 0.022222222222222223, 
     -0.01818181818181818, 0.015151515151515152, -0.01282051282051282, 
     0.01098901098901099, -0.009523809523809525, 0.008333333333333333, 
     -0.007352941176470588, 0.006535947712418301, -0.005847953216374269, 
     0.005263157894736842, -0.004761904761904762, 0.004329004329004329, 
     -0.003952569169960474, 0.0036231884057971015, -0.0033333333333333335, 
     0.003076923076923077, -0.002849002849002849, 0.0026455026455026454, 
     -0.0024630541871921183, 0.0022988505747126436, -0.002150537634408602, 
     0.0020161290322580645, -0.001893939393939394, 0.0017825311942959, 
     -0.0016806722689075631, 0.0015873015873015873, -0.0015015015015015015, 
     0.001422475106685633, -0.001349527665317139, 0.001282051282051282, 
     -0.0012195121951219512, 0.0011614401858304297, -0.0011074197120708748, 
     0.0010570824524312897, -0.00101010101010101, 0.000966183574879227, 
     -0.0009250693802035153, 0.0008865248226950354, -0.0008503401360544217, 
     0.0008163265306122449, -0.000784313725490196, 0.0007541478129713424, 
     -0.000725689404934688, 0.0006988120195667365, -0.0006734006734006734, 
     0.0006493506493506494, -0.0006265664160401002, 0.0006049606775559589, 
     -0.0005844535359438924, 0.0005649717514124294, -0.000546448087431694, 
     0.0005288207297726071, -0.0005120327700972862, 0.000496031746031746};
 
  TVIL_REAL Gx00xytableC[] = 
     {0, 0, 0.09034728299512149, 0.07061786974208396, 
     0.053858094906417235, 0.04272479033248704, 0.03487787047671334, 
     0.029121777556425393, 0.024765215838894895, 0.021381404144873023, 
     0.01869514621573528, 0.016522634267807382, 0.014737328259627593, 
     0.013249776816613311, 0.011995255880823126, 0.010925958158831729, 
     0.010005919256487281, 0.00920763834408038, 0.00850977619255552, 
     0.007895554859360249, 0.007351624436288302, 0.0068672469646261355, 
     0.006433699688014262, 0.006043832540137165, 0.005691735761480099, 
     0.0053724872682376764, 0.0050819585313540885, 0.004816663901079345, 
     0.004573642553080284, 0.004350365184197225, 0.004144659667850909, 
     0.003954651365284563, 0.0037787148618438006, 0.0036154346804887867, 
     0.0034635731018152188, 0.003322043649187715, 0.0031898891198230803, 
     0.0030662632865364713, 0.0029504155808918794, 0.002841678211459569, 
     0.0027394552815244253, 0.002643213556790902, 0.00255247460121843, 
     0.002466808052435783, 0.0023858258504803453, 0.0023091772673495747, 
     0.0022365446119087693, 0.0021676395065044138, 0.002102199649289237, 
     0.0020399859906282194, 0.0019807802636899042, 0.001924382818955405, 
     0.0018706107203089275, 0.0018192960669323533, 0.0017702845106705508, 
     0.0017234339430689416, 0.0016786133300754156, 0.0016357016755776197, 
     0.0015945870976212043, 0.00155516600341159, 0.0015173423511123374, 
     0.0014810269880748419, 0.001446137056514515, 0.0014125954588267914, 
     0.0013803303757444763, 0.0013492748314028668, 0.0013193663001228083, 
     0.0012905463503630034, 0.0012627603218467475, 0.0012359570323478594, 
     0.0012100885110367682, 0.0011851097556495106, 0.0011609785110577586, 
     0.0011376550670931978, 0.0011151020737203525, 0.0010932843718629284, 
     0.0010721688383739864, 0.0010517242438030983, 0.001031921121757194, 
     0.001012731648778375, 0.0009941295337739372, 0.0009760899161328759, 
     0.0009585892717510257, 0.0009416053262649565, 0.0009251169748641307, 
     0.0009091042081125766, 0.0008935480432664324, 0.0008784304606228922, 
     0.0008637343444800718, 0.0008494434283267045, 0.0008355422439158512, 
     0.000822016073908536, 0.0008088509078016735, 0.0007960334008802717, 
     0.0007835508359569979, 0.0007713910876829917, 0.0007595425892326145, 
     0.0007479943011817953, 0.000736735682415018, 0.0007257566629098955, 
     0.0007150476182609144};
 
  TVIL_REAL Gx00xytableCLx[] = 
     {0, 0, 0.15625, 0.11848958333333333, 0.08734809027777778, 
     0.0667385525173611, 0.05284552680121528, 0.043085099477616566, 
     0.035958045042561296, 0.030581003224768605, 0.026412358451742585, 
     0.023106201958034037, 0.020433305088469033, 0.01823676360129405, 
     0.016406109117501552, 0.014861632131412368, 0.013544566472328335, 
     0.012410757339173477, 0.011426466222511164, 0.010565524565726458, 
     0.00980736086086137, 0.00913560662825322, 0.008537094179069395, 
     0.008001124616002178, 0.007518925484347111, 0.007083243635254634, 
     0.0066880358936897534, 0.006328231419793772, 0.005999547271872488, 
     0.005698343899177928, 0.005421510920443826, 0.005166376099244785, 
     0.004930632249311624, 0.004712278117372811, 0.004509570249632234, 
     0.004320983554110918, 0.004145178796211654, 0.00398097565890243, 
     0.0038273302970804465, 0.003683316543096121, 0.0035481100951781095, 
     0.0034209751557538453, 0.0033012530920432355, 0.003188352773938152, 
     0.0030817423093718334, 0.0029809419491099317, 0.00288551797416553, 
     0.002795077412141034, 0.0027092634554808674, 0.0026277514762285117, 
     0.0025502455494638304, 0.0024764754119650945, 0.002406193794431615, 
     0.002339174075318591, 0.002275208212372134, 0.00221410491462449, 
     0.0021556880231686265, 0.0020997950736792404, 0.002046276017546084, 
     0.0019949920817664848, 0.0019458147505135033, 0.0018986248536409548, 
     0.0018533117493773898, 0.0018097725901562035, 0.0017679116619761224, 
     0.0017276397889248905, 0.0016888737955617701, 0.0016515360207686055, 
     0.0016155538774673742, 0.001580859453283216, 0.0015473891478217953, 
     0.001515083342741778, 0.001483886101248475, 0.0014537448940227047, 
     0.0014246103489377654, 0.0013964360222138235, 0.001369178188918837, 
     0.0013427956509532645, 0.0013172495608564762, 0.0012925032599496037, 
     0.0012685221294856045, 0.0012452734536152852, 0.0012227262931001574, 
     0.0012008513688113315, 0.0011796209541498378, 0.0011590087756093302, 
     0.0011389899207783305, 0.001119540753147144, 0.0011006388331452775, 
     0.0010822628448894879, 0.001064392528171208, 0.00104700861525568, 
     0.0010300927721042692, 0.0010136275436666007, 0.0009975963029208172, 
     0.0009819832033687698, 0.0009667731347186799, 0.0009519516815110317, 
     0.0009375050844644511, 0.0009234202043373267, 0.0009096844881181263};
 
  TVIL_REAL Gx00xytableCLy[] = 
     {0, 0, -0.20561675835602827, -0.1466451847335697, 
     -0.1083633099029255, -0.08328514375496453, -0.06628357352802894, 
     -0.0542598952795518, -0.045429785630133945, -0.038736276199850164, 
     -0.03352675067532218, -0.029381663006811644, -0.02602138374190713, 
     -0.023253560118436593, -0.0209421879958053, -0.0189887700046686, 
     -0.017320455203975058, -0.015882351830169804, -0.014632413041498274, 
     -0.01353795408337552, -0.012573230255774174, -0.011717720506247222, 
     -0.010954890144769188, -0.010271285013921043, -0.009655858891484893, 
     -0.009099467580325328, -0.008594483836942056, -0.008134501057329048, 
     -0.0077141029496837175, -0.007328682817671955, -0.006974300531765619, 
     -0.006647568409545985, -0.006345559471723527, -0.006065733163673311, 
     -0.00580587481784146, -0.005564046007081205, -0.0053385435904265335, 
     -0.00512786574229642, -0.004930683626986224, -0.0047458176635085695, 
     -0.004572217543724905, -0.004408945335512714, -0.004255161134370177, 
     -0.00411011083019637, -0.003973115637581957, -0.0038435631027461054, 
     -0.003720899351998817, -0.00360462238814036, -0.003494276274712258, 
     -0.003389446075168192, -0.003289753436141658, -0.0031948527220662243, 
     -0.0031044276232499446, -0.003018188171745053, -0.002935868109483871, 
     -0.0028572225615664778, -0.0027820259746005683, -0.0027100702858617867, 
     -0.002641163293967466, -0.002575127205902891, -0.002511797338740653, 
     -0.0024510209573593887, -0.002392656231987389, -0.002336571301542228, 
     -0.002282643430570163, -0.0022307582491580746, -0.002180809066537643, 
     -0.0021326962502603254, -0.0020863266638212787, -0.002041613156474375, 
     -0.0019984740997289964, -0.0019568329656691804, -0.0019166179428010415, 
     -0.0018777615856272857, -0.001840200494578083, -0.0018038750233043284, 
     -0.0017687290106695628, -0.001734709535066944, -0.0017017666889428615, 
     -0.0016698533716337522, -0.0016389250988212362, -0.0016089398270862942, 
     -0.001579857792198702, -0.0015516413599158774, -0.0015242548881878037, 
     -0.001497664599773707, -0.0014718384643732487, -0.0014467460894616382, 
     -0.001422358619095432, -0.0013986486400250245, -0.0013755900945118236, 
     -0.0013531581993036987, -0.001331329370272219, -0.0013100811522600698, 
     -0.0012893921537274352, -0.0012692419858225234, -0.0012496112055342548, 
     -0.0012304812626147763, -0.0012118344499862797, -0.0011936538573708599, 
     -0.0011759233279041337};
 
  TVIL_REAL Gx00xytableCLx2[] = 
     {0, 0, 0.109375, 0.049479166666666664, 0.029459635416666668, 
     0.020035807291666666, 0.014742024739583333, 0.01142607189360119, 
     0.009189269656226748, 0.007597113412524026, 0.006416633772471594, 
     0.005512897982053771, 0.004802929075679393, 0.004233195016735176, 
     0.00376777761567329, 0.0033817747935635366, 0.003057436239636326, 
     0.002781804520391232, 0.002545223386131661, 0.0023403652102309356, 
     0.002161579745461028, 0.0020044476607377175, 0.0018654680038290288, 
     0.0017418352895941798, 0.0016312778165194625, 0.0015319385964298246, 
     0.0014422864454962238, 0.0013610487530840085, 0.001287160051151473, 
     0.0012197222495772264, 0.001157973587492295, 0.0011012641684167675, 
     0.0010490365194108686, 0.0010008100203883449, 0.0009561683411222935, 
     0.0009147492349965993, 0.0008762361937305519, 0.000840351582267146, 
     0.000806850958977493, 0.0007755183511709145, 0.000746162305205357, 
     0.0007186125682767623, 0.0006927172881328407, 0.0006683406396273971, 
     0.000645360804768356, 0.0006236682468759986, 0.0006031642305255266, 
     0.0005837595477539137, 0.0005653734180612016, 0.0005479325354098912, 
     0.0005313702400139689, 0.000515625796436456, 0.0005006437625561166, 
     0.0004863734364568212, 0.000472768370344486, 0.0004597859422912907, 
     0.00044738697801232057, 0.0004355354160495144, 0.00042419801071475827, 
     0.00041334406796265965, 0.0004029452100518301, 0.0003929751654339772, 
     0.0003834095808011127, 0.00037422585263773494, 0.0003654029759792078, 
     0.0003569214083798483, 0.0003487629473527727, 0.00034091061976523326, 
     0.0003333485818637279, 0.00032606202876733623, 0.0003190371124095175, 
     0.00031226086703131645, 0.00030572114143536305, 0.00029940653730256697, 
     0.0002933063529539966, 0.00028741053201075217, 0.0002817096164661394, 
     0.00027619470373832115, 0.0002708574073188989, 0.00026568982067444935, 
     0.00026068448409464394, 0.0002558343542128789, 0.00025113277595387775, 
     0.00024657345668798727, 0.00024215044239427394, 0.00023785809565440345, 
     0.00023369107531695535, 0.00022964431768755878, 0.00022571301911426017, 
     0.00022189261985005842, 0.00021817878908573956, 0.00021456741105616494, 
     0.0002110545721321502, 0.0002076365488181362, 0.0002043097965830952, 
     0.00020107093945863472, 0.00019791676034412901, 0.0001948441919640031, 
     0.00019185030842706967, 0.00018893231734213857, 0.0001860875524480226};
 
  TVIL_REAL Gx00xytableCLxLy[] = 
     {0, 0, -0.28125, -0.15104166666666666, -0.09733072916666667, 
     -0.06930338541666667, -0.05254720052083333, -0.04160098121279762, 
     -0.0339896247500465, -0.028445909893701948, -0.02426084866599431, 
     -0.021010031672611208, -0.018425491030770118, -0.016330572704566757, 
     -0.014604590070472268, -0.01316258118450989, -0.011943183532523344, 
     -0.010901089087619768, -0.010002193178772057, -0.009220385323912821, 
     -0.008535372572624534, -0.007931170166103542, -0.007395034105767806, 
     -0.006916692787709731, -0.006487785023428036, -0.006101443024219293, 
     -0.0057519788520242485, -0.005434645806681085, -0.005145454818786382, 
     -0.00488103171911991, -0.004638505232376055, -0.004415418308880627, 
     -0.004209657357874574, -0.0040193953378879705, -0.003843045665008397, 
     -0.003679224633806086, -0.003526720587013211, -0.00338446847313701, 
     -0.0032515287340187647, -0.0031270696937867773, -0.00301035279586307, 
     -0.00290072016949073, -0.002797584111705564, -0.002700418152159315, 
     -0.0026087494321700984, -0.002522152179897919, -0.002440242103675496, 
     -0.002362671557578513, -0.002289125359054989, -0.002219317159199118, 
     -0.0021529862830903957, -0.002089894971330177, -0.0020298259651234584, 
     -0.0019725803864663223, -0.0019179758725971047, -0.0018658449301593295, 
     -0.0018160334797509689, -0.0017683995658930127, -0.0017228122110972133, 
     -0.00167915039577446, -0.0016373021483036244, -0.0015971637317588232, 
     -0.0015586389156384208, -0.0015216383225070654, -0.0014860788407979667, 
     -0.0014518830961638457, -0.0014189789747424623, -0.0013872991925418393, 
     -0.0013567809058726665, -0.0013273653583784908, -0.0012989975607531324, 
     -0.0012716259997016715, -0.0012452023731068219, -0.0012196813487153411, 
     -0.0011950203439667964, -0.00117117932485579, -0.0011481206219540162, 
     -0.0011258087619248544, -0.0011042103130444393, -0.0010832937434026634, 
     -0.001063029290598182, -0.001043388841865648, -0.001024345823683198, 
     -0.0010058751000055037, -0.0009879528783539753, -0.0009705566230723778, 
     -0.0009536649751243465, -0.0009372576778700661, -0.0009213155083136205, 
     -0.0009058202133609766, -0.0008907544506719291, -0.0008761017337281651, 
     -0.0008618463807744474, -0.0008479734673212055, -0.0008344687819249446, 
     -0.0008213187849882161, -0.0008085105703437043, -0.0007960318294075857, 
     -0.0007838708177059077, -0.0007720163235945571, -0.0007604576390086064};
 
  TVIL_REAL Gx00xytableCLy2[] = 
    {0, 0, 0.171875, 0.1015625, 0.06787109375, 0.049267578125, 
     0.03780517578125, 0.03017490931919643, 0.024800355093819754, 
     0.02084879648117792, 0.017844214893522718, 0.015497133690557439, 
     0.013622561955090725, 0.012097377687831581, 0.010836812454798977, 
     0.009780806390946353, 0.00888574729288702, 0.008119284567228536, 
     0.007456969792640397, 0.006880020113681886, 0.0063737928271635075, 
     0.005926722505365824, 0.005529566101938778, 0.005174857498115552, 
     0.004856507206908572, 0.004569504427789469, 0.004309692406528025, 
     0.004073597053597076, 0.0038582947676349096, 0.003661309469542684, 
     0.0034805316448837604, 0.00331415414046386, 0.0031606208384637054, 
     0.003018585317499626, 0.002886877323886104, 0.002764475398809487, 
     0.0026504843932826593, 0.002544116890869864, 0.0024446777750412717, 
     0.0023515513426158627, 0.0022641904906577125, 0.002182107601213968, 
     0.002104866823572724, 0.002032077512531918, 0.0019633886274017416, 
     0.0018984839330219209, 0.0018370778731499698, 0.0017789120098245991, 
     0.0017237519409937874, 0.0016713846237892268, 0.0016216160430764272, 
     0.0015742691748937207, 0.001529182202567342, 0.0014862069500095013, 
     0.0014452075022526188, 0.0014060589878680389, 0.001368646501738648, 
     0.001332864149843498, 0.001298614200382455, 0.0012658063278118002, 
     0.0012343569382517944, 0.001204188566324846, 0.0011752293348373077, 
     0.0011474124698693305, 0.0011206758648187587, 0.0010949616877839975, 
     0.0010702160273896894, 0.001046388572776606, 0.001023432324008939, 
     0.0010013033296111546, 0.0009799604483436146, 0.0009593651326703548, 
     0.0009394812316714589, 0.0009202748114127741, 0.0009017139910127998, 
     0.0008837687928450376, 0.0008664110054878764, 0.0008496140581865334, 
     0.0008333529057255407, 0.0008176039227282139, 0.0008023448065035382, 
     0.0007875544876527691, 0.0007732130477293202, 0.0007593016433175164, 
     0.0007458024359597013, 0.0007326985274179743, 0.000719973899807391, 
     0.0007076133601825072, 0.0006956024891993602, 0.0006839275935109181, 
     0.0006725756615861897, 0.0006615343226720003, 0.0006507918086422974, 
     0.0006403369185030693, 0.0006301589853418494, 0.0006202478455295814, 
     0.0006105938099995753, 0.0006011876374435825, 0.0005920205092788381, 
     0.0005830840062524185, 0.0005743700865605838};
 
  TVIL_REAL Gx00xytableCLx3[] = 
     {0, 0, -0.03125, -0.015625, -0.009765625, -0.0068359375, 
     -0.005126953125, -0.0040283203125, -0.00327301025390625, 
     -0.002727508544921875, -0.0023183822631835938, -0.002002239227294922, 
     -0.0017519593238830566, -0.0015498101711273193, -0.001383759081363678, 
     -0.0012453831732273102, -0.0011286285007372499, -0.0010290436330251396, 
     -0.0009432899969397113, -0.0008688197340234183, -0.0008036582539716619, 
     -0.0007462540929736861, -0.0006953731320891166, -0.0006500227104311307, 
     -0.000609396291029185, -0.0005728325135674339, -0.0005397844839385435, 
     -0.0005097964570530689, -0.00048248593256808303, -0.0004575297636421477, 
     -0.0004346532754600403, -0.00041362166535713514, -0.0003942331497935194, 
     -0.0003763134611665413, -0.0003597113967033115, -0.0003442951939874553, 
     -0.0003299495609046447, -0.0003165732273544564, -0.00030407691574835943, 
     -0.0002923816497580379, -0.0002814173378921115, -0.00027112158162776595, 
     -0.0002614386679982029, -0.0002523187144633818, -0.00024371694010667563, 
     -0.00023559304210311977, -0.00022791066029540934, 
     -0.00022063691581789628, -0.00021374201219858703, 
     -0.0002071988893761813, -0.00020098292269489585, 
     -0.00019507166026269305, -0.00018944459313973076, 
     -0.0001840829537112478, -0.0001789695383303798, -0.00017408855092136946, 
     -0.00016942546473597563, -0.00016496689987450258, 
     -0.0001607005145329206, -0.0001566149082312362, -0.0001526995355254553, 
     -0.0001489446289141736, -0.00014534112982754038, 
     -0.00014188062673640845, -0.00013855529954727387, 
     -0.0001353578695577214, -0.00013228155434050047, -0.0001293200270045191, 
     -0.00012646737935000766, -0.0001237180884945727, 
     -0.00012106698659826044, -0.00011850923336026903, 
     -0.00011604029099859675, -0.0001136559014575297, 
     -0.00011135206561717436, -0.00010912502430483088, 
     -0.00010697124093039342, -0.00010488738558759355, 
     -0.00010287032048013983, -0.00010091708654697261, 
     -0.00009902489117421688, -0.00009719109689321287, 
     -0.00009541321097443458, -0.00009368887583634239, 
     -0.00009201586019640771, -0.00009039205089882404, 
     -0.00008881544535989107, -0.00008728414457782397, 
     -0.0000857963466588838, -0.00008435034081631834, 
     -0.00008294450180271303, -0.00008157728474003095, 
     -0.00008024722031492175, -0.00007895291030984237, 
     -0.00007769302344319594, -0.00007646629149409284, 
     -0.00007527150568949765, -0.00007410751333347448, 
     -0.00007297321466000294, -0.00007186755989242713, 
     -0.00007078954649404074};
 
  TVIL_REAL Gx00xytableD[] = 
    {0, 0, 0.845574663765145, -0.3015841064301469, 0.15938940428676457, 
     -0.09850996915313068, 0.06685247584607733, -0.048315822459717245, 
     0.036538604972939, -0.02859435582833405, 0.022984246492259504, 
     -0.018876226120929915, 0.01577839054140881, -0.0133848310732964, 
     0.011497220915933491, -0.009982419420124358, 0.008748358572943048, 
     -0.007729727839960655, 0.0068791582809036205, -0.006161617910367615, 
     0.005550747984798741, -0.005026408447833482, 0.004572997101380317, 
     -0.004178275837983609, 0.0038325363730006994, -0.0035279977256618814, 
     0.0032583646962994245, -0.003018499990693064, 0.002804177750701089, 
     -0.0026118961863154087, 0.0024387336510425105, -0.0022822370192892532, 
     0.0021403343386439855, -0.002011265906191661, 0.001893529457922652, 
     -0.001785836262720539, 0.0016870757102777957, -0.0015962865656476912, 
     0.0015126334937659196, -0.001435387778028248, 0.001363911397958241, 
     -0.0012976438134516299, 0.001236090942290939, -0.0011788159245989785, 
     0.0011254313506658081, -0.0010755926930335587, 0.0010289927342189884, 
     -0.0009853568212477228, 0.0009444388097095671, -0.0009060175851680197, 
     0.0008698940698745012, -0.0008358886389246951, 0.0008038388830792976, 
     -0.0007735976660959652, 0.0007450314330828107, -0.0007180187334773348, 
     0.0006924489280855625, -0.0006682210544272996, 0.0006452428286176059, 
     -0.0006234297653255244, 0.000602704400111855, -0.0005829956007572471, 
     0.0005642379561299326, -0.0005463712327737083, 0.0005293398907738719, 
     -0.0005130926516246267, 0.0004975821118111124, -0.00048276439666153787, 
     0.00046859884974365785, -0.0004550477536947029, 0.00044207607890110767, 
     -0.00042965125689755355, 0.000417742975745216, -0.0004063229949861361, 
     0.0003953649780622261, -0.00038484434034021897, 0.00037473811110348633, 
     -0.00036502480806280404, 0.0003556843231048486, -0.00034669781814285325, 
     0.0003380476300613348, -0.000329717183858575, 0.0003216909131887149, 
     -0.0003139541875916893, 0.00030649324577533446, -0.0002992951343811768, 
     0.0002923476517247846, -0.0002856392960541312, 0.00027915921791602216, 
     -0.0002728971762620131, 0.00026684349796203695, -0.0002609890404267096, 
     0.0002553251570684834, -0.0002498436653578842, 0.0002445368172543637, 
     -0.00023939727181214972, 0.0002344180697801585, -0.00022959261003179063, 
     0.0002249146276754859, -0.00022037817371044566, 0.00021597759610411307};
 
  TVIL_REAL Gx00xytableDL[] = 
     {0, 0, -0.2186975871035137, 0.12845475125672678, 
     -0.07174761194892897, 0.0450539635215082, -0.030781213381871893, 
     0.02232424768031541, -0.016917752027425906, 0.01325740228634727, 
     -0.010666352641678704, 0.008765923455703912, -0.0073311097273131755, 
     0.006221497298689193, -0.005345824471730073, 0.004642710405504938, 
     -0.004069648147935945, 0.0035964498632350627, -0.0032012004186621674, 
     0.002867680026044644, -0.002583676868542607, 0.0023398552080642404, 
     -0.0021289794823856766, 0.0019453719969755765, -0.001784527186160578, 
     0.0016428328487905924, -0.0015173657573760368, 0.0014057398030670883, 
     -0.0013059917947846889, 0.0012164946097603406, -0.0011358904584165463, 
     0.0010630391113052996, -0.0009969773741609015, 0.0009368871028294241, 
     -0.0008820697618443181, 0.0008319260403774927, -0.0007859394085249639, 
     0.0007436627669514287, -0.0007047075423440928, 0.0006687347297160743, 
     -0.0006354474942519688, 0.0006045850299568943, -0.0005759174369101424, 
     0.0005492414285320382, -0.0005243767186617271, 0.0005011629681429953, 
     -0.00047945719404525347, 0.0004591315631144789, -0.00044007150568623117, 
     0.0004221740979558993, -0.0004053466698416065, 0.0003895056031915755, 
     -0.0003745752911644787, 0.0003604872345459633, -0.00034717925478887774, 
     0.00033459480686010457, -0.00032268237768597784, 0.00031139495822376346, 
     -0.00030068957903809897, 0.0002905269007999901, -0.00028087085240907015, 
     0.00027168831051329, -0.0002629488151010855, 0.00025462431659940664, 
     -0.0002466889505512105, 0.00023911883648804089, -0.00023189189807346246, 
     0.00022498770198478663, -0.00021838731333476241, 0.00021207316572084104, 
     -0.00020602894423482463, 0.00020023947997647055, 
     -0.00019469065479619014, 0.00018936931514874428, 
     -0.00018426319407546977, 0.0001793608404501683, -0.00017465155472595008, 
     0.00017012533050925286, -0.0001657728013648112, 0.0001615851923231121, 
     -0.0001575542756211857, 0.00015367233025958448, -0.00014993210500408567, 
     0.0001463267845008375, -0.0001428499582090864, 0.00013949559188687835, 
     -0.00013625800139276028, 0.0001331318285909674, -0.00013011201916927212, 
     0.0001271938021979259, -0.00012437267127524685, 0.00012164436712064931, 
     -0.00011900486148950288, 0.00011645034229633883, 
     -0.00011397719984376683, 0.0001115820140641688, -0.00010926154268993257, 
     0.00010701271027578927, -0.00010483259800382426, 0.00010271843420803197, 
     -0.00010066758556095591};
 
  TVIL_REAL Gx00xytableDL2[] = 
     {0, 0, 0.25, -0.08333333333333333, 0.041666666666666664, -0.025, 
     0.016666666666666666, -0.011904761904761904, 0.008928571428571428, 
     -0.006944444444444444, 0.005555555555555556, -0.004545454545454545, 
     0.003787878787878788, -0.003205128205128205, 0.0027472527472527475, 
     -0.002380952380952381, 0.0020833333333333333, -0.001838235294117647, 
     0.0016339869281045752, -0.0014619883040935672, 0.0013157894736842105, 
     -0.0011904761904761906, 0.0010822510822510823, -0.0009881422924901185, 
     0.0009057971014492754, -0.0008333333333333334, 0.0007692307692307692, 
     -0.0007122507122507123, 0.0006613756613756613, -0.0006157635467980296, 
     0.0005747126436781609, -0.0005376344086021505, 0.0005040322580645161, 
     -0.0004734848484848485, 0.000445632798573975, -0.0004201680672268908, 
     0.0003968253968253968, -0.00037537537537537537, 0.00035561877667140827, 
     -0.00033738191632928474, 0.0003205128205128205, -0.0003048780487804878, 
     0.00029036004645760743, -0.0002768549280177187, 0.0002642706131078224, 
     -0.0002525252525252525, 0.00024154589371980676, -0.00023126734505087883, 
     0.00022163120567375886, -0.00021258503401360543, 0.00020408163265306123, 
     -0.000196078431372549, 0.0001885369532428356, -0.000181422351233672, 
     0.00017470300489168413, -0.00016835016835016836, 0.00016233766233766234, 
     -0.00015664160401002505, 0.00015124016938898973, -0.0001461133839859731, 
     0.00014124293785310735, -0.0001366120218579235, 0.00013220518244315177, 
     -0.00012800819252432156, 0.0001240079365079365, -0.0001201923076923077, 
     0.00011655011655011655, -0.00011307100859339665, 0.00010974539069359087, 
     -0.00010656436487638534, 0.00010351966873706004, 
     -0.00010060362173038229, 0.00009780907668231612, 
     -0.00009512937595129375, 0.00009255831173639393, 
     -0.00009009009009009009, 0.00008771929824561403, 
     -0.00008544087491455913, 0.00008325008325008325, 
     -0.00008114248620577734, 0.00007911392405063291, 
     -0.00007716049382716049, 0.00007527853056308341, 
     -0.00007346459006758743, 0.00007171543316121629, 
     -0.00007002801120448179, 0.00006839945280437756, 
     -0.00006682705159048383, 0.00006530825496342738, 
     -0.00006384065372829418, 0.00006242197253433208, 
     -0.00006105006105006105, 0.00005972288580984233, -0.0000584385226741468, 
     0.00005719514985129261, -0.000055991041433370664, 
     0.00005482456140350877, -0.000053694158075601374, 
     0.000052598358931201344, -0.000051535765821480104, 
     0.000050505050505050505};
 
  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  if (y < 0.5 * x) {
    result = TVIL_Gx000x (x,qq);
    result += y * (1.5L - 0.5L * PI2 + lnbarx * (1.L - Zeta2) 
              -0.5L * lnbarx2 - lnbarx2 * lnbarx/3.L + (0.5L + Zeta2) * lnbary 
              -lnbarx * lnbary + 0.5L * lnbarx2 * lnbary - Zeta3/3.L);
    rn = r = y/x;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gx00xytableA[n] +
        Gx00xytableALx[n] * lnbarx +
        Gx00xytableALy[n] * lnbary +
        Gx00xytableALx2[n] * lnbarx * (lnbarx - lnbary));
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_Gx00xx (x,qq);
    result += (y-x) * (-2.L - (2.L*PI2*PI)/(27.L*SQRT3) - lnbarx2 +
      lnbarx2 * lnbarx/6.L + 2.L*SQRT3*LS2 +
      lnbarx * (2.5L - SQRT3*LS2) - 4.L*Zeta3/3.L); 
    rn = r = y/x - 1.L;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gx00xytableD[n] + 
        Gx00xytableDL[n] * lnbarx + 
        Gx00xytableDL2[n] * lnbarx2);
    }
  }
  else if (y < 6. * x) {
    result = x*(-22.709596332660382L 
               + 16.50940173340954L * lnbarx  
               - 6.727411277760218L * lnbarx2 
               + 1.1666666666666667L * lnbarx3) +
             (y - 4.L * x) * (-0.28694285870612024L 
               + 1.1137056388801094L * lnbarx 
               - 0.3068528194400547L * lnbarx2 
               + 0.16666666666666667L * lnbarx3);
    rn = r = y/(4.L*x) - 1.L;
    for (n=2; n < 64; n++) {
      rn *= r;
      result += x * rn * (Gx00xytableB[n] +
        Gx00xytableBL[n] * lnbarx +  
        Gx00xytableBL2[n] * lnbarx2);
    }
  }
  else {
    result = TVIL_G0000x (y, qq);
    result += x * (-35.L/6.L + Zeta2 + (4.5L + Zeta2) * lnbarx 
              - 0.5L * lnbarx2 + (3.L - PI2/3.L) * lnbary 
              - 4 * lnbarx * lnbary + 0.5L * lnbarx2 * lnbary 
              + lnbary2 + 0.5L * lnbarx * lnbary2 
              - 0.5L * lnbary3 - 2.L * Zeta3);
    rn = r = 4.L * x/y;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += y * rn * (Gx00xytableC[n] +
        Gx00xytableCLx[n] * lnbarx +
        Gx00xytableCLy[n] * lnbary +
        Gx00xytableCLx2[n] * lnbarx2 +
        Gx00xytableCLy2[n] * lnbary2 +
        Gx00xytableCLxLy[n] * lnbarx * lnbary +
        Gx00xytableCLx3[n] * (lnbarx3 + lnbary3 - lnbarx2 * lnbary 
          - lnbarx * lnbary2));
    }
  }

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gy0xxx (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  TVIL_REAL Gy0xxxtableA[] = 
     {0, 0, 0.37491653687766124, -0.10238425354319386, 
     -0.03288701415043827, -0.01177392244794588, -0.005113618832905143, 
     -0.0026229595992455423, -0.0015224994068369, -0.0009650037381618294, 
     -0.0006516642488469152, -0.000461388328901806, -0.00033887899431915097, 
     -0.00025632152780461544, -0.00019861327987806665, 
     -0.00015704104118820613, -0.0001263255005026564, -0.000103136019233435, 
     -0.00008529864790786708, -0.00007135251049465911, 
     -0.000060290804850748515, -0.000051404126531780006, 
     -0.000044182724907774356, -0.000038253851292799655, 
     -0.00003334062418205625, -0.00002923443546250299, 
     -0.000025776078702505825, -0.0000228426145820179, 
     -0.000020338082461001146, -0.000018186835410886077, 
     -0.000016328693307944418, -0.000014715374331988559, 
     -0.000013307837559967157, -0.000012074283003576208, 
     -0.000010988631564476039, -0.00001002935910160529, 
     -9.178594416872626e-6, -8.421415792003756e-6, -7.74529821900255e-6, 
     -7.139675950964888e-6, -6.595593992521424e-6, -6.105428689093561e-6, 
     -5.662662373600838e-6, -5.261700581669123e-6, -4.8977229971127105e-6, 
     -4.5665612825686416e-6, -4.264598459718847e-6, -3.988685654772766e-6, 
     -3.7360729086329755e-6, -3.5043514338315985e-6, 
     -3.291405230811172e-6, -3.0953703907051897e-6, -2.91460073754021e-6, 
     -2.7476387200941714e-6, -2.593190667903134e-6, 
     -2.4501056888260184e-6, -2.317357616117158e-6, 
     -2.1940295180147826e-6, -2.0793003677618306e-6, 
     -1.972433540877833e-6, -1.8727668626332043e-6, 
     -1.7797039745792228e-6, -1.6927068266593564e-6, 
     -1.6112891324542078e-6, -1.535010650752003e-6, 
     -1.4634721778937788e-6, -1.3963111530218765e-6, 
     -1.3331977931090976e-6, -1.2738316869860043e-6, 
     -1.2179387879382527e-6, -1.1652687531580489e-6, 
     -1.1155925856839574e-6, -1.068700540680377e-6, 
     -1.0244002631799976e-6, -9.825151288940043e-7, -9.428827635133313e-7, 
     -9.05353719185416e-7, -8.697902896422744e-7, -8.360654478501905e-7, 
     -8.040618921096409e-7, -7.73671188307124e-7, -7.447929975509034e-7, 
     -7.173343797461178e-7, -6.912091648114e-7, -6.663373842345251e-7, 
     -6.426447565302008e-7, -6.200622209171601e-7, -5.98525514189725e-7, 
     -5.779747863341663e-7, -5.583542509437416e-7, -5.396118669278676e-7, 
     -5.21699048398701e-7, -5.045703999595337e-7, -4.881834749199071e-7, 
     -4.7249855422744716e-7, -4.574784441406185e-7, -4.430882908737762e-7, 
     -4.292954106294245e-7, -4.1606913359539086e-7, -4.033806606292127e-7, 
     -3.9120293148062063e-7};
 
  TVIL_REAL Gy0xxxtableALx[] = 
     {0, 0, 1.0277777777777777, 0.07333333333333333, 
     0.014529478458049886, 0.004937011841773747, 0.001953325254191055, 
     0.0006887990433611479, 0.0000899220644059139, -0.00020228900894083462, 
     -0.0003421176315841565, -0.00040323300527444144, -0.0004228700268925939, 
     -0.00042057953443265094, -0.000406918483548199, -0.00038770078205996756, 
     -0.0003661632049613447, -0.0003441075895037328, -0.00032252142810637027, 
     -0.00030192387418512354, -0.0002825629178627086, 
     -0.00026452977623831543, -0.0002478261762944148, 
     -0.00023240430126674006, -0.00021819060882096543, 
     -0.00020510000476283569, -0.00019304418987907873, 
     -0.00018193646228451194, -0.0001716943575072979, 
     -0.00016224097222504506, -0.00015350549347661739, 
     -0.00014542325692667662, -0.0001379355352297839, 
     -0.00013098918116969096, -0.0001245362023445473, 
     -0.00011853331399610918, -0.000112941497548651, -0.00010772558043842487, 
     -0.00010285384531150497, -0.00009829767202464842, 
     -0.00009403121306756966, -0.00009003110137423707, 
     -0.00008627618857987838, -0.00008274731133475369, 
     -0.00007942708312810287, -0.00007629970909161863, 
     -0.0000733508213678557, -0.00007056733279831763, -0.0000679373068790825, 
     -0.00006544984213056861, -0.00006309496922156943, 
     -0.00006086355936990785, -0.00005874724270989937, 
     -0.00005673833546909569, -0.00005482977493348345, 
     -0.0000530150613021022, -0.00005128820563995013, -0.0000496436832332682, 
     -0.00004807639173508586, -0.00004658161356249765, 
     -0.00004515498207167853, -0.000043792451093201004, 
     -0.000042490267459757265, -0.00004124494620177944, 
     -0.000040053248124460645, -0.00003891215951298766, 
     -0.00003781887374200006, -0.000036770774590912525, 
     -0.000035765421089233544, -0.00003480053373578305, 
     -0.0000338739819530999, -0.000032983772653639345, 
     -0.00003212803980785305, -0.00003130503491614769, 
     -0.000030513118297231495, -0.000029750751114652952, 
     -0.000029016488071564035, -0.000028308970711030312, 
     -0.000027626921265678405, -0.000026969137006214803, 
     -0.000026334485043457123, -0.000025721897543064478, 
     -0.000025130367316204066, -0.000024558943753004366, 
     -0.000024006729068872175, -0.000023472874836635322, 
     -0.000022956578780054738, -0.00002245708180656258, 
     -0.000021973665259157357, -0.00002150564836924961, 
     -0.000021052385893925183, -0.00002061326592259891, 
     -0.000020187707839387495, -0.000019775160428752314, 
     -0.000019375100113065783, -0.000018987029311750773, 
     -0.000018610474912542712, -0.000018244986846238814, 
     -0.000017890136757036335, -0.000017545516761230695, 
     -0.0000172107382876508};
 
  TVIL_REAL Gy0xxxtableALy[] = 
     {0, 0, 0.16666666666666666, 0.1, 0.038492063492063494, 
     0.018253968253968255, 0.01038961038961039, 0.006703389203389204, 
     0.0046976634476634475, 0.0034825060560354677, 0.0026879829140996764, 
     0.0021388097012820587, 0.0017428969075268326, 0.0014478660754516635, 
     0.0012220378413074027, 0.0010452972455230946, 0.0009043576699895455, 
     0.0007901499817060155, 0.0006963092885377608, 0.0006182605250214372, 
     0.0005526460204116899, 0.0004969560801061106, 0.0004492841699631982, 
     0.00040816083550481076, 0.00037243866595198334, 0.000341211115873985, 
     0.0003137542490506853, 0.0002894842906300632, 0.00026792626590851893, 
     0.0002486905342139311, 0.00023145502445825304, 0.00021595164171104477, 
     0.00020195576155652688, 0.00018927803562331812, 0.00017775794477673326, 
     0.00016725868649805113, 0.00015766308988929097, 0.00014887032879038042, 
     0.00014079325960788568, 0.00013335625172418273, 0.00012649340899130402, 
     0.00012014710375377304, 0.00011426676216406121, 0.0001088078527317704, 
     0.00010373104014753264, 0.00009900147421762618, 0.00009458818980119136, 
     0.00009046359837623783, 0.00008660305558387601, 0.00008298449204495612, 
     0.0000795880970849597, 0.0000763960468747137, 0.00007339226999799292, 
     0.00007056224467050031, 0.0000678928228184661, 0.00006537207702612129, 
     0.00006298916701623618, 0.00006073422286555695, 0.00005859824260001859, 
     0.00005657300218105923, 0.00005465097619852586, 0.000052825267838998135, 
     0.00005108954691005216, 0.00004943799487845132, 0.0000478652560294745, 
     0.00004636639398044328, 0.000044936852887951234, 0.000043572422778575, 
     0.00004226920850961755, 0.000041023601931889095, 0.00003983225688247934, 
     0.00003869206668341155, 0.000037600143863240845, 0.00003655380185409959, 
     0.000035550538447268486, 0.000034588020816787525, 
     0.00003366407194352464, 0.000032776658292003495, 0.00003192387860958879, 
     0.000031103953732702, 0.000030315217297903528, 0.000029556107267191897, 
     0.00002882515818696064, 0.000028120994108911484, 
     0.000027442322109010765, 0.00002678792634743572, 
     0.000026156662618508516, 0.00002554745334496239, 
     0.000024959282975614982, 0.000024391193749716433, 
     0.00002384228179496025, 0.00002331169352945143, 0.000022798622340868896, 
     0.00002230230551868152, 0.00002182202141761662, 0.000021357086832670603, 
     0.00002090685456782126, 0.000020470711182276415, 0.00002004807489959562, 
     0.000019638393666370167, 0.00001924114334835889};
 
  TVIL_REAL Gy0xxxtableALx2[] = 
     {0, 0, 0.6666666666666666, 0.18333333333333332, 
     0.08571428571428572, 0.0503968253968254, 0.033405483405483404, 
     0.023823398823398824, 0.01785991785991786, 0.013889460212989625, 
     0.01111123138986916, 0.009090934864928672, 0.007575763178805311, 
     0.006410257642926912, 0.005494505768432273, 0.0047619048233021434, 
     0.004166666680530591, 0.003676470591386186, 0.0032679738569293543, 
     0.0029239766083525866, 0.0026315789474066023, 0.002380952380961228, 
     0.002164502164504222, 0.001976284584980717, 0.001811594202898663, 
     0.001666666666666693, 0.0015384615384615447, 0.001424501424501426, 
     0.0013227513227513231, 0.001231527093596059, 0.001149425287356322, 
     0.001075268817204301, 0.0010080645161290322, 0.000946969696969697, 
     0.00089126559714795, 0.0008403361344537816, 0.0007936507936507937, 
     0.0007507507507507506, 0.0007112375533428164, 0.0006747638326585695, 
     0.000641025641025641, 0.0006097560975609757, 0.0005807200929152149, 
     0.0005537098560354374, 0.0005285412262156448, 0.0005050505050505052, 
     0.00048309178743961357, 0.00046253469010175765, 0.0004432624113475177, 
     0.00042517006802721087, 0.00040816326530612246, 0.0003921568627450981, 
     0.0003770739064856712, 0.000362844702467344, 0.00034940600978336826, 
     0.0003367003367003367, 0.0003246753246753247, 0.0003132832080200501, 
     0.00030248033877797946, 0.00029222676797194627, 0.0002824858757062147, 
     0.000273224043715847, 0.00026441036488630354, 0.0002560163850486431, 
     0.00024801587301587306, 0.00024038461538461537, 0.00023310023310023313, 
     0.0002261420171867933, 0.00021949078138718174, 0.00021312872975277065, 
     0.00020703933747412008, 0.00020120724346076458, 0.00019561815336463224, 
     0.00019025875190258754, 0.00018511662347278784, 0.00018018018018018016, 
     0.00017543859649122808, 0.00017088174982911826, 0.0001665001665001665, 
     0.0001622849724115547, 0.0001582278481012658, 0.00015432098765432096, 
     0.00015055706112616685, 0.00014692918013517483, 0.0001434308663224326, 
     0.00014005602240896358, 0.00013679890560875513, 0.00013365410318096765, 
     0.00013061650992685474, 0.00012768130745658836, 0.0001248439450686642, 
     0.0001221001221001221, 0.00011944577161968467, 0.00011687704534829359, 
     0.00011439029970258523, 0.00011198208286674131, 0.00010964912280701753, 
     0.00010738831615120275, 0.0001051967178624027, 0.00010307153164296021, 
     0.00010101010101010101};

  TVIL_REAL Gy0xxxtableB[] = 
    {0, -1.2707173477574996, 4.2899882125401, -0.2717647743267166, 
     0.031104313483596633, 0.0012331731989206492, -0.00601535592610141, 
     0.0058674860209448915, -0.004885057095344924, 0.003920516939015157, 
     -0.0031310165703138182, 0.0025147004597895913, -0.002038586100459073, 
     0.0016697619205853138, -0.0013817784784545552, 0.0011546934953737503, 
     -0.0009737688703708533, 0.000828145962918614, -0.0007097894416453565, 
     0.0006127069355798755, -0.0005323881641674176, 0.00046540509553481385, 
     -0.0004091266611375146, 0.0003615141220655961, -0.0003209731724110009, 
     0.0002862461208313366, -0.0002563325725330556, 0.00023043054128438664, 
     -0.0002078923331329164, 0.00018819120541782624, -0.00017089595542753676, 
     0.00015565139521957677, -0.00014216323256439637, 0.0001301862769511206, 
     -0.00011951517444987257, 0.00010997708028789745, 
     -0.00010142582682176321, 0.00009373725345924277, 
     -0.00008680544534455117, 0.00008053968723134403, 
     -0.00007486198356162588, 0.00006970502936042496, 
     -0.00006501054202932168, 0.000060727883562855364, 
     -0.00005681291764054695, 0.00005322705757899887, 
     -0.000049936470086958845, 0.0000469114067636553, 
     -0.000044125640775120215, 0.000041555990479245976, 
     -0.00003918191520882028, 0.000036985171161275954, 
     -0.00003494951753629938, 0.00003306046482461792, 
     -0.00003130505857357298, 0.0000296716931076574, 
     -0.000028149950619826716, 0.00002673046181502239, 
     -0.000025404784914785558, 0.000024165300347828307, 
     -0.00002300511887719588, 0.000021918001267119167, 
     -0.00002089828788536304, 0.000019940836880697234, 
     -0.000019040969778817814, 0.000018194423510717766, 
     -0.000017397308030898585, 0.00001664606880361431, 
     -0.00001593745353737163, 0.000015268482634308075, 
     -0.000014636422894411033, 0.000014038764076944993, 
     -0.000013473197974677575, 0.000012937599701989553, 
     -0.00001243001093692797, 0.000011948624890720393, 
     -0.000011491772807052452, 0.000011057911818223347, 
     -0.000010645614006724886, 0.00001025355653933556, 
     -9.880512756900072e-6, 9.52534411693061e-6, -9.186992898317914e-6, 
     8.864475588031937e-6, -8.556876878939476e-6, 8.263344215953394e-6, 
     -7.983082834812114e-6, 7.715351244002821e-6, -7.459457105802736e-6, 
     7.214753477218047e-6, -6.980635375835063e-6, 6.756536639335404e-6, 
     -6.541927050730085e-6, 6.3363097042903835e-6, -6.139218589743657e-6, 
     5.950216374600756e-6, -5.768892366523728e-6, 5.594860639459081e-6, 
     -5.427758308879916e-6, 5.267243942922986e-6, -5.112996097494944e-6};
 
  TVIL_REAL Gy0xxxtableBL[] = 
     {0, 2.2123242385872732, 4.060236592639416, -0.4995073020773833, 
     0.08741305993782221, 0.0006170726148296361, -0.022988705182725035, 
     0.02769025942853131, -0.02703530367850806, 0.02479717465534203, 
     -0.022244105506497056, 0.019809430516758684, -0.01762616757729801, 
     0.015716012494448026, -0.01406066611357937, 0.01262969771011513, 
     -0.011391407207517622, 0.010316797920738445, -0.00938072622294002, 
     0.00856192128886229, -0.00784259235992355, 0.007207926138868673, 
     -0.006645596866804554, 0.006145333071467334, -0.005698551264358614, 
     0.005298053189890922, -0.0049377784698054214, 0.004612603586378026, 
     -0.004318178803855752, 0.004050795800822722, -0.0038072800258218626, 
     0.0035849029152887502, -0.003381310070776265, 0.003194462279117804, 
     -0.0030225868929618736, 0.002864137594317964, -0.0027177609642174993, 
     0.0025822685982546654, -0.0024566137580672893, 0.002339871746847413, 
     -0.0022312233539439554, 0.0021299408383601277, -0.0020353760203648025, 
     0.0019469501299249092, -0.0018641451244349448, 0.001786496239556715, 
     -0.0017135855784573687, 0.0016450365783602931, -0.0015805092206831286, 
     0.0015196958733759856, -0.0014623176723752866, 0.0014081213641348065, 
     -0.0013568765436058926, 0.00130837323230858, -0.0012624197496606236, 
     0.0012188408378306394, -0.001177476006311001, 0.0011381780673732369, 
     -0.001100811837741513, 0.0010652529853351857, -0.001031387002900992, 
     0.000999108292870594, -0.000968319349914921, 0.0009389300294848651, 
     -0.0009108568921793479, 0.0008840226151088693, -0.000858355462560418, 
     0.0008337888092472764, -0.000810260710269154, 0.0007877135126346296, 
     -0.000766093503826175, 0.0007453505934324541, -0.0007254380243452713, 
     0.000706312110429714, -0.0006879319979343714, 0.0006702594482213705, 
     -0.0006532586396696158, 0.0006368959868443632, -0.0006211399752366746, 
     0.000605961010061266, -0.0005913312777641281, 0.0005772246190349197, 
     -0.0005636164122459863, 0.0005504834663520683, -0.0005378039223841516, 
     0.000525557162759098, -0.000513723727705018, 0.0005022852381720258, 
     -0.0004912243246600902, 0.00048052456145104226, -0.00047017040578124563, 
     0.00046014714153563374, -0.0004504408270833948, 0.0004410382469110543, 
     -0.000431926866740538, 0.0004230947918483924, -0.0004145307283280618, 
     0.0004062239470602789, -0.00039816425017750095, 0.00039034193982715853, 
     -0.0003827477890554975};
 
  TVIL_REAL Gy0xxxtableBL2[] = 
     {0, 1.5451774444795625, 2., -0.6666666666666666, 
     0.3333333333333333, -0.2, 0.13333333333333333, -0.09523809523809523, 
     0.07142857142857142, -0.05555555555555555, 0.044444444444444446, 
     -0.03636363636363636, 0.030303030303030304, -0.02564102564102564, 
     0.02197802197802198, -0.01904761904761905, 0.016666666666666666, 
     -0.014705882352941176, 0.013071895424836602, -0.011695906432748537, 
     0.010526315789473684, -0.009523809523809525, 0.008658008658008658, 
     -0.007905138339920948, 0.007246376811594203, -0.006666666666666667, 
     0.006153846153846154, -0.005698005698005698, 0.005291005291005291, 
     -0.0049261083743842365, 0.004597701149425287, -0.004301075268817204, 
     0.004032258064516129, -0.003787878787878788, 0.0035650623885918, 
     -0.0033613445378151263, 0.0031746031746031746, -0.003003003003003003, 
     0.002844950213371266, -0.002699055330634278, 0.002564102564102564, 
     -0.0024390243902439024, 0.0023228803716608595, -0.0022148394241417496, 
     0.0021141649048625794, -0.00202020202020202, 0.001932367149758454, 
     -0.0018501387604070306, 0.0017730496453900709, -0.0017006802721088435, 
     0.0016326530612244899, -0.001568627450980392, 0.0015082956259426848, 
     -0.001451378809869376, 0.001397624039133473, -0.0013468013468013469, 
     0.0012987012987012987, -0.0012531328320802004, 0.0012099213551119178, 
     -0.0011689070718877848, 0.0011299435028248588, -0.001092896174863388, 
     0.0010576414595452142, -0.0010240655401945725, 0.000992063492063492, 
     -0.0009615384615384616, 0.0009324009324009324, -0.0009045680687471732, 
     0.000877963125548727, -0.0008525149190110827, 0.0008281573498964803, 
     -0.0008048289738430583, 0.000782472613458529, -0.00076103500761035, 
     0.0007404664938911515, -0.0007207207207207207, 0.0007017543859649122, 
     -0.000683526999316473, 0.000666000666000666, -0.0006491398896462187, 
     0.0006329113924050633, -0.0006172839506172839, 0.0006022282445046673, 
     -0.0005877167205406994, 0.0005737234652897303, -0.0005602240896358543, 
     0.0005471956224350205, -0.0005346164127238706, 0.0005224660397074191, 
     -0.0005107252298263534, 0.0004993757802746567, -0.0004884004884004884, 
     0.00047778308647873863, -0.0004675081813931744, 0.0004575611988103409, 
     -0.0004479283314669653, 0.0004385964912280702, -0.000429553264604811, 
     0.00042078687144961075, -0.00041228612657184083, 0.00040404040404040404};
 
  TVIL_REAL Gy0xxxtableC[] = 
     {0, -1.5402709982840332, 0.5797290576318396, 0.1528029172572363, 
     0.12389219642803596, 0.09729510854244712, 0.0783483706301704, 
     0.06465396396567315, 0.0544506945265942, 0.046633881335887944, 
     0.04050081844271059, 0.03559012558738436, 0.031589252068743745, 
     0.028280416330005526, 0.025508034816332095, 0.023158477417509364, 
     0.021147114469678097, 0.019409807725853077, 0.01789718579583179, 
     0.016570708981609096, 0.015399910872191402, 0.014360430248854698, 
     0.013432584041435403, 0.012600317245656929, 0.01185041973354652, 
     0.01117193484016983, 0.010555707640154774, 0.009994036261727384, 
     0.009480400093099677, 0.00900924599384703, 0.008575818705600173, 
     0.008176025259616321, 0.007806325764014144, 0.007463644828847217, 
     0.00714529926178662, 0.006848938684542237, 0.006572496480021065, 
     0.006314149052672659, 0.006072281819246963, 0.005845460679943185, 
     0.005632407976455588, 0.005431982142550697, 0.0052431604083961565, 
     0.005065024042182647, 0.004896745709318357, 0.004737578606412635, 
     0.004586847088783572, 0.00444393855966605, 0.004308296429227657, 
     0.0041794139839007125, 0.004056829032947396, 0.003940119220792476, 
     0.003828897911426572, 0.003722810565845473, 0.0036215315456366447, 
     0.003524761285921596, 0.0034322237892870713, 0.003343664399390207, 
     0.0032588478188455626, 0.0031775563409918526, 0.0030995882693529257, 
     0.003024756502181329, 0.002952887262510236, 0.0028838189567282017, 
     0.0028174011469032016, 0.0027534936239774557, 0.002691965570581969, 
     0.0026326948036207725, 0.002575567087983751, 0.0025204755137924373, 
     0.0024673199304892828, 0.0024160064318679295, 0.002366446886826988, 
     0.0023185585112271614, 0.002272263476753505, 0.0022274885531415266, 
     0.0021841647805265784, 0.0021422271690280507, 0.002101614422989784, 
     0.002062268687571285, 0.0020241353156255936, 0.001987162653013024, 
     0.001951301840689033, 0.0019165066320721816, 0.0018827332243471647, 
     0.001849940102490503, 0.0018180878949246332, 0.0017871392398115839, 
     0.0017570586610916312, 0.0017278124534566232, 0.0016993685755231714, 
     0.0016716965505386534, 0.0016447673740137927, 0.0016185534277302865, 
     0.0015930283996211957, 0.0015681672090661855, 0.0015439459371837535, 
     0.0015203417617387488, 0.0014973328963161915, 0.0014748985334420118, 
     0.0014530187913581482};
 
  TVIL_REAL Gy0xxxtableCLx[] = 
     {0, 3.1087005501361697, 0.06000824164397173, 
     0.21744791666666666, 0.14612470191114066, 0.10784155303961288, 
     0.08366220119481751, 0.06720613422061102, 0.05544502674797983, 
     0.04671805363395903, 0.04004327327991324, 0.034808846441872814, 
     0.03061714291074256, 0.027200407274545778, 0.024372761307694852, 
     0.022001715959509366, 0.019990637319367118, 0.01826760400626158, 
     0.016778122660098135, 0.015480243958641643, 0.014341213357983735, 
     0.013335127276604216, 0.012441262648130618, 0.01164286652998614, 
     0.010926265777480666, 0.010280203100547738, 0.009695335680237433, 
     0.009163852146527604, 0.008679176844506361, 0.008235739237727038, 
     0.007828792453152619, 0.007454269278424958, 0.007108666973799127, 
     0.006788954449624639, 0.006492496947484662, 0.006216994526345308, 
     0.005960431515982539, 0.005721034743016691, 0.00549723881940445, 
     0.005287657151298756, 0.005091057607946505, 0.004906342007567377, 
     0.004732528745865204, 0.004568738024682876, 0.004414179242014432, 
     0.004268140186630592, 0.004129977745847018, 0.0039991098871756635, 
     0.0038750087165769593, 0.0037571944499457588, 0.0036452301619939002, 
     0.003538717199139496, 0.0034372911613945924, 0.00334061837335726, 
     0.0032483927768912025, 0.0031603331884151207, 0.0030761808723227748, 
     0.0029956973892311975, 0.0029186626837642343, 0.00284487338162762, 
     0.0027741412699870873, 0.002706291938758119, 0.0026411635634656662, 
     0.002578605812924999, 0.0025184788672053477, 0.002460652533227441, 
     0.002405005446965238, 0.002351424352613145, 0.002299803450277856, 
     0.0022500438047878095, 0.002202052809107665, 0.002155743696620557, 
     0.0021110350972145665, 0.0020678506326962634, 0.002026118547565799, 
     0.001985771371635102, 0.0019467456113622735, 0.0019089814671187292, 
     0.0018724225739074783, 0.0018370157633166406, 0.0018027108447266423, 
     0.0017694604039964743, 0.0017372196180375301, 0.001705946083845764, 
     0.0016755996607068948, 0.0016461423244173495, 0.0016175380324775141, 
     0.0015897525993153795, 0.0015627535806892587, 0.0015365101664992144, 
     0.0015109930813093043, 0.0014861744919476636, 0.0014620279216096964, 
     0.0014385281699419656, 0.0014156512386314314, 0.001393374262067047, 
     0.001371675442678918, 0.0013505339905946951, 0.0013299300672840067, 
     0.0013098447328898958, 0.0012902598969717228};
 
  TVIL_REAL Gy0xxxtableCLy[] = 
     {0, -0.9674011002723395, -0.0625, -0.24343337917801414, 
     -0.1669500343835106, -0.1243661716209663, -0.09709726398065897, 
     -0.07838048021697297, -0.06491669435027317, -0.054873314099423774, 
     -0.047157663266479015, -0.04108430707686611, -0.03620522148550143, 
     -0.032217203776380585, -0.028908840182962046, -0.026128853832153163, 
     -0.02376652605088853, -0.021739198497231944, -0.019984069479079804, 
     -0.018452673476289556, -0.017107082752896297, -0.015917241154598166, 
     -0.014859058613830401, -0.013913026927905001, -0.013063199184618447, 
     -0.012296427045618431, -0.011601783623489735, -0.01097012178406288, 
     -0.010393732522317588, -0.009866078156221066, -0.009381582064474411, 
     -0.008935461588726157, -0.008523594196211029, -0.008142409495925141, 
     -0.007788801515693888, -0.0074600569793155935, -0.0071537963101974186, 
     -0.00686792482641068, -0.006600592149310229, -0.0063501582717112055, 
     -0.006115165056493302, -0.005894312187326245, -0.005686436788192145, 
     -0.005490496080941094, -0.005305552570224554, -0.0051307613402667655, 
     -0.004965359123680306, -0.004808654863174989, -0.00466002153580835, 
     -0.004518889048885439, -0.004384738048671727, -0.004257094509240626, 
     -0.004135524990212922, -0.004019632469783723, -0.003909052674002939, 
     -0.003803450835357108, -0.0037025188237547165, -0.0036059726014137433, 
     -0.0035135499601856154, -0.0034250085057640264, -0.003340123858214237, 
     -0.0032586880424765536, -0.0031805080460756653, -0.003105404524311024, 
     -0.0030332106357993886, -0.0029637709934606255, -0.0028969407179411104, 
     -0.0028325845821048647, -0.0027705762366317605, -0.0027107975079789684, 
     -0.0026531377610148664, -0.00259749331954796, -0.0025437669387671337, 
     -0.0024918673243008445, -0.0024417086932061165, -0.002393210372725607, 
     -0.0023462964331129993, -0.002300895351232409, -0.0022569397019938636, 
     -0.0022143658750007895, -0.002173113814062274, -0.0021331267774674827, 
     -0.002094351117136075, -0.00205673607495031, -0.0020202335947448608, 
     -0.001984798148581726, -0.001950386576072432, -0.0019169579356298737, 
     -0.001884473366639413, -0.0018528959616347508, -0.0018221906476499198, 
     -0.0017923240759956825, -0.0017632645197776463, -0.0017349817785354347, 
     -0.0017074470894380494, -0.0016806330445208004, -0.0016545135134944928, 
     -0.00162906357169844, -0.0016042594328058355, -0.001580078385923429, 
     -0.0015564987367577303};
 
  TVIL_REAL Gy0xxxtableCLx2[] = 
     {0, 0., 0.203125, 0.03515625, 0.018391927083333332, 
     0.011564127604166667, 0.008011881510416667, 0.005925351097470238, 
     0.004592123485746838, 0.0036849952879406157, 0.0030372430407811725, 
     0.002556787846236346, 0.002189370361929504, 0.001901278836419625, 
     0.0016706308137424079, 0.0014826923514965362, 0.001327230088126608, 
     0.0011969449928890294, 0.0010865097294870698, 0.0009919570218921679, 
     0.0009102795899847089, 0.0008391616935925569, 0.0007767948567702899, 
     0.0007217487871555567, 0.0006728792975306342, 0.000629261533909243, 
     0.0005901408271069054, 0.0005548960208392799, 0.0005230117662466129, 
     0.0004940573496291556, 0.0004676703411982945, 0.000443543843249448, 
     0.00042141645498566273, 0.0004010643084665907, 0.0003822946984159003, 
     0.0003649409493801855, 0.00034885825137035884, 0.0003339202593810511, 
     0.0003200162997694488, 0.0003070490620345486, 0.0002949326813400253, 
     0.0002835911374900122, 0.000272956911661607, 0.0002629698542255983, 
     0.00025357622632746647, 0.000244727885201862, 0.0002363815889361804, 
     0.00022849840094197138, 0.00022104317800739195, 0.00021398412869496277, 
     0.00020729243117312553, 0.0002009419014477707, 0.00019490870448389994, 
     0.0001891711019500483, 0.00018370923133536747, 0.00017850491202559714, 
     0.00017354147461442262, 0.00016880361029860045, 0.0001642772376807566, 
     0.00015994938470054924, 0.00015580808374708922, 0.00015184227828454855, 
     0.0001480417395579962, 0.00014439699214520356, 0.00014089924728857852, 
     0.00013754034308454356, 0.00013431269072968304, 0.00013120922612725166, 
     0.00012822336624696243, 0.00012534896970769184, 0.00012258030111878717, 
     0.00011991199877265244, 0.00011733904533057913, 0.00011485674118650605, 
     0.0001124606802304989, 0.00011014672776603168, 0.00010791100036331557, 
     0.00010574984745552761, 0.00010365983450633356, 0.00010163772759599072, 
     0.000099680479289916, 0.0000977852156682125, 0.000095949224407526, 
     0.0000941699438179766, 0.00009244495274796778, 0.00009077196127858644, 
     0.0000891488021372121, 0.00008757342276697754, 0.00008604387799497263, 
     0.00008455832324765229, 0.00008311500826687813, 0.00008171227128446383, 
     0.00008034853361706573, 0.00007902229464681883, 0.00007773212715630992, 
     0.00007647667298934569, 0.00007525463901155097, 0.00007406479334715165, 
     0.00007290596187038795, 0.00007177702493188976, 0.00007067691430204935};
 
  TVIL_REAL Gy0xxxtableCLxLy[] = 
      {0, -1.5, -0.5, -0.125, -0.07552083333333333, 
     -0.052408854166666664, -0.03909505208333333, -0.030600992838541667, 
     -0.024795604887462797, -0.020621726626441593, -0.01750207779899476, 
     -0.015097813568417988, -0.013198374054820678, -0.011666740439455918, 
     -0.010410296487079132, -0.009364416304810759, -0.008482771230474036, 
     -0.007731370032829362, -0.00708476586553043, -0.006523568947245923, 
     -0.00603277226167429, -0.005600598231813763, -0.005217687811650452, 
     -0.0048765197828325125, -0.004570987985450385, -0.004296088899178131, 
     -0.004047687615245613, -0.003822340342191628, -0.0036171582489766636, 
     -0.0034297019192237686, -0.0032578987397880546, -0.0030999776585459884, 
     -0.002954417229024162, -0.0028199039140444624, -0.002695298379595611, 
     -0.002579608062573259, -0.0024719647022928247, -0.0023716058273648205, 
     -0.002277859415602676, -0.0021901311155140455, -0.0021078935481324062, 
     -0.0020306773079172297, -0.001958063358763097, -0.0018896765813557178, 
     -0.0018251802752883189, -0.0017642714565496466, -0.001706676820496804, 
     -0.0016521492639546282, -0.0016004648789473698, -0.0015514203457692613, 
     -0.0015048306654087094, -0.0014605271813528061, -0.0014183558489790252, 
     -0.0013781757174527766, -0.0013398575945788678, -0.0013032828696279426, 
     -0.0012683424729551728, -0.0012349359543911847, -0.00120297066502921, 
     -0.0011723610292502392, -0.0011430278956941428, -0.0011148979574599658, 
     -0.0010879032331521875, -0.001061980601522003, -0.001037071383416708, 
     -0.0010131209655732363, -0.0009900784614962827, -0.0009678964052658762, 
     -0.0009465304746391356, -0.000925939240259202, -0.0009060839381716717, 
     -0.0008869282631843433, -0.0008684381808972541, -0.0008505817564832193, 
     -0.000833328998519801, -0.0008166517163663489, -0.0008005233897483682, 
     -0.0007849190493592676, -0.0007698151674193089, -0.0007551895572457459, 
     -0.0007410212809887263, -0.0007272905647763154, -0.0007139787205904944, 
     -0.0007010680742654824, -0.000688541899061363, -0.0006763843543207437, 
     -0.00066458042876486, -0.0006531158880289036, -0.0006419772260750454, 
     -0.0006311516201561643, -0.0006206268890342064, -0.000610391454184763, 
     -0.0006004343037442785, -0.0005907449589785707, -0.000581313443071374, 
     -0.000572130252049638, -0.0005631863276785482, -0.0005544730321738827, 
     -0.0005459821245925444, -0.0005377057387740596, -0.00052963636271666};
 
  TVIL_REAL Gy0xxxtableCLy2[] = 
     {0, 0.375, 0.296875, 0.08984375, 0.05712890625, 
     0.0408447265625, 0.031083170572916666, 0.024675641741071428, 
     0.02020348140171596, 0.016936731338500977, 0.014464834758213588, 
     0.012541025722181642, 0.011009003692891175, 0.009765461603036294, 
     0.008739665673336724, 0.007881723953314223, 0.007155541142347429, 
     0.006534425039940333, 0.00599825613604336, 0.005531611925353755, 
     0.005122492671689582, 0.004761436538221206, 0.004440892954880162, 
     0.004154770995676957, 0.0038981086879197515, 0.003666827365268888, 
     0.0034575467881387072, 0.0032674443213523475, 0.0030941464827300503, 
     0.002935644569594613, 0.0027902283985897602, 0.00265643381529654, 
     0.002533000774038499, 0.0024188396055778716, 0.002313003681179711, 
     0.002214667113193073, 0.002123106450922466, 0.002037685567983769, 
     0.0019578431158332275, 0.001883082053479497, 0.0018129608667923809, 
     0.0017470861704272176, 0.0016851064471014897, 0.0016267067271301195, 
     0.0015716040489608524, 0.0015195435713477846, 0.0014702952315606237, 
     0.001423650863012657, 0.0013794217009399778, 0.0013374362170742984, 
     0.0012975382342355838, 0.0012595852799050355, 0.0012234471444951254, 
     0.0011890046155027284, 0.0011561483632435002, 0.0011247779576023453, 
     0.0010948009983407503, 0.0010661323440925843, 0.0010386934273484533, 
     0.00101241164454969, 0.0009872198119470533, 0.0009630556791754174, 
     0.0009398614935941913, 0.0009175836093767993, 0.0008961721361281296, 
     0.0008755806224886928, 0.0008557657707665998, 0.0008366871791386244, 
     0.0008183071083921732, 0.0008005902705515102, 0.0007835036370528846, 
     0.0007670162644116908, 0.000751099135566675, 0.0007357250152967131, 
     0.0007208683182893021, 0.0007065049886003171, 0.0006926123893850526, 
     0.0006791692019037398, 0.0006661553329129754, 0.0006535518296497554, 
     0.0006413408016988103, 0.0006295053491081027, 0.0006180294961829685, 
     0.0006068981304475058, 0.0005960969463133951, 0.0005856123930421573, 
     0.0005754316266276478, 0.000565542465261926, 0.0005559333480800727, 
     0.000546593296908512, 0.0005375118807673283, 0.0005286791829002991, 
     0.0005200857701272128, 0.0005117226643317519, 0.0005035813159150642, 
     0.0004956535790602923, 0.0004879316886669972, 0.0004804082388267311, 
     0.0004730761627221563, 0.0004659287138421698, 0.00045895944841461067};
 
  TVIL_REAL Gy0xxxtableCLx3[] = 
     {0, 0., -0.0625, -0.020833333333333332, -0.01171875, 
     -0.0078125, -0.005696614583333333, -0.00439453125, -0.0035247802734375, 
     -0.0029093424479166665, -0.0024547576904296875, -0.0021076202392578125, 
     -0.0018353859583536785, -0.0016171932220458984, -0.001439109444618225, 
     -0.0012915084759394329, -0.0011675467249006033, -0.0010622385889291763, 
     -0.0009718745423015207, -0.0008936431549955159, -0.0008253787473222474, 
     -0.0007653888133063447, -0.000712333452383973, -0.0006651395176504593, 
     -0.0006229384308298336, -0.0005850204393880176, -0.0005508004938148403, 
     -0.0005197924660148937, -0.000491589440729745, -0.0004658484866174595, 
     -0.0004422787715207428, -0.00042063220205810353, 
     -0.00040069598831472467, -0.00038228669070886734, 
     -0.00036524541819105475, -0.00034943392822607403, 
     -0.00033473143859891484, -0.0003210320052045191, 
     -0.00030824235295039175, -0.00029628007175481173, 
     -0.00028507210851408697, -0.00027455350038254776, 
     -0.00026466630587472387, -0.00025535869897498885, 
     -0.0002465841982255777, -0.00023830100810430505, 
     -0.00023047145423131282, -0.00022306149731040063, 
     -0.00021604031340502345, -0.00020937993031698321, 
     -0.00020305491158865768, -0.00019704208107342732, 
     -0.00019132028218071817, -0.00018587016685407546, 
     -0.00018067401012400246, -0.0001757155467243729, 
     -0.00017097982679777356, -0.00016645308816166026, 
     -0.0001621226429801146, -0.00015797677699846434, 
     -0.00015400465976071558, -0.0001501962644512675, 
     -0.00014654229618975146, -0.00014303412776678576, 
     -0.00013966374194365207, -0.0001364236795542389, -0.0001333069927462408, 
     -0.00013030720278317957, -0.00012741826190151148, 
     -0.00012463451877971768, -0.00012195068723036453, 
     -0.00011936181777293282, -0.00011686327178582084, 
     -0.00011445069797121871, -0.00011212001089729281, 
     -0.00010986737140894537, -0.00010768916872187258, 
     -0.0001055820040351935, -0.00010354267551595774, 
     -0.00010156816452469502, -0.00009965562296513546, 
     -0.00009780236165354753, -0.00009600583961402734, 
     -0.00009426365421570646, -0.00009257353207638593, 
     -0.00009093332066468527, -0.00008934098053953539, 
     -0.00008779457817184633, -0.00008629227929853052, 
     -0.00008483234276384016, -0.00008341311480724814, 
     -0.00008203302376092497, -0.00008069057512329148, 
     -0.00007938434697820215, -0.00007811298573207809, 
     -0.00007687520214379388, -0.00007566976762436271, 
     -0.00007449551078548221, -0.00007335131421782679, 
     -0.00007223611148161908, -0.00007114888429350286};
 
  TVIL_REAL Gy0xxxtableCLx2Ly[] = 
     {0, 0., 0.125, 0.03125, 0.015625, 0.009765625, 0.0068359375, 
     0.005126953125, 0.0040283203125, 0.00327301025390625, 
     0.002727508544921875, 0.0023183822631835938, 0.002002239227294922, 
     0.0017519593238830566, 0.0015498101711273193, 0.001383759081363678, 
     0.0012453831732273102, 0.0011286285007372499, 0.0010290436330251396, 
     0.0009432899969397113, 0.0008688197340234183, 0.0008036582539716619, 
     0.0007462540929736861, 0.0006953731320891166, 0.0006500227104311307, 
     0.000609396291029185, 0.0005728325135674339, 0.0005397844839385435, 
     0.0005097964570530689, 0.00048248593256808303, 0.0004575297636421477, 
     0.0004346532754600403, 0.00041362166535713514, 0.0003942331497935194, 
     0.0003763134611665413, 0.0003597113967033115, 0.0003442951939874553, 
     0.0003299495609046447, 0.0003165732273544564, 0.00030407691574835943, 
     0.0002923816497580379, 0.0002814173378921115, 0.00027112158162776595, 
     0.0002614386679982029, 0.0002523187144633818, 0.00024371694010667563, 
     0.00023559304210311977, 0.00022791066029540934, 0.00022063691581789628, 
     0.00021374201219858703, 0.0002071988893761813, 0.00020098292269489585, 
     0.00019507166026269305, 0.00018944459313973076, 0.0001840829537112478, 
     0.0001789695383303798, 0.00017408855092136946, 0.00016942546473597563, 
     0.00016496689987450258, 0.0001607005145329206, 0.0001566149082312362, 
     0.0001526995355254553, 0.0001489446289141736, 0.00014534112982754038, 
     0.00014188062673640845, 0.00013855529954727387, 0.0001353578695577214, 
     0.00013228155434050047, 0.0001293200270045191, 0.00012646737935000766, 
     0.0001237180884945727, 0.00012106698659826044, 0.00011850923336026903, 
     0.00011604029099859675, 0.0001136559014575297, 0.00011135206561717436, 
     0.00010912502430483088, 0.00010697124093039342, 0.00010488738558759355, 
     0.00010287032048013983, 0.00010091708654697261, 0.00009902489117421688, 
     0.00009719109689321287, 0.00009541321097443458, 0.00009368887583634239, 
     0.00009201586019640771, 0.00009039205089882404, 0.00008881544535989107, 
     0.00008728414457782397, 0.0000857963466588838, 0.00008435034081631834, 
     0.00008294450180271303, 0.00008157728474003095, 0.00008024722031492175, 
     0.00007895291030984237, 0.00007769302344319594, 0.00007646629149409284, 
     0.00007527150568949765, 0.00007410751333347448, 0.00007297321466000294, 
     0.00007186755989242713};
 
  TVIL_REAL Gy0xxxtableCLxLy2[] = 
     {0, 0.375, -0.0625, 0., 0.00390625, 0.00390625, 
     0.00341796875, 0.0029296875, 0.0025177001953125, 0.0021820068359375, 
     0.0019092559814453125, 0.00168609619140625, 0.0015016794204711914, 
     0.001347661018371582, 0.0012177079916000366, 0.0011070072650909424, 
     0.0010118738282471895, 0.0009294587653130293, 0.000857536360854283, 
     0.0007943494711071253, 0.0007384967739199055, 0.0006888499319757102, 
     0.000644492171204547, 0.0006046722887731448, 0.0005687698716272394, 
     0.0005362687361056828, 0.0005067364543096531, 0.0004798084301675942, 
     0.0004551754080830972, 0.0004325735947162124, 0.00041177678727793293, 
     0.00039259005525422996, 0.0003748446342299037, 0.0003583937725395631, 
     0.00034310933224008177, 0.0003288789912715991, 0.00031560392782183403, 
     0.00030319689380426805, 0.00029158060414226247, 0.0002806863837677164, 
     0.00027045302602618504, 0.00026082582536342036, 0.0002517557543686398, 
     0.0002431987609285608, 0.00023511516574996943, 0.00022746914409956393, 
     0.00022022827848769893, 0.00021336317134038323, 0.00020684710857927778, 
     0.00020065576655377558, 0.00019476695601361042, 0.00018916039783049022, 
     0.00018381752601676844, 0.00017872131428276486, 0.0001738561229495118, 
     0.00016920756351235908, 0.0001647623785505818, 0.00016050833501302954, 
     0.00015643412919133864, 0.00015252930192955177, 0.0001487841628196744, 
     0.00014518972230289192, 0.00014173763074090714, 0.00013842012364527655, 
     0.00013522997235813932, 0.00013216043956816893, 0.00012920523912327952, 
     0.00012635849966853775, 0.0001236147316954962, 0.00012096879763913776, 
     0.00011841588470194817, 0.0001159514801222776, 0.00011357134863692448, 
     0.00011127151191646264, 0.00010904822977681904, 0.00010689798299248739, 
     0.00010481745755595597, 0.00010280353024479368, 0.00010085325537268611, 
     0.00009896385261380541, 0.00009713269580146114, 0.00009535730261220885, 
     0.0000936353250556563, 0.0000919645406982502, 0.00009034284455647303, 
     0.00008876824160124037, 0.00008723883982095809, 0.00008575284379575689, 
     0.00008430854873994361, 0.00008290433497375288, 0.00008153866278910773, 
     0.00008021006767734887, 0.00007891715588981255, 0.00007765860030476298, 
     0.00007643313657654953, 0.00007523955954498976, 0.00007407671988490245, 
     0.00007294352097745133, 0.00007183891598653139, 0.00007076190512485134, 
     0.00006971153309565433};
 
  TVIL_REAL Gy0xxxtableCLy3[] = 
     {0, -0.25, 0., -0.010416666666666666, -0.0078125, 
     -0.005859375, -0.004557291666666667, -0.003662109375, 
     -0.003021240234375, -0.0025456746419270835, -0.0021820068359375, 
     -0.0018968582153320312, -0.0016685326894124348, -0.0014824271202087402, 
     -0.0013284087181091309, -0.0011992578705151875, -0.0010897102765738964, 
     -0.0009958486771211028, -0.0009147054515779018, -0.0008439963130513206, 
     -0.0007819377606210764, -0.0007271193726410274, -0.00067841281179426, 
     -0.0006349059032118021, -0.0005958541512285365, -0.0005606445877468502, 
     -0.0005287684740622467, -0.000499800448091244, -0.0004733824244064211, 
     -0.0004492110406668359, -0.00042702777939933784, 
     -0.00040661112865616675, -0.0003877703112723142, 
     -0.00037034023162421523, -0.00035417737521556826, 
     -0.00033915645974883657, -0.00032516768321037446, 
     -0.0003121144495043936, -0.0002999114785463271, -0.0002884832277612641, 
     -0.000277762567270136, -0.0002676896628729841, -0.00025821103012168184, 
     -0.00024927872995177483, -0.00024084968198777356, 
     -0.0002328850761019345, -0.00022534986635950588, 
     -0.00021821233432539193, -0.0002114437109921506, -0.0002050178484353794, 
     -0.00019891093380113405, -0.00019310123945195877, 
     -0.00018756890409874332, -0.00018229574056842016, 
     -0.00017726506653675713, -0.000172461555118366, -0.0001678711026741777, 
     -0.0001634807115873449, -0.00015927838608572662, 
     -0.00015525303946400804, -0.000151394411290195, -0.0001476929933770797, 
     -0.0001441399634653293, -0.00014072712570603114, -0.0001374468571508957, 
     -0.00013429205956120392, -0.00013125611593476014, 
     -0.00012833285122585867, -0.00012551649679850383, 
     -0.00012280165820942774, -0.00012018328596615635, 
     -0.00011765664894760522, -0.00011521731021137267, 
     -0.00011286110494384068, -0.00011058412033705592, 
     -0.00010838267720071638, -0.00010625331313891427, 
     -0.0001041927671399936, -0.00010219796544432192, 
     -0.00010026600856925021, -0.0000983941593832983, 
     -0.00009657983213287819, -0.00009482058233484182, 
     -0.00009311409745697832, -0.00009145818831642948, 
     -0.00008985078113296281, -0.00008828991018024673, 
     -0.00008677371098380161, -0.00008530041401923707, 
     -0.00008386833886879651, -0.00008247588879817793, 
     -0.00008112154571913692, -0.00007980386550655202, 
     -0.00007852147364148256, -0.00007727306115431381, 
     -0.00007605738084439182, -0.00007487324375463258, 
     -0.00007371951588146677, -0.0000725951151021791, -0.0000714990083032352, 
     -0.0000704302086945786};
 
  TVIL_REAL Gy0xxxtableD[] = 
     {0, 0, 0.30301768662811995, 0.001985632211516103, 
     -0.004692159997145554, 0.002821015378817693, -0.00169667442521237, 
     0.0010776289410660404, -0.0007212300751408436, 0.0005044189500014635, 
     -0.0003658197618694282, 0.0002733947843413996, -0.0002095210635832869, 
     0.0001640212873177436, -0.0001307595391668503, 0.00010589474738231981, 
     -0.0000869421817603373, 0.0000722476038795484, -0.00006068141498706783, 
     0.00005145474434797134, -0.0000440055307028763, 0.00003792605964956524, 
     -0.00003291575741765733, 0.000028749768443929323, 
     -0.000025257626934881097, 0.00002230852036390175, 
     -0.000019800940939539687, 0.000017655309521104086, 
     -0.00001580864572345083, 0.000014210667610642354, 
     -0.000012820903956377253, 0.000011606532859683527, 
     -0.000010540747588633387, 9.601509345024665e-6, -8.770586912262093e-6, 
     8.03281106736193e-6, -7.37549122370262e-6, 6.787955663880062e-6, 
     -6.261186679550267e-6, 5.787529142321614e-6, -5.36045629462836e-6, 
     4.9743804291987286e-6, -4.624499008345723e-6, 4.306668932902876e-6, 
     -4.0173032990807416e-6, 3.753286218717546e-6, -3.5119022246627285e-6, 
     3.2907775114127894e-6, -3.087830825206866e-6, 2.901232257187385e-6, 
     -2.7293685374065912e-6, 2.570813698483711e-6, -2.4243041922254007e-6, 
     2.2887177131282713e-6, -2.163055119007305e-6, 2.0464249484159913e-6, 
     -1.9380301227315596e-6, 1.8371564921800723e-6, 
     -1.7431629431043968e-6, 1.6554728311193782e-6, 
     -1.5735665435642533e-6, 1.4969750265193983e-6, -1.425274137924387e-6, 
     1.358079710069109e-6, -1.2950432227701003e-6, 1.2358480035647982e-6, 
     -1.1802058838002655e-6, 1.1278542499988803e-6, -1.078553438707464e-6, 
     1.0320844304677876e-6, -9.882468048217048e-7, 9.468569235767329e-7, 
     -9.077463140666625e-7, 8.707602279775689e-7, -8.357563545805174e-7, 
     8.026036700078567e-7, -7.71181406604622e-7, 7.413781284421573e-7, 
     -7.130909008493132e-7, 6.86224543340734e-7, -6.606909566381306e-7, 
     6.364085156195468e-7, -6.13301521019199e-7, 5.912997035582323e-7, 
     -5.703377749330749e-7, 5.503550207385968e-7, -5.312949309712534e-7, 
     5.131048642541074e-7, -4.957357423607252e-7, 4.791417719966785e-7, 
     -4.6328019113280096e-7, 4.4811103747953093e-7, -4.335969369518103e-7, 
     4.1970291020360316e-7, -4.063961955140159e-7, 3.93646086486585e-7, 
     -3.8142378318245163e-7, 3.697022554493701e-7, -3.5845611733397767e-7, 
     3.476615115763914e-7, -3.3729600328562876e-7};
 
  TVIL_REAL Gy0xxxtableDL[] = 
     {0, 0, 0.2813024128964863, 0.045121417923393456, 
     -0.0439698341711512, 0.0325539635215082, -0.024114546715205225, 
     0.018355993712061442, -0.01436673161926264, 0.011521291175236158, 
     -0.009431784740444135, 0.007856832546613002, -0.006642404493153396, 
     0.005687309264501159, -0.004923170202921959, 0.0043025743510831695, 
     -0.0037918703701581677, 0.0033666704514703568, -0.0030089666624145703, 
     0.0027052368811453587, -0.0024451727134179534, 0.002220807589016621, 
     -0.0020259079507427163, 0.0018555408794764749, -0.0017057622208171627, 
     0.001573388404346148, -0.0014558272958375754, 0.0013509512867401104, 
     -0.0012570010050531584, 0.0011725114992747671, -0.0010962551036801213, 
     0.0010271968173984896, -0.0009644591639631907, 0.000907294299799121, 
     -0.0008550617134458954, 0.0008072102717170874, -0.0007632636715635126, 
     0.0007228085794305745, -0.0006854849057672599, 0.000650977786751375, 
     -0.0006190109393538754, 0.0005893411275178699, -0.0005617535322048932, 
     0.0005360578605311944, -0.0005120850622381075, 0.0004896845475736657, 
     -0.00046872182099103987, 0.000449076461155745, -0.0004306403905511776, 
     0.00041331638820533235, -0.0003970168072843387, 0.00038166246593667353, 
     -0.0003671816851549557, 0.00035350945180620666, -0.00034058668856655006, 
     0.00032835961543972795, -0.0003167791899646083, 0.00030580061522340543, 
     -0.000295382906427959, 0.00028548850824874965, -0.00027608295621065973, 
     0.00026713457645135923, -0.0002586142189554084, 0.00025049502006636404, 
     -0.00024275219066206968, 0.00023536282687265628, 
     -0.00022830574064115116, 0.00022156130778498674, 
     -0.00021511133152301345, 0.000208938919695065, -0.00020302837412650406, 
     0.0001973650907841739, -0.00019193546953753335, 0.00018672683248343057, 
     -0.0001817273499183083, 0.00017692597315043613, -0.00017231237343940037, 
     0.00016787688643255395, -0.0001636104615401337, 0.00015950461575373322, 
     -0.00015555139146800512, 0.00015174331791390546, -0.0001480733758543799, 
     0.00014453496523089636, -0.0001411218754823101, 0.00013782825828677166, 
     -0.00013464860250324553, 0.00013157771111211894, 
     -0.00012861067997471055, 0.00012574287824955558, 
     -0.00012296993031941917, 0.00012028769909731462, 
     -0.00011769227059258326, 0.00011517993962950954, -0.0001127471966211584, 
     0.0001103907153102673, -0.00010810734139722713, 0.00010589408198254757, 
     -0.0001037480957578201, 0.00010166668388514461, -0.00009964728151034882};
 
  TVIL_REAL Gy0xxxtableDL2[] = 
     {0, 0, 0.5, -0.16666666666666666, 0.08333333333333333, -0.05, 
     0.03333333333333333, -0.023809523809523808, 0.017857142857142856, 
     -0.013888888888888888, 0.011111111111111112, -0.00909090909090909, 
     0.007575757575757576, -0.00641025641025641, 0.005494505494505495, 
     -0.004761904761904762, 0.004166666666666667, -0.003676470588235294, 
     0.0032679738562091504, -0.0029239766081871343, 0.002631578947368421, 
     -0.002380952380952381, 0.0021645021645021645, -0.001976284584980237, 
     0.0018115942028985507, -0.0016666666666666668, 0.0015384615384615385, 
     -0.0014245014245014246, 0.0013227513227513227, -0.0012315270935960591, 
     0.0011494252873563218, -0.001075268817204301, 0.0010080645161290322, 
     -0.000946969696969697, 0.00089126559714795, -0.0008403361344537816, 
     0.0007936507936507937, -0.0007507507507507507, 0.0007112375533428165, 
     -0.0006747638326585695, 0.000641025641025641, -0.0006097560975609756, 
     0.0005807200929152149, -0.0005537098560354374, 0.0005285412262156448, 
     -0.000505050505050505, 0.0004830917874396135, -0.00046253469010175765, 
     0.0004432624113475177, -0.00042517006802721087, 0.00040816326530612246, 
     -0.000392156862745098, 0.0003770739064856712, -0.000362844702467344, 
     0.00034940600978336826, -0.0003367003367003367, 0.0003246753246753247, 
     -0.0003132832080200501, 0.00030248033877797946, -0.0002922267679719462, 
     0.0002824858757062147, -0.000273224043715847, 0.00026441036488630354, 
     -0.0002560163850486431, 0.000248015873015873, -0.0002403846153846154, 
     0.0002331002331002331, -0.0002261420171867933, 0.00021949078138718174, 
     -0.00021312872975277067, 0.00020703933747412008, 
     -0.00020120724346076458, 0.00019561815336463224, -0.0001902587519025875, 
     0.00018511662347278786, -0.00018018018018018018, 0.00017543859649122806, 
     -0.00017088174982911826, 0.0001665001665001665, -0.0001622849724115547, 
     0.00015822784810126583, -0.00015432098765432098, 0.00015055706112616682, 
     -0.00014692918013517486, 0.00014343086632243257, 
     -0.00014005602240896358, 0.00013679890560875513, 
     -0.00013365410318096765, 0.00013061650992685477, 
     -0.00012768130745658836, 0.00012484394506866417, -0.0001221001221001221, 
     0.00011944577161968466, -0.0001168770453482936, 0.00011439029970258523, 
     -0.00011198208286674133, 0.00010964912280701755, 
     -0.00010738831615120275, 0.00010519671786240269, 
     -0.00010307153164296021, 0.00010101010101010101};
 
  if (y < 0.5 * x) {
    result = TVIL_G00xxx (x,qq);
    result += y * (3.L - PI*PI/36.L + (-1.L - Zeta2) * lnbarx 
              - lnbarx2 - (2.L * lnbarx3)/3.L - lnbarx * lnbary 
              + lnbarx2 * lnbary - (9.L*SQRT3*LS2)/2.L);
    rn = r = y/x;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gy0xxxtableA[n] +
        Gy0xxxtableALx[n] * lnbarx +
        Gy0xxxtableALy[n] * lnbary +
        Gy0xxxtableALx2[n] * lnbarx * (lnbarx - lnbary));
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_Gx0xxx (x,qq);
    result += (y-x) * (-2.04579029229260745L - lnbarx2 +
     lnbarx3/3.L - SQRT3 * lnbarx * LS2); 
    rn = r = y/x - 1.L;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gy0xxxtableD[n] + 
        Gy0xxxtableDL[n] * lnbarx + 
        Gy0xxxtableDL2[n] * lnbarx2);
    }
  }
  else if (y < 6. * x) {
    result = x * (-17.773015221981147L 
             + 16.137416484381877L * lnbarx 
             - 6.954822555520438L * lnbarx2 
             + 1.8333333333333333L * lnbarx3) +
             (y - 4.L * x) * (-0.3176793369393749L 
               + 0.5530810596468184L * lnbarx 
               + 0.38629436111989046L * lnbarx2 
               + 0.3333333333333333L * lnbarx3);
    rn = r = y/(4.L*x) - 1.L;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gy0xxxtableB[n] +
        Gy0xxxtableBL[n] * lnbarx +  
        Gy0xxxtableBL2[n] * lnbarx2);
    }
  }
  else {
    result = TVIL_Gx0000 (y, qq);
    rn = r = 4.L * x/y;
    for (n=1; n < 100; n++) {
      result += y * rn * (Gy0xxxtableC[n] +
        Gy0xxxtableCLx[n] * lnbarx +
        Gy0xxxtableCLy[n] * lnbary +
        Gy0xxxtableCLx2[n] * lnbarx2 +
        Gy0xxxtableCLy2[n] * lnbary2 +
        Gy0xxxtableCLxLy[n] * lnbarx * lnbary +
        Gy0xxxtableCLx3[n] * lnbarx3 +
        Gy0xxxtableCLx2Ly[n] * lnbarx2 * lnbary +
        Gy0xxxtableCLxLy2[n] * lnbarx * lnbary2 +
        Gy0xxxtableCLy3[n] * lnbary3);
      rn *= r;
    }
  }

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0yxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  TVIL_REAL Gx0yxytableA[] = 
     {0, -0.6498285914033671, 0.17306039356765535, 
     0.006640094659018887, 0.0014256409878518807, 0.0006790122940137193, 
     0.0004039048574314857, 0.00025965489011322543, 0.00017486962432474893, 
     0.00012212100027108084, 0.00008792477261154258, 0.00006498232320102586, 
     0.000049126028120521, 0.00003787829183302451, 0.00002971467679047566, 
     0.000023668151429114742, 0.000019108258784950253, 
     0.000015613723140385637, 0.000012896720447736157, 
     0.000010756612229833006, 9.050964241999543e-6, 7.676972209950682e-6, 
     6.559305273463022e-6, 5.641995143862694e-6, 4.882927974973687e-6, 
     4.250042292164282e-6, 3.7186647637853933e-6, 3.2696171152772525e-6, 
     2.8878534984129277e-6, 2.561467832657888e-6, 2.2809625335061854e-6, 
     2.0387041455067842e-6, 1.8285141323498864e-6, 1.6453584383268983e-6, 
     1.4851099478643446e-6, 1.3443652496689684e-6, 1.2203022100535913e-6, 
     1.1105684679956934e-6, 1.0131935434725369e-6, 9.265191115134444e-7, 
     8.491433491713228e-7, 7.798762572639255e-7, 7.177035948671165e-7, 
     6.617576135108822e-7, 6.112931903960803e-7, 5.656682718504063e-7, 
     5.243277757092935e-7, 4.867902832427439e-7, 4.52636991476958e-7, 
     4.215025054627547e-7, 3.9306713477212156e-7, 3.6705042489529286e-7, 
     3.432057064955879e-7, 3.2131548685480697e-7, 3.011875407370784e-7, 
     2.8265158416902514e-7, 2.655564357036273e-7, 2.4976758670382273e-7, 
     2.3516511590243586e-7, 2.2164189463193042e-7, 2.0910203819085137e-7, 
     1.9745956623248022e-7, 1.8663724114795183e-7, 1.7656555842672112e-7, 
     1.6718186711539068e-7, 1.584296019241581e-7, 1.502576113788827e-7, 
     1.4261956879091327e-7, 1.3547345480104757e-7, 1.2878110191691787e-7, 
     1.2250779286046894e-7, 1.1662190571945929e-7, 1.1109459989124368e-7, 
     1.058995376489677e-7, 1.0101263687477694e-7, 9.641185111241124e-8, 
     9.207697360969944e-8, 8.79894624641786e-8, 8.413228436412035e-8, 
     8.048977474247457e-8, 7.704751244084538e-8, 7.379220722146882e-8, 
     7.071159867302816e-8, 6.779436523587962e-8, 6.503004222795106e-8, 
     6.240894788768095e-8, 5.992211656780371e-8, 5.756123831604569e-8, 
     5.531860416798209e-8, 5.3187056555214635e-8, 5.115994430019361e-8, 
     4.9231081728742224e-8, 4.7394711483758746e-8, 4.56454706696453e-8, 
     4.397835999755877e-8, 4.238871563731947e-8, 4.0872183513354044e-8, 
     3.942469580992605e-8, 3.804244947557448e-8, 3.672188653853898e-8, 
     3.5459676064341295e-8};
 
  TVIL_REAL Gx0yxytableALx[] = 
     {0, 0.33876648328794345, 0.16976106526643028, 
      0.0037065972222222222, -0.0020727705144557825, -0.0015045352089041635, 
     -0.0009132361719895646, -0.0005630390865190855, -0.00036198007044654153, 
     -0.0002427342211048441, -0.00016895592219958968, 
     -0.00012142539108080707, -0.00008968220312917362, 
     -0.00006780600130796634, -0.00005231214446697566, 
     -0.00004107393297164025, -0.000032750360490655755, 
     -0.000026470832397645758, -0.000021655260748549056, 
     -0.00001790803780398347, -0.000014953685060319989, 
     -0.000012596740889226701, -0.00001069614484769684, 
     -9.148516089974819e-6, -7.87701704740921e-6, -6.823799951596916e-6, 
     -5.944796943055559e-6, -5.206070863875069e-6, -4.581222667003032e-6, 
     -4.04952516795563e-6, -3.594563201399152e-6, -3.2032315019527807e-6, 
     -2.8649883838080144e-6, -2.57129442933699e-6, -2.3151864190908107e-6, 
     -2.090951113900498e-6, -1.8938734536587974e-6, 
     -1.7200407069853633e-6, -1.5661890384835607e-6, 
     -1.4295824864273263e-6, -1.3079168885286257e-6, 
     -1.1992431465998483e-6, -1.101905581945423e-6, 
     -1.0144921409811012e-6, -9.357939623583186e-7, -8.647723818382015e-7, 
     -8.005318786854472e-7, -7.422977930130092e-7, -6.893978931406682e-7, 
     -6.412470645366728e-7, -5.973345412193222e-7, -5.572132169363786e-7, 
     -5.204906647284304e-7, -4.868215654130425e-7, -4.559013024793931e-7, 
     -4.274605261869072e-7, -4.012605258601502e-7, -3.770892784203136e-7, 
     -3.547580646001307e-7, -3.340985632248911e-7, -3.1496034932019783e-7, 
     -2.9720873434200476e-7, -2.8072289707847545e-7, -2.65394262190336e-7, 
     -2.5112509028876457e-7, -2.378272491778057e-7, 
     -2.2542114063584312e-7, -2.13834761057511e-7, -2.0300287756819818e-7, 
     -1.9286630397485304e-7, -1.833712632237871e-7, 
     -1.7446882497559748e-7, -1.6611440854194846e-7, 
     -1.5826734281014045e-7, -1.5089047595127602e-7, 
     -1.4394982870108975e-7, -1.374142858477395e-7, 
     -1.3125532128173488e-7, -1.2544675257933615e-7, 
     -1.199645216185192e-7, -1.1478649817958443e-7, -1.09892303872063e-7, 
     -1.0526315406527585e-7, -1.0088171578972638e-7, -9.6731979827195e-8, 
     -9.279914542462624e-8, -8.90695162554596e-8, -8.553040641601535e-8, 
     -8.217005538735712e-8, -7.897755101764425e-8, -7.594275968885968e-8, 
     -7.305626292708326e-8, -7.030929979900064e-8, -6.769371451065576e-8, 
     -6.520190868891084e-8, -6.282679788282341e-8, -6.056177187217801e-8, 
     -5.8400658414575205e-8, -5.633769010152386e-8, 
     -5.4367474028540225e-8, -5.248496401488694e-8};
 
  TVIL_REAL Gx0yxytableALy[] = 
     {0, 0.75, -0.09510828748865252, -0.0009982638888888888, 
     0.0022798859126984127, 0.0015271826504039115, 0.0009162495840119771, 
     0.0005634902698837554, 0.0003620531232039889, 0.0002427467341398443, 
     0.00016895815939105936, 0.00012142580487453685, 0.00008968228180890693, 
     0.00006780601661572868, 0.000052312147503531894, 0.00004107393358407468, 
     0.00003275036061596392, 0.000026470832423608842, 
     0.000021655260753988384, 0.000017908037805134296, 
     0.000014953685060565628, 0.00001259674088927955, 
     0.000010696144847708291, 9.148516089977318e-6, 7.877017047409758e-6, 
     6.823799951597038e-6, 5.944796943055586e-6, 5.206070863875075e-6, 
     4.581222667003034e-6, 4.04952516795563e-6, 3.5945632013991525e-6, 
     3.203231501952781e-6, 2.8649883838080144e-6, 2.57129442933699e-6, 
     2.3151864190908107e-6, 2.090951113900498e-6, 1.8938734536587976e-6, 
     1.720040706985363e-6, 1.5661890384835607e-6, 1.429582486427326e-6, 
     1.3079168885286257e-6, 1.1992431465998483e-6, 1.101905581945423e-6, 
     1.0144921409811012e-6, 9.357939623583185e-7, 8.647723818382016e-7, 
     8.005318786854471e-7, 7.422977930130092e-7, 6.893978931406681e-7, 
     6.412470645366727e-7, 5.973345412193222e-7, 5.572132169363786e-7, 
     5.204906647284304e-7, 4.868215654130426e-7, 4.559013024793931e-7, 
     4.2746052618690724e-7, 4.0126052586015024e-7, 3.770892784203136e-7, 
     3.547580646001307e-7, 3.3409856322489104e-7, 3.1496034932019783e-7, 
     2.9720873434200476e-7, 2.8072289707847545e-7, 2.6539426219033606e-7, 
     2.511250902887646e-7, 2.378272491778057e-7, 2.2542114063584314e-7, 
     2.1383476105751098e-7, 2.0300287756819824e-7, 1.9286630397485304e-7, 
     1.8337126322378712e-7, 1.7446882497559746e-7, 1.6611440854194849e-7, 
     1.5826734281014047e-7, 1.5089047595127602e-7, 1.4394982870108973e-7, 
     1.374142858477395e-7, 1.3125532128173488e-7, 1.2544675257933615e-7, 
     1.1996452161851922e-7, 1.1478649817958442e-7, 1.09892303872063e-7, 
     1.0526315406527585e-7, 1.0088171578972637e-7, 9.673197982719498e-8, 
     9.279914542462623e-8, 8.906951625545959e-8, 8.553040641601534e-8, 
     8.217005538735712e-8, 7.897755101764423e-8, 7.594275968885966e-8, 
     7.305626292708326e-8, 7.030929979900064e-8, 6.769371451065576e-8, 
     6.520190868891084e-8, 6.282679788282343e-8, 6.056177187217801e-8, 
     5.8400658414575205e-8, 5.633769010152386e-8, 5.436747402854023e-8, 
     5.248496401488694e-8};
 
  TVIL_REAL Gx0yxytableALx2[] = 
     {0, 0., 0.10416666666666667, 0.015885416666666666, 
     0.004175967261904762, 0.0015117342509920635, 0.000679445473146645, 
     0.0003544363148244984, 0.00020524870874297143, 0.0001281995537874884, 
     0.00008476840082174851, 0.00005859674999191242, 0.00004197574538981773, 
     0.00003096310063927083, 0.000023406526467262383, 
     0.000018066586500149526, 0.000014197124428825355, 
     0.000011331742567656145, 9.169351071629946e-6, 7.510050629874213e-6, 
     6.21781850037252e-6, 5.198059470557961e-6, 4.383698691126656e-6, 
     3.7263391455871093e-6, 3.190506924855699e-6, 2.749826702315412e-6, 
     2.384431282562461e-6, 2.0791764433213708e-6, 1.8223911466534406e-6, 
     1.6049897878757626e-6, 1.4198331321949807e-6, 1.2612625620864726e-6, 
     1.1247567293426874e-6, 1.0066757364982103e-6, 9.04068635074444e-7, 
     8.145272213513574e-7, 7.36074027481414e-7, 6.670758086206534e-7, 
     6.061762090145834e-7, 5.522429759032985e-7, 5.043262954548625e-7, 
     4.616256950011262e-7, 4.2346358961262754e-7, 3.8926401665783087e-7, 
     3.5853544684809897e-7, 3.308568176620441e-7, 3.058661285627675e-7, 
     2.832510839332735e-7, 2.6274138131393187e-7, 2.4410232816063074e-7, 
     2.2712953641489075e-7, 2.1164449545036798e-7, 1.9749086396814115e-7, 
     1.8453135279580353e-7, 1.726450952866929e-7, 1.617254216156524e-7, 
     1.5167796886716015e-7, 1.4241907128259033e-7, 1.3387438504607538e-7, 
     1.259777100607371e-7, 1.1866997770090768e-7, 1.1189837883487053e-7, 
     1.0561561074222735e-7, 9.977922509350673e-8, 9.435106206978525e-8, 
     8.929675809806047e-8, 8.458531666039643e-8, 8.018873327862565e-8, 
     7.608166714354627e-8, 7.224115299796928e-8, 6.864634783693794e-8, 
     6.52783077886292e-8, 6.211979121242865e-8, 5.915508461812477e-8, 
     5.636984848984139e-8, 5.375098050478118e-8, 5.128649398207855e-8, 
     4.896540969095197e-8, 4.67776593980958e-8, 4.47139997486553e-8, 
     4.2765935258843094e-8, 4.092564935599458e-8, 3.918594253756926e-8, 
     3.7540176837587035e-8, 3.598222589002011e-8, 3.4506429966078034e-8, 
     3.310755543809626e-8, 3.1780758188535195e-8, 3.0521550539827004e-8, 
     2.9325771330671568e-8, 2.818955880789904e-8, 2.7109326041053794e-8, 
     2.6081738600154694e-8, 2.510369426628381e-8, 2.417230457029389e-8, 
     2.3284877977470436e-8, 2.2438904555838362e-8, 2.1632041983312096e-8, 
     2.0862102764348808e-8, 2.012704254043582e-8, 1.942494939084756e-8};
 
  TVIL_REAL Gx0yxytableALxLy[] = 
     {0, -0.75, -0.16666666666666666, -0.02890625, 
     -0.008017113095238095, -0.0029742528521825395, -0.0013507353106962483, 
     -0.0007074185647794046, -0.0004102248967666448, -0.0002563461234890813, 
     -0.00016952620514749687, -0.00011719133253605164, 
     -0.00008395103922896228, -0.00006192610575825924, 
     -0.00004681303246589573, -0.000036133168565429594, 
     -0.00002839424788752302, -0.000022663484921313536, 
     -0.000018338702095704616, -0.00001502010124911106, 
     -0.000012435636998351633, -0.000010396118940574556, 
     -8.767397382130273e-6, -7.4526782911461335e-6, -6.381013849704961e-6, 
     -5.499653404629344e-6, -4.76886256512458e-6, -4.158352886642663e-6, 
     -3.6447822933068625e-6, -3.2099795757515206e-6, 
     -2.8396662643899605e-6, -2.5225251241729447e-6, 
     -2.2495134586853747e-6, -2.0133514729964206e-6, 
     -1.808137270148888e-6, -1.6290544427027145e-6, -1.472148054962828e-6, 
     -1.334151617241307e-6, -1.2123524180291667e-6, -1.104485951806597e-6, 
     -1.0086525909097248e-6, -9.232513900022524e-7, -8.469271792252551e-7, 
     -7.785280333156617e-7, -7.170708936961978e-7, -6.617136353240882e-7, 
     -6.117322571255351e-7, -5.665021678665469e-7, -5.254827626278638e-7, 
     -4.882046563212615e-7, -4.542590728297815e-7, -4.232889909007359e-7, 
     -3.949817279362823e-7, -3.6906270559160705e-7, -3.452901905733858e-7, 
     -3.2345084323130483e-7, -3.033559377343203e-7, -2.848381425651806e-7, 
     -2.6774877009215076e-7, -2.5195542012147426e-7, 
     -2.3733995540181536e-7, -2.2379675766974103e-7, 
     -2.112312214844547e-7, -1.9955845018701348e-7, 
     -1.8870212413957053e-7, -1.785935161961209e-7, 
     -1.6917063332079286e-7, -1.6037746655725133e-7, 
     -1.5216333428709256e-7, -1.4448230599593856e-7, 
     -1.3729269567387587e-7, -1.305566155772584e-7, -1.242395824248573e-7, 
     -1.1831016923624954e-7, -1.1273969697968278e-7, 
     -1.0750196100956238e-7, -1.025729879641571e-7, -9.793081938190395e-8, 
     -9.35553187961916e-8, -8.942799949731061e-8, -8.55318705176862e-8, 
     -8.185129871198918e-8, -7.837188507513853e-8, -7.508035367517406e-8, 
     -7.196445178004021e-8, -6.901285993215605e-8, -6.621511087619252e-8, 
     -6.356151637707039e-8, -6.104310107965401e-8, -5.865154266134313e-8, 
     -5.637911761579808e-8, -5.4218652082107594e-8, -5.216347720030939e-8, 
     -5.020738853256762e-8, -4.834460914058778e-8, -4.656975595494087e-8, 
     -4.4877809111676723e-8, -4.326408396662419e-8, 
     -4.1724205528697616e-8, -4.025408508087163e-8, -3.884989878169512e-8};
 
  TVIL_REAL Gx0yxytableALy2[] = 
     {0, 0., 0.0625, 0.013020833333333334, 0.003841145833333333, 
     0.0014625186011904762, 0.0006712898375496032, 0.0003529822499549062, 
     0.00020497618802367337, 0.00012814656970159288, 0.00008475780432574835, 
     0.00005859458254413922, 0.000041975293839144555, 
     0.000030963005118988405, 0.00002340650599863335, 0.00001806658206528007, 
     0.000014197123458697668, 0.000011331742353657393, 9.169351024074667e-6, 
     7.510050619236847e-6, 6.217818497979113e-6, 5.198059470016595e-6, 
     4.383698691003618e-6, 3.7263391455590246e-6, 3.1905069248492622e-6, 
     2.7498267023139316e-6, 2.384431282562119e-6, 2.079176443321292e-6, 
     1.8223911466534222e-6, 1.6049897878757584e-6, 1.4198331321949796e-6, 
     1.2612625620864721e-6, 1.1247567293426874e-6, 1.0066757364982103e-6, 
     9.040686350744439e-7, 8.145272213513574e-7, 7.36074027481414e-7, 
     6.670758086206534e-7, 6.061762090145834e-7, 5.522429759032985e-7, 
     5.043262954548625e-7, 4.616256950011262e-7, 4.2346358961262754e-7, 
     3.8926401665783087e-7, 3.585354468480989e-7, 3.308568176620441e-7, 
     3.0586612856276753e-7, 2.832510839332735e-7, 2.6274138131393187e-7, 
     2.4410232816063074e-7, 2.2712953641489072e-7, 2.1164449545036798e-7, 
     1.9749086396814115e-7, 1.8453135279580353e-7, 1.726450952866929e-7, 
     1.6172542161565242e-7, 1.5167796886716015e-7, 1.4241907128259033e-7, 
     1.3387438504607538e-7, 1.259777100607371e-7, 1.1866997770090768e-7, 
     1.1189837883487052e-7, 1.0561561074222735e-7, 9.977922509350671e-8, 
     9.435106206978524e-8, 8.929675809806045e-8, 8.458531666039643e-8, 
     8.018873327862567e-8, 7.608166714354628e-8, 7.224115299796928e-8, 
     6.864634783693794e-8, 6.52783077886292e-8, 6.211979121242865e-8, 
     5.915508461812477e-8, 5.636984848984139e-8, 5.375098050478118e-8, 
     5.128649398207855e-8, 4.896540969095197e-8, 4.67776593980958e-8, 
     4.471399974865531e-8, 4.2765935258843094e-8, 4.092564935599458e-8, 
     3.918594253756927e-8, 3.754017683758703e-8, 3.598222589002011e-8, 
     3.4506429966078034e-8, 3.3107555438096255e-8, 3.17807581885352e-8, 
     3.0521550539827004e-8, 2.9325771330671565e-8, 2.818955880789904e-8, 
     2.7109326041053794e-8, 2.6081738600154697e-8, 2.5103694266283802e-8, 
     2.4172304570293894e-8, 2.3284877977470436e-8, 2.243890455583836e-8, 
     2.1632041983312096e-8, 2.0862102764348808e-8, 2.012704254043582e-8, 
     1.942494939084756e-8};
 
  TVIL_REAL Gx0yxytableC[] = 
     {0, -0.26086629990922017, -0.007305142246744556, 
     0.03232371309809767, 0.024895079196020048, 0.01951499902390133, 
     0.01576961179659593, 0.013061115243769725, 0.011035384424821153, 
     0.009477269698113695, 0.008250341497667256, 0.007264790857829662, 
     0.006459554296532416, 0.005791924749564505, 0.005231284808001949, 
     0.0047552003013862955, 0.004346912657695608, 0.003993686193549693, 
     0.0036856927273864644, 0.0034152425524567286, 0.0031762438615635102, 
     0.0029638160345256855, 0.002774008544371716, 0.0026035936375308905, 
     0.0024499113724534075, 0.0023107523656901007, 0.0021842680627320032, 
     0.0020689013524410136, 0.0019633323918205967, 0.0018664359254985507, 
     0.001777247378891558, 0.001694935710621872, 0.0016187815176582944, 
     0.0015481592557471339, 0.0014825227086848487, 0.0014213930408644455, 
     0.0013643489177941615, 0.0013110182926552158, 0.0012610715431872043, 
     0.0012142157092664635, 0.0011701896325470602, 0.0011287598391738042, 
     0.0010897170375843033, 0.001052873127822116, 0.001018058638104391, 
     0.0009851205197693507, 0.0009539202440404428, 0.0009243321539476922, 
     0.0008962420327527296, 0.0008695458567256472, 0.00084414870542566, 
     0.0008199638069825025, 0.000796911699449598, 0.0007749194922516351, 
     0.0007539202141957982, 0.0007338522365514175, 0.0007146587614021444, 
     0.0006962873668981732, 0.0006786896022323479, 0.0006618206261724048, 
     0.0006456388838342432, 0.0006301058171042932, 0.0006151856047338471, 
     0.000600844928652631, 0.0005870527634971104, 0.0005737801867332728, 
     0.0005610002070837485, 0.0005486876092534788, 0.0005368188131935859, 
     0.0005253717463554702, 0.0005143257275713234, 0.0005036613613572192, 
     0.0004933604415742724, 0.00048340586350490745, 0.00047378154350749503, 
     0.0004644723455056684, 0.0004554640136502654, 0.0004467431105635647, 
     0.0004382969606386688, 0.00043011359792259965, 0.00042218171816085, 
     0.00041449063462471345, 0.00040703023738126185, 0.00039979095570011336, 
     0.0003927637233215428, 0.0003859399463375839, 0.0003793114734619335, 
     0.00037287056848599653, 0.00036660988473768757, 0.00036052244137684854, 
     0.0003546016013765787, 0.0003488410510536378, 0.00034323478102353576, 
     0.0003377770684671287, 0.0003324624606056048, 0.0003272857592898498, 
     0.0003222420066183848, 0.0003173264715054737, 0.0003125346371277008, 
     0.0003078621891834032, 0.0003033050049048216};
 
  TVIL_REAL Gx0yxytableCLx[] = 
     {0, 0.46376648328794345, 0.14719162082198586, 
     0.06568885450537829, 0.04625014782347816, 0.034755375838289436, 
     0.02721331596306588, 0.022001278469995448, 0.018243079465450125, 
     0.015435831198314626, 0.013276839047314259, 0.011575690859494978, 
     0.010207791460454323, 0.009088757980472137, 0.008159710270999845, 
     0.0073784848084864595, 0.006714198443868861, 0.006143777233007191, 
     0.0056496770389135465, 0.005218348903411666, 0.004839182543391581, 
     0.004503764310975818, 0.004205346539238421, 0.003938461815172106, 
     0.0036986384118746496, 0.003482187492062982, 0.0032860419985077296, 
     0.0031076332809031326, 0.0029447956237396095, 0.00279569164495348, 
     0.0026587534759222944, 0.002532635994652848, 0.002416179351050587, 
     0.0023083787183328865, 0.0022083597099483597, 0.002115358272473528, 
     0.0020287041401718183, 0.001947807142866939, 0.001872145814254466, 
     0.0018012578660843849, 0.0017347321843666948, 0.0016722020738199617, 
     0.001613339531271569, 0.001557850371367923, 0.0015054700615418186, 
     0.0014559601497928796, 0.0014091051900338965, 0.00136471008673184, 
     0.0013225977942368673, 0.001282607317245295, 0.0012445919678239813, 
     0.0012084178417545047, 0.001173962482964696, 0.0011411137097609692, 
     0.0011097685806615769, 0.001079832481020401, 0.0010512183144522674, 
     0.0010238457854274685, 0.0009976407613783071, 0.0009725347043212118, 
     0.0009484641633986149, 0.0009253703209297303, 0.0009031985855646623, 
     0.0008818982269915676, 0.000861422047376243, 0.000841726085337606, 
     0.0008227693487976803, 0.0008045135735047187, 0.0007869230044244514, 
     0.0007699641975367805, 0.0007536058398715031, 0.0007378185858736759, 
     0.0007225749084126224, 0.000707848962943181, 0.000693616463497612, 
     0.0006798545693350859, 0.0006665417812057742, 0.000653657846300735, 
     0.0006411836710591829, 0.000629101241093142, 0.000617393547567483, 
     0.0006060445194422638, 0.0005950389610453065, 0.0005843624944970009, 
     0.0005740015065573429, 0.0005639430995078882, 0.0005541750457193023, 
     0.0005446857455890713, 0.0005354641885641861, 0.0005264999169906549, 
     0.0005177829925559142, 0.000509303965111898, 0.0005010538436860132, 
     0.0004930240695047528, 0.00048520649087043584, 0.0004775933397457241, 
     0.0004701772099133725, 0.00046295103659018517, 0.00045590807738460034, 
     0.0004490418944967494, 0.00044234633806838344};
 
  TVIL_REAL Gx0yxytableCLy[] = 
     {0, -0.07246703342411309, -0.14968337917801414, 
     -0.09167431701672576, -0.0670754802958481, -0.05127999441964286, 
     -0.040648378748907324, -0.033175624466357405, -0.02771474706774346, 
     -0.023591091663779377, -0.02039122903388003, -0.01785115149448827, 
     -0.015795870035213197, -0.014105554482306947, -0.01269578914626704, 
     -0.01150562268113026, -0.01049008717539027, -0.009615371723977554, 
     -0.008855623857895218, -0.00819077842105958, -0.007605051938304142, 
     -0.007085878188969769, -0.006623142504938203, -0.006208622213090969, 
     -0.005835571819012429, -0.005498411437133676, -0.005192489941760031, 
     -0.004913902918438408, -0.004659351301550838, -0.0044260305634475075, 
     -0.004211543087244087, -0.0040138283049540495, -0.00383110657346249, 
     -0.003661833764633386, -0.0035046642781575853, -0.0033584207254438144, 
     -0.003222068934386697, -0.003094697226260928, -0.002975499144160243, 
     -0.002863758986496833, -0.002758839632913491, -0.0026601722535788304, 
     -0.0025672475735985098, -0.002479608427626141, -0.002396843389751942, 
     -0.0023185813034290533, -0.0022444865678671834, -0.0021742550627311657, 
     -0.002107610613468258, -0.002044301916184975, -0.0019840998545018087, 
     -0.0019267951518556346, -0.0018721963117830252, -0.0018201278061874314, 
     -0.001770428477773314, -0.0017229501279623883, -0.0016775562658842098, 
     -0.0016341209976100143, -0.0015925280377996882, -0.0015526698284576185, 
     -0.0015144467516257638, -0.0014777664246481644, -0.0014425430681746616, 
     -0.0014086969383775927, -0.0013761538159702835, -0.00134484454557079, 
     -0.0013147046197735529, -0.001285673802996438, -0.001257695790778356, 
     -0.0012307179007279394, -0.0012046907917787047, -0.0011795682088010782, 
     -0.0011553067499651892, -0.0011318656545477616, -0.00110920660913793, 
     -0.001087293570425591, -0.0010660926029565005, -0.0010455717304144146, 
     -0.001025700799145568, -0.0010064513527772907, -0.000987796516903115, 
     -0.0009697108929132728, -0.0009521704601438512, -0.0009351524856015466, 
     -0.000918635440595309, -0.0009025989236722649, -0.0008870235893142206, 
     -0.0008718910819035656, -0.0008571839745143406, -0.0008428857121261918, 
     -0.0008289805588965297, -0.0008154535491599168, -0.0008022904418539629, 
     -0.0007894776780982221, -0.0007770023416770538, -0.0007648521221994775, 
     -0.0007530152807289477, -0.0007414806176939301, -0.0007302374429064289, 
     -0.0007192755475302825, -0.0007085851778543907};
 
  TVIL_REAL Gx0yxytableCLx2[] = 
     {0, 0., 0.0625, 0.0390625, 0.024088541666666668, 
     0.016520182291666668, 0.01221923828125, 0.009514363606770833, 
     0.007682909284319197, 0.006374100276402065, 0.005399928395710294, 
     0.0046514379599737745, 0.004061502263401494, 0.003586701581101397, 
     0.003197817047438686, 0.0028745304406308883, 0.0026023165380970343, 
     0.002370542728442427, 0.0021712646343397687, 0.0019984390245555697, 
     0.0018473954989844663, 0.0017144734397051098, 0.0015967672805345331, 
     0.0014919444230299989, 0.0013981128876448586, 0.0013137236511153835, 
     0.0012374975837041195, 0.0011683701010917437, 0.0011054487518574396, 
     0.0010479803723703982, 0.0009953254017666146, 0.0009469376140529813, 
     0.0009023479902233954, 0.0008611517841722874, 0.0008229980740841088, 
     0.0007875812639320422, 0.0007546341267841866, 0.0007239220758848644, 
     0.0006952384200620632, 0.0006684004133186488, 0.0006432459490520634, 
     0.0006196307804875132, 0.0005974261729755437, 0.0005765169125314392, 
     0.000556799609660633, 0.0005381812490724593, 0.0005205779450464995, 
     0.0005039138695188956, 0.00048812032580843376, 0.0004731349456159723, 
     0.0004589009907458307, 0.0004453667440997812, 0.00043248497702772187, 
     0.00042021248219699256, 0.00040850966285347923, 0.0003973401707623679, 
     0.0003866705862904105, 0.00037647013506932823, 0.00036671043649713484, 
     0.00035736528001937363, 0.0003484104257086849, 0.0003398234261475309, 
     0.00033158346703059366, 0.00032367122425280186, 0.0003160687355463898, 
     0.0003087592849842527, 0.000301727298884097, 0.0002949582518342413, 
     0.00028843858172218444, 0.0002821556127852054, 0.0002760974858216108, 
     0.0002702530948045967, 0.0002646120292303758, 0.000259164521610203, 
     0.00025390139958389224, 0.00024881404219173923, 0.00024389433989366696, 
     0.0002391346579698876, 0.00023452780297730826, 0.0002300669919710256, 
     0.00022574582423119565, 0.00022155825526287075, 0.00021749857286053047, 
     0.00021356137505040224, 0.00020974154974261425, 0.0002060342559420479, 
     0.00020243490638172283, 0.0001989391514558716, 0.0001955428643417498, 
     0.0001922421272098392, 0.0001890332184315963, 0.00018591260070239697, 
     0.00018287691000494976, 0.00017992294534528993, 0.00017704765919961623, 
     0.0001742481486157641, 0.0001715216469180938, 0.00016886551596906666, 
     0.0001662772389448426, 0.00016375441358590023, 0.00016129474588700004};
 
  TVIL_REAL Gx0yxytableCLxLy[] = 
     {0, -1., -0.21875, -0.1328125, -0.0869140625, 
     -0.06232096354166667, -0.047509765625, -0.037779017857142855, 
     -0.030977176484607516, -0.02599993660336449, -0.022227448508853005, 
     -0.019287113795892846, -0.016942637857764658, -0.015037585928819463, 
     -0.013464668954471688, -0.012148092483079463, -0.011032944130414888, 
     -0.010078565503936158, -0.009254275675235828, -0.008536532952572727, 
     -0.007907004079673806, -0.007351221724038869, -0.006857632659178939, 
     -0.0064169110545813975, -0.006021455165678835, -0.005665013133590412, 
     -0.00534240112844004, -0.005049288502696555, -0.0047820322201983165, 
     -0.0045375479647062535, -0.004313208860924695, -0.004106765200153055, 
     -0.003916280299499628, -0.0037400788654558554, -0.0035767051309320277, 
     -0.003424888691676972, -0.0032835164531204806, -0.003151609460372447, 
     -0.003028303656187905, -0.002912833818082246, -0.002804520083556482, 
     -0.002702756593912232, -0.0026070018813909705, -0.0025167706979673994, 
     -0.002431627041954652, -0.002351178184290841, -0.0022750695327174424, 
     -0.002202980201108477, -0.0021346191745494534, -0.00206972197961128, 
     -0.00200804778455412, -0.001949376866656827, -0.0018935083940666692, 
     -0.001840258477946665, -0.0017894584576150913, -0.001740953387101484, 
     -0.0016946006963071488, -0.0016502690039326402, -0.0016078370626619663, 
     -0.0015671928198878883, -0.001528232579617334, -0.0014908602531859307, 
     -0.0014549866880973826, -0.0014205290657371993, -0.0013874103599323306, 
     -0.0013555588493726547, -0.0013249076778051108, -0.0012953944566798552, 
     -0.0012669609055895796, -0.0012395525264142291, -0.001213118307577319, 
     -0.0011876104552482319, -0.0011629841486968475, -0.0011391973173306132, 
     -0.0011162104372265875, -0.0010939863452177638, -0.001072490068809071, 
     -0.0010516886703879874, -0.0010315511043612583, -0.0010120480859958157, 
     -0.0009931519708712858, -0.0009748366439656318, -0.0009570774174965034, 
     -0.0009398509367303338, -0.0009231350930506559, -0.0009069089436476666, 
     -0.0008911526372538813, -0.0008758473454066918, -0.0008609751987685996, 
     -0.0008465192280805382, -0.0008324633093636426, -0.0008187921130206292, 
     -0.0008054910565200465, -0.0007925462603755129, -0.0007799445071579866, 
     -0.000767673203302475, -0.0007557203434916338, -0.0007440744774177128, 
     -0.0007327246787414537, -0.0007216605160820806, -0.0007108720258865613};
 
  TVIL_REAL Gx0yxytableCLy2[] = 
     {0, 0.125, 0.15625, 0.09375, 0.06282552083333333, 
     0.04580078125, 0.03529052734375, 0.028264654250372025, 
     0.023294267200288318, 0.019625836326962427, 0.01682752011314271, 
     0.01463567583591907, 0.012881135594363165, 0.011450884347718066, 
     0.010266851907033001, 0.009273562042448575, 0.008430627592317854, 
     0.00770802277549373, 0.007083011040896059, 0.006538093928017156, 
     0.00605960858068934, 0.005636748284333758, 0.005260865378644405, 
     0.004924966631551398, 0.004623342278033976, 0.004351289482475029, 
     0.004104903544735921, 0.0038809184016048116, 0.0036765834683408767, 
     0.003489567592335855, 0.0033178834591580803, 0.0031598275861000735, 
     0.0030139323092762318, 0.0028789270812835683, 0.002753707056847919, 
     0.00263730742774493, 0.002528882326336294, 0.0024276873844875824, 
     0.002333065236125842, 0.0022444334047635973, 0.002161274134504419, 
     0.0020831258134247185, 0.0020095757084154266, 0.0019402537854359607, 
     0.0018748274322940189, 0.0018129969352183816, 0.0017544915876709429, 
     0.0016990663315895813, 0.0016464988487410195, 0.0015965870339953079, 
     0.0015491467938082892, 0.001504010122557046, 0.0014610234170389473, 
     0.0014200459957496724, 0.0013809487947616119, 0.0013436132163391161, 
     0.0013079301100167382, 0.0012737988688633118, 0.0012411266261648315, 
     0.0012098275398685146, 0.0011798221539086491, 0.0011510368270383996, 
     0.0011234032210667888, 0.0010968578414843975, 0.001071341624385941, 
     0.0010467995643884018, 0.001023180378921014, 0.0010004362048456142, 
     0.0009785223238673953, 0.0009573969136290239, 0.0009370208217557081, 
     0.0009173573604436353, 0.0008983721194664716, 0.0008800327957204101, 
     0.0008623090376426954, 0.0008451723030260248, 0.000828595728915404, 
     0.0008125540124180999, 0.00079702330138395, 0.0007819810940247903, 
     0.0007674061466400899, 0.0007532783887027611, 0.0007395788446359729, 
     0.0007262895616799315, 0.0007133935433080417, 0.0007008746877056189, 
     0.0006887177308721585, 0.0006769081939508201, 0.0006654323344268499, 
     0.000654277100870699, 0.0006434300909320464, 0.0006328795123182323, 
     0.0006226141465150969, 0.000612623315030223, 0.0006028968479583704, 
     0.0005934250546867107, 0.00058419869657354, 0.0005752089614486461, 
     0.000566447439796611, 0.0005579061024961802, 0.0005495772799995613};
 
  TVIL_REAL Gx0yxytableCLx2Ly[] = 
     {0, 0., -0.0625, -0.03125, -0.01953125, -0.013671875, 
     -0.01025390625, -0.008056640625, -0.0065460205078125, 
     -0.00545501708984375, -0.0046367645263671875, -0.004004478454589844, 
     -0.0035039186477661133, -0.0030996203422546387, -0.002767518162727356, 
     -0.0024907663464546204, -0.0022572570014744997, -0.002058087266050279, 
     -0.0018865799938794225, -0.0017376394680468366, -0.0016073165079433238, 
     -0.0014925081859473721, -0.001390746264178233, -0.0013000454208622614, 
     -0.00121879258205837, -0.0011456650271348678, -0.001079568967877087, 
     -0.0010195929141061377, -0.0009649718651361661, -0.0009150595272842954, 
     -0.0008693065509200806, -0.0008272433307142703, -0.0007884662995870388, 
     -0.0007526269223330826, -0.000719422793406623, -0.0006885903879749107, 
     -0.0006598991218092894, -0.0006331464547089128, -0.0006081538314967189, 
     -0.0005847632995160758, -0.000562834675784223, -0.0005422431632555319, 
     -0.0005228773359964058, -0.0005046374289267636, -0.00048743388021335127, 
     -0.00047118608420623954, -0.0004558213205908187, 
     -0.00044127383163579257, -0.00042748402439717406, 
     -0.0004143977787523626, -0.0004019658453897917, -0.0003901433205253861, 
     -0.0003788891862794615, -0.0003681659074224956, -0.0003579390766607596, 
     -0.0003481771018427389, -0.00033885092947195125, 
     -0.00032993379974900517, -0.0003214010290658412, -0.0003132298164624724, 
     -0.0003053990710509106, -0.0002978892578283472, -0.00029068225965508075, 
     -0.0002837612534728169, -0.00027711059909454774, -0.0002707157391154428, 
     -0.00026456310868100093, -0.0002586400540090382, -0.0002529347587000153, 
     -0.0002474361769891454, -0.00024213397319652088, 
     -0.00023701846672053806, -0.0002320805819971935, -0.0002273118029150594, 
     -0.00022270413123434872, -0.00021825004860966175, 
     -0.00021394248186078685, -0.0002097747711751871, 
     -0.00020574064096027966, -0.00020183417309394523, 
     -0.00019804978234843376, -0.00019438219378642573, 
     -0.00019082642194886916, -0.00018737775167268478, 
     -0.00018403172039281542, -0.00018078410179764808, 
     -0.00017763089071978213, -0.00017456828915564794, 
     -0.0001715926933177676, -0.00016870068163263668, 
     -0.00016588900360542605, -0.0001631545694800619, -0.0001604944406298435, 
     -0.00015790582061968474, -0.00015538604688639188, 
     -0.00015293258298818569, -0.0001505430113789953, 
     -0.00014821502666694897, -0.00014594642932000588, 
     -0.00014373511978485427, -0.00014157909298808148};
 
  TVIL_REAL Gx0yxytableCLxLy2[] = 
     {0, 0.375, 0.125, 0.0625, 0.0390625, 0.02734375, 
     0.0205078125, 0.01611328125, 0.013092041015625, 0.0109100341796875, 
     0.009273529052734375, 0.008008956909179688, 0.0070078372955322266, 
     0.006199240684509277, 0.005535036325454712, 0.004981532692909241, 
     0.004514514002948999, 0.004116174532100558, 0.003773159987758845, 
     0.003475278936093673, 0.0032146330158866476, 0.0029850163718947442, 
     0.002781492528356466, 0.0026000908417245228, 0.00243758516411674, 
     0.0022913300542697357, 0.002159137935754174, 0.0020391858282122755, 
     0.0019299437302723321, 0.0018301190545685908, 0.0017386131018401613, 
     0.0016544866614285406, 0.0015769325991740776, 0.0015052538446661652, 
     0.001438845586813246, 0.0013771807759498213, 0.0013197982436185787, 
     0.0012662929094178256, 0.0012163076629934377, 0.0011695265990321515, 
     0.001125669351568446, 0.0010844863265110638, 0.0010457546719928115, 
     0.0010092748578535273, 0.0009748677604267025, 0.0009423721684124791, 
     0.0009116426411816373, 0.0008825476632715851, 0.0008549680487943481, 
     0.0008287955575047252, 0.0008039316907795834, 0.0007802866410507722, 
     0.000757778372558923, 0.0007363318148449912, 0.0007158781533215192, 
     0.0006963542036854778, 0.0006777018589439025, 0.0006598675994980103, 
     0.0006428020581316825, 0.0006264596329249448, 0.0006107981421018212, 
     0.0005957785156566944, 0.0005813645193101615, 0.0005675225069456338, 
     0.0005542211981890955, 0.0005414314782308857, 0.0005291262173620019, 
     0.0005172801080180764, 0.0005058695174000306, 0.0004948723539782908, 
     0.00048426794639304176, 0.0004740369334410761, 0.000464161163994387, 
     0.0004546236058301188, 0.00044540826246869744, 0.0004365000972193235, 
     0.0004278849637215737, 0.0004195495423503742, 0.0004114812819205593, 
     0.00040366834618789046, 0.0003960995646968675, 0.00038876438757285146, 
     0.0003816528438977383, 0.00037475550334536956, 0.00036806344078563083, 
     0.00036156820359529616, 0.00035526178143956426, 0.0003491365783112959, 
     0.0003431853866355352, 0.00033740136326527336, 0.0003317780072108521, 
     0.0003263091389601238, 0.000320988881259687, 0.0003158116412393695, 
     0.00031077209377278377, 0.00030586516597637137, 0.0003010860227579906, 
     0.00029643005333389793, 0.00029189285864001177, 0.00028747023956970854, 
     0.00028315818597616295};
 
  TVIL_REAL Gx0yxytableCLy3[] = 
     {0, -0.25, -0.0625, -0.03125, -0.01953125, -0.013671875, 
     -0.01025390625, -0.008056640625, -0.0065460205078125, 
     -0.00545501708984375, -0.0046367645263671875, -0.004004478454589844, 
     -0.0035039186477661133, -0.0030996203422546387, -0.002767518162727356, 
     -0.0024907663464546204, -0.0022572570014744997, -0.002058087266050279, 
     -0.0018865799938794225, -0.0017376394680468366, -0.0016073165079433238, 
     -0.0014925081859473721, -0.001390746264178233, -0.0013000454208622614, 
     -0.00121879258205837, -0.0011456650271348678, -0.001079568967877087, 
     -0.0010195929141061377, -0.0009649718651361661, -0.0009150595272842954, 
     -0.0008693065509200806, -0.0008272433307142703, -0.0007884662995870388, 
     -0.0007526269223330826, -0.000719422793406623, -0.0006885903879749107, 
     -0.0006598991218092894, -0.0006331464547089128, -0.0006081538314967189, 
     -0.0005847632995160758, -0.000562834675784223, -0.0005422431632555319, 
     -0.0005228773359964058, -0.0005046374289267636, -0.00048743388021335127, 
     -0.00047118608420623954, -0.0004558213205908187, 
     -0.00044127383163579257, -0.00042748402439717406, 
     -0.0004143977787523626, -0.0004019658453897917, -0.0003901433205253861, 
     -0.0003788891862794615, -0.0003681659074224956, -0.0003579390766607596, 
     -0.0003481771018427389, -0.00033885092947195125, 
     -0.00032993379974900517, -0.0003214010290658412, -0.0003132298164624724, 
     -0.0003053990710509106, -0.0002978892578283472, -0.00029068225965508075, 
     -0.0002837612534728169, -0.00027711059909454774, -0.0002707157391154428, 
     -0.00026456310868100093, -0.0002586400540090382, -0.0002529347587000153, 
     -0.0002474361769891454, -0.00024213397319652088, 
     -0.00023701846672053806, -0.0002320805819971935, -0.0002273118029150594, 
     -0.00022270413123434872, -0.00021825004860966175, 
     -0.00021394248186078685, -0.0002097747711751871, 
     -0.00020574064096027966, -0.00020183417309394523, 
     -0.00019804978234843376, -0.00019438219378642573, 
     -0.00019082642194886916, -0.00018737775167268478, 
     -0.00018403172039281542, -0.00018078410179764808, 
     -0.00017763089071978213, -0.00017456828915564794, 
     -0.0001715926933177676, -0.00016870068163263668, 
     -0.00016588900360542605, -0.0001631545694800619, -0.0001604944406298435, 
     -0.00015790582061968474, -0.00015538604688639188, 
     -0.00015293258298818569, -0.0001505430113789953, 
     -0.00014821502666694897, -0.00014594642932000588, 
     -0.00014373511978485427, -0.00014157909298808148};
 
  TVIL_REAL Gx0yxytableB[] = 
     {8.751507168460932, 39.01679330540531, 7.804961923145032, 
     -2.416747298792531, 1.2757449243320103, -0.7940812864240877, 
     0.5410318271099598, -0.3913084517998365, 0.29547428982513474, 
     -0.23053521688505227, 0.18457020015913722, -0.1508906193766732, 
     0.12550793612875652, -0.10592498909007524, 0.0905145436505955, 
     -0.07818010596454696, 0.06816143789824881, -0.05991831250604587, 
     0.053058520768596455, -0.047291889870288296, 0.04240011203447841, 
     -0.03821646999163243, 0.0346119204934165, -0.03148535841399003, 
     0.028756687586750148, -0.026361811821224653, 0.024248962231435023, 
     -0.022375969164923213, 0.02070821145568135, -0.019217057778148517, 
     0.017878669896101512, -0.01667307505933088, 0.015583440670358367, 
     -0.01459550244578553, 0.013697110120304572, -0.012877863929761747, 
     0.012128821764114494, -0.011442261748956609, 0.010811488608828511, 
     -0.010230674843434649, 0.0096947297596221, -0.009199190925209945, 
     0.008740133772745148, -0.008314095973952544, 0.00791801389606395, 
     -0.0075491689885975695, 0.00720514236997362, -0.006883776214788855, 
     0.006583140805054327, -0.0063015063176681185, 0.006037318587595182, 
     -0.005789178220652017, 0.005555822538367324, -0.005336109925470262, 
     0.005129006222316194, -0.004933572863258485, 0.004748956510178485, 
     -0.004574379970119619, 0.004409134218842279, -0.004252571379404146, 
     0.004104098527599976, -0.0039631722150886214, 0.0038292936169567137, 
     -0.0037020042238552066, 0.003580882010133287, -0.003465538018939788, 
     0.003355613313356279, -0.003250776249507295, 0.003150720033458409, 
     -0.0030551605287244413, 0.002963834285502575, -0.002876496766430276, 
     0.0027929207468387588, -0.002712894870207096, 0.002636222341885001, 
     -0.002562719746198569, 0.002492215973828777, -0.002424551247896216, 
     0.002359576238530153, -0.0022971512568734542, 0.0022371455205007613, 
     -0.0021794364831257715, 0.002123909222261661, -0.0020704558791913214, 
     0.002018975146213722, -0.0019693717966701436, 0.001921556253728572, 
     -0.0018754441943241349, 0.0018309561850250852, -0.0017880173469233705, 
     0.0017465570469415099, -0.0017065086132077747, 0.0016678090723834553, 
     -0.0016303989070326572, 0.0015942218313096063, -0.0015592245834033722, 
     0.0015253567333275726, -0.0014925705047749028, 0.001460820609875031, 
     -0.0014300640958010056, 0.0014002602022651805};
 
  TVIL_REAL Gx0yxytableBL[] = 
     {26.047061595422754, 11.12196934962815, 0.060236592639416386, 
     0.83382603125595, -0.5792536067288443, 0.4006170726148297, 
     -0.2896553718493917, 0.218166449904722, -0.16989244653565094, 
     0.1359082857664532, -0.11113299439538593, 0.0925367032440314, 
     -0.07823222818335873, 0.0669980637764993, -0.05801671006962339, 
     0.0507249358053532, -0.04472474054085107, 0.03972856262662061, 
     -0.03552451707261328, 0.031953734154359204, -0.02889522393887134, 
     0.026255545186487872, -0.023961614182821833, 0.02195560975130917, 
     -0.020191304887546835, 0.018631386523225046, -0.01724547077749783, 
     0.0160086149823897, -0.014900189385866014, 0.013903012549590699, 
     -0.01300268232467161, 0.012187053452919372, -0.011445826199810938, 
     0.010770219854890684, -0.010152711670144754, 0.009586826669959692, 
     -0.009066967313430041, 0.008588274604278467, -0.00814651418480139, 
     0.007737982408087873, -0.0073594284821183464, 0.007007989618898591, 
     -0.006681136763688755, 0.006376628978159715, -0.006092474934121128, 
     0.005826900279998881, -0.005578319877940885, 0.0053453140994861315, 
     -0.00512660851200053, 0.004921056417515501, -0.004727623794678948, 
     0.004545376265923551, -0.004373467795630859, 0.004211130853036593, 
     -0.004057667829329148, 0.003912443533408805, -0.003774878603508114, 
     0.0036444437319005374, -0.0035206545508117415, 0.0034030671340588015, 
     -0.0032912740134634078, 0.003184900648193434, -0.003083602263359353, 
     0.0029870611033402383, -0.0028949838888365775, 0.0028070995467714965, 
     -0.0027231572894379497, 0.0026429249555803835, -0.0025661868858151138, 
     0.002492743427865207, -0.002422408200800419, 0.0023550085024908185, 
     -0.0022903832141309977, 0.0022283821599557996, -0.0021688651759177446, 
     0.002111701061949134, -0.0020567672327160835, 0.002003950532525778, 
     -0.0019531422294676304, 0.0019042408093810081, -0.0018571540713310242, 
     0.0018117930740118027, -0.0017680749297142029, 0.0017259195446968079, 
     -0.0016852542757987976, 0.0016460083425045013, -0.0016081184148788452, 
     0.0015715286135673523, -0.0015361607074737549, 0.0015019625425338745, 
     -0.0014689266681671143, 0.0014369487762451172, -0.0014060139656066895, 
     0.0013760626316070557, -0.0013470351696014404, 0.0013188719749450684, 
     -0.0012917518615722656, 0.0012652873992919922, -0.0012396574020385742, 
     0.0012149810791015625, -0.0011909008026123047};
 
  TVIL_REAL Gx0yxytableBL2[] = 
     {-9.954822555520437, -2.4548225555204377, 2., 
     -0.6666666666666666, 0.3333333333333333, -0.2, 0.13333333333333333, 
     -0.09523809523809523, 0.07142857142857142, -0.05555555555555555, 
     0.044444444444444446, -0.03636363636363636, 0.030303030303030304, 
     -0.02564102564102564, 0.02197802197802198, -0.01904761904761905, 
     0.016666666666666666, -0.014705882352941176, 0.013071895424836602, 
     -0.011695906432748537, 0.010526315789473684, -0.009523809523809525, 
     0.008658008658008658, -0.007905138339920948, 0.007246376811594203, 
     -0.006666666666666667, 0.006153846153846154, -0.005698005698005698, 
     0.005291005291005291, -0.0049261083743842365, 0.004597701149425287, 
     -0.004301075268817204, 0.004032258064516129, -0.003787878787878788, 
     0.0035650623885918, -0.0033613445378151263, 0.0031746031746031746, 
     -0.003003003003003003, 0.002844950213371266, -0.002699055330634278, 
     0.002564102564102564, -0.0024390243902439024, 0.0023228803716608595, 
     -0.0022148394241417496, 0.0021141649048625794, -0.00202020202020202, 
     0.001932367149758454, -0.0018501387604070306, 0.0017730496453900709, 
     -0.0017006802721088435, 0.0016326530612244899, -0.001568627450980392, 
     0.0015082956259426848, -0.001451378809869376, 0.001397624039133473, 
     -0.0013468013468013469, 0.0012987012987012987, -0.0012531328320802004, 
     0.0012099213551119178, -0.0011689070718877848, 0.0011299435028248588, 
     -0.001092896174863388, 0.0010576414595452142, -0.0010240655401945725, 
     0.000992063492063492, -0.0009615384615384616, 0.0009324009324009324, 
     -0.0009045680687471732, 0.000877963125548727, -0.0008525149190110827, 
     0.0008281573498964803, -0.0008048289738430583, 0.000782472613458529, 
     -0.00076103500761035, 0.0007404664938911515, -0.0007207207207207207, 
     0.0007017543859649122, -0.000683526999316473, 0.000666000666000666, 
     -0.0006491398896462187, 0.0006329113924050633, -0.0006172839506172839, 
     0.0006022282445046673, -0.0005877167205406994, 0.0005737234652897303, 
     -0.0005602240896358543, 0.0005471956224350205, -0.0005346164127238706, 
     0.0005224660397074191, -0.0005107252298263534, 0.0004993757802746567, 
     -0.0004884004884004884, 0.00047778308647873863, -0.0004675081813931744, 
     0.0004575611988103409, -0.0004479283314669653, 0.0004385964912280702, 
     -0.000429553264604811, 0.00042078687144961075, -0.00041228612657184083, 
     0.00040404040404040404};
 
  TVIL_REAL Gx0yxytableD[] = 
     {0, 4.400271436338192, 1.9561832400899384, -0.6730239324642008, 
     0.34064619612793184, -0.20313505419333897, 0.13384353246948916, 
     -0.09436824234370672, 0.06987932513608862, -0.053702450439594714, 
     0.04248777201239899, -0.03440982071506609, 0.028407531197181948, 
     -0.023831216880717675, 0.020265648611118153, -0.017435725068048066, 
     0.015153517703255353, -0.013287216577980194, 0.011742224662652486, 
     -0.010449267985817065, 0.009356702115349313, -0.008425407100353074, 
     0.0076253232595554325, -0.006933052759749258, 0.006330168770229858, 
     -0.0058020037448660395, 0.00533676800811008, -0.004924899799981756, 
     0.004558579960121476, -0.004231365342926175, 0.003937908949697009, 
     -0.00367374414345217, 0.0034351167384288716, -0.003218853219897276, 
     0.0030222564899193794, -0.0028430227699514352, 0.002679174900136256, 
     -0.0025290084453433105, 0.0023910478774625344, -0.0022640107404814885, 
     0.002146778181133461, -0.0020383705868831483, 0.0019379273456898859, 
     -0.001844689950622519, 0.0017579878331433483, -0.0016772264335406207, 
     0.0016018771142746419, -0.001531468598376676, 0.001465579675338144, 
     -0.0014038329647922021, 0.0013458895664813068, -0.0012914444556286603, 
     0.0012402225075042585, -0.001191975054944511, 0.0011464768988155198, 
     -0.0011035237046586321, 0.0010629297296143318, -0.0010245258326527448, 
     0.0009881577285147107, -0.0009536844518794798, 0.0009209770033575749, 
     -0.0008899171531476702, 0.0008603963817453624, -0.0008323149400713281, 
     0.0008055810138953937, -0.0007801099795519184, 0.0007558237397362546, 
     -0.0007326501296957291, 0.0007105223854257662, -0.0006893786665889554, 
     0.0006691616278221601, -0.000649818032909214, 0.0006312984069951541, 
     -0.000613556722619635, 0.0005965501158666975, -0.000580238629377573, 
     0.0005645849793629466, -0.0005495543440896759, 0.000535114171611686, 
     -0.0005212340047717636, 0.000507885321725526, -0.0004950413904353676, 
     0.0004826771357544999, -0.00047076901787253234, 0.0004592949210271694, 
     -0.0004482340515039011, 0.00043756684404908276, -0.0004272748759132959, 
     0.0004173407878228752, -0.0004077482112492797, 0.0003984817014097259, 
     -0.0003895266754891575, 0.00038086935562406876, -0.00037249671623365143, 
     0.0003643964353238682, -0.00035655684942591123, 0.000348966911862592, 
     -0.00034161615406495463, 0.0003344946496871858, -0.0003275929812910447, 
     0.00032090220939185246};
 
  TVIL_REAL Gx0yxytableDL[] = 
     {0, 3.8280463806552705, -0.7186975871035137, 0.3784547512567268, 
     -0.21063650083781785, 0.1325539635215082, -0.0907812133818719, 
     0.06597504133110907, -0.050081017333548354, 0.03929906895301394, 
     -0.031654006962666355, 0.026038650728431183, -0.021793919644668546, 
     0.01850782208501398, -0.015912181191932946, 0.013826383874892694, 
     -0.0121252037034915, 0.010719611627940944, -0.009544914374832871, 
     0.008553190097519628, -0.007708330608154795, 0.006982712350921383, 
     -0.006354912279747046, 0.005808110049436949, -0.005328950626614264, 
     0.004906721737679481, -0.0045327503727606525, 0.004199954135742959, 
     -0.003902503650555804, 0.0036355656864668854, -0.003395105678392765, 
     0.0031777344518070915, -0.002980588196221255, 0.0028012336937385147, 
     -0.0026375929077417956, 0.0024878825406246504, -0.0023505652588650997, 
     0.002224310080932076, -0.0021079600124528928, 0.002000505452068514, 
     -0.0019010622214051575, 0.0018088533226398211, -0.001723193718035323, 
     0.0016434775726020692, -0.0015691675146693972, 0.0014997855576746758, 
     -0.001434905395870267, 0.0013741458413592603, -0.0013171652132462131, 
     0.001263656524259754, -0.0012133433378965835, 0.0011659761914268696, 
     -0.0011213294981262981, 0.0010791988567408946, -0.0010393987081332866, 
     0.0010017602888404014, -0.0009661298393152576, 0.0009323670312635057, 
     -0.0009003435839839178, 0.0008699420441926421, -0.0008410547076230891, 
     0.0008135826638830532, -0.0007874349487280155, 0.0007625277901636503, 
     -0.0007387839366938157, 0.000716132057641887, -0.0006945062068416174, 
     0.0006738453421585733, -0.0006540928942973769, 0.0006351963792006063, 
     -0.0006171070490747443, 0.0005997795777057031, -0.0005831717762667979, 
     0.0005672443362886056, -0.000551960596863884, 0.0005372863335107966, 
     -0.0005231895664218565, 0.0005096403860907904, -0.0004966107945404667, 
     0.00048407456057684257, -0.0004720070876705368, 0.00046038529322254743, 
     -0.0004491874981067135, 0.00043839332550124605, -0.0004279836081271753, 
     0.00041794030310469884, -0.0004082464137207558, 0.0003988859174740542, 
     -0.00038984369982842006, 0.0003811054931627323, -0.0003726578204567475, 
     0.0003644879432975588, -0.00035658381383195256, 0.00034893403032609674, 
     -0.00034152779602632884, 0.0003343548810437499, -0.0003274055870112622, 
     0.0003206707142849531, -0.0003141415314826255, 0.00030780974717106507, 
     -0.00030166748353055087};
 
  TVIL_REAL Gx0yxytableDL2[] = 
     {0, -2., 0.5, -0.16666666666666666, 0.08333333333333333, -0.05, 
     0.03333333333333333, -0.023809523809523808, 0.017857142857142856, 
     -0.013888888888888888, 0.011111111111111112, -0.00909090909090909, 
     0.007575757575757576, -0.00641025641025641, 0.005494505494505495, 
     -0.004761904761904762, 0.004166666666666667, -0.003676470588235294, 
     0.0032679738562091504, -0.0029239766081871343, 0.002631578947368421, 
     -0.002380952380952381, 0.0021645021645021645, -0.001976284584980237, 
     0.0018115942028985507, -0.0016666666666666668, 0.0015384615384615385, 
     -0.0014245014245014246, 0.0013227513227513227, -0.0012315270935960591, 
     0.0011494252873563218, -0.001075268817204301, 0.0010080645161290322, 
     -0.000946969696969697, 0.00089126559714795, -0.0008403361344537816, 
     0.0007936507936507937, -0.0007507507507507507, 0.0007112375533428165, 
     -0.0006747638326585695, 0.000641025641025641, -0.0006097560975609756, 
     0.0005807200929152149, -0.0005537098560354374, 0.0005285412262156448, 
     -0.000505050505050505, 0.0004830917874396135, -0.00046253469010175765, 
     0.0004432624113475177, -0.00042517006802721087, 0.00040816326530612246, 
     -0.000392156862745098, 0.0003770739064856712, -0.000362844702467344, 
     0.00034940600978336826, -0.0003367003367003367, 0.0003246753246753247, 
     -0.0003132832080200501, 0.00030248033877797946, -0.0002922267679719462, 
     0.0002824858757062147, -0.000273224043715847, 0.00026441036488630354, 
     -0.0002560163850486431, 0.000248015873015873, -0.0002403846153846154, 
     0.0002331002331002331, -0.0002261420171867933, 0.00021949078138718174, 
     -0.00021312872975277067, 0.00020703933747412008, 
     -0.00020120724346076458, 0.00019561815336463224, -0.0001902587519025875, 
     0.00018511662347278786, -0.00018018018018018018, 0.00017543859649122806, 
     -0.00017088174982911826, 0.0001665001665001665, -0.0001622849724115547, 
     0.00015822784810126583, -0.00015432098765432098, 0.00015055706112616682, 
     -0.00014692918013517486, 0.00014343086632243257, 
     -0.00014005602240896358, 0.00013679890560875513, 
     -0.00013365410318096765, 0.00013061650992685477, 
     -0.00012768130745658836, 0.00012484394506866417, -0.0001221001221001221, 
     0.00011944577161968466, -0.0001168770453482936, 0.00011439029970258523, 
     -0.00011198208286674133, 0.00010964912280701755, 
     -0.00010738831615120275, 0.00010519671786240269, 
     -0.00010307153164296021, 0.00010101010101010101};
 
  TVIL_REAL Gx0yxytableE[] = 
     {-18.70693688512331, -4.854553937928337, 1.707639005699074, 
     0.3753025778145237, -0.12768829157951597, 0.01885701196516894, 
     0.022309001672815812, -0.03695784549002777, 0.04089425239365959, 
     -0.040410493696452596, 0.03815605257702752, -0.0352921490638091, 
     0.03233544756382356, -0.029510844158004063, 0.02690738970095761, 
     -0.024550292060310792, 0.022435255309136454, -0.02054519125280379, 
     0.018858403064691085, -0.01735254138548563, 0.01600643244148591, 
     -0.014800830119532553, 0.013718629281027236, -0.012744818074722, 
     0.011866313370467138, -0.011071753533685818, 0.010351285829832423, 
     -0.009696366174688071, 0.009099578631184418, -0.008554476718701758, 
     0.008055445953126631, -0.007597585831932088, 0.007176609038941609, 
     -0.006788755596193653, 0.0064307198322554535, -0.006099588257729945, 
     0.005792786681722136, -0.005508035138574047, 0.0052433094089048594, 
     -0.004996808108065671, 0.00476692447811565, -0.004552222158075516, 
     0.004351414324144829, -0.004163345689649295, 0.003986976936481331, 
     -0.0038213712182252036, 0.0036656824322207336, -0.0035191450054066773, 
     0.0033810649784942436, -0.0032508122061914, 0.0031278135189438806, 
     -0.0030115467149032, 0.0029015352703397916, -0.002797343673122116, 
     0.0026985732977016, -0.002604858751709167, 0.0025158646341377905, 
     -0.0024312826534512266, 0.0023508290610656448, -0.0022742423617004865, 
     0.002201281267255421, -0.0021317228652815725, 0.0020653609768937022, 
     -0.002002004682213104, 0.0019414769942200044, -0.0018836136642975344, 
     0.0018282621048242077, -0.0017752804159665684, 0.0017245365053789757, 
     -0.0016759072908677716, 0.001629277977251458, -0.0015845413996716975, 
     0.0015415974265029456, -0.0015003524157892038, 0.0014607187198199954, 
     -0.001422614233057266, 0.0013859619791516248, -0.001350689733249788, 
     0.001316729676203436, -0.001284018077650083, 0.001252495005255032, 
     -0.0012221040576853642, 0.0011927921191367194, -0.001164509133455322, 
     0.0011372078960947267, -0.0011108438623220606, 0.001085374970244747, 
     -0.001060761477368025, 0.0010369658095180474, -0.001013952421076635, 
     0.0009916876655734197, -0.0009701396757704294, 0.0009492782524543313, 
     -0.0009290747612235609, 0.0009095020366223349, -0.0008905342930318593, 
     0.0008721470417816007, -0.0008543170139909091, 0.0008370220886941054, 
     -0.0008202412258408634, 0.0008039544037987487};
 
  TVIL_REAL Gx0yxytableEL[] = 
     {16.128233394887786, -0.2559561126456432, 2.5503065678940287, 
     0.6653600395183402, -0.6455812461002074, 0.49454227816751295, 
     -0.3765805067709882, 0.292759077888949, -0.2328905478200722, 
     0.18916275616404243, -0.15643929541046278, 0.13139232091386321, 
     -0.11183214508626159, 0.09628454847536712, -0.08373305214701497, 
     0.07346073417991551, -0.06495130685471918, 0.05782586682819009, 
     -0.05180153683189991, 0.046663835040257166, -0.042247841250622864, 
     0.03842511849533557, -0.035094474512582935, 0.032175332103291106, 
     -0.02960290218981144, 0.027324622133798594, -0.02529749504441682, 
     0.023486079345508223, -0.021860953524643498, 0.020397532168197174, 
     -0.019075144505706878, 0.01787631110619555, -0.016786171560843655, 
     0.0157920282313464, -0.014882979960652824, 0.014049626057522281, 
     -0.01328382557844866, 0.012578500423580507, -0.011927473375032254, 
     0.011325334174728247, -0.010767328234418715, 0.01024926371482709, 
     -0.009767433592574091, 0.009318550017333564, -0.008899688795343976, 
     0.008508242254381253, -0.008141879076112846, 0.007798509944372226, 
     -0.007476258067457547, 0.007173433800616291, -0.006888512730290293, 
     0.00662011669130085, -0.006366997277257126, 0.006128021477211071, 
     -0.0059021591312025425, 0.005688471946394517, -0.005486103856012115, 
     0.005294272536878086, -0.005112261929264392, 0.004939415626083162, 
     -0.004775131017948303, 0.004618854097020269, -0.0044700748363431355, 
     0.004328323073036612, -0.004193164833576317, 0.004064199047778911, 
     -0.003941054605247276, 0.0038233877141250266, -0.0037108795272249007, 
     0.0036032340050692817, -0.0035001759892276077, 0.003401449462650049, 
     -0.0033068159765593354, 0.003216053225939869, -0.003128953757811554, 
     0.0030453237983424425, -0.002964982186479487, 0.0028877594031942117, 
     -0.002813496686678872, 0.002742045224913063, -0.002673265417971696, 
     0.002607026203280619, -0.00254320443776113, 0.0024816843314524116, 
     -0.002422356927772642, 0.0023651196260850056, -0.0023098757426823022, 
     0.0022565341067006363, -0.0022050086878249615, 0.0021552182529624747, 
     -0.002107086049338764, 0.0020605395117202466, -0.0020155099916883664, 
     0.0019719325070894542, -0.001929745509961639, 0.001888890671399328, 
     -0.001849312681958448, 0.0018109590663338202, -0.0017737800111552802, 
     0.001737728204852884, -0.001702758688635017};
 
  TVIL_REAL Gx0yxytableEL2[] = 
     {-8.682233833280657, 0.317766166719343, 3., -1., 0.5, -0.3, 
     0.2, -0.14285714285714285, 0.10714285714285714, -0.08333333333333333, 
     0.06666666666666667, -0.05454545454545454, 0.045454545454545456, 
     -0.038461538461538464, 0.03296703296703297, -0.02857142857142857, 0.025, 
     -0.022058823529411766, 0.0196078431372549, -0.017543859649122806, 
     0.015789473684210527, -0.014285714285714285, 0.012987012987012988, 
     -0.011857707509881422, 0.010869565217391304, -0.01, 
     0.009230769230769232, -0.008547008547008548, 0.007936507936507936, 
     -0.007389162561576354, 0.006896551724137931, -0.0064516129032258064, 
     0.006048387096774193, -0.005681818181818182, 0.0053475935828877, 
     -0.005042016806722689, 0.004761904761904762, -0.0045045045045045045, 
     0.004267425320056899, -0.004048582995951417, 0.0038461538461538464, 
     -0.003658536585365854, 0.003484320557491289, -0.0033222591362126247, 
     0.003171247357293869, -0.0030303030303030303, 0.002898550724637681, 
     -0.0027752081406105457, 0.0026595744680851063, -0.002551020408163265, 
     0.0024489795918367346, -0.002352941176470588, 0.0022624434389140274, 
     -0.0021770682148040637, 0.0020964360587002098, -0.00202020202020202, 
     0.001948051948051948, -0.0018796992481203006, 0.0018148820326678765, 
     -0.0017533606078316774, 0.001694915254237288, -0.001639344262295082, 
     0.0015864621893178213, -0.0015360983102918587, 0.001488095238095238, 
     -0.0014423076923076924, 0.0013986013986013986, -0.0013568521031207597, 
     0.0013169446883230904, -0.0012787723785166241, 0.0012422360248447205, 
     -0.0012072434607645875, 0.0011737089201877935, -0.001141552511415525, 
     0.0011106997408367272, -0.001081081081081081, 0.0010526315789473684, 
     -0.0010252904989747095, 0.000999000999000999, -0.0009737098344693282, 
     0.0009493670886075949, -0.000925925925925926, 0.0009033423667570009, 
     -0.000881575080811049, 0.0008605851979345956, -0.0008403361344537816, 
     0.0008207934336525308, -0.0008019246190858059, 0.0007836990595611285, 
     -0.0007660878447395301, 0.000749063670411985, -0.0007326007326007326, 
     0.000716674629718108, -0.0007012622720897616, 0.0006863417982155113, 
     -0.0006718924972004479, 0.0006578947368421052, -0.0006443298969072165, 
     0.0006311803071744162, -0.0006184291898577613, 0.0006060606060606061};

  if (y < 0.1545 * x) {
    result = TVIL_Gx000x (x, qq);
    result += y * (-(2.L/3.L) * lnbarx3 + lnbarx2 * lnbary); 
    rn = r = 4.L * y/x;
    for (n=1; n < 100; n++) {
      result += x * rn * (Gx0yxytableA[n] +
        Gx0yxytableALx[n] * lnbarx +
        Gx0yxytableALy[n] * lnbary +
        Gx0yxytableALx2[n] * lnbarx2 + 
        Gx0yxytableALxLy[n] * lnbarx * lnbary + 
        Gx0yxytableALy2[n] * lnbary2); 
      rn *= r;
    }
  } 
  else if (y < 0.5 * x) {
    result = (x/2.L + y/3.L) * lnbary3;
    rn = 1.L;
    r = 0.25L * x/y - 1.L;
    for (n=0; n < 100; n++) {
      result += y * rn * (
        Gx0yxytableE[n] +
        Gx0yxytableEL[n] * lnbary +
        Gx0yxytableEL2[n] * lnbary2);
      rn *= r;
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_Gx0xxx (x, qq);
    result += (y-x) * lnbarx3/3.L;
    rn = r = y/x - 1.L;
    for (n=1; n < 100; n++) {
      result += x * rn * (
        Gx0yxytableD[n] +
        Gx0yxytableDL[n] * lnbarx +
        Gx0yxytableDL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else if (y < 6.47 * x) {
    result = (x/2.L + y/3.L) * lnbarx3;
    rn = 1.L;
    r = 0.25L * y/x - 1.L;
    for (n=0; n < 100; n++) {
      result += x * rn * (
        Gx0yxytableB[n] +
        Gx0yxytableBL[n] * lnbarx +
        Gx0yxytableBL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else {
    result = TVIL_G00x0x (y, qq);
    rn = r = 4.L * x/y;
    for (n=1; n < 100; n++) {
      result += y * rn * (
        Gx0yxytableC[n] +
        Gx0yxytableCLx[n] * lnbarx +
        Gx0yxytableCLy[n] * lnbary +
        Gx0yxytableCLx2[n] * lnbarx2 +
        Gx0yxytableCLxLy[n] * lnbarx * lnbary +
        Gx0yxytableCLy2[n] * lnbary2 +
        Gx0yxytableCLx2Ly[n] * lnbarx2 * lnbary +
        Gx0yxytableCLxLy2[n] * lnbarx * lnbary2 +
        Gx0yxytableCLy3[n] * lnbary3);
      rn *= r;
    }
  }

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0yxx (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

    TVIL_REAL Gx0yxxtableA[] = 
     {0, 0, 0.24206957098290582, -0.016532365227920277, 
     -0.008474515947293473, -0.004136580316675403, -0.002269729953285408, 
     -0.0013714291321526221, -0.0008905121057790465, -0.0006105935442033876, 
     -0.00043676393416613497, -0.00032315761270776676, 
     -0.0002457881667777334, -0.00019128104379658256, 
     -0.00015177566295932485, -0.00012244486190667752, 
     -0.00010021214760059198, -0.00008305337611502795, 
     -0.00006959953705143691, -0.00005890208545550775, 
     -0.000050289645393600595, -0.00004327792554642589, 
     -0.000037511606500659245, -0.00003272597841498738, 
     -0.000028721086303401452, -0.000025343975423675816, 
     -0.000022476289761076644, -0.000020025474013170453, 
     -0.000017918442525261783, -0.000016096963404003952, 
     -0.000014514252226425085, -0.000013132430086383063, 
     -0.000011920606843908806, -0.000010853421757324524, 
     -9.909922277435732e-6, -9.072695337786151e-6, -8.327188926285295e-6, 
     -7.661178301557243e-6, -7.0643430625674875e-6, -6.527929829098633e-6, 
     -6.044481519352724e-6, -5.60761878979341e-6, -5.211862596823751e-6, 
     -4.852489376524996e-6, -4.525412248642065e-6, -4.227083099468067e-6, 
     -3.954411504279254e-6, -3.704697299973587e-6, -3.4755742758768783e-6, 
     -3.2649629619893746e-6, -3.0710308939296013e-6, 
     -2.8921590484189155e-6, -2.72691339185025e-6, -2.574020682069985e-6, 
     -2.432347821222629e-6, -2.3008841839801215e-6, -2.178726447335324e-6, 
     -2.0650655305177676e-6, -1.959175320483221e-6, -1.860402912959165e-6, 
     -1.768160143647106e-6, -1.6819162208232285e-6, 
     -1.6011913007725373e-6, -1.5255508724563055e-6, 
     -1.4546008385208961e-6, -1.3879831969874432e-6, 
     -1.3253722423436876e-6, -1.2664712167979347e-6, 
     -1.2110093525609984e-6, -1.1587392545287653e-6, 
     -1.1094345799177724e-6, -1.0628879774816013e-6, 
     -1.0189092540897222e-6, -9.773237408330616e-7, -9.379708345562491e-7, 
     -9.007026939080121e-7, -8.653830717338598e-7, -8.318862679800968e-7, 
     -8.000961892945614e-7, -7.699055032469056e-7, -7.412148765912754e-7, 
     -7.139322882918697e-7, -6.879724091564827e-7, -6.632560408996361e-7, 
     -6.397096083063015e-7, -6.172646989073509e-7, -5.958576452238982e-7, 
     -5.754291452025235e-7, -5.559239169579926e-7, -5.372903843739377e-7, 
     -5.194803904930791e-7, -5.024489359638764e-7, -4.861539401059371e-7, 
     -4.705560224171935e-7, -4.556183025762033e-7, -4.4130621719674644e-7, 
     -4.2758735177247314e-7, -4.1443128640957446e-7, 
     -4.0180945408776913e-7, -3.8969501031649233e-7, 
     -3.7806271316590806e-7};
 
  TVIL_REAL Gx0yxxtableALx[] = 
     {0, 0, 0.75, 0.1111111111111111, 0.03333333333333333, 
     0.013214285714285715, 0.0060185185185185185, 0.002936679722394008, 
     0.001458214404642976, 0.0006932111098777766, 0.00027678476207887974, 
     0.000042804437330190215, -0.00009059245707852519, 
     -0.00016630912771427593, -0.00020796146736735963, 
     -0.0002290733218628404, -0.00023764153783818875, 
     -0.00023851877334533523, -0.0002347109503187141, 
     -0.00022810965281474564, -0.00021991857057464216, 
     -0.00021090854320648334, -0.00020157368548092295, 
     -0.00019222891194006097, -0.00018307193519846035, 
     -0.00017422328183185908, -0.00016575245739114413, 
     -0.00015769524254587842, -0.00015006522885510504, 
     -0.0001428615658014862, -0.00013607418828937836, -0.0001296873525981933, 
     -0.00012368202746940838, -0.00011803750517306046, 
     -0.0001127324783929318, -0.00010774574999031195, -0.0001030566900131554, 
     -0.00009864551873947248, -0.00009449347031655113, 
     -0.00009058287493324717, -0.00008689718597740801, 
     -0.00008342097064837996, -0.00008013987691859426, 
     -0.00007704058582656145, -0.0000741107553303494, 
     -0.00007133896000822586, -0.00006871462952114847, 
     -0.0000662279877827561, -0.00006386999409918792, -0.00006163228706086, 
     -0.00005950713163284736, -0.000057487369658245976, 
     -0.0000555663738302255, -0.0000537380050822609, -0.0000519965732770656, 
     -0.000050336801032136516, -0.00004875379049572114, 
     -0.00004724299287578837, -0.0000458001805221762, 
     -0.000044421421365594516, -0.00004310305552450356, 
     -0.00004184167390059144, -0.00004063409859459726, 
     -0.000039477364985842746, -0.00003836870533054719, 
     -0.00003730553374547278, -0.00003628543245446425, 
     -0.000035306139185874866, -0.00003436553561863754, 
     -0.000033461636783813413, -0.00003259258133682805, 
     -0.000031756622623302686, -0.000030952120468435, 
     -0.00003017753362631411, -0.000029431412831411017, 
     -0.000028712394399808164, -0.00002801919433256258, 
     -0.00002735060287797797, -0.000026705479513529194, 
     -0.000026082748311776705, -0.0000254813936578609, 
     -0.00002490045628911057, -0.000024339029629963405, 
     -0.00002379625639780757, -0.000023271325457535272, 
     -0.000022763468904575252, -0.000022271959357959648, 
     -0.00002179610744660181, -0.000021335259473430326, 
     -0.00002088879524335623, -0.000020456126042258586, 
     -0.000020036692755269845, -0.000019629964113638304, 
     -0.00001923543506034921, -0.00001885262522550889, 
     -0.0000184810775032439, -0.000018120356722548445, 
     -0.000017770048405133164, -0.00001742975760389371, 
     -0.000017099107816132653, -0.00001677773996613859};
 
  TVIL_REAL Gx0yxxtableALy[] = 
     {0, 0, 0., 0.027777777777777776, 0.015277777777777777, 
     0.009285714285714286, 0.0062037037037037035, 0.004432934790077647, 
     0.0033249488606631465, 0.0025861098777765447, 0.0020688942502667994, 
     0.0016927327527524545, 0.0014106108225514361, 0.0011935938088451109, 
     0.0010230804143544386, 0.0008866696937449266, 0.0007758359822826332, 
     0.0006845611608885878, 0.0006084988096890418, 0.0005444463034080906, 
     0.0004900016730677169, 0.0004433348470613586, 0.0004030316791467088, 
     0.00036798544617743385, 0.0003373199923293152, 0.0003103343929429702, 
     0.0002864625165627417, 0.00026524307089142757, 0.0002462971372563256, 
     0.0002293111277903721, 0.00021402371927101396, 0.00020021573738256146, 
     0.00018770225379615134, 0.00017632635962668765, 0.0001659542208251178, 
     0.0001564711224922539, 0.00014777828235379537, 0.00013979026709142804, 
     0.00013243288461293182, 0.0001256414546327815, 0.0001193593819011424, 
     0.00011353697302791595, 0.00010813045050277709, 0.00010310112722357816, 
     0.00009841471234977914, 0.00009404072513423341, 0.00008995199795448414, 
     0.0000861242533606763, 0.00008253574280398145, 0.00007916693697524752, 
     0.00007600025949623761, 0.00007301985716305181, 0.00007021140111831906, 
     0.00006756191428366551, 0.00006505962116204827, 0.0000626938167561556, 
     0.000060454751872007194, 0.00005833353250807711, 
     0.000056322031387108936, 0.00005441280998415609, 0.00005259904965135089, 
     0.00005087449064638857, 0.00004923337804489216, 0.00004767041366251464, 
     0.000046180713235561054, 0.000044759768212928406, 
     0.00004340341160041542, 0.00004210778737353735, 0.00004086932303902154, 
     0.00003968470497991947, 0.00003855085626620749, 0.00003746491665307488, 
     0.000036424224523822795, 0.00003542630056426601, 0.00003446883298144801, 
     0.00003354966410194273, 0.00003266677820452318, 0.000031818290458951154, 
     0.00003100243685743958, 0.000030217565038263898, 0.0000294621259123073, 
     0.000028734666013237985, 0.000028033820500719983, 
     0.00002735830675371469, 0.00002670691849767386, 0.00002607852041537565, 
     0.00002547204319641343, 0.000024886478985001624, 0.00002432087718988795, 
     0.000023774340623823052, 0.000023246021943293652, 
     0.00002273512036212236, 0.000022240878615119706, 
     0.000021762580150278416, 0.00002129954653005973, 
     0.000020851135024163736, 0.00002041673637782699, 
     0.000019995772741170762, 0.00001958769574645299, 
     0.000019191984721272124, 0.00001880814502684668};
 
  TVIL_REAL Gx0yxxtableALx2[] = 
     {0, 0, 0.5, 0.16666666666666666, 0.08333333333333333, 0.05, 
     0.03333333333333333, 0.023809523809523808, 0.017857142857142856, 
     0.013888888888888888, 0.011111111111111112, 0.00909090909090909, 
     0.007575757575757576, 0.00641025641025641, 0.005494505494505495, 
     0.004761904761904762, 0.004166666666666667, 0.003676470588235294, 
     0.0032679738562091504, 0.0029239766081871343, 0.002631578947368421, 
     0.002380952380952381, 0.0021645021645021645, 0.001976284584980237, 
     0.0018115942028985507, 0.0016666666666666668, 0.0015384615384615385, 
     0.0014245014245014246, 0.0013227513227513227, 0.0012315270935960591, 
     0.0011494252873563218, 0.001075268817204301, 0.0010080645161290322, 
     0.000946969696969697, 0.00089126559714795, 0.0008403361344537816, 
     0.0007936507936507937, 0.0007507507507507507, 0.0007112375533428165, 
     0.0006747638326585695, 0.000641025641025641, 0.0006097560975609756, 
     0.0005807200929152149, 0.0005537098560354374, 0.0005285412262156448, 
     0.000505050505050505, 0.0004830917874396135, 0.00046253469010175765, 
     0.0004432624113475177, 0.00042517006802721087, 0.00040816326530612246, 
     0.000392156862745098, 0.0003770739064856712, 0.000362844702467344, 
     0.00034940600978336826, 0.0003367003367003367, 0.0003246753246753247, 
     0.0003132832080200501, 0.00030248033877797946, 0.0002922267679719462, 
     0.0002824858757062147, 0.000273224043715847, 0.00026441036488630354, 
     0.0002560163850486431, 0.000248015873015873, 0.0002403846153846154, 
     0.0002331002331002331, 0.0002261420171867933, 0.00021949078138718174, 
     0.00021312872975277067, 0.00020703933747412008, 0.00020120724346076458, 
     0.00019561815336463224, 0.0001902587519025875, 0.00018511662347278786, 
     0.00018018018018018018, 0.00017543859649122806, 0.00017088174982911826, 
     0.0001665001665001665, 0.0001622849724115547, 0.00015822784810126583, 
     0.00015432098765432098, 0.00015055706112616682, 0.00014692918013517486, 
     0.00014343086632243257, 0.00014005602240896358, 0.00013679890560875513, 
     0.00013365410318096765, 0.00013061650992685477, 0.00012768130745658836, 
     0.00012484394506866417, 0.0001221001221001221, 0.00011944577161968466, 
     0.0001168770453482936, 0.00011439029970258523, 0.00011198208286674133, 
     0.00010964912280701755, 0.00010738831615120275, 0.00010519671786240269, 
     0.00010307153164296021, 0.00010101010101010101};
 
  TVIL_REAL Gx0yxxtableALxLy[] = 
      {0, 0, -0.5, -0.16666666666666666, -0.08333333333333333, -0.05, 
     -0.03333333333333333, -0.023809523809523808, -0.017857142857142856, 
     -0.013888888888888888, -0.011111111111111112, -0.00909090909090909, 
     -0.007575757575757576, -0.00641025641025641, -0.005494505494505495, 
     -0.004761904761904762, -0.004166666666666667, -0.003676470588235294, 
     -0.0032679738562091504, -0.0029239766081871343, -0.002631578947368421, 
     -0.002380952380952381, -0.0021645021645021645, -0.001976284584980237, 
     -0.0018115942028985507, -0.0016666666666666668, -0.0015384615384615385, 
     -0.0014245014245014246, -0.0013227513227513227, -0.0012315270935960591, 
     -0.0011494252873563218, -0.001075268817204301, -0.0010080645161290322, 
     -0.000946969696969697, -0.00089126559714795, -0.0008403361344537816, 
     -0.0007936507936507937, -0.0007507507507507507, -0.0007112375533428165, 
     -0.0006747638326585695, -0.000641025641025641, -0.0006097560975609756, 
     -0.0005807200929152149, -0.0005537098560354374, -0.0005285412262156448, 
     -0.000505050505050505, -0.0004830917874396135, -0.00046253469010175765, 
     -0.0004432624113475177, -0.00042517006802721087, 
     -0.00040816326530612246, -0.000392156862745098, -0.0003770739064856712, 
     -0.000362844702467344, -0.00034940600978336826, -0.0003367003367003367, 
     -0.0003246753246753247, -0.0003132832080200501, -0.00030248033877797946, 
     -0.0002922267679719462, -0.0002824858757062147, -0.000273224043715847, 
     -0.00026441036488630354, -0.0002560163850486431, -0.000248015873015873, 
     -0.0002403846153846154, -0.0002331002331002331, -0.0002261420171867933, 
     -0.00021949078138718174, -0.00021312872975277067, 
     -0.00020703933747412008, -0.00020120724346076458, 
     -0.00019561815336463224, -0.0001902587519025875, 
     -0.00018511662347278786, -0.00018018018018018018, 
     -0.00017543859649122806, -0.00017088174982911826, 
     -0.0001665001665001665, -0.0001622849724115547, -0.00015822784810126583, 
     -0.00015432098765432098, -0.00015055706112616682, 
     -0.00014692918013517486, -0.00014343086632243257, 
     -0.00014005602240896358, -0.00013679890560875513, 
     -0.00013365410318096765, -0.00013061650992685477, 
     -0.00012768130745658836, -0.00012484394506866417, 
     -0.0001221001221001221, -0.00011944577161968466, -0.0001168770453482936, 
     -0.00011439029970258523, -0.00011198208286674133, 
     -0.00010964912280701755, -0.00010738831615120275, 
     -0.00010519671786240269, -0.00010307153164296021, 
     -0.00010101010101010101};

  TVIL_REAL Gx0yxxtableC[] = 
     {0, 0, -0.33340441695345285, -0.015983246090604912, 
     -0.0021283515807823694, -0.0006768557364975261, -0.0003563555265195341, 
     -0.00022486719198577617, -0.0001523057812876229, -0.0001074354791018974, 
     -0.00007812008761781641, -0.00005825042191473522, 
     -0.000044381608552948885, -0.00003445531968094208, 
     -0.000027193090821664858, -0.000021775820850316715, 
     -0.000017664452119748933, -0.00001449566275887317, 
     -0.000012019268582007952, -0.000010059621126202368, 
     -8.491214488778264e-6, -7.222924424853649e-6, -6.187615743308599e-6, 
     -5.335160480237997e-6, -4.627666293539117e-6, -4.036163410126389e-6, 
     -3.5382704247409725e-6, -3.1165273395920996e-6, 
     -2.757190064050955e-6, -2.449348383293214e-6, -2.1842735316782644e-6, 
     -1.9549306653506063e-6, -1.7556110691414678e-6, 
     -1.5816522015408659e-6, -1.429222803465607e-6, 
     -1.2951566410190907e-6, -1.1768229136752594e-6, 
     -1.0720245288604109e-6, -9.789177177965274e-7, -8.959481139040899e-7, 
     -8.217996176288548e-7, -7.553532572176913e-7, -6.956539123801579e-7, 
     -6.418832594163416e-7, -5.933376666887142e-7, -5.494100501119438e-7, 
     -5.095749126419007e-7, -4.7337595631903805e-7, -4.404157825504122e-7, 
     -4.103472950738605e-7, -3.8286649718359263e-7, 
     -3.5770643535578325e-7, -3.3463208919454015e-7, 
     -3.134360454989378e-7, -2.93934824420271e-7, -2.759657498113478e-7, 
     -2.5938427525602993e-7, -2.4406169290448743e-7, 
     -2.298831649024799e-7, -2.1674602749612352e-7, 
     -2.0455832629116926e-7, -1.9323754802112056e-7, 
     -1.8270951982674116e-7, -1.7290745170496964e-7, 
     -1.6377110163471605e-7, -1.5524604607984405e-7, 
     -1.4728304122577015e-7, -1.398374625221589e-7, 
     -1.3286881195826388e-7, -1.2634028405291063e-7, 
     -1.2021838284948133e-7, -1.1447258330961297e-7, 
     -1.090750314320974e-7, -1.0400027821395305e-7, -9.922504324209982e-8, 
     -9.472800427573704e-8, -9.048960966730824e-8, -8.649191088704511e-8, 
     -8.271841277350576e-8, -7.915393943942582e-8, -7.578451402625231e-8, 
     -7.259725072835199e-8, -6.958025770447656e-8, -6.672254966416996e-8, 
     -6.401396906425085e-8, -6.144511497853883e-8, -5.9007278815361164e-8, 
     -5.669238615441002e-8, -5.449294405920102e-8, -5.240199329540262e-8, 
     -5.041306495010616e-8, -4.852014100392152e-8, -4.67176184576727e-8, 
     -4.500027665933803e-8, -4.3363247515512654e-8, -4.180198830573901e-8, 
     -4.0312256848134255e-8, -3.889008879134362e-8, -3.753177683139931e-8, 
     -3.623385167294212e-8, -3.4993064572793876e-8};
 
  TVIL_REAL Gx0yxxtableCLx[] = 
      {0, 0, 0.28125, 0.016493055555555556, 0.00010850694444444444, 
     -0.000947265625, -0.0007071940104166666, -0.0004647321982178288, 
     -0.0003077584870007573, -0.00021022139823415712, -0.000148353988741651, 
     -0.00010781690343446217, -0.00008038371704289763, 
     -0.00006126772160358848, -0.00004759951579504322, 
     -0.000037602980857980805, -0.000030144828843073254, 
     -0.000024481685441535184, -0.000020113677726277305, 
     -0.00001669710045264425, -0.000013990847255973159, 
     -0.000011822701548388787, -0.000010067624643262237, 
     -8.63347151367251e-6, -7.451409640075937e-6, -6.46937774736818e-6, 
     -5.64754687466454e-6, -4.955123466982251e-6, -4.368066453969583e-6, 
     -3.867436089355219e-6, -3.438185508748502e-6, -3.0682665141745203e-6, 
     -2.7479610525956255e-6, -2.4693766082546476e-6, -2.22606188233521e-6, 
     -2.012711608244383e-6, -1.8249380251200788e-6, 
     -1.6590926311128186e-6, -1.5121261712253e-6, -1.381477923677232e-6, 
     -1.2649876005098493e-6, -1.1608248233211512e-6, 
     -1.0674323470808422e-6, -9.834801050221208e-7, -9.07827820998189e-7, 
     -8.394944431115328e-7, -7.776330373870548e-7, -7.21510074216595e-7, 
     -6.704882661580329e-7, -6.24012290231433e-7, -5.81596863531796e-7, 
     -5.428167470051171e-7, -5.072983355211569e-7, -4.7471255812551954e-7, 
     -4.44768864506017e-7, -4.172101152654057e-7, -3.9180822685295623e-7, 
     -3.6836044874024976e-7, -3.4668617200084833e-7, 
     -3.266241859330002e-7, -3.08030313580182e-7, -2.9077536860777207e-7, 
     -2.7474338549891853e-7, -2.5983008284484554e-7, 
     -2.459415259470032e-7, -2.329929602777942e-7, -2.209077917689282e-7, 
     -2.0961669357707075e-7, -1.9905682204863133e-7, 
     -1.8917112717701758e-7, -1.7990774500392952e-7, 
     -1.7121946123244942e-7, -1.6306323685191712e-7, 
     -1.5539978787047344e-7, -1.4819321234979537e-7, 
     -1.4141065887014329e-7, -1.350220313489927e-7, 
     -1.2899972581525588e-7, -1.2331839532170933e-7, 
     -1.1795473967595335e-7, -1.128873170977469e-7, 
     -1.0809637527851719e-7, -1.0356369963614365e-7, 
     -9.927247683225457e-8, -9.520717185655677e-8, -9.135341718846608e-8, 
     -8.769791272502438e-8, -8.42283353195922e-8, -8.093325691133371e-8, 
     -7.78020703438249e-8, -7.482492207456294e-8, -7.199265106774456e-8, 
     -6.929673324213341e-8, -6.672923091562095e-8, -6.428274674946989e-8, 
     -6.195038174929936e-8, -5.972569692756538e-8, -5.7602678274417704e-8, 
     -5.557570472107291e-8, -5.363951881284048e-8, -5.178919983819719e-8};
 
  TVIL_REAL Gx0yxxtableCLy[] = 
     {0, 0, -0.234375, -0.014322916666666666, 0.00008138020833333333, 
     0.00096923828125, 0.0007101779513888889, 0.0004651820037910998, 
     0.00030783147228007415, 0.00021023390785096182, 0.0001483562257554796, 
     0.000107817317218773, 0.00008038379572212338, 0.00006126773691132311, 
     0.000047599518831597926, 0.00003760298147041516, 
     0.000030144828968381415, 0.000024481685467498265, 
     0.000020113677731716636, 0.00001669710045379508, 
     0.000013990847256218796, 0.000011822701548441633, 
     0.000010067624643273687, 8.633471513675008e-6, 7.451409640076485e-6, 
     6.469377747368301e-6, 5.647546874664566e-6, 4.955123466982257e-6, 
     4.368066453969584e-6, 3.867436089355219e-6, 3.438185508748502e-6, 
     3.0682665141745203e-6, 2.7479610525956255e-6, 2.4693766082546476e-6, 
     2.22606188233521e-6, 2.012711608244383e-6, 1.824938025120079e-6, 
     1.6590926311128186e-6, 1.5121261712253e-6, 1.3814779236772322e-6, 
     1.2649876005098493e-6, 1.1608248233211512e-6, 1.0674323470808424e-6, 
     9.834801050221208e-7, 9.07827820998189e-7, 8.394944431115328e-7, 
     7.77633037387055e-7, 7.21510074216595e-7, 6.704882661580329e-7, 
     6.24012290231433e-7, 5.815968635317959e-7, 5.428167470051171e-7, 
     5.072983355211569e-7, 4.747125581255196e-7, 4.4476886450601694e-7, 
     4.172101152654057e-7, 3.9180822685295623e-7, 3.6836044874024976e-7, 
     3.4668617200084833e-7, 3.266241859330002e-7, 3.08030313580182e-7, 
     2.9077536860777207e-7, 2.7474338549891853e-7, 2.5983008284484554e-7, 
     2.459415259470032e-7, 2.329929602777942e-7, 2.209077917689282e-7, 
     2.0961669357707075e-7, 1.9905682204863133e-7, 1.8917112717701758e-7, 
     1.7990774500392952e-7, 1.7121946123244942e-7, 1.6306323685191712e-7, 
     1.5539978787047344e-7, 1.4819321234979537e-7, 1.414106588701433e-7, 
     1.350220313489927e-7, 1.2899972581525588e-7, 1.2331839532170936e-7, 
     1.1795473967595335e-7, 1.128873170977469e-7, 1.080963752785172e-7, 
     1.0356369963614364e-7, 9.927247683225457e-8, 9.520717185655677e-8, 
     9.135341718846608e-8, 8.769791272502438e-8, 8.42283353195922e-8, 
     8.09332569113337e-8, 7.78020703438249e-8, 7.482492207456294e-8, 
     7.199265106774455e-8, 6.929673324213341e-8, 6.672923091562095e-8, 
     6.428274674946989e-8, 6.195038174929936e-8, 5.972569692756538e-8, 
     5.7602678274417704e-8, 5.557570472107291e-8, 5.363951881284048e-8, 
     5.17891998381972e-8};
 
  TVIL_REAL Gx0yxxtableCLx2[] = 
     {0, 0, -0.078125, -0.01171875, -0.0030924479166666665, 
     -0.0011474609375, -0.0005330403645833333, -0.00028701055617559525, 
     -0.00017070770263671875, -0.00010895729064941406, 
     -0.00007331106397840712, -0.00005139979449185458, 
     -0.000037253128759788744, -0.000027749830713638894, 
     -0.00002115253604702897, -0.00001644384160283066, 
     -0.000013002327856762955, -0.000010434657858294326, 
     -8.48410695504391e-6, -6.978577924291508e-6, -5.799960317026968e-6, 
     -4.8654867049165094e-6, -4.116065732022655e-6, 
     -3.5087964682033164e-6, -3.012056766822626e-6, 
     -2.6022147682606503e-6, -2.261386435563361e-6, 
     -1.9758806408620852e-6, -1.7351043883696587e-6, 
     -1.5307811042933016e-6, -1.3563851897604838e-6, 
     -1.206728074717393e-6, -1.077651791289146e-6, -9.657997789515064e-7, 
     -8.684437923795193e-7, -7.833519930566099e-7, -7.086875712251038e-7, 
     -6.429302099435588e-7, -5.848147876301024e-7, -5.332831966046267e-7, 
     -4.874462180296392e-7, -4.4655316358968975e-7, 
     -4.0996755695016174e-7, -3.771475427429725e-7, -3.476300189015874e-7, 
     -3.2101771876095474e-7, -2.96968643177532e-7, -2.7518737487519216e-7, 
     -2.5541790803068057e-7, -2.374377036061507e-7, 
     -2.2105274086130955e-7, -2.060933820795836e-7, 
     -1.9241090398008902e-7, -1.7987457792499803e-7, 
     -1.683692036516713e-7, -1.5779301921060932e-7, 
     -1.4805592410254178e-7, -1.390779640689105e-7, -1.307880352065432e-7, 
     -1.2312277251919356e-7, -1.1602559405115274e-7, 
     -1.0944587665672606e-7, -1.033382434680024e-7, -9.766194640855432e-8, 
     -9.23803298022076e-8, -8.746036335482406e-8, -8.287223463170582e-8, 
     -7.858899268465461e-8, -7.458623575787993e-8, -7.08418370667883e-8, 
     -6.733570353537548e-8, -6.404956312666075e-8, -6.096677703092126e-8, 
     -5.8072173508481115e-8, -5.535190063393057e-8, 
     -5.2793295570411706e-8, -5.038476832714616e-8, -4.811569822989924e-8, 
     -4.597634157020018e-8, -4.395774910120104e-8, -4.2051692221334486e-8, 
     -4.0250596835823185e-8, -3.854748401428827e-8, 
     -3.6935916673289814e-8, -3.540995160820683e-8, -3.396409628161801e-8, 
     -3.259326984712316e-8, -3.12927679499152e-8, -3.005823089969749e-8, 
     -2.8885614858868443e-8, -2.7771165730223528e-8, 
     -2.671139546457076e-8, -2.5703060540319175e-8, 
     -2.4743142394877602e-8, -2.3828829612106506e-8, 
     -2.2957501691539135e-8, -2.212671424400838e-8, 
     -2.1334185475009456e-8, -2.057778383187754e-8, -1.985551670390757e-8, 
     -1.916552007610195e-8};
 
  TVIL_REAL Gx0yxxtableCLy2[] = 
     {0, 0, -0.046875, -0.009114583333333334, -0.0027669270833333335, 
     -0.0010986328125, -0.00052490234375, -0.00028555733816964287, 
     -0.00017043522426060269, -0.00010890430874294705, 
     -0.00007330046759711372, -0.00005139762705022638, 
     -0.00003725267720944954, -0.00002774973519337483, 
     -0.000021152515578400956, -0.000016443837167961258, 
     -0.000013002326886635273, -0.000010434657644295572, 
     -8.484106907488632e-6, -6.9785779136541434e-6, 
     -5.7999603146335605e-6, -4.8654867043751436e-6, 
     -4.116065731899617e-6, -3.5087964681752317e-6, -3.01205676681619e-6, 
     -2.60221476825917e-6, -2.261386435563019e-6, -1.975880640862006e-6, 
     -1.7351043883696405e-6, -1.5307811042932973e-6, 
     -1.3563851897604827e-6, -1.2067280747173927e-6, 
     -1.0776517912891457e-6, -9.657997789515064e-7, -8.684437923795193e-7, 
     -7.833519930566099e-7, -7.086875712251038e-7, -6.429302099435589e-7, 
     -5.848147876301024e-7, -5.332831966046267e-7, -4.874462180296392e-7, 
     -4.4655316358968975e-7, -4.0996755695016174e-7, 
     -3.7714754274297245e-7, -3.476300189015874e-7, 
     -3.2101771876095474e-7, -2.96968643177532e-7, -2.7518737487519216e-7, 
     -2.554179080306806e-7, -2.374377036061507e-7, -2.2105274086130953e-7, 
     -2.060933820795836e-7, -1.92410903980089e-7, -1.7987457792499803e-7, 
     -1.683692036516713e-7, -1.5779301921060932e-7, 
     -1.4805592410254178e-7, -1.390779640689105e-7, -1.307880352065432e-7, 
     -1.2312277251919356e-7, -1.1602559405115272e-7, 
     -1.0944587665672604e-7, -1.033382434680024e-7, -9.766194640855432e-8, 
     -9.238032980220759e-8, -8.746036335482406e-8, -8.287223463170582e-8, 
     -7.858899268465461e-8, -7.458623575787993e-8, -7.08418370667883e-8, 
     -6.733570353537548e-8, -6.404956312666075e-8, -6.096677703092126e-8, 
     -5.8072173508481115e-8, -5.535190063393057e-8, 
     -5.2793295570411706e-8, -5.038476832714616e-8, -4.811569822989924e-8, 
     -4.5976341570200174e-8, -4.395774910120103e-8, 
     -4.2051692221334486e-8, -4.025059683582318e-8, -3.854748401428827e-8, 
     -3.6935916673289814e-8, -3.540995160820683e-8, -3.396409628161801e-8, 
     -3.259326984712316e-8, -3.12927679499152e-8, -3.005823089969749e-8, 
     -2.8885614858868443e-8, -2.7771165730223528e-8, 
     -2.6711395464570758e-8, -2.5703060540319175e-8, 
     -2.4743142394877602e-8, -2.3828829612106506e-8, 
     -2.2957501691539135e-8, -2.212671424400838e-8, -2.133418547500946e-8, 
     -2.057778383187754e-8, -1.985551670390757e-8, -1.9165520076101947e-8};
 
  TVIL_REAL Gx0yxxtableCLxLy[] = 
     {0, 0, 0.125, 0.020833333333333332, 0.005859375, 0.00224609375, 
     0.0010579427083333333, 0.0005725678943452381, 0.00034114292689732144, 
     0.00021786159939236112, 0.00014661153157552082, 0.00010279742154208097, 
     0.00007450580596923828, 0.00005549956590701372, 0.000042305051625429926, 
     0.00003288767877079192, 0.00002600465474339823, 0.000020869315502589897, 
     0.000016968213862532542, 0.00001395715583794565, 
     0.000011599920631660528, 9.730973409291653e-6, 8.232131463922273e-6, 
     7.017592936378548e-6, 6.024113533638816e-6, 5.204429536519821e-6, 
     4.52277287112638e-6, 3.951761281724092e-6, 3.470208776739299e-6, 
     3.061562208586599e-6, 2.7127703795209667e-6, 2.4134561494347857e-6, 
     2.1553035825782914e-6, 1.9315995579030128e-6, 1.7368875847590386e-6, 
     1.5667039861132197e-6, 1.4173751424502078e-6, 1.2858604198871179e-6, 
     1.1696295752602047e-6, 1.0665663932092534e-6, 9.748924360592784e-7, 
     8.931063271793795e-7, 8.199351139003235e-7, 7.54295085485945e-7, 
     6.952600378031748e-7, 6.420354375219095e-7, 5.93937286355064e-7, 
     5.503747497503843e-7, 5.108358160613612e-7, 4.748754072123014e-7, 
     4.4210548172261905e-7, 4.121867641591672e-7, 3.8482180796017804e-7, 
     3.5974915584999606e-7, 3.3673840730334264e-7, 3.1558603842121864e-7, 
     2.9611184820508357e-7, 2.78155928137821e-7, 2.615760704130864e-7, 
     2.462455450383871e-7, 2.3205118810230544e-7, 2.1889175331345212e-7, 
     2.066764869360048e-7, 1.9532389281710864e-7, 1.847606596044152e-7, 
     1.7492072670964811e-7, 1.6574446926341164e-7, 1.5717798536930923e-7, 
     1.4917247151575987e-7, 1.416836741335766e-7, 1.3467140707075096e-7, 
     1.280991262533215e-7, 1.2193355406184252e-7, 1.1614434701696223e-7, 
     1.1070380126786114e-7, 1.0558659114082341e-7, 1.0076953665429231e-7, 
     9.623139645979849e-8, 9.195268314040035e-8, 8.791549820240208e-8, 
     8.410338444266897e-8, 8.050119367164636e-8, 7.709496802857654e-8, 
     7.387183334657963e-8, 7.081990321641366e-8, 6.792819256323602e-8, 
     6.518653969424632e-8, 6.25855358998304e-8, 6.011646179939498e-8, 
     5.777122971773689e-8, 5.554233146044706e-8, 5.3422790929141516e-8, 
     5.140612108063835e-8, 4.9486284789755205e-8, 4.765765922421302e-8, 
     4.591500338307827e-8, 4.425342848801675e-8, 4.266837095001891e-8, 
     4.115556766375508e-8, 3.971103340781514e-8, 3.83310401522039e-8};
 
  TVIL_REAL Gx0yxxtableD[] = 
     {0, 4.0563641976487330077022384, -0.3359768096723647, 0.15887600537353597, 
     -0.08262232897092964, 0.050152683451778, -0.03359999018380173, 
     0.024060757749178888, -0.018072091099905742, 0.014069117950339424, 
     -0.011262310878077558, 0.009218661249967387, -0.007684679720694074, 
     0.0065039895575645015, -0.005575885330173788, 0.004833141957687642, 
     -0.004229495856128353, 0.0037322647940791743, -0.0033178302114854103, 
     0.002968780170035329, -0.002672050301932171, 0.002417683373364407, 
     -0.0021979829307054955, 0.0020069241831384495, -0.0018397365022754712, 
     0.001692602693787997, -0.0015624391539856527, 0.001446732971327293, 
     -0.0013434197189063414, 0.001250790722932464, -0.001167421953454019, 
     0.0010921189616493938, -0.001023873854878866, 0.0009618313931645865, 
     -0.000905262062188898, 0.0008535405290850817, -0.0008061282854804155, 
     0.0007625595728907277, -0.0007224298997683134, 0.0006853866188159564, 
     -0.0006511211526847371, 0.0006193625465457094, -0.0005898720948911543, 
     0.0005624388427788332, -0.0005368758025824927, 0.0005130167590876919, 
     -0.0004907135606427717, 0.0004698338136558427, -0.0004502589132317904, 
     0.00043188235508358013, -0.000414608283725164, 0.000398350239891026, 
     -0.00038303007653909117, 0.00036857701799600543, -0.0003549268410429463, 
     0.00034202116020872283, -0.00032980680238628153, 0.00031823525823832595, 
     -0.000307262199802339, 0.0002968470553203602, -0.00028695263366481483, 
     0.00027754479185703324, -0.0002685921401189699, 0.0002600657796927111, 
     -0.0002519390693323856, 0.0002441874169400585, -0.00023678809329826105, 
     0.00022972006526109605, -0.00022296384611496242, 0.00021650136111846146, 
     -0.0002103158264869261, 0.00020439164030685965, -0.0001987142840548859, 
     0.00019327023355919808, -0.00018804687838280248, 0.00018303244873032364, 
     -0.00017821594908649585, 0.00017358709788701154, 
     -0.00016913627260308216, 0.0001648544596915363, -0.00016073320892394545, 
     0.00015676459166231717, -0.00015294116269635804, 0.0001492559252990497, 
     -0.00014570229919405717, 0.00014227409116093556, 
     -0.00013896546803277728, 0.00013577093186632156, 
     -0.00013268529708704388, 0.00012970366943171162, -0.0001268214265286422, 
     0.00012403419997169933, -0.00012133785875814585, 0.00011872849397303964, 
     -0.0001162024046140905, 0.0001137560844609449, -0.00011138620990186848, 
     0.00010908962863887002, -0.00010686334919956165, 0.00010470453119056809, 
     -0.0001026104762331643};
 
  TVIL_REAL Gx0yxxtableDL[] = 
     {0, 2.5, -0.5, 0.25, -0.1388888888888889, 0.0875, -0.06, 
     0.04365079365079365, -0.03316326530612245, 0.026041666666666668, 
     -0.020987654320987655, 0.017272727272727273, -0.014462809917355372, 
     0.012286324786324786, -0.010566356720202874, 0.009183673469387756, 
     -0.008055555555555555, 0.007123161764705882, -0.006343713956170703, 
     0.0056855100714749834, -0.005124653739612188, 0.004642857142857143, 
     -0.004225932797361369, 0.0038627380524613726, -0.003544423440453686, 
     0.003263888888888889, -0.0030153846153846155, 0.002794214332675871, 
     -0.002596511855771115, 0.002419071076706545, -0.002259215219976219, 
     0.0021146953405017923, -0.0019836108220603536, 0.001864346590909091, 
     -0.0017555231458974774, 0.0016559565002471576, -0.001564625850340136, 
     0.0014806473139806473, -0.0014032524701088002, 0.0013317707223524397, 
     -0.0012656147271531888, 0.0012042682926829268, -0.0011472762811251807, 
     0.001094236144070031, -0.00104479079600767, 0.0009986225895316804, 
     -0.0009554482018250134, 0.0009150142782447814, -0.0008770937075599819, 
     0.0008414824263038549, -0.0008079966680549771, 0.0007764705882352942, 
     -0.0007467542069618194, 0.0007187116221949313, -0.0006922194533444089, 
     0.0006671654819802968, -0.0006434474616292798, 0.0006209720730397422, 
     -0.0005996540049458188, 0.000579415143392652, -0.000560183855214019, 
     0.0005418943533697633, -0.00052448613362693, 0.0005079034735642436, 
     -0.0004920949861426052, 0.00047701322115384614, -0.0004626143087681549, 
     0.0004488576401737867, -0.0004357055809626145, 0.0004231232134797653, 
     -0.00041107810483991957, 0.0003995400977292325, -0.0003884811214706077, 
     0.0003778750211398613, -0.0003676974027884142, 0.0003579254930606282, 
     -0.0003485380116959064, 0.00033951505558153756, -0.0003308379931756555, 
     0.0003224893682537305, -0.00031445281204935105, 0.00030671296296296295, 
     -0.0002992553931026279, 0.00029206654100040854, -0.0002851336499180889, 
     0.00027844471121782046, -0.0002719884123279955, 0.00026575408888308686, 
     -0.00025973168065914794, 0.00025391169096480637, 
     -0.00024828514918150065, 0.0002428435761769095, -0.00023757895234244973, 
     0.0002324836880297579, -0.000227550596182562, 0.00022277286697958113, 
     -0.00021814404432132965, 0.0002136580040091638, -0.00020930893347880124, 
     0.00020509131296303308, -0.00020099989796959494};
 
  TVIL_REAL Gx0yxxtableDL2[] = 
     {0, -1., 0.25, -0.08333333333333333, 0.041666666666666664, 
     -0.025, 0.016666666666666666, -0.011904761904761904, 
     0.008928571428571428, -0.006944444444444444, 0.005555555555555556, 
     -0.004545454545454545, 0.003787878787878788, -0.003205128205128205, 
     0.0027472527472527475, -0.002380952380952381, 0.0020833333333333333, 
     -0.001838235294117647, 0.0016339869281045752, -0.0014619883040935672, 
     0.0013157894736842105, -0.0011904761904761906, 0.0010822510822510823, 
     -0.0009881422924901185, 0.0009057971014492754, -0.0008333333333333334, 
     0.0007692307692307692, -0.0007122507122507123, 0.0006613756613756613, 
     -0.0006157635467980296, 0.0005747126436781609, -0.0005376344086021505, 
     0.0005040322580645161, -0.0004734848484848485, 0.000445632798573975, 
     -0.0004201680672268908, 0.0003968253968253968, -0.00037537537537537537, 
     0.00035561877667140827, -0.00033738191632928474, 0.0003205128205128205, 
     -0.0003048780487804878, 0.00029036004645760743, -0.0002768549280177187, 
     0.0002642706131078224, -0.0002525252525252525, 0.00024154589371980676, 
     -0.00023126734505087883, 0.00022163120567375886, 
     -0.00021258503401360543, 0.00020408163265306123, -0.000196078431372549, 
     0.0001885369532428356, -0.000181422351233672, 0.00017470300489168413, 
     -0.00016835016835016836, 0.00016233766233766234, 
     -0.00015664160401002505, 0.00015124016938898973, -0.0001461133839859731, 
     0.00014124293785310735, -0.0001366120218579235, 0.00013220518244315177, 
     -0.00012800819252432156, 0.0001240079365079365, -0.0001201923076923077, 
     0.00011655011655011655, -0.00011307100859339665, 0.00010974539069359087, 
     -0.00010656436487638534, 0.00010351966873706004, 
     -0.00010060362173038229, 0.00009780907668231612, 
     -0.00009512937595129375, 0.00009255831173639393, 
     -0.00009009009009009009, 0.00008771929824561403, 
     -0.00008544087491455913, 0.00008325008325008325, 
     -0.00008114248620577734, 0.00007911392405063291, 
     -0.00007716049382716049, 0.00007527853056308341, 
     -0.00007346459006758743, 0.00007171543316121629, 
     -0.00007002801120448179, 0.00006839945280437756, 
     -0.00006682705159048383, 0.00006530825496342738, 
     -0.00006384065372829418, 0.00006242197253433208, 
     -0.00006105006105006105, 0.00005972288580984233, -0.0000584385226741468, 
     0.00005719514985129261, -0.000055991041433370664, 
     0.00005482456140350877, -0.000053694158075601374, 
     0.000052598358931201344, -0.000051535765821480104, 
     0.000050505050505050505};
  
  TVIL_REAL Gx0yxxtableB[] = 
     {0, 14.02642266853542, 
     -0.049662687283291075, 0.4830709789981153, -0.2899409194733985, 
     0.18521907442831959, -0.12725151359827275, 0.09245950036210727, 
     -0.07009318220167679, 0.05491292769437799, -0.044156407308515624, 
     0.03626492577693906, -0.0303078043943853, 0.02570258919092045, 
     -0.02207008240628019, 0.01915500395464797, -0.016780486989429896, 
     0.01482090340157189, -0.013185056684856469, 0.011805463154025015, 
     -0.01063132869391489, 0.009623835161969494, -0.008752908351803085, 
     0.007994958742740801, -0.007331274530466393, 0.006746860424724235, 
     -0.006229586395188439, 0.005769555358285781, -0.005358627774328409, 
     0.0049900602067043135, -0.004658227674295884, 0.004358408320268201, 
     -0.0040866149176294626, 0.0038394619253815996, -0.003614059777752868, 
     0.003407930215067014, -0.0032189380039619165, 0.0030452355202841854, 
     -0.002885217499034515, 0.0027374838748233147, -0.002600809101386848, 
     0.0024741166909102697, -0.0023564579826259504, 0.0022469943566557193, 
     -0.0021449822688290664, 0.002049760606610878, -0.0019607399637329936, 
     0.001877393507923909, -0.0017992491769870558, 0.0017258829869563374, 
     -0.001656913274871568, 0.0015919957299435294, -0.0015308190921182153, 
     0.0014731014175412064, -0.001418586827130362, 0.0013670426681427347, 
     -0.001318257029863239, 0.0012720365638169435, -0.0012282045665860629, 
     0.0011865992896934229, -0.0011470724463338345, 0.0011094878891843144, 
     -0.0010737204372574746, 0.001039654832904395, -0.0010071848127253477, 
     0.0009762122783915752, -0.0009466465552866787, 0.0009184037284976654, 
     -0.0008914060470691688, 0.0008655813886176693, -0.0008408627774170907, 
     0.0008171879499390436, -0.0007944989625819761, 0.0007727418369717658, 
     -0.0007518662387770922, 0.0007318251864690675, -0.0007125747868768721, 
     0.0006940739947586429, -0.0006762843939273164, 0.0006591699977510734, 
     -0.0006426970670930266, 0.0006268339439695801, -0.0006115508993955209, 
     0.0005968199940498281, -0.0005826149505423849, 0.0005689110361907993, 
     -0.0005556849553305728, 0.0005429147502827959, -0.0005305797101930354, 
     0.0005186602870345155, -0.000507138018139318, 0.0004959954546841972, 
     -0.0004852160956136449, 0.0004747843265328671, -0.00046468536314803736, 
     0.00045490519887119666, -0.000445430556243012, 0.00043624884185875504, 
     -0.00042734810451173306, 0.0004187169962943646, -0.0004103447364204546};
 
  TVIL_REAL Gx0yxxtableBL[] = 
     {0, 6.667146794107712, -0.3032150370136253, 0.5792066831171669, 
     -0.3861377887447779, 0.26446578655137787, -0.1906362547123358, 
     0.14346309972603422, -0.11171706798000247, 0.08939971070942054, 
     -0.0731374692011596, 0.06093111118240968, -0.0515396184855057, 
     0.04416124789506948, -0.038259985384353046, 0.033466727921552586, 
     -0.02952070638466875, 0.026233510779348546, -0.023466295999925446, 
     0.021114934478066782, -0.01910010460954803, 0.017360527198150955, 
     -0.01584825807568091, 0.014525352889172893, -0.013361465564588393, 
     0.012332093411401956, -0.011417277361038813, 0.010600627321322165, 
     -0.009868582951348515, 0.009209847059718612, -0.0086149470579997, 
     0.008075892437204857, -0.007585904973019808, 0.0071392045344680355, 
     -0.006730837775876353, 0.006356540174522252, -0.006012624197325067, 
     0.0056958880910542575, -0.0054035410605592915, 0.005133141555774046, 
     -0.004882546105648089, 0.004649866688964721, -0.004433435052078494, 
     0.0042317727097724855, -0.004043565615916123, 0.0038676426942174658, 
     -0.0037029575687483884, 0.0035485729613355943, -0.00340364731914633, 
     0.003267423318902729, -0.0031392179489557748, 0.003018413921836327, 
     -0.0029044522379990667, 0.0027968256927124457, -0.002695073229915579, 
     0.0025987749850173714, -0.0025075479588849703, 0.0024210421834141016, 
     -0.002338937370950589, 0.0022609399529756047, -0.002186780438933056, 
     0.0021162110497243702, -0.002049003727734089, 0.0019849482632707804, 
     -0.0019238505483372137, 0.0018655312014743686, -0.0018098243745043874, 
     0.0017565761809237301, -0.0017056441283784807, 0.0016568957944400609, 
     -0.0016102079534903169, 0.0015654662856832147, -0.001522563979960978, 
     0.0014814016176387668, -0.0014418864157050848, 0.0014039315283298492, 
     -0.0013674558140337467, 0.0013323836028575897, -0.0012986441142857075, 
     0.001266169361770153, -0.0012348983436822891, 0.0012047719210386276, 
     -0.0011757351458072662, 0.001147732138633728, -0.0011207237839698792, 
     0.0010946579277515411, -0.001069486141204834, 0.0010451823472976685, 
     -0.0010216832160949707, 0.0009989738464355469, -0.0009770244359970093, 
     0.0009557902812957764, -0.0009352266788482666, 0.0009152889251708984, 
     -0.0008960366249084473, 0.0008774399757385254, -0.000859379768371582, 
     0.0008417367935180664, -0.0008248090744018555, 0.0008081197738647461, 
     -0.0007925033569335938};
 
  TVIL_REAL Gx0yxxtableBL2[] = 
     {0, -1.2274112777602189, 1., -0.3333333333333333, 
     0.16666666666666666, -0.1, 0.06666666666666667, -0.047619047619047616, 
     0.03571428571428571, -0.027777777777777776, 0.022222222222222223, 
     -0.01818181818181818, 0.015151515151515152, -0.01282051282051282, 
     0.01098901098901099, -0.009523809523809525, 0.008333333333333333, 
     -0.007352941176470588, 0.006535947712418301, -0.005847953216374269, 
     0.005263157894736842, -0.004761904761904762, 0.004329004329004329, 
     -0.003952569169960474, 0.0036231884057971015, -0.0033333333333333335, 
     0.003076923076923077, -0.002849002849002849, 0.0026455026455026454, 
     -0.0024630541871921183, 0.0022988505747126436, -0.002150537634408602, 
     0.0020161290322580645, -0.001893939393939394, 0.0017825311942959, 
     -0.0016806722689075631, 0.0015873015873015873, -0.0015015015015015015, 
     0.001422475106685633, -0.001349527665317139, 0.001282051282051282, 
     -0.0012195121951219512, 0.0011614401858304297, -0.0011074197120708748, 
     0.0010570824524312897, -0.00101010101010101, 0.000966183574879227, 
     -0.0009250693802035153, 0.0008865248226950354, -0.0008503401360544217, 
     0.0008163265306122449, -0.000784313725490196, 0.0007541478129713424, 
     -0.000725689404934688, 0.0006988120195667365, -0.0006734006734006734, 
     0.0006493506493506494, -0.0006265664160401002, 0.0006049606775559589, 
     -0.0005844535359438924, 0.0005649717514124294, -0.000546448087431694, 
     0.0005288207297726071, -0.0005120327700972862, 0.000496031746031746, 
     -0.0004807692307692308, 0.0004662004662004662, -0.0004522840343735866, 
     0.0004389815627743635, -0.00042625745950554135, 0.00041407867494824016, 
     -0.00040241448692152917, 0.0003912363067292645, -0.000380517503805175, 
     0.00037023324694557573, -0.00036036036036036037, 0.0003508771929824561, 
     -0.0003417634996582365, 0.000333000333000333, -0.0003245699448231094, 
     0.00031645569620253165, -0.00030864197530864197, 0.00030111412225233364, 
     -0.0002938583602703497, 0.00028686173264486515, -0.00028011204481792715, 
     0.00027359781121751026, -0.0002673082063619353, 0.00026123301985370953, 
     -0.0002553626149131767, 0.00024968789013732833, -0.0002442002442002442, 
     0.00023889154323936931, -0.0002337540906965872, 0.00022878059940517045, 
     -0.00022396416573348266, 0.0002192982456140351, -0.0002147766323024055, 
     0.00021039343572480537, -0.00020614306328592042, 0.00020202020202020202};
 
  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  if (y < 0.5 * x) {
    result = TVIL_Gx00xx (x, qq);
    result += y * (-9.L/2.L + PI*PI/3.L + (2.L*PI*PI*PI)/(9.L*SQRT3) 
      + lnbarx2/2.L - lnbarx3/3.L - 2.L * lnbarx * lnbary  
      + lnbarx2 * lnbary/2.L + 3.L * SQRT3 * LS2 
      + lnbary * (5.L/2.L - 3.L * SQRT3 * LS2) 
      + lnbarx * (2.L - PI*PI/6.L + 3.L * SQRT3 * LS2) - (4.L*Zeta3)/3.L); 
    rn = r = y/x;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gx0yxxtableA[n] +
        Gx0yxxtableALx[n] * lnbarx +
        Gx0yxxtableALy[n] * lnbary +
        Gx0yxxtableALx2[n] * lnbarx2 + 
        Gx0yxxtableALxLy[n] * lnbarx * lnbary);
    }
  } 
  else if (y < 1.5 * x) {
    result = TVIL_Gx0xxx (x, qq);
    result += (y - x) * lnbarx3/6.L;
    rn = r = y/x - 1.L;
    for (n=1; n < 100; n++) {
      result += x * rn * (
        Gx0yxxtableD[n] +
        Gx0yxxtableDL[n] * lnbarx +
        Gx0yxxtableDL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else if (y < 6.47 * x) {
    result = x * (-3.345631214575005518L + 22.6667330708272511 * lnbarx 
      - 8.22741127776021876 * lnbarx2 + 1.33333333333333333 * lnbarx3);
    result += x * (0.25L * y/x - 1.L) * (2.L/3.L) * lnbarx3;
    rn = r = 0.25L * y/x - 1.L;
    for (n=1; n < 100; n++) {
      result += x * rn * (
        Gx0yxxtableB[n] +
        Gx0yxxtableBL[n] * lnbarx +
        Gx0yxxtableBL2[n] * lnbarx2); 
      rn *= r;
    }
  }
  else {
    result = TVIL_G0000x (y, qq);
    result += x * (
      -25.L/3.L + (5.L*PI*PI)/6.L + (7.L - PI*PI/3.L)*lnbarx 
      - 1.5L * lnbarx2 - 6.L * lnbarx * lnbary + 1.5L * lnbarx2 * lnbary 
      + 2.5L * lnbary2 - lnbarx * lnbary2 + lnbary3/6.L 
      + 3.L * SQRT3 * LS2 + lnbary * (7.L + PI*PI/6.L - 3.L * SQRT3 * LS2) 
      + 2.L * Zeta3/3.L);
    rn = r = 4.L * x/y;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += y * rn * (
        Gx0yxxtableC[n] +
        Gx0yxxtableCLx[n] * lnbarx +
        Gx0yxxtableCLy[n] * lnbary +
        Gx0yxxtableCLx2[n] * lnbarx2 +
        Gx0yxxtableCLxLy[n] * lnbarx * lnbary +
        Gx0yxxtableCLy2[n] * lnbary2);
    }
  }

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gyxxyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  TVIL_REAL GyxxyytableA[] = 
      {0, 0, -3.552912079216524, -0.3013652819957265, 
     -0.046850504057914494, -0.0100558978166567, -0.002817082434150755, 
     -0.001001845359473932, -0.00043291288746718056, -0.00021579578781436153, 
     -0.00011890233610229807, -0.00007037648464136127, 
     -0.00004395428274356933, -0.0000286405972462447, 
     -0.00001932171175242875, -0.00001342145707994798, 
     -9.559392234463355e-6, -6.958398092850703e-6, -5.162767773959929e-6, 
     -3.895831389168862e-6, -2.9844794791204605e-6, 
     -2.3174896000841737e-6, -1.8216971851028903e-6, 
     -1.4479453348239975e-6, -1.1625715883484937e-6, 
     -9.421219615356358e-7, -7.699955088100077e-7, -6.342711344177918e-7, 
     -5.26274035701693e-7, -4.3961399257611606e-7, -3.69530115125765e-7, 
     -3.124379487937785e-7, -2.656122569860783e-7, -2.2696207288719302e-7, 
     -1.9486933404954364e-7, -1.6807187493171053e-7, 
     -1.4557772391866246e-7, -1.2660173253385926e-7, 
     -1.1051829855792657e-7, -9.682579863232966e-8, -8.511961740150212e-8, 
     -7.507154170904697e-8, -6.641390567456488e-8, -5.892730896233242e-8, 
     -5.243104199582392e-8, -4.677557601679266e-8, -4.1836638529354726e-8, 
     -3.75105136059171e-8, -3.371029415428456e-8, -3.036287825593105e-8, 
     -2.740655024577941e-8, -2.478902371094501e-8, -2.2465851201188278e-8, 
     -2.0399126456644266e-8, -1.8556421037994837e-8, 
     -1.6909909615732136e-8, -1.5435647743358586e-8, 
     -1.4112973376604677e-8, -1.2924009209497637e-8, 
     -1.1853247456017425e-8, -1.0887202298472386e-8, 
     -1.001411806733508e-8, -9.223723477523329e-9, -8.507024049868678e-9, 
     -7.856126291548959e-9, -7.264088371242279e-9, -6.724792962508757e-9, 
     -6.2328386883398604e-9, -5.78344721692175e-9, -5.372383561754972e-9, 
     -4.995887550723792e-9, -4.650614766243856e-9, -4.333585536341545e-9, 
     -4.042140785692341e-9, -3.773903745287422e-9, -3.5267466767551824e-9, 
     -3.298761898279444e-9, -3.0882365082529698e-9, 
     -2.8936302941145766e-9, -2.7135563903567445e-9, 
     -2.546764313999848e-9, -2.3921250599876498e-9, -2.248617984671264e-9, 
     -2.11531924421703e-9, -1.991391587552935e-9, -1.8760753313130856e-9, 
     -1.7686803679409743e-9, -1.6685790783264507e-9, 
     -1.5752000376246984e-9, -1.48802241769377e-9, -1.4065710022711647e-9, 
     -1.3304117419085127e-9, -1.2591477850644065e-9, 
     -1.1924159298439298e-9, -1.1298834478592534e-9, 
     -1.0712452377289937e-9, -1.0162212709703915e-9, 
     -9.645542975826371e-10, -9.160077825693476e-10, 
     -8.703640480862493e-10, -8.274225988972024e-10};
 
  TVIL_REAL GyxxyytableALx[] = 
      {0, 0, -1.8333333333333333, -0.23555555555555555, 
     -0.050770975056689344, -0.01518140589569161, -0.005863036674724986, 
     -0.0027422232279874638, -0.0014673075287460903, -0.0008621106380238828, 
     -0.0005417661643662261, -0.00035817917449725695, 
     -0.00024646673637408425, -0.00017521230406256888, 
     -0.0001279897441756543, -0.00009567780992359566, 
     -0.00007295926103896669, -0.00005660666217470229, 
     -0.00004459264901476656, -0.000035605363353264755, 
     -0.000028773601930269775, -0.000023505359574905325, 
     -0.000019390031669280312, -0.00001613754667037115, 
     -0.000013539553561214843, -0.000011444126851959986, 
     -9.73895237336993e-6, -8.339947695703726e-6, -7.1834329667742915e-6, 
     -6.220662535714583e-6, -5.4139520124964995e-6, -4.733899789853051e-6, 
     -4.157369831353876e-6, -3.666010817495978e-6, -3.2451577372405207e-6, 
     -2.883009241125061e-6, -2.570005919668971e-6, -2.298356420695886e-6, 
     -2.061673350620265e-6, -1.8546914095699948e-6, -1.673047629059204e-6, 
     -1.5131088724376308e-6, -1.371835567946621e-6, 
     -1.2466734112547251e-6, -1.135466801027138e-6, -1.036389267324624e-6, 
     -9.47887265619066e-7, -8.686345430785006e-7, -7.974949127968208e-7, 
     -7.334917492427339e-7, -6.757828830915049e-7, -6.236398540411575e-7, 
     -5.764306969756361e-7, -5.33605605293678e-7, -4.946849468227106e-7, 
     -4.59249211060912e-7, -4.2693054800391223e-7, -3.974056234168034e-7, 
     -3.703895668425241e-7, -3.4563082975582814e-7, -3.229068042811171e-7, 
     -3.02020079496883e-7, -2.8279523387413994e-7, -2.6507607987533354e-7, 
     -2.487232909848014e-7, -2.3361235309049864e-7, 
     -2.1963179169423477e-7, -2.0668163429476947e-7, 
     -1.9467207378397024e-7, -1.8352230407606844e-7, 
     -1.731595036586431e-7, -1.635179464761922e-7, -1.54538222666217e-7, 
     -1.461665542715841e-7, -1.383541932392964e-7, -1.3105689085625277e-7, 
     -1.242344293256249e-7, -1.1785020750112285e-7, 
     -1.1187087391013219e-7, -1.0626600114303592e-7, 
     -1.010077964918992e-7, -9.607084440940435e-8, -9.143187694701954e-8, 
     -8.70695688353107e-8, -8.296435430195973e-8, -7.909826309522593e-8, 
     -7.545477350133532e-8, -7.201868042121398e-8, -6.87759768115089e-8, 
     -6.571374700237448e-8, -6.28200705846233e-8, -6.008393571542667e-8, 
     -5.7495160828098126e-8, -5.504432385040573e-8, 
     -5.2722698139726996e-8, -5.052219443422254e-8, -4.843530819880884e-8, 
     -4.6455071814551074e-8, -4.457501112145926e-8, 
     -4.2789105878657396e-8, -4.1091753753458325e-8};
 
  TVIL_REAL GyxxyytableALy[] = 
     {0, 0, 2.2777777777777777, 0.27, 0.05518140589569161, 
     0.01587238599143361, 0.005983750096304209, 0.00276479696226616, 
     0.0014717297755093292, 0.0008630066974641949, 0.0005419524345360671, 
     0.00035821868042222956, 0.0002464752515354122, 0.00017521416395074646, 
     0.00012799015494777913, 0.00009567790150463652, 0.00007295928162272298, 
     0.00005660666683373241, 0.000044592650075829494, 0.00003560536359623333, 
     0.00002877360198617628, 0.000023505359587825204, 0.00001939003167227776, 
     0.000016137546671069027, 0.000013539553561377852, 
     0.000011444126851998174, 9.738952373378901e-6, 8.339947695705837e-6, 
     7.1834329667747896e-6, 6.220662535714701e-6, 5.4139520124965275e-6, 
     4.7338997898530576e-6, 4.157369831353877e-6, 3.6660108174959783e-6, 
     3.2451577372405207e-6, 2.883009241125061e-6, 2.570005919668971e-6, 
     2.298356420695886e-6, 2.061673350620265e-6, 1.8546914095699948e-6, 
     1.673047629059204e-6, 1.5131088724376308e-6, 1.371835567946621e-6, 
     1.2466734112547251e-6, 1.135466801027138e-6, 1.036389267324624e-6, 
     9.47887265619066e-7, 8.686345430785006e-7, 7.974949127968208e-7, 
     7.334917492427339e-7, 6.757828830915049e-7, 6.236398540411575e-7, 
     5.764306969756361e-7, 5.33605605293678e-7, 4.946849468227106e-7, 
     4.59249211060912e-7, 4.2693054800391223e-7, 3.974056234168034e-7, 
     3.703895668425241e-7, 3.4563082975582814e-7, 3.229068042811171e-7, 
     3.02020079496883e-7, 2.8279523387413994e-7, 2.6507607987533354e-7, 
     2.487232909848014e-7, 2.3361235309049864e-7, 2.1963179169423477e-7, 
     2.0668163429476947e-7, 1.9467207378397024e-7, 1.8352230407606844e-7, 
     1.731595036586431e-7, 1.635179464761922e-7, 1.54538222666217e-7, 
     1.461665542715841e-7, 1.383541932392964e-7, 1.3105689085625277e-7, 
     1.242344293256249e-7, 1.1785020750112285e-7, 1.1187087391013219e-7, 
     1.0626600114303592e-7, 1.010077964918992e-7, 9.607084440940435e-8, 
     9.143187694701954e-8, 8.70695688353107e-8, 8.296435430195973e-8, 
     7.909826309522593e-8, 7.545477350133532e-8, 7.201868042121398e-8, 
     6.87759768115089e-8, 6.571374700237448e-8, 6.28200705846233e-8, 
     6.008393571542667e-8, 5.7495160828098126e-8, 5.504432385040573e-8, 
     5.2722698139726996e-8, 5.052219443422254e-8, 4.843530819880884e-8, 
     4.6455071814551074e-8, 4.457501112145926e-8, 4.2789105878657396e-8, 
     4.1091753753458325e-8};
 
  TVIL_REAL GyxxyytableALx2[] = 
     {0, 0, -0.25, -0.058333333333333334, -0.02023809523809524, 
     -0.008928571428571428, -0.004653679653679654, -0.0027264402264402265, 
     -0.0017357642357642357, -0.0011743566890625714, -0.0008320283088084946, 
     -0.000611192213359396, -0.00046224863663280676, -0.0003581049564694739, 
     -0.00028307908271564216, -0.0002276523723984978, 
     -0.00018581397656310166, -0.0001536386488623805, -0.0001284880870602341, 
     -0.00010854392832970607, -0.00009252498211117374, 
     -0.00007951072465874468, -0.00006882812583929329, 
     -0.00005997733125095148, -0.00005258180524806419, 
     -0.00004635423320447765, -0.00004107279091990726, 
     -0.00003656436435849557, -0.000032692510171123, 
     -0.000029348701419407363, -0.000026445883173356355, 
     -0.000023913674151114232, -0.00002169475600628168, 
     -0.0000197421294625702, -0.000018017009978344377, 
     -0.00001648719998690527, -0.00001512581962574906, 
     -0.000013910309509607662, -0.00001282164166021006, 
     -0.000011843690952889034, -0.00001096273125481687, 
     -0.000010167029099134624, -9.446514155396475e-6, 
     -8.792510543777237e-6, -8.197516639482377e-6, -7.655023739318834e-6, 
     -7.1593660407101965e-6, -6.705595978685345e-6, -6.289380198497691e-6, 
     -5.906912398885635e-6, -5.554840029084623e-6, -5.230202410471993e-6, 
     -4.930378317936612e-6, -4.653041424521215e-6, -4.396122306737569e-6, 
     -4.157775943384241e-6, -3.936353830150443e-6, -3.7303799853910383e-6, 
     -3.5385302466863346e-6, -3.3596143589957844e-6, -3.19256043795876e-6, 
     -3.0364014597985985e-6, -2.890263485205378e-6, -2.753355370779257e-6, 
     -2.624959759921496e-6, -2.5044251769158336e-6, -2.391159074515571e-6, 
     -2.2846217075830778e-6, -2.1843207239809136e-6, 
     -2.0898063796067977e-6, -2.000667297703246e-6, -1.916526703769692e-6, 
     -1.8370390768991011e-6, -1.7618871664310731e-6, 
     -1.6907793296891598e-6, -1.6234471524418424e-6, 
     -1.5596433187521605e-6, -1.4991397011916618e-6, 
     -1.4417256460996752e-6, -1.3872064317604598e-6, 
     -1.3354018801253067e-6, -1.2861451050886372e-6, 
     -1.239281382390873e-6, -1.1946671280121528e-6, 
     -1.1521689734786278e-6, -1.111662927859921e-6, -1.073033617420303e-6, 
     -1.0361735949209858e-6, -1.0009827114768979e-6, 
     -9.673675446657256e-7, -9.352408772846709e-7, -9.045212217640329e-7, 
     -8.751323857872467e-7, -8.470030751438558e-7, -8.200665302631155e-7, 
     -7.942601932485513e-7, -7.695254025638715e-7, -7.458071128134023e-7, 
     -7.230536373202359e-7, -7.012164114365059e-7, -6.802497747260794e-7};
 
  TVIL_REAL GyxxyytableALy2[] = 
      {0, 0, -0.4166666666666667, -0.075, -0.02261904761904762, 
     -0.009325396825396825, -0.004725829725829726, -0.0027403152403152405, 
     -0.0017385392385392386, -0.0011749280131633072, -0.0008321485875665442, 
     -0.0006112179873789781, -0.000462254239680542, -0.00035810618913997567, 
     -0.0002830793566424203, -0.0002276524337958791, -0.00018581399042702648, 
     -0.0001536386520132725, -0.000128488087780438, -0.00010854392849515832, 
     -0.00009252498214935502, -0.00007951072466759155, 
     -0.0000688281258413507, -0.00005997733125143154, 
     -0.000052581805248176546, -0.00004635423320450402, 
     -0.00004107279091991346, -0.00003656436435849703, 
     -0.00003269251017112335, -0.000029348701419407444, 
     -0.000026445883173356372, -0.00002391367415111424, 
     -0.00002169475600628168, -0.0000197421294625702, 
     -0.000018017009978344377, -0.00001648719998690527, 
     -0.00001512581962574906, -0.000013910309509607662, 
     -0.00001282164166021006, -0.000011843690952889034, 
     -0.00001096273125481687, -0.000010167029099134624, 
     -9.446514155396475e-6, -8.792510543777237e-6, -8.197516639482377e-6, 
     -7.655023739318834e-6, -7.1593660407101965e-6, -6.705595978685345e-6, 
     -6.289380198497691e-6, -5.906912398885635e-6, -5.554840029084623e-6, 
     -5.230202410471993e-6, -4.930378317936612e-6, -4.653041424521215e-6, 
     -4.396122306737569e-6, -4.157775943384241e-6, -3.936353830150443e-6, 
     -3.7303799853910383e-6, -3.5385302466863346e-6, 
     -3.3596143589957844e-6, -3.19256043795876e-6, -3.0364014597985985e-6, 
     -2.890263485205378e-6, -2.753355370779257e-6, -2.624959759921496e-6, 
     -2.5044251769158336e-6, -2.391159074515571e-6, 
     -2.2846217075830778e-6, -2.1843207239809136e-6, 
     -2.0898063796067977e-6, -2.000667297703246e-6, -1.916526703769692e-6, 
     -1.8370390768991011e-6, -1.7618871664310731e-6, 
     -1.6907793296891598e-6, -1.6234471524418424e-6, 
     -1.5596433187521605e-6, -1.4991397011916618e-6, 
     -1.4417256460996752e-6, -1.3872064317604598e-6, 
     -1.3354018801253067e-6, -1.2861451050886372e-6, 
     -1.239281382390873e-6, -1.1946671280121528e-6, 
     -1.1521689734786278e-6, -1.111662927859921e-6, -1.073033617420303e-6, 
     -1.0361735949209858e-6, -1.0009827114768979e-6, 
     -9.673675446657256e-7, -9.352408772846709e-7, -9.045212217640329e-7, 
     -8.751323857872467e-7, -8.470030751438558e-7, -8.200665302631155e-7, 
     -7.942601932485513e-7, -7.695254025638715e-7, -7.458071128134023e-7, 
     -7.230536373202359e-7, -7.012164114365059e-7, -6.802497747260794e-7};
 
  TVIL_REAL GyxxyytableALxLy[] = 
     {0, 0, 0.6666666666666666, 0.13333333333333333, 
     0.04285714285714286, 0.018253968253968255, 0.00937950937950938, 
     0.005466755466755467, 0.0034743034743034743, 0.0023492847022258787, 
     0.0016641768963750387, 0.0012224102007383742, 0.0009245028763133488, 
     0.0007162111456094495, 0.0005661584393580625, 0.0004553048061943769, 
     0.00037162796699012813, 0.000307277300875653, 0.0002569761748406721, 
     0.00021708785682486437, 0.00018504996426052875, 0.00015902144932633622, 
     0.000137656251680644, 0.00011995466250238303, 0.00010516361049624074, 
     0.00009270846640898168, 0.00008214558183982073, 0.0000731287287169926, 
     0.00006538502034224635, 0.00005869740283881481, 0.00005289176634671273, 
     0.00004782734830222847, 0.00004338951201256336, 0.0000394842589251404, 
     0.000036034019956688755, 0.00003297439997381054, 0.00003025163925149812, 
     0.000027820619019215323, 0.00002564328332042012, 
     0.000023687381905778068, 0.00002192546250963374, 
     0.000020334058198269248, 0.00001889302831079295, 
     0.000017585021087554475, 0.000016395033278964753, 
     0.000015310047478637667, 0.000014318732081420393, 
     0.00001341119195737069, 0.000012578760396995382, 0.00001181382479777127, 
     0.000011109680058169246, 0.000010460404820943987, 9.860756635873224e-6, 
     9.30608284904243e-6, 8.792244613475137e-6, 8.315551886768482e-6, 
     7.872707660300886e-6, 7.460759970782077e-6, 7.077060493372669e-6, 
     6.719228717991569e-6, 6.38512087591752e-6, 6.072802919597197e-6, 
     5.780526970410756e-6, 5.506710741558514e-6, 5.249919519842992e-6, 
     5.008850353831667e-6, 4.782318149031142e-6, 4.5692434151661555e-6, 
     4.368641447961827e-6, 4.1796127592135954e-6, 4.001334595406492e-6, 
     3.833053407539384e-6, 3.6740781537982023e-6, 3.5237743328621462e-6, 
     3.3815586593783197e-6, 3.2468943048836848e-6, 3.119286637504321e-6, 
     2.9982794023833237e-6, 2.8834512921993504e-6, 2.7744128635209196e-6, 
     2.6708037602506133e-6, 2.5722902101772744e-6, 2.478562764781746e-6, 
     2.3893342560243055e-6, 2.3043379469572556e-6, 2.223325855719842e-6, 
     2.146067234840606e-6, 2.0723471898419715e-6, 2.0019654229537957e-6, 
     1.934735089331451e-6, 1.8704817545693419e-6, 1.8090424435280658e-6, 
     1.7502647715744933e-6, 1.6940061502877115e-6, 1.640133060526231e-6, 
     1.5885203864971026e-6, 1.539050805127743e-6, 1.4916142256268047e-6, 
     1.4461072746404718e-6, 1.4024328228730118e-6, 1.3604995494521588e-6};

  TVIL_REAL GyxxyytableC[] = 
     {0, 2.3405468035299375, -0.06124439280566024, 
     0.0040589431288650295, 0.003859016140959534, 0.0030771329277003412, 
     0.0025018174501127513, 0.002080715281643196, 0.0017636393461934476, 
     0.0015185163710057037, 0.0013247042626526252, 0.0011684948229293978, 
     0.0010405037957377287, 0.0009341307006288819, 0.0008446207709606427, 
     0.0007684756958822566, 0.0007030728824114805, 0.0006464131013441378, 
     0.0005969493359266184, 0.0005534682659552198, 0.0005150066397778812, 
     0.0004807912457021324, 0.00045019514596524463, 0.00042270530938279396, 
     0.00039789835899819396, 0.00037542218041835656, 0.00035498181908794627, 
     0.000336328554873497, 0.0003192513572642824, 0.00030357014313728547, 
     0.0002891304128386194, 0.0002757989498694713, 0.0002634603483754085, 
     0.00025201419010155917, 0.00024137273474664575, 0.00023145901903963998, 
     0.00022220528338331232, 0.00021355166268143173, 0.00020544509150274858, 
     0.00019783838412265378, 0.00019068945801188654, 0.00018396067558873542, 
     0.00017761828394336895, 0.00017163193609751187, 0.00016597428041738614, 
     0.000160620607232068, 0.00015554854365945316, 0.00015073778921206938, 
     0.000146169886025174, 0.00014182801858193087, 0.0001376968386532214, 
     0.00013376231186054287, 0.00013001158283914918, 0.00012643285644853535, 
     0.00012301529286716167, 0.00011974891473279193, 0.00011662452476086517, 
     0.00011363363250048767, 0.00011076838907863585, 0.00010802152894425991, 
     0.00010538631776025814, 0.00010285650570691342, 0.00010042628555874869, 
     0.00009809025498067257, 0.00009584338256105577, 0.00009368097716092026, 
     0.00009159866021131984, 0.00008959234063656784, 0.00008765819212032579, 
     0.00008579263246563226, 0.00008399230482949817, 0.00008225406063837682, 
     0.00008057494401318562, 0.00007895217755207654, 0.00007738314933622117, 
     0.00007586540103882723, 0.00007439661703072587, 0.00007297461438740422, 
     0.00007159733371251766, 0.00007026283070187739, 0.00006896926837982815, 
     0.00006771490994693826, 0.00006649811218413591, 0.00006531731936393953, 
     0.00006417105762433191, 0.00006305792976519187, 0.00006197661043108843, 
     0.000060925841647715386, 0.00005990442868235012, 
     0.000058911236201499426, 0.00005794518470138678, 0.00005700524718917085, 
     0.00005609044609479371, 0.000055199850395164285, 0.00005433257293400954, 
     0.00005348776792219338, 0.000052664628604627365, 0.00005186238508109431, 
     0.000051080302269388134, 0.00005031767800015366, 0.000049573841233698784};
 
  TVIL_REAL GyxxyytableCLx[] = 
     {0, -0.5079304290170942, 0.060517392745726456, 
     0.011161474150641006, 0.00724718870526174, 0.0054517213297943295, 
     0.004295361092831858, 0.0034911729412783195, 0.002906812127517385, 
     0.0024674745688600093, 0.00212782331368195, 0.001859071111179419, 
     0.001642221262376524, 0.001464315815473361, 0.001316258781726241, 
     0.0011915037517990815, 0.0010852352235715694, 0.000993842178111317, 
     0.0009145703036128229, 0.0008452866291799376, 0.0007843167537939706, 
     0.000730330069717893, 0.0006822573953762295, 0.0006392309178247292, 
     0.0006005397629809384, 0.0005655966889795823, 0.000533912812942715, 
     0.0005050782181009252, 0.00047874691884869006, 0.00045462509263517677, 
     0.00043246178688923084, 0.00041204151967489245, 0.00039317834268069436, 
     0.00037571104315461045, 0.00035949924006932796, 0.00034442018769456097, 
     0.0003303661427628967, 0.0003172421836575101, 0.00030496439442532233, 
     0.0002934583449948969, 0.00028265781324160526, 0.00027250370557297196, 
     0.00026294314129526007, 0.0002539286727520615, 0.00024541761853132604, 
     0.00023737149124456255, 0.00022975550473674345, 0.0002225381482746015, 
     0.00021569081742747512, 0.00020918749310862796, 0.00020300446167120548, 
     0.00019712007011797822, 0.00019151451143963595, 0.00018616963588344478, 
     0.0001810687846048196, 0.00017619664269441344, 0.00017153910902312387, 
     0.00016708318072334406, 0.0001628168504400179, 0.00015872901475024538, 
     0.00015480939237396101, 0.0001510484509876021, 0.00014743734161344477, 
     0.00014396783969411757, 0.00014063229207858332, 0.00013742356924580809, 
     0.00013433502217805564, 0.0001313604433694602, 0.00012849403151906833, 
     0.00012573035951243277, 0.00012306434534337053, 0.00012049122566873853, 
     0.00011800653172494051, 0.00011560606736612447, 0.00011328588901130703, 
     0.00011104228731152009, 0.00010887177036898335, 0.00010677104835866152, 
     0.00010473701941870719, 0.00010276675669051173, 0.00010085749640163466, 
     0.00009900662689597409, 0.00009721167852535972, 0.00009547031432545495, 
     0.0000937803214065862, 0.00009213960299699104, 0.00009054617108209938, 
     0.00008899813958892156, 0.0000874937180694921, 0.0000860312058416785, 
     0.00008460898654956687, 0.0000832255231091367, 0.0000818793530080775, 
     0.0000805690839314235, 0.00007929338968722261, 0.00007805100640874382, 
     0.00007684072901179134, 0.00007566140788755613, 0.00007451194581312002, 
     0.00007339129506325093, 0.00007229845470850791};
 
  TVIL_REAL GyxxyytableCLy[] = 
      {0, 1.935463395592981, -0.10988415110175476, 
     -0.03931707555087738, -0.028262408330409473, -0.021998312567397742, 
     -0.017733407819645528, -0.014665968743213551, -0.01237855271509004, 
     -0.010622747543941567, -0.009242215537261551, -0.008134532159957025, 
     -0.007230299915814625, -0.006481112332615906, -0.0058523376600299925, 
     -0.005318641625055316, -0.00486112395521829, -0.004465436669107643, 
     -0.004120517122599932, -0.0038177161468290004, -0.0035501861487067772, 
     -0.0033124439477118977, -0.003100053361076023, -0.002909391315743596, 
     -0.00273747317011872, -0.0025818206340502757, -0.0024403607561950163, 
     -0.0023113478556362, -0.002193302596659919, -0.0020849640111292034, 
     -0.0019852513982110227, -0.0018932338299760935, -0.001808105565092597, 
     -0.0017291660894551103, -0.0016558038082785547, -0.0015874826406648472, 
     -0.001523730936977776, -0.0014641322670514996, -0.0014083177243311, 
     -0.0013559594654073454, -0.0013067652617884018, -0.0012604738853318406, 
     -0.0012168511836222007, -0.0011756867290102799, -0.0011367909467414493, 
     -0.0010999926448807364, -0.0010651368825700307, -0.0010320831242739276, 
     -0.001000703636658866, -0.000970882092048308, -0.0009425123483490326, 
     -0.0009154973802191084, -0.000889748340257965, -0.0008651837323099069, 
     -0.0008417286817165568, -0.0008193142896364011, -0.0007978770604550659, 
     -0.0007773583929058901, -0.0007577041268613995, -0.0007388641388866522, 
     -0.0007207919806011107, -0.0007034445547060364, -0.000686781824223444, 
     -0.0006707665510801422, -0.0006553640606726237, -0.0006405420294789922, 
     -0.0006262702931539285, -0.0006125206728611798, -0.000599266817872973, 
     -0.0005864840627035915, -0.000574149297250572, -0.0005622408485961407, 
     -0.0005507383732775072, -0.0005396227589707053, -0.0005288760346516248, 
     -0.0005184812884020251, -0.0005084225921197093, -0.0004986849324723412, 
     -0.0004892541475050926, -0.0004801168683746605, -0.00047126046573726645, 
     -0.0004626730003669831, -0.00045434317762390453, -0.0004462603054300009, 
     -0.0004384142554445522, -0.00043079542716136773, -0.0004233947146770176, 
     -0.00041620347590341577, -0.0004092135040196466, 
     -0.00040241700097721513, -0.00039580655289018243, 
     -0.00038937510715715545, -0.0003831159511760273, -0.0003770226925248926, 
     -0.00037108924049384035, -0.00036530978886249716, 
     -0.0003596787998273663, -0.0003541909889913012, -0.00034884131133494867, 
     -0.0003436249480967841, -0.0003385372944945153};
 
  TVIL_REAL GyxxyytableCLx2[] = 
     {0, 0., 0., 0.005208333333333333, 0.0035807291666666665, 
     0.0025390625, 0.0019083658854166666, 0.0015000116257440476, 
     0.0012188502720424108, 0.0010157236977229043, 0.000863367792159792, 
     0.0007456363021553337, 0.0006524318546959849, 0.0005771512734445381, 
     0.0005153136404154898, 0.0004637822770562285, 0.0004203026887207967, 
     0.00038321715739161253, 0.0003512823942815892, 0.0003235495736816626, 
     0.0002992833556558038, 0.0002779059731090177, 0.0002589578385788697, 
     0.00024206928388894607, 0.00022693995364588752, 0.00021332355642713442, 
     0.00020101642817172284, 0.00018984884882884936, 0.0001796783747844467, 
     0.00017038466574387188, 0.0001618654324566783, 0.0001540332341120003, 
     0.0001468129262630003, 0.0001401396114328639, 0.00013395698151670815, 
     0.00012821596802313495, 0.00012287363602217098, 0.00011789227239965054, 
     0.0001132386300680854, 0.0001088832981423898, 0.00010480017446205018, 
     0.00010096602173782883, 0.00009736009239004923, 0.0000939638100973731, 
     0.00009076049838950811, 0.00008773514844319117, 0.00008487421968960884, 
     0.00008216546799738729, 0.00007959779712246893, 0.00007716112986361784, 
     0.0000748462959677093, 0.00007264493432160021, 0.00007054940737001559, 
     0.00006855272602935478, 0.00006664848363965048, 0.00006483079772220546, 
     0.00006309425849750353, 0.00006143388327388502, 0.000059845075947836264, 
     0.000058323590966111615, 0.000056865501191958824, 
     0.000055467169195435246, 0.0000541252215536102, 0.00005283652580233377, 
     0.000051598169728841567, 0.00005040744273509907, 0.00004926181903657409, 
     0.00004815894249097915, 0.00004709661287720755, 0.00004607277346683347, 
     0.00004508549974968704, 0.00004413298919159506, 0.00004321355191677017, 
     0.00004232560221985023, 0.00004146765082350192, 0.000040638297807031876, 
     0.00003983622613978783, 0.00003906019576044131, 0.00003830903814966359, 
     0.00003758165134935353, 0.00003687699538655315, 0.00003619408806457994, 
     0.00003553200108778884, 0.00003488985648981676, 0.00003426682333821289, 
     0.00003366211469106795, 0.00003307498478366561, 0.00003250472642532654, 
     0.0000319506685885312, 0.00003141217417411775, 0.00003088863793788246, 
     0.000030379484565280003, 0.000029884166882150436, 
     0.00002940216419050285, 0.000028932980719377802, 
     0.000028476144181703418, 0.000028031204428864302, 
     0.000027597732195428254, 0.000027175317927130884, 
     0.00002676357068581072, 0.000026362117125523557};
 
  TVIL_REAL GyxxyytableCLy2[] = 
     {0, 0.25, 0.0625, 0.057291666666666664, 0.0419921875, 
     0.03177083333333333, 0.024971516927083333, 0.020248849051339286, 
     0.016829935709635417, 0.014267406766376799, 0.012290948913210914, 
     0.010729872010659001, 0.009472064734107315, 0.008441333944540943, 
     0.007584348479541177, 0.006862813874439045, 0.0062486137419714895, 
     0.005720697204228917, 0.005263028800790325, 0.004863204477132612, 
     0.0045114964373582835, 0.004200180817737125, 0.003923055936688619, 
     0.003675091492410318, 0.0034521693440349977, 0.0032508893877867782, 
     0.0030684223892035243, 0.0029023971493419174, 0.002750813091267884, 
     0.0026119718857093295, 0.0024844234898481437, 0.0023669232061590923, 
     0.0022583972453158368, 0.002157914908544145, 0.002064665964280518, 
     0.0019779421318360225, 0.0018971218355742783, 0.0018216575810023684, 
     0.001751065446131864, 0.0016849162895873381, 0.0016228283599144058, 
     0.0015644610546750343, 0.001509509627829932, 0.0014577006830018943, 
     0.001408788321022894, 0.0013625508345891137, 0.001318787862314052, 
     0.001277317930068073, 0.0012379763200550547, 0.0012006132182429536, 
     0.0011650920990301677, 0.001131288312778865, 0.001099087847381241, 
     0.0010683862395820347, 0.0010390876155477833, 0.0010111038432989536, 
     0.0009843537822238312, 0.0009587626170678687, 0.000934261265615533, 
     0.0009107858508152523, 0.000888277229391923, 0.0008666805700863041, 
     0.0008459449755898053, 0.0008260231430339295, 0.0008068710585683927, 
     0.0007884477221392483, 0.0007707148990734909, 0.000753636895502352, 
     0.0007371803550224184, 0.000721314074310652, 0.0007060088356837844, 
     0.0006912372548306335, 0.000676973642152866, 0.0006631938763300573, 
     0.0006498752888823051, 0.0006369965586413174, 0.0006245376151615249, 
     0.0006124795502086536, 0.0006008045365563054, 0.0005894957534031181, 
     0.0005785373177954475, 0.0005679142215044702, 0.0005576122728632313, 
     0.000547618043119346, 0.0005379188169036403, 0.0005285025464546388, 
     0.0005193578092741013, 0.000510473768920275, 0.0005018401386736313, 
     0.0004934471478349775, 0.00048528551043833257, 0.00047734639618111533, 
     0.0004696214033922975, 0.0004621025338754359, 0.00045478216947813203, 
     0.0004476530502526501, 0.00044070825408431055, 0.0004339411776750077, 
     0.0004273455187788993, 0.0004209152595960908, 0.00041464465123808487};
 
  TVIL_REAL GyxxyytableCLxLy[] = 
      {0, -1., -0.0625, -0.0625, -0.045572916666666664, 
     -0.03430989583333333, -0.0268798828125, -0.021748860677083332, 
     -0.018048785981677827, -0.015283130464099702, -0.013154316705370706, 
     -0.011475508312814336, -0.010124496588803301, -0.00901848521798548, 
     -0.008099662119956667, -0.007326596151495273, -0.006668916430692286, 
     -0.00610391436162053, -0.005614311195071914, -0.005186754050814275, 
     -0.004810779793014087, -0.004478086790846143, -0.004182013775267488, 
     -0.003917160776299264, -0.0036791092976808854, -0.0034642129442139127, 
     -0.003269438817375247, -0.0030922459981707665, -0.0029304914660523308, 
     -0.0027823565514532014, -0.002646288922304822, -0.0025209564402710926, 
     -0.002405210171578837, -0.002298054519977009, -0.0021986229457972265, 
     -0.0021061580998591573, -0.002019995471596449, -0.001939549853402019, 
     -0.0018643040761999496, -0.001793799587729728, -0.0017276285343764558, 
     -0.0016654270764128632, -0.0016068697202199812, -0.0015516644930992675, 
     -0.0014995488194124022, -0.0014502859830323048, -0.001403662082003661, 
     -0.0013594833980654602, -0.0013175741171775237, -0.0012777743481065713, 
     -0.001239938394997877, -0.0012039332471004652, -0.0011696372547512566, 
     -0.0011369389656113896, -0.0011057360991874338, -0.001075934641021159, 
     -0.0010474480407213346, -0.0010201965003417538, -0.0009941063415633692, 
     -0.0009691094417813639, -0.0009451427305838819, -0.0009221477392817393, 
     -0.0009000701971434155, -0.0008788596688362632, -0.0008584692282972341, 
     -0.0008388551648743474, -0.000819976718110065, -0.0008017958379933311, 
     -0.000784276967899626, -0.0007673868477774854, -0.0007510943354334714, 
     -0.0007353702440222286, -0.0007201871940696362, -0.0007055194785499075, 
     -0.000691342939705807, -0.0006776348564483492, -0.0006643738413013127, 
     -0.0006515397459690949, -0.000639113574705969, -0.0006270774047524716, 
     -0.0006154143131820006, -0.0006041083095690502, -0.0005931442739510202, 
     -0.0005825078996091628, -0.0005721856402418531, -0.0005621646611457067, 
     -0.0005524327940577669, -0.0005429784953456016, -0.0005337908072621625, 
     -0.0005248593220090953, -0.0005161741483762151, -0.0005077258807463953, 
     -0.000499505570274448, -0.0004915046980659387, -0.0004837151501975098, 
     -0.0004761291944343535, -0.00046873945851317483, -0.000461538909870436, 
     -0.0004545208367060302, -0.00044767883028190146, -0.0004410067683636084};
 
  TVIL_REAL GyxxyytableCLx2Ly[] = 
      {0, 0., -0.0625, -0.03125, -0.01953125, -0.013671875, 
     -0.01025390625, -0.008056640625, -0.0065460205078125, 
     -0.00545501708984375, -0.0046367645263671875, -0.004004478454589844, 
     -0.0035039186477661133, -0.0030996203422546387, -0.002767518162727356, 
     -0.0024907663464546204, -0.0022572570014744997, -0.002058087266050279, 
     -0.0018865799938794225, -0.0017376394680468366, -0.0016073165079433238, 
     -0.0014925081859473721, -0.001390746264178233, -0.0013000454208622614, 
     -0.00121879258205837, -0.0011456650271348678, -0.001079568967877087, 
     -0.0010195929141061377, -0.0009649718651361661, -0.0009150595272842954, 
     -0.0008693065509200806, -0.0008272433307142703, -0.0007884662995870388, 
     -0.0007526269223330826, -0.000719422793406623, -0.0006885903879749107, 
     -0.0006598991218092894, -0.0006331464547089128, -0.0006081538314967189, 
     -0.0005847632995160758, -0.000562834675784223, -0.0005422431632555319, 
     -0.0005228773359964058, -0.0005046374289267636, -0.00048743388021335127, 
     -0.00047118608420623954, -0.0004558213205908187, 
     -0.00044127383163579257, -0.00042748402439717406, 
     -0.0004143977787523626, -0.0004019658453897917, -0.0003901433205253861, 
     -0.0003788891862794615, -0.0003681659074224956, -0.0003579390766607596, 
     -0.0003481771018427389, -0.00033885092947195125, 
     -0.00032993379974900517, -0.0003214010290658412, -0.0003132298164624724, 
     -0.0003053990710509106, -0.0002978892578283472, -0.00029068225965508075, 
     -0.0002837612534728169, -0.00027711059909454774, -0.0002707157391154428, 
     -0.00026456310868100093, -0.0002586400540090382, -0.0002529347587000153, 
     -0.0002474361769891454, -0.00024213397319652088, 
     -0.00023701846672053806, -0.0002320805819971935, -0.0002273118029150594, 
     -0.00022270413123434872, -0.00021825004860966175, 
     -0.00021394248186078685, -0.0002097747711751871, 
     -0.00020574064096027966, -0.00020183417309394523, 
     -0.00019804978234843376, -0.00019438219378642573, 
     -0.00019082642194886916, -0.00018737775167268478, 
     -0.00018403172039281542, -0.00018078410179764808, 
     -0.00017763089071978213, -0.00017456828915564794, 
     -0.0001715926933177676, -0.00016870068163263668, 
     -0.00016588900360542605, -0.0001631545694800619, -0.0001604944406298435, 
     -0.00015790582061968474, -0.00015538604688639188, 
     -0.00015293258298818569, -0.0001505430113789953, 
     -0.00014821502666694897, -0.00014594642932000588, 
     -0.00014373511978485427, -0.00014157909298808148};
 
  TVIL_REAL GyxxyytableCLxLy2[] = 
     {0, 0.25, 0.125, 0.0625, 0.0390625, 0.02734375, 
     0.0205078125, 0.01611328125, 0.013092041015625, 0.0109100341796875, 
     0.009273529052734375, 0.008008956909179688, 0.0070078372955322266, 
     0.006199240684509277, 0.005535036325454712, 0.004981532692909241, 
     0.004514514002948999, 0.004116174532100558, 0.003773159987758845, 
     0.003475278936093673, 0.0032146330158866476, 0.0029850163718947442, 
     0.002781492528356466, 0.0026000908417245228, 0.00243758516411674, 
     0.0022913300542697357, 0.002159137935754174, 0.0020391858282122755, 
     0.0019299437302723321, 0.0018301190545685908, 0.0017386131018401613, 
     0.0016544866614285406, 0.0015769325991740776, 0.0015052538446661652, 
     0.001438845586813246, 0.0013771807759498213, 0.0013197982436185787, 
     0.0012662929094178256, 0.0012163076629934377, 0.0011695265990321515, 
     0.001125669351568446, 0.0010844863265110638, 0.0010457546719928115, 
     0.0010092748578535273, 0.0009748677604267025, 0.0009423721684124791, 
     0.0009116426411816373, 0.0008825476632715851, 0.0008549680487943481, 
     0.0008287955575047252, 0.0008039316907795834, 0.0007802866410507722, 
     0.000757778372558923, 0.0007363318148449912, 0.0007158781533215192, 
     0.0006963542036854778, 0.0006777018589439025, 0.0006598675994980103, 
     0.0006428020581316825, 0.0006264596329249448, 0.0006107981421018212, 
     0.0005957785156566944, 0.0005813645193101615, 0.0005675225069456338, 
     0.0005542211981890955, 0.0005414314782308857, 0.0005291262173620019, 
     0.0005172801080180764, 0.0005058695174000306, 0.0004948723539782908, 
     0.00048426794639304176, 0.0004740369334410761, 0.000464161163994387, 
     0.0004546236058301188, 0.00044540826246869744, 0.0004365000972193235, 
     0.0004278849637215737, 0.0004195495423503742, 0.0004114812819205593, 
     0.00040366834618789046, 0.0003960995646968675, 0.00038876438757285146, 
     0.0003816528438977383, 0.00037475550334536956, 0.00036806344078563083, 
     0.00036156820359529616, 0.00035526178143956426, 0.0003491365783112959, 
     0.0003431853866355352, 0.00033740136326527336, 0.0003317780072108521, 
     0.0003263091389601238, 0.000320988881259687, 0.0003158116412393695, 
     0.00031077209377278377, 0.00030586516597637137, 0.0003010860227579906, 
     0.00029643005333389793, 0.00029189285864001177, 0.00028747023956970854, 
     0.00028315818597616295};
 
  TVIL_REAL GyxxyytableCLy3[] = 
      {0, -0.16666666666666666, -0.0625, -0.03125, -0.01953125, 
     -0.013671875, -0.01025390625, -0.008056640625, -0.0065460205078125, 
     -0.00545501708984375, -0.0046367645263671875, -0.004004478454589844, 
     -0.0035039186477661133, -0.0030996203422546387, -0.002767518162727356, 
     -0.0024907663464546204, -0.0022572570014744997, -0.002058087266050279, 
     -0.0018865799938794225, -0.0017376394680468366, -0.0016073165079433238, 
     -0.0014925081859473721, -0.001390746264178233, -0.0013000454208622614, 
     -0.00121879258205837, -0.0011456650271348678, -0.001079568967877087, 
     -0.0010195929141061377, -0.0009649718651361661, -0.0009150595272842954, 
     -0.0008693065509200806, -0.0008272433307142703, -0.0007884662995870388, 
     -0.0007526269223330826, -0.000719422793406623, -0.0006885903879749107, 
     -0.0006598991218092894, -0.0006331464547089128, -0.0006081538314967189, 
     -0.0005847632995160758, -0.000562834675784223, -0.0005422431632555319, 
     -0.0005228773359964058, -0.0005046374289267636, -0.00048743388021335127, 
     -0.00047118608420623954, -0.0004558213205908187, 
     -0.00044127383163579257, -0.00042748402439717406, 
     -0.0004143977787523626, -0.0004019658453897917, -0.0003901433205253861, 
     -0.0003788891862794615, -0.0003681659074224956, -0.0003579390766607596, 
     -0.0003481771018427389, -0.00033885092947195125, 
     -0.00032993379974900517, -0.0003214010290658412, -0.0003132298164624724, 
     -0.0003053990710509106, -0.0002978892578283472, -0.00029068225965508075, 
     -0.0002837612534728169, -0.00027711059909454774, -0.0002707157391154428, 
     -0.00026456310868100093, -0.0002586400540090382, -0.0002529347587000153, 
     -0.0002474361769891454, -0.00024213397319652088, 
     -0.00023701846672053806, -0.0002320805819971935, -0.0002273118029150594, 
     -0.00022270413123434872, -0.00021825004860966175, 
     -0.00021394248186078685, -0.0002097747711751871, 
     -0.00020574064096027966, -0.00020183417309394523, 
     -0.00019804978234843376, -0.00019438219378642573, 
     -0.00019082642194886916, -0.00018737775167268478, 
     -0.00018403172039281542, -0.00018078410179764808, 
     -0.00017763089071978213, -0.00017456828915564794, 
     -0.0001715926933177676, -0.00016870068163263668, 
     -0.00016588900360542605, -0.0001631545694800619, -0.0001604944406298435, 
     -0.00015790582061968474, -0.00015538604688639188, 
     -0.00015293258298818569, -0.0001505430113789953, 
     -0.00014821502666694897, -0.00014594642932000588, 
     -0.00014373511978485427, -0.00014157909298808148};
 
  TVIL_REAL GyxxyytableB[] = {-16.165688767687847, -16.330904828648134, -7.66873881867253, 
     3.9269164641426095, -1.9535403922052537, 1.1289563739574269, 
     -0.7237196895210972, 0.498758466905162, -0.3623524402206062, 
     0.27400335595965253, -0.2137905393917638, 0.17106010171410654, 
     -0.13972345295831703, 0.11610887654413068, -0.09790161142897826, 
     0.08358692428648312, -0.07214163242054882, 0.06285542395742563, 
     -0.055223305666537784, 0.048878667318985505, -0.04355038724860342, 
     0.039034624275359336, -0.035175835692146856, 0.03185373756336904, 
     -0.028974179061909664, 0.026462647564825515, -0.024259574735813576, 
     0.022316896352192948, -0.020595498393155044, 0.019063298501298363, 
     -0.01769378890423594, 0.016464918535225033, -0.01535822727742278, 
     0.014358169561794183, -0.01345158155755406, 0.012627258241579216, 
     -0.011875615263608861, 0.01118841677227775, -0.010558554935766032, 
     0.009979870262881062, -0.009447004341158976, 0.00895527849364976, 
     -0.008500593282505945, 0.008079344874959614, -0.007688355122165786, 
     0.007324812846675627, -0.006986224336222676, 0.006670371434281767, 
     -0.006375275927005228, 0.006099169170804379, -0.005840466099496589, 
     0.005597742905582198, -0.00536971781526896, 0.005155234477800808, 
     -0.0049532475714834726, 0.004762810295429319, -0.004583063470514441, 
     0.0044132260177462655, -0.004252586619068865, 0.004100496396083655, 
     -0.003956362467428121, 0.0038196422665883046, -0.0036898385194878793, 
     0.003566494795915018, -0.0034491915612171738, 0.0033375426651189905, 
     -0.003231192213330112, 0.0031298117750779213, -0.003033097886046722, 
     0.002940769811612006, -0.002852567539876702, 0.0027682499779703115, 
     -0.0026875933284650844, 0.0026103896256819987, -0.0025364454141752406, 
     0.002465580553857323, -0.0023976271381084646, 0.002332428512845924, 
     -0.0022698383859474382, 0.002209720017658138, -0.0021519454836879262, 
     0.0020963950036481504, -0.002042956328301044, 0.001991524179818648, 
     -0.0019419997398833278, 0.0018942901810211313, -0.001848308237052019, 
     0.0018039718089760156, -0.0017612036029989167, 0.0017199307977416867, 
     -0.001680084737979607, 0.0016416006525253066, -0.001604417394108177, 
     0.00156847719931489, -0.001533725466844949, 0.0015001105525040924, 
     -0.0014675835795093322, 0.001436098262814497, -0.0014056107462861963, 
     0.0013760794516686854, -0.001347464938373634};
 
  TVIL_REAL GyxxyytableBL[] = {13.015654457104455, -10.25845832049773, 0.6812177963723853, 
     2.148697292565669, -1.6401547901975093, 1.2043746693915174, 
     -0.9111680393557663, 0.7119525803349094, -0.5718265868871005, 
     0.46982459423546363, -0.39331500720363777, 0.3344427440087158, 
     -0.28814781207800705, 0.2510611479653366, -0.22087208625169596, 
     0.1959537923036405, -0.17513409909497088, 0.15755099149914437, 
     -0.14255892559984243, 0.1296665714255627, -0.11849449986857868, 
     0.10874583596996876, -0.10018552829823503, 0.092625458687659, 
     -0.0859135832888446, 0.07992590277782857, -0.07456044849276967, 
     0.06973272526733892, -0.06537222053655663, 0.06141970330463484, 
     -0.057825114731216945, 0.05454590643250415, -0.05154572086146912, 
     0.04879333540733303, -0.04626181151618872, 0.04392780445798831, 
     -0.041770999903305475, 0.039773651299086867, -0.037920197895294855, 
     0.036196947702810386, -0.034591813034286024, 0.03309408886519946, 
     -0.031694266249220435, 0.030383874574481672, -0.029155347661968672, 
     0.028001909663257663, -0.026917477471609337, 0.025896576962762426, 
     -0.024934270863683737, 0.02402609643501665, -0.02316801146601492, 
     0.022356347334807198, -0.02158776809392565, 0.020859234710540638, 
     -0.020167973730150272, 0.019511449747402, -0.01888734116289193, 
     0.018293518783875, -0.01772802689276904, 0.0171890664625129, 
     -0.016674980244150133, 0.016184239491000067, -0.01571543211670204, 
     0.015267252112300393, -0.014838490071214856, 0.01442802469110171, 
     -0.014034815138822293, 0.013657894179465545, -0.013296361983008773, 
     0.01294938053306865, -0.01261616857156175, 0.01229599702118589, 
     -0.011988184834638893, 0.011692095225568659, -0.011407132241531419, 
     0.011132737643836555, -0.010868388063172052, 0.010613592403415584, 
     -0.010367889469111581, 0.01013084579479301, -0.00990205365669842, 
     0.009681129249523121, -0.009467711012684944, 0.009261458092211683, 
     -0.009062048925796413, 0.00886917993984185, -0.008682564348446256, 
     0.00850193104528868, -0.008327023580265864, 0.008157599213530242, 
     -0.007993428040289673, 0.007834292180365002, -0.007679985027069944, 
     0.007530310550486957, -0.007385082650669383, 0.007244124556710072, 
     -0.007107268267985268, 0.006974354034214181, -0.006845229871273485, 
     0.006719751109975493, -0.006597779975262124};
 
  TVIL_REAL GyxxyytableBL2[] = {-11.909645111040875, -0.9096451110408751, 4., 
     -1.3333333333333333, 0.6666666666666666, -0.4, 0.26666666666666666, 
     -0.19047619047619047, 0.14285714285714285, -0.1111111111111111, 
     0.08888888888888889, -0.07272727272727272, 0.06060606060606061, 
     -0.05128205128205128, 0.04395604395604396, -0.0380952380952381, 
     0.03333333333333333, -0.029411764705882353, 0.026143790849673203, 
     -0.023391812865497075, 0.021052631578947368, -0.01904761904761905, 
     0.017316017316017316, -0.015810276679841896, 0.014492753623188406, 
     -0.013333333333333334, 0.012307692307692308, -0.011396011396011397, 
     0.010582010582010581, -0.009852216748768473, 0.009195402298850575, 
     -0.008602150537634409, 0.008064516129032258, -0.007575757575757576, 
     0.0071301247771836, -0.0067226890756302525, 0.006349206349206349, 
     -0.006006006006006006, 0.005689900426742532, -0.005398110661268556, 
     0.005128205128205128, -0.004878048780487805, 0.004645760743321719, 
     -0.004429678848283499, 0.004228329809725159, -0.00404040404040404, 
     0.003864734299516908, -0.0037002775208140612, 0.0035460992907801418, 
     -0.003401360544217687, 0.0032653061224489797, -0.003137254901960784, 
     0.0030165912518853697, -0.002902757619738752, 0.002795248078266946, 
     -0.0026936026936026937, 0.0025974025974025974, -0.002506265664160401, 
     0.0024198427102238356, -0.0023378141437755697, 0.0022598870056497176, 
     -0.002185792349726776, 0.0021152829190904283, -0.002048131080389145, 
     0.001984126984126984, -0.0019230769230769232, 0.0018648018648018648, 
     -0.0018091361374943465, 0.001755926251097454, -0.0017050298380221654, 
     0.0016563146997929607, -0.0016096579476861167, 0.001564945226917058, 
     -0.0015220700152207, 0.001480932987782303, -0.0014414414414414415, 
     0.0014035087719298245, -0.001367053998632946, 0.001332001332001332, 
     -0.0012982797792924375, 0.0012658227848101266, -0.0012345679012345679, 
     0.0012044564890093346, -0.0011754334410813989, 0.0011474469305794606, 
     -0.0011204481792717086, 0.001094391244870041, -0.0010692328254477412, 
     0.0010449320794148381, -0.0010214504596527069, 0.0009987515605493133, 
     -0.0009768009768009768, 0.0009555661729574773, -0.0009350163627863488, 
     0.0009151223976206818, -0.0008958566629339306, 0.0008771929824561404, 
     -0.000859106529209622, 0.0008415737428992215, -0.0008245722531436817, 
     0.0008080808080808081};
 
  TVIL_REAL GyxxyytableD[] = 
     {0, 2.414687711675314, -2.535213657142912, 0.8485958541663458, 
     -0.38951092392507886, 0.21922692813587086, -0.13942586791581227, 
     0.09607805239974948, -0.0700497623815508, 0.05325067402741178, 
     -0.04180162681681188, 0.03366013682571749, -0.027670056935867826, 
     0.02313811029557353, -0.019628562838468908, 0.01685663230890151, 
     -0.014629946478621873, 0.012814832400678815, -0.011316105280798365, 
     0.010064521834116824, -0.00900875165795727, 0.008110100725310647, 
     -0.007338960559406598, 0.006672367678805718, -0.0060922940078768, 
     0.005584428609636942, -0.005137295917131655, 0.004741608392499676, 
     -0.004389785069164974, 0.004075589163905377, -0.003793852288158274, 
     0.00354026241248784, -0.0033111992963682033, 0.0031036056280641317, 
     -0.0029148852935576516, 0.002742822443718381, -0.0025855166425204986, 
     0.0024413305486325003, -0.00230884743890521, 0.0021868365150323615, 
     -0.0020742244064361885, 0.0019700716371411154, -0.0018735530932048035, 
     0.0017839417325090654, -0.0017005949365211767, 0.001622943025795328, 
     -0.0015504795561524956, 0.001482753087069637, -0.0014193601726133196, 
     0.001359939371866702, -0.001304166112944229, 0.001251748274437972, 
     -0.001202422372080651, 0.0011559502577660724, -0.0011121162537854464, 
     0.0010707246579557813, -0.0010315975658118936, 0.000994572964660996, 
     -0.0009595030614174349, 0.0009262528120301065, -0.0008946986252137504, 
     0.0008647272172797722, -0.0008362345982788348, 0.0008091251725343575, 
     -0.0007833109390589428, 0.00075871077938247, -0.0007352498220446231, 
     0.0007128588744679595, -0.0006914739141729672, 0.0006710356323590931, 
     -0.0006514890237845263, 0.0006327830176567067, -0.0006148701449151324, 
     0.0005977062378647849, -0.0005812501586163204, 0.0005654635532198402, 
     -0.0005503106287523387, 0.0005357579509431752, -0.0005217742602040792, 
     0.0005083303041762376, -0.0004953986851219243, 0.0004829537206762127, 
     -0.00047097131663918366, 0.00045942885063382727, -0.0004483050655821863, 
     0.0004375799720644909, -0.0004272347587250408, 0.0004172517099760925, 
     -0.0004076141303284586, 0.00039830627474617564, -0.00038931328448353966, 
     0.0003806211279169776, -0.00037221654593244625, 0.00036408700147202793, 
     -0.0003562206328817542, 0.00034860621073696727, -0.0003412330978522008, 
     0.00033409121221004, -0.0003271709925680633, 0.00032046336652510036, 
     -0.00031395972084793434};
 
  TVIL_REAL GyxxyytableDL[] = 
     {0, 0.31218552262108223, -2.2186975871035135, 
     1.2951214179233934, -0.7800809452822624, 0.5200539635215082, 
     -0.37244788004853857, 0.28065758101364874, -0.21959632345599733, 
     0.17684867212761712, -0.14570603518136124, 0.12228323947301993, 
     -0.10420160034780379, 0.08993708726427915, -0.07847567081586213, 
     0.06912081166932049, -0.0613808438966317, 0.05490044611208425, 
     -0.04941749773790066, 0.04473509981529106, -0.04070295117009245, 
     0.037204662282900064, -0.03414893396600266, 0.03146330898173484, 
     -0.0290896716619791, 0.02698095707089146, -0.025098711193161455, 
     0.02341125908121598, -0.021892313419976668, 0.02051990625970646, 
     -0.01927556070772586, 0.018143642759435592, -0.017110849745895954, 
     0.01616580337774378, -0.015298723582084568, 0.014501165264930982, 
     -0.013765804465141073, 0.013086263560532949, -0.012456967563954275, 
     0.011873025331244413, -0.011330130853153283, 0.01082448083288929, 
     -0.010352705541909635, 0.009911810558386105, -0.009499127469161208, 
     0.009112271989256874, -0.008749108247179215, 0.008407718217441013, 
     -0.008086375467547187, 0.007783522535537684, -0.007497751374001752, 
     0.007227786393383056, -0.00697246971612235, 0.006730748317419708, 
     -0.006501662781026595, 0.0062843374417682705, -0.0060779717222420844, 
     0.005881832500760813, -0.005695247372247322, 0.0055175986843467644, 
     -0.005348318248236216, 0.005186882638069359, -0.0050328090051738545, 
     0.004885651343410484, -0.004744997150823597, 0.004610464440122009, 
     -0.004481699056842065, 0.004358372269436427, -0.004240178600149007, 
     0.004126833869499333, -0.00401807343060905, 0.003913650572543286, 
     -0.003813335074380348, 0.0037169118939236637, -0.0036241799768795503, 
     0.0035349511739850513, -0.0034490492550170275, 0.0033663090098768438, 
     -0.0032865754280497375, 0.0032097029487058947, -0.003135554774559832, 
     0.0030640022433516445, -0.0029949242514714976, 0.0029282067248290167, 
     -0.0028637421325818984, 0.00280142903979171, -0.002741171695476862, 
     0.0026828796528895298, -0.0026264674191604, 0.0025718541317373495, 
     -0.0025189632592956803, 0.0024677223250220183, -0.002418062650374542, 
     0.0023699191176016895, -0.002323229949462247, 0.0022779365047339204, 
     -0.0022339830882269836, 0.0021913167741360044, -0.002149887241667439, 
     0.002109646621975283, -0.002070549355522151};
 
  TVIL_REAL GyxxyytableDL2[] = 
     {0, -3., 1., -0.3333333333333333, 0.16666666666666666, -0.1, 
     0.06666666666666667, -0.047619047619047616, 0.03571428571428571, 
     -0.027777777777777776, 0.022222222222222223, -0.01818181818181818, 
     0.015151515151515152, -0.01282051282051282, 0.01098901098901099, 
     -0.009523809523809525, 0.008333333333333333, -0.007352941176470588, 
     0.006535947712418301, -0.005847953216374269, 0.005263157894736842, 
     -0.004761904761904762, 0.004329004329004329, -0.003952569169960474, 
     0.0036231884057971015, -0.0033333333333333335, 0.003076923076923077, 
     -0.002849002849002849, 0.0026455026455026454, -0.0024630541871921183, 
     0.0022988505747126436, -0.002150537634408602, 0.0020161290322580645, 
     -0.001893939393939394, 0.0017825311942959, -0.0016806722689075631, 
     0.0015873015873015873, -0.0015015015015015015, 0.001422475106685633, 
     -0.001349527665317139, 0.001282051282051282, -0.0012195121951219512, 
     0.0011614401858304297, -0.0011074197120708748, 0.0010570824524312897, 
     -0.00101010101010101, 0.000966183574879227, -0.0009250693802035153, 
     0.0008865248226950354, -0.0008503401360544217, 0.0008163265306122449, 
     -0.000784313725490196, 0.0007541478129713424, -0.000725689404934688, 
     0.0006988120195667365, -0.0006734006734006734, 0.0006493506493506494, 
     -0.0006265664160401002, 0.0006049606775559589, -0.0005844535359438924, 
     0.0005649717514124294, -0.000546448087431694, 0.0005288207297726071, 
     -0.0005120327700972862, 0.000496031746031746, -0.0004807692307692308, 
     0.0004662004662004662, -0.0004522840343735866, 0.0004389815627743635, 
     -0.00042625745950554135, 0.00041407867494824016, 
     -0.00040241448692152917, 0.0003912363067292645, -0.000380517503805175, 
     0.00037023324694557573, -0.00036036036036036037, 0.0003508771929824561, 
     -0.0003417634996582365, 0.000333000333000333, -0.0003245699448231094, 
     0.00031645569620253165, -0.00030864197530864197, 0.00030111412225233364, 
     -0.0002938583602703497, 0.00028686173264486515, -0.00028011204481792715, 
     0.00027359781121751026, -0.0002673082063619353, 0.00026123301985370953, 
     -0.0002553626149131767, 0.00024968789013732833, -0.0002442002442002442, 
     0.00023889154323936931, -0.0002337540906965872, 0.00022878059940517045, 
     -0.00022396416573348266, 0.0002192982456140351, -0.0002147766323024055, 
     0.00021039343572480537, -0.00020614306328592042, 0.00020202020202020202};
 
  TVIL_REAL GyxxyytableE[] = {-1.21960175665143, 7.930642825366072, -4.284674418003376, 
     2.0392755508362397, -1.0227916448807886, 0.5983299373398503, 
     -0.3880022302734242, 0.2701535093907481, -0.19805981632263928, 
     0.15098342158116954, -0.11866014137286675, 0.09556579340282843, 
     -0.0785240684042526, 0.06560840649046909, -0.05559763339285571, 
     0.04768855509733595, -0.04133602377811712, 0.03615988329117962, 
     -0.03188871702835523, 0.028324696040497113, -0.025320964947334716, 
     0.022766715414604868, -0.020577106181692603, 0.01868631527548862, 
     -0.01704266203447156, 0.015605124667959781, -0.014340816044094602, 
     0.013223128460171419, -0.01223035261748813, 0.011344637463726657, 
     -0.010551198234863576, 0.009837707387773667, -0.009193821797509954, 
     0.00861081252945941, -0.00808127257003791, 0.007598884340678856, 
     -0.0071582334439266645, 0.0067546584451507715, -0.00638412895133699, 
     0.006043146066098805, -0.005728660656060562, 0.005438005883738847, 
     -0.005168841235267064, 0.004919105861810468, -0.004686979507649243, 
     0.00447084964948823, -0.0042692837454658475, 0.004081005707026071, 
     -0.0039048758760576903, 0.0037398739238480405, -0.003585084195279435, 
     0.0034396831072822927, -0.003302928279420774, 0.0031741491301468076, 
     -0.0030527387174456105, 0.0029381466394355804, -0.0028298728406416325, 
     0.0027274621944423493, -0.002630499752632135, 0.002538606569960922, 
     -0.0024514360255706055, 0.0023686705749633623, -0.0022900188759336685, 
     0.0022152132401131656, -0.0021440073686909114, 0.0020761743367048065, 
     -0.0020115047952357946, 0.0019498053650241717, -0.0018908971985898166, 
     0.001834614690976421, -0.0017808043218374462, 0.0017293236138077462, 
     -0.0016800401940171789, 0.0016328309472489727, -0.0015875812506662707, 
     0.0015441842812586627, -0.0015025403882248953, 0.0014625565234320493, 
     -0.001424145723895359, 0.0013872266409234901, -0.0013517231111858762, 
     0.0013175637654938763, -0.0012846816715564677, 0.0012530140073828387, 
     -0.0012225017623661769, 0.0011930894634017014, -0.0011647249236731542, 
     0.0011373590119903463, -0.001110945440780129, 0.0010854405710278823, 
     -0.001060803232639414, 0.001036994558846691, -0.0010139778334174604, 
     0.0009917183495505352, -0.0009701832794471328, 0.000949341553645665, 
     -0.0009291637492941549, 0.0009096219866121609, -0.0008906898328637653, 
     0.0008723422132257224, -0.0008545553279910637};
 
  TVIL_REAL GyxxyytableEL[] = {22.339423719033036, 1.986542204287521, -1.1464783950923463, 
     1.4194866897345069, -0.9261101240220962, 0.6300764916161352, 
     -0.45261091872531906, 0.3397721686391054, -0.2640306226972127, 
     0.21087415656573313, -0.1721907150981921, 0.14318848245872617, 
     -0.12089858720681639, 0.10340535186234892, -0.08942911071870602, 
     0.078089244353601, -0.06876393380338398, 0.06100412075472384, 
     -0.05447903168164797, 0.04894071342768737, -0.04420036822002254, 
     0.040112210344803514, -0.03656223375291926, 0.033460255893960913, 
     -0.030734190248412264, 0.02832586205573058, -0.026187909991068153, 
     0.024281463420196478, -0.022574381155304874, 0.02103990185724784, 
     -0.01965559974655285, 0.0184025692066303, -0.017264782716853038, 
     0.01622858127263023, -0.01528226696195493, 0.014415774958641431, 
     -0.013620407730309252, 0.012888618338554111, -0.012213832741209334, 
     0.011590303280204509, -0.011012987257000837, 0.010477445806423845, 
     -0.009979759283800323, 0.009516456155895258, -0.009084452989145472, 
     0.008681003600413899, -0.008303655806699351, 0.007950214503993054, 
     -0.007618710039183966, 0.0073073710258068116, -0.007014600904611257, 
     0.006738957671183274, -0.006479136291183816, 0.006233953403860591, 
     -0.0060023339799903375, 0.005783299654191358, -0.0055759584958746874, 
     0.0053794960197725925, -0.0051931672674255915, 0.005016289816367375, 
     -0.004848237594939338, 0.0046884353984333015, -0.004536354017201599, 
     0.004391505899974624, -0.004253441286283862, 0.004121744750927872, 
     -0.003996032111105763, 0.0038759476533966816, -0.0037611616433657256, 
     0.003651368085376268, -0.003546282704310731, 0.003445641124449843, 
     -0.0033491972238212336, 0.003256721644974321, -0.0031680004454308366, 
     0.003082833873050291, -0.0030010352532805406, 0.0029224299767719453, 
     -0.002846854577150518, 0.0027741558898973003, -0.0027041902842904345, 
     0.0026368229612522285, -0.0025719273107222924, 0.002509384322863648, 
     -0.0024490820480136057, 0.002390915100825559, -0.0023347842045206057, 
     0.002280595771586779, -0.002228261517635331, 0.002177698105453781, 
     -0.0021288268165892627, 0.0020815732480575313, -0.002035867032006557, 
     0.0019916415763722725, -0.001948833824750662, 0.0019073840338774864, 
     -0.0018672355672567803, 0.001828334703613731, -0.0017906304589684317, 
     0.0017540744212357269, -0.001718620596354307};
 
  TVIL_REAL GyxxyytableEL2[] = {-11.454822555520437, -2.4548225555204377, 2., 
     -0.6666666666666666, 0.3333333333333333, -0.2, 0.13333333333333333, 
     -0.09523809523809523, 0.07142857142857142, -0.05555555555555555, 
     0.044444444444444446, -0.03636363636363636, 0.030303030303030304, 
     -0.02564102564102564, 0.02197802197802198, -0.01904761904761905, 
     0.016666666666666666, -0.014705882352941176, 0.013071895424836602, 
     -0.011695906432748537, 0.010526315789473684, -0.009523809523809525, 
     0.008658008658008658, -0.007905138339920948, 0.007246376811594203, 
     -0.006666666666666667, 0.006153846153846154, -0.005698005698005698, 
     0.005291005291005291, -0.0049261083743842365, 0.004597701149425287, 
     -0.004301075268817204, 0.004032258064516129, -0.003787878787878788, 
     0.0035650623885918, -0.0033613445378151263, 0.0031746031746031746, 
     -0.003003003003003003, 0.002844950213371266, -0.002699055330634278, 
     0.002564102564102564, -0.0024390243902439024, 0.0023228803716608595, 
     -0.0022148394241417496, 0.0021141649048625794, -0.00202020202020202, 
     0.001932367149758454, -0.0018501387604070306, 0.0017730496453900709, 
     -0.0017006802721088435, 0.0016326530612244899, -0.001568627450980392, 
     0.0015082956259426848, -0.001451378809869376, 0.001397624039133473, 
     -0.0013468013468013469, 0.0012987012987012987, -0.0012531328320802004, 
     0.0012099213551119178, -0.0011689070718877848, 0.0011299435028248588, 
     -0.001092896174863388, 0.0010576414595452142, -0.0010240655401945725, 
     0.000992063492063492, -0.0009615384615384616, 0.0009324009324009324, 
     -0.0009045680687471732, 0.000877963125548727, -0.0008525149190110827, 
     0.0008281573498964803, -0.0008048289738430583, 0.000782472613458529, 
     -0.00076103500761035, 0.0007404664938911515, -0.0007207207207207207, 
     0.0007017543859649122, -0.000683526999316473, 0.000666000666000666, 
     -0.0006491398896462187, 0.0006329113924050633, -0.0006172839506172839, 
     0.0006022282445046673, -0.0005877167205406994, 0.0005737234652897303, 
     -0.0005602240896358543, 0.0005471956224350205, -0.0005346164127238706, 
     0.0005224660397074191, -0.0005107252298263534, 0.0004993757802746567, 
     -0.0004884004884004884, 0.00047778308647873863, -0.0004675081813931744, 
     0.0004575611988103409, -0.0004479283314669653, 0.0004385964912280702, 
     -0.000429553264604811, 0.00042078687144961075, -0.00041228612657184083, 
     0.00040404040404040404};
 
  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  if (y < 0.155 * x) {
    result = TVIL_G000xx (x, qq);
    result += y*(38.L/3.L + 14.L*lnbarx + 3.L*lnbarx2 + lnbarx3/6.L 
              - 3.L*lnbary - 8.L*lnbarx*lnbary - lnbarx2*lnbary
              + 1.5L*lnbarx*lnbary2 - 3.L*SQRT3*LS2*lnbarx - 4.L*Zeta3/3.L);
    rn = r = y/x;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (GyxxyytableA[n] +
        GyxxyytableALx[n] * lnbarx +
        GyxxyytableALy[n] * lnbary +
        GyxxyytableALx2[n] * lnbarx2 + 
        GyxxyytableALy2[n] * lnbary2 + 
        GyxxyytableALxLy[n] * lnbarx * lnbary);
    }
  } 
  else if (y < 0.5 * x) {
    result = ((x + 2.L*y)/3.L) * lnbary3; 
    rn = 1;
    r = 0.25L * x/y - 1.L;
    for (n=0; n < 100; n++) {
      result += y * rn * (
        GyxxyytableE[n] +
        GyxxyytableEL[n] * lnbary +
        GyxxyytableEL2[n] * lnbary2);
      rn *= r;
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_Gxxxxx (x, qq);
    result += (y - x) * lnbarx3 * (2.L/3.L);
    rn = r = y/x - 1.L;
    for (n=1; n < 100; n++) {
      result += x * rn * (
        GyxxyytableD[n] +
        GyxxyytableDL[n] * lnbarx +
        GyxxyytableDL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else if (y < 6.47 * x) {
    result = ((x + 2.L*y)/3.L) * lnbarx3; 
    rn = 1;
    r = 0.25L * y/x - 1.L;
    for (n=0; n < 100; n++) {
      result += x * rn * (
        GyxxyytableB[n] +
        GyxxyytableBL[n] * lnbarx +
        GyxxyytableBL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else {
    result = TVIL_Gx00xx (y, qq);
    rn = r = 4.L * x/y;
    for (n=1; n < 100; n++) {
      result += y * rn * (
        GyxxyytableC[n] +
        GyxxyytableCLx[n] * lnbarx +
        GyxxyytableCLy[n] * lnbary +
        GyxxyytableCLx2[n] * lnbarx2 +
        GyxxyytableCLxLy[n] * lnbarx * lnbary +
        GyxxyytableCLy2[n] * lnbary2 + 
        GyxxyytableCLx2Ly[n] * lnbarx2 * lnbary +
        GyxxyytableCLxLy2[n] * lnbarx * lnbary2 +
        GyxxyytableCLy3[n] * lnbary3);
      rn *= r;
    }
  }

  return result;
}

/* ****************************************************************** */
TVIL_COMPLEX TVIL_Gxxxxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  TVIL_REAL GxxxxytableA[] = 
     {0, 0, 0.23346308041667416, -0.0015340394795746205, 
     -0.0006518888547821979, -0.0001204630251552816, -0.00002200016908754228, 
     -4.172092302441235e-6, -8.212185326148273e-7, -1.6668098130613792e-7, 
     -3.467057855923783e-8, -7.354964720384632e-9, -1.5854391703427205e-9, 
     -3.463046837980318e-10, -7.648535711812442e-11, 
     -1.705238788637664e-11, -3.832703057173232e-12, 
     -8.675138689669595e-13, -1.9757054641532676e-13, 
     -4.5240899826440624e-14, -1.0409826280088977e-14, 
     -2.405689090263142e-15, -5.581262172646708e-16, 
     -1.299456794032861e-16, -3.035212049906725e-17, 
     -7.110386912647665e-18, -1.670200645255276e-18, 
     -3.9329832922611408e-19, -9.28263132795779e-20, 
     -2.1955446113417027e-20, -5.203194104728007e-21, 
     -1.2353657828235853e-21, -2.938095588698507e-22, 
     -6.998955326812666e-23, -1.6697600691147626e-23, 
     -3.9892292987058366e-24, -9.54337538573534e-25, 
     -2.285915457421311e-25, -5.481927382207903e-26, 
     -1.3161142587081068e-26, -3.1631190791216142e-27, 
     -7.6098397335761525e-28, -1.8325323730002393e-28, 
     -4.416962636352211e-29, -1.0655477373181288e-29, 
     -2.5726559523435916e-30, -6.216326383392628e-31, 
     -1.5031902775982709e-31, -3.637540545823382e-32, 
     -8.808497174223297e-33, -2.13443123551196e-33, 
     -5.175262775292194e-34, -1.2555182957992213e-34, 
     -3.046996113887239e-35, -7.392468234628167e-36, 
     -1.788432821093256e-36, -4.271457650108497e-37, 
     -9.659550993088142e-38, -1.6567116995038598e-38, 
     2.558748550889421e-39, 6.888681892230827e-39, 7.637922549196894e-39, 
     7.534612676521e-39, 7.241567551042731e-39, 6.918873412883909e-39, 
     6.604282291881328e-39, 6.305847371620637e-39, 6.024483438635201e-39, 
     5.7594560614793347e-39, 5.5097110150161224e-39, 
     5.274190426537274e-39, 5.0519026570566233e-39, 4.841932887208485e-39, 
     4.6434399316297424e-39, 4.455650309290289e-39, 4.277852188849655e-39, 
     4.1093897847178976e-39, 3.949658288655749e-39, 3.798099308923617e-39, 
     3.6541967675359086e-39, 3.517473206219154e-39, 3.387486456256547e-39, 
     3.263826632487164e-39, 3.146113416414692e-39, 3.0339935975216905e-39, 
     2.9271388455082757e-39, 2.8252436893385556e-39, 
     2.7280236817442556e-39, 2.6352137302562964e-39, 
     2.5465665779577296e-39, 2.4618514190152177e-39, 
     2.3808526356851314e-39, 2.3033686449336624e-39, 
     2.2292108440832762e-39, 2.158202646022067e-39, 
     2.0901785955068885e-39, 2.024983558971716e-39, 1.962471981033603e-39, 
     1.902507201581994e-39, 1.844960827953672e-39, 1.7897121572444046e-39};
 
  TVIL_REAL GxxxxytableALx[] = 
     {0, 0, 0.4826563598543843, 0.03275079601702368, 
     0.004022248206228854, 0.0006199503186828171, 0.00010745292337627173, 
     0.00002000192527963649, 3.9063900406349646e-6, 7.897436415241383e-7, 
     1.6387938555714455e-7, 3.470721496184937e-8, 7.471906634575439e-9, 
     1.6303672993191408e-9, 3.5976706327735677e-10, 8.014883446662433e-11, 
     1.8002286958066965e-11, 4.072332230903187e-12, 9.269605320507601e-13, 
     2.1216126943563158e-13, 4.8797124802008116e-14, 
     1.1272580689807152e-14, 2.614353362349544e-15, 6.084917733711829e-16, 
     1.4208698578938166e-16, 3.3276752841972664e-17, 
     7.814617107166165e-18, 1.839756886403765e-18, 4.34126012573172e-19, 
     1.0265963430699503e-19, 2.4324613830920596e-20, 
     5.7742444594538395e-21, 1.3730738676293073e-21, 
     3.270347273773286e-22, 7.801018464763313e-23, 1.8634871446124367e-23, 
     4.457412855895005e-24, 1.067548206519274e-24, 2.559822623131642e-25, 
     6.14500198811991e-26, 1.4767201391726896e-26, 3.552340605106207e-27, 
     8.55360583689564e-28, 2.061492240776829e-28, 4.9727093413892155e-29, 
     1.2005098484585969e-29, 2.900569277360791e-30, 7.01342726282131e-31, 
     1.697041900285778e-31, 4.1091939013639954e-32, 9.956574138834682e-33, 
     2.4140188205627888e-33, 5.856493927416613e-34, 1.421643240384429e-34, 
     3.4529444445594703e-35, 8.391223944007858e-36, 2.040276451630498e-36, 
     4.963321594327392e-37, 1.2080020206163278e-37, 2.941489600538421e-38, 
     7.165794274413766e-39, 1.7464333831701196e-39, 4.258180102990881e-40, 
     1.0386621295461123e-40, 2.5345279509643074e-41, 
     6.187096813143321e-42, 1.5109098623309454e-42, 3.691025431713538e-43, 
     9.020022115772295e-44, 2.2050361273771886e-44, 5.392212734929405e-45, 
     1.3190382074273784e-45, 3.2276230526961173e-46, 
     7.900225922257544e-47, 1.9343000136121752e-47, 4.737315211547108e-48, 
     1.1605437014552085e-48, 2.8438603211557863e-49, 
     6.970589017614971e-50, 1.7090004426969832e-50, 4.191056391932786e-51, 
     1.0280417493781124e-51, 2.5223271652468587e-52, 
     6.190041040059383e-53, 1.5194517009797013e-53, 
     3.7306807556354206e-54, 9.162835333613612e-55, 
     2.2518938652873424e-55, 5.544736885836042e-56, 
     1.3744724475343993e-56, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.};
 
  TVIL_REAL GxxxxytableALy[] = 
     {0, 0, -0.03821191540993988, 0.0016936484274207681, 
     0.00038818263277341303, 0.00007102977705918345, 0.000013260498202950723, 
     2.571808999059495e-6, 5.1585672260414e-7, 1.0631579878805037e-7, 
     2.2390784283915116e-8, 4.7987100107258085e-9, 1.043254693350917e-9, 
     2.295208782600997e-10, 5.100506157204004e-11, 1.1432206397657376e-11, 
     2.5814693328583413e-12, 5.866978836835907e-13, 
     1.3410240189207809e-13, 3.0807311203859664e-14, 
     7.109379759603565e-15, 1.647295334032622e-15, 3.8309194043641597e-16, 
     8.938811965615124e-17, 2.092062377077906e-17, 4.909942315647589e-18, 
     1.155280545064266e-18, 2.7247182668643385e-19, 6.440243176426399e-20, 
     1.5253207523315868e-20, 3.619405175044165e-21, 8.603504104633301e-22, 
     2.0484533582480497e-22, 4.884773392747394e-23, 
     1.1665130490145101e-23, 2.7894877259044734e-24, 
     6.679055118363038e-25, 1.601143350292531e-25, 3.842744040702097e-26, 
     9.232566851037529e-27, 2.2204907616419395e-27, 
     5.3456259076565235e-28, 1.2881026283509698e-28, 
     3.1066004566111626e-29, 7.49869075733729e-30, 1.811481475087098e-30, 
     4.37940576394683e-31, 1.0595336525677816e-31, 2.565186737795682e-32, 
     6.214627663731806e-33, 1.5065764033289227e-33, 3.654566522926595e-34, 
     8.870307094482026e-35, 2.1542174372313492e-35, 5.234547043739727e-36, 
     1.2726192354046124e-36, 3.0955603023355437e-37, 
     7.533443213648447e-38, 1.8342296520187525e-38, 4.467995306199525e-39, 
     1.0888391922671111e-39, 2.654607948089238e-40, 6.474653531924971e-41, 
     1.5798154617896927e-41, 3.856242465785864e-42, 9.416406021105014e-43, 
     2.3001907837813745e-43, 5.620766952849195e-44, 
     1.3739652551408873e-44, 3.3596960618405966e-45, 
     8.217961590111207e-46, 2.0107778358758973e-46, 4.921484213659481e-47, 
     1.2049151005637442e-47, 2.9508124909668045e-48, 
     7.228500395321161e-49, 1.7712219492368973e-49, 4.341230249142613e-50, 
     1.06430159158429e-50, 2.6099113741730493e-51, 6.4016677519031434e-52, 
     1.5705939089855065e-52, 3.854202809082334e-53, 9.460167793845085e-54, 
     2.3224132432085565e-54, 5.701588447613403e-55, 
     1.3990590678067826e-55, 3.4241411782087547e-56, 0., 0., 0., 0., 0., 
     0., 0., 0., 0., 0., 0., 0., 0.};
 
  TVIL_REAL GxxxxytableALx2[] = 
     {0, 0, 0.16666666666666666, 0.016666666666666666, 
     0.002380952380952381, 0.0003968253968253968, 0.00007215007215007215, 
     0.000013875013875013875, 2.775002775002775e-6, 5.713241007358655e-7, 
     1.202787580496559e-7, 2.577401958206912e-8, 5.603047735232417e-9, 
     1.2326705017511316e-9, 2.7392677816691816e-10, 6.139738131327476e-11, 
     1.3863924812674945e-11, 3.1508920028806695e-12, 
     7.202038863727245e-13, 1.6545224416670698e-13, 
     3.8181287115393914e-14, 8.846883599908346e-15, 
     2.0574147906763594e-15, 4.800634511578173e-16, 1.123552758028934e-16, 
     2.636909534149539e-17, 6.204493021528327e-18, 1.4633238258321526e-18, 
     3.4587654065123604e-19, 8.191812804897696e-20, 1.943819987602843e-20, 
     4.6205557082362665e-21, 1.1001323114848254e-21, 
     2.623392435079199e-22, 6.264817755413012e-23, 1.4981085936857203e-23, 
     3.587020576430598e-24, 8.59902192979938e-25, 2.0637652631518508e-25, 
     4.958397060819382e-26, 1.19252587538694e-26, 2.870895625931522e-27, 
     6.917820785377162e-28, 1.6684156011791979e-28, 4.027210071811857e-29, 
     9.728653544264598e-30, 2.3519821755364965e-30, 5.690279456943136e-31, 
     1.3776466053651802e-31, 3.337597445987808e-32, 8.091145323606808e-33, 
     1.962703568597691e-33, 4.763843613101192e-34, 1.1569334488960036e-34, 
     2.811240156195897e-35, 6.83466643478819e-36, 1.6624864300836136e-36, 
     4.045874055513219e-37, 9.850823787336533e-38, 2.399559640505053e-38, 
     5.847666350810633e-39, 1.4256707218918486e-39, 
     3.4772456631508503e-40, 8.484479418088075e-41, 
     2.0710146611081126e-41, 5.0571288236360894e-42, 
     1.2353291782927851e-42, 3.0186615259034222e-43, 7.37895039665281e-44, 
     1.8043418853129134e-44, 4.4134981367366226e-45, 
     1.0798984802653439e-45, 2.6431081684816107e-46, 
     6.471057929730841e-47, 1.58474888075041e-47, 3.882102962912078e-48, 
     9.512437723691846e-49, 2.3314798342381977e-49, 5.71588604522913e-50, 
     1.4016663231931305e-50, 3.4380494719831504e-51, 
     8.434966095859281e-52, 2.0699303302722166e-52, 5.08073808339544e-53, 
     1.2473668348455872e-53, 3.063060570774667e-54, 7.523306665060585e-55, 
     1.8482111749426293e-55, 4.541318887001889e-56, 
     1.1160868451106337e-56, 2.7434536974786526e-57, 
     6.744955223082875e-58, 1.6585955466597236e-58, 4.07924850664959e-59, 
     1.0034515043095249e-59, 2.4688092566345452e-60, 
     6.0750803697289855e-61, 1.4951622671612789e-61, 
     3.6803994268585327e-62, 9.060881837697403e-63, 2.231071407272225e-63};
 
  TVIL_REAL GxxxxytableALxLy[] = 
     {0, 0, -0.16666666666666666, -0.016666666666666666, 
     -0.002380952380952381, -0.0003968253968253968, -0.00007215007215007215, 
     -0.000013875013875013875, -2.775002775002775e-6, 
     -5.713241007358655e-7, -1.202787580496559e-7, -2.577401958206912e-8, 
     -5.603047735232417e-9, -1.2326705017511316e-9, 
     -2.7392677816691816e-10, -6.139738131327476e-11, 
     -1.3863924812674945e-11, -3.1508920028806695e-12, 
     -7.202038863727245e-13, -1.6545224416670698e-13, 
     -3.8181287115393914e-14, -8.846883599908346e-15, 
     -2.0574147906763594e-15, -4.800634511578173e-16, 
     -1.123552758028934e-16, -2.636909534149539e-17, 
     -6.204493021528327e-18, -1.4633238258321526e-18, 
     -3.4587654065123604e-19, -8.191812804897696e-20, 
     -1.943819987602843e-20, -4.6205557082362665e-21, 
     -1.1001323114848254e-21, -2.623392435079199e-22, 
     -6.264817755413012e-23, -1.4981085936857203e-23, 
     -3.587020576430598e-24, -8.59902192979938e-25, 
     -2.0637652631518508e-25, -4.958397060819382e-26, 
     -1.19252587538694e-26, -2.870895625931522e-27, 
     -6.917820785377162e-28, -1.6684156011791979e-28, 
     -4.027210071811857e-29, -9.728653544264598e-30, 
     -2.3519821755364965e-30, -5.690279456943136e-31, 
     -1.3776466053651802e-31, -3.337597445987808e-32, 
     -8.091145323606808e-33, -1.962703568597691e-33, 
     -4.763843613101192e-34, -1.1569334488960036e-34, 
     -2.811240156195897e-35, -6.83466643478819e-36, 
     -1.6624864300836136e-36, -4.045874055513219e-37, 
     -9.850823787336533e-38, -2.399559640505053e-38, 
     -5.847666350810633e-39, -1.4256707218918486e-39, 
     -3.4772456631508503e-40, -8.484479418088075e-41, 
     -2.0710146611081126e-41, -5.0571288236360894e-42, 
     -1.2353291782927851e-42, -3.0186615259034222e-43, 
     -7.37895039665281e-44, -1.8043418853129134e-44, 
     -4.4134981367366226e-45, -1.0798984802653439e-45, 
     -2.6431081684816107e-46, -6.471057929730841e-47, 
     -1.58474888075041e-47, -3.882102962912078e-48, 
     -9.512437723691846e-49, -2.3314798342381977e-49, 
     -5.71588604522913e-50, -1.4016663231931305e-50, 
     -3.4380494719831504e-51, -8.434966095859281e-52, 
     -2.0699303302722166e-52, -5.08073808339544e-53, 
     -1.2473668348455872e-53, -3.063060570774667e-54, 
     -7.523306665060585e-55, -1.8482111749426293e-55, 
     -4.541318887001889e-56, -1.1160868451106337e-56, 
     -2.7434536974786526e-57, -6.744955223082875e-58, 
     -1.6585955466597236e-58, -4.07924850664959e-59, 
     -1.0034515043095249e-59, -2.4688092566345452e-60, 
     -6.0750803697289855e-61, -1.4951622671612789e-61, 
     -3.6803994268585327e-62, -9.060881837697403e-63, 
     -2.231071407272225e-63};
 
  TVIL_REAL GxxxxytableC[] = 
     {0, -0.02769326033142769, 0.05091419428022199, 
     0.005463239441233018, -0.00007319369529620402, -0.001134253440864444, 
     -0.0011297157235988175, -0.0009106120808749862, -0.0006944970135700317, 
     -0.000524680495579979, -0.0003994626333360986, -0.0003084842517601913, 
     -0.00024208695823091134, -0.0001930185600916546, 
     -0.00015618844140267036, -0.00012809464171484753, 
     -0.00010632862411919596, -0.00008921872976292946, 
     -0.00007558906083890298, -0.00006459984596647523, 
     -0.00005564203446103464, -0.000048267237288715035, 
     -0.00004214063103918192, -0.00003700886491313155, 
     -0.00003267787292104781, -0.000028997310253664377, 
     -0.000025849481562475768, -0.000023141358497704105, 
     -0.000020798751431239812, -0.000018762003419710527, 
     -0.00001698277350374452, -0.00001542160887602399, 
     -0.000014046094742151477, -0.000012829431681088916, 
     -0.00001174933248003865, -0.000010787159923194716, 
     -9.927247890200557e-6, -9.156363048729517e-6, -8.463275208138317e-6, 
     -7.838412262902348e-6, -7.273581437999532e-6, -6.761742838958156e-6, 
     -6.29682451776427e-6, -5.873570683320138e-6, -5.487416519756896e-6, 
     -5.134384477682524e-6, -4.810997981466724e-6, -4.51420932983283e-6, 
     -4.241339216312046e-6, -3.9900258043406164e-6, 
     -3.7581816917328928e-6, -3.5439574156299385e-6, 
     -3.3457104005066647e-6, -3.161978452672113e-6, -2.991457065838547e-6, 
     -2.832979932179543e-6, -2.68550215836138e-6, -2.548085771387066e-6, 
     -2.4198871687041456e-6, -2.3001462240115474e-6, 
     -2.1881768070155574e-6, -2.083358513978777e-6, -1.985129437828809e-6, 
     -1.8929798330838534e-6, -1.8064465529035274e-6, 
     -1.7251081539844577e-6, -1.6485805804372806e-6, 
     -1.576513350728076e-6, -1.5085861826687148e-6, -1.444506000644462e-6, 
     -1.3840042770578457e-6, -1.3268346665787049e-6, 
     -1.2727708974137139e-6, -1.2216048886033405e-6, 
     -1.173145066451564e-6, -1.127214856702969e-6, -1.0836513320939185e-6, 
     -1.0423039974952669e-6, -1.0030336970969922e-6, 
     -9.657116300134487e-7, -9.302184623564435e-7, -8.964435252697461e-7, 
     -8.642840896748297e-7, -8.336447095705489e-7, -8.044366266820134e-7, 
     -7.765772300855045e-7, -7.49989565163511e-7, -7.246018868809293e-7, 
     -7.003472529322792e-7, -6.771631528007772e-7, -6.549911692021572e-7, 
     -6.337766687668776e-7, -6.134685191503753e-7, -5.940188300579887e-7, 
     -5.753827159339781e-7, -5.575180782969673e-7, -5.4038540591078e-7, 
     -5.239475911632575e-7, -5.081697611889767e-7, -4.930191224172743e-7, 
     -4.784648173567208e-7};
 
  TVIL_REAL GxxxxytableCLx[] = 
     {0, 0.8727851036835303, 0.015940623750531558, 
     0.006197986559742537, -0.0012592095393340757, -0.0024185630418349546, 
     -0.0020945714042663777, -0.0015819136592869329, -0.001158427544436807, 
     -0.0008506922300640939, -0.0006342060973284457, -0.00048190344305910394, 
     -0.0003733514131220283, -0.00029457782799335804, 
     -0.00023630222302746694, -0.00019237386796282078, 
     -0.0001586757186892113, -0.00013240910856218978, -0.0001116376700393328, 
     -0.00009499717533507737, -0.00008150942444003345, 
     -0.00007046126195707882, -0.00006132467327200852, 
     -0.00005370311903503746, -0.00004729488301380894, 
     -0.000041867630632446556, -0.000037240475486285994, 
     -0.000033271154381467375, -0.000029846731400285763, 
     -0.000026876775067085075, -0.000024288292121205513, 
     -0.000022021924785895833, -0.000020029067589153713, 
     -0.00001826966080011022, -0.000016710486852969032, 
     -0.00001532384428626312, -0.000014086507580388919, 
     -0.000012978905342947573, -0.000011984466578797302, 
     -0.000011089097321904494, -0.000010280759087136042, 
     -9.549127380737065e-6, -8.885313557429889e-6, -8.28163710138929e-6, 
     -7.731438273245047e-6, -7.228923246492845e-6, -6.769035528507167e-6, 
     -6.347348750867894e-6, -5.959976914382256e-6, -5.603498955194836e-6, 
     -5.274895111312549e-6, -4.971493052437672e-6, -4.690922119431292e-6, 
     -4.431074325228703e-6, -4.190071013565041e-6, -3.966234268479993e-6, 
     -3.7580623263233815e-6, -3.564208370695091e-6, -3.383462195520517e-6, 
     -3.2147343070652634e-6, -3.0570421058926138e-6, 
     -2.9094978475392997e-6, -2.7712981283916774e-6, 
     -2.641714682768952e-6, -2.5200863100700313e-6, 
     -2.4058117782270646e-6, -2.2983435726082672e-6, 
     -2.1971823787154935e-6, -2.1018722031698324e-6, 
     -2.0119960510939247e-6, -1.927172089509956e-6, -1.847050236127511e-6, 
     -1.7713091211836273e-6, -1.6996533770559594e-6, 
     -1.6318112163952336e-6, -1.5675322646780772e-6, 
     -1.5065856175011703e-6, -1.448758096735391e-6, -1.393852682928546e-6, 
     -1.3416871041664016e-6, -1.292092564040445e-6, 
     -1.2449125934829674e-6, -1.200002013062792e-6, 
     -1.1572259939281332e-6, -1.1164592069704254e-6, 
     -1.0775850509931606e-6, -1.0404949517272329e-6, 
     -1.0050877244597895e-6, -9.712689938548866e-7, -9.389506652565686e-7, 
     -9.080504423913338e-7, -8.784913869385383e-7, -8.502015159237382e-7, 
     -8.231134333195881e-7, -7.971639926188631e-7, -7.722939874806584e-7, 
     -7.484478678492046e-7, -7.255734792096863e-7, -7.036218228809985e-7, 
     -6.825468354550657e-7, -6.623051856792196e-7};
 
  TVIL_REAL GxxxxytableCLy[] = 
     {0, 0.4265783416797317, -0.025692082191228507, 
     -0.008669808904893604, 0.0004392284047451686, 0.0021316198348830012, 
     0.001990999720122646, 0.0015436345371728428, 0.001144007398680591, 
     0.0008451740503614717, 0.0006320665956896026, 0.0004810646826186763, 
     0.0003730194634125119, 0.0002944453774480018, 0.0002362489968418228, 
     0.00019235234454652382, 0.000158666966858706, 0.00013240553232609132, 
     0.00011163620222546051, 0.00009499657049059766, 0.00008150917430109264, 
     0.00007046115817018568, 0.00006132463007991546, 0.00005370310101072835, 
     0.0000472948754731282, 0.00004186762747034499, 0.000037240474157425226, 
     0.000033271153821897155, 0.000029846731164215607, 
     0.000026876774967318543, 0.000024288292078973958, 
     0.000022021924767991694, 0.000020029067581552314, 
     0.000018269660796878595, 0.000016710486851593404, 
     0.000015323844285676838, 0.000014086507580138768, 
     0.000012978905342840723, 0.000011984466578751616, 
     0.000011089097321884941, 0.000010280759087127667, 9.549127380733473e-6, 
     8.885313557428347e-6, 8.281637101388627e-6, 7.731438273244762e-6, 
     7.228923246492723e-6, 6.769035528507114e-6, 6.347348750867872e-6, 
     5.959976914382246e-6, 5.6034989551948315e-6, 5.274895111312547e-6, 
     4.971493052437671e-6, 4.690922119431292e-6, 4.431074325228703e-6, 
     4.190071013565041e-6, 3.966234268479993e-6, 3.7580623263233815e-6, 
     3.564208370695091e-6, 3.383462195520517e-6, 3.2147343070652634e-6, 
     3.0570421058926138e-6, 2.9094978475392997e-6, 2.7712981283916774e-6, 
     2.641714682768952e-6, 2.5200863100700313e-6, 2.4058117782270646e-6, 
     2.2983435726082672e-6, 2.1971823787154935e-6, 2.1018722031698324e-6, 
     2.0119960510939247e-6, 1.927172089509956e-6, 1.847050236127511e-6, 
     1.7713091211836273e-6, 1.6996533770559594e-6, 1.6318112163952336e-6, 
     1.5675322646780772e-6, 1.5065856175011703e-6, 1.448758096735391e-6, 
     1.393852682928546e-6, 1.3416871041664016e-6, 1.292092564040445e-6, 
     1.2449125934829674e-6, 1.200002013062792e-6, 1.1572259939281332e-6, 
     1.1164592069704254e-6, 1.0775850509931606e-6, 1.0404949517272329e-6, 
     1.0050877244597895e-6, 9.712689938548866e-7, 9.389506652565686e-7, 
     9.080504423913338e-7, 8.784913869385383e-7, 8.502015159237382e-7, 
     8.231134333195881e-7, 7.971639926188631e-7, 7.722939874806584e-7, 
     7.484478678492046e-7, 7.255734792096863e-7, 7.036218228809985e-7, 
     6.825468354550657e-7, 6.623051856792196e-7};
 
  TVIL_REAL GxxxxytableCLx2[] = 
     {0, -0.16666666666666666, 0.033950617283950615, 
     -0.0006858710562414266, -0.0029784585683076768, -0.0022673260060853415, 
     -0.0015148436044640891, -0.00100366927898112, -0.0006800783607276604, 
     -0.00047523269256638913, -0.0003426742059104591, -0.0002543617190865685, 
     -0.00019372100729439826, -0.00015086717220729275, 
     -0.00011977947275819173, -0.00009669465539280838, 
     -0.00007919567458667812, -0.00006568819195120742, 
     -0.00005509376592029666, -0.000046665797777490046, 
     -0.0000398763868321466, -0.00003434506647344323, 
     -0.000029792858052592193, -0.00002601198888452076, 
     -0.000022845521597501636, -0.000020173389848079052, 
     -0.00001790265837828678, -0.00001596062073472791, 
     -0.00001428983613052624, -0.000012844512573018776, 
     -0.00001158783838902896, -0.000010489990927931492, 
     -9.526634850265734e-6, -8.67777849085037e-6, -7.926894939506257e-6, 
     -7.260240790835747e-6, -6.666323883152314e-6, -6.135484322395792e-6, 
     -5.659562353686859e-6, -5.231633329301879e-6, -4.84579489257413e-6, 
     -4.496995077707639e-6, -4.180892680053883e-6, -3.893743235413295e-6, 
     -3.6323054411150822e-6, -3.3937639850898665e-6, 
     -3.1756656148866524e-6, -2.97586594416119e-6, -2.7924850090412184e-6, 
     -2.6238699874392836e-6, -2.4685638079366025e-6, 
     -2.3252786215691115e-6, -2.192873304963774e-6, -2.070334318352174e-6, 
     -1.9567593658299148e-6, -1.8513434045766415e-6, 
     -1.7533666297957758e-6, -1.6621841268961966e-6, 
     -1.5772169350489088e-6, -1.4979443091565154e-6, 
     -1.423897002393553e-6, -1.3546514203275185e-6, 
     -1.2898245214149335e-6, -1.229069358339806e-6, -1.172071170986813e-6, 
     -1.1185439554306329e-6, -1.0682274446688289e-6, 
     -1.020884446326542e-6, -9.76298490539577e-7, -9.342717479406562e-7, 
     -8.946231833457185e-7, -8.571869155384228e-7, -8.218107576252858e-7, 
     -7.883549158996553e-7, -7.566908281077895e-7, -7.267001245357085e-7, 
     -6.982736974984723e-7, -6.713108666701357e-7, -6.457186292895741e-7, 
     -6.214109856537932e-7, -5.983083314990352e-7, -5.763369098985693e-7, 
     -5.554283161977451e-7, -5.355190502813358e-7, -5.165501111420265e-7, 
     -4.984666293061894e-7, -4.812175331858486e-7, -4.64755245874139e-7, 
     -4.490354092943454e-7, -4.3401663295719956e-7, 
     -4.1966026488389576e-7, -4.059301825187348e-7, 
     -3.9279260169012785e-7, -3.802159018859331e-7, 
     -3.6817046629226156e-7, -3.5662853520699057e-7, 
     -3.4556407158287913e-7, -3.349526375826572e-7, -3.247712811417255e-7, 
     -3.1499843163486816e-7, -3.056138038331346e-7};
 
  TVIL_REAL GxxxxytableCLy2[] = 
     {0, 0.3333333333333333, 0.046296296296296294, 
     0.0038866026520347507, -0.0014797032972615964, -0.0017604023776863283, 
     -0.0013370879050230097, -0.0009394453727879263, -0.0006563114379174864, 
     -0.00046626608056474765, -0.0003392376047549214, 
     -0.00025302725427591853, -0.0001931970929485326, 
     -0.00015065954662789988, -0.00011969652495883321, 
     -0.00009666128383479465, -0.00007918216561062098, 
     -0.0000656826935875973, -0.000055091517121448864, 
     -0.000046664874026332326, -0.00003987600588917053, 
     -0.00003434490881938946, -0.000029792792596255818, 
     -0.000026011961627480453, -0.000022845510216508168, 
     -0.00002017338508417785, -0.000017902656379604727, 
     -0.000015960619894398643, -0.000014289835776517223, 
     -0.00001284451242360893, -0.000011587838325861847, 
     -0.00001048999090118285, -9.526634838921691e-6, -8.67777848603256e-6, 
     -7.926894937457403e-6, -7.26024078996334e-6, -6.666323882780399e-6, 
     -6.135484322237062e-6, -5.659562353619043e-6, -5.231633329272876e-6, 
     -4.845794892561714e-6, -4.49699507770232e-6, -4.180892680051602e-6, 
     -3.893743235412316e-6, -3.6323054411146617e-6, 
     -3.3937639850896857e-6, -3.175665614886575e-6, 
     -2.9758659441611564e-6, -2.792485009041204e-6, 
     -2.6238699874392773e-6, -2.4685638079366e-6, -2.3252786215691103e-6, 
     -2.1928733049637735e-6, -2.070334318352174e-6, 
     -1.9567593658299148e-6, -1.8513434045766415e-6, 
     -1.7533666297957758e-6, -1.6621841268961966e-6, 
     -1.5772169350489088e-6, -1.4979443091565154e-6, 
     -1.423897002393553e-6, -1.3546514203275185e-6, 
     -1.2898245214149335e-6, -1.229069358339806e-6, -1.172071170986813e-6, 
     -1.1185439554306329e-6, -1.0682274446688289e-6, 
     -1.020884446326542e-6, -9.76298490539577e-7, -9.342717479406562e-7, 
     -8.946231833457185e-7, -8.571869155384228e-7, -8.218107576252858e-7, 
     -7.883549158996553e-7, -7.566908281077895e-7, -7.267001245357085e-7, 
     -6.982736974984723e-7, -6.713108666701357e-7, -6.457186292895741e-7, 
     -6.214109856537932e-7, -5.983083314990352e-7, -5.763369098985693e-7, 
     -5.554283161977451e-7, -5.355190502813358e-7, -5.165501111420265e-7, 
     -4.984666293061894e-7, -4.812175331858486e-7, -4.64755245874139e-7, 
     -4.490354092943454e-7, -4.3401663295719956e-7, 
     -4.1966026488389576e-7, -4.059301825187348e-7, 
     -3.9279260169012785e-7, -3.802159018859331e-7, 
     -3.6817046629226156e-7, -3.5662853520699057e-7, 
     -3.4556407158287913e-7, -3.349526375826572e-7, -3.247712811417255e-7, 
     -3.1499843163486816e-7, -3.056138038331346e-7};
 
  TVIL_REAL GxxxxytableCLxLy[] = 
     {0, -0.8888888888888888, -0.08024691358024691, 
     -0.003200731595793324, 0.004458161865569273, 0.00402772838377167, 
     0.002851931509487099, 0.0019431146517690462, 0.0013363897986451467, 
     0.0009414987731311368, 0.0006819118106653805, 0.000507388973362487, 
     0.00038691810024293086, 0.00030152671883519264, 0.00023947599771702494, 
     0.00019335593922760303, 0.0001583778401972991, 0.0001313708855388047, 
     0.00011018528304174552, 0.00009333067180382237, 0.00007975239272131713, 
     0.00006868997529283269, 0.00005958565064884801, 0.00005202395051200121, 
     0.0000456910318140098, 0.0000403467749322569, 0.00003580531475789151, 
     0.00003192124062912656, 0.000028579671907043464, 
     0.000025689024996627707, 0.000023175676714890807, 
     0.000020979981829114342, 0.000019053269689187424, 
     0.00001735555697688293, 0.00001585378987696366, 0.000014520481580799088, 
     0.000013332647765932712, 0.000012270968644632855, 
     0.000011319124707305901, 0.000010463266658574754, 9.691589785135844e-6, 
     8.99399015540996e-6, 8.361785360105486e-6, 7.787486470825611e-6, 
     7.264610882229744e-6, 6.787527970179553e-6, 6.351331229773228e-6, 
     5.951731888322346e-6, 5.584970018082422e-6, 5.2477399748785605e-6, 
     4.9371276158732025e-6, 4.650557243138221e-6, 4.385746609927547e-6, 
     4.140668636704348e-6, 3.9135187316598295e-6, 3.702686809153283e-6, 
     3.5067332595915516e-6, 3.324368253792393e-6, 3.1544338700978176e-6, 
     2.9958886183130308e-6, 2.847794004787106e-6, 2.709302840655037e-6, 
     2.579649042829867e-6, 2.458138716679612e-6, 2.344142341973626e-6, 
     2.2370879108612658e-6, 2.1364548893376578e-6, 2.041768892653084e-6, 
     1.952596981079154e-6, 1.8685434958813125e-6, 1.789246366691437e-6, 
     1.7143738310768457e-6, 1.6436215152505717e-6, 1.5767098317993105e-6, 
     1.513381656215579e-6, 1.453400249071417e-6, 1.3965473949969445e-6, 
     1.3426217333402714e-6, 1.2914372585791483e-6, 1.2428219713075864e-6, 
     1.1966166629980703e-6, 1.1526738197971387e-6, 1.1108566323954901e-6, 
     1.0710381005626716e-6, 1.033100222284053e-6, 9.969332586123789e-7, 
     9.624350663716971e-7, 9.29510491748278e-7, 8.980708185886908e-7, 
     8.680332659143991e-7, 8.393205297677915e-7, 8.118603650374696e-7, 
     7.855852033802557e-7, 7.604318037718662e-7, 7.363409325845231e-7, 
     7.132570704139811e-7, 6.911281431657583e-7, 6.699052751653144e-7, 
     6.49542562283451e-7, 6.299968632697363e-7, 6.112276076662692e-7};
 
  TVIL_REAL GxxxxytableCLx2Ly[] = 
     {0, 0.16666666666666666, 0.043209876543209874, 
     0.013717421124828532, 0.0054107605547934765, 0.0024555877322223916, 
     0.0012475514685543645, 0.0006981019529919596, 0.0004241786499835841, 
     0.00027598953342914187, 0.0001898086958890235, 0.00013645278564054366, 
     0.00010162523494397648, 0.00007787022973203946, 0.00006106878937466767, 
     0.00004882346217018666, 0.000039672629162799613, 
     0.000032688403708397525, 0.000027260763575104316, 
     0.000022976404628899815, 0.000019547943600861355, 
     0.000016771010374620795, 0.000014497387029476019, 
     0.000012617703929199518, 0.000011050007161481216, 9.73203441684151e-6, 
     8.61589174522293e-6, 7.664319270314181e-6, 6.848029435622934e-6, 
     6.143782134739722e-6, 5.532974290106249e-6, 5.000593856640832e-6, 
     4.534435436818437e-6, 4.124506012816981e-6, 3.762570410192063e-6, 
     3.4418005430268744e-6, 3.156502495319818e-6, 2.901902513773102e-6, 
     2.673977970331513e-6, 2.469322928070618e-6, 2.285040534983099e-6, 
     2.1186563655866823e-6, 1.9680482291299395e-6, 1.831389004217659e-6, 
     1.7070998405638357e-6, 1.5938116587043405e-6, 1.4903333276272802e-6, 
     1.3956252443972397e-6, 1.308777305199497e-6, 1.2289904630892828e-6, 
     1.1555612283651895e-6, 1.0878685935257249e-6, 1.0253629641882354e-6, 
     9.67556756169821e-7, 9.140163817221741e-7, 8.64355398168676e-7, 
     8.18228632594927e-7, 7.753271288643998e-7, 7.35373789676696e-7, 
     6.981196079107459e-7, 6.633403990817763e-7, 6.30833961162376e-7, 
     6.00417599886045e-7, 5.719259674516962e-7, 5.452091706667475e-7, 
     5.201311113144355e-7, 4.965680271566561e-7, 4.7440720668761145e-7, 
     4.535458546981756e-7, 4.338900890279879e-7, 4.153540516792071e-7, 
     3.978591198303742e-7, 3.8133320429285234e-7, 3.6571012465499013e-7, 
     3.509290518092655e-7, 3.369340097955308e-7, 3.236734299525614e-7, 
     3.110997512782002e-7, 2.991690616786884e-7, 2.8784077545964134e-7, 
     2.7707734299080767e-7, 2.6684398897786924e-7, 2.5710847620856866e-7, 
     2.4784089201708157e-7, 2.3901345503795555e-7, 2.3060034010605957e-7, 
     2.225775194077147e-7, 2.1492261820551692e-7, 2.0761478364959015e-7, 
     2.0063456535477052e-7, 1.9396380656964288e-7, 1.8758554489210718e-7, 
     1.8148392159954322e-7, 1.75644098761648e-7, 1.7005218339234507e-7, 
     1.64695157975283e-7, 1.5956081676662385e-7, 1.546377073401758e-7, 
     1.4991507689440373e-7, 1.4538282288928866e-7, 1.4103144762412704e-7};
 
  TVIL_REAL GxxxxytableCLxLy2[] = 
      {0, -0.05555555555555555, -0.030864197530864196, 
     -0.010973936899862825, -0.004648681603414114, -0.0022184965029043674, 
     -0.0011685210587816899, -0.000670504032118962, -0.0004142127341127795, 
     -0.00027229845347699204, -0.00018841428790710024, 
     -0.0001359175583343509, -0.00010141709099156817, 
     -0.00007778839535758834, -0.00006103631541655215, 
     -0.00004881047258694045, -0.000039667397247325446, 
     -0.000032686283585787074, -0.000027259899821448206, 
     -0.000022976051045531817, -0.000019547798238810064, 
     -0.000016770950383932963, -0.000014497362184847723, 
     -0.000012617693607276652, -0.000011050002860680022, 
     -9.732032620062346e-6, -8.615890992725671e-6, -7.664318954451134e-6, 
     -6.848029302759906e-6, -6.143782078743809e-6, -5.532974266463531e-6, 
     -5.000593846641402e-6, -4.534435432582567e-6, -4.124506011019946e-6, 
     -3.7625704094286164e-6, -3.4418005427021068e-6, 
     -3.1565024951814912e-6, -2.901902513714116e-6, 
     -2.6739779703063317e-6, -2.469322928059857e-6, 
     -2.2850405349784954e-6, -2.1186563655847112e-6, 
     -1.9680482291290946e-6, -1.8313890042172966e-6, 
     -1.7070998405636803e-6, -1.5938116587042738e-6, 
     -1.4903333276272514e-6, -1.3956252443972274e-6, 
     -1.3087773051994917e-6, -1.2289904630892805e-6, 
     -1.1555612283651885e-6, -1.0878685935257244e-6, 
     -1.0253629641882351e-6, -9.67556756169821e-7, -9.140163817221741e-7, 
     -8.64355398168676e-7, -8.18228632594927e-7, -7.753271288643998e-7, 
     -7.35373789676696e-7, -6.981196079107459e-7, -6.633403990817763e-7, 
     -6.30833961162376e-7, -6.00417599886045e-7, -5.719259674516962e-7, 
     -5.452091706667475e-7, -5.201311113144355e-7, -4.965680271566561e-7, 
     -4.7440720668761145e-7, -4.535458546981756e-7, -4.338900890279879e-7, 
     -4.153540516792071e-7, -3.978591198303742e-7, -3.8133320429285234e-7, 
     -3.6571012465499013e-7, -3.509290518092655e-7, -3.369340097955308e-7, 
     -3.236734299525614e-7, -3.110997512782002e-7, -2.991690616786884e-7, 
     -2.8784077545964134e-7, -2.7707734299080767e-7, 
     -2.6684398897786924e-7, -2.5710847620856866e-7, 
     -2.4784089201708157e-7, -2.3901345503795555e-7, 
     -2.3060034010605957e-7, -2.225775194077147e-7, 
     -2.1492261820551692e-7, -2.0761478364959015e-7, 
     -2.0063456535477052e-7, -1.9396380656964288e-7, 
     -1.8758554489210718e-7, -1.8148392159954322e-7, -1.75644098761648e-7, 
     -1.7005218339234507e-7, -1.64695157975283e-7, -1.5956081676662385e-7, 
     -1.546377073401758e-7, -1.4991507689440373e-7, 
     -1.4538282288928866e-7, -1.4103144762412704e-7};
 
  TVIL_REAL GxxxxytableCLy3[] = 
     {0, -0.018518518518518517, 0.006172839506172839, 
     0.0027434842249657062, 0.001295534217344917, 0.0006604684245287812, 
     0.0003631635496696717, 0.0002143020370819882, 0.0001347489394139916, 
     0.00008953579117494738, 0.00006233995997505899, 0.0000451274436760527, 
     0.00003373631567971996, 0.000025902186994379068, 
     0.000020334613819478873, 0.00001626582766789808, 0.00001322072177728376, 
     0.00001089472115439221, 9.0863453559307e-6, 7.658565820721272e-6, 
     6.515884292252926e-6, 5.590296797748377e-6, 4.832445780073143e-6, 
     4.205894428451261e-6, 3.683332853292942e-6, 3.2440102744277266e-6, 
     2.8719634134094713e-6, 2.5547728795293626e-6, 2.2826763899656264e-6, 
     2.0479273409159657e-6, 1.8443247476069376e-6, 1.666864612213991e-6, 
     1.5114784761155661e-6, 1.3748353364076367e-6, 1.2541901362217234e-6, 
     1.147266847459113e-6, 1.0521674983477213e-6, 9.673008378850431e-7, 
     8.913259900937168e-7, 8.231076426830319e-7, 7.616801783246307e-7, 
     7.062187885275801e-7, 6.560160763760833e-7, 6.104630014056448e-7, 
     5.690332801878415e-7, 5.312705529014023e-7, 4.967777758757409e-7, 
     4.652084147990717e-7, 4.3625910173316216e-7, 4.09663487696426e-7, 
     3.851870761217292e-7, 3.626228645085747e-7, 3.4178765472941163e-7, 
     3.225189187232736e-7, 3.0467212724072467e-7, 2.8811846605622537e-7, 
     2.7274287753164235e-7, 2.584423762881333e-7, 2.4512459655889866e-7, 
     2.3270653597024863e-7, 2.211134663605921e-7, 2.1027798705412533e-7, 
     2.00139199962015e-7, 1.906419891505654e-7, 1.8173639022224916e-7, 
     1.733770371048118e-7, 1.655226757188854e-7, 1.5813573556253716e-7, 
     1.5118195156605853e-7, 1.4463002967599597e-7, 1.384513505597357e-7, 
     1.3261970661012474e-7, 1.2711106809761744e-7, 1.219033748849967e-7, 
     1.1697635060308849e-7, 1.1231133659851026e-7, 1.0789114331752045e-7, 
     1.0369991709273339e-7, 9.972302055956281e-8, 9.594692515321377e-8, 
     9.235911433026923e-8, 8.894799632595642e-8, 8.570282540285621e-8, 
     8.261363067236052e-8, 7.967115167931852e-8, 7.686678003535319e-8, 
     7.419250646923824e-8, 7.16408727351723e-8, 6.920492788319672e-8, 
     6.687818845159018e-8, 6.465460218988097e-8, 6.252851496403573e-8, 
     6.049464053318107e-8, 5.854803292054933e-8, 5.668406113078169e-8, 
     5.4898385991761e-8, 5.318693892220795e-8, 5.154590244672526e-8, 
     4.9971692298134574e-8, 4.846094096309622e-8, 4.701048254137568e-8};
 
  TVIL_REAL GxxxxytableCLx3[] = 
      {0, 0., -0.018518518518518517, -0.0054869684499314125, 
     -0.00205761316872428, -0.0008975596538468052, -0.0004421939594423464, 
     -0.0002418999579549857, -0.00014471485528479624, 
     -0.00009322687112709726, -0.00006373436795698226, 
     -0.00004566267098224548, -0.00003394445963212826, 
     -0.000025984021368830195, -0.0000203670877775944, 
     -0.00001627881725114429, -0.000013225953692757929, 
     -0.000010896841277002656, -9.087209109586808e-6, -7.65891940408927e-6, 
     -6.516029654304214e-6, -5.59035678843621e-6, -4.832470624701437e-6, 
     -4.205904750374128e-6, -3.6833371540941365e-6, 
     -3.2440120712068925e-6, -2.871964165906729e-6, 
     -2.5547731953924087e-6, -2.282676522828654e-6, 
     -2.0479273969118777e-6, -1.8443247712496558e-6, 
     -1.6668646222134202e-6, -1.5114784803514354e-6, 
     -1.3748353382046722e-6, -1.2541901369851698e-6, 
     -1.1472668477838808e-6, -1.0521674984860484e-6, 
     -9.673008379440294e-7, -8.913259901188981e-7, -8.231076426937931e-7, 
     -7.616801783292341e-7, -7.062187885295512e-7, -6.56016076376928e-7, 
     -6.104630014060071e-7, -5.690332801879972e-7, -5.312705529014691e-7, 
     -4.967777758757696e-7, -4.6520841479908404e-7, 
     -4.3625910173316746e-7, -4.0966348769642835e-7, 
     -3.851870761217302e-7, -3.626228645085751e-7, -3.4178765472941184e-7, 
     -3.225189187232737e-7, -3.046721272407247e-7, -2.8811846605622537e-7, 
     -2.7274287753164235e-7, -2.584423762881333e-7, 
     -2.4512459655889866e-7, -2.3270653597024863e-7, 
     -2.211134663605921e-7, -2.1027798705412533e-7, -2.00139199962015e-7, 
     -1.906419891505654e-7, -1.8173639022224916e-7, -1.733770371048118e-7, 
     -1.655226757188854e-7, -1.5813573556253716e-7, 
     -1.5118195156605853e-7, -1.4463002967599597e-7, 
     -1.384513505597357e-7, -1.3261970661012474e-7, 
     -1.2711106809761744e-7, -1.219033748849967e-7, 
     -1.1697635060308849e-7, -1.1231133659851026e-7, 
     -1.0789114331752045e-7, -1.0369991709273339e-7, 
     -9.972302055956281e-8, -9.594692515321377e-8, -9.235911433026923e-8, 
     -8.894799632595642e-8, -8.570282540285621e-8, -8.261363067236052e-8, 
     -7.967115167931852e-8, -7.686678003535319e-8, -7.419250646923824e-8, 
     -7.16408727351723e-8, -6.920492788319672e-8, -6.687818845159018e-8, 
     -6.465460218988097e-8, -6.252851496403573e-8, -6.049464053318107e-8, 
     -5.854803292054933e-8, -5.668406113078169e-8, -5.4898385991761e-8, 
     -5.318693892220795e-8, -5.154590244672526e-8, -4.9971692298134574e-8, 
     -4.846094096309622e-8, -4.701048254137568e-8};
 
  TVIL_REAL GxxxxytableB[] = {-3.197512627307807, 10.602527649303676, 0.5540971022564781, 
     0.2516611733276796, -0.17019332087408084, 0.1126209405944749, 
     -0.07872877206447133, 0.057815373546684, -0.04415271479667997, 
     0.034779522361234314, -0.028085791027967214, 0.02314546827860935, 
     -0.01939825079194293, 0.016490026799845355, -0.01418849531444692, 
     0.012336307021485837, -0.01082389049169812, 0.009573083066361067, 
     -0.008526935156026781, 0.007643169662170354, -0.006889875009567475, 
     0.006242602115405749, -0.00568236633946535, 0.00519424616876294, 
     -0.004766383528264501, 0.004389259475410559, -0.004055161944432343, 
     0.00375778951638444, -0.003491952914820706, 0.003253347637441288, 
     -0.0030383789997651227, 0.0028440262312590266, -0.002667735974818113, 
     0.002507338140840632, -0.0023609789118982437, 0.002227067017735261, 
     -0.002104230360385634, 0.001991280772493602, -0.0018871852119987525, 
     0.0017910420843515339, -0.001702061675326038, 0.0016195498988358554, 
     -0.0015428947332498844, 0.0014715548497979273, -0.0014050500374185792, 
     0.0013429531069459912, -0.0012848830191291368, 0.0012304990295635544, 
     -0.0011794956821509326, 0.001131598513426633, -0.0010865603547158163, 
     0.001044158138902971, -0.0010041901346354019, 0.0009664735438098568, 
     -0.000930842408821775, 0.0008971457847653721, -0.0008652461389352029, 
     0.0008350179458926525, -0.0008063464512596679, 0.0007791265814749822, 
     -0.0007532619801456962, 0.0007286641544705302, -0.0007052517175981439, 
     0.0006829497147939498, -0.0006616890229862825, 0.0006414058147003037, 
     -0.0006220410786087176, 0.0006035401899676912, -0.0005858525250935224, 
     0.0005689311147947232, -0.0005527323323253279, 0.0005372156119850417, 
     -0.0005223431949742234, 0.0005080798995282512, -0.0004943929127163157, 
     0.00048125160160228934, -0.00046862734173695893, 0.00045649336118739394, 
     -0.000444824598515506, 0.00043359757329811853, -0.00042279026793867687, 
     0.00041238201965912647, -0.00040235342168206507, 0.0003926862327202536, 
     -0.00038336329398485784, 0.00037436845300702423, -0.0003656864936409775, 
     0.00035730307168198056, -0.0003492046555902736, 0.0003413784718634072, 
     -0.00033381245464500806, 0.0003264951991986354, -0.00031941591891160694, 
     0.00031256440552600875, -0.0003059309923230115, 0.00029950652001248707, 
     -0.0002932823051031052, 0.0002872501105488917, -0.00028140211848691547, 
     0.0002757309048975719, -0.00027022941603406156};
 
  TVIL_REAL GxxxxytableBL[] = {22.348606808527123, 4.454822555520438, 0.3634516296530417, 
     0.25461934813878334, -0.19311581798406666, 0.13615128606345187, 
     -0.0990191171370559, 0.07470335017868768, -0.05817537855564856, 
     0.04650857505703271, -0.03799552519422637, 0.03160559206162165, 
     -0.026692609697852813, 0.02283681588142982, -0.01975672468527041, 
     0.017258207883800603, -0.01520403415618242, 0.013495051847272193, 
     -0.012058221072688079, 0.010838799676292492, -0.009795119329323225, 
     0.008895017988336617, -0.008113356107140878, 0.007430256862137142, 
     -0.006829839322959437, 0.006299293111822909, -0.005828193416456754, 
     0.005407987661066282, -0.005031606434517131, 0.004693165489873384, 
     -0.004387735266667833, 0.004111161015723496, -0.0038599212267856477, 
     0.0036310153204016315, -0.003421873894263979, 0.0032302864954371134, 
     -0.003054343116078091, 0.0028923865132282696, -0.0027429731242443684, 
     0.002604840852323675, -0.002476882376526078, 0.0023581229299568826, 
     -0.0022477017115910343, 0.0021448562684866033, -0.0020489093182364418, 
     0.0019592575855893607, -0.0018753623090438725, 0.0017967411379811219, 
     -0.0017229611924095482, 0.0016536330985665066, -0.001588405846696251, 
     0.0015269623440172316, -0.0014690155575325815, 0.0014143051589581006, 
     -0.0013625945984484186, 0.0013136685456274797, -0.0012673306461735729, 
     0.0012234015502677435, -0.0011817171759027124, 0.001142127175619399, 
     -0.0011044935798920276, 0.0010686895942836265, -0.0010345985307733847, 
     0.0010021128564228772, -0.0009711333448868932, 0.0009415683182578305, 
     -0.0009133329684189041, 0.0008863487485189314, -0.0008605428264099786, 
     0.0008358475929416156, -0.0008122002189092981, 0.0007895422552322477, 
     -0.0007678192716071694, 0.0007469805294641659, -0.000726978685553654, 
     0.0007077695229292189, -0.0006893117064706696, 0.000671566560422097, 
     -0.0006544978657083207, 0.0006380716750455035, -0.0006222561440828666, 
     0.0006070213770065292, -0.0005923392852071487, 0.000578183457763305, 
     -0.0005645290426251152, 0.000551352637499651, -0.0005386321895433217, 
     0.0005263469030581683, -0.0005144771544704596, 0.0005030044139423489, 
     -0.0004919111730317438, 0.00048118087787291845, -0.00047079786740158514, 
     0.00046074731619387275, -0.000451015181529561, 0.00044158815432655097, 
     -0.00043245361362639423, 0.0004235995843401897, -0.00041501469799065237, 
     0.0004066881562100013, -0.00039860969677478757};
 
  TVIL_REAL GxxxxytableBL2[] = {-9.727411277760218, -1.2274112777602189, 1., 
     -0.3333333333333333, 0.16666666666666666, -0.1, 0.06666666666666667, 
     -0.047619047619047616, 0.03571428571428571, -0.027777777777777776, 
     0.022222222222222223, -0.01818181818181818, 0.015151515151515152, 
     -0.01282051282051282, 0.01098901098901099, -0.009523809523809525, 
     0.008333333333333333, -0.007352941176470588, 0.006535947712418301, 
     -0.005847953216374269, 0.005263157894736842, -0.004761904761904762, 
     0.004329004329004329, -0.003952569169960474, 0.0036231884057971015, 
     -0.0033333333333333335, 0.003076923076923077, -0.002849002849002849, 
     0.0026455026455026454, -0.0024630541871921183, 0.0022988505747126436, 
     -0.002150537634408602, 0.0020161290322580645, -0.001893939393939394, 
     0.0017825311942959, -0.0016806722689075631, 0.0015873015873015873, 
     -0.0015015015015015015, 0.001422475106685633, -0.001349527665317139, 
     0.001282051282051282, -0.0012195121951219512, 0.0011614401858304297, 
     -0.0011074197120708748, 0.0010570824524312897, -0.00101010101010101, 
     0.000966183574879227, -0.0009250693802035153, 0.0008865248226950354, 
     -0.0008503401360544217, 0.0008163265306122449, -0.000784313725490196, 
     0.0007541478129713424, -0.000725689404934688, 0.0006988120195667365, 
     -0.0006734006734006734, 0.0006493506493506494, -0.0006265664160401002, 
     0.0006049606775559589, -0.0005844535359438924, 0.0005649717514124294, 
     -0.000546448087431694, 0.0005288207297726071, -0.0005120327700972862, 
     0.000496031746031746, -0.0004807692307692308, 0.0004662004662004662, 
     -0.0004522840343735866, 0.0004389815627743635, -0.00042625745950554135, 
     0.00041407867494824016, -0.00040241448692152917, 0.0003912363067292645, 
     -0.000380517503805175, 0.00037023324694557573, -0.00036036036036036037, 
     0.0003508771929824561, -0.0003417634996582365, 0.000333000333000333, 
     -0.0003245699448231094, 0.00031645569620253165, -0.00030864197530864197, 
     0.00030111412225233364, -0.0002938583602703497, 0.00028686173264486515, 
     -0.00028011204481792715, 0.00027359781121751026, -0.0002673082063619353, 
     0.00026123301985370953, -0.0002553626149131767, 0.00024968789013732833, 
     -0.0002442002442002442, 0.00023889154323936931, -0.0002337540906965872, 
     0.00022878059940517045, -0.00022396416573348266, 0.0002192982456140351, 
     -0.0002147766323024055, 0.00021039343572480537, -0.00020614306328592042, 
     0.00020202020202020202};
 
  TVIL_REAL GxxxxytableD[] = 
     {0, 2.7480210450086475, -0.16399130575669638, 
     0.09882698433854777, -0.05265271615074063, 0.03227341274192837, 
     -0.021741522654166835, 0.01562557344501031, -0.011766764554686482, 
     0.009178203782279171, -0.007358253954094998, 0.006030337232709244, 
     -0.00503189263022729, 0.004262321114893906, -0.0036566725715227134, 
     0.003171498611508199, -0.0027768453557531518, 0.0024515201587140757, 
     -0.0021801875247460466, 0.0019515289057924188, -0.001757043256303326, 
     0.0015902455151348464, -0.0014461190031227142, 0.0013207338064515342, 
     -0.0012109760433627057, 0.0011143526669194672, -0.0010288486451140988, 
     0.0009528210513625916, -0.0008849195531002841, 0.0008240260381837225, 
     -0.0007692082902899047, 0.0007196840976468761, -0.000674793193548347, 
     0.000633975134762056, -0.0005967517240115651, 0.0005627129402632306, 
     -0.0005315055990213298, 0.0005028241536099151, -0.00047640318762811343, 
     0.00045201125235565725, -0.00042944578063136086, 0.00040852886754847773, 
     -0.0003891037531539686, 0.00037103187677256527, -0.0003541903991985923, 
     0.00033847010971489543, -0.0003237736511186757, 0.0003100140087090024, 
     -0.0002971132193085483, 0.00028500126444822656, -0.00027361511829075285, 
     0.0002628979260541835, -0.00025279829288581715, 0.00024326966653685498, 
     -0.00023426979995944922, 0.00022576028221582044, 
     -0.00021770612795269265, 0.00021007541723133916, 
     -0.00020283897877590077, 0.00019597011075961313, 
     -0.00018944433412960407, 0.00018323917420768457, 
     -0.00017733396692262352, 0.0001717096865494679, -0.0001663487922703694, 
     0.00016123509124282856, -0.00015635361617649644, 0.0001516905156879039, 
     -0.0001472329559313113, 0.0001429690321995678, -0.00013888768935663338, 
     0.00013497865010757818, -0.00013123235023602975, 0.00012763988004620334, 
     -0.00012419293133934806, 0.00012088374933478891, 
     -0.00011770508901553116, 0.00011465017543912347, 
     -0.00011171266760742783, 0.00010888662553519865, 
     -0.00010616648019785064, 0.00010354700607427986, 
     -0.00010102329603176217, 0.00009859073832736355, 
     -0.00009624499552444464, 0.00009398198514415268, 
     -0.00009179786189062777, 0.00008968900130532107, 
     -0.00008765198472060081, 0.00008568358539594057, -0.0000837807557316461, 
     0.00008194061546545894, -0.00008016044076662852, 0.00007843765415030441, 
     -0.00007676981514248138, 0.00007515461163233544, 
     -0.00007358985185470604, 0.00007207345695078794, 
     -0.00007060345405986226, 0.00006917796989918206, -0.00006779522479298495};
 
  TVIL_REAL GxxxxytableDL[] = 
     {0, 1.3280463806552705, -0.2186975871035137, 
     0.12845475125672678, -0.07174761194892897, 0.0450539635215082, 
     -0.030781213381871893, 0.02232424768031541, -0.016917752027425906, 
     0.01325740228634727, -0.010666352641678704, 0.008765923455703912, 
     -0.0073311097273131755, 0.006221497298689193, -0.005345824471730073, 
     0.004642710405504938, -0.004069648147935945, 0.0035964498632350627, 
     -0.0032012004186621674, 0.002867680026044644, -0.002583676868542607, 
     0.0023398552080642404, -0.0021289794823856766, 0.0019453719969755765, 
     -0.001784527186160578, 0.0016428328487905924, -0.0015173657573760368, 
     0.0014057398030670883, -0.0013059917947846889, 0.0012164946097603406, 
     -0.0011358904584165463, 0.0010630391113052996, -0.0009969773741609015, 
     0.0009368871028294241, -0.0008820697618443181, 0.0008319260403774927, 
     -0.0007859394085249639, 0.0007436627669514287, -0.0007047075423440928, 
     0.0006687347297160743, -0.0006354474942519688, 0.0006045850299568943, 
     -0.0005759174369101424, 0.0005492414285320382, -0.0005243767186617271, 
     0.0005011629681429953, -0.00047945719404525347, 0.0004591315631144789, 
     -0.00044007150568623117, 0.0004221740979558993, -0.0004053466698416065, 
     0.0003895056031915755, -0.0003745752911644787, 0.0003604872345459633, 
     -0.00034717925478887774, 0.00033459480686010457, 
     -0.00032268237768597784, 0.00031139495822376346, 
     -0.00030068957903809897, 0.0002905269007999901, -0.00028087085240907015, 
     0.00027168831051329, -0.0002629488151010855, 0.00025462431659940664, 
     -0.0002466889505512105, 0.00023911883648804089, -0.00023189189807346246, 
     0.00022498770198478663, -0.00021838731333476241, 0.00021207316572084104, 
     -0.00020602894423482463, 0.00020023947997647055, 
     -0.00019469065479619014, 0.00018936931514874428, 
     -0.00018426319407546977, 0.0001793608404501683, -0.00017465155472595008, 
     0.00017012533050925286, -0.0001657728013648112, 0.0001615851923231121, 
     -0.0001575542756211857, 0.00015367233025958448, -0.00014993210500408567, 
     0.0001463267845008375, -0.0001428499582090864, 0.00013949559188687835, 
     -0.00013625800139276028, 0.0001331318285909674, -0.00013011201916927212, 
     0.0001271938021979259, -0.00012437267127524685, 0.00012164436712064931, 
     -0.00011900486148950288, 0.00011645034229633883, 
     -0.00011397719984376683, 0.0001115820140641688, -0.00010926154268993257, 
     0.00010701271027578927, -0.00010483259800382426, 0.00010271843420803197, 
     -0.00010066758556095591};
 
  TVIL_REAL GxxxxytableDL2[] = 
     {0, -1., 0.25, -0.08333333333333333, 0.041666666666666664, 
     -0.025, 0.016666666666666666, -0.011904761904761904, 
     0.008928571428571428, -0.006944444444444444, 0.005555555555555556, 
     -0.004545454545454545, 0.003787878787878788, -0.003205128205128205, 
     0.0027472527472527475, -0.002380952380952381, 0.0020833333333333333, 
     -0.001838235294117647, 0.0016339869281045752, -0.0014619883040935672, 
     0.0013157894736842105, -0.0011904761904761906, 0.0010822510822510823, 
     -0.0009881422924901185, 0.0009057971014492754, -0.0008333333333333334, 
     0.0007692307692307692, -0.0007122507122507123, 0.0006613756613756613, 
     -0.0006157635467980296, 0.0005747126436781609, -0.0005376344086021505, 
     0.0005040322580645161, -0.0004734848484848485, 0.000445632798573975, 
     -0.0004201680672268908, 0.0003968253968253968, -0.00037537537537537537, 
     0.00035561877667140827, -0.00033738191632928474, 0.0003205128205128205, 
     -0.0003048780487804878, 0.00029036004645760743, -0.0002768549280177187, 
     0.0002642706131078224, -0.0002525252525252525, 0.00024154589371980676, 
     -0.00023126734505087883, 0.00022163120567375886, 
     -0.00021258503401360543, 0.00020408163265306123, -0.000196078431372549, 
     0.0001885369532428356, -0.000181422351233672, 0.00017470300489168413, 
     -0.00016835016835016836, 0.00016233766233766234, 
     -0.00015664160401002505, 0.00015124016938898973, -0.0001461133839859731, 
     0.00014124293785310735, -0.0001366120218579235, 0.00013220518244315177, 
     -0.00012800819252432156, 0.0001240079365079365, -0.0001201923076923077, 
     0.00011655011655011655, -0.00011307100859339665, 0.00010974539069359087, 
     -0.00010656436487638534, 0.00010351966873706004, 
     -0.00010060362173038229, 0.00009780907668231612, 
     -0.00009512937595129375, 0.00009255831173639393, 
     -0.00009009009009009009, 0.00008771929824561403, 
     -0.00008544087491455913, 0.00008325008325008325, 
     -0.00008114248620577734, 0.00007911392405063291, 
     -0.00007716049382716049, 0.00007527853056308341, 
     -0.00007346459006758743, 0.00007171543316121629, 
     -0.00007002801120448179, 0.00006839945280437756, 
     -0.00006682705159048383, 0.00006530825496342738, 
     -0.00006384065372829418, 0.00006242197253433208, 
     -0.00006105006105006105, 0.00005972288580984233, -0.0000584385226741468, 
     0.00005719514985129261, -0.000055991041433370664, 
     0.00005482456140350877, -0.000053694158075601374, 
     0.000052598358931201344, -0.000051535765821480104, 
     0.000050505050505050505};
 
  TVIL_REAL GxxxxytableF[] = {11.182995202585692, 28.15358392643667, 4.279929431501079, 
     0.11438573360426604, -0.24287382586973777, 0.19352278023167443, 
     -0.1464119429131649, 0.11233593517297841, -0.08820683319107062, 
     0.07082468058561256, -0.05799799108139685, 0.04830628934797364, 
     -0.04082438735110384, 0.03493748841949688, -0.030227336762334762, 
     0.026402699247528638, -0.02325633566539576, 0.0206378126920452, 
     -0.018435942769461998, 0.016567190136197056, -0.014967856531209538, 
     0.013588711939932994, -0.01239123902674664, 0.011344962765424437, 
     -0.01042552273378838, 0.009613261971408684, -0.00889218058145661, 
     0.008249150496653158, -0.007673319682180984, 0.007155655412782567, 
     -0.006688590802003198, 0.00626574879460489, -0.005881724845391525, 
     0.005531914467922906, -0.005212375385175641, 0.004919716579969655, 
     -0.004651008416745141, 0.004403709387618592, -0.004175606063059731, 
     0.00396476359813781, -0.003769484727883115, 0.003588275629092859, 
     -0.0034198173663754763, 0.0032629419032037294, -0.003116611863184155, 
     0.0029799033866572144, -0.0028519915535519563, 0.002732137942955363, 
     -0.002619679979027038, 0.0025140217761828905, -0.0024146262473181174, 
     0.002321008279878362, -0.002232728817858199, 0.0021493897148935253, 
     -0.0020706292457571486, 0.0019961181817360527, -0.0019255563503285849, 
     0.0018586696120521948, -0.0017952071973700342, 0.0017349393551942904, 
     -0.0016776552713795754, 0.0016231612212665295, -0.0015712789247617066, 
     0.00152184407560626, -0.0014747050181684286, 0.0014297215447695473, 
     -0.001386763783191366, 0.0013457111357110874, -0.0013064512143375838, 
     0.0012688786857538996, -0.0012328938829337225, 0.001198400939226174, 
     -0.0011653050207855189, 0.0011335079141957007, -0.0011029006611764783, 
     0.0010733509322898615, -0.0010446810619245967, 0.0010166295350366589, 
     -0.0009887831730689576, 0.0009604574542454961, -0.0009304850311555946, 
     0.0008968417461934936, -0.0008559849630097126, 0.0008016825233864171, 
     -0.000722939657266459, 0.0006003282007346351, -0.00039948553390263346, 
     0.000059598904927459255, 0.0005269964500769457, -0.001550968607138612, 
     0.0033500580455963725, -0.0065226420942024015, 0.01212906277746216, 
     -0.02204859665198249, 0.03961248446445047, -0.0707266736761138, 
     0.1258634024373431, -0.22359448085080935, 0.39686057247289863, 
     -0.7040966081671682, 1.2489774766533637};
 
  TVIL_REAL GxxxxytableFL[] = {28.73038785456922, 13.149794828901914, 3.1168098531636756, 
     0.0014789231864387323, -0.20515254949992184, 0.1910341723256109, 
     -0.15653446733385326, 0.12645496517099164, -0.10301234144199252, 
     0.08504474325469732, -0.07118236730069764, 0.06034606066644689, 
     -0.051751652776853056, 0.044838569241992095, -0.039204500191702636, 
     0.03455747110429236, -0.03068267172644708, 0.02741981317392816, 
     -0.02464763053713715, 0.02227317556495362, -0.020224328009985887, 
     0.018444488721237867, -0.016888768766046593, 0.015521217392919822, 
     -0.014312780671460884, 0.013239780574528508, -0.012282769289508404, 
     0.01142565721899285, -0.010655042817980095, 0.009959692836177758, 
     -0.009330135746592768, 0.008758341145116215, -0.008237465023320468, 
     0.007761645933370752, -0.0073258407786519425, 0.006925691685943348, 
     -0.006557417427738614, 0.006217724364151887, -0.0059037330020134775, 
     0.005612917123292268, -0.005343053086982375, 0.005092177409519472, 
     -0.004858551116200889, 0.004640629657590111, -0.004437037420951655, 
     0.00424654605265322, -0.004068055954657382, 0.003900580435376631, 
     -0.0037432320888808844, 0.0035952110517756116, -0.003455794847898285, 
     0.003324329580319801, -0.0032002222703266317, 0.0030829341759295087, 
     -0.0029719749494340458, 0.002866897515853778, -0.002767293572347405, 
     0.0026727896241372884, -0.0025830434850893564, 0.0024977411817665575, 
     -0.002416594208680591, 0.002339337089960579, -0.0022657252089770393, 
     0.0021955328728040595, -0.0021285515829349458, 0.002064588487520408, 
     -0.0020034649936836535, 0.0019450155212744013, -0.001889086381829129, 
     0.0018355347685702415, -0.0017842278450544554, 0.001735041921613974, 
     -0.0016878617100594098, 0.0016425796482614856, -0.0015990952872250433, 
     0.0015573147341355284, -0.0015171501456132759, 0.0014785192660701494, 
     -0.0014413450066396466, 0.0014055550606566893, -0.0013710815521066418, 
     0.0013378607138528047, -0.00130583259279479, 0.001274940779412835, 
     -0.0012451321594204412, 0.0012163566854842237, -0.0011885671671793897, 
     0.0011617190775351654, -0.0011357703746896792, 0.0011106813373207621, 
     -0.0010864144126500723, 0.0010629340759347498, -0.0010402067004651528, 
     0.0010182004371805426, -0.0009968851030981473, 0.000976232077825957, 
     -0.0009562142074968538, 0.0009368057155221085, -0.0009179821196166516, 
     0.000899720154597491, -0.0008819977005008034};
 
  TVIL_REAL GxxxxytableFL2[] = {-10.112489401987013, 0.8875105980129873, 2.25, -0.75, 
     0.375, -0.225, 0.15, -0.10714285714285714, 0.08035714285714286, -0.0625, 
     0.05, -0.04090909090909091, 0.03409090909090909, -0.028846153846153848, 
     0.024725274725274724, -0.02142857142857143, 0.01875, 
     -0.016544117647058824, 0.014705882352941176, -0.013157894736842105, 
     0.011842105263157895, -0.010714285714285714, 0.00974025974025974, 
     -0.008893280632411068, 0.008152173913043478, -0.0075, 
     0.006923076923076923, -0.00641025641025641, 0.005952380952380952, 
     -0.005541871921182266, 0.005172413793103448, -0.004838709677419355, 
     0.0045362903225806455, -0.004261363636363636, 0.004010695187165776, 
     -0.003781512605042017, 0.0035714285714285713, -0.0033783783783783786, 
     0.003200568990042674, -0.003036437246963563, 0.0028846153846153848, 
     -0.00274390243902439, 0.002613240418118467, -0.0024916943521594683, 
     0.0023784355179704017, -0.0022727272727272726, 0.002173913043478261, 
     -0.0020814061054579094, 0.0019946808510638296, -0.001913265306122449, 
     0.001836734693877551, -0.0017647058823529412, 0.0016968325791855204, 
     -0.001632801161103048, 0.0015723270440251573, -0.0015151515151515152, 
     0.001461038961038961, -0.0014097744360902255, 0.0013611615245009074, 
     -0.001315020455873758, 0.001271186440677966, -0.0012295081967213116, 
     0.001189846641988366, -0.001152073732718894, 0.0011160714285714285, 
     -0.0010817307692307693, 0.001048951048951049, -0.0010176390773405698, 
     0.000987708516242318, -0.0009590792838874681, 0.0009316770186335404, 
     -0.0009054325955734407, 0.0008802816901408451, -0.0008561643835616438, 
     0.0008330248056275454, -0.0008108108108108108, 0.0007894736842105263, 
     -0.0007689678742310321, 0.0007492507492507493, -0.0007302823758519961, 
     0.0007120253164556962, -0.0006944444444444445, 0.0006775067750677507, 
     -0.0006611813106082868, 0.0006454388984509467, -0.0006302521008403362, 
     0.0006155950752393981, -0.0006014434643143544, 0.0005877742946708464, 
     -0.0005745658835546476, 0.0005617977528089888, -0.0005494505494505495, 
     0.000537505972288581, -0.0005259467040673212, 0.0005147563486616335, 
     -0.000503919372900336, 0.000493421052631579, -0.0004832474226804124, 
     0.00047338523038081213, -0.00046382189239332097, 0.00045454545454545455};
 
  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  if (y < 0.5 * x) {
    result = TVIL_Gx0xxx (x, qq);
    result += y*(2.997072792151277L + 2.1719536193447295L*lnbarx 
      - 0.5L*lnbarx2 - 0.3333333333333333L*lnbarx3 
      - 0.6719536193447294L*lnbary - lnbarx*lnbary + 0.5L*lnbarx2*lnbary);
    rn = r = y/x;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (
        GxxxxytableA[n] +
        GxxxxytableALx[n] * lnbarx +
        GxxxxytableALy[n] * lnbary +
        GxxxxytableALx2[n] * lnbarx2 + 
        GxxxxytableALxLy[n] * lnbarx * lnbary);
    }
  } 
  else if (y < 1.6 * x) {
    result = TVIL_Gxxxxx (x, qq);
    result += (y - x) * lnbarx3 * (1.L/6.L);
    rn = r = y/x - 1.L;
    for (n=1; n < 100; n++) {
      result += x * rn * (
        GxxxxytableD[n] +
        GxxxxytableDL[n] * lnbarx +
        GxxxxytableDL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else if (y < 5.59 * x) {
    result = ((5.L*x + y)/6.L) * lnbarx3; 
    rn = 1;
    r = 0.25L * y/x - 1.L;
    for (n=0; n < 100; n++) {
      result += x * rn * (
        GxxxxytableB[n] +
        GxxxxytableBL[n] * lnbarx +
        GxxxxytableBL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else if (y < 14.56 * x) {
    result = ((5.L*x + y)/6.L) * lnbarx3; 
    rn = 1;
    r = y/(9.L*x) - 1.L;
    for (n=0; n < 85; n++) {
      result += x * rn * (
        GxxxxytableF[n] +
        GxxxxytableFL[n] * lnbarx +
        GxxxxytableFL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else {
    result = TVIL_G0000x (y, qq);
    rn = r = 9.L * x/y;
    for (n=1; n < 100; n++) {
      result += y * rn * (
        GxxxxytableC[n] +
        GxxxxytableCLx[n] * lnbarx +
        GxxxxytableCLy[n] * lnbary +
        GxxxxytableCLx2[n] * lnbarx2 +
        GxxxxytableCLxLy[n] * lnbarx * lnbary +
        GxxxxytableCLy2[n] * lnbary2 + 
        GxxxxytableCLx3[n] * lnbarx3 + 
        GxxxxytableCLx2Ly[n] * lnbarx2 * lnbary +
        GxxxxytableCLxLy2[n] * lnbarx * lnbary2 +
        GxxxxytableCLy3[n] * lnbary3);
      rn *= r;
    }
  }

  return result;
}

/* ****************************************************************** */
TVIL_COMPLEX TVIL_Gyxxxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  TVIL_REAL GyxxxytableA[] = 
     {0, 0.38723014310098935, -0.036719882675303565, 0.0014757320760509192, 
     0.0012071032030904968, 0.0009061313514220126, 0.00071242727702229, 
     0.0005779822439292061, 0.00048026469099685874, 0.0004068234274468896, 
     0.0003501072384629669, 0.0003052987853765892, 0.0002692072825272324, 
     0.00023965157061897328, 0.00021509920230051822, 0.00019444726432663907, 
     0.00017688492680078852, 0.00016180474483931418, 0.00014874393215165928, 
     0.00013734456885007579, 0.00012732606948286606, 0.00011846576988045093, 
     0.00011058500133060884, 0.00010353894334017442, 0.00009720912311782524, 
     0.00009149779820244512, 0.0000863236983749168, 0.00008161876182782377, 
     0.00007732560756802174, 0.00007339555922076042, 0.00006978708618974275, 
     0.00006646456383508696, 0.0000633972797492174, 0.000060558631514261666, 
     0.00005792547464805449, 0.00005547758924304705, 0.000053197241075487005, 
     0.000051068818410053844, 0.000049078529840363525, 
     0.000047214151639233924, 0.000045464815496588956, 0.0000438208293804103, 
     0.00004227352570118056, 0.00004081513209164616, 0.00003943866100496661, 
     0.00003813781504047314, 0.00003690690546887757, 0.0000357407818794007, 
     0.00003463477123404628, 0.00003358462490767705, 0.000032586472530999724, 
     0.00003163678164819562, 0.00003073232236047034, 0.000029870136258098494, 
     0.00002904750905202774, 0.00002826194640608055, 0.00002751115254568139, 
     0.00002679301128158653, 0.000026105569139512362, 0.00002544702033062744, 
     0.000024815693335039326, 0.000024210038901844698, 
     0.00002362861929598016, 0.00002307009864479848, 0.00002253323425664704, 
     0.000022016868800275646, 0.000021519923248091217, 
     0.000021041390498473036, 0.000020580329602870065, 
     0.000020135860532475172, 0.00001970715942712376, 0.000019293454275875, 
     0.000018894020984653213, 0.00001850817979148236, 0.0000181352919943452, 
     0.000017774756960632006, 0.000017426009390589196, 
     0.000017088516810201554, 0.000016761777271599878, 
     0.000016445317241426426, 0.00001613868965965524, 
     0.000015841472153188654, 0.000015553265390165666, 
     0.000015273691562348644, 0.000015002392984224933, 
     0.000014739030798588991, 0.000014483283779375902, 0.0000142348472234131, 
     0.000013993431923557224, 0.000013758763216398085, 
     0.00001353058009835179, 0.000013308634404538803, 
     0.000013092690045357454, 0.000012882522296125935, 
     0.000012677917135581864, 0.000012478670629403172, 
     0.000012284588355251818, 0.000012095484866146841, 
     0.000011911183189248659, 0.000011731514357385799, 0.00001155631697088092};
 
  TVIL_REAL GyxxxytableALx[] = 
     {0, 0.3064981810844339, -0.05835154200571963, -0.030993974258768858, 
     -0.02325919917152607, -0.01820402301596771, -0.014698101084750346, 
     -0.012167725179107452, -0.010278117220335427, -0.00882617111926999, 
     -0.007683542682914123, -0.0067660256618142355, -0.006016510802315558, 
     -0.005395128308263948, -0.004873330415047532, -0.004430217289285219, 
     -0.004050185608367297, -0.0037213822752889237, -0.0034346625809784596, 
     -0.0031828727654544726, -0.0029603461627192404, -0.002762542999477795, 
     -0.002585788702817613, -0.00242708096144498, -0.0022839455527788937, 
     -0.002154327273940248, -0.0020365064879322883, -0.0019290345969341929, 
     -0.001830683663984817, -0.0017404067252171603, -0.001657306261066936, 
     -0.0015806089526677874, -0.0015096453223098151, -0.0014438332002360305, 
     -0.0013826642121197942, -0.0013256926683930428, -0.0012725263763308863, 
     -0.0012228190012111503, -0.0011762636830329643, -0.0011325876767105006, 
     -0.0010915478310752455, -0.0010529267588712107, -0.0010165295787532764, 
     -0.0009821811329865941, -0.0009497236025067142, -0.0009190144552999983, 
     -0.000889924675509254, -0.0008623372298769134, -0.0008361457355811644, 
     -0.0008112532995653068, -0.0007875715043918384, -0.0007650195196926897, 
     -0.0007435233216103188, -0.0007230150053689029, -0.0007034321783899853, 
     -0.0006847174232597886, -0.0006668178214357215, -0.0006496845299034267, 
     -0.0006332724041082727, -0.000617539661423115, -0.0006024475802072413, 
     -0.0005879602301839855, -0.0005740442304364689, -0.0005606685318086637, 
     -0.0005478042209159823, -0.0005354243433270331, -0.0005235037437853155, 
     -0.0005120189216041604, -0.0005009478995965995, -0.0004902701050994402, 
     -0.0004799662618221632, -0.00047001829140014213, -0.0004604092236613239, 
     -0.00045112311472860503, -0.00044214497217901134, 
     -0.00043346068656736913, -0.0004250569686981286, -0.0004169212920957693, 
     -0.0004090418401830091, -0.00040140745772788755, -0.0003940076061665975, 
     -0.0003868323224494659, -0.0003798721810934, -0.0003731182591559884, 
     -0.0003665621038747782, -0.0003601957027404695, -0.00035401145579524556, 
     -0.00034800214996752384, -0.00034216093527234556, 
     -0.0003364813027226738, -0.00033095706381125163, -0.0003255823314355784, 
     -0.0003203515021501557, -0.0003152592396405797, -0.0003103004593234496, 
     -0.00030547031398452237, -0.00030076418037518665, 
     -0.0002961776466942292, -0.0002917065008881097, -0.00028734671970861314, 
     -0.0002830944584718711};
 
  TVIL_REAL GyxxxytableALy[] = 
     {0, -0.2539652145085471, 0.03676256142746911, 0.0033765673029769283, 
     0.0022612077918431877, 0.0016581065636140444, 0.0012600838289868643, 
     0.0009929307549636185, 0.0008063767002409031, 0.0006708981476066283, 
     0.0005691504595121621, 0.0004905646130460481, 0.0004284321488779649, 
     0.0003783317911214316, 0.0003372515367437821, 0.0003030794160289844, 
     0.00027429687672057704, 0.00024978778429259697, 0.00022871576199135055, 
     0.0002104432478054098, 0.00019447676780643414, 0.00018042912148379033, 
     0.00016799273711781966, 0.00015692056352611323, 0.00014701214564111182, 
     0.00013810332886955446, 0.00013005854467998678, 0.00012276495939891806, 
     0.00011612798617358814, 0.00011006780672313353, 0.0001045166497451442, 
     0.00009941664236658638, 0.00009471809989791241, 0.00009037815393553074, 
     0.0000863596439105673, 0.00008263021542275637, 0.000079161582116007, 
     0.00007592891781716089, 0.00007291035312718647, 0.00007008655629805191, 
     0.00006744038252844903, 0.00006495657911234208, 0.00006262153642633591, 
     0.00006042307672837567, 0.000058350274296591, 0.00005639330166382455, 
     0.000054543297675966636, 0.000052792253877587266, 
     0.00005113291634977341, 0.0000495587006256268, 0.00004806361771401131, 
     0.0000466422095915596, 0.000045289492791989736, 0.000044000908942440796, 
     0.00004277228127824812, 0.00004159977631780093, 0.000040479870003779545, 
     0.00003940931772088066, 0.000038385127686891014, 
     0.000037404537286708224, 0.00003646499198009167, 0.00003556412646555106, 
     0.000034699747826469614, 0.000033869820422639015, 
     0.00003307245232194185, 0.00003230588309384901, 0.00003156847280944267, 
     0.000030858692112440765, 0.000030175113242694845, 
     0.000029516401908281476, 0.00002888130991496179, 0.00002826866847273993, 
     0.000027677382108757226, 0.000027106423124024165, 
     0.000026554826538693533, 0.000026021685476864114, 
     0.000025506146947402654, 0.000025007407982089623, 
     0.00002452471209662365, 0.00002405734604373885, 0.000023604636830965667, 
     0.000023165948978456807, 0.00002274068199485518, 
     0.000022328268051442435, 0.000021928169836812204, 
     0.000021539878576092793, 0.00002116291220032734, 
     0.000020796813653029635, 0.000020441149322191083, 
     0.000020095507587137215, 0.000019759497470636054, 
     0.00001943274738755965, 0.00001911490398220583, 0.00001880563104711064, 
     0.000018504608516831872, 0.00001821153153076901, 0.00001792610955961172, 
     0.000017648065590484122, 0.00001737713536628102, 0.00001711306667507997, 
     0.000016855618685863744};
 
  TVIL_REAL GyxxxytableALx2[] = 
     {0, -0.125, 0.07291666666666667, 0.054947916666666666, 
     0.039787946428571426, 0.03008083767361111, 0.0236544346224522, 
     0.019191105355961312, 0.01595800130689352, 0.0135332304143962, 
     0.011662008927363658, 0.010183373328453824, 0.00899152980290599, 
     0.008014532058025155, 0.007201992173546177, 0.006517710533172898, 
     0.0059350968592943336, 0.0054342349944442115, 0.004999948535323923, 
     0.0046204942864950605, 0.004286660163846228, 0.003991129950391058, 
     0.003728027949036344, 0.0034925872953741294, 0.0032809047891676573, 
     0.003089757241674978, 0.0029164622109322676, 0.002758771202431301, 
     0.002614786912874306, 0.002482898485923615, 0.0023617304065282913, 
     0.0022501018252288566, 0.0021469939327202364, 0.0020515236017416808, 
     0.0019629219477817037, 0.0018805167795715638, 0.0018037181475707394, 
     0.001732006376398656, 0.001664922101488914, 0.0016020579325634191, 
     0.0015430514450605697, 0.0014875792613661101, 0.0014353520309514907, 
     0.0013861101555433981, 0.0013396201346252646, 0.001295671429702323, 
     0.0012540737642010463, 0.0012146547906509858, 0.0011772580686992989, 
     0.0011417413071412238, 0.0011079748309821232, 0.0010758402409431881, 
     0.0010452292380688536, 0.0010160425904138463, 0.0009881892223589195, 
     0.0009615854100675694, 0.0009361540690636979, 0.0009118241219723055, 
     0.0008885299361942425, 0.0008662108227403336, 0.0008448105886772233, 
     0.0008242771366756838, 0.0008045621060334288, 0.0007856205502945186, 
     0.0007674106472275146, 0.0007498934374721773, 0.000733032588634244, 
     0.0007167941820117236, 0.0007011465194842643, 0.0006860599483978773, 
     0.000671506702537656, 0.000657460757507036, 0.0006438976990285524, 
     0.0006307946028521711, 0.000618129925106651, 0.0006058834020600466, 
     0.0005940359583699429, 0.0005825696230045138, 0.0005714674521038739, 
     0.0005607134581290459, 0.0005502925447145627, 0.0005401904467014347, 
     0.0005303936748809607, 0.0005208894650275087, 0.0005116657308407034, 
     0.0005027110204550774, 0.0004940144762087494, 0.00048556579739256596, 
     0.00047735520572782345, 0.00046937341334454157, 0.00046161159305361805, 
     0.00045406135072533936, 0.0004467146996039098, 0.0004395640364031046, 
     0.0004326021190420477, 0.00042582204589263433, 0.0004192172364214044, 
     0.0004127814131188648, 0.00040650858461846917, 0.0004003930299157986, 
     0.000394429283606031};
 
  TVIL_REAL GyxxxytableALy2[] = 
     {0, 0., 0., 0.0026041666666666665, 0.0013671875, 
     0.0008486793154761905, 0.0005912659660218254, 0.00044226708350243504, 
     0.00034691582695733084, 0.00028154734356287703, 0.0002344278061978291, 
     0.00019913761994401016, 0.00017189692349432493, 0.0001503493869287317, 
     0.0001329573344204891, 0.00011867893579008056, 0.00010678580604364093, 
     0.00009675494760690729, 0.00008820212881518768, 0.0000808393830441109, 
     0.00007444708214374833, 0.0000688551057629502, 0.00006392985092659494, 
     0.00005956508685275768, 0.00005567539877854717, 0.00005219141031533409, 
     0.0000490562499004661, 0.00004622290191823306, 0.00004365219639086873, 
     0.00004131126595815756, 0.00003917234913682565, 0.00003721185318176464, 
     0.00003540961366739961, 0.000033748304630399874, 
     0.000032212965017893634, 0.00003079061575867617, 
     0.000029469948018632145, 0.000028241067795938205, 
     0.00002709528542513525, 0.000026024941118470623, 0.00002502325960821421, 
     0.000024084228428904656, 0.000023202495511607927, 
     0.000022373282638876863, 0.000021592311991878675, 
     0.000020855743556400505, 0.000020160121576602894, 
     0.000019502328580300288, 0.00001887954576671324, 0.00001828921876188816, 
     0.000017729027919664786, 0.000017196862485923446, 
     0.00001669079805762835, 0.00001620907686116636, 0.00001575009045078677, 
     0.00001531236449082127, 0.000014894545337370324, 0.00001449538817832174, 
     0.000014113746526545691, 0.000013748562891192973, 
     0.000013398860477259097, 0.000013063735784814968, 
     0.000012742351997233642, 0.00001243393306292292, 
     0.000012137758387963483, 0.000011853158068027974, 
     0.000011579508597327186, 0.000011316229000350793, 
     0.000011062777339053522, 0.000010818647554058922, 
     0.000010583366603558627, 0.00001035649186799747, 
     0.000010137608792456586, 9.926328741964026e-6, 9.7222870478478e-6, 
     9.525141225761116e-6, 9.33456934820582e-6, 9.150268556301484e-6, 
     8.971953697232089e-6, 8.799356075281273e-6, 8.632222305668423e-6, 
     8.470313261544451e-6, 8.313403105518227e-6, 8.161278397979434e-6, 
     8.013737275275934e-6, 7.870588691506478e-6, 7.731651718313694e-6, 
     7.596754897617469e-6, 7.465735642723363e-6, 7.338439683681815e-6, 
     7.2147205531679286e-6, 7.0944391095040165e-6, 6.9774630937627154e-6, 
     6.863666718171494e-6, 6.752930283293443e-6, 6.6451398216876735e-6, 
     6.540186765958193e-6, 6.437967639285317e-6, 6.338383766700783e-6, 
     6.241341005518549e-6, 6.146749493469676e-6};
 
  TVIL_REAL GyxxxytableALxLy[] = 
     {0, -0.75, -0.07291666666666667, -0.05755208333333333, 
     -0.04115513392857143, -0.030929516989087302, -0.024245700588474025, 
     -0.01963337243946375, -0.01630491713385085, -0.013814777757959076, 
     -0.011896436733561487, -0.010382510948397834, -0.009163426726400315, 
     -0.008164881444953887, -0.0073349495079666665, -0.006636389468962978, 
     -0.006041882665337975, -0.0055309899420511194, -0.0050881506641391105, 
     -0.004701333669539172, -0.004361107245989976, -0.004059985056154008, 
     -0.003791957799962939, -0.003552152382226887, -0.0033365801879462046, 
     -0.003141948651990312, -0.0029655184608327334, -0.002804994104349534, 
     -0.002658439109265175, -0.0025242097518817725, -0.0024009027556651167, 
     -0.0022873136784106215, -0.002182403546387636, -0.0020852719063720803, 
     -0.0019951349127995976, -0.0019113073953302398, -0.0018331880955893716, 
     -0.0017602474441945942, -0.0016920173869140493, -0.0016280828736818897, 
     -0.0015680747046687839, -0.0015116634897950148, -0.0014585545264630985, 
     -0.001408483438182275, -0.0013612124466171433, -0.0013165271732587234, 
     -0.001274233885777649, -0.0012341571192312861, -0.0011961376144660123, 
     -0.001160030525903112, -0.001125703858901788, -0.0010930371034291117, 
     -0.001061920036126482, -0.0010322516672750127, -0.0010039393128097062, 
     -0.0009768977745583907, -0.0009510486144010682, -0.0009263195101506272, 
     -0.0009026436827207882, -0.0008799593856315266, -0.0008582094491544825, 
     -0.0008373408724604987, -0.0008173044580306624, -0.0007980544833574415, 
     -0.000779548405615478, -0.0007617465955402053, -0.0007446120972315712, 
     -0.0007281104110120744, -0.0007122092968233179, -0.0006968785959519363, 
     -0.0006820900691412146, -0.0006678172493750333, -0.000654035307821009, 
     -0.0006407209315941352, -0.0006278522121544988, -0.0006154085432858076, 
     -0.0006033705277181487, -0.0005917198915608153, -0.0005804394058011059, 
     -0.0005695128142043271, -0.0005589247670202311, -0.0005486607599629792, 
     -0.000538707077986479, -0.0005290507434254881, -0.0005196794681159792, 
     -0.0005105816091465838, -0.0005017461279270631, -0.0004931625522901834, 
     -0.0004848209413705468, -0.0004767118530282234, -0.000468826313606786, 
     -0.00046115578983484335, -0.0004536921626976725, 
     -0.00044642770312127605, -0.0004393550493253411, -0.000432467185714322, 
     -0.0004257574231873626, -0.0004192193807581501, -0.00041284696838517, 
     -0.0004066343709213171, -0.00040057603309950066};
 
  TVIL_REAL GyxxxytableALx3[] = 
     {0, -0.25, -0.0625, -0.03125, -0.01953125, -0.013671875, 
     -0.01025390625, -0.008056640625, -0.0065460205078125, 
     -0.00545501708984375, -0.0046367645263671875, -0.004004478454589844, 
     -0.0035039186477661133, -0.0030996203422546387, -0.002767518162727356, 
     -0.0024907663464546204, -0.0022572570014744997, -0.002058087266050279, 
     -0.0018865799938794225, -0.0017376394680468366, -0.0016073165079433238, 
     -0.0014925081859473721, -0.001390746264178233, -0.0013000454208622614, 
     -0.00121879258205837, -0.0011456650271348678, -0.001079568967877087, 
     -0.0010195929141061377, -0.0009649718651361661, -0.0009150595272842954, 
     -0.0008693065509200806, -0.0008272433307142703, -0.0007884662995870388, 
     -0.0007526269223330826, -0.000719422793406623, -0.0006885903879749107, 
     -0.0006598991218092894, -0.0006331464547089128, -0.0006081538314967189, 
     -0.0005847632995160758, -0.000562834675784223, -0.0005422431632555319, 
     -0.0005228773359964058, -0.0005046374289267636, -0.00048743388021335127, 
     -0.00047118608420623954, -0.0004558213205908187, 
     -0.00044127383163579257, -0.00042748402439717406, 
     -0.0004143977787523626, -0.0004019658453897917, -0.0003901433205253861, 
     -0.0003788891862794615, -0.0003681659074224956, -0.0003579390766607596, 
     -0.0003481771018427389, -0.00033885092947195125, 
     -0.00032993379974900517, -0.0003214010290658412, -0.0003132298164624724, 
     -0.0003053990710509106, -0.0002978892578283472, -0.00029068225965508075, 
     -0.0002837612534728169, -0.00027711059909454774, -0.0002707157391154428, 
     -0.00026456310868100093, -0.0002586400540090382, -0.0002529347587000153, 
     -0.0002474361769891454, -0.00024213397319652088, 
     -0.00023701846672053806, -0.0002320805819971935, -0.0002273118029150594, 
     -0.00022270413123434872, -0.00021825004860966175, 
     -0.00021394248186078685, -0.0002097747711751871, 
     -0.00020574064096027966, -0.00020183417309394523, 
     -0.00019804978234843376, -0.00019438219378642573, 
     -0.00019082642194886916, -0.00018737775167268478, 
     -0.00018403172039281542, -0.00018078410179764808, 
     -0.00017763089071978213, -0.00017456828915564794, 
     -0.0001715926933177676, -0.00016870068163263668, 
     -0.00016588900360542605, -0.0001631545694800619, -0.0001604944406298435, 
     -0.00015790582061968474, -0.00015538604688639188, 
     -0.00015293258298818569, -0.0001505430113789953, 
     -0.00014821502666694897, -0.00014594642932000588, 
     -0.00014373511978485427, -0.00014157909298808148};

  TVIL_REAL GyxxxytableALx2Ly[] = 
    {0, 0.375, 0.125, 0.0625, 0.0390625, 0.02734375, 0.0205078125, 
     0.01611328125, 0.013092041015625, 0.0109100341796875, 
     0.009273529052734375, 0.008008956909179688, 0.0070078372955322266, 
     0.006199240684509277, 0.005535036325454712, 0.004981532692909241, 
     0.004514514002948999, 0.004116174532100558, 0.003773159987758845, 
     0.003475278936093673, 0.0032146330158866476, 0.0029850163718947442, 
     0.002781492528356466, 0.0026000908417245228, 0.00243758516411674, 
     0.0022913300542697357, 0.002159137935754174, 0.0020391858282122755, 
     0.0019299437302723321, 0.0018301190545685908, 0.0017386131018401613, 
     0.0016544866614285406, 0.0015769325991740776, 0.0015052538446661652, 
     0.001438845586813246, 0.0013771807759498213, 0.0013197982436185787, 
     0.0012662929094178256, 0.0012163076629934377, 0.0011695265990321515, 
     0.001125669351568446, 0.0010844863265110638, 0.0010457546719928115, 
     0.0010092748578535273, 0.0009748677604267025, 0.0009423721684124791, 
     0.0009116426411816373, 0.0008825476632715851, 0.0008549680487943481, 
     0.0008287955575047252, 0.0008039316907795834, 0.0007802866410507722, 
     0.000757778372558923, 0.0007363318148449912, 0.0007158781533215192, 
     0.0006963542036854778, 0.0006777018589439025, 0.0006598675994980103, 
     0.0006428020581316825, 0.0006264596329249448, 0.0006107981421018212, 
     0.0005957785156566944, 0.0005813645193101615, 0.0005675225069456338, 
     0.0005542211981890955, 0.0005414314782308857, 0.0005291262173620019, 
     0.0005172801080180764, 0.0005058695174000306, 0.0004948723539782908, 
     0.00048426794639304176, 0.0004740369334410761, 0.000464161163994387, 
     0.0004546236058301188, 0.00044540826246869744, 0.0004365000972193235, 
     0.0004278849637215737, 0.0004195495423503742, 0.0004114812819205593, 
     0.00040366834618789046, 0.0003960995646968675, 0.00038876438757285146, 
     0.0003816528438977383, 0.00037475550334536956, 0.00036806344078563083, 
     0.00036156820359529616, 0.00035526178143956426, 0.0003491365783112959, 
     0.0003431853866355352, 0.00033740136326527336, 0.0003317780072108521, 
     0.0003263091389601238, 0.000320988881259687, 0.0003158116412393695, 
     0.00031077209377278377, 0.00030586516597637137, 0.0003010860227579906, 
     0.00029643005333389793, 0.00029189285864001177, 0.00028747023956970854, 
     0.00028315818597616295};
 
  TVIL_REAL GyxxxytableALxLy2[] = 
     {0, 0., -0.0625, -0.03125, -0.01953125, -0.013671875, 
     -0.01025390625, -0.008056640625, -0.0065460205078125, 
     -0.00545501708984375, -0.0046367645263671875, -0.004004478454589844, 
     -0.0035039186477661133, -0.0030996203422546387, -0.002767518162727356, 
     -0.0024907663464546204, -0.0022572570014744997, -0.002058087266050279, 
     -0.0018865799938794225, -0.0017376394680468366, -0.0016073165079433238, 
     -0.0014925081859473721, -0.001390746264178233, -0.0013000454208622614, 
     -0.00121879258205837, -0.0011456650271348678, -0.001079568967877087, 
     -0.0010195929141061377, -0.0009649718651361661, -0.0009150595272842954, 
     -0.0008693065509200806, -0.0008272433307142703, -0.0007884662995870388, 
     -0.0007526269223330826, -0.000719422793406623, -0.0006885903879749107, 
     -0.0006598991218092894, -0.0006331464547089128, -0.0006081538314967189, 
     -0.0005847632995160758, -0.000562834675784223, -0.0005422431632555319, 
     -0.0005228773359964058, -0.0005046374289267636, -0.00048743388021335127, 
     -0.00047118608420623954, -0.0004558213205908187, 
     -0.00044127383163579257, -0.00042748402439717406, 
     -0.0004143977787523626, -0.0004019658453897917, -0.0003901433205253861, 
     -0.0003788891862794615, -0.0003681659074224956, -0.0003579390766607596, 
     -0.0003481771018427389, -0.00033885092947195125, 
     -0.00032993379974900517, -0.0003214010290658412, -0.0003132298164624724, 
     -0.0003053990710509106, -0.0002978892578283472, -0.00029068225965508075, 
     -0.0002837612534728169, -0.00027711059909454774, -0.0002707157391154428, 
     -0.00026456310868100093, -0.0002586400540090382, -0.0002529347587000153, 
     -0.0002474361769891454, -0.00024213397319652088, 
     -0.00023701846672053806, -0.0002320805819971935, -0.0002273118029150594, 
     -0.00022270413123434872, -0.00021825004860966175, 
     -0.00021394248186078685, -0.0002097747711751871, 
     -0.00020574064096027966, -0.00020183417309394523, 
     -0.00019804978234843376, -0.00019438219378642573, 
     -0.00019082642194886916, -0.00018737775167268478, 
     -0.00018403172039281542, -0.00018078410179764808, 
     -0.00017763089071978213, -0.00017456828915564794, 
     -0.0001715926933177676, -0.00016870068163263668, 
     -0.00016588900360542605, -0.0001631545694800619, -0.0001604944406298435, 
     -0.00015790582061968474, -0.00015538604688639188, 
     -0.00015293258298818569, -0.0001505430113789953, 
     -0.00014821502666694897, -0.00014594642932000588, 
     -0.00014373511978485427, -0.00014157909298808148};
 
  TVIL_REAL GyxxxytableC[] = 
     {0, -0.15146009958841405, 0.07718162462305643, 
     0.00781647646286505, 0.00360761124473395, 0.0019712092251663493, 
     0.0011715224666601451, 0.0007462962859362722, 0.0005034908514949728, 
     0.00035586013461273415, 0.00026111920474832293, 0.00019749541730905545, 
     0.00015312284294576178, 0.00012118859814294982, 0.00009759384010687403, 
     0.00007976903241994335, 0.00006604472776742076, 0.000055302240345861, 
     0.0000467716525805733, 0.000039910642927715626, 0.00003432937242692297, 
     0.00002974254836585185, 0.00002593803458975786, 0.000022755822885477892, 
     0.000020073656774226224, 0.000017797023177427136, 
     0.00001585207003567495, 0.000014180519661826235, 
     0.000012735965766881612, 0.000011481144183231842, 
     0.00001038589817725029, 9.425645495162181e-6, 8.580212054023439e-6, 
     7.832936455004308e-6, 7.169976550551033e-6, 6.579768174000132e-6, 
     6.052599466570614e-6, 5.580273747779759e-6, 5.155840733220199e-6, 
     4.773380896108995e-6, 4.4278314364424895e-6, 4.114845038676251e-6, 
     3.8306746281167824e-6, 3.572078863364582e-6, 3.3362442597576676e-6, 
     3.12072072229239e-6, 2.923367945250254e-6, 2.7423106604456915e-6, 
     2.5759011240101183e-6, 2.422687550691054e-6, 2.2813874555101635e-6, 
     2.1508650608901964e-6, 2.0301120848339967e-6, 1.9182313514069913e-6, 
     1.8144227655191423e-6, 1.7179712751201321e-6, 1.6282365095111722e-6, 
     1.5446438357255096e-6, 1.4666766183278983e-6, 1.3938695034859836e-6, 
     1.3258025773152373e-6, 1.2620962725144363e-6, 1.202406917161373e-6, 
     1.146422836003379e-6, 1.0938609282753956e-6, 1.0444636575092397e-6, 
     9.979963983647227e-7, 9.542450935430511e-7, 9.13014180601082e-7, 
     8.741247541880469e-7, 8.374129340515163e-7, 8.027284132519984e-7, 
     7.699331645053475e-7, 7.389002855378344e-7, 7.0951296687209e-7, 
     6.816635676309979e-7, 6.552527868074682e-7, 6.301889190479764e-7, 
     6.063871853762003e-7, 5.837691304730688e-7, 5.622620791588236e-7, 
     5.417986456146577e-7, 5.223162896558987e-7, 5.037569150422323e-7, 
     4.860665053973006e-7, 4.691947938221678e-7, 4.5309496273489483e-7, 
     4.3772337086052605e-7, 4.230393046396363e-7, 4.0900475162562505e-7, 
     3.95584193706643e-7, 3.8274441822213056e-7, 3.704543452504785e-7, 
     3.5868486952680495e-7, 3.474087156112926e-7, 3.366003050715698e-7, 
     3.2623563456950735e-7, 3.162921638555215e-7, 3.067487127737157e-7, 
     2.975853664704653e-7, 2.887833880786372e-7};
 
  TVIL_REAL GyxxxytableCLx[] = 
     {0, 0.42834065923908593, -0.01699751275271869, 
     0.012972146443083723, 0.006658667913062278, 0.0035398506220008317, 
     0.0020382363791226544, 0.0012615060553888753, 0.0008299938468785272, 
     0.000574304401763735, 0.0004140143739463722, 0.00030857228042819977, 
     0.00023633854630412742, 0.00018514368895407334, 0.00014781006160355923, 
     0.00011992047463151617, 0.00009865298239523221, 0.00008214497203810123, 
     0.00006913162640076794, 0.00005873254708404535, 0.00005032149581898606, 
     0.00004344443545632944, 0.000037766552439374496, 0.00003303718081623342, 
     0.000029066076069509953, 0.000025707055458345686, 
     0.000022846521307048637, 0.000020395283042595452, 
     0.000018282646397355152, 0.000016452085349341138, 
     0.000014858034899868505, 0.000013463488075789502, 
     0.000012238177009138182, 0.000011157182992617961, 
     0.000010199864896600812, 9.349026162423646e-6, 8.590262213232392e-6, 
     7.91144546788111e-6, 7.302316146583161e-6, 6.754155026196351e-6, 
     6.259520129024805e-6, 5.812033625888675e-6, 5.406208429744997e-6, 
     5.0373063513744494e-6, 4.701221497424418e-6, 4.394383966688986e-6, 
     4.113679953698992e-6, 3.8563851802152625e-6, 3.620109204336657e-6, 
     3.4027486474869453e-6, 3.202447764176056e-6, 3.017565082614103e-6, 
     2.8466450844528234e-6, 2.688394083150511e-6, 2.5416596133993926e-6, 
     2.40541276692911e-6, 2.2787330091424884e-6, 2.1607950913644586e-6, 
     2.050857738822479e-6, 1.9482538478269134e-6, 1.852381969342538e-6, 
     1.7626988921024851e-6, 1.678713168093088e-6, 1.5999794478111893e-6, 
     1.526093513107419e-6, 1.4566879124368017e-6, 1.3914281175519251e-6, 
     1.3300091325871e-6, 1.2721524964948808e-6, 1.2176036282348996e-6, 
     1.1661294712454625e-6, 1.1175163997688884e-6, 1.0715683547314166e-6, 
     1.0281051812454098e-6, 9.869611435276996e-7, 9.479835962144489e-7, 
     9.110317937840137e-7, 8.759758221450463e-7, 8.426956384660688e-7, 
     8.110802070639929e-7, 7.810267206737408e-7, 7.524398977238615e-7, 
     7.252313473730496e-7, 6.993189950444449e-7, 6.746265620494343e-7, 
     6.510830936381255e-7, 6.286225304648313e-7, 6.071833190266329e-7, 
     5.867080571323815e-7, 5.671431708977426e-7, 5.484386201471277e-7, 
     5.305476294425306e-7, 5.134264422583181e-7, 4.970340960850537e-7, 
     4.813322164788798e-7, 4.662848282796686e-7, 4.5185818240439465e-7, 
     4.380205967848438e-7, 4.247423101633591e-7, 4.119953475889994e-7, 
     3.9975339657114055e-7};
 
  TVIL_REAL GyxxxytableCLy[] = 
     {0, 0.3727851036835304, 0.012733022761953153, 
     -0.01539671989324927, -0.007477976828349401, -0.0038267821271441896, 
     -0.0021418078361227864, -0.0012997851727833583, -0.0008444139925320118, 
     -0.0005798225814640444, -0.00041615387558516194, -0.0003094110408686262, 
     -0.0002366704960136438, -0.0001852761394994296, -0.00014786328778920336, 
     -0.00011994199804781315, -0.00009866173422573754, 
     -0.00008214854827419971, -0.00006913309421464022, 
     -0.00005873315192852507, -0.00005032174595792687, 
     -0.00004344453924322258, -0.00003776659563146755, 
     -0.00003303719884054253, -0.000029066083610190693, 
     -0.000025707058620447255, -0.000022846522635909405, 
     -0.00002039528360216567, -0.000018282646633425308, 
     -0.000016452085449107667, -0.00001485803494210006, 
     -0.00001346348809369364, -0.000012238177016739581, 
     -0.000011157182995849585, -0.000010199864897976441, 
     -9.349026163009925e-6, -8.590262213482544e-6, -7.911445467987958e-6, 
     -7.302316146628847e-6, -6.754155026215904e-6, -6.259520129033181e-6, 
     -5.812033625892266e-6, -5.4062084297465376e-6, -5.037306351375112e-6, 
     -4.701221497424702e-6, -4.394383966689109e-6, -4.113679953699045e-6, 
     -3.856385180215285e-6, -3.6201092043366666e-6, 
     -3.4027486474869495e-6, -3.202447764176058e-6, -3.017565082614104e-6, 
     -2.8466450844528234e-6, -2.6883940831505116e-6, 
     -2.5416596133993926e-6, -2.40541276692911e-6, -2.2787330091424884e-6, 
     -2.1607950913644586e-6, -2.050857738822479e-6, 
     -1.9482538478269134e-6, -1.852381969342538e-6, 
     -1.7626988921024851e-6, -1.678713168093088e-6, 
     -1.5999794478111893e-6, -1.526093513107419e-6, 
     -1.4566879124368017e-6, -1.3914281175519251e-6, -1.3300091325871e-6, 
     -1.2721524964948808e-6, -1.2176036282348996e-6, 
     -1.1661294712454625e-6, -1.1175163997688884e-6, 
     -1.0715683547314166e-6, -1.0281051812454098e-6, 
     -9.869611435276996e-7, -9.479835962144489e-7, -9.110317937840137e-7, 
     -8.759758221450463e-7, -8.426956384660688e-7, -8.110802070639929e-7, 
     -7.810267206737408e-7, -7.524398977238615e-7, -7.252313473730496e-7, 
     -6.993189950444449e-7, -6.746265620494343e-7, -6.510830936381255e-7, 
     -6.286225304648313e-7, -6.071833190266329e-7, -5.867080571323815e-7, 
     -5.671431708977426e-7, -5.484386201471277e-7, -5.305476294425306e-7, 
     -5.134264422583181e-7, -4.970340960850537e-7, -4.813322164788798e-7, 
     -4.662848282796686e-7, -4.5185818240439465e-7, -4.380205967848438e-7, 
     -4.247423101633591e-7, -4.119953475889994e-7, -3.9975339657114055e-7};
 
  TVIL_REAL GyxxxytableCLx2[] = 
     {0, 0., 0.037037037037037035, 0.009144947416552356, 
     0.00411014581110603, 0.00211624082985156, 0.001187076479065618, 
     0.0007162126435636258, 0.0004600998230931159, 0.0003116331494238993, 
     0.0002205441929178973, 0.00016181962823076535, 0.00012231458941818588, 
     0.00009476019100114984, 0.00007494349589294059, 0.00006031628873723471, 
     0.000049277228077833884, 0.00004078535523870019, 0.00003414352720773572, 
     0.000028872483008942705, 0.000024635081393681238, 
     0.000021189292915204058, 0.000018358209717966798, 
     0.000016010427751126455, 0.000014046922674287945, 
     0.000012392091054325124, 0.000010987522663719786, 9.787599473370371e-6, 
     8.75633866891131e-6, 7.865096902533927e-6, 7.09087978782376e-6, 
     6.415082628715496e-6, 5.822542319525496e-6, 5.300816425999153e-6, 
     4.839629939503638e-6, 4.430447041698089e-6, 4.066136955907934e-6, 
     3.74071123929721e-6, 3.4491157720294117e-6, 3.187064951504757e-6, 
     2.9509086926940086e-6, 2.737525106073061e-6, 2.544233405784069e-6, 
     2.3687228555362615e-6, 2.2089945037017825e-6, 2.0633131742932643e-6, 
     1.9301677262020692e-6, 1.808238012159653e-6, 1.6963672927523915e-6, 
     1.593539112600803e-6, 1.498857842668568e-6, 1.411532247415344e-6, 
     1.3308615577896505e-6, 1.2562236281671176e-6, 1.1870648328256207e-6, 
     1.122891419660629e-6, 1.0632620888508539e-6, 1.0077816046152154e-6, 
     9.560952810236807e-7, 9.078842095729324e-7, 8.628611181188525e-7, 
     8.207667687221029e-7, 7.813668167632893e-7, 7.44449065918785e-7, 
     7.098210637349439e-7, 6.773079909799719e-7, 6.467508049970697e-7, 
     6.180046031781566e-7, 5.909371776259035e-7, 5.654277362365964e-7, 
     5.413657689509841e-7, 5.186500408939253e-7, 4.971876966459118e-7, 
     4.76893462034167e-7, 4.5768893165883753e-7, 4.3950193193120505e-7, 
     4.2226595073764807e-7, 4.0591962599006906e-7, 3.9040628630971054e-7, 
     3.756735379409812e-7, 3.616728927254665e-7, 3.4835943260081046e-7, 
     3.356915066390381e-7, 3.2363045711631055e-7, 3.121403715213578e-7, 
     3.011878577716479e-7, 2.907418402221414e-7, 2.8077337432755977e-7, 
     2.7125547806085256e-7, 2.6216297840258403e-7, 2.534723714022168e-7, 
     2.4516169447612967e-7, 2.3721040975157775e-7, 2.2959929739318312e-7, 
     2.2231035796109566e-7, 2.153267229495476e-7, 2.0863257274275498e-7, 
     2.0221306130339439e-7, 1.9605424697841309e-7, 1.9014302886877512e-7, 
     1.8446708826481732e-7};
 
  TVIL_REAL GyxxxytableCLy2[] = 
     {0, 0.05555555555555555, 0.051440329218107, 
     0.013740283493369913, 0.005609263976890863, 0.002623171178523513, 
     0.0013648323142697871, 0.0007804365526577399, 0.0004838667459677548, 
     0.0003205997614270155, 0.00022398079407346945, 0.00016315409304141614, 
     0.00012283850376405156, 0.00009496781658054271, 0.00007502644369229911, 
     0.000060349660295248424, 0.00004929073705389104, 0.00004079085360231031, 
     0.000034145776006583515, 0.000028873406760100425, 
     0.000024635462336657305, 0.00002118945056925783, 
     0.000018358275174303173, 0.00001601045500816676, 
     0.000014046934055281411, 0.000012392095818226327, 
     0.00001098752466240184, 9.787600313699642e-6, 8.75633902292033e-6, 
     7.865097051943772e-6, 7.090879850990873e-6, 6.415082655464139e-6, 
     5.822542330869539e-6, 5.300816430816963e-6, 4.839629941552493e-6, 
     4.4304470425704955e-6, 4.066136956279849e-6, 3.740711239455939e-6, 
     3.4491157720972277e-6, 3.1870649515337603e-6, 2.9509086927064244e-6, 
     2.7375251060783813e-6, 2.5442334057863503e-6, 2.3687228555372407e-6, 
     2.208994503702203e-6, 2.063313174293445e-6, 1.930167726202147e-6, 
     1.8082380121596866e-6, 1.696367292752406e-6, 1.5935391126008092e-6, 
     1.4988578426685709e-6, 1.411532247415345e-6, 1.330861557789651e-6, 
     1.2562236281671178e-6, 1.1870648328256207e-6, 1.122891419660629e-6, 
     1.0632620888508539e-6, 1.0077816046152154e-6, 9.560952810236807e-7, 
     9.078842095729324e-7, 8.628611181188525e-7, 8.207667687221029e-7, 
     7.813668167632893e-7, 7.44449065918785e-7, 7.098210637349439e-7, 
     6.773079909799719e-7, 6.467508049970697e-7, 6.180046031781566e-7, 
     5.909371776259035e-7, 5.654277362365964e-7, 5.413657689509841e-7, 
     5.186500408939253e-7, 4.971876966459118e-7, 4.76893462034167e-7, 
     4.5768893165883753e-7, 4.3950193193120505e-7, 4.2226595073764807e-7, 
     4.0591962599006906e-7, 3.9040628630971054e-7, 3.756735379409812e-7, 
     3.616728927254665e-7, 3.4835943260081046e-7, 3.356915066390381e-7, 
     3.2363045711631055e-7, 3.121403715213578e-7, 3.011878577716479e-7, 
     2.907418402221414e-7, 2.8077337432755977e-7, 2.7125547806085256e-7, 
     2.6216297840258403e-7, 2.534723714022168e-7, 2.4516169447612967e-7, 
     2.3721040975157775e-7, 2.2959929739318312e-7, 2.2231035796109566e-7, 
     2.153267229495476e-7, 2.0863257274275498e-7, 2.0221306130339439e-7, 
     1.9605424697841309e-7, 1.9014302886877512e-7, 1.8446708826481732e-7};
 
  TVIL_REAL GyxxxytableCLxLy[] = 
     {0, -0.5555555555555556, -0.08847736625514403, 
     -0.02288523090992227, -0.009719409787996893, -0.004739412008375073, 
     -0.002551908793335405, -0.0014966491962213658, -0.0009439665690608707, 
     -0.0006322329108509148, -0.00044452498699136674, 
     -0.00032497372127218146, -0.00024515309318223744, 
     -0.00018972800758169255, -0.0001499699395852397, 
     -0.00012066594903248313, -0.00009856796513172493, 
     -0.0000815762088410105, -0.00006828930321431924, 
     -0.00005774588976904313, -0.000049270543730338546, 
     -0.00004237874348446189, -0.00003671648489226997, 
     -0.00003202088275929321, -0.000028093856729569354, 
     -0.00002478418687255145, -0.000021975047326121624, 
     -0.000019575199787070014, -0.000017512677691831642, 
     -0.0000157301939544777, -0.000014181759638814632, 
     -0.000012830165284179636, -0.000011645084650395036, 
     -0.000010601632856816116, -9.679259881056131e-6, 
     -8.860894084268584e-6, -8.132273912187783e-6, -7.481422478753149e-6, 
     -6.898231544126639e-6, -6.374129903038517e-6, -5.901817385400433e-6, 
     -5.475050212151442e-6, -5.088466811570419e-6, -4.737445711073502e-6, 
     -4.417989007403986e-6, -4.12662634858671e-6, -3.860335452404216e-6, 
     -3.6164760243193398e-6, -3.3927345855047975e-6, 
     -3.1870782252016125e-6, -2.9977156853371387e-6, 
     -2.823064494830689e-6, -2.6617231155793015e-6, 
     -2.5124472563342356e-6, -2.3741296656512415e-6, 
     -2.245782839321258e-6, -2.1265241777017077e-6, 
     -2.0155632092304307e-6, -1.9121905620473614e-6, 
     -1.8157684191458647e-6, -1.725722236237705e-6, 
     -1.6415335374442058e-6, -1.5627336335265786e-6, -1.48889813183757e-6, 
     -1.4196421274698879e-6, -1.3546159819599439e-6, 
     -1.2935016099941395e-6, -1.2360092063563131e-6, 
     -1.181874355251807e-6, -1.1308554724731927e-6, 
     -1.0827315379019683e-6, -1.0373000817878505e-6, 
     -9.943753932918236e-7, -9.53786924068334e-7, -9.153778633176751e-7, 
     -8.790038638624101e-7, -8.445319014752961e-7, -8.118392519801381e-7, 
     -7.808125726194211e-7, -7.513470758819624e-7, -7.23345785450933e-7, 
     -6.967188652016209e-7, -6.713830132780762e-7, -6.472609142326211e-7, 
     -6.242807430427156e-7, -6.023757155432958e-7, -5.814836804442828e-7, 
     -5.615467486551195e-7, -5.425109561217051e-7, -5.243259568051681e-7, 
     -5.069447428044336e-7, -4.903233889522593e-7, -4.744208195031555e-7, 
     -4.5919859478636624e-7, -4.446207159221913e-7, -4.306534458990952e-7, 
     -4.1726514548550996e-7, -4.0442612260678877e-7, 
     -3.9210849395682617e-7, -3.8028605773755025e-7, 
     -3.6893417652963463e-7};
 
  TVIL_REAL GyxxxytableCLx3[] = 
     {0, 0., 0., 0.0013717421124828531, 0.0007620789513793629, 
     0.00040644210740232686, 0.0002276828472022294, 0.00013548070246744229, 
     0.00008544204795529025, 0.000056767777194148347, 
     0.000039453830285734375, 0.000028485143941526873, 
     0.00002123245349872752, 0.00001625417145922321, 0.000012724990427443918, 
     0.000010152798198414139, 8.232927954472374e-6, 6.770215414529986e-6, 
     5.635755838222901e-6, 4.742055632032508e-6, 4.028274677550714e-6, 
     3.451188850611981e-6, 2.979497525681448e-6, 2.590144819856766e-6, 
     2.2658862316759906e-6, 1.9936447969307466e-6, 1.763379220010326e-6, 
     1.567290933143293e-6, 1.3992597911937516e-6, 1.254436674008365e-6, 
     1.1289454767775749e-6, 1.0196624674080425e-6, 9.240510939166013e-7, 
     8.400370231829125e-7, 7.659127021384396e-7, 7.0026381244403e-7, 
     6.419121212884888e-7, 5.898707244573872e-7, 5.433087363662533e-7, 
     5.015232401074401e-7, 4.639168593497681e-7, 4.2997971483696e-7, 
     3.9927482372169454e-7, 3.714262196001429e-7, 3.461092356529559e-7, 
     3.2304251749824943e-7, 3.019814267804111e-7, 2.8271256878331084e-7, 
     2.6504923302222194e-7, 2.488275789113881e-7, 2.3390343223668428e-7, 
     2.201495845280012e-7, 2.0745350820446363e-7, 1.9571541682477652e-7, 
     1.8484661287647908e-7, 1.74768076015511e-7, 1.6540925308440875e-7, 
     1.5670701802812805e-7, 1.4860477532786213e-7, 1.4105168504786428e-7, 
     1.3400199124378368e-7, 1.2741443847510603e-7, 1.212517636267178e-7, 
     1.1548025227675695e-7, 1.1006935053052496e-7, 1.0499132463790213e-7, 
     1.0022096187628152e-7, 9.57353071542964e-8, 9.151343060734795e-8, 
     8.753622214155987e-8, 8.378620946061261e-8, 8.024739659817242e-8, 
     7.690512039226595e-8, 7.374592268923223e-8, 7.075743636392803e-8, 
     6.79282834980321e-8, 6.52479842765184e-8, 6.27068753494087e-8, 
     6.029603656657028e-8, 5.800722513160434e-8, 5.5832816340132627e-8, 
     5.376575017085101e-8, 5.179948308695353e-8, 4.992794448293485e-8, 
     4.814549727904662e-8, 4.644690222424352e-8, 4.482728551952411e-8, 
     4.328210941818253e-8, 4.180714549852151e-8, 4.039845033878598e-8, 
     3.905234335410457e-8, 3.77653865816234e-8, 3.653436622325808e-8, 
     3.5356275775981475e-8, 3.42283005976588e-8, 3.314780377244007e-8, 
     3.211231315388554e-8, 3.111950947655838e-8, 3.0167215437968424e-8, 
     2.9253385662660895e-8, 2.837609746906443e-8};
 
  TVIL_REAL GyxxxytableCLy3[] = 
     {0, -0.1111111111111111, -0.012345679012345678, 
     -0.00411522633744856, -0.0015241579027587258, -0.0006435333367203509, 
     -0.0003067132569749041, -0.0001630786233404398, -0.00009540796382609491, 
     -0.000060458857146298217, -0.000040848238267657665, 
     -0.00002902037124771965, -0.00002144059745113582, 
     -0.000016336005833674338, -0.000012757464385559446, 
     -0.00001016578778166035, -8.238159869946542e-6, -6.772335537140434e-6, 
     -5.63661959187901e-6, -4.742409215400506e-6, -4.028420039602001e-6, 
     -3.4512488412998142e-6, -2.9795223703097426e-6, 
     -2.590155141779632e-6, -2.265890532477185e-6, -1.993646593709912e-6, 
     -1.7633799725075831e-6, -1.5672912490063393e-6, 
     -1.3992599240567791e-6, -1.2544367300042767e-6, 
     -1.1289455004202933e-6, -1.0196624774074719e-6, 
     -9.240510981524706e-7, -8.400370249799479e-7, -7.659127029018859e-7, 
     -7.002638127687977e-7, -6.419121214268157e-7, -5.898707245163735e-7, 
     -5.433087363914347e-7, -5.015232401182013e-7, -4.639168593543715e-7, 
     -4.299797148389311e-7, -3.992748237225393e-7, -3.7142621960050526e-7, 
     -3.461092356531114e-7, -3.230425174983163e-7, -3.0198142678043985e-7, 
     -2.8271256878332317e-7, -2.650492330222273e-7, -2.488275789113904e-7, 
     -2.3390343223668526e-7, -2.2014958452800164e-7, 
     -2.0745350820446382e-7, -1.957154168247766e-7, -1.848466128764791e-7, 
     -1.74768076015511e-7, -1.6540925308440875e-7, -1.5670701802812805e-7, 
     -1.4860477532786213e-7, -1.4105168504786428e-7, 
     -1.3400199124378368e-7, -1.2741443847510603e-7, 
     -1.212517636267178e-7, -1.1548025227675695e-7, 
     -1.1006935053052496e-7, -1.0499132463790213e-7, 
     -1.0022096187628152e-7, -9.57353071542964e-8, -9.151343060734795e-8, 
     -8.753622214155987e-8, -8.378620946061261e-8, -8.024739659817242e-8, 
     -7.690512039226595e-8, -7.374592268923223e-8, -7.075743636392803e-8, 
     -6.79282834980321e-8, -6.52479842765184e-8, -6.27068753494087e-8, 
     -6.029603656657028e-8, -5.800722513160434e-8, -5.5832816340132627e-8, 
     -5.376575017085101e-8, -5.179948308695353e-8, -4.992794448293485e-8, 
     -4.814549727904662e-8, -4.644690222424352e-8, -4.482728551952411e-8, 
     -4.328210941818253e-8, -4.180714549852151e-8, -4.039845033878598e-8, 
     -3.905234335410457e-8, -3.77653865816234e-8, -3.653436622325808e-8, 
     -3.5356275775981475e-8, -3.42283005976588e-8, -3.314780377244007e-8, 
     -3.211231315388554e-8, -3.111950947655838e-8, -3.0167215437968424e-8, 
     -2.9253385662660895e-8, -2.837609746906443e-8};

  TVIL_REAL GyxxxytableCLx2Ly[] = 
     {0, 0., -0.012345679012345678, -0.006858710562414266, 
     -0.0030483158055174516, -0.0014564175515250047, -0.0007620789513793629, 
     -0.00043404002827532437, -0.0002662920597366754, -0.0001739944115345949, 
     -0.00011975589883912641, -0.0000859906591307734, 
     -0.00006390550444859086, -0.000048844348752120765, 
     -0.00003820744524044728, -0.00003047138417848863, 
     -0.00002470401577889129, -0.000020312766366200407, 
     -0.000016908131268324815, -0.000014226520479465522, 
     -0.000012084969394703429, -0.000010353626542523777, 
     -8.93851742167264e-6, -7.770444781493163e-6, -6.797662995829166e-6, 
     -5.980936187571405e-6, -5.290138412528235e-6, -4.701873115292925e-6, 
     -4.197779506444282e-6, -3.7633100780210064e-6, -3.386836453975443e-6, 
     -3.058987412223557e-6, -2.772153285985673e-6, -2.520111071345773e-6, 
     -2.297738107178765e-6, -2.1007914376568576e-6, 
     -1.9257363640037933e-6, -1.7696121734311478e-6, 
     -1.6299262091239414e-6, -1.5045697203330818e-6, 
     -1.3917505780539078e-6, -1.2899391445128512e-6, 
     -1.1978244711659284e-6, -1.114278658800791e-6, 
     -1.0383277069590232e-6, -9.691275524948152e-7, -9.05944280341262e-7, 
     -8.481377063499448e-7, -7.951476990666712e-7, -7.464827367341666e-7, 
     -7.017102967100538e-7, -6.60448753584004e-7, -6.223605246133911e-7, 
     -5.871462504743297e-7, -5.545398386294373e-7, -5.24304228046533e-7, 
     -4.962277592532262e-7, -4.701210540843841e-7, -4.4581432598358637e-7, 
     -4.2315505514359283e-7, -4.0200597373135105e-7, 
     -3.822433154253181e-7, -3.637552908801534e-7, -3.4644075683027087e-7, 
     -3.3020805159157487e-7, -3.149739739137064e-7, 
     -3.0066288562884454e-7, -2.8720592146288923e-7, 
     -2.745402918220438e-7, -2.6260866642467963e-7, 
     -2.5135862838183784e-7, -2.4074218979451725e-7, 
     -2.3071536117679785e-7, -2.2123776806769672e-7, 
     -2.1227230909178409e-7, -2.037848504940963e-7, -1.957439528295552e-7, 
     -1.8812062604822613e-7, -1.8088810969971083e-7, 
     -1.7402167539481302e-7, -1.6749844902039787e-7, 
     -1.6129725051255303e-7, -1.553984492608606e-7, 
     -1.4978383344880458e-7, -1.4443649183713986e-7, 
     -1.3934070667273056e-7, -1.3448185655857234e-7, 
     -1.298463282545476e-7, -1.2542143649556453e-7, 
     -1.2119535101635795e-7, -1.1715703006231371e-7, 
     -1.132961597448702e-7, -1.0960309866977423e-7, 
     -1.0606882732794443e-7, -1.026849017929764e-7, -9.944341131732022e-8, 
     -9.633693946165661e-8, -9.335852842967514e-8, -9.050164631390527e-8, 
     -8.776015698798268e-8, -8.51282924071933e-8};
 
  TVIL_REAL GyxxxytableCLxLy2[] = 
     {0, 0.16666666666666666, 0.024691358024691357, 
     0.009602194787379973, 0.0038103947568968147, 0.0016935087808430287, 
     0.0008411093611520376, 0.0004616379491483219, 0.0002762579756074801, 
     0.0001776854914867448, 0.0001211503068210497, 0.00008652588643696616, 
     0.00006411364840099917, 0.00004892618312657189, 0.00003823991919856281, 
     0.00003048437376173484, 0.00002470924769436546, 0.000020314886488810855, 
     0.00001690899502198092, 0.00001422687406283352, 0.000012085114756754718, 
     0.00001035368653321161, 8.938542266300934e-6, 7.77045510341603e-6, 
     6.79766729663036e-6, 5.98093798435057e-6, 5.290139165025492e-6, 
     4.7018734311559715e-6, 4.19777963930731e-6, 3.7633101340169184e-6, 
     3.3868364776181617e-6, 3.0589874222229863e-6, 2.7721532902215424e-6, 
     2.5201110731428085e-6, 2.2977381079422114e-6, 2.1007914379816252e-6, 
     1.9257363641421205e-6, 1.769612173490134e-6, 1.6299262091491226e-6, 
     1.5045697203438429e-6, 1.3917505780585112e-6, 1.2899391445148222e-6, 
     1.197824471166773e-6, 1.1142786588011534e-6, 1.0383277069591786e-6, 
     9.69127552494882e-7, 9.059442803412907e-7, 8.481377063499571e-7, 
     7.951476990666765e-7, 7.464827367341689e-7, 7.017102967100548e-7, 
     6.604487535840044e-7, 6.223605246133913e-7, 5.871462504743298e-7, 
     5.545398386294373e-7, 5.24304228046533e-7, 4.962277592532262e-7, 
     4.701210540843841e-7, 4.4581432598358637e-7, 4.2315505514359283e-7, 
     4.0200597373135105e-7, 3.822433154253181e-7, 3.637552908801534e-7, 
     3.4644075683027087e-7, 3.3020805159157487e-7, 3.149739739137064e-7, 
     3.0066288562884454e-7, 2.8720592146288923e-7, 2.745402918220438e-7, 
     2.6260866642467963e-7, 2.5135862838183784e-7, 2.4074218979451725e-7, 
     2.3071536117679785e-7, 2.2123776806769672e-7, 2.1227230909178409e-7, 
     2.037848504940963e-7, 1.957439528295552e-7, 1.8812062604822613e-7, 
     1.8088810969971083e-7, 1.7402167539481302e-7, 1.6749844902039787e-7, 
     1.6129725051255303e-7, 1.553984492608606e-7, 1.4978383344880458e-7, 
     1.4443649183713986e-7, 1.3934070667273056e-7, 1.3448185655857234e-7, 
     1.298463282545476e-7, 1.2542143649556453e-7, 1.2119535101635795e-7, 
     1.1715703006231371e-7, 1.132961597448702e-7, 1.0960309866977423e-7, 
     1.0606882732794443e-7, 1.026849017929764e-7, 9.944341131732022e-8, 
     9.633693946165661e-8, 9.335852842967514e-8, 9.050164631390527e-8, 
     8.776015698798268e-8, 8.51282924071933e-8};
 
  TVIL_REAL GyxxxytableB[] = {-13.947574800890505, -4.366252327466239, 0.7111722853267121, 
     1.030910132024845, -0.5753695752191219, 0.3415901228300143, 
     -0.22079057578262706, 0.1525414860259111, -0.11087860375582563, 
     0.08382926255624566, -0.06538506297092707, 0.0523004272759953, 
     -0.04271122566554368, 0.035490633329668925, -0.029927631726075266, 
     0.025556920372541057, -0.022064328731940027, 0.019231904271478636, 
     -0.016904821927723405, 0.014970781541585458, -0.013346805877950963, 
     0.011970561973989073, -0.010794524320551653, 0.009781968004986919, 
     -0.008904166682095975, 0.008138399890751814, -0.007466514074485166, 
     0.006873868784845702, -0.00634855496570261, 0.005880808150091311, 
     -0.005462563113038104, 0.005087112426444579, -0.0047488421886034814, 
     0.004443025674884172, -0.004165660882977686, 0.003913341645882678, 
     -0.00368315463444375, 0.0034725964875547727, -0.0032795067084486684, 
     0.003102012998365817, -0.002938486467486036, 0.002787504739723604, 
     -0.0026478214041418084, 0.0025183405980672294, -0.002398095761989138, 
     0.0022862318033227682, -0.0021819900592683107, 0.0020846955687924998, 
     -0.0019937462580065643, 0.001908603717772515, -0.0018287853116645202, 
     0.001753857399806869, -0.0016834295021764373, 0.0016171492556735544, 
     -0.0015546980441603297, 0.0014957872009290218, -0.0014401546996242783, 
     0.0013875622632317874, -0.0013377928319378979, 0.0012906483399164122, 
     -0.0012459477587733435, 0.0012035253717683542, -0.001163229248265954, 
     0.001124919892338152, -0.0010884690431950397, 0.0010537586082840621, 
     -0.001020679712572965, 0.0009891318497977047, -0.0009590221233823376, 
     0.0009302645663784524, -0.00090277953117282, 0.0008764931409114481, 
     -0.0008513367956175761, 0.0008272467268664713, -0.0008041635956430477, 
     0.0007820321286675816, -0.0007608007890454902, 0.0007404214775921714, 
     -0.0007208492616141498, 0.0007020421283024423, -0.0006839607602209231, 
     0.0006665683306581654, -0.0006498303168613826, 0.0006337143293904928, 
     -0.0006181899560230899, 0.0006032286188107346, -0.0005888034430364905, 
     0.000574889136955623, -0.0005614618813180756, 0.0005484992277746655, 
     -0.0005359800053605741, 0.0005238842343310628, -0.0005121930466967015, 
     0.0005008886128698198, -0.000489954073891327, 0.0004793734787583303, 
     -0.0004691317264188186, 0.0004592145120407003, -0.00044960827719924993, 
     0.00044030016365999297, -0.0004312779704636835};
 
  TVIL_REAL GyxxxytableBL[] = {15.81010713258766, -2.4682803512329166, 3.2169732345606956, 
     0.34077270453995684, -0.45255927533949625, 0.36622777767958703, 
     -0.2849633691957083, 0.2239993283416026, -0.1793488583957184, 
     0.1462716205116547, -0.12129735140352958, 0.10206680179307509, 
     -0.0869851362986086, 0.07496011646172746, -0.06522979144793248, 
     0.0572522141421635, -0.05063463462623307, 0.04508740789611368, 
     -0.04039346190466284, 0.03638770023848279, -0.032942855970398394, 
     0.029959609285521088, -0.027359572544042827, 0.02508023607625616, 
     -0.023071275948183298, 0.021291821834220154, -0.0197084110998326, 
     0.018293439685251364, -0.017023977007811424, 0.015880850598352748, 
     -0.014847932714370108, 0.013911579684719387, -0.013060187814606428, 
     0.012283839017274284, -0.011574016079035309, 0.010923372378448292, 
     -0.010325544497180993, 0.009774998845776376, -0.00926690543871117, 
     0.008797033471259628, -0.008361664505321787, 0.007957519955892922, 
     -0.007581700252069637, 0.007231633576098361, -0.006905032497656755, 
     0.006599857145599218, -0.006314283816226315, 0.006046678121160116, 
     -0.005795571940813373, 0.005559643580155631, -0.0053377006288585285, 
     0.0051286651132397216, -0.004931560596831027, 0.00474550094307994, 
     -0.00456968050017181, 0.004403365506216144, -0.004245886544645663, 
     0.004096631905879935, -0.003955041733104468, 0.0038206028482112046, 
     -0.0036928441691816485, 0.003571332642990152, -0.0034556696288845553, 
     0.003345487676008356, -0.003240447647043771, 0.00314023614610878, 
     -0.0030445632147228017, 0.0029531602644212664, -0.0028657782186782502, 
     0.002782185840295718, -0.002702168223427068, 0.002625525431995974, 
     -0.002552071268511345, 0.0024816321592177866, -0.0024140461432021875, 
     0.0023491619545380686, -0.002286838187821386, 0.0022269425385610963, 
     -0.0021693511108575067, 0.002113947785650366, -0.0020606236435631747, 
     0.00200927643702419, -0.0019598101069201066, 0.0019121343395455544, 
     -0.0018661641600592601, 0.0018218195590535009, -0.0017790251491938865, 
     0.0017377098491972059, -0.0016978065926909526, 0.0016592520597434233, 
     -0.001621986429071693, 0.0015859531491294728, -0.0015510987264506647, 
     0.0015173725297797965, -0.001484726608659541, 0.0014531155252701068, 
     -0.0014224961984270342, 0.0013928277587442986, -0.0013640714140598625, 
     0.0013361903243020465, -0.0013091494850482866};
 
  TVIL_REAL GyxxxytableBL2[] = {-10.182233833280657, 0.3177661667193437, 3., -1., 0.5, 
     -0.3, 0.2, -0.14285714285714285, 0.10714285714285714, 
     -0.08333333333333333, 0.06666666666666667, -0.05454545454545454, 
     0.045454545454545456, -0.038461538461538464, 0.03296703296703297, 
     -0.02857142857142857, 0.025, -0.022058823529411766, 0.0196078431372549, 
     -0.017543859649122806, 0.015789473684210527, -0.014285714285714285, 
     0.012987012987012988, -0.011857707509881422, 0.010869565217391304, 
     -0.01, 0.009230769230769232, -0.008547008547008548, 
     0.007936507936507936, -0.007389162561576354, 0.006896551724137931, 
     -0.0064516129032258064, 0.006048387096774193, -0.005681818181818182, 
     0.0053475935828877, -0.005042016806722689, 0.004761904761904762, 
     -0.0045045045045045045, 0.004267425320056899, -0.004048582995951417, 
     0.0038461538461538464, -0.003658536585365854, 0.003484320557491289, 
     -0.0033222591362126247, 0.003171247357293869, -0.0030303030303030303, 
     0.002898550724637681, -0.0027752081406105457, 0.0026595744680851063, 
     -0.002551020408163265, 0.0024489795918367346, -0.002352941176470588, 
     0.0022624434389140274, -0.0021770682148040637, 0.0020964360587002098, 
     -0.00202020202020202, 0.001948051948051948, -0.0018796992481203006, 
     0.0018148820326678765, -0.0017533606078316774, 0.001694915254237288, 
     -0.001639344262295082, 0.0015864621893178213, -0.0015360983102918587, 
     0.001488095238095238, -0.0014423076923076924, 0.0013986013986013986, 
     -0.0013568521031207597, 0.0013169446883230904, -0.0012787723785166241, 
     0.0012422360248447205, -0.0012072434607645875, 0.0011737089201877935, 
     -0.001141552511415525, 0.0011106997408367272, -0.001081081081081081, 
     0.0010526315789473684, -0.0010252904989747095, 0.000999000999000999, 
     -0.0009737098344693282, 0.0009493670886075949, -0.000925925925925926, 
     0.0009033423667570009, -0.000881575080811049, 0.0008605851979345956, 
     -0.0008403361344537816, 0.0008207934336525308, -0.0008019246190858059, 
     0.0007836990595611285, -0.0007660878447395301, 0.000749063670411985, 
     -0.0007326007326007326, 0.000716674629718108, -0.0007012622720897616, 
     0.0006863417982155113, -0.0006718924972004479, 0.0006578947368421052, 
     -0.0006443298969072165, 0.0006311803071744162, -0.0006184291898577613, 
     0.0006060606060606061};
 
  TVIL_REAL GyxxxytableD[] = 
     {0, -0.3333333333333333, -0.5546425122049395, 0.2554861982793259, 
     -0.11904110067344673, 0.0671524761131516, -0.042787121040013, 
     0.02955365482264261, -0.021605214028513304, 0.016470396513220638, 
     -0.012965963107326582, 0.010469670637541636, -0.008629549219972882, 
     0.0072345881125379105, -0.00615213907591538, 0.005295463498448368, 
     -0.004605925229972044, 0.004042742388865057, -0.0035768447652625144, 
     0.0031870606881419902, -0.0028576765231610674, 0.0025768321664617184, 
     -0.0023354407543365965, 0.002126445706658474, -0.0019442999303439356, 
     0.001784594412489601, -0.001643789180653224, 0.0015190156208765928, 
     -0.0014079293216903827, 0.0013085992104978847, -0.0012194231046228046, 
     0.0011390627232737947, -0.0010663931998638153, 0.001000463512293973, 
     -0.0009404652144052107, 0.0008857075366945987, -0.0008355974157880711, 
     0.0007896233685264544, -0.0007473423875713161, 0.0007083692284781505, 
     -0.000672367602207521, 0.0006390428954000052, -0.000608136122908287, 
     0.0005794188798561932, -0.0005526891087968461, 0.0005277675349581183, 
     -0.0005044946517322811, 0.0004827281614444563, -0.00046234079448201457, 
     0.0004432184441828715, -0.0004252585662962223, 0.0004083688009780237, 
     -0.000392465782650945, 0.0003774741090187711, -0.0003633254453684304, 
     0.0003499577442449771, -0.00033731456382303374, 0.00032534447096175444, 
     -0.00031400051712949796, 0.0003032397772066573, -0.0002930229426903085, 
     0.0002833139620884933, -0.0002740797223500361, 0.0002652897660641833, 
     -0.0002569160399124934, 0.0002489326704872891, -0.00024131576412616206, 
     0.00023404322786653748, -0.00022709460901133656, 0.00022045095112716958, 
     -0.00021409466457924964, 0.00020800940994977266, 
     -0.00020217999289507107, 0.00019659226917657802, 
     -0.00019123305875586613, 0.00018609006797837022, -0.0001811518189869185, 
     0.0001764075856074506, -0.00017184733503746065, 0.00016746167474461436, 
     -0.00016324180405020126, 0.00015917946993093443, 
     -0.00015526692662422355, 0.00015149689866739244, 
     -0.00014786254704121827, 0.00014435743812334298, 
     -0.00014097551518815865, 0.00013771107221722647, -0.0001345587298085984, 
     0.00013151341299497363, -0.0001285703307997664, 0.0001257249573771912, 
     -0.00012297301459763364, 0.00012031045595309702, 
     -0.00011773345166958713, 0.000115238374924091, -0.00011282178907346633, 
     0.00011048043581121628, -0.0001082112241758933, 0.00010601122034185431, 
     -0.00010387763812936582};
 
  TVIL_REAL GyxxxytableDL[] = 
     {0, -1.0158608580341884, -0.4373951742070274, 
     0.38536425377018035, -0.23028330848791806, 0.14857616918012026, 
     -0.10282193755900246, 0.07504415978122468, -0.057033635639389776, 
     0.04473536820440237, -0.035984237824998294, 0.029545633474399, 
     -0.02467615701784305, 0.02090744409982058, -0.017932954457889328, 
     0.015545454091845653, -0.013600886548639802, 0.01199666049201154, 
     -0.010658149304479116, 0.009530042665723756, -0.008570658525191531, 
     0.007748113520106382, -0.00703769007539277, 0.006419991817942485, 
     -0.005879629069883187, 0.00540426747540242, -0.004983929646274072, 
     0.004610475854784576, -0.004277213243187003, 0.003978598495673439, 
     -0.0037100093075982006, 0.0034675670670724873, -0.0032479980581998453, 
     0.003048523922800446, -0.0028667745474195167, 0.0027007182848381825, 
     -0.0025486056821195503, 0.0024089238116372694, -0.002280358984615821, 
     0.002161766135947785, -0.0020521435518664776, 0.0019506119021042924, 
     -0.0018563967595793991, 0.0017688139608673743, -0.0016872572924487655, 
     0.0016111880903287676, -0.001540126421027929, 0.0014736435753121588, 
     -0.001411355656250498, 0.0013529180831983456, -0.0012980208653387215, 
     0.0012463845241876914, -0.0011977565653016873, 0.0011519084163362082, 
     -0.0011086327623930621, 0.001067741220879819, -0.0010290623073803448, 
     0.0009924396516862897, -0.0009577304294734805, 0.000924803980369276, 
     -0.0008935405875431975, 0.0008638303976211814, -0.0008355724628008054, 
     0.0008086738896338539, -0.0007830490811273527, 0.0007586190606630413, 
     -0.0007353108678040877, 0.000713057017392602, -0.0006917950144800077, 
     0.0006714669186058423, -0.0006520189517749901, 0.0006334011452002432, 
     -0.0006155670204943764, 0.0005984733015286279, -0.00058207965363516, 
     0.0005663484472302979, -0.0005512445432820047, 0.0005367350983466596, 
     -0.0005227893871631109, 0.0005093786410215746, -0.0004964759003258196, 
     0.0004840558799431258, -0.00047209484609104987, 0.0004605705036459472, 
     -0.00044946189287790216, 0.0004387492947223278, -0.0004284141437918039, 
     0.000418438948414291, -0.00040880721705702894, 0.00039950339056036524, 
     -0.0003905127796634675, 0.0003818215073552319, -0.0003734164556294651, 
     0.0003652852162642501, -0.00035741604528189243, 0.00034979782077847616, 
     -0.0003424200038412893, 0.00033527260229858775, -0.00032834613706969807, 
     0.0003216316109046053, -0.0003151204793212036};
 
  TVIL_REAL GyxxxytableDL2[] = 
     {0, -2., 0.75, -0.25, 0.125, -0.075, 0.05, 
     -0.03571428571428571, 0.026785714285714284, -0.020833333333333332, 
     0.016666666666666666, -0.013636363636363636, 0.011363636363636364, 
     -0.009615384615384616, 0.008241758241758242, -0.007142857142857143, 
     0.00625, -0.0055147058823529415, 0.004901960784313725, 
     -0.0043859649122807015, 0.003947368421052632, -0.0035714285714285713, 
     0.003246753246753247, -0.0029644268774703555, 0.002717391304347826, 
     -0.0025, 0.002307692307692308, -0.002136752136752137, 
     0.001984126984126984, -0.0018472906403940886, 0.0017241379310344827, 
     -0.0016129032258064516, 0.0015120967741935483, -0.0014204545454545455, 
     0.001336898395721925, -0.0012605042016806723, 0.0011904761904761906, 
     -0.0011261261261261261, 0.0010668563300142249, -0.0010121457489878543, 
     0.0009615384615384616, -0.0009146341463414635, 0.0008710801393728223, 
     -0.0008305647840531562, 0.0007928118393234672, -0.0007575757575757576, 
     0.0007246376811594203, -0.0006938020351526364, 0.0006648936170212766, 
     -0.0006377551020408163, 0.0006122448979591836, -0.000588235294117647, 
     0.0005656108597285068, -0.0005442670537010159, 0.0005241090146750524, 
     -0.000505050505050505, 0.000487012987012987, -0.00046992481203007516, 
     0.00045372050816696913, -0.00043834015195791935, 0.000423728813559322, 
     -0.0004098360655737705, 0.0003966155473294553, -0.00038402457757296467, 
     0.0003720238095238095, -0.0003605769230769231, 0.00034965034965034965, 
     -0.00033921302578018993, 0.0003292361720807726, -0.00031969309462915604, 
     0.00031055900621118014, -0.0003018108651911469, 0.00029342723004694836, 
     -0.00028538812785388126, 0.0002776749352091818, -0.0002702702702702703, 
     0.0002631578947368421, -0.0002563226247436774, 0.00024975024975024975, 
     -0.00024342745861733204, 0.00023734177215189873, -0.0002314814814814815, 
     0.00022583559168925022, -0.00022039377020276226, 0.0002151462994836489, 
     -0.0002100840336134454, 0.0002051983584131327, -0.00020048115477145148, 
     0.00019592476489028212, -0.00019152196118488253, 0.00018726591760299626, 
     -0.00018315018315018315, 0.000179168657429527, -0.0001753155680224404, 
     0.00017158544955387783, -0.00016797312430011198, 0.0001644736842105263, 
     -0.00016108247422680412, 0.00015779507679360404, 
     -0.00015460729746444033, 0.00015151515151515152};
 
  TVIL_REAL GyxxxytableE[] = {22.458154233265567, 51.42266167678135, 5.924145049863704, 
     -2.030113795966496, 1.2455027589464653, -0.8502101307225332, 
     0.615749683934709, -0.46516640975304485, 0.3629308531378145, 
     -0.2904959265692398, 0.23739613589690944, -0.19736873479085304, 
     0.16648472328041955, -0.14218089185542224, 0.12272894566936685, 
     -0.10693016898234896, 0.09393257745393477, -0.08311754548431702, 
     0.07402734655515311, -0.06631759000906433, 0.05972525257498291, 
     -0.05404673272485117, 0.0491224967846028, -0.044826151068155254, 
     0.04105654213956479, -0.037731964465082694, 0.034785857713555614, 
     -0.03216357219897152, 0.029819910366821658, -0.02771723899342453, 
     0.025824025842989828, -0.02411369532339772, 0.022563726227920716, 
     -0.021154934871032434, 0.019870901414799295, -0.018697507674929628, 
     0.01762256237092919, -0.016635495452508937, 0.015727107356820563, 
     -0.014889362223194407, 0.014115216493970332, -0.01339847616237052, 
     0.012733677336139209, -0.012115985874529852, 0.011541112703787874, 
     -0.011005242080037664, 0.010504970591306612, -0.010037255104505514, 
     0.009599368192876904, -0.009188859843242697, 0.008803524454508061, 
     -0.008441372310225058, 0.008100604847038445, -0.007779593154104245, 
     0.007476859231234633, -0.00719105960962515, 0.006920971001756761, 
     -0.006665477698970529, 0.006423560478306097, -0.006194286816092942, 
     0.005976802235783799, -0.005770322642669856, 0.00557412751926506, 
     -0.005387553872981021, 0.005209990842795951, -0.005040874884410529, 
     0.0048796854642574345, -0.004725941202000199, 0.004579196409077362, 
     -0.004439037977632128, 0.004305082579992355, -0.00417697414387768, 
     0.004054381572832829, -0.00393699668512148, 0.003824532347549756, 
     -0.0037167207834953924, 0.003613312036859021, -0.003514072575779819, 
     0.0034187840218129497, -0.0033272419918881635, 0.003239255041789368, 
     -0.0031546437011411754, 0.003073239590983506, -0.002994884615979175, 
     0.0029194302241491383, -0.0028467367277802687, 0.002776672679813985, 
     -0.002709114300611509, 0.0026439449505125476, -0.0025810546440668707, 
     0.002520339602229733, -0.002461701839178461, 0.0024050487807342497, 
     -0.0023502929116648616, 0.002297351449404641, -0.0022461460419616135, 
     0.002196602487990509, -0.0021486504771981363, 0.0021022233494159934, 
     -0.002057257870826485, 0.002013694025965454};
 
  TVIL_REAL GyxxxytableEL[] = {25.719752243628534, 6.441364759807959, -0.7830267654393045, 
     1.6741060378732902, -1.119225942006163, 0.766227777679587, 
     -0.551630035862375, 0.4144755188177931, -0.32220600125286125, 
     0.2573827316227658, -0.21018624029241847, 0.17479407452034781, 
     -0.1475911969046692, 0.12624216774377875, -0.10918583540397643, 
     0.0953474522374016, -0.0839679679595664, 0.07449917260199604, 
     -0.06653725275433604, 0.059779513103979866, -0.053995487549345765, 
     0.04900722833314013, -0.04467558986006014, 0.040890512756098056, 
     -0.037564029571371706, 0.03462515516755349, -0.03201610340752491, 
     0.02968945108126276, -0.027605987589822006, 0.025733067347121222, 
     -0.02404333501322068, 0.022513730222353794, -0.021124703943638686, 
     0.01985959659303186, -0.01870414085621891, 0.017646061454078543, 
     -0.01667475084638734, 0.015781004851782382, -0.014956805865453702, 
     0.014195144132528183, -0.013489869633526915, 0.012835568736380728, 
     -0.012227460995391357, 0.011661312424381861, -0.011133362307381914, 
     0.01064026118600326, -0.010179018115743224, 0.009746955641974177, 
     -0.009341671231593515, 0.008961004124373319, -0.008603006751307507, 
     0.008265920015200505, -0.007948151848716396, 0.0076482585628186925, 
     -0.007364928578438756, 0.007096968199818837, -0.00684328914204826, 
     0.006602897570040336, -0.006374884443328304, 0.006158416991986775, 
     -0.005952731174831366, 0.0057571249927169275, -0.005570952547974984, 
     0.005393618756397501, -0.005224574631170755, 0.005063313069185703, 
     -0.004909365079524666, 0.004762296401915613, -0.004621704469775704, 
     0.004487215678317884, -0.0043584829232200285, 0.0042351833796820905, 
     -0.0041170164954284025, 0.004003702174438487, -0.0038949791309844904, 
     0.00379060339597951, -0.00369034695975121, 0.003593996537194042, 
     -0.0035013524428588387, 0.003412227564942804, -0.003326446428373301, 
     0.003243844338258758, -0.0031642665959294414, 0.003087567780626953, 
     -0.0030136110906387207, 0.0029422677383252097, -0.0028734163940639275, 
     0.0028069426746449473, -0.0027427386721057905, 0.00268070251939613, 
     -0.0026207379896210064, 0.0025627541259304496, -0.002506664899408142, 
     0.0024523888925661454, -0.0023998490062802228, 0.0023489721882040374, 
     -0.0022996891808831745, 0.002251934287953921, -0.002205645156959084, 
     0.002160762577445728, -0.0021172302931290947};
 
  TVIL_REAL GyxxxytableEL2[] = {-13.182233833280657, -3.682233833280656, 3., -1., 0.5, 
     -0.3, 0.2, -0.14285714285714285, 0.10714285714285714, 
     -0.08333333333333333, 0.06666666666666667, -0.05454545454545454, 
     0.045454545454545456, -0.038461538461538464, 0.03296703296703297, 
     -0.02857142857142857, 0.025, -0.022058823529411766, 0.0196078431372549, 
     -0.017543859649122806, 0.015789473684210527, -0.014285714285714285, 
     0.012987012987012988, -0.011857707509881422, 0.010869565217391304, 
     -0.01, 0.009230769230769232, -0.008547008547008548, 
     0.007936507936507936, -0.007389162561576354, 0.006896551724137931, 
     -0.0064516129032258064, 0.006048387096774193, -0.005681818181818182, 
     0.0053475935828877, -0.005042016806722689, 0.004761904761904762, 
     -0.0045045045045045045, 0.004267425320056899, -0.004048582995951417, 
     0.0038461538461538464, -0.003658536585365854, 0.003484320557491289, 
     -0.0033222591362126247, 0.003171247357293869, -0.0030303030303030303, 
     0.002898550724637681, -0.0027752081406105457, 0.0026595744680851063, 
     -0.002551020408163265, 0.0024489795918367346, -0.002352941176470588, 
     0.0022624434389140274, -0.0021770682148040637, 0.0020964360587002098, 
     -0.00202020202020202, 0.001948051948051948, -0.0018796992481203006, 
     0.0018148820326678765, -0.0017533606078316774, 0.001694915254237288, 
     -0.001639344262295082, 0.0015864621893178213, -0.0015360983102918587, 
     0.001488095238095238, -0.0014423076923076924, 0.0013986013986013986, 
     -0.0013568521031207597, 0.0013169446883230904, -0.0012787723785166241, 
     0.0012422360248447205, -0.0012072434607645875, 0.0011737089201877935, 
     -0.001141552511415525, 0.0011106997408367272, -0.001081081081081081, 
     0.0010526315789473684, -0.0010252904989747095, 0.000999000999000999, 
     -0.0009737098344693282, 0.0009493670886075949, -0.000925925925925926, 
     0.0009033423667570009, -0.000881575080811049, 0.0008605851979345956, 
     -0.0008403361344537816, 0.0008207934336525308, -0.0008019246190858059, 
     0.0007836990595611285, -0.0007660878447395301, 0.000749063670411985, 
     -0.0007326007326007326, 0.000716674629718108, -0.0007012622720897616, 
     0.0006863417982155113, -0.0006718924972004479, 0.0006578947368421052, 
     -0.0006443298969072165, 0.0006311803071744162, -0.0006184291898577613, 
     0.0006060606060606061};
 
  TVIL_REAL GyxxxytableF[] = {-17.10034433853062, -0.2521798403432631, 11.104120788816608, 
     1.3714048351446457, -1.1681240999440186, 0.7836806966049762, 
     -0.5372820542721881, 0.3838193998057944, -0.2847351254838217, 
     0.21805176468173573, -0.17145806473270028, 0.13783097183883078, 
     -0.11288153345261323, 0.09392657025668703, -0.07922850894925863, 
     0.06762715733410278, -0.058326619033828755, 0.050767693561320194, 
     -0.0445490532904208, 0.039377166148275355, -0.03503366634909869, 
     0.03135360341640712, -0.028210640504536463, 0.02550679136495205, 
     -0.023165181873253088, 0.021124864578939605, -0.01933705052309131, 
     0.017762334730814823, -0.016368628418432687, 0.015129600510927632, 
     -0.01402349072854447, 0.013032196855900286, -0.012140566488026406, 
     0.011335842786096088, -0.010607227310938473, 0.009945532635151124, 
     -0.009342904364022072, 0.008792597230807402, -0.008288793625848504, 
     0.007826455653295459, -0.007401203850345814, 0.0070092172398701896, 
     -0.006647150551908815, 0.006312065338942954, -0.0060013723937564715, 
     0.005712783408018897, -0.005444270221930506, 0.005194030338180496, 
     -0.0049604576278542865, 0.004742117357408166, -0.0045377248262336725, 
     0.004346127032665715, -0.004166286889446341, 0.00399726959295512, 
     -0.003838230818074719, 0.0036884064655829, -0.0035471037339608333, 
     0.0034136933244594656, -0.003287602618738205, 0.0031683096936367967, 
     -0.0030553380586782935, 0.0029482520195723704, -0.002846652586026233, 
     0.002750173855261092, -0.0026584798144993755, 0.0025712615172159567, 
     -0.0024882346003788176, 0.0024091371251777336, -0.002333727745064516, 
     0.002261784237806656, -0.002193102492270312, 0.002127496132623809, 
     -0.0020647971222461834, 0.002004857969212955, -0.0019475566474060457, 
     0.0018928062158402724, -0.001840572653532764, 0.0017909071411395074, 
     -0.001744003821810788, 0.0017003025703985642, -0.0016606713403747697, 
     0.0016267292866289774, -0.0016014190178839374, 0.0015900198529776519, 
     -0.001601941910020561, 0.0016539030003160898, -0.0017755548341282148, 
     0.0020194483659645357, -0.0024786875516539684, 0.0033182082465222492, 
     -0.00483020698246795, 0.007532380897344959, -0.012342071801622449, 
     0.02088500842657497, -0.03604276210174282, 0.06292362809578092, 
     -0.11058467820893808, 0.19508660121856305, -0.3449136037533241, 
     0.6105907222130246, -1.0817515027820293};
 
  TVIL_REAL GyxxxytableFL[] = {17.87894231467214, 12.77955065278312, 15.554925350786911, 
     -1.5481196991296295, -0.01362577212641971, 0.2892781131199918, 
     -0.32039426048402686, 0.2957376773300347, -0.26047928516274166, 
     0.22659808521131083, -0.19699658471178216, 0.17191537266311072, 
     -0.1508505064909765, 0.13315806985039433, -0.11824020723024938, 
     0.10559176584307008, -0.09480101199565127, 0.08553691890293773, 
     -0.0775342966650279, 0.07058039491423625, -0.0645038506137709, 
     0.05916590367113768, -0.054453527244752, 0.05027408762772311, 
     -0.04655119573157355, 0.043221476631958466, -0.04023204377129729, 
     0.037538514193755944, -0.035103440300856194, 0.03289506358068091, 
     -0.030886318442696178, 0.02905403136882469, -0.027378273440828535, 
     0.02584183398682806, -0.024429790409049728, 0.02312915481011296, 
     -0.02192858227112765, 0.020818128881014735, -0.019789050116943617, 
     0.018833632111982482, -0.01794504985317084, 0.017117247532417907, 
     -0.016344837199951702, 0.015623012602922388, -0.014947475673781472, 
     0.014314373597450447, -0.013720244758527435, 0.01316197216947009, 
     -0.012636743223012791, 0.012142014808822875, -0.011675482994787593, 
     0.011235056604578691, -0.010818834130960114, 0.010425083513193312, 
     -0.010052224380434982, 0.009698812424071172, -0.009363525612777847, 
     0.009045152006581429, -0.008742578961798088, 0.008454783548660597, 
     -0.008180824028673336, 0.007919832260066942, -0.007671006917805833, 
     0.007433607429969909, -0.007206948545426579, 0.006990395458894777, 
     -0.006783359429080174, 0.006585293833780711, -0.006395690612932132, 
     0.006214077056658699, -0.0060400129006602165, 0.005873087695825404, 
     -0.005712918422916342, 0.005559147326606059, -0.0054114399461447195, 
     0.005269483322541475, -0.005132984364431772, 0.005001668356798606, 
     -0.004875277598469282, 0.004753570155849521, -0.004636318721712133, 
     0.004523309569052186, -0.004414341591075319, 0.004309225419318292, 
     -0.004207782612726563, 0.004109844911245851, -0.004015253548134749, 
     0.003923858615783626, -0.003835518480339795, 0.0037500992408979156, 
     -0.0036674742294243424, 0.003587523547950392, -0.003510133639897305, 
     0.0034351968926894035, -0.0033626112690754587, 0.0032922799648149627, 
     -0.003224111090598798, 0.003158017376265386, -0.003093915895546014, 
     0.0030317278097287876, -0.0029713781287712838};
 
  TVIL_REAL GyxxxytableFL2[] = {-6.337468205961039, 11.662531794038962, 6.75, -2.25, 1.125, 
     -0.675, 0.45, -0.32142857142857145, 0.24107142857142858, -0.1875, 0.15, 
     -0.12272727272727273, 0.10227272727272728, -0.08653846153846154, 
     0.07417582417582418, -0.06428571428571428, 0.05625, 
     -0.04963235294117647, 0.04411764705882353, -0.039473684210526314, 
     0.035526315789473684, -0.03214285714285714, 0.02922077922077922, 
     -0.0266798418972332, 0.024456521739130436, -0.0225, 0.02076923076923077, 
     -0.019230769230769232, 0.017857142857142856, -0.0166256157635468, 
     0.015517241379310345, -0.014516129032258065, 0.013608870967741936, 
     -0.01278409090909091, 0.012032085561497326, -0.01134453781512605, 
     0.010714285714285714, -0.010135135135135136, 0.009601706970128023, 
     -0.009109311740890687, 0.008653846153846154, -0.008231707317073171, 
     0.0078397212543554, -0.007475083056478406, 0.007135306553911205, 
     -0.006818181818181818, 0.006521739130434782, -0.006244218316373728, 
     0.005984042553191489, -0.005739795918367347, 0.005510204081632653, 
     -0.005294117647058823, 0.005090497737556561, -0.0048984034833091435, 
     0.0047169811320754715, -0.004545454545454545, 0.004383116883116883, 
     -0.0042293233082706765, 0.004083484573502722, -0.003945061367621274, 
     0.0038135593220338985, -0.0036885245901639345, 0.003569539925965098, 
     -0.0034562211981566822, 0.0033482142857142855, -0.003245192307692308, 
     0.003146853146853147, -0.0030529172320217096, 0.0029631255487269537, 
     -0.002877237851662404, 0.0027950310559006213, -0.002716297786720322, 
     0.002640845070422535, -0.0025684931506849314, 0.002499074416882636, 
     -0.0024324324324324323, 0.002368421052631579, -0.002306903622693096, 
     0.002247752247752248, -0.0021908471275559884, 0.0021360759493670887, 
     -0.0020833333333333333, 0.0020325203252032522, -0.0019835439318248603, 
     0.00193631669535284, -0.0018907563025210084, 0.0018467852257181942, 
     -0.0018043303929430633, 0.0017633228840125393, -0.0017236976506639428, 
     0.0016853932584269663, -0.0016483516483516484, 0.001612517916865743, 
     -0.0015778401122019635, 0.0015442690459849004, -0.0015117581187010078, 
     0.0014802631578947369, -0.0014497422680412372, 0.0014201556911424365, 
     -0.0013914656771799629, 0.0013636363636363637};
 
  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  if (y < 0.155 * x) {
    result = TVIL_G00xxx (x, qq);
    rn = r = 4.L*y/x;
    for (n=1; n < 100; n++) {
      result += x * rn * (
        GyxxxytableA[n] +
        GyxxxytableALx[n] * lnbarx +
        GyxxxytableALy[n] * lnbary +
        GyxxxytableALx2[n] * lnbarx2 + 
        GyxxxytableALy2[n] * lnbary2 + 
        GyxxxytableALxLy[n] * lnbarx * lnbary +
        GyxxxytableALx3[n] * lnbarx3 + 
        GyxxxytableALx2Ly[n] * lnbarx2 * lnbary +
        GyxxxytableALxLy2[n] * lnbarx * lnbary2);
      rn *= r;
    }
  } 
  else if (y < 0.5 * x) {
    result = 0.5L * (x + y) * lnbary3; 
    rn = 1;
    r = 0.25L * x/y - 1.L;
    for (n=0; n < 100; n++) {
      result += y * rn * (
        GyxxxytableE[n] +
        GyxxxytableEL[n] * lnbary +
        GyxxxytableEL2[n] * lnbary2);
      rn *= r;
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_Gxxxxx (x, qq);
    result += 0.5L * (y - x) * lnbarx3;
    rn = r = y/x - 1.L;
    for (n=1; n < 100; n++) {
      result += x * rn * (
        GyxxxytableD[n] +
        GyxxxytableDL[n] * lnbarx +
        GyxxxytableDL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else if (y < 5.59 * x) {
    result = 0.5L * (x + y) * lnbarx3; 
    rn = 1;
    r = 0.25L * y/x - 1.L;
    for (n=0; n < 100; n++) {
      result += x * rn * (
        GyxxxytableB[n] +
        GyxxxytableBL[n] * lnbarx +
        GyxxxytableBL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else if (y < 14.56 * x) {
    result = 0.5L * (x + y) * lnbarx3; 
    rn = 1;
    r = y/(9.L*x) - 1.L;
    for (n=0; n < 85; n++) {
      result += x * rn * (
        GyxxxytableF[n] +
        GyxxxytableFL[n] * lnbarx +
        GyxxxytableFL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else {
    result = TVIL_Gx000x (y, qq);
    rn = r = 9.L * x/y;
    for (n=1; n < 100; n++) {
      result += y * rn * (
        GyxxxytableC[n] +
        GyxxxytableCLx[n] * lnbarx +
        GyxxxytableCLy[n] * lnbary +
        GyxxxytableCLx2[n] * lnbarx2 +
        GyxxxytableCLxLy[n] * lnbarx * lnbary +
        GyxxxytableCLy2[n] * lnbary2 + 
        GyxxxytableCLx3[n] * lnbarx3 + 
        GyxxxytableCLx2Ly[n] * lnbarx2 * lnbary +
        GyxxxytableCLxLy2[n] * lnbarx * lnbary2 +
        GyxxxytableCLy3[n] * lnbary3);
      rn *= r;
    }
  }

  return result;
}

/* ****************************************************************** */
int TVIL_AnalyticGTYPE (TVIL_GTYPE *foo, TVIL_REAL qq)
{
  int retval;
  TVIL_REAL x, u, v, y, z;
  TVIL_COMPLEX Au, Av, Ay, Az;
  TVIL_COMPLEX FBARu, FBARv, FBARy, FBARz;

  x = foo->arg[0];
  u = foo->arg[1];
  v = foo->arg[2];
  y = foo->arg[3];
  z = foo->arg[4];

  retval = TVIL_Ganalytic (x, u, v, y, z, qq,  &(foo->value));

  if (0 == retval) {

    if (SAME2(0,x)) {

      Au = TVIL_A (u, qq);
      Av = TVIL_A (v, qq);
      Ay = TVIL_A (y, qq);
      Az = TVIL_A (z, qq);

      if (SAME2(0,u)) FBARu = 0; else FBARu = *(foo->fval[0]);
      if (SAME2(0,v)) FBARv = 0; else FBARv = *(foo->fval[1]);
      if (SAME2(0,y)) FBARy = 0; else FBARy = *(foo->fval[2]);
      if (SAME2(0,z)) FBARz = 0; else FBARz = *(foo->fval[3]);

      if (SAME2(u,v)) {
	  foo->value = 2.0L*(
	      z * FBARz - (Az + z) * TVIL_I2(y,u,u,qq)
            - y * FBARy + (Ay + y) * TVIL_I2(z,u,u,qq)
            + (Az - Ay) * TVIL_I2(0,u,u,qq) + 0.25L * (y * Ay - z * Az))/(y - z)
            - FBARu + (Au/u + 1.L) * (TVIL_I2(u,y,z,qq) - TVIL_I2(0,y,z,qq)) 
            - Ay - Az + 0.25L * Au; 
      } 
      else if (SAME2(y,z)) {
	  foo->value = 2.0L*(
	      v * FBARv - (Av + v) * TVIL_I2(u,y,y,qq)
            - u * FBARu + (Au + u) * TVIL_I2(v,y,y,qq)
            + (Av - Au) * TVIL_I2(0,y,y,qq) + 0.25L * (u * Au - v * Av))/(u - v)
            - FBARy + (Ay/y + 1.L) * (TVIL_I2(y,u,v,qq) - TVIL_I2(0,u,v,qq)) 
            - Au - Av + 0.25L * Ay; 
      }
      else {
        foo->value = 
          (v * FBARv - (Av + v) * TVIL_I2(u,y,z,qq)
          -u * FBARu + (Au + u) * TVIL_I2(v,y,z,qq) +
          (Av - Au) * TVIL_I2(0,y,z,qq) + 0.25L * (u * Au - v * Av))/(u - v)
         +(z * FBARz - (Az + z) * TVIL_I2(y,u,v,qq) 
          -y * FBARy + (Ay + y) * TVIL_I2(z,u,v,qq) +
          (Az - Ay) * TVIL_I2(0,u,v,qq) + 0.25L * (y * Ay - z * Az))/(y - z)
         - 2.L * (u + v + y + z)/3.L;
      }
    }
  }

  return retval;
}

/* ****************************************************************** */

int TVIL_Ganalytic (TVIL_REAL a1,
		    TVIL_REAL a2,
		    TVIL_REAL a3,
		    TVIL_REAL a4,
		    TVIL_REAL a5,
		    TVIL_REAL QQ,
		    TVIL_COMPLEX *result)
{
  int success = 1;

  if (SAME6(0,a1,a2,a3,a4,a5))
    *result = TVIL_G00000 ();

  else if (SAME5(0,a2,a3,a4,a5))
    *result = TVIL_Gx0000 (a1, QQ);

  else if (SAME5(0,a1,a2,a3,a4))
    *result = TVIL_G0000x (a5, QQ);
  else if (SAME5(0,a1,a2,a3,a5))
    *result = TVIL_G0000x (a4, QQ);
  else if (SAME5(0,a1,a2,a4,a5))
    *result = TVIL_G0000x (a3, QQ);
  else if (SAME5(0,a1,a3,a4,a5))
    *result = TVIL_G0000x (a2, QQ);

  else if (SAME4(0,a1,a2,a3) && SAME2(a4,a5))
    *result = TVIL_G000xx (a5, QQ);
  else if (SAME4(0,a1,a4,a5) && SAME2(a2,a3))
    *result = TVIL_G000xx (a3, QQ);

  else if (SAME4(0,a2,a3,a4) && SAME2(a1,a5))
    *result = TVIL_Gx000x (a1, QQ);
  else if (SAME4(0,a2,a3,a5) && SAME2(a1,a4))
    *result = TVIL_Gx000x (a1, QQ);
  else if (SAME4(0,a2,a4,a5) && SAME2(a1,a3))
    *result = TVIL_Gx000x (a1, QQ);
  else if (SAME4(0,a3,a4,a5) && SAME2(a1,a2))
    *result = TVIL_Gx000x (a1, QQ);

  else if (SAME4(0,a1,a2,a4) && SAME2(a3,a5))
    *result = TVIL_G00x0x (a5, QQ);
  else if (SAME4(0,a1,a3,a4) && SAME2(a2,a5))
    *result = TVIL_G00x0x (a5, QQ);
  else if (SAME4(0,a1,a2,a5) && SAME2(a3,a4))
    *result = TVIL_G00x0x (a4, QQ);
  else if (SAME4(0,a1,a3,a5) && SAME2(a2,a4))
    *result = TVIL_G00x0x (a4, QQ);

  else if (SAME3(0,a1,a2) && SAME3(a3,a4,a5))
    *result = TVIL_G00xxx (a5, QQ);
  else if (SAME3(0,a1,a3) && SAME3(a2,a4,a5))
    *result = TVIL_G00xxx (a5, QQ);
  else if (SAME3(0,a1,a4) && SAME3(a2,a3,a5))
    *result = TVIL_G00xxx (a5, QQ);
  else if (SAME3(0,a1,a5) && SAME3(a2,a3,a4))
    *result = TVIL_G00xxx (a4, QQ);

  else if (SAME3(0,a2,a3) && SAME3(a1,a4,a5))
    *result = TVIL_Gx00xx (a1, QQ);
  else if (SAME3(0,a4,a5) && SAME3(a1,a2,a3))
    *result = TVIL_Gx00xx (a1, QQ);

  else if (SAME3(0,a2,a4) && SAME3(a1,a3,a5))
    *result = TVIL_Gx0x0x (a1, QQ);
  else if (SAME3(0,a3,a4) && SAME3(a1,a2,a5))
    *result = TVIL_Gx0x0x (a1, QQ);
  else if (SAME3(0,a2,a5) && SAME3(a1,a3,a4))
    *result = TVIL_Gx0x0x (a1, QQ);
  else if (SAME3(0,a3,a5) && SAME3(a1,a2,a4))
    *result = TVIL_Gx0x0x (a1, QQ);

  else if (SAME2(0,a2) && SAME4(a1,a3,a4,a5))
    *result = TVIL_Gx0xxx (a1, QQ);
  else if (SAME2(0,a3) && SAME4(a1,a2,a4,a5))
    *result = TVIL_Gx0xxx (a1, QQ);
  else if (SAME2(0,a4) && SAME4(a1,a2,a3,a5))
    *result = TVIL_Gx0xxx (a1, QQ);
  else if (SAME2(0,a5) && SAME4(a1,a2,a3,a4))
    *result = TVIL_Gx0xxx (a1, QQ);

  else if (SAME2(0,a1) && SAME4(a2,a3,a4,a5))
    *result = TVIL_G0xxxx (a5, QQ);

  else if (SAME5(a1,a2,a3,a4,a5))
    *result = TVIL_Gxxxxx (a1, QQ);

  else if (SAME4(0,a1,a2,a3) && (a4>0) && (a5>0))
    *result = TVIL_G000xy (a4, a5, QQ);
  else if (SAME4(0,a1,a4,a5) && (a2>0) && (a3>0))
    *result = TVIL_G000xy (a2, a3, QQ);

  else if (SAME4(0,a1,a2,a4) && (a3>0) && (a5>0))
    *result = TVIL_G00x0y (a3, a5, QQ);
  else if (SAME4(0,a1,a2,a5) && (a3>0) && (a4>0))
    *result = TVIL_G00x0y (a3, a4, QQ);
  else if (SAME4(0,a1,a3,a4) && (a2>0) && (a5>0))
    *result = TVIL_G00x0y (a2, a5, QQ);
  else if (SAME4(0,a1,a3,a5) && (a2>0) && (a4>0))
    *result = TVIL_G00x0y (a2, a4, QQ);

  else if (SAME4(0,a2,a3,a4) && (a1>0) && (a5>0)) 
    *result = TVIL_Gx000y (a1, a5, QQ);
  else if (SAME4(0,a2,a3,a5) && (a1>0) && (a4>0)) 
    *result = TVIL_Gx000y (a1, a4, QQ);
  else if (SAME4(0,a2,a4,a5) && (a1>0) && (a3>0)) 
    *result = TVIL_Gx000y (a1, a3, QQ);
  else if (SAME4(0,a3,a4,a5) && (a1>0) && (a2>0)) 
    *result = TVIL_Gx000y (a1, a2, QQ);

  else if (SAME3(0,a2,a3) && SAME2(a4,a5) && (a1>0) && (a5>0))
    *result = TVIL_Gx00yy (a1, a5, QQ);
  else if (SAME3(0,a4,a5) && SAME2(a2,a3) && (a1>0) && (a3>0))
    *result = TVIL_Gx00yy (a1, a3, QQ);

  else if (SAME3(0,a2,a4) && SAME2(a1,a3) && (a1>0) && (a5>0))
    *result = TVIL_Gx0x0y (a1, a5, QQ);
  else if (SAME3(0,a3,a4) && SAME2(a1,a2) && (a1>0) && (a5>0))
    *result = TVIL_Gx0x0y (a1, a5, QQ);
  else if (SAME3(0,a2,a5) && SAME2(a1,a3) && (a1>0) && (a4>0))
    *result = TVIL_Gx0x0y (a1, a4, QQ);
  else if (SAME3(0,a3,a5) && SAME2(a1,a2) && (a1>0) && (a4>0))
    *result = TVIL_Gx0x0y (a1, a4, QQ);

  else if (SAME3(0,a2,a4) && SAME2(a3,a5) && (a1>0) && (a3>0))
    *result = TVIL_Gx0y0y (a1, a3, QQ);
  else if (SAME3(0,a2,a5) && SAME2(a3,a4) && (a1>0) && (a3>0))
    *result = TVIL_Gx0y0y (a1, a3, QQ);
  else if (SAME3(0,a3,a4) && SAME2(a2,a5) && (a1>0) && (a2>0))
    *result = TVIL_Gx0y0y (a1, a2, QQ);
  else if (SAME3(0,a3,a5) && SAME2(a2,a4) && (a1>0) && (a2>0))
    *result = TVIL_Gx0y0y (a1, a2, QQ);

  else if (SAME3(0,a2,a4) && SAME2(a1,a5) && (a1>0) && (a3>0))
    *result = TVIL_Gx0x0y (a1, a3, QQ);
  else if (SAME3(0,a3,a4) && SAME2(a1,a5) && (a1>0) && (a2>0))
    *result = TVIL_Gx0x0y (a1, a2, QQ);
  else if (SAME3(0,a2,a5) && SAME2(a1,a4) && (a1>0) && (a3>0))
    *result = TVIL_Gx0x0y (a1, a3, QQ);
  else if (SAME3(0,a3,a5) && SAME2(a1,a4) && (a1>0) && (a2>0))
    *result = TVIL_Gx0x0y (a1, a2, QQ);

  else if (SAME2(0,a1) && SAME2(a2,a3) && SAME2(a4,a5) && (a3>0) && (a5>0))
    *result = TVIL_G0xxyy (a3, a5, QQ);

  else if (SAME2(0,a1) && SAME2(a2,a4) && SAME2(a3,a5) && (a2>0) && (a3>0))
    *result = TVIL_G0xyxy (a2, a3, QQ);
  else if (SAME2(0,a1) && SAME2(a2,a5) && SAME2(a3,a4) && (a2>0) && (a3>0))
    *result = TVIL_G0xyxy (a2, a3, QQ);

  else if (SAME3(0,a1,a2) && SAME2(a4,a5) && (a3>0) && (a4>0))
    *result = TVIL_G00yxx (a4, a3, QQ);
  else if (SAME3(0,a1,a3) && SAME2(a4,a5) && (a2>0) && (a4>0))
    *result = TVIL_G00yxx (a4, a2, QQ);
  else if (SAME3(0,a1,a4) && SAME2(a2,a3) && (a2>0) && (a5>0))
    *result = TVIL_G00yxx (a2, a5, QQ);
  else if (SAME3(0,a1,a5) && SAME2(a2,a3) && (a2>0) && (a4>0))
    *result = TVIL_G00yxx (a2, a4, QQ);

  else if (SAME3(0,a1,a2) && SAME2(a3,a4) && (a3>0) && (a5>0))
    *result = TVIL_G00xxy (a3, a5, QQ);
  else if (SAME3(0,a1,a2) && SAME2(a3,a5) && (a3>0) && (a4>0))
    *result = TVIL_G00xxy (a3, a4, QQ);
  else if (SAME3(0,a1,a3) && SAME2(a2,a4) && (a2>0) && (a5>0))
    *result = TVIL_G00xxy (a2, a5, QQ);
  else if (SAME3(0,a1,a3) && SAME2(a2,a5) && (a2>0) && (a4>0))
    *result = TVIL_G00xxy (a2, a4, QQ);
  else if (SAME3(0,a1,a4) && SAME2(a2,a5) && (a2>0) && (a3>0))
    *result = TVIL_G00xxy (a2, a3, QQ);
  else if (SAME3(0,a1,a4) && SAME2(a3,a5) && (a3>0) && (a2>0))
    *result = TVIL_G00xxy (a3, a2, QQ);
  else if (SAME3(0,a1,a5) && SAME2(a2,a4) && (a2>0) && (a3>0))
    *result = TVIL_G00xxy (a2, a3, QQ);
  else if (SAME3(0,a1,a5) && SAME2(a3,a4) && (a3>0) && (a2>0))
    *result = TVIL_G00xxy (a3, a2, QQ);

  else if (SAME2(0,a1) && SAME3(a2,a3,a4) && (a2>0) && (a5>0))
    *result = TVIL_G0xxxy (a2, a5, QQ);
  else if (SAME2(0,a1) && SAME3(a2,a3,a5) && (a2>0) && (a4>0))
    *result = TVIL_G0xxxy (a2, a4, QQ);
  else if (SAME2(0,a1) && SAME3(a2,a4,a5) && (a2>0) && (a3>0))
    *result = TVIL_G0xxxy (a2, a3, QQ);
  else if (SAME2(0,a1) && SAME3(a3,a4,a5) && (a3>0) && (a2>0))
    *result = TVIL_G0xxxy (a3, a2, QQ);

  else if (SAME2(0,a2) && SAME3(a1,a3,a4) && (a1 > 0) && (a5 > 0))
    *result = TVIL_Gx0xxy (a1, a5, QQ);
  else if (SAME2(0,a2) && SAME3(a1,a3,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0xxy (a1, a4, QQ);
  else if (SAME2(0,a3) && SAME3(a1,a2,a4) && (a1 > 0) && (a5 > 0))
    *result = TVIL_Gx0xxy (a1, a5, QQ);
  else if (SAME2(0,a3) && SAME3(a1,a2,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0xxy (a1, a4, QQ);
  else if (SAME2(0,a4) && SAME3(a1,a2,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0xxy (a1, a3, QQ);
  else if (SAME2(0,a4) && SAME3(a1,a3,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0xxy (a1, a2, QQ);
  else if (SAME2(0,a5) && SAME3(a1,a2,a4) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0xxy (a1, a3, QQ);
  else if (SAME2(0,a5) && SAME3(a1,a3,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0xxy (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME2(a1,a3) && SAME2(a4,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0xyy (a1, a4, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a2) && SAME2(a4,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0xyy (a1, a4, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a5) && SAME2(a2,a3) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0xyy (a1, a2, QQ);
  else if (SAME2(0,a5) && SAME2(a1,a4) && SAME2(a2,a3) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0xyy (a1, a2, QQ);

  else if (SAME4(a2,a3,a4,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gyxxxx (a2, a1, QQ);

  else if (SAME3(a1,a2,a4) && SAME2(a3,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gxxyxy (a1, a3, QQ);
  else if (SAME3(a1,a2,a5) && SAME2(a3,a4) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gxxyxy (a1, a3, QQ);
  else if (SAME3(a1,a3,a4) && SAME2(a2,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gxxyxy (a1, a2, QQ);
  else if (SAME3(a1,a3,a5) && SAME2(a2,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gxxyxy (a1, a2, QQ);

  else if (SAME3(0,a2,a3) && SAME2(a1,a4) && (a1 > 0) && (a5 > 0))
    *result = TVIL_Gx00xy (a1, a5, QQ);
  else if (SAME3(0,a2,a3) && SAME2(a1,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx00xy (a1, a4, QQ);
  else if (SAME3(0,a4,a5) && SAME2(a1,a2) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx00xy (a1, a3, QQ);
  else if (SAME3(0,a4,a5) && SAME2(a1,a3) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx00xy (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME3(a3,a4,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gy0xxx (a3, a1, QQ);
  else if (SAME2(0,a3) && SAME3(a2,a4,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gy0xxx (a2, a1, QQ);
  else if (SAME2(0,a4) && SAME3(a2,a3,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gy0xxx (a2, a1, QQ);
  else if (SAME2(0,a5) && SAME3(a2,a3,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gy0xxx (a2, a1, QQ);

  else if (SAME2(0,a2) && SAME2(a1,a4) && SAME2(a3,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxy (a1, a3, QQ);
  else if (SAME2(0,a2) && SAME2(a1,a5) && SAME2(a3,a4) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxy (a1, a3, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a4) && SAME2(a2,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxy (a1, a2, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a5) && SAME2(a2,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxy (a1, a2, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a2) && SAME2(a3,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxy (a1, a3, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a3) && SAME2(a2,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxy (a1, a2, QQ);
  else if (SAME2(0,a5) && SAME2(a1,a2) && SAME2(a3,a4) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxy (a1, a3, QQ);
  else if (SAME2(0,a5) && SAME2(a1,a3) && SAME2(a2,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxy (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME3(a1,a4,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxx (a1, a3, QQ);
  else if (SAME2(0,a3) && SAME3(a1,a4,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxx (a1, a2, QQ);
  else if (SAME2(0,a4) && SAME3(a1,a2,a3) && (a1 > 0) && (a5 > 0))
    *result = TVIL_Gx0yxx (a1, a5, QQ);
  else if (SAME2(0,a5) && SAME3(a1,a2,a3) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0yxx (a1, a4, QQ);

  else if (SAME2(a2,a3) && SAME3(a1,a4,a5) && (a2 > 0) && (a1 > 0))
    *result = TVIL_Gyxxyy (a2, a1, QQ);
  else if (SAME2(a4,a5) && SAME3(a1,a2,a3) && (a4 > 0) && (a1 > 0))
    *result = TVIL_Gyxxyy (a4, a1, QQ);

  else if (SAME4(a1,a2,a3,a4) && (a1 > 0) && (a5 > 0))
    *result = TVIL_Gxxxxy (a1, a5, QQ);
  else if (SAME4(a1,a2,a3,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gxxxxy (a1, a4, QQ);
  else if (SAME4(a1,a2,a4,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gxxxxy (a1, a3, QQ);
  else if (SAME4(a1,a3,a4,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gxxxxy (a1, a2, QQ);

  else if (SAME3(a2,a3,a4) && SAME2(a1,a5) && (a2 > 0) && (a1 > 0))
    *result = TVIL_Gyxxxy (a2, a1, QQ);
  else if (SAME3(a2,a3,a5) && SAME2(a1,a4) && (a2 > 0) && (a1 > 0))
    *result = TVIL_Gyxxxy (a2, a1, QQ);
  else if (SAME3(a2,a4,a5) && SAME2(a1,a3) && (a2 > 0) && (a1 > 0))
    *result = TVIL_Gyxxxy (a2, a1, QQ);
  else if (SAME3(a3,a4,a5) && SAME2(a1,a2) && (a3 > 0) && (a1 > 0))
    *result = TVIL_Gyxxxy (a3, a1, QQ);

  else
    success = 0;

  return success;
}

/* ****************************************************************** */
/* Sets initial value for an G function at a point near t = 0. */

int TVIL_InitialG (TVIL_GTYPE  *foo, 
		   TVIL_REAL    qq,
		   TVIL_COMPLEX tinit)
{
  TVIL_REAL w = (foo->arg[0])/_a;
  TVIL_REAL u = (foo->arg[1])/_a;
  TVIL_REAL z = (foo->arg[2])/_a;
  TVIL_REAL v = (foo->arg[3])/_a;
  TVIL_REAL y = (foo->arg[4])/_a;

  TVIL_REAL Gexp[9];
  TVIL_REAL w2, w3, w4, w5, w6, w7, w8;
  TVIL_REAL u2, u3, u4, u5, u6, u7, u8;
  TVIL_REAL z2, z3, z4, z5, z6, z7, z8;
  TVIL_REAL v2, v3, v4, v5, v6, v7, v8;
  TVIL_REAL y2, y3, y4, y5, y6, y7, y8;

  TVIL_REAL lnbara, lnbara2, lnbara3;
  TVIL_COMPLEX ttothei, result;
  int i, nTerms = 9;

  lnbara = TVIL_LOG (_a/qq);
  lnbara2 = lnbara*lnbara;
  lnbara3 = lnbara2*lnbara;

  w2 = w*w;
  w3 = w2*w;
  w4 = w2*w2;
  w5 = w2*w3;
  w6 = w3*w3;
  w7 = w4*w3;
  w8 = w4*w4;

  u2 = u*u;
  u3 = u2*u;
  u4 = u2*u2;
  u5 = u2*u3;
  u6 = u3*u3;
  u7 = u4*u3;
  u8 = u4*u4;

  z2 = z*z;
  z3 = z2*z;
  z4 = z2*z2;
  z5 = z2*z3;
  z6 = z3*z3;
  z7 = z4*z3;
  z8 = z4*z4;

  v2 = v*v;
  v3 = v2*v;
  v4 = v2*v2;
  v5 = v2*v3;
  v6 = v3*v3;
  v7 = v4*v3;
  v8 = v4*v4;

  y2 = y*y;
  y3 = y2*y;
  y4 = y2*y2;
  y5 = y2*y3;
  y6 = y3*y3;
  y7 = y4*y3;
  y8 = y4*y4;

  Gexp[0] = -11.057548482239014 + 18.968278283931625*lnbara - 8.*lnbara2 + 
     lnbara3;
 
  Gexp[1] = -7.910729801692609 - 2.9682782839316233*lnbara + 5.*lnbara2 - 
     1.*lnbara3 + 2.7480210450086475*u + 1.3280463806552705*lnbara*u - 
     1.*lnbara2*u + 0.16666666666666666*lnbara3*u + 2.7480210450086475*v + 
     1.3280463806552705*lnbara*v - 1.*lnbara2*v + 
     0.16666666666666666*lnbara3*v - 3.081354378341981*w - 
     2.343907238689459*lnbara*w - 1.*lnbara2*w + 0.3333333333333333*lnbara3*
      w + 2.7480210450086475*y + 1.3280463806552705*lnbara*y - 
     1.*lnbara2*y + 0.16666666666666666*lnbara3*y + 2.7480210450086475*z + 
     1.3280463806552705*lnbara*z - 1.*lnbara2*z + 
     0.16666666666666666*lnbara3*z;
 
  Gexp[2] = 1.4841391419658116 - 5.*lnbara + 1.5*lnbara2 - 
     1.3280463806552705*u + 2.*lnbara*u - 0.5*lnbara2*u - 
     0.16399130575669638*u2 - 0.2186975871035137*lnbara*u2 + 
     0.25*lnbara2*u2 - 1.3280463806552705*v + 2.*lnbara*v - 
     0.5*lnbara2*v + 1.7363044156749696*u*v - 0.16399130575669638*v2 - 
     0.2186975871035137*lnbara*v2 + 0.25*lnbara2*v2 + 
     2.343907238689459*w + 2.*lnbara*w - 1.*lnbara2*w - 
     0.7813024128964863*u*w - 0.7813024128964863*lnbara*u*w - 
     0.7813024128964863*v*w - 0.7813024128964863*lnbara*v*w + 
     0.39065120644824314*w2 + 0.5626048257929726*lnbara*w2 + 
     0.5*lnbara2*w2 - 1.3280463806552705*y + 2.*lnbara*y - 0.5*lnbara2*y + 
     1.7363044156749696*u*y - 1.0352774262847895*v*y - 
     0.7813024128964863*lnbara*v*y - 0.7813024128964863*w*y - 
     0.7813024128964863*lnbara*w*y - 0.16399130575669638*y2 - 
     0.2186975871035137*lnbara*y2 + 0.25*lnbara2*y2 - 
     1.3280463806552705*z + 2.*lnbara*z - 0.5*lnbara2*z - 
     1.0352774262847895*u*z - 0.7813024128964863*lnbara*u*z + 
     1.7363044156749696*v*z - 0.7813024128964863*w*z - 
     0.7813024128964863*lnbara*w*z + 1.7363044156749696*y*z - 
     0.16399130575669638*z2 - 0.2186975871035137*lnbara*z2 + 
     0.25*lnbara2*z2;
 
  Gexp[3] = 2.161379713988604 - 2.6666666666666665*lnbara + 0.5*lnbara2 - 
     1.6640231903276352*u + 1.5*lnbara*u - 0.25*lnbara2*u + 
     0.05470628134681734*u2 - 0.7186975871035137*lnbara*u2 + 
     0.25*lnbara2*u2 + 0.09882698433854777*u3 + 0.12845475125672678*lnbara*
      u3 - 0.08333333333333333*lnbara2*u3 - 1.6640231903276352*v + 
     1.5*lnbara*v - 0.25*lnbara2*v + 1.7363044156749696*u*v - 
     0.30106209007612295*u2*v + 0.05470628134681734*v2 - 
     0.7186975871035137*lnbara*v2 + 0.25*lnbara2*v2 - 
     0.30106209007612295*u*v2 + 0.09882698433854777*v3 + 
     0.12845475125672678*lnbara*v3 - 0.08333333333333333*lnbara2*v3 + 
     0.17195361934472944*w + 2.*lnbara*w - 0.5*lnbara2*w - 
     0.7813024128964863*lnbara*u*w + 0.11844729853083825*u2*w + 
     0.16666666666666666*lnbara*u2*w - 0.7813024128964863*lnbara*v*w - 
     0.20253427433816312*u*v*w + 0.11844729853083825*v2*w + 
     0.16666666666666666*lnbara*v2*w - 0.17195361934472944*w2 - 
     0.4373951742070274*lnbara*w2 + 0.5*lnbara2*w2 + 
     0.057317873114909816*u*w2 + 0.16666666666666666*lnbara*u*w2 + 
     0.057317873114909816*v*w2 + 0.16666666666666666*lnbara*v*w2 - 
     0.01910595770496994*w3 - 0.07642383081987976*lnbara*w3 - 
     0.16666666666666666*lnbara2*w3 - 1.6640231903276352*y + 1.5*lnbara*y - 
     0.25*lnbara2*y + 1.7363044156749696*u*y - 0.30106209007612295*u2*y - 
     0.2539750133883032*v*y - 0.7813024128964863*lnbara*v*y - 
     0.16476089051615736*u*v*y + 0.13248964725894694*v2*y + 
     0.16666666666666666*lnbara*v2*y - 0.7813024128964863*lnbara*w*y - 
     0.20253427433816312*u*w*y + 0.053538205384830104*v*w*y + 
     0.11463574622981963*lnbara*v*w*y + 0.057317873114909816*w2*y + 
     0.16666666666666666*lnbara*w2*y + 0.05470628134681734*y2 - 
     0.7186975871035137*lnbara*y2 + 0.25*lnbara2*y2 - 
     0.30106209007612295*u*y2 + 0.13248964725894694*v*y2 + 
     0.16666666666666666*lnbara*v*y2 + 0.11844729853083825*w*y2 + 
     0.16666666666666666*lnbara*w*y2 + 0.09882698433854777*y3 + 
     0.12845475125672678*lnbara*y3 - 0.08333333333333333*lnbara2*y3 - 
     1.6640231903276352*z + 1.5*lnbara*z - 0.25*lnbara2*z - 
     0.2539750133883032*u*z - 0.7813024128964863*lnbara*u*z + 
     0.13248964725894694*u2*z + 0.16666666666666666*lnbara*u2*z + 
     1.7363044156749696*v*z - 0.16476089051615736*u*v*z - 
     0.30106209007612295*v2*z - 0.7813024128964863*lnbara*w*z + 
     0.053538205384830104*u*w*z + 0.11463574622981963*lnbara*u*w*z - 
     0.20253427433816312*v*w*z + 0.057317873114909816*w2*z + 
     0.16666666666666666*lnbara*w2*z + 1.7363044156749696*y*z - 
     0.16476089051615736*u*y*z - 0.16476089051615736*v*y*z - 
     0.20253427433816312*w*y*z - 0.30106209007612295*y2*z + 
     0.05470628134681734*z2 - 0.7186975871035137*lnbara*z2 + 
     0.25*lnbara2*z2 + 0.13248964725894694*u*z2 + 
     0.16666666666666666*lnbara*u*z2 - 0.30106209007612295*v*z2 + 
     0.11844729853083825*w*z2 + 0.16666666666666666*lnbara*w*z2 - 
     0.30106209007612295*y*z2 + 0.09882698433854777*z3 + 
     0.12845475125672678*lnbara*z3 - 0.08333333333333333*lnbara2*z3;
 
  Gexp[4] = 1.7473565236609687 - 1.5833333333333333*lnbara + 0.25*lnbara2 - 
     1.6093487935517568*u + 1.1666666666666667*lnbara*u - 
     0.16666666666666666*lnbara2*u + 0.4140550748985742*u2 - 
     0.9686975871035137*lnbara*u2 + 0.25*lnbara2*u2 + 
     0.06919921742036875*u3 + 0.42357616918012025*lnbara*u3 - 
     0.16666666666666666*lnbara2*u3 - 0.05265271615074063*u4 - 
     0.07174761194892897*lnbara*u4 + 0.041666666666666664*lnbara2*u4 - 
     1.6093487935517568*v + 1.1666666666666667*lnbara*v - 
     0.16666666666666666*lnbara2*v + 1.7363044156749696*u*v - 
     0.6021241801522459*u2*v + 0.11595103369494308*u3*v + 
     0.4140550748985742*v2 - 0.9686975871035137*lnbara*v2 + 
     0.25*lnbara2*v2 - 0.6021241801522459*u*v2 + 
     0.059716839228361955*u2*v2 + 0.06919921742036875*v3 + 
     0.42357616918012025*lnbara*v3 - 0.16666666666666666*lnbara2*v3 + 
     0.11595103369494308*u*v3 - 0.05265271615074063*v4 - 
     0.07174761194892897*lnbara*v4 + 0.041666666666666664*lnbara2*v4 - 
     0.552030920436847*w + 1.6666666666666667*lnbara*w - 
     0.3333333333333333*lnbara2*w + 0.39065120644824314*u*w - 
     0.7813024128964863*lnbara*u*w + 0.07022793039500985*u2*w + 
     0.3333333333333333*lnbara*u2*w - 0.04387086136102624*u3*w - 
     0.06829286069220218*lnbara*u3*w + 0.39065120644824314*v*w - 
     0.7813024128964863*lnbara*v*w - 0.40506854867632625*u*v*w + 
     0.050239513929349555*u2*v*w + 0.07022793039500985*v2*w + 
     0.3333333333333333*lnbara*v2*w + 0.050239513929349555*u*v2*w - 
     0.04387086136102624*v3*w - 0.06829286069220218*lnbara*v3*w + 
     0.046743967758784255*w2 - 0.9373951742070274*lnbara*w2 + 
     0.5*lnbara2*w2 - 0.05203092043684704*u*w2 + 
     0.3333333333333333*lnbara*u*w2 - 0.012964544309194878*u2*w2 - 
     0.045121417923393456*lnbara*u2*w2 - 0.05203092043684704*v*w2 + 
     0.3333333333333333*lnbara*v*w2 + 0.06270564403669335*u*v*w2 - 
     0.012964544309194878*v2*w2 - 0.045121417923393456*lnbara*v2*w2 + 
     0.03821191540993988*w3 + 0.18048567169357382*lnbara*w3 - 
     0.3333333333333333*lnbara2*w3 - 0.012737305136646625*u*w3 - 
     0.06829286069220218*lnbara*u*w3 - 0.012737305136646625*v*w3 - 
     0.06829286069220218*lnbara*v*w3 + 0.0031843262841616564*w4 + 
     0.023171442768808725*lnbara*w4 + 0.08333333333333333*lnbara2*w4 - 
     1.6093487935517568*y + 1.1666666666666667*lnbara*y - 
     0.16666666666666666*lnbara2*y + 1.7363044156749696*u*y - 
     0.6021241801522459*u2*y + 0.11595103369494308*u3*y + 
     0.13667619305993997*v*y - 0.7813024128964863*lnbara*v*y - 
     0.3295217810323147*u*v*y + 0.03780687567263677*u2*v*y + 
     0.09831262785122723*v2*y + 0.3333333333333333*lnbara*v2*y + 
     0.04679101100870634*u*v2*y - 0.04661955884626616*v3*y - 
     0.06829286069220218*lnbara*v3*y + 0.39065120644824314*w*y - 
     0.7813024128964863*lnbara*w*y - 0.40506854867632625*u*w*y + 
     0.050239513929349555*u2*w*y - 0.007559335460159426*v*w*y + 
     0.22927149245963926*lnbara*v*w*y + 0.03934960244277067*u*v*w*y - 
     0.013165285552240471*v2*w*y - 0.03821191540993988*lnbara*v2*w*y - 
     0.05203092043684704*w2*y + 0.3333333333333333*lnbara*w2*y + 
     0.06270564403669335*u*w2*y - 0.009239363608210014*v*w2*y - 
     0.03821191540993988*lnbara*v*w2*y - 0.012737305136646625*w3*y - 
     0.06829286069220218*lnbara*w3*y + 0.4140550748985742*y2 - 
     0.9686975871035137*lnbara*y2 + 0.25*lnbara2*y2 - 
     0.6021241801522459*u*y2 + 0.059716839228361955*u2*y2 + 
     0.09831262785122723*v*y2 + 0.3333333333333333*lnbara*v*y2 + 
     0.04679101100870634*u*v*y2 - 0.01943534388880048*v2*y2 - 
     0.045121417923393456*lnbara*v2*y2 + 0.07022793039500985*w*y2 + 
     0.3333333333333333*lnbara*w*y2 + 0.050239513929349555*u*w*y2 - 
     0.013165285552240471*v*w*y2 - 0.03821191540993988*lnbara*v*w*y2 - 
     0.012964544309194878*w2*y2 - 0.045121417923393456*lnbara*w2*y2 + 
     0.06919921742036875*y3 + 0.42357616918012025*lnbara*y3 - 
     0.16666666666666666*lnbara2*y3 + 0.11595103369494308*u*y3 - 
     0.04661955884626616*v*y3 - 0.06829286069220218*lnbara*v*y3 - 
     0.04387086136102624*w*y3 - 0.06829286069220218*lnbara*w*y3 - 
     0.05265271615074063*y4 - 0.07174761194892897*lnbara*y4 + 
     0.041666666666666664*lnbara2*y4 - 1.6093487935517568*z + 
     1.1666666666666667*lnbara*z - 0.16666666666666666*lnbara2*z + 
     0.13667619305993997*u*z - 0.7813024128964863*lnbara*u*z + 
     0.09831262785122723*u2*z + 0.3333333333333333*lnbara*u2*z - 
     0.04661955884626616*u3*z - 0.06829286069220218*lnbara*u3*z + 
     1.7363044156749696*v*z - 0.3295217810323147*u*v*z + 
     0.04679101100870634*u2*v*z - 0.6021241801522459*v2*z + 
     0.03780687567263677*u*v2*z + 0.11595103369494308*v3*z + 
     0.39065120644824314*w*z - 0.7813024128964863*lnbara*w*z - 
     0.007559335460159426*u*w*z + 0.22927149245963926*lnbara*u*w*z - 
     0.013165285552240471*u2*w*z - 0.03821191540993988*lnbara*u2*w*z - 
     0.40506854867632625*v*w*z + 0.03934960244277067*u*v*w*z + 
     0.050239513929349555*v2*w*z - 0.05203092043684704*w2*z + 
     0.3333333333333333*lnbara*w2*z - 0.009239363608210014*u*w2*z - 
     0.03821191540993988*lnbara*u*w2*z + 0.06270564403669335*v*w2*z - 
     0.012737305136646625*w3*z - 0.06829286069220218*lnbara*w3*z + 
     1.7363044156749696*y*z - 0.3295217810323147*u*y*z + 
     0.04679101100870634*u2*y*z - 0.3295217810323147*v*y*z + 
     0.02739438320944513*u*v*y*z + 0.04679101100870634*v2*y*z - 
     0.40506854867632625*w*y*z + 0.03934960244277067*u*w*y*z + 
     0.03934960244277067*v*w*y*z + 0.06270564403669335*w2*y*z - 
     0.6021241801522459*y2*z + 0.03780687567263677*u*y2*z + 
     0.04679101100870634*v*y2*z + 0.050239513929349555*w*y2*z + 
     0.11595103369494308*y3*z + 0.4140550748985742*z2 - 
     0.9686975871035137*lnbara*z2 + 0.25*lnbara2*z2 + 
     0.09831262785122723*u*z2 + 0.3333333333333333*lnbara*u*z2 - 
     0.01943534388880048*u2*z2 - 0.045121417923393456*lnbara*u2*z2 - 
     0.6021241801522459*v*z2 + 0.04679101100870634*u*v*z2 + 
     0.059716839228361955*v2*z2 + 0.07022793039500985*w*z2 + 
     0.3333333333333333*lnbara*w*z2 - 0.013165285552240471*u*w*z2 - 
     0.03821191540993988*lnbara*u*w*z2 + 0.050239513929349555*v*w*z2 - 
     0.012964544309194878*w2*z2 - 0.045121417923393456*lnbara*w2*z2 - 
     0.6021241801522459*y*z2 + 0.04679101100870634*u*y*z2 + 
     0.03780687567263677*v*y*z2 + 0.050239513929349555*w*y*z2 + 
     0.059716839228361955*y2*z2 + 0.06919921742036875*z3 + 
     0.42357616918012025*lnbara*z3 - 0.16666666666666666*lnbara2*z3 - 
     0.04661955884626616*u*z3 - 0.06829286069220218*lnbara*u*z3 + 
     0.11595103369494308*v*z3 - 0.04387086136102624*w*z3 - 
     0.06829286069220218*lnbara*w*z3 + 0.11595103369494308*y*z3 - 
     0.05265271615074063*z4 - 0.07174761194892897*lnbara*z4 + 
     0.041666666666666664*lnbara2*z4;
 
  Gexp[5] = 1.3650805808632478 - 1.05*lnbara + 0.15*lnbara2 - 
     1.4986782618304844*u + 0.9583333333333334*lnbara*u - 0.125*lnbara2*u + 
     0.7369542705997454*u2 - 1.1353642537701805*lnbara*u2 + 
     0.25*lnbara2*u2 - 0.107989258459507*u3 + 0.802030920436847*lnbara*
      u3 - 0.25*lnbara2*u3 - 0.08621053650329293*u4 - 
     0.29857616918012025*lnbara*u4 + 0.125*lnbara2*u4 + 
     0.03227341274192837*u5 + 0.0450539635215082*lnbara*u5 - 
     0.025*lnbara2*u5 - 1.4986782618304844*v + 0.9583333333333334*lnbara*
      v - 0.125*lnbara2*v + 1.7363044156749696*u*v - 
     0.9031862702283687*u2*v + 0.34785310108482925*u3*v - 
     0.06059652683278195*u4*v + 0.7369542705997454*v2 - 
     1.1353642537701805*lnbara*v2 + 0.25*lnbara2*v2 - 
     0.9031862702283687*u*v2 + 0.17915051768508586*u2*v2 - 
     0.0237971369540094*u3*v2 - 0.107989258459507*v3 + 
     0.802030920436847*lnbara*v3 - 0.25*lnbara2*v3 + 
     0.34785310108482925*u*v3 - 0.0237971369540094*u2*v3 - 
     0.08621053650329293*v4 - 0.29857616918012025*lnbara*v4 + 
     0.125*lnbara2*v4 - 0.06059652683278195*u*v4 + 
     0.03227341274192837*v5 + 0.0450539635215082*lnbara*v5 - 
     0.025*lnbara2*v5 - 0.830689856994302*w + 1.4166666666666667*lnbara*w - 
     0.25*lnbara2*w + 0.6510853440804052*u*w - 0.7813024128964863*lnbara*u*
      w - 0.0613247710741519*u2*w + 0.5*lnbara*u2*w - 
     0.06331972339087655*u3*w - 0.20487858207660653*lnbara*u3*w + 
     0.022557055760128716*u4*w + 0.03665317578628961*lnbara*u4*w + 
     0.6510853440804052*v*w - 0.7813024128964863*lnbara*v*w - 
     0.6076028230144893*u*v*w + 0.15071854178804867*u2*v*w - 
     0.02150184968349584*u3*v*w - 0.0613247710741519*v2*w + 
     0.5*lnbara*v2*w + 0.15071854178804867*u*v2*w - 
     0.013018552693696988*u2*v2*w - 0.06331972339087655*v3*w - 
     0.20487858207660653*lnbara*v3*w - 0.02150184968349584*u*v3*w + 
     0.022557055760128716*v4*w + 0.03665317578628961*lnbara*v4*w + 
     0.3592090258277934*w2 - 1.2707285075403607*lnbara*w2 + 
     0.5*lnbara2*w2 - 0.24471304732193722*u*w2 + 0.5*lnbara*u*w2 + 
     0.006227784995808821*u2*w2 - 0.13536425377018038*lnbara*u2*w2 + 
     0.005325806143638784*u3*w2 + 0.020053963521508202*lnbara*u3*w2 - 
     0.24471304732193722*v*w2 + 0.5*lnbara*v*w2 + 
     0.18811693211008002*u*v*w2 - 0.017655955408877412*u2*v*w2 + 
     0.006227784995808821*v2*w2 - 0.13536425377018038*lnbara*v2*w2 - 
     0.017655955408877412*u*v2*w2 + 0.005325806143638784*v3*w2 + 
     0.020053963521508202*lnbara*v3*w2 - 0.032924962731877096*w3 + 
     0.6040618408736941*lnbara*w3 - 0.5*lnbara2*w3 + 
     0.030080945282262305*u*w3 - 0.20487858207660653*lnbara*u*w3 + 
     0.0033646110897693924*u2*w3 + 0.020053963521508202*lnbara*u2*w3 + 
     0.030080945282262305*v*w3 - 0.20487858207660653*lnbara*v*w3 - 
     0.028872460828119215*u*v*w3 + 0.0033646110897693924*v2*w3 + 
     0.020053963521508202*lnbara*v2*w3 - 0.013618463916323756*w4 - 
     0.0971523383602405*lnbara*w4 + 0.25*lnbara2*w4 + 
     0.0045394879721079185*u*w4 + 0.03665317578628961*lnbara*u*w4 + 
     0.0045394879721079185*v*w4 + 0.03665317578628961*lnbara*v*w4 - 
     0.0009078975944215837*w5 - 0.009892072956983595*lnbara*w5 - 
     0.05*lnbara2*w5 - 1.4986782618304844*y + 0.9583333333333334*lnbara*y - 
     0.125*lnbara2*y + 1.7363044156749696*u*y - 0.9031862702283687*u2*y + 
     0.34785310108482925*u3*y - 0.06059652683278195*u4*y + 
     0.39711033069210205*v*y - 0.7813024128964863*lnbara*v*y - 
     0.49428267154847205*u*v*y + 0.11342062701791031*u2*v*y - 
     0.01565521245743462*u3*v*y - 0.019197724889825834*v2*y + 
     0.5*lnbara*v2*y + 0.14037303302611903*u*v2*y - 
     0.011674571633666243*u2*v2*y - 0.0715658158465963*v3*y - 
     0.20487858207660653*lnbara*v3*y - 0.02071565770475219*u*v3*y + 
     0.023479470699086277*v4*y + 0.03665317578628961*lnbara*v4*y + 
     0.6510853440804052*w*y - 0.7813024128964863*lnbara*w*y - 
     0.6076028230144893*u*w*y + 0.15071854178804867*u2*w*y - 
     0.02150184968349584*u3*w*y - 0.12597474942005876*v*w*y + 
     0.3439072386894589*lnbara*v*w*y + 0.11804880732831201*u*v*w*y - 
     0.01059794141127439*u2*v*w*y - 0.001283941246781538*v2*w*y - 
     0.11463574622981963*lnbara*v2*w*y - 0.01426603512113796*u*v2*w*y + 
     0.005443587430075787*v3*w*y + 0.018157951888431674*lnbara*v3*w*y - 
     0.24471304732193722*w2*y + 0.5*lnbara*w2*y + 
     0.18811693211008002*u*w2*y - 0.017655955408877412*u2*w2*y + 
     0.010493824585309836*v*w2*y - 0.11463574622981963*lnbara*v*w2*y - 
     0.015437863995106367*u*v*w2*y + 0.0030128741217214736*v2*w2*y + 
     0.015040472641131153*lnbara*v2*w2*y + 0.030080945282262305*w3*y - 
     0.20487858207660653*lnbara*w3*y - 0.028872460828119215*u*w3*y + 
     0.002776802306005667*v*w3*y + 0.018157951888431674*lnbara*v*w3*y + 
     0.0045394879721079185*w4*y + 0.03665317578628961*lnbara*w4*y + 
     0.7369542705997454*y2 - 1.1353642537701805*lnbara*y2 + 
     0.25*lnbara2*y2 - 0.9031862702283687*u*y2 + 
     0.17915051768508586*u2*y2 - 0.0237971369540094*u3*y2 - 
     0.019197724889825834*v*y2 + 0.5*lnbara*v*y2 + 
     0.14037303302611903*u*v*y2 - 0.011674571633666243*u2*v*y2 - 
     0.013184613743007976*v2*y2 - 0.13536425377018038*lnbara*v2*y2 - 
     0.015726059911862465*u*v2*y2 + 0.006817830514839888*v3*y2 + 
     0.020053963521508202*lnbara*v3*y2 - 0.0613247710741519*w*y2 + 
     0.5*lnbara*w*y2 + 0.15071854178804867*u*w*y2 - 
     0.013018552693696988*u2*w*y2 - 0.001283941246781538*v*w*y2 - 
     0.11463574622981963*lnbara*v*w*y2 - 0.01426603512113796*u*v*w*y2 + 
     0.0037297504776935757*v2*w*y2 + 0.015040472641131153*lnbara*v2*w*
      y2 + 0.006227784995808821*w2*y2 - 0.13536425377018038*lnbara*w2*
      y2 - 0.017655955408877412*u*w2*y2 + 0.0030128741217214736*v*w2*
      y2 + 0.015040472641131153*lnbara*v*w2*y2 + 
     0.0033646110897693924*w3*y2 + 0.020053963521508202*lnbara*w3*y2 - 
     0.107989258459507*y3 + 0.802030920436847*lnbara*y3 - 
     0.25*lnbara2*y3 + 0.34785310108482925*u*y3 - 
     0.0237971369540094*u2*y3 - 0.0715658158465963*v*y3 - 
     0.20487858207660653*lnbara*v*y3 - 0.02071565770475219*u*v*y3 + 
     0.006817830514839888*v2*y3 + 0.020053963521508202*lnbara*v2*y3 - 
     0.06331972339087655*w*y3 - 0.20487858207660653*lnbara*w*y3 - 
     0.02150184968349584*u*w*y3 + 0.005443587430075787*v*w*y3 + 
     0.018157951888431674*lnbara*v*w*y3 + 0.005325806143638784*w2*y3 + 
     0.020053963521508202*lnbara*w2*y3 - 0.08621053650329293*y4 - 
     0.29857616918012025*lnbara*y4 + 0.125*lnbara2*y4 - 
     0.06059652683278195*u*y4 + 0.023479470699086277*v*y4 + 
     0.03665317578628961*lnbara*v*y4 + 0.022557055760128716*w*y4 + 
     0.03665317578628961*lnbara*w*y4 + 0.03227341274192837*y5 + 
     0.0450539635215082*lnbara*y5 - 0.025*lnbara2*y5 - 
     1.4986782618304844*z + 0.9583333333333334*lnbara*z - 0.125*lnbara2*z + 
     0.39711033069210205*u*z - 0.7813024128964863*lnbara*u*z - 
     0.019197724889825834*u2*z + 0.5*lnbara*u2*z - 
     0.0715658158465963*u3*z - 0.20487858207660653*lnbara*u3*z + 
     0.023479470699086277*u4*z + 0.03665317578628961*lnbara*u4*z + 
     1.7363044156749696*v*z - 0.49428267154847205*u*v*z + 
     0.14037303302611903*u2*v*z - 0.02071565770475219*u3*v*z - 
     0.9031862702283687*v2*z + 0.11342062701791031*u*v2*z - 
     0.011674571633666243*u2*v2*z + 0.34785310108482925*v3*z - 
     0.01565521245743462*u*v3*z - 0.06059652683278195*v4*z + 
     0.6510853440804052*w*z - 0.7813024128964863*lnbara*w*z - 
     0.12597474942005876*u*w*z + 0.3439072386894589*lnbara*u*w*z - 
     0.001283941246781538*u2*w*z - 0.11463574622981963*lnbara*u2*w*z + 
     0.005443587430075787*u3*w*z + 0.018157951888431674*lnbara*u3*w*z - 
     0.6076028230144893*v*w*z + 0.11804880732831201*u*v*w*z - 
     0.01426603512113796*u2*v*w*z + 0.15071854178804867*v2*w*z - 
     0.01059794141127439*u*v2*w*z - 0.02150184968349584*v3*w*z - 
     0.24471304732193722*w2*z + 0.5*lnbara*w2*z + 
     0.010493824585309836*u*w2*z - 0.11463574622981963*lnbara*u*w2*z + 
     0.0030128741217214736*u2*w2*z + 0.015040472641131153*lnbara*u2*w2*
      z + 0.18811693211008002*v*w2*z - 0.015437863995106367*u*v*w2*z - 
     0.017655955408877412*v2*w2*z + 0.030080945282262305*w3*z - 
     0.20487858207660653*lnbara*w3*z + 0.002776802306005667*u*w3*z + 
     0.018157951888431674*lnbara*u*w3*z - 0.028872460828119215*v*w3*z + 
     0.0045394879721079185*w4*z + 0.03665317578628961*lnbara*w4*z + 
     1.7363044156749696*y*z - 0.49428267154847205*u*y*z + 
     0.14037303302611903*u2*y*z - 0.02071565770475219*u3*y*z - 
     0.49428267154847205*v*y*z + 0.08218314962833538*u*v*y*z - 
     0.009158761699667091*u2*v*y*z + 0.14037303302611903*v2*y*z - 
     0.009158761699667091*u*v2*y*z - 0.02071565770475219*v3*y*z - 
     0.6076028230144893*w*y*z + 0.11804880732831201*u*w*y*z - 
     0.01426603512113796*u2*w*y*z + 0.11804880732831201*v*w*y*z - 
     0.008913056030998658*u*v*w*y*z - 0.01426603512113796*v2*w*y*z + 
     0.18811693211008002*w2*y*z - 0.015437863995106367*u*w2*y*z - 
     0.015437863995106367*v*w2*y*z - 0.028872460828119215*w3*y*z - 
     0.9031862702283687*y2*z + 0.11342062701791031*u*y2*z - 
     0.011674571633666243*u2*y2*z + 0.14037303302611903*v*y2*z - 
     0.009158761699667091*u*v*y2*z - 0.015726059911862465*v2*y2*z + 
     0.15071854178804867*w*y2*z - 0.01059794141127439*u*w*y2*z - 
     0.01426603512113796*v*w*y2*z - 0.017655955408877412*w2*y2*z + 
     0.34785310108482925*y3*z - 0.01565521245743462*u*y3*z - 
     0.02071565770475219*v*y3*z - 0.02150184968349584*w*y3*z - 
     0.06059652683278195*y4*z + 0.7369542705997454*z2 - 
     1.1353642537701805*lnbara*z2 + 0.25*lnbara2*z2 - 
     0.019197724889825834*u*z2 + 0.5*lnbara*u*z2 - 
     0.013184613743007976*u2*z2 - 0.13536425377018038*lnbara*u2*z2 + 
     0.006817830514839888*u3*z2 + 0.020053963521508202*lnbara*u3*z2 - 
     0.9031862702283687*v*z2 + 0.14037303302611903*u*v*z2 - 
     0.015726059911862465*u2*v*z2 + 0.17915051768508586*v2*z2 - 
     0.011674571633666243*u*v2*z2 - 0.0237971369540094*v3*z2 - 
     0.0613247710741519*w*z2 + 0.5*lnbara*w*z2 - 0.001283941246781538*u*w*
      z2 - 0.11463574622981963*lnbara*u*w*z2 + 0.0037297504776935757*u2*w*
      z2 + 0.015040472641131153*lnbara*u2*w*z2 + 
     0.15071854178804867*v*w*z2 - 0.01426603512113796*u*v*w*z2 - 
     0.013018552693696988*v2*w*z2 + 0.006227784995808821*w2*z2 - 
     0.13536425377018038*lnbara*w2*z2 + 0.0030128741217214736*u*w2*z2 + 
     0.015040472641131153*lnbara*u*w2*z2 - 0.017655955408877412*v*w2*z2 + 
     0.0033646110897693924*w3*z2 + 0.020053963521508202*lnbara*w3*z2 - 
     0.9031862702283687*y*z2 + 0.14037303302611903*u*y*z2 - 
     0.015726059911862465*u2*y*z2 + 0.11342062701791031*v*y*z2 - 
     0.009158761699667091*u*v*y*z2 - 0.011674571633666243*v2*y*z2 + 
     0.15071854178804867*w*y*z2 - 0.01426603512113796*u*w*y*z2 - 
     0.01059794141127439*v*w*y*z2 - 0.017655955408877412*w2*y*z2 + 
     0.17915051768508586*y2*z2 - 0.011674571633666243*u*y2*z2 - 
     0.011674571633666243*v*y2*z2 - 0.013018552693696988*w*y2*z2 - 
     0.0237971369540094*y3*z2 - 0.107989258459507*z3 + 
     0.802030920436847*lnbara*z3 - 0.25*lnbara2*z3 - 
     0.0715658158465963*u*z3 - 0.20487858207660653*lnbara*u*z3 + 
     0.006817830514839888*u2*z3 + 0.020053963521508202*lnbara*u2*z3 + 
     0.34785310108482925*v*z3 - 0.02071565770475219*u*v*z3 - 
     0.0237971369540094*v2*z3 - 0.06331972339087655*w*z3 - 
     0.20487858207660653*lnbara*w*z3 + 0.005443587430075787*u*w*z3 + 
     0.018157951888431674*lnbara*u*w*z3 - 0.02150184968349584*v*w*z3 + 
     0.005325806143638784*w2*z3 + 0.020053963521508202*lnbara*w2*z3 + 
     0.34785310108482925*y*z3 - 0.02071565770475219*u*y*z3 - 
     0.01565521245743462*v*y*z3 - 0.02150184968349584*w*y*z3 - 
     0.0237971369540094*y2*z3 - 0.08621053650329293*z4 - 
     0.29857616918012025*lnbara*z4 + 0.125*lnbara2*z4 + 
     0.023479470699086277*u*z4 + 0.03665317578628961*lnbara*u*z4 - 
     0.06059652683278195*v*z4 + 0.022557055760128716*w*z4 + 
     0.03665317578628961*lnbara*w*z4 - 0.06059652683278195*y*z4 + 
     0.03227341274192837*z5 + 0.0450539635215082*lnbara*z5 - 
     0.025*lnbara2*z5;
 
  Gexp[6] = 1.0850537205754986 - 0.75*lnbara + 0.1*lnbara2 - 
     1.390609276131054*u + 0.8166666666666667*lnbara*u - 0.1*lnbara2*u + 
     1.0207953340422906*u2 - 1.2603642537701805*lnbara*u2 + 
     0.25*lnbara2*u2 - 0.411329318091625*u3 + 1.2360412272491295*lnbara*
      u3 - 0.3333333333333333*lnbara2*u3 - 0.02313298841652572*u4 - 
     0.7221523383602405*lnbara*u4 + 0.25*lnbara2*u4 + 
     0.08403968744620527*u5 + 0.23021585408603282*lnbara*u5 - 
     0.1*lnbara2*u5 - 0.021741522654166835*u6 - 0.030781213381871893*
      lnbara*u6 + 0.016666666666666666*lnbara2*u6 - 1.390609276131054*v + 
     0.8166666666666667*lnbara*v - 0.1*lnbara2*v + 1.7363044156749696*u*v - 
     1.2042483603044918*u2*v + 0.6957062021696585*u3*v - 
     0.2423861073311278*u4*v + 0.037105667100660746*u5*v + 
     1.0207953340422906*v2 - 1.2603642537701805*lnbara*v2 + 
     0.25*lnbara2*v2 - 1.2042483603044918*u*v2 + 
     0.3583010353701717*u2*v2 - 0.0951885478160376*u3*v2 + 
     0.012603690943738541*u4*v2 - 0.411329318091625*v3 + 
     1.2360412272491295*lnbara*v3 - 0.3333333333333333*lnbara2*v3 + 
     0.6957062021696585*u*v3 - 0.0951885478160376*u2*v3 + 
     0.009594503638373669*u3*v3 - 0.02313298841652572*v4 - 
     0.7221523383602405*lnbara*v4 + 0.25*lnbara2*v4 - 
     0.2423861073311278*u*v4 + 0.012603690943738541*u2*v4 + 
     0.08403968744620527*v5 + 0.23021585408603282*lnbara*v5 - 
     0.1*lnbara2*v5 + 0.037105667100660746*u*v5 - 
     0.021741522654166835*v6 - 0.030781213381871893*lnbara*v6 + 
     0.016666666666666666*lnbara2*v6 - 0.9478852189287749*w + 
     1.2333333333333334*lnbara*w - 0.2*lnbara2*w + 0.8464109473045268*u*w - 
     0.7813024128964863*lnbara*u*w - 0.2484330280988692*u2*w + 
     0.6666666666666666*lnbara*u2*w - 0.02420015574344982*u3*w - 
     0.40975716415321306*lnbara*u3*w + 0.05357504725422525*u4*w + 
     0.14661270314515845*lnbara*u4*w - 0.013695633713123625*u5*w - 
     0.02276428689740073*lnbara*u5*w + 0.8464109473045268*v*w - 
     0.7813024128964863*lnbara*v*w - 0.8101370973526525*u*v*w + 
     0.30143708357609733*u2*v*w - 0.08600739873398336*u3*v*w + 
     0.011755626833308665*u4*v*w - 0.2484330280988692*v2*w + 
     0.6666666666666666*lnbara*v2*w + 0.30143708357609733*u*v2*w - 
     0.05207421077478795*u2*v2*w + 0.005666397839155122*u3*v2*w - 
     0.02420015574344982*v3*w - 0.40975716415321306*lnbara*v3*w - 
     0.08600739873398336*u*v3*w + 0.005666397839155122*u2*v3*w + 
     0.05357504725422525*v4*w + 0.14661270314515845*lnbara*v4*w + 
     0.011755626833308665*u*v4*w - 0.013695633713123625*v5*w - 
     0.02276428689740073*lnbara*v5*w + 0.6768911527128836*w2 - 
     1.5207285075403607*lnbara*w2 + 0.5*lnbara2*w2 - 
     0.492950729762583*u*w2 + 0.6666666666666666*lnbara*u*w2 + 
     0.08013769687670783*u2*w2 - 0.27072850754036076*lnbara*u2*w2 + 
     0.0012492610530469332*u3*w2 + 0.08021585408603281*lnbara*u3*w2 - 
     0.0028504812172850903*u4*w2 - 0.011178565512996366*lnbara*u4*w2 - 
     0.492950729762583*v*w2 + 0.6666666666666666*lnbara*v*w2 + 
     0.37623386422016003*u*v*w2 - 0.07062382163550965*u2*v*w2 + 
     0.007977294501053117*u3*v*w2 + 0.08013769687670783*v2*w2 - 
     0.27072850754036076*lnbara*v2*w2 - 0.07062382163550965*u*v2*w2 + 
     0.005057271046160232*u2*v2*w2 + 0.0012492610530469332*v3*w2 + 
     0.08021585408603281*lnbara*v3*w2 + 0.007977294501053117*u*v3*w2 - 
     0.0028504812172850903*v4*w2 - 0.011178565512996366*lnbara*v4*w2 - 
     0.24525389726706748*w3 + 1.1387491211649254*lnbara*w3 - 
     0.6666666666666666*lnbara2*w3 + 0.16260118160282788*u*w3 - 
     0.40975716415321306*lnbara*u*w3 - 0.0065955191624306325*u2*w3 + 
     0.08021585408603281*lnbara*u2*w3 - 0.0014691525048179737*u3*w3 - 
     0.009259259259259259*lnbara*u3*w3 + 0.16260118160282788*v*w3 - 
     0.40975716415321306*lnbara*v*w3 - 0.11548984331247686*u*v*w3 + 
     0.008605527574636129*u2*v*w3 - 0.0065955191624306325*v2*w3 + 
     0.08021585408603281*lnbara*v2*w3 + 0.008605527574636129*u*v2*w3 - 
     0.0014691525048179737*v3*w3 - 0.009259259259259259*lnbara*v3*w3 + 
     0.021339241347472736*w4 - 0.44430467672048096*lnbara*w4 + 
     0.5*lnbara2*w4 - 0.018495223897857942*u*w4 + 
     0.14661270314515845*lnbara*u*w4 - 0.0012913080119257936*u2*w4 - 
     0.011178565512996366*lnbara*u2*w4 - 0.018495223897857942*v*w4 + 
     0.14661270314515845*lnbara*v*w4 + 0.016324459572189313*u*v*w4 - 
     0.0012913080119257936*v2*w4 - 0.011178565512996366*lnbara*v2*w4 + 
     0.006260482579297259*w5 + 0.060431708172065626*lnbara*w5 - 
     0.2*lnbara2*w5 - 0.0020868275264324197*u*w5 - 
     0.02276428689740073*lnbara*u*w5 - 0.0020868275264324197*v*w5 - 
     0.02276428689740073*lnbara*v*w5 + 0.00034780458773873665*w6 + 
     0.0051042399029228806*lnbara*w6 + 0.03333333333333333*lnbara2*w6 - 
     1.390609276131054*y + 0.8166666666666667*lnbara*y - 0.1*lnbara2*y + 
     1.7363044156749696*u*y - 1.2042483603044918*u2*y + 
     0.6957062021696585*u3*y - 0.2423861073311278*u4*y + 
     0.037105667100660746*u5*y + 0.5924359339162236*v*y - 
     0.7813024128964863*lnbara*v*y - 0.6590435620646294*u*v*y + 
     0.22684125403582062*u2*v*y - 0.06262084982973848*u3*v*y + 
     0.008419189235014828*u4*v*y - 0.19226363318643444*v2*y + 
     0.6666666666666666*lnbara*v2*y + 0.28074606605223806*u*v2*y - 
     0.04669828653466497*u2*v2*y + 0.004986373961111605*u3*v2*y - 
     0.040692340654889324*v3*y - 0.40975716415321306*lnbara*v3*y - 
     0.08286263081900876*u*v3*y + 0.0053375013256957*u2*v3*y + 
     0.057264707010055496*v4*y + 0.14661270314515845*lnbara*v4*y + 
     0.01147557387202353*u*v4*y - 0.014106252009402123*v5*y - 
     0.02276428689740073*lnbara*v5*y + 0.8464109473045268*w*y - 
     0.7813024128964863*lnbara*w*y - 0.8101370973526525*u*w*y + 
     0.30143708357609733*u2*w*y - 0.08600739873398336*u3*w*y + 
     0.011755626833308665*u4*w*y - 0.282602078789898*v*w*y + 
     0.45854298491927853*lnbara*v*w*y + 0.23609761465662402*u*v*w*y - 
     0.04239176564509756*u2*v*w*y + 0.004682895552936569*u3*v*w*y + 
     0.054749990621346736*v2*w*y - 0.22927149245963926*lnbara*v2*w*y - 
     0.05706414048455184*u*v2*w*y + 0.003980640823768378*u2*v2*w*y + 
     0.003616397831871475*v3*w*y + 0.0726318075537267*lnbara*v3*w*y + 
     0.007014611167395649*u*v3*w*y - 0.002907169920654274*v4*w*y - 
     0.010434137632162098*lnbara*v4*w*y - 0.492950729762583*w2*y + 
     0.6666666666666666*lnbara*w2*y + 0.37623386422016003*u*w2*y - 
     0.07062382163550965*u2*w2*y + 0.007977294501053117*u3*w2*y + 
     0.07830552228552949*v*w2*y - 0.22927149245963926*lnbara*v*w2*y - 
     0.06175145598042547*u*v*w2*y + 0.004484885221839508*u2*v*w2*y - 
     0.002988976154245258*v2*w2*y + 0.06016189056452461*lnbara*v2*w2*y + 
     0.006275928094281939*u*v2*w2*y - 0.0013944676715588855*v3*w2*y - 
     0.007723814256269575*lnbara*v3*w2*y + 0.16260118160282788*w3*y - 
     0.40975716415321306*lnbara*w3*y - 0.11548984331247686*u*w3*y + 
     0.008605527574636129*u2*w3*y - 0.007050742664409005*v*w3*y + 
     0.0726318075537267*lnbara*v*w3*y + 0.00788494736258755*u*v*w3*y - 
     0.0010428464246845287*v2*w3*y - 0.007723814256269575*lnbara*v2*w3*
      y - 0.018495223897857942*w4*y + 0.14661270314515845*lnbara*w4*y + 
     0.016324459572189313*u*w4*y - 0.001136941590506995*v*w4*y - 
     0.010434137632162098*lnbara*v*w4*y - 0.0020868275264324197*w5*y - 
     0.02276428689740073*lnbara*w5*y + 1.0207953340422906*y2 - 
     1.2603642537701805*lnbara*y2 + 0.25*lnbara2*y2 - 
     1.2042483603044918*u*y2 + 0.3583010353701717*u2*y2 - 
     0.0951885478160376*u3*y2 + 0.012603690943738541*u4*y2 - 
     0.19226363318643444*v*y2 + 0.6666666666666666*lnbara*v*y2 + 
     0.28074606605223806*u*v*y2 - 0.04669828653466497*u2*v*y2 + 
     0.004986373961111605*u3*v*y2 + 0.04131289939907423*v2*y2 - 
     0.27072850754036076*lnbara*v2*y2 - 0.06290423964744986*u*v2*y2 + 
     0.004230734800403052*u2*v2*y2 + 0.0072173585378513495*v3*y2 + 
     0.08021585408603281*lnbara*v3*y2 + 0.0074775100099156964*u*v3*y2 - 
     0.003388712393218835*v4*y2 - 0.011178565512996366*lnbara*v4*y2 - 
     0.2484330280988692*w*y2 + 0.6666666666666666*lnbara*w*y2 + 
     0.30143708357609733*u*w*y2 - 0.05207421077478795*u2*w*y2 + 
     0.005666397839155122*u3*w*y2 + 0.054749990621346736*v*w*y2 - 
     0.22927149245963926*lnbara*v*w*y2 - 0.05706414048455184*u*v*w*y2 + 
     0.003980640823768378*u2*v*w*y2 - 0.00012147073035684983*v2*w*y2 + 
     0.06016189056452461*lnbara*v2*w*y2 + 0.006028211949364472*u*v2*w*
      y2 - 0.0016140025704639528*v3*w*y2 - 0.007723814256269575*lnbara*v3*
      w*y2 + 0.08013769687670783*w2*y2 - 0.27072850754036076*lnbara*w2*
      y2 - 0.07062382163550965*u*w2*y2 + 0.005057271046160232*u2*w2*
      y2 - 0.002988976154245258*v*w2*y2 + 0.06016189056452461*lnbara*v*w2*
      y2 + 0.006275928094281939*u*v*w2*y2 - 0.0011254688727941888*v2*w2*
      y2 - 0.00690950251345358*lnbara*v2*w2*y2 - 
     0.0065955191624306325*w3*y2 + 0.08021585408603281*lnbara*w3*y2 + 
     0.008605527574636129*u*w3*y2 - 0.0010428464246845287*v*w3*y2 - 
     0.007723814256269575*lnbara*v*w3*y2 - 0.0012913080119257936*w4*y2 - 
     0.011178565512996366*lnbara*w4*y2 - 0.411329318091625*y3 + 
     1.2360412272491295*lnbara*y3 - 0.3333333333333333*lnbara2*y3 + 
     0.6957062021696585*u*y3 - 0.0951885478160376*u2*y3 + 
     0.009594503638373669*u3*y3 - 0.040692340654889324*v*y3 - 
     0.40975716415321306*lnbara*v*y3 - 0.08286263081900876*u*v*y3 + 
     0.0053375013256957*u2*v*y3 + 0.0072173585378513495*v2*y3 + 
     0.08021585408603281*lnbara*v2*y3 + 0.0074775100099156964*u*v2*y3 - 
     0.0023345088047811496*v3*y3 - 0.009259259259259259*lnbara*v3*y3 - 
     0.02420015574344982*w*y3 - 0.40975716415321306*lnbara*w*y3 - 
     0.08600739873398336*u*w*y3 + 0.005666397839155122*u2*w*y3 + 
     0.003616397831871475*v*w*y3 + 0.0726318075537267*lnbara*v*w*y3 + 
     0.007014611167395649*u*v*w*y3 - 0.0016140025704639528*v2*w*y3 - 
     0.007723814256269575*lnbara*v2*w*y3 + 0.0012492610530469332*w2*y3 + 
     0.08021585408603281*lnbara*w2*y3 + 0.007977294501053117*u*w2*y3 - 
     0.0013944676715588855*v*w2*y3 - 0.007723814256269575*lnbara*v*w2*
      y3 - 0.0014691525048179737*w3*y3 - 0.009259259259259259*lnbara*w3*
      y3 - 0.02313298841652572*y4 - 0.7221523383602405*lnbara*y4 + 
     0.25*lnbara2*y4 - 0.2423861073311278*u*y4 + 
     0.012603690943738541*u2*y4 + 0.057264707010055496*v*y4 + 
     0.14661270314515845*lnbara*v*y4 + 0.01147557387202353*u*v*y4 - 
     0.003388712393218835*v2*y4 - 0.011178565512996366*lnbara*v2*y4 + 
     0.05357504725422525*w*y4 + 0.14661270314515845*lnbara*w*y4 + 
     0.011755626833308665*u*w*y4 - 0.002907169920654274*v*w*y4 - 
     0.010434137632162098*lnbara*v*w*y4 - 0.0028504812172850903*w2*y4 - 
     0.011178565512996366*lnbara*w2*y4 + 0.08403968744620527*y5 + 
     0.23021585408603282*lnbara*y5 - 0.1*lnbara2*y5 + 
     0.037105667100660746*u*y5 - 0.014106252009402123*v*y5 - 
     0.02276428689740073*lnbara*v*y5 - 0.013695633713123625*w*y5 - 
     0.02276428689740073*lnbara*w*y5 - 0.021741522654166835*y6 - 
     0.030781213381871893*lnbara*y6 + 0.016666666666666666*lnbara2*y6 - 
     1.390609276131054*z + 0.8166666666666667*lnbara*z - 0.1*lnbara2*z + 
     0.5924359339162236*u*z - 0.7813024128964863*lnbara*u*z - 
     0.19226363318643444*u2*z + 0.6666666666666666*lnbara*u2*z - 
     0.040692340654889324*u3*z - 0.40975716415321306*lnbara*u3*z + 
     0.057264707010055496*u4*z + 0.14661270314515845*lnbara*u4*z - 
     0.014106252009402123*u5*z - 0.02276428689740073*lnbara*u5*z + 
     1.7363044156749696*v*z - 0.6590435620646294*u*v*z + 
     0.28074606605223806*u2*v*z - 0.08286263081900876*u3*v*z + 
     0.01147557387202353*u4*v*z - 1.2042483603044918*v2*z + 
     0.22684125403582062*u*v2*z - 0.04669828653466497*u2*v2*z + 
     0.0053375013256957*u3*v2*z + 0.6957062021696585*v3*z - 
     0.06262084982973848*u*v3*z + 0.004986373961111605*u2*v3*z - 
     0.2423861073311278*v4*z + 0.008419189235014828*u*v4*z + 
     0.037105667100660746*v5*z + 0.8464109473045268*w*z - 
     0.7813024128964863*lnbara*w*z - 0.282602078789898*u*w*z + 
     0.45854298491927853*lnbara*u*w*z + 0.054749990621346736*u2*w*z - 
     0.22927149245963926*lnbara*u2*w*z + 0.003616397831871475*u3*w*z + 
     0.0726318075537267*lnbara*u3*w*z - 0.002907169920654274*u4*w*z - 
     0.010434137632162098*lnbara*u4*w*z - 0.8101370973526525*v*w*z + 
     0.23609761465662402*u*v*w*z - 0.05706414048455184*u2*v*w*z + 
     0.007014611167395649*u3*v*w*z + 0.30143708357609733*v2*w*z - 
     0.04239176564509756*u*v2*w*z + 0.003980640823768378*u2*v2*w*z - 
     0.08600739873398336*v3*w*z + 0.004682895552936569*u*v3*w*z + 
     0.011755626833308665*v4*w*z - 0.492950729762583*w2*z + 
     0.6666666666666666*lnbara*w2*z + 0.07830552228552949*u*w2*z - 
     0.22927149245963926*lnbara*u*w2*z - 0.002988976154245258*u2*w2*z + 
     0.06016189056452461*lnbara*u2*w2*z - 0.0013944676715588855*u3*w2*z - 
     0.007723814256269575*lnbara*u3*w2*z + 0.37623386422016003*v*w2*z - 
     0.06175145598042547*u*v*w2*z + 0.006275928094281939*u2*v*w2*z - 
     0.07062382163550965*v2*w2*z + 0.004484885221839508*u*v2*w2*z + 
     0.007977294501053117*v3*w2*z + 0.16260118160282788*w3*z - 
     0.40975716415321306*lnbara*w3*z - 0.007050742664409005*u*w3*z + 
     0.0726318075537267*lnbara*u*w3*z - 0.0010428464246845287*u2*w3*z - 
     0.007723814256269575*lnbara*u2*w3*z - 0.11548984331247686*v*w3*z + 
     0.00788494736258755*u*v*w3*z + 0.008605527574636129*v2*w3*z - 
     0.018495223897857942*w4*z + 0.14661270314515845*lnbara*w4*z - 
     0.001136941590506995*u*w4*z - 0.010434137632162098*lnbara*u*w4*z + 
     0.016324459572189313*v*w4*z - 0.0020868275264324197*w5*z - 
     0.02276428689740073*lnbara*w5*z + 1.7363044156749696*y*z - 
     0.6590435620646294*u*y*z + 0.28074606605223806*u2*y*z - 
     0.08286263081900876*u3*y*z + 0.01147557387202353*u4*y*z - 
     0.6590435620646294*v*y*z + 0.16436629925667076*u*v*y*z - 
     0.036635046798668365*u2*v*y*z + 0.004315701492296185*u3*v*y*z + 
     0.28074606605223806*v2*y*z - 0.036635046798668365*u*v2*y*z + 
     0.003284550249668572*u2*v2*y*z - 0.08286263081900876*v3*y*z + 
     0.004315701492296185*u*v3*y*z + 0.01147557387202353*v4*y*z - 
     0.8101370973526525*w*y*z + 0.23609761465662402*u*w*y*z - 
     0.05706414048455184*u2*w*y*z + 0.007014611167395649*u3*w*y*z + 
     0.23609761465662402*v*w*y*z - 0.03565222412399463*u*v*w*y*z + 
     0.003450745247535318*u2*v*w*y*z - 0.05706414048455184*v2*w*y*z + 
     0.003450745247535318*u*v2*w*y*z + 0.007014611167395649*v3*w*y*z + 
     0.37623386422016003*w2*y*z - 0.06175145598042547*u*w2*y*z + 
     0.006275928094281939*u2*w2*y*z - 0.06175145598042547*v*w2*y*z + 
     0.004023131071856042*u*v*w2*y*z + 0.006275928094281939*v2*w2*y*z - 
     0.11548984331247686*w3*y*z + 0.00788494736258755*u*w3*y*z + 
     0.00788494736258755*v*w3*y*z + 0.016324459572189313*w4*y*z - 
     1.2042483603044918*y2*z + 0.22684125403582062*u*y2*z - 
     0.04669828653466497*u2*y2*z + 0.0053375013256957*u3*y2*z + 
     0.28074606605223806*v*y2*z - 0.036635046798668365*u*v*y2*z + 
     0.003284550249668572*u2*v*y2*z - 0.06290423964744986*v2*y2*z + 
     0.003549498037785102*u*v2*y2*z + 0.0074775100099156964*v3*y2*z + 
     0.30143708357609733*w*y2*z - 0.04239176564509756*u*w*y2*z + 
     0.003980640823768378*u2*w*y2*z - 0.05706414048455184*v*w*y2*z + 
     0.003450745247535318*u*v*w*y2*z + 0.006028211949364472*v2*w*y2*z - 
     0.07062382163550965*w2*y2*z + 0.004484885221839508*u*w2*y2*z + 
     0.006275928094281939*v*w2*y2*z + 0.008605527574636129*w3*y2*z + 
     0.6957062021696585*y3*z - 0.06262084982973848*u*y3*z + 
     0.004986373961111605*u2*y3*z - 0.08286263081900876*v*y3*z + 
     0.004315701492296185*u*v*y3*z + 0.0074775100099156964*v2*y3*z - 
     0.08600739873398336*w*y3*z + 0.004682895552936569*u*w*y3*z + 
     0.007014611167395649*v*w*y3*z + 0.007977294501053117*w2*y3*z - 
     0.2423861073311278*y4*z + 0.008419189235014828*u*y4*z + 
     0.01147557387202353*v*y4*z + 0.011755626833308665*w*y4*z + 
     0.037105667100660746*y5*z + 1.0207953340422906*z2 - 
     1.2603642537701805*lnbara*z2 + 0.25*lnbara2*z2 - 
     0.19226363318643444*u*z2 + 0.6666666666666666*lnbara*u*z2 + 
     0.04131289939907423*u2*z2 - 0.27072850754036076*lnbara*u2*z2 + 
     0.0072173585378513495*u3*z2 + 0.08021585408603281*lnbara*u3*z2 - 
     0.003388712393218835*u4*z2 - 0.011178565512996366*lnbara*u4*z2 - 
     1.2042483603044918*v*z2 + 0.28074606605223806*u*v*z2 - 
     0.06290423964744986*u2*v*z2 + 0.0074775100099156964*u3*v*z2 + 
     0.3583010353701717*v2*z2 - 0.04669828653466497*u*v2*z2 + 
     0.004230734800403052*u2*v2*z2 - 0.0951885478160376*v3*z2 + 
     0.004986373961111605*u*v3*z2 + 0.012603690943738541*v4*z2 - 
     0.2484330280988692*w*z2 + 0.6666666666666666*lnbara*w*z2 + 
     0.054749990621346736*u*w*z2 - 0.22927149245963926*lnbara*u*w*z2 - 
     0.00012147073035684983*u2*w*z2 + 0.06016189056452461*lnbara*u2*w*
      z2 - 0.0016140025704639528*u3*w*z2 - 0.007723814256269575*lnbara*u3*
      w*z2 + 0.30143708357609733*v*w*z2 - 0.05706414048455184*u*v*w*z2 + 
     0.006028211949364472*u2*v*w*z2 - 0.05207421077478795*v2*w*z2 + 
     0.003980640823768378*u*v2*w*z2 + 0.005666397839155122*v3*w*z2 + 
     0.08013769687670783*w2*z2 - 0.27072850754036076*lnbara*w2*z2 - 
     0.002988976154245258*u*w2*z2 + 0.06016189056452461*lnbara*u*w2*z2 - 
     0.0011254688727941888*u2*w2*z2 - 0.00690950251345358*lnbara*u2*w2*
      z2 - 0.07062382163550965*v*w2*z2 + 0.006275928094281939*u*v*w2*
      z2 + 0.005057271046160232*v2*w2*z2 - 0.0065955191624306325*w3*
      z2 + 0.08021585408603281*lnbara*w3*z2 - 0.0010428464246845287*u*w3*
      z2 - 0.007723814256269575*lnbara*u*w3*z2 + 
     0.008605527574636129*v*w3*z2 - 0.0012913080119257936*w4*z2 - 
     0.011178565512996366*lnbara*w4*z2 - 1.2042483603044918*y*z2 + 
     0.28074606605223806*u*y*z2 - 0.06290423964744986*u2*y*z2 + 
     0.0074775100099156964*u3*y*z2 + 0.22684125403582062*v*y*z2 - 
     0.036635046798668365*u*v*y*z2 + 0.003549498037785102*u2*v*y*z2 - 
     0.04669828653466497*v2*y*z2 + 0.003284550249668572*u*v2*y*z2 + 
     0.0053375013256957*v3*y*z2 + 0.30143708357609733*w*y*z2 - 
     0.05706414048455184*u*w*y*z2 + 0.006028211949364472*u2*w*y*z2 - 
     0.04239176564509756*v*w*y*z2 + 0.003450745247535318*u*v*w*y*z2 + 
     0.003980640823768378*v2*w*y*z2 - 0.07062382163550965*w2*y*z2 + 
     0.006275928094281939*u*w2*y*z2 + 0.004484885221839508*v*w2*y*z2 + 
     0.008605527574636129*w3*y*z2 + 0.3583010353701717*y2*z2 - 
     0.04669828653466497*u*y2*z2 + 0.004230734800403052*u2*y2*z2 - 
     0.04669828653466497*v*y2*z2 + 0.003284550249668572*u*v*y2*z2 + 
     0.004230734800403052*v2*y2*z2 - 0.05207421077478795*w*y2*z2 + 
     0.003980640823768378*u*w*y2*z2 + 0.003980640823768378*v*w*y2*z2 + 
     0.005057271046160232*w2*y2*z2 - 0.0951885478160376*y3*z2 + 
     0.004986373961111605*u*y3*z2 + 0.0053375013256957*v*y3*z2 + 
     0.005666397839155122*w*y3*z2 + 0.012603690943738541*y4*z2 - 
     0.411329318091625*z3 + 1.2360412272491295*lnbara*z3 - 
     0.3333333333333333*lnbara2*z3 - 0.040692340654889324*u*z3 - 
     0.40975716415321306*lnbara*u*z3 + 0.0072173585378513495*u2*z3 + 
     0.08021585408603281*lnbara*u2*z3 - 0.0023345088047811496*u3*z3 - 
     0.009259259259259259*lnbara*u3*z3 + 0.6957062021696585*v*z3 - 
     0.08286263081900876*u*v*z3 + 0.0074775100099156964*u2*v*z3 - 
     0.0951885478160376*v2*z3 + 0.0053375013256957*u*v2*z3 + 
     0.009594503638373669*v3*z3 - 0.02420015574344982*w*z3 - 
     0.40975716415321306*lnbara*w*z3 + 0.003616397831871475*u*w*z3 + 
     0.0726318075537267*lnbara*u*w*z3 - 0.0016140025704639528*u2*w*z3 - 
     0.007723814256269575*lnbara*u2*w*z3 - 0.08600739873398336*v*w*z3 + 
     0.007014611167395649*u*v*w*z3 + 0.005666397839155122*v2*w*z3 + 
     0.0012492610530469332*w2*z3 + 0.08021585408603281*lnbara*w2*z3 - 
     0.0013944676715588855*u*w2*z3 - 0.007723814256269575*lnbara*u*w2*
      z3 + 0.007977294501053117*v*w2*z3 - 0.0014691525048179737*w3*z3 - 
     0.009259259259259259*lnbara*w3*z3 + 0.6957062021696585*y*z3 - 
     0.08286263081900876*u*y*z3 + 0.0074775100099156964*u2*y*z3 - 
     0.06262084982973848*v*y*z3 + 0.004315701492296185*u*v*y*z3 + 
     0.004986373961111605*v2*y*z3 - 0.08600739873398336*w*y*z3 + 
     0.007014611167395649*u*w*y*z3 + 0.004682895552936569*v*w*y*z3 + 
     0.007977294501053117*w2*y*z3 - 0.0951885478160376*y2*z3 + 
     0.0053375013256957*u*y2*z3 + 0.004986373961111605*v*y2*z3 + 
     0.005666397839155122*w*y2*z3 + 0.009594503638373669*y3*z3 - 
     0.02313298841652572*z4 - 0.7221523383602405*lnbara*z4 + 
     0.25*lnbara2*z4 + 0.057264707010055496*u*z4 + 
     0.14661270314515845*lnbara*u*z4 - 0.003388712393218835*u2*z4 - 
     0.011178565512996366*lnbara*u2*z4 - 0.2423861073311278*v*z4 + 
     0.01147557387202353*u*v*z4 + 0.012603690943738541*v2*z4 + 
     0.05357504725422525*w*z4 + 0.14661270314515845*lnbara*w*z4 - 
     0.002907169920654274*u*w*z4 - 0.010434137632162098*lnbara*u*w*z4 + 
     0.011755626833308665*v*w*z4 - 0.0028504812172850903*w2*z4 - 
     0.011178565512996366*lnbara*w2*z4 - 0.2423861073311278*y*z4 + 
     0.01147557387202353*u*y*z4 + 0.008419189235014828*v*y*z4 + 
     0.011755626833308665*w*y*z4 + 0.012603690943738541*y2*z4 + 
     0.08403968744620527*z5 + 0.23021585408603282*lnbara*z5 - 
     0.1*lnbara2*z5 - 0.014106252009402123*u*z5 - 
     0.02276428689740073*lnbara*u*z5 + 0.037105667100660746*v*z5 - 
     0.013695633713123625*w*z5 - 0.02276428689740073*lnbara*w*z5 + 
     0.037105667100660746*y*z5 - 0.021741522654166835*z6 - 
     0.030781213381871893*lnbara*z6 + 0.016666666666666666*lnbara2*z6;
 
  Gexp[7] = 0.882181228982499 - 0.5642857142857143*lnbara + 
     0.07142857142857142*lnbara2 - 1.2949521745536563*u + 
     0.7138888888888889*lnbara*u - 0.08333333333333333*lnbara2*u + 
     1.2728681847963266*u2 - 1.3603642537701803*lnbara*u2 + 
     0.25*lnbara2*u2 - 0.8231719544268136*u3 + 1.7117182007280785*lnbara*
      u3 - 0.4166666666666667*lnbara2*u3 + 0.20216246542587063*u4 - 
     1.3702538972670675*lnbara*u4 + 0.4166666666666667*lnbara2*u4 + 
     0.09499129157249676*u5 + 0.675539635215082*lnbara*u5 - 
     0.25*lnbara2*u5 - 0.07792639988896227*u6 - 0.1872394002426928*lnbara*
      u6 + 0.08333333333333333*lnbara2*u6 + 0.01562557344501031*u7 + 
     0.02232424768031541*lnbara*u7 - 0.011904761904761904*lnbara2*u7 - 
     1.2949521745536563*v + 0.7138888888888889*lnbara*v - 
     0.08333333333333333*lnbara2*v + 1.7363044156749696*u*v - 
     1.5053104503806145*u2*v + 1.1595103369494308*u3*v - 
     0.6059652683278195*u4*v + 0.18552833550330372*u5*v - 
     0.02502340865562592*u6*v + 1.2728681847963266*v2 - 
     1.3603642537701803*lnbara*v2 + 0.25*lnbara2*v2 - 
     1.5053104503806145*u*v2 + 0.5971683922836196*u2*v2 - 
     0.23797136954009399*u3*v2 + 0.0630184547186927*u4*v2 - 
     0.007769887708739977*u5*v2 - 0.8231719544268136*v3 + 
     1.7117182007280785*lnbara*v3 - 0.4166666666666667*lnbara2*v3 + 
     1.1595103369494308*u*v3 - 0.23797136954009399*u2*v3 + 
     0.04797251819186834*u3*v3 - 0.005107942897122393*u4*v3 + 
     0.20216246542587063*v4 - 1.3702538972670675*lnbara*v4 + 
     0.4166666666666667*lnbara2*v4 - 0.6059652683278195*u*v4 + 
     0.0630184547186927*u2*v4 - 0.005107942897122393*u3*v4 + 
     0.09499129157249676*v5 + 0.675539635215082*lnbara*v5 - 
     0.25*lnbara2*v5 + 0.18552833550330372*u*v5 - 
     0.007769887708739977*u2*v5 - 0.07792639988896227*v6 - 
     0.1872394002426928*lnbara*v6 + 0.08333333333333333*lnbara2*v6 - 
     0.02502340865562592*u*v6 + 0.01562557344501031*v7 + 
     0.02232424768031541*lnbara*v7 - 0.011904761904761904*lnbara2*v7 - 
     0.9954599046628679*w + 1.0944444444444446*lnbara*w - 
     0.16666666666666666*lnbara2*w + 1.0026714298838242*u*w - 
     0.7813024128964863*lnbara*u*w - 0.47720795179025316*u2*w + 
     0.8333333333333334*lnbara*u2*w + 0.09625212847865466*u3*w - 
     0.6829286069220218*lnbara*u3*w + 0.0606312665629839*u4*w + 
     0.36653175786289616*lnbara*u4*w - 0.0457138816682174*u5*w - 
     0.11382143448700363*lnbara*u5*w + 0.009188839992349455*u6*w + 
     0.01548483324024246*lnbara*u6*w + 1.0026714298838242*v*w - 
     0.7813024128964863*lnbara*v*w - 1.0126713716908156*u*v*w + 
     0.5023951392934956*u2*v*w - 0.21501849683495838*u3*v*w + 
     0.058778134166543324*u4*v*w - 0.007372846802421446*u5*v*w - 
     0.47720795179025316*v2*w + 0.8333333333333334*lnbara*v2*w + 
     0.5023951392934956*u*v2*w - 0.1301855269369699*u2*v2*w + 
     0.02833198919577561*u3*v2*w - 0.0031230558273987455*u4*v2*w + 
     0.09625212847865466*v3*w - 0.6829286069220218*lnbara*v3*w - 
     0.21501849683495838*u*v3*w + 0.02833198919577561*u2*v3*w - 
     0.002484679216493939*u3*v3*w + 0.0606312665629839*v4*w + 
     0.36653175786289616*lnbara*v4*w + 0.058778134166543324*u*v4*w - 
     0.0031230558273987455*u2*v4*w - 0.0457138816682174*v5*w - 
     0.11382143448700363*lnbara*v5*w - 0.007372846802421446*u*v5*w + 
     0.009188839992349455*v6*w + 0.01548483324024246*lnbara*v6*w + 
     0.9810368542209558*w2 - 1.7207285075403607*lnbara*w2 + 
     0.5*lnbara2*w2 - 0.7828550788698954*u*w2 + 0.8333333333333334*lnbara*
      u*w2 + 0.22380566397463328*u2*w2 - 0.4512141792339346*lnbara*u2*
      w2 - 0.036984774410399074*u3*w2 + 0.20053963521508203*lnbara*u3*
      w2 - 0.003073840573429086*u4*w2 - 0.055892827564981824*lnbara*u4*
      w2 + 0.0017654969488961178*u5*w2 + 0.00709100055854524*lnbara*u5*
      w2 - 0.7828550788698954*v*w2 + 0.8333333333333334*lnbara*v*w2 + 
     0.6270564403669334*u*v*w2 - 0.17655955408877413*u2*v*w2 + 
     0.039886472505265586*u3*v*w2 - 0.004483995136656385*u4*v*w2 + 
     0.22380566397463328*v2*w2 - 0.4512141792339346*lnbara*v2*w2 - 
     0.17655955408877413*u*v2*w2 + 0.02528635523080116*u2*v2*w2 - 
     0.0023037031758568953*u3*v2*w2 - 0.036984774410399074*v3*w2 + 
     0.20053963521508203*lnbara*v3*w2 + 0.039886472505265586*u*v3*w2 - 
     0.0023037031758568953*u2*v3*w2 - 0.003073840573429086*v4*w2 - 
     0.055892827564981824*lnbara*v4*w2 - 0.004483995136656385*u*v4*w2 + 
     0.0017654969488961178*v5*w2 + 0.00709100055854524*lnbara*v5*w2 - 
     0.5912546518750658*w3 + 1.7567697347894902*lnbara*w3 - 
     0.8333333333333334*lnbara2*w3 + 0.4075876907224508*u*w3 - 
     0.6829286069220218*lnbara*u*w3 - 0.056596724949092986*u2*w3 + 
     0.20053963521508203*lnbara*u2*w3 + 0.0019134967351693904*u3*w3 - 
     0.046296296296296294*lnbara*u3*w3 + 0.000809549773107401*u4*w3 + 
     0.005269398380875331*lnbara*u4*w3 + 0.4075876907224508*v*w3 - 
     0.6829286069220218*lnbara*v*w3 - 0.2887246082811922*u*v*w3 + 
     0.043027637873180646*u2*v*w3 - 0.004003458840761125*u3*v*w3 - 
     0.056596724949092986*v2*w3 + 0.20053963521508203*lnbara*v2*w3 + 
     0.043027637873180646*u*v2*w3 - 0.0025854864042796264*u2*v2*w3 + 
     0.0019134967351693904*v3*w3 - 0.046296296296296294*lnbara*v3*w3 - 
     0.004003458840761125*u*v3*w3 + 0.000809549773107401*v4*w3 + 
     0.005269398380875331*lnbara*v4*w3 + 0.18366696115261488*w4 - 
     1.0738411278674682*lnbara*w4 + 0.8333333333333334*lnbara2*w4 - 
     0.11954441131722408*u*w4 + 0.36653175786289616*lnbara*u*w4 + 
     0.004722025453367396*u2*w4 - 0.055892827564981824*lnbara*u2*w4 + 
     0.0005843696903917379*u3*w4 + 0.005269398380875331*lnbara*u3*w4 - 
     0.11954441131722408*v*w4 + 0.36653175786289616*lnbara*v*w4 + 
     0.08162229786094656*u*v*w4 - 0.005014303821094131*u2*v*w4 + 
     0.004722025453367396*v2*w4 - 0.055892827564981824*lnbara*v2*w4 - 
     0.005014303821094131*u*v2*w4 + 0.0005843696903917379*v3*w4 + 
     0.005269398380875331*lnbara*v3*w4 - 0.014564647637789663*w5 + 
     0.35107927043016407*lnbara*w5 - 0.5*lnbara2*w5 + 
     0.012330149265238628*u*w5 - 0.11382143448700363*lnbara*u*w5 + 
     0.0006183344116792466*u2*w5 + 0.00709100055854524*lnbara*u2*w5 + 
     0.012330149265238628*v*w5 - 0.11382143448700363*lnbara*v*w5 - 
     0.010430313916348187*u*v*w5 + 0.0006183344116792466*v2*w5 + 
     0.00709100055854524*lnbara*v2*w5 - 0.0033652169642291977*w6 - 
     0.041145467152052265*lnbara*w6 + 0.16666666666666666*lnbara2*w6 + 
     0.0011217389880763993*u*w6 + 0.01548483324024246*lnbara*u*w6 + 
     0.0011217389880763993*v*w6 + 0.01548483324024246*lnbara*v*w6 - 
     0.00016024842686805703*w7 - 0.0029705522584167966*lnbara*w7 - 
     0.023809523809523808*lnbara2*w7 - 1.2949521745536563*y + 
     0.7138888888888889*lnbara*y - 0.08333333333333333*lnbara2*y + 
     1.7363044156749696*u*y - 1.5053104503806145*u2*y + 
     1.1595103369494308*u3*y - 0.6059652683278195*u4*y + 
     0.18552833550330372*u5*y - 0.02502340865562592*u6*y + 
     0.7486964164955209*v*y - 0.7813024128964863*lnbara*v*y - 
     0.8238044525807867*u*v*y + 0.3780687567263677*u2*v*y - 
     0.1565521245743462*u3*v*y + 0.04209594617507414*u4*v*y - 
     0.005230685402774597*u5*v*y - 0.4069962081497097*v2*y + 
     0.8333333333333334*lnbara*v2*y + 0.4679101100870634*u*v2*y - 
     0.11674571633666242*u2*v2*y + 0.024931869805558025*u3*v2*y - 
     0.002720137747628636*u4*v2*y + 0.06876515362625549*v3*y - 
     0.6829286069220218*lnbara*v3*y - 0.20715657704752188*u*v3*y + 
     0.0266875066284785*u2*v3*y - 0.00231214789919763*u3*v3*y + 
     0.06985541595255951*v4*y + 0.36653175786289616*lnbara*v4*y + 
     0.057377869360117656*u*v4*y - 0.0030019939085982657*u2*v4*y - 
     0.047766973149609884*v5*y - 0.11382143448700363*lnbara*v5*y - 
     0.007244575946872198*u*v5*y + 0.0094053630927925*v6*y + 
     0.01548483324024246*lnbara*v6*y + 1.0026714298838242*w*y - 
     0.7813024128964863*lnbara*w*y - 1.0126713716908156*u*w*y + 
     0.5023951392934956*u2*w*y - 0.21501849683495838*u3*w*y + 
     0.058778134166543324*u4*w*y - 0.007372846802421446*u5*w*y - 
     0.4678883447171921*v*w*y + 0.5731787311490981*lnbara*v*w*y + 
     0.3934960244277067*u*v*w*y - 0.10597941411274388*u2*v*w*y + 
     0.023414477764682844*u3*v*w*y - 0.0025998411220075207*u4*v*w*y + 
     0.167673815188791*v2*w*y - 0.3821191540993988*lnbara*v2*w*y - 
     0.1426603512113796*u*v2*w*y + 0.019903204118841892*u2*v2*w*y - 
     0.0017876398103266954*u3*v2*w*y - 0.02727490919718466*v3*w*y + 
     0.18157951888431673*lnbara*v3*w*y + 0.03507305583697824*u*v3*w*y - 
     0.0019906820746583257*u2*v3*w*y - 0.004101711971109271*v4*w*y - 
     0.0521706881608105*lnbara*v4*w*y - 0.004099957104318314*u*v4*w*y + 
     0.0017955414211713314*v5*w*y + 0.006730433928458395*lnbara*v5*w*y - 
     0.7828550788698954*w2*y + 0.8333333333333334*lnbara*w2*y + 
     0.6270564403669334*u*w2*y - 0.17655955408877413*u2*w2*y + 
     0.039886472505265586*u3*w2*y - 0.004483995136656385*u4*w2*y + 
     0.20693303462909557*v*w2*y - 0.3821191540993988*lnbara*v*w2*y - 
     0.15437863995106366*u*v*w2*y + 0.02242442610919754*u2*v*w2*y - 
     0.002056880745742084*u3*v*w2*y - 0.03755338566787545*v2*w2*y + 
     0.15040472641131153*lnbara*v2*w2*y + 0.031379640471409696*u*v2*w2*
      y - 0.001853838481410454*u2*v2*w2*y + 0.0007514758984751476*v3*w2*
      y - 0.03861907128134787*lnbara*v3*w2*y - 0.003275828338900795*u*v3*
      w2*y + 0.0007856967829390636*v4*w2*y + 0.004629629629629629*lnbara*
      v4*w2*y + 0.4075876907224508*w3*y - 0.6829286069220218*lnbara*w3*
      y - 0.2887246082811922*u*w3*y + 0.043027637873180646*u2*w3*y - 
     0.004003458840761125*u3*w3*y - 0.05394276043788586*v*w3*y + 
     0.18157951888431673*lnbara*v*w3*y + 0.03942473681293775*u*v*w3*y - 
     0.002384224310314243*u2*v*w3*y + 0.002509582132846931*v2*w3*y - 
     0.03861907128134787*lnbara*v2*w3*y - 0.0034048489476472465*u*v2*w3*
      y + 0.0005177430923563043*v3*w3*y + 0.004141109249293644*lnbara*v3*
      w3*y - 0.11954441131722408*w4*y + 0.36653175786289616*lnbara*w4*y + 
     0.08162229786094656*u*w4*y - 0.005014303821094131*u2*w4*y + 
     0.004749429679627125*v*w4*y - 0.0521706881608105*lnbara*v*w4*y - 
     0.004706756497414547*u*v*w4*y + 0.00046180105924941995*v2*w4*y + 
     0.004629629629629629*lnbara*v2*w4*y + 0.012330149265238628*w5*y - 
     0.11382143448700363*lnbara*w5*y - 0.010430313916348187*u*w5*y + 
     0.0005633758156408582*v*w5*y + 0.006730433928458395*lnbara*v*w5*y + 
     0.0011217389880763993*w6*y + 0.01548483324024246*lnbara*w6*y + 
     1.2728681847963266*y2 - 1.3603642537701803*lnbara*y2 + 
     0.25*lnbara2*y2 - 1.5053104503806145*u*y2 + 
     0.5971683922836196*u2*y2 - 0.23797136954009399*u3*y2 + 
     0.0630184547186927*u4*y2 - 0.007769887708739977*u5*y2 - 
     0.4069962081497097*v*y2 + 0.8333333333333334*lnbara*v*y2 + 
     0.4679101100870634*u*v*y2 - 0.11674571633666242*u2*v*y2 + 
     0.024931869805558025*u3*v*y2 - 0.002720137747628636*u4*v*y2 + 
     0.1590976681785773*v2*y2 - 0.4512141792339346*lnbara*v2*y2 - 
     0.15726059911862464*u*v2*y2 + 0.02115367400201526*u2*v2*y2 - 
     0.0018641464676133518*u3*v2*y2 - 0.022064530698388034*v3*y2 + 
     0.20053963521508203*lnbara*v3*y2 + 0.03738755004957848*u*v3*y2 - 
     0.0020767314249685157*u2*v3*y2 - 0.005764996453097809*v4*y2 - 
     0.055892827564981824*lnbara*v4*y2 - 0.004294458827781368*u*v4*y2 + 
     0.0020142025327139768*v5*y2 + 0.00709100055854524*lnbara*v5*y2 - 
     0.47720795179025316*w*y2 + 0.8333333333333334*lnbara*w*y2 + 
     0.5023951392934956*u*w*y2 - 0.1301855269369699*u2*w*y2 + 
     0.02833198919577561*u3*w*y2 - 0.0031230558273987455*u4*w*y2 + 
     0.167673815188791*v*w*y2 - 0.3821191540993988*lnbara*v*w*y2 - 
     0.1426603512113796*u*v*w*y2 + 0.019903204118841892*u2*v*w*y2 - 
     0.0017876398103266954*u3*v*w*y2 - 0.03038462210815443*v2*w*y2 + 
     0.15040472641131153*lnbara*v2*w*y2 + 0.030141059746822362*u*v2*w*
      y2 - 0.001739141446927106*u2*v2*w*y2 - 0.0003461985960501892*v3*w*
      y2 - 0.03861907128134787*lnbara*v3*w*y2 - 0.003194707024362469*u*v3*
      w*y2 + 0.000876262754005557*v4*w*y2 + 0.004629629629629629*lnbara*
      v4*w*y2 + 0.22380566397463328*w2*y2 - 0.4512141792339346*lnbara*w2*
      y2 - 0.17655955408877413*u*w2*y2 + 0.02528635523080116*u2*w2*y2 - 
     0.0023037031758568953*u3*w2*y2 - 0.03755338566787545*v*w2*y2 + 
     0.15040472641131153*lnbara*v*w2*y2 + 0.031379640471409696*u*v*w2*
      y2 - 0.001853838481410454*u2*v*w2*y2 + 0.0012821581494826362*v2*
      w2*y2 - 0.0345475125672679*lnbara*v2*w2*y2 - 
     0.002972087316778959*u*v2*w2*y2 + 0.0005520821852506379*v3*w2*y2 + 
     0.003838612507474211*lnbara*v3*w2*y2 - 0.056596724949092986*w3*y2 + 
     0.20053963521508203*lnbara*w3*y2 + 0.043027637873180646*u*w3*y2 - 
     0.0025854864042796264*u2*w3*y2 + 0.002509582132846931*v*w3*y2 - 
     0.03861907128134787*lnbara*v*w3*y2 - 0.0034048489476472465*u*v*w3*
      y2 + 0.0004498411241904846*v2*w3*y2 + 0.003838612507474211*lnbara*
      v2*w3*y2 + 0.004722025453367396*w4*y2 - 0.055892827564981824*
      lnbara*w4*y2 - 0.005014303821094131*u*w4*y2 + 
     0.00046180105924941995*v*w4*y2 + 0.004629629629629629*lnbara*v*w4*
      y2 + 0.0006183344116792466*w5*y2 + 0.00709100055854524*lnbara*w5*
      y2 - 0.8231719544268136*y3 + 1.7117182007280785*lnbara*y3 - 
     0.4166666666666667*lnbara2*y3 + 1.1595103369494308*u*y3 - 
     0.23797136954009399*u2*y3 + 0.04797251819186834*u3*y3 - 
     0.005107942897122393*u4*y3 + 0.06876515362625549*v*y3 - 
     0.6829286069220218*lnbara*v*y3 - 0.20715657704752188*u*v*y3 + 
     0.0266875066284785*u2*v*y3 - 0.00231214789919763*u3*v*y3 - 
     0.022064530698388034*v2*y3 + 0.20053963521508203*lnbara*v2*y3 + 
     0.03738755004957848*u*v2*y3 - 0.0020767314249685157*u2*v2*y3 - 
     0.0024132847646464893*v3*y3 - 0.046296296296296294*lnbara*v3*y3 - 
     0.0036899420821654982*u*v3*y3 + 0.0011355462303617014*v4*y3 + 
     0.005269398380875331*lnbara*v4*y3 + 0.09625212847865466*w*y3 - 
     0.6829286069220218*lnbara*w*y3 - 0.21501849683495838*u*w*y3 + 
     0.02833198919577561*u2*w*y3 - 0.002484679216493939*u3*w*y3 - 
     0.02727490919718466*v*w*y3 + 0.18157951888431673*lnbara*v*w*y3 + 
     0.03507305583697824*u*v*w*y3 - 0.0019906820746583257*u2*v*w*y3 - 
     0.0003461985960501892*v2*w*y3 - 0.03861907128134787*lnbara*v2*w*y3 - 
     0.003194707024362469*u*v2*w*y3 + 0.0007087990860838744*v3*w*y3 + 
     0.004141109249293644*lnbara*v3*w*y3 - 0.036984774410399074*w2*y3 + 
     0.20053963521508203*lnbara*w2*y3 + 0.039886472505265586*u*w2*y3 - 
     0.0023037031758568953*u2*w2*y3 + 0.0007514758984751476*v*w2*y3 - 
     0.03861907128134787*lnbara*v*w2*y3 - 0.003275828338900795*u*v*w2*
      y3 + 0.0005520821852506379*v2*w2*y3 + 0.003838612507474211*lnbara*
      v2*w2*y3 + 0.0019134967351693904*w3*y3 - 
     0.046296296296296294*lnbara*w3*y3 - 0.004003458840761125*u*w3*y3 + 
     0.0005177430923563043*v*w3*y3 + 0.004141109249293644*lnbara*v*w3*
      y3 + 0.0005843696903917379*w4*y3 + 0.005269398380875331*lnbara*w4*
      y3 + 0.20216246542587063*y4 - 1.3702538972670675*lnbara*y4 + 
     0.4166666666666667*lnbara2*y4 - 0.6059652683278195*u*y4 + 
     0.0630184547186927*u2*y4 - 0.005107942897122393*u3*y4 + 
     0.06985541595255951*v*y4 + 0.36653175786289616*lnbara*v*y4 + 
     0.057377869360117656*u*v*y4 - 0.0030019939085982657*u2*v*y4 - 
     0.005764996453097809*v2*y4 - 0.055892827564981824*lnbara*v2*y4 - 
     0.004294458827781368*u*v2*y4 + 0.0011355462303617014*v3*y4 + 
     0.005269398380875331*lnbara*v3*y4 + 0.0606312665629839*w*y4 + 
     0.36653175786289616*lnbara*w*y4 + 0.058778134166543324*u*w*y4 - 
     0.0031230558273987455*u2*w*y4 - 0.004101711971109271*v*w*y4 - 
     0.0521706881608105*lnbara*v*w*y4 - 0.004099957104318314*u*v*w*y4 + 
     0.000876262754005557*v2*w*y4 + 0.004629629629629629*lnbara*v2*w*y4 - 
     0.003073840573429086*w2*y4 - 0.055892827564981824*lnbara*w2*y4 - 
     0.004483995136656385*u*w2*y4 + 0.0007856967829390636*v*w2*y4 + 
     0.004629629629629629*lnbara*v*w2*y4 + 0.000809549773107401*w3*y4 + 
     0.005269398380875331*lnbara*w3*y4 + 0.09499129157249676*y5 + 
     0.675539635215082*lnbara*y5 - 0.25*lnbara2*y5 + 
     0.18552833550330372*u*y5 - 0.007769887708739977*u2*y5 - 
     0.047766973149609884*v*y5 - 0.11382143448700363*lnbara*v*y5 - 
     0.007244575946872198*u*v*y5 + 0.0020142025327139768*v2*y5 + 
     0.00709100055854524*lnbara*v2*y5 - 0.0457138816682174*w*y5 - 
     0.11382143448700363*lnbara*w*y5 - 0.007372846802421446*u*w*y5 + 
     0.0017955414211713314*v*w*y5 + 0.006730433928458395*lnbara*v*w*y5 + 
     0.0017654969488961178*w2*y5 + 0.00709100055854524*lnbara*w2*y5 - 
     0.07792639988896227*y6 - 0.1872394002426928*lnbara*y6 + 
     0.08333333333333333*lnbara2*y6 - 0.02502340865562592*u*y6 + 
     0.0094053630927925*v*y6 + 0.01548483324024246*lnbara*v*y6 + 
     0.009188839992349455*w*y6 + 0.01548483324024246*lnbara*w*y6 + 
     0.01562557344501031*y7 + 0.02232424768031541*lnbara*y7 - 
     0.011904761904761904*lnbara2*y7 - 1.2949521745536563*z + 
     0.7138888888888889*lnbara*z - 0.08333333333333333*lnbara2*z + 
     0.7486964164955209*u*z - 0.7813024128964863*lnbara*u*z - 
     0.4069962081497097*u2*z + 0.8333333333333334*lnbara*u2*z + 
     0.06876515362625549*u3*z - 0.6829286069220218*lnbara*u3*z + 
     0.06985541595255951*u4*z + 0.36653175786289616*lnbara*u4*z - 
     0.047766973149609884*u5*z - 0.11382143448700363*lnbara*u5*z + 
     0.0094053630927925*u6*z + 0.01548483324024246*lnbara*u6*z + 
     1.7363044156749696*v*z - 0.8238044525807867*u*v*z + 
     0.4679101100870634*u2*v*z - 0.20715657704752188*u3*v*z + 
     0.057377869360117656*u4*v*z - 0.007244575946872198*u5*v*z - 
     1.5053104503806145*v2*z + 0.3780687567263677*u*v2*z - 
     0.11674571633666242*u2*v2*z + 0.0266875066284785*u3*v2*z - 
     0.0030019939085982657*u4*v2*z + 1.1595103369494308*v3*z - 
     0.1565521245743462*u*v3*z + 0.024931869805558025*u2*v3*z - 
     0.00231214789919763*u3*v3*z - 0.6059652683278195*v4*z + 
     0.04209594617507414*u*v4*z - 0.002720137747628636*u2*v4*z + 
     0.18552833550330372*v5*z - 0.005230685402774597*u*v5*z - 
     0.02502340865562592*v6*z + 1.0026714298838242*w*z - 
     0.7813024128964863*lnbara*w*z - 0.4678883447171921*u*w*z + 
     0.5731787311490981*lnbara*u*w*z + 0.167673815188791*u2*w*z - 
     0.3821191540993988*lnbara*u2*w*z - 0.02727490919718466*u3*w*z + 
     0.18157951888431673*lnbara*u3*w*z - 0.004101711971109271*u4*w*z - 
     0.0521706881608105*lnbara*u4*w*z + 0.0017955414211713314*u5*w*z + 
     0.006730433928458395*lnbara*u5*w*z - 1.0126713716908156*v*w*z + 
     0.3934960244277067*u*v*w*z - 0.1426603512113796*u2*v*w*z + 
     0.03507305583697824*u3*v*w*z - 0.004099957104318314*u4*v*w*z + 
     0.5023951392934956*v2*w*z - 0.10597941411274388*u*v2*w*z + 
     0.019903204118841892*u2*v2*w*z - 0.0019906820746583257*u3*v2*w*z - 
     0.21501849683495838*v3*w*z + 0.023414477764682844*u*v3*w*z - 
     0.0017876398103266954*u2*v3*w*z + 0.058778134166543324*v4*w*z - 
     0.0025998411220075207*u*v4*w*z - 0.007372846802421446*v5*w*z - 
     0.7828550788698954*w2*z + 0.8333333333333334*lnbara*w2*z + 
     0.20693303462909557*u*w2*z - 0.3821191540993988*lnbara*u*w2*z - 
     0.03755338566787545*u2*w2*z + 0.15040472641131153*lnbara*u2*w2*z + 
     0.0007514758984751476*u3*w2*z - 0.03861907128134787*lnbara*u3*w2*z + 
     0.0007856967829390636*u4*w2*z + 0.004629629629629629*lnbara*u4*w2*
      z + 0.6270564403669334*v*w2*z - 0.15437863995106366*u*v*w2*z + 
     0.031379640471409696*u2*v*w2*z - 0.003275828338900795*u3*v*w2*z - 
     0.17655955408877413*v2*w2*z + 0.02242442610919754*u*v2*w2*z - 
     0.001853838481410454*u2*v2*w2*z + 0.039886472505265586*v3*w2*z - 
     0.002056880745742084*u*v3*w2*z - 0.004483995136656385*v4*w2*z + 
     0.4075876907224508*w3*z - 0.6829286069220218*lnbara*w3*z - 
     0.05394276043788586*u*w3*z + 0.18157951888431673*lnbara*u*w3*z + 
     0.002509582132846931*u2*w3*z - 0.03861907128134787*lnbara*u2*w3*z + 
     0.0005177430923563043*u3*w3*z + 0.004141109249293644*lnbara*u3*w3*
      z - 0.2887246082811922*v*w3*z + 0.03942473681293775*u*v*w3*z - 
     0.0034048489476472465*u2*v*w3*z + 0.043027637873180646*v2*w3*z - 
     0.002384224310314243*u*v2*w3*z - 0.004003458840761125*v3*w3*z - 
     0.11954441131722408*w4*z + 0.36653175786289616*lnbara*w4*z + 
     0.004749429679627125*u*w4*z - 0.0521706881608105*lnbara*u*w4*z + 
     0.00046180105924941995*u2*w4*z + 0.004629629629629629*lnbara*u2*w4*
      z + 0.08162229786094656*v*w4*z - 0.004706756497414547*u*v*w4*z - 
     0.005014303821094131*v2*w4*z + 0.012330149265238628*w5*z - 
     0.11382143448700363*lnbara*w5*z + 0.0005633758156408582*u*w5*z + 
     0.006730433928458395*lnbara*u*w5*z - 0.010430313916348187*v*w5*z + 
     0.0011217389880763993*w6*z + 0.01548483324024246*lnbara*w6*z + 
     1.7363044156749696*y*z - 0.8238044525807867*u*y*z + 
     0.4679101100870634*u2*y*z - 0.20715657704752188*u3*y*z + 
     0.057377869360117656*u4*y*z - 0.007244575946872198*u5*y*z - 
     0.8238044525807867*v*y*z + 0.2739438320944513*u*v*y*z - 
     0.09158761699667091*u2*v*y*z + 0.021578507461480923*u3*v*y*z - 
     0.0024621270486790818*u4*v*y*z + 0.4679101100870634*v2*y*z - 
     0.09158761699667091*u*v2*y*z + 0.01642275124834286*u2*v2*y*z - 
     0.0015989423718971896*u3*v2*y*z - 0.20715657704752188*v3*y*z + 
     0.021578507461480923*u*v3*y*z - 0.0015989423718971896*u2*v3*y*z + 
     0.057377869360117656*v4*y*z - 0.0024621270486790818*u*v4*y*z - 
     0.007244575946872198*v5*y*z - 1.0126713716908156*w*y*z + 
     0.3934960244277067*u*w*y*z - 0.1426603512113796*u2*w*y*z + 
     0.03507305583697824*u3*w*y*z - 0.004099957104318314*u4*w*y*z + 
     0.3934960244277067*v*w*y*z - 0.08913056030998658*u*v*w*y*z + 
     0.01725372623767659*u2*v*w*y*z - 0.0017507925438618114*u3*v*w*y*z - 
     0.1426603512113796*v2*w*y*z + 0.01725372623767659*u*v2*w*y*z - 
     0.001382278607211708*u2*v2*w*y*z + 0.03507305583697824*v3*w*y*z - 
     0.0017507925438618114*u*v3*w*y*z - 0.004099957104318314*v4*w*y*z + 
     0.6270564403669334*w2*y*z - 0.15437863995106366*u*w2*y*z + 
     0.031379640471409696*u2*w2*y*z - 0.003275828338900795*u3*w2*y*z - 
     0.15437863995106366*v*w2*y*z + 0.02011565535928021*u*v*w2*y*z - 
     0.001685757015386744*u2*v*w2*y*z + 0.031379640471409696*v2*w2*y*z - 
     0.001685757015386744*u*v2*w2*y*z - 0.003275828338900795*v3*w2*y*z - 
     0.2887246082811922*w3*y*z + 0.03942473681293775*u*w3*y*z - 
     0.0034048489476472465*u2*w3*y*z + 0.03942473681293775*v*w3*y*z - 
     0.002209866412062086*u*v*w3*y*z - 0.0034048489476472465*v2*w3*y*z + 
     0.08162229786094656*w4*y*z - 0.004706756497414547*u*w4*y*z - 
     0.004706756497414547*v*w4*y*z - 0.010430313916348187*w5*y*z - 
     1.5053104503806145*y2*z + 0.3780687567263677*u*y2*z - 
     0.11674571633666242*u2*y2*z + 0.0266875066284785*u3*y2*z - 
     0.0030019939085982657*u4*y2*z + 0.4679101100870634*v*y2*z - 
     0.09158761699667091*u*v*y2*z + 0.01642275124834286*u2*v*y2*z - 
     0.0015989423718971896*u3*v*y2*z - 0.15726059911862464*v2*y2*z + 
     0.017747490188925512*u*v2*y2*z - 0.0013617046024370035*u2*v2*y2*z + 
     0.03738755004957848*v3*y2*z - 0.001791718617657013*u*v3*y2*z - 
     0.004294458827781368*v4*y2*z + 0.5023951392934956*w*y2*z - 
     0.10597941411274388*u*w*y2*z + 0.019903204118841892*u2*w*y2*z - 
     0.0019906820746583257*u3*w*y2*z - 0.1426603512113796*v*w*y2*z + 
     0.01725372623767659*u*v*w*y2*z - 0.001382278607211708*u2*v*w*y2*z + 
     0.030141059746822362*v2*w*y2*z - 0.0015503600732354181*u*v2*w*y2*z - 
     0.003194707024362469*v3*w*y2*z - 0.17655955408877413*w2*y2*z + 
     0.02242442610919754*u*w2*y2*z - 0.001853838481410454*u2*w2*y2*z + 
     0.031379640471409696*v*w2*y2*z - 0.001685757015386744*u*v*w2*y2*z - 
     0.002972087316778959*v2*w2*y2*z + 0.043027637873180646*w3*y2*z - 
     0.002384224310314243*u*w3*y2*z - 0.0034048489476472465*v*w3*y2*z - 
     0.005014303821094131*w4*y2*z + 1.1595103369494308*y3*z - 
     0.1565521245743462*u*y3*z + 0.024931869805558025*u2*y3*z - 
     0.00231214789919763*u3*y3*z - 0.20715657704752188*v*y3*z + 
     0.021578507461480923*u*v*y3*z - 0.0015989423718971896*u2*v*y3*z + 
     0.03738755004957848*v2*y3*z - 0.001791718617657013*u*v2*y3*z - 
     0.0036899420821654982*v3*y3*z - 0.21501849683495838*w*y3*z + 
     0.023414477764682844*u*w*y3*z - 0.0017876398103266954*u2*w*y3*z + 
     0.03507305583697824*v*w*y3*z - 0.0017507925438618114*u*v*w*y3*z - 
     0.003194707024362469*v2*w*y3*z + 0.039886472505265586*w2*y3*z - 
     0.002056880745742084*u*w2*y3*z - 0.003275828338900795*v*w2*y3*z - 
     0.004003458840761125*w3*y3*z - 0.6059652683278195*y4*z + 
     0.04209594617507414*u*y4*z - 0.002720137747628636*u2*y4*z + 
     0.057377869360117656*v*y4*z - 0.0024621270486790818*u*v*y4*z - 
     0.004294458827781368*v2*y4*z + 0.058778134166543324*w*y4*z - 
     0.0025998411220075207*u*w*y4*z - 0.004099957104318314*v*w*y4*z - 
     0.004483995136656385*w2*y4*z + 0.18552833550330372*y5*z - 
     0.005230685402774597*u*y5*z - 0.007244575946872198*v*y5*z - 
     0.007372846802421446*w*y5*z - 0.02502340865562592*y6*z + 
     1.2728681847963266*z2 - 1.3603642537701803*lnbara*z2 + 
     0.25*lnbara2*z2 - 0.4069962081497097*u*z2 + 
     0.8333333333333334*lnbara*u*z2 + 0.1590976681785773*u2*z2 - 
     0.4512141792339346*lnbara*u2*z2 - 0.022064530698388034*u3*z2 + 
     0.20053963521508203*lnbara*u3*z2 - 0.005764996453097809*u4*z2 - 
     0.055892827564981824*lnbara*u4*z2 + 0.0020142025327139768*u5*z2 + 
     0.00709100055854524*lnbara*u5*z2 - 1.5053104503806145*v*z2 + 
     0.4679101100870634*u*v*z2 - 0.15726059911862464*u2*v*z2 + 
     0.03738755004957848*u3*v*z2 - 0.004294458827781368*u4*v*z2 + 
     0.5971683922836196*v2*z2 - 0.11674571633666242*u*v2*z2 + 
     0.02115367400201526*u2*v2*z2 - 0.0020767314249685157*u3*v2*z2 - 
     0.23797136954009399*v3*z2 + 0.024931869805558025*u*v3*z2 - 
     0.0018641464676133518*u2*v3*z2 + 0.0630184547186927*v4*z2 - 
     0.002720137747628636*u*v4*z2 - 0.007769887708739977*v5*z2 - 
     0.47720795179025316*w*z2 + 0.8333333333333334*lnbara*w*z2 + 
     0.167673815188791*u*w*z2 - 0.3821191540993988*lnbara*u*w*z2 - 
     0.03038462210815443*u2*w*z2 + 0.15040472641131153*lnbara*u2*w*z2 - 
     0.0003461985960501892*u3*w*z2 - 0.03861907128134787*lnbara*u3*w*z2 + 
     0.000876262754005557*u4*w*z2 + 0.004629629629629629*lnbara*u4*w*z2 + 
     0.5023951392934956*v*w*z2 - 0.1426603512113796*u*v*w*z2 + 
     0.030141059746822362*u2*v*w*z2 - 0.003194707024362469*u3*v*w*z2 - 
     0.1301855269369699*v2*w*z2 + 0.019903204118841892*u*v2*w*z2 - 
     0.001739141446927106*u2*v2*w*z2 + 0.02833198919577561*v3*w*z2 - 
     0.0017876398103266954*u*v3*w*z2 - 0.0031230558273987455*v4*w*z2 + 
     0.22380566397463328*w2*z2 - 0.4512141792339346*lnbara*w2*z2 - 
     0.03755338566787545*u*w2*z2 + 0.15040472641131153*lnbara*u*w2*z2 + 
     0.0012821581494826362*u2*w2*z2 - 0.0345475125672679*lnbara*u2*w2*
      z2 + 0.0005520821852506379*u3*w2*z2 + 0.003838612507474211*lnbara*
      u3*w2*z2 - 0.17655955408877413*v*w2*z2 + 
     0.031379640471409696*u*v*w2*z2 - 0.002972087316778959*u2*v*w2*z2 + 
     0.02528635523080116*v2*w2*z2 - 0.001853838481410454*u*v2*w2*z2 - 
     0.0023037031758568953*v3*w2*z2 - 0.056596724949092986*w3*z2 + 
     0.20053963521508203*lnbara*w3*z2 + 0.002509582132846931*u*w3*z2 - 
     0.03861907128134787*lnbara*u*w3*z2 + 0.0004498411241904846*u2*w3*
      z2 + 0.003838612507474211*lnbara*u2*w3*z2 + 
     0.043027637873180646*v*w3*z2 - 0.0034048489476472465*u*v*w3*z2 - 
     0.0025854864042796264*v2*w3*z2 + 0.004722025453367396*w4*z2 - 
     0.055892827564981824*lnbara*w4*z2 + 0.00046180105924941995*u*w4*z2 + 
     0.004629629629629629*lnbara*u*w4*z2 - 0.005014303821094131*v*w4*z2 + 
     0.0006183344116792466*w5*z2 + 0.00709100055854524*lnbara*w5*z2 - 
     1.5053104503806145*y*z2 + 0.4679101100870634*u*y*z2 - 
     0.15726059911862464*u2*y*z2 + 0.03738755004957848*u3*y*z2 - 
     0.004294458827781368*u4*y*z2 + 0.3780687567263677*v*y*z2 - 
     0.09158761699667091*u*v*y*z2 + 0.017747490188925512*u2*v*y*z2 - 
     0.001791718617657013*u3*v*y*z2 - 0.11674571633666242*v2*y*z2 + 
     0.01642275124834286*u*v2*y*z2 - 0.0013617046024370035*u2*v2*y*z2 + 
     0.0266875066284785*v3*y*z2 - 0.0015989423718971896*u*v3*y*z2 - 
     0.0030019939085982657*v4*y*z2 + 0.5023951392934956*w*y*z2 - 
     0.1426603512113796*u*w*y*z2 + 0.030141059746822362*u2*w*y*z2 - 
     0.003194707024362469*u3*w*y*z2 - 0.10597941411274388*v*w*y*z2 + 
     0.01725372623767659*u*v*w*y*z2 - 0.0015503600732354181*u2*v*w*y*z2 + 
     0.019903204118841892*v2*w*y*z2 - 0.001382278607211708*u*v2*w*y*z2 - 
     0.0019906820746583257*v3*w*y*z2 - 0.17655955408877413*w2*y*z2 + 
     0.031379640471409696*u*w2*y*z2 - 0.002972087316778959*u2*w2*y*z2 + 
     0.02242442610919754*v*w2*y*z2 - 0.001685757015386744*u*v*w2*y*z2 - 
     0.001853838481410454*v2*w2*y*z2 + 0.043027637873180646*w3*y*z2 - 
     0.0034048489476472465*u*w3*y*z2 - 0.002384224310314243*v*w3*y*z2 - 
     0.005014303821094131*w4*y*z2 + 0.5971683922836196*y2*z2 - 
     0.11674571633666242*u*y2*z2 + 0.02115367400201526*u2*y2*z2 - 
     0.0020767314249685157*u3*y2*z2 - 0.11674571633666242*v*y2*z2 + 
     0.01642275124834286*u*v*y2*z2 - 0.0013617046024370035*u2*v*y2*z2 + 
     0.02115367400201526*v2*y2*z2 - 0.0013617046024370035*u*v2*y2*z2 - 
     0.0020767314249685157*v3*y2*z2 - 0.1301855269369699*w*y2*z2 + 
     0.019903204118841892*u*w*y2*z2 - 0.001739141446927106*u2*w*y2*z2 + 
     0.019903204118841892*v*w*y2*z2 - 0.001382278607211708*u*v*w*y2*z2 - 
     0.001739141446927106*v2*w*y2*z2 + 0.02528635523080116*w2*y2*z2 - 
     0.001853838481410454*u*w2*y2*z2 - 0.001853838481410454*v*w2*y2*
      z2 - 0.0025854864042796264*w3*y2*z2 - 0.23797136954009399*y3*z2 + 
     0.024931869805558025*u*y3*z2 - 0.0018641464676133518*u2*y3*z2 + 
     0.0266875066284785*v*y3*z2 - 0.0015989423718971896*u*v*y3*z2 - 
     0.0020767314249685157*v2*y3*z2 + 0.02833198919577561*w*y3*z2 - 
     0.0017876398103266954*u*w*y3*z2 - 0.0019906820746583257*v*w*y3*z2 - 
     0.0023037031758568953*w2*y3*z2 + 0.0630184547186927*y4*z2 - 
     0.002720137747628636*u*y4*z2 - 0.0030019939085982657*v*y4*z2 - 
     0.0031230558273987455*w*y4*z2 - 0.007769887708739977*y5*z2 - 
     0.8231719544268136*z3 + 1.7117182007280785*lnbara*z3 - 
     0.4166666666666667*lnbara2*z3 + 0.06876515362625549*u*z3 - 
     0.6829286069220218*lnbara*u*z3 - 0.022064530698388034*u2*z3 + 
     0.20053963521508203*lnbara*u2*z3 - 0.0024132847646464893*u3*z3 - 
     0.046296296296296294*lnbara*u3*z3 + 0.0011355462303617014*u4*z3 + 
     0.005269398380875331*lnbara*u4*z3 + 1.1595103369494308*v*z3 - 
     0.20715657704752188*u*v*z3 + 0.03738755004957848*u2*v*z3 - 
     0.0036899420821654982*u3*v*z3 - 0.23797136954009399*v2*z3 + 
     0.0266875066284785*u*v2*z3 - 0.0020767314249685157*u2*v2*z3 + 
     0.04797251819186834*v3*z3 - 0.00231214789919763*u*v3*z3 - 
     0.005107942897122393*v4*z3 + 0.09625212847865466*w*z3 - 
     0.6829286069220218*lnbara*w*z3 - 0.02727490919718466*u*w*z3 + 
     0.18157951888431673*lnbara*u*w*z3 - 0.0003461985960501892*u2*w*z3 - 
     0.03861907128134787*lnbara*u2*w*z3 + 0.0007087990860838744*u3*w*z3 + 
     0.004141109249293644*lnbara*u3*w*z3 - 0.21501849683495838*v*w*z3 + 
     0.03507305583697824*u*v*w*z3 - 0.003194707024362469*u2*v*w*z3 + 
     0.02833198919577561*v2*w*z3 - 0.0019906820746583257*u*v2*w*z3 - 
     0.002484679216493939*v3*w*z3 - 0.036984774410399074*w2*z3 + 
     0.20053963521508203*lnbara*w2*z3 + 0.0007514758984751476*u*w2*z3 - 
     0.03861907128134787*lnbara*u*w2*z3 + 0.0005520821852506379*u2*w2*
      z3 + 0.003838612507474211*lnbara*u2*w2*z3 + 
     0.039886472505265586*v*w2*z3 - 0.003275828338900795*u*v*w2*z3 - 
     0.0023037031758568953*v2*w2*z3 + 0.0019134967351693904*w3*z3 - 
     0.046296296296296294*lnbara*w3*z3 + 0.0005177430923563043*u*w3*z3 + 
     0.004141109249293644*lnbara*u*w3*z3 - 0.004003458840761125*v*w3*z3 + 
     0.0005843696903917379*w4*z3 + 0.005269398380875331*lnbara*w4*z3 + 
     1.1595103369494308*y*z3 - 0.20715657704752188*u*y*z3 + 
     0.03738755004957848*u2*y*z3 - 0.0036899420821654982*u3*y*z3 - 
     0.1565521245743462*v*y*z3 + 0.021578507461480923*u*v*y*z3 - 
     0.001791718617657013*u2*v*y*z3 + 0.024931869805558025*v2*y*z3 - 
     0.0015989423718971896*u*v2*y*z3 - 0.00231214789919763*v3*y*z3 - 
     0.21501849683495838*w*y*z3 + 0.03507305583697824*u*w*y*z3 - 
     0.003194707024362469*u2*w*y*z3 + 0.023414477764682844*v*w*y*z3 - 
     0.0017507925438618114*u*v*w*y*z3 - 0.0017876398103266954*v2*w*y*z3 + 
     0.039886472505265586*w2*y*z3 - 0.003275828338900795*u*w2*y*z3 - 
     0.002056880745742084*v*w2*y*z3 - 0.004003458840761125*w3*y*z3 - 
     0.23797136954009399*y2*z3 + 0.0266875066284785*u*y2*z3 - 
     0.0020767314249685157*u2*y2*z3 + 0.024931869805558025*v*y2*z3 - 
     0.0015989423718971896*u*v*y2*z3 - 0.0018641464676133518*v2*y2*z3 + 
     0.02833198919577561*w*y2*z3 - 0.0019906820746583257*u*w*y2*z3 - 
     0.0017876398103266954*v*w*y2*z3 - 0.0023037031758568953*w2*y2*z3 + 
     0.04797251819186834*y3*z3 - 0.00231214789919763*u*y3*z3 - 
     0.00231214789919763*v*y3*z3 - 0.002484679216493939*w*y3*z3 - 
     0.005107942897122393*y4*z3 + 0.20216246542587063*z4 - 
     1.3702538972670675*lnbara*z4 + 0.4166666666666667*lnbara2*z4 + 
     0.06985541595255951*u*z4 + 0.36653175786289616*lnbara*u*z4 - 
     0.005764996453097809*u2*z4 - 0.055892827564981824*lnbara*u2*z4 + 
     0.0011355462303617014*u3*z4 + 0.005269398380875331*lnbara*u3*z4 - 
     0.6059652683278195*v*z4 + 0.057377869360117656*u*v*z4 - 
     0.004294458827781368*u2*v*z4 + 0.0630184547186927*v2*z4 - 
     0.0030019939085982657*u*v2*z4 - 0.005107942897122393*v3*z4 + 
     0.0606312665629839*w*z4 + 0.36653175786289616*lnbara*w*z4 - 
     0.004101711971109271*u*w*z4 - 0.0521706881608105*lnbara*u*w*z4 + 
     0.000876262754005557*u2*w*z4 + 0.004629629629629629*lnbara*u2*w*z4 + 
     0.058778134166543324*v*w*z4 - 0.004099957104318314*u*v*w*z4 - 
     0.0031230558273987455*v2*w*z4 - 0.003073840573429086*w2*z4 - 
     0.055892827564981824*lnbara*w2*z4 + 0.0007856967829390636*u*w2*z4 + 
     0.004629629629629629*lnbara*u*w2*z4 - 0.004483995136656385*v*w2*z4 + 
     0.000809549773107401*w3*z4 + 0.005269398380875331*lnbara*w3*z4 - 
     0.6059652683278195*y*z4 + 0.057377869360117656*u*y*z4 - 
     0.004294458827781368*u2*y*z4 + 0.04209594617507414*v*y*z4 - 
     0.0024621270486790818*u*v*y*z4 - 0.002720137747628636*v2*y*z4 + 
     0.058778134166543324*w*y*z4 - 0.004099957104318314*u*w*y*z4 - 
     0.0025998411220075207*v*w*y*z4 - 0.004483995136656385*w2*y*z4 + 
     0.0630184547186927*y2*z4 - 0.0030019939085982657*u*y2*z4 - 
     0.002720137747628636*v*y2*z4 - 0.0031230558273987455*w*y2*z4 - 
     0.005107942897122393*y3*z4 + 0.09499129157249676*z5 + 
     0.675539635215082*lnbara*z5 - 0.25*lnbara2*z5 - 
     0.047766973149609884*u*z5 - 0.11382143448700363*lnbara*u*z5 + 
     0.0020142025327139768*u2*z5 + 0.00709100055854524*lnbara*u2*z5 + 
     0.18552833550330372*v*z5 - 0.007244575946872198*u*v*z5 - 
     0.007769887708739977*v2*z5 - 0.0457138816682174*w*z5 - 
     0.11382143448700363*lnbara*w*z5 + 0.0017955414211713314*u*w*z5 + 
     0.006730433928458395*lnbara*u*w*z5 - 0.007372846802421446*v*w*z5 + 
     0.0017654969488961178*w2*z5 + 0.00709100055854524*lnbara*w2*z5 + 
     0.18552833550330372*y*z5 - 0.007244575946872198*u*y*z5 - 
     0.005230685402774597*v*y*z5 - 0.007372846802421446*w*y*z5 - 
     0.007769887708739977*y2*z5 - 0.07792639988896227*z6 - 
     0.1872394002426928*lnbara*z6 + 0.08333333333333333*lnbara2*z6 + 
     0.0094053630927925*u*z6 + 0.01548483324024246*lnbara*u*z6 - 
     0.02502340865562592*v*z6 + 0.009188839992349455*w*z6 + 
     0.01548483324024246*lnbara*w*z6 - 0.02502340865562592*y*z6 + 
     0.01562557344501031*z7 + 0.02232424768031541*lnbara*z7 - 
     0.011904761904761904*lnbara2*z7;
 
  Gexp[8] = 0.7321716360225885 - 0.44107142857142856*lnbara + 
     0.05357142857142857*lnbara2 - 1.2119431337444038*u + 
     0.6357142857142857*lnbara*u - 0.07142857142857142*lnbara2*u + 
     1.49959556042469*u2 - 1.4436975871035138*lnbara*u2 + 
     0.25*lnbara2*u2 - 1.330149985457792*u3 + 2.2207285075403607*lnbara*
      u3 - 0.5*lnbara2*u3 + 0.6458071724555728*u4 - 
     2.2637141792339346*lnbara*u4 + 0.625*lnbara2*u4 - 
     0.035197295260033824*u5 + 1.5177459370968307*lnbara*u5 - 
     0.5*lnbara2*u5 - 0.14015949954554044*u6 - 0.6450515340614117*lnbara*
      u6 + 0.25*lnbara2*u6 + 0.07142919298974644*u7 + 
     0.15775500989141628*lnbara*u7 - 0.07142857142857142*lnbara2*u7 - 
     0.011766764554686482*u8 - 0.016917752027425906*lnbara*u8 + 
     0.008928571428571428*lnbara2*u8 - 1.2119431337444038*v + 
     0.6357142857142857*lnbara*v - 0.07142857142857142*lnbara2*v + 
     1.7363044156749696*u*v - 1.8063725404567375*u2*v + 
     1.7392655054241464*u3*v - 1.211930536655639*u4*v + 
     0.5565850065099112*u5*v - 0.15014045193375553*u6*v + 
     0.01800569050603713*u7*v + 1.49959556042469*v2 - 
     1.4436975871035138*lnbara*v2 + 0.25*lnbara2*v2 - 
     1.8063725404567375*u*v2 + 0.8957525884254294*u2*v2 - 
     0.47594273908018797*u3*v2 + 0.18905536415607813*u4*v2 - 
     0.04661932625243986*u5*v2 + 0.005260726475147424*u6*v2 - 
     1.330149985457792*v3 + 2.2207285075403607*lnbara*v3 - 
     0.5*lnbara2*v3 + 1.7392655054241464*u*v3 - 0.47594273908018797*u2*
      v3 + 0.143917554575605*u3*v3 - 0.030647657382734356*u4*v3 + 
     0.0031576827739003242*u5*v3 + 0.6458071724555728*v4 - 
     2.2637141792339346*lnbara*v4 + 0.625*lnbara2*v4 - 
     1.211930536655639*u*v4 + 0.18905536415607813*u2*v4 - 
     0.030647657382734356*u3*v4 + 0.002726070724998416*u4*v4 - 
     0.035197295260033824*v5 + 1.5177459370968307*lnbara*v5 - 
     0.5*lnbara2*v5 + 0.5565850065099112*u*v5 - 0.04661932625243986*u2*
      v5 + 0.0031576827739003242*u3*v5 - 0.14015949954554044*v6 - 
     0.6450515340614117*lnbara*v6 + 0.25*lnbara2*v6 - 
     0.15014045193375553*u*v6 + 0.005260726475147424*u2*v6 + 
     0.07142919298974644*v7 + 0.15775500989141628*lnbara*v7 - 
     0.07142857142857142*lnbara2*v7 + 0.01800569050603713*u*v7 - 
     0.011766764554686482*v8 - 0.016917752027425906*lnbara*v8 + 
     0.008928571428571428*lnbara2*v8 - 1.0096005532030932*w + 
     0.9857142857142858*lnbara*w - 0.14285714285714285*lnbara2*w + 
     1.132888498699905*u*w - 0.7813024128964863*lnbara*u*w - 
     0.7393162088149705*u2*w + lnbara*u2*w + 0.31511034444848746*u3*w - 
     1.0243929103830327*lnbara*u3*w - 0.0009147194949975854*u4*w + 
     0.7330635157257923*lnbara*u4*w - 0.08023092776115039*u5*w - 
     0.3414643034610109*lnbara*u5*w + 0.039648206713854266*u6*w + 
     0.09290899944145475*lnbara*u6*w - 0.00658939908338011*u7*w - 
     0.011206496836004519*lnbara*u7*w + 1.132888498699905*v*w - 
     0.7813024128964863*lnbara*v*w - 1.2152056460289786*u*v*w + 
     0.7535927089402433*u2*v*w - 0.43003699366991677*u3*v*w + 
     0.17633440249962998*u4*v*w - 0.04423708081452867*u5*v*w + 
     0.005045032605736152*u6*v*w - 0.7393162088149705*v2*w + lnbara*v2*w + 
     0.7535927089402433*u*v2*w - 0.2603710538739398*u2*v2*w + 
     0.08499596758732683*u3*v2*w - 0.01873833496439247*u4*v2*w + 
     0.001967584154035969*u5*v2*w + 0.31511034444848746*v3*w - 
     1.0243929103830327*lnbara*v3*w - 0.43003699366991677*u*v3*w + 
     0.08499596758732683*u2*v3*w - 0.014908075298963635*u3*v3*w + 
     0.0013746585204415407*u4*v3*w - 0.0009147194949975854*v4*w + 
     0.7330635157257923*lnbara*v4*w + 0.17633440249962998*u*v4*w - 
     0.01873833496439247*u2*v4*w + 0.0013746585204415407*u3*v4*w - 
     0.08023092776115039*v5*w - 0.3414643034610109*lnbara*v5*w - 
     0.04423708081452867*u*v5*w + 0.001967584154035969*u2*v5*w + 
     0.039648206713854266*v6*w + 0.09290899944145475*lnbara*v6*w + 
     0.005045032605736152*u*v6*w - 0.00658939908338011*v7*w - 
     0.011206496836004519*lnbara*v7*w + 1.2678249388110159*w2 - 
     1.8873951742070274*lnbara*w2 + 0.5*lnbara2*w2 - 
     1.1060927613105411*u*w2 + lnbara*u*w2 + 0.44851204077043355*u2*w2 - 
     0.6768212688509019*lnbara*u2*w2 - 0.14081609389249217*u3*w2 + 
     0.40107927043016406*lnbara*u3*w2 + 0.018724892062203655*u4*w2 - 
     0.16767848269494548*lnbara*u4*w2 + 0.0035019811348314675*u5*w2 + 
     0.04254600335127144*lnbara*u5*w2 - 0.0011983236323822545*u6*w2 - 
     0.004887855481301699*lnbara*u6*w2 - 1.1060927613105411*v*w2 + 
     lnbara*v*w2 + 0.9405846605504001*u*v*w2 - 0.35311910817754827*u2*v*
      w2 + 0.11965941751579676*u3*v*w2 - 0.02690397081993831*u4*v*w2 + 
     0.0028582170878550506*u5*v*w2 + 0.44851204077043355*v2*w2 - 
     0.6768212688509019*lnbara*v2*w2 - 0.35311910817754827*u*v2*w2 + 
     0.07585906569240349*u2*v2*w2 - 0.013822219055141373*u3*v2*w2 + 
     0.0013006407407352707*u4*v2*w2 - 0.14081609389249217*v3*w2 + 
     0.40107927043016406*lnbara*v3*w2 + 0.11965941751579676*u*v3*w2 - 
     0.013822219055141373*u2*v3*w2 + 0.0010537837376492188*u3*v3*w2 + 
     0.018724892062203655*v4*w2 - 0.16767848269494548*lnbara*v4*w2 - 
     0.02690397081993831*u*v4*w2 + 0.0013006407407352707*u2*v4*w2 + 
     0.0035019811348314675*v5*w2 + 0.04254600335127144*lnbara*v5*w2 + 
     0.0028582170878550506*u*v5*w2 - 0.0011983236323822545*v6*w2 - 
     0.004887855481301699*lnbara*v6*w2 - 1.060859529207977*w3 + 
     2.4414570150807213*lnbara*w3 - 1.*lnbara2*w3 + 
     0.7821136878141817*u*w3 - 1.0243929103830327*lnbara*u*w3 - 
     0.18003999496988*u2*w3 + 0.40107927043016406*lnbara*u2*w3 + 
     0.02888863835365632*u3*w3 - 0.1388888888888889*lnbara*u3*w3 - 
     0.0004120997422309256*u4*w3 + 0.03161639028525199*lnbara*u4*w3 - 
     0.0005095764010007675*u5*w3 - 0.003384978503667747*lnbara*u5*w3 + 
     0.7821136878141817*v*w3 - 1.0243929103830327*lnbara*v*w3 - 
     0.5774492165623843*u*v*w3 + 0.12908291361954194*u2*v*w3 - 
     0.024020753044566752*u3*v*w3 + 0.002288117132733893*u4*v*w3 - 
     0.18003999496988*v2*w3 + 0.40107927043016406*lnbara*v2*w3 + 
     0.12908291361954194*u*v2*w3 - 0.01551291842567776*u2*v2*w3 + 
     0.0012080368273358105*u3*v2*w3 + 0.02888863835365632*v3*w3 - 
     0.1388888888888889*lnbara*v3*w3 - 0.024020753044566752*u*v3*w3 + 
     0.0012080368273358105*u2*v3*w3 - 0.0004120997422309256*v4*w3 + 
     0.03161639028525199*lnbara*v4*w3 + 0.002288117132733893*u*v4*w3 - 
     0.0005095764010007675*v5*w3 - 0.003384978503667747*lnbara*v5*w3 + 
     0.5439607236957894*w4 - 2.027428358467869*lnbara*w4 + 
     1.25*lnbara2*w4 - 0.36126607525541354*u*w4 + 
     0.7330635157257923*lnbara*u*w4 + 0.0421124901425931*u2*w4 - 
     0.16767848269494548*lnbara*u2*w4 - 0.0017631802385249043*u3*w4 + 
     0.03161639028525199*lnbara*u3*w4 - 0.00032828045176791254*u4*w4 - 
     0.0030360036294498475*lnbara*u4*w4 - 0.36126607525541354*v*w4 + 
     0.7330635157257923*lnbara*v*w4 + 0.24486689358283967*u*v*w4 - 
     0.03008582292656479*u2*v*w4 + 0.002373235870460425*u3*v*w4 + 
     0.0421124901425931*v2*w4 - 0.16767848269494548*lnbara*v2*w4 - 
     0.03008582292656479*u*v2*w4 + 0.0015468623265518214*u2*v2*w4 - 
     0.0017631802385249043*v3*w4 + 0.03161639028525199*lnbara*v3*w4 + 
     0.002373235870460425*u*v3*w4 - 0.00032828045176791254*v4*w4 - 
     0.0030360036294498475*lnbara*v4*w4 - 0.14615571875230068*w5 + 
     1.0354918741936614*lnbara*w5 - 1.*lnbara2*w5 + 
     0.09390116503921771*u*w5 - 0.3414643034610109*lnbara*u*w5 - 
     0.00338099408846976*u2*w5 + 0.04254600335127144*lnbara*u2*w5 - 
     0.0002861013781231583*u3*w5 - 0.003384978503667747*lnbara*u3*w5 + 
     0.09390116503921771*v*w5 - 0.3414643034610109*lnbara*v*w5 - 
     0.06258188349808913*u*v*w5 + 0.0032620105692251983*u2*v*w5 - 
     0.00338099408846976*v2*w5 + 0.04254600335127144*lnbara*v2*w5 + 
     0.0032620105692251983*u*v2*w5 - 0.0002861013781231583*v3*w5 - 
     0.003384978503667747*lnbara*v3*w5 + 0.010477082683338539*w6 - 
     0.29010306812282344*lnbara*w6 + 0.5*lnbara2*w6 - 
     0.008754399311784065*u*w6 + 0.09290899944145475*lnbara*u*w6 - 
     0.0003407921988201555*u2*w6 - 0.004887855481301699*lnbara*u2*w6 - 
     0.008754399311784065*v*w6 + 0.09290899944145475*lnbara*v*w6 + 
     0.007220363850737711*u*v*w6 - 0.0003407921988201555*v2*w6 - 
     0.004887855481301699*lnbara*v2*w6 + 0.0020090616972084545*w7 + 
     0.02979573406854684*lnbara*w7 - 0.14285714285714285*lnbara2*w7 - 
     0.0006696872324028182*u*w7 - 0.011206496836004519*lnbara*u*w7 - 
     0.0006696872324028182*v*w7 - 0.011206496836004519*lnbara*v*w7 + 
     0.00008371090405035228*w8 + 0.0018787816594339048*lnbara*w8 + 
     0.017857142857142856*lnbara2*w8 - 1.2119431337444038*y + 
     0.6357142857142857*lnbara*y - 0.07142857142857142*lnbara2*y + 
     1.7363044156749696*u*y - 1.8063725404567375*u2*y + 
     1.7392655054241464*u3*y - 1.211930536655639*u4*y + 
     0.5565850065099112*u5*y - 0.15014045193375553*u6*y + 
     0.01800569050603713*u7*y + 0.878913485311602*v*y - 
     0.7813024128964863*lnbara*v*y - 0.9885653430969441*u*v*y + 
     0.5671031350895516*u2*v*y - 0.3131042491486924*u3*v*y + 
     0.1262878385252224*u4*v*y - 0.03138411241664758*u5*v*y + 
     0.003557820085944631*u6*v*y - 0.6550621164463183*v2*y + lnbara*v2*y + 
     0.7018651651305952*u*v2*y - 0.23349143267332484*u2*v2*y + 
     0.07479560941667407*u3*v2*y - 0.01632082648577182*u4*v2*y + 
     0.0017031606129609958*u5*v2*y + 0.2738798821698887*v3*y - 
     1.0243929103830327*lnbara*v3*y - 0.41431315409504377*u*v3*y + 
     0.0800625198854355*u2*v3*y - 0.01387288739518578*u3*v3*y + 
     0.001270334042999831*u4*v3*y + 0.01753357928415362*v4*y + 
     0.7330635157257923*lnbara*v4*y + 0.17213360808035297*u*v4*y - 
     0.018011963451589594*u2*v4*y + 0.0013099680497976988*u3*v4*y - 
     0.08639020220532784*v5*y - 0.3414643034610109*lnbara*v5*y - 
     0.04346745568123319*u*v5*y + 0.001911174312857377*u2*v5*y + 
     0.04094734531651254*v6*y + 0.09290899944145475*lnbara*v6*y + 
     0.00497631274951997*u*v6*y - 0.006717058480948745*v7*y - 
     0.011206496836004519*lnbara*v7*y + 1.132888498699905*w*y - 
     0.7813024128964863*lnbara*w*y - 1.2152056460289786*u*w*y + 
     0.7535927089402433*u2*w*y - 0.43003699366991677*u3*w*y + 
     0.17633440249962998*u4*w*y - 0.04423708081452867*u5*w*y + 
     0.005045032605736152*u6*w*y - 0.6761017598904502*v*w*y + 
     0.6878144773789178*lnbara*v*w*y + 0.59024403664156*u*v*w*y - 
     0.21195882822548776*u2*v*w*y + 0.07024343329404853*u3*v*w*y - 
     0.015599046732045124*u4*v*w*y + 0.0016446715859244178*u5*v*w*y + 
     0.34704051130803615*v2*w*y - 0.5731787311490981*lnbara*v2*w*y - 
     0.2853207024227592*u*v2*w*y + 0.05970961235652567*u2*v2*w*y - 
     0.010725838861960173*u3*v2*w*y + 0.0010009197339258765*u4*v2*w*y - 
     0.11507632468914157*v3*w*y + 0.36315903776863345*lnbara*v3*w*y + 
     0.10521916751093474*u*v3*w*y - 0.011944092447949953*u2*v3*w*y + 
     0.0009016198300664359*u3*v3*w*y + 0.013780208167077434*v4*w*y - 
     0.1565120644824315*lnbara*v4*w*y - 0.02459974262590988*u*v4*w*y + 
     0.0011742374174915872*u2*v4*w*y + 0.004042814598569594*v5*w*y + 
     0.040382603570750374*lnbara*v5*w*y + 0.002670611110405308*u*v5*w*y - 
     0.0012158310769012908*v6*w*y - 0.004687810626819727*lnbara*v6*w*y - 
     1.1060927613105411*w2*y + lnbara*w2*y + 0.9405846605504001*u*w2*y - 
     0.35311910817754827*u2*w2*y + 0.11965941751579676*u3*w2*y - 
     0.02690397081993831*u4*w2*y + 0.0028582170878550506*u5*w2*y + 
     0.40592934046849305*v*w2*y - 0.5731787311490981*lnbara*v*w2*y - 
     0.3087572799021273*u*v*w2*y + 0.06727327832759263*u2*v*w2*y - 
     0.012341284474452504*u3*v*w2*y + 0.0011655861883641662*u4*v*w2*y - 
     0.12524168013952142*v2*w2*y + 0.30080945282262306*lnbara*v2*w2*y + 
     0.09413892141422908*u*v2*w2*y - 0.011123030888462724*u2*v2*w2*y + 
     0.0008576480370907614*u3*v2*w2*y + 0.02156396333609938*v3*w2*y - 
     0.11585721384404363*lnbara*v3*w2*y - 0.019654970033404773*u*v3*w2*
      y + 0.0009765463601544392*u2*v3*w2*y + 0.00008455106800475184*v4*
      w2*y + 0.027777777777777776*lnbara*v4*w2*y + 
     0.0019816663126266698*u*v4*w2*y - 0.0004997443132457395*v5*w2*y - 
     0.0030639349524580017*lnbara*v5*w2*y + 0.7821136878141817*w3*y - 
     1.0243929103830327*lnbara*w3*y - 0.5774492165623843*u*w3*y + 
     0.12908291361954194*u2*w3*y - 0.024020753044566752*u3*w3*y + 
     0.002288117132733893*u4*w3*y - 0.16841202717054396*v*w3*y + 
     0.36315903776863345*lnbara*v*w3*y + 0.11827421043881324*u*v*w3*y - 
     0.014305345861885458*u2*v*w3*y + 0.0011178896264369238*u3*v*w3*y + 
     0.02683828203921473*v2*w3*y - 0.11585721384404363*lnbara*v2*w3*y - 
     0.020429093685883477*u*v2*w3*y + 0.0010386240777278052*u2*v2*w3*y - 
     0.0010346506951558188*v3*w3*y + 0.024846655495761868*lnbara*v3*w3*
      y + 0.0018413777506809327*u*v3*w3*y - 0.0003031307111613726*v4*w3*
      y - 0.0025474832491138625*lnbara*v4*w3*y - 0.36126607525541354*w4*
      y + 0.7330635157257923*lnbara*w4*y + 0.24486689358283967*u*w4*y - 
     0.03008582292656479*u2*w4*y + 0.002373235870460425*u3*w4*y + 
     0.04033363311928662*v*w4*y - 0.1565120644824315*lnbara*v*w4*y - 
     0.028240538984487286*u*v*w4*y + 0.0014569340256667344*u2*v*w4*y - 
     0.00185882327413311*v2*w4*y + 0.027777777777777776*lnbara*v2*w4*y + 
     0.0021054037902871444*u*v2*w4*y - 0.0002396628047085045*v3*w4*y - 
     0.0025474832491138625*lnbara*v3*w4*y + 0.09390116503921771*w5*y - 
     0.3414643034610109*lnbara*w5*y - 0.06258188349808913*u*w5*y + 
     0.0032620105692251983*u2*w5*y - 0.003350179034613246*v*w5*y + 
     0.040382603570750374*lnbara*v*w5*y + 0.0031058290583810336*u*v*w5*y - 
     0.0002399697226902283*v2*w5*y - 0.0030639349524580017*lnbara*v2*w5*
      y - 0.008754399311784065*w6*y + 0.09290899944145475*lnbara*w6*y + 
     0.007220363850737711*u*w6*y - 0.00031693336523131804*v*w6*y - 
     0.004687810626819727*lnbara*v*w6*y - 0.0006696872324028182*w7*y - 
     0.011206496836004519*lnbara*w7*y + 1.49959556042469*y2 - 
     1.4436975871035138*lnbara*y2 + 0.25*lnbara2*y2 - 
     1.8063725404567375*u*y2 + 0.8957525884254294*u2*y2 - 
     0.47594273908018797*u3*y2 + 0.18905536415607813*u4*y2 - 
     0.04661932625243986*u5*y2 + 0.005260726475147424*u6*y2 - 
     0.6550621164463183*v*y2 + lnbara*v*y2 + 0.7018651651305952*u*v*y2 - 
     0.23349143267332484*u2*v*y2 + 0.07479560941667407*u3*v*y2 - 
     0.01632082648577182*u4*v*y2 + 0.0017031606129609958*u5*v*y2 + 
     0.3514500470763496*v2*y2 - 0.6768212688509019*lnbara*v2*y2 - 
     0.3145211982372493*u*v2*y2 + 0.06346102200604578*u2*v2*y2 - 
     0.011184878805680112*u3*v2*y2 + 0.0010325956586233194*u4*v2*y2 - 
     0.11097560646847007*v3*y2 + 0.40107927043016406*lnbara*v3*y2 + 
     0.11216265014873544*u*v3*y2 - 0.012460388549811095*u2*v3*y2 + 
     0.000929170356268885*u3*v3*y2 + 0.010651424423197484*v4*y2 - 
     0.16767848269494548*lnbara*v4*y2 - 0.02576675296668821*u*v4*y2 + 
     0.0012120200398115979*u2*v4*y2 + 0.004994214637738621*v5*y2 + 
     0.04254600335127144*lnbara*v5*y2 + 0.0027683707923909567*u*v5*y2 - 
     0.001332365186004987*v6*y2 - 0.004887855481301699*lnbara*v6*y2 - 
     0.7393162088149705*w*y2 + lnbara*w*y2 + 0.7535927089402433*u*w*y2 - 
     0.2603710538739398*u2*w*y2 + 0.08499596758732683*u3*w*y2 - 
     0.01873833496439247*u4*w*y2 + 0.001967584154035969*u5*w*y2 + 
     0.34704051130803615*v*w*y2 - 0.5731787311490981*lnbara*v*w*y2 - 
     0.2853207024227592*u*v*w*y2 + 0.05970961235652567*u2*v*w*y2 - 
     0.010725838861960173*u3*v*w*y2 + 0.0010009197339258765*u4*v*w*y2 - 
     0.11090415302007936*v2*w*y2 + 0.30080945282262306*lnbara*v2*w*y2 + 
     0.09042317924046708*u*v2*w*y2 - 0.010434848681562636*u2*v2*w*y2 + 
     0.0007939134731674265*u3*v2*w*y2 + 0.018270939852523368*v3*w*y2 - 
     0.11585721384404363*lnbara*v3*w*y2 - 0.019168242146174814*u*v3*w*
      y2 + 0.0009375065759672177*u2*v3*w*y2 + 0.0006279468944037123*v4*w*
      y2 + 0.027777777777777776*lnbara*v4*w*y2 + 
     0.001947021061827816*u*v4*w*y2 - 0.0005447808657404928*v5*w*y2 - 
     0.0030639349524580017*lnbara*v5*w*y2 + 0.44851204077043355*w2*y2 - 
     0.6768212688509019*lnbara*w2*y2 - 0.35311910817754827*u*w2*y2 + 
     0.07585906569240349*u2*w2*y2 - 0.013822219055141373*u3*w2*y2 + 
     0.0013006407407352707*u4*w2*y2 - 0.12524168013952142*v*w2*y2 + 
     0.30080945282262306*lnbara*v*w2*y2 + 0.09413892141422908*u*v*w2*y2 - 
     0.011123030888462724*u2*v*w2*y2 + 0.0008576480370907614*u3*v*w2*
      y2 + 0.021120230732081857*v2*w2*y2 - 0.10364253770180369*lnbara*v2*
      w2*y2 - 0.017832523900673754*u*v2*w2*y2 + 
     0.0008927349168409385*u2*v2*w2*y2 - 0.0005261193959703832*v3*w2*
      y2 + 0.023031675044845268*lnbara*v3*w2*y2 + 
     0.001678200058612197*u*v3*w2*y2 - 0.00031988499677263827*v4*w2*
      y2 - 0.0024078266340730905*lnbara*v4*w2*y2 - 
     0.18003999496988*w3*y2 + 0.40107927043016406*lnbara*w3*y2 + 
     0.12908291361954194*u*w3*y2 - 0.01551291842567776*u2*w3*y2 + 
     0.0012080368273358105*u3*w3*y2 + 0.02683828203921473*v*w3*y2 - 
     0.11585721384404363*lnbara*v*w3*y2 - 0.020429093685883477*u*v*w3*
      y2 + 0.0010386240777278052*u2*v*w3*y2 - 0.0011395657623313037*v2*
      w3*y2 + 0.023031675044845268*lnbara*v2*w3*y2 + 
     0.0017183262741199826*u*v2*w3*y2 - 0.0002384653713632691*v3*w3*
      y2 - 0.002233394751425484*lnbara*v3*w3*y2 + 
     0.0421124901425931*w4*y2 - 0.16767848269494548*lnbara*w4*y2 - 
     0.03008582292656479*u*w4*y2 + 0.0015468623265518214*u2*w4*y2 - 
     0.00185882327413311*v*w4*y2 + 0.027777777777777776*lnbara*v*w4*y2 + 
     0.0021054037902871444*u*v*w4*y2 - 0.00021657363943226177*v2*w4*y2 - 
     0.0024078266340730905*lnbara*v2*w4*y2 - 0.00338099408846976*w5*y2 + 
     0.04254600335127144*lnbara*w5*y2 + 0.0032620105692251983*u*w5*y2 - 
     0.0002399697226902283*v*w5*y2 - 0.0030639349524580017*lnbara*v*w5*
      y2 - 0.0003407921988201555*w6*y2 - 0.004887855481301699*lnbara*w6*
      y2 - 1.330149985457792*y3 + 2.2207285075403607*lnbara*y3 - 
     0.5*lnbara2*y3 + 1.7392655054241464*u*y3 - 0.47594273908018797*u2*
      y3 + 0.143917554575605*u3*y3 - 0.030647657382734356*u4*y3 + 
     0.0031576827739003242*u5*y3 + 0.2738798821698887*v*y3 - 
     1.0243929103830327*lnbara*v*y3 - 0.41431315409504377*u*v*y3 + 
     0.0800625198854355*u2*v*y3 - 0.01387288739518578*u3*v*y3 + 
     0.001270334042999831*u4*v*y3 - 0.11097560646847007*v2*y3 + 
     0.40107927043016406*lnbara*v2*y3 + 0.11216265014873544*u*v2*y3 - 
     0.012460388549811095*u2*v2*y3 + 0.000929170356268885*u3*v2*y3 + 
     0.01590829385420868*v3*y3 - 0.1388888888888889*lnbara*v3*y3 - 
     0.02213965249299299*u*v3*y3 + 0.0010588370339842305*u2*v3*y3 + 
     0.0015438790012948771*v4*y3 + 0.03161639028525199*lnbara*v4*y3 + 
     0.0021644635339529753*u*v4*y3 - 0.0006639947469167062*v5*y3 - 
     0.003384978503667747*lnbara*v5*y3 + 0.31511034444848746*w*y3 - 
     1.0243929103830327*lnbara*w*y3 - 0.43003699366991677*u*w*y3 + 
     0.08499596758732683*u2*w*y3 - 0.014908075298963635*u3*w*y3 + 
     0.0013746585204415407*u4*w*y3 - 0.11507632468914157*v*w*y3 + 
     0.36315903776863345*lnbara*v*w*y3 + 0.10521916751093474*u*v*w*y3 - 
     0.011944092447949953*u2*v*w*y3 + 0.0009016198300664359*u3*v*w*y3 + 
     0.018270939852523368*v2*w*y3 - 0.11585721384404363*lnbara*v2*w*y3 - 
     0.019168242146174814*u*v2*w*y3 + 0.0009375065759672177*u2*v2*w*y3 + 
     0.00011168526720960141*v3*w*y3 + 0.024846655495761868*lnbara*v3*w*
      y3 + 0.0017670251675018884*u*v3*w*y3 - 0.0003861048986038681*v4*w*
      y3 - 0.0025474832491138625*lnbara*v4*w*y3 - 
     0.14081609389249217*w2*y3 + 0.40107927043016406*lnbara*w2*y3 + 
     0.11965941751579676*u*w2*y3 - 0.013822219055141373*u2*w2*y3 + 
     0.0010537837376492188*u3*w2*y3 + 0.02156396333609938*v*w2*y3 - 
     0.11585721384404363*lnbara*v*w2*y3 - 0.019654970033404773*u*v*w2*
      y3 + 0.0009765463601544392*u2*v*w2*y3 - 0.0005261193959703832*v2*
      w2*y3 + 0.023031675044845268*lnbara*v2*w2*y3 + 
     0.001678200058612197*u*v2*w2*y3 - 0.00027844820669121686*v3*w2*
      y3 - 0.002233394751425484*lnbara*v3*w2*y3 + 
     0.02888863835365632*w3*y3 - 0.1388888888888889*lnbara*w3*y3 - 
     0.024020753044566752*u*w3*y3 + 0.0012080368273358105*u2*w3*y3 - 
     0.0010346506951558188*v*w3*y3 + 0.024846655495761868*lnbara*v*w3*
      y3 + 0.0018413777506809327*u*v*w3*y3 - 0.0002384653713632691*v2*w3*
      y3 - 0.002233394751425484*lnbara*v2*w3*y3 - 
     0.0017631802385249043*w4*y3 + 0.03161639028525199*lnbara*w4*y3 + 
     0.002373235870460425*u*w4*y3 - 0.0002396628047085045*v*w4*y3 - 
     0.0025474832491138625*lnbara*v*w4*y3 - 0.0002861013781231583*w5*y3 - 
     0.003384978503667747*lnbara*w5*y3 + 0.6458071724555728*y4 - 
     2.2637141792339346*lnbara*y4 + 0.625*lnbara2*y4 - 
     1.211930536655639*u*y4 + 0.18905536415607813*u2*y4 - 
     0.030647657382734356*u3*y4 + 0.002726070724998416*u4*y4 + 
     0.01753357928415362*v*y4 + 0.7330635157257923*lnbara*v*y4 + 
     0.17213360808035297*u*v*y4 - 0.018011963451589594*u2*v*y4 + 
     0.0013099680497976988*u3*v*y4 + 0.010651424423197484*v2*y4 - 
     0.16767848269494548*lnbara*v2*y4 - 0.02576675296668821*u*v2*y4 + 
     0.0012120200398115979*u2*v2*y4 + 0.0015438790012948771*v3*y4 + 
     0.03161639028525199*lnbara*v3*y4 + 0.0021644635339529753*u*v3*y4 - 
     0.0005416818590033571*v4*y4 - 0.0030360036294498475*lnbara*v4*y4 - 
     0.0009147194949975854*w*y4 + 0.7330635157257923*lnbara*w*y4 + 
     0.17633440249962998*u*w*y4 - 0.01873833496439247*u2*w*y4 + 
     0.0013746585204415407*u3*w*y4 + 0.013780208167077434*v*w*y4 - 
     0.1565120644824315*lnbara*v*w*y4 - 0.02459974262590988*u*v*w*y4 + 
     0.0011742374174915872*u2*v*w*y4 + 0.0006279468944037123*v2*w*y4 + 
     0.027777777777777776*lnbara*v2*w*y4 + 0.001947021061827816*u*v2*w*
      y4 - 0.0003861048986038681*v3*w*y4 - 0.0025474832491138625*lnbara*
      v3*w*y4 + 0.018724892062203655*w2*y4 - 0.16767848269494548*lnbara*
      w2*y4 - 0.02690397081993831*u*w2*y4 + 0.0013006407407352707*u2*w2*
      y4 + 0.00008455106800475184*v*w2*y4 + 0.027777777777777776*lnbara*v*
      w2*y4 + 0.0019816663126266698*u*v*w2*y4 - 
     0.00031988499677263827*v2*w2*y4 - 0.0024078266340730905*lnbara*v2*
      w2*y4 - 0.0004120997422309256*w3*y4 + 0.03161639028525199*lnbara*
      w3*y4 + 0.002288117132733893*u*w3*y4 - 0.0003031307111613726*v*w3*
      y4 - 0.0025474832491138625*lnbara*v*w3*y4 - 
     0.00032828045176791254*w4*y4 - 0.0030360036294498475*lnbara*w4*y4 - 
     0.035197295260033824*y5 + 1.5177459370968307*lnbara*y5 - 
     0.5*lnbara2*y5 + 0.5565850065099112*u*y5 - 0.04661932625243986*u2*
      y5 + 0.0031576827739003242*u3*y5 - 0.08639020220532784*v*y5 - 
     0.3414643034610109*lnbara*v*y5 - 0.04346745568123319*u*v*y5 + 
     0.001911174312857377*u2*v*y5 + 0.004994214637738621*v2*y5 + 
     0.04254600335127144*lnbara*v2*y5 + 0.0027683707923909567*u*v2*y5 - 
     0.0006639947469167062*v3*y5 - 0.003384978503667747*lnbara*v3*y5 - 
     0.08023092776115039*w*y5 - 0.3414643034610109*lnbara*w*y5 - 
     0.04423708081452867*u*w*y5 + 0.001967584154035969*u2*w*y5 + 
     0.004042814598569594*v*w*y5 + 0.040382603570750374*lnbara*v*w*y5 + 
     0.002670611110405308*u*v*w*y5 - 0.0005447808657404928*v2*w*y5 - 
     0.0030639349524580017*lnbara*v2*w*y5 + 0.0035019811348314675*w2*y5 + 
     0.04254600335127144*lnbara*w2*y5 + 0.0028582170878550506*u*w2*y5 - 
     0.0004997443132457395*v*w2*y5 - 0.0030639349524580017*lnbara*v*w2*
      y5 - 0.0005095764010007675*w3*y5 - 0.003384978503667747*lnbara*w3*
      y5 - 0.14015949954554044*y6 - 0.6450515340614117*lnbara*y6 + 
     0.25*lnbara2*y6 - 0.15014045193375553*u*y6 + 
     0.005260726475147424*u2*y6 + 0.04094734531651254*v*y6 + 
     0.09290899944145475*lnbara*v*y6 + 0.00497631274951997*u*v*y6 - 
     0.001332365186004987*v2*y6 - 0.004887855481301699*lnbara*v2*y6 + 
     0.039648206713854266*w*y6 + 0.09290899944145475*lnbara*w*y6 + 
     0.005045032605736152*u*w*y6 - 0.0012158310769012908*v*w*y6 - 
     0.004687810626819727*lnbara*v*w*y6 - 0.0011983236323822545*w2*y6 - 
     0.004887855481301699*lnbara*w2*y6 + 0.07142919298974644*y7 + 
     0.15775500989141628*lnbara*y7 - 0.07142857142857142*lnbara2*y7 + 
     0.01800569050603713*u*y7 - 0.006717058480948745*v*y7 - 
     0.011206496836004519*lnbara*v*y7 - 0.00658939908338011*w*y7 - 
     0.011206496836004519*lnbara*w*y7 - 0.011766764554686482*y8 - 
     0.016917752027425906*lnbara*y8 + 0.008928571428571428*lnbara2*y8 - 
     1.2119431337444038*z + 0.6357142857142857*lnbara*z - 
     0.07142857142857142*lnbara2*z + 0.878913485311602*u*z - 
     0.7813024128964863*lnbara*u*z - 0.6550621164463183*u2*z + 
     lnbara*u2*z + 0.2738798821698887*u3*z - 1.0243929103830327*lnbara*u3*
      z + 0.01753357928415362*u4*z + 0.7330635157257923*lnbara*u4*z - 
     0.08639020220532784*u5*z - 0.3414643034610109*lnbara*u5*z + 
     0.04094734531651254*u6*z + 0.09290899944145475*lnbara*u6*z - 
     0.006717058480948745*u7*z - 0.011206496836004519*lnbara*u7*z + 
     1.7363044156749696*v*z - 0.9885653430969441*u*v*z + 
     0.7018651651305952*u2*v*z - 0.41431315409504377*u3*v*z + 
     0.17213360808035297*u4*v*z - 0.04346745568123319*u5*v*z + 
     0.00497631274951997*u6*v*z - 1.8063725404567375*v2*z + 
     0.5671031350895516*u*v2*z - 0.23349143267332484*u2*v2*z + 
     0.0800625198854355*u3*v2*z - 0.018011963451589594*u4*v2*z + 
     0.001911174312857377*u5*v2*z + 1.7392655054241464*v3*z - 
     0.3131042491486924*u*v3*z + 0.07479560941667407*u2*v3*z - 
     0.01387288739518578*u3*v3*z + 0.0013099680497976988*u4*v3*z - 
     1.211930536655639*v4*z + 0.1262878385252224*u*v4*z - 
     0.01632082648577182*u2*v4*z + 0.001270334042999831*u3*v4*z + 
     0.5565850065099112*v5*z - 0.03138411241664758*u*v5*z + 
     0.0017031606129609958*u2*v5*z - 0.15014045193375553*v6*z + 
     0.003557820085944631*u*v6*z + 0.01800569050603713*v7*z + 
     1.132888498699905*w*z - 0.7813024128964863*lnbara*w*z - 
     0.6761017598904502*u*w*z + 0.6878144773789178*lnbara*u*w*z + 
     0.34704051130803615*u2*w*z - 0.5731787311490981*lnbara*u2*w*z - 
     0.11507632468914157*u3*w*z + 0.36315903776863345*lnbara*u3*w*z + 
     0.013780208167077434*u4*w*z - 0.1565120644824315*lnbara*u4*w*z + 
     0.004042814598569594*u5*w*z + 0.040382603570750374*lnbara*u5*w*z - 
     0.0012158310769012908*u6*w*z - 0.004687810626819727*lnbara*u6*w*z - 
     1.2152056460289786*v*w*z + 0.59024403664156*u*v*w*z - 
     0.2853207024227592*u2*v*w*z + 0.10521916751093474*u3*v*w*z - 
     0.02459974262590988*u4*v*w*z + 0.002670611110405308*u5*v*w*z + 
     0.7535927089402433*v2*w*z - 0.21195882822548776*u*v2*w*z + 
     0.05970961235652567*u2*v2*w*z - 0.011944092447949953*u3*v2*w*z + 
     0.0011742374174915872*u4*v2*w*z - 0.43003699366991677*v3*w*z + 
     0.07024343329404853*u*v3*w*z - 0.010725838861960173*u2*v3*w*z + 
     0.0009016198300664359*u3*v3*w*z + 0.17633440249962998*v4*w*z - 
     0.015599046732045124*u*v4*w*z + 0.0010009197339258765*u2*v4*w*z - 
     0.04423708081452867*v5*w*z + 0.0016446715859244178*u*v5*w*z + 
     0.005045032605736152*v6*w*z - 1.1060927613105411*w2*z + lnbara*w2*z + 
     0.40592934046849305*u*w2*z - 0.5731787311490981*lnbara*u*w2*z - 
     0.12524168013952142*u2*w2*z + 0.30080945282262306*lnbara*u2*w2*z + 
     0.02156396333609938*u3*w2*z - 0.11585721384404363*lnbara*u3*w2*z + 
     0.00008455106800475184*u4*w2*z + 0.027777777777777776*lnbara*u4*w2*
      z - 0.0004997443132457395*u5*w2*z - 0.0030639349524580017*lnbara*u5*
      w2*z + 0.9405846605504001*v*w2*z - 0.3087572799021273*u*v*w2*z + 
     0.09413892141422908*u2*v*w2*z - 0.019654970033404773*u3*v*w2*z + 
     0.0019816663126266698*u4*v*w2*z - 0.35311910817754827*v2*w2*z + 
     0.06727327832759263*u*v2*w2*z - 0.011123030888462724*u2*v2*w2*z + 
     0.0009765463601544392*u3*v2*w2*z + 0.11965941751579676*v3*w2*z - 
     0.012341284474452504*u*v3*w2*z + 0.0008576480370907614*u2*v3*w2*z - 
     0.02690397081993831*v4*w2*z + 0.0011655861883641662*u*v4*w2*z + 
     0.0028582170878550506*v5*w2*z + 0.7821136878141817*w3*z - 
     1.0243929103830327*lnbara*w3*z - 0.16841202717054396*u*w3*z + 
     0.36315903776863345*lnbara*u*w3*z + 0.02683828203921473*u2*w3*z - 
     0.11585721384404363*lnbara*u2*w3*z - 0.0010346506951558188*u3*w3*z + 
     0.024846655495761868*lnbara*u3*w3*z - 0.0003031307111613726*u4*w3*
      z - 0.0025474832491138625*lnbara*u4*w3*z - 0.5774492165623843*v*w3*
      z + 0.11827421043881324*u*v*w3*z - 0.020429093685883477*u2*v*w3*z + 
     0.0018413777506809327*u3*v*w3*z + 0.12908291361954194*v2*w3*z - 
     0.014305345861885458*u*v2*w3*z + 0.0010386240777278052*u2*v2*w3*z - 
     0.024020753044566752*v3*w3*z + 0.0011178896264369238*u*v3*w3*z + 
     0.002288117132733893*v4*w3*z - 0.36126607525541354*w4*z + 
     0.7330635157257923*lnbara*w4*z + 0.04033363311928662*u*w4*z - 
     0.1565120644824315*lnbara*u*w4*z - 0.00185882327413311*u2*w4*z + 
     0.027777777777777776*lnbara*u2*w4*z - 0.0002396628047085045*u3*w4*
      z - 0.0025474832491138625*lnbara*u3*w4*z + 0.24486689358283967*v*w4*
      z - 0.028240538984487286*u*v*w4*z + 0.0021054037902871444*u2*v*w4*
      z - 0.03008582292656479*v2*w4*z + 0.0014569340256667344*u*v2*w4*z + 
     0.002373235870460425*v3*w4*z + 0.09390116503921771*w5*z - 
     0.3414643034610109*lnbara*w5*z - 0.003350179034613246*u*w5*z + 
     0.040382603570750374*lnbara*u*w5*z - 0.0002399697226902283*u2*w5*z - 
     0.0030639349524580017*lnbara*u2*w5*z - 0.06258188349808913*v*w5*z + 
     0.0031058290583810336*u*v*w5*z + 0.0032620105692251983*v2*w5*z - 
     0.008754399311784065*w6*z + 0.09290899944145475*lnbara*w6*z - 
     0.00031693336523131804*u*w6*z - 0.004687810626819727*lnbara*u*w6*z + 
     0.007220363850737711*v*w6*z - 0.0006696872324028182*w7*z - 
     0.011206496836004519*lnbara*w7*z + 1.7363044156749696*y*z - 
     0.9885653430969441*u*y*z + 0.7018651651305952*u2*y*z - 
     0.41431315409504377*u3*y*z + 0.17213360808035297*u4*y*z - 
     0.04346745568123319*u5*y*z + 0.00497631274951997*u6*y*z - 
     0.9885653430969441*v*y*z + 0.4109157481416769*u*v*y*z - 
     0.18317523399334182*u2*v*y*z + 0.06473552238444277*u3*v*y*z - 
     0.014772762292074491*u4*v*y*z + 0.0015798778632113992*u5*v*y*z + 
     0.7018651651305952*v2*y*z - 0.18317523399334182*u*v2*y*z + 
     0.04926825374502858*u2*v2*y*z - 0.009593654231383138*u3*v2*y*z + 
     0.0009279102407948306*u4*v2*y*z - 0.41431315409504377*v3*y*z + 
     0.06473552238444277*u*v3*y*z - 0.009593654231383138*u2*v3*y*z + 
     0.0007917184813914537*u3*v3*y*z + 0.17213360808035297*v4*y*z - 
     0.014772762292074491*u*v4*y*z + 0.0009279102407948306*u2*v4*y*z - 
     0.04346745568123319*v5*y*z + 0.0015798778632113992*u*v5*y*z + 
     0.00497631274951997*v6*y*z - 1.2152056460289786*w*y*z + 
     0.59024403664156*u*w*y*z - 0.2853207024227592*u2*w*y*z + 
     0.10521916751093474*u3*w*y*z - 0.02459974262590988*u4*w*y*z + 
     0.002670611110405308*u5*w*y*z + 0.59024403664156*v*w*y*z - 
     0.17826112061997315*u*v*w*y*z + 0.05176117871302977*u2*v*w*y*z - 
     0.010504755263170868*u3*v*w*y*z + 0.0010408374899911962*u4*v*w*y*z - 
     0.2853207024227592*v2*w*y*z + 0.05176117871302977*u*v2*w*y*z - 
     0.008293671643270249*u2*v2*w*y*z + 0.0007141774155409824*u3*v2*w*y*
      z + 0.10521916751093474*v3*w*y*z - 0.010504755263170868*u*v3*w*y*z + 
     0.0007141774155409824*u2*v3*w*y*z - 0.02459974262590988*v4*w*y*z + 
     0.0010408374899911962*u*v4*w*y*z + 0.002670611110405308*v5*w*y*z + 
     0.9405846605504001*w2*y*z - 0.3087572799021273*u*w2*y*z + 
     0.09413892141422908*u2*w2*y*z - 0.019654970033404773*u3*w2*y*z + 
     0.0019816663126266698*u4*w2*y*z - 0.3087572799021273*v*w2*y*z + 
     0.060346966077840625*u*v*w2*y*z - 0.010114542092320464*u2*v*w2*y*z + 
     0.0008946786933220228*u3*v*w2*y*z + 0.09413892141422908*v2*w2*y*z - 
     0.010114542092320464*u*v2*w2*y*z + 0.00071910562986183*u2*v2*w2*y*
      z - 0.019654970033404773*v3*w2*y*z + 0.0008946786933220228*u*v3*w2*
      y*z + 0.0019816663126266698*v4*w2*y*z - 0.5774492165623843*w3*y*z + 
     0.11827421043881324*u*w3*y*z - 0.020429093685883477*u2*w3*y*z + 
     0.0018413777506809327*u3*w3*y*z + 0.11827421043881324*v*w3*y*z - 
     0.013259198472372514*u*v*w3*y*z + 0.0009694445689965282*u2*v*w3*y*z - 
     0.020429093685883477*v2*w3*y*z + 0.0009694445689965282*u*v2*w3*y*z + 
     0.0018413777506809327*v3*w3*y*z + 0.24486689358283967*w4*y*z - 
     0.028240538984487286*u*w4*y*z + 0.0021054037902871444*u2*w4*y*z - 
     0.028240538984487286*v*w4*y*z + 0.0013759104801000723*u*v*w4*y*z + 
     0.0021054037902871444*v2*w4*y*z - 0.06258188349808913*w5*y*z + 
     0.0031058290583810336*u*w5*y*z + 0.0031058290583810336*v*w5*y*z + 
     0.007220363850737711*w6*y*z - 1.8063725404567375*y2*z + 
     0.5671031350895516*u*y2*z - 0.23349143267332484*u2*y2*z + 
     0.0800625198854355*u3*y2*z - 0.018011963451589594*u4*y2*z + 
     0.001911174312857377*u5*y2*z + 0.7018651651305952*v*y2*z - 
     0.18317523399334182*u*v*y2*z + 0.04926825374502858*u2*v*y2*z - 
     0.009593654231383138*u3*v*y2*z + 0.0009279102407948306*u4*v*y2*z - 
     0.3145211982372493*v2*y2*z + 0.05324247056677653*u*v2*y2*z - 
     0.00817022761462202*u2*v2*y2*z + 0.0006855605604060971*u3*v2*y2*
      z + 0.11216265014873544*v3*y2*z - 0.010750311705942078*u*v3*y2*z + 
     0.0007107796438381393*u2*v3*y2*z - 0.02576675296668821*v4*y2*z + 
     0.0010604472614234883*u*v4*y2*z + 0.0027683707923909567*v5*y2*z + 
     0.7535927089402433*w*y2*z - 0.21195882822548776*u*w*y2*z + 
     0.05970961235652567*u2*w*y2*z - 0.011944092447949953*u3*w*y2*z + 
     0.0011742374174915872*u4*w*y2*z - 0.2853207024227592*v*w*y2*z + 
     0.05176117871302977*u*v*w*y2*z - 0.008293671643270249*u2*v*w*y2*z + 
     0.0007141774155409824*u3*v*w*y2*z + 0.09042317924046708*v2*w*y2*z - 
     0.009302160439412508*u*v2*w*y2*z + 0.0006425989725751736*u2*v2*w*y2*
      z - 0.019168242146174814*v3*w*y2*z + 0.0008476691271990539*u*v3*w*
      y2*z + 0.001947021061827816*v4*w*y2*z - 0.35311910817754827*w2*y2*
      z + 0.06727327832759263*u*w2*y2*z - 0.011123030888462724*u2*w2*y2*
      z + 0.0009765463601544392*u3*w2*y2*z + 0.09413892141422908*v*w2*y2*
      z - 0.010114542092320464*u*v*w2*y2*z + 0.00071910562986183*u2*v*w2*
      y2*z - 0.017832523900673754*v2*w2*y2*z + 0.0008228748929587454*u*
      v2*w2*y2*z + 0.001678200058612197*v3*w2*y2*z + 
     0.12908291361954194*w3*y2*z - 0.014305345861885458*u*w3*y2*z + 
     0.0010386240777278052*u2*w3*y2*z - 0.020429093685883477*v*w3*y2*z + 
     0.0009694445689965282*u*v*w3*y2*z + 0.0017183262741199826*v2*w3*y2*
      z - 0.03008582292656479*w4*y2*z + 0.0014569340256667344*u*w4*y2*z + 
     0.0021054037902871444*v*w4*y2*z + 0.0032620105692251983*w5*y2*z + 
     1.7392655054241464*y3*z - 0.3131042491486924*u*y3*z + 
     0.07479560941667407*u2*y3*z - 0.01387288739518578*u3*y3*z + 
     0.0013099680497976988*u4*y3*z - 0.41431315409504377*v*y3*z + 
     0.06473552238444277*u*v*y3*z - 0.009593654231383138*u2*v*y3*z + 
     0.0007917184813914537*u3*v*y3*z + 0.11216265014873544*v2*y3*z - 
     0.010750311705942078*u*v2*y3*z + 0.0007107796438381393*u2*v2*y3*z - 
     0.02213965249299299*v3*y3*z + 0.0009392449858988379*u*v3*y3*z + 
     0.0021644635339529753*v4*y3*z - 0.43003699366991677*w*y3*z + 
     0.07024343329404853*u*w*y3*z - 0.010725838861960173*u2*w*y3*z + 
     0.0009016198300664359*u3*w*y3*z + 0.10521916751093474*v*w*y3*z - 
     0.010504755263170868*u*v*w*y3*z + 0.0007141774155409824*u2*v*w*y3*z - 
     0.019168242146174814*v2*w*y3*z + 0.0008476691271990539*u*v2*w*y3*z + 
     0.0017670251675018884*v3*w*y3*z + 0.11965941751579676*w2*y3*z - 
     0.012341284474452504*u*w2*y3*z + 0.0008576480370907614*u2*w2*y3*z - 
     0.019654970033404773*v*w2*y3*z + 0.0008946786933220228*u*v*w2*y3*z + 
     0.001678200058612197*v2*w2*y3*z - 0.024020753044566752*w3*y3*z + 
     0.0011178896264369238*u*w3*y3*z + 0.0018413777506809327*v*w3*y3*z + 
     0.002373235870460425*w4*y3*z - 1.211930536655639*y4*z + 
     0.1262878385252224*u*y4*z - 0.01632082648577182*u2*y4*z + 
     0.001270334042999831*u3*y4*z + 0.17213360808035297*v*y4*z - 
     0.014772762292074491*u*v*y4*z + 0.0009279102407948306*u2*v*y4*z - 
     0.02576675296668821*v2*y4*z + 0.0010604472614234883*u*v2*y4*z + 
     0.0021644635339529753*v3*y4*z + 0.17633440249962998*w*y4*z - 
     0.015599046732045124*u*w*y4*z + 0.0010009197339258765*u2*w*y4*z - 
     0.02459974262590988*v*w*y4*z + 0.0010408374899911962*u*v*w*y4*z + 
     0.001947021061827816*v2*w*y4*z - 0.02690397081993831*w2*y4*z + 
     0.0011655861883641662*u*w2*y4*z + 0.0019816663126266698*v*w2*y4*z + 
     0.002288117132733893*w3*y4*z + 0.5565850065099112*y5*z - 
     0.03138411241664758*u*y5*z + 0.0017031606129609958*u2*y5*z - 
     0.04346745568123319*v*y5*z + 0.0015798778632113992*u*v*y5*z + 
     0.0027683707923909567*v2*y5*z - 0.04423708081452867*w*y5*z + 
     0.0016446715859244178*u*w*y5*z + 0.002670611110405308*v*w*y5*z + 
     0.0028582170878550506*w2*y5*z - 0.15014045193375553*y6*z + 
     0.003557820085944631*u*y6*z + 0.00497631274951997*v*y6*z + 
     0.005045032605736152*w*y6*z + 0.01800569050603713*y7*z + 
     1.49959556042469*z2 - 1.4436975871035138*lnbara*z2 + 
     0.25*lnbara2*z2 - 0.6550621164463183*u*z2 + lnbara*u*z2 + 
     0.3514500470763496*u2*z2 - 0.6768212688509019*lnbara*u2*z2 - 
     0.11097560646847007*u3*z2 + 0.40107927043016406*lnbara*u3*z2 + 
     0.010651424423197484*u4*z2 - 0.16767848269494548*lnbara*u4*z2 + 
     0.004994214637738621*u5*z2 + 0.04254600335127144*lnbara*u5*z2 - 
     0.001332365186004987*u6*z2 - 0.004887855481301699*lnbara*u6*z2 - 
     1.8063725404567375*v*z2 + 0.7018651651305952*u*v*z2 - 
     0.3145211982372493*u2*v*z2 + 0.11216265014873544*u3*v*z2 - 
     0.02576675296668821*u4*v*z2 + 0.0027683707923909567*u5*v*z2 + 
     0.8957525884254294*v2*z2 - 0.23349143267332484*u*v2*z2 + 
     0.06346102200604578*u2*v2*z2 - 0.012460388549811095*u3*v2*z2 + 
     0.0012120200398115979*u4*v2*z2 - 0.47594273908018797*v3*z2 + 
     0.07479560941667407*u*v3*z2 - 0.011184878805680112*u2*v3*z2 + 
     0.000929170356268885*u3*v3*z2 + 0.18905536415607813*v4*z2 - 
     0.01632082648577182*u*v4*z2 + 0.0010325956586233194*u2*v4*z2 - 
     0.04661932625243986*v5*z2 + 0.0017031606129609958*u*v5*z2 + 
     0.005260726475147424*v6*z2 - 0.7393162088149705*w*z2 + lnbara*w*z2 + 
     0.34704051130803615*u*w*z2 - 0.5731787311490981*lnbara*u*w*z2 - 
     0.11090415302007936*u2*w*z2 + 0.30080945282262306*lnbara*u2*w*z2 + 
     0.018270939852523368*u3*w*z2 - 0.11585721384404363*lnbara*u3*w*z2 + 
     0.0006279468944037123*u4*w*z2 + 0.027777777777777776*lnbara*u4*w*
      z2 - 0.0005447808657404928*u5*w*z2 - 0.0030639349524580017*lnbara*
      u5*w*z2 + 0.7535927089402433*v*w*z2 - 0.2853207024227592*u*v*w*z2 + 
     0.09042317924046708*u2*v*w*z2 - 0.019168242146174814*u3*v*w*z2 + 
     0.001947021061827816*u4*v*w*z2 - 0.2603710538739398*v2*w*z2 + 
     0.05970961235652567*u*v2*w*z2 - 0.010434848681562636*u2*v2*w*z2 + 
     0.0009375065759672177*u3*v2*w*z2 + 0.08499596758732683*v3*w*z2 - 
     0.010725838861960173*u*v3*w*z2 + 0.0007939134731674265*u2*v3*w*z2 - 
     0.01873833496439247*v4*w*z2 + 0.0010009197339258765*u*v4*w*z2 + 
     0.001967584154035969*v5*w*z2 + 0.44851204077043355*w2*z2 - 
     0.6768212688509019*lnbara*w2*z2 - 0.12524168013952142*u*w2*z2 + 
     0.30080945282262306*lnbara*u*w2*z2 + 0.021120230732081857*u2*w2*
      z2 - 0.10364253770180369*lnbara*u2*w2*z2 - 
     0.0005261193959703832*u3*w2*z2 + 0.023031675044845268*lnbara*u3*w2*
      z2 - 0.00031988499677263827*u4*w2*z2 - 0.0024078266340730905*lnbara*
      u4*w2*z2 - 0.35311910817754827*v*w2*z2 + 
     0.09413892141422908*u*v*w2*z2 - 0.017832523900673754*u2*v*w2*z2 + 
     0.001678200058612197*u3*v*w2*z2 + 0.07585906569240349*v2*w2*z2 - 
     0.011123030888462724*u*v2*w2*z2 + 0.0008927349168409385*u2*v2*w2*
      z2 - 0.013822219055141373*v3*w2*z2 + 0.0008576480370907614*u*v3*
      w2*z2 + 0.0013006407407352707*v4*w2*z2 - 
     0.18003999496988*w3*z2 + 0.40107927043016406*lnbara*w3*z2 + 
     0.02683828203921473*u*w3*z2 - 0.11585721384404363*lnbara*u*w3*z2 - 
     0.0011395657623313037*u2*w3*z2 + 0.023031675044845268*lnbara*u2*w3*
      z2 - 0.0002384653713632691*u3*w3*z2 - 0.002233394751425484*lnbara*
      u3*w3*z2 + 0.12908291361954194*v*w3*z2 - 
     0.020429093685883477*u*v*w3*z2 + 0.0017183262741199826*u2*v*w3*z2 - 
     0.01551291842567776*v2*w3*z2 + 0.0010386240777278052*u*v2*w3*z2 + 
     0.0012080368273358105*v3*w3*z2 + 0.0421124901425931*w4*z2 - 
     0.16767848269494548*lnbara*w4*z2 - 0.00185882327413311*u*w4*z2 + 
     0.027777777777777776*lnbara*u*w4*z2 - 0.00021657363943226177*u2*w4*
      z2 - 0.0024078266340730905*lnbara*u2*w4*z2 - 
     0.03008582292656479*v*w4*z2 + 0.0021054037902871444*u*v*w4*z2 + 
     0.0015468623265518214*v2*w4*z2 - 0.00338099408846976*w5*z2 + 
     0.04254600335127144*lnbara*w5*z2 - 0.0002399697226902283*u*w5*z2 - 
     0.0030639349524580017*lnbara*u*w5*z2 + 0.0032620105692251983*v*w5*
      z2 - 0.0003407921988201555*w6*z2 - 0.004887855481301699*lnbara*w6*
      z2 - 1.8063725404567375*y*z2 + 0.7018651651305952*u*y*z2 - 
     0.3145211982372493*u2*y*z2 + 0.11216265014873544*u3*y*z2 - 
     0.02576675296668821*u4*y*z2 + 0.0027683707923909567*u5*y*z2 + 
     0.5671031350895516*v*y*z2 - 0.18317523399334182*u*v*y*z2 + 
     0.05324247056677653*u2*v*y*z2 - 0.010750311705942078*u3*v*y*z2 + 
     0.0010604472614234883*u4*v*y*z2 - 0.23349143267332484*v2*y*z2 + 
     0.04926825374502858*u*v2*y*z2 - 0.00817022761462202*u2*v2*y*z2 + 
     0.0007107796438381393*u3*v2*y*z2 + 0.0800625198854355*v3*y*z2 - 
     0.009593654231383138*u*v3*y*z2 + 0.0006855605604060971*u2*v3*y*z2 - 
     0.018011963451589594*v4*y*z2 + 0.0009279102407948306*u*v4*y*z2 + 
     0.001911174312857377*v5*y*z2 + 0.7535927089402433*w*y*z2 - 
     0.2853207024227592*u*w*y*z2 + 0.09042317924046708*u2*w*y*z2 - 
     0.019168242146174814*u3*w*y*z2 + 0.001947021061827816*u4*w*y*z2 - 
     0.21195882822548776*v*w*y*z2 + 0.05176117871302977*u*v*w*y*z2 - 
     0.009302160439412508*u2*v*w*y*z2 + 0.0008476691271990539*u3*v*w*y*
      z2 + 0.05970961235652567*v2*w*y*z2 - 0.008293671643270249*u*v2*w*y*
      z2 + 0.0006425989725751736*u2*v2*w*y*z2 - 
     0.011944092447949953*v3*w*y*z2 + 0.0007141774155409824*u*v3*w*y*z2 + 
     0.0011742374174915872*v4*w*y*z2 - 0.35311910817754827*w2*y*z2 + 
     0.09413892141422908*u*w2*y*z2 - 0.017832523900673754*u2*w2*y*z2 + 
     0.001678200058612197*u3*w2*y*z2 + 0.06727327832759263*v*w2*y*z2 - 
     0.010114542092320464*u*v*w2*y*z2 + 0.0008228748929587454*u2*v*w2*y*
      z2 - 0.011123030888462724*v2*w2*y*z2 + 0.00071910562986183*u*v2*
      w2*y*z2 + 0.0009765463601544392*v3*w2*y*z2 + 
     0.12908291361954194*w3*y*z2 - 0.020429093685883477*u*w3*y*z2 + 
     0.0017183262741199826*u2*w3*y*z2 - 0.014305345861885458*v*w3*y*z2 + 
     0.0009694445689965282*u*v*w3*y*z2 + 0.0010386240777278052*v2*w3*y*
      z2 - 0.03008582292656479*w4*y*z2 + 0.0021054037902871444*u*w4*y*
      z2 + 0.0014569340256667344*v*w4*y*z2 + 0.0032620105692251983*w5*y*
      z2 + 0.8957525884254294*y2*z2 - 0.23349143267332484*u*y2*z2 + 
     0.06346102200604578*u2*y2*z2 - 0.012460388549811095*u3*y2*z2 + 
     0.0012120200398115979*u4*y2*z2 - 0.23349143267332484*v*y2*z2 + 
     0.04926825374502858*u*v*y2*z2 - 0.00817022761462202*u2*v*y2*z2 + 
     0.0007107796438381393*u3*v*y2*z2 + 0.06346102200604578*v2*y2*z2 - 
     0.00817022761462202*u*v2*y2*z2 + 0.0006031345488998603*u2*v2*y2*
      z2 - 0.012460388549811095*v3*y2*z2 + 0.0007107796438381393*u*v3*
      y2*z2 + 0.0012120200398115979*v4*y2*z2 - 
     0.2603710538739398*w*y2*z2 + 0.05970961235652567*u*w*y2*z2 - 
     0.010434848681562636*u2*w*y2*z2 + 0.0009375065759672177*u3*w*y2*
      z2 + 0.05970961235652567*v*w*y2*z2 - 0.008293671643270249*u*v*w*y2*
      z2 + 0.0006425989725751736*u2*v*w*y2*z2 - 
     0.010434848681562636*v2*w*y2*z2 + 0.0006425989725751736*u*v2*w*y2*
      z2 + 0.0009375065759672177*v3*w*y2*z2 + 0.07585906569240349*w2*y2*
      z2 - 0.011123030888462724*u*w2*y2*z2 + 0.0008927349168409385*u2*
      w2*y2*z2 - 0.011123030888462724*v*w2*y2*z2 + 
     0.00071910562986183*u*v*w2*y2*z2 + 0.0008927349168409385*v2*w2*y2*
      z2 - 0.01551291842567776*w3*y2*z2 + 0.0010386240777278052*u*w3*y2*
      z2 + 0.0010386240777278052*v*w3*y2*z2 + 0.0015468623265518214*w4*
      y2*z2 - 0.47594273908018797*y3*z2 + 0.07479560941667407*u*y3*z2 - 
     0.011184878805680112*u2*y3*z2 + 0.000929170356268885*u3*y3*z2 + 
     0.0800625198854355*v*y3*z2 - 0.009593654231383138*u*v*y3*z2 + 
     0.0006855605604060971*u2*v*y3*z2 - 0.012460388549811095*v2*y3*z2 + 
     0.0007107796438381393*u*v2*y3*z2 + 0.0010588370339842305*v3*y3*
      z2 + 0.08499596758732683*w*y3*z2 - 0.010725838861960173*u*w*y3*
      z2 + 0.0007939134731674265*u2*w*y3*z2 - 0.011944092447949953*v*w*
      y3*z2 + 0.0007141774155409824*u*v*w*y3*z2 + 
     0.0009375065759672177*v2*w*y3*z2 - 0.013822219055141373*w2*y3*z2 + 
     0.0008576480370907614*u*w2*y3*z2 + 0.0009765463601544392*v*w2*y3*
      z2 + 0.0012080368273358105*w3*y3*z2 + 0.18905536415607813*y4*z2 - 
     0.01632082648577182*u*y4*z2 + 0.0010325956586233194*u2*y4*z2 - 
     0.018011963451589594*v*y4*z2 + 0.0009279102407948306*u*v*y4*z2 + 
     0.0012120200398115979*v2*y4*z2 - 0.01873833496439247*w*y4*z2 + 
     0.0010009197339258765*u*w*y4*z2 + 0.0011742374174915872*v*w*y4*z2 + 
     0.0013006407407352707*w2*y4*z2 - 0.04661932625243986*y5*z2 + 
     0.0017031606129609958*u*y5*z2 + 0.001911174312857377*v*y5*z2 + 
     0.001967584154035969*w*y5*z2 + 0.005260726475147424*y6*z2 - 
     1.330149985457792*z3 + 2.2207285075403607*lnbara*z3 - 
     0.5*lnbara2*z3 + 0.2738798821698887*u*z3 - 1.0243929103830327*lnbara*
      u*z3 - 0.11097560646847007*u2*z3 + 0.40107927043016406*lnbara*u2*
      z3 + 0.01590829385420868*u3*z3 - 0.1388888888888889*lnbara*u3*z3 + 
     0.0015438790012948771*u4*z3 + 0.03161639028525199*lnbara*u4*z3 - 
     0.0006639947469167062*u5*z3 - 0.003384978503667747*lnbara*u5*z3 + 
     1.7392655054241464*v*z3 - 0.41431315409504377*u*v*z3 + 
     0.11216265014873544*u2*v*z3 - 0.02213965249299299*u3*v*z3 + 
     0.0021644635339529753*u4*v*z3 - 0.47594273908018797*v2*z3 + 
     0.0800625198854355*u*v2*z3 - 0.012460388549811095*u2*v2*z3 + 
     0.0010588370339842305*u3*v2*z3 + 0.143917554575605*v3*z3 - 
     0.01387288739518578*u*v3*z3 + 0.000929170356268885*u2*v3*z3 - 
     0.030647657382734356*v4*z3 + 0.001270334042999831*u*v4*z3 + 
     0.0031576827739003242*v5*z3 + 0.31511034444848746*w*z3 - 
     1.0243929103830327*lnbara*w*z3 - 0.11507632468914157*u*w*z3 + 
     0.36315903776863345*lnbara*u*w*z3 + 0.018270939852523368*u2*w*z3 - 
     0.11585721384404363*lnbara*u2*w*z3 + 0.00011168526720960141*u3*w*
      z3 + 0.024846655495761868*lnbara*u3*w*z3 - 
     0.0003861048986038681*u4*w*z3 - 0.0025474832491138625*lnbara*u4*w*
      z3 - 0.43003699366991677*v*w*z3 + 0.10521916751093474*u*v*w*z3 - 
     0.019168242146174814*u2*v*w*z3 + 0.0017670251675018884*u3*v*w*z3 + 
     0.08499596758732683*v2*w*z3 - 0.011944092447949953*u*v2*w*z3 + 
     0.0009375065759672177*u2*v2*w*z3 - 0.014908075298963635*v3*w*z3 + 
     0.0009016198300664359*u*v3*w*z3 + 0.0013746585204415407*v4*w*z3 - 
     0.14081609389249217*w2*z3 + 0.40107927043016406*lnbara*w2*z3 + 
     0.02156396333609938*u*w2*z3 - 0.11585721384404363*lnbara*u*w2*z3 - 
     0.0005261193959703832*u2*w2*z3 + 0.023031675044845268*lnbara*u2*w2*
      z3 - 0.00027844820669121686*u3*w2*z3 - 0.002233394751425484*lnbara*
      u3*w2*z3 + 0.11965941751579676*v*w2*z3 - 
     0.019654970033404773*u*v*w2*z3 + 0.001678200058612197*u2*v*w2*z3 - 
     0.013822219055141373*v2*w2*z3 + 0.0009765463601544392*u*v2*w2*z3 + 
     0.0010537837376492188*v3*w2*z3 + 0.02888863835365632*w3*z3 - 
     0.1388888888888889*lnbara*w3*z3 - 0.0010346506951558188*u*w3*z3 + 
     0.024846655495761868*lnbara*u*w3*z3 - 0.0002384653713632691*u2*w3*
      z3 - 0.002233394751425484*lnbara*u2*w3*z3 - 
     0.024020753044566752*v*w3*z3 + 0.0018413777506809327*u*v*w3*z3 + 
     0.0012080368273358105*v2*w3*z3 - 0.0017631802385249043*w4*z3 + 
     0.03161639028525199*lnbara*w4*z3 - 0.0002396628047085045*u*w4*z3 - 
     0.0025474832491138625*lnbara*u*w4*z3 + 0.002373235870460425*v*w4*
      z3 - 0.0002861013781231583*w5*z3 - 0.003384978503667747*lnbara*w5*
      z3 + 1.7392655054241464*y*z3 - 0.41431315409504377*u*y*z3 + 
     0.11216265014873544*u2*y*z3 - 0.02213965249299299*u3*y*z3 + 
     0.0021644635339529753*u4*y*z3 - 0.3131042491486924*v*y*z3 + 
     0.06473552238444277*u*v*y*z3 - 0.010750311705942078*u2*v*y*z3 + 
     0.0009392449858988379*u3*v*y*z3 + 0.07479560941667407*v2*y*z3 - 
     0.009593654231383138*u*v2*y*z3 + 0.0007107796438381393*u2*v2*y*z3 - 
     0.01387288739518578*v3*y*z3 + 0.0007917184813914537*u*v3*y*z3 + 
     0.0013099680497976988*v4*y*z3 - 0.43003699366991677*w*y*z3 + 
     0.10521916751093474*u*w*y*z3 - 0.019168242146174814*u2*w*y*z3 + 
     0.0017670251675018884*u3*w*y*z3 + 0.07024343329404853*v*w*y*z3 - 
     0.010504755263170868*u*v*w*y*z3 + 0.0008476691271990539*u2*v*w*y*z3 - 
     0.010725838861960173*v2*w*y*z3 + 0.0007141774155409824*u*v2*w*y*z3 + 
     0.0009016198300664359*v3*w*y*z3 + 0.11965941751579676*w2*y*z3 - 
     0.019654970033404773*u*w2*y*z3 + 0.001678200058612197*u2*w2*y*z3 - 
     0.012341284474452504*v*w2*y*z3 + 0.0008946786933220228*u*v*w2*y*z3 + 
     0.0008576480370907614*v2*w2*y*z3 - 0.024020753044566752*w3*y*z3 + 
     0.0018413777506809327*u*w3*y*z3 + 0.0011178896264369238*v*w3*y*z3 + 
     0.002373235870460425*w4*y*z3 - 0.47594273908018797*y2*z3 + 
     0.0800625198854355*u*y2*z3 - 0.012460388549811095*u2*y2*z3 + 
     0.0010588370339842305*u3*y2*z3 + 0.07479560941667407*v*y2*z3 - 
     0.009593654231383138*u*v*y2*z3 + 0.0007107796438381393*u2*v*y2*z3 - 
     0.011184878805680112*v2*y2*z3 + 0.0006855605604060971*u*v2*y2*z3 + 
     0.000929170356268885*v3*y2*z3 + 0.08499596758732683*w*y2*z3 - 
     0.011944092447949953*u*w*y2*z3 + 0.0009375065759672177*u2*w*y2*z3 - 
     0.010725838861960173*v*w*y2*z3 + 0.0007141774155409824*u*v*w*y2*z3 + 
     0.0007939134731674265*v2*w*y2*z3 - 0.013822219055141373*w2*y2*z3 + 
     0.0009765463601544392*u*w2*y2*z3 + 0.0008576480370907614*v*w2*y2*
      z3 + 0.0012080368273358105*w3*y2*z3 + 0.143917554575605*y3*z3 - 
     0.01387288739518578*u*y3*z3 + 0.000929170356268885*u2*y3*z3 - 
     0.01387288739518578*v*y3*z3 + 0.0007917184813914537*u*v*y3*z3 + 
     0.000929170356268885*v2*y3*z3 - 0.014908075298963635*w*y3*z3 + 
     0.0009016198300664359*u*w*y3*z3 + 0.0009016198300664359*v*w*y3*z3 + 
     0.0010537837376492188*w2*y3*z3 - 0.030647657382734356*y4*z3 + 
     0.001270334042999831*u*y4*z3 + 0.0013099680497976988*v*y4*z3 + 
     0.0013746585204415407*w*y4*z3 + 0.0031576827739003242*y5*z3 + 
     0.6458071724555728*z4 - 2.2637141792339346*lnbara*z4 + 
     0.625*lnbara2*z4 + 0.01753357928415362*u*z4 + 
     0.7330635157257923*lnbara*u*z4 + 0.010651424423197484*u2*z4 - 
     0.16767848269494548*lnbara*u2*z4 + 0.0015438790012948771*u3*z4 + 
     0.03161639028525199*lnbara*u3*z4 - 0.0005416818590033571*u4*z4 - 
     0.0030360036294498475*lnbara*u4*z4 - 1.211930536655639*v*z4 + 
     0.17213360808035297*u*v*z4 - 0.02576675296668821*u2*v*z4 + 
     0.0021644635339529753*u3*v*z4 + 0.18905536415607813*v2*z4 - 
     0.018011963451589594*u*v2*z4 + 0.0012120200398115979*u2*v2*z4 - 
     0.030647657382734356*v3*z4 + 0.0013099680497976988*u*v3*z4 + 
     0.002726070724998416*v4*z4 - 0.0009147194949975854*w*z4 + 
     0.7330635157257923*lnbara*w*z4 + 0.013780208167077434*u*w*z4 - 
     0.1565120644824315*lnbara*u*w*z4 + 0.0006279468944037123*u2*w*z4 + 
     0.027777777777777776*lnbara*u2*w*z4 - 0.0003861048986038681*u3*w*
      z4 - 0.0025474832491138625*lnbara*u3*w*z4 + 
     0.17633440249962998*v*w*z4 - 0.02459974262590988*u*v*w*z4 + 
     0.001947021061827816*u2*v*w*z4 - 0.01873833496439247*v2*w*z4 + 
     0.0011742374174915872*u*v2*w*z4 + 0.0013746585204415407*v3*w*z4 + 
     0.018724892062203655*w2*z4 - 0.16767848269494548*lnbara*w2*z4 + 
     0.00008455106800475184*u*w2*z4 + 0.027777777777777776*lnbara*u*w2*
      z4 - 0.00031988499677263827*u2*w2*z4 - 0.0024078266340730905*lnbara*
      u2*w2*z4 - 0.02690397081993831*v*w2*z4 + 
     0.0019816663126266698*u*v*w2*z4 + 0.0013006407407352707*v2*w2*z4 - 
     0.0004120997422309256*w3*z4 + 0.03161639028525199*lnbara*w3*z4 - 
     0.0003031307111613726*u*w3*z4 - 0.0025474832491138625*lnbara*u*w3*
      z4 + 0.002288117132733893*v*w3*z4 - 0.00032828045176791254*w4*z4 - 
     0.0030360036294498475*lnbara*w4*z4 - 1.211930536655639*y*z4 + 
     0.17213360808035297*u*y*z4 - 0.02576675296668821*u2*y*z4 + 
     0.0021644635339529753*u3*y*z4 + 0.1262878385252224*v*y*z4 - 
     0.014772762292074491*u*v*y*z4 + 0.0010604472614234883*u2*v*y*z4 - 
     0.01632082648577182*v2*y*z4 + 0.0009279102407948306*u*v2*y*z4 + 
     0.001270334042999831*v3*y*z4 + 0.17633440249962998*w*y*z4 - 
     0.02459974262590988*u*w*y*z4 + 0.001947021061827816*u2*w*y*z4 - 
     0.015599046732045124*v*w*y*z4 + 0.0010408374899911962*u*v*w*y*z4 + 
     0.0010009197339258765*v2*w*y*z4 - 0.02690397081993831*w2*y*z4 + 
     0.0019816663126266698*u*w2*y*z4 + 0.0011655861883641662*v*w2*y*z4 + 
     0.002288117132733893*w3*y*z4 + 0.18905536415607813*y2*z4 - 
     0.018011963451589594*u*y2*z4 + 0.0012120200398115979*u2*y2*z4 - 
     0.01632082648577182*v*y2*z4 + 0.0009279102407948306*u*v*y2*z4 + 
     0.0010325956586233194*v2*y2*z4 - 0.01873833496439247*w*y2*z4 + 
     0.0011742374174915872*u*w*y2*z4 + 0.0010009197339258765*v*w*y2*z4 + 
     0.0013006407407352707*w2*y2*z4 - 0.030647657382734356*y3*z4 + 
     0.0013099680497976988*u*y3*z4 + 0.001270334042999831*v*y3*z4 + 
     0.0013746585204415407*w*y3*z4 + 0.002726070724998416*y4*z4 - 
     0.035197295260033824*z5 + 1.5177459370968307*lnbara*z5 - 
     0.5*lnbara2*z5 - 0.08639020220532784*u*z5 - 
     0.3414643034610109*lnbara*u*z5 + 0.004994214637738621*u2*z5 + 
     0.04254600335127144*lnbara*u2*z5 - 0.0006639947469167062*u3*z5 - 
     0.003384978503667747*lnbara*u3*z5 + 0.5565850065099112*v*z5 - 
     0.04346745568123319*u*v*z5 + 0.0027683707923909567*u2*v*z5 - 
     0.04661932625243986*v2*z5 + 0.001911174312857377*u*v2*z5 + 
     0.0031576827739003242*v3*z5 - 0.08023092776115039*w*z5 - 
     0.3414643034610109*lnbara*w*z5 + 0.004042814598569594*u*w*z5 + 
     0.040382603570750374*lnbara*u*w*z5 - 0.0005447808657404928*u2*w*z5 - 
     0.0030639349524580017*lnbara*u2*w*z5 - 0.04423708081452867*v*w*z5 + 
     0.002670611110405308*u*v*w*z5 + 0.001967584154035969*v2*w*z5 + 
     0.0035019811348314675*w2*z5 + 0.04254600335127144*lnbara*w2*z5 - 
     0.0004997443132457395*u*w2*z5 - 0.0030639349524580017*lnbara*u*w2*
      z5 + 0.0028582170878550506*v*w2*z5 - 0.0005095764010007675*w3*z5 - 
     0.003384978503667747*lnbara*w3*z5 + 0.5565850065099112*y*z5 - 
     0.04346745568123319*u*y*z5 + 0.0027683707923909567*u2*y*z5 - 
     0.03138411241664758*v*y*z5 + 0.0015798778632113992*u*v*y*z5 + 
     0.0017031606129609958*v2*y*z5 - 0.04423708081452867*w*y*z5 + 
     0.002670611110405308*u*w*y*z5 + 0.0016446715859244178*v*w*y*z5 + 
     0.0028582170878550506*w2*y*z5 - 0.04661932625243986*y2*z5 + 
     0.001911174312857377*u*y2*z5 + 0.0017031606129609958*v*y2*z5 + 
     0.001967584154035969*w*y2*z5 + 0.0031576827739003242*y3*z5 - 
     0.14015949954554044*z6 - 0.6450515340614117*lnbara*z6 + 
     0.25*lnbara2*z6 + 0.04094734531651254*u*z6 + 
     0.09290899944145475*lnbara*u*z6 - 0.001332365186004987*u2*z6 - 
     0.004887855481301699*lnbara*u2*z6 - 0.15014045193375553*v*z6 + 
     0.00497631274951997*u*v*z6 + 0.005260726475147424*v2*z6 + 
     0.039648206713854266*w*z6 + 0.09290899944145475*lnbara*w*z6 - 
     0.0012158310769012908*u*w*z6 - 0.004687810626819727*lnbara*u*w*z6 + 
     0.005045032605736152*v*w*z6 - 0.0011983236323822545*w2*z6 - 
     0.004887855481301699*lnbara*w2*z6 - 0.15014045193375553*y*z6 + 
     0.00497631274951997*u*y*z6 + 0.003557820085944631*v*y*z6 + 
     0.005045032605736152*w*y*z6 + 0.005260726475147424*y2*z6 + 
     0.07142919298974644*z7 + 0.15775500989141628*lnbara*z7 - 
     0.07142857142857142*lnbara2*z7 - 0.006717058480948745*u*z7 - 
     0.011206496836004519*lnbara*u*z7 + 0.01800569050603713*v*z7 - 
     0.00658939908338011*w*z7 - 0.011206496836004519*lnbara*w*z7 + 
     0.01800569050603713*y*z7 - 0.011766764554686482*z8 - 
     0.016917752027425906*lnbara*z8 + 0.008928571428571428*lnbara2*z8;
 
  ttothei = 1.0L;
  result = Gexp[0];

  for (i=1; i<nTerms; i++) {
    ttothei *= tinit;
    result += Gexp[i]*ttothei;
  }
  foo->value = _a * result;

  ttothei = 1.0L;
  result = Gexp[1];

  for (i=2; i<nTerms; i++) {
    ttothei *= tinit;
    result += i*Gexp[i]*ttothei;
  }
  foo->deriv = _a * result;

  return 0;
}
