/* Analytic results for FBAR and F-type functions */

#include "internal.h"

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx000 (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return (47*x)/12 + (PI2*x)/6 - (11*x*lnbarx)/4 + (x*lnbarx*lnbarx)/2;
} 

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx00x (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
 
  lnbarx2 = lnbarx*lnbarx;

  return (49*x)/12 - (3*x*lnbarx)/4 - x*lnbarx2 + (x*lnbarx*lnbarx2)/3 - 
    (8*x*Zeta3)/3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx0xx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  lnbarx2 = lnbarx*lnbarx;

  return (17*x)/4 + (5*x*lnbarx)/4 -
    (5*x*lnbarx2)/2 + (2*x*lnbarx*lnbarx2)/3 - 3*TVIL_SQRT(3)*LS2*x;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fxxxx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  lnbarx2 = lnbarx*lnbarx;

  return (53*x)/12 + (13*x*lnbarx)/4 - 4*x*lnbarx2 + x*lnbarx*lnbarx2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx0yy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX k, lnk, lnk2, result;
  TVIL_REAL lnbarx, lnbary, lnbary2;

  k = (1 - TVIL_CSQRT(1-4.L*y/x))/(1 + TVIL_CSQRT(1-4.L*y/x));

  /* This shouldn't be necessary, but just in case... */
  if (TVIL_CIMAG(k) > 0) k = TVIL_CONJ(k);

  lnk = TVIL_CLOG (k);
  lnk2 = lnk*lnk;
  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = 4*y*TVIL_Trilog(-k) + TVIL_CSQRT(x*(x-4*y))*(2*TVIL_Dilog(-k) 
      + 0.5L*lnk2 + PI2/6.) 
      + (y/3)*(lnk*lnk2 + PI2*lnk - lnbary*lnbary2 + 1 - 4*Zeta3 + 
    3*lnbarx*lnbary2 - 3*lnbary) + (y-x/2.)*lnbary2 + (x-4*y)*lnbarx*lnbary + 
    (5*y-11*x/4.)*lnbarx + 47.*x/12.;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fy0xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX k, lnk, lnk2, sqrt, result;
  TVIL_REAL lnbarx, lnbary, lnbary2;

  k = (1 - TVIL_CSQRT(1-4*y/x))/(1 + TVIL_CSQRT(1-4*y/x));

  /* This shouldn't be necessary, but just in case... */
  if (TVIL_CIMAG(k) > 0) k = TVIL_CONJ(k);

  lnk = TVIL_CLOG (k);
  lnk2 = lnk*lnk;
  sqrt = x * (1.L - k)/(1.L + k);

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = (x - 2*y)*(2*TVIL_Trilog(-k) + (1./6.)*lnk*lnk2 
   - (1./6.)*lnbary*lnbary2 + 
   (PI2/6)*lnk - (2./3.)*Zeta3) 
   + sqrt*(2*TVIL_Dilog(-k) + 0.5L*lnk2 + 
    PI2/6) + (x/2)*lnbarx*lnbary2 - x*lnbarx*lnbary - (y + x/2)*lnbary2 +
    - (x/2)*lnbarx + (5*x/2. - 3*y/4.)*lnbary + x/6. + 49.*y/12.;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fxxyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2, lnyox;

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary2 = lnbary*lnbary;
  lnyox = TVIL_LOG (y/x);

  result = 2*(x-y)*(TVIL_Trilog(1-x/y) + TVIL_Trilog(1-y/x) 
    + lnyox*TVIL_Dilog(1-x/y) +
    (1./3.)*lnbary*lnbary2 - lnbarx*lnbary2 - (1./6.)*lnbarx*lnbarx2 
    - (7./3.)*Zeta3) +
  (49*x + 4*y)/12 + ((-3*x + 20*y)*lnbarx)/4 - x*lnbarx2 - y*lnbary +
  - 4*y*lnbarx*lnbary + (2*x - y)*lnbarx2*lnbary + y*lnbary2;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx00y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2, lnyox;

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary2 = lnbary*lnbary;
  lnyox = lnbary - lnbarx;

  result = 2*y*TVIL_Trilog(1-x/y) + 2*y*TVIL_Trilog(1-y/x) + 
    (y*lnyox - x + y)*TVIL_Dilog(1-x/y) +
  (47*x + 2*y)/12 + ((-11*x + 10*y)*lnbarx)/4 - (y*lnbarx*lnbarx2)/3 
  - (y*lnbary)/2 + 
  (x - 2*y)*lnbarx*lnbary + y*lnbarx2*lnbary + ((-x + y)*lnbary2)/2 - 
  (y*lnbarx*lnbary2)/2 + (y*lnbary*lnbary2)/6 - (8*y*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR0000 ()
{
  return 0.0L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR000x (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  lnbarx2 = lnbarx*lnbarx;

  return x/6 + (PI2*x)/6 - (x*lnbarx)/2 - (PI2*x*lnbarx)/6 +
    (x*lnbarx2)/2 - (x*lnbarx*lnbarx2)/6 - (2*x*Zeta3)/3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR00xx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return x/3 - x*lnbarx + x*lnbarx2 - (x*lnbarx*lnbarx2)/3 +
    (8*x*Zeta3)/3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx000 (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return (47*x)/12 + (PI2*x)/6 - (11*x*lnbarx)/4 + (x*lnbarx2)/2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx00x (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return (49*x)/12 - (13*x*lnbarx)/4 - (PI2*x*lnbarx)/6 +
    x*lnbarx2 - (x*lnbarx*lnbarx2)/6 - (8*x*Zeta3)/3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx0xx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return (17*x)/4 - (15*x*lnbarx)/4 + (3*x*lnbarx2)/2 -
    (x*lnbarx*lnbarx2)/3 - 3*TVIL_SQRT(3)*x*LS2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR0xxx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return x*(9.0968675372632776795L + (3.*SQRT3*LS2 - 1.5)*lnbarx
	    + 1.5L*lnbarx2 - 0.5*lnbarx2*lnbarx);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARxxxx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return (53*x)/12 - (17*x*lnbarx)/4 + 2*x*lnbarx2 -
    (x*lnbarx*lnbarx2)/2 + 3*TVIL_SQRT(3)*x*lnbarx*LS2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARxxyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return TVIL_Fxxyy (x, y, qq) + lnbarx*TVIL_I2(x, y, y, qq);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx0xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return TVIL_Fy0xy (y, x, qq) + lnbarx*TVIL_I2(0, x, y, qq);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx0yy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return TVIL_Fx0yy (x, y, qq) + lnbarx*TVIL_I2(0, y, y, qq);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx00y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return TVIL_Fx00y (x, y, qq) + lnbarx*TVIL_I2(0, 0, y, qq);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR00xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary2 = lnbary*lnbary;

  result = -2*x*TVIL_Trilog(1-y/x) - 2*y*TVIL_Trilog(1-x/y) +
    (x*lnbarx - x - y*lnbary + y)*TVIL_Dilog(1-x/y) +
    (x + y)/6 - (x*lnbarx)/2 + (x*lnbarx*lnbarx2)/3 - (y*lnbary)/2 + x*lnbarx*lnbary +
    - x*lnbarx2*lnbary + ((-x + y)*lnbary2)/2 + (x*lnbarx*lnbary2)/2 +
    - (y*lnbary*lnbary2)/6 + (4*(x + y)*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR0xxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnyox;
  TVIL_COMPLEX result;
  int n;

  TVIL_REAL Fbar0xxytableA[] = 
     {0, 0, -7.037037037037037, 1.7327407407407407, 1.9337073750134974, 
     1.6596918179382276, 1.3978865512096648, 1.1894023285507445, 
     1.0264758824059403, 0.897854589350033, 0.7946651108145208, 
     0.710510968151481, 0.6408356611657425, 0.5823633669545625, 
     0.5327021270694172, 0.49007550685022, 0.45314213945320814, 
     0.420873282041491, 0.39246854511459206, 0.3672969657560077, 
     0.34485513826423037, 0.3247370016952336, 0.30661171823851513, 
     0.29020725281135085, 0.2752980283857671, 0.2616955349427729, 
     0.24924110640055255, 0.2378003079844564, 0.22725853333199988, 
     0.21751751987341075, 0.2084925680938096, 0.20011030529692037, 
     0.1923068742055669, 0.18502645571070864, 0.17822005643452615, 
     0.1718445076585136, 0.16586163409076304, 0.16023755997157546, 
     0.15494212690234874, 0.14994840307617138, 0.1452322676871227, 
     0.14077205749027663, 0.13654826499113282, 0.13254327972201538, 
     0.12874116563420335, 0.12512746888909612, 0.12168905133873012, 
     0.11841394579838511, 0.11529122987263861, 0.11231091563263074, 
     0.10946385288111506, 0.10674164410237251, 0.1041365694914414, 
     0.10164152070338055, 0.09924994216798709, 0.09695577898616416, 
     0.09475343056709616, 0.09263770928547055, 0.09060380353917329, 
     0.08864724467341618, 0.08676387730976927, 0.08494983268022856, 
     0.08320150461902061, 0.08151552790979084, 0.07988875872434871, 
     0.07831825692225045, 0.07680127000901957, 0.07533521857543193, 
     0.0739176830616056, 0.0725463917081219, 0.0712192095724745, 
     0.06993412850314065, 0.06868925797578662, 0.06748281670680531, 
     0.06631312496874588, 0.06517859754041559, 0.06407773723166159, 
     0.06300912892920964, 0.061971434115556376, 0.06096338581787975, 
     0.059983783948331725, 0.0590314910009776, 0.05810542807411153, 
     0.05720457118975968, 0.05632794788492786, 0.055474634051599775, 
     0.05464375100468, 0.0538344627590329, 0.05304597349852208, 
     0.05227752522152706, 0.05152839554882622, 0.05079789568100448, 
     0.050085368493687235, 0.04939018675993217, 0.04871175149004014, 
     0.04804949037988574, 0.04740285635962818, 0.04677132623534958, 
     0.0461543994167918, 0.04555159672492749, 0.04496245927361466};
 
  TVIL_REAL Fbar0xxytableALx[] = 
     {0, 0, -7.555555555555555, -0.8533333333333334, 
     0.1291609977324263, 0.35926429831191736, 0.4099420092493686, 
     0.40668765011089353, 0.3861874837832214, 0.36095030752857354, 
     0.3355622636742313, 0.31169472316394137, 0.28987056108877113, 
     0.2701478715517435, 0.2524016816883294, 0.23644428588260602, 
     0.22207702755200412, 0.20911182592735142, 0.19737908051539305, 
     0.18672945552436918, 0.17703301386893588, 0.16817732302673874, 
     0.16006528572513998, 0.1526130323846955, 0.14574801203590226, 
     0.13940732305744027, 0.13353628124026343, 0.12808720420735498, 
     0.12301838508987253, 0.11829322803884124, 0.11387952035706159, 
     0.10974881914299874, 0.10587593356710204, 0.10223848690229793, 
     0.09881654507226885, 0.09559230073747572, 0.09254980383216209, 
     0.08967473103753072, 0.08695418797342591, 0.08437653895765672, 
     0.08193126005819797, 0.07960881188288361, 0.07740052914234488, 
     0.07529852450837324, 0.07329560469089143, 0.07138519698800377, 
     0.06956128483794054, 0.06781835112946753, 0.06615132821690886, 
     0.06455555374414687, 0.06302673151436353, 0.06156089675338424, 
     0.060154385207954825, 0.058803805599133445, 0.05750601501767243, 
     0.05625809690482053, 0.05505734131005821, 0.05390122715825818, 
     0.05278740629377559, 0.051713689098957044, 0.05067803151029828, 
     0.04967852327762612, 0.04871337733077835, 0.04778092013475824, 
     0.04687958292863389, 0.046007893755856, 0.0451644702044537, 
     0.044348012784966855, 0.04355729888217683, 0.04279117722387427, 
     0.04204856281618964, 0.04132843230053173, 0.04062981969203296, 
     0.03995181246367466, 0.0392935479440377, 0.03865420999995688, 
     0.03803302597830774, 0.03742926388376967, 0.03684222977173164, 
     0.036271265337570704, 0.0357157456853726, 0.0351750772608022, 
     0.03464869593429555, 0.03413606522205385, 0.03363667463349099, 
     0.033150038134836635, 0.03267569271953954, 0.03221319707696229, 
     0.03176213035162164, 0.031322090985914035, 0.030892695639886007, 
     0.03047357818216721, 0.03006438874668963, 0.029664792850273236, 
     0.02927447056657243, 0.028893115752253035, 0.02852043532161032, 
     0.028156148566147905, 0.027799986515919025, 0.02745169133968777, 
     0.02711101578120148};
 
  TVIL_REAL Fbar0xxytableALy[] = 
     {0, 0, 0.4444444444444444, -1.3511111111111112, 
     -1.2582312925170067, -1.0668279163517258, -0.9043841840378637, 
     -0.7765357125330485, -0.6760038476588593, -0.5958469134497719, 
     -0.5308806932854904, -0.4773945823001134, -0.43273126196223843, 
     -0.3949628543161166, -0.3626674843343662, -0.33477867974403835, 
     -0.3104835876503626, -0.2891533538202688, -0.2702947701199098, 
     -0.253516150423707, -0.2385028657027399, -0.22499953869728348, 
     -0.21279690114971142, -0.20172196404387147, -0.19163057514050824, 
     -0.18240171957803264, -0.1739331089643999, -0.1661377339881321, 
     -0.15894114534829926, -0.15227929079270905, -0.1460967807941808, 
     -0.14034548754252582, -0.13498340528221167, -0.12997371716424086, 
     -0.1252840264814824, -0.12088571965521318, -0.11675343550597257, 
     -0.11286462079146403, -0.1091991561711446, -0.10573903998209454, 
     -0.10246811971807039, -0.09937186306590376, -0.09643716189875527, 
     -0.09365216385002256, -0.09100612706715855, -0.08848929452607104, 
     -0.08609278491599126, -0.0838084976138613, -0.08162902968125973, 
     -0.07954760315497363, -0.07755800117964376, -0.07565451175932364, 
     -0.07383187809367568, -0.0720852546213195, -0.07041016802347723, 
     -0.06880248255027967, -0.06725836912372403, -0.06577427774839495, 
     -0.06434691282617674, -0.06297321102633069, -0.06165032140915359, 
     -0.06037558754133183, -0.05914653137518477, -0.0579608386931758, 
     -0.056816345944126656, -0.05571102831913768, -0.05464298893382408, 
     -0.05361044899956852, -0.052611738880437776, -0.05164528994452347, 
     -0.050709627129012814, -0.0498033621474909, -0.04892518727601503, 
     -0.048073869661539696, -0.04724824610244549, -0.046447218256352965, 
     -0.04566974823518066, -0.044914854551620934, -0.04418160838493127, 
     -0.04346913013723352, -0.04277658625443401, -0.04210318628847046, 
     -0.04144818017989622, -0.0408108557418652, -0.040190536328410374, 
     -0.03958657867154315, -0.03899837087316186, -0.038425330539065605, 
     -0.03786690304354272, -0.03732255991405555, -0.03679179732648974, 
     -0.03627413470228721, -0.03576911339954956, -0.0352762954908901, 
     -0.03479526262143766, -0.03432561494096026, -0.03386697010458763, 
     -0.033418962337074885, -0.03298124155596945, -0.032553472549424776, 
     -0.0321353342047507};
 
  TVIL_REAL Fbar0xxytableAL2[] = 
     {0, 0, 2.6666666666666665, 1.0666666666666667, 
     0.6095238095238096, 0.40634920634920635, 0.2955266955266955, 
     0.22732822732822733, 0.18186258186258186, 0.14976918506330272, 
     0.12612141900067597, 0.10810407342915083, 0.09400354211230506, 
     0.08272311705882845, 0.07353165960784752, 0.06592493620013916, 
     0.059545103664641816, 0.05413191242240165, 0.04949203421476723, 
     0.04547916657573205, 0.04198076914682958, 0.0389090055507201, 
     0.036194423768111716, 0.03378146218357094, 0.03162519863993875, 
     0.02968896198851393, 0.027942552459777815, 0.026360898546960203, 
     0.024923031353489646, 0.023611292861200717, 0.022410718647919325, 
     0.021308552157038047, 0.020293859197179093, 0.019357219541924674, 
     0.018490478368405658, 0.017686544526301064, 0.01693922574349961, 
     0.016243093178698258, 0.015593369451550326, 0.0149858355768146, 
     0.014416753213138097, 0.013882799390429279, 0.013381011460654724, 
     0.012908740467925735, 0.012463611486273124, 0.012043489750780772, 
     0.011646451627128658, 0.011270759639156766, 0.01091484091370971, 
     0.010577268514316625, 0.010256745226004001, 0.009952089427211803, 
     0.009662222744865829, 0.009386159237869661, 0.009122995894751821, 
     0.008871904264621037, 0.008632123068279927, 0.00840295165938754, 
     0.008183744224794821, 0.007973904629287262, 0.007772881823506911, 
     0.007580165745238144, 0.007395283653890872, 0.007217796846197491, 
     0.007047297708098339, 0.006883407063723958, 0.006725771787455471, 
     0.006574062649392565, 0.006427972368294952, 0.006287213849281194, 
     0.006151518586347068, 0.006020635212169471, 0.005894328179746336, 
     0.0057723765622343425, 0.005654572958923437, 0.005540722496663234, 
     0.005430641917259328, 0.005324158742411106, 0.005221110508687021, 
     0.005121344065845867, 0.0050247149325280205, 0.0049310867039715975, 
     0.004840330506965986, 0.004752324497748422, 0.004666953398986475, 
     0.004584108072377247, 0.00450368512373905, 0.004425586537778257, 
     0.0043497193399877725, 0.00427599528337781, 0.00420433055795807, 
     0.004134645521085838, 0.0040668644469696764, 0.004000915293775573, 
     0.003936729486923559, 0.0038742417172898513, 0.0038133897531439373, 
     0.003754114264753099, 0.0036963586606799746, 0.0036400689348828176, 
     0.0035851935238041823};
 
  TVIL_REAL Fbar0xxytableC[] = 
     {0, 0, -0.016969290922157987, -0.1071041892356652, 
     -0.091549467875236, -0.0778124515340627, -0.06712924599891806, 
     -0.05871867000670852, -0.05197016217862003, -0.04646005194719721, 
     -0.04189177452558616, -0.038053386192670687, -0.0347902371828175, 
     -0.03198729927513923, -0.029557512652350064, -0.02743393969485649, 
     -0.02556437525099403, -0.023907574503936525, -0.022430566887997487, 
     -0.021106712568224863, -0.01991427532388426, -0.018835360272001403, 
     -0.017855113160271684, -0.01696110976385888, -0.0161428852081664, 
     -0.01539156750572108, -0.014699589567034918, -0.014060460911684482, 
     -0.013468585234225332, -0.012919113507568799, -0.012407824860184843, 
     -0.011931029331409652, -0.011485487988910633, -0.011068346921052703, 
     -0.01067708239058807, -0.010309455022805962, -0.00996347134970239, 
     -0.009637351377006225, -0.009329501108627148, -0.00903848917207779, 
     -0.00876302685259318, -0.008501950973414829, -0.00825420916283496, 
     -0.00801884713101771, -0.007794997645832191, -0.007581870950397677, 
     -0.00737874640841743, -0.007184965198728731, -0.006999923909434368, 
     -0.006823068905767813, -0.0066538913654763466, -0.00649192289177194, 
     -0.006336731627426206, -0.00618791880487457, -0.006045115676648845, 
     -0.005907980778400601, -0.005776197483473531, -0.0056494718136440615, 
     -0.005527530475450174, -0.00541011909561143, -0.005297000632524867, 
     -0.005187953943798879, -0.005082772492339647, -0.004981263175698485, 
     -0.004883245265278389, -0.004788549443630384, -0.00469701692948282, 
     -0.004608498681372305, -0.004522854671810168, -0.004439953224846392, 
     -0.004359670410702946, -0.004281889491856777, -0.0042065004155736555, 
     -0.004133399348438785, -0.004062488248909519, -0.003993674474337636, 
     -0.00392687041928123, -0.0038619931822556786, -0.0037989642583647213, 
     -0.003737709255511305, -0.0036781576321174656, -0.0036202424544868987, 
     -0.0035639001721257204, -0.0035090704094993415, -0.0034556957728482936, 
     -0.0034037216708156168, -0.0033530961477545103, -0.0033037697286891834, 
     -0.003255695274995372, -0.003208827849951053, -0.0031631245933836723, 
     -0.0031185446047083346, -0.0030750488337130785, -0.003032599978502793, 
     -0.0029911623900638067, -0.002950701982956525, -0.002911186151684834, 
     -0.002872583692328358, -0.002834864729057652, -0.002798000645183259, 
     -0.0027619640184176923};
 
  TVIL_REAL Fbar0xxytableCLx[] = 
     {0, 0, -0.34873351671205655, -0.19520009168936162, 
     -0.15455214063918435, -0.12830368594742905, -0.10896647973834955, 
     -0.094140321567731, -0.08247772873138623, -0.07311049206018763, 
     -0.06545181133815298, -0.059093051022286694, -0.053742538620351665, 
     -0.0491874836939689, -0.04526956355297516, -0.04186887850629249, 
     -0.03889316804992415, -0.03627041111800133, -0.033943650223626755, 
     -0.03186730661479441, -0.0300045139241542, -0.028325159718034284, 
     -0.026804427052181924, -0.02542169450337586, -0.02415969678630207, 
     -0.0230038772418792, -0.021941883295182363, -0.020963169631152124, 
     -0.020058683369882646, -0.019220612267385265, -0.018442181795949555, 
     -0.01771749045386129, -0.017041375211904082, -0.016409300894095515, 
     -0.015817268699864672, -0.015261740135698466, -0.014739573429192448, 
     -0.014247970113987048, -0.013784429948311396, -0.013346712697812292, 
     -0.01293280560074878, -0.01254089555954556, -0.01216934528135142, 
     -0.011816672732341507, -0.011481533384136966, -0.011162704822066681, 
     -0.010859073358800844, -0.01056962235679925, -0.010293422011876, 
     -0.010029620390200281, -0.009777435543967379, -0.009536148558154895, 
     -0.009305097403311553, -0.009083671488074485, -0.008871306820766412, 
     -0.008667481702541696, -0.00847171288557796, -0.008283552139109755, 
     -0.008102583173967993, -0.007928418882963487, -0.007760698860132226, 
     -0.0075990871667055305, -0.007443270315813568, -0.007292955451486093, 
     -0.007147868700571315, -0.007007753678828757, -0.006872370134728253, 
     -0.006741492716458449, -0.006614909849358573, -0.00649242271247485, 
     -0.00637384430423923, -0.006258998588400008, -0.006147719712324293, 
     -0.006039851290660379, -0.0059352457481103675, -0.005833763715734117, 
     -0.005735273475796636, -0.005639650450692808, -0.005546776731944716, 
     -0.0054565406456754915, -0.00536883635132604, -0.005283563470703069, 
     -0.005200626744733334, -0.0051199357155543345, -0.005041404431799467, 
     -0.004964951175139212, -0.004890498206322026, -0.004817971529121774, 
     -0.004747300670744895, -0.004678418477381974, -0.004611260923706586, 
     -0.004545766935230742, -0.004481878222522205, -0.004419539126375532, 
     -0.004358696473106953, -0.004299299439213927, -0.004241299424704291, 
     -0.004184649934458014, -0.004129306467037189, -0.0040752264104078565, 
     -0.004022368944080618};
 
  TVIL_REAL Fbar0xxytableCLy[] = 
     {0, 0, 0.3981002750680849, 0.223355693089598, 
     0.1755673602643321, 0.14485027718503246, 0.12240452646516323, 
     0.10531511736966623, 0.09194946931895889, 0.08126576503526918, 
     0.07256620356173257, 0.0653685120710643, 0.05933061727378977, 
     0.05420428021111144, 0.049805642431278906, 0.045996016379548726, 
     0.04266905678157087, 0.03974200560899767, 0.03714959704261386, 
     0.03483973613244347, 0.03277038331906701, 0.030907273596028288, 
     0.029222223017881716, 0.027691854901294725, 0.02629663019343985, 
     0.025020101186949896, 0.02384833123843466, 0.0227694392686874, 
     0.02177323904769387, 0.020850951185879287, 0.01999497140727135, 
     0.019198682764162492, 0.018456302434315987, 0.017762755940396013, 
     0.017113573268073896, 0.01650480258866875, 0.015932938223407325, 
     0.015394860197381035, 0.014887783278217173, 0.014409213818224742, 
     0.013956913049295576, 0.013528865739304431, 0.01312325332367836, 
     0.012738430788599724, 0.012372906712347087, 0.012025325975702855, 
     0.01169445473663413, 0.011379167332798576, 0.011078434831107391, 
     0.01079131498913996, 0.010516943430645204, 0.010254525868256025, 
     0.010003331232129882, 0.009762685584500948, 0.009531966717878149, 
     0.009310599349483684, 0.0090980508370099, 0.0088938273512923, 
     0.008697470450389374, 0.008508554007099893, 0.008326681448359375, 
     0.008151483270423966, 0.00798261479842357, 0.007819754162872117, 
     0.007662600469165355, 0.007510872139061941, 0.007364305405704126, 
     0.0072226529459501684, 0.007085682635712475, 0.006953176415666009, 
     0.006824929256146433, 0.00670074821132741, 0.006580451553876859, 
     0.006463867982264959, 0.006350835893750685, 0.006241202716824623, 
     0.006134824297547362, 0.006031564334806488, 0.005931293860031102, 
     0.00583389075735964, 0.005739239320661673, 0.005647229844174078, 
     0.0055577582438318795, 0.005470725706658881, 0.0053860383658374325, 
     0.0053036069993035884, 0.005223346749916945, 0.005145176865436269, 
     0.0050690204566950494, 0.0049948042725175106, 0.004922458490047201, 
     0.004851916519278761, 0.004783114820690155, 0.004715992734969001, 
     0.004650492323913571, 0.00458655822166768, 0.004524137495519867, 
     0.0044631795155617585, 0.0044036358325590195, 0.004345460063441389, 
     0.004288607783866624};
 
  TVIL_REAL Fbar0xxytableCLx2[] = 
     {0, 0, -0.0625, -0.078125, -0.06510416666666667, 
     -0.053548177083333336, -0.044775390625, -0.038134765625, 
     -0.033010646275111605, -0.028970037187848772, -0.0257193232339526, 
     -0.023057532688928028, -0.020844271026476464, -0.01897924819377938, 
     -0.017389269841952545, -0.016019852150912648, -0.01482970745482535, 
     -0.013787040127735, -0.012867006660465493, -0.012049939957523884, 
     -0.011320085427943228, -0.010664686369091505, -0.010073311987896821, 
     -0.0095373567567299, -0.00904966260408374, -0.00860423041355491, 
     -0.008195997304123882, -0.007820662949206697, -0.007474552863856036, 
     -0.00715450985155927, -0.006857807109476927, -0.006582078142995986, 
     -0.006325259836790156, -0.006085545905167072, -0.005861348591765891, 
     -0.005651266971696096, -0.005454060572865488, -0.0052686273093263325, 
     -0.005093984930721501, -0.004929255354768495, -0.004773651376154545, 
     -0.004626465344034205, -0.004487059478046047, -0.004354857554269565, 
     -0.00422933774149248, -0.004110026407328888, -0.003996492745237672, 
     -0.0038883440989630627, -0.0037852218816100307, -0.00368679800345042, 
     -0.003592771736392319, -0.0035028669544322623, -0.00341682969881866, 
     -0.003334426024459108, -0.003255440090601347, -0.003179672464245924, 
     -0.003106938609299322, -0.003037067538303931, -0.002969900606810857, 
     -0.00290529043319495, -0.002843099929031633, -0.002783201427130262, 
     -0.0027254758960046995, -0.0026698122310047675, -0.002616106613570449, 
     -0.0025642619311357874, -0.0025141872511278574, -0.0024657973432999675, 
     -0.002419012245325848, -0.0023737568671785324, -0.002329960630336954, 
     -0.002287557138316057, -0.0022464838754116564, -0.002206681930897469, 
     -0.0021680957462152243, -0.0021306728829654144, -0.002094363809740911, 
     -0.0020591217060525295, -0.0020249022817783184, -0.0019916636107299456, 
     -0.0019593659770726904, -0.0019279717334626076, -0.0018974451698773025, 
     -0.0018677523922172356, -0.001838861209844012, -0.001810741031302061, 
     -0.001783362767541518, -0.0017566987420240814, -0.001730722607150891, 
     -0.0017054092665028972, -0.001680734802430372, -0.0016566764085697578, 
     -0.0016332123269034743, -0.0016103217890120294, -0.0015879849611982442, 
     -0.0015661828931909146, -0.0015448974701601293, -0.0015241113677990196, 
     -0.0015038080102471464, -0.0014839715306492873, -0.0014645867341602397};
 
  TVIL_REAL Fbar0xxytableCLxLy[] = 
     {0, 0, 0.1875, 0.20833333333333334, 0.16861979166666666, 
     0.136328125, 0.11261393229166666, 0.09501836867559524, 
     0.08163237798781622, 0.07119175744435144, 0.06286622758895632, 
     0.05609930108635973, 0.05050817493236426, 0.045822679058655155, 
     0.04184757452303078, 0.03843873589920811, 0.035487725962901395, 
     0.032911560302307304, 0.030645759727439725, 0.028639534818498718, 
     0.026852383937588938, 0.02525164758281112, 0.023810722073903393, 
     0.02250773572198117, 0.02132455459855659, 0.020246026658469463, 
     0.019259400569279567, 0.018353874198926458, 0.01752024044419551, 
     0.016750606923083996, 0.01603817227634532, 0.015377046258039064, 
     0.014762103992633148, 0.014188867107445425, 0.013653406166295592, 
     0.01315226010720508, 0.012682369345283084, 0.012241019927255382, 
     0.011825796677506783, 0.011434543700981941, 0.011065330937761447, 
     0.010716425721005614, 0.010386268491531975, 0.010073451981443653, 
     0.009776703305618346, 0.009494868500803699, 0.009226899133099787, 
     0.008971840659996812, 0.008728822286152647, 0.008497048095280174, 
     0.008275789275847097, 0.00806437728732179, 0.007862197837648546, 
     0.007668685562470895, 0.007483319313110826, 0.007305617974068597, 
     0.007135136742324973, 0.006971463810401845, 0.0068142174032894106, 
     0.006663043126239041, 0.006517611586263229, 0.006377616255151393, 
     0.0062427715460455935, 0.00611281107924113, 0.005987486115980449, 
     0.005866564141675724, 0.005749827582292632, 0.005637072639611307, 
     0.005528108232796908, 0.005422755035200883, 0.005320844596608006, 
     0.005222218542271152, 0.005126727841059409, 0.005034232135905145, 
     0.004944599130489251, 0.0048577040267651144, 0.00477342900850356, 
     0.00469166276655327, 0.004612300061963278, 0.004535241323513657, 
     0.004460392276554276, 0.004387663600365106, 0.004316970611530048, 
     0.004248232971063999, 0.004181374413253451, 0.004116322494367692, 
     0.004053008359573471, 0.003991366526543111, 0.003931334684386882, 
     0.0038728535066666543, 0.003815866477361194, 0.003760319728755351, 
     0.003706161890317096, 0.0036533439477089923, 0.003601819111155243, 
     0.003551542692452776, 0.003502471989975704, 0.0034545661810776187, 
     0.0034077862213460607, 0.0033620947502088546, 0.0033174560024330406};
 
  TVIL_REAL Fbar0xxytableCLy2[] = 
      {0, 0, -0.125, -0.13020833333333334, -0.103515625, 
     -0.08277994791666667, -0.06783854166666667, -0.05688360305059524, 
     -0.04862173171270461, -0.042221720256502664, -0.03714690435500372, 
     -0.0330417683974317, -0.029663903905887797, -0.02684343086487578, 
     -0.024458304681078232, -0.022418883748295464, -0.020658018508076043, 
     -0.019124520174572304, -0.01777875306697423, -0.016589594860974836, 
     -0.015532298509645708, -0.014586961213719614, -0.01373741008600657, 
     -0.01297037896525127, -0.012274891994472851, -0.011641796244914553, 
     -0.011063403265155683, -0.010533211249719763, -0.010045687580339472, 
     -0.009596097071524727, -0.009180365166868393, -0.008794968115043078, 
     -0.008436844155842992, -0.008103321202278352, -0.0077920575745297005, 
     -0.007500993135508984, -0.007228308772417596, -0.00697239261792905, 
     -0.00673181174678528, -0.006505288346213444, -0.006291679561606901, 
     -0.00608996037697141, -0.005899209013485929, -0.0057185944271740865, 
     -0.005547365564125866, -0.00538484209347481, -0.005230406387862116, 
     -0.005083496561033748, -0.004943600404542617, -0.004810250091829755, 
     -0.004683017539454778, -0.004561510332889527, -0.004445368138829885, 
     -0.004334259538011788, -0.004227879222509479, -0.004125945509822673, 
     -0.00402819813302565, -0.003934396272097914, -0.003844316796478554, 
     -0.00375775269304409, -0.003674511657231597, -0.003594414828021131, 
     -0.0035172956500408945, -0.0034429988482363627, -0.0033713795024100006, 
     -0.003302302210539937, -0.0032356403311647746, -0.0031712752963113404, 
     -0.003109095987471059, -0.0030489981680223506, -0.0029908839662710516, 
     -0.0029346614039550954, -0.0028802439656477525, -0.0028275502050076765, 
     -0.0027765033842740276, -0.0027270311437997, -0.002679065198762648, 
     -0.0026325410605007415, -0.00258739778018496, -0.00254357771278371, 
     -0.002501026299481585, -0.0024596918669024977, -0.0024195254416527453, 
     -0.0023804805788467643, -0.002342513203409439, -0.0023055814630656315, 
     -0.002269645592031954, -0.0022346677845190297, -0.002200612077235991, 
     -0.002167444240163757, -0.002135131674930822, -0.002103643320185593, 
     -0.0020729495634136215, -0.002043022158696963, -0.0020138341499569986, 
     -0.001985359799261861, -0.0019575745198155753, -0.0019304548132785988, 
     -0.0019039782110989148, -0.0018781232195595673, -0.0018528692682728014};
 
  TVIL_REAL Fbar0xxytableCL3[] = 
     {0, 0, 0.0625, 0.03125, 0.01953125, 0.013671875, 0.01025390625, 
     0.008056640625, 0.0065460205078125, 0.00545501708984375, 
     0.0046367645263671875, 0.004004478454589844, 0.0035039186477661133, 
     0.0030996203422546387, 0.002767518162727356, 0.0024907663464546204, 
     0.0022572570014744997, 0.002058087266050279, 0.0018865799938794225, 
     0.0017376394680468366, 0.0016073165079433238, 0.0014925081859473721, 
     0.001390746264178233, 0.0013000454208622614, 0.00121879258205837, 
     0.0011456650271348678, 0.001079568967877087, 0.0010195929141061377, 
     0.0009649718651361661, 0.0009150595272842954, 0.0008693065509200806, 
     0.0008272433307142703, 0.0007884662995870388, 0.0007526269223330826, 
     0.000719422793406623, 0.0006885903879749107, 0.0006598991218092894, 
     0.0006331464547089128, 0.0006081538314967189, 0.0005847632995160758, 
     0.000562834675784223, 0.0005422431632555319, 0.0005228773359964058, 
     0.0005046374289267636, 0.00048743388021335127, 0.00047118608420623954, 
     0.0004558213205908187, 0.00044127383163579257, 0.00042748402439717406, 
     0.0004143977787523626, 0.0004019658453897917, 0.0003901433205253861, 
     0.0003788891862794615, 0.0003681659074224956, 0.0003579390766607596, 
     0.0003481771018427389, 0.00033885092947195125, 0.00032993379974900517, 
     0.0003214010290658412, 0.0003132298164624724, 0.0003053990710509106, 
     0.0002978892578283472, 0.00029068225965508075, 0.0002837612534728169, 
     0.00027711059909454774, 0.0002707157391154428, 0.00026456310868100093, 
     0.0002586400540090382, 0.0002529347587000153, 0.0002474361769891454, 
     0.00024213397319652088, 0.00023701846672053806, 0.0002320805819971935, 
     0.0002273118029150594, 0.00022270413123434872, 0.00021825004860966175, 
     0.00021394248186078685, 0.0002097747711751871, 0.00020574064096027966, 
     0.00020183417309394523, 0.00019804978234843376, 0.00019438219378642573, 
     0.00019082642194886916, 0.00018737775167268478, 0.00018403172039281542, 
     0.00018078410179764808, 0.00017763089071978213, 0.00017456828915564794, 
     0.0001715926933177676, 0.00016870068163263668, 0.00016588900360542605, 
     0.0001631545694800619, 0.0001604944406298435, 0.00015790582061968474, 
     0.00015538604688639188, 0.00015293258298818569, 0.0001505430113789953, 
     0.00014821502666694897, 0.00014594642932000588, 0.00014373511978485427, 
     0.00014157909298808148};
 
  TVIL_REAL Fbar0xxytableB[] = 
     {0, 0, -6.666327987697243, 1.3780980721093787, 
     -0.5962190418585888, 0.3360537734035998, -0.2167957009720997, 
     0.15185666722133911, -0.11245888672944566, 0.08670719018544441, 
     -0.06892895168980347, 0.05612973261090299, -0.046603702017221665, 
     0.039319607375414865, -0.03362352336198361, 0.02908419045961301, 
     -0.02540768897449584, 0.0223880204955734, -0.01987728714162622, 
     0.01776705325140905, -0.01597633607172145, 0.014443658691766578, 
     -0.013121665851344121, 0.011973398868764801, -0.010969669589587436, 
     0.010087177508406748, -0.009307138878548421, 0.008614274551860516, 
     -0.007996053069456558, 0.007442117954516633, -0.006943849670014726, 
     0.006494027211241769, -0.006086564236212801, 0.005716301534882823, 
     -0.0053788424910013325, 0.005070421646320982, -0.004787798965902231, 
     0.00452817421497528, -0.004289117189666525, 0.004068510532119721, 
     -0.0038645026002406286, 0.003675468420551335, -0.003499977177254409, 
     0.003336765015956863, -0.003184712191538369, 0.003042823784627837, 
     -0.0029102133635476876, 0.0027860890884103978, -0.0026697418488056453, 
     0.002560535101851763, -0.0024578961375926857, 0.002361308547077722, 
     -0.0022703057074830555, 0.0021844651302661685, -0.0021034035440978664, 
     0.002026772605371725, -0.0019542551463732918, 0.0018855618854324197, 
     -0.0018204285351594253, 0.0017586132546417294, -0.0016998943996184494, 
     0.0016440685314535973, -0.0015909486514307648, 0.001540362631687216, 
     -0.0014921518181488355, 0.0014461697842473, -0.0014022812171013111, 
     0.0013603609203101594, -0.0013202929196107058, 0.0012819696594462823, 
     -0.0012452912800359475, 0.0012101649658552963, -0.001176504357578266, 
     0.0011442290205118683, -0.0011132639634048238, 0.0010835392022467325, 
     -0.0010549893643133697, 0.001027553328269081, -0.0010011738966216337, 
     0.0009757974972476034, -0.0009513739110763393, 0.0009278560233446421, 
     -0.0009051995961187448, 0.0008833630600304899, -0.0008623073233948786, 
     0.0008419955970705108, -0.0008223932335962943, 0.0008034675792896116, 
     -0.0007851878381259452, 0.0007675249463394039, -0.0007504514567897747, 
     0.0007339414322363671, -0.0007179703467430101, 0.0007025149945138273, 
     -0.0006875534055265158, 0.0006730647673899741, -0.000659029352906861, 
     0.0006454284528700405, -0.0006322443136650321, 0.0006194600792897019, 
     -0.0006070597374373047};
 
  TVIL_REAL Fbar0xxytableBL[] = 
     {0, 0, -4.363451629653041, 1.07871398519455, -0.4735508486826, 
     0.26384871393654813, -0.16764754952961072, 0.11577284029750277, 
     -0.0846817643014943, 0.0646025360540784, -0.050893363694662505, 
     0.04112168066565108, -0.033913450908207785, 0.02844523540062145, 
     -0.024199319270773536, 0.020837030211437492, -0.018129299177150913, 
     0.01591671285861016, -0.014085569776985125, 0.012553013189204583, 
     -0.011257512249624138, 0.010152601059282427, -0.009202661208876436, 
     0.008380019817704752, -0.007662914300228969, 0.007034040221510426, 
     -0.006479498891235554, 0.0059880237349451155, -0.005550404147493448, 
     0.005159051258895086, -0.004807667032182737, 0.004490989521910908, 
     -0.00420459490224661, 0.003944742255355942, -0.003708250882919619, 
     0.003492402580193135, -0.0032948632331282583, 0.0031136194927777368, 
     -0.002946927302498164, 0.002793269808944881, -0.0026513227516790534, 
     0.0025199258505309227, -0.0023980590317306816, 0.002284822579796895, 
     -0.0021794204914887157, 0.0020811464548146814, -0.001989371990473037, 
     0.001903536382832938, -0.0018231380983705931, 0.0017477274456511784, 
     -0.0016769002757527317, 0.0016102925579435535, -0.0015475756943527878, 
     0.001488452460780651, -0.0014326534798185294, 0.0013799341479752147, 
     -0.001330071951229023, 0.0012828641138926573, -0.0012381255343211217, 
     0.0011956869681561694, -0.0011553934257576889, 0.0011171027554431473, 
     -0.0010806843883170419, 0.0010460182239662667, -0.0010129936392400916, 
     0.000981508604819093, -0.0009514688963829596, 0.0009227873889754157, 
     -0.000895383424687474, 0.0008691822450805492, -0.0008441144808836619, 
     0.0008201156924538692, -0.0007971259553098894, 0.0007750894857565353, 
     -0.0007539543022286486, 0.000733671918512222, -0.0007141970654591543, 
     0.0006954874382108494, -0.0006775034662930115, 0.0006602081042469329, 
     -0.0006435666407272594, 0.0006275465242280382, -0.0006121172038021858, 
     0.0005972499833180938, -0.000582917887954346, 0.0005690955417720581, 
     -0.0005557590553267192, 0.0005428859223895726, -0.0005304549249443777, 
     0.000518446045710357, -0.000506840387517569, 0.0004956200989280598, 
     -0.0004847683055558922, 0.0004742690465924758, -0.00046410721609112075, 
     0.00045426850860737916, -0.00044473936882974494, 0.00043550694486943226, 
     -0.00042655904490856815, 0.000417884096933681, -0.0004094711113060206};
 
  TVIL_REAL Fbar0xxytableBL2[] = 
     {0, 0, -1., 0.3333333333333333, -0.16666666666666666, 0.1, 
     -0.06666666666666667, 0.047619047619047616, -0.03571428571428571, 
     0.027777777777777776, -0.022222222222222223, 0.01818181818181818, 
     -0.015151515151515152, 0.01282051282051282, -0.01098901098901099, 
     0.009523809523809525, -0.008333333333333333, 0.007352941176470588, 
     -0.006535947712418301, 0.005847953216374269, -0.005263157894736842, 
     0.004761904761904762, -0.004329004329004329, 0.003952569169960474, 
     -0.0036231884057971015, 0.0033333333333333335, -0.003076923076923077, 
     0.002849002849002849, -0.0026455026455026454, 0.0024630541871921183, 
     -0.0022988505747126436, 0.002150537634408602, -0.0020161290322580645, 
     0.001893939393939394, -0.0017825311942959, 0.0016806722689075631, 
     -0.0015873015873015873, 0.0015015015015015015, -0.001422475106685633, 
     0.001349527665317139, -0.001282051282051282, 0.0012195121951219512, 
     -0.0011614401858304297, 0.0011074197120708748, -0.0010570824524312897, 
     0.00101010101010101, -0.000966183574879227, 0.0009250693802035153, 
     -0.0008865248226950354, 0.0008503401360544217, -0.0008163265306122449, 
     0.000784313725490196, -0.0007541478129713424, 0.000725689404934688, 
     -0.0006988120195667365, 0.0006734006734006734, -0.0006493506493506494, 
     0.0006265664160401002, -0.0006049606775559589, 0.0005844535359438924, 
     -0.0005649717514124294, 0.000546448087431694, -0.0005288207297726071, 
     0.0005120327700972862, -0.000496031746031746, 0.0004807692307692308, 
     -0.0004662004662004662, 0.0004522840343735866, -0.0004389815627743635, 
     0.00042625745950554135, -0.00041407867494824016, 0.00040241448692152917, 
     -0.0003912363067292645, 0.000380517503805175, -0.00037023324694557573, 
     0.00036036036036036037, -0.0003508771929824561, 0.0003417634996582365, 
     -0.000333000333000333, 0.0003245699448231094, -0.00031645569620253165, 
     0.00030864197530864197, -0.00030111412225233364, 0.0002938583602703497, 
     -0.00028686173264486515, 0.00028011204481792715, 
     -0.00027359781121751026, 0.0002673082063619353, -0.00026123301985370953, 
     0.0002553626149131767, -0.00024968789013732833, 0.0002442002442002442, 
     -0.00023889154323936931, 0.0002337540906965872, -0.00022878059940517045, 
     0.00022396416573348266, -0.0002192982456140351, 0.0002147766323024055, 
     -0.00021039343572480537, 0.00020614306328592042, -0.00020202020202020202};

  if (SAME2(0,x)) return TVIL_FBAR000x(y,qq);
  if (SAME2(0,y)) return TVIL_FBAR00xx(x,qq);

  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnyox = lnbary - lnbarx;

  if (y < 2. * x) {

    result = x * (1./3.L - lnbarx + lnbarx2 - lnbarx2*lnbarx/3.L + 
             8.L*Zeta3/3.L);

    result += y * (55.L/6.L + 5.L*lnbarx + 1.5L*lnbarx2 + 
              lnbarx2 * lnbarx/3.L - 1.5L * lnbary - lnbarx * lnbary 
              - 0.5L * lnbarx2 * lnbary - 8.L*Zeta3/3.L);

    rn = r = 0.25L * y/x;

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Fbar0xxytableA[n] + 
        Fbar0xxytableALx[n] * lnbarx + 
        Fbar0xxytableALy[n] * lnbary +
        Fbar0xxytableAL2[n] * lnbarx * lnyox); 
    }
  }
  else if (y > 6.47 * x) {
    result = y * (1/6.L + Zeta2 - 0.5L * lnbary - Zeta2 * lnbary + 
     0.5L * lnbary2 -lnbary2 * lnbary/6.L - 2.L * Zeta3/3.L);

    result += x * (-5.L/3.L + 2.L * Zeta2 + lnbarx - 2.L * Zeta2 * lnbarx 
              + 4.L * Zeta2 * lnbary + lnbary2 - lnbarx * lnbary2 
              + 2.L * lnbary2 * lnbary/3.L + 8.L * Zeta3/3.L);

    rn = r = 4.L * x/y;

    for (n=2; n < 100; n++) {
      rn *= r;
      result += y * rn * (Fbar0xxytableC[n] + 
        Fbar0xxytableCLx[n] * lnbarx + 
        Fbar0xxytableCLy[n] * lnbary +
        Fbar0xxytableCLx2[n] * lnbarx2 +
        Fbar0xxytableCLy2[n] * lnbary2 +
        Fbar0xxytableCLxLy[n] * lnbarx * lnbary +
        Fbar0xxytableCL3[n] * lnbary * lnyox * lnyox); 
    }
  }
  else {
    result = x * (1 - 4.L * LN2 - 3.L * lnbarx + 8.L * LN2 * lnbarx +
             3.L * lnbarx2 - 4.L * LN2 * lnbarx2 - lnbarx2 * lnbarx +
             13.L * Zeta3);

    result += (y - 4.L * x) * (-2.L - 42.L * LN2 + 3.L * lnbarx - 
              12.L * LN2 * lnbarx - 6 * LN2 * lnbarx2 - lnbarx2 * lnbarx +
              26.L * Zeta3)/6.L;
 
    rn = r = 0.25L * y/x - 1.L; 

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Fbar0xxytableB[n] + 
        Fbar0xxytableBL[n] * lnbarx + 
        Fbar0xxytableBL2[n] * lnbarx2);
    }

  }

  return result;
};

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARxxxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3, lnyox;
  TVIL_COMPLEX result;
  int n;

  TVIL_REAL FbarxxxyAtable[] = 
     {0, 0, -0.6771008042988288, -0.015794183710048648, 
     -0.000726927706672653, -0.00004369648636189193, -3.0308089586657903e-6, 
     -2.2983279944706415e-7, -1.8523083907800795e-8, 
     -1.560312514826848e-9, -1.359171173369866e-10, 
     -1.2155204389237518e-11, -1.1103290987348368e-12, 
     -1.0320703999858746e-13, -9.734209966399911e-15, 
     -9.295449292775476e-16, -8.971471253400263e-17, 
     -8.739249734633192e-18, -8.582370563437681e-19, 
     -8.488958228485253e-20, -8.450338051690998e-21, 
     -8.460149855651243e-22, -8.513747240778552e-23, 
     -8.607782431477428e-24, -8.739914637154617e-25, 
     -8.908602459030492e-26, -9.112954669338603e-27, 
     -9.352622319357283e-28, -9.627720605165542e-29, 
     -9.938772022762728e-30, -1.0286660000941011e-30, 
     -1.067253930337088e-31, -1.1097232040233646e-32, 
     -1.1555696619996604e-33, -1.198496267431609e-34, 
     -1.1772422735113943e-35, -5.10441410738581e-37, 
     6.3100717344050445e-37, 7.152696346525944e-37, 6.912948471753307e-37, 
     6.583738505833631e-37, 6.2670637444883925e-37, 
     5.9715949544539306e-37, 5.696419696580478e-37, 5.439820609285703e-37, 
     5.200173288161007e-37, 4.9760180975825315e-37, 4.766048214918821e-37, 
     4.569091642382392e-37, 4.38409494188499e-37, 4.210109139649265e-37, 
     4.046277539719993e-37, 3.891825163336405e-37, 3.7460495716576e-37, 
     3.6083128686567113e-37, 3.4780347138971645e-37, 
     3.3546862020459087e-37, 3.2377844884037532e-37, 
     3.1268880583225824e-37, 3.021592553842141e-37, 2.921527083784079e-37, 
     2.82635095434581e-37, 2.7357507663114128e-37, 2.6494378326411354e-37, 
     2.567145876659264e-37, 2.488628976531441e-37, 2.413659726370382e-37, 
     2.342027588267656e-37, 2.2735374129294315e-37, 
     2.2080081094875974e-37, 2.145271447540327e-37, 
     2.0851709766113202e-37, 2.027561050057335e-37, 1.972305942043383e-37, 
     1.9192790475811626e-37, 1.86836215682003e-37, 1.8194447958173885e-37, 
     1.7724236269189242e-37, 1.7272019026674806e-37, 
     1.683688967848467e-37, 1.641799804883117e-37, 1.6014546183102318e-37, 
     1.562578454562151e-37, 1.525100853650035e-37, 1.488955529734415e-37, 
     1.4540800778755878e-37, 1.420415704540179e-37, 1.387906979689733e-37, 
     1.3565016084984863e-37, 1.326150220944042e-37, 1.296806177689479e-37, 
     1.2684253908311314e-37, 1.2409661582251158e-37, 
     1.2143890102296802e-37, 1.1886565678112969e-37, 
     1.1637334110616623e-37, 1.1395859572617126e-37, 
     1.1161823477085756e-37, 1.0934923425930898e-37, 
     1.071487223280009e-37, 1.0501397014010827e-37};
 
  TVIL_REAL FbarxxxyALxtable[] = 
     {0, 0, -0.6111111111111112, -0.039457935324821496, 
     -0.004666338339500548, -0.0007072641084198667, -0.00012188447576817353, 
     -0.00002266478959495296, -4.42972137720031e-6, -8.96697994067143e-7, 
     -1.8632641549051558e-7, -3.9511000601148344e-8, 
     -8.515628432727089e-9, -1.8599318685234022e-9, 
     -4.107762677164815e-10, -9.158143830313938e-11, 
     -2.0583794803822603e-11, -4.659033879446382e-12, 
     -1.06106330482805e-12, -2.429686174267978e-13, 
     -5.590650823278745e-14, -1.2919876392215398e-14, 
     -2.9974453399330043e-15, -6.978798967900942e-16, 
     -1.6300760994286675e-16, -3.818669519669085e-17, 
     -8.969897656232906e-18, -2.112228713501523e-18, 
     -4.985284443798309e-19, -1.1791284183469243e-19, 
     -2.794401900641874e-20, -6.634594869964319e-21, 
     -1.5779192034590196e-21, -3.758824613053144e-22, 
     -8.967531513783172e-23, -2.142435917203444e-23, 
     -5.1253183677318954e-24, -1.2276625415485888e-24, 
     -2.9440970272019166e-25, -7.068258673223731e-26, 
     -1.6987692153368908e-26, -4.086903195871867e-27, 
     -9.841708465246619e-28, -2.372152286437946e-28, 
     -5.722578417122945e-29, -1.3816579959673066e-29, 
     -3.338509853755474e-30, -8.072960915389092e-31, 
     -1.9535605740653463e-31, -4.730656667737176e-32, 
     -1.1463150542163605e-32, -2.7794754728554484e-33, 
     -6.743524636864816e-34, -1.637064984107564e-34, 
     -3.976399148933443e-35, -9.66384317941247e-36, 
     -2.3498324818640528e-36, -5.716665915692237e-37, 
     -1.391424985818203e-37, -3.3882891311583733e-38, 
     -8.254633466680877e-39, -2.0118941779790434e-39, 
     -4.905645456183377e-40, -1.1966436757250815e-40, 
     -2.9201521975428923e-41, -7.128737415253807e-42, 
     -1.7409289407090676e-42, -4.253102126998309e-43, 
     -1.0393987370911744e-43, -2.5410057335598526e-44, 
     -6.214008893926968e-45, -1.5201159910017908e-45, 
     -3.719771473933933e-46, -9.105141021574887e-47, 
     -2.229381261495965e-47, -5.4601652392720866e-48, 
     -1.3376658848808941e-48, -3.2779832340615147e-49, 
     -8.034889517691855e-50, -1.9699905161049358e-50, 
     -4.8312127917486683e-51, -1.1850910198641425e-51, 
     -2.907648698813924e-52, -7.1350940300490505e-53, 
     -1.7507520779884405e-53, -4.291650523130475e-54, 
     -1.0472131053047345e-54, -2.506599027674213e-55, 
     -5.516437192956653e-56, -7.281331749827947e-57, 
     4.3458394247323795e-57, 7.06957021151347e-57, 7.609644523626782e-57, 
     7.617132869287717e-57, 7.497657863011859e-57, 7.35076608019832e-57, 
     7.200775979507188e-57, 7.053518724257317e-57, 6.910286967514003e-57, 
     6.771264229835529e-57, 6.636367870661476e-57};
 
  TVIL_REAL FbarxxxyALytable[] = 
     {0, 0, 0.16666666666666666, 0.0050134908803770506, 
     0.0002559075004982807, 0.000016284012677866168, 1.1710541889510905e-6, 
     9.105531625697603e-8, 7.474613961205244e-9, 6.385537549542906e-10, 
     5.624564945590386e-11, 5.075628573163536e-12, 4.671048007320135e-13, 
     4.3690944161752295e-14, 4.142867084717057e-15, 
     3.9743885767319906e-16, 3.851289729637914e-17, 3.764859604219425e-18, 
     3.7088521198723526e-19, 3.678730654960202e-20, 3.671175767864127e-21, 
     3.683756237520986e-22, 3.7147044458225384e-23, 
     3.7627601671512246e-24, 3.8270602685616957e-25, 
     3.9070598925858157e-26, 4.0024756673936845e-27, 
     4.113244627200483e-28, 4.2394945493271197e-29, 4.381522745152704e-30, 
     4.539781233613016e-31, 4.714866833284723e-32, 4.90751512970882e-33, 
     5.118597570462718e-34, 5.349121151813761e-35, 5.600230314090518e-36, 
     5.8732107759301485e-37, 6.169495122337957e-38, 6.49067002630868e-39, 
     6.838485034378482e-40, 7.214862886976085e-41, 7.621911377734799e-42, 
     8.061936784127375e-43, 8.537458926445852e-44, 9.051227934420079e-45, 
     9.606242821427824e-46, 1.0205771984941856e-46, 
     1.0853375759129867e-47, 1.1552931045810663e-48, 
     1.2308656921497144e-49, 1.3125129097305267e-50, 
     1.4007164926399677e-51, 1.4958438449733233e-52, 
     1.5967838940108834e-53, 1.6877684255532989e-54, 
     1.6112568550166193e-55, -1.586413411887804e-57, 
     -1.8358901203519511e-56, -1.9534924020439997e-56, 
     -1.9070792845178526e-56, -1.8460028391694415e-56, 
     -1.7860881049734094e-56, -1.7288581219835264e-56, 
     -1.674315234219673e-56, -1.6223110176760472e-56, 
     -1.5726921952933404e-56, -1.5253152870840188e-56, 
     -1.480047268041479e-56, -1.4367648159828267e-56, 
     -1.395353490593382e-56, -1.355706978490828e-56, 
     -1.317726410604019e-56, -1.2813197453546761e-56, 
     -1.2464012106314042e-56, -1.2128907982532614e-56, 
     -1.1807138053570616e-56, -1.1498004177963986e-56, 
     -1.1200853312111853e-56, -1.0915074059246838e-56, 
     -1.0640093522604765e-56, -1.037537443253167e-56, 
     -1.0120412520610969e-56, -9.874734116832947e-57, 
     -9.637893948415532e-57, -9.409473121165893e-57, 
     -9.189077266285873e-57, -8.976334837304851e-57, 
     -8.770895543400479e-57, -8.572428906766286e-57, 
     -8.380622932927312e-57, -8.195182884009673e-57, 
     -8.015830145953894e-57, -7.842301181539333e-57, 
     -7.674346561870535e-57, -7.511730069676899e-57, 
     -7.354227868404226e-57, -7.201627731638723e-57, 
     -7.053728327908523e-57, -6.910338556360839e-57, 
     -6.771276929220494e-57, -6.636370997302507e-57};
 
  TVIL_REAL FbarxxxyALxLytable[] = 
     {0, 0, 0.16666666666666666, 0.016666666666666666, 
     0.002380952380952381, 0.0003968253968253968, 0.00007215007215007215, 
     0.000013875013875013875, 2.775002775002775e-6, 5.713241007358655e-7, 
     1.202787580496559e-7, 2.577401958206912e-8, 5.603047735232417e-9, 
     1.2326705017511316e-9, 2.7392677816691816e-10, 6.139738131327476e-11, 
     1.3863924812674945e-11, 3.1508920028806695e-12, 
     7.202038863727245e-13, 1.6545224416670698e-13, 
     3.8181287115393914e-14, 8.846883599908346e-15, 
     2.0574147906763594e-15, 4.800634511578173e-16, 1.123552758028934e-16, 
     2.636909534149539e-17, 6.204493021528327e-18, 1.4633238258321526e-18, 
     3.4587654065123604e-19, 8.191812804897696e-20, 1.943819987602843e-20, 
     4.6205557082362665e-21, 1.1001323114848254e-21, 
     2.623392435079199e-22, 6.264817755413012e-23, 1.4981085936857203e-23, 
     3.587020576430598e-24, 8.59902192979938e-25, 2.0637652631518508e-25, 
     4.958397060819382e-26, 1.19252587538694e-26, 2.870895625931522e-27, 
     6.917820785377162e-28, 1.6684156011791979e-28, 4.027210071811857e-29, 
     9.728653544264598e-30, 2.3519821755364965e-30, 5.690279456943136e-31, 
     1.3776466053651802e-31, 3.337597445987808e-32, 8.091145323606808e-33, 
     1.962703568597691e-33, 4.763843613101192e-34, 1.1569334488960036e-34, 
     2.811240156195897e-35, 6.83466643478819e-36, 1.6624864300836136e-36, 
     4.045874055513219e-37, 9.850823787336533e-38, 2.399559640505053e-38, 
     5.847666350810633e-39, 1.4256707218918486e-39, 
     3.4772456631508503e-40, 8.484479418088075e-41, 
     2.0710146611081126e-41, 5.0571288236360894e-42, 
     1.2353291782927851e-42, 3.0186615259034222e-43, 7.37895039665281e-44, 
     1.8043418853129134e-44, 4.4134981367366226e-45, 
     1.0798984802653439e-45, 2.6431081684816107e-46, 
     6.471057929730841e-47, 1.58474888075041e-47, 3.882102962912078e-48, 
     9.512437723691846e-49, 2.3314798342381977e-49, 5.71588604522913e-50, 
     1.4016663231931305e-50, 3.4380494719831504e-51, 
     8.434966095859281e-52, 2.0699303302722166e-52, 5.08073808339544e-53, 
     1.2473668348455872e-53, 3.063060570774667e-54, 7.523306665060585e-55, 
     1.8482111749426293e-55, 4.541318887001889e-56, 
     1.1160868451106337e-56, 2.7434536974786526e-57, 
     6.744955223082875e-58, 1.6585955466597236e-58, 4.07924850664959e-59, 
     1.0034515043095249e-59, 2.4688092566345452e-60, 
     6.0750803697289855e-61, 1.4951622671612789e-61, 
     3.6803994268585327e-62, 9.060881837697403e-63, 2.231071407272225e-63};

  TVIL_REAL FbarxxxyBtable[] = 
     {0, 0, -5.966406282768356, 1.049895022103459, -0.4063468195477593, 
     0.21243243881038343, -0.12995197784239967, 0.08752357590441186, 
     -0.06289711691633826, 0.047357626919277224, -0.03693238314198893, 
     0.029602563901053855, -0.02425474247103696, 0.02023425457553582, 
     -0.017135852555697762, 0.014697845112108367, -0.012745155333527738, 
     0.011157078328012928, -0.009848215374659451, 0.0087567730900252, 
     -0.007837147684903291, 0.007055090771421478, -0.006384478716771728, 
     0.0058051053694902115, -0.005301143838266372, 0.004860055245815599, 
     -0.004471801981038327, 0.004128272093860371, -0.003822852480132174, 
     0.0035501084767271245, -0.0033055405970598747, 0.0030853978917978735, 
     -0.0028865333588110912, 0.002706290915060306, -0.0025424162961861898, 
     0.0023929862656523653, -0.0022563519567633432, 0.0021310932128603788, 
     -0.0020159815519779677, 0.0019099499433800125, -0.001812068000932883, 
     0.0017215215116215623, -0.001637595454573753, 0.0015596598466689692, 
     -0.001487157889564023, 0.0014195960002346025, -0.0013565353905990176, 
     0.0012975849271375693, -0.0012423950528837034, 0.0011906525949185146, 
     -0.001142076312948629, 0.001096413070514166, -0.0010534345312545885, 
     0.0010129342995302978, -0.0009747254383883047, 0.0009386383090181697, 
     -0.0009045186849756221, 0.0008722261019535049, -0.0008416324100669941, 
     0.0008126205007415452, -0.0007850831845462415, 0.0007589221998610128, 
     -0.0007340473352311957, 0.0007103756507500656, -0.0006878307859026589, 
     0.0006663423430701506, -0.000645845337388521, 0.0006262797049234436, 
     -0.0006075898622023668, 0.0005897243110652364, -0.0005726352835824599, 
     0.0005562784224634928, -0.0005406124929592268, 0.0005255991227606793, 
     -0.0005112025668274441, 0.0004973894944521246, -0.0004841287961900477, 
     0.0004713914085641619, -0.00045915015469919147, 0.000447379599252011, 
     -0.00043605591619115444, 0.0004251567681410971, -0.0004146611961495879, 
     0.000404549518861567, -0.0003948032401933728, 0.00038540496469800534, 
     -0.0003763383198978604, 0.0003675878849370413, -0.0003591391249723523, 
     0.00035097833078146456, -0.00034309256311946076, 0.0003354696014018275, 
     -0.00032809789633367814, 0.0003209665261421701, -0.00031406515610226635, 
     0.0003073840010756466, -0.00030091379080910975, 0.000294645737762581, 
     -0.00028857150725816044, 0.0002826831897607967, -0.00027697327511838437};
 
  TVIL_REAL FbarxxxyBLtable[] = 
     {0, 0, -4.363451629653041, 1.07871398519455, -0.4735508486826, 
     0.26384871393654813, -0.16764754952961078, 0.11577284029750279, 
     -0.0846817643014943, 0.0646025360540784, -0.05089336369466251, 
     0.041121680665651084, -0.03391345090820779, 0.02844523540062146, 
     -0.024199319270773546, 0.020837030211437492, -0.018129299177150913, 
     0.015916712858610158, -0.014085569776985125, 0.012553013189204583, 
     -0.011257512249624143, 0.01015260105928243, -0.009202661208876438, 
     0.008380019817704755, -0.007662914300228969, 0.007034040221510425, 
     -0.0064794988912355534, 0.005988023734945115, -0.005550404147493452, 
     0.005159051258895088, -0.0048076670321827416, 0.004490989521910913, 
     -0.004204594902246611, 0.003944742255355944, -0.0037082508829196217, 
     0.0034924025801931387, -0.0032948632331282583, 0.0031136194927777363, 
     -0.0029469273024981635, 0.0027932698089448813, -0.0026513227516790504, 
     0.0025199258505309223, -0.0023980590317306846, 0.0022848225797968964, 
     -0.002179420491488717, 0.0020811464548146797, -0.001989371990473036, 
     0.0019035363828329391, -0.0018231380983705938, 0.0017477274456511806, 
     -0.0016769002757527286, 0.0016102925579435526, -0.001547575694352788, 
     0.0014884524607806512, -0.0014326534798185277, 0.001379934147975214, 
     -0.0013300719512290245, 0.0012828641138926576, -0.001238125534321123, 
     0.0011956869681561707, -0.00115539342575769, 0.0011171027554431495, 
     -0.0010806843883170436, 0.0010460182239662677, -0.001012993639240091, 
     0.0009815086048190925, -0.0009514688963829607, 0.000922787388975415, 
     -0.0008953834246874753, 0.0008691822450805497, -0.0008441144808836625, 
     0.0008201156924538689, -0.0007971259553098886, 0.0007750894857565342, 
     -0.0007539543022286488, 0.0007336719185122225, -0.000714197065459155, 
     0.000695487438210849, -0.0006775034662930113, 0.000660208104246934, 
     -0.0006435666407272599, 0.0006275465242280387, -0.0006121172038021859, 
     0.0005972499833180937, -0.0005829178879543455, 0.0005690955417720577, 
     -0.0005557590553267194, 0.0005428859223895729, -0.0005304549249443784, 
     0.000518446045710358, -0.0005068403875175696, 0.0004956200989280583, 
     -0.00048476830555589217, 0.00047426904659247606, 
     -0.00046410721609112075, 0.0004542685086073796, -0.0004447393688297461, 
     0.00043550694486943226, -0.0004265590449085692, 0.0004178840969336804, 
     -0.0004094711113060205};
 
  TVIL_REAL FbarxxxyBL2table[] = 
     {0, 0, -1., 0.3333333333333333, -0.16666666666666666, 0.1, 
     -0.06666666666666667, 0.047619047619047616, -0.03571428571428571, 
     0.027777777777777776, -0.022222222222222223, 0.01818181818181818, 
     -0.015151515151515152, 0.01282051282051282, -0.01098901098901099, 
     0.009523809523809525, -0.008333333333333333, 0.007352941176470588, 
     -0.006535947712418301, 0.005847953216374269, -0.005263157894736842, 
     0.004761904761904762, -0.004329004329004329, 0.003952569169960474, 
     -0.0036231884057971015, 0.0033333333333333335, -0.003076923076923077, 
     0.002849002849002849, -0.0026455026455026454, 0.0024630541871921183, 
     -0.0022988505747126436, 0.002150537634408602, -0.0020161290322580645, 
     0.001893939393939394, -0.0017825311942959, 0.0016806722689075631, 
     -0.0015873015873015873, 0.0015015015015015015, -0.001422475106685633, 
     0.001349527665317139, -0.001282051282051282, 0.0012195121951219512, 
     -0.0011614401858304297, 0.0011074197120708748, -0.0010570824524312897, 
     0.00101010101010101, -0.000966183574879227, 0.0009250693802035153, 
     -0.0008865248226950354, 0.0008503401360544217, -0.0008163265306122449, 
     0.000784313725490196, -0.0007541478129713424, 0.000725689404934688, 
     -0.0006988120195667365, 0.0006734006734006734, -0.0006493506493506494, 
     0.0006265664160401002, -0.0006049606775559589, 0.0005844535359438924, 
     -0.0005649717514124294, 0.000546448087431694, -0.0005288207297726071, 
     0.0005120327700972862, -0.000496031746031746, 0.0004807692307692308, 
     -0.0004662004662004662, 0.0004522840343735866, -0.0004389815627743635, 
     0.00042625745950554135, -0.00041407867494824016, 0.00040241448692152917, 
     -0.0003912363067292645, 0.000380517503805175, -0.00037023324694557573, 
     0.00036036036036036037, -0.0003508771929824561, 0.0003417634996582365, 
     -0.000333000333000333, 0.0003245699448231094, -0.00031645569620253165, 
     0.00030864197530864197, -0.00030111412225233364, 0.0002938583602703497, 
     -0.00028686173264486515, 0.00028011204481792715, 
     -0.00027359781121751026, 0.0002673082063619353, -0.00026123301985370953, 
     0.0002553626149131767, -0.00024968789013732833, 0.0002442002442002442, 
     -0.00023889154323936931, 0.0002337540906965872, -0.00022878059940517045, 
     0.00022396416573348266, -0.0002192982456140351, 0.0002147766323024055, 
     -0.00021039343572480537, 0.00020614306328592042, -0.00020202020202020202};

  TVIL_REAL FbarxxxyCtable[] = 
     {1.0102294647418302, 0.4556021268822753, 
     -0.05371907311293129, -0.02410436132778537, -0.01637827988262368, 
     -0.011833947935051643, -0.008923569946890553, -0.0069567449129927005, 
     -0.005569568559245571, -0.004556546018205067, -0.0037951421725132637, 
     -0.003208873249816055, -0.0027481107788816105, -0.0023795640069594055, 
     -0.0020802514592322277, -0.0018339071341009656, -0.0016287630809104856, 
     -0.0014561391052901537, -0.0013095213836459942, -0.0011839459040587916, 
     -0.0010755769351837047, -0.000981413206854794, -0.0008990794949257705, 
     -0.0008266764162996729, -0.0007626705935579389, -0.0007058132643545862, 
     -0.0006550792273420893, -0.0006096205240433757, -0.0005687309316264093, 
     -0.0005318184786107296, -0.0004983839783708578, -0.00046800412151043935, 
     -0.00044031805406329505, -0.0004150166442809301, 
     -0.00039183384004805186, -0.00037053966443504114, 
     -0.00035093450410354917, -0.00033284442500714374, 
     -0.0003161173096239958, -0.0003006196551669903, -0.00028623390665725686, 
     -0.0002728562251740616, -0.0002603946120107561, -0.000248767325342502, 
     -0.0002379015384329939, -0.00022773219818328927, 
     -0.00021820105056279295, -0.00020925580561848695, 
     -0.0002008494196817357, -0.00019293947634857532, 
     -0.00018548765100400786, -0.00017845924625178045, 
     -0.00017182278772154692, -0.00016554967145140774, 
     -0.0001596138554611916, -0.00015399158930013806, -0.0001486611763191659, 
     -0.00014360276422033792, -0.00013879816010459073, 
     -0.00013423066679747687, -0.00012988493770107765, 
     -0.00012574684781416974, -0.00012180337889499303, 
     -0.00011804251702201783, -0.00011445316104650152, 
     -0.0001110250406333679, -0.00010774864275981629, 
     -0.00010461514568884017, -0.00010161635956145831, 
     -0.00009874467286021628, -0.00009599300409013901, 
     -0.00009335475810408794, -0.00009082378656931383, 
     -0.00008839435213250474, -0.00008606109589316029, 
     -0.0000838190078408203, -0.00008166339995150263, 
     -0.00007958988167348205, -0.00007759433756296234, 
     -0.00007567290685685318, -0.00007382196479326421, 
     -0.00007203810551090553, -0.00007031812637670667, 
     -0.00006865901360695262, -0.00006705792906135962, 
     -0.00006551219810201135, -0.00006401929842015146, 
     -0.00006257684974365603, -0.0000611826043467449, 
     -0.00005983443829126267, -0.00005853034333578725, 
     -0.00005726841945500377, -0.00005604686791730347, 
     -0.0000548639848735065, -0.00005371815541403169, 
     -0.00005260784805580311, -0.000051531609623745085, 
     -0.00005048806049491846, -0.00004947589017623126, 
     -0.000048493853189251905, -0.000047540765237992915};
 
  TVIL_REAL FbarxxxyCLxtable[] = 
     {0., -0.33776312596627256, -0.047280694659171674, 
     -0.03880325133861923, -0.02631157557587333, -0.018712671266748197, 
     -0.013892719699750162, -0.010681309899242085, -0.008449723773400555, 
     -0.006842928308842, -0.005650648304378521, -0.004742999597628709, 
     -0.00403672783577585, -0.0034766916285821053, -0.003025294683080117, 
     -0.0026562352099280535, -0.0023506875001020073, -0.0020948999083722814, 
     -0.0018786430648287497, -0.0016941828060456554, -0.0015355852762085152, 
     -0.0013982372649787864, -0.0012785090251578397, -0.0011735132738673278, 
     -0.0010809303021906286, -0.0009988792789622644, -0.0009258223276099209, 
     -0.000860492182289068, -0.0008018370296246208, -0.0007489780270493504, 
     -0.000701176276321433, -0.0006578069227681011, -0.0006183386767454599, 
     -0.0005823174984023677, -0.0005493535062144665, -0.0005191104016214527, 
     -0.0004912968721151605, -0.00046565956095720587, -0.0004419772856577675, 
     -0.00042005625808211284, -0.0003997261127254319, 
     -0.00038083659072775123, -0.000363254758788412, -0.00034686266662004787, 
     -0.00033155536567499775, -0.000317239226858353, -0.0003038305067645898, 
     -0.0002912541213561576, -0.0002794425934856557, -0.0002683351466623204, 
     -0.0002578769222958811, -0.00024801830156122523, 
     -0.00023871431620556098, -0.00022992413521386615, 
     -0.00022161061637430613, -0.0002137399135342859, -0.0002062811317820829, 
     -0.0001992060239859721, -0.00019248872311819387, 
     -0.00018610550562173008, -0.00018003458177316838, 
     -0.0001742559095788016, -0.00016875102923286632, 
     -0.00016350291558220193, -0.00015849584639346235, 
     -0.00015371528451785674, -0.00014914777230288953, 
     -0.00014478083681784427, -0.000140602904645713, -0.0001366032251538057, 
     -0.00013277180129245614, -0.00012909932708946598, 
     -0.0001255771311100436, -0.00012219712524037463, 
     -0.00011895175822961852, -0.00011583397349174272, 
     -0.00011283717072661305, -0.00010995517097036462, 
     -0.00010718218472930528, -0.00010451278289032961, 
     -0.00010194187013478593, -0.00009946466061258077, 
     -0.00009707665565956652, -0.0000947736233644063, 
     -0.00009255157981154699, -0.00009040677184500072, 
     -0.00008833566121363701, -0.00008633490997287792, 
     -0.0000844013670302907, -0.00008253205573378006, 
     -0.00008072416241106277, -0.00007897502577800714, 
     -0.00007728212714136632, -0.00007564308132853907, 
     -0.00007405562828335009, -0.00007251762527254205, 
     -0.00007102703965278424, -0.00006958194215259758, 
     -0.00006818050062772576, -0.00006682097425220335, 
     -0.00006550170811072312};
 
  TVIL_REAL FbarxxxyCLytable[] = 
     {-2.1449340668482266, 0.5088595852658784, 
     0.05703215309986862, 0.04127507368377029, 0.027131556710462235, 
     0.01899961447370015, 0.013996291383893893, 0.010719589021356175, 
     0.008464143919156772, 0.006848446488544622, 0.005652787806017364, 
     0.004743838358069136, 0.004037059785485366, 0.0034768240791274614, 
     0.0030253479092657615, 0.0026562567333443506, 0.0023506962519325124, 
     0.00209490348460838, 0.0018786445326426221, 0.001694183410890135, 
     0.001535585526347456, 0.0013982373687656795, 0.0012785090683499329, 
     0.0011735132918916369, 0.0010809303097313093, 0.000998879282124366, 
     0.0009258223289387817, 0.0008604921828486383, 0.000801837029860691, 
     0.0007489780271491169, 0.0007011762763636646, 0.0006578069227860053, 
     0.0006183386767530613, 0.0005823174984055993, 0.0005493535062158422, 
     0.000519110401622039, 0.0004912968721154107, 0.0004656595609573127, 
     0.00044197728565781313, 0.00042005625808213236, 0.00039972611272544024, 
     0.0003808365907277548, 0.00036325475878841353, 0.0003468626666200485, 
     0.000331555365674998, 0.0003172392268583531, 0.00030383050676458987, 
     0.00029125412135615767, 0.0002794425934856557, 0.0002683351466623204, 
     0.0002578769222958811, 0.00024801830156122523, 0.00023871431620556098, 
     0.00022992413521386615, 0.00022161061637430613, 0.0002137399135342859, 
     0.0002062811317820829, 0.0001992060239859721, 0.00019248872311819387, 
     0.00018610550562173008, 0.00018003458177316838, 0.0001742559095788016, 
     0.00016875102923286632, 0.00016350291558220193, 0.00015849584639346235, 
     0.00015371528451785674, 0.00014914777230288953, 0.00014478083681784427, 
     0.000140602904645713, 0.0001366032251538057, 0.00013277180129245614, 
     0.00012909932708946598, 0.0001255771311100436, 0.00012219712524037463, 
     0.00011895175822961852, 0.00011583397349174272, 0.00011283717072661305, 
     0.00010995517097036462, 0.00010718218472930528, 0.00010451278289032961, 
     0.00010194187013478593, 0.00009946466061258077, 0.00009707665565956652, 
     0.0000947736233644063, 0.00009255157981154699, 0.00009040677184500072, 
     0.00008833566121363701, 0.00008633490997287792, 0.0000844013670302907, 
     0.00008253205573378006, 0.00008072416241106277, 0.00007897502577800714, 
     0.00007728212714136632, 0.00007564308132853907, 0.00007405562828335009, 
     0.00007251762527254205, 0.00007102703965278424, 0.00006958194215259758, 
     0.00006818050062772576, 0.00006682097425220335, 0.00006550170811072312};
 
  TVIL_REAL FbarxxxyCLx2table[] = 
     {0., 0., -0.037037037037037035, -0.0205761316872428, 
     -0.013920642178529695, -0.00985057607523695, -0.007234669511761419, 
     -0.005493923683525163, -0.004294866146991887, -0.0034415104020405663, 
     -0.0028159182299640436, -0.0023450949341543097, -0.001982509761596128, 
     -0.0016976290247946676, -0.0014698584590077239, -0.0012849497168193954, 
     -0.00113281305551888, -0.001006151460134322, -0.0008995863771232325, 
     -0.0008090848508841458, -0.0007315758317880835, -0.0006646879047545758, 
     -0.0006065666173000198, -0.0005557450330741675, -0.0005110505365098495, 
     -0.00047153675233156824, -0.0004364331414322745, -0.0004051072205914748, 
     -0.0003770359201922362, -0.00035178363983633045, -0.0003289852705775658, 
     -0.0003083329398897715, -0.0002895655751524713, -0.0002724606211368637, 
     -0.00025682741812369067, -0.00024250187083683667, 
     -0.00022934212849218234, -0.00021722506262819292, 
     -0.00020604337870855358, -0.00019570323446038267, 
     -0.00018612226585205274, -0.00017722794289140063, 
     -0.00016895619374524145, -0.00016125024828561192, 
     -0.00015405966196670794, -0.00014733948860108653, 
     -0.00014104957663459616, -0.00013515396829167901, 
     -0.0001296203847591777, -0.0001244197836125847, -0.00011952597712813423, 
     -0.00011491530209361097, -0.00011056633332794871, 
     -0.00010645963442057157, -0.00010257754026535678, 
     -0.00009890396683769213, -0.00009542424438315598, 
     -0.00009212497078203115, -0.00008899388234840329, 
     -0.0000860197397345626, -0.00008319222695574071, 
     -0.00008050186183889476, -0.00007793991644202776, 
     -0.00007549834619531193, -0.00007316972668849932, 
     -0.00007094719717603223, -0.0000688244099962261, 
     -0.00006679548520745055, -0.00006485496983531792, 
     -0.00006299780120293934, -0.00006121927388334711, 
     -0.00005951500987089417, -0.00005788093161823586, 
     -0.000056313237628552206, -0.000054808380329973354, 
     -0.00005336304599155818, -0.000051974136468350876, 
     -0.000050638752587597065, -0.000049354179009644526, 
     -0.00004811787041581242, -0.000046927438891952187, 
     -0.000045780642390854844, -0.00004467537416934922, 
     -0.000043609653107113064, -0.00004258161482407867, 
     -0.00004158950352202686, -0.000040631664483671934, 
     -0.00003970653716937205, -0.00003881264885766238, 
     -0.00003794860878119673, -0.00003711310271447868, 
     -0.000036304887974036664, -0.00003552278879551048, 
     -0.000034765692055524036, -0.000034032543309266536, 
     -0.000033322343117434656, -0.00003263414363863599, 
     -0.0000319670454655523, -0.000031320194685136486, 
     -0.0000306927801448952, -0.000030084030908910406};
 
  TVIL_REAL FbarxxxyCLxLytable[] = 
     {0., 0.1111111111111111, 0.08641975308641975, 
     0.04572473708276177, 0.029340039628105472, 0.020208075778872913, 
     0.014647094722963916, 0.01105207127324352, 0.00861349921679395, 
     0.006891987416082775, 0.005635273061083626, 0.004691524333119269, 
     0.003965543437538121, 0.003395465675168728, 0.0029397998658148065, 
     0.0025699328051968042, 0.002265639620013817, 0.002012308418632254, 
     0.0017991750030453128, 0.0016181706255194493, 0.001463152044519143, 
     0.0013293759671632055, 0.0012131333000563761, 0.0011114900934053754, 
     0.0010221010844006925, 0.0009430735094270377, 0.000872866284863231, 
     0.0008102144420232788, 0.0007540718407384815, 0.0007035672798220707, 
     0.0006579705412182986, 0.0006166658798062917, 0.0005791311503162866, 
     0.0005449212422785452, 0.0005136548362494302, 0.00048500374167454574, 
     0.0004586842569847366, 0.0004344501252565446, 0.00041208675741717497, 
     0.00039140646892079435, 0.0003722445317041179, 0.0003544558857828066, 
     0.0003379123874904852, 0.0003225004965712248, 0.0003081193239334163, 
     0.0002946789772021732, 0.0002820991532691924, 0.0002703079365833581, 
     0.0002592407695183554, 0.0002488395672251694, 0.00023905195425626846, 
     0.00022983060418722194, 0.00022113266665589742, 0.00021291926884114314, 
     0.00020515508053071355, 0.00019780793367538425, 0.00019084848876631196, 
     0.0001842499415640623, 0.00017798776469680658, 0.0001720394794691252, 
     0.00016638445391148142, 0.00016100372367778952, 0.00015587983288405552, 
     0.00015099669239062387, 0.00014633945337699865, 0.00014189439435206445, 
     0.0001376488199924522, 0.0001335909704149011, 0.00012970993967063583, 
     0.00012599560240587868, 0.00012243854776669422, 0.00011903001974178834, 
     0.00011576186323647172, 0.00011262647525710441, 0.00010961676065994671, 
     0.00010672609198311636, 0.00010394827293670175, 0.00010127750517519413, 
     0.00009870835801928905, 0.00009623574083162484, 0.00009385487778390437, 
     0.00009156128478170969, 0.00008935074833869844, 0.00008721930621422613, 
     0.00008516322964815734, 0.00008317900704405372, 0.00008126332896734387, 
     0.0000794130743387441, 0.00007762529771532475, 0.00007589721756239346, 
     0.00007422620542895736, 0.00007260977594807333, 0.00007104557759102096, 
     0.00006953138411104807, 0.00006806508661853307, 0.00006664468623486931, 
     0.00006526828727727198, 0.0000639340909311046, 0.00006264038937027297, 
     0.0000613855602897904, 0.00006016806181782081};
 
   TVIL_REAL FbarxxxyCLy2table[] = 
     {0.5, 0.05555555555555555, -0.04938271604938271, 
     -0.025148605395518976, -0.015419397449575776, -0.010357499703635963, 
     -0.007412425211202498, -0.005558147589718357, -0.004318633069802061, 
     -0.003450477014042208, -0.0028193548311195816, -0.0023464293989649593, 
     -0.0019830336759419937, -0.0016978366503740607, -0.0014699414068070824, 
     -0.001284983088377409, -0.001132826564494937, -0.001006156958497932, 
     -0.0008995886259220803, -0.0008090857746353035, -0.0007315762127310596, 
     -0.0006646880624086296, -0.0006065666827563562, -0.0005557450603312078, 
     -0.0005110505478908429, -0.0004715367570954694, -0.0004364331434309565, 
     -0.0004051072214318041, -0.00037703592054624525, -0.0003517836399857403, 
     -0.00032898527064073287, -0.0003083329399165202, -0.0002895655751638153, 
     -0.0002724606211416815, -0.0002568274181257395, -0.00024250187083770907, 
     -0.00022934212849255424, -0.00021722506262835165, 
     -0.0002060433787086214, -0.00019570323446041168, 
     -0.00018612226585206515, -0.00017722794289140595, 
     -0.00016895619374524373, -0.0001612502482856129, 
     -0.00015405966196670837, -0.0001473394886010867, 
     -0.00014104957663459624, -0.00013515396829167904, 
     -0.0001296203847591777, -0.0001244197836125847, -0.00011952597712813423, 
     -0.00011491530209361097, -0.00011056633332794871, 
     -0.00010645963442057157, -0.00010257754026535678, 
     -0.00009890396683769213, -0.00009542424438315598, 
     -0.00009212497078203115, -0.00008899388234840329, 
     -0.0000860197397345626, -0.00008319222695574071, 
     -0.00008050186183889476, -0.00007793991644202776, 
     -0.00007549834619531193, -0.00007316972668849932, 
     -0.00007094719717603223, -0.0000688244099962261, 
     -0.00006679548520745055, -0.00006485496983531792, 
     -0.00006299780120293934, -0.00006121927388334711, 
     -0.00005951500987089417, -0.00005788093161823586, 
     -0.000056313237628552206, -0.000054808380329973354, 
     -0.00005336304599155818, -0.000051974136468350876, 
     -0.000050638752587597065, -0.000049354179009644526, 
     -0.00004811787041581242, -0.000046927438891952187, 
     -0.000045780642390854844, -0.00004467537416934922, 
     -0.000043609653107113064, -0.00004258161482407867, 
     -0.00004158950352202686, -0.000040631664483671934, 
     -0.00003970653716937205, -0.00003881264885766238, 
     -0.00003794860878119673, -0.00003711310271447868, 
     -0.000036304887974036664, -0.00003552278879551048, 
     -0.000034765692055524036, -0.000034032543309266536, 
     -0.000033322343117434656, -0.00003263414363863599, 
     -0.0000319670454655523, -0.000031320194685136486, 
     -0.0000306927801448952, -0.000030084030908910406};
 
  TVIL_REAL FbarxxxyCLx3table[] = 
     {0., 0., 0., -0.0027434842249657062, 
     -0.002286236854138089, -0.0016935087808430287, -0.0012513148214006824, 
     -0.0009441834141095207, -0.0007307873693794239, -0.0005795769877312813, 
     -0.0004697419776027041, -0.000387946874697261, -0.0003256038838777278, 
     -0.0002770857887739143, -0.0002386235236319674, -0.00020763369824178574, 
     -0.0001823052613670202, -0.0001613413837640083, -0.0001437951028546089, 
     -0.00012896247660219636, -0.00011631166796676705, 
     -0.0001054349245752789, -0.00009601543956703942, -0.0000878040734150586, 
     -0.00008060273173632106, -0.00007425231455758677, 
     -0.00006862385678287068, -0.00006361193028976614, 
     -0.00005912967151751537, -0.00005510499265014013, 
     -0.00005147766510583802, -0.0000481970531705047, 
     -0.000045220337281567425, -0.00004251110969533135, 
     -0.00004003825594217643, -0.00003777505748560023, 
     -0.00003569846696780965, -0.000033788519123156905, 
     -0.00003202784909330699, -0.000030401296334768646, 
     -0.000028895577168069774, -0.000027499012702963927, 
     -0.000026201301690041508, -0.00002499333001625538, 
     -0.000023867010240900562, -0.000022815145877771933, 
     -0.000021831316156241264, -0.00002090977780432793, 
     -0.000020045381039733595, -0.000019233497467555627, 
     -0.00001846995799439359, -0.00001775099919959407, 
     -0.000017073216872229204, -0.000016433525640089608, 
     -0.000015829123794637197, -0.000015257462561455015, 
     -0.00001471621918550503, -0.000014203273299409734, 
     -0.000013716686124940016, -0.00001325468212605746, 
     -0.00001281563278873755, -0.00001239804225041373, 
     -0.000012000534541864203, -0.000011621842238038045, 
     -0.000011260796342762182, -0.000010916317256365576, 
     -0.000010587406695722642, -0.000010273140453646468, 
     -9.972661899442716e-6, -9.68517613517076e-6, -9.409944733085062e-6, 
     -9.146280989125612e-6, -8.893545635424153e-6, -8.651142961787318e-6, 
     -8.418517302172035e-6, -8.19514984741958e-6, -7.980555750078434e-6, 
     -7.77428149111995e-6, -7.575902481817921e-6, -7.385020877093344e-6, 
     -7.201263579279012e-6, -7.0242804135858756e-6, -6.853742458597901e-6, 
     -6.689340516921762e-6, -6.53078371270403e-6, -6.377798204129074e-6, 
     -6.23012600024932e-6, -6.087523872596203e-6, -5.949762352992789e-6, 
     -5.816624809852836e-6, -5.687906596019325e-6, -5.563414261879638e-6, 
     -5.442964828104713e-6, -5.326385112904262e-6, -5.213511109177215e-6, 
     -5.104187407372558e-6, -4.99826666026649e-6, -4.895609086212473e-6, 
     -4.796082007735744e-6, -4.6995594226271655e-6, -4.605921604946375e-6};
 
  TVIL_REAL FbarxxxyCLx2Lytable[] = 
     {0., 0., 0.012345679012345678, 0.010973936899862825, 
     0.007620789513793629, 0.00531761757184711, 0.0038329748739747214, 
     0.0028601481632015593, 0.002202328024009076, 0.0017424220431459937, 
     0.0014106203407900355, 0.0011643758513979756, 0.0009770197955855915, 
     0.000831339200696194, 0.0007159030448540178, 0.0006229140843086034, 
     0.0005469210160165348, 0.0004840262714146353, 0.0004313861723174828, 
     0.00038688778338995705, 0.00034893514926235246, 0.0003163048337165245, 
     0.00028804634354574656, 0.00026341223056709865, 0.00024180819950976438, 
     0.00022275694546953947, 0.00020587157110110927, 0.00019083579118516148, 
     0.00017738901468540913, 0.00016531497800641631, 0.0001544329953411568, 
     0.00014459115952151352, 0.00013566101184893815, 0.00012753332908779108, 
     0.00012011476782729274, 0.00011332517245712545, 0.00010709540090356729, 
     0.0001013655573695297, 0.00009608354727994614, 0.00009120388900431671, 
     0.00008668673150421392, 0.00008249703810889376, 0.00007860390507012536, 
     0.0000749799900487665, 0.00007160103072270184, 0.00006844543763331587, 
     0.00006549394846872383, 0.0000627293334129838, 0.00006013614311920079, 
     0.000057700492402666885, 0.00005540987398318077, 0.0000532529975987822, 
     0.00005121965061668761, 0.00004930057692026882, 0.00004748737138391159, 
     0.00004577238768436505, 0.00004414865755651509, 0.0000426098198982292, 
     0.00004115005837482005, 0.00003976404637817238, 0.00003844689836621265, 
     0.000037194126751241186, 0.00003600160362559261, 
     0.000034865526714114136, 0.000033782389028286544, 
     0.00003274895176909673, 0.000031762220087167924, 0.0000308194213609394, 
     0.000029917985698328147, 0.00002905552840551228, 
     0.000028229834199255185, 0.000027438842967376834, 
     0.000026680636906272455, 0.000025953428885361955, 
     0.000025255551906516106, 0.00002458544954225874, 0.0000239416672502353, 
     0.000023322844473359846, 0.00002272770744545376, 
     0.000022155062631280032, 0.000021603790737837035, 
     0.000021072841240757628, 0.0000205612273757937, 0.000020068021550765287, 
     0.000019592351138112088, 0.000019133394612387222, 
     0.00001869037800074796, 0.00001826257161778861, 0.000017849287058978365, 
     0.000017449874429558508, 0.000017063719788057973, 
     0.00001669024278563891, 0.00001632889448431414, 0.000015979155338712787, 
     0.000015640533327531646, 0.000015312562222117676, 
     0.00001499479998079947, 0.000014686827258637418, 0.00001438824602320723, 
     0.000014098678267881496, 0.000013817764814839126};
 
  TVIL_REAL FbarxxxyCLxLy2table[] = 
     {0., -0.1111111111111111, -0.024691358024691357, 
     -0.013717421124828532, -0.008382868465172992, -0.0055547088011651344, 
     -0.003912005283747396, -0.002887746084074557, -0.0022122939398798807, 
     -0.0017461131230981435, -0.0014120147487719588, -0.0011649110787041684, 
     -0.000977227939538, -0.0008314210350706451, -0.0007159355188121333, 
     -0.0006229270738918497, -0.0005469262479320089, -0.0004840283915372458, 
     -0.0004313870360711389, -0.00038688813697332504, 
     -0.00034893529462440374, -0.00031630489370721235, 
     -0.0002880463683903748, -0.00026341224088902154, 
     -0.00024180820381056558, -0.00022275694726631864, 
     -0.00020587157185360654, -0.00019083579150102454, 
     -0.00017738901481827217, -0.00016531497806241224, 
     -0.0001544329953647995, -0.00014459115953151296, 
     -0.00013566101185317402, -0.00012753332908958811, 
     -0.00012011476782805618, -0.0001133251724574502, 
     -0.00010709540090370562, -0.00010136555736958869, 
     -0.00009608354727997132, -0.00009120388900432747, 
     -0.00008668673150421853, -0.00008249703810889572, 
     -0.00007860390507012622, -0.00007497999004876686, -0.000071601030722702, 
     -0.00006844543763331592, -0.00006549394846872385, 
     -0.00006272933341298381, -0.0000601361431192008, 
     -0.00005770049240266689, -0.00005540987398318077, 
     -0.0000532529975987822, -0.00005121965061668761, 
     -0.00004930057692026882, -0.00004748737138391159, 
     -0.00004577238768436505, -0.00004414865755651509, 
     -0.0000426098198982292, -0.00004115005837482005, 
     -0.00003976404637817238, -0.00003844689836621265, 
     -0.000037194126751241186, -0.00003600160362559261, 
     -0.000034865526714114136, -0.000033782389028286544, 
     -0.00003274895176909673, -0.000031762220087167924, 
     -0.0000308194213609394, -0.000029917985698328147, 
     -0.00002905552840551228, -0.000028229834199255185, 
     -0.000027438842967376834, -0.000026680636906272455, 
     -0.000025953428885361955, -0.000025255551906516106, 
     -0.00002458544954225874, -0.0000239416672502353, 
     -0.000023322844473359846, -0.00002272770744545376, 
     -0.000022155062631280032, -0.000021603790737837035, 
     -0.000021072841240757628, -0.0000205612273757937, 
     -0.000020068021550765287, -0.000019592351138112088, 
     -0.000019133394612387222, -0.00001869037800074796, 
     -0.00001826257161778861, -0.000017849287058978365, 
     -0.000017449874429558508, -0.000017063719788057973, 
     -0.00001669024278563891, -0.00001632889448431414, 
     -0.000015979155338712787, -0.000015640533327531646, 
     -0.000015312562222117676, -0.00001499479998079947, 
     -0.000014686827258637418, -0.00001438824602320723, 
     -0.000014098678267881496, -0.000013817764814839126};
 
  TVIL_REAL FbarxxxyCLy3table[] = 
     {-0.16666666666666666, 0.07407407407407407, 
     0.012345679012345678, 0.0054869684499314125, 0.0030483158055174516, 
     0.0019306000101610528, 0.001330345231173357, 0.0009717813349825182, 
     0.0007407532852502284, 0.0005832680676834312, 0.00047113638558462736, 
     0.00038848210200345375, 0.00032581202783013607, 0.0002771676231483654, 
     0.00023865599759008294, 0.00020764668782503195, 0.00018231049328249437, 
     0.00016134350388661875, 0.000143795966608265, 0.00012896283018556435, 
     0.00011631181332881833, 0.00010543498456596673, 0.00009601546441166771, 
     0.00008780408373698146, 0.00008060273603712225, 0.00007425231635436594, 
     0.00006862385753536793, 0.00006361193060562919, 0.0000591296716503784, 
     0.00005510499270613604, 0.000051477665129480744, 0.00004819705318050413, 
     0.000045220337285803295, 0.00004251110969712839, 
     0.000040038255942939875, 0.00003777505748592499, 0.00003569846696794798, 
     0.00003378851912321589, 0.00003202784909333217, 0.00003040129633477941, 
     0.000028895577168074378, 0.0000274990127029659, 0.000026201301690042352, 
     0.000024993330016255743, 0.000023867010240900718, 0.000022815145877772, 
     0.000021831316156241295, 0.000020909777804327943, 0.0000200453810397336, 
     0.00001923349746755563, 0.00001846995799439359, 0.00001775099919959407, 
     0.000017073216872229204, 0.000016433525640089608, 
     0.000015829123794637197, 0.000015257462561455015, 
     0.00001471621918550503, 0.000014203273299409734, 
     0.000013716686124940016, 0.00001325468212605746, 0.00001281563278873755, 
     0.00001239804225041373, 0.000012000534541864203, 
     0.000011621842238038045, 0.000011260796342762182, 
     0.000010916317256365576, 0.000010587406695722642, 
     0.000010273140453646468, 9.972661899442716e-6, 9.68517613517076e-6, 
     9.409944733085062e-6, 9.146280989125612e-6, 8.893545635424153e-6, 
     8.651142961787318e-6, 8.418517302172035e-6, 8.19514984741958e-6, 
     7.980555750078434e-6, 7.77428149111995e-6, 7.575902481817921e-6, 
     7.385020877093344e-6, 7.201263579279012e-6, 7.0242804135858756e-6, 
     6.853742458597901e-6, 6.689340516921762e-6, 6.53078371270403e-6, 
     6.377798204129074e-6, 6.23012600024932e-6, 6.087523872596203e-6, 
     5.949762352992789e-6, 5.816624809852836e-6, 5.687906596019325e-6, 
     5.563414261879638e-6, 5.442964828104713e-6, 5.326385112904262e-6, 
     5.213511109177215e-6, 5.104187407372558e-6, 4.99826666026649e-6, 
     4.895609086212473e-6, 4.796082007735744e-6, 4.6995594226271655e-6, 
     4.605921604946375e-6};

  TVIL_REAL FbarxxxyDtable[] = 
     {0, 0, -0.801799790264645, 0.1587832808994946, 
     -0.06897497378308062, 0.03893566151703746, -0.02509960988230047, 
     0.017552526521994072, -0.012974162169876576, 0.009984495081256, 
     -0.007923337220919367, 0.006441676861718593, -0.0053406127859088074, 
     0.00449993049732091, -0.003843450592306278, 0.0033209775656387742, 
     -0.0028983358224161635, 0.0025515984973498323, -0.0022636058827264494, 
     0.00202179047656827, -0.0018167764809175078, 0.0016414537118259066, 
     -0.001490350664897491, 0.0013592011270673603, -0.0012446389095071048, 
     0.0011439791557714292, -0.0010550592492491872, 0.000976121448031597, 
     -0.0009057251880287146, 0.0008426807800643742, -0.0007859987358574599, 
     0.000734850648912412, -0.000688538713568094, 0.0006464717685544998, 
     -0.0006081463160649583, 0.0005731313692074589, -0.0005410562699460301, 
     0.0005116008300512707, -0.0004844873021618272, 0.0004594738026895084, 
     -0.00043634889405307206, 0.0004149270984065294, -0.00039504516419669775, 
     0.0003765589445383785, -0.0003593407754328729, 0.0003432772643970982, 
     -0.0003282674176799428, 0.0003142210480814814, -0.0003010574163287329, 
     0.0002887040676540019, -0.00027709583216550734, 0.0002661739631743401, 
     -0.0002558853921381238, 0.00024618208252505977, -0.00023702046786703757, 
     0.00022836096169356245, -0.00022016752902640624, 0.00021240731075248222, 
     -0.00020505029354629938, 0.00019806901913662823, 
     -0.00019143832764718252, 0.00018513513052227277, 
     -0.00017913820920296885, 0.0001734280362695223, -0.00016798661622966068, 
     0.0001627973435245568, -0.00015784487565678748, 0.00015311501962727485, 
     -0.00014859463010913584, 0.00014427151799224316, 
     -0.00014013436810864655, 0.00013617266510041587, -0.0001323766265217688, 
     0.0001287371423797293, -0.00012524572041470363, 0.00012189443650650046, 
     -0.0001186758896643499, 0.00011558316112298764, -0.00011260977712220882, 
     0.00010974967499560696, -0.0001069971722364631, 0.00010434693824576726, 
     -0.00010179396849984157, 0.0000993335609035947, -0.0000969612941205863, 
     0.00009467300769326134, -0.00009246478378630742, 0.0000903329304034228, 
     -0.00008827396594314128, 0.00008628460497298757, 
     -0.00008436174511334547, 0.00008250245493319556, 
     -0.00008070396276947859, 0.00007896364639040509, 
     -0.00007727902343068258, 0.00007564774253347465, 
     -0.00007406757514003437, 0.00007253640787344942, 
     -0.00007105223546786836, 0.00006961315419901091, -0.0000682173557757529};
 
  TVIL_REAL FbarxxxyDLtable[] = 
     {0, 0, -0.7813024128964863, 0.20487858207660653, 
     -0.09491905471773769, 0.0549460364784918, -0.035885453284794776, 
     0.025294799938732206, -0.01879653368685981, 0.014520375491430508, 
     -0.01155586958054352, 0.00941589472611427, -0.007820405424201976, 
     0.006599015521823628, -0.005643186517280916, 0.004881099118304586, 
     -0.004263685185397388, 0.0037564913132355254, -0.0033347472937561335, 
     0.002980273190329625, -0.002679481026194235, 0.0024220495538405215, 
     -0.0022000248466186524, 0.0020071971729848977, -0.0018386612196365235, 
     0.001690500484542741, -0.0015595573195470401, 0.0014432630459357608, 
     -0.0013395108507179567, 0.0012465595774317775, -0.0011629601162960975, 
     0.0010874985231033025, -0.0010191516580971632, 0.0009570522911099699, 
     -0.0009004614324515821, 0.0008487462285300704, -0.0008013621787766234, 
     0.0007578387345500728, -0.0007177675643415403, 0.0006807929356010648, 
     -0.0006466037877993132, 0.0006149271651650569, -0.0005855227489202873, 
     0.0005581782835388367, -0.0005327057337695625, 0.0005089380419580148, 
     -0.00048672638083397356, 0.0004659378170890364, -0.00044645331700880433, 
     0.0004281660380985225, -0.00041097986077063837, 0.0003948081222986206, 
     -0.0003795725218068637, 0.00036520217038872463, -0.00035163276477785877, 
     0.00033880586654056887, -0.0003266682716646715, 0.0003151714578163368, 
     -0.0003042710985178599, 0.00029392663514390233, -0.00028410089900335924, 
     0.000274759776918404, -0.00026587191467152156, 0.0002574084534978796, 
     -0.0002493427954805355, 0.00024165039428118988, -0.00023430856812700374, 
     0.00022729633238879998, -0.00022059424943960106, 0.0002141842937847003, 
     -0.00020804973071341553, 0.00020217500694505865, 
     -0.00019654565193307432, 0.00019114818865643076, 
     -0.00018597005287010593, 0.00018099951991019207, 
     -0.00017622563825650607, 0.00017163816914898364, -0.0001672275316355218, 
     0.00016298475249999726, -0.00015890142058134596, 0.0001549696450490575, 
     -0.00015118201724824797, 0.00014753157576951218, 
     -0.00014401177443577878, 0.00014061645293104882, 
     -0.00013733980982474998, 0.00013417637777096792, -0.0001311210006844374, 
     0.0001281688127152508, -0.00012531521886208148, 0.0001225558770795949, 
     -0.00011988668174986645, 0.00011730374840024836, 
     -0.00011480339956140361, 0.00011238215166931385, 
     -0.00011003670292410251, 0.00010776392202661624, 
     -0.00010556083772098112, 0.00010342462907788846, -0.0001013526164592461};
 
  TVIL_REAL FbarxxxyDL2table[] = 
     {0, 0, -0.25, 0.08333333333333333, -0.041666666666666664, 0.025, 
     -0.016666666666666666, 0.011904761904761904, -0.008928571428571428, 
     0.006944444444444444, -0.005555555555555556, 0.004545454545454545, 
     -0.003787878787878788, 0.003205128205128205, -0.0027472527472527475, 
     0.002380952380952381, -0.0020833333333333333, 0.001838235294117647, 
     -0.0016339869281045752, 0.0014619883040935672, -0.0013157894736842105, 
     0.0011904761904761906, -0.0010822510822510823, 0.0009881422924901185, 
     -0.0009057971014492754, 0.0008333333333333334, -0.0007692307692307692, 
     0.0007122507122507123, -0.0006613756613756613, 0.0006157635467980296, 
     -0.0005747126436781609, 0.0005376344086021505, -0.0005040322580645161, 
     0.0004734848484848485, -0.000445632798573975, 0.0004201680672268908, 
     -0.0003968253968253968, 0.00037537537537537537, -0.00035561877667140827, 
     0.00033738191632928474, -0.0003205128205128205, 0.0003048780487804878, 
     -0.00029036004645760743, 0.0002768549280177187, -0.0002642706131078224, 
     0.0002525252525252525, -0.00024154589371980676, 0.00023126734505087883, 
     -0.00022163120567375886, 0.00021258503401360543, 
     -0.00020408163265306123, 0.000196078431372549, -0.0001885369532428356, 
     0.000181422351233672, -0.00017470300489168413, 0.00016835016835016836, 
     -0.00016233766233766234, 0.00015664160401002505, 
     -0.00015124016938898973, 0.0001461133839859731, -0.00014124293785310735, 
     0.0001366120218579235, -0.00013220518244315177, 0.00012800819252432156, 
     -0.0001240079365079365, 0.0001201923076923077, -0.00011655011655011655, 
     0.00011307100859339665, -0.00010974539069359087, 0.00010656436487638534, 
     -0.00010351966873706004, 0.00010060362173038229, 
     -0.00009780907668231612, 0.00009512937595129375, 
     -0.00009255831173639393, 0.00009009009009009009, 
     -0.00008771929824561403, 0.00008544087491455913, 
     -0.00008325008325008325, 0.00008114248620577734, 
     -0.00007911392405063291, 0.00007716049382716049, 
     -0.00007527853056308341, 0.00007346459006758743, 
     -0.00007171543316121629, 0.00007002801120448179, 
     -0.00006839945280437756, 0.00006682705159048383, 
     -0.00006530825496342738, 0.00006384065372829418, 
     -0.00006242197253433208, 0.00006105006105006105, 
     -0.00005972288580984233, 0.0000584385226741468, -0.00005719514985129261, 
     0.000055991041433370664, -0.00005482456140350877, 
     0.000053694158075601374, -0.000052598358931201344, 
     0.000051535765821480104, -0.000050505050505050505};

  TVIL_REAL FbarxxxyFtable[] = 
     {0, 0, -19.677752302989337, 3.4982775729482087, 
     -1.3053716014924643, 0.6568696660265069, -0.38874085323596963, 
     0.2546501620674605, -0.17879555259687646, 0.13201011229855597, 
     -0.1012470612478178, 0.07999806802474509, -0.06473607125906755, 
     0.053420926599169305, -0.044808756649790595, 0.03810749010458591, 
     -0.032794020274531197, 0.02851197642318151, -0.025011994040234953, 
     0.022115471722395807, -0.01969184557682396, 0.01764392358111497, 
     -0.015898177523846025, 0.014398169470291784, -0.013100009425973261, 
     0.011969158621782723, -0.010978142198886792, 0.010104887711867183, 
     -0.009331501465984996, 0.008643355835337636, -0.008028400550548473, 
     0.007476637369105552, -0.006979715351474496, 0.006530616149960787, 
     -0.006123407168084816, 0.0057530463854314675, -0.005415226864369148, 
     0.005106251990265245, -0.004822934702135048, 0.004562515588792376, 
     -0.004322595923881916, 0.004101082608343533, -0.0038961426630896735, 
     0.003706165426457368, -0.0035297310023335885, 0.0033655838061849444, 
     -0.0032126102897910972, 0.003069820107667183, -0.002936330131121117, 
     0.0028113508287143964, -0.0026941746214194716, 0.0025841658921745654, 
     -0.002480752386778105, 0.002383417789169037, -0.0022916952914428922, 
     0.002205162009268572, -0.002123434118110317, 0.002046162605930116, 
     -0.0019730295547195904, 0.0019037448769766154, -0.001838043444648429, 
     0.0017756825575470003, -0.0017164397061542414, 0.0016601105903561568, 
     -0.0016065073612038718, 0.001555457057480187, -0.0015068002128030456, 
     0.0014603896123446146, -0.0014160891810870186, 0.0013737729879556182, 
     -0.0013333243522361349, 0.0012946350404491622, -0.0012576045433713024, 
     0.001222139424195164, -0.0011881527299430993, 0.0011555634592189362, 
     -0.001124296080220754, 0.001094280093665065, -0.0010654496359046586, 
     0.0010377431180724327, -0.0010111028975632937, 0.00098547497858538, 
     -0.0009608087388787964, 0.000937056680021785, -0.0009141741990268552, 
     0.0008921193791780308, -0.0008708527982794726, 0.0008503373526791161, 
     -0.0008305380956019088, 0.000811422088478566, -0.0007929582640899392, 
     0.0007751173004662172, -0.0007578715045860945, 0.0007411947050153416, 
     -0.0007250621527082753, 0.0007094504292706706, -0.0006943373620497274, 
     0.000679701945476728, -0.0006655242681418024, 0.0006517854451284607, 
     -0.0006384675551788839};
 
  TVIL_REAL FbarxxxyFLtable[] = 
     {0, 0, -12.116809853163677, 2.998521076813561, 
     -1.2948474505000782, 0.7089658276743891, -0.44346553266614674, 
     0.3021164634004369, -0.21841622998657892, 0.16495525674530268, 
     -0.12881763269930235, 0.10329030296991674, -0.0846119835867833, 
     0.07054604614262329, -0.05969659870939627, 0.051156814609993356, 
     -0.04431732827355292, 0.03875665741430713, -0.034175898874627554, 
     0.0303584033824148, -0.027144093042645694, 0.02441265413590499, 
     -0.02207227019499237, 0.020051905136724446, -0.018295914980713028, 
     0.01676021942547149, -0.015409538402799289, 0.01421536842203279, 
     -0.013154480991543715, 0.012207794848551305, -0.011359519425821024, 
     0.010596497564561205, -0.009907696267002114, 0.009283808612083793, 
     -0.00871693997001116, 0.008200358734224719, -0.007728296857975672, 
     0.007295789149361627, -0.00689854295815722, 0.006532831864561983, 
     -0.006195408451479164, 0.005883432346578089, -0.005594410556272978, 
     0.005326147751047762, -0.005076704650929951, 0.0048443630382558715, 
     -0.004627596219255662, 0.004425043986455006, -0.004235491315374435, 
     0.004057850172714184, -0.0038911439276119193, 0.003734493949091964, 
     -0.0035871080464154495, 0.003448270468482683, -0.003317333226666583, 
     0.0031937085447522827, -0.0030768622718084396, 0.002966308120223614, 
     -0.0028616026129142736, 0.0027623406417284745, -0.0026681515540312737, 
     0.002578695696924667, -0.0024936613589764244, 0.0024127620580715165, 
     -0.0023357341313507687, 0.0022623345894026686, -0.0021923392021205423, 
     0.0021255407880878784, -0.002061747683140142, 0.0020007823669796307, 
     -0.001942480229479706, 0.0018866884606797885, -0.0018332650505039705, 
     0.0017820778859850897, -0.0017330039352851383, 0.0016859285091077147, 
     -0.0016407445912288295, 0.001597352230853979, -0.0015556579903633504, 
     0.0015155744427512953, -0.001477019713716143, 0.001439917063924973, 
     -0.0014041945074762126, 0.0013697844630203122, -0.0013366234343833454, 
     0.0013046517178771208, -0.0012738131337782027, 0.0012440547797222526, 
     -0.0012153268039937065, 0.0011875821968978283, -0.0011607765985858828, 
     0.001134868121867448, -0.0011098171886891712, 0.001085586379088742, 
     -0.0010621402915483868, 0.0010394454137753867, -0.001017470003029462, 
     0.000996183975199541, -0.000975558801906597, 0.0009555674149757929, 
     -0.0009361841176810147};
 
  TVIL_REAL FbarxxxyFL2table[] = 
     {0, 0, -2.25, 0.75, -0.375, 0.225, -0.15, 0.10714285714285714, 
     -0.08035714285714286, 0.0625, -0.05, 0.04090909090909091, 
     -0.03409090909090909, 0.028846153846153848, -0.024725274725274724, 
     0.02142857142857143, -0.01875, 0.016544117647058824, 
     -0.014705882352941176, 0.013157894736842105, -0.011842105263157895, 
     0.010714285714285714, -0.00974025974025974, 0.008893280632411068, 
     -0.008152173913043478, 0.0075, -0.006923076923076923, 
     0.00641025641025641, -0.005952380952380952, 0.005541871921182266, 
     -0.005172413793103448, 0.004838709677419355, -0.0045362903225806455, 
     0.004261363636363636, -0.004010695187165776, 0.003781512605042017, 
     -0.0035714285714285713, 0.0033783783783783786, -0.003200568990042674, 
     0.003036437246963563, -0.0028846153846153848, 0.00274390243902439, 
     -0.002613240418118467, 0.0024916943521594683, -0.0023784355179704017, 
     0.0022727272727272726, -0.002173913043478261, 0.0020814061054579094, 
     -0.0019946808510638296, 0.001913265306122449, -0.001836734693877551, 
     0.0017647058823529412, -0.0016968325791855204, 0.001632801161103048, 
     -0.0015723270440251573, 0.0015151515151515152, -0.001461038961038961, 
     0.0014097744360902255, -0.0013611615245009074, 0.001315020455873758, 
     -0.001271186440677966, 0.0012295081967213116, -0.001189846641988366, 
     0.001152073732718894, -0.0011160714285714285, 0.0010817307692307693, 
     -0.001048951048951049, 0.0010176390773405698, -0.000987708516242318, 
     0.0009590792838874681, -0.0009316770186335404, 0.0009054325955734407, 
     -0.0008802816901408451, 0.0008561643835616438, -0.0008330248056275454, 
     0.0008108108108108108, -0.0007894736842105263, 0.0007689678742310321, 
     -0.0007492507492507493, 0.0007302823758519961, -0.0007120253164556962, 
     0.0006944444444444445, -0.0006775067750677507, 0.0006611813106082868, 
     -0.0006454388984509467, 0.0006302521008403362, -0.0006155950752393981, 
     0.0006014434643143544, -0.0005877742946708464, 0.0005745658835546476, 
     -0.0005617977528089888, 0.0005494505494505495, -0.000537505972288581, 
     0.0005259467040673212, -0.0005147563486616335, 0.000503919372900336, 
     -0.000493421052631579, 0.0004832474226804124, -0.00047338523038081213, 
     0.00046382189239332097, -0.00045454545454545455};

  if (SAME2(0,x)) return TVIL_FBAR000x(y,qq);
  if (SAME2(0,y)) return TVIL_FBARx0xx(x,qq);
  if (SAME2(x,y)) return TVIL_FBARxxxx(x,qq);

  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;
  lnyox = lnbary - lnbarx;

  if (y < 0.5 * x) {

    result = TVIL_FBARx0xx(x,qq);

    result += y * (4.376196417777218 + 4.1719536193447295*lnbarx + 
      1.5*lnbarx2 + 0.3333333333333333*lnbarx2*lnbarx 
      - 0.6719536193447294*lnbary - lnbarx * lnbary - 0.5*lnbarx2*lnbary);

    rn = r = y/x;

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (FbarxxxyAtable[n] + 
        FbarxxxyALxtable[n] * lnbarx + 
        FbarxxxyALytable[n] * lnbary +
        FbarxxxyALxLytable[n] * lnbarx * lnyox); 
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_FBARxxxx(x,qq);

    result += (y - x) * (2.4714661073723865 + 1.6719536193447295*lnbarx 
      - 0.16666666666666666*lnbarx3);
 
    rn = r = y/x - 1.L; 

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (
        FbarxxxyDtable[n] + 
        FbarxxxyDLtable[n] * lnbarx + 
        FbarxxxyDL2table[n] * lnbarx2);
    }
  }
  else if (y < 5.54 * x) {
    result = 9.031469645943357*x - 0.5866657498231629*y + 
      3.340354888959125*x*lnbarx - 0.8862943611198906*y*lnbarx + 
      3.5*x*lnbarx2 - 0.6931471805599453*y*lnbarx2 - 
      0.3333333333333333*x*lnbarx3 - 0.16666666666666666*y*lnbarx3;

    rn = r = 0.25L * y/x - 1.L; 

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (
        FbarxxxyBtable[n] + 
        FbarxxxyBLtable[n] * lnbarx + 
        FbarxxxyBL2table[n] * lnbarx2);
    }
  }
  else if (y < 14.56 * x) {
    result = 27.67396374925295*x - 3.5346082608073264*y + 
      15.653546116298507*x*lnbarx - 2.8555374689948736*y*lnbarx + 
      6.*x*lnbarx2 - 1.0986122886681098*y*lnbarx2 - 
      0.3333333333333333*x*lnbarx3 - 0.16666666666666666*y*lnbarx3;

    rn = r = y/(9.L*x) - 1.L; 

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (
        FbarxxxyFtable[n] + 
        FbarxxxyFLtable[n] * lnbarx + 
        FbarxxxyFL2table[n] * lnbarx2);
    }
  }
  else {
    result = 0;
    r = 9.L * x/y;
    rn = 1;

    for (n=0; n < 100; n++) {
      result += y * rn * (
        FbarxxxyCtable[n] + 
        FbarxxxyCLxtable[n] * lnbarx + 
        FbarxxxyCLytable[n] * lnbary +
        FbarxxxyCLx2table[n] * lnbarx2 +
        FbarxxxyCLy2table[n] * lnbary2 +
        FbarxxxyCLxLytable[n] * lnbarx * lnbary +
        FbarxxxyCLx3table[n] * lnbarx3 +
        FbarxxxyCLx2Lytable[n] * lnbarx2 * lnbary +
        FbarxxxyCLxLy2table[n] * lnbarx * lnbary2 +
        FbarxxxyCLy3table[n] * lnbary3); 
        rn *= r;
    }
  }

  return result;
};


/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARyxxx (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3, lnyox;
  TVIL_COMPLEX result;
  int n;

  TVIL_REAL FbaryxxxAtable[] = 
     {0, 0, 0.17222859867270013, 0.004745427490783339, 
     0.00022933844026137043, 0.000014077785634852715, 9.871510335793436e-7, 
     7.533810462473739e-8, 6.096538527183674e-9, 5.149622196501907e-10, 
     4.494505524743857e-11, 4.0252110434893335e-12, 
     3.6808236218483084e-13, 3.42423543442629e-14, 3.2317657797242872e-15, 
     3.087722663603471e-16, 2.9813845353865366e-17, 2.905242687316168e-18, 
     2.853935262052585e-19, 2.823577824207859e-20, 2.811330170260295e-21, 
     2.815108646125656e-22, 2.8333907719305445e-23, 
     2.8650799890215462e-24, 2.9094105106206265e-25, 
     2.9658795130219145e-26, 3.034198346313872e-27, 3.114257214345785e-28, 
     3.2060993988944535e-29, 3.309900751246559e-30, 
     3.4259367065625406e-31, 3.554385929627906e-32, 3.693563424785885e-33, 
     3.8233411031131445e-34, 3.748856396607379e-35, 1.624450507523899e-36, 
     -2.000891999272669e-36, -2.264990460334946e-36, 
     -2.185983411490859e-36, -2.0790750178451266e-36, 
     -1.9765354585796277e-36, -1.8810524076297617e-36, 
     -1.7922881481315687e-36, -1.7096579057447204e-36, 
     -1.6326125439544083e-36, -1.560660221514205e-36, 
     -1.493361774007865e-36, -1.4303243402240499e-36, 
     -1.371195652036369e-36, -1.3156591061403952e-36, 
     -1.263429517504406e-36, -1.2142494509609585e-36, 
     -1.1678860429285459e-36, -1.1241282398507447e-36, 
     -1.0827843920623248e-36, -1.043680151747616e-36, 
     -1.006656631849167e-36, -9.715687895502309e-37, 
     -9.38284003561507e-37, -9.066808191054037e-37, -8.76647838381836e-37, 
     -8.480827375565379e-37, -8.208913940478272e-37, 
     -7.94987110191256e-37, -7.702899213073508e-37, -7.46725977845837e-37, 
     -7.242269926796905e-37, -7.0272974581455155e-37, 
     -6.821756397969144e-37, -6.625102999756892e-37, 
     -6.436832145191467e-37, -6.256474097319776e-37, 
     -6.08359156771128e-37, -5.9177770633752506e-37, 
     -5.758650483349407e-37, -5.605856938464386e-37, 
     -5.459064770910286e-37, -5.317963752949874e-37, 
     -5.1822634464946325e-37, -5.0516917073326675e-37, 
     -4.925993319612486e-37, -4.804928747778614e-37, 
     -4.688272994553811e-37, -4.575814554793568e-37, 
     -4.467354456123794e-37, -4.3627053782305495e-37, 
     -4.261690843517886e-37, -4.164144472600004e-37, 
     -4.069909298759301e-37, -3.97883713609272e-37, 
     -3.890787996594369e-37, -3.805629551890355e-37, 
     -3.7232366357591292e-37, -3.643490783943323e-37, 
     -3.566279808092191e-37, -3.4914974009720554e-37, 
     -3.419042770349426e-37, -3.348820299191338e-37, 
     -3.2807392300429146e-37, -3.214713371635967e-37, 
     -3.1506608259569146e-37};

  TVIL_REAL FbaryxxxALtable[] = 
     {0, 0, 0.045121417923393456, 
     0.0015354450029896843, 0.00008142006338933084, 
     5.269743850279907e-6, 3.824323282792993e-7, 2.989845584482098e-8, 
     2.4629930548236923e-9, 2.1092118545963946e-10, 1.861063810159963e-11, 
     1.6815772826352487e-12, 1.549042565734854e-13, 1.45000347965097e-14, 
     1.375749891945689e-15, 1.3204421930187134e-16, 1.2800522654346045e-17, 
     1.2517375904569192e-18, 1.2334567490160675e-19, 1.2237252559547091e-20, 
     1.2214560155990638e-21, 1.2258524671214377e-22, 1.2363354834925453e-23, 
     1.2524924515292822e-24, 1.2740412693214615e-25, 1.3008045919029474e-26, 
     1.3326912592129564e-27, 1.3696828543979925e-28, 1.4118239956603158e-29, 
     1.4592153965184697e-30, 1.5120090189499286e-31, 1.5704048415068227e-32, 
     1.634648901534868e-33, 1.7050323671406362e-34, 1.781891463574256e-35, 
     1.8656081288248707e-36, 1.956611310227181e-37, 2.0553788416644154e-38, 
     2.162439862222385e-39, 2.2783777537819213e-40, 2.403833588362513e-41, 
     2.5395100870001232e-42, 2.6861761012475975e-43, 2.844671636532025e-44, 
     3.0159134439366424e-45, 3.2009012134590363e-46, 3.4007244045273583e-47, 
     3.6165697186885554e-48, 3.8497288669363406e-49, 4.101602842907896e-50, 
     4.3736657831411233e-51, 4.667032796316769e-52, 4.978208610739813e-53, 
     5.258047787300661e-54, 5.016177001466834e-55, -4.935508392539835e-57, 
     -5.707949283276066e-56, -6.069779963493856e-56, -5.921983041397543e-56, 
     -5.728974328456888e-56, -5.539900393392101e-56, -5.359460178148932e-56, 
     -5.187632447008495e-56, -5.023930893448405e-56, -4.867856794955577e-56, 
     -4.718944169416183e-56, -4.57676155194365e-56, -4.440909431219647e-56, 
     -4.3110175007885085e-56, -4.186742139456969e-56, -4.067764137081972e-56, 
     -3.9537866428087152e-56, -3.8445333116658805e-56, -3.739746627947556e-56, 
     -3.639186386374505e-56, -3.542628314291606e-56, -3.449862820130451e-56, 
     -3.3606938550838946e-56, -3.27493787643809e-56, -3.1924229023174366e-56, 
     -3.112987648744893e-56, -3.0364807409261313e-56, -2.96275999154996e-56, 
     -2.8916917396753717e-56, -2.8231502444613224e-56, -2.757017128600776e-56, 
     -2.6931808668559115e-56, -2.6315363155654643e-56, -2.571984279415623e-56, 
     -2.5144311121393315e-56, -2.4587883481409137e-56, -2.404972362338729e-56, 
     -2.3529040557822847e-56, -2.302508564835745e-56, -2.253714991930327e-56, 
     -2.206456156076545e-56, -2.16066836149619e-56, -2.116291182885507e-56, 
     -2.0732672659572028e-56, -2.03154214203138e-56, 
     -1.9910638250759756e-56};

  TVIL_REAL FbaryxxxBtable[] = 
     {0, 0, 2.7394630052989544, -0.6979321253382145, 
     0.3190711058270777, -0.1833072830356581, 0.1191401434710989, 
     -0.0836984782639941, 0.062044419158448286, -0.04784041523682381, 
     0.03801761001223754, -0.03094082836781535, 0.025673104295895144, 
     -0.021645899555931398, 0.01849785721544242, -0.01599032120305282, 
     0.013960501120531713, -0.012294252658608064, 0.010909612070560617, 
     -0.009746487179829724, 0.00876000690905998, -0.007916116772897372, 
     0.007188593207671238, -0.0065569772750104114, 0.006005117772364449, 
     -0.005520126615749577, 0.005091618323853963, -0.004711148589584577, 
     0.004371794516194409, -0.004067837081757951, 0.0037945183322732104, 
     -0.003547853856010498, 0.003324486606529933, -0.003121571971881393, 
     0.002936686682275616, -0.002767756067530813, 0.0026129955576550076, 
     -0.0024708633258054996, 0.00234002171222503, -0.0022193056162705667, 
     0.0021076964541509795, -0.002004300589738877, 0.001908331381370251, 
     -0.001819094167989339, 0.0017359736571922893, -0.0016584232858121485, 
     0.0015859562081496376, -0.0015181376333488626, 0.0014545782859069808, 
     -0.0013949288050295477, 0.0013388749318796246, -0.0012861333605364744, 
     0.0012364481500751123, -0.00118958761267965, 0.0011453416069491075, 
     -0.0011035191771982906, 0.0010639464891118013, -0.0010264650199810707, 
     0.0009909299682631365, -0.0009572088526009426, 0.0009251802749421268, 
     -0.000894732826150254, 0.0008657641156510738, -0.0008381799093032991, 
     0.000811893361915149, -0.0007868243327150237, 0.0007628987736848198, 
     -0.0007400481820248367, 0.0007182091091788995, -0.0006973227198393289, 
     0.0006773343952003393, -0.0006581933754574177, 0.0006398524371776206, 
     -0.0006222676017068858, 0.0006053978712482484, -0.0005892049896500673, 
     0.0005736532252951026, -0.0005587091737871958, 0.0005443415783988713, 
     -0.0005305211664759087, 0.0005172205001984781, -0.0005044138402767778, 
     0.0004920770213156435, -0.00048018733772021776, 0.0004687234391359555, 
     -0.0004576652345231337, 0.00044699380406045946, -0.0004366913181559163, 
     0.0004267409629170125, -0.00041712687149828004, 0.0004078340608022417, 
     -0.00039884837306199925, 0.00039015642187987414, -0.000381745542337819, 
     0.0003736037448322049, -0.0003657196723185798, 0.0003580825606815437, 
     -0.00035068220197137685, 0.0003435089102728446, -0.00033655348999297546, 
     0.0003298072063738436};
 
  TVIL_REAL FbaryxxxBLtable[] = 
     {0, 0, 2., -0.6666666666666666, 0.3333333333333333, -0.2, 
     0.13333333333333333, -0.09523809523809523, 0.07142857142857142, 
     -0.05555555555555555, 0.044444444444444446, -0.03636363636363636, 
     0.030303030303030304, -0.02564102564102564, 0.02197802197802198, 
     -0.01904761904761905, 0.016666666666666666, -0.014705882352941176, 
     0.013071895424836602, -0.011695906432748537, 0.010526315789473684, 
     -0.009523809523809525, 0.008658008658008658, -0.007905138339920948, 
     0.007246376811594203, -0.006666666666666667, 0.006153846153846154, 
     -0.005698005698005698, 0.005291005291005291, -0.0049261083743842365, 
     0.004597701149425287, -0.004301075268817204, 0.004032258064516129, 
     -0.003787878787878788, 0.0035650623885918, -0.0033613445378151263, 
     0.0031746031746031746, -0.003003003003003003, 0.002844950213371266, 
     -0.002699055330634278, 0.002564102564102564, -0.0024390243902439024, 
     0.0023228803716608595, -0.0022148394241417496, 0.0021141649048625794, 
     -0.00202020202020202, 0.001932367149758454, -0.0018501387604070306, 
     0.0017730496453900709, -0.0017006802721088435, 0.0016326530612244899, 
     -0.001568627450980392, 0.0015082956259426848, -0.001451378809869376, 
     0.001397624039133473, -0.0013468013468013469, 0.0012987012987012987, 
     -0.0012531328320802004, 0.0012099213551119178, -0.0011689070718877848, 
     0.0011299435028248588, -0.001092896174863388, 0.0010576414595452142, 
     -0.0010240655401945725, 0.000992063492063492, -0.0009615384615384616, 
     0.0009324009324009324, -0.0009045680687471732, 0.000877963125548727, 
     -0.0008525149190110827, 0.0008281573498964803, -0.0008048289738430583, 
     0.000782472613458529, -0.00076103500761035, 0.0007404664938911515, 
     -0.0007207207207207207, 0.0007017543859649122, -0.000683526999316473, 
     0.000666000666000666, -0.0006491398896462187, 0.0006329113924050633, 
     -0.0006172839506172839, 0.0006022282445046673, -0.0005877167205406994, 
     0.0005737234652897303, -0.0005602240896358543, 0.0005471956224350205, 
     -0.0005346164127238706, 0.0005224660397074191, -0.0005107252298263534, 
     0.0004993757802746567, -0.0004884004884004884, 0.00047778308647873863, 
     -0.0004675081813931744, 0.0004575611988103409, -0.0004479283314669653, 
     0.0004385964912280702, -0.000429553264604811, 0.00042078687144961075, 
     -0.00041228612657184083, 0.00040404040404040404};

  TVIL_REAL FbaryxxxCtable[] = 
     {5.561600733514893, -1.093212889651541, 0.11258770865542418, 
     0.008364400351449941, 0.005298992894411524, 0.003854199803830233, 
     0.002923634378916075, 0.002288487470692671, 0.0018373232764156875, 
     0.0015061788305463432, 0.001256367919319999, 0.001063488030363371, 
     0.0009115803172906872, 0.0007898756041911571, 0.0006909052288910359, 
     0.0006093636656496872, 0.0005414013010048208, 0.000484171857779676, 
     0.00043553524129926786, 0.00039385788441840034, 0.0003578757866774365, 
     0.00032659877950737005, 0.00029924245693469957, 0.00027517901850821527, 
     0.00025390126126448683, 0.000234995856746745, 0.0002181232788429439, 
     0.00020300255873919603, 0.00018939958633548866, 0.00017711804687825045, 
     0.00016599233642045026, 0.00015588197786923943, 0.00014666718544509153, 
     0.00013824531561015889, 0.0001305280078072482, 0.00012343886606108563, 
     0.00011691156769250769, 0.00011088831159737368, 0.0001053185382102121, 
     0.00010015786815466031, 0.00009536721792838874, 0.00009091205968169004, 
     0.00008676179888327452, 0.00008288924890636631, 0.0000792701856697724, 
     0.0000758829686981322, 0.00007270821752263881, 0.00006972853437894888, 
     0.00006692826578743248, 0.00006429329691007514, 0.0000618108736357339, 
     0.00005946944820330023, 0.00005725854487127129, 0.000055168642714051594, 
     0.00005319107309497168, 0.000051317929753233486, 
     0.000049541989762412185, 0.00004785664388421878, 0.00004625583506292395, 
     0.000044734003991166896, 0.000043286040833279736, 
     0.000041907242322974875, 0.00004059327356251553, 0.00003934013394378063, 
     0.00003814412669077636, 0.000037001831590463584, 
     0.000035910080536176096, 0.00003486593555698179, 0.00003386666904839683, 
     0.000032909745955989686, 0.000031992807694515736, 
     0.00003111365761206012, 0.000030270247831873174, 0.00002946066732469045, 
     0.00002868313108178852, 0.000027935970274216166, 
     0.000027217623296879235, 0.00002652662760771834, 
     0.000025861612282332008, 0.00002522129121326148, 
     0.000024604456890934263, 0.000024009974710105824, 
     0.000023436777751665358, 0.00002288386199498825, 0.00002235028192071523, 
     0.00002183514646799511, 0.00002133761531391186, 0.000020856895446085897, 
     0.000020392238002345148, 0.000019942935353947185, 
     0.00001950831841113807, 0.000019087754131889716, 0.00001868064321649478, 
     0.000018286417972341512, 0.000017904540334663128, 
     0.000017534500030376254, 0.00001717581287330825, 
     0.000016828019180178447, 0.000016490682297657043, 
     0.00001616338723168884, 0.000015845739371047953};
 
  TVIL_REAL FbaryxxxCLxtable[] = 
     {0., 0.7149780222827421, -0.05555555555555555, 
     0.011823874349916816, 0.008631960535467584, 0.006151133100293264, 
     0.0045699957978057905, 0.003518634744600188, 0.0027880999551119583, 
     0.0022614318030415, 0.0018699256848617282, 0.0015713207855484986, 
     0.0013385598112549831, 0.0011537099299093185, 0.0010045241830722736, 
     0.0008824173083495997, 0.0007812313875088221, 0.0006964592396087731, 
     0.0006247420463634575, 0.0005635362142585678, 0.0005108874944340654, 
     0.00046527472862451126, 0.0004254997827237962, 0.0003906087282414194, 
     0.0003598345464804633, 0.00033255490185267646, 0.00030826062562826944, 
     0.00028653191820537883, 0.0002670201852651199, 0.0002494340351219849, 
     0.0002335283834696736, 0.00021909590242642484, 0.00020596025512346628, 
     0.0001939707024364934, 0.000182997773018682, 0.0001729297637958539, 
     0.00016366989387420214, 0.00015513397614371762, 0.0001472485017501031, 
     0.0001399490558834672, 0.00013317900100703802, 0.0001268883771701942, 
     0.00012103297946587707, 0.0001155735807693861, 0.00011047527419839195, 
     0.00010570691468196276, 0.00010124064293297503, 0.00009705147821949371, 
     0.00009311696880542704, 0.00008941689091539555, 0.00008593298867795028, 
     0.00008264874879577728, 0.00007954920474397551, 0.00007662076615675025, 
     0.000073851069767219, 0.00007122884884464508, 0.00006874381855216498, 
     0.0000663865750449323, 0.00006414850645870953, 0.00006202171421444158, 
     0.000059998943295012384, 0.00005807352034411595, 0.00005623929860036566, 
     0.00005449060881763417, 0.0000528222154394156, 0.000051229277394219675, 
     0.000049707312963512036, 0.00004825216824586941, 0.00004685998880278085, 
     0.000045527194124517953, 0.000044250454600069257, 
     0.00004302667071441392, 0.00004185295423033869, 0.000040726611141372476, 
     0.000039645126207887895, 0.000038606148910560765, 
     0.00003760748067465943, 0.0000366470632354579, 0.00003572296802977019, 
     0.00003483338651147815, 0.00003397662130021815, 0.00003315107808231466, 
     0.000032355258191781585, 0.00003158775180691048, 
     0.000030847231704761204, 0.000030132447521880765, 
     0.000029442220474898253, 0.000028775438499363906, 
     0.000028131051769392472, 0.000027508068564399396, 
     0.00002690555145253861, 0.000026322613763411757, 0.0000257584163252625, 
     0.000025212164444233355, 0.000024683105105378415, 
     0.000024170524377021735, 0.000023673745001752863, 
     0.000023192124158879586, 0.00002272505138453294, 
     0.000022271946636857373, 0.000021832258494834726};
 
  TVIL_REAL FbaryxxxCLytable[] = 
     {-2.75, -0.49099348250116565, 0.05555555555555555, 
     -0.011823874349916816, -0.008631960535467584, -0.006151133100293264, 
     -0.0045699957978057905, -0.003518634744600188, -0.0027880999551119583, 
     -0.0022614318030415, -0.0018699256848617282, -0.0015713207855484986, 
     -0.0013385598112549831, -0.0011537099299093185, -0.0010045241830722736, 
     -0.0008824173083495997, -0.0007812313875088221, -0.0006964592396087731, 
     -0.0006247420463634575, -0.0005635362142585678, -0.0005108874944340654, 
     -0.00046527472862451126, -0.0004254997827237962, -0.0003906087282414194, 
     -0.0003598345464804633, -0.00033255490185267646, 
     -0.00030826062562826944, -0.00028653191820537883, 
     -0.0002670201852651199, -0.0002494340351219849, -0.0002335283834696736, 
     -0.00021909590242642484, -0.00020596025512346628, 
     -0.0001939707024364934, -0.000182997773018682, -0.0001729297637958539, 
     -0.00016366989387420214, -0.00015513397614371762, 
     -0.0001472485017501031, -0.0001399490558834672, -0.00013317900100703802, 
     -0.0001268883771701942, -0.00012103297946587707, -0.0001155735807693861, 
     -0.00011047527419839195, -0.00010570691468196276, 
     -0.00010124064293297503, -0.00009705147821949371, 
     -0.00009311696880542704, -0.00008941689091539555, 
     -0.00008593298867795028, -0.00008264874879577728, 
     -0.00007954920474397551, -0.00007662076615675025, -0.000073851069767219, 
     -0.00007122884884464508, -0.00006874381855216498, 
     -0.0000663865750449323, -0.00006414850645870953, 
     -0.00006202171421444158, -0.000059998943295012384, 
     -0.00005807352034411595, -0.00005623929860036566, 
     -0.00005449060881763417, -0.0000528222154394156, 
     -0.000051229277394219675, -0.000049707312963512036, 
     -0.00004825216824586941, -0.00004685998880278085, 
     -0.000045527194124517953, -0.000044250454600069257, 
     -0.00004302667071441392, -0.00004185295423033869, 
     -0.000040726611141372476, -0.000039645126207887895, 
     -0.000038606148910560765, -0.00003760748067465943, 
     -0.0000366470632354579, -0.00003572296802977019, 
     -0.00003483338651147815, -0.00003397662130021815, 
     -0.00003315107808231466, -0.000032355258191781585, 
     -0.00003158775180691048, -0.000030847231704761204, 
     -0.000030132447521880765, -0.000029442220474898253, 
     -0.000028775438499363906, -0.000028131051769392472, 
     -0.000027508068564399396, -0.00002690555145253861, 
     -0.000026322613763411757, -0.0000257584163252625, 
     -0.000025212164444233355, -0.000024683105105378415, 
     -0.000024170524377021735, -0.000023673745001752863, 
     -0.000023192124158879586, -0.00002272505138453294, 
     -0.000022271946636857373, -0.000021832258494834726};
 
  TVIL_REAL FbaryxxxCLx2table[] = 
     {0., 0., 0.037037037037037035, 0.00823045267489712, 
     0.004877305288827923, 0.0033277447543565513, 0.0024089221569280504, 
     0.0018191629508784188, 0.001419905064147793, 0.001137935815263503, 
     0.0009317925650982574, 0.0007767023322158301, 0.0006571815289069812, 
     0.0005631729542932661, 0.0004879244268736945, 0.00042677112638951344, 
     0.0003764089738587107, 0.00033444594798835513, 0.00029911652785053925, 
     0.0002690950156717281, 0.00024337054654151888, 0.00022116158711992873, 
     0.00020185630672671682, 0.00018497025870056085, 0.00017011586594751135, 
     0.0001569800967751773, 0.00014530791436178457, 0.00013488985594929486, 
     0.00012555260577635507, 0.00011715176528640994, 0.00010956625464602172, 
     0.00010269393836170508, 0.00009644817859340573, 0.00009075509807661399, 
     0.00008555139055949603, 0.00008078255713493518, 0.0000764014764018188, 
     0.0000723672381786378, 0.00006864418670136757, 0.00006520113139844416, 
     0.00006201069253288217, 0.00005904875601040266, 0.00005629401703208235, 
     0.00005372759642743915, 0.000051332716737587835, 0.00004909442764889318, 
     0.000046999372369859186, 0.000045035588121187335, 
     0.00004319233516418595, 0.00004145994979683807, 0.00003982971755400115, 
     0.00003829376350008635, 0.000036844957031383885, 0.0000354768290360364, 
     0.00003418349961211768, 0.00003295961483375018, 0.00003180029129385095, 
     0.00003070106734957495, 0.000029657860160506702, 0.00002866692774628267, 
     0.000027724835404540203, 0.000026828425925866098, 
     0.000025974793122978753, 0.00002516125825934021, 
     0.000024385349019891436, 0.00002364478071538156, 0.00002293743945325209, 
     0.00002226136704342014, 0.000021614747437554784, 
     0.000020995894526365007, 0.00002040324114168723, 
     0.000019835329129333863, 0.00001929080037520842, 
     0.000018768388681499282, 0.000018266912402160756, 
     0.00001778526775765435, 0.00001732242275828761, 0.0000168774116736508, 
     0.000016449329992780085, 0.000016037329825912437, 
     0.000015640615704163126, 0.000015258440738255232, 
     0.000014890103101650272, 0.000014534942807146, 0.000014192338749286484, 
     0.000013861705987827047, 0.0000135424932500607, 0.000013234180632085059, 
     0.00001293627748110551, 0.000012648320442662868, 0.00001236987165826902, 
     0.000012100517100355793, 0.000011839865032710889, 
     0.000011587544585708322, 0.000011343204436654945, 
     0.000011106511586482914, 0.000010877150224832702, 
     0.000010654820676302555, 0.000010439238421297837, 
     0.000010230133185505292, 0.000010027248092550292};
 
  TVIL_REAL FbaryxxxCLxLytable[] = 
     {0., 0.3333333333333333, -0.07407407407407407, 
     -0.01646090534979424, -0.009754610577655845, -0.006655489508713103, 
     -0.004817844313856101, -0.0036383259017568376, -0.002839810128295586, 
     -0.002275871630527006, -0.0018635851301965149, -0.0015534046644316603, 
     -0.0013143630578139624, -0.0011263459085865321, -0.000975848853747389, 
     -0.0008535422527790269, -0.0007528179477174214, -0.0006688918959767103, 
     -0.0005982330557010785, -0.0005381900313434562, -0.00048674109308303776, 
     -0.00044232317423985746, -0.00040371261345343364, 
     -0.0003699405174011217, -0.0003402317318950227, -0.0003139601935503546, 
     -0.00029061582872356913, -0.0002697797118985897, 
     -0.00025110521155271014, -0.0002343035305728199, 
     -0.00021913250929204344, -0.00020538787672341017, 
     -0.00019289635718681145, -0.00018151019615322798, 
     -0.00017110278111899207, -0.00016156511426987036, 
     -0.0001528029528036376, -0.0001447344763572756, -0.00013728837340273514, 
     -0.0001304022627968883, -0.00012402138506576433, 
     -0.00011809751202080532, -0.0001125880340641647, -0.0001074551928548783, 
     -0.00010266543347517567, -0.00009818885529778636, 
     -0.00009399874473971837, -0.00009007117624237467, 
     -0.0000863846703283719, -0.00008291989959367615, -0.0000796594351080023, 
     -0.0000765875270001727, -0.00007368991406276777, -0.0000709536580720728, 
     -0.00006836699922423537, -0.00006591922966750035, 
     -0.0000636005825877019, -0.0000614021346991499, 
     -0.000059315720321013405, -0.00005733385549256534, 
     -0.000055449670809080406, -0.000053656851851732195, 
     -0.00005194958624595751, -0.00005032251651868042, 
     -0.00004877069803978287, -0.00004728956143076312, 
     -0.00004587487890650418, -0.00004452273408684028, 
     -0.00004322949487510957, -0.00004199178905273001, 
     -0.00004080648228337446, -0.000039670658258667726, 
     -0.00003858160075041684, -0.000037536777362998565, 
     -0.00003653382480432151, -0.0000355705355153087, 
     -0.00003464484551657522, -0.0000337548233473016, 
     -0.00003289865998556017, -0.000032074659651824875, 
     -0.00003128123140832625, -0.000030516881476510464, 
     -0.000029780206203300545, -0.000029069885614292, 
     -0.000028384677498572968, -0.000027723411975654094, 
     -0.0000270849865001214, -0.000026468361264170117, 
     -0.00002587255496221102, -0.000025296640885325735, 
     -0.00002473974331653804, -0.000024201034200711586, 
     -0.000023679730065421777, -0.000023175089171416644, 
     -0.00002268640887330989, -0.000022213023172965827, 
     -0.000021754300449665403, -0.00002130964135260511, 
     -0.000020878476842595675, -0.000020460266371010583, 
     -0.000020054496185100584};
 
  TVIL_REAL FbaryxxxCLy2table[] = 
     {0.5, -0.16666666666666666, 0.037037037037037035, 
     0.00823045267489712, 0.004877305288827923, 0.0033277447543565513, 
     0.0024089221569280504, 0.0018191629508784188, 0.001419905064147793, 
     0.001137935815263503, 0.0009317925650982574, 0.0007767023322158301, 
     0.0006571815289069812, 0.0005631729542932661, 0.0004879244268736945, 
     0.00042677112638951344, 0.0003764089738587107, 0.00033444594798835513, 
     0.00029911652785053925, 0.0002690950156717281, 0.00024337054654151888, 
     0.00022116158711992873, 0.00020185630672671682, 0.00018497025870056085, 
     0.00017011586594751135, 0.0001569800967751773, 0.00014530791436178457, 
     0.00013488985594929486, 0.00012555260577635507, 0.00011715176528640994, 
     0.00010956625464602172, 0.00010269393836170508, 0.00009644817859340573, 
     0.00009075509807661399, 0.00008555139055949603, 0.00008078255713493518, 
     0.0000764014764018188, 0.0000723672381786378, 0.00006864418670136757, 
     0.00006520113139844416, 0.00006201069253288217, 0.00005904875601040266, 
     0.00005629401703208235, 0.00005372759642743915, 0.000051332716737587835, 
     0.00004909442764889318, 0.000046999372369859186, 
     0.000045035588121187335, 0.00004319233516418595, 0.00004145994979683807, 
     0.00003982971755400115, 0.00003829376350008635, 0.000036844957031383885, 
     0.0000354768290360364, 0.00003418349961211768, 0.00003295961483375018, 
     0.00003180029129385095, 0.00003070106734957495, 0.000029657860160506702, 
     0.00002866692774628267, 0.000027724835404540203, 
     0.000026828425925866098, 0.000025974793122978753, 
     0.00002516125825934021, 0.000024385349019891436, 0.00002364478071538156, 
     0.00002293743945325209, 0.00002226136704342014, 0.000021614747437554784, 
     0.000020995894526365007, 0.00002040324114168723, 
     0.000019835329129333863, 0.00001929080037520842, 
     0.000018768388681499282, 0.000018266912402160756, 
     0.00001778526775765435, 0.00001732242275828761, 0.0000168774116736508, 
     0.000016449329992780085, 0.000016037329825912437, 
     0.000015640615704163126, 0.000015258440738255232, 
     0.000014890103101650272, 0.000014534942807146, 0.000014192338749286484, 
     0.000013861705987827047, 0.0000135424932500607, 0.000013234180632085059, 
     0.00001293627748110551, 0.000012648320442662868, 0.00001236987165826902, 
     0.000012100517100355793, 0.000011839865032710889, 
     0.000011587544585708322, 0.000011343204436654945, 
     0.000011106511586482914, 0.000010877150224832702, 
     0.000010654820676302555, 0.000010439238421297837, 
     0.000010230133185505292, 0.000010027248092550292};
 
  TVIL_REAL FbaryxxxCLx3table[] = 
     {0., 0., 0., 0.0013717421124828531, 
     0.0009144947416552355, 0.0006096631611034903, 0.0004290222244802339, 
     0.000316748864565085, 0.00024294533374562955, 0.00019204714802783702, 
     0.0001555381513822483, 0.0001284917415230802, 0.00010791169500095938, 
     0.00009189570015721786, 0.00007919074947096155, 0.0000689450659704684, 
     0.00006056361728230099, 0.000053620733318380694, 0.00004780548263307222, 
     0.00004288651635685097, 0.000038688849055669304, 0.00003507816592456426, 
     0.00003194999532302022, 0.000029222097864420607, 0.00002682902558629989, 
     0.000024718172384717493, 0.000022846866570574136, 
     0.000021180202943014794, 0.000019689407092218558, 
     0.00001835058775356571, 0.00001714377550857566, 0.000016052175147902598, 
     0.00001506157911890754, 0.000014159903594544467, 
     0.000013336818728510866, 0.000012583451867781104, 
     0.00001189214772705046, 0.000011256273368271886, 0.00001067005867048923, 
     0.00001012846509789137, 9.627077172680147e-6, 9.162012272804072e-6, 
     8.729845302528858e-6, 8.327545498385554e-6, 7.952423186990463e-6, 
     7.602084743398007e-6, 7.274394337840348e-6, 6.967441326459988e-6, 
     6.679512354160314e-6, 6.409067407261764e-6, 6.154719189617802e-6, 
     5.915215305394026e-6, 5.6894228203827135e-6, 5.476314845809367e-6, 
     5.27495884743617e-6, 5.084506431004675e-6, 4.904184394753398e-6, 
     4.7332868725308574e-6, 4.571168418200834e-6, 4.4172379046417e-6, 
     4.270953129507404e-6, 4.131816035713199e-6, 3.999368467875397e-6, 
     3.87318839710961e-6, 3.7528865560331186e-6, 3.638103433815474e-6, 
     3.528506587916146e-6, 3.423788234935183e-6, 3.3236630879444456e-6, 
     3.2278664118969175e-6, 3.136152272341008e-6, 3.0482919557881187e-6, 
     2.964072542772189e-6, 2.8832956169639944e-6, 2.805776095714806e-6, 
     2.731341169149149e-6, 2.659829336443197e-6, 2.5910895292462444e-6, 
     2.524980313355197e-6, 2.461369160759409e-6, 2.4001317850553368e-6, 
     2.341151534004288e-6, 2.2843188336864634e-6, 2.2295306793029316e-6, 
     2.1766901682047005e-6, 2.1257060711938608e-6, 2.076492438553652e-6, 
     2.028968237629089e-6, 1.9830570191033085e-6, 1.9386866094021448e-6, 
     1.8957888269149983e-6, 1.854299219947692e-6, 1.8141568245259687e-6, 
     1.7753039403495657e-6, 1.7376859233588372e-6, 1.701250993520986e-6, 
     1.6659500565729878e-6, 1.631736538574971e-6, 1.598566232232644e-6, 
     1.5663971540416401e-6, 1.5351894113915407e-6};
 
  TVIL_REAL FbaryxxxCLx2Lytable[] = 
     {0., -0.16666666666666666, 0., -0.00411522633744856, 
     -0.0027434842249657062, -0.001828989483310471, -0.0012870666734407018, 
     -0.0009502465936952549, -0.0007288360012368886, -0.000576141444083511, 
     -0.0004666144541467449, -0.00038547522456924057, -0.0003237350850028781, 
     -0.0002756871004716536, -0.00023757224841288466, 
     -0.00020683519791140522, -0.00018169085184690297, 
     -0.00016086219995514208, -0.00014341644789921665, 
     -0.0001286595490705529, -0.00011606654716700792, 
     -0.00010523449777369278, -0.00009584998596906065, 
     -0.00008766629359326183, -0.00008048707675889968, 
     -0.00007415451715415248, -0.0000685405997117224, 
     -0.00006354060882904438, -0.00005906822127665568, 
     -0.00005505176326069713, -0.00005143132652572698, 
     -0.000048156525443707795, -0.00004518473735672262, 
     -0.0000424797107836334, -0.0000400104561855326, -0.00003775035560334331, 
     -0.00003567644318115138, -0.00003376882010481566, 
     -0.00003201017601146769, -0.00003038539529367411, 
     -0.00002888123151804044, -0.000027486036818412215, 
     -0.00002618953590758657, -0.000024982636495156662, 
     -0.00002385726956097139, -0.00002280625423019402, 
     -0.000021823183013521043, -0.000020902323979379962, 
     -0.000020038537062480944, -0.00001922720222178529, 
     -0.000018464157568853406, -0.000017745645916182076, 
     -0.00001706826846114814, -0.000016428944537428102, 
     -0.00001582487654230851, -0.000015253519293014025, 
     -0.000014712553184260193, -0.000014199860617592572, 
     -0.000013713505254602502, -0.0000132517137139251, 
     -0.000012812859388522212, -0.000012395448107139598, 
     -0.00001199810540362619, -0.000011619565191328831, 
     -0.000011258659668099357, -0.000010914310301446423, 
     -0.000010585519763748439, -0.000010271364704805549, 
     -9.970989263833336e-6, -9.683599235690753e-6, -9.408456817023023e-6, 
     -9.144875867364355e-6, -8.892217628316568e-6, -8.649886850891984e-6, 
     -8.417328287144418e-6, -8.194023507447446e-6, -7.979488009329591e-6, 
     -7.773268587738733e-6, -7.574940940065591e-6, -7.384107482278227e-6, 
     -7.200395355166011e-6, -7.023454602012864e-6, -6.8529565010593905e-6, 
     -6.688592037908795e-6, -6.530070504614101e-6, -6.377118213581582e-6, 
     -6.229477315660956e-6, -6.0869047128872664e-6, -5.949171057309926e-6, 
     -5.8160598282064334e-6, -5.6873664807449955e-6, 
     -5.562897659843075e-6, -5.442470473577906e-6, -5.325911821048697e-6, 
     -5.213057770076512e-6, -5.103752980562958e-6, -4.997850169718963e-6, 
     -4.895209615724913e-6, -4.795698696697932e-6, -4.699191462124921e-6, 
     -4.605568234174622e-6};
 
  TVIL_REAL FbaryxxxCLxLy2table[] = 
     {0., 0.16666666666666666, 0., 0.00411522633744856, 
     0.0027434842249657062, 0.001828989483310471, 0.0012870666734407018, 
     0.0009502465936952549, 0.0007288360012368886, 0.000576141444083511, 
     0.0004666144541467449, 0.00038547522456924057, 0.0003237350850028781, 
     0.0002756871004716536, 0.00023757224841288466, 0.00020683519791140522, 
     0.00018169085184690297, 0.00016086219995514208, 0.00014341644789921665, 
     0.0001286595490705529, 0.00011606654716700792, 0.00010523449777369278, 
     0.00009584998596906065, 0.00008766629359326183, 0.00008048707675889968, 
     0.00007415451715415248, 0.0000685405997117224, 0.00006354060882904438, 
     0.00005906822127665568, 0.00005505176326069713, 0.00005143132652572698, 
     0.000048156525443707795, 0.00004518473735672262, 0.0000424797107836334, 
     0.0000400104561855326, 0.00003775035560334331, 0.00003567644318115138, 
     0.00003376882010481566, 0.00003201017601146769, 0.00003038539529367411, 
     0.00002888123151804044, 0.000027486036818412215, 0.00002618953590758657, 
     0.000024982636495156662, 0.00002385726956097139, 0.00002280625423019402, 
     0.000021823183013521043, 0.000020902323979379962, 
     0.000020038537062480944, 0.00001922720222178529, 
     0.000018464157568853406, 0.000017745645916182076, 
     0.00001706826846114814, 0.000016428944537428102, 0.00001582487654230851, 
     0.000015253519293014025, 0.000014712553184260193, 
     0.000014199860617592572, 0.000013713505254602502, 0.0000132517137139251, 
     0.000012812859388522212, 0.000012395448107139598, 
     0.00001199810540362619, 0.000011619565191328831, 
     0.000011258659668099357, 0.000010914310301446423, 
     0.000010585519763748439, 0.000010271364704805549, 9.970989263833336e-6, 
     9.683599235690753e-6, 9.408456817023023e-6, 9.144875867364355e-6, 
     8.892217628316568e-6, 8.649886850891984e-6, 8.417328287144418e-6, 
     8.194023507447446e-6, 7.979488009329591e-6, 7.773268587738733e-6, 
     7.574940940065591e-6, 7.384107482278227e-6, 7.200395355166011e-6, 
     7.023454602012864e-6, 6.8529565010593905e-6, 6.688592037908795e-6, 
     6.530070504614101e-6, 6.377118213581582e-6, 6.229477315660956e-6, 
     6.0869047128872664e-6, 5.949171057309926e-6, 5.8160598282064334e-6, 
     5.6873664807449955e-6, 5.562897659843075e-6, 5.442470473577906e-6, 
     5.325911821048697e-6, 5.213057770076512e-6, 5.103752980562958e-6, 
     4.997850169718963e-6, 4.895209615724913e-6, 4.795698696697932e-6, 
     4.699191462124921e-6, 4.605568234174622e-6};
 
  TVIL_REAL FbaryxxxCLy3table[] = 
     {0., -0.05555555555555555, 0., -0.0013717421124828531, 
     -0.0009144947416552355, -0.0006096631611034903, -0.0004290222244802339, 
     -0.000316748864565085, -0.00024294533374562955, -0.00019204714802783702, 
     -0.0001555381513822483, -0.0001284917415230802, -0.00010791169500095938, 
     -0.00009189570015721786, -0.00007919074947096155, 
     -0.0000689450659704684, -0.00006056361728230099, 
     -0.000053620733318380694, -0.00004780548263307222, 
     -0.00004288651635685097, -0.000038688849055669304, 
     -0.00003507816592456426, -0.00003194999532302022, 
     -0.000029222097864420607, -0.00002682902558629989, 
     -0.000024718172384717493, -0.000022846866570574136, 
     -0.000021180202943014794, -0.000019689407092218558, 
     -0.00001835058775356571, -0.00001714377550857566, 
     -0.000016052175147902598, -0.00001506157911890754, 
     -0.000014159903594544467, -0.000013336818728510866, 
     -0.000012583451867781104, -0.00001189214772705046, 
     -0.000011256273368271886, -0.00001067005867048923, 
     -0.00001012846509789137, -9.627077172680147e-6, -9.162012272804072e-6, 
     -8.729845302528858e-6, -8.327545498385554e-6, -7.952423186990463e-6, 
     -7.602084743398007e-6, -7.274394337840348e-6, -6.967441326459988e-6, 
     -6.679512354160314e-6, -6.409067407261764e-6, -6.154719189617802e-6, 
     -5.915215305394026e-6, -5.6894228203827135e-6, -5.476314845809367e-6, 
     -5.27495884743617e-6, -5.084506431004675e-6, -4.904184394753398e-6, 
     -4.7332868725308574e-6, -4.571168418200834e-6, -4.4172379046417e-6, 
     -4.270953129507404e-6, -4.131816035713199e-6, -3.999368467875397e-6, 
     -3.87318839710961e-6, -3.7528865560331186e-6, -3.638103433815474e-6, 
     -3.528506587916146e-6, -3.423788234935183e-6, -3.3236630879444456e-6, 
     -3.2278664118969175e-6, -3.136152272341008e-6, 
     -3.0482919557881187e-6, -2.964072542772189e-6, 
     -2.8832956169639944e-6, -2.805776095714806e-6, -2.731341169149149e-6, 
     -2.659829336443197e-6, -2.5910895292462444e-6, -2.524980313355197e-6, 
     -2.461369160759409e-6, -2.4001317850553368e-6, -2.341151534004288e-6, 
     -2.2843188336864634e-6, -2.2295306793029316e-6, 
     -2.1766901682047005e-6, -2.1257060711938608e-6, 
     -2.076492438553652e-6, -2.028968237629089e-6, -1.9830570191033085e-6, 
     -1.9386866094021448e-6, -1.8957888269149983e-6, 
     -1.854299219947692e-6, -1.8141568245259687e-6, 
     -1.7753039403495657e-6, -1.7376859233588372e-6, 
     -1.701250993520986e-6, -1.6659500565729878e-6, -1.631736538574971e-6, 
     -1.598566232232644e-6, -1.5663971540416401e-6, -1.5351894113915407e-6};

  TVIL_REAL FbaryxxxDtable[] = 
     {0, 0, 0.5224689417768408, -0.14786268028506597, 
     0.07120118998892583, -0.04206798897609178, 0.027815460363156325, 
     -0.01976717368170844, 0.014774160972681501, -0.011462304876807345, 
     0.00915251269715744, -0.007477341254236414, 0.006223707145088672, 
     -0.00526106965996546, 0.004505806038386361, -0.003902326811340382, 
     0.0034125041377431596, -0.003009477361010906, 0.0026738796879204525, 
     -0.002391461479581142, 0.0021515489491393826, -0.0019460186680763118, 
     0.0017685995759865478, -0.0016143881607525734, 0.0014795055072388296, 
     -0.0013608506691344215, 0.0012559206351010965, -0.0011626771001938285, 
     0.001079446632658023, -0.001004844999328886, 0.0009377191911431632, 
     -0.0008771025700057025, 0.0008221798491093037, -0.0007722595175632265, 
     0.0007267519539993125, -0.0006851519261517968, 0.0006470244998226676, 
     -0.0006119936186605272, 0.0005797327914384377, -0.0005499574537508652, 
     0.0005224186686662096, -0.0004968979046367059, 0.0004732026851394598, 
     -0.00045116294760933395, 0.00043062798250302934, 
     -0.00041146384920546375, 0.0003935511857284068, -0.00037678334507765027, 
     0.00036106480376851656, -0.0003463097979972541, 0.0003324411509953056, 
     -0.0003193892615383161, 0.0003070912287856073, -0.0002954900928465826, 
     0.00028453417390866836, -0.00027417649557365655, 0.00026437428035878144, 
     -0.00025508850722268485, 0.0002462835225516262, -0.0002379266973492082, 
     0.0002299881244625807, -0.00022244035058894247, 0.0002152581385699522, 
     -0.00020841825612408663, 0.00020189928770892988, 
     -0.00019568146666386292, 0.00018974652517257258, -0.0001840775599156402, 
     0.00017865891156561154, -0.0001734760565181637, 0.0001685155094597066, 
     -0.00016376473554933742, 0.0001592120711459607, -0.00015484665214331826, 
     0.0001506583490897613, -0.00014663770836845919, 0.0001427758987995842, 
     -0.0001390646631006971, 0.00013549627370666124, -0.00013206349250726978, 
     0.00012875953411051194, -0.00012557803228300328, 0.0001225130092573797, 
     -0.00011955884763011732, 0.00011671026460289065, 
     -0.00011396228834674216, 0.00011131023629145151, 
     -0.00010874969516295075, 0.00010627650260976148, 
     -0.00010388673027552328, 0.00010157666818898443, 
     -0.00009934281035555704, 0.00009718184144588355, 
     -0.00009509062448698641, 0.00009306618947061973, 
     -0.00009110572280153553, 0.00008920655751562764, 
     -0.00008736616420441848, 0.0000855821425881927, -0.00008385221368532957, 
     0.00008217421253010979};
 
  TVIL_REAL FbaryxxxDLtable[] = 
     {0, 0, 0.5, -0.16666666666666666, 0.08333333333333333, -0.05, 
     0.03333333333333333, -0.023809523809523808, 0.017857142857142856, 
     -0.013888888888888888, 0.011111111111111112, -0.00909090909090909, 
     0.007575757575757576, -0.00641025641025641, 0.005494505494505495, 
     -0.004761904761904762, 0.004166666666666667, -0.003676470588235294, 
     0.0032679738562091504, -0.0029239766081871343, 0.002631578947368421, 
     -0.002380952380952381, 0.0021645021645021645, -0.001976284584980237, 
     0.0018115942028985507, -0.0016666666666666668, 0.0015384615384615385, 
     -0.0014245014245014246, 0.0013227513227513227, -0.0012315270935960591, 
     0.0011494252873563218, -0.001075268817204301, 0.0010080645161290322, 
     -0.000946969696969697, 0.00089126559714795, -0.0008403361344537816, 
     0.0007936507936507937, -0.0007507507507507507, 0.0007112375533428165, 
     -0.0006747638326585695, 0.000641025641025641, -0.0006097560975609756, 
     0.0005807200929152149, -0.0005537098560354374, 0.0005285412262156448, 
     -0.000505050505050505, 0.0004830917874396135, -0.00046253469010175765, 
     0.0004432624113475177, -0.00042517006802721087, 0.00040816326530612246, 
     -0.000392156862745098, 0.0003770739064856712, -0.000362844702467344, 
     0.00034940600978336826, -0.0003367003367003367, 0.0003246753246753247, 
     -0.0003132832080200501, 0.00030248033877797946, -0.0002922267679719462, 
     0.0002824858757062147, -0.000273224043715847, 0.00026441036488630354, 
     -0.0002560163850486431, 0.000248015873015873, -0.0002403846153846154, 
     0.0002331002331002331, -0.0002261420171867933, 0.00021949078138718174, 
     -0.00021312872975277067, 0.00020703933747412008, 
     -0.00020120724346076458, 0.00019561815336463224, -0.0001902587519025875, 
     0.00018511662347278786, -0.00018018018018018018, 0.00017543859649122806, 
     -0.00017088174982911826, 0.0001665001665001665, -0.0001622849724115547, 
     0.00015822784810126583, -0.00015432098765432098, 0.00015055706112616682, 
     -0.00014692918013517486, 0.00014343086632243257, 
     -0.00014005602240896358, 0.00013679890560875513, 
     -0.00013365410318096765, 0.00013061650992685477, 
     -0.00012768130745658836, 0.00012484394506866417, -0.0001221001221001221, 
     0.00011944577161968466, -0.0001168770453482936, 0.00011439029970258523, 
     -0.00011198208286674133, 0.00010964912280701755, 
     -0.00010738831615120275, 0.00010519671786240269, 
     -0.00010307153164296021, 0.00010101010101010101};

  TVIL_REAL FbaryxxxFtable[] = 
     {0, 0, 7.563830936659006, -1.8513926935300402, 0.8178318090929925, 
     -0.458862597896255, 0.29329332107502026, -0.20352478674192542, 
     0.14945887798098284, -0.11439395442155428, 0.09036572997502505, 
     -0.07318470303598835, 0.060476087964571996, -0.050812109732463466, 
     0.04329245144863045, -0.037326580574427976, 0.03251410642375433, 
     -0.028575774066306278, 0.025312003529755177, -0.022577088402684607, 
     0.020262641619513112, -0.018286685829072797, 0.01658629118798414, 
     -0.015112500974108573, 0.013826767137958188, -0.012698403297748649, 
     0.01170273630313919, -0.01081974567461995, 0.010033049112200251, 
     -0.009329137007660823, 0.0086967884832378, -0.008126621375504529, 
     0.007610742168083928, -0.007142471284892145, 0.006716125757286665, 
     -0.0063268459679008335, 0.00597045654321421, -0.005643353913626597, 
     0.00534241485442181, -0.005064921649732164, 0.004808500514118152, 
     -0.0045710706539321315, 0.0043508019181347155, -0.004146079422258681, 
     0.003955473863504752, -0.0037777165041502376, 0.003611678002702263, 
     -0.0034563504309982947, 0.0033108319408130145, -0.0031743136430484402, 
     0.0030460683420033925, -0.0029254408309155877, 0.002811839506301812, 
     -0.002704729100178838, 0.0026036243630392334, -0.0025080845580489116, 
     0.002417708649555521, -0.0023321310876159448, 0.0022510181056329733, 
     -0.0021740644609441776, 0.002100990558816054, -0.0020315399091531765, 
     0.001965476872648921, -0.0019025846593346619, 0.001842663547733736, 
     -0.0017855292972620877, 0.001731011730276096, -0.0016789534633615303, 
     0.0016292087701780102, -0.0015816425604966875, 0.0015361294620579661, 
     -0.0014925529935830727, 0.0014508048187415793, -0.001410784072142772, 
     0.0013723967495123588, -0.0013355551551628342, 0.0013001774006872547, 
     -0.0012661869495202468, 0.0012335122026320086, -0.0012020861211637967, 
     0.0011718458822878456, -0.0011427325649902014, 0.0011146908628395019, 
     -0.0010876688211250997, 0.0010616175960299306, -0.0010364912337521627, 
     0.0010122464677092171, -0.0009888425321519284, 0.0009662409906885989, 
     -0.0009444055783712588, 0.0009233020561319502, -0.0009028980764773978, 
     0.0008831630594577911, -0.0008640680780211658, 0.0008455857519503887, 
     -0.0008276901496562247, 0.0008103566971684215, -0.0007935620937281269, 
     0.0007772842334400155, -0.0007615021324920018, 0.0007461958614949143};
 
  TVIL_REAL FbaryxxxFLtable[] = 
     {0, 0, 4.5, -1.5, 0.75, -0.45, 0.3, -0.21428571428571427, 
     0.16071428571428573, -0.125, 0.1, -0.08181818181818182, 
     0.06818181818181818, -0.057692307692307696, 0.04945054945054945, 
     -0.04285714285714286, 0.0375, -0.03308823529411765, 
     0.029411764705882353, -0.02631578947368421, 0.02368421052631579, 
     -0.02142857142857143, 0.01948051948051948, -0.017786561264822136, 
     0.016304347826086956, -0.015, 0.013846153846153847, 
     -0.01282051282051282, 0.011904761904761904, -0.011083743842364532, 
     0.010344827586206896, -0.00967741935483871, 0.009072580645161291, 
     -0.008522727272727272, 0.008021390374331552, -0.007563025210084034, 
     0.007142857142857143, -0.006756756756756757, 0.006401137980085348, 
     -0.006072874493927126, 0.0057692307692307696, -0.00548780487804878, 
     0.005226480836236934, -0.0049833887043189366, 0.0047568710359408035, 
     -0.004545454545454545, 0.004347826086956522, -0.004162812210915819, 
     0.003989361702127659, -0.003826530612244898, 0.003673469387755102, 
     -0.0035294117647058825, 0.003393665158371041, -0.003265602322206096, 
     0.0031446540880503146, -0.0030303030303030303, 0.002922077922077922, 
     -0.002819548872180451, 0.0027223230490018148, -0.002630040911747516, 
     0.002542372881355932, -0.002459016393442623, 0.002379693283976732, 
     -0.002304147465437788, 0.002232142857142857, -0.0021634615384615386, 
     0.002097902097902098, -0.0020352781546811396, 0.001975417032484636, 
     -0.0019181585677749361, 0.0018633540372670807, -0.0018108651911468814, 
     0.0017605633802816902, -0.0017123287671232876, 0.0016660496112550908, 
     -0.0016216216216216215, 0.0015789473684210526, -0.0015379357484620643, 
     0.0014985014985014985, -0.0014605647517039922, 0.0014240506329113924, 
     -0.001388888888888889, 0.0013550135501355014, -0.0013223626212165735, 
     0.0012908777969018934, -0.0012605042016806723, 0.0012311901504787962, 
     -0.0012028869286287089, 0.0011755485893416929, -0.0011491317671092952, 
     0.0011235955056179776, -0.001098901098901099, 0.001075011944577162, 
     -0.0010518934081346423, 0.001029512697323267, -0.001007838745800672, 
     0.000986842105263158, -0.0009664948453608248, 0.0009467704607616243, 
     -0.0009276437847866419, 0.0009090909090909091};

  if (SAME2(0,x)) return TVIL_FBARx000(y,qq);
  if (SAME2(0,y)) return TVIL_FBAR0xxx(x,qq);
  if (SAME2(x,y)) return TVIL_FBARxxxx(x,qq);

  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;
  lnyox = lnbary - lnbarx;

  if (y < 0.5 * x) {

    result = TVIL_FBAR0xxx(x,qq);

    result += y * (-4.857419382136006 - 3.5626048257929726*lnbarx 
      - 0.5*lnbarx2 + 0.8126048257929726*lnbary + lnbarx * lnbary);

    rn = r = y/x;

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (FbaryxxxAtable[n] - FbaryxxxALtable[n] * lnyox); 
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_FBARxxxx(x,qq);

    result += (y - x) * (-3.731870797416305 - 1.75*lnbarx + 0.5*lnbarx2);
 
    rn = r = y/x - 1.L; 

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (
        FbaryxxxDtable[n] + FbaryxxxDLtable[n] * lnbarx);
    }
  }
  else if (y < 5.54 * x) {
    result = 4.47354098831186*x - 2.0846398663779646*y - 
      1.9841391419658116*x*lnbarx - 0.36370563888010937*y*lnbarx + 
      1.5*x*lnbarx2 + 0.5*y*lnbarx2 - 0.5*x*lnbarx3;

    rn = r = 0.25L * y/x - 1.L; 

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (
        FbaryxxxBtable[n] + FbaryxxxBLtable[n] * lnbarx);
    }
  }
  else if (y < 14.56 * x) {
    result = -3.2154078147193443*x - 0.8545293985094398*y - 
      6.984139141965811*x*lnbarx + 0.4472245773362194*y*lnbarx + 
      1.5*x*lnbarx2 + 0.5*y*lnbarx2 - 0.5*x*lnbarx3;

    rn = r = y/(9.L*x) - 1.L; 

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (FbaryxxxFtable[n] + FbaryxxxFLtable[n] * lnbarx);
    }
  }
  else {
    result = 0;
    r = 9.L * x/y;
    rn = 1;

    for (n=0; n < 100; n++) {
      result += y * rn * (
        FbaryxxxCtable[n] + 
        FbaryxxxCLxtable[n] * lnbarx + 
        FbaryxxxCLytable[n] * lnbary +
        FbaryxxxCLx2table[n] * lnbarx2 +
        FbaryxxxCLy2table[n] * lnbary2 +
        FbaryxxxCLxLytable[n] * lnbarx * lnbary +
        FbaryxxxCLx3table[n] * lnbarx3 +
        FbaryxxxCLx2Lytable[n] * lnbarx2 * lnbary +
        FbaryxxxCLxLy2table[n] * lnbarx * lnbary2 +
        FbaryxxxCLy3table[n] * lnbary3); 
        rn *= r;
    }
  }

  return result;
};

/* ****************************************************************** */

int TVIL_AnalyticFBARTYPE (TVIL_FBARTYPE *foo, TVIL_REAL qq)
{
  int retval;

  retval = TVIL_FBARanalytic (foo->arg[0],
			      foo->arg[1],
			      foo->arg[2],
			      foo->arg[3],
			      qq,
			      &(foo->value));

  return retval;
}

/* ****************************************************************** */


int TVIL_FBARanalytic (TVIL_REAL a1,
		       TVIL_REAL a2,
		       TVIL_REAL a3,
		       TVIL_REAL a4,
		       TVIL_REAL QQ,
		       TVIL_COMPLEX *result)
{
  int success = 1;

  if (SAME5(0,a1,a2,a3,a4))
    *result = TVIL_FBAR0000 ();

  else if (SAME4(0,a1,a2,a3))
    *result = TVIL_FBAR000x (a4, QQ);
  else if (SAME4(0,a1,a2,a4))
    *result = TVIL_FBAR000x (a3, QQ);
  else if (SAME4(0,a1,a3,a4))
    *result = TVIL_FBAR000x (a2, QQ);

  else if (SAME4(0,a2,a3,a4))
    *result = TVIL_FBARx000 (a1, QQ);

  else if (SAME3(0,a1,a2) && SAME2(a3,a4))
    *result = TVIL_FBAR00xx (a4, QQ);
  else if (SAME3(0,a1,a3) && SAME2(a2,a4))
    *result = TVIL_FBAR00xx (a4, QQ);
  else if (SAME3(0,a1,a4) && SAME2(a2,a3))
    *result = TVIL_FBAR00xx (a3, QQ);

  else if (SAME3(0,a2,a3) && SAME2(a1,a4))
    *result = TVIL_FBARx00x (a1, QQ);
  else if (SAME3(0,a2,a4) && SAME2(a1,a3))
    *result = TVIL_FBARx00x (a1, QQ);
  else if (SAME3(0,a3,a4) && SAME2(a1,a2))
    *result = TVIL_FBARx00x (a1, QQ);

  else if (SAME2(0,a2) && SAME3(a1,a3,a4))
    *result = TVIL_FBARx0xx (a1, QQ);
  else if (SAME2(0,a3) && SAME3(a1,a2,a4))
    *result = TVIL_FBARx0xx (a1, QQ);
  else if (SAME2(0,a4) && SAME3(a1,a2,a3))
    *result = TVIL_FBARx0xx (a1, QQ);

  else if (SAME2(0,a1) && SAME3(a2,a3,a4))
    *result = TVIL_FBAR0xxx (a4, QQ);

  else if (SAME4(a1,a2,a3,a4))
    *result = TVIL_FBARxxxx (a1, QQ);

  else if (SAME3(0,a1,a2) && (a3>0) && (a4>0))
    *result = TVIL_FBAR00xy (a3, a4, QQ);
  else if (SAME3(0,a1,a3) && (a2>0) && (a4>0))
    *result = TVIL_FBAR00xy (a2, a4, QQ);
  else if (SAME3(0,a1,a4) && (a2>0) && (a3>0))
    *result = TVIL_FBAR00xy (a2, a3, QQ);

  else if ((SAME3(0,a2,a3)) && (a1>0) && (a4>0))
    *result = TVIL_FBARx00y (a1, a4, QQ);
  else if ((SAME3(0,a2,a4)) && (a1>0) && (a3>0))
    *result = TVIL_FBARx00y (a1, a3, QQ);
  else if ((SAME3(0,a3,a4)) && (a1>0) && (a2>0))
    *result = TVIL_FBARx00y (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME2(a1,a3) && (a1>0) && (a4>0))
    *result = TVIL_FBARx0xy (a1, a4, QQ);
  else if (SAME2(0,a2) && SAME2(a1,a4) && (a1>0) && (a3>0))
    *result = TVIL_FBARx0xy (a1, a3, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a2) && (a1>0) && (a4>0))
    *result = TVIL_FBARx0xy (a1, a4, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a4) && (a1>0) && (a2>0))
    *result = TVIL_FBARx0xy (a1, a2, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a2) && (a1>0) && (a3>0))
    *result = TVIL_FBARx0xy (a1, a3, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a3) && (a1>0) && (a2>0))
    *result = TVIL_FBARx0xy (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME2(a3,a4) && (a1>0) && (a4>0))
    *result = TVIL_FBARx0yy (a1, a4, QQ);
  else if (SAME2(0,a3) && SAME2(a2,a4) && (a1>0) && (a4>0))
    *result = TVIL_FBARx0yy (a1, a4, QQ);
  else if (SAME2(0,a4) && SAME2(a2,a3) && (a1>0) && (a3>0))
    *result = TVIL_FBARx0yy (a1, a3, QQ);

  else if (SAME2(0,a1) && SAME2(a2,a3) && (a2>0) && (a4>0))
    *result = TVIL_FBAR0xxy (a2, a4, QQ);
  else if (SAME2(0,a1) && SAME2(a2,a4) && (a2>0) && (a3>0))
    *result = TVIL_FBAR0xxy (a2, a3, QQ);
  else if (SAME2(0,a1) && SAME2(a3,a4) && (a3>0) && (a2>0))
    *result = TVIL_FBAR0xxy (a3, a2, QQ);

  else if (SAME2(a1,a2) && SAME2(a3,a4) && (a1>0) && (a3>0))
    *result = TVIL_FBARxxyy (a1, a3, QQ);
  else if (SAME2(a1,a3) && SAME2(a2,a4) && (a1>0) && (a2>0))
    *result = TVIL_FBARxxyy (a1, a2, QQ);
  else if (SAME2(a1,a4) && SAME2(a2,a3) && (a1>0) && (a2>0))
    *result = TVIL_FBARxxyy (a1, a2, QQ);

  else if (SAME3(a1,a2,a3) && (a1>0) && (a4>0))
    *result = TVIL_FBARxxxy (a1, a4, QQ);
  else if (SAME3(a1,a2,a4) && (a1>0) && (a3>0))
    *result = TVIL_FBARxxxy (a1, a3, QQ);
  else if (SAME3(a1,a3,a4) && (a1>0) && (a2>0))
    *result = TVIL_FBARxxxy (a1, a2, QQ);

  else if (SAME3(a2,a3,a4) && (a1>0) && (a2>0))
    *result = TVIL_FBARyxxx (a2, a1, QQ);

  else
    success = 0;

  return success;
}

/* ****************************************************************** */

int TVIL_Fanalytic (TVIL_REAL a1,
                    TVIL_REAL a2,
                    TVIL_REAL a3,
                    TVIL_REAL a4,
                    TVIL_REAL QQ,
                    TVIL_COMPLEX *result)
{
  int success;
  TVIL_COMPLEX FBARresult;

  if (a1 > TVIL_EPSILON) {
     success = TVIL_FBARanalytic (a1, a2, a3, a4, QQ, &FBARresult); 
     *result = FBARresult - TVIL_LOG (a1/QQ) * TVIL_I2 (a2, a3, a4, QQ);
  } 
  else success = 0;              
  
  return success;
}

/* ****************************************************************** */

int TVIL_SetF (TVIL_FBARTYPE *foo, TVIL_REAL qq)
{
  /* For readability: */
  TVIL_REAL u = foo->arg[0];
  TVIL_REAL v = foo->arg[1];
  TVIL_REAL y = foo->arg[2];
  TVIL_REAL z = foo->arg[3];
  TVIL_COMPLEX lnbaru;

/*
  if (SAME2(0,u)) return TVIL_ComplexInfinity;
*/

  lnbaru = TVIL_LOG (TVIL_FABS(u)/qq);  
  if (u<0) lnbaru = lnbaru - I * PI;

  (foo->fValue) = (foo->value) - lnbaru*TVIL_I2 (v, y, z, qq);

  /* Make this meaningful eventually... */
  return 0;
}

/* ****************************************************************** */

int TVIL_SetAllFs (TVIL_RESULT *foo)
{
  int i;
  for (i=0; i<NUM_F_FUNCS; i++)
    if (foo->evaluateFBAR[i])
      TVIL_SetF (&(_FBAR[i]), _qq);

  /* Make this meaningful eventually... */
  return 0;
}

/* ****************************************************************** */
/* Sets initial value for an FBAR function at a point near t = 0. */

int TVIL_InitialFBAR (TVIL_FBARTYPE *foo, 
		      TVIL_REAL qq,
		      TVIL_COMPLEX tinit)
{
  TVIL_REAL x = (foo->arg[0])/_a;
  TVIL_REAL y = (foo->arg[1])/_a;
  TVIL_REAL z = (foo->arg[2])/_a;
  TVIL_REAL u = (foo->arg[3])/_a;

  TVIL_REAL Fbarexp[9];
  TVIL_REAL x2, x3, x4, x5, x6, x7, x8;
  TVIL_REAL y2, y3, y4, y5, y6, y7, y8;
  TVIL_REAL z2, z3, z4, z5, z6, z7, z8;
  TVIL_REAL u2, u3, u4, u5, u6, u7, u8;
  TVIL_REAL lnbara, lnbara2, lnbara3;
  TVIL_COMPLEX ttothei, result;
  int i, nTerms = 9;

  lnbara = TVIL_LOG (_a/_qq);
  lnbara2 = lnbara*lnbara;
  lnbara3 = lnbara2*lnbara;

  x2 = x*x;
  x3 = x2*x;
  x4 = x2*x2;
  x5 = x2*x3;
  x6 = x3*x3;
  x7 = x4*x3;
  x8 = x4*x4;

  y2 = y*y;
  y3 = y2*y;
  y4 = y2*y2;
  y5 = y2*y3;
  y6 = y3*y3;
  y7 = y4*y3;
  y8 = y4*y4;

  z2 = z*z;
  z3 = z2*z;
  z4 = z2*z2;
  z5 = z2*z3;
  z6 = z3*z3;
  z7 = z4*z3;
  z8 = z4*z4;

  u2 = u*u;
  u3 = u2*u;
  u4 = u2*u2;
  u5 = u2*u3;
  u6 = u3*u3;
  u7 = u4*u3;
  u8 = u4*u4;

  Fbarexp[0] = 4.416666666666667 - 0.7341391419658116*lnbara + 2.*lnbara2 - 
     0.5*lnbara3;
 
  Fbarexp[1] = -3.682527524700855 - 3.265860858034188*lnbara - 0.5*lnbara2 + 
     0.5*lnbara3 + 2.4714661073723865*u + 1.6719536193447295*lnbara*u - 
     0.16666666666666666*lnbara3*u - 3.731870797416305*x - 1.75*lnbara*x + 
     0.5*lnbara2*x + 2.4714661073723865*y + 1.6719536193447295*lnbara*y - 
     0.16666666666666666*lnbara3*y + 2.4714661073723865*z + 
     1.6719536193447295*lnbara*z - 0.16666666666666666*lnbara3*z;
 
  Fbarexp[2] = 1.632930429017094 + 0.5*lnbara - 0.75*lnbara2 - 
     1.6719536193447295*u + 0.5*lnbara2*u - 0.801799790264645*u2 - 
     0.7813024128964863*lnbara*u2 - 0.25*lnbara2*u2 + 1.75*x - 
     1.*lnbara*x - 0.9316459611845606*u*x + 0.5224689417768408*x2 + 
     0.5*lnbara*x2 - 1.6719536193447295*y + 0.5*lnbara2*y + 
     2.10359958052929*u*y + 0.7813024128964863*lnbara*u*y - 
     0.9316459611845606*x*y - 0.801799790264645*y2 - 
     0.7813024128964863*lnbara*y2 - 0.25*lnbara2*y2 - 
     1.6719536193447295*z + 0.5*lnbara2*z + 2.10359958052929*u*z + 
     0.7813024128964863*lnbara*u*z - 0.9316459611845606*x*z + 
     2.10359958052929*y*z + 0.7813024128964863*lnbara*y*z - 
     0.801799790264645*z2 - 0.7813024128964863*lnbara*z2 - 0.25*lnbara2*z2;
 
  Fbarexp[3] = 0.3776434763390314 + 0.6666666666666666*lnbara - 0.25*lnbara2 - 
     0.8359768096723648*u - 0.5*lnbara*u + 0.25*lnbara2*u - 
     0.020497377368158702*u2 - 0.2813024128964863*lnbara*u2 - 
     0.25*lnbara2*u2 + 0.1587832808994946*u3 + 0.20487858207660653*lnbara*
      u3 + 0.08333333333333333*lnbara2*u3 + 1.375*x - 0.5*lnbara*x - 
     0.9316459611845606*u*x + 0.19504742980199746*u2*x + 
     0.02246894177684083*x2 + 0.5*lnbara*x2 + 0.14037303302611903*u*x2 - 
     0.14786268028506597*x3 - 0.16666666666666666*lnbara*x3 - 
     0.8359768096723648*y - 0.5*lnbara*y + 0.25*lnbara2*y + 
     1.3222971676328037*u*y + 0.7813024128964863*lnbara*u*y - 
     0.32544994756616125*u2*y - 0.16666666666666666*lnbara*u2*y - 
     0.9316459611845606*x*y + 0.13040251776416378*u*x*y + 
     0.14037303302611903*x2*y - 0.020497377368158702*y2 - 
     0.2813024128964863*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.32544994756616125*u*y2 - 0.16666666666666666*lnbara*u*y2 + 
     0.19504742980199746*x*y2 + 0.1587832808994946*y3 + 
     0.20487858207660653*lnbara*y3 + 0.08333333333333333*lnbara2*y3 - 
     0.8359768096723648*z - 0.5*lnbara*z + 0.25*lnbara2*z + 
     1.3222971676328037*u*z + 0.7813024128964863*lnbara*u*z - 
     0.32544994756616125*u2*z - 0.16666666666666666*lnbara*u2*z - 
     0.9316459611845606*x*z + 0.13040251776416378*u*x*z + 
     0.14037303302611903*x2*z + 1.3222971676328037*y*z + 
     0.7813024128964863*lnbara*y*z - 0.1508998951323225*u*y*z - 
     0.11463574622981963*lnbara*u*y*z + 0.13040251776416378*x*y*z - 
     0.32544994756616125*y2*z - 0.16666666666666666*lnbara*y2*z - 
     0.020497377368158702*z2 - 0.2813024128964863*lnbara*z2 - 
     0.25*lnbara2*z2 - 0.32544994756616125*u*z2 - 
     0.16666666666666666*lnbara*u*z2 + 0.19504742980199746*x*z2 - 
     0.32544994756616125*y*z2 - 0.16666666666666666*lnbara*y*z2 + 
     0.1587832808994946*z3 + 0.20487858207660653*lnbara*z3 + 
     0.08333333333333333*lnbara2*z3;
 
  Fbarexp[4] = 0.022155071502849028 + 0.4583333333333333*lnbara - 
     0.125*lnbara2 - 0.39065120644824314*u - 0.5*lnbara*u + 
     0.16666666666666666*lnbara2*u + 0.12015382908008444*u2 - 
     0.0313024128964863*lnbara*u2 - 0.25*lnbara2*u2 + 
     0.11268797972238262*u3 + 0.24309049748654643*lnbara*u3 + 
     0.16666666666666666*lnbara2*u3 - 0.06897497378308062*u4 - 
     0.09491905471773769*lnbara*u4 - 0.041666666666666664*lnbara2*u4 + 
     1.0833333333333333*x - 0.3333333333333333*lnbara*x - 
     0.9316459611845606*u*x + 0.3900948596039949*u2*x - 
     0.07890469882288804*u3*x - 0.22753105822315917*x2 + 0.5*lnbara*x2 + 
     0.28074606605223806*u*x2 - 0.035023714900998724*u2*x2 - 
     0.12905869390346528*x3 - 0.3333333333333333*lnbara*x3 - 
     0.05191535535074602*u*x3 + 0.07120118998892583*x4 + 
     0.08333333333333333*lnbara*x4 - 0.39065120644824314*y - 0.5*lnbara*y + 
     0.16666666666666666*lnbara2*y + 0.9316459611845606*u*y + 
     0.7813024128964863*lnbara*u*y - 0.4842332284656558*u2*y - 
     0.3333333333333333*lnbara*u2*y + 0.12105830711641395*u3*y + 
     0.06829286069220218*lnbara*u3*y - 0.9316459611845606*x*y + 
     0.26080503552832757*u*x*y - 0.041666666666666664*u2*x*y + 
     0.28074606605223806*x2*y - 0.027476285099001272*u*x2*y - 
     0.05191535535074602*x3*y + 0.12015382908008444*y2 - 
     0.0313024128964863*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.4842332284656558*u*y2 - 0.3333333333333333*lnbara*u*y2 + 
     0.0625*u2*y2 + 0.045121417923393456*lnbara*u2*y2 + 
     0.3900948596039949*x*y2 - 0.041666666666666664*u*x*y2 - 
     0.035023714900998724*x2*y2 + 0.11268797972238262*y3 + 
     0.24309049748654643*lnbara*y3 + 0.16666666666666666*lnbara2*y3 + 
     0.12105830711641395*u*y3 + 0.06829286069220218*lnbara*u*y3 - 
     0.07890469882288804*x*y3 - 0.06897497378308062*y4 - 
     0.09491905471773769*lnbara*y4 - 0.041666666666666664*lnbara2*y4 - 
     0.39065120644824314*z - 0.5*lnbara*z + 0.16666666666666666*lnbara2*z + 
     0.9316459611845606*u*z + 0.7813024128964863*lnbara*u*z - 
     0.4842332284656558*u2*z - 0.3333333333333333*lnbara*u2*z + 
     0.12105830711641395*u3*z + 0.06829286069220218*lnbara*u3*z - 
     0.9316459611845606*x*z + 0.26080503552832757*u*x*z - 
     0.041666666666666664*u2*x*z + 0.28074606605223806*x2*z - 
     0.027476285099001272*u*x2*z - 0.05191535535074602*x3*z + 
     0.9316459611845606*y*z + 0.7813024128964863*lnbara*y*z - 
     0.18716404403482537*u*y*z - 0.22927149245963926*lnbara*u*y*z + 
     0.03772497378308062*u2*y*z + 0.03821191540993988*lnbara*u2*y*z + 
     0.26080503552832757*x*y*z - 0.03918579866365838*u*x*y*z - 
     0.027476285099001272*x2*y*z - 0.4842332284656558*y2*z - 
     0.3333333333333333*lnbara*y2*z + 0.03772497378308062*u*y2*z + 
     0.03821191540993988*lnbara*u*y2*z - 0.041666666666666664*x*y2*z + 
     0.12105830711641395*y3*z + 0.06829286069220218*lnbara*y3*z + 
     0.12015382908008444*z2 - 0.0313024128964863*lnbara*z2 - 
     0.25*lnbara2*z2 - 0.4842332284656558*u*z2 - 
     0.3333333333333333*lnbara*u*z2 + 0.0625*u2*z2 + 
     0.045121417923393456*lnbara*u2*z2 + 0.3900948596039949*x*z2 - 
     0.041666666666666664*u*x*z2 - 0.035023714900998724*x2*z2 - 
     0.4842332284656558*y*z2 - 0.3333333333333333*lnbara*y*z2 + 
     0.03772497378308062*u*y*z2 + 0.03821191540993988*lnbara*u*y*z2 - 
     0.041666666666666664*x*y*z2 + 0.0625*y2*z2 + 
     0.045121417923393456*lnbara*y2*z2 + 0.11268797972238262*z3 + 
     0.24309049748654643*lnbara*z3 + 0.16666666666666666*lnbara2*z3 + 
     0.12105830711641395*u*z3 + 0.06829286069220218*lnbara*u*z3 - 
     0.07890469882288804*x*z3 + 0.12105830711641395*y*z3 + 
     0.06829286069220218*lnbara*y*z3 - 0.06897497378308062*z4 - 
     0.09491905471773769*lnbara*z4 - 0.041666666666666664*lnbara2*z4;
 
  Fbarexp[5] = -0.07837362376495725 + 0.325*lnbara - 0.075*lnbara2 - 
     0.16798840483618235*u - 0.4583333333333333*lnbara*u + 0.125*lnbara2*u + 
     0.13058796671224654*u2 + 0.13536425377018038*lnbara*u2 - 
     0.25*lnbara2*u2 + 0.04748672084030073*u3 + 0.19796907956315296*lnbara*
      u3 + 0.25*lnbara2*u3 - 0.11200586663150418*u4 - 
     0.20142383081987975*lnbara*u4 - 0.125*lnbara2*u4 + 
     0.03893566151703746*u5 + 0.0549460364784918*lnbara*u5 + 
     0.025*lnbara2*u5 + 0.8958333333333334*x - 0.25*lnbara*x - 
     0.9316459611845606*u*x + 0.5851422894059923*u2*x - 
     0.23671409646866412*u3*x + 0.04204576035750674*u4*x - 
     0.39419772488982585*x2 + 0.5*lnbara*x2 + 0.4211190990783571*u*x2 - 
     0.10507114470299618*u2*x2 + 0.014959121883334814*u3*x2 - 
     0.026921374188531248*x3 - 0.5*lnbara*x3 - 0.15574606605223806*u*x3 + 
     0.013495492518326768*u2*x3 + 0.13027023663344417*x4 + 
     0.25*lnbara*x4 + 0.02668990274900491*u*x4 - 0.04206798897609178*x5 - 
     0.05*lnbara*x5 - 0.16798840483618235*y - 0.4583333333333333*lnbara*y + 
     0.125*lnbara2*y + 0.6712118235523985*u*y + 0.7813024128964863*lnbara*u*
      y - 0.559683176031817*u2*y - 0.5*lnbara*u2*y + 
     0.2948820606570397*u3*y + 0.20487858207660653*lnbara*u3*y - 
     0.06235910065559491*u4*y - 0.03665317578628961*lnbara*u4*y - 
     0.9316459611845606*x*y + 0.3912075532924914*u*x*y - 0.125*u2*x*y + 
     0.01930640563598377*u3*x*y + 0.4211190990783571*x2*y - 
     0.08242885529700382*u*x2*y + 0.009853650749005715*u2*x2*y - 
     0.15574606605223806*x3*y + 0.010997735009782437*u*x3*y + 
     0.02668990274900491*x4*y + 0.13058796671224654*y2 + 
     0.13536425377018038*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.559683176031817*u*y2 - 0.5*lnbara*u*y2 + 0.14237858207660653*u2*
      y2 + 0.13536425377018038*lnbara*u2*y2 - 0.024493227528109205*u3*
      y2 - 0.020053963521508202*lnbara*u3*y2 + 0.5851422894059923*x*y2 - 
     0.125*u*x*y2 + 0.015560465676376308*u2*x*y2 - 
     0.10507114470299618*x2*y2 + 0.009853650749005715*u*x2*y2 + 
     0.013495492518326768*x3*y2 + 0.04748672084030073*y3 + 
     0.19796907956315296*lnbara*y3 + 0.25*lnbara2*y3 + 
     0.2948820606570397*u*y3 + 0.20487858207660653*lnbara*u*y3 - 
     0.024493227528109205*u2*y3 - 0.020053963521508202*lnbara*u2*y3 - 
     0.23671409646866412*x*y3 + 0.01930640563598377*u*x*y3 + 
     0.014959121883334814*x2*y3 - 0.11200586663150418*y4 - 
     0.20142383081987975*lnbara*y4 - 0.125*lnbara2*y4 - 
     0.06235910065559491*u*y4 - 0.03665317578628961*lnbara*u*y4 + 
     0.04204576035750674*x*y4 + 0.03893566151703746*y5 + 
     0.0549460364784918*lnbara*y5 + 0.025*lnbara2*y5 - 
     0.16798840483618235*z - 0.4583333333333333*lnbara*z + 0.125*lnbara2*z + 
     0.6712118235523985*u*z + 0.7813024128964863*lnbara*u*z - 
     0.559683176031817*u2*z - 0.5*lnbara*u2*z + 0.2948820606570397*u3*z + 
     0.20487858207660653*lnbara*u3*z - 0.06235910065559491*u4*z - 
     0.03665317578628961*lnbara*u4*z - 0.9316459611845606*x*z + 
     0.3912075532924914*u*x*z - 0.125*u2*x*z + 0.01930640563598377*u3*x*z + 
     0.4211190990783571*x2*z - 0.08242885529700382*u*x2*z + 
     0.009853650749005715*u2*x2*z - 0.15574606605223806*x3*z + 
     0.010997735009782437*u*x3*z + 0.02668990274900491*x4*z + 
     0.6712118235523985*y*z + 0.7813024128964863*lnbara*y*z - 
     0.16611031982241842*u*y*z - 0.3439072386894589*lnbara*u*y*z + 
     0.074963005939302*u2*y*z + 0.11463574622981963*lnbara*u2*y*z - 
     0.01576560861442539*u3*y*z - 0.018157951888431674*lnbara*u3*y*z + 
     0.3912075532924914*x*y*z - 0.11755739599097514*u*x*y*z + 
     0.016252550241284643*u2*x*y*z - 0.08242885529700382*x2*y*z + 
     0.010021047271633643*u*x2*y*z + 0.010997735009782437*x3*y*z - 
     0.559683176031817*y2*z - 0.5*lnbara*y2*z + 0.074963005939302*u*y2*z + 
     0.11463574622981963*lnbara*u*y2*z - 0.010979682584327617*u2*y2*z - 
     0.015040472641131153*lnbara*u2*y2*z - 0.125*x*y2*z + 
     0.016252550241284643*u*x*y2*z + 0.009853650749005715*x2*y2*z + 
     0.2948820606570397*y3*z + 0.20487858207660653*lnbara*y3*z - 
     0.01576560861442539*u*y3*z - 0.018157951888431674*lnbara*u*y3*z + 
     0.01930640563598377*x*y3*z - 0.06235910065559491*y4*z - 
     0.03665317578628961*lnbara*y4*z + 0.13058796671224654*z2 + 
     0.13536425377018038*lnbara*z2 - 0.25*lnbara2*z2 - 
     0.559683176031817*u*z2 - 0.5*lnbara*u*z2 + 0.14237858207660653*u2*
      z2 + 0.13536425377018038*lnbara*u2*z2 - 0.024493227528109205*u3*
      z2 - 0.020053963521508202*lnbara*u3*z2 + 0.5851422894059923*x*z2 - 
     0.125*u*x*z2 + 0.015560465676376308*u2*x*z2 - 
     0.10507114470299618*x2*z2 + 0.009853650749005715*u*x2*z2 + 
     0.013495492518326768*x3*z2 - 0.559683176031817*y*z2 - 
     0.5*lnbara*y*z2 + 0.074963005939302*u*y*z2 + 
     0.11463574622981963*lnbara*u*y*z2 - 0.010979682584327617*u2*y*z2 - 
     0.015040472641131153*lnbara*u2*y*z2 - 0.125*x*y*z2 + 
     0.016252550241284643*u*x*y*z2 + 0.009853650749005715*x2*y*z2 + 
     0.14237858207660653*y2*z2 + 0.13536425377018038*lnbara*y2*z2 - 
     0.010979682584327617*u*y2*z2 - 0.015040472641131153*lnbara*u*y2*z2 + 
     0.015560465676376308*x*y2*z2 - 0.024493227528109205*y3*z2 - 
     0.020053963521508202*lnbara*y3*z2 + 0.04748672084030073*z3 + 
     0.19796907956315296*lnbara*z3 + 0.25*lnbara2*z3 + 
     0.2948820606570397*u*z3 + 0.20487858207660653*lnbara*u*z3 - 
     0.024493227528109205*u2*z3 - 0.020053963521508202*lnbara*u2*z3 - 
     0.23671409646866412*x*z3 + 0.01930640563598377*u*x*z3 + 
     0.014959121883334814*x2*z3 + 0.2948820606570397*y*z3 + 
     0.20487858207660653*lnbara*y*z3 - 0.01576560861442539*u*y*z3 - 
     0.018157951888431674*lnbara*u*y*z3 + 0.01930640563598377*x*y*z3 - 
     0.024493227528109205*y2*z3 - 0.020053963521508202*lnbara*y2*z3 - 
     0.11200586663150418*z4 - 0.20142383081987975*lnbara*z4 - 
     0.125*lnbara2*z4 - 0.06235910065559491*u*z4 - 
     0.03665317578628961*lnbara*u*z4 + 0.04204576035750674*x*z4 - 
     0.06235910065559491*y*z4 - 0.03665317578628961*lnbara*y*z4 + 
     0.03893566151703746*z5 + 0.0549460364784918*lnbara*z5 + 
     0.025*lnbara2*z5;
 
  Fbarexp[6] = -0.10641574917663817 + 0.24166666666666667*lnbara - 
     0.05*lnbara2 - 0.042724057202279224*u - 0.4166666666666667*lnbara*u + 
     0.1*lnbara2*u + 0.09674690326970145*u2 + 0.26036425377018035*lnbara*
      u2 - 0.25*lnbara2*u2 - 0.0026740654006500216*u3 + 
     0.09729210608420395*lnbara*u3 + 0.3333333333333333*lnbara2*u3 - 
     0.12329981785306848*u4 - 0.2778476616397595*lnbara*u4 - 
     0.25*lnbara2*u4 + 0.10079660958965803*u5 + 0.16978414591396718*lnbara*
      u5 + 0.1*lnbara2*u5 - 0.02509960988230047*u6 - 
     0.035885453284794776*lnbara*u6 - 0.016666666666666666*lnbara2*u6 + 
     0.7666666666666667*x - 0.2*lnbara*x - 0.9316459611845606*u*x + 
     0.7801897192079899*u2*x - 0.47342819293732824*u3*x + 
     0.16818304143002696*u4*x - 0.02600114622302915*u5*x - 
     0.5191977248898259*x2 + 0.5*lnbara*x2 + 0.5614921321044761*u*x2 - 
     0.21014228940599236*u2*x2 + 0.059836487533339255*u3*x2 - 
     0.00816041324288591*u4*x2 + 0.13077150108195834*x3 - 
     0.6666666666666666*lnbara*x3 - 0.3114921321044761*u*x3 + 
     0.05398197007330707*u2*x3 - 0.005867060110137494*u3*x3 + 
     0.13554047326688834*x4 + 0.5*lnbara*x4 + 0.10675961099601965*u*x4 - 
     0.00704235352968079*u2*x4 - 0.11827195590436712*x5 - 0.2*lnbara*x5 - 
     0.016206935424856943*u*x5 + 0.027815460363156325*x6 + 
     0.03333333333333333*lnbara*x6 - 0.042724057202279224*y - 
     0.4166666666666667*lnbara*y + 0.1*lnbara2*y + 0.4758862203282769*u*y + 
     0.7813024128964863*lnbara*u*y - 0.5795775680424228*u2*y - 
     0.6666666666666666*lnbara*u2*y + 0.4873248302757761*u3*y + 
     0.40975716415321306*lnbara*u3*y - 0.21278322683609005*u4*y - 
     0.14661270314515845*lnbara*u4*y + 0.03790109796358698*u5*y + 
     0.02276428689740073*lnbara*u5*y - 0.9316459611845606*x*y + 
     0.5216100710566551*u*x*y - 0.25*u2*x*y + 0.07722562254393509*u3*x*y - 
     0.010928241914554696*u4*x*y + 0.5614921321044761*x2*y - 
     0.16485771059400764*u*x2*y + 0.03941460299602286*u2*x2*y - 
     0.004796827115691569*u3*x2*y - 0.3114921321044761*x3*y + 
     0.04399094003912975*u*x3*y - 0.004105687812085715*u2*x3*y + 
     0.10675961099601965*x4*y - 0.00582011340618667*u*x4*y - 
     0.016206935424856943*x5*y + 0.09674690326970145*y2 + 
     0.26036425377018035*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.5795775680424228*u*y2 - 0.6666666666666666*lnbara*u*y2 + 
     0.2170750372681229*u2*y2 + 0.27072850754036076*lnbara*u2*y2 - 
     0.07791894659092861*u3*y2 - 0.08021585408603281*lnbara*u3*y2 + 
     0.01286246693586746*u4*y2 + 0.011178565512996366*lnbara*u4*y2 + 
     0.7801897192079899*x*y2 - 0.25*u*x*y2 + 0.06224186270550523*u2*x*
      y2 - 0.007736900085251058*u3*x*y2 - 0.21014228940599236*x2*y2 + 
     0.03941460299602286*u*x2*y2 - 0.00408511380731101*u2*x2*y2 + 
     0.05398197007330707*x3*y2 - 0.004105687812085715*u*x3*y2 - 
     0.00704235352968079*x4*y2 - 0.0026740654006500216*y3 + 
     0.09729210608420395*lnbara*y3 + 0.3333333333333333*lnbara2*y3 + 
     0.4873248302757761*u*y3 + 0.40975716415321306*lnbara*u*y3 - 
     0.07791894659092861*u2*y3 - 0.08021585408603281*lnbara*u2*y3 + 
     0.009783201076803173*u3*y3 + 0.009259259259259259*lnbara*u3*y3 - 
     0.47342819293732824*x*y3 + 0.07722562254393509*u*x*y3 - 
     0.007736900085251058*u2*x*y3 + 0.059836487533339255*x2*y3 - 
     0.004796827115691569*u*x2*y3 - 0.005867060110137494*x3*y3 - 
     0.12329981785306848*y4 - 0.2778476616397595*lnbara*y4 - 
     0.25*lnbara2*y4 - 0.21278322683609005*u*y4 - 
     0.14661270314515845*lnbara*u*y4 + 0.01286246693586746*u2*y4 + 
     0.011178565512996366*lnbara*u2*y4 + 0.16818304143002696*x*y4 - 
     0.010928241914554696*u*x*y4 - 0.00816041324288591*x2*y4 + 
     0.10079660958965803*y5 + 0.16978414591396718*lnbara*y5 + 
     0.1*lnbara2*y5 + 0.03790109796358698*u*y5 + 
     0.02276428689740073*lnbara*u*y5 - 0.02600114622302915*x*y5 - 
     0.02509960988230047*y6 - 0.035885453284794776*lnbara*y6 - 
     0.016666666666666666*lnbara2*y6 - 0.042724057202279224*z - 
     0.4166666666666667*lnbara*z + 0.1*lnbara2*z + 0.4758862203282769*u*z + 
     0.7813024128964863*lnbara*u*z - 0.5795775680424228*u2*z - 
     0.6666666666666666*lnbara*u2*z + 0.4873248302757761*u3*z + 
     0.40975716415321306*lnbara*u3*z - 0.21278322683609005*u4*z - 
     0.14661270314515845*lnbara*u4*z + 0.03790109796358698*u5*z + 
     0.02276428689740073*lnbara*u5*z - 0.9316459611845606*x*z + 
     0.5216100710566551*u*x*z - 0.25*u2*x*z + 0.07722562254393509*u3*x*z - 
     0.010928241914554696*u4*x*z + 0.5614921321044761*x2*z - 
     0.16485771059400764*u*x2*z + 0.03941460299602286*u2*x2*z - 
     0.004796827115691569*u3*x2*z - 0.3114921321044761*x3*z + 
     0.04399094003912975*u*x3*z - 0.004105687812085715*u2*x3*z + 
     0.10675961099601965*x4*z - 0.00582011340618667*u*x4*z - 
     0.016206935424856943*x5*z + 0.4758862203282769*y*z + 
     0.7813024128964863*lnbara*y*z - 0.1068446802000716*u*y*z - 
     0.45854298491927853*lnbara*u*y*z + 0.09260813876369418*u2*y*z + 
     0.22927149245963926*lnbara*u2*y*z - 0.04490448256926989*u3*y*z - 
     0.0726318075537267*lnbara*u3*y*z + 0.008481045060974917*u4*y*z + 
     0.010434137632162098*lnbara*u4*y*z + 0.5216100710566551*x*y*z - 
     0.2351147919819503*u*x*y*z + 0.06501020096513857*u2*x*y*z - 
     0.008445200483831043*u3*x*y*z - 0.16485771059400764*x2*y*z + 
     0.04008418908653457*u*x2*y*z - 0.004536830598068991*u2*x2*y*z + 
     0.04399094003912975*x3*y*z - 0.0042877351660402085*u*x3*y*z - 
     0.00582011340618667*x4*y*z - 0.5795775680424228*y2*z - 
     0.6666666666666666*lnbara*y2*z + 0.09260813876369418*u*y2*z + 
     0.22927149245963926*lnbara*u*y2*z - 0.028878257696179317*u2*y2*z - 
     0.06016189056452461*lnbara*u2*y2*z + 0.004856375702300316*u3*y2*z + 
     0.007723814256269575*lnbara*u3*y2*z - 0.25*x*y2*z + 
     0.06501020096513857*u*x*y2*z - 0.007650234579376865*u2*x*y2*z + 
     0.03941460299602286*x2*y2*z - 0.004536830598068991*u*x2*y2*z - 
     0.004105687812085715*x3*y2*z + 0.4873248302757761*y3*z + 
     0.40975716415321306*lnbara*y3*z - 0.04490448256926989*u*y3*z - 
     0.0726318075537267*lnbara*u*y3*z + 0.004856375702300316*u2*y3*z + 
     0.007723814256269575*lnbara*u2*y3*z + 0.07722562254393509*x*y3*z - 
     0.008445200483831043*u*x*y3*z - 0.004796827115691569*x2*y3*z - 
     0.21278322683609005*y4*z - 0.14661270314515845*lnbara*y4*z + 
     0.008481045060974917*u*y4*z + 0.010434137632162098*lnbara*u*y4*z - 
     0.010928241914554696*x*y4*z + 0.03790109796358698*y5*z + 
     0.02276428689740073*lnbara*y5*z + 0.09674690326970145*z2 + 
     0.26036425377018035*lnbara*z2 - 0.25*lnbara2*z2 - 
     0.5795775680424228*u*z2 - 0.6666666666666666*lnbara*u*z2 + 
     0.2170750372681229*u2*z2 + 0.27072850754036076*lnbara*u2*z2 - 
     0.07791894659092861*u3*z2 - 0.08021585408603281*lnbara*u3*z2 + 
     0.01286246693586746*u4*z2 + 0.011178565512996366*lnbara*u4*z2 + 
     0.7801897192079899*x*z2 - 0.25*u*x*z2 + 0.06224186270550523*u2*x*
      z2 - 0.007736900085251058*u3*x*z2 - 0.21014228940599236*x2*z2 + 
     0.03941460299602286*u*x2*z2 - 0.00408511380731101*u2*x2*z2 + 
     0.05398197007330707*x3*z2 - 0.004105687812085715*u*x3*z2 - 
     0.00704235352968079*x4*z2 - 0.5795775680424228*y*z2 - 
     0.6666666666666666*lnbara*y*z2 + 0.09260813876369418*u*y*z2 + 
     0.22927149245963926*lnbara*u*y*z2 - 0.028878257696179317*u2*y*z2 - 
     0.06016189056452461*lnbara*u2*y*z2 + 0.004856375702300316*u3*y*z2 + 
     0.007723814256269575*lnbara*u3*y*z2 - 0.25*x*y*z2 + 
     0.06501020096513857*u*x*y*z2 - 0.007650234579376865*u2*x*y*z2 + 
     0.03941460299602286*x2*y*z2 - 0.004536830598068991*u*x2*y*z2 - 
     0.004105687812085715*x3*y*z2 + 0.2170750372681229*y2*z2 + 
     0.27072850754036076*lnbara*y2*z2 - 0.028878257696179317*u*y2*z2 - 
     0.06016189056452461*lnbara*u*y2*z2 + 0.0036951190308771435*u2*y2*
      z2 + 0.00690950251345358*lnbara*u2*y2*z2 + 
     0.06224186270550523*x*y2*z2 - 0.007650234579376865*u*x*y2*z2 - 
     0.00408511380731101*x2*y2*z2 - 0.07791894659092861*y3*z2 - 
     0.08021585408603281*lnbara*y3*z2 + 0.004856375702300316*u*y3*z2 + 
     0.007723814256269575*lnbara*u*y3*z2 - 0.007736900085251058*x*y3*z2 + 
     0.01286246693586746*y4*z2 + 0.011178565512996366*lnbara*y4*z2 - 
     0.0026740654006500216*z3 + 0.09729210608420395*lnbara*z3 + 
     0.3333333333333333*lnbara2*z3 + 0.4873248302757761*u*z3 + 
     0.40975716415321306*lnbara*u*z3 - 0.07791894659092861*u2*z3 - 
     0.08021585408603281*lnbara*u2*z3 + 0.009783201076803173*u3*z3 + 
     0.009259259259259259*lnbara*u3*z3 - 0.47342819293732824*x*z3 + 
     0.07722562254393509*u*x*z3 - 0.007736900085251058*u2*x*z3 + 
     0.059836487533339255*x2*z3 - 0.004796827115691569*u*x2*z3 - 
     0.005867060110137494*x3*z3 + 0.4873248302757761*y*z3 + 
     0.40975716415321306*lnbara*y*z3 - 0.04490448256926989*u*y*z3 - 
     0.0726318075537267*lnbara*u*y*z3 + 0.004856375702300316*u2*y*z3 + 
     0.007723814256269575*lnbara*u2*y*z3 + 0.07722562254393509*x*y*z3 - 
     0.008445200483831043*u*x*y*z3 - 0.004796827115691569*x2*y*z3 - 
     0.07791894659092861*y2*z3 - 0.08021585408603281*lnbara*y2*z3 + 
     0.004856375702300316*u*y2*z3 + 0.007723814256269575*lnbara*u*y2*z3 - 
     0.007736900085251058*x*y2*z3 + 0.009783201076803173*y3*z3 + 
     0.009259259259259259*lnbara*y3*z3 - 0.12329981785306848*z4 - 
     0.2778476616397595*lnbara*z4 - 0.25*lnbara2*z4 - 
     0.21278322683609005*u*z4 - 0.14661270314515845*lnbara*u*z4 + 
     0.01286246693586746*u2*z4 + 0.011178565512996366*lnbara*u2*z4 + 
     0.16818304143002696*x*z4 - 0.010928241914554696*u*x*z4 - 
     0.00816041324288591*x2*z4 - 0.21278322683609005*y*z4 - 
     0.14661270314515845*lnbara*y*z4 + 0.008481045060974917*u*y*z4 + 
     0.010434137632162098*lnbara*u*y*z4 - 0.010928241914554696*x*y*z4 + 
     0.01286246693586746*y2*z4 + 0.011178565512996366*lnbara*y2*z4 + 
     0.10079660958965803*z5 + 0.16978414591396718*lnbara*z5 + 
     0.1*lnbara2*z5 + 0.03790109796358698*u*z5 + 
     0.02276428689740073*lnbara*u*z5 - 0.02600114622302915*x*z5 + 
     0.03790109796358698*y*z5 + 0.02276428689740073*lnbara*y*z5 - 
     0.02509960988230047*z6 - 0.035885453284794776*lnbara*z6 - 
     0.016666666666666666*lnbara2*z6;
 
  Fbarexp[7] = -0.11053505893569393 + 0.1869047619047619*lnbara - 
     0.03571428571428571*lnbara2 + 0.033841063442545095*u - 
     0.38055555555555554*lnbara*u + 0.08333333333333333*lnbara2*u + 
     0.04467405251566538*u2 + 0.3603642537701804*lnbara*u2 - 
     0.25*lnbara2*u2 - 0.027665608271863516*u3 - 
     0.04505153406141173*lnbara*u3 + 0.4166666666666667*lnbara2*u3 - 
     0.11288380920852763*u4 - 0.29641276939959915*lnbara*u4 - 
     0.4166666666666667*lnbara2*u4 + 0.16709945101716145*u5 + 
     0.32446036478491797*lnbara*u5 + 0.25*lnbara2*u5 - 
     0.08961259612670759*u6 - 0.14609393309064053*lnbara*u6 - 
     0.08333333333333333*lnbara2*u6 + 0.017552526521994072*u7 + 
     0.025294799938732206*lnbara*u7 + 0.011904761904761904*lnbara2*u7 + 
     0.6722222222222223*x - 0.16666666666666666*lnbara*x - 
     0.9316459611845606*u*x + 0.9752371490099873*u2*x - 
     0.7890469882288804*u3*x + 0.4204576035750674*u4*x - 
     0.13000573111514574*u5*x + 0.01763709312218411*u6*x - 
     0.6191977248898258*x2 + 0.5*lnbara*x2 + 0.7018651651305952*u*x2 - 
     0.35023714900998726*u2*x2 + 0.14959121883334814*u3*x2 - 
     0.04080206621442954*u4*x2 + 0.005109481838882987*u5*x2 + 
     0.3301310430191146*x3 - 0.8333333333333334*lnbara*x3 - 
     0.5191535535074602*u*x3 + 0.13495492518326768*u2*x3 - 
     0.029335300550687473*u3*x3 + 0.0032290651917485417*u4*x3 + 
     0.05923412211148055*x4 + 0.8333333333333334*lnbara*x4 + 
     0.2668990274900491*u*x4 - 0.03521176764840395*u2*x4 + 
     0.0030845212777298402*u3*x4 - 0.1956798897609178*x5 - 
     0.5*lnbara*x5 - 0.08103467712428472*u*x5 + 0.004307156641639393*u2*
      x5 + 0.1057439684824483*x6 + 0.16666666666666666*lnbara*x6 + 
     0.010875415763170257*u*x6 - 0.01976717368170844*x7 - 
     0.023809523809523808*lnbara*x7 + 0.033841063442545095*y - 
     0.38055555555555554*lnbara*y + 0.08333333333333333*lnbara2*y + 
     0.3196257377489796*u*y + 0.7813024128964863*lnbara*u*y - 
     0.5578052933863618*u2*y - 0.8333333333333334*lnbara*u2*y + 
     0.6756223290752225*u3*y + 0.6829286069220218*lnbara*u3*y - 
     0.4586517155176459*u4*y - 0.36653175786289616*lnbara*u4*y + 
     0.16674120292053418*u5*y + 0.11382143448700363*lnbara*u5*y - 
     0.02544609132471751*u6*y - 0.01548483324024246*lnbara*u6*y - 
     0.9316459611845606*x*y + 0.652012588820819*u*x*y - 
     0.4166666666666667*u2*x*y + 0.1930640563598377*u3*x*y - 
     0.05464120957277348*u4*x*y + 0.006982104352137553*u5*x*y + 
     0.7018651651305952*x2*y - 0.27476285099001274*u*x2*y + 
     0.09853650749005716*u2*x2*y - 0.023984135578457844*u3*x2*y + 
     0.0027837307223844915*u4*x2*y - 0.5191535535074602*x3*y + 
     0.10997735009782438*u*x3*y - 0.020528439060428574*u2*x3*y + 
     0.002040477336386972*u3*x3*y + 0.2668990274900491*x4*y - 
     0.02910056703093335*u*x4*y + 0.0022112103035087306*u2*x4*y - 
     0.08103467712428472*x5*y + 0.003583934630992194*u*x5*y + 
     0.010875415763170257*x6*y + 0.04467405251566538*y2 + 
     0.3603642537701804*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.5578052933863618*u*y2 - 0.8333333333333334*lnbara*u*y2 + 
     0.27154889293341794*u2*y2 + 0.4512141792339346*lnbara*u2*y2 - 
     0.15468943943430513*u3*y2 - 0.20053963521508203*lnbara*u3*y2 + 
     0.05313376916634094*u4*y2 + 0.055892827564981824*lnbara*u4*y2 - 
     0.007891091272631587*u5*y2 - 0.00709100055854524*lnbara*u5*y2 + 
     0.9752371490099873*x*y2 - 0.4166666666666667*u*x*y2 + 
     0.1556046567637631*u2*x*y2 - 0.03868450042625529*u3*x*y2 + 
     0.004544934602470172*u4*x*y2 - 0.35023714900998726*x2*y2 + 
     0.09853650749005716*u*x2*y2 - 0.02042556903655505*u2*x2*y2 + 
     0.002132338931514418*u3*x2*y2 + 0.13495492518326768*x3*y2 - 
     0.020528439060428574*u*x3*y2 + 0.0017732108200787678*u2*x3*y2 - 
     0.03521176764840395*x4*y2 + 0.0022112103035087306*u*x4*y2 + 
     0.004307156641639393*x5*y2 - 0.027665608271863516*y3 - 
     0.04505153406141173*lnbara*y3 + 0.4166666666666667*lnbara2*y3 + 
     0.6756223290752225*u*y3 + 0.6829286069220218*lnbara*u*y3 - 
     0.15468943943430513*u2*y3 - 0.20053963521508203*lnbara*u2*y3 + 
     0.03965674612475661*u3*y3 + 0.046296296296296294*lnbara*u3*y3 - 
     0.005180952390253439*u4*y3 - 0.005269398380875331*lnbara*u4*y3 - 
     0.7890469882288804*x*y3 + 0.1930640563598377*u*x*y3 - 
     0.03868450042625529*u2*x*y3 + 0.0039961640397661365*u3*x*y3 + 
     0.14959121883334814*x2*y3 - 0.023984135578457844*u*x2*y3 + 
     0.002132338931514418*u2*x2*y3 - 0.029335300550687473*x3*y3 + 
     0.002040477336386972*u*x3*y3 + 0.0030845212777298402*x4*y3 - 
     0.11288380920852763*y4 - 0.29641276939959915*lnbara*y4 - 
     0.4166666666666667*lnbara2*y4 - 0.4586517155176459*u*y4 - 
     0.36653175786289616*lnbara*u*y4 + 0.05313376916634094*u2*y4 + 
     0.055892827564981824*lnbara*u2*y4 - 0.005180952390253439*u3*y4 - 
     0.005269398380875331*lnbara*u3*y4 + 0.4204576035750674*x*y4 - 
     0.05464120957277348*u*x*y4 + 0.004544934602470172*u2*x*y4 - 
     0.04080206621442954*x2*y4 + 0.0027837307223844915*u*x2*y4 + 
     0.0032290651917485417*x3*y4 + 0.16709945101716145*y5 + 
     0.32446036478491797*lnbara*y5 + 0.25*lnbara2*y5 + 
     0.16674120292053418*u*y5 + 0.11382143448700363*lnbara*u*y5 - 
     0.007891091272631587*u2*y5 - 0.00709100055854524*lnbara*u2*y5 - 
     0.13000573111514574*x*y5 + 0.006982104352137553*u*x*y5 + 
     0.005109481838882987*x2*y5 - 0.08961259612670759*y6 - 
     0.14609393309064053*lnbara*y6 - 0.08333333333333333*lnbara2*y6 - 
     0.02544609132471751*u*y6 - 0.01548483324024246*lnbara*u*y6 + 
     0.01763709312218411*x*y6 + 0.017552526521994072*y7 + 
     0.025294799938732206*lnbara*y7 + 0.011904761904761904*lnbara2*y7 + 
     0.033841063442545095*z - 0.38055555555555554*lnbara*z + 
     0.08333333333333333*lnbara2*z + 0.3196257377489796*u*z + 
     0.7813024128964863*lnbara*u*z - 0.5578052933863618*u2*z - 
     0.8333333333333334*lnbara*u2*z + 0.6756223290752225*u3*z + 
     0.6829286069220218*lnbara*u3*z - 0.4586517155176459*u4*z - 
     0.36653175786289616*lnbara*u4*z + 0.16674120292053418*u5*z + 
     0.11382143448700363*lnbara*u5*z - 0.02544609132471751*u6*z - 
     0.01548483324024246*lnbara*u6*z - 0.9316459611845606*x*z + 
     0.652012588820819*u*x*z - 0.4166666666666667*u2*x*z + 
     0.1930640563598377*u3*x*z - 0.05464120957277348*u4*x*z + 
     0.006982104352137553*u5*x*z + 0.7018651651305952*x2*z - 
     0.27476285099001274*u*x2*z + 0.09853650749005716*u2*x2*z - 
     0.023984135578457844*u3*x2*z + 0.0027837307223844915*u4*x2*z - 
     0.5191535535074602*x3*z + 0.10997735009782438*u*x3*z - 
     0.020528439060428574*u2*x3*z + 0.002040477336386972*u3*x3*z + 
     0.2668990274900491*x4*z - 0.02910056703093335*u*x4*z + 
     0.0022112103035087306*u2*x4*z - 0.08103467712428472*x5*z + 
     0.003583934630992194*u*x5*z + 0.010875415763170257*x6*z + 
     0.3196257377489796*y*z + 0.7813024128964863*lnbara*y*z - 
     0.018920104020269873*u*y*z - 0.5731787311490981*lnbara*u*y*z + 
     0.07792306711961054*u2*y*z + 0.3821191540993988*lnbara*u2*y*z - 
     0.07594530264631137*u3*y*z - 0.18157951888431673*lnbara*u3*y*z + 
     0.031971087672712485*u4*y*z + 0.0521706881608105*lnbara*u4*y*z - 
     0.005264576779103489*u5*y*z - 0.006730433928458395*lnbara*u5*y*z + 
     0.652012588820819*x*y*z - 0.3918579866365838*u*x*y*z + 
     0.1625255024128464*u2*x*y*z - 0.04222600241915521*u3*x*y*z + 
     0.005073357162376386*u4*x*y*z - 0.27476285099001274*x2*y*z + 
     0.10021047271633643*u*x2*y*z - 0.022684152990344954*u2*x2*y*z + 
     0.002463102816730127*u3*x2*y*z + 0.10997735009782438*x3*y*z - 
     0.021438675830201044*u*x3*y*z + 0.002015744197075201*u2*x3*y*z - 
     0.02910056703093335*x4*y*z + 0.0023360526619374596*u*x4*y*z + 
     0.003583934630992194*x5*y*z - 0.5578052933863618*y2*z - 
     0.8333333333333334*lnbara*y2*z + 0.07792306711961054*u*y2*z + 
     0.3821191540993988*lnbara*u*y2*z - 0.04211469895818599*u2*y2*z - 
     0.15040472641131153*lnbara*u2*y2*z + 0.016558064255232003*u3*y2*z + 
     0.03861907128134787*lnbara*u3*y2*z - 0.002680390234892856*u4*y2*z - 
     0.004629629629629629*lnbara*u4*y2*z - 0.4166666666666667*x*y2*z + 
     0.1625255024128464*u*x*y2*z - 0.038251172896884324*u2*x*y2*z + 
     0.004251592034047353*u3*x*y2*z + 0.09853650749005716*x2*y2*z - 
     0.022684152990344954*u*x2*y2*z + 0.002311902987232243*u2*x2*y2*z - 
     0.020528439060428574*x3*y2*z + 0.002015744197075201*u*x3*y2*z + 
     0.0022112103035087306*x4*y2*z + 0.6756223290752225*y3*z + 
     0.6829286069220218*lnbara*y3*z - 0.07594530264631137*u*y3*z - 
     0.18157951888431673*lnbara*u*y3*z + 0.016558064255232003*u2*y3*z + 
     0.03861907128134787*lnbara*u2*y3*z - 0.0022052910424952363*u3*y3*z - 
     0.004141109249293644*lnbara*u3*y3*z + 0.1930640563598377*x*y3*z - 
     0.04222600241915521*u*x*y3*z + 0.004251592034047353*u2*x*y3*z - 
     0.023984135578457844*x2*y3*z + 0.002463102816730127*u*x2*y3*z + 
     0.002040477336386972*x3*y3*z - 0.4586517155176459*y4*z - 
     0.36653175786289616*lnbara*y4*z + 0.031971087672712485*u*y4*z + 
     0.0521706881608105*lnbara*u*y4*z - 0.002680390234892856*u2*y4*z - 
     0.004629629629629629*lnbara*u2*y4*z - 0.05464120957277348*x*y4*z + 
     0.005073357162376386*u*x*y4*z + 0.0027837307223844915*x2*y4*z + 
     0.16674120292053418*y5*z + 0.11382143448700363*lnbara*y5*z - 
     0.005264576779103489*u*y5*z - 0.006730433928458395*lnbara*u*y5*z + 
     0.006982104352137553*x*y5*z - 0.02544609132471751*y6*z - 
     0.01548483324024246*lnbara*y6*z + 0.04467405251566538*z2 + 
     0.3603642537701804*lnbara*z2 - 0.25*lnbara2*z2 - 
     0.5578052933863618*u*z2 - 0.8333333333333334*lnbara*u*z2 + 
     0.27154889293341794*u2*z2 + 0.4512141792339346*lnbara*u2*z2 - 
     0.15468943943430513*u3*z2 - 0.20053963521508203*lnbara*u3*z2 + 
     0.05313376916634094*u4*z2 + 0.055892827564981824*lnbara*u4*z2 - 
     0.007891091272631587*u5*z2 - 0.00709100055854524*lnbara*u5*z2 + 
     0.9752371490099873*x*z2 - 0.4166666666666667*u*x*z2 + 
     0.1556046567637631*u2*x*z2 - 0.03868450042625529*u3*x*z2 + 
     0.004544934602470172*u4*x*z2 - 0.35023714900998726*x2*z2 + 
     0.09853650749005716*u*x2*z2 - 0.02042556903655505*u2*x2*z2 + 
     0.002132338931514418*u3*x2*z2 + 0.13495492518326768*x3*z2 - 
     0.020528439060428574*u*x3*z2 + 0.0017732108200787678*u2*x3*z2 - 
     0.03521176764840395*x4*z2 + 0.0022112103035087306*u*x4*z2 + 
     0.004307156641639393*x5*z2 - 0.5578052933863618*y*z2 - 
     0.8333333333333334*lnbara*y*z2 + 0.07792306711961054*u*y*z2 + 
     0.3821191540993988*lnbara*u*y*z2 - 0.04211469895818599*u2*y*z2 - 
     0.15040472641131153*lnbara*u2*y*z2 + 0.016558064255232003*u3*y*z2 + 
     0.03861907128134787*lnbara*u3*y*z2 - 0.002680390234892856*u4*y*z2 - 
     0.004629629629629629*lnbara*u4*y*z2 - 0.4166666666666667*x*y*z2 + 
     0.1625255024128464*u*x*y*z2 - 0.038251172896884324*u2*x*y*z2 + 
     0.004251592034047353*u3*x*y*z2 + 0.09853650749005716*x2*y*z2 - 
     0.022684152990344954*u*x2*y*z2 + 0.002311902987232243*u2*x2*y*z2 - 
     0.020528439060428574*x3*y*z2 + 0.002015744197075201*u*x3*y*z2 + 
     0.0022112103035087306*x4*y*z2 + 0.27154889293341794*y2*z2 + 
     0.4512141792339346*lnbara*y2*z2 - 0.04211469895818599*u*y2*z2 - 
     0.15040472641131153*lnbara*u*y2*z2 + 0.011566092640932137*u2*y2*
      z2 + 0.0345475125672679*lnbara*u2*y2*z2 - 
     0.001736111111111111*u3*y2*z2 - 0.003838612507474211*lnbara*u3*y2*
      z2 + 0.1556046567637631*x*y2*z2 - 0.038251172896884324*u*x*y2*z2 + 
     0.004058907359067862*u2*x*y2*z2 - 0.02042556903655505*x2*y2*z2 + 
     0.002311902987232243*u*x2*y2*z2 + 0.0017732108200787678*x3*y2*z2 - 
     0.15468943943430513*y3*z2 - 0.20053963521508203*lnbara*y3*z2 + 
     0.016558064255232003*u*y3*z2 + 0.03861907128134787*lnbara*u*y3*z2 - 
     0.001736111111111111*u2*y3*z2 - 0.003838612507474211*lnbara*u2*y3*
      z2 - 0.03868450042625529*x*y3*z2 + 0.004251592034047353*u*x*y3*
      z2 + 0.002132338931514418*x2*y3*z2 + 0.05313376916634094*y4*z2 + 
     0.055892827564981824*lnbara*y4*z2 - 0.002680390234892856*u*y4*z2 - 
     0.004629629629629629*lnbara*u*y4*z2 + 0.004544934602470172*x*y4*z2 - 
     0.007891091272631587*y5*z2 - 0.00709100055854524*lnbara*y5*z2 - 
     0.027665608271863516*z3 - 0.04505153406141173*lnbara*z3 + 
     0.4166666666666667*lnbara2*z3 + 0.6756223290752225*u*z3 + 
     0.6829286069220218*lnbara*u*z3 - 0.15468943943430513*u2*z3 - 
     0.20053963521508203*lnbara*u2*z3 + 0.03965674612475661*u3*z3 + 
     0.046296296296296294*lnbara*u3*z3 - 0.005180952390253439*u4*z3 - 
     0.005269398380875331*lnbara*u4*z3 - 0.7890469882288804*x*z3 + 
     0.1930640563598377*u*x*z3 - 0.03868450042625529*u2*x*z3 + 
     0.0039961640397661365*u3*x*z3 + 0.14959121883334814*x2*z3 - 
     0.023984135578457844*u*x2*z3 + 0.002132338931514418*u2*x2*z3 - 
     0.029335300550687473*x3*z3 + 0.002040477336386972*u*x3*z3 + 
     0.0030845212777298402*x4*z3 + 0.6756223290752225*y*z3 + 
     0.6829286069220218*lnbara*y*z3 - 0.07594530264631137*u*y*z3 - 
     0.18157951888431673*lnbara*u*y*z3 + 0.016558064255232003*u2*y*z3 + 
     0.03861907128134787*lnbara*u2*y*z3 - 0.0022052910424952363*u3*y*z3 - 
     0.004141109249293644*lnbara*u3*y*z3 + 0.1930640563598377*x*y*z3 - 
     0.04222600241915521*u*x*y*z3 + 0.004251592034047353*u2*x*y*z3 - 
     0.023984135578457844*x2*y*z3 + 0.002463102816730127*u*x2*y*z3 + 
     0.002040477336386972*x3*y*z3 - 0.15468943943430513*y2*z3 - 
     0.20053963521508203*lnbara*y2*z3 + 0.016558064255232003*u*y2*z3 + 
     0.03861907128134787*lnbara*u*y2*z3 - 0.001736111111111111*u2*y2*
      z3 - 0.003838612507474211*lnbara*u2*y2*z3 - 
     0.03868450042625529*x*y2*z3 + 0.004251592034047353*u*x*y2*z3 + 
     0.002132338931514418*x2*y2*z3 + 0.03965674612475661*y3*z3 + 
     0.046296296296296294*lnbara*y3*z3 - 0.0022052910424952363*u*y3*z3 - 
     0.004141109249293644*lnbara*u*y3*z3 + 0.0039961640397661365*x*y3*
      z3 - 0.005180952390253439*y4*z3 - 0.005269398380875331*lnbara*y4*
      z3 - 0.11288380920852763*z4 - 0.29641276939959915*lnbara*z4 - 
     0.4166666666666667*lnbara2*z4 - 0.4586517155176459*u*z4 - 
     0.36653175786289616*lnbara*u*z4 + 0.05313376916634094*u2*z4 + 
     0.055892827564981824*lnbara*u2*z4 - 0.005180952390253439*u3*z4 - 
     0.005269398380875331*lnbara*u3*z4 + 0.4204576035750674*x*z4 - 
     0.05464120957277348*u*x*z4 + 0.004544934602470172*u2*x*z4 - 
     0.04080206621442954*x2*z4 + 0.0027837307223844915*u*x2*z4 + 
     0.0032290651917485417*x3*z4 - 0.4586517155176459*y*z4 - 
     0.36653175786289616*lnbara*y*z4 + 0.031971087672712485*u*y*z4 + 
     0.0521706881608105*lnbara*u*y*z4 - 0.002680390234892856*u2*y*z4 - 
     0.004629629629629629*lnbara*u2*y*z4 - 0.05464120957277348*x*y*z4 + 
     0.005073357162376386*u*x*y*z4 + 0.0027837307223844915*x2*y*z4 + 
     0.05313376916634094*y2*z4 + 0.055892827564981824*lnbara*y2*z4 - 
     0.002680390234892856*u*y2*z4 - 0.004629629629629629*lnbara*u*y2*z4 + 
     0.004544934602470172*x*y2*z4 - 0.005180952390253439*y3*z4 - 
     0.005269398380875331*lnbara*y3*z4 + 0.16709945101716145*z5 + 
     0.32446036478491797*lnbara*z5 + 0.25*lnbara2*z5 + 
     0.16674120292053418*u*z5 + 0.11382143448700363*lnbara*u*z5 - 
     0.007891091272631587*u2*z5 - 0.00709100055854524*lnbara*u2*z5 - 
     0.13000573111514574*x*z5 + 0.006982104352137553*u*x*z5 + 
     0.005109481838882987*x2*z5 + 0.16674120292053418*y*z5 + 
     0.11382143448700363*lnbara*y*z5 - 0.005264576779103489*u*y*z5 - 
     0.006730433928458395*lnbara*u*y*z5 + 0.006982104352137553*x*y*z5 - 
     0.007891091272631587*y2*z5 - 0.00709100055854524*lnbara*y2*z5 - 
     0.08961259612670759*z6 - 0.14609393309064053*lnbara*z6 - 
     0.08333333333333333*lnbara2*z6 - 0.02544609132471751*u*z6 - 
     0.01548483324024246*lnbara*u*z6 + 0.01763709312218411*x*z6 - 
     0.02544609132471751*y*z6 - 0.01548483324024246*lnbara*y*z6 + 
     0.017552526521994072*z7 + 0.025294799938732206*lnbara*z7 + 
     0.011904761904761904*lnbara2*z7;
 
  Fbarexp[8] = -0.10626438943986569 + 0.14910714285714285*lnbara - 
     0.026785714285714284*lnbara2 + 0.08337170517297515*u - 0.35*lnbara*u + 
     0.07142857142857142*lnbara2*u - 0.015386656446031351*u2 + 
     0.4436975871035137*lnbara*u2 - 0.25*lnbara2*u2 - 
     0.02418842311395387*u3 - 0.22072850754036075*lnbara*u3 + 
     0.5*lnbara2*u3 - 0.09522252146289166*u4 - 0.23628582076606544*lnbara*
      u4 - 0.625*lnbara2*u4 + 0.22604544710601693*u5 + 
     0.4822540629031693*lnbara*u5 + 0.5*lnbara2*u5 - 
     0.1957908218348025*u6 - 0.35494846593858825*lnbara*u6 - 
     0.25*lnbara2*u6 + 0.08002035919323222*u7 + 0.12795927582286945*lnbara*
      u7 + 0.07142857142857142*lnbara2*u7 - 0.012974162169876576*u8 - 
     0.01879653368685981*lnbara*u8 - 0.008928571428571428*lnbara2*u8 + 
     0.6*x - 0.14285714285714285*lnbara*x - 0.9316459611845606*u*x + 
     1.1702845788119847*u2*x - 1.1835704823433206*u3*x + 
     0.8409152071501348*u4*x - 0.3900171933454372*u5*x + 
     0.10582255873310466*u6*x - 0.012739270908917709*u7*x - 
     0.7025310582231592*x2 + 0.5*lnbara*x2 + 0.8422381981567142*u*x2 - 
     0.5253557235149809*u2*x2 + 0.2991824376666963*u3*x2 - 
     0.12240619864328864*u4*x2 + 0.030656891033297922*u5*x2 - 
     0.0034920303557606663*u6*x2 + 0.5628239182896042*x3 - 1.*lnbara*x3 - 
     0.7787303302611903*u*x3 + 0.26990985036653536*u2*x3 - 
     0.08800590165206242*u3*x3 + 0.019374391150491253*u4*x3 - 
     0.002032085124576991*u5*x3 - 0.11948215016611251*x4 + 
     1.25*lnbara*x4 + 0.5337980549800982*u*x4 - 0.10563530294521185*u2*
      x4 + 0.01850712766637904*u3*x4 - 0.0017045245923250636*u4*x4 - 
     0.2246931128551689*x5 - 1.*lnbara*x5 - 0.24310403137285416*u*x5 + 
     0.02584293984983636*u2*x5 - 0.0018937975809947979*u3*x5 + 
     0.23389857211401155*x6 + 0.5*lnbara*x6 + 0.06525249457902155*u*x6 - 
     0.002902179150693661*u2*x6 - 0.09479351828072682*x7 - 
     0.14285714285714285*lnbara*x7 - 0.007799923166908395*u*x7 + 
     0.014774160972681501*x8 + 0.017857142857142856*lnbara*x8 + 
     0.08337170517297515*y - 0.35*lnbara*y + 0.07142857142857142*lnbara2*y + 
     0.18940866893289857*u*y + 0.7813024128964863*lnbara*u*y - 
     0.5026996853969675*u2*y - 1.*lnbara*u2*y + 0.8427013418823283*u3*y + 
     1.0243929103830327*lnbara*u3*y - 0.7951261784143264*u4*y - 
     0.7330635157257923*lnbara*u4*y + 0.4433128915181007*u5*y + 
     0.3414643034610109*lnbara*u5*y - 0.1371917147080626*u6*y - 
     0.09290899944145475*lnbara*u6*y + 0.018256104537349046*u7*y + 
     0.011206496836004519*lnbara*u7*y - 0.9316459611845606*x*y + 
     0.7824151065849828*u*x*y - 0.625*u2*x*y + 0.3861281127196754*u3*x*y - 
     0.16392362871832045*u4*x*y + 0.041892626112825314*u5*x*y - 
     0.0048318008295796825*u6*x*y + 0.8422381981567142*x2*y - 
     0.4121442764850191*u*x2*y + 0.1970730149801143*u2*x2*y - 
     0.07195240673537354*u3*x2*y + 0.01670238433430695*u4*x2*y - 
     0.0018042267625014755*u5*x2*y - 0.7787303302611903*x3*y + 
     0.21995470019564875*u*x3*y - 0.06158531718128572*u2*x3*y + 
     0.012242864018321833*u3*x3*y - 0.0011979335791530209*u4*x3*y + 
     0.5337980549800982*x4*y - 0.08730170109280005*u*x4*y + 
     0.013267261821052385*u2*x4*y - 0.0011100206960523984*u3*x4*y - 
     0.24310403137285416*x5*y + 0.02150360778595316*u*x5*y - 
     0.0013742361013450004*u2*x5*y + 0.06525249457902155*x6*y - 
     0.002424337054637728*u*x6*y - 0.007799923166908395*x7*y - 
     0.015386656446031351*y2 + 0.4436975871035137*lnbara*y2 - 
     0.25*lnbara2*y2 - 0.5026996853969675*u*y2 - 1.*lnbara*u*y2 + 
     0.29451979459164324*u2*y2 + 0.6768212688509019*lnbara*u2*y2 - 
     0.24253233379691627*u3*y2 - 0.40107927043016406*lnbara*u3*y2 + 
     0.1314548937165319*u4*y2 + 0.16767848269494548*lnbara*u4*y2 - 
     0.04025554707724428*u5*y2 - 0.04254600335127144*lnbara*u5*y2 + 
     0.005326516205331389*u6*y2 + 0.004887855481301699*lnbara*u6*y2 + 
     1.1702845788119847*x*y2 - 0.625*u*x*y2 + 0.3112093135275262*u2*x*
      y2 - 0.11605350127876586*u3*x*y2 + 0.027269607614821036*u4*x*y2 - 
     0.002968292254510239*u5*x*y2 - 0.5253557235149809*x2*y2 + 
     0.1970730149801143*u*x2*y2 - 0.06127670710966516*u2*x2*y2 + 
     0.012794033589086507*u3*x2*y2 - 0.0012856369475801259*u4*x2*y2 + 
     0.26990985036653536*x3*y2 - 0.06158531718128572*u*x3*y2 + 
     0.010639264920472607*u2*x3*y2 - 0.0009464600952786589*u3*x3*y2 - 
     0.10563530294521185*x4*y2 + 0.013267261821052385*u*x4*y2 - 
     0.0009735837207608611*u2*x4*y2 + 0.02584293984983636*x5*y2 - 
     0.0013742361013450004*u*x5*y2 - 0.002902179150693661*x6*y2 - 
     0.02418842311395387*y3 - 0.22072850754036075*lnbara*y3 + 
     0.5*lnbara2*y3 + 0.8427013418823283*u*y3 + 1.0243929103830327*lnbara*
      u*y3 - 0.24253233379691627*u2*y3 - 0.40107927043016406*lnbara*u2*
      y3 + 0.09582209022612168*u3*y3 + 0.1388888888888889*lnbara*u3*y3 - 
     0.025816315960645302*u4*y3 - 0.03161639028525199*lnbara*u4*y3 + 
     0.0031926388953996293*u5*y3 + 0.003384978503667747*lnbara*u5*y3 - 
     1.1835704823433206*x*y3 + 0.3861281127196754*u*x*y3 - 
     0.11605350127876586*u2*x*y3 + 0.02397698423859682*u3*x*y3 - 
     0.0024003011749299604*u4*x*y3 + 0.2991824376666963*x2*y3 - 
     0.07195240673537354*u*x2*y3 + 0.012794033589086507*u2*x2*y3 - 
     0.0011574074074074073*u3*x2*y3 - 0.08800590165206242*x3*y3 + 
     0.012242864018321833*u*x3*y3 - 0.0009464600952786589*u2*x3*y3 + 
     0.01850712766637904*x4*y3 - 0.0011100206960523984*u*x4*y3 - 
     0.0018937975809947979*x5*y3 - 0.09522252146289166*y4 - 
     0.23628582076606544*lnbara*y4 - 0.625*lnbara2*y4 - 
     0.7951261784143264*u*y4 - 0.7330635157257923*lnbara*u*y4 + 
     0.1314548937165319*u2*y4 + 0.16767848269494548*lnbara*u2*y4 - 
     0.025816315960645302*u3*y4 - 0.03161639028525199*lnbara*u3*y4 + 
     0.0027549479207358792*u4*y4 + 0.0030360036294498475*lnbara*u4*y4 + 
     0.8409152071501348*x*y4 - 0.16392362871832045*u*x*y4 + 
     0.027269607614821036*u2*x*y4 - 0.0024003011749299604*u3*x*y4 - 
     0.12240619864328864*x2*y4 + 0.01670238433430695*u*x2*y4 - 
     0.0012856369475801259*u2*x2*y4 + 0.019374391150491253*x3*y4 - 
     0.0011979335791530209*u*x3*y4 - 0.0017045245923250636*x4*y4 + 
     0.22604544710601693*y5 + 0.4822540629031693*lnbara*y5 + 
     0.5*lnbara2*y5 + 0.4433128915181007*u*y5 + 0.3414643034610109*lnbara*
      u*y5 - 0.04025554707724428*u2*y5 - 0.04254600335127144*lnbara*u2*
      y5 + 0.0031926388953996293*u3*y5 + 0.003384978503667747*lnbara*u3*
      y5 - 0.3900171933454372*x*y5 + 0.041892626112825314*u*x*y5 - 
     0.002968292254510239*u2*x*y5 + 0.030656891033297922*x2*y5 - 
     0.0018042267625014755*u*x2*y5 - 0.002032085124576991*x3*y5 - 
     0.1957908218348025*y6 - 0.35494846593858825*lnbara*y6 - 
     0.25*lnbara2*y6 - 0.1371917147080626*u*y6 - 
     0.09290899944145475*lnbara*u*y6 + 0.005326516205331389*u2*y6 + 
     0.004887855481301699*lnbara*u2*y6 + 0.10582255873310466*x*y6 - 
     0.0048318008295796825*u*x*y6 - 0.0034920303557606663*x2*y6 + 
     0.08002035919323222*y7 + 0.12795927582286945*lnbara*y7 + 
     0.07142857142857142*lnbara2*y7 + 0.018256104537349046*u*y7 + 
     0.011206496836004519*lnbara*u*y7 - 0.012739270908917709*x*y7 - 
     0.012974162169876576*y8 - 0.01879653368685981*lnbara*y8 - 
     0.008928571428571428*lnbara2*y8 + 0.08337170517297515*z - 
     0.35*lnbara*z + 0.07142857142857142*lnbara2*z + 
     0.18940866893289857*u*z + 0.7813024128964863*lnbara*u*z - 
     0.5026996853969675*u2*z - 1.*lnbara*u2*z + 0.8427013418823283*u3*z + 
     1.0243929103830327*lnbara*u3*z - 0.7951261784143264*u4*z - 
     0.7330635157257923*lnbara*u4*z + 0.4433128915181007*u5*z + 
     0.3414643034610109*lnbara*u5*z - 0.1371917147080626*u6*z - 
     0.09290899944145475*lnbara*u6*z + 0.018256104537349046*u7*z + 
     0.011206496836004519*lnbara*u7*z - 0.9316459611845606*x*z + 
     0.7824151065849828*u*x*z - 0.625*u2*x*z + 0.3861281127196754*u3*x*z - 
     0.16392362871832045*u4*x*z + 0.041892626112825314*u5*x*z - 
     0.0048318008295796825*u6*x*z + 0.8422381981567142*x2*z - 
     0.4121442764850191*u*x2*z + 0.1970730149801143*u2*x2*z - 
     0.07195240673537354*u3*x2*z + 0.01670238433430695*u4*x2*z - 
     0.0018042267625014755*u5*x2*z - 0.7787303302611903*x3*z + 
     0.21995470019564875*u*x3*z - 0.06158531718128572*u2*x3*z + 
     0.012242864018321833*u3*x3*z - 0.0011979335791530209*u4*x3*z + 
     0.5337980549800982*x4*z - 0.08730170109280005*u*x4*z + 
     0.013267261821052385*u2*x4*z - 0.0011100206960523984*u3*x4*z - 
     0.24310403137285416*x5*z + 0.02150360778595316*u*x5*z - 
     0.0013742361013450004*u2*x5*z + 0.06525249457902155*x6*z - 
     0.002424337054637728*u*x6*z - 0.007799923166908395*x7*z + 
     0.18940866893289857*y*z + 0.7813024128964863*lnbara*y*z + 
     0.09193162140549578*u*y*z - 0.6878144773789178*lnbara*u*y*z + 
     0.02135481215456613*u2*y*z + 0.5731787311490981*lnbara*u2*y*z - 
     0.0913640989978505*u3*y*z - 0.36315903776863345*lnbara*u3*y*z + 
     0.06982791893773221*u4*y*z + 0.1565120644824315*lnbara*u4*y*z - 
     0.024857026746162542*u5*y*z - 0.040382603570750374*lnbara*u5*y*z + 
     0.0035777513655361887*u6*y*z + 0.004687810626819727*lnbara*u6*y*z + 
     0.7824151065849828*x*y*z - 0.5877869799548757*u*x*y*z + 
     0.3250510048256928*u2*x*y*z - 0.12667800725746564*u3*x*y*z + 
     0.03044014297425832*u4*x*y*z - 0.0033567831013237934*u5*x*y*z - 
     0.4121442764850191*x2*y*z + 0.20042094543267286*u*x2*y*z - 
     0.06805245897103486*u2*x2*y*z + 0.014778616900380764*u3*x2*y*z - 
     0.0015161758891802588*u4*x2*y*z + 0.21995470019564875*x3*y*z - 
     0.06431602749060313*u*x3*y*z + 0.012094465182451206*u2*x3*y*z - 
     0.001118126726942837*u3*x3*y*z - 0.08730170109280005*x4*y*z + 
     0.014016315971624758*u*x4*y*z - 0.0011188517846484648*u2*x4*y*z + 
     0.02150360778595316*x5*y*z - 0.0014606410527467938*u*x5*y*z - 
     0.002424337054637728*x6*y*z - 0.5026996853969675*y2*z - 
     1.*lnbara*y2*z + 0.02135481215456613*u*y2*z + 
     0.5731787311490981*lnbara*u*y2*z - 0.03409448911260147*u2*y2*z - 
     0.30080945282262306*lnbara*u2*y2*z + 0.030364657125022076*u3*y2*z + 
     0.11585721384404363*lnbara*u3*y2*z - 0.011452711779727507*u4*y2*z - 
     0.027777777777777776*lnbara*u4*y2*z + 0.001686825413567301*u5*y2*z + 
     0.0030639349524580017*lnbara*u5*y2*z - 0.625*x*y2*z + 
     0.3250510048256928*u*x*y2*z - 0.11475351869065298*u2*x*y2*z + 
     0.025509552204284115*u3*x*y2*z - 0.0026559689223197088*u4*x*y2*z + 
     0.1970730149801143*x2*y2*z - 0.06805245897103486*u*x2*y2*z + 
     0.013871417923393456*u2*x2*y2*z - 0.0013398832907078044*u3*x2*y2*
      z - 0.06158531718128572*x3*y2*z + 0.012094465182451206*u*x3*y2*z - 
     0.001066169465757209*u2*x3*y2*z + 0.013267261821052385*x4*y2*z - 
     0.0011188517846484648*u*x4*y2*z - 0.0013742361013450004*x5*y2*z + 
     0.8427013418823283*y3*z + 1.0243929103830327*lnbara*y3*z - 
     0.0913640989978505*u*y3*z - 0.36315903776863345*lnbara*u*y3*z + 
     0.030364657125022076*u2*y3*z + 0.11585721384404363*lnbara*u2*y3*z - 
     0.009090637005677775*u3*y3*z - 0.024846655495761868*lnbara*u3*y3*z + 
     0.001233630975633597*u4*y3*z + 0.0025474832491138625*lnbara*u4*y3*
      z + 0.3861281127196754*x*y3*z - 0.12667800725746564*u*x*y3*z + 
     0.025509552204284115*u2*x*y3*z - 0.0024597600243423225*u3*x*y3*z - 
     0.07195240673537354*x2*y3*z + 0.014778616900380764*u*x2*y3*z - 
     0.0013398832907078044*u2*x2*y3*z + 0.012242864018321833*x3*y3*z - 
     0.001118126726942837*u*x3*y3*z - 0.0011100206960523984*x4*y3*z - 
     0.7951261784143264*y4*z - 0.7330635157257923*lnbara*y4*z + 
     0.06982791893773221*u*y4*z + 0.1565120644824315*lnbara*u*y4*z - 
     0.011452711779727507*u2*y4*z - 0.027777777777777776*lnbara*u2*y4*z + 
     0.001233630975633597*u3*y4*z + 0.0025474832491138625*lnbara*u3*y4*
      z - 0.16392362871832045*x*y4*z + 0.03044014297425832*u*x*y4*z - 
     0.0026559689223197088*u2*x*y4*z + 0.01670238433430695*x2*y4*z - 
     0.0015161758891802588*u*x2*y4*z - 0.0011979335791530209*x3*y4*z + 
     0.4433128915181007*y5*z + 0.3414643034610109*lnbara*y5*z - 
     0.024857026746162542*u*y5*z - 0.040382603570750374*lnbara*u*y5*z + 
     0.001686825413567301*u2*y5*z + 0.0030639349524580017*lnbara*u2*y5*
      z + 0.041892626112825314*x*y5*z - 0.0033567831013237934*u*x*y5*z - 
     0.0018042267625014755*x2*y5*z - 0.1371917147080626*y6*z - 
     0.09290899944145475*lnbara*y6*z + 0.0035777513655361887*u*y6*z + 
     0.004687810626819727*lnbara*u*y6*z - 0.0048318008295796825*x*y6*z + 
     0.018256104537349046*y7*z + 0.011206496836004519*lnbara*y7*z - 
     0.015386656446031351*z2 + 0.4436975871035137*lnbara*z2 - 
     0.25*lnbara2*z2 - 0.5026996853969675*u*z2 - 1.*lnbara*u*z2 + 
     0.29451979459164324*u2*z2 + 0.6768212688509019*lnbara*u2*z2 - 
     0.24253233379691627*u3*z2 - 0.40107927043016406*lnbara*u3*z2 + 
     0.1314548937165319*u4*z2 + 0.16767848269494548*lnbara*u4*z2 - 
     0.04025554707724428*u5*z2 - 0.04254600335127144*lnbara*u5*z2 + 
     0.005326516205331389*u6*z2 + 0.004887855481301699*lnbara*u6*z2 + 
     1.1702845788119847*x*z2 - 0.625*u*x*z2 + 0.3112093135275262*u2*x*
      z2 - 0.11605350127876586*u3*x*z2 + 0.027269607614821036*u4*x*z2 - 
     0.002968292254510239*u5*x*z2 - 0.5253557235149809*x2*z2 + 
     0.1970730149801143*u*x2*z2 - 0.06127670710966516*u2*x2*z2 + 
     0.012794033589086507*u3*x2*z2 - 0.0012856369475801259*u4*x2*z2 + 
     0.26990985036653536*x3*z2 - 0.06158531718128572*u*x3*z2 + 
     0.010639264920472607*u2*x3*z2 - 0.0009464600952786589*u3*x3*z2 - 
     0.10563530294521185*x4*z2 + 0.013267261821052385*u*x4*z2 - 
     0.0009735837207608611*u2*x4*z2 + 0.02584293984983636*x5*z2 - 
     0.0013742361013450004*u*x5*z2 - 0.002902179150693661*x6*z2 - 
     0.5026996853969675*y*z2 - 1.*lnbara*y*z2 + 0.02135481215456613*u*y*
      z2 + 0.5731787311490981*lnbara*u*y*z2 - 0.03409448911260147*u2*y*
      z2 - 0.30080945282262306*lnbara*u2*y*z2 + 0.030364657125022076*u3*y*
      z2 + 0.11585721384404363*lnbara*u3*y*z2 - 0.011452711779727507*u4*y*
      z2 - 0.027777777777777776*lnbara*u4*y*z2 + 
     0.001686825413567301*u5*y*z2 + 0.0030639349524580017*lnbara*u5*y*
      z2 - 0.625*x*y*z2 + 0.3250510048256928*u*x*y*z2 - 
     0.11475351869065298*u2*x*y*z2 + 0.025509552204284115*u3*x*y*z2 - 
     0.0026559689223197088*u4*x*y*z2 + 0.1970730149801143*x2*y*z2 - 
     0.06805245897103486*u*x2*y*z2 + 0.013871417923393456*u2*x2*y*z2 - 
     0.0013398832907078044*u3*x2*y*z2 - 0.06158531718128572*x3*y*z2 + 
     0.012094465182451206*u*x3*y*z2 - 0.001066169465757209*u2*x3*y*z2 + 
     0.013267261821052385*x4*y*z2 - 0.0011188517846484648*u*x4*y*z2 - 
     0.0013742361013450004*x5*y*z2 + 0.29451979459164324*y2*z2 + 
     0.6768212688509019*lnbara*y2*z2 - 0.03409448911260147*u*y2*z2 - 
     0.30080945282262306*lnbara*u*y2*z2 + 0.017424521639162464*u2*y2*
      z2 + 0.10364253770180369*lnbara*u2*y2*z2 - 
     0.006578054159192456*u3*y2*z2 - 0.023031675044845268*lnbara*u3*y2*
      z2 + 0.0009868303536549605*u4*y2*z2 + 0.0024078266340730905*lnbara*
      u4*y2*z2 + 0.3112093135275262*x*y2*z2 - 0.11475351869065298*u*x*
      y2*z2 + 0.024353444154407173*u2*x*y2*z2 - 
     0.002413314930281352*u3*x*y2*z2 - 0.06127670710966516*x2*y2*z2 + 
     0.013871417923393456*u*x2*y2*z2 - 0.0013168048909375015*u2*x2*y2*
      z2 + 0.010639264920472607*x3*y2*z2 - 0.001066169465757209*u*x3*y2*
      z2 - 0.0009735837207608611*x4*y2*z2 - 0.24253233379691627*y3*z2 - 
     0.40107927043016406*lnbara*y3*z2 + 0.030364657125022076*u*y3*z2 + 
     0.11585721384404363*lnbara*u*y3*z2 - 0.006578054159192456*u2*y3*
      z2 - 0.023031675044845268*lnbara*u2*y3*z2 + 
     0.000840674612475661*u3*y3*z2 + 0.002233394751425484*lnbara*u3*y3*
      z2 - 0.11605350127876586*x*y3*z2 + 0.025509552204284115*u*x*y3*
      z2 - 0.002413314930281352*u2*x*y3*z2 + 0.012794033589086507*x2*y3*
      z2 - 0.0013398832907078044*u*x2*y3*z2 - 0.0009464600952786589*x3*
      y3*z2 + 0.1314548937165319*y4*z2 + 0.16767848269494548*lnbara*y4*
      z2 - 0.011452711779727507*u*y4*z2 - 0.027777777777777776*lnbara*u*
      y4*z2 + 0.0009868303536549605*u2*y4*z2 + 
     0.0024078266340730905*lnbara*u2*y4*z2 + 0.027269607614821036*x*y4*
      z2 - 0.0026559689223197088*u*x*y4*z2 - 0.0012856369475801259*x2*y4*
      z2 - 0.04025554707724428*y5*z2 - 0.04254600335127144*lnbara*y5*
      z2 + 0.001686825413567301*u*y5*z2 + 0.0030639349524580017*lnbara*u*
      y5*z2 - 0.002968292254510239*x*y5*z2 + 0.005326516205331389*y6*
      z2 + 0.004887855481301699*lnbara*y6*z2 - 0.02418842311395387*z3 - 
     0.22072850754036075*lnbara*z3 + 0.5*lnbara2*z3 + 
     0.8427013418823283*u*z3 + 1.0243929103830327*lnbara*u*z3 - 
     0.24253233379691627*u2*z3 - 0.40107927043016406*lnbara*u2*z3 + 
     0.09582209022612168*u3*z3 + 0.1388888888888889*lnbara*u3*z3 - 
     0.025816315960645302*u4*z3 - 0.03161639028525199*lnbara*u4*z3 + 
     0.0031926388953996293*u5*z3 + 0.003384978503667747*lnbara*u5*z3 - 
     1.1835704823433206*x*z3 + 0.3861281127196754*u*x*z3 - 
     0.11605350127876586*u2*x*z3 + 0.02397698423859682*u3*x*z3 - 
     0.0024003011749299604*u4*x*z3 + 0.2991824376666963*x2*z3 - 
     0.07195240673537354*u*x2*z3 + 0.012794033589086507*u2*x2*z3 - 
     0.0011574074074074073*u3*x2*z3 - 0.08800590165206242*x3*z3 + 
     0.012242864018321833*u*x3*z3 - 0.0009464600952786589*u2*x3*z3 + 
     0.01850712766637904*x4*z3 - 0.0011100206960523984*u*x4*z3 - 
     0.0018937975809947979*x5*z3 + 0.8427013418823283*y*z3 + 
     1.0243929103830327*lnbara*y*z3 - 0.0913640989978505*u*y*z3 - 
     0.36315903776863345*lnbara*u*y*z3 + 0.030364657125022076*u2*y*z3 + 
     0.11585721384404363*lnbara*u2*y*z3 - 0.009090637005677775*u3*y*z3 - 
     0.024846655495761868*lnbara*u3*y*z3 + 0.001233630975633597*u4*y*z3 + 
     0.0025474832491138625*lnbara*u4*y*z3 + 0.3861281127196754*x*y*z3 - 
     0.12667800725746564*u*x*y*z3 + 0.025509552204284115*u2*x*y*z3 - 
     0.0024597600243423225*u3*x*y*z3 - 0.07195240673537354*x2*y*z3 + 
     0.014778616900380764*u*x2*y*z3 - 0.0013398832907078044*u2*x2*y*z3 + 
     0.012242864018321833*x3*y*z3 - 0.001118126726942837*u*x3*y*z3 - 
     0.0011100206960523984*x4*y*z3 - 0.24253233379691627*y2*z3 - 
     0.40107927043016406*lnbara*y2*z3 + 0.030364657125022076*u*y2*z3 + 
     0.11585721384404363*lnbara*u*y2*z3 - 0.006578054159192456*u2*y2*
      z3 - 0.023031675044845268*lnbara*u2*y2*z3 + 
     0.000840674612475661*u3*y2*z3 + 0.002233394751425484*lnbara*u3*y2*
      z3 - 0.11605350127876586*x*y2*z3 + 0.025509552204284115*u*x*y2*
      z3 - 0.002413314930281352*u2*x*y2*z3 + 0.012794033589086507*x2*y2*
      z3 - 0.0013398832907078044*u*x2*y2*z3 - 0.0009464600952786589*x3*
      y2*z3 + 0.09582209022612168*y3*z3 + 0.1388888888888889*lnbara*y3*
      z3 - 0.009090637005677775*u*y3*z3 - 0.024846655495761868*lnbara*u*
      y3*z3 + 0.000840674612475661*u2*y3*z3 + 0.002233394751425484*
      lnbara*u2*y3*z3 + 0.02397698423859682*x*y3*z3 - 
     0.0024597600243423225*u*x*y3*z3 - 0.0011574074074074073*x2*y3*z3 - 
     0.025816315960645302*y4*z3 - 0.03161639028525199*lnbara*y4*z3 + 
     0.001233630975633597*u*y4*z3 + 0.0025474832491138625*lnbara*u*y4*
      z3 - 0.0024003011749299604*x*y4*z3 + 0.0031926388953996293*y5*z3 + 
     0.003384978503667747*lnbara*y5*z3 - 0.09522252146289166*z4 - 
     0.23628582076606544*lnbara*z4 - 0.625*lnbara2*z4 - 
     0.7951261784143264*u*z4 - 0.7330635157257923*lnbara*u*z4 + 
     0.1314548937165319*u2*z4 + 0.16767848269494548*lnbara*u2*z4 - 
     0.025816315960645302*u3*z4 - 0.03161639028525199*lnbara*u3*z4 + 
     0.0027549479207358792*u4*z4 + 0.0030360036294498475*lnbara*u4*z4 + 
     0.8409152071501348*x*z4 - 0.16392362871832045*u*x*z4 + 
     0.027269607614821036*u2*x*z4 - 0.0024003011749299604*u3*x*z4 - 
     0.12240619864328864*x2*z4 + 0.01670238433430695*u*x2*z4 - 
     0.0012856369475801259*u2*x2*z4 + 0.019374391150491253*x3*z4 - 
     0.0011979335791530209*u*x3*z4 - 0.0017045245923250636*x4*z4 - 
     0.7951261784143264*y*z4 - 0.7330635157257923*lnbara*y*z4 + 
     0.06982791893773221*u*y*z4 + 0.1565120644824315*lnbara*u*y*z4 - 
     0.011452711779727507*u2*y*z4 - 0.027777777777777776*lnbara*u2*y*z4 + 
     0.001233630975633597*u3*y*z4 + 0.0025474832491138625*lnbara*u3*y*
      z4 - 0.16392362871832045*x*y*z4 + 0.03044014297425832*u*x*y*z4 - 
     0.0026559689223197088*u2*x*y*z4 + 0.01670238433430695*x2*y*z4 - 
     0.0015161758891802588*u*x2*y*z4 - 0.0011979335791530209*x3*y*z4 + 
     0.1314548937165319*y2*z4 + 0.16767848269494548*lnbara*y2*z4 - 
     0.011452711779727507*u*y2*z4 - 0.027777777777777776*lnbara*u*y2*z4 + 
     0.0009868303536549605*u2*y2*z4 + 0.0024078266340730905*lnbara*u2*y2*
      z4 + 0.027269607614821036*x*y2*z4 - 0.0026559689223197088*u*x*y2*
      z4 - 0.0012856369475801259*x2*y2*z4 - 0.025816315960645302*y3*
      z4 - 0.03161639028525199*lnbara*y3*z4 + 0.001233630975633597*u*y3*
      z4 + 0.0025474832491138625*lnbara*u*y3*z4 - 
     0.0024003011749299604*x*y3*z4 + 0.0027549479207358792*y4*z4 + 
     0.0030360036294498475*lnbara*y4*z4 + 0.22604544710601693*z5 + 
     0.4822540629031693*lnbara*z5 + 0.5*lnbara2*z5 + 
     0.4433128915181007*u*z5 + 0.3414643034610109*lnbara*u*z5 - 
     0.04025554707724428*u2*z5 - 0.04254600335127144*lnbara*u2*z5 + 
     0.0031926388953996293*u3*z5 + 0.003384978503667747*lnbara*u3*z5 - 
     0.3900171933454372*x*z5 + 0.041892626112825314*u*x*z5 - 
     0.002968292254510239*u2*x*z5 + 0.030656891033297922*x2*z5 - 
     0.0018042267625014755*u*x2*z5 - 0.002032085124576991*x3*z5 + 
     0.4433128915181007*y*z5 + 0.3414643034610109*lnbara*y*z5 - 
     0.024857026746162542*u*y*z5 - 0.040382603570750374*lnbara*u*y*z5 + 
     0.001686825413567301*u2*y*z5 + 0.0030639349524580017*lnbara*u2*y*
      z5 + 0.041892626112825314*x*y*z5 - 0.0033567831013237934*u*x*y*z5 - 
     0.0018042267625014755*x2*y*z5 - 0.04025554707724428*y2*z5 - 
     0.04254600335127144*lnbara*y2*z5 + 0.001686825413567301*u*y2*z5 + 
     0.0030639349524580017*lnbara*u*y2*z5 - 0.002968292254510239*x*y2*
      z5 + 0.0031926388953996293*y3*z5 + 0.003384978503667747*lnbara*y3*
      z5 - 0.1957908218348025*z6 - 0.35494846593858825*lnbara*z6 - 
     0.25*lnbara2*z6 - 0.1371917147080626*u*z6 - 
     0.09290899944145475*lnbara*u*z6 + 0.005326516205331389*u2*z6 + 
     0.004887855481301699*lnbara*u2*z6 + 0.10582255873310466*x*z6 - 
     0.0048318008295796825*u*x*z6 - 0.0034920303557606663*x2*z6 - 
     0.1371917147080626*y*z6 - 0.09290899944145475*lnbara*y*z6 + 
     0.0035777513655361887*u*y*z6 + 0.004687810626819727*lnbara*u*y*z6 - 
     0.0048318008295796825*x*y*z6 + 0.005326516205331389*y2*z6 + 
     0.004887855481301699*lnbara*y2*z6 + 0.08002035919323222*z7 + 
     0.12795927582286945*lnbara*z7 + 0.07142857142857142*lnbara2*z7 + 
     0.018256104537349046*u*z7 + 0.011206496836004519*lnbara*u*z7 - 
     0.012739270908917709*x*z7 + 0.018256104537349046*y*z7 + 
     0.011206496836004519*lnbara*y*z7 - 0.012974162169876576*z8 - 
     0.01879653368685981*lnbara*z8 - 0.008928571428571428*lnbara2*z8;

  ttothei = 1.0L;
  result = Fbarexp[0];

  for (i=1; i<nTerms; i++) {
    ttothei *= tinit;
    result += Fbarexp[i]*ttothei;
  }
  foo->value = _a * result;

  ttothei = 1.0L;
  result = Fbarexp[1];

  for (i=2; i<nTerms; i++) {
    ttothei *= tinit;
    result += i*Fbarexp[i]*ttothei;
  }
  foo->deriv = _a * result;

  return 0;
}
