/* General header for "internal" use */

#include "3vil.h"
#include "3vil_funcs.h"
#include "3vil_global.h"
#include "3vil_params.h"
/* #include "3vil_names.h" */

#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>

#ifndef PI
#define PI      3.1415926535897932385L
#endif
#define PI2     9.8696044010893586188L
#define LN2     0.69314718055994530942L
#define SQRT2   1.4142135623730950488L
#define SQRT3   1.7320508075688772935L
#define CUBERT2 1.2599210498948731648L
#define Zeta2   1.644934066848226436472415166646025189219L
#define Zeta3   1.202056903159594285399738161511449990765L
#define LS2     0.67662773760643575001413503618301352396112620502020L
#define LS3    -2.1447672125694943914826421122153512974711431057868L
#define LSP4   -0.49767555160664719605829895429509963073508410781489L
#define A4TRANS 0.51747906167389938633075816189886294562237747514138L

#define TVIL_ComplexInfinity ((1.0L + 1.0L*I)/0.0L)
#define TVIL_Infinity (1.0L/0.0L)

enum {FALSE, TRUE};
enum {NO, YES};

extern TVIL_REAL a, a2, a3, a4, a5, a6, a7, a8, a9;
extern TVIL_REAL maxerr, err_H, maxerr_noH;

#define SAME2(arg1,arg2) ((TVIL_FABS(arg1 - arg2)) < TVIL_TOL)
#define SAME3(arg1,arg2,arg3) (((TVIL_FABS(arg1 - arg2)) < TVIL_TOL) && \
                         ((TVIL_FABS(arg2 - arg3)) < TVIL_TOL))
#define SAME4(arg1,arg2,arg3,arg4) (((TVIL_FABS(arg1 - arg2)) < TVIL_TOL) && \
                            ((TVIL_FABS(arg2 - arg3)) < TVIL_TOL) && \
                            ((TVIL_FABS(arg3 - arg4)) < TVIL_TOL))
#define SAME5(arg1,arg2,arg3,arg4,arg5) (((TVIL_FABS(arg1 - arg2)) < TVIL_TOL) && \
                               ((TVIL_FABS(arg2 - arg3)) < TVIL_TOL) && \
                               ((TVIL_FABS(arg3 - arg4)) < TVIL_TOL) && \
                               ((TVIL_FABS(arg4 - arg5)) < TVIL_TOL))
#define SAME6(arg1,arg2,arg3,arg4,arg5,arg6) (((TVIL_FABS(arg1 - arg2)) < TVIL_TOL) && \
                                  ((TVIL_FABS(arg2 - arg3)) < TVIL_TOL) && \
                                  ((TVIL_FABS(arg3 - arg4)) < TVIL_TOL) && \
                                  ((TVIL_FABS(arg4 - arg5)) < TVIL_TOL) && \
                                  ((TVIL_FABS(arg5 - arg6)) < TVIL_TOL))
#define SAME7(arg1,arg2,arg3,arg4,arg5,arg6,arg7) (((TVIL_FABS(arg1 - arg2)) < TVIL_TOL) && \
                                     ((TVIL_FABS(arg2 - arg3)) < TVIL_TOL) && \
                                     ((TVIL_FABS(arg3 - arg4)) < TVIL_TOL) && \
                                     ((TVIL_FABS(arg4 - arg5)) < TVIL_TOL) && \
                                     ((TVIL_FABS(arg5 - arg6)) < TVIL_TOL) && \
                                     ((TVIL_FABS(arg6 - arg7)) < TVIL_TOL))
