/* Routines for setup and initialization of H-type functions */

#include "internal.h"

void TVIL_cHd1Roots (TVIL_HTYPE *, TVIL_REAL *);

TVIL_REAL u2, u3, u4, u5, u6;
TVIL_REAL v2, v3, v4, v5, v6;
TVIL_REAL w2, w3, w4, w5, w6;
TVIL_REAL x2, x3, x4, x5, x6;
TVIL_REAL y2, y3, y4, y5, y6;
TVIL_REAL z2, z3, z4, z5, z6;

/* **************************************************************** */
/* **************************************************************** */

void TVIL_cHden (TVIL_REAL u,
		 TVIL_REAL v,
		 TVIL_REAL w,
		 TVIL_REAL x,
		 TVIL_REAL y,
		 TVIL_REAL z,
		 TVIL_REAL *result)
{
  u2 = u*u;
  v2 = v*v;
  w2 = w*w;
  x2 = x*x;
  y2 = y*y;
  z2 = z*z;

  if (SAME6(u,v,w,x,y,z)) 
    {
      *(result) = -a;
      *(result+1) = a - u;
      *(result+2) = 0;
      *(result+3) = 0;
    }
  else if (SAME4(u,v,y,z) && SAME2(w,x))
    {
      *(result) = a2;
      *(result+1) = -2*a2 + 2*a*u;
      *(result+2) = a2 - 2*a*u + 2*u*w - w2;
      *(result+3) = 0;
    }
  else if (SAME4(u,w,x,y) && SAME2(v,z))
    {
      *(result) = a2;
      *(result+1) = -2*a2 + 2*a*u;
      *(result+2) = a2 - 2*a*u + 2*u*v - v2;
      *(result+3) = 0;
    }
  else if (SAME4(v,w,x,z) && SAME2(u,y))
    {
      *(result) = a2;
      *(result+1) = -2*a2 + 2*a*v;
      *(result+2) = a2 - u2 - 2*a*v + 2*u*v;
      *(result+3) = 0;
    }
  else if (SAME3(u,v,w) && SAME3(x,y,z))
    {
      *(result) = 2*a2;
      *(result+1) = -4*a2 + 3*a*u + a*x;
      *(result+2) = 2*a2 - 3*a*u - a*x + 3*u*x - x2;
      *(result+3) = 0;
    }
  else if (SAME3(u,v,x) && SAME3(w,y,z))
    {
      *(result) = 2*a2;
      *(result+1) = -4*a2 + a*u + 3*a*w;
      *(result+2) = 2*a2 - a*u - u2 - 3*a*w + 3*u*w;
      *(result+3) = 0;
    }
  else if (SAME3(u,w,z) && SAME3(v,x,y))
    {
      *(result) = 2*a2;
      *(result+1) = -4*a2 + a*u + 3*a*v;
      *(result+2) = 2*a2 - a*u - u2 - 3*a*v + 3*u*v;
      *(result+3) = 0;
    }
  else if (SAME3(u,x,z) && SAME3(v,w,y))
    {
      *(result) = 2*a2;
      *(result+1) = -4*a2 + 3*a*u + a*v;
      *(result+2) = 2*a2 - 3*a*u - a*v + 3*u*v - v2;
      *(result+3) = 0;
    }
  else 
    {
      *(result) = -2*a3;
      *(result+1) = 6*a3 - a2*u - a2*v - a2*w - a2*x - a2*y - a2*z;
      *(result+2) = -6*a3 + 2*a2*u + a*u2 + 2*a2*v - a*u*v + a*v2 + 2*a2*w - a*u*w - a*v*w + a*w2 + 2*a2*x - a*u*x - a*v*x + a*x2 + 2*a2*y - a*v*y - a*w*y - a*x*y + a*y2 + 2*a2*z - a*u*z - a*w*z - a*x*z - a*y*z + a*z2;
      *(result+3) = 2*a3 - a2*u - a*u2 - a2*v + a*u*v - a*v2 - a2*w + a*u*w + a*v*w - a*w2 - a2*x + a*u*x + a*v*x + u*v*x - u*w*x - v*w*x + w2*x - a*x2 + w*x2 - a2*y + u2*y + a*v*y - u*v*y + a*w*y - u*w*y + v*w*y + a*x*y - u*x*y - w*x*y - a*y2 + u*y2 - a2*z + a*u*z - u*v*z + v2*z + a*w*z + u*w*z - v*w*z + a*x*z - v*x*z - w*x*z + a*y*z - u*y*z - v*y*z + x*y*z - a*z2 + v*z2;
    }

  return;
}

/* **************************************************************** */
/* **************************************************************** */

void TVIL_cHnum (TVIL_REAL u,
		 TVIL_REAL v,
		 TVIL_REAL w,
		 TVIL_REAL x,
		 TVIL_REAL y,
		 TVIL_REAL z,
		 TVIL_REAL *result)
{
  u2 = u*u;
  v2 = v*v;
  w2 = w*w;
  x2 = x*x;
  y2 = y*y;
  z2 = z*z;

  if (SAME6(u,v,w,x,y,z))
    {
      *(result) = -6*a + 6*u;
      *(result+1) = 0;
      *(result+2) = 0;
    }
  else if (SAME4(u,v,y,z) && SAME2(w,x))
    {
      *(result) = 6*a2 - 4*a*u - 2*a*w;
      *(result+1) = -6*a2 + 12*a*u - 12*u*w + 6*w2;
      *(result+2) = 0;
    }
  else if (SAME4(u,w,x,y) && SAME2(v,z))
    {
      *(result) = 6*a2 - 4*a*u - 2*a*v;
      *(result+1) = -6*a2 + 12*a*u - 12*u*v + 6*v2;
      *(result+2) = 0;
    }
  else if (SAME4(v,w,x,z) && SAME2(u,y))
    {
      *(result) = 6*a2 - 2*a*u - 4*a*v;
      *(result+1) = -6*a2 + 6*u2 + 12*a*v - 12*u*v;
      *(result+2) = 0;
    }
  else if (SAME3(u,v,w) && SAME3(x,y,z))
    {
      *(result) = 12*a2 - 6*a*u - 6*a*x;
      *(result+1) = -12*a2 + 18*a*u + 6*a*x - 18*u*x + 6*x2;
      *(result+2) = 0;
    }
  else if (SAME3(u,v,x) && SAME3(w,y,z))
    {
      *(result) = 12*a2 - 6*a*u - 6*a*w;
      *(result+1) = -12*a2 + 6*a*u + 6*u2 + 18*a*w - 18*u*w;
      *(result+2) = 0;
    }
  else if (SAME3(u,w,z) && SAME3(v,x,y))
    {
      *(result) = 12*a2 - 6*a*u - 6*a*v;
      *(result+1) = -12*a2 + 6*a*u + 6*u2 + 18*a*v - 18*u*v;
      *(result+2) = 0;
    }
  else if (SAME3(u,x,z) && SAME3(v,w,y))
    {
      *(result) = 12*a2 - 6*a*u - 6*a*v;
      *(result+1) = -12*a2 + 18*a*u + 6*a*v - 18*u*v + 6*v2;
      *(result+2) = 0;
    }
  else 
    {
      *(result) = -12*a3 + 2*a2*u + 2*a2*v + 2*a2*w + 2*a2*x + 2*a2*y + 2*a2*z;
      *(result+1) =  24*a3 - 8*a2*u - 4*a*u2 - 8*a2*v + 4*a*u*v - 4*a*v2 - 8*a2*w + 4*a*u*w + 4*a*v*w - 4*a*w2 - 8*a2*x + 4*a*u*x + 4*a*v*x - 4*a*x2 - 8*a2*y + 4*a*v*y + 4*a*w*y + 4*a*x*y - 4*a*y2 - 8*a2*z + 4*a*u*z + 4*a*w*z + 4*a*x*z + 4*a*y*z - 4*a*z2;
      *(result+2) = -12*a3 + 6*a2*u + 6*a*u2 + 6*a2*v - 6*a*u*v + 6*a*v2 + 6*a2*w - 6*a*u*w - 6*a*v*w + 6*a*w2 + 6*a2*x - 6*a*u*x - 6*a*v*x - 6*u*v*x + 6*u*w*x + 6*v*w*x - 6*w2*x + 6*a*x2 - 6*w*x2 + 6*a2*y - 6*u2*y - 6*a*v*y + 6*u*v*y - 6*a*w*y + 6*u*w*y - 6*v*w*y - 6*a*x*y + 6*u*x*y + 6*w*x*y + 6*a*y2 - 6*u*y2 + 6*a2*z - 6*a*u*z + 6*u*v*z - 6*v2*z - 6*a*w*z - 6*u*w*z + 6*v*w*z - 6*a*x*z + 6*v*x*z + 6*w*x*z - 6*a*y*z + 6*u*y*z + 6*v*y*z - 6*x*y*z + 6*a*z2 - 6*v*z2;
    }

  return;
}

/* **************************************************************** */
/* **************************************************************** */

void TVIL_cHGden (TVIL_REAL u,
		  TVIL_REAL v,
		  TVIL_REAL w,
		  TVIL_REAL x,
		  TVIL_REAL y,
		  TVIL_REAL z,
		  TVIL_REAL *result)
{
  u2 = u*u;
  u3 = u2*u;
  u4 = u2*u2;
  u5 = u2*u3;

  v2 = v*v;
  v3 = v2*v;
  v4 = v2*v2;
  v5 = v2*v3;

  w2 = w*w;
  w3 = w2*w;
  w4 = w2*w2;

  x2 = x*x;
  x3 = x2*x;
  x4 = x2*x2;
  x5 = x2*x3;
  x6 = x3*x3;

  y2 = y*y;
  y3 = y2*y;
  y4 = y2*y2;

  z2 = z*z;
  z3 = z2*z;
  z4 = z2*z2;

  if (SAME6(u,v,w,x,y,z))
    {
      *(result) = 1;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME5(u,v,w,x,y))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - 17*a2*u - a2*z;
      *(result+2) = -18*a3 + 34*a2*u - 12*a*u2 + 2*a2*z - 10*a*u*z + 4*a*z2;
      *(result+3) = 6*a3 - 17*a2*u + 12*a*u2 - a2*z + 10*a*u*z - 12*u2*z - 4*a*z2 + 7*u*z2 - z3;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME5(u,v,w,x,z))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - 17*a2*u - a2*y;
      *(result+2) = -18*a3 + 34*a2*u - 12*a*u2 + 2*a2*y - 10*a*u*y + 4*a*y2;
      *(result+3) = 6*a3 - 17*a2*u + 12*a*u2 - a2*y + 10*a*u*y - 12*u2*y - 4*a*y2 + 7*u*y2 - y3;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME5(u,w,x,y,z))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - 17*a2*u - a2*v;
      *(result+2) = -18*a3 + 34*a2*u - 12*a*u2 + 2*a2*v - 10*a*u*v + 4*a*v2;
      *(result+3) = 6*a3 - 17*a2*u + 12*a*u2 - a2*v + 10*a*u*v - 12*u2*v - 4*a*v2 + 7*u*v2 - v3;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME5(v,w,x,y,z))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - a2*u - 17*a2*v;
      *(result+2) = -18*a3 + 2*a2*u + 4*a*u2 + 34*a2*v - 10*a*u*v - 12*a*v2;
      *(result+3) = 6*a3 - a2*u - 4*a*u2 - u3 - 17*a2*v + 10*a*u*v + 7*u2*v + 12*a*v2 - 12*u*v2;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME4(u,w,x,y) && SAME2(v,z))
    {
      *(result) = -3*a3;
      *(result+1) = 9*a3 - 10*a2*u + a2*v;
      *(result+2) = -9*a3 + 20*a2*u - 8*a*u2 - 2*a2*v - 4*a*u*v + 3*a*v2;
      *(result+3) = 3*a3 - 10*a2*u + 8*a*u2 + a2*v + 4*a*u*v - 8*u2*v - 3*a*v2 + 6*u*v2 - v3;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME4(v,w,x,z) && SAME2(u,y))
    {
      *(result) = -3*a3;
      *(result+1) = 9*a3 + a2*u - 10*a2*v;
      *(result+2) = -9*a3 - 2*a2*u + 3*a*u2 + 20*a2*v - 4*a*u*v - 8*a*v2;
      *(result+3) = 3*a3 + a2*u - 3*a*u2 - u3 - 10*a2*v + 4*a*u*v + 6*u2*v + 8*a*v2 - 8*u*v2;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME3(u,v,w) && SAME3(x,y,z))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - 17*a2*u - a2*x;
      *(result+2) = -18*a3 + 34*a2*u - 12*a*u2 + 2*a2*x - 10*a*u*x + 4*a*x2;
      *(result+3) = 6*a3 - 17*a2*u + 12*a*u2 - a2*x + 10*a*u*x - 12*u2*x - 4*a*x2 + 7*u*x2 - x3;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME3(u,v,x) && SAME3(w,y,z))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - a2*u - 17*a2*w;
      *(result+2) = -18*a3 + 2*a2*u + 4*a*u2 + 34*a2*w - 10*a*u*w - 12*a*w2;
      *(result+3) = 6*a3 - a2*u - 4*a*u2 - u3 - 17*a2*w + 10*a*u*w + 7*u2*w + 12*a*w2 - 12*u*w2;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME3(u,w,z) && SAME3(v,x,y))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - a2*u - 17*a2*v;
      *(result+2) = -18*a3 + 2*a2*u + 4*a*u2 + 34*a2*v - 10*a*u*v - 12*a*v2;
      *(result+3) = 6*a3 - a2*u - 4*a*u2 - u3 - 17*a2*v + 10*a*u*v + 7*u2*v + 12*a*v2 - 12*u*v2;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME3(u,x,z) && SAME3(v,w,y))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - 17*a2*u - a2*v;
      *(result+2) = -18*a3 + 34*a2*u - 12*a*u2 + 2*a2*v - 10*a*u*v + 4*a*v2;
      *(result+3) = 6*a3 - 17*a2*u + 12*a*u2 - a2*v + 10*a*u*v - 12*u2*v - 4*a*v2 + 7*u*v2 - v3;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME4(u,v,y,z))
    {
      *(result) = -6*a3;
      *(result+1) = 18*a3 - 20*a2*u - 3*a2*w + 5*a2*x;
      *(result+2) = -18*a3 + 40*a2*u - 16*a*u2 + 6*a2*w - 16*a*u*w + 3*a*w2 - 10*a2*x + 8*a*u*x + 4*a*w*x - a*x2;
      *(result+3) = 6*a3 - 20*a2*u + 16*a*u2 - 3*a2*w + 16*a*u*w - 16*u2*w - 3*a*w2 + 4*u*w2 + 5*a2*x - 8*a*u*x - 4*a*w*x + 8*u*w*x - w2*x + a*x2 - w*x2;
      *(result+4) = 0;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME2(u,z) && SAME2(v,y) && SAME2(w,x))
    {
      *(result) = 6*a4;
      *(result+1) = -24*a4 + 10*a3*u + 10*a3*v + 4*a3*w;
      *(result+2) = 36*a4 - 30*a3*u - a2*u2 - 30*a3*v + 18*a2*u*v - a2*v2 - 12*a3*w + 14*a2*u*w + 14*a2*v*w - 8*a2*w2;
      *(result+3) = -24*a4 + 30*a3*u + 2*a2*u2 - 4*a*u3 + 30*a3*v - 36*a2*u*v + 4*a*u2*v + 2*a2*v2 + 4*a*u*v2 - 4*a*v3 + 12*a3*w - 28*a2*u*w + 6*a*u2*w - 28*a2*v*w + 20*a*u*v*w + 6*a*v2*w + 16*a2*w2 - 2*a*u*w2 - 2*a*v*w2 - 4*a*w3;
      *(result+4) = 6*a4 - 10*a3*u - a2*u2 + 4*a*u3 + u4 - 10*a3*v + 18*a2*u*v - 4*a*u2*v - 4*u3*v - a2*v2 - 4*a*u*v2 + 6*u2*v2 + 4*a*v3 - 4*u*v3 + v4 - 4*a3*w + 14*a2*u*w - 6*a*u2*w - 4*u3*w + 14*a2*v*w - 20*a*u*v*w + 4*u2*v*w - 6*a*v2*w + 4*u*v2*w - 4*v3*w - 8*a2*w2 + 2*a*u*w2 + 7*u2*w2 + 2*a*v*w2 + 2*u*v*w2 + 7*v2*w2 + 4*a*w3 - 6*u*w3 - 6*v*w3 + 2*w4;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME2(u,v) && SAME2(y,z))
    {
      *(result) = 18*a4;
      *(result+1) = -72*a4 + 42*a3*u + 9*a3*w - 21*a3*x + 42*a3*y;
      *(result+2) = 108*a4 - 126*a3*u + 15*a2*u2 - 27*a3*w + 30*a2*u*w - 9*a2*w2 + 63*a3*x - 32*a2*u*x - 15*a2*w*x + 8*a2*x2 - 126*a3*y + 98*a2*u*y + 30*a2*w*y - 32*a2*x*y + 15*a2*y2;
      *(result+3) = -72*a4 + 126*a3*u - 30*a2*u2 - 12*a*u3 + 27*a3*w - 60*a2*u*w + 24*a*u2*w + 18*a2*w2 - 12*a*u*w2 - 63*a3*x + 64*a2*u*x - 2*a*u2*x + 30*a2*w*x - 28*a*u*w*x + 6*a*w2*x - 16*a2*x2 + 6*a*u*x2 + 7*a*w*x2 - a*x3 + 126*a3*y - 196*a2*u*y + 44*a*u2*y - 60*a2*w*y + 64*a*u*w*y - 12*a*w2*y + 64*a2*x*y - 44*a*u*x*y - 28*a*w*x*y + 6*a*x2*y - 30*a2*y2 + 44*a*u*y2 + 24*a*w*y2 - 2*a*x*y2 - 12*a*y3;
      *(result+4) = 18*a4 - 42*a3*u + 15*a2*u2 + 12*a*u3 - 9*a3*w + 30*a2*u*w - 24*a*u2*w - 9*a2*w2 + 12*a*u*w2 + 21*a3*x - 32*a2*u*x + 2*a*u2*x + 4*u3*x - 15*a2*w*x + 28*a*u*w*x - 8*u2*w*x - 6*a*w2*x + 4*u*w2*x + 8*a2*x2 - 6*a*u*x2 - u2*x2 - 7*a*w*x2 + 6*u*w*x2 - w2*x2 + a*x3 - w*x3 - 42*a3*y + 98*a2*u*y - 44*a*u2*y - 16*u3*y + 30*a2*w*y - 64*a*u*w*y + 32*u2*w*y + 12*a*w2*y - 16*u*w2*y - 32*a2*x*y + 44*a*u*x*y - 4*u2*x*y + 28*a*w*x*y - 32*u*w*x*y + 4*w2*x*y - 6*a*x2*y + 2*u*x2*y + 6*w*x2*y + 15*a2*y2 - 44*a*u*y2 + 32*u2*y2 - 24*a*w*y2 + 32*u*w*y2 + 2*a*x*y2 - 4*u*x*y2 - 8*w*x*y2 - x2*y2 + 12*a*y3 - 16*u*y3 + 4*x*y3;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME3(u,v,x))
    {
      *(result) = 6*a4;
      *(result+1) = -24*a4 + 7*a3*u + 3*a3*w + 7*a3*y + 7*a3*z;
      *(result+2) = 36*a4 - 21*a3*u - 3*a2*u2 - 9*a3*w + 5*a2*u*w - 3*a2*w2 - 21*a3*y + 11*a2*u*y + 5*a2*w*y - 3*a2*y2 - 21*a3*z + 11*a2*u*z + 5*a2*w*z + 11*a2*y*z - 3*a2*z2;
      *(result+3) = -24*a4 + 21*a3*u + 6*a2*u2 - 3*a*u3 + 9*a3*w - 10*a2*u*w + a*u2*w + 6*a2*w2 - 2*a*u*w2 + 21*a3*y - 22*a2*u*y + a*u2*y - 10*a2*w*y + 6*a*u*w*y - 2*a*w2*y + 6*a2*y2 + a*u*y2 + a*w*y2 - 3*a*y3 + 21*a3*z - 22*a2*u*z + a*u2*z - 10*a2*w*z + 6*a*u*w*z - 2*a*w2*z - 22*a2*y*z + 12*a*u*y*z + 6*a*w*y*z + a*y2*z + 6*a2*z2 + a*u*z2 + a*w*z2 + a*y*z2 - 3*a*z3;
      *(result+4) = 6*a4 - 7*a3*u - 3*a2*u2 + 3*a*u3 + u4 - 3*a3*w + 5*a2*u*w - a*u2*w - u3*w - 3*a2*w2 + 2*a*u*w2 + u2*w2 - 7*a3*y + 11*a2*u*y - a*u2*y - 3*u3*y + 5*a2*w*y - 6*a*u*w*y + u2*w*y + 2*a*w2*y - 2*u*w2*y - 3*a2*y2 - a*u*y2 + 4*u2*y2 - a*w*y2 + u*w*y2 + w2*y2 + 3*a*y3 - 3*u*y3 - w*y3 + y4 - 7*a3*z + 11*a2*u*z - a*u2*z - 3*u3*z + 5*a2*w*z - 6*a*u*w*z + u2*w*z + 2*a*w2*z - 2*u*w2*z + 11*a2*y*z - 12*a*u*y*z + u2*y*z - 6*a*w*y*z + 6*u*w*y*z - 2*w2*y*z - a*y2*z + u*y2*z + w*y2*z - 3*y3*z - 3*a2*z2 - a*u*z2 + 4*u2*z2 - a*w*z2 + u*w*z2 + w2*z2 - a*y*z2 + u*y*z2 + w*y*z2 + 4*y2*z2 + 3*a*z3 - 3*u*z3 - w*z3 - 3*y*z3 + z4;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME3(x,y,z))
    {
      *(result) = 6*a4;
      *(result+1) = -24*a4 + 7*a3*u + 7*a3*v + 3*a3*w + 7*a3*x;
      *(result+2) = 36*a4 - 21*a3*u - 3*a2*u2 - 21*a3*v + 11*a2*u*v - 3*a2*v2 - 9*a3*w + 5*a2*u*w + 5*a2*v*w - 3*a2*w2 - 21*a3*x + 11*a2*u*x + 11*a2*v*x + 5*a2*w*x - 3*a2*x2;
      *(result+3) = -24*a4 + 21*a3*u + 6*a2*u2 - 3*a*u3 + 21*a3*v - 22*a2*u*v + a*u2*v + 6*a2*v2 + a*u*v2 - 3*a*v3 + 9*a3*w - 10*a2*u*w + a*u2*w - 10*a2*v*w + 6*a*u*v*w + a*v2*w + 6*a2*w2 - 2*a*u*w2 - 2*a*v*w2 + 21*a3*x - 22*a2*u*x + a*u2*x - 22*a2*v*x + 12*a*u*v*x + a*v2*x - 10*a2*w*x + 6*a*u*w*x + 6*a*v*w*x - 2*a*w2*x + 6*a2*x2 + a*u*x2 + a*v*x2 + a*w*x2 - 3*a*x3;
      *(result+4) = 6*a4 - 7*a3*u - 3*a2*u2 + 3*a*u3 + u4 - 7*a3*v + 11*a2*u*v - a*u2*v - 3*u3*v - 3*a2*v2 - a*u*v2 + 4*u2*v2 + 3*a*v3 - 3*u*v3 + v4 - 3*a3*w + 5*a2*u*w - a*u2*w - u3*w + 5*a2*v*w - 6*a*u*v*w + u2*v*w - a*v2*w + u*v2*w - v3*w - 3*a2*w2 + 2*a*u*w2 + u2*w2 + 2*a*v*w2 - 2*u*v*w2 + v2*w2 - 7*a3*x + 11*a2*u*x - a*u2*x - 3*u3*x + 11*a2*v*x - 12*a*u*v*x + u2*v*x - a*v2*x + u*v2*x - 3*v3*x + 5*a2*w*x - 6*a*u*w*x + u2*w*x - 6*a*v*w*x + 6*u*v*w*x + v2*w*x + 2*a*w2*x - 2*u*w2*x - 2*v*w2*x - 3*a2*x2 - a*u*x2 + 4*u2*x2 - a*v*x2 + u*v*x2 + 4*v2*x2 - a*w*x2 + u*w*x2 + v*w*x2 + w2*x2 + 3*a*x3 - 3*u*x3 - 3*v*x3 - w*x3 + x4;
      *(result+5) = 0;
      *(result+6) = 0; 
      *(result+7) = 0;
    }
  else if (SAME3(u,v,w) && SAME2(x,y))
    {
      *(result) = -18*a5;
      *(result+1) = 90*a5 - 51*a4*u - 36*a4*x - 3*a4*z;
      *(result+2) = -180*a5 + 204*a4*u - 36*a3*u2 + 144*a4*x - 119*a3*u*x - a3*x2 + 12*a4*z - 13*a3*u*z - 23*a3*x*z + 12*a3*z2;
      *(result+3) = 180*a5 - 306*a4*u + 108*a3*u2 - 216*a4*x + 357*a3*u*x - 96*a2*u2*x + 3*a3*x2 - 44*a2*u*x2 + 17*a2*x3 - 18*a4*z + 39*a3*u*z - 12*a2*u2*z + 69*a3*x*z - 77*a2*u*x*z - 10*a2*x2*z - 36*a3*z2 + 31*a2*u*z2 + 14*a2*x*z2 - 3*a2*z3;
      *(result+4) = -90*a5 + 204*a4*u - 108*a3*u2 + 144*a4*x - 357*a3*u*x + 192*a2*u2*x - 3*a3*x2 + 88*a2*u*x2 - 64*a*u2*x2 - 34*a2*x3 + 32*a*u*x3 - 4*a*x4 + 12*a4*z - 39*a3*u*z + 24*a2*u2*z - 69*a3*x*z + 154*a2*u*x*z - 64*a*u2*x*z + 20*a2*x2*z - 56*a*u*x2*z + 18*a*x3*z + 36*a3*z2 - 62*a2*u*z2 + 20*a*u2*z2 - 28*a2*x*z2 + 43*a*u*x*z2 - 9*a*x2*z2 + 6*a2*z3 - 7*a*u*z3 + a*x*z3;
      *(result+5) = 18*a5 - 51*a4*u + 36*a3*u2 - 36*a4*x + 119*a3*u*x - 96*a2*u2*x + a3*x2 - 44*a2*u*x2 + 64*a*u2*x2 + 17*a2*x3 - 32*a*u*x3 + 4*a*x4 - 3*a4*z + 13*a3*u*z - 12*a2*u2*z + 23*a3*x*z - 77*a2*u*x*z + 64*a*u2*x*z - 10*a2*x2*z + 56*a*u*x2*z - 64*u2*x2*z - 18*a*x3*z + 32*u*x3*z - 4*x4*z - 12*a3*z2 + 31*a2*u*z2 - 20*a*u2*z2 + 14*a2*x*z2 - 43*a*u*x*z2 + 32*u2*x*z2 + 9*a*x2*z2 - 12*u*x2*z2 + x3*z2 - 3*a2*z3 + 7*a*u*z3 - 4*u2*z3 - a*x*z3 + u*x*z3;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME3(u,v,w) && SAME2(x,z))
    {
      *(result) = -18*a5;
      *(result+1) = 90*a5 - 51*a4*u - 36*a4*x - 3*a4*y;
      *(result+2) = -180*a5 + 204*a4*u - 36*a3*u2 + 144*a4*x - 119*a3*u*x - a3*x2 + 12*a4*y - 13*a3*u*y - 23*a3*x*y + 12*a3*y2;
      *(result+3) = 180*a5 - 306*a4*u + 108*a3*u2 - 216*a4*x + 357*a3*u*x - 96*a2*u2*x + 3*a3*x2 - 44*a2*u*x2 + 17*a2*x3 - 18*a4*y + 39*a3*u*y - 12*a2*u2*y + 69*a3*x*y - 77*a2*u*x*y - 10*a2*x2*y - 36*a3*y2 + 31*a2*u*y2 + 14*a2*x*y2 - 3*a2*y3;
      *(result+4) = -90*a5 + 204*a4*u - 108*a3*u2 + 144*a4*x - 357*a3*u*x + 192*a2*u2*x - 3*a3*x2 + 88*a2*u*x2 - 64*a*u2*x2 - 34*a2*x3 + 32*a*u*x3 - 4*a*x4 + 12*a4*y - 39*a3*u*y + 24*a2*u2*y - 69*a3*x*y + 154*a2*u*x*y - 64*a*u2*x*y + 20*a2*x2*y - 56*a*u*x2*y + 18*a*x3*y + 36*a3*y2 - 62*a2*u*y2 + 20*a*u2*y2 - 28*a2*x*y2 + 43*a*u*x*y2 - 9*a*x2*y2 + 6*a2*y3 - 7*a*u*y3 + a*x*y3;
      *(result+5) = 18*a5 - 51*a4*u + 36*a3*u2 - 36*a4*x + 119*a3*u*x - 96*a2*u2*x + a3*x2 - 44*a2*u*x2 + 64*a*u2*x2 + 17*a2*x3 - 32*a*u*x3 + 4*a*x4 - 3*a4*y + 13*a3*u*y - 12*a2*u2*y + 23*a3*x*y - 77*a2*u*x*y + 64*a*u2*x*y - 10*a2*x2*y + 56*a*u*x2*y - 64*u2*x2*y - 18*a*x3*y + 32*u*x3*y - 4*x4*y - 12*a3*y2 + 31*a2*u*y2 - 20*a*u2*y2 + 14*a2*x*y2 - 43*a*u*x*y2 + 32*u2*x*y2 + 9*a*x2*y2 - 12*u*x2*y2 + x3*y2 - 3*a2*y3 + 7*a*u*y3 - 4*u2*y3 - a*x*y3 + u*x*y3;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME3(w,y,z) && SAME2(u,x))
    {
      *(result) = -18*a5;
      *(result+1) = 90*a5 - 36*a4*u - 3*a4*v - 51*a4*w;
      *(result+2) = -180*a5 + 144*a4*u - a3*u2 + 12*a4*v - 23*a3*u*v + 12*a3*v2 + 204*a4*w - 119*a3*u*w - 13*a3*v*w - 36*a3*w2;
      *(result+3) = 180*a5 - 216*a4*u + 3*a3*u2 + 17*a2*u3 - 18*a4*v + 69*a3*u*v - 10*a2*u2*v - 36*a3*v2 + 14*a2*u*v2 - 3*a2*v3 - 306*a4*w + 357*a3*u*w - 44*a2*u2*w + 39*a3*v*w - 77*a2*u*v*w + 31*a2*v2*w + 108*a3*w2 - 96*a2*u*w2 - 12*a2*v*w2;
      *(result+4) = -90*a5 + 144*a4*u - 3*a3*u2 - 34*a2*u3 - 4*a*u4 + 12*a4*v - 69*a3*u*v + 20*a2*u2*v + 18*a*u3*v + 36*a3*v2 - 28*a2*u*v2 - 9*a*u2*v2 + 6*a2*v3 + a*u*v3 + 204*a4*w - 357*a3*u*w + 88*a2*u2*w + 32*a*u3*w - 39*a3*v*w + 154*a2*u*v*w - 56*a*u2*v*w - 62*a2*v2*w + 43*a*u*v2*w - 7*a*v3*w - 108*a3*w2 + 192*a2*u*w2 - 64*a*u2*w2 + 24*a2*v*w2 - 64*a*u*v*w2 + 20*a*v2*w2;
      *(result+5) = 18*a5 - 36*a4*u + a3*u2 + 17*a2*u3 + 4*a*u4 - 3*a4*v + 23*a3*u*v - 10*a2*u2*v - 18*a*u3*v - 4*u4*v - 12*a3*v2 + 14*a2*u*v2 + 9*a*u2*v2 + u3*v2 - 3*a2*v3 - a*u*v3 - 51*a4*w + 119*a3*u*w - 44*a2*u2*w - 32*a*u3*w + 13*a3*v*w - 77*a2*u*v*w + 56*a*u2*v*w + 32*u3*v*w + 31*a2*v2*w - 43*a*u*v2*w - 12*u2*v2*w + 7*a*v3*w + u*v3*w + 36*a3*w2 - 96*a2*u*w2 + 64*a*u2*w2 - 12*a2*v*w2 + 64*a*u*v*w2 - 64*u2*v*w2 - 20*a*v2*w2 + 32*u*v2*w2 - 4*v3*w2;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME3(w,y,z) && SAME2(v,x))
    {
      *(result) = -18*a5;
      *(result+1) = 90*a5 - 3*a4*u - 36*a4*v - 51*a4*w;
      *(result+2) = -180*a5 + 12*a4*u + 12*a3*u2 + 144*a4*v - 23*a3*u*v - a3*v2 + 204*a4*w - 13*a3*u*w - 119*a3*v*w - 36*a3*w2;
      *(result+3) = 180*a5 - 18*a4*u - 36*a3*u2 - 3*a2*u3 - 216*a4*v + 69*a3*u*v + 14*a2*u2*v + 3*a3*v2 - 10*a2*u*v2 + 17*a2*v3 - 306*a4*w + 39*a3*u*w + 31*a2*u2*w + 357*a3*v*w - 77*a2*u*v*w - 44*a2*v2*w + 108*a3*w2 - 12*a2*u*w2 - 96*a2*v*w2;
      *(result+4) = -90*a5 + 12*a4*u + 36*a3*u2 + 6*a2*u3 + 144*a4*v - 69*a3*u*v - 28*a2*u2*v + a*u3*v - 3*a3*v2 + 20*a2*u*v2 - 9*a*u2*v2 - 34*a2*v3 + 18*a*u*v3 - 4*a*v4 + 204*a4*w - 39*a3*u*w - 62*a2*u2*w - 7*a*u3*w - 357*a3*v*w + 154*a2*u*v*w + 43*a*u2*v*w + 88*a2*v2*w - 56*a*u*v2*w + 32*a*v3*w - 108*a3*w2 + 24*a2*u*w2 + 20*a*u2*w2 + 192*a2*v*w2 - 64*a*u*v*w2 - 64*a*v2*w2;
      *(result+5) = 18*a5 - 3*a4*u - 12*a3*u2 - 3*a2*u3 - 36*a4*v + 23*a3*u*v + 14*a2*u2*v - a*u3*v + a3*v2 - 10*a2*u*v2 + 9*a*u2*v2 + 17*a2*v3 - 18*a*u*v3 + u2*v3 + 4*a*v4 - 4*u*v4 - 51*a4*w + 13*a3*u*w + 31*a2*u2*w + 7*a*u3*w + 119*a3*v*w - 77*a2*u*v*w - 43*a*u2*v*w + u3*v*w - 44*a2*v2*w + 56*a*u*v2*w - 12*u2*v2*w - 32*a*v3*w + 32*u*v3*w + 36*a3*w2 - 12*a2*u*w2 - 20*a*u2*w2 - 4*u3*w2 - 96*a2*v*w2 + 64*a*u*v*w2 + 32*u2*v*w2 + 64*a*v2*w2 - 64*u*v2*w2;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME4(u,w,x,y))
    {
      *(result) = -18*a5;
      *(result+1) = 90*a5 - 84*a4*u - 3*a4*v - 3*a4*z;
      *(result+2) = -180*a5 + 336*a4*u - 128*a3*u2 + 12*a4*v - 40*a3*u*v + 12*a3*v2 + 12*a4*z - 40*a3*u*z + 4*a3*v*z + 12*a3*z2;
      *(result+3) = 180*a5 - 504*a4*u + 384*a3*u2 - 64*a2*u3 - 18*a4*v + 120*a3*u*v - 96*a2*u2*v - 36*a3*v2 + 40*a2*u*v2 - 3*a2*v3 - 18*a4*z + 120*a3*u*z - 96*a2*u2*z - 12*a3*v*z - 8*a2*u*v*z + 5*a2*v2*z - 36*a3*z2 + 40*a2*u*z2 + 5*a2*v*z2 - 3*a2*z3;
      *(result+4) = -90*a5 + 336*a4*u - 384*a3*u2 + 128*a2*u3 + 12*a4*v - 120*a3*u*v + 192*a2*u2*v - 64*a*u3*v + 36*a3*v2 - 80*a2*u*v2 + 32*a*u2*v2 + 6*a2*v3 - 4*a*u*v3 + 12*a4*z - 120*a3*u*z + 192*a2*u2*z - 64*a*u3*z + 12*a3*v*z + 16*a2*u*v*z - 64*a*u2*v*z - 10*a2*v2*z + 28*a*u*v2*z - 2*a*v3*z + 36*a3*z2 - 80*a2*u*z2 + 32*a*u2*z2 - 10*a2*v*z2 + 28*a*u*v*z2 - 6*a*v2*z2 + 6*a2*z3 - 4*a*u*z3 - 2*a*v*z3;
      *(result+5) = 18*a5 - 84*a4*u + 128*a3*u2 - 64*a2*u3 - 3*a4*v + 40*a3*u*v - 96*a2*u2*v + 64*a*u3*v - 12*a3*v2 + 40*a2*u*v2 - 32*a*u2*v2 - 3*a2*v3 + 4*a*u*v3 - 3*a4*z + 40*a3*u*z - 96*a2*u2*z + 64*a*u3*z - 4*a3*v*z - 8*a2*u*v*z + 64*a*u2*v*z - 64*u3*v*z + 5*a2*v2*z - 28*a*u*v2*z + 32*u2*v2*z + 2*a*v3*z - 4*u*v3*z - 12*a3*z2 + 40*a2*u*z2 - 32*a*u2*z2 + 5*a2*v*z2 - 28*a*u*v*z2 + 32*u2*v*z2 + 6*a*v2*z2 - 12*u*v2*z2 + v3*z2 - 3*a2*z3 + 4*a*u*z3 + 2*a*v*z3 - 4*u*v*z3 + v2*z3;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME4(v,w,x,z))
    {
      *(result) = -18*a5;
      *(result+1) = 90*a5 - 3*a4*u - 84*a4*v - 3*a4*y;
      *(result+2) = -180*a5 + 12*a4*u + 12*a3*u2 + 336*a4*v - 40*a3*u*v - 128*a3*v2 + 12*a4*y + 4*a3*u*y - 40*a3*v*y + 12*a3*y2;
      *(result+3) = 180*a5 - 18*a4*u - 36*a3*u2 - 3*a2*u3 - 504*a4*v + 120*a3*u*v + 40*a2*u2*v + 384*a3*v2 - 96*a2*u*v2 - 64*a2*v3 - 18*a4*y - 12*a3*u*y + 5*a2*u2*y + 120*a3*v*y - 8*a2*u*v*y - 96*a2*v2*y - 36*a3*y2 + 5*a2*u*y2 + 40*a2*v*y2 - 3*a2*y3;
      *(result+4) = -90*a5 + 12*a4*u + 36*a3*u2 + 6*a2*u3 + 336*a4*v - 120*a3*u*v - 80*a2*u2*v - 4*a*u3*v - 384*a3*v2 + 192*a2*u*v2 + 32*a*u2*v2 + 128*a2*v3 - 64*a*u*v3 + 12*a4*y + 12*a3*u*y - 10*a2*u2*y - 2*a*u3*y - 120*a3*v*y + 16*a2*u*v*y + 28*a*u2*v*y + 192*a2*v2*y - 64*a*u*v2*y - 64*a*v3*y + 36*a3*y2 - 10*a2*u*y2 - 6*a*u2*y2 - 80*a2*v*y2 + 28*a*u*v*y2 + 32*a*v2*y2 + 6*a2*y3 - 2*a*u*y3 - 4*a*v*y3;
      *(result+5) = 18*a5 - 3*a4*u - 12*a3*u2 - 3*a2*u3 - 84*a4*v + 40*a3*u*v + 40*a2*u2*v + 4*a*u3*v + 128*a3*v2 - 96*a2*u*v2 - 32*a*u2*v2 - 64*a2*v3 + 64*a*u*v3 - 3*a4*y - 4*a3*u*y + 5*a2*u2*y + 2*a*u3*y + 40*a3*v*y - 8*a2*u*v*y - 28*a*u2*v*y - 4*u3*v*y - 96*a2*v2*y + 64*a*u*v2*y + 32*u2*v2*y + 64*a*v3*y - 64*u*v3*y - 12*a3*y2 + 5*a2*u*y2 + 6*a*u2*y2 + u3*y2 + 40*a2*v*y2 - 28*a*u*v*y2 - 12*u2*v*y2 - 32*a*v2*y2 + 32*u*v2*y2 - 3*a2*y3 + 2*a*u*y3 + u2*y3 + 4*a*v*y3 - 4*u*v*y3;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME2(u,y) && SAME2(v,z))
    {
      *(result) = -6*a5;
      *(result+1) = 30*a5 - 10*a4*u - 10*a4*v - 3*a4*w - 7*a4*x;
      *(result+2) = -60*a5 + 40*a4*u + 4*a3*u2 + 40*a4*v - 24*a3*u*v + 4*a3*v2 + 12*a4*w - 8*a3*u*w - 8*a3*v*w + 3*a3*w2 + 28*a4*x - 16*a3*u*x - 16*a3*v*x - 2*a3*w*x + 3*a3*x2;
      *(result+3) = 60*a5 - 60*a4*u - 12*a3*u2 + 12*a2*u3 - 60*a4*v + 72*a3*u*v - 12*a2*u2*v - 12*a3*v2 - 12*a2*u*v2 + 12*a2*v3 - 18*a4*w + 24*a3*u*w - 6*a2*u2*w + 24*a3*v*w - 4*a2*u*v*w - 6*a2*v2*w - 9*a3*w2 + 2*a2*u*w2 + 2*a2*v*w2 - 42*a4*x + 48*a3*u*x - 6*a2*u2*x + 48*a3*v*x - 20*a2*u*v*x - 6*a2*v2*x + 6*a3*w*x - 12*a2*u*w*x - 12*a2*v*w*x + 5*a2*w2*x - 9*a3*x2 - 2*a2*u*x2 - 2*a2*v*x2 + 4*a2*w*x2 + 3*a2*x3;
      *(result+4) = -30*a5 + 40*a4*u + 12*a3*u2 - 24*a2*u3 + 2*a*u4 + 40*a4*v - 72*a3*u*v + 24*a2*u2*v + 8*a*u3*v + 12*a3*v2 + 24*a2*u*v2 - 20*a*u2*v2 - 24*a2*v3 + 8*a*u*v3 + 2*a*v4 + 12*a4*w - 24*a3*u*w + 12*a2*u2*w - 24*a3*v*w + 8*a2*u*v*w + 12*a2*v2*w + 9*a3*w2 - 4*a2*u*w2 - a*u2*w2 - 4*a2*v*w2 + 2*a*u*v*w2 - a*v2*w2 + 28*a4*x - 48*a3*u*x + 12*a2*u2*x + 8*a*u3*x - 48*a3*v*x + 40*a2*u*v*x - 8*a*u2*v*x + 12*a2*v2*x - 8*a*u*v2*x + 8*a*v3*x - 6*a3*w*x + 24*a2*u*w*x - 10*a*u2*w*x + 24*a2*v*w*x - 12*a*u*v*w*x - 10*a*v2*w*x - 10*a2*w2*x + 4*a*u*w2*x + 4*a*v*w2*x + 9*a3*x2 + 4*a2*u*x2 - 9*a*u2*x2 + 4*a2*v*x2 + 2*a*u*v*x2 - 9*a*v2*x2 - 8*a2*w*x2 + a*w2*x2 - 6*a2*x3 + 4*a*u*x3 + 4*a*v*x3 + 2*a*w*x3 - a*x4;
      *(result+5) = 6*a5 - 10*a4*u - 4*a3*u2 + 12*a2*u3 - 2*a*u4 - 2*u5 - 10*a4*v + 24*a3*u*v - 12*a2*u2*v - 8*a*u3*v + 6*u4*v - 4*a3*v2 - 12*a2*u*v2 + 20*a*u2*v2 - 4*u3*v2 + 12*a2*v3 - 8*a*u*v3 - 4*u2*v3 - 2*a*v4 + 6*u*v4 - 2*v5 - 3*a4*w + 8*a3*u*w - 6*a2*u2*w + u4*w + 8*a3*v*w - 4*a2*u*v*w - 4*u3*v*w - 6*a2*v2*w + 6*u2*v2*w - 4*u*v3*w + v4*w - 3*a3*w2 + 2*a2*u*w2 + a*u2*w2 + 2*a2*v*w2 - 2*a*u*v*w2 + a*v2*w2 - 7*a4*x + 16*a3*u*x - 6*a2*u2*x - 8*a*u3*x + 5*u4*x + 16*a3*v*x - 20*a2*u*v*x + 8*a*u2*v*x - 4*u3*v*x - 6*a2*v2*x + 8*a*u*v2*x - 2*u2*v2*x - 8*a*v3*x - 4*u*v3*x + 5*v4*x + 2*a3*w*x - 12*a2*u*w*x + 10*a*u2*w*x - 12*a2*v*w*x + 12*a*u*v*w*x + 10*a*v2*w*x + 5*a2*w2*x - 4*a*u*w2*x - u2*w2*x - 4*a*v*w2*x + 2*u*v*w2*x - v2*w2*x - 3*a3*x2 - 2*a2*u*x2 + 9*a*u2*x2 - 4*u3*x2 - 2*a2*v*x2 - 2*a*u*v*x2 + 4*u2*v*x2 + 9*a*v2*x2 + 4*u*v2*x2 - 4*v3*x2 + 4*a2*w*x2 - 4*u2*w*x2 - 8*u*v*w*x2 - 4*v2*w*x2 - a*w2*x2 + 2*u*w2*x2 + 2*v*w2*x2 + 3*a2*x3 - 4*a*u*x3 + u2*x3 - 4*a*v*x3 - 2*u*v*x3 + v2*x3 - 2*a*w*x3 + 4*u*w*x3 + 4*v*w*x3 - w2*x3 + a*x4 - w*x4;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME2(u,z) && SAME2(v,y))
    {
      *(result) = -6*a5;
      *(result+1) = 30*a5 - 10*a4*u - 10*a4*v - 3*a4*w - 7*a4*x;
      *(result+2) = -60*a5 + 40*a4*u + a3*u2 + 40*a4*v - 18*a3*u*v + a3*v2 + 12*a4*w - 8*a3*u*w - 8*a3*v*w + 3*a3*w2 + 28*a4*x - 16*a3*u*x - 16*a3*v*x - 2*a3*w*x + 3*a3*x2;
      *(result+3) = 60*a5 - 60*a4*u - 3*a3*u2 + 4*a2*u3 - 60*a4*v + 54*a3*u*v - 4*a2*u2*v - 3*a3*v2 - 4*a2*u*v2 + 4*a2*v3 - 18*a4*w + 24*a3*u*w + 24*a3*v*w - 16*a2*u*v*w - 9*a3*w2 + 2*a2*u*w2 + 2*a2*v*w2 - 42*a4*x + 48*a3*u*x - 5*a2*u2*x + 48*a3*v*x - 22*a2*u*v*x - 5*a2*v2*x + 6*a3*w*x - 12*a2*u*w*x - 12*a2*v*w*x + 5*a2*w2*x - 9*a3*x2 - 2*a2*u*x2 - 2*a2*v*x2 + 4*a2*w*x2 + 3*a2*x3;
      *(result+4) = -30*a5 + 40*a4*u + 3*a3*u2 - 8*a2*u3 - a*u4 + 40*a4*v - 54*a3*u*v + 8*a2*u2*v + 4*a*u3*v + 3*a3*v2 + 8*a2*u*v2 - 6*a*u2*v2 - 8*a2*v3 + 4*a*u*v3 - a*v4 + 12*a4*w - 24*a3*u*w + 4*a*u3*w - 24*a3*v*w + 32*a2*u*v*w - 4*a*u2*v*w - 4*a*u*v2*w + 4*a*v3*w + 9*a3*w2 - 4*a2*u*w2 - a*u2*w2 - 4*a2*v*w2 + 2*a*u*v*w2 - a*v2*w2 + 28*a4*x - 48*a3*u*x + 10*a2*u2*x + 4*a*u3*x - 48*a3*v*x + 44*a2*u*v*x - 4*a*u2*v*x + 10*a2*v2*x - 4*a*u*v2*x + 4*a*v3*x - 6*a3*w*x + 24*a2*u*w*x - 6*a*u2*w*x + 24*a2*v*w*x - 20*a*u*v*w*x - 6*a*v2*w*x - 10*a2*w2*x + 4*a*u*w2*x + 4*a*v*w2*x + 9*a3*x2 + 4*a2*u*x2 - 6*a*u2*x2 + 4*a2*v*x2 - 4*a*u*v*x2 - 6*a*v2*x2 - 8*a2*w*x2 + a*w2*x2 - 6*a2*x3 + 4*a*u*x3 + 4*a*v*x3 + 2*a*w*x3 - a*x4;
      *(result+5) = 6*a5 - 10*a4*u - a3*u2 + 4*a2*u3 + a*u4 - 10*a4*v + 18*a3*u*v - 4*a2*u2*v - 4*a*u3*v - a3*v2 - 4*a2*u*v2 + 6*a*u2*v2 + 4*a2*v3 - 4*a*u*v3 + a*v4 - 3*a4*w + 8*a3*u*w - 4*a*u3*w - u4*w + 8*a3*v*w - 16*a2*u*v*w + 4*a*u2*v*w + 4*u3*v*w + 4*a*u*v2*w - 6*u2*v2*w - 4*a*v3*w + 4*u*v3*w - v4*w - 3*a3*w2 + 2*a2*u*w2 + a*u2*w2 + 2*a2*v*w2 - 2*a*u*v*w2 + a*v2*w2 - 7*a4*x + 16*a3*u*x - 5*a2*u2*x - 4*a*u3*x + 16*a3*v*x - 22*a2*u*v*x + 4*a*u2*v*x - 5*a2*v2*x + 4*a*u*v2*x - 4*a*v3*x + 2*a3*w*x - 12*a2*u*w*x + 6*a*u2*w*x + 4*u3*w*x - 12*a2*v*w*x + 20*a*u*v*w*x - 4*u2*v*w*x + 6*a*v2*w*x - 4*u*v2*w*x + 4*v3*w*x + 5*a2*w2*x - 4*a*u*w2*x - u2*w2*x - 4*a*v*w2*x + 2*u*v*w2*x - v2*w2*x - 3*a3*x2 - 2*a2*u*x2 + 6*a*u2*x2 - 2*a2*v*x2 + 4*a*u*v*x2 + 6*a*v2*x2 + 4*a2*w*x2 - 6*u2*w*x2 - 4*u*v*w*x2 - 6*v2*w*x2 - a*w2*x2 + 2*u*w2*x2 + 2*v*w2*x2 + 3*a2*x3 - 4*a*u*x3 - 4*a*v*x3 - 2*a*w*x3 + 4*u*w*x3 + 4*v*w*x3 - w2*x3 + a*x4 - w*x4;
      *(result+6) = 0;
      *(result+7) = 0;
    }
  else if (SAME4(u,w,x,z))
    {
      *(result) = 18*a6;
      *(result+1) = -108*a6 + 66*a5*u + 21*a5*v + 21*a5*y;
      *(result+2) = 270*a6 - 330*a5*u + 71*a4*u2 - 105*a5*v + 94*a4*u*v - 9*a4*v2 - 105*a5*y + 94*a4*u*y + 29*a4*v*y - 9*a4*y2;
      *(result+3) = -360*a6 + 660*a5*u - 284*a4*u2 + 8*a3*u3 + 210*a5*v - 376*a4*u*v + 130*a3*u2*v + 36*a4*v2 - 6*a3*u*v2 - 9*a3*v3 + 210*a5*y - 376*a4*u*y + 130*a3*u2*y - 116*a4*v*y + 128*a3*u*v*y - 3*a3*v2*y + 36*a4*y2 - 6*a3*u*y2 - 3*a3*v*y2 - 9*a3*y3;
      *(result+4) = 270*a6 - 660*a5*u + 426*a4*u2 - 24*a3*u3 - 16*a2*u4 - 210*a5*v + 564*a4*u*v - 390*a3*u2*v + 44*a2*u3*v - 54*a4*v2 + 18*a3*u*v2 + 35*a2*u2*v2 + 27*a3*v3 - 30*a2*u*v3 + 3*a2*v4 - 210*a5*y + 564*a4*u*y - 390*a3*u2*y + 44*a2*u3*y + 174*a4*v*y - 384*a3*u*v*y + 188*a2*u2*v*y + 9*a3*v2*y + 2*a2*u*v2*y - 9*a2*v3*y - 54*a4*y2 + 18*a3*u*y2 + 35*a2*u2*y2 + 9*a3*v*y2 + 2*a2*u*v*y2 + 8*a2*v2*y2 + 27*a3*y3 - 30*a2*u*y3 - 9*a2*v*y3 + 3*a2*y4;
      *(result+5) = -108*a6 + 330*a5*u - 284*a4*u2 + 24*a3*u3 + 32*a2*u4 + 105*a5*v - 376*a4*u*v + 390*a3*u2*v - 88*a2*u3*v - 16*a*u4*v + 36*a4*v2 - 18*a3*u*v2 - 70*a2*u2*v2 + 36*a*u3*v2 - 27*a3*v3 + 60*a2*u*v3 - 24*a*u2*v3 - 6*a2*v4 + 4*a*u*v4 + 105*a5*y - 376*a4*u*y + 390*a3*u2*y - 88*a2*u3*y - 16*a*u4*y - 116*a4*v*y + 384*a3*u*v*y - 376*a2*u2*v*y + 80*a*u3*v*y - 9*a3*v2*y - 4*a2*u*v2*y + 34*a*u2*v2*y + 18*a2*v3*y - 28*a*u*v3*y + 2*a*v4*y + 36*a4*y2 - 18*a3*u*y2 - 70*a2*u2*y2 + 36*a*u3*y2 - 9*a3*v*y2 - 4*a2*u*v*y2 + 34*a*u2*v*y2 - 16*a2*v2*y2 + 10*a*u*v2*y2 + a*v3*y2 - 27*a3*y3 + 60*a2*u*y3 - 24*a*u2*y3 + 18*a2*v*y3 - 28*a*u*v*y3 + a*v2*y3 - 6*a2*y4 + 4*a*u*y4 + 2*a*v*y4;
      *(result+6) = 18*a6 - 66*a5*u + 71*a4*u2 - 8*a3*u3 - 16*a2*u4 - 21*a5*v + 94*a4*u*v - 130*a3*u2*v + 44*a2*u3*v + 16*a*u4*v - 9*a4*v2 + 6*a3*u*v2 + 35*a2*u2*v2 - 36*a*u3*v2 + 9*a3*v3 - 30*a2*u*v3 + 24*a*u2*v3 + 3*a2*v4 - 4*a*u*v4 - 21*a5*y + 94*a4*u*y - 130*a3*u2*y + 44*a2*u3*y + 16*a*u4*y + 29*a4*v*y - 128*a3*u*v*y + 188*a2*u2*v*y - 80*a*u3*v*y - 16*u4*v*y + 3*a3*v2*y + 2*a2*u*v2*y - 34*a*u2*v2*y + 36*u3*v2*y - 9*a2*v3*y + 28*a*u*v3*y - 24*u2*v3*y - 2*a*v4*y + 4*u*v4*y - 9*a4*y2 + 6*a3*u*y2 + 35*a2*u2*y2 - 36*a*u3*y2 + 3*a3*v*y2 + 2*a2*u*v*y2 - 34*a*u2*v*y2 + 36*u3*v*y2 + 8*a2*v2*y2 - 10*a*u*v2*y2 - u2*v2*y2 - a*v3*y2 + 2*u*v3*y2 - v4*y2 + 9*a3*y3 - 30*a2*u*y3 + 24*a*u2*y3 - 9*a2*v*y3 + 28*a*u*v*y3 - 24*u2*v*y3 - a*v2*y3 + 2*u*v2*y3 + v3*y3 + 3*a2*y4 - 4*a*u*y4 - 2*a*v*y4 + 4*u*v*y4 - v2*y4;
      *(result+7) = 0;
    }
  else if (SAME4(v,w,x,y))
    {
      *(result) = 18*a6;
      *(result+1) = -108*a6 + 21*a5*u + 66*a5*v + 21*a5*z;
      *(result+2) = 270*a6 - 105*a5*u - 9*a4*u2 - 330*a5*v + 94*a4*u*v + 71*a4*v2 - 105*a5*z + 29*a4*u*z + 94*a4*v*z - 9*a4*z2;
      *(result+3) = -360*a6 + 210*a5*u + 36*a4*u2 - 9*a3*u3 + 660*a5*v - 376*a4*u*v - 6*a3*u2*v - 284*a4*v2 + 130*a3*u*v2 + 8*a3*v3 + 210*a5*z - 116*a4*u*z - 3*a3*u2*z - 376*a4*v*z + 128*a3*u*v*z + 130*a3*v2*z + 36*a4*z2 - 3*a3*u*z2 - 6*a3*v*z2 - 9*a3*z3;
      *(result+4) = 270*a6 - 210*a5*u - 54*a4*u2 + 27*a3*u3 + 3*a2*u4 - 660*a5*v + 564*a4*u*v + 18*a3*u2*v - 30*a2*u3*v + 426*a4*v2 - 390*a3*u*v2 + 35*a2*u2*v2 - 24*a3*v3 + 44*a2*u*v3 - 16*a2*v4 - 210*a5*z + 174*a4*u*z + 9*a3*u2*z - 9*a2*u3*z + 564*a4*v*z - 384*a3*u*v*z + 2*a2*u2*v*z - 390*a3*v2*z + 188*a2*u*v2*z + 44*a2*v3*z - 54*a4*z2 + 9*a3*u*z2 + 8*a2*u2*z2 + 18*a3*v*z2 + 2*a2*u*v*z2 + 35*a2*v2*z2 + 27*a3*z3 - 9*a2*u*z3 - 30*a2*v*z3 + 3*a2*z4;
      *(result+5) = -108*a6 + 105*a5*u + 36*a4*u2 - 27*a3*u3 - 6*a2*u4 + 330*a5*v - 376*a4*u*v - 18*a3*u2*v + 60*a2*u3*v + 4*a*u4*v - 284*a4*v2 + 390*a3*u*v2 - 70*a2*u2*v2 - 24*a*u3*v2 + 24*a3*v3 - 88*a2*u*v3 + 36*a*u2*v3 + 32*a2*v4 - 16*a*u*v4 + 105*a5*z - 116*a4*u*z - 9*a3*u2*z + 18*a2*u3*z + 2*a*u4*z - 376*a4*v*z + 384*a3*u*v*z - 4*a2*u2*v*z - 28*a*u3*v*z + 390*a3*v2*z - 376*a2*u*v2*z + 34*a*u2*v2*z - 88*a2*v3*z + 80*a*u*v3*z - 16*a*v4*z + 36*a4*z2 - 9*a3*u*z2 - 16*a2*u2*z2 + a*u3*z2 - 18*a3*v*z2 - 4*a2*u*v*z2 + 10*a*u2*v*z2 - 70*a2*v2*z2 + 34*a*u*v2*z2 + 36*a*v3*z2 - 27*a3*z3 + 18*a2*u*z3 + a*u2*z3 + 60*a2*v*z3 - 28*a*u*v*z3 - 24*a*v2*z3 - 6*a2*z4 + 2*a*u*z4 + 4*a*v*z4;
      *(result+6) = 18*a6 - 21*a5*u - 9*a4*u2 + 9*a3*u3 + 3*a2*u4 - 66*a5*v + 94*a4*u*v + 6*a3*u2*v - 30*a2*u3*v - 4*a*u4*v + 71*a4*v2 - 130*a3*u*v2 + 35*a2*u2*v2 + 24*a*u3*v2 - 8*a3*v3 + 44*a2*u*v3 - 36*a*u2*v3 - 16*a2*v4 + 16*a*u*v4 - 21*a5*z + 29*a4*u*z + 3*a3*u2*z - 9*a2*u3*z - 2*a*u4*z + 94*a4*v*z - 128*a3*u*v*z + 2*a2*u2*v*z + 28*a*u3*v*z + 4*u4*v*z - 130*a3*v2*z + 188*a2*u*v2*z - 34*a*u2*v2*z - 24*u3*v2*z + 44*a2*v3*z - 80*a*u*v3*z + 36*u2*v3*z + 16*a*v4*z - 16*u*v4*z - 9*a4*z2 + 3*a3*u*z2 + 8*a2*u2*z2 - a*u3*z2 - u4*z2 + 6*a3*v*z2 + 2*a2*u*v*z2 - 10*a*u2*v*z2 + 2*u3*v*z2 + 35*a2*v2*z2 - 34*a*u*v2*z2 - u2*v2*z2 - 36*a*v3*z2 + 36*u*v3*z2 + 9*a3*z3 - 9*a2*u*z3 - a*u2*z3 + u3*z3 - 30*a2*v*z3 + 28*a*u*v*z3 + 2*u2*v*z3 + 24*a*v2*z3 - 24*u*v2*z3 + 3*a2*z4 - 2*a*u*z4 - u2*z4 - 4*a*v*z4 + 4*u*v*z4;
      *(result+7) = 0;
    }
  else if (SAME2(u,w) && SAME2(x,y))
    {
      *(result) = 18*a6;
      *(result+1) = -108*a6 + 30*a5*u + 21*a5*v + 54*a5*x + 3*a5*z;
      *(result+2) = 270*a6 - 150*a5*u - 3*a4*u2 - 105*a5*v + 48*a4*u*v - 9*a4*v2 - 270*a5*x + 94*a4*u*x + 76*a4*v*x + 37*a4*x2 - 15*a5*z + 14*a4*u*z - a4*v*z + 26*a4*x*z - 12*a4*z2;
      *(result+3) = -360*a6 + 300*a5*u + 12*a4*u2 - 12*a3*u3 + 210*a5*v - 192*a4*u*v + 15*a3*u2*v + 36*a4*v2 + 6*a3*u*v2 - 9*a3*v3 + 540*a5*x - 376*a4*u*x + 8*a3*u2*x - 304*a4*v*x + 130*a3*u*v*x - 6*a3*v2*x - 148*a4*x2 + 84*a3*u*x2 + 79*a3*v*x2 - 16*a3*x3 + 30*a5*z - 56*a4*u*z + a3*u2*z + 4*a4*v*z + 20*a3*u*v*z - 9*a3*v2*z - 104*a4*x*z + 62*a3*u*x*z + 28*a3*v*x*z + 33*a3*x2*z + 48*a4*z2 - 14*a3*u*z2 - 17*a3*v*z2 - 26*a3*x*z2 + 3*a3*z3;
      *(result+4) = 270*a6 - 300*a5*u - 18*a4*u2 + 36*a3*u3 + 3*a2*u4 - 210*a5*v + 288*a4*u*v - 45*a3*u2*v - 12*a2*u3*v - 54*a4*v2 - 18*a3*u*v2 + 18*a2*u2*v2 + 27*a3*v3 - 12*a2*u*v3 + 3*a2*v4 - 540*a5*x + 564*a4*u*x - 24*a3*u2*x - 28*a2*u3*x + 456*a4*v*x - 390*a3*u*v*x + 32*a2*u2*v*x + 18*a3*v2*x + 20*a2*u*v2*x - 24*a2*v3*x + 222*a4*x2 - 252*a3*u*x2 + 34*a2*u2*x2 - 237*a3*v*x2 + 100*a2*u*v*x2 + 26*a2*v2*x2 + 48*a3*x3 + 4*a2*u*x3 + 8*a2*v*x3 - 13*a2*x4 - 30*a5*z + 84*a4*u*z - 3*a3*u2*z - 8*a2*u3*z - 6*a4*v*z - 60*a3*u*v*z + 13*a2*u2*v*z + 27*a3*v2*z - 2*a2*u*v2*z - 3*a2*v3*z + 156*a4*x*z - 186*a3*u*x*z + 8*a2*u2*x*z - 84*a3*v*x*z + 86*a2*u*v*x*z - 18*a2*v2*x*z - 99*a3*x2*z + 72*a2*u*x2*z + 61*a2*v*x2*z - 8*a2*x3*z - 72*a4*z2 + 42*a3*u*z2 + 3*a2*u2*z2 + 51*a3*v*z2 - 24*a2*u*v*z2 + a2*v2*z2 + 78*a3*x*z2 - 30*a2*u*x*z2 - 44*a2*v*x*z2 - 5*a2*x2*z2 - 9*a3*z3 + 2*a2*u*z3 + 5*a2*v*z3 + 2*a2*x*z3;
      *(result+5) = -108*a6 + 150*a5*u + 12*a4*u2 - 36*a3*u3 - 6*a2*u4 + 105*a5*v - 192*a4*u*v + 45*a3*u2*v + 24*a2*u3*v + 36*a4*v2 + 18*a3*u*v2 - 36*a2*u2*v2 - 27*a3*v3 + 24*a2*u*v3 - 6*a2*v4 + 270*a5*x - 376*a4*u*x + 24*a3*u2*x + 56*a2*u3*x + 4*a*u4*x - 304*a4*v*x + 390*a3*u*v*x - 64*a2*u2*v*x - 16*a*u3*v*x - 18*a3*v2*x - 40*a2*u*v2*x + 24*a*u2*v2*x + 48*a2*v3*x - 16*a*u*v3*x + 4*a*v4*x - 148*a4*x2 + 252*a3*u*x2 - 68*a2*u2*x2 - 16*a*u3*x2 + 237*a3*v*x2 - 200*a2*u*v*x2 + 16*a*u2*v*x2 - 52*a2*v2*x2 + 16*a*u*v2*x2 - 16*a*v3*x2 - 48*a3*x3 - 8*a2*u*x3 + 24*a*u2*x3 - 16*a2*v*x3 + 16*a*u*v*x3 + 24*a*v2*x3 + 26*a2*x4 - 16*a*u*x4 - 16*a*v*x4 + 4*a*x5 + 15*a5*z - 56*a4*u*z + 3*a3*u2*z + 16*a2*u3*z + 2*a*u4*z + 4*a4*v*z + 60*a3*u*v*z - 26*a2*u2*v*z - 8*a*u3*v*z - 27*a3*v2*z + 4*a2*u*v2*z + 12*a*u2*v2*z + 6*a2*v3*z - 8*a*u*v3*z + 2*a*v4*z - 104*a4*x*z + 186*a3*u*x*z - 16*a2*u2*x*z - 24*a*u3*x*z + 84*a3*v*x*z - 172*a2*u*v*x*z + 32*a*u2*v*x*z + 36*a2*v2*x*z + 8*a*u*v2*x*z - 16*a*v3*x*z + 99*a3*x2*z - 144*a2*u*x2*z + 28*a*u2*x2*z - 122*a2*v*x2*z + 88*a*u*v*x2*z + 12*a*v2*x2*z + 16*a2*x3*z + 8*a*u*x3*z + 16*a*v*x3*z - 14*a*x4*z + 48*a4*z2 - 42*a3*u*z2 - 6*a2*u2*z2 + 4*a*u3*z2 - 51*a3*v*z2 + 48*a2*u*v*z2 - 3*a*u2*v*z2 - 2*a2*v2*z2 - 6*a*u*v2*z2 + 5*a*v3*z2 - 78*a3*x*z2 + 60*a2*u*x*z2 + 88*a2*v*x*z2 - 42*a*u*v*x*z2 - 10*a*v2*x*z2 + 10*a2*x2*z2 - 12*a*u*x2*z2 - 19*a*v*x2*z2 + 8*a*x3*z2 + 9*a3*z3 - 4*a2*u*z3 - a*u2*z3 - 10*a2*v*z3 + 4*a*u*v*z3 + a*v2*z3 - 4*a2*x*z3 + 2*a*u*x*z3 + 4*a*v*x*z3 - a*x2*z3;
      *(result+6) = 18*a6 - 30*a5*u - 3*a4*u2 + 12*a3*u3 + 3*a2*u4 - 21*a5*v + 48*a4*u*v - 15*a3*u2*v - 12*a2*u3*v - 9*a4*v2 - 6*a3*u*v2 + 18*a2*u2*v2 + 9*a3*v3 - 12*a2*u*v3 + 3*a2*v4 - 54*a5*x + 94*a4*u*x - 8*a3*u2*x - 28*a2*u3*x - 4*a*u4*x + 76*a4*v*x - 130*a3*u*v*x + 32*a2*u2*v*x + 16*a*u3*v*x + 6*a3*v2*x + 20*a2*u*v2*x - 24*a*u2*v2*x - 24*a2*v3*x + 16*a*u*v3*x - 4*a*v4*x + 37*a4*x2 - 84*a3*u*x2 + 34*a2*u2*x2 + 16*a*u3*x2 - 79*a3*v*x2 + 100*a2*u*v*x2 - 16*a*u2*v*x2 + 26*a2*v2*x2 - 16*a*u*v2*x2 + 16*a*v3*x2 + 16*a3*x3 + 4*a2*u*x3 - 24*a*u2*x3 + 8*a2*v*x3 - 16*a*u*v*x3 - 24*a*v2*x3 - 13*a2*x4 + 16*a*u*x4 + 16*a*v*x4 - 4*a*x5 - 3*a5*z + 14*a4*u*z - a3*u2*z - 8*a2*u3*z - 2*a*u4*z - a4*v*z - 20*a3*u*v*z + 13*a2*u2*v*z + 8*a*u3*v*z + 9*a3*v2*z - 2*a2*u*v2*z - 12*a*u2*v2*z - 3*a2*v3*z + 8*a*u*v3*z - 2*a*v4*z + 26*a4*x*z - 62*a3*u*x*z + 8*a2*u2*x*z + 24*a*u3*x*z + 4*u4*x*z - 28*a3*v*x*z + 86*a2*u*v*x*z - 32*a*u2*v*x*z - 16*u3*v*x*z - 18*a2*v2*x*z - 8*a*u*v2*x*z + 24*u2*v2*x*z + 16*a*v3*x*z - 16*u*v3*x*z + 4*v4*x*z - 33*a3*x2*z + 72*a2*u*x2*z - 28*a*u2*x2*z - 16*u3*x2*z + 61*a2*v*x2*z - 88*a*u*v*x2*z + 16*u2*v*x2*z - 12*a*v2*x2*z + 16*u*v2*x2*z - 16*v3*x2*z - 8*a2*x3*z - 8*a*u*x3*z + 24*u2*x3*z - 16*a*v*x3*z + 16*u*v*x3*z + 24*v2*x3*z + 14*a*x4*z - 16*u*x4*z - 16*v*x4*z + 4*x5*z - 12*a4*z2 + 14*a3*u*z2 + 3*a2*u2*z2 - 4*a*u3*z2 - u4*z2 + 17*a3*v*z2 - 24*a2*u*v*z2 + 3*a*u2*v*z2 + 4*u3*v*z2 + a2*v2*z2 + 6*a*u*v2*z2 - 6*u2*v2*z2 - 5*a*v3*z2 + 4*u*v3*z2 - v4*z2 + 26*a3*x*z2 - 30*a2*u*x*z2 + 4*u3*x*z2 - 44*a2*v*x*z2 + 42*a*u*v*x*z2 + 10*a*v2*x*z2 - 12*u*v2*x*z2 + 8*v3*x*z2 - 5*a2*x2*z2 + 12*a*u*x2*z2 - 6*u2*x2*z2 + 19*a*v*x2*z2 - 12*u*v*x2*z2 - 14*v2*x2*z2 - 8*a*x3*z2 + 4*u*x3*z2 + 8*v*x3*z2 - x4*z2 - 3*a3*z3 + 2*a2*u*z3 + a*u2*z3 + 5*a2*v*z3 - 4*a*u*v*z3 - u2*v*z3 - a*v2*z3 + 2*u*v2*z3 - v3*z3 + 2*a2*x*z3 - 2*a*u*x*z3 - 4*a*v*x*z3 + 2*u*v*x*z3 + 2*v2*x*z3 + a*x2*z3 - v*x2*z3;
      *(result+7) = 0;
    }
  else if (SAME2(u,x) && SAME2(w,y))
    {
      *(result) = 18*a6;
      *(result+1) = -108*a6 + 54*a5*u + 3*a5*v + 30*a5*w + 21*a5*z;
      *(result+2) = 270*a6 - 270*a5*u + 37*a4*u2 - 15*a5*v + 26*a4*u*v - 12*a4*v2 - 150*a5*w + 94*a4*u*w + 14*a4*v*w - 3*a4*w2 - 105*a5*z + 76*a4*u*z - a4*v*z + 48*a4*w*z - 9*a4*z2;
      *(result+3) = -360*a6 + 540*a5*u - 148*a4*u2 - 16*a3*u3 + 30*a5*v - 104*a4*u*v + 33*a3*u2*v + 48*a4*v2 - 26*a3*u*v2 + 3*a3*v3 + 300*a5*w - 376*a4*u*w + 84*a3*u2*w - 56*a4*v*w + 62*a3*u*v*w - 14*a3*v2*w + 12*a4*w2 + 8*a3*u*w2 + a3*v*w2 - 12*a3*w3 + 210*a5*z - 304*a4*u*z + 79*a3*u2*z + 4*a4*v*z + 28*a3*u*v*z - 17*a3*v2*z - 192*a4*w*z + 130*a3*u*w*z + 20*a3*v*w*z + 15*a3*w2*z + 36*a4*z2 - 6*a3*u*z2 - 9*a3*v*z2 + 6*a3*w*z2 - 9*a3*z3;
      *(result+4) = 270*a6 - 540*a5*u + 222*a4*u2 + 48*a3*u3 - 13*a2*u4 - 30*a5*v + 156*a4*u*v - 99*a3*u2*v - 8*a2*u3*v - 72*a4*v2 + 78*a3*u*v2 - 5*a2*u2*v2 - 9*a3*v3 + 2*a2*u*v3 - 300*a5*w + 564*a4*u*w - 252*a3*u2*w + 4*a2*u3*w + 84*a4*v*w - 186*a3*u*v*w + 72*a2*u2*v*w + 42*a3*v2*w - 30*a2*u*v2*w + 2*a2*v3*w - 18*a4*w2 - 24*a3*u*w2 + 34*a2*u2*w2 - 3*a3*v*w2 + 8*a2*u*v*w2 + 3*a2*v2*w2 + 36*a3*w3 - 28*a2*u*w3 - 8*a2*v*w3 + 3*a2*w4 - 210*a5*z + 456*a4*u*z - 237*a3*u2*z + 8*a2*u3*z - 6*a4*v*z - 84*a3*u*v*z + 61*a2*u2*v*z + 51*a3*v2*z - 44*a2*u*v2*z + 5*a2*v3*z + 288*a4*w*z - 390*a3*u*w*z + 100*a2*u2*w*z - 60*a3*v*w*z + 86*a2*u*v*w*z - 24*a2*v2*w*z - 45*a3*w2*z + 32*a2*u*w2*z + 13*a2*v*w2*z - 12*a2*w3*z - 54*a4*z2 + 18*a3*u*z2 + 26*a2*u2*z2 + 27*a3*v*z2 - 18*a2*u*v*z2 + a2*v2*z2 - 18*a3*w*z2 + 20*a2*u*w*z2 - 2*a2*v*w*z2 + 18*a2*w2*z2 + 27*a3*z3 - 24*a2*u*z3 - 3*a2*v*z3 - 12*a2*w*z3 + 3*a2*z4;
      *(result+5) = -108*a6 + 270*a5*u - 148*a4*u2 - 48*a3*u3 + 26*a2*u4 + 4*a*u5 + 15*a5*v - 104*a4*u*v + 99*a3*u2*v + 16*a2*u3*v - 14*a*u4*v + 48*a4*v2 - 78*a3*u*v2 + 10*a2*u2*v2 + 8*a*u3*v2 + 9*a3*v3 - 4*a2*u*v3 - a*u2*v3 + 150*a5*w - 376*a4*u*w + 252*a3*u2*w - 8*a2*u3*w - 16*a*u4*w - 56*a4*v*w + 186*a3*u*v*w - 144*a2*u2*v*w + 8*a*u3*v*w - 42*a3*v2*w + 60*a2*u*v2*w - 12*a*u2*v2*w - 4*a2*v3*w + 2*a*u*v3*w + 12*a4*w2 + 24*a3*u*w2 - 68*a2*u2*w2 + 24*a*u3*w2 + 3*a3*v*w2 - 16*a2*u*v*w2 + 28*a*u2*v*w2 - 6*a2*v2*w2 - a*v3*w2 - 36*a3*w3 + 56*a2*u*w3 - 16*a*u2*w3 + 16*a2*v*w3 - 24*a*u*v*w3 + 4*a*v2*w3 - 6*a2*w4 + 4*a*u*w4 + 2*a*v*w4 + 105*a5*z - 304*a4*u*z + 237*a3*u2*z - 16*a2*u3*z - 16*a*u4*z + 4*a4*v*z + 84*a3*u*v*z - 122*a2*u2*v*z + 16*a*u3*v*z - 51*a3*v2*z + 88*a2*u*v2*z - 19*a*u2*v2*z - 10*a2*v3*z + 4*a*u*v3*z - 192*a4*w*z + 390*a3*u*w*z - 200*a2*u2*w*z + 16*a*u3*w*z + 60*a3*v*w*z - 172*a2*u*v*w*z + 88*a*u2*v*w*z + 48*a2*v2*w*z - 42*a*u*v2*w*z + 4*a*v3*w*z + 45*a3*w2*z - 64*a2*u*w2*z + 16*a*u2*w2*z - 26*a2*v*w2*z + 32*a*u*v*w2*z - 3*a*v2*w2*z + 24*a2*w3*z - 16*a*u*w3*z - 8*a*v*w3*z + 36*a4*z2 - 18*a3*u*z2 - 52*a2*u2*z2 + 24*a*u3*z2 - 27*a3*v*z2 + 36*a2*u*v*z2 + 12*a*u2*v*z2 - 2*a2*v2*z2 - 10*a*u*v2*z2 + a*v3*z2 + 18*a3*w*z2 - 40*a2*u*w*z2 + 16*a*u2*w*z2 + 4*a2*v*w*z2 + 8*a*u*v*w*z2 - 6*a*v2*w*z2 - 36*a2*w2*z2 + 24*a*u*w2*z2 + 12*a*v*w2*z2 - 27*a3*z3 + 48*a2*u*z3 - 16*a*u2*z3 + 6*a2*v*z3 - 16*a*u*v*z3 + 5*a*v2*z3 + 24*a2*w*z3 - 16*a*u*w*z3 - 8*a*v*w*z3 - 6*a2*z4 + 4*a*u*z4 + 2*a*v*z4;
      *(result+6) = 18*a6 - 54*a5*u + 37*a4*u2 + 16*a3*u3 - 13*a2*u4 - 4*a*u5 - 3*a5*v + 26*a4*u*v - 33*a3*u2*v - 8*a2*u3*v + 14*a*u4*v + 4*u5*v - 12*a4*v2 + 26*a3*u*v2 - 5*a2*u2*v2 - 8*a*u3*v2 - u4*v2 - 3*a3*v3 + 2*a2*u*v3 + a*u2*v3 - 30*a5*w + 94*a4*u*w - 84*a3*u2*w + 4*a2*u3*w + 16*a*u4*w + 14*a4*v*w - 62*a3*u*v*w + 72*a2*u2*v*w - 8*a*u3*v*w - 16*u4*v*w + 14*a3*v2*w - 30*a2*u*v2*w + 12*a*u2*v2*w + 4*u3*v2*w + 2*a2*v3*w - 2*a*u*v3*w - 3*a4*w2 - 8*a3*u*w2 + 34*a2*u2*w2 - 24*a*u3*w2 - a3*v*w2 + 8*a2*u*v*w2 - 28*a*u2*v*w2 + 24*u3*v*w2 + 3*a2*v2*w2 - 6*u2*v2*w2 + a*v3*w2 + 12*a3*w3 - 28*a2*u*w3 + 16*a*u2*w3 - 8*a2*v*w3 + 24*a*u*v*w3 - 16*u2*v*w3 - 4*a*v2*w3 + 4*u*v2*w3 + 3*a2*w4 - 4*a*u*w4 - 2*a*v*w4 + 4*u*v*w4 - v2*w4 - 21*a5*z + 76*a4*u*z - 79*a3*u2*z + 8*a2*u3*z + 16*a*u4*z - a4*v*z - 28*a3*u*v*z + 61*a2*u2*v*z - 16*a*u3*v*z - 16*u4*v*z + 17*a3*v2*z - 44*a2*u*v2*z + 19*a*u2*v2*z + 8*u3*v2*z + 5*a2*v3*z - 4*a*u*v3*z - u2*v3*z + 48*a4*w*z - 130*a3*u*w*z + 100*a2*u2*w*z - 16*a*u3*w*z - 20*a3*v*w*z + 86*a2*u*v*w*z - 88*a*u2*v*w*z + 16*u3*v*w*z - 24*a2*v2*w*z + 42*a*u*v2*w*z - 12*u2*v2*w*z - 4*a*v3*w*z + 2*u*v3*w*z - 15*a3*w2*z + 32*a2*u*w2*z - 16*a*u2*w2*z + 13*a2*v*w2*z - 32*a*u*v*w2*z + 16*u2*v*w2*z + 3*a*v2*w2*z - v3*w2*z - 12*a2*w3*z + 16*a*u*w3*z + 8*a*v*w3*z - 16*u*v*w3*z + 4*v2*w3*z - 9*a4*z2 + 6*a3*u*z2 + 26*a2*u2*z2 - 24*a*u3*z2 + 9*a3*v*z2 - 18*a2*u*v*z2 - 12*a*u2*v*z2 + 24*u3*v*z2 + a2*v2*z2 + 10*a*u*v2*z2 - 14*u2*v2*z2 - a*v3*z2 + 2*u*v3*z2 - 6*a3*w*z2 + 20*a2*u*w*z2 - 16*a*u2*w*z2 - 2*a2*v*w*z2 - 8*a*u*v*w*z2 + 16*u2*v*w*z2 + 6*a*v2*w*z2 - 12*u*v2*w*z2 + 2*v3*w*z2 + 18*a2*w2*z2 - 24*a*u*w2*z2 - 12*a*v*w2*z2 + 24*u*v*w2*z2 - 6*v2*w2*z2 + 9*a3*z3 - 24*a2*u*z3 + 16*a*u2*z3 - 3*a2*v*z3 + 16*a*u*v*z3 - 16*u2*v*z3 - 5*a*v2*z3 + 8*u*v2*z3 - v3*z3 - 12*a2*w*z3 + 16*a*u*w*z3 + 8*a*v*w*z3 - 16*u*v*w*z3 + 4*v2*w*z3 + 3*a2*z4 - 4*a*u*z4 - 2*a*v*z4 + 4*u*v*z4 - v2*z4;
      *(result+7) = 0;
    }
  else if (SAME2(v,w) && SAME2(x,z))
    {
      *(result) = 18*a6;
      *(result+1) = -108*a6 + 21*a5*u + 30*a5*v + 54*a5*x + 3*a5*y;
      *(result+2) = 270*a6 - 105*a5*u - 9*a4*u2 - 150*a5*v + 48*a4*u*v - 3*a4*v2 - 270*a5*x + 76*a4*u*x + 94*a4*v*x + 37*a4*x2 - 15*a5*y - a4*u*y + 14*a4*v*y + 26*a4*x*y - 12*a4*y2;
      *(result+3) = -360*a6 + 210*a5*u + 36*a4*u2 - 9*a3*u3 + 300*a5*v - 192*a4*u*v + 6*a3*u2*v + 12*a4*v2 + 15*a3*u*v2 - 12*a3*v3 + 540*a5*x - 304*a4*u*x - 6*a3*u2*x - 376*a4*v*x + 130*a3*u*v*x + 8*a3*v2*x - 148*a4*x2 + 79*a3*u*x2 + 84*a3*v*x2 - 16*a3*x3 + 30*a5*y + 4*a4*u*y - 9*a3*u2*y - 56*a4*v*y + 20*a3*u*v*y + a3*v2*y - 104*a4*x*y + 28*a3*u*x*y + 62*a3*v*x*y + 33*a3*x2*y + 48*a4*y2 - 17*a3*u*y2 - 14*a3*v*y2 - 26*a3*x*y2 + 3*a3*y3;
      *(result+4) = 270*a6 - 210*a5*u - 54*a4*u2 + 27*a3*u3 + 3*a2*u4 - 300*a5*v + 288*a4*u*v - 18*a3*u2*v - 12*a2*u3*v - 18*a4*v2 - 45*a3*u*v2 + 18*a2*u2*v2 + 36*a3*v3 - 12*a2*u*v3 + 3*a2*v4 - 540*a5*x + 456*a4*u*x + 18*a3*u2*x - 24*a2*u3*x + 564*a4*v*x - 390*a3*u*v*x + 20*a2*u2*v*x - 24*a3*v2*x + 32*a2*u*v2*x - 28*a2*v3*x + 222*a4*x2 - 237*a3*u*x2 + 26*a2*u2*x2 - 252*a3*v*x2 + 100*a2*u*v*x2 + 34*a2*v2*x2 + 48*a3*x3 + 8*a2*u*x3 + 4*a2*v*x3 - 13*a2*x4 - 30*a5*y - 6*a4*u*y + 27*a3*u2*y - 3*a2*u3*y + 84*a4*v*y - 60*a3*u*v*y - 2*a2*u2*v*y - 3*a3*v2*y + 13*a2*u*v2*y - 8*a2*v3*y + 156*a4*x*y - 84*a3*u*x*y - 18*a2*u2*x*y - 186*a3*v*x*y + 86*a2*u*v*x*y + 8*a2*v2*x*y - 99*a3*x2*y + 61*a2*u*x2*y + 72*a2*v*x2*y - 8*a2*x3*y - 72*a4*y2 + 51*a3*u*y2 + a2*u2*y2 + 42*a3*v*y2 - 24*a2*u*v*y2 + 3*a2*v2*y2 + 78*a3*x*y2 - 44*a2*u*x*y2 - 30*a2*v*x*y2 - 5*a2*x2*y2 - 9*a3*y3 + 5*a2*u*y3 + 2*a2*v*y3 + 2*a2*x*y3;
      *(result+5) = -108*a6 + 105*a5*u + 36*a4*u2 - 27*a3*u3 - 6*a2*u4 + 150*a5*v - 192*a4*u*v + 18*a3*u2*v + 24*a2*u3*v + 12*a4*v2 + 45*a3*u*v2 - 36*a2*u2*v2 - 36*a3*v3 + 24*a2*u*v3 - 6*a2*v4 + 270*a5*x - 304*a4*u*x - 18*a3*u2*x + 48*a2*u3*x + 4*a*u4*x - 376*a4*v*x + 390*a3*u*v*x - 40*a2*u2*v*x - 16*a*u3*v*x + 24*a3*v2*x - 64*a2*u*v2*x + 24*a*u2*v2*x + 56*a2*v3*x - 16*a*u*v3*x + 4*a*v4*x - 148*a4*x2 + 237*a3*u*x2 - 52*a2*u2*x2 - 16*a*u3*x2 + 252*a3*v*x2 - 200*a2*u*v*x2 + 16*a*u2*v*x2 - 68*a2*v2*x2 + 16*a*u*v2*x2 - 16*a*v3*x2 - 48*a3*x3 - 16*a2*u*x3 + 24*a*u2*x3 - 8*a2*v*x3 + 16*a*u*v*x3 + 24*a*v2*x3 + 26*a2*x4 - 16*a*u*x4 - 16*a*v*x4 + 4*a*x5 + 15*a5*y + 4*a4*u*y - 27*a3*u2*y + 6*a2*u3*y + 2*a*u4*y - 56*a4*v*y + 60*a3*u*v*y + 4*a2*u2*v*y - 8*a*u3*v*y + 3*a3*v2*y - 26*a2*u*v2*y + 12*a*u2*v2*y + 16*a2*v3*y - 8*a*u*v3*y + 2*a*v4*y - 104*a4*x*y + 84*a3*u*x*y + 36*a2*u2*x*y - 16*a*u3*x*y + 186*a3*v*x*y - 172*a2*u*v*x*y + 8*a*u2*v*x*y - 16*a2*v2*x*y + 32*a*u*v2*x*y - 24*a*v3*x*y + 99*a3*x2*y - 122*a2*u*x2*y + 12*a*u2*x2*y - 144*a2*v*x2*y + 88*a*u*v*x2*y + 28*a*v2*x2*y + 16*a2*x3*y + 16*a*u*x3*y + 8*a*v*x3*y - 14*a*x4*y + 48*a4*y2 - 51*a3*u*y2 - 2*a2*u2*y2 + 5*a*u3*y2 - 42*a3*v*y2 + 48*a2*u*v*y2 - 6*a*u2*v*y2 - 6*a2*v2*y2 - 3*a*u*v2*y2 + 4*a*v3*y2 - 78*a3*x*y2 + 88*a2*u*x*y2 - 10*a*u2*x*y2 + 60*a2*v*x*y2 - 42*a*u*v*x*y2 + 10*a2*x2*y2 - 19*a*u*x2*y2 - 12*a*v*x2*y2 + 8*a*x3*y2 + 9*a3*y3 - 10*a2*u*y3 + a*u2*y3 - 4*a2*v*y3 + 4*a*u*v*y3 - a*v2*y3 - 4*a2*x*y3 + 4*a*u*x*y3 + 2*a*v*x*y3 - a*x2*y3;
      *(result+6) = 18*a6 - 21*a5*u - 9*a4*u2 + 9*a3*u3 + 3*a2*u4 - 30*a5*v + 48*a4*u*v - 6*a3*u2*v - 12*a2*u3*v - 3*a4*v2 - 15*a3*u*v2 + 18*a2*u2*v2 + 12*a3*v3 - 12*a2*u*v3 + 3*a2*v4 - 54*a5*x + 76*a4*u*x + 6*a3*u2*x - 24*a2*u3*x - 4*a*u4*x + 94*a4*v*x - 130*a3*u*v*x + 20*a2*u2*v*x + 16*a*u3*v*x - 8*a3*v2*x + 32*a2*u*v2*x - 24*a*u2*v2*x - 28*a2*v3*x + 16*a*u*v3*x - 4*a*v4*x + 37*a4*x2 - 79*a3*u*x2 + 26*a2*u2*x2 + 16*a*u3*x2 - 84*a3*v*x2 + 100*a2*u*v*x2 - 16*a*u2*v*x2 + 34*a2*v2*x2 - 16*a*u*v2*x2 + 16*a*v3*x2 + 16*a3*x3 + 8*a2*u*x3 - 24*a*u2*x3 + 4*a2*v*x3 - 16*a*u*v*x3 - 24*a*v2*x3 - 13*a2*x4 + 16*a*u*x4 + 16*a*v*x4 - 4*a*x5 - 3*a5*y - a4*u*y + 9*a3*u2*y - 3*a2*u3*y - 2*a*u4*y + 14*a4*v*y - 20*a3*u*v*y - 2*a2*u2*v*y + 8*a*u3*v*y - a3*v2*y + 13*a2*u*v2*y - 12*a*u2*v2*y - 8*a2*v3*y + 8*a*u*v3*y - 2*a*v4*y + 26*a4*x*y - 28*a3*u*x*y - 18*a2*u2*x*y + 16*a*u3*x*y + 4*u4*x*y - 62*a3*v*x*y + 86*a2*u*v*x*y - 8*a*u2*v*x*y - 16*u3*v*x*y + 8*a2*v2*x*y - 32*a*u*v2*x*y + 24*u2*v2*x*y + 24*a*v3*x*y - 16*u*v3*x*y + 4*v4*x*y - 33*a3*x2*y + 61*a2*u*x2*y - 12*a*u2*x2*y - 16*u3*x2*y + 72*a2*v*x2*y - 88*a*u*v*x2*y + 16*u2*v*x2*y - 28*a*v2*x2*y + 16*u*v2*x2*y - 16*v3*x2*y - 8*a2*x3*y - 16*a*u*x3*y + 24*u2*x3*y - 8*a*v*x3*y + 16*u*v*x3*y + 24*v2*x3*y + 14*a*x4*y - 16*u*x4*y - 16*v*x4*y + 4*x5*y - 12*a4*y2 + 17*a3*u*y2 + a2*u2*y2 - 5*a*u3*y2 - u4*y2 + 14*a3*v*y2 - 24*a2*u*v*y2 + 6*a*u2*v*y2 + 4*u3*v*y2 + 3*a2*v2*y2 + 3*a*u*v2*y2 - 6*u2*v2*y2 - 4*a*v3*y2 + 4*u*v3*y2 - v4*y2 + 26*a3*x*y2 - 44*a2*u*x*y2 + 10*a*u2*x*y2 + 8*u3*x*y2 - 30*a2*v*x*y2 + 42*a*u*v*x*y2 - 12*u2*v*x*y2 + 4*v3*x*y2 - 5*a2*x2*y2 + 19*a*u*x2*y2 - 14*u2*x2*y2 + 12*a*v*x2*y2 - 12*u*v*x2*y2 - 6*v2*x2*y2 - 8*a*x3*y2 + 8*u*x3*y2 + 4*v*x3*y2 - x4*y2 - 3*a3*y3 + 5*a2*u*y3 - a*u2*y3 - u3*y3 + 2*a2*v*y3 - 4*a*u*v*y3 + 2*u2*v*y3 + a*v2*y3 - u*v2*y3 + 2*a2*x*y3 - 4*a*u*x*y3 + 2*u2*x*y3 - 2*a*v*x*y3 + 2*u*v*x*y3 + a*x2*y3 - u*x2*y3;
      *(result+7) = 0;
    }
  else if (SAME2(v,x) && SAME2(w,z))
    {
      *(result) = 18*a6;
      *(result+1) = -108*a6 + 3*a5*u + 54*a5*v + 30*a5*w + 21*a5*y;
      *(result+2) = 270*a6 - 15*a5*u - 12*a4*u2 - 270*a5*v + 26*a4*u*v + 37*a4*v2 - 150*a5*w + 14*a4*u*w + 94*a4*v*w - 3*a4*w2 - 105*a5*y - a4*u*y + 76*a4*v*y + 48*a4*w*y - 9*a4*y2;
      *(result+3) = -360*a6 + 30*a5*u + 48*a4*u2 + 3*a3*u3 + 540*a5*v - 104*a4*u*v - 26*a3*u2*v - 148*a4*v2 + 33*a3*u*v2 - 16*a3*v3 + 300*a5*w - 56*a4*u*w - 14*a3*u2*w - 376*a4*v*w + 62*a3*u*v*w + 84*a3*v2*w + 12*a4*w2 + a3*u*w2 + 8*a3*v*w2 - 12*a3*w3 + 210*a5*y + 4*a4*u*y - 17*a3*u2*y - 304*a4*v*y + 28*a3*u*v*y + 79*a3*v2*y - 192*a4*w*y + 20*a3*u*w*y + 130*a3*v*w*y + 15*a3*w2*y + 36*a4*y2 - 9*a3*u*y2 - 6*a3*v*y2 + 6*a3*w*y2 - 9*a3*y3;
      *(result+4) = 270*a6 - 30*a5*u - 72*a4*u2 - 9*a3*u3 - 540*a5*v + 156*a4*u*v + 78*a3*u2*v + 2*a2*u3*v + 222*a4*v2 - 99*a3*u*v2 - 5*a2*u2*v2 + 48*a3*v3 - 8*a2*u*v3 - 13*a2*v4 - 300*a5*w + 84*a4*u*w + 42*a3*u2*w + 2*a2*u3*w + 564*a4*v*w - 186*a3*u*v*w - 30*a2*u2*v*w - 252*a3*v2*w + 72*a2*u*v2*w + 4*a2*v3*w - 18*a4*w2 - 3*a3*u*w2 + 3*a2*u2*w2 - 24*a3*v*w2 + 8*a2*u*v*w2 + 34*a2*v2*w2 + 36*a3*w3 - 8*a2*u*w3 - 28*a2*v*w3 + 3*a2*w4 - 210*a5*y - 6*a4*u*y + 51*a3*u2*y + 5*a2*u3*y + 456*a4*v*y - 84*a3*u*v*y - 44*a2*u2*v*y - 237*a3*v2*y + 61*a2*u*v2*y + 8*a2*v3*y + 288*a4*w*y - 60*a3*u*w*y - 24*a2*u2*w*y - 390*a3*v*w*y + 86*a2*u*v*w*y + 100*a2*v2*w*y - 45*a3*w2*y + 13*a2*u*w2*y + 32*a2*v*w2*y - 12*a2*w3*y - 54*a4*y2 + 27*a3*u*y2 + a2*u2*y2 + 18*a3*v*y2 - 18*a2*u*v*y2 + 26*a2*v2*y2 - 18*a3*w*y2 - 2*a2*u*w*y2 + 20*a2*v*w*y2 + 18*a2*w2*y2 + 27*a3*y3 - 3*a2*u*y3 - 24*a2*v*y3 - 12*a2*w*y3 + 3*a2*y4;
      *(result+5) = -108*a6 + 15*a5*u + 48*a4*u2 + 9*a3*u3 + 270*a5*v - 104*a4*u*v - 78*a3*u2*v - 4*a2*u3*v - 148*a4*v2 + 99*a3*u*v2 + 10*a2*u2*v2 - a*u3*v2 - 48*a3*v3 + 16*a2*u*v3 + 8*a*u2*v3 + 26*a2*v4 - 14*a*u*v4 + 4*a*v5 + 150*a5*w - 56*a4*u*w - 42*a3*u2*w - 4*a2*u3*w - 376*a4*v*w + 186*a3*u*v*w + 60*a2*u2*v*w + 2*a*u3*v*w + 252*a3*v2*w - 144*a2*u*v2*w - 12*a*u2*v2*w - 8*a2*v3*w + 8*a*u*v3*w - 16*a*v4*w + 12*a4*w2 + 3*a3*u*w2 - 6*a2*u2*w2 - a*u3*w2 + 24*a3*v*w2 - 16*a2*u*v*w2 - 68*a2*v2*w2 + 28*a*u*v2*w2 + 24*a*v3*w2 - 36*a3*w3 + 16*a2*u*w3 + 4*a*u2*w3 + 56*a2*v*w3 - 24*a*u*v*w3 - 16*a*v2*w3 - 6*a2*w4 + 2*a*u*w4 + 4*a*v*w4 + 105*a5*y + 4*a4*u*y - 51*a3*u2*y - 10*a2*u3*y - 304*a4*v*y + 84*a3*u*v*y + 88*a2*u2*v*y + 4*a*u3*v*y + 237*a3*v2*y - 122*a2*u*v2*y - 19*a*u2*v2*y - 16*a2*v3*y + 16*a*u*v3*y - 16*a*v4*y - 192*a4*w*y + 60*a3*u*w*y + 48*a2*u2*w*y + 4*a*u3*w*y + 390*a3*v*w*y - 172*a2*u*v*w*y - 42*a*u2*v*w*y - 200*a2*v2*w*y + 88*a*u*v2*w*y + 16*a*v3*w*y + 45*a3*w2*y - 26*a2*u*w2*y - 3*a*u2*w2*y - 64*a2*v*w2*y + 32*a*u*v*w2*y + 16*a*v2*w2*y + 24*a2*w3*y - 8*a*u*w3*y - 16*a*v*w3*y + 36*a4*y2 - 27*a3*u*y2 - 2*a2*u2*y2 + a*u3*y2 - 18*a3*v*y2 + 36*a2*u*v*y2 - 10*a*u2*v*y2 - 52*a2*v2*y2 + 12*a*u*v2*y2 + 24*a*v3*y2 + 18*a3*w*y2 + 4*a2*u*w*y2 - 6*a*u2*w*y2 - 40*a2*v*w*y2 + 8*a*u*v*w*y2 + 16*a*v2*w*y2 - 36*a2*w2*y2 + 12*a*u*w2*y2 + 24*a*v*w2*y2 - 27*a3*y3 + 6*a2*u*y3 + 5*a*u2*y3 + 48*a2*v*y3 - 16*a*u*v*y3 - 16*a*v2*y3 + 24*a2*w*y3 - 8*a*u*w*y3 - 16*a*v*w*y3 - 6*a2*y4 + 2*a*u*y4 + 4*a*v*y4;
      *(result+6) = 18*a6 - 3*a5*u - 12*a4*u2 - 3*a3*u3 - 54*a5*v + 26*a4*u*v + 26*a3*u2*v + 2*a2*u3*v + 37*a4*v2 - 33*a3*u*v2 - 5*a2*u2*v2 + a*u3*v2 + 16*a3*v3 - 8*a2*u*v3 - 8*a*u2*v3 - 13*a2*v4 + 14*a*u*v4 - u2*v4 - 4*a*v5 + 4*u*v5 - 30*a5*w + 14*a4*u*w + 14*a3*u2*w + 2*a2*u3*w + 94*a4*v*w - 62*a3*u*v*w - 30*a2*u2*v*w - 2*a*u3*v*w - 84*a3*v2*w + 72*a2*u*v2*w + 12*a*u2*v2*w + 4*a2*v3*w - 8*a*u*v3*w + 4*u2*v3*w + 16*a*v4*w - 16*u*v4*w - 3*a4*w2 - a3*u*w2 + 3*a2*u2*w2 + a*u3*w2 - 8*a3*v*w2 + 8*a2*u*v*w2 + 34*a2*v2*w2 - 28*a*u*v2*w2 - 6*u2*v2*w2 - 24*a*v3*w2 + 24*u*v3*w2 + 12*a3*w3 - 8*a2*u*w3 - 4*a*u2*w3 - 28*a2*v*w3 + 24*a*u*v*w3 + 4*u2*v*w3 + 16*a*v2*w3 - 16*u*v2*w3 + 3*a2*w4 - 2*a*u*w4 - u2*w4 - 4*a*v*w4 + 4*u*v*w4 - 21*a5*y - a4*u*y + 17*a3*u2*y + 5*a2*u3*y + 76*a4*v*y - 28*a3*u*v*y - 44*a2*u2*v*y - 4*a*u3*v*y - 79*a3*v2*y + 61*a2*u*v2*y + 19*a*u2*v2*y - u3*v2*y + 8*a2*v3*y - 16*a*u*v3*y + 8*u2*v3*y + 16*a*v4*y - 16*u*v4*y + 48*a4*w*y - 20*a3*u*w*y - 24*a2*u2*w*y - 4*a*u3*w*y - 130*a3*v*w*y + 86*a2*u*v*w*y + 42*a*u2*v*w*y + 2*u3*v*w*y + 100*a2*v2*w*y - 88*a*u*v2*w*y - 12*u2*v2*w*y - 16*a*v3*w*y + 16*u*v3*w*y - 15*a3*w2*y + 13*a2*u*w2*y + 3*a*u2*w2*y - u3*w2*y + 32*a2*v*w2*y - 32*a*u*v*w2*y - 16*a*v2*w2*y + 16*u*v2*w2*y - 12*a2*w3*y + 8*a*u*w3*y + 4*u2*w3*y + 16*a*v*w3*y - 16*u*v*w3*y - 9*a4*y2 + 9*a3*u*y2 + a2*u2*y2 - a*u3*y2 + 6*a3*v*y2 - 18*a2*u*v*y2 + 10*a*u2*v*y2 + 2*u3*v*y2 + 26*a2*v2*y2 - 12*a*u*v2*y2 - 14*u2*v2*y2 - 24*a*v3*y2 + 24*u*v3*y2 - 6*a3*w*y2 - 2*a2*u*w*y2 + 6*a*u2*w*y2 + 2*u3*w*y2 + 20*a2*v*w*y2 - 8*a*u*v*w*y2 - 12*u2*v*w*y2 - 16*a*v2*w*y2 + 16*u*v2*w*y2 + 18*a2*w2*y2 - 12*a*u*w2*y2 - 6*u2*w2*y2 - 24*a*v*w2*y2 + 24*u*v*w2*y2 + 9*a3*y3 - 3*a2*u*y3 - 5*a*u2*y3 - u3*y3 - 24*a2*v*y3 + 16*a*u*v*y3 + 8*u2*v*y3 + 16*a*v2*y3 - 16*u*v2*y3 - 12*a2*w*y3 + 8*a*u*w*y3 + 4*u2*w*y3 + 16*a*v*w*y3 - 16*u*v*w*y3 + 3*a2*y4 - 2*a*u*y4 - u2*y4 - 4*a*v*y4 + 4*u*v*y4;
      *(result+7) = 0;
    }
  else if (SAME2(u,v))
    {
      *(result) = 18*a6;
      *(result+1) = -108*a6 + 42*a5*u + 9*a5*w + 15*a5*x + 21*a5*y + 21*a5*z;
      *(result+2) = 270*a6 - 210*a5*u + 15*a4*u2 - 45*a5*w + 30*a4*u*w - 9*a4*w2 - 75*a5*x + 52*a4*u*x + 3*a4*w*x - 16*a4*x2 - 105*a5*y + 49*a4*u*y + 15*a4*w*y + 26*a4*x*y - 9*a4*y2 - 105*a5*z + 49*a4*u*z + 15*a4*w*z + 26*a4*x*z + 33*a4*y*z - 9*a4*z2;
      *(result+3) = -360*a6 + 420*a5*u - 60*a4*u2 - 12*a3*u3 + 90*a5*w - 120*a4*u*w + 24*a3*u2*w + 36*a4*w2 - 12*a3*u*w2 + 150*a5*x - 208*a4*u*x + 28*a3*u2*x - 12*a4*w*x + 32*a3*u*w*x - 12*a3*w2*x + 64*a4*x2 - 16*a3*u*x2 - 14*a3*w*x2 - 6*a3*x3 + 210*a5*y - 196*a4*u*y + 22*a3*u2*y - 60*a4*w*y + 32*a3*u*w*y - 6*a3*w2*y - 104*a4*x*y + 76*a3*u*x*y + 16*a3*w*x*y - 8*a3*x2*y + 36*a4*y2 - 21*a3*u*y2 + 3*a3*w*y2 + 6*a3*x*y2 - 9*a3*y3 + 210*a5*z - 196*a4*u*z + 22*a3*u2*z - 60*a4*w*z + 32*a3*u*w*z - 6*a3*w2*z - 104*a4*x*z + 76*a3*u*x*z + 16*a3*w*x*z - 8*a3*x2*z - 132*a4*y*z + 86*a3*u*y*z + 18*a3*w*y*z + 16*a3*x*y*z + 3*a3*y2*z + 36*a4*z2 - 21*a3*u*z2 + 3*a3*w*z2 + 6*a3*x*z2 + 3*a3*y*z2 - 9*a3*z3;
      *(result+4) = 270*a6 - 420*a5*u + 90*a4*u2 + 36*a3*u3 - 90*a5*w + 180*a4*u*w - 72*a3*u2*w - 54*a4*w2 + 36*a3*u*w2 - 150*a5*x + 312*a4*u*x - 84*a3*u2*x - 20*a2*u3*x + 18*a4*w*x - 96*a3*u*w*x + 40*a2*u2*w*x + 36*a3*w2*x - 20*a2*u*w2*x - 96*a4*x2 + 48*a3*u*x2 + 10*a2*u2*x2 + 42*a3*w*x2 - 20*a2*u*w*x2 + 2*a2*w2*x2 + 18*a3*x3 - 20*a2*u*x3 - 2*a2*w*x3 + 6*a2*x4 - 210*a5*y + 294*a4*u*y - 66*a3*u2*y - 8*a2*u3*y + 90*a4*w*y - 96*a3*u*w*y + 16*a2*u2*w*y + 18*a3*w2*y - 8*a2*u*w2*y + 156*a4*x*y - 228*a3*u*x*y + 42*a2*u2*x*y - 48*a3*w*x*y + 48*a2*u*w*x*y - 10*a2*w2*x*y + 24*a3*x2*y + 6*a2*u*x2*y - 10*a2*w*x2*y - 10*a2*x3*y - 54*a4*y2 + 63*a3*u*y2 - 9*a2*u2*y2 - 9*a3*w*y2 - 2*a2*u*w*y2 + 3*a2*w2*y2 - 18*a3*x*y2 + 7*a2*u*x*y2 + 11*a2*w*x*y2 + 11*a2*x2*y2 + 27*a3*y3 - 21*a2*u*y3 - 3*a2*w*y3 - 6*a2*x*y3 + 3*a2*y4 - 210*a5*z + 294*a4*u*z - 66*a3*u2*z - 8*a2*u3*z + 90*a4*w*z - 96*a3*u*w*z + 16*a2*u2*w*z + 18*a3*w2*z - 8*a2*u*w2*z + 156*a4*x*z - 228*a3*u*x*z + 42*a2*u2*x*z - 48*a3*w*x*z + 48*a2*u*w*x*z - 10*a2*w2*x*z + 24*a3*x2*z + 6*a2*u*x2*z - 10*a2*w*x2*z - 10*a2*x3*z + 198*a4*y*z - 258*a3*u*y*z + 50*a2*u2*y*z - 54*a3*w*y*z + 36*a2*u*w*y*z - 6*a2*w2*y*z - 48*a3*x*y*z + 70*a2*u*x*y*z + 18*a2*w*x*y*z - 12*a2*x2*y*z - 9*a3*y2*z + 13*a2*u*y2*z + 3*a2*w*y2*z - 4*a2*x*y2*z - 9*a2*y3*z - 54*a4*z2 + 63*a3*u*z2 - 9*a2*u2*z2 - 9*a3*w*z2 - 2*a2*u*w*z2 + 3*a2*w2*z2 - 18*a3*x*z2 + 7*a2*u*x*z2 + 11*a2*w*x*z2 + 11*a2*x2*z2 - 9*a3*y*z2 + 13*a2*u*y*z2 + 3*a2*w*y*z2 - 4*a2*x*y*z2 + 12*a2*y2*z2 + 27*a3*z3 - 21*a2*u*z3 - 3*a2*w*z3 - 6*a2*x*z3 - 9*a2*y*z3 + 3*a2*z4;
      *(result+5) = -108*a6 + 210*a5*u - 60*a4*u2 - 36*a3*u3 + 45*a5*w - 120*a4*u*w + 72*a3*u2*w + 36*a4*w2 - 36*a3*u*w2 + 75*a5*x - 208*a4*u*x + 84*a3*u2*x + 40*a2*u3*x - 12*a4*w*x + 96*a3*u*w*x - 80*a2*u2*w*x - 36*a3*w2*x + 40*a2*u*w2*x + 64*a4*x2 - 48*a3*u*x2 - 20*a2*u2*x2 - 4*a*u3*x2 - 42*a3*w*x2 + 40*a2*u*w*x2 + 8*a*u2*w*x2 - 4*a2*w2*x2 - 4*a*u*w2*x2 - 18*a3*x3 + 40*a2*u*x3 - 4*a*u2*x3 + 4*a2*w*x3 - 16*a*u*w*x3 + 4*a*w2*x3 - 12*a2*x4 + 6*a*u*x4 + 5*a*w*x4 - a*x5 + 105*a5*y - 196*a4*u*y + 66*a3*u2*y + 16*a2*u3*y - 60*a4*w*y + 96*a3*u*w*y - 32*a2*u2*w*y - 18*a3*w2*y + 16*a2*u*w2*y - 104*a4*x*y + 228*a3*u*x*y - 84*a2*u2*x*y - 16*a*u3*x*y + 48*a3*w*x*y - 96*a2*u*w*x*y + 32*a*u2*w*x*y + 20*a2*w2*x*y - 16*a*u*w2*x*y - 24*a3*x2*y - 12*a2*u*x2*y + 18*a*u2*x2*y + 20*a2*w*x2*y - 2*a*w2*x2*y + 20*a2*x3*y - 20*a*u*x3*y - 8*a*w*x3*y + 3*a*x4*y + 36*a4*y2 - 63*a3*u*y2 + 18*a2*u2*y2 + 4*a*u3*y2 + 9*a3*w*y2 + 4*a2*u*w*y2 - 8*a*u2*w*y2 - 6*a2*w2*y2 + 4*a*u*w2*y2 + 18*a3*x*y2 - 14*a2*u*x*y2 + 2*a*u2*x*y2 - 22*a2*w*x*y2 + 12*a*u*w*x*y2 + 2*a*w2*x*y2 - 22*a2*x2*y2 + 25*a*u*x2*y2 + 5*a*w*x2*y2 - 4*a*x3*y2 - 27*a3*y3 + 42*a2*u*y3 - 12*a*u2*y3 + 6*a2*w*y3 - 4*a*u*w*y3 + 12*a2*x*y3 - 18*a*u*x*y3 - 2*a*w*x*y3 + 3*a*x2*y3 - 6*a2*y4 + 7*a*u*y4 - a*x*y4 + 105*a5*z - 196*a4*u*z + 66*a3*u2*z + 16*a2*u3*z - 60*a4*w*z + 96*a3*u*w*z - 32*a2*u2*w*z - 18*a3*w2*z + 16*a2*u*w2*z - 104*a4*x*z + 228*a3*u*x*z - 84*a2*u2*x*z - 16*a*u3*x*z + 48*a3*w*x*z - 96*a2*u*w*x*z + 32*a*u2*w*x*z + 20*a2*w2*x*z - 16*a*u*w2*x*z - 24*a3*x2*z - 12*a2*u*x2*z + 18*a*u2*x2*z + 20*a2*w*x2*z - 2*a*w2*x2*z + 20*a2*x3*z - 20*a*u*x3*z - 8*a*w*x3*z + 3*a*x4*z - 132*a4*y*z + 258*a3*u*y*z - 100*a2*u2*y*z - 8*a*u3*y*z + 54*a3*w*y*z - 72*a2*u*w*y*z + 16*a*u2*w*y*z + 12*a2*w2*y*z - 8*a*u*w2*y*z + 48*a3*x*y*z - 140*a2*u*x*y*z + 60*a*u2*x*y*z - 36*a2*w*x*y*z + 40*a*u*w*x*y*z - 4*a*w2*x*y*z + 24*a2*x2*y*z - 14*a*u*x2*y*z - 2*a*w*x2*y*z + 4*a*x3*y*z + 9*a3*y2*z - 26*a2*u*y2*z + 12*a*u2*y2*z - 6*a2*w*y2*z + 4*a*u*w*y2*z + 8*a2*x*y2*z + 2*a*u*x*y2*z + 2*a*w*x*y2*z - 5*a*x2*y2*z + 18*a2*y3*z - 24*a*u*y3*z + 6*a*x*y3*z + 36*a4*z2 - 63*a3*u*z2 + 18*a2*u2*z2 + 4*a*u3*z2 + 9*a3*w*z2 + 4*a2*u*w*z2 - 8*a*u2*w*z2 - 6*a2*w2*z2 + 4*a*u*w2*z2 + 18*a3*x*z2 - 14*a2*u*x*z2 + 2*a*u2*x*z2 - 22*a2*w*x*z2 + 12*a*u*w*x*z2 + 2*a*w2*x*z2 - 22*a2*x2*z2 + 25*a*u*x2*z2 + 5*a*w*x2*z2 - 4*a*x3*z2 + 9*a3*y*z2 - 26*a2*u*y*z2 + 12*a*u2*y*z2 - 6*a2*w*y*z2 + 4*a*u*w*y*z2 + 8*a2*x*y*z2 + 2*a*u*x*y*z2 + 2*a*w*x*y*z2 - 5*a*x2*y*z2 - 24*a2*y2*z2 + 34*a*u*y2*z2 - 10*a*x*y2*z2 - 27*a3*z3 + 42*a2*u*z3 - 12*a*u2*z3 + 6*a2*w*z3 - 4*a*u*w*z3 + 12*a2*x*z3 - 18*a*u*x*z3 - 2*a*w*x*z3 + 3*a*x2*z3 + 18*a2*y*z3 - 24*a*u*y*z3 + 6*a*x*y*z3 - 6*a2*z4 + 7*a*u*z4 - a*x*z4;
      *(result+6) = 18*a6 - 42*a5*u + 15*a4*u2 + 12*a3*u3 - 9*a5*w + 30*a4*u*w - 24*a3*u2*w - 9*a4*w2 + 12*a3*u*w2 - 15*a5*x + 52*a4*u*x - 28*a3*u2*x - 20*a2*u3*x + 3*a4*w*x - 32*a3*u*w*x + 40*a2*u2*w*x + 12*a3*w2*x - 20*a2*u*w2*x - 16*a4*x2 + 16*a3*u*x2 + 10*a2*u2*x2 + 4*a*u3*x2 + 14*a3*w*x2 - 20*a2*u*w*x2 - 8*a*u2*w*x2 + 2*a2*w2*x2 + 4*a*u*w2*x2 + 6*a3*x3 - 20*a2*u*x3 + 4*a*u2*x3 + 4*u3*x3 - 2*a2*w*x3 + 16*a*u*w*x3 - 8*u2*w*x3 - 4*a*w2*x3 + 4*u*w2*x3 + 6*a2*x4 - 6*a*u*x4 - u2*x4 - 5*a*w*x4 + 6*u*w*x4 - w2*x4 + a*x5 - w*x5 - 21*a5*y + 49*a4*u*y - 22*a3*u2*y - 8*a2*u3*y + 15*a4*w*y - 32*a3*u*w*y + 16*a2*u2*w*y + 6*a3*w2*y - 8*a2*u*w2*y + 26*a4*x*y - 76*a3*u*x*y + 42*a2*u2*x*y + 16*a*u3*x*y - 16*a3*w*x*y + 48*a2*u*w*x*y - 32*a*u2*w*x*y - 10*a2*w2*x*y + 16*a*u*w2*x*y + 8*a3*x2*y + 6*a2*u*x2*y - 18*a*u2*x2*y - 8*u3*x2*y - 10*a2*w*x2*y + 16*u2*w*x2*y + 2*a*w2*x2*y - 8*u*w2*x2*y - 10*a2*x3*y + 20*a*u*x3*y - 2*u2*x3*y + 8*a*w*x3*y - 16*u*w*x3*y + 2*w2*x3*y - 3*a*x4*y + u*x4*y + 3*w*x4*y - 9*a4*y2 + 21*a3*u*y2 - 9*a2*u2*y2 - 4*a*u3*y2 - 3*a3*w*y2 - 2*a2*u*w*y2 + 8*a*u2*w*y2 + 3*a2*w2*y2 - 4*a*u*w2*y2 - 6*a3*x*y2 + 7*a2*u*x*y2 - 2*a*u2*x*y2 + 4*u3*x*y2 + 11*a2*w*x*y2 - 12*a*u*w*x*y2 - 8*u2*w*x*y2 - 2*a*w2*x*y2 + 4*u*w2*x*y2 + 11*a2*x2*y2 - 25*a*u*x2*y2 + 11*u2*x2*y2 - 5*a*w*x2*y2 + 14*u*w*x2*y2 - w2*x2*y2 + 4*a*x3*y2 - 3*u*x3*y2 - 3*w*x3*y2 + 9*a3*y3 - 21*a2*u*y3 + 12*a*u2*y3 - 3*a2*w*y3 + 4*a*u*w*y3 - 6*a2*x*y3 + 18*a*u*x*y3 - 12*u2*x*y3 + 2*a*w*x*y3 - 4*u*w*x*y3 - 3*a*x2*y3 + 3*u*x2*y3 + w*x2*y3 + 3*a2*y4 - 7*a*u*y4 + 4*u2*y4 + a*x*y4 - u*x*y4 - 21*a5*z + 49*a4*u*z - 22*a3*u2*z - 8*a2*u3*z + 15*a4*w*z - 32*a3*u*w*z + 16*a2*u2*w*z + 6*a3*w2*z - 8*a2*u*w2*z + 26*a4*x*z - 76*a3*u*x*z + 42*a2*u2*x*z + 16*a*u3*x*z - 16*a3*w*x*z + 48*a2*u*w*x*z - 32*a*u2*w*x*z - 10*a2*w2*x*z + 16*a*u*w2*x*z + 8*a3*x2*z + 6*a2*u*x2*z - 18*a*u2*x2*z - 8*u3*x2*z - 10*a2*w*x2*z + 16*u2*w*x2*z + 2*a*w2*x2*z - 8*u*w2*x2*z - 10*a2*x3*z + 20*a*u*x3*z - 2*u2*x3*z + 8*a*w*x3*z - 16*u*w*x3*z + 2*w2*x3*z - 3*a*x4*z + u*x4*z + 3*w*x4*z + 33*a4*y*z - 86*a3*u*y*z + 50*a2*u2*y*z + 8*a*u3*y*z - 18*a3*w*y*z + 36*a2*u*w*y*z - 16*a*u2*w*y*z - 6*a2*w2*y*z + 8*a*u*w2*y*z - 16*a3*x*y*z + 70*a2*u*x*y*z - 60*a*u2*x*y*z - 8*u3*x*y*z + 18*a2*w*x*y*z - 40*a*u*w*x*y*z + 16*u2*w*x*y*z + 4*a*w2*x*y*z - 8*u*w2*x*y*z - 12*a2*x2*y*z + 14*a*u*x2*y*z + 10*u2*x2*y*z + 2*a*w*x2*y*z + 4*u*w*x2*y*z + 2*w2*x2*y*z - 4*a*x3*y*z + 2*u*x3*y*z - 2*w*x3*y*z - x4*y*z - 3*a3*y2*z + 13*a2*u*y2*z - 12*a*u2*y2*z + 3*a2*w*y2*z - 4*a*u*w*y2*z - 4*a2*x*y2*z - 2*a*u*x*y2*z + 12*u2*x*y2*z - 2*a*w*x*y2*z + 4*u*w*x*y2*z + 5*a*x2*y2*z - 11*u*x2*y2*z - w*x2*y2*z + 2*x3*y2*z - 9*a2*y3*z + 24*a*u*y3*z - 16*u2*y3*z - 6*a*x*y3*z + 8*u*x*y3*z - x2*y3*z - 9*a4*z2 + 21*a3*u*z2 - 9*a2*u2*z2 - 4*a*u3*z2 - 3*a3*w*z2 - 2*a2*u*w*z2 + 8*a*u2*w*z2 + 3*a2*w2*z2 - 4*a*u*w2*z2 - 6*a3*x*z2 + 7*a2*u*x*z2 - 2*a*u2*x*z2 + 4*u3*x*z2 + 11*a2*w*x*z2 - 12*a*u*w*x*z2 - 8*u2*w*x*z2 - 2*a*w2*x*z2 + 4*u*w2*x*z2 + 11*a2*x2*z2 - 25*a*u*x2*z2 + 11*u2*x2*z2 - 5*a*w*x2*z2 + 14*u*w*x2*z2 - w2*x2*z2 + 4*a*x3*z2 - 3*u*x3*z2 - 3*w*x3*z2 - 3*a3*y*z2 + 13*a2*u*y*z2 - 12*a*u2*y*z2 + 3*a2*w*y*z2 - 4*a*u*w*y*z2 - 4*a2*x*y*z2 - 2*a*u*x*y*z2 + 12*u2*x*y*z2 - 2*a*w*x*y*z2 + 4*u*w*x*y*z2 + 5*a*x2*y*z2 - 11*u*x2*y*z2 - w*x2*y*z2 + 2*x3*y*z2 + 12*a2*y2*z2 - 34*a*u*y2*z2 + 24*u2*y2*z2 + 10*a*x*y2*z2 - 14*u*x*y2*z2 + 2*x2*y2*z2 + 9*a3*z3 - 21*a2*u*z3 + 12*a*u2*z3 - 3*a2*w*z3 + 4*a*u*w*z3 - 6*a2*x*z3 + 18*a*u*x*z3 - 12*u2*x*z3 + 2*a*w*x*z3 - 4*u*w*x*z3 - 3*a*x2*z3 + 3*u*x2*z3 + w*x2*z3 - 9*a2*y*z3 + 24*a*u*y*z3 - 16*u2*y*z3 - 6*a*x*y*z3 + 8*u*x*y*z3 - x2*y*z3 + 3*a2*z4 - 7*a*u*z4 + 4*u2*z4 + a*x*z4 - u*x*z4;
      *(result+7) = 0;
    }
  else if (SAME2(y,z))
    {
      *(result) = 18*a6;
      *(result+1) = -108*a6 + 21*a5*u + 21*a5*v + 9*a5*w + 15*a5*x + 42*a5*y;
      *(result+2) = 270*a6 - 105*a5*u - 9*a4*u2 - 105*a5*v + 33*a4*u*v - 9*a4*v2 - 45*a5*w + 15*a4*u*w + 15*a4*v*w - 9*a4*w2 - 75*a5*x + 26*a4*u*x + 26*a4*v*x + 3*a4*w*x - 16*a4*x2 - 210*a5*y + 49*a4*u*y + 49*a4*v*y + 30*a4*w*y + 52*a4*x*y + 15*a4*y2;
      *(result+3) = -360*a6 + 210*a5*u + 36*a4*u2 - 9*a3*u3 + 210*a5*v - 132*a4*u*v + 3*a3*u2*v + 36*a4*v2 + 3*a3*u*v2 - 9*a3*v3 + 90*a5*w - 60*a4*u*w + 3*a3*u2*w - 60*a4*v*w + 18*a3*u*v*w + 3*a3*v2*w + 36*a4*w2 - 6*a3*u*w2 - 6*a3*v*w2 + 150*a5*x - 104*a4*u*x + 6*a3*u2*x - 104*a4*v*x + 16*a3*u*v*x + 6*a3*v2*x - 12*a4*w*x + 16*a3*u*w*x + 16*a3*v*w*x - 12*a3*w2*x + 64*a4*x2 - 8*a3*u*x2 - 8*a3*v*x2 - 14*a3*w*x2 - 6*a3*x3 + 420*a5*y - 196*a4*u*y - 21*a3*u2*y - 196*a4*v*y + 86*a3*u*v*y - 21*a3*v2*y - 120*a4*w*y + 32*a3*u*w*y + 32*a3*v*w*y - 12*a3*w2*y - 208*a4*x*y + 76*a3*u*x*y + 76*a3*v*x*y + 32*a3*w*x*y - 16*a3*x2*y - 60*a4*y2 + 22*a3*u*y2 + 22*a3*v*y2 + 24*a3*w*y2 + 28*a3*x*y2 - 12*a3*y3;
      *(result+4) = 270*a6 - 210*a5*u - 54*a4*u2 + 27*a3*u3 + 3*a2*u4 - 210*a5*v + 198*a4*u*v - 9*a3*u2*v - 9*a2*u3*v - 54*a4*v2 - 9*a3*u*v2 + 12*a2*u2*v2 + 27*a3*v3 - 9*a2*u*v3 + 3*a2*v4 - 90*a5*w + 90*a4*u*w - 9*a3*u2*w - 3*a2*u3*w + 90*a4*v*w - 54*a3*u*v*w + 3*a2*u2*v*w - 9*a3*v2*w + 3*a2*u*v2*w - 3*a2*v3*w - 54*a4*w2 + 18*a3*u*w2 + 3*a2*u2*w2 + 18*a3*v*w2 - 6*a2*u*v*w2 + 3*a2*v2*w2 - 150*a5*x + 156*a4*u*x - 18*a3*u2*x - 6*a2*u3*x + 156*a4*v*x - 48*a3*u*v*x - 4*a2*u2*v*x - 18*a3*v2*x - 4*a2*u*v2*x - 6*a2*v3*x + 18*a4*w*x - 48*a3*u*w*x + 11*a2*u2*w*x - 48*a3*v*w*x + 18*a2*u*v*w*x + 11*a2*v2*w*x + 36*a3*w2*x - 10*a2*u*w2*x - 10*a2*v*w2*x - 96*a4*x2 + 24*a3*u*x2 + 11*a2*u2*x2 + 24*a3*v*x2 - 12*a2*u*v*x2 + 11*a2*v2*x2 + 42*a3*w*x2 - 10*a2*u*w*x2 - 10*a2*v*w*x2 + 2*a2*w2*x2 + 18*a3*x3 - 10*a2*u*x3 - 10*a2*v*x3 - 2*a2*w*x3 + 6*a2*x4 - 420*a5*y + 294*a4*u*y + 63*a3*u2*y - 21*a2*u3*y + 294*a4*v*y - 258*a3*u*v*y + 13*a2*u2*v*y + 63*a3*v2*y + 13*a2*u*v2*y - 21*a2*v3*y + 180*a4*w*y - 96*a3*u*w*y - 2*a2*u2*w*y - 96*a3*v*w*y + 36*a2*u*v*w*y - 2*a2*v2*w*y + 36*a3*w2*y - 8*a2*u*w2*y - 8*a2*v*w2*y + 312*a4*x*y - 228*a3*u*x*y + 7*a2*u2*x*y - 228*a3*v*x*y + 70*a2*u*v*x*y + 7*a2*v2*x*y - 96*a3*w*x*y + 48*a2*u*w*x*y + 48*a2*v*w*x*y - 20*a2*w2*x*y + 48*a3*x2*y + 6*a2*u*x2*y + 6*a2*v*x2*y - 20*a2*w*x2*y - 20*a2*x3*y + 90*a4*y2 - 66*a3*u*y2 - 9*a2*u2*y2 - 66*a3*v*y2 + 50*a2*u*v*y2 - 9*a2*v2*y2 - 72*a3*w*y2 + 16*a2*u*w*y2 + 16*a2*v*w*y2 - 84*a3*x*y2 + 42*a2*u*x*y2 + 42*a2*v*x*y2 + 40*a2*w*x*y2 + 10*a2*x2*y2 + 36*a3*y3 - 8*a2*u*y3 - 8*a2*v*y3 - 20*a2*x*y3;
      *(result+5) = -108*a6 + 105*a5*u + 36*a4*u2 - 27*a3*u3 - 6*a2*u4 + 105*a5*v - 132*a4*u*v + 9*a3*u2*v + 18*a2*u3*v + 36*a4*v2 + 9*a3*u*v2 - 24*a2*u2*v2 - 27*a3*v3 + 18*a2*u*v3 - 6*a2*v4 + 45*a5*w - 60*a4*u*w + 9*a3*u2*w + 6*a2*u3*w - 60*a4*v*w + 54*a3*u*v*w - 6*a2*u2*v*w + 9*a3*v2*w - 6*a2*u*v2*w + 6*a2*v3*w + 36*a4*w2 - 18*a3*u*w2 - 6*a2*u2*w2 - 18*a3*v*w2 + 12*a2*u*v*w2 - 6*a2*v2*w2 + 75*a5*x - 104*a4*u*x + 18*a3*u2*x + 12*a2*u3*x - a*u4*x - 104*a4*v*x + 48*a3*u*v*x + 8*a2*u2*v*x + 6*a*u3*v*x + 18*a3*v2*x + 8*a2*u*v2*x - 10*a*u2*v2*x + 12*a2*v3*x + 6*a*u*v3*x - a*v4*x - 12*a4*w*x + 48*a3*u*w*x - 22*a2*u2*w*x - 2*a*u3*w*x + 48*a3*v*w*x - 36*a2*u*v*w*x + 2*a*u2*v*w*x - 22*a2*v2*w*x + 2*a*u*v2*w*x - 2*a*v3*w*x - 36*a3*w2*x + 20*a2*u*w2*x + 2*a*u2*w2*x + 20*a2*v*w2*x - 4*a*u*v*w2*x + 2*a*v2*w2*x + 64*a4*x2 - 24*a3*u*x2 - 22*a2*u2*x2 + 3*a*u3*x2 - 24*a3*v*x2 + 24*a2*u*v*x2 - 5*a*u2*v*x2 - 22*a2*v2*x2 - 5*a*u*v2*x2 + 3*a*v3*x2 - 42*a3*w*x2 + 20*a2*u*w*x2 + 5*a*u2*w*x2 + 20*a2*v*w*x2 - 2*a*u*v*w*x2 + 5*a*v2*w*x2 - 4*a2*w2*x2 - 2*a*u*w2*x2 - 2*a*v*w2*x2 - 18*a3*x3 + 20*a2*u*x3 - 4*a*u2*x3 + 20*a2*v*x3 + 4*a*u*v*x3 - 4*a*v2*x3 + 4*a2*w*x3 - 8*a*u*w*x3 - 8*a*v*w*x3 + 4*a*w2*x3 - 12*a2*x4 + 3*a*u*x4 + 3*a*v*x4 + 5*a*w*x4 - a*x5 + 210*a5*y - 196*a4*u*y - 63*a3*u2*y + 42*a2*u3*y + 7*a*u4*y - 196*a4*v*y + 258*a3*u*v*y - 26*a2*u2*v*y - 24*a*u3*v*y - 63*a3*v2*y - 26*a2*u*v2*y + 34*a*u2*v2*y + 42*a2*v3*y - 24*a*u*v3*y + 7*a*v4*y - 120*a4*w*y + 96*a3*u*w*y + 4*a2*u2*w*y - 4*a*u3*w*y + 96*a3*v*w*y - 72*a2*u*v*w*y + 4*a*u2*v*w*y + 4*a2*v2*w*y + 4*a*u*v2*w*y - 4*a*v3*w*y - 36*a3*w2*y + 16*a2*u*w2*y + 4*a*u2*w2*y + 16*a2*v*w2*y - 8*a*u*v*w2*y + 4*a*v2*w2*y - 208*a4*x*y + 228*a3*u*x*y - 14*a2*u2*x*y - 18*a*u3*x*y + 228*a3*v*x*y - 140*a2*u*v*x*y + 2*a*u2*v*x*y - 14*a2*v2*x*y + 2*a*u*v2*x*y - 18*a*v3*x*y + 96*a3*w*x*y - 96*a2*u*w*x*y + 12*a*u2*w*x*y - 96*a2*v*w*x*y + 40*a*u*v*w*x*y + 12*a*v2*w*x*y + 40*a2*w2*x*y - 16*a*u*w2*x*y - 16*a*v*w2*x*y - 48*a3*x2*y - 12*a2*u*x2*y + 25*a*u2*x2*y - 12*a2*v*x2*y - 14*a*u*v*x2*y + 25*a*v2*x2*y + 40*a2*w*x2*y - 4*a*w2*x2*y + 40*a2*x3*y - 20*a*u*x3*y - 20*a*v*x3*y - 16*a*w*x3*y + 6*a*x4*y - 60*a4*y2 + 66*a3*u*y2 + 18*a2*u2*y2 - 12*a*u3*y2 + 66*a3*v*y2 - 100*a2*u*v*y2 + 12*a*u2*v*y2 + 18*a2*v2*y2 + 12*a*u*v2*y2 - 12*a*v3*y2 + 72*a3*w*y2 - 32*a2*u*w*y2 - 8*a*u2*w*y2 - 32*a2*v*w*y2 + 16*a*u*v*w*y2 - 8*a*v2*w*y2 + 84*a3*x*y2 - 84*a2*u*x*y2 + 2*a*u2*x*y2 - 84*a2*v*x*y2 + 60*a*u*v*x*y2 + 2*a*v2*x*y2 - 80*a2*w*x*y2 + 32*a*u*w*x*y2 + 32*a*v*w*x*y2 - 20*a2*x2*y2 + 18*a*u*x2*y2 + 18*a*v*x2*y2 + 8*a*w*x2*y2 - 4*a*x3*y2 - 36*a3*y3 + 16*a2*u*y3 + 4*a*u2*y3 + 16*a2*v*y3 - 8*a*u*v*y3 + 4*a*v2*y3 + 40*a2*x*y3 - 16*a*u*x*y3 - 16*a*v*x*y3 - 4*a*x2*y3;
      *(result+6) = 18*a6 - 21*a5*u - 9*a4*u2 + 9*a3*u3 + 3*a2*u4 - 21*a5*v + 33*a4*u*v - 3*a3*u2*v - 9*a2*u3*v - 9*a4*v2 - 3*a3*u*v2 + 12*a2*u2*v2 + 9*a3*v3 - 9*a2*u*v3 + 3*a2*v4 - 9*a5*w + 15*a4*u*w - 3*a3*u2*w - 3*a2*u3*w + 15*a4*v*w - 18*a3*u*v*w + 3*a2*u2*v*w - 3*a3*v2*w + 3*a2*u*v2*w - 3*a2*v3*w - 9*a4*w2 + 6*a3*u*w2 + 3*a2*u2*w2 + 6*a3*v*w2 - 6*a2*u*v*w2 + 3*a2*v2*w2 - 15*a5*x + 26*a4*u*x - 6*a3*u2*x - 6*a2*u3*x + a*u4*x + 26*a4*v*x - 16*a3*u*v*x - 4*a2*u2*v*x - 6*a*u3*v*x - 6*a3*v2*x - 4*a2*u*v2*x + 10*a*u2*v2*x - 6*a2*v3*x - 6*a*u*v3*x + a*v4*x + 3*a4*w*x - 16*a3*u*w*x + 11*a2*u2*w*x + 2*a*u3*w*x - 16*a3*v*w*x + 18*a2*u*v*w*x - 2*a*u2*v*w*x + 11*a2*v2*w*x - 2*a*u*v2*w*x + 2*a*v3*w*x + 12*a3*w2*x - 10*a2*u*w2*x - 2*a*u2*w2*x - 10*a2*v*w2*x + 4*a*u*v*w2*x - 2*a*v2*w2*x - 16*a4*x2 + 8*a3*u*x2 + 11*a2*u2*x2 - 3*a*u3*x2 + 8*a3*v*x2 - 12*a2*u*v*x2 + 5*a*u2*v*x2 - u3*v*x2 + 11*a2*v2*x2 + 5*a*u*v2*x2 + 2*u2*v2*x2 - 3*a*v3*x2 - u*v3*x2 + 14*a3*w*x2 - 10*a2*u*w*x2 - 5*a*u2*w*x2 + u3*w*x2 - 10*a2*v*w*x2 + 2*a*u*v*w*x2 - u2*v*w*x2 - 5*a*v2*w*x2 - u*v2*w*x2 + v3*w*x2 + 2*a2*w2*x2 + 2*a*u*w2*x2 - u2*w2*x2 + 2*a*v*w2*x2 + 2*u*v*w2*x2 - v2*w2*x2 + 6*a3*x3 - 10*a2*u*x3 + 4*a*u2*x3 - 10*a2*v*x3 - 4*a*u*v*x3 + 2*u2*v*x3 + 4*a*v2*x3 + 2*u*v2*x3 - 2*a2*w*x3 + 8*a*u*w*x3 - 3*u2*w*x3 + 8*a*v*w*x3 - 2*u*v*w*x3 - 3*v2*w*x3 - 4*a*w2*x3 + 2*u*w2*x3 + 2*v*w2*x3 + 6*a2*x4 - 3*a*u*x4 - 3*a*v*x4 - u*v*x4 - 5*a*w*x4 + 3*u*w*x4 + 3*v*w*x4 - w2*x4 + a*x5 - w*x5 - 42*a5*y + 49*a4*u*y + 21*a3*u2*y - 21*a2*u3*y - 7*a*u4*y + 49*a4*v*y - 86*a3*u*v*y + 13*a2*u2*v*y + 24*a*u3*v*y + 21*a3*v2*y + 13*a2*u*v2*y - 34*a*u2*v2*y - 21*a2*v3*y + 24*a*u*v3*y - 7*a*v4*y + 30*a4*w*y - 32*a3*u*w*y - 2*a2*u2*w*y + 4*a*u3*w*y - 32*a3*v*w*y + 36*a2*u*v*w*y - 4*a*u2*v*w*y - 2*a2*v2*w*y - 4*a*u*v2*w*y + 4*a*v3*w*y + 12*a3*w2*y - 8*a2*u*w2*y - 4*a*u2*w2*y - 8*a2*v*w2*y + 8*a*u*v*w2*y - 4*a*v2*w2*y + 52*a4*x*y - 76*a3*u*x*y + 7*a2*u2*x*y + 18*a*u3*x*y - u4*x*y - 76*a3*v*x*y + 70*a2*u*v*x*y - 2*a*u2*v*x*y + 8*u3*v*x*y + 7*a2*v2*x*y - 2*a*u*v2*x*y - 14*u2*v2*x*y + 18*a*v3*x*y + 8*u*v3*x*y - v4*x*y - 32*a3*w*x*y + 48*a2*u*w*x*y - 12*a*u2*w*x*y - 4*u3*w*x*y + 48*a2*v*w*x*y - 40*a*u*v*w*x*y + 4*u2*v*w*x*y - 12*a*v2*w*x*y + 4*u*v2*w*x*y - 4*v3*w*x*y - 20*a2*w2*x*y + 16*a*u*w2*x*y + 4*u2*w2*x*y + 16*a*v*w2*x*y - 8*u*v*w2*x*y + 4*v2*w2*x*y + 16*a3*x2*y + 6*a2*u*x2*y - 25*a*u2*x2*y + 3*u3*x2*y + 6*a2*v*x2*y + 14*a*u*v*x2*y - 11*u2*v*x2*y - 25*a*v2*x2*y - 11*u*v2*x2*y + 3*v3*x2*y - 20*a2*w*x2*y + 14*u2*w*x2*y + 4*u*v*w*x2*y + 14*v2*w*x2*y + 4*a*w2*x2*y - 8*u*w2*x2*y - 8*v*w2*x2*y - 20*a2*x3*y + 20*a*u*x3*y - 3*u2*x3*y + 20*a*v*x3*y + 2*u*v*x3*y - 3*v2*x3*y + 16*a*w*x3*y - 16*u*w*x3*y - 16*v*w*x3*y + 4*w2*x3*y - 6*a*x4*y + u*x4*y + v*x4*y + 6*w*x4*y + 15*a4*y2 - 22*a3*u*y2 - 9*a2*u2*y2 + 12*a*u3*y2 + 4*u4*y2 - 22*a3*v*y2 + 50*a2*u*v*y2 - 12*a*u2*v*y2 - 16*u3*v*y2 - 9*a2*v2*y2 - 12*a*u*v2*y2 + 24*u2*v2*y2 + 12*a*v3*y2 - 16*u*v3*y2 + 4*v4*y2 - 24*a3*w*y2 + 16*a2*u*w*y2 + 8*a*u2*w*y2 + 16*a2*v*w*y2 - 16*a*u*v*w*y2 + 8*a*v2*w*y2 - 28*a3*x*y2 + 42*a2*u*x*y2 - 2*a*u2*x*y2 - 12*u3*x*y2 + 42*a2*v*x*y2 - 60*a*u*v*x*y2 + 12*u2*v*x*y2 - 2*a*v2*x*y2 + 12*u*v2*x*y2 - 12*v3*x*y2 + 40*a2*w*x*y2 - 32*a*u*w*x*y2 - 8*u2*w*x*y2 - 32*a*v*w*x*y2 + 16*u*v*w*x*y2 - 8*v2*w*x*y2 + 10*a2*x2*y2 - 18*a*u*x2*y2 + 11*u2*x2*y2 - 18*a*v*x2*y2 + 10*u*v*x2*y2 + 11*v2*x2*y2 - 8*a*w*x2*y2 + 16*u*w*x2*y2 + 16*v*w*x2*y2 + 4*a*x3*y2 - 2*u*x3*y2 - 2*v*x3*y2 - 8*w*x3*y2 - x4*y2 + 12*a3*y3 - 8*a2*u*y3 - 4*a*u2*y3 - 8*a2*v*y3 + 8*a*u*v*y3 - 4*a*v2*y3 - 20*a2*x*y3 + 16*a*u*x*y3 + 4*u2*x*y3 + 16*a*v*x*y3 - 8*u*v*x*y3 + 4*v2*x*y3 + 4*a*x2*y3 - 8*u*x2*y3 - 8*v*x2*y3 + 4*x3*y3;
      *(result+7) = 0;
    }
  else
    {
      *(result) = -18*a7;
      *(result+1) = 126*a7 - 21*a6*u - 21*a6*v - 9*a6*w - 33*a6*x - 21*a6*y - 21*a6*z;
      *(result+2) = -378*a7 + 126*a6*u + 9*a5*u2 + 126*a6*v - 33*a5*u*v + 9*a5*v2 + 54*a6*w - 15*a5*u*w - 15*a5*v*w + 9*a5*w2 + 198*a6*x - 47*a5*u*x - 47*a5*v*x - 12*a5*w*x + a5*x2 + 126*a6*y - 20*a5*u*y - 29*a5*v*y - 15*a5*w*y - 47*a5*x*y + 9*a5*y2 + 126*a6*z - 29*a5*u*z - 20*a5*v*z - 15*a5*w*z - 47*a5*x*z - 33*a5*y*z + 9*a5*z2;
      *(result+3) = 630*a7 - 315*a6*u - 45*a5*u2 + 9*a4*u3 - 315*a6*v + 165*a5*u*v - 3*a4*u2*v - 45*a5*v2 - 3*a4*u*v2 + 9*a4*v3 - 135*a6*w + 75*a5*u*w - 3*a4*u2*w + 75*a5*v*w - 18*a4*u*v*w - 3*a4*v2*w - 45*a5*w2 + 6*a4*u*w2 + 6*a4*v*w2 - 495*a6*x + 235*a5*u*x + 3*a4*u2*x + 235*a5*v*x - 49*a4*u*v*x + 3*a4*v2*x + 60*a5*w*x - 31*a4*u*w*x - 31*a4*v*w*x + 21*a4*w2*x - 5*a5*x2 - 18*a4*u*x2 - 18*a4*v*x2 + 11*a4*w*x2 + 22*a4*x3 - 315*a6*y + 100*a5*u*y + 18*a4*u2*y + 145*a5*v*y - 43*a4*u*v*y + 3*a4*v2*y + 75*a5*w*y - 25*a4*u*w*y - 7*a4*v*w*y + 6*a4*w2*y + 235*a5*x*y - 61*a4*u*x*y - 64*a4*v*x*y - 31*a4*w*x*y - 18*a4*x2*y - 45*a5*y2 + 18*a4*u*y2 + 3*a4*v*y2 - 3*a4*w*y2 + 3*a4*x*y2 + 9*a4*y3 - 315*a6*z + 145*a5*u*z + 3*a4*u2*z + 100*a5*v*z - 43*a4*u*v*z + 18*a4*v2*z + 75*a5*w*z - 7*a4*u*w*z - 25*a4*v*w*z + 6*a4*w2*z + 235*a5*x*z - 64*a4*u*x*z - 61*a4*v*x*z - 31*a4*w*x*z - 18*a4*x2*z + 165*a5*y*z - 43*a4*u*y*z - 43*a4*v*y*z - 18*a4*w*y*z - 49*a4*x*y*z - 3*a4*y2*z - 45*a5*z2 + 3*a4*u*z2 + 18*a4*v*z2 - 3*a4*w*z2 + 3*a4*x*z2 - 3*a4*y*z2 + 9*a4*z3;
      *(result+4) = -630*a7 + 420*a6*u + 90*a5*u2 - 36*a4*u3 - 3*a3*u4 + 420*a6*v - 330*a5*u*v + 12*a4*u2*v + 9*a3*u3*v + 90*a5*v2 + 12*a4*u*v2 - 12*a3*u2*v2 - 36*a4*v3 + 9*a3*u*v3 - 3*a3*v4 + 180*a6*w - 150*a5*u*w + 12*a4*u2*w + 3*a3*u3*w - 150*a5*v*w + 72*a4*u*v*w - 3*a3*u2*v*w + 12*a4*v2*w - 3*a3*u*v2*w + 3*a3*v3*w + 90*a5*w2 - 24*a4*u*w2 - 3*a3*u2*w2 - 24*a4*v*w2 + 6*a3*u*v*w2 - 3*a3*v2*w2 + 660*a6*x - 470*a5*u*x - 12*a4*u2*x + 15*a3*u3*x - 470*a5*v*x + 196*a4*u*v*x + a3*u2*v*x - 12*a4*v2*x + a3*u*v2*x + 15*a3*v3*x - 120*a5*w*x + 124*a4*u*w*x - 14*a3*u2*w*x + 124*a4*v*w*x - 36*a3*u*v*w*x - 14*a3*v2*w*x - 84*a4*w2*x + 16*a3*u*w2*x + 16*a3*v*w2*x + 10*a5*x2 + 72*a4*u*x2 - 17*a3*u2*x2 + 72*a4*v*x2 - 4*a3*u*v*x2 - 17*a3*v2*x2 - 44*a4*w*x2 - 6*a3*u*w*x2 - 6*a3*v*w*x2 + 10*a3*w2*x2 - 88*a4*x3 + 18*a3*u*x3 + 18*a3*v*x3 + 16*a3*w*x3 + 420*a6*y - 200*a5*u*y - 72*a4*u2*y + 12*a3*u3*y - 290*a5*v*y + 172*a4*u*v*y + a3*u2*v*y - 12*a4*v2*y - 14*a3*u*v2*y + 9*a3*v3*y - 150*a5*w*y + 100*a4*u*w*y - 5*a3*u2*w*y + 28*a4*v*w*y - 18*a3*u*v*w*y + 7*a3*v2*w*y - 24*a4*w2*y + 4*a3*u*w2*y + 4*a3*v*w2*y - 470*a5*x*y + 244*a4*u*x*y + 15*a3*u2*x*y + 256*a4*v*x*y - 78*a3*u*v*x*y - a3*v2*x*y + 124*a4*w*x*y - 52*a3*u*w*x*y - 28*a3*v*w*x*y + 16*a3*w2*x*y + 72*a4*x2*y - 48*a3*u*x2*y - 34*a3*v*x2*y - 6*a3*w*x2*y + 18*a3*x3*y + 90*a5*y2 - 72*a4*u*y2 + 8*a3*u2*y2 - 12*a4*v*y2 + 9*a3*u*v*y2 - 8*a3*v2*y2 + 12*a4*w*y2 - 5*a3*u*w*y2 + 7*a3*v*w*y2 - 3*a3*w2*y2 - 12*a4*x*y2 + 15*a3*u*x*y2 - a3*v*x*y2 - 14*a3*w*x*y2 - 17*a3*x2*y2 - 36*a4*y3 + 12*a3*u*y3 + 9*a3*v*y3 + 3*a3*w*y3 + 15*a3*x*y3 - 3*a3*y4 + 420*a6*z - 290*a5*u*z - 12*a4*u2*z + 9*a3*u3*z - 200*a5*v*z + 172*a4*u*v*z - 14*a3*u2*v*z - 72*a4*v2*z + a3*u*v2*z + 12*a3*v3*z - 150*a5*w*z + 28*a4*u*w*z + 7*a3*u2*w*z + 100*a4*v*w*z - 18*a3*u*v*w*z - 5*a3*v2*w*z - 24*a4*w2*z + 4*a3*u*w2*z + 4*a3*v*w2*z - 470*a5*x*z + 256*a4*u*x*z - a3*u2*x*z + 244*a4*v*x*z - 78*a3*u*v*x*z + 15*a3*v2*x*z + 124*a4*w*x*z - 28*a3*u*w*x*z - 52*a3*v*w*x*z + 16*a3*w2*x*z + 72*a4*x2*z - 34*a3*u*x2*z - 48*a3*v*x2*z - 6*a3*w*x2*z + 18*a3*x3*z - 330*a5*y*z + 172*a4*u*y*z + 9*a3*u2*y*z + 172*a4*v*y*z - 68*a3*u*v*y*z + 9*a3*v2*y*z + 72*a4*w*y*z - 18*a3*u*w*y*z - 18*a3*v*w*y*z + 6*a3*w2*y*z + 196*a4*x*y*z - 78*a3*u*x*y*z - 78*a3*v*x*y*z - 36*a3*w*x*y*z - 4*a3*x2*y*z + 12*a4*y2*z + a3*u*y2*z - 14*a3*v*y2*z - 3*a3*w*y2*z + a3*x*y2*z + 9*a3*y3*z + 90*a5*z2 - 12*a4*u*z2 - 8*a3*u2*z2 - 72*a4*v*z2 + 9*a3*u*v*z2 + 8*a3*v2*z2 + 12*a4*w*z2 + 7*a3*u*w*z2 - 5*a3*v*w*z2 - 3*a3*w2*z2 - 12*a4*x*z2 - a3*u*x*z2 + 15*a3*v*x*z2 - 14*a3*w*x*z2 - 17*a3*x2*z2 + 12*a4*y*z2 - 14*a3*u*y*z2 + a3*v*y*z2 - 3*a3*w*y*z2 + a3*x*y*z2 - 12*a3*y2*z2 - 36*a4*z3 + 9*a3*u*z3 + 12*a3*v*z3 + 3*a3*w*z3 + 15*a3*x*z3 + 9*a3*y*z3 - 3*a3*z4;
      *(result+5) = 378*a7 - 315*a6*u - 90*a5*u2 + 54*a4*u3 + 9*a3*u4 - 315*a6*v + 330*a5*u*v - 18*a4*u2*v - 27*a3*u3*v - 90*a5*v2 - 18*a4*u*v2 + 36*a3*u2*v2 + 54*a4*v3 - 27*a3*u*v3 + 9*a3*v4 - 135*a6*w + 150*a5*u*w - 18*a4*u2*w - 9*a3*u3*w + 150*a5*v*w - 108*a4*u*v*w + 9*a3*u2*v*w - 18*a4*v2*w + 9*a3*u*v2*w - 9*a3*v3*w - 90*a5*w2 + 36*a4*u*w2 + 9*a3*u2*w2 + 36*a4*v*w2 - 18*a3*u*v*w2 + 9*a3*v2*w2 - 495*a6*x + 470*a5*u*x + 18*a4*u2*x - 45*a3*u3*x - 2*a2*u4*x + 470*a5*v*x - 294*a4*u*v*x - 3*a3*u2*v*x + 3*a2*u3*v*x + 18*a4*v2*x - 3*a3*u*v2*x - 2*a2*u2*v2*x - 45*a3*v3*x + 3*a2*u*v3*x - 2*a2*v4*x + 120*a5*w*x - 186*a4*u*w*x + 42*a3*u2*w*x + 5*a2*u3*w*x - 186*a4*v*w*x + 108*a3*u*v*w*x - 5*a2*u2*v*w*x + 42*a3*v2*w*x - 5*a2*u*v2*w*x + 5*a2*v3*w*x + 126*a4*w2*x - 48*a3*u*w2*x - 5*a2*u2*w2*x - 48*a3*v*w2*x + 10*a2*u*v*w2*x - 5*a2*v2*w2*x - 10*a5*x2 - 108*a4*u*x2 + 51*a3*u2*x2 + 3*a2*u3*x2 - 108*a4*v*x2 + 12*a3*u*v*x2 + 9*a2*u2*v*x2 + 51*a3*v2*x2 + 9*a2*u*v2*x2 + 3*a2*v3*x2 + 66*a4*w*x2 + 18*a3*u*w*x2 - 16*a2*u2*w*x2 + 18*a3*v*w*x2 - 16*a2*u*v*w*x2 - 16*a2*v2*w*x2 - 30*a3*w2*x2 + 12*a2*u*w2*x2 + 12*a2*v*w2*x2 + 132*a4*x3 - 54*a3*u*x3 - 7*a2*u2*x3 - 54*a3*v*x3 + 8*a2*u*v*x3 - 7*a2*v2*x3 - 48*a3*w*x3 + 18*a2*u*w*x3 + 18*a2*v*w*x3 - 6*a2*w2*x3 + 7*a2*u*x4 + 7*a2*v*x4 - 3*a2*w*x4 - 5*a2*x5 - 315*a6*y + 200*a5*u*y + 108*a4*u2*y - 36*a3*u3*y - 5*a2*u4*y + 290*a5*v*y - 258*a4*u*v*y - 3*a3*u2*v*y + 15*a2*u3*v*y + 18*a4*v2*y + 42*a3*u*v2*y - 17*a2*u2*v2*y - 27*a3*v3*y + 9*a2*u*v3*y - 2*a2*v4*y + 150*a5*w*y - 150*a4*u*w*y + 15*a3*u2*w*y + 5*a2*u3*w*y - 42*a4*v*w*y + 54*a3*u*v*w*y - 11*a2*u2*v*w*y - 21*a3*v2*w*y + 7*a2*u*v2*w*y - a2*v3*w*y + 36*a4*w2*y - 12*a3*u*w2*y - 2*a2*u2*w2*y - 12*a3*v*w2*y + 4*a2*u*v*w2*y - 2*a2*v2*w2*y + 470*a5*x*y - 366*a4*u*x*y - 45*a3*u2*x*y + 25*a2*u3*x*y - 384*a4*v*x*y + 234*a3*u*v*x*y - 4*a2*u2*v*x*y + 3*a3*v2*x*y - 11*a2*u*v2*x*y + 14*a2*v3*x*y - 186*a4*w*x*y + 156*a3*u*w*x*y - 15*a2*u2*w*x*y + 84*a3*v*w*x*y - 38*a2*u*v*w*x*y + 5*a2*v2*w*x*y - 48*a3*w2*x*y + 12*a2*u*w2*x*y + 12*a2*v*w2*x*y - 108*a4*x2*y + 144*a3*u*x2*y - 21*a2*u2*x2*y + 102*a3*v*x2*y - 28*a2*u*v*x2*y - 11*a2*v2*x2*y + 18*a3*w*x2*y - 22*a2*u*w*x2*y - 26*a2*v*w*x2*y + 12*a2*w2*x2*y - 54*a3*x3*y + 6*a2*u*x3*y + 8*a2*v*x3*y + 18*a2*w*x3*y + 7*a2*x4*y - 90*a5*y2 + 108*a4*u*y2 - 24*a3*u2*y2 - 2*a2*u3*y2 + 18*a4*v*y2 - 27*a3*u*v*y2 + 9*a2*u2*v*y2 + 24*a3*v2*y2 - 10*a2*u*v2*y2 - a2*v3*y2 - 18*a4*w*y2 + 15*a3*u*w*y2 - a2*u2*w*y2 - 21*a3*v*w*y2 + 2*a2*u*v*w*y2 + 7*a2*v2*w*y2 + 9*a3*w2*y2 - 2*a2*u*w2*y2 - 2*a2*v*w2*y2 + 18*a4*x*y2 - 45*a3*u*x*y2 + 19*a2*u2*x*y2 + 3*a3*v*x*y2 - 7*a2*u*v*x*y2 - 5*a2*v2*x*y2 + 42*a3*w*x*y2 - 15*a2*u*w*x*y2 + 5*a2*v*w*x*y2 - 5*a2*w2*x*y2 + 51*a3*x2*y2 - 21*a2*u*x2*y2 - 11*a2*v*x2*y2 - 16*a2*w*x2*y2 - 7*a2*x3*y2 + 54*a4*y3 - 36*a3*u*y3 - 2*a2*u2*y3 - 27*a3*v*y3 + 15*a2*u*v*y3 - a2*v2*y3 - 9*a3*w*y3 + 5*a2*u*w*y3 - a2*v*w*y3 - 45*a3*x*y3 + 25*a2*u*x*y3 + 14*a2*v*x*y3 + 5*a2*w*x*y3 + 3*a2*x2*y3 + 9*a3*y4 - 5*a2*u*y4 - 2*a2*v*y4 - 2*a2*x*y4 - 315*a6*z + 290*a5*u*z + 18*a4*u2*z - 27*a3*u3*z - 2*a2*u4*z + 200*a5*v*z - 258*a4*u*v*z + 42*a3*u2*v*z + 9*a2*u3*v*z + 108*a4*v2*z - 3*a3*u*v2*z - 17*a2*u2*v2*z - 36*a3*v3*z + 15*a2*u*v3*z - 5*a2*v4*z + 150*a5*w*z - 42*a4*u*w*z - 21*a3*u2*w*z - a2*u3*w*z - 150*a4*v*w*z + 54*a3*u*v*w*z + 7*a2*u2*v*w*z + 15*a3*v2*w*z - 11*a2*u*v2*w*z + 5*a2*v3*w*z + 36*a4*w2*z - 12*a3*u*w2*z - 2*a2*u2*w2*z - 12*a3*v*w2*z + 4*a2*u*v*w2*z - 2*a2*v2*w2*z + 470*a5*x*z - 384*a4*u*x*z + 3*a3*u2*x*z + 14*a2*u3*x*z - 366*a4*v*x*z + 234*a3*u*v*x*z - 11*a2*u2*v*x*z - 45*a3*v2*x*z - 4*a2*u*v2*x*z + 25*a2*v3*x*z - 186*a4*w*x*z + 84*a3*u*w*x*z + 5*a2*u2*w*x*z + 156*a3*v*w*x*z - 38*a2*u*v*w*x*z - 15*a2*v2*w*x*z - 48*a3*w2*x*z + 12*a2*u*w2*x*z + 12*a2*v*w2*x*z - 108*a4*x2*z + 102*a3*u*x2*z - 11*a2*u2*x2*z + 144*a3*v*x2*z - 28*a2*u*v*x2*z - 21*a2*v2*x2*z + 18*a3*w*x2*z - 26*a2*u*w*x2*z - 22*a2*v*w*x2*z + 12*a2*w2*x2*z - 54*a3*x3*z + 8*a2*u*x3*z + 6*a2*v*x3*z + 18*a2*w*x3*z + 7*a2*x4*z + 330*a5*y*z - 258*a4*u*y*z - 27*a3*u2*y*z + 15*a2*u3*y*z - 258*a4*v*y*z + 204*a3*u*v*y*z - 11*a2*u2*v*y*z - 27*a3*v2*y*z - 11*a2*u*v2*y*z + 15*a2*v3*y*z - 108*a4*w*y*z + 54*a3*u*w*y*z + 2*a2*u2*w*y*z + 54*a3*v*w*y*z - 20*a2*u*v*w*y*z + 2*a2*v2*w*y*z - 18*a3*w2*y*z + 4*a2*u*w2*y*z + 4*a2*v*w2*y*z - 294*a4*x*y*z + 234*a3*u*x*y*z - 7*a2*u2*x*y*z + 234*a3*v*x*y*z - 96*a2*u*v*x*y*z - 7*a2*v2*x*y*z + 108*a3*w*x*y*z - 38*a2*u*w*x*y*z - 38*a2*v*w*x*y*z + 10*a2*w2*x*y*z + 12*a3*x2*y*z - 28*a2*u*x2*y*z - 28*a2*v*x2*y*z - 16*a2*w*x2*y*z + 8*a2*x3*y*z - 18*a4*y2*z - 3*a3*u*y2*z + 9*a2*u2*y2*z + 42*a3*v*y2*z - 11*a2*u*v*y2*z - 10*a2*v2*y2*z + 9*a3*w*y2*z - 11*a2*u*w*y2*z + 7*a2*v*w*y2*z - 3*a3*x*y2*z - 4*a2*u*x*y2*z - 11*a2*v*x*y2*z - 5*a2*w*x*y2*z + 9*a2*x2*y2*z - 27*a3*y3*z + 15*a2*u*y3*z + 9*a2*v*y3*z + 3*a2*x*y3*z - 90*a5*z2 + 18*a4*u*z2 + 24*a3*u2*z2 - a2*u3*z2 + 108*a4*v*z2 - 27*a3*u*v*z2 - 10*a2*u2*v*z2 - 24*a3*v2*z2 + 9*a2*u*v2*z2 - 2*a2*v3*z2 - 18*a4*w*z2 - 21*a3*u*w*z2 + 7*a2*u2*w*z2 + 15*a3*v*w*z2 + 2*a2*u*v*w*z2 - a2*v2*w*z2 + 9*a3*w2*z2 - 2*a2*u*w2*z2 - 2*a2*v*w2*z2 + 18*a4*x*z2 + 3*a3*u*x*z2 - 5*a2*u2*x*z2 - 45*a3*v*x*z2 - 7*a2*u*v*x*z2 + 19*a2*v2*x*z2 + 42*a3*w*x*z2 + 5*a2*u*w*x*z2 - 15*a2*v*w*x*z2 - 5*a2*w2*x*z2 + 51*a3*x2*z2 - 11*a2*u*x2*z2 - 21*a2*v*x2*z2 - 16*a2*w*x2*z2 - 7*a2*x3*z2 - 18*a4*y*z2 + 42*a3*u*y*z2 - 10*a2*u2*y*z2 - 3*a3*v*y*z2 - 11*a2*u*v*y*z2 + 9*a2*v2*y*z2 + 9*a3*w*y*z2 + 7*a2*u*w*y*z2 - 11*a2*v*w*y*z2 - 3*a3*x*y*z2 - 11*a2*u*x*y*z2 - 4*a2*v*x*y*z2 - 5*a2*w*x*y*z2 + 9*a2*x2*y*z2 + 36*a3*y2*z2 - 17*a2*u*y2*z2 - 17*a2*v*y2*z2 - 2*a2*x*y2*z2 + 54*a4*z3 - 27*a3*u*z3 - a2*u2*z3 - 36*a3*v*z3 + 15*a2*u*v*z3 - 2*a2*v2*z3 - 9*a3*w*z3 - a2*u*w*z3 + 5*a2*v*w*z3 - 45*a3*x*z3 + 14*a2*u*x*z3 + 25*a2*v*x*z3 + 5*a2*w*x*z3 + 3*a2*x2*z3 - 27*a3*y*z3 + 9*a2*u*y*z3 + 15*a2*v*y*z3 + 3*a2*x*y*z3 + 9*a3*z4 - 2*a2*u*z4 - 5*a2*v*z4 - 2*a2*x*z4;
      *(result+6) = -126*a7 + 126*a6*u + 45*a5*u2 - 36*a4*u3 - 9*a3*u4 + 126*a6*v - 165*a5*u*v + 12*a4*u2*v + 27*a3*u3*v + 45*a5*v2 + 12*a4*u*v2 - 36*a3*u2*v2 - 36*a4*v3 + 27*a3*u*v3 - 9*a3*v4 + 54*a6*w - 75*a5*u*w + 12*a4*u2*w + 9*a3*u3*w - 75*a5*v*w + 72*a4*u*v*w - 9*a3*u2*v*w + 12*a4*v2*w - 9*a3*u*v2*w + 9*a3*v3*w + 45*a5*w2 - 24*a4*u*w2 - 9*a3*u2*w2 - 24*a4*v*w2 + 18*a3*u*v*w2 - 9*a3*v2*w2 + 198*a6*x - 235*a5*u*x - 12*a4*u2*x + 45*a3*u3*x + 4*a2*u4*x - 235*a5*v*x + 196*a4*u*v*x + 3*a3*u2*v*x - 6*a2*u3*v*x - 12*a4*v2*x + 3*a3*u*v2*x + 4*a2*u2*v2*x + 45*a3*v3*x - 6*a2*u*v3*x + 4*a2*v4*x - 60*a5*w*x + 124*a4*u*w*x - 42*a3*u2*w*x - 10*a2*u3*w*x + 124*a4*v*w*x - 108*a3*u*v*w*x + 10*a2*u2*v*w*x - 42*a3*v2*w*x + 10*a2*u*v2*w*x - 10*a2*v3*w*x - 84*a4*w2*x + 48*a3*u*w2*x + 10*a2*u2*w2*x + 48*a3*v*w2*x - 20*a2*u*v*w2*x + 10*a2*v2*w2*x + 5*a5*x2 + 72*a4*u*x2 - 51*a3*u2*x2 - 6*a2*u3*x2 + a*u4*x2 + 72*a4*v*x2 - 12*a3*u*v*x2 - 18*a2*u2*v*x2 - 5*a*u3*v*x2 - 51*a3*v2*x2 - 18*a2*u*v2*x2 + 8*a*u2*v2*x2 - 6*a2*v3*x2 - 5*a*u*v3*x2 + a*v4*x2 - 44*a4*w*x2 - 18*a3*u*w*x2 + 32*a2*u2*w*x2 + a*u3*w*x2 - 18*a3*v*w*x2 + 32*a2*u*v*w*x2 - a*u2*v*w*x2 + 32*a2*v2*w*x2 - a*u*v2*w*x2 + a*v3*w*x2 + 30*a3*w2*x2 - 24*a2*u*w2*x2 - a*u2*w2*x2 - 24*a2*v*w2*x2 + 2*a*u*v*w2*x2 - a*v2*w2*x2 - 88*a4*x3 + 54*a3*u*x3 + 14*a2*u2*x3 - 3*a*u3*x3 + 54*a3*v*x3 - 16*a2*u*v*x3 + 3*a*u2*v*x3 + 14*a2*v2*x3 + 3*a*u*v2*x3 - 3*a*v3*x3 + 48*a3*w*x3 - 36*a2*u*w*x3 - 2*a*u2*w*x3 - 36*a2*v*w*x3 + 4*a*u*v*w*x3 - 2*a*v2*w*x3 + 12*a2*w2*x3 - 14*a2*u*x4 + 4*a*u2*x4 - 14*a2*v*x4 - 3*a*u*v*x4 + 4*a*v2*x4 + 6*a2*w*x4 + 5*a*u*w*x4 + 5*a*v*w*x4 - 3*a*w2*x4 + 10*a2*x5 - 3*a*u*x5 - 3*a*v*x5 - 4*a*w*x5 + a*x6 + 126*a6*y - 100*a5*u*y - 72*a4*u2*y + 36*a3*u3*y + 10*a2*u4*y - 145*a5*v*y + 172*a4*u*v*y + 3*a3*u2*v*y - 30*a2*u3*v*y - 12*a4*v2*y - 42*a3*u*v2*y + 34*a2*u2*v2*y + 27*a3*v3*y - 18*a2*u*v3*y + 4*a2*v4*y - 75*a5*w*y + 100*a4*u*w*y - 15*a3*u2*w*y - 10*a2*u3*w*y + 28*a4*v*w*y - 54*a3*u*v*w*y + 22*a2*u2*v*w*y + 21*a3*v2*w*y - 14*a2*u*v2*w*y + 2*a2*v3*w*y - 24*a4*w2*y + 12*a3*u*w2*y + 4*a2*u2*w2*y + 12*a3*v*w2*y - 8*a2*u*v*w2*y + 4*a2*v2*w2*y - 235*a5*x*y + 244*a4*u*x*y + 45*a3*u2*x*y - 50*a2*u3*x*y - 4*a*u4*x*y + 256*a4*v*x*y - 234*a3*u*v*x*y + 8*a2*u2*v*x*y + 10*a*u3*v*x*y - 3*a3*v2*x*y + 22*a2*u*v2*x*y - 10*a*u2*v2*x*y - 28*a2*v3*x*y + 6*a*u*v3*x*y - 2*a*v4*x*y + 124*a4*w*x*y - 156*a3*u*w*x*y + 30*a2*u2*w*x*y + 6*a*u3*w*x*y - 84*a3*v*w*x*y + 76*a2*u*v*w*x*y - 10*a*u2*v*w*x*y - 10*a2*v2*w*x*y + 2*a*u*v2*w*x*y + 2*a*v3*w*x*y + 48*a3*w2*x*y - 24*a2*u*w2*x*y - 4*a*u2*w2*x*y - 24*a2*v*w2*x*y + 8*a*u*v*w2*x*y - 4*a*v2*w2*x*y + 72*a4*x2*y - 144*a3*u*x2*y + 42*a2*u2*x2*y + 10*a*u3*x2*y - 102*a3*v*x2*y + 56*a2*u*v*x2*y + a*u2*v*x2*y + 22*a2*v2*x2*y + 8*a*u*v2*x2*y + 5*a*v3*x2*y - 18*a3*w*x2*y + 44*a2*u*w*x2*y - 15*a*u2*w*x2*y + 52*a2*v*w*x2*y - 22*a*u*v*w*x2*y - 11*a*v2*w*x2*y - 24*a2*w2*x2*y + 12*a*u*w2*x2*y + 12*a*v*w2*x2*y + 54*a3*x3*y - 12*a2*u*x3*y - 15*a*u2*x3*y - 16*a2*v*x3*y + 6*a*u*v*x3*y - 7*a*v2*x3*y - 36*a2*w*x3*y + 12*a*u*w*x3*y + 4*a*v*w*x3*y - 14*a2*x4*y + 12*a*u*x4*y + 7*a*v*x4*y + 5*a*w*x4*y - 3*a*x5*y + 45*a5*y2 - 72*a4*u*y2 + 24*a3*u2*y2 + 4*a2*u3*y2 - a*u4*y2 - 12*a4*v*y2 + 27*a3*u*v*y2 - 18*a2*u2*v*y2 + 3*a*u3*v*y2 - 24*a3*v2*y2 + 20*a2*u*v2*y2 - 2*a*u2*v2*y2 + 2*a2*v3*y2 - a*u*v3*y2 + a*v4*y2 + 12*a4*w*y2 - 15*a3*u*w*y2 + 2*a2*u2*w*y2 + a*u3*w*y2 + 21*a3*v*w*y2 - 4*a2*u*v*w*y2 - 5*a*u2*v*w*y2 - 14*a2*v2*w*y2 + 7*a*u*v2*w*y2 - 3*a*v3*w*y2 - 9*a3*w2*y2 + 4*a2*u*w2*y2 + a*u2*w2*y2 + 4*a2*v*w2*y2 - 2*a*u*v*w2*y2 + a*v2*w2*y2 - 12*a4*x*y2 + 45*a3*u*x*y2 - 38*a2*u2*x*y2 + 5*a*u3*x*y2 - 3*a3*v*x*y2 + 14*a2*u*v*x*y2 + a*u2*v*x*y2 + 10*a2*v2*x*y2 - 13*a*u*v2*x*y2 - a*v3*x*y2 - 42*a3*w*x*y2 + 30*a2*u*w*x*y2 - 10*a2*v*w*x*y2 + 16*a*v2*w*x*y2 + 10*a2*w2*x*y2 - 4*a*u*w2*x*y2 - 4*a*v*w2*x*y2 - 51*a3*x2*y2 + 42*a2*u*x2*y2 + 3*a*u2*x2*y2 + 22*a2*v*x2*y2 - 19*a*u*v*x2*y2 + 3*a*v2*x2*y2 + 32*a2*w*x2*y2 - 15*a*u*w*x2*y2 - 11*a*v*w*x2*y2 - a*w2*x2*y2 + 14*a2*x3*y2 - 15*a*u*x3*y2 - 7*a*v*x3*y2 - 2*a*w*x3*y2 + 4*a*x4*y2 - 36*a4*y3 + 36*a3*u*y3 + 4*a2*u2*y3 - 4*a*u3*y3 + 27*a3*v*y3 - 30*a2*u*v*y3 + 3*a*u2*v*y3 + 2*a2*v2*y3 + 2*a*u*v2*y3 - a*v3*y3 + 9*a3*w*y3 - 10*a2*u*w*y3 + a*u2*w*y3 + 2*a2*v*w*y3 + 2*a*u*v*w*y3 - 3*a*v2*w*y3 + 45*a3*x*y3 - 50*a2*u*x*y3 + 5*a*u2*x*y3 - 28*a2*v*x*y3 + 20*a*u*v*x*y3 - a*v2*x*y3 - 10*a2*w*x*y3 + 6*a*u*w*x*y3 + 2*a*v*w*x*y3 - 6*a2*x2*y3 + 10*a*u*x2*y3 + 5*a*v*x2*y3 + a*w*x2*y3 - 3*a*x3*y3 - 9*a3*y4 + 10*a2*u*y4 - a*u2*y4 + 4*a2*v*y4 - 4*a*u*v*y4 + a*v2*y4 + 4*a2*x*y4 - 4*a*u*x*y4 - 2*a*v*x*y4 + a*x2*y4 + 126*a6*z - 145*a5*u*z - 12*a4*u2*z + 27*a3*u3*z + 4*a2*u4*z - 100*a5*v*z + 172*a4*u*v*z - 42*a3*u2*v*z - 18*a2*u3*v*z - 72*a4*v2*z + 3*a3*u*v2*z + 34*a2*u2*v2*z + 36*a3*v3*z - 30*a2*u*v3*z + 10*a2*v4*z - 75*a5*w*z + 28*a4*u*w*z + 21*a3*u2*w*z + 2*a2*u3*w*z + 100*a4*v*w*z - 54*a3*u*v*w*z - 14*a2*u2*v*w*z - 15*a3*v2*w*z + 22*a2*u*v2*w*z - 10*a2*v3*w*z - 24*a4*w2*z + 12*a3*u*w2*z + 4*a2*u2*w2*z + 12*a3*v*w2*z - 8*a2*u*v*w2*z + 4*a2*v2*w2*z - 235*a5*x*z + 256*a4*u*x*z - 3*a3*u2*x*z - 28*a2*u3*x*z - 2*a*u4*x*z + 244*a4*v*x*z - 234*a3*u*v*x*z + 22*a2*u2*v*x*z + 6*a*u3*v*x*z + 45*a3*v2*x*z + 8*a2*u*v2*x*z - 10*a*u2*v2*x*z - 50*a2*v3*x*z + 10*a*u*v3*x*z - 4*a*v4*x*z + 124*a4*w*x*z - 84*a3*u*w*x*z - 10*a2*u2*w*x*z + 2*a*u3*w*x*z - 156*a3*v*w*x*z + 76*a2*u*v*w*x*z + 2*a*u2*v*w*x*z + 30*a2*v2*w*x*z - 10*a*u*v2*w*x*z + 6*a*v3*w*x*z + 48*a3*w2*x*z - 24*a2*u*w2*x*z - 4*a*u2*w2*x*z - 24*a2*v*w2*x*z + 8*a*u*v*w2*x*z - 4*a*v2*w2*x*z + 72*a4*x2*z - 102*a3*u*x2*z + 22*a2*u2*x2*z + 5*a*u3*x2*z - 144*a3*v*x2*z + 56*a2*u*v*x2*z + 8*a*u2*v*x2*z + 42*a2*v2*x2*z + a*u*v2*x2*z + 10*a*v3*x2*z - 18*a3*w*x2*z + 52*a2*u*w*x2*z - 11*a*u2*w*x2*z + 44*a2*v*w*x2*z - 22*a*u*v*w*x2*z - 15*a*v2*w*x2*z - 24*a2*w2*x2*z + 12*a*u*w2*x2*z + 12*a*v*w2*x2*z + 54*a3*x3*z - 16*a2*u*x3*z - 7*a*u2*x3*z - 12*a2*v*x3*z + 6*a*u*v*x3*z - 15*a*v2*x3*z - 36*a2*w*x3*z + 4*a*u*w*x3*z + 12*a*v*w*x3*z - 14*a2*x4*z + 7*a*u*x4*z + 12*a*v*x4*z + 5*a*w*x4*z - 3*a*x5*z - 165*a5*y*z + 172*a4*u*y*z + 27*a3*u2*y*z - 30*a2*u3*y*z - 4*a*u4*y*z + 172*a4*v*y*z - 204*a3*u*v*y*z + 22*a2*u2*v*y*z + 14*a*u3*v*y*z + 27*a3*v2*y*z + 22*a2*u*v2*y*z - 20*a*u2*v2*y*z - 30*a2*v3*y*z + 14*a*u*v3*y*z - 4*a*v4*y*z + 72*a4*w*y*z - 54*a3*u*w*y*z - 4*a2*u2*w*y*z + 2*a*u3*w*y*z - 54*a3*v*w*y*z + 40*a2*u*v*w*y*z - 2*a*u2*v*w*y*z - 4*a2*v2*w*y*z - 2*a*u*v2*w*y*z + 2*a*v3*w*y*z + 18*a3*w2*y*z - 8*a2*u*w2*y*z - 2*a*u2*w2*y*z - 8*a2*v*w2*y*z + 4*a*u*v*w2*y*z - 2*a*v2*w2*y*z + 196*a4*x*y*z - 234*a3*u*x*y*z + 14*a2*u2*x*y*z + 20*a*u3*x*y*z - 234*a3*v*x*y*z + 192*a2*u*v*x*y*z - 12*a*u2*v*x*y*z + 14*a2*v2*x*y*z - 12*a*u*v2*x*y*z + 20*a*v3*x*y*z - 108*a3*w*x*y*z + 76*a2*u*w*x*y*z + 76*a2*v*w*x*y*z - 32*a*u*v*w*x*y*z - 20*a2*w2*x*y*z + 8*a*u*w2*x*y*z + 8*a*v*w2*x*y*z - 12*a3*x2*y*z + 56*a2*u*x2*y*z - 19*a*u2*x2*y*z + 56*a2*v*x2*y*z - 32*a*u*v*x2*y*z - 19*a*v2*x2*y*z + 32*a2*w*x2*y*z - 22*a*u*w*x2*y*z - 22*a*v*w*x2*y*z + 2*a*w2*x2*y*z - 16*a2*x3*y*z + 6*a*u*x3*y*z + 6*a*v*x3*y*z + 4*a*w*x3*y*z - 3*a*x4*y*z + 12*a4*y2*z + 3*a3*u*y2*z - 18*a2*u2*y2*z + 3*a*u3*y2*z - 42*a3*v*y2*z + 22*a2*u*v*y2*z + 8*a*u2*v*y2*z + 20*a2*v2*y2*z - 13*a*u*v2*y2*z + 2*a*v3*y2*z - 9*a3*w*y2*z + 22*a2*u*w*y2*z - 5*a*u2*w*y2*z - 14*a2*v*w*y2*z - 2*a*u*v*w*y2*z + 7*a*v2*w*y2*z + 3*a3*x*y2*z + 8*a2*u*x*y2*z + a*u2*x*y2*z + 22*a2*v*x*y2*z - 12*a*u*v*x*y2*z - 13*a*v2*x*y2*z + 10*a2*w*x*y2*z - 10*a*u*w*x*y2*z + 2*a*v*w*x*y2*z - 18*a2*x2*y2*z + a*u*x2*y2*z + 8*a*v*x2*y2*z - a*w*x2*y2*z + 3*a*x3*y2*z + 27*a3*y3*z - 30*a2*u*y3*z + 3*a*u2*y3*z - 18*a2*v*y3*z + 14*a*u*v*y3*z - a*v2*y3*z - 6*a2*x*y3*z + 10*a*u*x*y3*z + 6*a*v*x*y3*z - 5*a*x2*y3*z + 45*a5*z2 - 12*a4*u*z2 - 24*a3*u2*z2 + 2*a2*u3*z2 + a*u4*z2 - 72*a4*v*z2 + 27*a3*u*v*z2 + 20*a2*u2*v*z2 - a*u3*v*z2 + 24*a3*v2*z2 - 18*a2*u*v2*z2 - 2*a*u2*v2*z2 + 4*a2*v3*z2 + 3*a*u*v3*z2 - a*v4*z2 + 12*a4*w*z2 + 21*a3*u*w*z2 - 14*a2*u2*w*z2 - 3*a*u3*w*z2 - 15*a3*v*w*z2 - 4*a2*u*v*w*z2 + 7*a*u2*v*w*z2 + 2*a2*v2*w*z2 - 5*a*u*v2*w*z2 + a*v3*w*z2 - 9*a3*w2*z2 + 4*a2*u*w2*z2 + a*u2*w2*z2 + 4*a2*v*w2*z2 - 2*a*u*v*w2*z2 + a*v2*w2*z2 - 12*a4*x*z2 - 3*a3*u*x*z2 + 10*a2*u2*x*z2 - a*u3*x*z2 + 45*a3*v*x*z2 + 14*a2*u*v*x*z2 - 13*a*u2*v*x*z2 - 38*a2*v2*x*z2 + a*u*v2*x*z2 + 5*a*v3*x*z2 - 42*a3*w*x*z2 - 10*a2*u*w*x*z2 + 16*a*u2*w*x*z2 + 30*a2*v*w*x*z2 + 10*a2*w2*x*z2 - 4*a*u*w2*x*z2 - 4*a*v*w2*x*z2 - 51*a3*x2*z2 + 22*a2*u*x2*z2 + 3*a*u2*x2*z2 + 42*a2*v*x2*z2 - 19*a*u*v*x2*z2 + 3*a*v2*x2*z2 + 32*a2*w*x2*z2 - 11*a*u*w*x2*z2 - 15*a*v*w*x2*z2 - a*w2*x2*z2 + 14*a2*x3*z2 - 7*a*u*x3*z2 - 15*a*v*x3*z2 - 2*a*w*x3*z2 + 4*a*x4*z2 + 12*a4*y*z2 - 42*a3*u*y*z2 + 20*a2*u2*y*z2 + 2*a*u3*y*z2 + 3*a3*v*y*z2 + 22*a2*u*v*y*z2 - 13*a*u2*v*y*z2 - 18*a2*v2*y*z2 + 8*a*u*v2*y*z2 + 3*a*v3*y*z2 - 9*a3*w*y*z2 - 14*a2*u*w*y*z2 + 7*a*u2*w*y*z2 + 22*a2*v*w*y*z2 - 2*a*u*v*w*y*z2 - 5*a*v2*w*y*z2 + 3*a3*x*y*z2 + 22*a2*u*x*y*z2 - 13*a*u2*x*y*z2 + 8*a2*v*x*y*z2 - 12*a*u*v*x*y*z2 + a*v2*x*y*z2 + 10*a2*w*x*y*z2 + 2*a*u*w*x*y*z2 - 10*a*v*w*x*y*z2 - 18*a2*x2*y*z2 + 8*a*u*x2*y*z2 + a*v*x2*y*z2 - a*w*x2*y*z2 + 3*a*x3*y*z2 - 36*a3*y2*z2 + 34*a2*u*y2*z2 - 2*a*u2*y2*z2 + 34*a2*v*y2*z2 - 20*a*u*v*y2*z2 - 2*a*v2*y2*z2 + 4*a2*x*y2*z2 - 10*a*u*x*y2*z2 - 10*a*v*x*y2*z2 + 8*a*x2*y2*z2 - 36*a4*z3 + 27*a3*u*z3 + 2*a2*u2*z3 - a*u3*z3 + 36*a3*v*z3 - 30*a2*u*v*z3 + 2*a*u2*v*z3 + 4*a2*v2*z3 + 3*a*u*v2*z3 - 4*a*v3*z3 + 9*a3*w*z3 + 2*a2*u*w*z3 - 3*a*u2*w*z3 - 10*a2*v*w*z3 + 2*a*u*v*w*z3 + a*v2*w*z3 + 45*a3*x*z3 - 28*a2*u*x*z3 - a*u2*x*z3 - 50*a2*v*x*z3 + 20*a*u*v*x*z3 + 5*a*v2*x*z3 - 10*a2*w*x*z3 + 2*a*u*w*x*z3 + 6*a*v*w*x*z3 - 6*a2*x2*z3 + 5*a*u*x2*z3 + 10*a*v*x2*z3 + a*w*x2*z3 - 3*a*x3*z3 + 27*a3*y*z3 - 18*a2*u*y*z3 - a*u2*y*z3 - 30*a2*v*y*z3 + 14*a*u*v*y*z3 + 3*a*v2*y*z3 - 6*a2*x*y*z3 + 6*a*u*x*y*z3 + 10*a*v*x*y*z3 - 5*a*x2*y*z3 - 9*a3*z4 + 4*a2*u*z4 + a*u2*z4 + 10*a2*v*z4 - 4*a*u*v*z4 - a*v2*z4 + 4*a2*x*z4 - 2*a*u*x*z4 - 4*a*v*x*z4 + a*x2*z4;
      *(result+7) = 18*a7 - 21*a6*u - 9*a5*u2 + 9*a4*u3 + 3*a3*u4 - 21*a6*v + 33*a5*u*v - 3*a4*u2*v - 9*a3*u3*v - 9*a5*v2 - 3*a4*u*v2 + 12*a3*u2*v2 + 9*a4*v3 - 9*a3*u*v3 + 3*a3*v4 - 9*a6*w + 15*a5*u*w - 3*a4*u2*w - 3*a3*u3*w + 15*a5*v*w - 18*a4*u*v*w + 3*a3*u2*v*w - 3*a4*v2*w + 3*a3*u*v2*w - 3*a3*v3*w - 9*a5*w2 + 6*a4*u*w2 + 3*a3*u2*w2 + 6*a4*v*w2 - 6*a3*u*v*w2 + 3*a3*v2*w2 - 33*a6*x + 47*a5*u*x + 3*a4*u2*x - 15*a3*u3*x - 2*a2*u4*x + 47*a5*v*x - 49*a4*u*v*x - a3*u2*v*x + 3*a2*u3*v*x + 3*a4*v2*x - a3*u*v2*x - 2*a2*u2*v2*x - 15*a3*v3*x + 3*a2*u*v3*x - 2*a2*v4*x + 12*a5*w*x - 31*a4*u*w*x + 14*a3*u2*w*x + 5*a2*u3*w*x - 31*a4*v*w*x + 36*a3*u*v*w*x - 5*a2*u2*v*w*x + 14*a3*v2*w*x - 5*a2*u*v2*w*x + 5*a2*v3*w*x + 21*a4*w2*x - 16*a3*u*w2*x - 5*a2*u2*w2*x - 16*a3*v*w2*x + 10*a2*u*v*w2*x - 5*a2*v2*w2*x - a5*x2 - 18*a4*u*x2 + 17*a3*u2*x2 + 3*a2*u3*x2 - a*u4*x2 - 18*a4*v*x2 + 4*a3*u*v*x2 + 9*a2*u2*v*x2 + 5*a*u3*v*x2 + 17*a3*v2*x2 + 9*a2*u*v2*x2 - 8*a*u2*v2*x2 + 3*a2*v3*x2 + 5*a*u*v3*x2 - a*v4*x2 + 11*a4*w*x2 + 6*a3*u*w*x2 - 16*a2*u2*w*x2 - a*u3*w*x2 + 6*a3*v*w*x2 - 16*a2*u*v*w*x2 + a*u2*v*w*x2 - 16*a2*v2*w*x2 + a*u*v2*w*x2 - a*v3*w*x2 - 10*a3*w2*x2 + 12*a2*u*w2*x2 + a*u2*w2*x2 + 12*a2*v*w2*x2 - 2*a*u*v*w2*x2 + a*v2*w2*x2 + 22*a4*x3 - 18*a3*u*x3 - 7*a2*u2*x3 + 3*a*u3*x3 - 18*a3*v*x3 + 8*a2*u*v*x3 - 3*a*u2*v*x3 + u3*v*x3 - 7*a2*v2*x3 - 3*a*u*v2*x3 - 2*u2*v2*x3 + 3*a*v3*x3 + u*v3*x3 - 16*a3*w*x3 + 18*a2*u*w*x3 + 2*a*u2*w*x3 - u3*w*x3 + 18*a2*v*w*x3 - 4*a*u*v*w*x3 + u2*v*w*x3 + 2*a*v2*w*x3 + u*v2*w*x3 - v3*w*x3 - 6*a2*w2*x3 + u2*w2*x3 - 2*u*v*w2*x3 + v2*w2*x3 + 7*a2*u*x4 - 4*a*u2*x4 + 7*a2*v*x4 + 3*a*u*v*x4 - 2*u2*v*x4 - 4*a*v2*x4 - 2*u*v2*x4 - 3*a2*w*x4 - 5*a*u*w*x4 + 3*u2*w*x4 - 5*a*v*w*x4 + 2*u*v*w*x4 + 3*v2*w*x4 + 3*a*w2*x4 - 2*u*w2*x4 - 2*v*w2*x4 - 5*a2*x5 + 3*a*u*x5 + 3*a*v*x5 + u*v*x5 + 4*a*w*x5 - 3*u*w*x5 - 3*v*w*x5 + w2*x5 - a*x6 + w*x6 - 21*a6*y + 20*a5*u*y + 18*a4*u2*y - 12*a3*u3*y - 5*a2*u4*y + 29*a5*v*y - 43*a4*u*v*y - a3*u2*v*y + 15*a2*u3*v*y + 3*a4*v2*y + 14*a3*u*v2*y - 17*a2*u2*v2*y - 9*a3*v3*y + 9*a2*u*v3*y - 2*a2*v4*y + 15*a5*w*y - 25*a4*u*w*y + 5*a3*u2*w*y + 5*a2*u3*w*y - 7*a4*v*w*y + 18*a3*u*v*w*y - 11*a2*u2*v*w*y - 7*a3*v2*w*y + 7*a2*u*v2*w*y - a2*v3*w*y + 6*a4*w2*y - 4*a3*u*w2*y - 2*a2*u2*w2*y - 4*a3*v*w2*y + 4*a2*u*v*w2*y - 2*a2*v2*w2*y + 47*a5*x*y - 61*a4*u*x*y - 15*a3*u2*x*y + 25*a2*u3*x*y + 4*a*u4*x*y - 64*a4*v*x*y + 78*a3*u*v*x*y - 4*a2*u2*v*x*y - 10*a*u3*v*x*y + a3*v2*x*y - 11*a2*u*v2*x*y + 10*a*u2*v2*x*y + 14*a2*v3*x*y - 6*a*u*v3*x*y + 2*a*v4*x*y - 31*a4*w*x*y + 52*a3*u*w*x*y - 15*a2*u2*w*x*y - 6*a*u3*w*x*y + 28*a3*v*w*x*y - 38*a2*u*v*w*x*y + 10*a*u2*v*w*x*y + 5*a2*v2*w*x*y - 2*a*u*v2*w*x*y - 2*a*v3*w*x*y - 16*a3*w2*x*y + 12*a2*u*w2*x*y + 4*a*u2*w2*x*y + 12*a2*v*w2*x*y - 8*a*u*v*w2*x*y + 4*a*v2*w2*x*y - 18*a4*x2*y + 48*a3*u*x2*y - 21*a2*u2*x2*y - 10*a*u3*x2*y + u4*x2*y + 34*a3*v*x2*y - 28*a2*u*v*x2*y - a*u2*v*x2*y - 5*u3*v*x2*y - 11*a2*v2*x2*y - 8*a*u*v2*x2*y + 7*u2*v2*x2*y - 5*a*v3*x2*y - 3*u*v3*x2*y + 6*a3*w*x2*y - 22*a2*u*w*x2*y + 15*a*u2*w*x2*y + u3*w*x2*y - 26*a2*v*w*x2*y + 22*a*u*v*w*x2*y + u2*v*w*x2*y + 11*a*v2*w*x2*y - 5*u*v2*w*x2*y + 3*v3*w*x2*y + 12*a2*w2*x2*y - 12*a*u*w2*x2*y - 2*u2*w2*x2*y - 12*a*v*w2*x2*y + 4*u*v*w2*x2*y - 2*v2*w2*x2*y - 18*a3*x3*y + 6*a2*u*x3*y + 15*a*u2*x3*y - 3*u3*x3*y + 8*a2*v*x3*y - 6*a*u*v*x3*y + 6*u2*v*x3*y + 7*a*v2*x3*y + 5*u*v2*x3*y + 18*a2*w*x3*y - 12*a*u*w*x3*y - 5*u2*w*x3*y - 4*a*v*w*x3*y - 2*u*v*w*x3*y - 9*v2*w*x3*y + 4*u*w2*x3*y + 4*v*w2*x3*y + 7*a2*x4*y - 12*a*u*x4*y + 3*u2*x4*y - 7*a*v*x4*y - u*v*x4*y - 5*a*w*x4*y + 7*u*w*x4*y + 9*v*w*x4*y - 2*w2*x4*y + 3*a*x5*y - u*x5*y - 3*w*x5*y - 9*a5*y2 + 18*a4*u*y2 - 8*a3*u2*y2 - 2*a2*u3*y2 + a*u4*y2 + 3*a4*v*y2 - 9*a3*u*v*y2 + 9*a2*u2*v*y2 - 3*a*u3*v*y2 + 8*a3*v2*y2 - 10*a2*u*v2*y2 + 2*a*u2*v2*y2 - a2*v3*y2 + a*u*v3*y2 - a*v4*y2 - 3*a4*w*y2 + 5*a3*u*w*y2 - a2*u2*w*y2 - a*u3*w*y2 - 7*a3*v*w*y2 + 2*a2*u*v*w*y2 + 5*a*u2*v*w*y2 + 7*a2*v2*w*y2 - 7*a*u*v2*w*y2 + 3*a*v3*w*y2 + 3*a3*w2*y2 - 2*a2*u*w2*y2 - a*u2*w2*y2 - 2*a2*v*w2*y2 + 2*a*u*v*w2*y2 - a*v2*w2*y2 + 3*a4*x*y2 - 15*a3*u*x*y2 + 19*a2*u2*x*y2 - 5*a*u3*x*y2 - 2*u4*x*y2 + a3*v*x*y2 - 7*a2*u*v*x*y2 - a*u2*v*x*y2 + 7*u3*v*x*y2 - 5*a2*v2*x*y2 + 13*a*u*v2*x*y2 - 8*u2*v2*x*y2 + a*v3*x*y2 + 3*u*v3*x*y2 + 14*a3*w*x*y2 - 15*a2*u*w*x*y2 + u3*w*x*y2 + 5*a2*v*w*x*y2 - 5*u2*v*w*x*y2 - 16*a*v2*w*x*y2 + 7*u*v2*w*x*y2 - 3*v3*w*x*y2 - 5*a2*w2*x*y2 + 4*a*u*w2*x*y2 + u2*w2*x*y2 + 4*a*v*w2*x*y2 - 2*u*v*w2*x*y2 + v2*w2*x*y2 + 17*a3*x2*y2 - 21*a2*u*x2*y2 - 3*a*u2*x2*y2 + 7*u3*x2*y2 - 11*a2*v*x2*y2 + 19*a*u*v*x2*y2 - 8*u2*v*x2*y2 - 3*a*v2*x2*y2 - 3*u*v2*x2*y2 - 16*a2*w*x2*y2 + 15*a*u*w*x2*y2 + u2*w*x2*y2 + 11*a*v*w*x2*y2 - 2*u*v*w*x2*y2 + 9*v2*w*x2*y2 + a*w2*x2*y2 - 2*u*w2*x2*y2 - 2*v*w2*x2*y2 - 7*a2*x3*y2 + 15*a*u*x3*y2 - 8*u2*x3*y2 + 7*a*v*x3*y2 - 3*u*v*x3*y2 + 2*a*w*x3*y2 - 5*u*w*x3*y2 - 9*v*w*x3*y2 + w2*x3*y2 - 4*a*x4*y2 + 3*u*x4*y2 + 3*w*x4*y2 + 9*a4*y3 - 12*a3*u*y3 - 2*a2*u2*y3 + 4*a*u3*y3 + u4*y3 - 9*a3*v*y3 + 15*a2*u*v*y3 - 3*a*u2*v*y3 - 3*u3*v*y3 - a2*v2*y3 - 2*a*u*v2*y3 + 3*u2*v2*y3 + a*v3*y3 - u*v3*y3 - 3*a3*w*y3 + 5*a2*u*w*y3 - a*u2*w*y3 - u3*w*y3 - a2*v*w*y3 - 2*a*u*v*w*y3 + 3*u2*v*w*y3 + 3*a*v2*w*y3 - 3*u*v2*w*y3 + v3*w*y3 - 15*a3*x*y3 + 25*a2*u*x*y3 - 5*a*u2*x*y3 - 5*u3*x*y3 + 14*a2*v*x*y3 - 20*a*u*v*x*y3 + 6*u2*v*x*y3 + a*v2*x*y3 - u*v2*x*y3 + 5*a2*w*x*y3 - 6*a*u*w*x*y3 + u2*w*x*y3 - 2*a*v*w*x*y3 + 2*u*v*w*x*y3 - 3*v2*w*x*y3 + 3*a2*x2*y3 - 10*a*u*x2*y3 + 7*u2*x2*y3 - 5*a*v*x2*y3 + 5*u*v*x2*y3 - a*w*x2*y3 + u*w*x2*y3 + 3*v*w*x2*y3 + 3*a*x3*y3 - 3*u*x3*y3 - w*x3*y3 + 3*a3*y4 - 5*a2*u*y4 + a*u2*y4 + u3*y4 - 2*a2*v*y4 + 4*a*u*v*y4 - 2*u2*v*y4 - a*v2*y4 + u*v2*y4 - 2*a2*x*y4 + 4*a*u*x*y4 - 2*u2*x*y4 + 2*a*v*x*y4 - 2*u*v*x*y4 - a*x2*y4 + u*x2*y4 - 21*a6*z + 29*a5*u*z + 3*a4*u2*z - 9*a3*u3*z - 2*a2*u4*z + 20*a5*v*z - 43*a4*u*v*z + 14*a3*u2*v*z + 9*a2*u3*v*z + 18*a4*v2*z - a3*u*v2*z - 17*a2*u2*v2*z - 12*a3*v3*z + 15*a2*u*v3*z - 5*a2*v4*z + 15*a5*w*z - 7*a4*u*w*z - 7*a3*u2*w*z - a2*u3*w*z - 25*a4*v*w*z + 18*a3*u*v*w*z + 7*a2*u2*v*w*z + 5*a3*v2*w*z - 11*a2*u*v2*w*z + 5*a2*v3*w*z + 6*a4*w2*z - 4*a3*u*w2*z - 2*a2*u2*w2*z - 4*a3*v*w2*z + 4*a2*u*v*w2*z - 2*a2*v2*w2*z + 47*a5*x*z - 64*a4*u*x*z + a3*u2*x*z + 14*a2*u3*x*z + 2*a*u4*x*z - 61*a4*v*x*z + 78*a3*u*v*x*z - 11*a2*u2*v*x*z - 6*a*u3*v*x*z - 15*a3*v2*x*z - 4*a2*u*v2*x*z + 10*a*u2*v2*x*z + 25*a2*v3*x*z - 10*a*u*v3*x*z + 4*a*v4*x*z - 31*a4*w*x*z + 28*a3*u*w*x*z + 5*a2*u2*w*x*z - 2*a*u3*w*x*z + 52*a3*v*w*x*z - 38*a2*u*v*w*x*z - 2*a*u2*v*w*x*z - 15*a2*v2*w*x*z + 10*a*u*v2*w*x*z - 6*a*v3*w*x*z - 16*a3*w2*x*z + 12*a2*u*w2*x*z + 4*a*u2*w2*x*z + 12*a2*v*w2*x*z - 8*a*u*v*w2*x*z + 4*a*v2*w2*x*z - 18*a4*x2*z + 34*a3*u*x2*z - 11*a2*u2*x2*z - 5*a*u3*x2*z + 48*a3*v*x2*z - 28*a2*u*v*x2*z - 8*a*u2*v*x2*z - 3*u3*v*x2*z - 21*a2*v2*x2*z - a*u*v2*x2*z + 7*u2*v2*x2*z - 10*a*v3*x2*z - 5*u*v3*x2*z + v4*x2*z + 6*a3*w*x2*z - 26*a2*u*w*x2*z + 11*a*u2*w*x2*z + 3*u3*w*x2*z - 22*a2*v*w*x2*z + 22*a*u*v*w*x2*z - 5*u2*v*w*x2*z + 15*a*v2*w*x2*z + u*v2*w*x2*z + v3*w*x2*z + 12*a2*w2*x2*z - 12*a*u*w2*x2*z - 2*u2*w2*x2*z - 12*a*v*w2*x2*z + 4*u*v*w2*x2*z - 2*v2*w2*x2*z - 18*a3*x3*z + 8*a2*u*x3*z + 7*a*u2*x3*z + 6*a2*v*x3*z - 6*a*u*v*x3*z + 5*u2*v*x3*z + 15*a*v2*x3*z + 6*u*v2*x3*z - 3*v3*x3*z + 18*a2*w*x3*z - 4*a*u*w*x3*z - 9*u2*w*x3*z - 12*a*v*w*x3*z - 2*u*v*w*x3*z - 5*v2*w*x3*z + 4*u*w2*x3*z + 4*v*w2*x3*z + 7*a2*x4*z - 7*a*u*x4*z - 12*a*v*x4*z - u*v*x4*z + 3*v2*x4*z - 5*a*w*x4*z + 9*u*w*x4*z + 7*v*w*x4*z - 2*w2*x4*z + 3*a*x5*z - v*x5*z - 3*w*x5*z + 33*a5*y*z - 43*a4*u*y*z - 9*a3*u2*y*z + 15*a2*u3*y*z + 4*a*u4*y*z - 43*a4*v*y*z + 68*a3*u*v*y*z - 11*a2*u2*v*y*z - 14*a*u3*v*y*z - 9*a3*v2*y*z - 11*a2*u*v2*y*z + 20*a*u2*v2*y*z + 15*a2*v3*y*z - 14*a*u*v3*y*z + 4*a*v4*y*z - 18*a4*w*y*z + 18*a3*u*w*y*z + 2*a2*u2*w*y*z - 2*a*u3*w*y*z + 18*a3*v*w*y*z - 20*a2*u*v*w*y*z + 2*a*u2*v*w*y*z + 2*a2*v2*w*y*z + 2*a*u*v2*w*y*z - 2*a*v3*w*y*z - 6*a3*w2*y*z + 4*a2*u*w2*y*z + 2*a*u2*w2*y*z + 4*a2*v*w2*y*z - 4*a*u*v*w2*y*z + 2*a*v2*w2*y*z - 49*a4*x*y*z + 78*a3*u*x*y*z - 7*a2*u2*x*y*z - 20*a*u3*x*y*z - 2*u4*x*y*z + 78*a3*v*x*y*z - 96*a2*u*v*x*y*z + 12*a*u2*v*x*y*z + 6*u3*v*x*y*z - 7*a2*v2*x*y*z + 12*a*u*v2*x*y*z - 8*u2*v2*x*y*z - 20*a*v3*x*y*z + 6*u*v3*x*y*z - 2*v4*x*y*z + 36*a3*w*x*y*z - 38*a2*u*w*x*y*z + 2*u3*w*x*y*z - 38*a2*v*w*x*y*z + 32*a*u*v*w*x*y*z - 2*u2*v*w*x*y*z - 2*u*v2*w*x*y*z + 2*v3*w*x*y*z + 10*a2*w2*x*y*z - 8*a*u*w2*x*y*z - 2*u2*w2*x*y*z - 8*a*v*w2*x*y*z + 4*u*v*w2*x*y*z - 2*v2*w2*x*y*z + 4*a3*x2*y*z - 28*a2*u*x2*y*z + 19*a*u2*x2*y*z + 5*u3*x2*y*z - 28*a2*v*x2*y*z + 32*a*u*v*x2*y*z - u2*v*x2*y*z + 19*a*v2*x2*y*z - u*v2*x2*y*z + 5*v3*x2*y*z - 16*a2*w*x2*y*z + 22*a*u*w*x2*y*z - 2*u2*w*x2*y*z + 22*a*v*w*x2*y*z - 12*u*v*w*x2*y*z - 2*v2*w*x2*y*z - 2*a*w2*x2*y*z + 4*u*w2*x2*y*z + 4*v*w2*x2*y*z + 8*a2*x3*y*z - 6*a*u*x3*y*z - 3*u2*x3*y*z - 6*a*v*x3*y*z - 4*u*v*x3*y*z - 3*v2*x3*y*z - 4*a*w*x3*y*z - 2*u*w*x3*y*z - 2*v*w*x3*y*z - 2*w2*x3*y*z + 3*a*x4*y*z - u*x4*y*z - v*x4*y*z + 2*w*x4*y*z + x5*y*z - 3*a4*y2*z - a3*u*y2*z + 9*a2*u2*y2*z - 3*a*u3*y2*z - 2*u4*y2*z + 14*a3*v*y2*z - 11*a2*u*v*y2*z - 8*a*u2*v*y2*z + 5*u3*v*y2*z - 10*a2*v2*y2*z + 13*a*u*v2*y2*z - 3*u2*v2*y2*z - 2*a*v3*y2*z - u*v3*y2*z + v4*y2*z + 3*a3*w*y2*z - 11*a2*u*w*y2*z + 5*a*u2*w*y2*z + 3*u3*w*y2*z + 7*a2*v*w*y2*z + 2*a*u*v*w*y2*z - 9*u2*v*w*y2*z - 7*a*v2*w*y2*z + 9*u*v2*w*y2*z - 3*v3*w*y2*z - a3*x*y2*z - 4*a2*u*x*y2*z - a*u2*x*y2*z + 6*u3*x*y2*z - 11*a2*v*x*y2*z + 12*a*u*v*x*y2*z - u2*v*x*y2*z + 13*a*v2*x*y2*z - 4*u*v2*x*y2*z - v3*x*y2*z - 5*a2*w*x*y2*z + 10*a*u*w*x*y2*z - 5*u2*w*x*y2*z - 2*a*v*w*x*y2*z - 2*u*v*w*x*y2*z + 7*v2*w*x*y2*z + 9*a2*x2*y2*z - a*u*x2*y2*z - 8*u2*x2*y2*z - 8*a*v*x2*y2*z - u*v*x2*y2*z - 3*v2*x2*y2*z + a*w*x2*y2*z + u*w*x2*y2*z - 5*v*w*x2*y2*z - 3*a*x3*y2*z + 6*u*x3*y2*z + 5*v*x3*y2*z + w*x3*y2*z - 2*x4*y2*z - 9*a3*y3*z + 15*a2*u*y3*z - 3*a*u2*y3*z - 3*u3*y3*z + 9*a2*v*y3*z - 14*a*u*v*y3*z + 5*u2*v*y3*z + a*v2*y3*z - u*v2*y3*z - v3*y3*z + 3*a2*x*y3*z - 10*a*u*x*y3*z + 7*u2*x*y3*z - 6*a*v*x*y3*z + 6*u*v*x*y3*z + 3*v2*x*y3*z + 5*a*x2*y3*z - 5*u*x2*y3*z - 3*v*x2*y3*z + x3*y3*z - 9*a5*z2 + 3*a4*u*z2 + 8*a3*u2*z2 - a2*u3*z2 - a*u4*z2 + 18*a4*v*z2 - 9*a3*u*v*z2 - 10*a2*u2*v*z2 + a*u3*v*z2 - 8*a3*v2*z2 + 9*a2*u*v2*z2 + 2*a*u2*v2*z2 - 2*a2*v3*z2 - 3*a*u*v3*z2 + a*v4*z2 - 3*a4*w*z2 - 7*a3*u*w*z2 + 7*a2*u2*w*z2 + 3*a*u3*w*z2 + 5*a3*v*w*z2 + 2*a2*u*v*w*z2 - 7*a*u2*v*w*z2 - a2*v2*w*z2 + 5*a*u*v2*w*z2 - a*v3*w*z2 + 3*a3*w2*z2 - 2*a2*u*w2*z2 - a*u2*w2*z2 - 2*a2*v*w2*z2 + 2*a*u*v*w2*z2 - a*v2*w2*z2 + 3*a4*x*z2 + a3*u*x*z2 - 5*a2*u2*x*z2 + a*u3*x*z2 - 15*a3*v*x*z2 - 7*a2*u*v*x*z2 + 13*a*u2*v*x*z2 + 3*u3*v*x*z2 + 19*a2*v2*x*z2 - a*u*v2*x*z2 - 8*u2*v2*x*z2 - 5*a*v3*x*z2 + 7*u*v3*x*z2 - 2*v4*x*z2 + 14*a3*w*x*z2 + 5*a2*u*w*x*z2 - 16*a*u2*w*x*z2 - 3*u3*w*x*z2 - 15*a2*v*w*x*z2 + 7*u2*v*w*x*z2 - 5*u*v2*w*x*z2 + v3*w*x*z2 - 5*a2*w2*x*z2 + 4*a*u*w2*x*z2 + u2*w2*x*z2 + 4*a*v*w2*x*z2 - 2*u*v*w2*x*z2 + v2*w2*x*z2 + 17*a3*x2*z2 - 11*a2*u*x2*z2 - 3*a*u2*x2*z2 - 21*a2*v*x2*z2 + 19*a*u*v*x2*z2 - 3*u2*v*x2*z2 - 3*a*v2*x2*z2 - 8*u*v2*x2*z2 + 7*v3*x2*z2 - 16*a2*w*x2*z2 + 11*a*u*w*x2*z2 + 9*u2*w*x2*z2 + 15*a*v*w*x2*z2 - 2*u*v*w*x2*z2 + v2*w*x2*z2 + a*w2*x2*z2 - 2*u*w2*x2*z2 - 2*v*w2*x2*z2 - 7*a2*x3*z2 + 7*a*u*x3*z2 + 15*a*v*x3*z2 - 3*u*v*x3*z2 - 8*v2*x3*z2 + 2*a*w*x3*z2 - 9*u*w*x3*z2 - 5*v*w*x3*z2 + w2*x3*z2 - 4*a*x4*z2 + 3*v*x4*z2 + 3*w*x4*z2 - 3*a4*y*z2 + 14*a3*u*y*z2 - 10*a2*u2*y*z2 - 2*a*u3*y*z2 + u4*y*z2 - a3*v*y*z2 - 11*a2*u*v*y*z2 + 13*a*u2*v*y*z2 - u3*v*y*z2 + 9*a2*v2*y*z2 - 8*a*u*v2*y*z2 - 3*u2*v2*y*z2 - 3*a*v3*y*z2 + 5*u*v3*y*z2 - 2*v4*y*z2 + 3*a3*w*y*z2 + 7*a2*u*w*y*z2 - 7*a*u2*w*y*z2 - 3*u3*w*y*z2 - 11*a2*v*w*y*z2 + 2*a*u*v*w*y*z2 + 9*u2*v*w*y*z2 + 5*a*v2*w*y*z2 - 9*u*v2*w*y*z2 + 3*v3*w*y*z2 - a3*x*y*z2 - 11*a2*u*x*y*z2 + 13*a*u2*x*y*z2 - u3*x*y*z2 - 4*a2*v*x*y*z2 + 12*a*u*v*x*y*z2 - 4*u2*v*x*y*z2 - a*v2*x*y*z2 - u*v2*x*y*z2 + 6*v3*x*y*z2 - 5*a2*w*x*y*z2 - 2*a*u*w*x*y*z2 + 7*u2*w*x*y*z2 + 10*a*v*w*x*y*z2 - 2*u*v*w*x*y*z2 - 5*v2*w*x*y*z2 + 9*a2*x2*y*z2 - 8*a*u*x2*y*z2 - 3*u2*x2*y*z2 - a*v*x2*y*z2 - u*v*x2*y*z2 - 8*v2*x2*y*z2 + a*w*x2*y*z2 - 5*u*w*x2*y*z2 + v*w*x2*y*z2 - 3*a*x3*y*z2 + 5*u*x3*y*z2 + 6*v*x3*y*z2 + w*x3*y*z2 - 2*x4*y*z2 + 12*a3*y2*z2 - 17*a2*u*y2*z2 + 2*a*u2*y2*z2 + 3*u3*y2*z2 - 17*a2*v*y2*z2 + 20*a*u*v*y2*z2 - 3*u2*v*y2*z2 + 2*a*v2*y2*z2 - 3*u*v2*y2*z2 + 3*v3*y2*z2 - 2*a2*x*y2*z2 + 10*a*u*x*y2*z2 - 8*u2*x*y2*z2 + 10*a*v*x*y2*z2 - 8*u*v*x*y2*z2 - 8*v2*x*y2*z2 - 8*a*x2*y2*z2 + 7*u*x2*y2*z2 + 7*v*x2*y2*z2 - 2*x3*y2*z2 + 9*a4*z3 - 9*a3*u*z3 - a2*u2*z3 + a*u3*z3 - 12*a3*v*z3 + 15*a2*u*v*z3 - 2*a*u2*v*z3 - u3*v*z3 - 2*a2*v2*z3 - 3*a*u*v2*z3 + 3*u2*v2*z3 + 4*a*v3*z3 - 3*u*v3*z3 + v4*z3 - 3*a3*w*z3 - a2*u*w*z3 + 3*a*u2*w*z3 + u3*w*z3 + 5*a2*v*w*z3 - 2*a*u*v*w*z3 - 3*u2*v*w*z3 - a*v2*w*z3 + 3*u*v2*w*z3 - v3*w*z3 - 15*a3*x*z3 + 14*a2*u*x*z3 + a*u2*x*z3 + 25*a2*v*x*z3 - 20*a*u*v*x*z3 - u2*v*x*z3 - 5*a*v2*x*z3 + 6*u*v2*x*z3 - 5*v3*x*z3 + 5*a2*w*x*z3 - 2*a*u*w*x*z3 - 3*u2*w*x*z3 - 6*a*v*w*x*z3 + 2*u*v*w*x*z3 + v2*w*x*z3 + 3*a2*x2*z3 - 5*a*u*x2*z3 - 10*a*v*x2*z3 + 5*u*v*x2*z3 + 7*v2*x2*z3 - a*w*x2*z3 + 3*u*w*x2*z3 + v*w*x2*z3 + 3*a*x3*z3 - 3*v*x3*z3 - w*x3*z3 - 9*a3*y*z3 + 9*a2*u*y*z3 + a*u2*y*z3 - u3*y*z3 + 15*a2*v*y*z3 - 14*a*u*v*y*z3 - u2*v*y*z3 - 3*a*v2*y*z3 + 5*u*v2*y*z3 - 3*v3*y*z3 + 3*a2*x*y*z3 - 6*a*u*x*y*z3 + 3*u2*x*y*z3 - 10*a*v*x*y*z3 + 6*u*v*x*y*z3 + 7*v2*x*y*z3 + 5*a*x2*y*z3 - 3*u*x2*y*z3 - 5*v*x2*y*z3 + x3*y*z3 + 3*a3*z4 - 2*a2*u*z4 - a*u2*z4 - 5*a2*v*z4 + 4*a*u*v*z4 + u2*v*z4 + a*v2*z4 - 2*u*v2*z4 + v3*z4 - 2*a2*x*z4 + 2*a*u*x*z4 + 4*a*v*x*z4 - 2*u*v*x*z4 - 2*v2*x*z4 - a*x2*z4 + v*x2*z4;
    }

  return;
}

/* **************************************************************** */
/* **************************************************************** */

void TVIL_cHGnum (TVIL_REAL u,
		  TVIL_REAL v,
		  TVIL_REAL w,
		  TVIL_REAL x,
		  TVIL_REAL y,
		  TVIL_REAL z,
		  TVIL_REAL *result)
{
  u2 = u*u;
  u3 = u2*u;
  u4 = u2*u2;

  v2 = v*v;
  v3 = v2*v;
  v4 = v2*v2;

  w2 = w*w;
  w3 = w2*w;

  x2 = x*x;
  x3 = x2*x;
  x4 = x2*x2;
  x5 = x2*x3;

  y2 = y*y;
  y3 = y2*y;

  z2 = z*z;
  z3 = z2*z;

  if (SAME6(u,v,w,x,y,z))
    {
      *(result) = 0;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME5(u,v,w,x,y))
    {
      *(result) = -(a*u) + a*z;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME5(u,v,w,x,z))
    {
      *(result) = -(a*u) + a*y;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME5(u,w,x,y,z))
    {
      *(result) = -(a*u) + a*v;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME5(v,w,x,y,z))
    {
      *(result) = a*u - a*v;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME4(u,w,x,y) && SAME2(v,z))
    {
      *(result) = -(a*u) + a*v;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME4(v,w,x,z) && SAME2(u,y))
    {
      *(result) = a*u - a*v;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(u,v,w) && SAME3(x,y,z))
    {
      *(result) = -(a*u) + a*x;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(u,v,x) && SAME3(w,y,z))
    {
      *(result) = a*u - a*w;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(u,w,z) && SAME3(v,x,y))
    {
      *(result) = -(a*u) + a*v;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(u,x,z) && SAME3(v,w,y))
    {
      *(result) = a*u - a*v;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME4(u,v,y,z))
    {
      *(result) = 4*a*u - 3*a*w - a*x;
      *(result+1) = 0;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME2(u,z) && SAME2(v,y) && SAME2(w,x))
    {
      *(result) = -2*a2*u - 2*a2*v + 4*a2*w;
      *(result+1) = 2*a2*u + 2*a*u2 + 2*a2*v - 4*a*u*v + 2*a*v2 - 4*a2*w - 2*a*u*w - 2*a*v*w + 4*a*w2;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME2(u,v) && SAME2(y,z))
    {
      *(result) = -6*a2*u + 9*a2*w + 3*a2*x - 6*a2*y;
      *(result+1) = 6*a2*u - 6*a*u2 - 9*a2*w + 6*a*u*w - 3*a2*x + 4*a*u*x - 3*a*w*x - a*x2 + 6*a2*y - 4*a*u*y + 6*a*w*y + 4*a*x*y - 6*a*y2;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(u,v,x))
    {
      *(result) = -(a2*u) + 3*a2*w - a2*y - a2*z;
      *(result+1) = a2*u - a*u2 - 3*a2*w + a*u*w + a2*y + a*w*y - a*y2 + a2*z + a*w*z - a*z2;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(x,y,z))
    {
      *(result) = -(a2*u) - a2*v + 3*a2*w - a2*x;
      *(result+1) = a2*u - a*u2 + a2*v - a*v2 - 3*a2*w + a*u*w + a*v*w + a2*x + a*w*x - a*x2;
      *(result+2) = 0;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(u,v,w) && SAME2(x,y))
    {
      *(result) = -3*a3*u + 3*a3*z;
      *(result+1) = 6*a3*u - 8*a2*u*x + 2*a2*x2 - 6*a3*z + 2*a2*u*z + 4*a2*x*z;
      *(result+2) = -3*a3*u + 8*a2*u*x - 2*a2*x2 - 4*a*u*x2 + a*x3 + 3*a3*z - 2*a2*u*z - 4*a2*x*z + 3*a*x2*z + a*u*z2 - a*x*z2;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(u,v,w) && SAME2(x,z))
    {
      *(result) = -3*a3*u + 3*a3*y;
      *(result+1) = 6*a3*u - 8*a2*u*x + 2*a2*x2 - 6*a3*y + 2*a2*u*y + 4*a2*x*y;
      *(result+2) = -3*a3*u + 8*a2*u*x - 2*a2*x2 - 4*a*u*x2 + a*x3 + 3*a3*y - 2*a2*u*y - 4*a2*x*y + 3*a*x2*y + a*u*y2 - a*x*y2;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(w,y,z) && SAME2(u,x))
    {
      *(result) = 3*a3*v - 3*a3*w;
      *(result+1) = 2*a2*u2 - 6*a3*v + 4*a2*u*v + 6*a3*w - 8*a2*u*w + 2*a2*v*w;
      *(result+2) = -2*a2*u2 + a*u3 + 3*a3*v - 4*a2*u*v + 3*a*u2*v - a*u*v2 - 3*a3*w + 8*a2*u*w - 4*a*u2*w - 2*a2*v*w + a*v2*w;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME3(w,y,z) && SAME2(v,x))
    {
      *(result) = 3*a3*u - 3*a3*w;
      *(result+1) = -6*a3*u + 4*a2*u*v + 2*a2*v2 + 6*a3*w + 2*a2*u*w - 8*a2*v*w;
      *(result+2) = 3*a3*u - 4*a2*u*v - a*u2*v - 2*a2*v2 + 3*a*u*v2 + a*v3 - 3*a3*w - 2*a2*u*w + a*u2*w + 8*a2*v*w - 4*a*v2*w;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME4(u,w,x,y))
    {
      *(result) = -6*a3*u + 3*a3*v + 3*a3*z;
      *(result+1) = 12*a3*u - 8*a2*u2 - 6*a3*v + 2*a2*u*v - 6*a3*z + 2*a2*u*z + 4*a2*v*z;
      *(result+2) = -6*a3*u + 8*a2*u2 + 3*a3*v - 2*a2*u*v - 4*a*u2*v + a*u*v2 + 3*a3*z - 2*a2*u*z - 4*a*u2*z - 4*a2*v*z + 8*a*u*v*z - a*v2*z + a*u*z2 - a*v*z2;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME4(v,w,x,z))
    {
      *(result) = 3*a3*u - 6*a3*v + 3*a3*y;
      *(result+1) = -6*a3*u + 12*a3*v + 2*a2*u*v - 8*a2*v2 - 6*a3*y + 4*a2*u*y + 2*a2*v*y;
      *(result+2) = 3*a3*u - 6*a3*v - 2*a2*u*v + a*u2*v + 8*a2*v2 - 4*a*u*v2 + 3*a3*y - 4*a2*u*y - a*u2*y - 2*a2*v*y + 8*a*u*v*y - 4*a*v2*y - a*u*y2 + a*v*y2;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME2(u,y) && SAME2(v,z))
    {
      *(result) = 2*a3*u + 2*a3*v - 3*a3*w - a3*x;
      *(result+1) = -4*a3*u + 4*a2*u2 - 4*a3*v - 8*a2*u*v + 4*a2*v2 + 6*a3*w + 2*a3*x + 4*a2*u*x + 4*a2*v*x - 6*a2*w*x - 2*a2*x2;
      *(result+2) = 2*a3*u - 4*a2*u2 + 2*a*u3 + 2*a3*v + 8*a2*u*v - 2*a*u2*v - 4*a2*v2 - 2*a*u*v2 + 2*a*v3 - 3*a3*w - a*u2*w + 2*a*u*v*w - a*v2*w - a3*x - 4*a2*u*x + a*u2*x - 4*a2*v*x - 2*a*u*v*x + a*v2*x + 6*a2*w*x + 2*a2*x2 + 2*a*u*x2 + 2*a*v*x2 - 3*a*w*x2 - a*x3;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME2(u,z) && SAME2(v,y))
    {
      *(result) = 2*a3*u + 2*a3*v - 3*a3*w - a3*x;
      *(result+1) = -4*a3*u - 2*a2*u2 - 4*a3*v + 4*a2*u*v - 2*a2*v2 + 6*a3*w + 2*a3*x + 4*a2*u*x + 4*a2*v*x - 6*a2*w*x - 2*a2*x2;
      *(result+2) = 2*a3*u + 2*a2*u2 + 2*a3*v - 4*a2*u*v + 2*a2*v2 - 3*a3*w - a*u2*w + 2*a*u*v*w - a*v2*w - a3*x - 4*a2*u*x - a*u2*x - 4*a2*v*x + 2*a*u*v*x - a*v2*x + 6*a2*w*x + 2*a2*x2 + 2*a*u*x2 + 2*a*v*x2 - 3*a*w*x2 - a*x3;
      *(result+3) = 0;
      *(result+4) = 0;
    }
  else if (SAME4(u,w,x,z))
    {
      *(result) = 6*a4*u - 3*a4*v - 3*a4*y;
      *(result+1) = -18*a4*u + 20*a3*u2 + 9*a4*v - 11*a3*u*v - 3*a3*v2 + 9*a4*y - 11*a3*u*y + 8*a3*v*y - 3*a3*y2;
      *(result+2) = 18*a4*u - 40*a3*u2 + 16*a2*u3 - 9*a4*v + 22*a3*u*v - 4*a2*u2*v + 6*a3*v2 - 9*a2*u*v2 - 9*a4*y + 22*a3*u*y - 4*a2*u2*y - 16*a3*v*y + 4*a2*u*v*y + 3*a2*v2*y + 6*a3*y2 - 9*a2*u*y2 + 3*a2*v*y2;
      *(result+3) = -6*a4*u + 20*a3*u2 - 16*a2*u3 + 3*a4*v - 11*a3*u*v + 4*a2*u2*v + 8*a*u3*v - 3*a3*v2 + 9*a2*u*v2 - 10*a*u2*v2 + 2*a*u*v3 + 3*a4*y - 11*a3*u*y + 4*a2*u2*y + 8*a*u3*y + 8*a3*v*y - 4*a2*u*v*y - 8*a*u2*v*y - 3*a2*v2*y + 5*a*u*v2*y - 2*a*v3*y - 3*a3*y2 + 9*a2*u*y2 - 10*a*u2*y2 - 3*a2*v*y2 + 5*a*u*v*y2 + 2*a*v2*y2 + 2*a*u*y3 - 2*a*v*y3;
      *(result+4) = 0;
    }
  else if (SAME4(v,w,x,y))
    {
      *(result) = -3*a4*u + 6*a4*v - 3*a4*z;
      *(result+1) = 9*a4*u - 3*a3*u2 - 18*a4*v - 11*a3*u*v + 20*a3*v2 + 9*a4*z + 8*a3*u*z - 11*a3*v*z - 3*a3*z2;
      *(result+2) = -9*a4*u + 6*a3*u2 + 18*a4*v + 22*a3*u*v - 9*a2*u2*v - 40*a3*v2 - 4*a2*u*v2 + 16*a2*v3 - 9*a4*z - 16*a3*u*z + 3*a2*u2*z + 22*a3*v*z + 4*a2*u*v*z - 4*a2*v2*z + 6*a3*z2 + 3*a2*u*z2 - 9*a2*v*z2;
      *(result+3) = 3*a4*u - 3*a3*u2 - 6*a4*v - 11*a3*u*v + 9*a2*u2*v + 2*a*u3*v + 20*a3*v2 + 4*a2*u*v2 - 10*a*u2*v2 - 16*a2*v3 + 8*a*u*v3 + 3*a4*z + 8*a3*u*z - 3*a2*u2*z - 2*a*u3*z - 11*a3*v*z - 4*a2*u*v*z + 5*a*u2*v*z + 4*a2*v2*z - 8*a*u*v2*z + 8*a*v3*z - 3*a3*z2 - 3*a2*u*z2 + 2*a*u2*z2 + 9*a2*v*z2 + 5*a*u*v*z2 - 10*a*v2*z2 - 2*a*u*z3 + 2*a*v*z3;
      *(result+4) = 0;
    }
  else if (SAME2(u,w) && SAME2(x,y))
    {
      *(result) = 6*a4*u - 3*a4*v - 3*a4*z;
      *(result+1) = -18*a4*u + 9*a4*v + 3*a3*u*v - 3*a3*v2 + 10*a3*u*x + a3*v*x - 2*a3*x2 + 9*a4*z + 5*a3*u*z - 7*a3*v*z - 7*a3*x*z;
      *(result+2) = 18*a4*u - 9*a4*v - 6*a3*u*v + 6*a3*v2 - 20*a3*u*x - 3*a2*u2*x - 2*a3*v*x + 6*a2*u*v*x - 3*a2*v2*x + 4*a3*x2 + 6*a2*u*x2 + 6*a2*v*x2 - 3*a2*x3 - 9*a4*z - 10*a3*u*z + 3*a2*u2*z + 14*a3*v*z - 3*a2*v2*z + 14*a3*x*z + 8*a2*u*x*z - 10*a2*v*x*z - 7*a2*x2*z - 2*a2*u*z2 + a2*v*z2 + a2*x*z2;
      *(result+3) = -6*a4*u + 3*a4*v + 3*a3*u*v - 3*a3*v2 + 10*a3*u*x + 3*a2*u2*x + a*u3*x + a3*v*x - 6*a2*u*v*x - 3*a*u2*v*x + 3*a2*v2*x + 3*a*u*v2*x - a*v3*x - 2*a3*x2 - 6*a2*u*x2 - 3*a*u2*x2 - 6*a2*v*x2 + 2*a*u*v*x2 + a*v2*x2 + 3*a2*x3 + 3*a*u*x3 + a*v*x3 - a*x4 + 3*a4*z + 5*a3*u*z - 3*a2*u2*z - a*u3*z - 7*a3*v*z + 3*a*u2*v*z + 3*a2*v2*z - 3*a*u*v2*z + a*v3*z - 7*a3*x*z - 8*a2*u*x*z + 3*a*u2*x*z + 10*a2*v*x*z + 2*a*u*v*x*z - 5*a*v2*x*z + 7*a2*x2*z + a*u*x2*z - a*v*x2*z - 3*a*x3*z + 2*a2*u*z2 - a2*v*z2 - a*u*v*z2 + a*v2*z2 - a2*x*z2 - a*u*x*z2 + a*x2*z2;
      *(result+4) = 0;
    }
  else if (SAME2(u,x) && SAME2(w,y))
    {
      *(result) = -3*a4*v + 6*a4*w - 3*a4*z;
      *(result+1) = -2*a3*u2 + 9*a4*v - 7*a3*u*v - 18*a4*w + 10*a3*u*w + 5*a3*v*w + 9*a4*z + a3*u*z - 7*a3*v*z + 3*a3*w*z - 3*a3*z2;
      *(result+2) = 4*a3*u2 - 3*a2*u3 - 9*a4*v + 14*a3*u*v - 7*a2*u2*v + a2*u*v2 + 18*a4*w - 20*a3*u*w + 6*a2*u2*w - 10*a3*v*w + 8*a2*u*v*w - 2*a2*v2*w - 3*a2*u*w2 + 3*a2*v*w2 - 9*a4*z - 2*a3*u*z + 6*a2*u2*z + 14*a3*v*z - 10*a2*u*v*z + a2*v2*z - 6*a3*w*z + 6*a2*u*w*z + 6*a3*z2 - 3*a2*u*z2 - 3*a2*v*z2;
      *(result+3) = -2*a3*u2 + 3*a2*u3 - a*u4 + 3*a4*v - 7*a3*u*v + 7*a2*u2*v - 3*a*u3*v - a2*u*v2 + a*u2*v2 - 6*a4*w + 10*a3*u*w - 6*a2*u2*w + 3*a*u3*w + 5*a3*v*w - 8*a2*u*v*w + a*u2*v*w + 2*a2*v2*w - a*u*v2*w + 3*a2*u*w2 - 3*a*u2*w2 - 3*a2*v*w2 + 3*a*u*v*w2 + a*u*w3 - a*v*w3 + 3*a4*z + a3*u*z - 6*a2*u2*z + a*u3*z - 7*a3*v*z + 10*a2*u*v*z - a*u2*v*z - a2*v2*z + 3*a3*w*z - 6*a2*u*w*z + 2*a*u2*w*z + 2*a*u*v*w*z - a*v2*w*z - 3*a*u*w2*z + 3*a*v*w2*z - 3*a3*z2 + 3*a2*u*z2 + a*u2*z2 + 3*a2*v*z2 - 5*a*u*v*z2 + a*v2*z2 + 3*a*u*w*z2 - 3*a*v*w*z2 - a*u*z3 + a*v*z3;
      *(result+4) = 0;
    }
  else if (SAME2(v,w) && SAME2(x,z))
    {
      *(result) = -3*a4*u + 6*a4*v - 3*a4*y;
      *(result+1) = 9*a4*u - 3*a3*u2 - 18*a4*v + 3*a3*u*v + a3*u*x + 10*a3*v*x - 2*a3*x2 + 9*a4*y - 7*a3*u*y + 5*a3*v*y - 7*a3*x*y;
      *(result+2) = -9*a4*u + 6*a3*u2 + 18*a4*v - 6*a3*u*v - 2*a3*u*x - 3*a2*u2*x - 20*a3*v*x + 6*a2*u*v*x - 3*a2*v2*x + 4*a3*x2 + 6*a2*u*x2 + 6*a2*v*x2 - 3*a2*x3 - 9*a4*y + 14*a3*u*y - 3*a2*u2*y - 10*a3*v*y + 3*a2*v2*y + 14*a3*x*y - 10*a2*u*x*y + 8*a2*v*x*y - 7*a2*x2*y + a2*u*y2 - 2*a2*v*y2 + a2*x*y2;
      *(result+3) = 3*a4*u - 3*a3*u2 - 6*a4*v + 3*a3*u*v + a3*u*x + 3*a2*u2*x - a*u3*x + 10*a3*v*x - 6*a2*u*v*x + 3*a*u2*v*x + 3*a2*v2*x - 3*a*u*v2*x + a*v3*x - 2*a3*x2 - 6*a2*u*x2 + a*u2*x2 - 6*a2*v*x2 + 2*a*u*v*x2 - 3*a*v2*x2 + 3*a2*x3 + a*u*x3 + 3*a*v*x3 - a*x4 + 3*a4*y - 7*a3*u*y + 3*a2*u2*y + a*u3*y + 5*a3*v*y - 3*a*u2*v*y - 3*a2*v2*y + 3*a*u*v2*y - a*v3*y - 7*a3*x*y + 10*a2*u*x*y - 5*a*u2*x*y - 8*a2*v*x*y + 2*a*u*v*x*y + 3*a*v2*x*y + 7*a2*x2*y - a*u*x2*y + a*v*x2*y - 3*a*x3*y - a2*u*y2 + a*u2*y2 + 2*a2*v*y2 - a*u*v*y2 - a2*x*y2 - a*v*x*y2 + a*x2*y2;
      *(result+4) = 0;
    }
  else if (SAME2(v,x) && SAME2(w,z))
    {
      *(result) = -3*a4*u + 6*a4*w - 3*a4*y;
      *(result+1) = 9*a4*u - 7*a3*u*v - 2*a3*v2 - 18*a4*w + 5*a3*u*w + 10*a3*v*w + 9*a4*y - 7*a3*u*y + a3*v*y + 3*a3*w*y - 3*a3*y2;
      *(result+2) = -9*a4*u + 14*a3*u*v + a2*u2*v + 4*a3*v2 - 7*a2*u*v2 - 3*a2*v3 + 18*a4*w - 10*a3*u*w - 2*a2*u2*w - 20*a3*v*w + 8*a2*u*v*w + 6*a2*v2*w + 3*a2*u*w2 - 3*a2*v*w2 - 9*a4*y + 14*a3*u*y + a2*u2*y - 2*a3*v*y - 10*a2*u*v*y + 6*a2*v2*y - 6*a3*w*y + 6*a2*v*w*y + 6*a3*y2 - 3*a2*u*y2 - 3*a2*v*y2;
      *(result+3) = 3*a4*u - 7*a3*u*v - a2*u2*v - 2*a3*v2 + 7*a2*u*v2 + a*u2*v2 + 3*a2*v3 - 3*a*u*v3 - a*v4 - 6*a4*w + 5*a3*u*w + 2*a2*u2*w + 10*a3*v*w - 8*a2*u*v*w - a*u2*v*w - 6*a2*v2*w + a*u*v2*w + 3*a*v3*w - 3*a2*u*w2 + 3*a2*v*w2 + 3*a*u*v*w2 - 3*a*v2*w2 - a*u*w3 + a*v*w3 + 3*a4*y - 7*a3*u*y - a2*u2*y + a3*v*y + 10*a2*u*v*y - 6*a2*v2*y - a*u*v2*y + a*v3*y + 3*a3*w*y - a*u2*w*y - 6*a2*v*w*y + 2*a*u*v*w*y + 2*a*v2*w*y + 3*a*u*w2*y - 3*a*v*w2*y - 3*a3*y2 + 3*a2*u*y2 + a*u2*y2 + 3*a2*v*y2 - 5*a*u*v*y2 + a*v2*y2 - 3*a*u*w*y2 + 3*a*v*w*y2 + a*u*y3 - a*v*y3;
      *(result+4) = 0;
    }
  else if (SAME2(u,v))
    {
      *(result) = -6*a4*u + 9*a4*w + 3*a4*x - 3*a4*y - 3*a4*z;
      *(result+1) = 18*a4*u - 6*a3*u2 - 27*a4*w + 6*a3*u*w - 9*a4*x - 8*a3*u*x + 15*a3*w*x + 5*a3*x2 + 9*a4*y - 2*a3*u*y + 3*a3*w*y - 4*a3*x*y - 3*a3*y2 + 9*a4*z - 2*a3*u*z + 3*a3*w*z - 4*a3*x*z - 3*a3*z2;
      *(result+2) = -18*a4*u + 12*a3*u2 + 27*a4*w - 12*a3*u*w + 9*a4*x + 16*a3*u*x - 12*a2*u2*x - 30*a3*w*x + 12*a2*u*w*x - 10*a3*x2 + 2*a2*u*x2 + 3*a2*w*x2 + a2*x3 - 9*a4*y + 4*a3*u*y - 6*a3*w*y + 8*a3*x*y - 4*a2*u*x*y + 6*a2*w*x*y + a2*x2*y + 6*a3*y2 - 3*a2*u*y2 - 3*a2*x*y2 - 9*a4*z + 4*a3*u*z - 6*a3*w*z + 8*a3*x*z - 4*a2*u*x*z + 6*a2*w*x*z + a2*x2*z + 6*a2*u*y*z - 6*a2*x*y*z + 6*a3*z2 - 3*a2*u*z2 - 3*a2*x*z2;
      *(result+3) = 6*a4*u - 6*a3*u2 - 9*a4*w + 6*a3*u*w - 3*a4*x - 8*a3*u*x + 12*a2*u2*x + 15*a3*w*x - 12*a2*u*w*x + 5*a3*x2 - 2*a2*u*x2 - 6*a*u2*x2 - 3*a2*w*x2 + 6*a*u*w*x2 - a2*x3 + 4*a*u*x3 - 3*a*w*x3 - a*x4 + 3*a4*y - 2*a3*u*y + 3*a3*w*y - 4*a3*x*y + 4*a2*u*x*y - 6*a2*w*x*y - a2*x2*y - 2*a*u*x2*y + 3*a*w*x2*y + 2*a*x3*y - 3*a3*y2 + 3*a2*u*y2 - 2*a*u2*y2 + 2*a*u*w*y2 + 3*a2*x*y2 + a*u*x*y2 - 2*a*w*x*y2 - 2*a*x2*y2 - a*u*y3 + a*x*y3 + 3*a4*z - 2*a3*u*z + 3*a3*w*z - 4*a3*x*z + 4*a2*u*x*z - 6*a2*w*x*z - a2*x2*z - 2*a*u*x2*z + 3*a*w*x2*z + 2*a*x3*z - 6*a2*u*y*z + 4*a*u2*y*z - 4*a*u*w*y*z + 6*a2*x*y*z - 2*a*u*x*y*z + 4*a*w*x*y*z - 2*a*x2*y*z + a*u*y2*z - a*x*y2*z - 3*a3*z2 + 3*a2*u*z2 - 2*a*u2*z2 + 2*a*u*w*z2 + 3*a2*x*z2 + a*u*x*z2 - 2*a*w*x*z2 - 2*a*x2*z2 + a*u*y*z2 - a*x*y*z2 - a*u*z3 + a*x*z3;
      *(result+4) = 0;
    }
  else if (SAME2(y,z))
    {
      *(result) = -3*a4*u - 3*a4*v + 9*a4*w + 3*a4*x - 6*a4*y;
      *(result+1) = 9*a4*u - 3*a3*u2 + 9*a4*v - 3*a3*v2 - 27*a4*w + 3*a3*u*w + 3*a3*v*w - 9*a4*x - 4*a3*u*x - 4*a3*v*x + 15*a3*w*x + 5*a3*x2 + 18*a4*y - 2*a3*u*y - 2*a3*v*y + 6*a3*w*y - 8*a3*x*y - 6*a3*y2;
      *(result+2) = -9*a4*u + 6*a3*u2 - 9*a4*v + 6*a3*v2 + 27*a4*w - 6*a3*u*w - 6*a3*v*w + 9*a4*x + 8*a3*u*x - 3*a2*u2*x + 8*a3*v*x - 6*a2*u*v*x - 3*a2*v2*x - 30*a3*w*x + 6*a2*u*w*x + 6*a2*v*w*x - 10*a3*x2 + a2*u*x2 + a2*v*x2 + 3*a2*w*x2 + a2*x3 - 18*a4*y + 4*a3*u*y - 3*a2*u2*y + 4*a3*v*y + 6*a2*u*v*y - 3*a2*v2*y - 12*a3*w*y + 16*a3*x*y - 4*a2*u*x*y - 4*a2*v*x*y + 12*a2*w*x*y + 2*a2*x2*y + 12*a3*y2 - 12*a2*x*y2;
      *(result+3) = 3*a4*u - 3*a3*u2 + 3*a4*v - 3*a3*v2 - 9*a4*w + 3*a3*u*w + 3*a3*v*w - 3*a4*x - 4*a3*u*x + 3*a2*u2*x + a*u3*x - 4*a3*v*x + 6*a2*u*v*x - a*u2*v*x + 3*a2*v2*x - a*u*v2*x + a*v3*x + 15*a3*w*x - 6*a2*u*w*x - 2*a*u2*w*x - 6*a2*v*w*x + 4*a*u*v*w*x - 2*a*v2*w*x + 5*a3*x2 - a2*u*x2 - 2*a*u2*x2 - a2*v*x2 - 2*a*u*v*x2 - 2*a*v2*x2 - 3*a2*w*x2 + 3*a*u*w*x2 + 3*a*v*w*x2 - a2*x3 + 2*a*u*x3 + 2*a*v*x3 - 3*a*w*x3 - a*x4 + 6*a4*y - 2*a3*u*y + 3*a2*u2*y - a*u3*y - 2*a3*v*y - 6*a2*u*v*y + a*u2*v*y + 3*a2*v2*y + a*u*v2*y - a*v3*y + 6*a3*w*y + 2*a*u2*w*y - 4*a*u*v*w*y + 2*a*v2*w*y - 8*a3*x*y + 4*a2*u*x*y + a*u2*x*y + 4*a2*v*x*y - 2*a*u*v*x*y + a*v2*x*y - 12*a2*w*x*y - 2*a2*x2*y - 2*a*u*x2*y - 2*a*v*x2*y + 6*a*w*x2*y + 4*a*x3*y - 6*a3*y2 - 2*a*u2*y2 + 4*a*u*v*y2 - 2*a*v2*y2 + 12*a2*x*y2 - 6*a*x2*y2;
      *(result+4) = 0;
    }
  else
    {
      *(result) = 3*a5*u + 3*a5*v - 9*a5*w - 3*a5*x + 3*a5*y + 3*a5*z;
      *(result+1) = -12*a5*u + 3*a4*u2 - 12*a5*v + 3*a4*v2 + 36*a5*w - 3*a4*u*w - 3*a4*v*w + 12*a5*x + 7*a4*u*x + 7*a4*v*x - 24*a4*w*x - 8*a4*x2 - 12*a5*y + 10*a4*u*y - 8*a4*v*y - 3*a4*w*y + 7*a4*x*y + 3*a4*y2 - 12*a5*z - 8*a4*u*z + 10*a4*v*z - 3*a4*w*z + 7*a4*x*z + 3*a4*z2;
      *(result+2) = 18*a5*u - 9*a4*u2 + 18*a5*v - 9*a4*v2 - 54*a5*w + 9*a4*u*w + 9*a4*v*w - 18*a5*x - 21*a4*u*x + 6*a3*u2*x - 21*a4*v*x + 6*a3*u*v*x + 6*a3*v2*x + 72*a4*w*x - 9*a3*u*w*x - 9*a3*v*w*x + 24*a4*x2 + 3*a3*u*x2 + 3*a3*v*x2 - 18*a3*w*x2 - 6*a3*x3 + 18*a5*y - 30*a4*u*y + 6*a3*u2*y + 24*a4*v*y - 3*a3*u*v*y - 3*a3*v2*y + 9*a4*w*y - 21*a4*x*y + 12*a3*u*x*y - 6*a3*v*x*y - 9*a3*w*x*y + 3*a3*x2*y - 9*a4*y2 + 6*a3*u*y2 - 3*a3*v*y2 + 6*a3*x*y2 + 18*a5*z + 24*a4*u*z - 3*a3*u2*z - 30*a4*v*z - 3*a3*u*v*z + 6*a3*v2*z + 9*a4*w*z - 21*a4*x*z - 6*a3*u*x*z + 12*a3*v*x*z - 9*a3*w*x*z + 3*a3*x2*z - 3*a3*u*y*z - 3*a3*v*y*z + 6*a3*x*y*z - 9*a4*z2 - 3*a3*u*z2 + 6*a3*v*z2 + 6*a3*x*z2;
      *(result+3) = -12*a5*u + 9*a4*u2 - 12*a5*v + 9*a4*v2 + 36*a5*w - 9*a4*u*w - 9*a4*v*w + 12*a5*x + 21*a4*u*x - 12*a3*u2*x - a2*u3*x + 21*a4*v*x - 12*a3*u*v*x + a2*u2*v*x - 12*a3*v2*x + a2*u*v2*x - a2*v3*x - 72*a4*w*x + 18*a3*u*w*x + 2*a2*u2*w*x + 18*a3*v*w*x - 4*a2*u*v*w*x + 2*a2*v2*w*x - 24*a4*x2 - 6*a3*u*x2 + 5*a2*u2*x2 - 6*a3*v*x2 + 8*a2*u*v*x2 + 5*a2*v2*x2 + 36*a3*w*x2 - 9*a2*u*w*x2 - 9*a2*v*w*x2 + 12*a3*x3 - 3*a2*u*x3 - 3*a2*v*x3 - 12*a5*y + 30*a4*u*y - 12*a3*u2*y - a2*u3*y - 24*a4*v*y + 6*a3*u*v*y + 4*a2*u2*v*y + 6*a3*v2*y - 5*a2*u*v2*y + 2*a2*v3*y - 9*a4*w*y - a2*u2*w*y + 2*a2*u*v*w*y - a2*v2*w*y + 21*a4*x*y - 24*a3*u*x*y + 6*a2*u2*x*y + 12*a3*v*x*y - 2*a2*u*v*x*y - 4*a2*v2*x*y + 18*a3*w*x*y - 6*a3*x2*y + 2*a2*u*x2*y + 4*a2*v*x2*y - 9*a2*w*x2*y - 3*a2*x3*y + 9*a4*y2 - 12*a3*u*y2 + 2*a2*u2*y2 + 6*a3*v*y2 + 2*a2*u*v*y2 - 2*a2*v2*y2 - a2*u*w*y2 - a2*v*w*y2 - 12*a3*x*y2 + 6*a2*u*x*y2 - 4*a2*v*x*y2 + 2*a2*w*x*y2 + 5*a2*x2*y2 - a2*u*y3 + 2*a2*v*y3 - a2*x*y3 - 12*a5*z - 24*a4*u*z + 6*a3*u2*z + 2*a2*u3*z + 30*a4*v*z + 6*a3*u*v*z - 5*a2*u2*v*z - 12*a3*v2*z + 4*a2*u*v2*z - a2*v3*z - 9*a4*w*z - a2*u2*w*z + 2*a2*u*v*w*z - a2*v2*w*z + 21*a4*x*z + 12*a3*u*x*z - 4*a2*u2*x*z - 24*a3*v*x*z - 2*a2*u*v*x*z + 6*a2*v2*x*z + 18*a3*w*x*z - 6*a3*x2*z + 4*a2*u*x2*z + 2*a2*v*x2*z - 9*a2*w*x2*z - 3*a2*x3*z + 6*a3*u*y*z + 2*a2*u2*y*z + 6*a3*v*y*z - 8*a2*u*v*y*z + 2*a2*v2*y*z + 2*a2*u*w*y*z + 2*a2*v*w*y*z - 12*a3*x*y*z - 2*a2*u*x*y*z - 2*a2*v*x*y*z - 4*a2*w*x*y*z + 8*a2*x2*y*z + 4*a2*u*y2*z - 5*a2*v*y2*z + a2*x*y2*z + 9*a4*z2 + 6*a3*u*z2 - 2*a2*u2*z2 - 12*a3*v*z2 + 2*a2*u*v*z2 + 2*a2*v2*z2 - a2*u*w*z2 - a2*v*w*z2 - 12*a3*x*z2 - 4*a2*u*x*z2 + 6*a2*v*x*z2 + 2*a2*w*x*z2 + 5*a2*x2*z2 - 5*a2*u*y*z2 + 4*a2*v*y*z2 + a2*x*y*z2 + 2*a2*u*z3 - a2*v*z3 - a2*x*z3;
      *(result+4) = 3*a5*u - 3*a4*u2 + 3*a5*v - 3*a4*v2 - 9*a5*w + 3*a4*u*w + 3*a4*v*w - 3*a5*x - 7*a4*u*x + 6*a3*u2*x + a2*u3*x - 7*a4*v*x + 6*a3*u*v*x - a2*u2*v*x + 6*a3*v2*x - a2*u*v2*x + a2*v3*x + 24*a4*w*x - 9*a3*u*w*x - 2*a2*u2*w*x - 9*a3*v*w*x + 4*a2*u*v*w*x - 2*a2*v2*w*x + 8*a4*x2 + 3*a3*u*x2 - 5*a2*u2*x2 - a*u3*x2 + 3*a3*v*x2 - 8*a2*u*v*x2 + a*u2*v*x2 - 5*a2*v2*x2 + a*u*v2*x2 - a*v3*x2 - 18*a3*w*x2 + 9*a2*u*w*x2 + 2*a*u2*w*x2 + 9*a2*v*w*x2 - 4*a*u*v*w*x2 + 2*a*v2*w*x2 - 6*a3*x3 + 3*a2*u*x3 + 2*a*u2*x3 + 3*a2*v*x3 + 2*a*u*v*x3 + 2*a*v2*x3 - 3*a*u*w*x3 - 3*a*v*w*x3 - 2*a*u*x4 - 2*a*v*x4 + 3*a*w*x4 + a*x5 + 3*a5*y - 10*a4*u*y + 6*a3*u2*y + a2*u3*y + 8*a4*v*y - 3*a3*u*v*y - 4*a2*u2*v*y - 3*a3*v2*y + 5*a2*u*v2*y - 2*a2*v3*y + 3*a4*w*y + a2*u2*w*y - 2*a2*u*v*w*y + a2*v2*w*y - 7*a4*x*y + 12*a3*u*x*y - 6*a2*u2*x*y - 6*a3*v*x*y + 2*a2*u*v*x*y + a*u2*v*x*y + 4*a2*v2*x*y - 2*a*u*v2*x*y + a*v3*x*y - 9*a3*w*x*y - a*u2*w*x*y + 2*a*u*v*w*x*y - a*v2*w*x*y + 3*a3*x2*y - 2*a2*u*x2*y - 4*a2*v*x2*y + a*u*v*x2*y - a*v2*x2*y + 9*a2*w*x2*y + 3*a2*x3*y + 2*a*v*x3*y - 3*a*w*x3*y - 2*a*x4*y - 3*a4*y2 + 6*a3*u*y2 - 2*a2*u2*y2 - a*u3*y2 - 3*a3*v*y2 - 2*a2*u*v*y2 + 2*a*u2*v*y2 + 2*a2*v2*y2 - a*u*v2*y2 + a2*u*w*y2 + a*u2*w*y2 + a2*v*w*y2 - 2*a*u*v*w*y2 + a*v2*w*y2 + 6*a3*x*y2 - 6*a2*u*x*y2 + 3*a*u2*x*y2 + 4*a2*v*x*y2 - a*v2*x*y2 - 2*a2*w*x*y2 - a*u*w*x*y2 - a*v*w*x*y2 - 5*a2*x2*y2 - a*v*x2*y2 + 2*a*w*x2*y2 + 2*a*x3*y2 + a2*u*y3 - a*u2*y3 - 2*a2*v*y3 + a*u*v*y3 + a2*x*y3 + a*v*x*y3 - a*x2*y3 + 3*a5*z + 8*a4*u*z - 3*a3*u2*z - 2*a2*u3*z - 10*a4*v*z - 3*a3*u*v*z + 5*a2*u2*v*z + 6*a3*v2*z - 4*a2*u*v2*z + a2*v3*z + 3*a4*w*z + a2*u2*w*z - 2*a2*u*v*w*z + a2*v2*w*z - 7*a4*x*z - 6*a3*u*x*z + 4*a2*u2*x*z + a*u3*x*z + 12*a3*v*x*z + 2*a2*u*v*x*z - 2*a*u2*v*x*z - 6*a2*v2*x*z + a*u*v2*x*z - 9*a3*w*x*z - a*u2*w*x*z + 2*a*u*v*w*x*z - a*v2*w*x*z + 3*a3*x2*z - 4*a2*u*x2*z - a*u2*x2*z - 2*a2*v*x2*z + a*u*v*x2*z + 9*a2*w*x2*z + 3*a2*x3*z + 2*a*u*x3*z - 3*a*w*x3*z - 2*a*x4*z - 3*a3*u*y*z - 2*a2*u2*y*z + a*u3*y*z - 3*a3*v*y*z + 8*a2*u*v*y*z - a*u2*v*y*z - 2*a2*v2*y*z - a*u*v2*y*z + a*v3*y*z - 2*a2*u*w*y*z - 2*a*u2*w*y*z - 2*a2*v*w*y*z + 4*a*u*v*w*y*z - 2*a*v2*w*y*z + 6*a3*x*y*z + 2*a2*u*x*y*z + 2*a2*v*x*y*z - 4*a*u*v*x*y*z + 4*a2*w*x*y*z + 2*a*u*w*x*y*z + 2*a*v*w*x*y*z - 8*a2*x2*y*z + a*u*x2*y*z + a*v*x2*y*z - 4*a*w*x2*y*z + 2*a*x3*y*z - 4*a2*u*y2*z + 2*a*u2*y2*z + 5*a2*v*y2*z - a*u*v*y2*z - a*v2*y2*z - a2*x*y2*z + a*u*x*y2*z - 2*a*v*x*y2*z + a*x2*y2*z - 3*a4*z2 - 3*a3*u*z2 + 2*a2*u2*z2 + 6*a3*v*z2 - 2*a2*u*v*z2 - a*u2*v*z2 - 2*a2*v2*z2 + 2*a*u*v2*z2 - a*v3*z2 + a2*u*w*z2 + a*u2*w*z2 + a2*v*w*z2 - 2*a*u*v*w*z2 + a*v2*w*z2 + 6*a3*x*z2 + 4*a2*u*x*z2 - a*u2*x*z2 - 6*a2*v*x*z2 + 3*a*v2*x*z2 - 2*a2*w*x*z2 - a*u*w*x*z2 - a*v*w*x*z2 - 5*a2*x2*z2 - a*u*x2*z2 + 2*a*w*x2*z2 + 2*a*x3*z2 + 5*a2*u*y*z2 - a*u2*y*z2 - 4*a2*v*y*z2 - a*u*v*y*z2 + 2*a*v2*y*z2 - a2*x*y*z2 - 2*a*u*x*y*z2 + a*v*x*y*z2 + a*x2*y*z2 - 2*a2*u*z3 + a2*v*z3 + a*u*v*z3 - a*v2*z3 + a2*x*z3 + a*u*x*z3 - a*x2*z3;
    }

  return;
}

/* GAAK */

/* **************************************************************** */
/* **************************************************************** */

void TVIL_SetParamsH (TVIL_HTYPE *foo,
		      TVIL_REAL   u, 
		      TVIL_REAL   v, 
		      TVIL_REAL   w, 
		      TVIL_REAL   x,
		      TVIL_REAL   y,
		      TVIL_REAL   z)
{
  foo->arg[0] = u;
  foo->arg[1] = v;
  foo->arg[2] = w;
  foo->arg[3] = x;
  foo->arg[4] = y;
  foo->arg[5] = z;

  return;
}

/* **************************************************************** */

void TVIL_ConstructH (TVIL_HTYPE *foo)
/* , */
/* 		      TVIL_REAL   u,  */
/* 		      TVIL_REAL   v,  */
/* 		      TVIL_REAL   w,  */
/* 		      TVIL_REAL   x, */
/* 		      TVIL_REAL   y, */
/* 		      TVIL_REAL   z, */
/* 		      TVIL_REAL   qq) */
{
  TVIL_REAL u, v, w, x, y, z;

  u = foo->arg[0];
  v = foo->arg[1];
  w = foo->arg[2];
  x = foo->arg[3];
  y = foo->arg[4];
  z = foo->arg[5];

  /* printf("Original roots:\n"); */
  /* TVIL_cHd1Roots_orig (foo, foo->cHd1roots); */
  /* printf("New roots:\n"); */

  TVIL_cHd1Roots (foo, foo->cHd1roots);

  /* for (i=0; i<3; i++) */
  /*   printf("Root %d is %Lf\n", i+1, foo->cHd1roots[i]); */

  TVIL_cHGnum (u, v, w, x, y, z, &(foo->cHGnum[0][0]));
  TVIL_cHGnum (u, z, x, w, y, v, &(foo->cHGnum[1][0]));
  TVIL_cHGnum (u, w, v, z, y, x, &(foo->cHGnum[2][0]));
  TVIL_cHGnum (u, x, z, v, y, w, &(foo->cHGnum[3][0]));
  TVIL_cHGnum (w, v, u, y, x, z, &(foo->cHGnum[4][0]));
  TVIL_cHGnum (x, v, y, u, w, z, &(foo->cHGnum[5][0]));

  TVIL_cHGden (u, v, w, x, y, z, &(foo->cHGden[0][0]));
  TVIL_cHGden (u, z, x, w, y, v, &(foo->cHGden[1][0]));
  TVIL_cHGden (u, w, v, z, y, x, &(foo->cHGden[2][0]));
  TVIL_cHGden (u, x, z, v, y, w, &(foo->cHGden[3][0]));
  TVIL_cHGden (w, v, u, y, x, z, &(foo->cHGden[4][0]));
  TVIL_cHGden (x, v, y, u, w, z, &(foo->cHGden[5][0]));

  TVIL_cHnum (u, v, w, x, y, z, &(foo->cHnum[0]));

  TVIL_cHden (u, v, w, x, y, z, &(foo->cHden[0]));

  return;
}

/* **************************************************************** */
/* **************************************************************** */

void TVIL_cHd1Roots (TVIL_HTYPE *foo, TVIL_REAL *result)
{
  TVIL_COMPLEX r1, r2, r3;
  TVIL_REAL u, v, w, x, y, z;
  TVIL_REAL A, B, C, D;
  TVIL_REAL A2;
  TVIL_REAL B2, B3;

  u  = foo->arg[0];
  v  = foo->arg[1];
  w  = foo->arg[2];
  x  = foo->arg[3];
  y  = foo->arg[4];
  z  = foo->arg[5];

  u2 = u*u;
  v2 = v*v;
  w2 = w*w;
  x2 = x*x;
  y2 = y*y;
  z2 = z*z;

  D = -2*a3;
  C = 6*a3 - a2*u - a2*v - a2*w - a2*x - a2*y - a2*z;
  B = -6*a3 + 2*a2*u + a*u2 + 2*a2*v - a*u*v + a*v2 + 
    2*a2*w - a*u*w - a*v*w + a*w2 + 2*a2*x - a*u*x - a*v*x + 
    a*x2 + 2*a2*y - a*v*y - a*w*y - a*x*y + a*y2 + 2*a2*z - 
    a*u*z - a*w*z - a*x*z - a*y*z + a*z2;
  A = 2*a3 - a2*u - a*u2 - a2*v + a*u*v - a*v2 - a2*w + 
    a*u*w + a*v*w - a*w2 - a2*x + a*u*x + a*v*x + u*v*x - 
    u*w*x - v*w*x + w2*x - a*x2 + w*x2 - a2*y + u2*y + 
    a*v*y - u*v*y + a*w*y - u*w*y + v*w*y + a*x*y - u*x*y - 
    w*x*y - a*y2 + u*y2 - a2*z + a*u*z - u*v*z + v2*z + 
    a*w*z + u*w*z - v*w*z + a*x*z - v*x*z - w*x*z + a*y*z - 
    u*y*z - v*y*z + x*y*z - a*z2 + v*z2;

  B2 = B*B;
  B3 = B2*B;
  A2 = A*A;

  r1 = -B/(3.*A) - (CUBERT2*(-B2 + 3*A*C))/
    (3.*A*TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D + 
	   TVIL_CSQRT(4*TVIL_CPOW(-B2 + 3*A*C,3) + 
	TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D,2)), 1.L/3.L)) + 
    TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D + 
     TVIL_CSQRT(4*TVIL_CPOW(-B2 + 3*A*C,3) + 
       TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D,2)), 1.L/3.L)/
    (3.*CUBERT2*A);

  r2 = -B/(3.*A) + ((1 + I*SQRT3)*(-B2 + 3*A*C))/
    (3.*CUBERT2*CUBERT2*A*
     TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D + 
      TVIL_CSQRT(4*TVIL_CPOW(-B2 + 3*A*C,3) + 
	   TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D,2)), 1.L/3.L)) - 
    ((1 - I*SQRT3)*TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D + 
      TVIL_CSQRT(4*TVIL_CPOW(-B2 + 3*A*C,3) + 
          TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D,2)), 1.L/3.L))/
    (6.*CUBERT2*A);

  r3 = -B/(3.*A) + ((1 - I*SQRT3)*(-B2 + 3*A*C))/
    (3.*CUBERT2*CUBERT2*A*
     TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D + 
      TVIL_CSQRT(4*TVIL_CPOW(-B2 + 3*A*C,3) + 
	  TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D,2)), 1.L/3.L)) - 
      ((1 + I*SQRT3)*TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D + 
          TVIL_CSQRT(4*TVIL_CPOW(-B2 + 3*A*C,3) + 
        TVIL_CPOW(-2*B3 + 9*A*B*C - 27*A2*D,2)), 1.L/3.L))/
      (6.*CUBERT2*A);

  /* printf("r1 = "); TVIL_cprintfM (r1); printf("\n"); */
  /* printf("r2 = "); TVIL_cprintfM (r2); printf("\n"); */
  /* printf("r3 = "); TVIL_cprintfM (r3); printf("\n"); */

  /* exit(0); */

  *(result)   = TVIL_CREAL(r1);
  *(result+1) = TVIL_CREAL(r2);
  *(result+2) = TVIL_CREAL(r3);

  return;
}
