/* Analytic results for G-type functions, including value at small,
   non-zero t. */

/* Need to check data types on everything here... */

#include "internal.h"

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00000 (void) { 
  return 0.0L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G0000x (TVIL_REAL x, TVIL_REAL qq)
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return (-15.L*x)/2.L - (PI2*x)/2.L + (11.L*x*lnbarx)/2.L + (PI2*x*lnbarx)/6.L -
    (3.L*x*lnbarx2)/2.L + (x*lnbarx2*lnbarx)/6.L + (2.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G000xx (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return -15.L*x + 11.L*x*lnbarx - 3.L*x*lnbarx2 + (x*lnbarx2*lnbarx)/3.L -
    (8.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00x0x (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return -15.L*x - (PI2*x)/3.L + 11.L*x*lnbarx + (PI2*x*lnbarx)/3.L - 
    3.L*x*lnbarx2 + (x*lnbarx2*lnbarx)/3.L + (16.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00xxx (TVIL_REAL x, TVIL_REAL qq)
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return (-45.L*x)/2.L + (33.L*x*lnbarx)/2.L + (PI2*x*lnbarx)/6.L - 
    (9.L*x*lnbarx2)/2.L + (x*lnbarx2*lnbarx)/2.L + 9.L*SQRT3*x*LS2;
}

/* ****************************************************************** */ 

TVIL_COMPLEX TVIL_G0xxxx (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;} 
  lnbarx2 = lnbarx*lnbarx;

  return -30.L*x + 22.L*x*lnbarx - 6.L*x*lnbarx2 + 
    (2.L*x*lnbarx2*lnbarx)/3.L + (56.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */
 
TVIL_COMPLEX TVIL_Gx0000 (TVIL_REAL x, TVIL_REAL qq) 
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-7.L*x)/3.L - (2.L*PI2*x)/3.L + 4.L*x*lnbarx + (PI2*x*lnbarx)/3.L - 
    2.L*x*lnbarx2 + (x*lnbarx2*lnbarx)/3.L - (2.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */
 
TVIL_COMPLEX TVIL_Gx000x (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-59.L*x)/6.L - (PI2*x)/2.L + (19.L*x*lnbarx)/2.L + 
    (PI2*x*lnbarx)/6.L - (7.L*x*lnbarx2)/2.L + (x*lnbarx2*lnbarx)/2.L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx00xx (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-52.L*x)/3.L - (PI2*x)/3.L - (2.L*PI*PI2*x)/(9.L*SQRT3) + 
     15.L*x*lnbarx + (PI2*x*lnbarx)/6.L - 5.L*x*lnbarx2 + 
     (2.L*x*lnbarx2*lnbarx)/3.L + 6.L*SQRT3*x*LS2 - 
     3.L*SQRT3*x*lnbarx*LS2 - (4.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */
 
TVIL_COMPLEX TVIL_Gx0x0x (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-52.L*x)/3.L + 15.L*x*lnbarx - 5.L*x*lnbarx2 + 
    (2.L*x*lnbarx2*lnbarx)/3.L + (8.L*x*Zeta3)/3.L;
}

/* ****************************************************************** */
 
TVIL_COMPLEX TVIL_Gx0xxx (TVIL_REAL x, TVIL_REAL qq) 
{ 
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-149*x)/6 + (41*x*lnbarx)/2 - (13*x*lnbarx2)/2 + 
    (5*x*lnbarx2*lnbarx)/6 + 9*SQRT3*x*LS2 - 3*SQRT3*x*lnbarx*LS2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gxxxxx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  TVIL_COMPLEX lnbarx2;
  if(x < 0) {lnbarx = lnbarx - I * PI;}
  lnbarx2 = lnbarx*lnbarx;

  return (-97.*x)/3 + 26*x*lnbarx - 8*x*lnbarx2 + x*lnbarx2*lnbarx + 
    12*SQRT3*x*LS2 - 6*SQRT3*x*lnbarx*LS2 + 6*x*Zeta3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G000xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX result;

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = 2*y*TVIL_Trilog(1 - x/y) + 2*x*TVIL_Trilog(1 - y/x) +
    (3*(x - y) - x*lnbarx + y*lnbary)*TVIL_Dilog(1 - x/y) + 
    (-15*(x + y))/2 + (11*x*lnbarx)/2 - (x*lnbarx*lnbarx2)/3. + 
    (11.*y*lnbary)/2. - 3*x*lnbarx*lnbary + x*lnbarx2*lnbary + 
    (3*(x - y)*lnbary2)/2. - x*lnbarx*lnbary2/2 + y*lnbary*lnbary2/6. + 
    - (4*(x + y)*Zeta3)/3.;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00x0y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{ 
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX result;

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = -2*(x + y)*(TVIL_Trilog(1 - x/y) + TVIL_Trilog(1 - y/x)) +
  + (2*(x - y) + (x + y)*TVIL_CLOG(x/y))*TVIL_Dilog(1 - x/y) +  
  -((45 + PI2)*(x + y))/6 + ((33*x + PI2*y)*lnbarx)/6 - (x*lnbarx2)/2 + 
  ((x + y)*lnbarx*lnbarx2)/3 + ((PI2*x + 33*y)*lnbary)/6 - 2*x*lnbarx*lnbary + 
  ((-x - 2*y)*lnbarx2*lnbary)/2 + ((2*x - 3*y)*lnbary2)/2 + 
  ((x + 2*y)*lnbarx*lnbary2)/2 + ((-x - y)*lnbary*lnbary2)/6 + 
  (8*(x + y)*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx000y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX result;

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = (y-x)*(TVIL_Trilog(1-x/y) + TVIL_Trilog(1-y/x) + (lnbary - 2)*TVIL_Dilog(1-x/y) +
  (-1./6.)*lnbarx*lnbarx2 + (1./3.)*lnbary*lnbary2 - 0.5L*lnbarx*lnbary2 - (PI2/6)*lnbarx +
    - Zeta3/3.) + (-14*x - 2*PI2*x - 45*y - PI2*y)/6 + 4*x*lnbarx - x*lnbarx2 + 
    + ((33 + PI2)*y*lnbary)/6. - 2.*x*lnbarx*lnbary + (y*lnbarx2*lnbary)/2. + 
    ((2*x - 3*y)*lnbary2)/2;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx00yy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq) 
{
  TVIL_REAL lnxoy, lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX k, lnk, sqrt, result;

  k = (1 - TVIL_CSQRT(1-4*y/x))/(1 + TVIL_CSQRT(1-4*y/x));

  /* This shouldn't be necessary, but just in case... */
  if (TVIL_CIMAG(k) > 0) k = TVIL_CONJ(k);

  lnk = TVIL_CLOG (k);
  sqrt = x * (1.L - k)/(1.L + k);  

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;
  lnxoy = lnbarx - lnbary;

  result = 
    sqrt*(2*TVIL_Trilog(-k) + 4*TVIL_Trilog(k/(1+k))
   	 + TVIL_Dilog(-k)*(2*lnbary - 4)
    + (1./12.)*lnk*lnk*lnk + (lnbarx/4 + lnbary/4 - 1)*lnk*lnk
   - (PI2/6 + (1./4.)*lnxoy*lnxoy)*lnk - (1./12.)*lnxoy*lnxoy*lnxoy 
	   + (PI2/6)*(lnbarx - 2) - 2*Zeta3)
    + (y/3 - x/6)*lnbary2*lnbary + (x/2)*lnbarx2*lnbary
    + (x - 3*y)*lnbary2 - 2*x*lnbarx*lnbary
    - x*lnbarx2 + ((PI2/6) * x + 11*y)*lnbary + 4*x*lnbarx 
    + (4*(x-2*y)/3)*Zeta3 - (7 + PI2)*x/3 - 15*y;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0x0y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq) 
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;

  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = -2*y*TVIL_Trilog(1-x/y) -2*y*TVIL_Trilog(1-y/x) + 
    (3*x-3*y + (2*y-x)*lnbarx - y*lnbary)*TVIL_Dilog(1-x/y) +
    (-59*x - 45*y)/6 + (19*x*lnbarx)/2 - 2*x*lnbarx2 + (y*lnbarx*lnbarx2)/3 + 
    (11*y*lnbary)/2 - 3*x*lnbarx*lnbary + (x - y)*lnbarx2*lnbary + 
    (3.*(x - y)*lnbary2)/2 + ((-x + 2*y)*lnbarx*lnbary2)/2 - (y*lnbary*lnbary2)/6. + 
    (8.*y*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0y0y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq) 
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbary, lnbary2;

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = -2.L * (x-y) * (x-y) * TVIL_Trilog(1-x/y)/x +
           2.L * (x-y) * (2 - lnbary) * TVIL_Dilog(1-x/y) +
           ((y - 2.L * x)/3.L) * lnbary * lnbary2 +
           (x * lnbarx + 2.L * x - 3.L * y) * lnbary2 +
           4.L * x * lnbarx * (1.L - lnbary) + 11.L * y * lnbary +
           -7.L * x/3.L - 15.L * y + 
           2.L * (1.L + y/x) * (3.L * y - x) * Zeta3/3.L;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G0xxyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL lnxoy, lnyox, lnbarx, lnbarx2, lnbary, lnbary2;
  TVIL_COMPLEX result;

  lnxoy = TVIL_LOG (x/y);
  lnyox = -lnxoy;
  lnbarx = TVIL_LOG (x/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = TVIL_POW(TVIL_SQRT(x) - TVIL_SQRT(y), 2) *
    (2*TVIL_Trilog(1-x/y) + 2*TVIL_Trilog(1-y/x) + 
     2*lnyox*TVIL_Dilog(1-x/y) - (1./3.)*lnbarx*lnbarx2) + 
    TVIL_SQRT(x)*TVIL_SQRT(y)*(-32*TVIL_Trilog(-TVIL_CSQRT(x/y)) + 
			       16*lnxoy*TVIL_Dilog(-TVIL_SQRT(x/y)) +
			       + 4*lnxoy*lnxoy*TVIL_LOG(1 + TVIL_SQRT(x/y)) + 
			       2*lnbarx*lnbary*lnyox - (2./3.)*lnbary*lnbary2 + 
			       4*Zeta3) +
    -15*(x + y) + 11*x*lnbarx - 3*x*lnbarx2 + 11*y*lnbary + 
    (2*x + y)*lnbarx2*lnbary - 3*y*lnbary2 + (-2*x - y)*lnbarx*lnbary2 + 
    (2*(x + y)*lnbary*lnbary2)/3 - (14*(x + y)*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G0xyxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX Ax, Ay, result;
  if (SAME2(x,y)) return TVIL_G0xxxx(x,qq);
  if (SAME2(0,x)) return TVIL_G00x0x(y,qq);
  if (SAME2(0,y)) return TVIL_G00x0x(x,qq);

  Ax = TVIL_A (x, qq);
  Ay = TVIL_A (y, qq);

  result = 2.L * (y * TVIL_FBARxxyy(y,x,qq) - x * TVIL_FBARxxyy(x,y,qq)
           + (x + Ax) * TVIL_I2(x,y,y,qq) - (y + Ay) * TVIL_I2(x,x,y,qq)
           + (Ay - Ax) * TVIL_I2(0,x,y,qq) 
           + (2.L/3.L) * (y*y - x*x) + 0.25L * (x * Ax - y * Ay))/(x-y);
 
  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00yxx (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx, lnbary, result;
  if (SAME2(x,y)) return TVIL_G00xxx(x,qq);
  if (SAME2(0,x)) return TVIL_G0000x(y,qq);
  if (SAME2(0,y)) return TVIL_G000xx(x,qq);

  lnbarx = TVIL_Ap (x, qq);
  lnbary = TVIL_Ap (y, qq);

  result = (-1.L - 0.5L * y/x) * TVIL_FBARx0yy(y,x,qq) +
           (2.L - 0.5L * y/x) * TVIL_I2(x,x,y,qq) +
           (2.L * x + 1.5L * y + Zeta2 * y) * lnbarx +
           y * (-1.25L - 0.375L * y/x) * lnbary +
           0.5L * y * lnbarx * lnbary * (lnbary - lnbarx) + 
           -14.L*x/3.L - 11.L * y/12.L + 17.L * y * y/(24.L * x);

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_G00xxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx, lnbary, result;
  if (SAME2(x,y)) return TVIL_G00xxx(x,qq);
  if (SAME2(0,x)) return TVIL_G0000x(y,qq);
  if (SAME2(0,y)) return TVIL_G00x0x(x,qq);

  lnbarx = TVIL_Ap (x, qq);
  lnbary = TVIL_Ap (y, qq);

  result = ( (-13.L/3.L - Zeta2 + (5.L + Zeta2) * lnbarx
             - 2.5L * lnbarx * lnbarx + 0.5 * lnbarx * lnbarx * lnbarx)*x*x 
           + (41.L/12.L + Zeta2 - (9.L/4.L) * lnbarx 
             + 0.5L * lnbarx * lnbarx + (2.5L - Zeta2) * lnbary
             -2.L * lnbarx * lnbary + 0.5L * lnbarx * lnbarx * lnbary)*x*y 
           + (11.L/12.L - 0.25L * lnbary) * y * y 
           + (y - 2.L*x) * TVIL_FBARx0xy (x, y, qq) 
           + y * TVIL_FBARx0yy (y, x, qq) +  
           + TVIL_I2(0, x, y, qq)*(x - y + x*lnbarx) )/(x-y);

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0xxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_Ap(x,qq);

  return -13.L*x/4.L - 7.L*y/3.L - TVIL_Fy0xy (y, x, qq) + 
           (2.L - lnbarx) * TVIL_I2 (x, x, y, qq) +
           1.25L * x * lnbarx + TVIL_A(y,qq) + y;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0xyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_Ap(x,qq);
  TVIL_COMPLEX lnbary = TVIL_Ap(y,qq);

  return (-TVIL_FBARx0yy(x,y,qq) + (2.L - lnbarx) * TVIL_I2(x,y,y,qq) 
          + x * (0.25L * lnbarx - 11.L/12.L) 
          + y * (-14.L/3.L - 5.L * lnbarx + (2.L  
            + 4.L * lnbarx - lnbarx * lnbary) * lnbary));
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gyxxxx (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_Ap(x,qq);
  TVIL_COMPLEX lnbary = TVIL_Ap(y,qq);
  TVIL_COMPLEX lnbarx2 = lnbarx * lnbarx;

  return ((26.L*x - 8.L*y)/3.L + 17.L*y*y/(12.L*x) + 
    (4.L - y/x)*TVIL_FBARx0yy(y,x,qq) +
    TVIL_I2(x, x, y, qq)*(8.L - y/x - 2.L*lnbarx) 
    - (16.L*x + 2*y)*lnbarx + 6.L*x*lnbarx2 - y*lnbary 
    - 0.75L*y*y*lnbary/x + 4.L*y*lnbarx*lnbary - y*lnbarx2*lnbary +
    (8.L*x - 2.L*y)*Zeta3);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gxxyxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_Ap(x,qq);
  TVIL_COMPLEX lnbary = TVIL_Ap(y,qq);
  TVIL_COMPLEX lnbarx2 = lnbarx * lnbarx;
  TVIL_COMPLEX lnbary2 = lnbary * lnbary;
  TVIL_COMPLEX result;

  result = (y/x - 1.L) *  TVIL_FBARxxyy (x,y,qq) 
    + y * (y - 4.L*x) * TVIL_FBARx0yy (y,x,qq)/(2.L * x * x) 
    + (1.L - y/x) *  TVIL_I2(x, y, y, qq) * lnbarx - x * lnbarx2 * lnbarx 
    + (2.L * x - y) * lnbarx2 * (6.L*x - y * lnbary)/(2.L*x) 
    - (lnbarx * (47.L * x * x - 47.L * x * y + 16.L * y * y 
      - 8.L * y * (2.L * x + y) * lnbary + 4.L * y * y * lnbary2))/(4.L*x) 
    + (162.L*x*x*x - 434.L*x*x*y + 116.L*x*y*y - 17.L*y*y*y +
      9.L*y*(-8.L*x*x - 8.L*x*y + y*y)*lnbary + 
      24.L*x*y*y*lnbary2)/(24.L*x*x) 
    + TVIL_I2(x, x, y, qq) * ((-2.L + y/x)*lnbarx + (8.L*x*x - 4*x*y + 
      y*y - 2*x*y*lnbary)/(2.L*x*x)) + 2.L*y*(4.L - y/x)*Zeta3;

  return result;
}

/* ****************************************************************** */
TVIL_COMPLEX TVIL_Gx00xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  TVIL_REAL Gx00xytableA[] = 
     {0, 0, -0.42391086660614674, -0.11127997554950356, 
     -0.024135990460208746, -0.006179852025555073, -0.0018852354594541955, 
     -0.0006831582249035862, -0.00028942688451065067, 
     -0.00013956909499487203, -0.00007443846530068568, 
     -0.000042869191803686065, -0.000026192600294754784, 
     -0.000016769610835324743, -0.000011152835844418036, 
     -7.656128840949065e-6, -5.399085279105823e-6, -3.89678257643342e-6, 
     -2.8699987620183548e-6, -2.1517931901416006e-6, 
     -1.639068737823178e-6, -1.2663280153262696e-6, -9.909070329018485e-7, 
     -7.843886650607117e-7, -6.274624076051258e-7, -5.067664547070383e-7, 
     -4.129019029065727e-7, -3.3915742127635767e-7, -2.806743348018197e-7, 
     -2.3389035491556021e-7, -1.9616293791864537e-7, 
     -1.6551044779401232e-7, -1.4043181381102468e-7, 
     -1.1977926451059578e-7, -1.0266744385301198e-7, 
     -8.840778519764158e-8, -7.646062957984981e-8, -6.639994911589195e-8, 
     -5.788711862640341e-8, -5.0651246222576827e-8, -4.447430251205685e-8, 
     -3.9179791250900086e-8, -3.462405523977762e-8, 
     -3.0689558491722316e-8, -2.727966147750733e-8, 
     -2.4314532339111566e-8, -2.1727928160492092e-8, 
     -1.946464687685294e-8, -1.747849925026189e-8, -1.5730686483026487e-8, 
     -1.4188495968792124e-8, -1.2824247876456773e-8, 
     -1.161444050275335e-8, -1.0539053900464956e-8, -9.580980124977293e-9, 
     -8.725555226196033e-9, -7.960173349700461e-9, -7.273967373950139e-9, 
     -6.657543677997012e-9, -6.102761115411155e-9, -5.6025462225509675e-9, 
     -5.150738232323738e-9, -4.74195868917736e-9, -4.371501436898984e-9, 
     -4.0352395314541885e-9, -3.729546257985133e-9, 
     -3.4512279363314724e-9, -3.197466608088614e-9, 
     -2.9657710298738773e-9, -2.7539346675320663e-9, 
     -2.5599996066237754e-9, -2.38222547531801e-9, -2.219062624394845e-9, 
     -2.0691289315449607e-9, -1.931189698403583e-9, 
     -1.8041401926876262e-9, -1.686990457565746e-9, 
     -1.5788520685249685e-9, -1.4789265665651255e-9, 
     -1.3864953372275866e-9, -1.3009107391119031e-9, 
     -1.2215883142675028e-9, -1.147999937080662e-9, 
     -1.0796677787597145e-9, -1.0161589818715223e-9, 
     -9.57080954109633e-10, -9.020772030012934e-10, 
     -8.508236439367154e-10, -8.030253230207482e-10, 
     -7.58413504047035e-10, -7.167430755803727e-10, 
     -6.777902398739345e-10, -6.413504502864571e-10, 
     -6.072365681199791e-10, -5.752772134718601e-10, 
     -5.453152878705661e-10, -5.172066492148389e-10, 
     -4.908189219211964e-10, -4.660304272568141e-10, 
     -4.4272922063757073e-10, -4.208122242417429e-10};
 
  TVIL_REAL Gx00xytableALx[] = 
     {0, 0, 0.1111111111111111, -0.04055555555555555, 
     -0.014240362811791384, -0.0049637818090199045, -0.0019680311671653665, 
     -0.0008980334363284747, -0.0004631458993763356, -0.00026314341415798495, 
     -0.00016098903161433585, -0.00010424312848813507, 
     -0.00007057155208741928, -0.0000495195389003308, 
     -0.00003578962570974795, -0.0000265172749928703, 
     -0.00002006867304609257, -0.000015469781623451876, 
     -0.000012117814207414963, -9.627611277104734e-6, 
     -7.746138704409993e-6, -6.3030587908566185e-6, -5.181196789661933e-6, 
     -4.298375884489631e-6, -3.595953371105364e-6, -3.0314174307322323e-6, 
     -2.5735059615800472e-6, -2.198927163458428e-6, 
     -1.8901181611959221e-6, -1.6336888595888343e-6, 
     -1.4193258393614365e-6, -1.2390099459042004e-6, 
     -1.086450870238933e-6, -9.56673839746502e-7, -8.457142618810274e-7, 
     -7.503898695409262e-7, -6.681291079495113e-7, -5.968407479392464e-7, 
     -5.348140060705333e-7, -4.806414407373761e-7, -4.331589954369755e-7, 
     -3.9139905386254226e-7, -3.545534428042866e-7, -3.219440943270408e-7, 
     -2.929996448571722e-7, -2.672366655243137e-7, -2.4424452718777453e-7, 
     -2.2367313451634202e-7, -2.0522293724760633e-7, 
     -1.8863675835830533e-7, -1.7369307918967118e-7, 
     -1.602004984961399e-7, -1.4799314171726605e-7, -1.369268427888781e-7, 
     -1.268759566884349e-7, -1.1773068902704233e-7, 
     -1.0939485114343175e-7, -1.0178396667487316e-7, 
     -9.482366950436339e-8, -8.844834409838618e-8, -8.259996815902672e-8, 
     -7.722712468463245e-8, -7.228415632641669e-8, -6.773043962645792e-8, 
     -6.352976054626509e-8, -5.964977581805018e-8, -5.6061547210109825e-8, 
     -5.273913790186778e-8, -4.965926189956972e-8, -4.6800978859336765e-8, 
     -4.4145427875561404e-8, -4.1675594783921527e-8, 
     -3.9376108355467305e-8, -3.723306145033314e-8, -3.523385378022152e-8, 
     -3.336705341710071e-8, -3.162227459724262e-8, -2.99900697176534e-8, 
     -2.8461833716680307e-8, -2.702971928081242e-8, -2.568656153261892e-8, 
     -2.442581103633771e-8, -2.3241474112782058e-8, 
     -2.2128059588086284e-8, -2.1080531214795298e-8, 
     -2.009426510178616e-8, -1.916501157389842e-8, -1.82888609549633e-8, 
     -1.7462212830860838e-8, -1.6681748403733373e-8, 
     -1.5944405595755333e-8, -1.5247356601930896e-8, 
     -1.4587987627133414e-8, -1.3963880573755371e-8, 
     -1.3372796473535593e-8, -1.2812660480910617e-8, 
     -1.2281548266059747e-8, -1.1777673664072968e-8, 
     -1.1299377452705673e-8, -1.084511714528497e-8, -1.0413457697749275e-8};
 
  TVIL_REAL Gx00xytableALy[] = 
     {0, 0, 0.3333333333333333, 0.075, 0.01865079365079365, 
     0.005654761904761905, 0.0020887445887445887, 0.0009206071706071706, 
     0.0004675681461395747, 0.0002640394735982971, 0.0001611753017841769, 
     0.00010428263441310766, 0.0000705800672487472, 0.000049521398788508376, 
     0.0000357900364818728, 0.000026517366573911166, 0.000020068693629848862, 
     0.00001546978628248199, 0.000012117815268477894, 9.627611520073316e-6, 
     7.746138760316498e-6, 6.303058803776496e-6, 5.1811967926593786e-6, 
     4.298375885187511e-6, 3.5959533712683713e-6, 3.031417430770419e-6, 
     2.5735059615890177e-6, 2.1989271634605405e-6, 1.8901181611964206e-6, 
     1.633688859588952e-6, 1.4193258393614645e-6, 1.2390099459042071e-6, 
     1.0864508702389344e-6, 9.566738397465024e-7, 8.457142618810276e-7, 
     7.503898695409263e-7, 6.681291079495113e-7, 5.968407479392464e-7, 
     5.348140060705333e-7, 4.806414407373761e-7, 4.3315899543697546e-7, 
     3.9139905386254226e-7, 3.545534428042866e-7, 3.219440943270408e-7, 
     2.929996448571722e-7, 2.672366655243137e-7, 2.442445271877745e-7, 
     2.2367313451634197e-7, 2.052229372476063e-7, 1.8863675835830533e-7, 
     1.7369307918967118e-7, 1.6020049849613989e-7, 1.4799314171726605e-7, 
     1.369268427888781e-7, 1.268759566884349e-7, 1.1773068902704233e-7, 
     1.0939485114343176e-7, 1.0178396667487316e-7, 9.48236695043634e-8, 
     8.844834409838618e-8, 8.259996815902672e-8, 7.722712468463247e-8, 
     7.228415632641669e-8, 6.773043962645792e-8, 6.352976054626508e-8, 
     5.964977581805018e-8, 5.606154721010982e-8, 5.273913790186779e-8, 
     4.965926189956972e-8, 4.680097885933678e-8, 4.414542787556141e-8, 
     4.1675594783921527e-8, 3.93761083554673e-8, 3.723306145033315e-8, 
     3.523385378022152e-8, 3.336705341710071e-8, 3.162227459724261e-8, 
     2.99900697176534e-8, 2.8461833716680307e-8, 2.702971928081242e-8, 
     2.568656153261892e-8, 2.4425811036337706e-8, 2.324147411278205e-8, 
     2.2128059588086287e-8, 2.1080531214795298e-8, 2.009426510178616e-8, 
     1.916501157389842e-8, 1.82888609549633e-8, 1.7462212830860838e-8, 
     1.6681748403733373e-8, 1.5944405595755333e-8, 1.5247356601930896e-8, 
     1.4587987627133412e-8, 1.3963880573755371e-8, 1.337279647353559e-8, 
     1.2812660480910617e-8, 1.2281548266059747e-8, 1.1777673664072968e-8, 
     1.1299377452705674e-8, 1.0845117145284969e-8, 1.0413457697749277e-8};
 
  TVIL_REAL Gx00xytableALx2[] = 
     {0, 0, 0.16666666666666666, 0.016666666666666666, 
     0.002380952380952381, 0.0003968253968253968, 0.00007215007215007215, 
     0.000013875013875013875, 2.775002775002775e-6, 5.713241007358655e-7, 
     1.202787580496559e-7, 2.577401958206912e-8, 5.603047735232417e-9, 
     1.2326705017511316e-9, 2.7392677816691816e-10, 6.139738131327476e-11, 
     1.3863924812674945e-11, 3.1508920028806695e-12, 
     7.202038863727245e-13, 1.6545224416670698e-13, 
     3.8181287115393914e-14, 8.846883599908346e-15, 
     2.0574147906763594e-15, 4.800634511578173e-16, 1.123552758028934e-16, 
     2.636909534149539e-17, 6.204493021528327e-18, 1.4633238258321526e-18, 
     3.4587654065123604e-19, 8.191812804897696e-20, 1.943819987602843e-20, 
     4.6205557082362665e-21, 1.1001323114848254e-21, 
     2.623392435079199e-22, 6.264817755413012e-23, 1.4981085936857203e-23, 
     3.587020576430598e-24, 8.59902192979938e-25, 2.0637652631518508e-25, 
     4.9583970608193825e-26, 1.19252587538694e-26, 2.8708956259315225e-27, 
     6.917820785377162e-28, 1.6684156011791979e-28, 4.027210071811857e-29, 
     9.728653544264599e-30, 2.3519821755364965e-30, 5.690279456943136e-31, 
     1.3776466053651805e-31, 3.3375974459878077e-32, 
     8.091145323606808e-33, 1.962703568597691e-33, 4.763843613101192e-34, 
     1.1569334488960036e-34, 2.811240156195897e-35, 6.83466643478819e-36, 
     1.6624864300836136e-36, 4.045874055513219e-37, 9.850823787336533e-38, 
     2.399559640505053e-38, 5.847666350810633e-39, 1.4256707218918484e-39, 
     3.47724566315085e-40, 8.484479418088074e-41, 2.0710146611081128e-41, 
     5.057128823636089e-42, 1.2353291782927851e-42, 
     3.0186615259034222e-43, 7.37895039665281e-44, 1.8043418853129132e-44, 
     4.4134981367366226e-45, 1.0798984802653439e-45, 
     2.643108168481611e-46, 6.471057929730841e-47, 1.58474888075041e-47, 
     3.882102962912078e-48, 9.512437723691846e-49, 2.3314798342381977e-49, 
     5.71588604522913e-50, 1.4016663231931305e-50, 3.4380494719831504e-51, 
     8.434966095859281e-52, 2.0699303302722166e-52, 5.08073808339544e-53, 
     1.2473668348455872e-53, 3.063060570774667e-54, 7.523306665060585e-55, 
     1.8482111749426293e-55, 4.541318887001889e-56, 
     1.1160868451106337e-56, 2.7434536974786526e-57, 
     6.744955223082876e-58, 1.6585955466597236e-58, 4.07924850664959e-59, 
     1.0034515043095249e-59, 2.4688092566345452e-60, 
     6.0750803697289855e-61, 1.4951622671612789e-61, 
     3.6803994268585327e-62, 9.060881837697403e-63, 2.231071407272225e-63};
 
  TVIL_REAL Gx00xytableB[] = 
     {0, -1.1477714348244796, 3.3913041288711554, -1.000448919580449, 
     0.5325349536523081, -0.3367532355844961, 0.23324577803444746, 
     -0.17137622734754943, 0.13132956626562065, -0.1038857099308107, 
     0.08424557176091407, -0.06970138558120559, 0.05862816425056977, 
     -0.050001684577842154, 0.043149953688130654, -0.037617051766323906, 
     0.033084727513553625, -0.02932532053226064, 0.02617246600730211, 
     -0.023502293022702223, 0.02122102731993511, -0.019256619758922205, 
     0.017552972085492696, -0.016065877811147516, 0.014760119504507882, 
     -0.013607360595938381, 0.012584592449200405, -0.011672975582112596, 
     0.01085696468344427, -0.010123640663246183, 0.009462195572761359, 
     -0.008863531669441177, 0.008319946601299102, -0.00782488419662429, 
     0.007372735684148202, -0.0069586800070578075, 0.006578554683178389, 
     -0.00622875071045996, 0.005906126533162623, -0.005607937217356342, 
     0.005331775838336564, -0.0050755247311897525, 0.004837314752056135, 
     -0.004615491080099898, 0.004408584386885198, -0.004215286431441034, 
     0.004034429321212549, -0.0038649678227770726, 0.0037059642202639624, 
     -0.0035565753106036324, 0.0034160411977307154, -0.0032836756068453307, 
     0.003158857487576234, -0.003041023713648054, 0.0029296627183932125, 
     -0.0028243089315095338, 0.0027245379037525302, -0.0026299620240887236, 
     0.002540226748401552, -0.002455007270969166, 0.0023740055806565144, 
     -0.002296947851309565, 0.0022235821240026397, -0.0021536762445450684, 
     0.002087016023983989};
 
  TVIL_REAL Gx00xytableBL[] = 
     {0, 4.454822555520438, 0.36345162965304123, 0.2546193481387835, 
     -0.19311581798406674, 0.13615128606345184, -0.09901911713705586, 
     0.07470335017868768, -0.05817537855564853, 0.04650857505703268, 
     -0.03799552519422639, 0.03160559206162164, -0.02669260969785281, 
     0.022836815881429842, -0.019756724685270413, 0.017258207883800614, 
     -0.01520403415618242, 0.013495051847272205, -0.012058221072688072, 
     0.010838799676292504, -0.00979511932932324, 0.008895017988336619, 
     -0.008113356107140882, 0.007430256862137136, -0.006829839322959434, 
     0.0062992931118229095, -0.0058281934164567464, 0.005407987661066281, 
     -0.005031606434517132, 0.004693165489873384, -0.004387735266667837, 
     0.0041111610157234975, -0.003859921226785648, 0.003631015320401637, 
     -0.003421873894263981, 0.003230286495437114, -0.0030543431160780926, 
     0.002892386513228269, -0.0027429731242443675, 0.002604840852323674, 
     -0.0024768823765260774, 0.002358122929956883, -0.002247701711591034, 
     0.0021448562684866015, -0.002048909318236442, 0.0019592575855893607, 
     -0.0018753623090438723, 0.0017967411379811223, -0.001722961192409547, 
     0.0016536330985665072, -0.001588405846696249, 0.0015269623440172311, 
     -0.0014690155575325815, 0.0014143051589580995, -0.0013625945984484158, 
     0.0013136685456274777, -0.0012673306461735753, 0.0012234015502677435, 
     -0.001181717175902713, 0.0011421271756194007, -0.0011044935798920283, 
     0.0010686895942836287, -0.0010345985307733847, 0.0010021128564228782, 
     -0.0009711333448868924};
 
  TVIL_REAL Gx00xytableBL2[] = 
     {0, -1.2274112777602189, 1., -0.3333333333333333, 
     0.16666666666666666, -0.1, 0.06666666666666667, -0.047619047619047616, 
     0.03571428571428571, -0.027777777777777776, 0.022222222222222223, 
     -0.01818181818181818, 0.015151515151515152, -0.01282051282051282, 
     0.01098901098901099, -0.009523809523809525, 0.008333333333333333, 
     -0.007352941176470588, 0.006535947712418301, -0.005847953216374269, 
     0.005263157894736842, -0.004761904761904762, 0.004329004329004329, 
     -0.003952569169960474, 0.0036231884057971015, -0.0033333333333333335, 
     0.003076923076923077, -0.002849002849002849, 0.0026455026455026454, 
     -0.0024630541871921183, 0.0022988505747126436, -0.002150537634408602, 
     0.0020161290322580645, -0.001893939393939394, 0.0017825311942959, 
     -0.0016806722689075631, 0.0015873015873015873, -0.0015015015015015015, 
     0.001422475106685633, -0.001349527665317139, 0.001282051282051282, 
     -0.0012195121951219512, 0.0011614401858304297, -0.0011074197120708748, 
     0.0010570824524312897, -0.00101010101010101, 0.000966183574879227, 
     -0.0009250693802035153, 0.0008865248226950354, -0.0008503401360544217, 
     0.0008163265306122449, -0.000784313725490196, 0.0007541478129713424, 
     -0.000725689404934688, 0.0006988120195667365, -0.0006734006734006734, 
     0.0006493506493506494, -0.0006265664160401002, 0.0006049606775559589, 
     -0.0005844535359438924, 0.0005649717514124294, -0.000546448087431694, 
     0.0005288207297726071, -0.0005120327700972862, 0.000496031746031746};
 
  TVIL_REAL Gx00xytableC[] = 
     {0, 0, 0.09034728299512149, 0.07061786974208396, 
     0.053858094906417235, 0.04272479033248704, 0.03487787047671334, 
     0.029121777556425393, 0.024765215838894895, 0.021381404144873023, 
     0.01869514621573528, 0.016522634267807382, 0.014737328259627593, 
     0.013249776816613311, 0.011995255880823126, 0.010925958158831729, 
     0.010005919256487281, 0.00920763834408038, 0.00850977619255552, 
     0.007895554859360249, 0.007351624436288302, 0.0068672469646261355, 
     0.006433699688014262, 0.006043832540137165, 0.005691735761480099, 
     0.0053724872682376764, 0.0050819585313540885, 0.004816663901079345, 
     0.004573642553080284, 0.004350365184197225, 0.004144659667850909, 
     0.003954651365284563, 0.0037787148618438006, 0.0036154346804887867, 
     0.0034635731018152188, 0.003322043649187715, 0.0031898891198230803, 
     0.0030662632865364713, 0.0029504155808918794, 0.002841678211459569, 
     0.0027394552815244253, 0.002643213556790902, 0.00255247460121843, 
     0.002466808052435783, 0.0023858258504803453, 0.0023091772673495747, 
     0.0022365446119087693, 0.0021676395065044138, 0.002102199649289237, 
     0.0020399859906282194, 0.0019807802636899042, 0.001924382818955405, 
     0.0018706107203089275, 0.0018192960669323533, 0.0017702845106705508, 
     0.0017234339430689416, 0.0016786133300754156, 0.0016357016755776197, 
     0.0015945870976212043, 0.00155516600341159, 0.0015173423511123374, 
     0.0014810269880748419, 0.001446137056514515, 0.0014125954588267914, 
     0.0013803303757444763, 0.0013492748314028668, 0.0013193663001228083, 
     0.0012905463503630034, 0.0012627603218467475, 0.0012359570323478594, 
     0.0012100885110367682, 0.0011851097556495106, 0.0011609785110577586, 
     0.0011376550670931978, 0.0011151020737203525, 0.0010932843718629284, 
     0.0010721688383739864, 0.0010517242438030983, 0.001031921121757194, 
     0.001012731648778375, 0.0009941295337739372, 0.0009760899161328759, 
     0.0009585892717510257, 0.0009416053262649565, 0.0009251169748641307, 
     0.0009091042081125766, 0.0008935480432664324, 0.0008784304606228922, 
     0.0008637343444800718, 0.0008494434283267045, 0.0008355422439158512, 
     0.000822016073908536, 0.0008088509078016735, 0.0007960334008802717, 
     0.0007835508359569979, 0.0007713910876829917, 0.0007595425892326145, 
     0.0007479943011817953, 0.000736735682415018, 0.0007257566629098955, 
     0.0007150476182609144};
 
  TVIL_REAL Gx00xytableCLx[] = 
     {0, 0, 0.15625, 0.11848958333333333, 0.08734809027777778, 
     0.0667385525173611, 0.05284552680121528, 0.043085099477616566, 
     0.035958045042561296, 0.030581003224768605, 0.026412358451742585, 
     0.023106201958034037, 0.020433305088469033, 0.01823676360129405, 
     0.016406109117501552, 0.014861632131412368, 0.013544566472328335, 
     0.012410757339173477, 0.011426466222511164, 0.010565524565726458, 
     0.00980736086086137, 0.00913560662825322, 0.008537094179069395, 
     0.008001124616002178, 0.007518925484347111, 0.007083243635254634, 
     0.0066880358936897534, 0.006328231419793772, 0.005999547271872488, 
     0.005698343899177928, 0.005421510920443826, 0.005166376099244785, 
     0.004930632249311624, 0.004712278117372811, 0.004509570249632234, 
     0.004320983554110918, 0.004145178796211654, 0.00398097565890243, 
     0.0038273302970804465, 0.003683316543096121, 0.0035481100951781095, 
     0.0034209751557538453, 0.0033012530920432355, 0.003188352773938152, 
     0.0030817423093718334, 0.0029809419491099317, 0.00288551797416553, 
     0.002795077412141034, 0.0027092634554808674, 0.0026277514762285117, 
     0.0025502455494638304, 0.0024764754119650945, 0.002406193794431615, 
     0.002339174075318591, 0.002275208212372134, 0.00221410491462449, 
     0.0021556880231686265, 0.0020997950736792404, 0.002046276017546084, 
     0.0019949920817664848, 0.0019458147505135033, 0.0018986248536409548, 
     0.0018533117493773898, 0.0018097725901562035, 0.0017679116619761224, 
     0.0017276397889248905, 0.0016888737955617701, 0.0016515360207686055, 
     0.0016155538774673742, 0.001580859453283216, 0.0015473891478217953, 
     0.001515083342741778, 0.001483886101248475, 0.0014537448940227047, 
     0.0014246103489377654, 0.0013964360222138235, 0.001369178188918837, 
     0.0013427956509532645, 0.0013172495608564762, 0.0012925032599496037, 
     0.0012685221294856045, 0.0012452734536152852, 0.0012227262931001574, 
     0.0012008513688113315, 0.0011796209541498378, 0.0011590087756093302, 
     0.0011389899207783305, 0.001119540753147144, 0.0011006388331452775, 
     0.0010822628448894879, 0.001064392528171208, 0.00104700861525568, 
     0.0010300927721042692, 0.0010136275436666007, 0.0009975963029208172, 
     0.0009819832033687698, 0.0009667731347186799, 0.0009519516815110317, 
     0.0009375050844644511, 0.0009234202043373267, 0.0009096844881181263};
 
  TVIL_REAL Gx00xytableCLy[] = 
     {0, 0, -0.20561675835602827, -0.1466451847335697, 
     -0.1083633099029255, -0.08328514375496453, -0.06628357352802894, 
     -0.0542598952795518, -0.045429785630133945, -0.038736276199850164, 
     -0.03352675067532218, -0.029381663006811644, -0.02602138374190713, 
     -0.023253560118436593, -0.0209421879958053, -0.0189887700046686, 
     -0.017320455203975058, -0.015882351830169804, -0.014632413041498274, 
     -0.01353795408337552, -0.012573230255774174, -0.011717720506247222, 
     -0.010954890144769188, -0.010271285013921043, -0.009655858891484893, 
     -0.009099467580325328, -0.008594483836942056, -0.008134501057329048, 
     -0.0077141029496837175, -0.007328682817671955, -0.006974300531765619, 
     -0.006647568409545985, -0.006345559471723527, -0.006065733163673311, 
     -0.00580587481784146, -0.005564046007081205, -0.0053385435904265335, 
     -0.00512786574229642, -0.004930683626986224, -0.0047458176635085695, 
     -0.004572217543724905, -0.004408945335512714, -0.004255161134370177, 
     -0.00411011083019637, -0.003973115637581957, -0.0038435631027461054, 
     -0.003720899351998817, -0.00360462238814036, -0.003494276274712258, 
     -0.003389446075168192, -0.003289753436141658, -0.0031948527220662243, 
     -0.0031044276232499446, -0.003018188171745053, -0.002935868109483871, 
     -0.0028572225615664778, -0.0027820259746005683, -0.0027100702858617867, 
     -0.002641163293967466, -0.002575127205902891, -0.002511797338740653, 
     -0.0024510209573593887, -0.002392656231987389, -0.002336571301542228, 
     -0.002282643430570163, -0.0022307582491580746, -0.002180809066537643, 
     -0.0021326962502603254, -0.0020863266638212787, -0.002041613156474375, 
     -0.0019984740997289964, -0.0019568329656691804, -0.0019166179428010415, 
     -0.0018777615856272857, -0.001840200494578083, -0.0018038750233043284, 
     -0.0017687290106695628, -0.001734709535066944, -0.0017017666889428615, 
     -0.0016698533716337522, -0.0016389250988212362, -0.0016089398270862942, 
     -0.001579857792198702, -0.0015516413599158774, -0.0015242548881878037, 
     -0.001497664599773707, -0.0014718384643732487, -0.0014467460894616382, 
     -0.001422358619095432, -0.0013986486400250245, -0.0013755900945118236, 
     -0.0013531581993036987, -0.001331329370272219, -0.0013100811522600698, 
     -0.0012893921537274352, -0.0012692419858225234, -0.0012496112055342548, 
     -0.0012304812626147763, -0.0012118344499862797, -0.0011936538573708599, 
     -0.0011759233279041337};
 
  TVIL_REAL Gx00xytableCLx2[] = 
     {0, 0, 0.109375, 0.049479166666666664, 0.029459635416666668, 
     0.020035807291666666, 0.014742024739583333, 0.01142607189360119, 
     0.009189269656226748, 0.007597113412524026, 0.006416633772471594, 
     0.005512897982053771, 0.004802929075679393, 0.004233195016735176, 
     0.00376777761567329, 0.0033817747935635366, 0.003057436239636326, 
     0.002781804520391232, 0.002545223386131661, 0.0023403652102309356, 
     0.002161579745461028, 0.0020044476607377175, 0.0018654680038290288, 
     0.0017418352895941798, 0.0016312778165194625, 0.0015319385964298246, 
     0.0014422864454962238, 0.0013610487530840085, 0.001287160051151473, 
     0.0012197222495772264, 0.001157973587492295, 0.0011012641684167675, 
     0.0010490365194108686, 0.0010008100203883449, 0.0009561683411222935, 
     0.0009147492349965993, 0.0008762361937305519, 0.000840351582267146, 
     0.000806850958977493, 0.0007755183511709145, 0.000746162305205357, 
     0.0007186125682767623, 0.0006927172881328407, 0.0006683406396273971, 
     0.000645360804768356, 0.0006236682468759986, 0.0006031642305255266, 
     0.0005837595477539137, 0.0005653734180612016, 0.0005479325354098912, 
     0.0005313702400139689, 0.000515625796436456, 0.0005006437625561166, 
     0.0004863734364568212, 0.000472768370344486, 0.0004597859422912907, 
     0.00044738697801232057, 0.0004355354160495144, 0.00042419801071475827, 
     0.00041334406796265965, 0.0004029452100518301, 0.0003929751654339772, 
     0.0003834095808011127, 0.00037422585263773494, 0.0003654029759792078, 
     0.0003569214083798483, 0.0003487629473527727, 0.00034091061976523326, 
     0.0003333485818637279, 0.00032606202876733623, 0.0003190371124095175, 
     0.00031226086703131645, 0.00030572114143536305, 0.00029940653730256697, 
     0.0002933063529539966, 0.00028741053201075217, 0.0002817096164661394, 
     0.00027619470373832115, 0.0002708574073188989, 0.00026568982067444935, 
     0.00026068448409464394, 0.0002558343542128789, 0.00025113277595387775, 
     0.00024657345668798727, 0.00024215044239427394, 0.00023785809565440345, 
     0.00023369107531695535, 0.00022964431768755878, 0.00022571301911426017, 
     0.00022189261985005842, 0.00021817878908573956, 0.00021456741105616494, 
     0.0002110545721321502, 0.0002076365488181362, 0.0002043097965830952, 
     0.00020107093945863472, 0.00019791676034412901, 0.0001948441919640031, 
     0.00019185030842706967, 0.00018893231734213857, 0.0001860875524480226};
 
  TVIL_REAL Gx00xytableCLxLy[] = 
     {0, 0, -0.28125, -0.15104166666666666, -0.09733072916666667, 
     -0.06930338541666667, -0.05254720052083333, -0.04160098121279762, 
     -0.0339896247500465, -0.028445909893701948, -0.02426084866599431, 
     -0.021010031672611208, -0.018425491030770118, -0.016330572704566757, 
     -0.014604590070472268, -0.01316258118450989, -0.011943183532523344, 
     -0.010901089087619768, -0.010002193178772057, -0.009220385323912821, 
     -0.008535372572624534, -0.007931170166103542, -0.007395034105767806, 
     -0.006916692787709731, -0.006487785023428036, -0.006101443024219293, 
     -0.0057519788520242485, -0.005434645806681085, -0.005145454818786382, 
     -0.00488103171911991, -0.004638505232376055, -0.004415418308880627, 
     -0.004209657357874574, -0.0040193953378879705, -0.003843045665008397, 
     -0.003679224633806086, -0.003526720587013211, -0.00338446847313701, 
     -0.0032515287340187647, -0.0031270696937867773, -0.00301035279586307, 
     -0.00290072016949073, -0.002797584111705564, -0.002700418152159315, 
     -0.0026087494321700984, -0.002522152179897919, -0.002440242103675496, 
     -0.002362671557578513, -0.002289125359054989, -0.002219317159199118, 
     -0.0021529862830903957, -0.002089894971330177, -0.0020298259651234584, 
     -0.0019725803864663223, -0.0019179758725971047, -0.0018658449301593295, 
     -0.0018160334797509689, -0.0017683995658930127, -0.0017228122110972133, 
     -0.00167915039577446, -0.0016373021483036244, -0.0015971637317588232, 
     -0.0015586389156384208, -0.0015216383225070654, -0.0014860788407979667, 
     -0.0014518830961638457, -0.0014189789747424623, -0.0013872991925418393, 
     -0.0013567809058726665, -0.0013273653583784908, -0.0012989975607531324, 
     -0.0012716259997016715, -0.0012452023731068219, -0.0012196813487153411, 
     -0.0011950203439667964, -0.00117117932485579, -0.0011481206219540162, 
     -0.0011258087619248544, -0.0011042103130444393, -0.0010832937434026634, 
     -0.001063029290598182, -0.001043388841865648, -0.001024345823683198, 
     -0.0010058751000055037, -0.0009879528783539753, -0.0009705566230723778, 
     -0.0009536649751243465, -0.0009372576778700661, -0.0009213155083136205, 
     -0.0009058202133609766, -0.0008907544506719291, -0.0008761017337281651, 
     -0.0008618463807744474, -0.0008479734673212055, -0.0008344687819249446, 
     -0.0008213187849882161, -0.0008085105703437043, -0.0007960318294075857, 
     -0.0007838708177059077, -0.0007720163235945571, -0.0007604576390086064};
 
  TVIL_REAL Gx00xytableCLy2[] = 
    {0, 0, 0.171875, 0.1015625, 0.06787109375, 0.049267578125, 
     0.03780517578125, 0.03017490931919643, 0.024800355093819754, 
     0.02084879648117792, 0.017844214893522718, 0.015497133690557439, 
     0.013622561955090725, 0.012097377687831581, 0.010836812454798977, 
     0.009780806390946353, 0.00888574729288702, 0.008119284567228536, 
     0.007456969792640397, 0.006880020113681886, 0.0063737928271635075, 
     0.005926722505365824, 0.005529566101938778, 0.005174857498115552, 
     0.004856507206908572, 0.004569504427789469, 0.004309692406528025, 
     0.004073597053597076, 0.0038582947676349096, 0.003661309469542684, 
     0.0034805316448837604, 0.00331415414046386, 0.0031606208384637054, 
     0.003018585317499626, 0.002886877323886104, 0.002764475398809487, 
     0.0026504843932826593, 0.002544116890869864, 0.0024446777750412717, 
     0.0023515513426158627, 0.0022641904906577125, 0.002182107601213968, 
     0.002104866823572724, 0.002032077512531918, 0.0019633886274017416, 
     0.0018984839330219209, 0.0018370778731499698, 0.0017789120098245991, 
     0.0017237519409937874, 0.0016713846237892268, 0.0016216160430764272, 
     0.0015742691748937207, 0.001529182202567342, 0.0014862069500095013, 
     0.0014452075022526188, 0.0014060589878680389, 0.001368646501738648, 
     0.001332864149843498, 0.001298614200382455, 0.0012658063278118002, 
     0.0012343569382517944, 0.001204188566324846, 0.0011752293348373077, 
     0.0011474124698693305, 0.0011206758648187587, 0.0010949616877839975, 
     0.0010702160273896894, 0.001046388572776606, 0.001023432324008939, 
     0.0010013033296111546, 0.0009799604483436146, 0.0009593651326703548, 
     0.0009394812316714589, 0.0009202748114127741, 0.0009017139910127998, 
     0.0008837687928450376, 0.0008664110054878764, 0.0008496140581865334, 
     0.0008333529057255407, 0.0008176039227282139, 0.0008023448065035382, 
     0.0007875544876527691, 0.0007732130477293202, 0.0007593016433175164, 
     0.0007458024359597013, 0.0007326985274179743, 0.000719973899807391, 
     0.0007076133601825072, 0.0006956024891993602, 0.0006839275935109181, 
     0.0006725756615861897, 0.0006615343226720003, 0.0006507918086422974, 
     0.0006403369185030693, 0.0006301589853418494, 0.0006202478455295814, 
     0.0006105938099995753, 0.0006011876374435825, 0.0005920205092788381, 
     0.0005830840062524185, 0.0005743700865605838};
 
  TVIL_REAL Gx00xytableCLx3[] = 
     {0, 0, -0.03125, -0.015625, -0.009765625, -0.0068359375, 
     -0.005126953125, -0.0040283203125, -0.00327301025390625, 
     -0.002727508544921875, -0.0023183822631835938, -0.002002239227294922, 
     -0.0017519593238830566, -0.0015498101711273193, -0.001383759081363678, 
     -0.0012453831732273102, -0.0011286285007372499, -0.0010290436330251396, 
     -0.0009432899969397113, -0.0008688197340234183, -0.0008036582539716619, 
     -0.0007462540929736861, -0.0006953731320891166, -0.0006500227104311307, 
     -0.000609396291029185, -0.0005728325135674339, -0.0005397844839385435, 
     -0.0005097964570530689, -0.00048248593256808303, -0.0004575297636421477, 
     -0.0004346532754600403, -0.00041362166535713514, -0.0003942331497935194, 
     -0.0003763134611665413, -0.0003597113967033115, -0.0003442951939874553, 
     -0.0003299495609046447, -0.0003165732273544564, -0.00030407691574835943, 
     -0.0002923816497580379, -0.0002814173378921115, -0.00027112158162776595, 
     -0.0002614386679982029, -0.0002523187144633818, -0.00024371694010667563, 
     -0.00023559304210311977, -0.00022791066029540934, 
     -0.00022063691581789628, -0.00021374201219858703, 
     -0.0002071988893761813, -0.00020098292269489585, 
     -0.00019507166026269305, -0.00018944459313973076, 
     -0.0001840829537112478, -0.0001789695383303798, -0.00017408855092136946, 
     -0.00016942546473597563, -0.00016496689987450258, 
     -0.0001607005145329206, -0.0001566149082312362, -0.0001526995355254553, 
     -0.0001489446289141736, -0.00014534112982754038, 
     -0.00014188062673640845, -0.00013855529954727387, 
     -0.0001353578695577214, -0.00013228155434050047, -0.0001293200270045191, 
     -0.00012646737935000766, -0.0001237180884945727, 
     -0.00012106698659826044, -0.00011850923336026903, 
     -0.00011604029099859675, -0.0001136559014575297, 
     -0.00011135206561717436, -0.00010912502430483088, 
     -0.00010697124093039342, -0.00010488738558759355, 
     -0.00010287032048013983, -0.00010091708654697261, 
     -0.00009902489117421688, -0.00009719109689321287, 
     -0.00009541321097443458, -0.00009368887583634239, 
     -0.00009201586019640771, -0.00009039205089882404, 
     -0.00008881544535989107, -0.00008728414457782397, 
     -0.0000857963466588838, -0.00008435034081631834, 
     -0.00008294450180271303, -0.00008157728474003095, 
     -0.00008024722031492175, -0.00007895291030984237, 
     -0.00007769302344319594, -0.00007646629149409284, 
     -0.00007527150568949765, -0.00007410751333347448, 
     -0.00007297321466000294, -0.00007186755989242713, 
     -0.00007078954649404074};
 
  TVIL_REAL Gx00xytableD[] = 
    {0, 0, 0.845574663765145, -0.3015841064301469, 0.15938940428676457, 
     -0.09850996915313068, 0.06685247584607733, -0.048315822459717245, 
     0.036538604972939, -0.02859435582833405, 0.022984246492259504, 
     -0.018876226120929915, 0.01577839054140881, -0.0133848310732964, 
     0.011497220915933491, -0.009982419420124358, 0.008748358572943048, 
     -0.007729727839960655, 0.0068791582809036205, -0.006161617910367615, 
     0.005550747984798741, -0.005026408447833482, 0.004572997101380317, 
     -0.004178275837983609, 0.0038325363730006994, -0.0035279977256618814, 
     0.0032583646962994245, -0.003018499990693064, 0.002804177750701089, 
     -0.0026118961863154087, 0.0024387336510425105, -0.0022822370192892532, 
     0.0021403343386439855, -0.002011265906191661, 0.001893529457922652, 
     -0.001785836262720539, 0.0016870757102777957, -0.0015962865656476912, 
     0.0015126334937659196, -0.001435387778028248, 0.001363911397958241, 
     -0.0012976438134516299, 0.001236090942290939, -0.0011788159245989785, 
     0.0011254313506658081, -0.0010755926930335587, 0.0010289927342189884, 
     -0.0009853568212477228, 0.0009444388097095671, -0.0009060175851680197, 
     0.0008698940698745012, -0.0008358886389246951, 0.0008038388830792976, 
     -0.0007735976660959652, 0.0007450314330828107, -0.0007180187334773348, 
     0.0006924489280855625, -0.0006682210544272996, 0.0006452428286176059, 
     -0.0006234297653255244, 0.000602704400111855, -0.0005829956007572471, 
     0.0005642379561299326, -0.0005463712327737083, 0.0005293398907738719, 
     -0.0005130926516246267, 0.0004975821118111124, -0.00048276439666153787, 
     0.00046859884974365785, -0.0004550477536947029, 0.00044207607890110767, 
     -0.00042965125689755355, 0.000417742975745216, -0.0004063229949861361, 
     0.0003953649780622261, -0.00038484434034021897, 0.00037473811110348633, 
     -0.00036502480806280404, 0.0003556843231048486, -0.00034669781814285325, 
     0.0003380476300613348, -0.000329717183858575, 0.0003216909131887149, 
     -0.0003139541875916893, 0.00030649324577533446, -0.0002992951343811768, 
     0.0002923476517247846, -0.0002856392960541312, 0.00027915921791602216, 
     -0.0002728971762620131, 0.00026684349796203695, -0.0002609890404267096, 
     0.0002553251570684834, -0.0002498436653578842, 0.0002445368172543637, 
     -0.00023939727181214972, 0.0002344180697801585, -0.00022959261003179063, 
     0.0002249146276754859, -0.00022037817371044566, 0.00021597759610411307};
 
  TVIL_REAL Gx00xytableDL[] = 
     {0, 0, -0.2186975871035137, 0.12845475125672678, 
     -0.07174761194892897, 0.0450539635215082, -0.030781213381871893, 
     0.02232424768031541, -0.016917752027425906, 0.01325740228634727, 
     -0.010666352641678704, 0.008765923455703912, -0.0073311097273131755, 
     0.006221497298689193, -0.005345824471730073, 0.004642710405504938, 
     -0.004069648147935945, 0.0035964498632350627, -0.0032012004186621674, 
     0.002867680026044644, -0.002583676868542607, 0.0023398552080642404, 
     -0.0021289794823856766, 0.0019453719969755765, -0.001784527186160578, 
     0.0016428328487905924, -0.0015173657573760368, 0.0014057398030670883, 
     -0.0013059917947846889, 0.0012164946097603406, -0.0011358904584165463, 
     0.0010630391113052996, -0.0009969773741609015, 0.0009368871028294241, 
     -0.0008820697618443181, 0.0008319260403774927, -0.0007859394085249639, 
     0.0007436627669514287, -0.0007047075423440928, 0.0006687347297160743, 
     -0.0006354474942519688, 0.0006045850299568943, -0.0005759174369101424, 
     0.0005492414285320382, -0.0005243767186617271, 0.0005011629681429953, 
     -0.00047945719404525347, 0.0004591315631144789, -0.00044007150568623117, 
     0.0004221740979558993, -0.0004053466698416065, 0.0003895056031915755, 
     -0.0003745752911644787, 0.0003604872345459633, -0.00034717925478887774, 
     0.00033459480686010457, -0.00032268237768597784, 0.00031139495822376346, 
     -0.00030068957903809897, 0.0002905269007999901, -0.00028087085240907015, 
     0.00027168831051329, -0.0002629488151010855, 0.00025462431659940664, 
     -0.0002466889505512105, 0.00023911883648804089, -0.00023189189807346246, 
     0.00022498770198478663, -0.00021838731333476241, 0.00021207316572084104, 
     -0.00020602894423482463, 0.00020023947997647055, 
     -0.00019469065479619014, 0.00018936931514874428, 
     -0.00018426319407546977, 0.0001793608404501683, -0.00017465155472595008, 
     0.00017012533050925286, -0.0001657728013648112, 0.0001615851923231121, 
     -0.0001575542756211857, 0.00015367233025958448, -0.00014993210500408567, 
     0.0001463267845008375, -0.0001428499582090864, 0.00013949559188687835, 
     -0.00013625800139276028, 0.0001331318285909674, -0.00013011201916927212, 
     0.0001271938021979259, -0.00012437267127524685, 0.00012164436712064931, 
     -0.00011900486148950288, 0.00011645034229633883, 
     -0.00011397719984376683, 0.0001115820140641688, -0.00010926154268993257, 
     0.00010701271027578927, -0.00010483259800382426, 0.00010271843420803197, 
     -0.00010066758556095591};
 
  TVIL_REAL Gx00xytableDL2[] = 
     {0, 0, 0.25, -0.08333333333333333, 0.041666666666666664, -0.025, 
     0.016666666666666666, -0.011904761904761904, 0.008928571428571428, 
     -0.006944444444444444, 0.005555555555555556, -0.004545454545454545, 
     0.003787878787878788, -0.003205128205128205, 0.0027472527472527475, 
     -0.002380952380952381, 0.0020833333333333333, -0.001838235294117647, 
     0.0016339869281045752, -0.0014619883040935672, 0.0013157894736842105, 
     -0.0011904761904761906, 0.0010822510822510823, -0.0009881422924901185, 
     0.0009057971014492754, -0.0008333333333333334, 0.0007692307692307692, 
     -0.0007122507122507123, 0.0006613756613756613, -0.0006157635467980296, 
     0.0005747126436781609, -0.0005376344086021505, 0.0005040322580645161, 
     -0.0004734848484848485, 0.000445632798573975, -0.0004201680672268908, 
     0.0003968253968253968, -0.00037537537537537537, 0.00035561877667140827, 
     -0.00033738191632928474, 0.0003205128205128205, -0.0003048780487804878, 
     0.00029036004645760743, -0.0002768549280177187, 0.0002642706131078224, 
     -0.0002525252525252525, 0.00024154589371980676, -0.00023126734505087883, 
     0.00022163120567375886, -0.00021258503401360543, 0.00020408163265306123, 
     -0.000196078431372549, 0.0001885369532428356, -0.000181422351233672, 
     0.00017470300489168413, -0.00016835016835016836, 0.00016233766233766234, 
     -0.00015664160401002505, 0.00015124016938898973, -0.0001461133839859731, 
     0.00014124293785310735, -0.0001366120218579235, 0.00013220518244315177, 
     -0.00012800819252432156, 0.0001240079365079365, -0.0001201923076923077, 
     0.00011655011655011655, -0.00011307100859339665, 0.00010974539069359087, 
     -0.00010656436487638534, 0.00010351966873706004, 
     -0.00010060362173038229, 0.00009780907668231612, 
     -0.00009512937595129375, 0.00009255831173639393, 
     -0.00009009009009009009, 0.00008771929824561403, 
     -0.00008544087491455913, 0.00008325008325008325, 
     -0.00008114248620577734, 0.00007911392405063291, 
     -0.00007716049382716049, 0.00007527853056308341, 
     -0.00007346459006758743, 0.00007171543316121629, 
     -0.00007002801120448179, 0.00006839945280437756, 
     -0.00006682705159048383, 0.00006530825496342738, 
     -0.00006384065372829418, 0.00006242197253433208, 
     -0.00006105006105006105, 0.00005972288580984233, -0.0000584385226741468, 
     0.00005719514985129261, -0.000055991041433370664, 
     0.00005482456140350877, -0.000053694158075601374, 
     0.000052598358931201344, -0.000051535765821480104, 
     0.000050505050505050505};
 
  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  if (y < 0.5 * x) {
    result = TVIL_Gx000x (x,qq);
    result += y * (1.5L - 0.5L * PI2 + lnbarx * (1.L - Zeta2) 
              -0.5L * lnbarx2 - lnbarx2 * lnbarx/3.L + (0.5L + Zeta2) * lnbary 
              -lnbarx * lnbary + 0.5L * lnbarx2 * lnbary - Zeta3/3.L);
    rn = r = y/x;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gx00xytableA[n] +
        Gx00xytableALx[n] * lnbarx +
        Gx00xytableALy[n] * lnbary +
        Gx00xytableALx2[n] * lnbarx * (lnbarx - lnbary));
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_Gx00xx (x,qq);
    result += (y-x) * (-2.L - (2.L*PI2*PI)/(27.L*SQRT3) - lnbarx2 +
      lnbarx2 * lnbarx/6.L + 2.L*SQRT3*LS2 +
      lnbarx * (2.5L - SQRT3*LS2) - 4.L*Zeta3/3.L); 
    rn = r = y/x - 1.L;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gx00xytableD[n] + 
        Gx00xytableDL[n] * lnbarx + 
        Gx00xytableDL2[n] * lnbarx2);
    }
  }
  else if (y < 6. * x) {
    result = x*(-22.709596332660382L 
               + 16.50940173340954L * lnbarx  
               - 6.727411277760218L * lnbarx2 
               + 1.1666666666666667L * lnbarx3) +
             (y - 4.L * x) * (-0.28694285870612024L 
               + 1.1137056388801094L * lnbarx 
               - 0.3068528194400547L * lnbarx2 
               + 0.16666666666666667L * lnbarx3);
    rn = r = y/(4.L*x) - 1.L;
    for (n=2; n < 64; n++) {
      rn *= r;
      result += x * rn * (Gx00xytableB[n] +
        Gx00xytableBL[n] * lnbarx +  
        Gx00xytableBL2[n] * lnbarx2);
    }
  }
  else {
    result = TVIL_G0000x (y, qq);
    result += x * (-35.L/6.L + Zeta2 + (4.5L + Zeta2) * lnbarx 
              - 0.5L * lnbarx2 + (3.L - PI2/3.L) * lnbary 
              - 4 * lnbarx * lnbary + 0.5L * lnbarx2 * lnbary 
              + lnbary2 + 0.5L * lnbarx * lnbary2 
              - 0.5L * lnbary3 - 2.L * Zeta3);
    rn = r = 4.L * x/y;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += y * rn * (Gx00xytableC[n] +
        Gx00xytableCLx[n] * lnbarx +
        Gx00xytableCLy[n] * lnbary +
        Gx00xytableCLx2[n] * lnbarx2 +
        Gx00xytableCLy2[n] * lnbary2 +
        Gx00xytableCLxLy[n] * lnbarx * lnbary +
        Gx00xytableCLx3[n] * (lnbarx3 + lnbary3 - lnbarx2 * lnbary 
          - lnbarx * lnbary2));
    }
  }

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gy0xxx (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  TVIL_REAL Gy0xxxtableA[] = 
     {0, 0, 0.37491653687766124, -0.10238425354319386, 
     -0.03288701415043827, -0.01177392244794588, -0.005113618832905143, 
     -0.0026229595992455423, -0.0015224994068369, -0.0009650037381618294, 
     -0.0006516642488469152, -0.000461388328901806, -0.00033887899431915097, 
     -0.00025632152780461544, -0.00019861327987806665, 
     -0.00015704104118820613, -0.0001263255005026564, -0.000103136019233435, 
     -0.00008529864790786708, -0.00007135251049465911, 
     -0.000060290804850748515, -0.000051404126531780006, 
     -0.000044182724907774356, -0.000038253851292799655, 
     -0.00003334062418205625, -0.00002923443546250299, 
     -0.000025776078702505825, -0.0000228426145820179, 
     -0.000020338082461001146, -0.000018186835410886077, 
     -0.000016328693307944418, -0.000014715374331988559, 
     -0.000013307837559967157, -0.000012074283003576208, 
     -0.000010988631564476039, -0.00001002935910160529, 
     -9.178594416872626e-6, -8.421415792003756e-6, -7.74529821900255e-6, 
     -7.139675950964888e-6, -6.595593992521424e-6, -6.105428689093561e-6, 
     -5.662662373600838e-6, -5.261700581669123e-6, -4.8977229971127105e-6, 
     -4.5665612825686416e-6, -4.264598459718847e-6, -3.988685654772766e-6, 
     -3.7360729086329755e-6, -3.5043514338315985e-6, 
     -3.291405230811172e-6, -3.0953703907051897e-6, -2.91460073754021e-6, 
     -2.7476387200941714e-6, -2.593190667903134e-6, 
     -2.4501056888260184e-6, -2.317357616117158e-6, 
     -2.1940295180147826e-6, -2.0793003677618306e-6, 
     -1.972433540877833e-6, -1.8727668626332043e-6, 
     -1.7797039745792228e-6, -1.6927068266593564e-6, 
     -1.6112891324542078e-6, -1.535010650752003e-6, 
     -1.4634721778937788e-6, -1.3963111530218765e-6, 
     -1.3331977931090976e-6, -1.2738316869860043e-6, 
     -1.2179387879382527e-6, -1.1652687531580489e-6, 
     -1.1155925856839574e-6, -1.068700540680377e-6, 
     -1.0244002631799976e-6, -9.825151288940043e-7, -9.428827635133313e-7, 
     -9.05353719185416e-7, -8.697902896422744e-7, -8.360654478501905e-7, 
     -8.040618921096409e-7, -7.73671188307124e-7, -7.447929975509034e-7, 
     -7.173343797461178e-7, -6.912091648114e-7, -6.663373842345251e-7, 
     -6.426447565302008e-7, -6.200622209171601e-7, -5.98525514189725e-7, 
     -5.779747863341663e-7, -5.583542509437416e-7, -5.396118669278676e-7, 
     -5.21699048398701e-7, -5.045703999595337e-7, -4.881834749199071e-7, 
     -4.7249855422744716e-7, -4.574784441406185e-7, -4.430882908737762e-7, 
     -4.292954106294245e-7, -4.1606913359539086e-7, -4.033806606292127e-7, 
     -3.9120293148062063e-7};
 
  TVIL_REAL Gy0xxxtableALx[] = 
     {0, 0, 1.0277777777777777, 0.07333333333333333, 
     0.014529478458049886, 0.004937011841773747, 0.001953325254191055, 
     0.0006887990433611479, 0.0000899220644059139, -0.00020228900894083462, 
     -0.0003421176315841565, -0.00040323300527444144, -0.0004228700268925939, 
     -0.00042057953443265094, -0.000406918483548199, -0.00038770078205996756, 
     -0.0003661632049613447, -0.0003441075895037328, -0.00032252142810637027, 
     -0.00030192387418512354, -0.0002825629178627086, 
     -0.00026452977623831543, -0.0002478261762944148, 
     -0.00023240430126674006, -0.00021819060882096543, 
     -0.00020510000476283569, -0.00019304418987907873, 
     -0.00018193646228451194, -0.0001716943575072979, 
     -0.00016224097222504506, -0.00015350549347661739, 
     -0.00014542325692667662, -0.0001379355352297839, 
     -0.00013098918116969096, -0.0001245362023445473, 
     -0.00011853331399610918, -0.000112941497548651, -0.00010772558043842487, 
     -0.00010285384531150497, -0.00009829767202464842, 
     -0.00009403121306756966, -0.00009003110137423707, 
     -0.00008627618857987838, -0.00008274731133475369, 
     -0.00007942708312810287, -0.00007629970909161863, 
     -0.0000733508213678557, -0.00007056733279831763, -0.0000679373068790825, 
     -0.00006544984213056861, -0.00006309496922156943, 
     -0.00006086355936990785, -0.00005874724270989937, 
     -0.00005673833546909569, -0.00005482977493348345, 
     -0.0000530150613021022, -0.00005128820563995013, -0.0000496436832332682, 
     -0.00004807639173508586, -0.00004658161356249765, 
     -0.00004515498207167853, -0.000043792451093201004, 
     -0.000042490267459757265, -0.00004124494620177944, 
     -0.000040053248124460645, -0.00003891215951298766, 
     -0.00003781887374200006, -0.000036770774590912525, 
     -0.000035765421089233544, -0.00003480053373578305, 
     -0.0000338739819530999, -0.000032983772653639345, 
     -0.00003212803980785305, -0.00003130503491614769, 
     -0.000030513118297231495, -0.000029750751114652952, 
     -0.000029016488071564035, -0.000028308970711030312, 
     -0.000027626921265678405, -0.000026969137006214803, 
     -0.000026334485043457123, -0.000025721897543064478, 
     -0.000025130367316204066, -0.000024558943753004366, 
     -0.000024006729068872175, -0.000023472874836635322, 
     -0.000022956578780054738, -0.00002245708180656258, 
     -0.000021973665259157357, -0.00002150564836924961, 
     -0.000021052385893925183, -0.00002061326592259891, 
     -0.000020187707839387495, -0.000019775160428752314, 
     -0.000019375100113065783, -0.000018987029311750773, 
     -0.000018610474912542712, -0.000018244986846238814, 
     -0.000017890136757036335, -0.000017545516761230695, 
     -0.0000172107382876508};
 
  TVIL_REAL Gy0xxxtableALy[] = 
     {0, 0, 0.16666666666666666, 0.1, 0.038492063492063494, 
     0.018253968253968255, 0.01038961038961039, 0.006703389203389204, 
     0.0046976634476634475, 0.0034825060560354677, 0.0026879829140996764, 
     0.0021388097012820587, 0.0017428969075268326, 0.0014478660754516635, 
     0.0012220378413074027, 0.0010452972455230946, 0.0009043576699895455, 
     0.0007901499817060155, 0.0006963092885377608, 0.0006182605250214372, 
     0.0005526460204116899, 0.0004969560801061106, 0.0004492841699631982, 
     0.00040816083550481076, 0.00037243866595198334, 0.000341211115873985, 
     0.0003137542490506853, 0.0002894842906300632, 0.00026792626590851893, 
     0.0002486905342139311, 0.00023145502445825304, 0.00021595164171104477, 
     0.00020195576155652688, 0.00018927803562331812, 0.00017775794477673326, 
     0.00016725868649805113, 0.00015766308988929097, 0.00014887032879038042, 
     0.00014079325960788568, 0.00013335625172418273, 0.00012649340899130402, 
     0.00012014710375377304, 0.00011426676216406121, 0.0001088078527317704, 
     0.00010373104014753264, 0.00009900147421762618, 0.00009458818980119136, 
     0.00009046359837623783, 0.00008660305558387601, 0.00008298449204495612, 
     0.0000795880970849597, 0.0000763960468747137, 0.00007339226999799292, 
     0.00007056224467050031, 0.0000678928228184661, 0.00006537207702612129, 
     0.00006298916701623618, 0.00006073422286555695, 0.00005859824260001859, 
     0.00005657300218105923, 0.00005465097619852586, 0.000052825267838998135, 
     0.00005108954691005216, 0.00004943799487845132, 0.0000478652560294745, 
     0.00004636639398044328, 0.000044936852887951234, 0.000043572422778575, 
     0.00004226920850961755, 0.000041023601931889095, 0.00003983225688247934, 
     0.00003869206668341155, 0.000037600143863240845, 0.00003655380185409959, 
     0.000035550538447268486, 0.000034588020816787525, 
     0.00003366407194352464, 0.000032776658292003495, 0.00003192387860958879, 
     0.000031103953732702, 0.000030315217297903528, 0.000029556107267191897, 
     0.00002882515818696064, 0.000028120994108911484, 
     0.000027442322109010765, 0.00002678792634743572, 
     0.000026156662618508516, 0.00002554745334496239, 
     0.000024959282975614982, 0.000024391193749716433, 
     0.00002384228179496025, 0.00002331169352945143, 0.000022798622340868896, 
     0.00002230230551868152, 0.00002182202141761662, 0.000021357086832670603, 
     0.00002090685456782126, 0.000020470711182276415, 0.00002004807489959562, 
     0.000019638393666370167, 0.00001924114334835889};
 
  TVIL_REAL Gy0xxxtableALx2[] = 
     {0, 0, 0.6666666666666666, 0.18333333333333332, 
     0.08571428571428572, 0.0503968253968254, 0.033405483405483404, 
     0.023823398823398824, 0.01785991785991786, 0.013889460212989625, 
     0.01111123138986916, 0.009090934864928672, 0.007575763178805311, 
     0.006410257642926912, 0.005494505768432273, 0.0047619048233021434, 
     0.004166666680530591, 0.003676470591386186, 0.0032679738569293543, 
     0.0029239766083525866, 0.0026315789474066023, 0.002380952380961228, 
     0.002164502164504222, 0.001976284584980717, 0.001811594202898663, 
     0.001666666666666693, 0.0015384615384615447, 0.001424501424501426, 
     0.0013227513227513231, 0.001231527093596059, 0.001149425287356322, 
     0.001075268817204301, 0.0010080645161290322, 0.000946969696969697, 
     0.00089126559714795, 0.0008403361344537816, 0.0007936507936507937, 
     0.0007507507507507506, 0.0007112375533428164, 0.0006747638326585695, 
     0.000641025641025641, 0.0006097560975609757, 0.0005807200929152149, 
     0.0005537098560354374, 0.0005285412262156448, 0.0005050505050505052, 
     0.00048309178743961357, 0.00046253469010175765, 0.0004432624113475177, 
     0.00042517006802721087, 0.00040816326530612246, 0.0003921568627450981, 
     0.0003770739064856712, 0.000362844702467344, 0.00034940600978336826, 
     0.0003367003367003367, 0.0003246753246753247, 0.0003132832080200501, 
     0.00030248033877797946, 0.00029222676797194627, 0.0002824858757062147, 
     0.000273224043715847, 0.00026441036488630354, 0.0002560163850486431, 
     0.00024801587301587306, 0.00024038461538461537, 0.00023310023310023313, 
     0.0002261420171867933, 0.00021949078138718174, 0.00021312872975277065, 
     0.00020703933747412008, 0.00020120724346076458, 0.00019561815336463224, 
     0.00019025875190258754, 0.00018511662347278784, 0.00018018018018018016, 
     0.00017543859649122808, 0.00017088174982911826, 0.0001665001665001665, 
     0.0001622849724115547, 0.0001582278481012658, 0.00015432098765432096, 
     0.00015055706112616685, 0.00014692918013517483, 0.0001434308663224326, 
     0.00014005602240896358, 0.00013679890560875513, 0.00013365410318096765, 
     0.00013061650992685474, 0.00012768130745658836, 0.0001248439450686642, 
     0.0001221001221001221, 0.00011944577161968467, 0.00011687704534829359, 
     0.00011439029970258523, 0.00011198208286674131, 0.00010964912280701753, 
     0.00010738831615120275, 0.0001051967178624027, 0.00010307153164296021, 
     0.00010101010101010101};
 
  TVIL_REAL Gy0xxxtableB[] = 
     {0, -1.2707173477574996, 4.2899882125401, -0.2717647743267166, 
     0.031104313483596633, 0.0012331731989206492, -0.00601535592610141, 
     0.0058674860209448915, -0.004885057095344924, 0.003920516939015157, 
     -0.0031310165703138182, 0.0025147004597895913, -0.002038586100459073, 
     0.0016697619205853138, -0.0013817784784545552, 0.0011546934953737503, 
     -0.0009737688703708533, 0.000828145962918614, -0.0007097894416453565, 
     0.0006127069355798755, -0.0005323881641674176, 0.00046540509553481385, 
     -0.0004091266611375146, 0.0003615141220655961, -0.0003209731724110009, 
     0.0002862461208313366, -0.0002563325725330556, 0.00023043054128438664, 
     -0.0002078923331329164, 0.00018819120541782624, -0.00017089595542753676, 
     0.00015565139521957677, -0.00014216323256439637, 0.0001301862769511206, 
     -0.00011951517444987257, 0.00010997708028789745, 
     -0.00010142582682176321, 0.00009373725345924277, 
     -0.00008680544534455117, 0.00008053968723134403, 
     -0.00007486198356162588, 0.00006970502936042496, 
     -0.00006501054202932168, 0.000060727883562855364, 
     -0.00005681291764054695, 0.00005322705757899887, 
     -0.000049936470086958845, 0.0000469114067636553, 
     -0.000044125640775120215, 0.000041555990479245976, 
     -0.00003918191520882028, 0.000036985171161275954, 
     -0.00003494951753629938, 0.00003306046482461792, 
     -0.00003130505857357298, 0.0000296716931076574, 
     -0.000028149950619826716, 0.00002673046181502239, 
     -0.000025404784914785558, 0.000024165300347828307, 
     -0.00002300511887719588, 0.000021918001267119167, 
     -0.00002089828788536304, 0.000019940836880697234, 
     -0.000019040969778817814};
 
  TVIL_REAL Gy0xxxtableBL[] = 
     {0, 2.2123242385872737, 4.060236592639416, -0.4995073020773835, 
     0.08741305993782222, 0.0006170726148297945, -0.02298870518272489, 
     0.02769025942853154, -0.02703530367850815, 0.024797174655342036, 
     -0.022244105506497136, 0.019809430516758653, -0.017626167577297958, 
     0.015716012494447984, -0.014060666113579368, 0.01262969771011524, 
     -0.011391407207517856, 0.010316797920738807, -0.009380726222939728, 
     0.00856192128886235, -0.00784259235992435, 0.007207926138868892, 
     -0.0066455968668046594, 0.006145333071467363, -0.005698551264358365, 
     0.005298053189891405, -0.00493777846980592, 0.004612603586378938, 
     -0.004318178803856654, 0.0040507958008255684, -0.0038072800258248662, 
     0.003584902915292787, -0.003381310070778909, 0.0031944622791328925, 
     -0.003022586892967638, 0.0028641375943152525, -0.00271776096423082, 
     0.002582268598274595, -0.002456613758056392, 0.002339871746841027, 
     -0.002231223353931, 0.002129940838415223, -0.002035376020273816, 
     0.001946950129877223, -0.0018641451243865959, 0.0017864962396743067, 
     -0.001713585578272614, 0.0016450365785658505, -0.0015805092209575378, 
     0.0015196958738670219, -0.0014623176721215714, 0.0014081213639656198, 
     -0.0013568765434683883, 0.0013083732328595943, -0.0012624197497643763, 
     0.0012188408381916815, -0.0011774760041589616, 0.0011381780714145862, 
     -0.0011008118381141685, 0.001065252989064902, -0.0010313870079698972, 
     0.0009991082988562994, -0.0009683193493401632, 0.0009389300248585641, 
     -0.0009108569065574557};
 
  TVIL_REAL Gy0xxxtableBL2[] = 
     {0, 1.5451774444795623, 2., -0.6666666666666666, 
     0.3333333333333333, -0.2, 0.13333333333333333, -0.09523809523809523, 
     0.07142857142857142, -0.05555555555555555, 0.044444444444444446, 
     -0.03636363636363636, 0.030303030303030304, -0.02564102564102564, 
     0.02197802197802198, -0.01904761904761905, 0.016666666666666666, 
     -0.014705882352941176, 0.013071895424836602, -0.011695906432748537, 
     0.010526315789473684, -0.009523809523809525, 0.008658008658008658, 
     -0.007905138339920948, 0.007246376811594203, -0.006666666666666667, 
     0.006153846153846154, -0.005698005698005698, 0.005291005291005291, 
     -0.0049261083743842365, 0.004597701149425287, -0.004301075268817204, 
     0.004032258064516129, -0.003787878787878788, 0.0035650623885918, 
     -0.0033613445378151263, 0.0031746031746031746, -0.003003003003003003, 
     0.002844950213371266, -0.002699055330634278, 0.002564102564102564, 
     -0.0024390243902439024, 0.0023228803716608595, -0.0022148394241417496, 
     0.0021141649048625794, -0.00202020202020202, 0.001932367149758454, 
     -0.0018501387604070306, 0.0017730496453900709, -0.0017006802721088435, 
     0.0016326530612244899, -0.001568627450980392, 0.0015082956259426848, 
     -0.001451378809869376, 0.001397624039133473, -0.0013468013468013469, 
     0.0012987012987012987, -0.0012531328320802004, 0.0012099213551119178, 
     -0.0011689070718877848, 0.0011299435028248588, -0.001092896174863388, 
     0.0010576414595452142, -0.0010240655401945725, 0.000992063492063492};
 
  TVIL_REAL Gy0xxxtableC[] = 
     {0, -1.5402709982840332, 0.5797290576318396, 0.1528029172572363, 
     0.12389219642803596, 0.09729510854244712, 0.0783483706301704, 
     0.06465396396567315, 0.0544506945265942, 0.046633881335887944, 
     0.04050081844271059, 0.03559012558738436, 0.031589252068743745, 
     0.028280416330005526, 0.025508034816332095, 0.023158477417509364, 
     0.021147114469678097, 0.019409807725853077, 0.01789718579583179, 
     0.016570708981609096, 0.015399910872191402, 0.014360430248854698, 
     0.013432584041435403, 0.012600317245656929, 0.01185041973354652, 
     0.01117193484016983, 0.010555707640154774, 0.009994036261727384, 
     0.009480400093099677, 0.00900924599384703, 0.008575818705600173, 
     0.008176025259616321, 0.007806325764014144, 0.007463644828847217, 
     0.00714529926178662, 0.006848938684542237, 0.006572496480021065, 
     0.006314149052672659, 0.006072281819246963, 0.005845460679943185, 
     0.005632407976455588, 0.005431982142550697, 0.0052431604083961565, 
     0.005065024042182647, 0.004896745709318357, 0.004737578606412635, 
     0.004586847088783572, 0.00444393855966605, 0.004308296429227657, 
     0.0041794139839007125, 0.004056829032947396, 0.003940119220792476, 
     0.003828897911426572, 0.003722810565845473, 0.0036215315456366447, 
     0.003524761285921596, 0.0034322237892870713, 0.003343664399390207, 
     0.0032588478188455626, 0.0031775563409918526, 0.0030995882693529257, 
     0.003024756502181329, 0.002952887262510236, 0.0028838189567282017, 
     0.0028174011469032016, 0.0027534936239774557, 0.002691965570581969, 
     0.0026326948036207725, 0.002575567087983751, 0.0025204755137924373, 
     0.0024673199304892828, 0.0024160064318679295, 0.002366446886826988, 
     0.0023185585112271614, 0.002272263476753505, 0.0022274885531415266, 
     0.0021841647805265784, 0.0021422271690280507, 0.002101614422989784, 
     0.002062268687571285, 0.0020241353156255936, 0.001987162653013024, 
     0.001951301840689033, 0.0019165066320721816, 0.0018827332243471647, 
     0.001849940102490503, 0.0018180878949246332, 0.0017871392398115839, 
     0.0017570586610916312, 0.0017278124534566232, 0.0016993685755231714, 
     0.0016716965505386534, 0.0016447673740137927, 0.0016185534277302865, 
     0.0015930283996211957, 0.0015681672090661855, 0.0015439459371837535, 
     0.0015203417617387488, 0.0014973328963161915, 0.0014748985334420118, 
     0.0014530187913581482};
 
  TVIL_REAL Gy0xxxtableCLx[] = 
     {0, 3.1087005501361697, 0.06000824164397173, 
     0.21744791666666666, 0.14612470191114066, 0.10784155303961288, 
     0.08366220119481751, 0.06720613422061102, 0.05544502674797983, 
     0.04671805363395903, 0.04004327327991324, 0.034808846441872814, 
     0.03061714291074256, 0.027200407274545778, 0.024372761307694852, 
     0.022001715959509366, 0.019990637319367118, 0.01826760400626158, 
     0.016778122660098135, 0.015480243958641643, 0.014341213357983735, 
     0.013335127276604216, 0.012441262648130618, 0.01164286652998614, 
     0.010926265777480666, 0.010280203100547738, 0.009695335680237433, 
     0.009163852146527604, 0.008679176844506361, 0.008235739237727038, 
     0.007828792453152619, 0.007454269278424958, 0.007108666973799127, 
     0.006788954449624639, 0.006492496947484662, 0.006216994526345308, 
     0.005960431515982539, 0.005721034743016691, 0.00549723881940445, 
     0.005287657151298756, 0.005091057607946505, 0.004906342007567377, 
     0.004732528745865204, 0.004568738024682876, 0.004414179242014432, 
     0.004268140186630592, 0.004129977745847018, 0.0039991098871756635, 
     0.0038750087165769593, 0.0037571944499457588, 0.0036452301619939002, 
     0.003538717199139496, 0.0034372911613945924, 0.00334061837335726, 
     0.0032483927768912025, 0.0031603331884151207, 0.0030761808723227748, 
     0.0029956973892311975, 0.0029186626837642343, 0.00284487338162762, 
     0.0027741412699870873, 0.002706291938758119, 0.0026411635634656662, 
     0.002578605812924999, 0.0025184788672053477, 0.002460652533227441, 
     0.002405005446965238, 0.002351424352613145, 0.002299803450277856, 
     0.0022500438047878095, 0.002202052809107665, 0.002155743696620557, 
     0.0021110350972145665, 0.0020678506326962634, 0.002026118547565799, 
     0.001985771371635102, 0.0019467456113622735, 0.0019089814671187292, 
     0.0018724225739074783, 0.0018370157633166406, 0.0018027108447266423, 
     0.0017694604039964743, 0.0017372196180375301, 0.001705946083845764, 
     0.0016755996607068948, 0.0016461423244173495, 0.0016175380324775141, 
     0.0015897525993153795, 0.0015627535806892587, 0.0015365101664992144, 
     0.0015109930813093043, 0.0014861744919476636, 0.0014620279216096964, 
     0.0014385281699419656, 0.0014156512386314314, 0.001393374262067047, 
     0.001371675442678918, 0.0013505339905946951, 0.0013299300672840067, 
     0.0013098447328898958, 0.0012902598969717228};
 
  TVIL_REAL Gy0xxxtableCLy[] = 
     {0, -0.9674011002723395, -0.0625, -0.24343337917801414, 
     -0.1669500343835106, -0.1243661716209663, -0.09709726398065897, 
     -0.07838048021697297, -0.06491669435027317, -0.054873314099423774, 
     -0.047157663266479015, -0.04108430707686611, -0.03620522148550143, 
     -0.032217203776380585, -0.028908840182962046, -0.026128853832153163, 
     -0.02376652605088853, -0.021739198497231944, -0.019984069479079804, 
     -0.018452673476289556, -0.017107082752896297, -0.015917241154598166, 
     -0.014859058613830401, -0.013913026927905001, -0.013063199184618447, 
     -0.012296427045618431, -0.011601783623489735, -0.01097012178406288, 
     -0.010393732522317588, -0.009866078156221066, -0.009381582064474411, 
     -0.008935461588726157, -0.008523594196211029, -0.008142409495925141, 
     -0.007788801515693888, -0.0074600569793155935, -0.0071537963101974186, 
     -0.00686792482641068, -0.006600592149310229, -0.0063501582717112055, 
     -0.006115165056493302, -0.005894312187326245, -0.005686436788192145, 
     -0.005490496080941094, -0.005305552570224554, -0.0051307613402667655, 
     -0.004965359123680306, -0.004808654863174989, -0.00466002153580835, 
     -0.004518889048885439, -0.004384738048671727, -0.004257094509240626, 
     -0.004135524990212922, -0.004019632469783723, -0.003909052674002939, 
     -0.003803450835357108, -0.0037025188237547165, -0.0036059726014137433, 
     -0.0035135499601856154, -0.0034250085057640264, -0.003340123858214237, 
     -0.0032586880424765536, -0.0031805080460756653, -0.003105404524311024, 
     -0.0030332106357993886, -0.0029637709934606255, -0.0028969407179411104, 
     -0.0028325845821048647, -0.0027705762366317605, -0.0027107975079789684, 
     -0.0026531377610148664, -0.00259749331954796, -0.0025437669387671337, 
     -0.0024918673243008445, -0.0024417086932061165, -0.002393210372725607, 
     -0.0023462964331129993, -0.002300895351232409, -0.0022569397019938636, 
     -0.0022143658750007895, -0.002173113814062274, -0.0021331267774674827, 
     -0.002094351117136075, -0.00205673607495031, -0.0020202335947448608, 
     -0.001984798148581726, -0.001950386576072432, -0.0019169579356298737, 
     -0.001884473366639413, -0.0018528959616347508, -0.0018221906476499198, 
     -0.0017923240759956825, -0.0017632645197776463, -0.0017349817785354347, 
     -0.0017074470894380494, -0.0016806330445208004, -0.0016545135134944928, 
     -0.00162906357169844, -0.0016042594328058355, -0.001580078385923429, 
     -0.0015564987367577303};
 
  TVIL_REAL Gy0xxxtableCLx2[] = 
     {0, 0., 0.203125, 0.03515625, 0.018391927083333332, 
     0.011564127604166667, 0.008011881510416667, 0.005925351097470238, 
     0.004592123485746838, 0.0036849952879406157, 0.0030372430407811725, 
     0.002556787846236346, 0.002189370361929504, 0.001901278836419625, 
     0.0016706308137424079, 0.0014826923514965362, 0.001327230088126608, 
     0.0011969449928890294, 0.0010865097294870698, 0.0009919570218921679, 
     0.0009102795899847089, 0.0008391616935925569, 0.0007767948567702899, 
     0.0007217487871555567, 0.0006728792975306342, 0.000629261533909243, 
     0.0005901408271069054, 0.0005548960208392799, 0.0005230117662466129, 
     0.0004940573496291556, 0.0004676703411982945, 0.000443543843249448, 
     0.00042141645498566273, 0.0004010643084665907, 0.0003822946984159003, 
     0.0003649409493801855, 0.00034885825137035884, 0.0003339202593810511, 
     0.0003200162997694488, 0.0003070490620345486, 0.0002949326813400253, 
     0.0002835911374900122, 0.000272956911661607, 0.0002629698542255983, 
     0.00025357622632746647, 0.000244727885201862, 0.0002363815889361804, 
     0.00022849840094197138, 0.00022104317800739195, 0.00021398412869496277, 
     0.00020729243117312553, 0.0002009419014477707, 0.00019490870448389994, 
     0.0001891711019500483, 0.00018370923133536747, 0.00017850491202559714, 
     0.00017354147461442262, 0.00016880361029860045, 0.0001642772376807566, 
     0.00015994938470054924, 0.00015580808374708922, 0.00015184227828454855, 
     0.0001480417395579962, 0.00014439699214520356, 0.00014089924728857852, 
     0.00013754034308454356, 0.00013431269072968304, 0.00013120922612725166, 
     0.00012822336624696243, 0.00012534896970769184, 0.00012258030111878717, 
     0.00011991199877265244, 0.00011733904533057913, 0.00011485674118650605, 
     0.0001124606802304989, 0.00011014672776603168, 0.00010791100036331557, 
     0.00010574984745552761, 0.00010365983450633356, 0.00010163772759599072, 
     0.000099680479289916, 0.0000977852156682125, 0.000095949224407526, 
     0.0000941699438179766, 0.00009244495274796778, 0.00009077196127858644, 
     0.0000891488021372121, 0.00008757342276697754, 0.00008604387799497263, 
     0.00008455832324765229, 0.00008311500826687813, 0.00008171227128446383, 
     0.00008034853361706573, 0.00007902229464681883, 0.00007773212715630992, 
     0.00007647667298934569, 0.00007525463901155097, 0.00007406479334715165, 
     0.00007290596187038795, 0.00007177702493188976, 0.00007067691430204935};
 
  TVIL_REAL Gy0xxxtableCLxLy[] = 
      {0, -1.5, -0.5, -0.125, -0.07552083333333333, 
     -0.052408854166666664, -0.03909505208333333, -0.030600992838541667, 
     -0.024795604887462797, -0.020621726626441593, -0.01750207779899476, 
     -0.015097813568417988, -0.013198374054820678, -0.011666740439455918, 
     -0.010410296487079132, -0.009364416304810759, -0.008482771230474036, 
     -0.007731370032829362, -0.00708476586553043, -0.006523568947245923, 
     -0.00603277226167429, -0.005600598231813763, -0.005217687811650452, 
     -0.0048765197828325125, -0.004570987985450385, -0.004296088899178131, 
     -0.004047687615245613, -0.003822340342191628, -0.0036171582489766636, 
     -0.0034297019192237686, -0.0032578987397880546, -0.0030999776585459884, 
     -0.002954417229024162, -0.0028199039140444624, -0.002695298379595611, 
     -0.002579608062573259, -0.0024719647022928247, -0.0023716058273648205, 
     -0.002277859415602676, -0.0021901311155140455, -0.0021078935481324062, 
     -0.0020306773079172297, -0.001958063358763097, -0.0018896765813557178, 
     -0.0018251802752883189, -0.0017642714565496466, -0.001706676820496804, 
     -0.0016521492639546282, -0.0016004648789473698, -0.0015514203457692613, 
     -0.0015048306654087094, -0.0014605271813528061, -0.0014183558489790252, 
     -0.0013781757174527766, -0.0013398575945788678, -0.0013032828696279426, 
     -0.0012683424729551728, -0.0012349359543911847, -0.00120297066502921, 
     -0.0011723610292502392, -0.0011430278956941428, -0.0011148979574599658, 
     -0.0010879032331521875, -0.001061980601522003, -0.001037071383416708, 
     -0.0010131209655732363, -0.0009900784614962827, -0.0009678964052658762, 
     -0.0009465304746391356, -0.000925939240259202, -0.0009060839381716717, 
     -0.0008869282631843433, -0.0008684381808972541, -0.0008505817564832193, 
     -0.000833328998519801, -0.0008166517163663489, -0.0008005233897483682, 
     -0.0007849190493592676, -0.0007698151674193089, -0.0007551895572457459, 
     -0.0007410212809887263, -0.0007272905647763154, -0.0007139787205904944, 
     -0.0007010680742654824, -0.000688541899061363, -0.0006763843543207437, 
     -0.00066458042876486, -0.0006531158880289036, -0.0006419772260750454, 
     -0.0006311516201561643, -0.0006206268890342064, -0.000610391454184763, 
     -0.0006004343037442785, -0.0005907449589785707, -0.000581313443071374, 
     -0.000572130252049638, -0.0005631863276785482, -0.0005544730321738827, 
     -0.0005459821245925444, -0.0005377057387740596, -0.00052963636271666};
 
  TVIL_REAL Gy0xxxtableCLy2[] = 
     {0, 0.375, 0.296875, 0.08984375, 0.05712890625, 
     0.0408447265625, 0.031083170572916666, 0.024675641741071428, 
     0.02020348140171596, 0.016936731338500977, 0.014464834758213588, 
     0.012541025722181642, 0.011009003692891175, 0.009765461603036294, 
     0.008739665673336724, 0.007881723953314223, 0.007155541142347429, 
     0.006534425039940333, 0.00599825613604336, 0.005531611925353755, 
     0.005122492671689582, 0.004761436538221206, 0.004440892954880162, 
     0.004154770995676957, 0.0038981086879197515, 0.003666827365268888, 
     0.0034575467881387072, 0.0032674443213523475, 0.0030941464827300503, 
     0.002935644569594613, 0.0027902283985897602, 0.00265643381529654, 
     0.002533000774038499, 0.0024188396055778716, 0.002313003681179711, 
     0.002214667113193073, 0.002123106450922466, 0.002037685567983769, 
     0.0019578431158332275, 0.001883082053479497, 0.0018129608667923809, 
     0.0017470861704272176, 0.0016851064471014897, 0.0016267067271301195, 
     0.0015716040489608524, 0.0015195435713477846, 0.0014702952315606237, 
     0.001423650863012657, 0.0013794217009399778, 0.0013374362170742984, 
     0.0012975382342355838, 0.0012595852799050355, 0.0012234471444951254, 
     0.0011890046155027284, 0.0011561483632435002, 0.0011247779576023453, 
     0.0010948009983407503, 0.0010661323440925843, 0.0010386934273484533, 
     0.00101241164454969, 0.0009872198119470533, 0.0009630556791754174, 
     0.0009398614935941913, 0.0009175836093767993, 0.0008961721361281296, 
     0.0008755806224886928, 0.0008557657707665998, 0.0008366871791386244, 
     0.0008183071083921732, 0.0008005902705515102, 0.0007835036370528846, 
     0.0007670162644116908, 0.000751099135566675, 0.0007357250152967131, 
     0.0007208683182893021, 0.0007065049886003171, 0.0006926123893850526, 
     0.0006791692019037398, 0.0006661553329129754, 0.0006535518296497554, 
     0.0006413408016988103, 0.0006295053491081027, 0.0006180294961829685, 
     0.0006068981304475058, 0.0005960969463133951, 0.0005856123930421573, 
     0.0005754316266276478, 0.000565542465261926, 0.0005559333480800727, 
     0.000546593296908512, 0.0005375118807673283, 0.0005286791829002991, 
     0.0005200857701272128, 0.0005117226643317519, 0.0005035813159150642, 
     0.0004956535790602923, 0.0004879316886669972, 0.0004804082388267311, 
     0.0004730761627221563, 0.0004659287138421698, 0.00045895944841461067};
 
  TVIL_REAL Gy0xxxtableCLx3[] = 
     {0, 0., -0.0625, -0.020833333333333332, -0.01171875, 
     -0.0078125, -0.005696614583333333, -0.00439453125, -0.0035247802734375, 
     -0.0029093424479166665, -0.0024547576904296875, -0.0021076202392578125, 
     -0.0018353859583536785, -0.0016171932220458984, -0.001439109444618225, 
     -0.0012915084759394329, -0.0011675467249006033, -0.0010622385889291763, 
     -0.0009718745423015207, -0.0008936431549955159, -0.0008253787473222474, 
     -0.0007653888133063447, -0.000712333452383973, -0.0006651395176504593, 
     -0.0006229384308298336, -0.0005850204393880176, -0.0005508004938148403, 
     -0.0005197924660148937, -0.000491589440729745, -0.0004658484866174595, 
     -0.0004422787715207428, -0.00042063220205810353, 
     -0.00040069598831472467, -0.00038228669070886734, 
     -0.00036524541819105475, -0.00034943392822607403, 
     -0.00033473143859891484, -0.0003210320052045191, 
     -0.00030824235295039175, -0.00029628007175481173, 
     -0.00028507210851408697, -0.00027455350038254776, 
     -0.00026466630587472387, -0.00025535869897498885, 
     -0.0002465841982255777, -0.00023830100810430505, 
     -0.00023047145423131282, -0.00022306149731040063, 
     -0.00021604031340502345, -0.00020937993031698321, 
     -0.00020305491158865768, -0.00019704208107342732, 
     -0.00019132028218071817, -0.00018587016685407546, 
     -0.00018067401012400246, -0.0001757155467243729, 
     -0.00017097982679777356, -0.00016645308816166026, 
     -0.0001621226429801146, -0.00015797677699846434, 
     -0.00015400465976071558, -0.0001501962644512675, 
     -0.00014654229618975146, -0.00014303412776678576, 
     -0.00013966374194365207, -0.0001364236795542389, -0.0001333069927462408, 
     -0.00013030720278317957, -0.00012741826190151148, 
     -0.00012463451877971768, -0.00012195068723036453, 
     -0.00011936181777293282, -0.00011686327178582084, 
     -0.00011445069797121871, -0.00011212001089729281, 
     -0.00010986737140894537, -0.00010768916872187258, 
     -0.0001055820040351935, -0.00010354267551595774, 
     -0.00010156816452469502, -0.00009965562296513546, 
     -0.00009780236165354753, -0.00009600583961402734, 
     -0.00009426365421570646, -0.00009257353207638593, 
     -0.00009093332066468527, -0.00008934098053953539, 
     -0.00008779457817184633, -0.00008629227929853052, 
     -0.00008483234276384016, -0.00008341311480724814, 
     -0.00008203302376092497, -0.00008069057512329148, 
     -0.00007938434697820215, -0.00007811298573207809, 
     -0.00007687520214379388, -0.00007566976762436271, 
     -0.00007449551078548221, -0.00007335131421782679, 
     -0.00007223611148161908, -0.00007114888429350286};
 
  TVIL_REAL Gy0xxxtableCLx2Ly[] = 
     {0, 0., 0.125, 0.03125, 0.015625, 0.009765625, 0.0068359375, 
     0.005126953125, 0.0040283203125, 0.00327301025390625, 
     0.002727508544921875, 0.0023183822631835938, 0.002002239227294922, 
     0.0017519593238830566, 0.0015498101711273193, 0.001383759081363678, 
     0.0012453831732273102, 0.0011286285007372499, 0.0010290436330251396, 
     0.0009432899969397113, 0.0008688197340234183, 0.0008036582539716619, 
     0.0007462540929736861, 0.0006953731320891166, 0.0006500227104311307, 
     0.000609396291029185, 0.0005728325135674339, 0.0005397844839385435, 
     0.0005097964570530689, 0.00048248593256808303, 0.0004575297636421477, 
     0.0004346532754600403, 0.00041362166535713514, 0.0003942331497935194, 
     0.0003763134611665413, 0.0003597113967033115, 0.0003442951939874553, 
     0.0003299495609046447, 0.0003165732273544564, 0.00030407691574835943, 
     0.0002923816497580379, 0.0002814173378921115, 0.00027112158162776595, 
     0.0002614386679982029, 0.0002523187144633818, 0.00024371694010667563, 
     0.00023559304210311977, 0.00022791066029540934, 0.00022063691581789628, 
     0.00021374201219858703, 0.0002071988893761813, 0.00020098292269489585, 
     0.00019507166026269305, 0.00018944459313973076, 0.0001840829537112478, 
     0.0001789695383303798, 0.00017408855092136946, 0.00016942546473597563, 
     0.00016496689987450258, 0.0001607005145329206, 0.0001566149082312362, 
     0.0001526995355254553, 0.0001489446289141736, 0.00014534112982754038, 
     0.00014188062673640845, 0.00013855529954727387, 0.0001353578695577214, 
     0.00013228155434050047, 0.0001293200270045191, 0.00012646737935000766, 
     0.0001237180884945727, 0.00012106698659826044, 0.00011850923336026903, 
     0.00011604029099859675, 0.0001136559014575297, 0.00011135206561717436, 
     0.00010912502430483088, 0.00010697124093039342, 0.00010488738558759355, 
     0.00010287032048013983, 0.00010091708654697261, 0.00009902489117421688, 
     0.00009719109689321287, 0.00009541321097443458, 0.00009368887583634239, 
     0.00009201586019640771, 0.00009039205089882404, 0.00008881544535989107, 
     0.00008728414457782397, 0.0000857963466588838, 0.00008435034081631834, 
     0.00008294450180271303, 0.00008157728474003095, 0.00008024722031492175, 
     0.00007895291030984237, 0.00007769302344319594, 0.00007646629149409284, 
     0.00007527150568949765, 0.00007410751333347448, 0.00007297321466000294, 
     0.00007186755989242713};
 
  TVIL_REAL Gy0xxxtableCLxLy2[] = 
     {0, 0.375, -0.0625, 0., 0.00390625, 0.00390625, 
     0.00341796875, 0.0029296875, 0.0025177001953125, 0.0021820068359375, 
     0.0019092559814453125, 0.00168609619140625, 0.0015016794204711914, 
     0.001347661018371582, 0.0012177079916000366, 0.0011070072650909424, 
     0.0010118738282471895, 0.0009294587653130293, 0.000857536360854283, 
     0.0007943494711071253, 0.0007384967739199055, 0.0006888499319757102, 
     0.000644492171204547, 0.0006046722887731448, 0.0005687698716272394, 
     0.0005362687361056828, 0.0005067364543096531, 0.0004798084301675942, 
     0.0004551754080830972, 0.0004325735947162124, 0.00041177678727793293, 
     0.00039259005525422996, 0.0003748446342299037, 0.0003583937725395631, 
     0.00034310933224008177, 0.0003288789912715991, 0.00031560392782183403, 
     0.00030319689380426805, 0.00029158060414226247, 0.0002806863837677164, 
     0.00027045302602618504, 0.00026082582536342036, 0.0002517557543686398, 
     0.0002431987609285608, 0.00023511516574996943, 0.00022746914409956393, 
     0.00022022827848769893, 0.00021336317134038323, 0.00020684710857927778, 
     0.00020065576655377558, 0.00019476695601361042, 0.00018916039783049022, 
     0.00018381752601676844, 0.00017872131428276486, 0.0001738561229495118, 
     0.00016920756351235908, 0.0001647623785505818, 0.00016050833501302954, 
     0.00015643412919133864, 0.00015252930192955177, 0.0001487841628196744, 
     0.00014518972230289192, 0.00014173763074090714, 0.00013842012364527655, 
     0.00013522997235813932, 0.00013216043956816893, 0.00012920523912327952, 
     0.00012635849966853775, 0.0001236147316954962, 0.00012096879763913776, 
     0.00011841588470194817, 0.0001159514801222776, 0.00011357134863692448, 
     0.00011127151191646264, 0.00010904822977681904, 0.00010689798299248739, 
     0.00010481745755595597, 0.00010280353024479368, 0.00010085325537268611, 
     0.00009896385261380541, 0.00009713269580146114, 0.00009535730261220885, 
     0.0000936353250556563, 0.0000919645406982502, 0.00009034284455647303, 
     0.00008876824160124037, 0.00008723883982095809, 0.00008575284379575689, 
     0.00008430854873994361, 0.00008290433497375288, 0.00008153866278910773, 
     0.00008021006767734887, 0.00007891715588981255, 0.00007765860030476298, 
     0.00007643313657654953, 0.00007523955954498976, 0.00007407671988490245, 
     0.00007294352097745133, 0.00007183891598653139, 0.00007076190512485134, 
     0.00006971153309565433};
 
  TVIL_REAL Gy0xxxtableCLy3[] = 
     {0, -0.25, 0., -0.010416666666666666, -0.0078125, 
     -0.005859375, -0.004557291666666667, -0.003662109375, 
     -0.003021240234375, -0.0025456746419270835, -0.0021820068359375, 
     -0.0018968582153320312, -0.0016685326894124348, -0.0014824271202087402, 
     -0.0013284087181091309, -0.0011992578705151875, -0.0010897102765738964, 
     -0.0009958486771211028, -0.0009147054515779018, -0.0008439963130513206, 
     -0.0007819377606210764, -0.0007271193726410274, -0.00067841281179426, 
     -0.0006349059032118021, -0.0005958541512285365, -0.0005606445877468502, 
     -0.0005287684740622467, -0.000499800448091244, -0.0004733824244064211, 
     -0.0004492110406668359, -0.00042702777939933784, 
     -0.00040661112865616675, -0.0003877703112723142, 
     -0.00037034023162421523, -0.00035417737521556826, 
     -0.00033915645974883657, -0.00032516768321037446, 
     -0.0003121144495043936, -0.0002999114785463271, -0.0002884832277612641, 
     -0.000277762567270136, -0.0002676896628729841, -0.00025821103012168184, 
     -0.00024927872995177483, -0.00024084968198777356, 
     -0.0002328850761019345, -0.00022534986635950588, 
     -0.00021821233432539193, -0.0002114437109921506, -0.0002050178484353794, 
     -0.00019891093380113405, -0.00019310123945195877, 
     -0.00018756890409874332, -0.00018229574056842016, 
     -0.00017726506653675713, -0.000172461555118366, -0.0001678711026741777, 
     -0.0001634807115873449, -0.00015927838608572662, 
     -0.00015525303946400804, -0.000151394411290195, -0.0001476929933770797, 
     -0.0001441399634653293, -0.00014072712570603114, -0.0001374468571508957, 
     -0.00013429205956120392, -0.00013125611593476014, 
     -0.00012833285122585867, -0.00012551649679850383, 
     -0.00012280165820942774, -0.00012018328596615635, 
     -0.00011765664894760522, -0.00011521731021137267, 
     -0.00011286110494384068, -0.00011058412033705592, 
     -0.00010838267720071638, -0.00010625331313891427, 
     -0.0001041927671399936, -0.00010219796544432192, 
     -0.00010026600856925021, -0.0000983941593832983, 
     -0.00009657983213287819, -0.00009482058233484182, 
     -0.00009311409745697832, -0.00009145818831642948, 
     -0.00008985078113296281, -0.00008828991018024673, 
     -0.00008677371098380161, -0.00008530041401923707, 
     -0.00008386833886879651, -0.00008247588879817793, 
     -0.00008112154571913692, -0.00007980386550655202, 
     -0.00007852147364148256, -0.00007727306115431381, 
     -0.00007605738084439182, -0.00007487324375463258, 
     -0.00007371951588146677, -0.0000725951151021791, -0.0000714990083032352, 
     -0.0000704302086945786};
 
  TVIL_REAL Gy0xxxtableD[] = 
     {0, 0, 0.30301768662811995, 0.001985632211516103, 
     -0.004692159997145554, 0.002821015378817693, -0.00169667442521237, 
     0.0010776289410660404, -0.0007212300751408436, 0.0005044189500014635, 
     -0.0003658197618694282, 0.0002733947843413996, -0.0002095210635832869, 
     0.0001640212873177436, -0.0001307595391668503, 0.00010589474738231981, 
     -0.0000869421817603373, 0.0000722476038795484, -0.00006068141498706783, 
     0.00005145474434797134, -0.0000440055307028763, 0.00003792605964956524, 
     -0.00003291575741765733, 0.000028749768443929323, 
     -0.000025257626934881097, 0.00002230852036390175, 
     -0.000019800940939539687, 0.000017655309521104086, 
     -0.00001580864572345083, 0.000014210667610642354, 
     -0.000012820903956377253, 0.000011606532859683527, 
     -0.000010540747588633387, 9.601509345024665e-6, -8.770586912262093e-6, 
     8.03281106736193e-6, -7.37549122370262e-6, 6.787955663880062e-6, 
     -6.261186679550267e-6, 5.787529142321614e-6, -5.36045629462836e-6, 
     4.9743804291987286e-6, -4.624499008345723e-6, 4.306668932902876e-6, 
     -4.0173032990807416e-6, 3.753286218717546e-6, -3.5119022246627285e-6, 
     3.2907775114127894e-6, -3.087830825206866e-6, 2.901232257187385e-6, 
     -2.7293685374065912e-6, 2.570813698483711e-6, -2.4243041922254007e-6, 
     2.2887177131282713e-6, -2.163055119007305e-6, 2.0464249484159913e-6, 
     -1.9380301227315596e-6, 1.8371564921800723e-6, 
     -1.7431629431043968e-6, 1.6554728311193782e-6, 
     -1.5735665435642533e-6, 1.4969750265193983e-6, -1.425274137924387e-6, 
     1.358079710069109e-6, -1.2950432227701003e-6, 1.2358480035647982e-6, 
     -1.1802058838002655e-6, 1.1278542499988803e-6, -1.078553438707464e-6, 
     1.0320844304677876e-6, -9.882468048217048e-7, 9.468569235767329e-7, 
     -9.077463140666625e-7, 8.707602279775689e-7, -8.357563545805174e-7, 
     8.026036700078567e-7, -7.71181406604622e-7, 7.413781284421573e-7, 
     -7.130909008493132e-7, 6.86224543340734e-7, -6.606909566381306e-7, 
     6.364085156195468e-7, -6.13301521019199e-7, 5.912997035582323e-7, 
     -5.703377749330749e-7, 5.503550207385968e-7, -5.312949309712534e-7, 
     5.131048642541074e-7, -4.957357423607252e-7, 4.791417719966785e-7, 
     -4.6328019113280096e-7, 4.4811103747953093e-7, -4.335969369518103e-7, 
     4.1970291020360316e-7, -4.063961955140159e-7, 3.93646086486585e-7, 
     -3.8142378318245163e-7, 3.697022554493701e-7, -3.5845611733397767e-7, 
     3.476615115763914e-7, -3.3729600328562876e-7};
 
  TVIL_REAL Gy0xxxtableDL[] = 
     {0, 0, 0.2813024128964863, 0.045121417923393456, 
     -0.0439698341711512, 0.0325539635215082, -0.024114546715205225, 
     0.018355993712061442, -0.01436673161926264, 0.011521291175236158, 
     -0.009431784740444135, 0.007856832546613002, -0.006642404493153396, 
     0.005687309264501159, -0.004923170202921959, 0.0043025743510831695, 
     -0.0037918703701581677, 0.0033666704514703568, -0.0030089666624145703, 
     0.0027052368811453587, -0.0024451727134179534, 0.002220807589016621, 
     -0.0020259079507427163, 0.0018555408794764749, -0.0017057622208171627, 
     0.001573388404346148, -0.0014558272958375754, 0.0013509512867401104, 
     -0.0012570010050531584, 0.0011725114992747671, -0.0010962551036801213, 
     0.0010271968173984896, -0.0009644591639631907, 0.000907294299799121, 
     -0.0008550617134458954, 0.0008072102717170874, -0.0007632636715635126, 
     0.0007228085794305745, -0.0006854849057672599, 0.000650977786751375, 
     -0.0006190109393538754, 0.0005893411275178699, -0.0005617535322048932, 
     0.0005360578605311944, -0.0005120850622381075, 0.0004896845475736657, 
     -0.00046872182099103987, 0.000449076461155745, -0.0004306403905511776, 
     0.00041331638820533235, -0.0003970168072843387, 0.00038166246593667353, 
     -0.0003671816851549557, 0.00035350945180620666, -0.00034058668856655006, 
     0.00032835961543972795, -0.0003167791899646083, 0.00030580061522340543, 
     -0.000295382906427959, 0.00028548850824874965, -0.00027608295621065973, 
     0.00026713457645135923, -0.0002586142189554084, 0.00025049502006636404, 
     -0.00024275219066206968, 0.00023536282687265628, 
     -0.00022830574064115116, 0.00022156130778498674, 
     -0.00021511133152301345, 0.000208938919695065, -0.00020302837412650406, 
     0.0001973650907841739, -0.00019193546953753335, 0.00018672683248343057, 
     -0.0001817273499183083, 0.00017692597315043613, -0.00017231237343940037, 
     0.00016787688643255395, -0.0001636104615401337, 0.00015950461575373322, 
     -0.00015555139146800512, 0.00015174331791390546, -0.0001480733758543799, 
     0.00014453496523089636, -0.0001411218754823101, 0.00013782825828677166, 
     -0.00013464860250324553, 0.00013157771111211894, 
     -0.00012861067997471055, 0.00012574287824955558, 
     -0.00012296993031941917, 0.00012028769909731462, 
     -0.00011769227059258326, 0.00011517993962950954, -0.0001127471966211584, 
     0.0001103907153102673, -0.00010810734139722713, 0.00010589408198254757, 
     -0.0001037480957578201, 0.00010166668388514461, -0.00009964728151034882};
 
  TVIL_REAL Gy0xxxtableDL2[] = 
     {0, 0, 0.5, -0.16666666666666666, 0.08333333333333333, -0.05, 
     0.03333333333333333, -0.023809523809523808, 0.017857142857142856, 
     -0.013888888888888888, 0.011111111111111112, -0.00909090909090909, 
     0.007575757575757576, -0.00641025641025641, 0.005494505494505495, 
     -0.004761904761904762, 0.004166666666666667, -0.003676470588235294, 
     0.0032679738562091504, -0.0029239766081871343, 0.002631578947368421, 
     -0.002380952380952381, 0.0021645021645021645, -0.001976284584980237, 
     0.0018115942028985507, -0.0016666666666666668, 0.0015384615384615385, 
     -0.0014245014245014246, 0.0013227513227513227, -0.0012315270935960591, 
     0.0011494252873563218, -0.001075268817204301, 0.0010080645161290322, 
     -0.000946969696969697, 0.00089126559714795, -0.0008403361344537816, 
     0.0007936507936507937, -0.0007507507507507507, 0.0007112375533428165, 
     -0.0006747638326585695, 0.000641025641025641, -0.0006097560975609756, 
     0.0005807200929152149, -0.0005537098560354374, 0.0005285412262156448, 
     -0.000505050505050505, 0.0004830917874396135, -0.00046253469010175765, 
     0.0004432624113475177, -0.00042517006802721087, 0.00040816326530612246, 
     -0.000392156862745098, 0.0003770739064856712, -0.000362844702467344, 
     0.00034940600978336826, -0.0003367003367003367, 0.0003246753246753247, 
     -0.0003132832080200501, 0.00030248033877797946, -0.0002922267679719462, 
     0.0002824858757062147, -0.000273224043715847, 0.00026441036488630354, 
     -0.0002560163850486431, 0.000248015873015873, -0.0002403846153846154, 
     0.0002331002331002331, -0.0002261420171867933, 0.00021949078138718174, 
     -0.00021312872975277067, 0.00020703933747412008, 
     -0.00020120724346076458, 0.00019561815336463224, -0.0001902587519025875, 
     0.00018511662347278786, -0.00018018018018018018, 0.00017543859649122806, 
     -0.00017088174982911826, 0.0001665001665001665, -0.0001622849724115547, 
     0.00015822784810126583, -0.00015432098765432098, 0.00015055706112616682, 
     -0.00014692918013517486, 0.00014343086632243257, 
     -0.00014005602240896358, 0.00013679890560875513, 
     -0.00013365410318096765, 0.00013061650992685477, 
     -0.00012768130745658836, 0.00012484394506866417, -0.0001221001221001221, 
     0.00011944577161968466, -0.0001168770453482936, 0.00011439029970258523, 
     -0.00011198208286674133, 0.00010964912280701755, 
     -0.00010738831615120275, 0.00010519671786240269, 
     -0.00010307153164296021, 0.00010101010101010101};
 
  if (y < 0.5 * x) {
    result = TVIL_G00xxx (x,qq);
    result += y * (3.L - PI*PI/36.L + (-1.L - Zeta2) * lnbarx 
              - lnbarx2 - (2.L * lnbarx3)/3.L - lnbarx * lnbary 
              + lnbarx2 * lnbary - (9.L*SQRT3*LS2)/2.L);
    rn = r = y/x;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gy0xxxtableA[n] +
        Gy0xxxtableALx[n] * lnbarx +
        Gy0xxxtableALy[n] * lnbary +
        Gy0xxxtableALx2[n] * lnbarx * (lnbarx - lnbary));
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_Gx0xxx (x,qq);
    result += (y-x) * (-2.04579029229260745L - lnbarx2 +
     lnbarx3/3.L - SQRT3 * lnbarx * LS2); 
    rn = r = y/x - 1.L;
    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Gy0xxxtableD[n] + 
        Gy0xxxtableDL[n] * lnbarx + 
        Gy0xxxtableDL2[n] * lnbarx2);
    }
  }
  else if (y < 6. * x) {
    result = x * (-17.773015221981147L 
             + 16.137416484381877L * lnbarx 
             - 6.954822555520438L * lnbarx2 
             + 1.8333333333333333L * lnbarx3) +
             (y - 4.L * x) * (-0.3176793369393749L 
               + 0.5530810596468184L * lnbarx 
               + 0.38629436111989046L * lnbarx2 
               + 0.3333333333333333L * lnbarx3);
    rn = r = y/(4.L*x) - 1.L;
    for (n=2; n < 64; n++) {
      rn *= r;
      result += x * rn * (Gy0xxxtableB[n] +
        Gy0xxxtableBL[n] * lnbarx +  
        Gy0xxxtableBL2[n] * lnbarx2);
    }
  }
  else {
    result = TVIL_Gx0000 (y, qq);
    rn = r = 4.L * x/y;
    for (n=1; n < 100; n++) {
      result += y * rn * (Gy0xxxtableC[n] +
        Gy0xxxtableCLx[n] * lnbarx +
        Gy0xxxtableCLy[n] * lnbary +
        Gy0xxxtableCLx2[n] * lnbarx2 +
        Gy0xxxtableCLy2[n] * lnbary2 +
        Gy0xxxtableCLxLy[n] * lnbarx * lnbary +
        Gy0xxxtableCLx3[n] * lnbarx3 +
        Gy0xxxtableCLx2Ly[n] * lnbarx2 * lnbary +
        Gy0xxxtableCLxLy2[n] * lnbarx * lnbary2 +
        Gy0xxxtableCLy3[n] * lnbary3);
      rn *= r;
    }
  }

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Gx0yxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX result;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnbarx3, lnbary3;
  int n;

  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnbarx3 = lnbarx2 * lnbarx;
  lnbary3 = lnbary2 * lnbary;

  TVIL_REAL Gx0yxytableA[] = 
     {0, -0.6498285914033671, 0.17306039356765535, 
     0.006640094659018887, 0.0014256409878518807, 0.0006790122940137193, 
     0.0004039048574314857, 0.00025965489011322543, 0.00017486962432474893, 
     0.00012212100027108084, 0.00008792477261154258, 0.00006498232320102586, 
     0.000049126028120521, 0.00003787829183302451, 0.00002971467679047566, 
     0.000023668151429114742, 0.000019108258784950253, 
     0.000015613723140385637, 0.000012896720447736157, 
     0.000010756612229833006, 9.050964241999543e-6, 7.676972209950682e-6, 
     6.559305273463022e-6, 5.641995143862694e-6, 4.882927974973687e-6, 
     4.250042292164282e-6, 3.7186647637853933e-6, 3.2696171152772525e-6, 
     2.8878534984129277e-6, 2.561467832657888e-6, 2.2809625335061854e-6, 
     2.0387041455067842e-6, 1.8285141323498864e-6, 1.6453584383268983e-6, 
     1.4851099478643446e-6, 1.3443652496689684e-6, 1.2203022100535913e-6, 
     1.1105684679956934e-6, 1.0131935434725369e-6, 9.265191115134444e-7, 
     8.491433491713228e-7, 7.798762572639255e-7, 7.177035948671165e-7, 
     6.617576135108822e-7, 6.112931903960803e-7, 5.656682718504063e-7, 
     5.243277757092935e-7, 4.867902832427439e-7, 4.52636991476958e-7, 
     4.215025054627547e-7, 3.9306713477212156e-7, 3.6705042489529286e-7, 
     3.432057064955879e-7, 3.2131548685480697e-7, 3.011875407370784e-7, 
     2.8265158416902514e-7, 2.655564357036273e-7, 2.4976758670382273e-7, 
     2.3516511590243586e-7, 2.2164189463193042e-7, 2.0910203819085137e-7, 
     1.9745956623248022e-7, 1.8663724114795183e-7, 1.7656555842672112e-7, 
     1.6718186711539068e-7, 1.584296019241581e-7, 1.502576113788827e-7, 
     1.4261956879091327e-7, 1.3547345480104757e-7, 1.2878110191691787e-7, 
     1.2250779286046894e-7, 1.1662190571945929e-7, 1.1109459989124368e-7, 
     1.058995376489677e-7, 1.0101263687477694e-7, 9.641185111241124e-8, 
     9.207697360969944e-8, 8.79894624641786e-8, 8.413228436412035e-8, 
     8.048977474247457e-8, 7.704751244084538e-8, 7.379220722146882e-8, 
     7.071159867302816e-8, 6.779436523587962e-8, 6.503004222795106e-8, 
     6.240894788768095e-8, 5.992211656780371e-8, 5.756123831604569e-8, 
     5.531860416798209e-8, 5.3187056555214635e-8, 5.115994430019361e-8, 
     4.9231081728742224e-8, 4.7394711483758746e-8, 4.56454706696453e-8, 
     4.397835999755877e-8, 4.238871563731947e-8, 4.0872183513354044e-8, 
     3.942469580992605e-8, 3.804244947557448e-8, 3.672188653853898e-8, 
     3.5459676064341295e-8};
 
  TVIL_REAL Gx0yxytableALx[] = 
     {0, 0.33876648328794345, 0.16976106526643028, 
      0.0037065972222222222, -0.0020727705144557825, -0.0015045352089041635, 
     -0.0009132361719895646, -0.0005630390865190855, -0.00036198007044654153, 
     -0.0002427342211048441, -0.00016895592219958968, 
     -0.00012142539108080707, -0.00008968220312917362, 
     -0.00006780600130796634, -0.00005231214446697566, 
     -0.00004107393297164025, -0.000032750360490655755, 
     -0.000026470832397645758, -0.000021655260748549056, 
     -0.00001790803780398347, -0.000014953685060319989, 
     -0.000012596740889226701, -0.00001069614484769684, 
     -9.148516089974819e-6, -7.87701704740921e-6, -6.823799951596916e-6, 
     -5.944796943055559e-6, -5.206070863875069e-6, -4.581222667003032e-6, 
     -4.04952516795563e-6, -3.594563201399152e-6, -3.2032315019527807e-6, 
     -2.8649883838080144e-6, -2.57129442933699e-6, -2.3151864190908107e-6, 
     -2.090951113900498e-6, -1.8938734536587974e-6, 
     -1.7200407069853633e-6, -1.5661890384835607e-6, 
     -1.4295824864273263e-6, -1.3079168885286257e-6, 
     -1.1992431465998483e-6, -1.101905581945423e-6, 
     -1.0144921409811012e-6, -9.357939623583186e-7, -8.647723818382015e-7, 
     -8.005318786854472e-7, -7.422977930130092e-7, -6.893978931406682e-7, 
     -6.412470645366728e-7, -5.973345412193222e-7, -5.572132169363786e-7, 
     -5.204906647284304e-7, -4.868215654130425e-7, -4.559013024793931e-7, 
     -4.274605261869072e-7, -4.012605258601502e-7, -3.770892784203136e-7, 
     -3.547580646001307e-7, -3.340985632248911e-7, -3.1496034932019783e-7, 
     -2.9720873434200476e-7, -2.8072289707847545e-7, -2.65394262190336e-7, 
     -2.5112509028876457e-7, -2.378272491778057e-7, 
     -2.2542114063584312e-7, -2.13834761057511e-7, -2.0300287756819818e-7, 
     -1.9286630397485304e-7, -1.833712632237871e-7, 
     -1.7446882497559748e-7, -1.6611440854194846e-7, 
     -1.5826734281014045e-7, -1.5089047595127602e-7, 
     -1.4394982870108975e-7, -1.374142858477395e-7, 
     -1.3125532128173488e-7, -1.2544675257933615e-7, 
     -1.199645216185192e-7, -1.1478649817958443e-7, -1.09892303872063e-7, 
     -1.0526315406527585e-7, -1.0088171578972638e-7, -9.6731979827195e-8, 
     -9.279914542462624e-8, -8.90695162554596e-8, -8.553040641601535e-8, 
     -8.217005538735712e-8, -7.897755101764425e-8, -7.594275968885968e-8, 
     -7.305626292708326e-8, -7.030929979900064e-8, -6.769371451065576e-8, 
     -6.520190868891084e-8, -6.282679788282341e-8, -6.056177187217801e-8, 
     -5.8400658414575205e-8, -5.633769010152386e-8, 
     -5.4367474028540225e-8, -5.248496401488694e-8};
 
  TVIL_REAL Gx0yxytableALy[] = 
     {0, 0.75, -0.09510828748865252, -0.0009982638888888888, 
     0.0022798859126984127, 0.0015271826504039115, 0.0009162495840119771, 
     0.0005634902698837554, 0.0003620531232039889, 0.0002427467341398443, 
     0.00016895815939105936, 0.00012142580487453685, 0.00008968228180890693, 
     0.00006780601661572868, 0.000052312147503531894, 0.00004107393358407468, 
     0.00003275036061596392, 0.000026470832423608842, 
     0.000021655260753988384, 0.000017908037805134296, 
     0.000014953685060565628, 0.00001259674088927955, 
     0.000010696144847708291, 9.148516089977318e-6, 7.877017047409758e-6, 
     6.823799951597038e-6, 5.944796943055586e-6, 5.206070863875075e-6, 
     4.581222667003034e-6, 4.04952516795563e-6, 3.5945632013991525e-6, 
     3.203231501952781e-6, 2.8649883838080144e-6, 2.57129442933699e-6, 
     2.3151864190908107e-6, 2.090951113900498e-6, 1.8938734536587976e-6, 
     1.720040706985363e-6, 1.5661890384835607e-6, 1.429582486427326e-6, 
     1.3079168885286257e-6, 1.1992431465998483e-6, 1.101905581945423e-6, 
     1.0144921409811012e-6, 9.357939623583185e-7, 8.647723818382016e-7, 
     8.005318786854471e-7, 7.422977930130092e-7, 6.893978931406681e-7, 
     6.412470645366727e-7, 5.973345412193222e-7, 5.572132169363786e-7, 
     5.204906647284304e-7, 4.868215654130426e-7, 4.559013024793931e-7, 
     4.2746052618690724e-7, 4.0126052586015024e-7, 3.770892784203136e-7, 
     3.547580646001307e-7, 3.3409856322489104e-7, 3.1496034932019783e-7, 
     2.9720873434200476e-7, 2.8072289707847545e-7, 2.6539426219033606e-7, 
     2.511250902887646e-7, 2.378272491778057e-7, 2.2542114063584314e-7, 
     2.1383476105751098e-7, 2.0300287756819824e-7, 1.9286630397485304e-7, 
     1.8337126322378712e-7, 1.7446882497559746e-7, 1.6611440854194849e-7, 
     1.5826734281014047e-7, 1.5089047595127602e-7, 1.4394982870108973e-7, 
     1.374142858477395e-7, 1.3125532128173488e-7, 1.2544675257933615e-7, 
     1.1996452161851922e-7, 1.1478649817958442e-7, 1.09892303872063e-7, 
     1.0526315406527585e-7, 1.0088171578972637e-7, 9.673197982719498e-8, 
     9.279914542462623e-8, 8.906951625545959e-8, 8.553040641601534e-8, 
     8.217005538735712e-8, 7.897755101764423e-8, 7.594275968885966e-8, 
     7.305626292708326e-8, 7.030929979900064e-8, 6.769371451065576e-8, 
     6.520190868891084e-8, 6.282679788282343e-8, 6.056177187217801e-8, 
     5.8400658414575205e-8, 5.633769010152386e-8, 5.436747402854023e-8, 
     5.248496401488694e-8};
 
  TVIL_REAL Gx0yxytableALx2[] = 
     {0, 0., 0.10416666666666667, 0.015885416666666666, 
     0.004175967261904762, 0.0015117342509920635, 0.000679445473146645, 
     0.0003544363148244984, 0.00020524870874297143, 0.0001281995537874884, 
     0.00008476840082174851, 0.00005859674999191242, 0.00004197574538981773, 
     0.00003096310063927083, 0.000023406526467262383, 
     0.000018066586500149526, 0.000014197124428825355, 
     0.000011331742567656145, 9.169351071629946e-6, 7.510050629874213e-6, 
     6.21781850037252e-6, 5.198059470557961e-6, 4.383698691126656e-6, 
     3.7263391455871093e-6, 3.190506924855699e-6, 2.749826702315412e-6, 
     2.384431282562461e-6, 2.0791764433213708e-6, 1.8223911466534406e-6, 
     1.6049897878757626e-6, 1.4198331321949807e-6, 1.2612625620864726e-6, 
     1.1247567293426874e-6, 1.0066757364982103e-6, 9.04068635074444e-7, 
     8.145272213513574e-7, 7.36074027481414e-7, 6.670758086206534e-7, 
     6.061762090145834e-7, 5.522429759032985e-7, 5.043262954548625e-7, 
     4.616256950011262e-7, 4.2346358961262754e-7, 3.8926401665783087e-7, 
     3.5853544684809897e-7, 3.308568176620441e-7, 3.058661285627675e-7, 
     2.832510839332735e-7, 2.6274138131393187e-7, 2.4410232816063074e-7, 
     2.2712953641489075e-7, 2.1164449545036798e-7, 1.9749086396814115e-7, 
     1.8453135279580353e-7, 1.726450952866929e-7, 1.617254216156524e-7, 
     1.5167796886716015e-7, 1.4241907128259033e-7, 1.3387438504607538e-7, 
     1.259777100607371e-7, 1.1866997770090768e-7, 1.1189837883487053e-7, 
     1.0561561074222735e-7, 9.977922509350673e-8, 9.435106206978525e-8, 
     8.929675809806047e-8, 8.458531666039643e-8, 8.018873327862565e-8, 
     7.608166714354627e-8, 7.224115299796928e-8, 6.864634783693794e-8, 
     6.52783077886292e-8, 6.211979121242865e-8, 5.915508461812477e-8, 
     5.636984848984139e-8, 5.375098050478118e-8, 5.128649398207855e-8, 
     4.896540969095197e-8, 4.67776593980958e-8, 4.47139997486553e-8, 
     4.2765935258843094e-8, 4.092564935599458e-8, 3.918594253756926e-8, 
     3.7540176837587035e-8, 3.598222589002011e-8, 3.4506429966078034e-8, 
     3.310755543809626e-8, 3.1780758188535195e-8, 3.0521550539827004e-8, 
     2.9325771330671568e-8, 2.818955880789904e-8, 2.7109326041053794e-8, 
     2.6081738600154694e-8, 2.510369426628381e-8, 2.417230457029389e-8, 
     2.3284877977470436e-8, 2.2438904555838362e-8, 2.1632041983312096e-8, 
     2.0862102764348808e-8, 2.012704254043582e-8, 1.942494939084756e-8};
 
  TVIL_REAL Gx0yxytableALxLy[] = 
     {0, -0.75, -0.16666666666666666, -0.02890625, 
     -0.008017113095238095, -0.0029742528521825395, -0.0013507353106962483, 
     -0.0007074185647794046, -0.0004102248967666448, -0.0002563461234890813, 
     -0.00016952620514749687, -0.00011719133253605164, 
     -0.00008395103922896228, -0.00006192610575825924, 
     -0.00004681303246589573, -0.000036133168565429594, 
     -0.00002839424788752302, -0.000022663484921313536, 
     -0.000018338702095704616, -0.00001502010124911106, 
     -0.000012435636998351633, -0.000010396118940574556, 
     -8.767397382130273e-6, -7.4526782911461335e-6, -6.381013849704961e-6, 
     -5.499653404629344e-6, -4.76886256512458e-6, -4.158352886642663e-6, 
     -3.6447822933068625e-6, -3.2099795757515206e-6, 
     -2.8396662643899605e-6, -2.5225251241729447e-6, 
     -2.2495134586853747e-6, -2.0133514729964206e-6, 
     -1.808137270148888e-6, -1.6290544427027145e-6, -1.472148054962828e-6, 
     -1.334151617241307e-6, -1.2123524180291667e-6, -1.104485951806597e-6, 
     -1.0086525909097248e-6, -9.232513900022524e-7, -8.469271792252551e-7, 
     -7.785280333156617e-7, -7.170708936961978e-7, -6.617136353240882e-7, 
     -6.117322571255351e-7, -5.665021678665469e-7, -5.254827626278638e-7, 
     -4.882046563212615e-7, -4.542590728297815e-7, -4.232889909007359e-7, 
     -3.949817279362823e-7, -3.6906270559160705e-7, -3.452901905733858e-7, 
     -3.2345084323130483e-7, -3.033559377343203e-7, -2.848381425651806e-7, 
     -2.6774877009215076e-7, -2.5195542012147426e-7, 
     -2.3733995540181536e-7, -2.2379675766974103e-7, 
     -2.112312214844547e-7, -1.9955845018701348e-7, 
     -1.8870212413957053e-7, -1.785935161961209e-7, 
     -1.6917063332079286e-7, -1.6037746655725133e-7, 
     -1.5216333428709256e-7, -1.4448230599593856e-7, 
     -1.3729269567387587e-7, -1.305566155772584e-7, -1.242395824248573e-7, 
     -1.1831016923624954e-7, -1.1273969697968278e-7, 
     -1.0750196100956238e-7, -1.025729879641571e-7, -9.793081938190395e-8, 
     -9.35553187961916e-8, -8.942799949731061e-8, -8.55318705176862e-8, 
     -8.185129871198918e-8, -7.837188507513853e-8, -7.508035367517406e-8, 
     -7.196445178004021e-8, -6.901285993215605e-8, -6.621511087619252e-8, 
     -6.356151637707039e-8, -6.104310107965401e-8, -5.865154266134313e-8, 
     -5.637911761579808e-8, -5.4218652082107594e-8, -5.216347720030939e-8, 
     -5.020738853256762e-8, -4.834460914058778e-8, -4.656975595494087e-8, 
     -4.4877809111676723e-8, -4.326408396662419e-8, 
     -4.1724205528697616e-8, -4.025408508087163e-8, -3.884989878169512e-8};
 
  TVIL_REAL Gx0yxytableALy2[] = 
     {0, 0., 0.0625, 0.013020833333333334, 0.003841145833333333, 
     0.0014625186011904762, 0.0006712898375496032, 0.0003529822499549062, 
     0.00020497618802367337, 0.00012814656970159288, 0.00008475780432574835, 
     0.00005859458254413922, 0.000041975293839144555, 
     0.000030963005118988405, 0.00002340650599863335, 0.00001806658206528007, 
     0.000014197123458697668, 0.000011331742353657393, 9.169351024074667e-6, 
     7.510050619236847e-6, 6.217818497979113e-6, 5.198059470016595e-6, 
     4.383698691003618e-6, 3.7263391455590246e-6, 3.1905069248492622e-6, 
     2.7498267023139316e-6, 2.384431282562119e-6, 2.079176443321292e-6, 
     1.8223911466534222e-6, 1.6049897878757584e-6, 1.4198331321949796e-6, 
     1.2612625620864721e-6, 1.1247567293426874e-6, 1.0066757364982103e-6, 
     9.040686350744439e-7, 8.145272213513574e-7, 7.36074027481414e-7, 
     6.670758086206534e-7, 6.061762090145834e-7, 5.522429759032985e-7, 
     5.043262954548625e-7, 4.616256950011262e-7, 4.2346358961262754e-7, 
     3.8926401665783087e-7, 3.585354468480989e-7, 3.308568176620441e-7, 
     3.0586612856276753e-7, 2.832510839332735e-7, 2.6274138131393187e-7, 
     2.4410232816063074e-7, 2.2712953641489072e-7, 2.1164449545036798e-7, 
     1.9749086396814115e-7, 1.8453135279580353e-7, 1.726450952866929e-7, 
     1.6172542161565242e-7, 1.5167796886716015e-7, 1.4241907128259033e-7, 
     1.3387438504607538e-7, 1.259777100607371e-7, 1.1866997770090768e-7, 
     1.1189837883487052e-7, 1.0561561074222735e-7, 9.977922509350671e-8, 
     9.435106206978524e-8, 8.929675809806045e-8, 8.458531666039643e-8, 
     8.018873327862567e-8, 7.608166714354628e-8, 7.224115299796928e-8, 
     6.864634783693794e-8, 6.52783077886292e-8, 6.211979121242865e-8, 
     5.915508461812477e-8, 5.636984848984139e-8, 5.375098050478118e-8, 
     5.128649398207855e-8, 4.896540969095197e-8, 4.67776593980958e-8, 
     4.471399974865531e-8, 4.2765935258843094e-8, 4.092564935599458e-8, 
     3.918594253756927e-8, 3.754017683758703e-8, 3.598222589002011e-8, 
     3.4506429966078034e-8, 3.3107555438096255e-8, 3.17807581885352e-8, 
     3.0521550539827004e-8, 2.9325771330671565e-8, 2.818955880789904e-8, 
     2.7109326041053794e-8, 2.6081738600154697e-8, 2.5103694266283802e-8, 
     2.4172304570293894e-8, 2.3284877977470436e-8, 2.243890455583836e-8, 
     2.1632041983312096e-8, 2.0862102764348808e-8, 2.012704254043582e-8, 
     1.942494939084756e-8};
 
  TVIL_REAL Gx0yxytableC[] = 
     {0, -0.26086629990922017, -0.007305142246744556, 
     0.03232371309809767, 0.024895079196020048, 0.01951499902390133, 
     0.01576961179659593, 0.013061115243769725, 0.011035384424821153, 
     0.009477269698113695, 0.008250341497667256, 0.007264790857829662, 
     0.006459554296532416, 0.005791924749564505, 0.005231284808001949, 
     0.0047552003013862955, 0.004346912657695608, 0.003993686193549693, 
     0.0036856927273864644, 0.0034152425524567286, 0.0031762438615635102, 
     0.0029638160345256855, 0.002774008544371716, 0.0026035936375308905, 
     0.0024499113724534075, 0.0023107523656901007, 0.0021842680627320032, 
     0.0020689013524410136, 0.0019633323918205967, 0.0018664359254985507, 
     0.001777247378891558, 0.001694935710621872, 0.0016187815176582944, 
     0.0015481592557471339, 0.0014825227086848487, 0.0014213930408644455, 
     0.0013643489177941615, 0.0013110182926552158, 0.0012610715431872043, 
     0.0012142157092664635, 0.0011701896325470602, 0.0011287598391738042, 
     0.0010897170375843033, 0.001052873127822116, 0.001018058638104391, 
     0.0009851205197693507, 0.0009539202440404428, 0.0009243321539476922, 
     0.0008962420327527296, 0.0008695458567256472, 0.00084414870542566, 
     0.0008199638069825025, 0.000796911699449598, 0.0007749194922516351, 
     0.0007539202141957982, 0.0007338522365514175, 0.0007146587614021444, 
     0.0006962873668981732, 0.0006786896022323479, 0.0006618206261724048, 
     0.0006456388838342432, 0.0006301058171042932, 0.0006151856047338471, 
     0.000600844928652631, 0.0005870527634971104, 0.0005737801867332728, 
     0.0005610002070837485, 0.0005486876092534788, 0.0005368188131935859, 
     0.0005253717463554702, 0.0005143257275713234, 0.0005036613613572192, 
     0.0004933604415742724, 0.00048340586350490745, 0.00047378154350749503, 
     0.0004644723455056684, 0.0004554640136502654, 0.0004467431105635647, 
     0.0004382969606386688, 0.00043011359792259965, 0.00042218171816085, 
     0.00041449063462471345, 0.00040703023738126185, 0.00039979095570011336, 
     0.0003927637233215428, 0.0003859399463375839, 0.0003793114734619335, 
     0.00037287056848599653, 0.00036660988473768757, 0.00036052244137684854, 
     0.0003546016013765787, 0.0003488410510536378, 0.00034323478102353576, 
     0.0003377770684671287, 0.0003324624606056048, 0.0003272857592898498, 
     0.0003222420066183848, 0.0003173264715054737, 0.0003125346371277008, 
     0.0003078621891834032, 0.0003033050049048216};
 
  TVIL_REAL Gx0yxytableCLx[] = 
     {0, 0.46376648328794345, 0.14719162082198586, 
     0.06568885450537829, 0.04625014782347816, 0.034755375838289436, 
     0.02721331596306588, 0.022001278469995448, 0.018243079465450125, 
     0.015435831198314626, 0.013276839047314259, 0.011575690859494978, 
     0.010207791460454323, 0.009088757980472137, 0.008159710270999845, 
     0.0073784848084864595, 0.006714198443868861, 0.006143777233007191, 
     0.0056496770389135465, 0.005218348903411666, 0.004839182543391581, 
     0.004503764310975818, 0.004205346539238421, 0.003938461815172106, 
     0.0036986384118746496, 0.003482187492062982, 0.0032860419985077296, 
     0.0031076332809031326, 0.0029447956237396095, 0.00279569164495348, 
     0.0026587534759222944, 0.002532635994652848, 0.002416179351050587, 
     0.0023083787183328865, 0.0022083597099483597, 0.002115358272473528, 
     0.0020287041401718183, 0.001947807142866939, 0.001872145814254466, 
     0.0018012578660843849, 0.0017347321843666948, 0.0016722020738199617, 
     0.001613339531271569, 0.001557850371367923, 0.0015054700615418186, 
     0.0014559601497928796, 0.0014091051900338965, 0.00136471008673184, 
     0.0013225977942368673, 0.001282607317245295, 0.0012445919678239813, 
     0.0012084178417545047, 0.001173962482964696, 0.0011411137097609692, 
     0.0011097685806615769, 0.001079832481020401, 0.0010512183144522674, 
     0.0010238457854274685, 0.0009976407613783071, 0.0009725347043212118, 
     0.0009484641633986149, 0.0009253703209297303, 0.0009031985855646623, 
     0.0008818982269915676, 0.000861422047376243, 0.000841726085337606, 
     0.0008227693487976803, 0.0008045135735047187, 0.0007869230044244514, 
     0.0007699641975367805, 0.0007536058398715031, 0.0007378185858736759, 
     0.0007225749084126224, 0.000707848962943181, 0.000693616463497612, 
     0.0006798545693350859, 0.0006665417812057742, 0.000653657846300735, 
     0.0006411836710591829, 0.000629101241093142, 0.000617393547567483, 
     0.0006060445194422638, 0.0005950389610453065, 0.0005843624944970009, 
     0.0005740015065573429, 0.0005639430995078882, 0.0005541750457193023, 
     0.0005446857455890713, 0.0005354641885641861, 0.0005264999169906549, 
     0.0005177829925559142, 0.000509303965111898, 0.0005010538436860132, 
     0.0004930240695047528, 0.00048520649087043584, 0.0004775933397457241, 
     0.0004701772099133725, 0.00046295103659018517, 0.00045590807738460034, 
     0.0004490418944967494, 0.00044234633806838344};
 
  TVIL_REAL Gx0yxytableCLy[] = 
     {0, -0.07246703342411309, -0.14968337917801414, 
     -0.09167431701672576, -0.0670754802958481, -0.05127999441964286, 
     -0.040648378748907324, -0.033175624466357405, -0.02771474706774346, 
     -0.023591091663779377, -0.02039122903388003, -0.01785115149448827, 
     -0.015795870035213197, -0.014105554482306947, -0.01269578914626704, 
     -0.01150562268113026, -0.01049008717539027, -0.009615371723977554, 
     -0.008855623857895218, -0.00819077842105958, -0.007605051938304142, 
     -0.007085878188969769, -0.006623142504938203, -0.006208622213090969, 
     -0.005835571819012429, -0.005498411437133676, -0.005192489941760031, 
     -0.004913902918438408, -0.004659351301550838, -0.0044260305634475075, 
     -0.004211543087244087, -0.0040138283049540495, -0.00383110657346249, 
     -0.003661833764633386, -0.0035046642781575853, -0.0033584207254438144, 
     -0.003222068934386697, -0.003094697226260928, -0.002975499144160243, 
     -0.002863758986496833, -0.002758839632913491, -0.0026601722535788304, 
     -0.0025672475735985098, -0.002479608427626141, -0.002396843389751942, 
     -0.0023185813034290533, -0.0022444865678671834, -0.0021742550627311657, 
     -0.002107610613468258, -0.002044301916184975, -0.0019840998545018087, 
     -0.0019267951518556346, -0.0018721963117830252, -0.0018201278061874314, 
     -0.001770428477773314, -0.0017229501279623883, -0.0016775562658842098, 
     -0.0016341209976100143, -0.0015925280377996882, -0.0015526698284576185, 
     -0.0015144467516257638, -0.0014777664246481644, -0.0014425430681746616, 
     -0.0014086969383775927, -0.0013761538159702835, -0.00134484454557079, 
     -0.0013147046197735529, -0.001285673802996438, -0.001257695790778356, 
     -0.0012307179007279394, -0.0012046907917787047, -0.0011795682088010782, 
     -0.0011553067499651892, -0.0011318656545477616, -0.00110920660913793, 
     -0.001087293570425591, -0.0010660926029565005, -0.0010455717304144146, 
     -0.001025700799145568, -0.0010064513527772907, -0.000987796516903115, 
     -0.0009697108929132728, -0.0009521704601438512, -0.0009351524856015466, 
     -0.000918635440595309, -0.0009025989236722649, -0.0008870235893142206, 
     -0.0008718910819035656, -0.0008571839745143406, -0.0008428857121261918, 
     -0.0008289805588965297, -0.0008154535491599168, -0.0008022904418539629, 
     -0.0007894776780982221, -0.0007770023416770538, -0.0007648521221994775, 
     -0.0007530152807289477, -0.0007414806176939301, -0.0007302374429064289, 
     -0.0007192755475302825, -0.0007085851778543907};
 
  TVIL_REAL Gx0yxytableCLx2[] = 
     {0, 0., 0.0625, 0.0390625, 0.024088541666666668, 
     0.016520182291666668, 0.01221923828125, 0.009514363606770833, 
     0.007682909284319197, 0.006374100276402065, 0.005399928395710294, 
     0.0046514379599737745, 0.004061502263401494, 0.003586701581101397, 
     0.003197817047438686, 0.0028745304406308883, 0.0026023165380970343, 
     0.002370542728442427, 0.0021712646343397687, 0.0019984390245555697, 
     0.0018473954989844663, 0.0017144734397051098, 0.0015967672805345331, 
     0.0014919444230299989, 0.0013981128876448586, 0.0013137236511153835, 
     0.0012374975837041195, 0.0011683701010917437, 0.0011054487518574396, 
     0.0010479803723703982, 0.0009953254017666146, 0.0009469376140529813, 
     0.0009023479902233954, 0.0008611517841722874, 0.0008229980740841088, 
     0.0007875812639320422, 0.0007546341267841866, 0.0007239220758848644, 
     0.0006952384200620632, 0.0006684004133186488, 0.0006432459490520634, 
     0.0006196307804875132, 0.0005974261729755437, 0.0005765169125314392, 
     0.000556799609660633, 0.0005381812490724593, 0.0005205779450464995, 
     0.0005039138695188956, 0.00048812032580843376, 0.0004731349456159723, 
     0.0004589009907458307, 0.0004453667440997812, 0.00043248497702772187, 
     0.00042021248219699256, 0.00040850966285347923, 0.0003973401707623679, 
     0.0003866705862904105, 0.00037647013506932823, 0.00036671043649713484, 
     0.00035736528001937363, 0.0003484104257086849, 0.0003398234261475309, 
     0.00033158346703059366, 0.00032367122425280186, 0.0003160687355463898, 
     0.0003087592849842527, 0.000301727298884097, 0.0002949582518342413, 
     0.00028843858172218444, 0.0002821556127852054, 0.0002760974858216108, 
     0.0002702530948045967, 0.0002646120292303758, 0.000259164521610203, 
     0.00025390139958389224, 0.00024881404219173923, 0.00024389433989366696, 
     0.0002391346579698876, 0.00023452780297730826, 0.0002300669919710256, 
     0.00022574582423119565, 0.00022155825526287075, 0.00021749857286053047, 
     0.00021356137505040224, 0.00020974154974261425, 0.0002060342559420479, 
     0.00020243490638172283, 0.0001989391514558716, 0.0001955428643417498, 
     0.0001922421272098392, 0.0001890332184315963, 0.00018591260070239697, 
     0.00018287691000494976, 0.00017992294534528993, 0.00017704765919961623, 
     0.0001742481486157641, 0.0001715216469180938, 0.00016886551596906666, 
     0.0001662772389448426, 0.00016375441358590023, 0.00016129474588700004};
 
  TVIL_REAL Gx0yxytableCLxLy[] = 
     {0, -1., -0.21875, -0.1328125, -0.0869140625, 
     -0.06232096354166667, -0.047509765625, -0.037779017857142855, 
     -0.030977176484607516, -0.02599993660336449, -0.022227448508853005, 
     -0.019287113795892846, -0.016942637857764658, -0.015037585928819463, 
     -0.013464668954471688, -0.012148092483079463, -0.011032944130414888, 
     -0.010078565503936158, -0.009254275675235828, -0.008536532952572727, 
     -0.007907004079673806, -0.007351221724038869, -0.006857632659178939, 
     -0.0064169110545813975, -0.006021455165678835, -0.005665013133590412, 
     -0.00534240112844004, -0.005049288502696555, -0.0047820322201983165, 
     -0.0045375479647062535, -0.004313208860924695, -0.004106765200153055, 
     -0.003916280299499628, -0.0037400788654558554, -0.0035767051309320277, 
     -0.003424888691676972, -0.0032835164531204806, -0.003151609460372447, 
     -0.003028303656187905, -0.002912833818082246, -0.002804520083556482, 
     -0.002702756593912232, -0.0026070018813909705, -0.0025167706979673994, 
     -0.002431627041954652, -0.002351178184290841, -0.0022750695327174424, 
     -0.002202980201108477, -0.0021346191745494534, -0.00206972197961128, 
     -0.00200804778455412, -0.001949376866656827, -0.0018935083940666692, 
     -0.001840258477946665, -0.0017894584576150913, -0.001740953387101484, 
     -0.0016946006963071488, -0.0016502690039326402, -0.0016078370626619663, 
     -0.0015671928198878883, -0.001528232579617334, -0.0014908602531859307, 
     -0.0014549866880973826, -0.0014205290657371993, -0.0013874103599323306, 
     -0.0013555588493726547, -0.0013249076778051108, -0.0012953944566798552, 
     -0.0012669609055895796, -0.0012395525264142291, -0.001213118307577319, 
     -0.0011876104552482319, -0.0011629841486968475, -0.0011391973173306132, 
     -0.0011162104372265875, -0.0010939863452177638, -0.001072490068809071, 
     -0.0010516886703879874, -0.0010315511043612583, -0.0010120480859958157, 
     -0.0009931519708712858, -0.0009748366439656318, -0.0009570774174965034, 
     -0.0009398509367303338, -0.0009231350930506559, -0.0009069089436476666, 
     -0.0008911526372538813, -0.0008758473454066918, -0.0008609751987685996, 
     -0.0008465192280805382, -0.0008324633093636426, -0.0008187921130206292, 
     -0.0008054910565200465, -0.0007925462603755129, -0.0007799445071579866, 
     -0.000767673203302475, -0.0007557203434916338, -0.0007440744774177128, 
     -0.0007327246787414537, -0.0007216605160820806, -0.0007108720258865613};
 
  TVIL_REAL Gx0yxytableCLy2[] = 
     {0, 0.125, 0.15625, 0.09375, 0.06282552083333333, 
     0.04580078125, 0.03529052734375, 0.028264654250372025, 
     0.023294267200288318, 0.019625836326962427, 0.01682752011314271, 
     0.01463567583591907, 0.012881135594363165, 0.011450884347718066, 
     0.010266851907033001, 0.009273562042448575, 0.008430627592317854, 
     0.00770802277549373, 0.007083011040896059, 0.006538093928017156, 
     0.00605960858068934, 0.005636748284333758, 0.005260865378644405, 
     0.004924966631551398, 0.004623342278033976, 0.004351289482475029, 
     0.004104903544735921, 0.0038809184016048116, 0.0036765834683408767, 
     0.003489567592335855, 0.0033178834591580803, 0.0031598275861000735, 
     0.0030139323092762318, 0.0028789270812835683, 0.002753707056847919, 
     0.00263730742774493, 0.002528882326336294, 0.0024276873844875824, 
     0.002333065236125842, 0.0022444334047635973, 0.002161274134504419, 
     0.0020831258134247185, 0.0020095757084154266, 0.0019402537854359607, 
     0.0018748274322940189, 0.0018129969352183816, 0.0017544915876709429, 
     0.0016990663315895813, 0.0016464988487410195, 0.0015965870339953079, 
     0.0015491467938082892, 0.001504010122557046, 0.0014610234170389473, 
     0.0014200459957496724, 0.0013809487947616119, 0.0013436132163391161, 
     0.0013079301100167382, 0.0012737988688633118, 0.0012411266261648315, 
     0.0012098275398685146, 0.0011798221539086491, 0.0011510368270383996, 
     0.0011234032210667888, 0.0010968578414843975, 0.001071341624385941, 
     0.0010467995643884018, 0.001023180378921014, 0.0010004362048456142, 
     0.0009785223238673953, 0.0009573969136290239, 0.0009370208217557081, 
     0.0009173573604436353, 0.0008983721194664716, 0.0008800327957204101, 
     0.0008623090376426954, 0.0008451723030260248, 0.000828595728915404, 
     0.0008125540124180999, 0.00079702330138395, 0.0007819810940247903, 
     0.0007674061466400899, 0.0007532783887027611, 0.0007395788446359729, 
     0.0007262895616799315, 0.0007133935433080417, 0.0007008746877056189, 
     0.0006887177308721585, 0.0006769081939508201, 0.0006654323344268499, 
     0.000654277100870699, 0.0006434300909320464, 0.0006328795123182323, 
     0.0006226141465150969, 0.000612623315030223, 0.0006028968479583704, 
     0.0005934250546867107, 0.00058419869657354, 0.0005752089614486461, 
     0.000566447439796611, 0.0005579061024961802, 0.0005495772799995613};
 
  TVIL_REAL Gx0yxytableCLx2Ly[] = 
     {0, 0., -0.0625, -0.03125, -0.01953125, -0.013671875, 
     -0.01025390625, -0.008056640625, -0.0065460205078125, 
     -0.00545501708984375, -0.0046367645263671875, -0.004004478454589844, 
     -0.0035039186477661133, -0.0030996203422546387, -0.002767518162727356, 
     -0.0024907663464546204, -0.0022572570014744997, -0.002058087266050279, 
     -0.0018865799938794225, -0.0017376394680468366, -0.0016073165079433238, 
     -0.0014925081859473721, -0.001390746264178233, -0.0013000454208622614, 
     -0.00121879258205837, -0.0011456650271348678, -0.001079568967877087, 
     -0.0010195929141061377, -0.0009649718651361661, -0.0009150595272842954, 
     -0.0008693065509200806, -0.0008272433307142703, -0.0007884662995870388, 
     -0.0007526269223330826, -0.000719422793406623, -0.0006885903879749107, 
     -0.0006598991218092894, -0.0006331464547089128, -0.0006081538314967189, 
     -0.0005847632995160758, -0.000562834675784223, -0.0005422431632555319, 
     -0.0005228773359964058, -0.0005046374289267636, -0.00048743388021335127, 
     -0.00047118608420623954, -0.0004558213205908187, 
     -0.00044127383163579257, -0.00042748402439717406, 
     -0.0004143977787523626, -0.0004019658453897917, -0.0003901433205253861, 
     -0.0003788891862794615, -0.0003681659074224956, -0.0003579390766607596, 
     -0.0003481771018427389, -0.00033885092947195125, 
     -0.00032993379974900517, -0.0003214010290658412, -0.0003132298164624724, 
     -0.0003053990710509106, -0.0002978892578283472, -0.00029068225965508075, 
     -0.0002837612534728169, -0.00027711059909454774, -0.0002707157391154428, 
     -0.00026456310868100093, -0.0002586400540090382, -0.0002529347587000153, 
     -0.0002474361769891454, -0.00024213397319652088, 
     -0.00023701846672053806, -0.0002320805819971935, -0.0002273118029150594, 
     -0.00022270413123434872, -0.00021825004860966175, 
     -0.00021394248186078685, -0.0002097747711751871, 
     -0.00020574064096027966, -0.00020183417309394523, 
     -0.00019804978234843376, -0.00019438219378642573, 
     -0.00019082642194886916, -0.00018737775167268478, 
     -0.00018403172039281542, -0.00018078410179764808, 
     -0.00017763089071978213, -0.00017456828915564794, 
     -0.0001715926933177676, -0.00016870068163263668, 
     -0.00016588900360542605, -0.0001631545694800619, -0.0001604944406298435, 
     -0.00015790582061968474, -0.00015538604688639188, 
     -0.00015293258298818569, -0.0001505430113789953, 
     -0.00014821502666694897, -0.00014594642932000588, 
     -0.00014373511978485427, -0.00014157909298808148};
 
  TVIL_REAL Gx0yxytableCLxLy2[] = 
     {0, 0.375, 0.125, 0.0625, 0.0390625, 0.02734375, 
     0.0205078125, 0.01611328125, 0.013092041015625, 0.0109100341796875, 
     0.009273529052734375, 0.008008956909179688, 0.0070078372955322266, 
     0.006199240684509277, 0.005535036325454712, 0.004981532692909241, 
     0.004514514002948999, 0.004116174532100558, 0.003773159987758845, 
     0.003475278936093673, 0.0032146330158866476, 0.0029850163718947442, 
     0.002781492528356466, 0.0026000908417245228, 0.00243758516411674, 
     0.0022913300542697357, 0.002159137935754174, 0.0020391858282122755, 
     0.0019299437302723321, 0.0018301190545685908, 0.0017386131018401613, 
     0.0016544866614285406, 0.0015769325991740776, 0.0015052538446661652, 
     0.001438845586813246, 0.0013771807759498213, 0.0013197982436185787, 
     0.0012662929094178256, 0.0012163076629934377, 0.0011695265990321515, 
     0.001125669351568446, 0.0010844863265110638, 0.0010457546719928115, 
     0.0010092748578535273, 0.0009748677604267025, 0.0009423721684124791, 
     0.0009116426411816373, 0.0008825476632715851, 0.0008549680487943481, 
     0.0008287955575047252, 0.0008039316907795834, 0.0007802866410507722, 
     0.000757778372558923, 0.0007363318148449912, 0.0007158781533215192, 
     0.0006963542036854778, 0.0006777018589439025, 0.0006598675994980103, 
     0.0006428020581316825, 0.0006264596329249448, 0.0006107981421018212, 
     0.0005957785156566944, 0.0005813645193101615, 0.0005675225069456338, 
     0.0005542211981890955, 0.0005414314782308857, 0.0005291262173620019, 
     0.0005172801080180764, 0.0005058695174000306, 0.0004948723539782908, 
     0.00048426794639304176, 0.0004740369334410761, 0.000464161163994387, 
     0.0004546236058301188, 0.00044540826246869744, 0.0004365000972193235, 
     0.0004278849637215737, 0.0004195495423503742, 0.0004114812819205593, 
     0.00040366834618789046, 0.0003960995646968675, 0.00038876438757285146, 
     0.0003816528438977383, 0.00037475550334536956, 0.00036806344078563083, 
     0.00036156820359529616, 0.00035526178143956426, 0.0003491365783112959, 
     0.0003431853866355352, 0.00033740136326527336, 0.0003317780072108521, 
     0.0003263091389601238, 0.000320988881259687, 0.0003158116412393695, 
     0.00031077209377278377, 0.00030586516597637137, 0.0003010860227579906, 
     0.00029643005333389793, 0.00029189285864001177, 0.00028747023956970854, 
     0.00028315818597616295};
 
  TVIL_REAL Gx0yxytableCLy3[] = 
     {0, -0.25, -0.0625, -0.03125, -0.01953125, -0.013671875, 
     -0.01025390625, -0.008056640625, -0.0065460205078125, 
     -0.00545501708984375, -0.0046367645263671875, -0.004004478454589844, 
     -0.0035039186477661133, -0.0030996203422546387, -0.002767518162727356, 
     -0.0024907663464546204, -0.0022572570014744997, -0.002058087266050279, 
     -0.0018865799938794225, -0.0017376394680468366, -0.0016073165079433238, 
     -0.0014925081859473721, -0.001390746264178233, -0.0013000454208622614, 
     -0.00121879258205837, -0.0011456650271348678, -0.001079568967877087, 
     -0.0010195929141061377, -0.0009649718651361661, -0.0009150595272842954, 
     -0.0008693065509200806, -0.0008272433307142703, -0.0007884662995870388, 
     -0.0007526269223330826, -0.000719422793406623, -0.0006885903879749107, 
     -0.0006598991218092894, -0.0006331464547089128, -0.0006081538314967189, 
     -0.0005847632995160758, -0.000562834675784223, -0.0005422431632555319, 
     -0.0005228773359964058, -0.0005046374289267636, -0.00048743388021335127, 
     -0.00047118608420623954, -0.0004558213205908187, 
     -0.00044127383163579257, -0.00042748402439717406, 
     -0.0004143977787523626, -0.0004019658453897917, -0.0003901433205253861, 
     -0.0003788891862794615, -0.0003681659074224956, -0.0003579390766607596, 
     -0.0003481771018427389, -0.00033885092947195125, 
     -0.00032993379974900517, -0.0003214010290658412, -0.0003132298164624724, 
     -0.0003053990710509106, -0.0002978892578283472, -0.00029068225965508075, 
     -0.0002837612534728169, -0.00027711059909454774, -0.0002707157391154428, 
     -0.00026456310868100093, -0.0002586400540090382, -0.0002529347587000153, 
     -0.0002474361769891454, -0.00024213397319652088, 
     -0.00023701846672053806, -0.0002320805819971935, -0.0002273118029150594, 
     -0.00022270413123434872, -0.00021825004860966175, 
     -0.00021394248186078685, -0.0002097747711751871, 
     -0.00020574064096027966, -0.00020183417309394523, 
     -0.00019804978234843376, -0.00019438219378642573, 
     -0.00019082642194886916, -0.00018737775167268478, 
     -0.00018403172039281542, -0.00018078410179764808, 
     -0.00017763089071978213, -0.00017456828915564794, 
     -0.0001715926933177676, -0.00016870068163263668, 
     -0.00016588900360542605, -0.0001631545694800619, -0.0001604944406298435, 
     -0.00015790582061968474, -0.00015538604688639188, 
     -0.00015293258298818569, -0.0001505430113789953, 
     -0.00014821502666694897, -0.00014594642932000588, 
     -0.00014373511978485427, -0.00014157909298808148};
 
  TVIL_REAL Gx0yxytableB[] = 
     {8.751507168460932, 39.01679330540531, 7.804961923145032, 
     -2.416747298792531, 1.2757449243320103, -0.7940812864240877, 
     0.5410318271099598, -0.3913084517998365, 0.29547428982513474, 
     -0.23053521688505227, 0.18457020015913722, -0.1508906193766732, 
     0.12550793612875652, -0.10592498909007524, 0.0905145436505955, 
     -0.07818010596454696, 0.06816143789824881, -0.05991831250604587, 
     0.053058520768596455, -0.047291889870288296, 0.04240011203447841, 
     -0.03821646999163243, 0.0346119204934165, -0.03148535841399003, 
     0.028756687586750148, -0.026361811821224653, 0.024248962231435023, 
     -0.022375969164923213, 0.02070821145568135, -0.019217057778148517, 
     0.017878669896101512, -0.01667307505933088, 0.015583440670358367, 
     -0.01459550244578553, 0.013697110120304572, -0.012877863929761747, 
     0.012128821764114494, -0.011442261748956609, 0.010811488608828511, 
     -0.010230674843434649, 0.0096947297596221, -0.009199190925209945, 
     0.008740133772745148, -0.008314095973952544, 0.00791801389606395, 
     -0.0075491689885975695, 0.00720514236997362, -0.006883776214788855, 
     0.006583140805054327, -0.0063015063176681185, 0.006037318587595182, 
     -0.005789178220652017, 0.005555822538367324, -0.005336109925470262, 
     0.005129006222316194, -0.004933572863258485, 0.004748956510178485, 
     -0.004574379970119619, 0.004409134218842279, -0.004252571379404146, 
     0.004104098527599976, -0.0039631722150886214, 0.0038292936169567137, 
     -0.0037020042238552066, 0.003580882010133287, -0.003465538018939788, 
     0.003355613313356279, -0.003250776249507295, 0.003150720033458409, 
     -0.0030551605287244413, 0.002963834285502575, -0.002876496766430276, 
     0.0027929207468387588, -0.002712894870207096, 0.002636222341885001, 
     -0.002562719746198569, 0.002492215973828777, -0.002424551247896216, 
     0.002359576238530153, -0.0022971512568734542, 0.0022371455205007613, 
     -0.0021794364831257715, 0.002123909222261661, -0.0020704558791913214, 
     0.002018975146213722, -0.0019693717966701436, 0.001921556253728572, 
     -0.0018754441943241349, 0.0018309561850250852, -0.0017880173469233705, 
     0.0017465570469415099, -0.0017065086132077747, 0.0016678090723834553, 
     -0.0016303989070326572, 0.0015942218313096063, -0.0015592245834033722, 
     0.0015253567333275726, -0.0014925705047749028, 0.001460820609875031, 
     -0.0014300640958010056, 0.0014002602022651805};
 
  TVIL_REAL Gx0yxytableBL[] = 
     {26.047061595422754, 11.12196934962815, 0.060236592639416386, 
     0.83382603125595, -0.5792536067288443, 0.4006170726148297, 
     -0.2896553718493917, 0.218166449904722, -0.16989244653565094, 
     0.1359082857664532, -0.11113299439538593, 0.0925367032440314, 
     -0.07823222818335873, 0.0669980637764993, -0.05801671006962339, 
     0.0507249358053532, -0.04472474054085107, 0.03972856262662061, 
     -0.03552451707261328, 0.031953734154359204, -0.02889522393887134, 
     0.026255545186487872, -0.023961614182821833, 0.02195560975130917, 
     -0.020191304887546835, 0.018631386523225046, -0.01724547077749783, 
     0.0160086149823897, -0.014900189385866014, 0.013903012549590699, 
     -0.01300268232467161, 0.012187053452919372, -0.011445826199810938, 
     0.010770219854890684, -0.010152711670144754, 0.009586826669959692, 
     -0.009066967313430041, 0.008588274604278467, -0.00814651418480139, 
     0.007737982408087873, -0.0073594284821183464, 0.007007989618898591, 
     -0.006681136763688755, 0.006376628978159715, -0.006092474934121128, 
     0.005826900279998881, -0.005578319877940885, 0.0053453140994861315, 
     -0.00512660851200053, 0.004921056417515501, -0.004727623794678948, 
     0.004545376265923551, -0.004373467795630859, 0.004211130853036593, 
     -0.004057667829329148, 0.003912443533408805, -0.003774878603508114, 
     0.0036444437319005374, -0.0035206545508117415, 0.0034030671340588015, 
     -0.0032912740134634078, 0.003184900648193434, -0.003083602263359353, 
     0.0029870611033402383, -0.0028949838888365775, 0.0028070995467714965, 
     -0.0027231572894379497, 0.0026429249555803835, -0.0025661868858151138, 
     0.002492743427865207, -0.002422408200800419, 0.0023550085024908185, 
     -0.0022903832141309977, 0.0022283821599557996, -0.0021688651759177446, 
     0.002111701061949134, -0.0020567672327160835, 0.002003950532525778, 
     -0.0019531422294676304, 0.0019042408093810081, -0.0018571540713310242, 
     0.0018117930740118027, -0.0017680749297142029, 0.0017259195446968079, 
     -0.0016852542757987976, 0.0016460083425045013, -0.0016081184148788452, 
     0.0015715286135673523, -0.0015361607074737549, 0.0015019625425338745, 
     -0.0014689266681671143, 0.0014369487762451172, -0.0014060139656066895, 
     0.0013760626316070557, -0.0013470351696014404, 0.0013188719749450684, 
     -0.0012917518615722656, 0.0012652873992919922, -0.0012396574020385742, 
     0.0012149810791015625, -0.0011909008026123047};
 
  TVIL_REAL Gx0yxytableBL2[] = 
     {-9.954822555520437, -2.4548225555204377, 2., 
     -0.6666666666666666, 0.3333333333333333, -0.2, 0.13333333333333333, 
     -0.09523809523809523, 0.07142857142857142, -0.05555555555555555, 
     0.044444444444444446, -0.03636363636363636, 0.030303030303030304, 
     -0.02564102564102564, 0.02197802197802198, -0.01904761904761905, 
     0.016666666666666666, -0.014705882352941176, 0.013071895424836602, 
     -0.011695906432748537, 0.010526315789473684, -0.009523809523809525, 
     0.008658008658008658, -0.007905138339920948, 0.007246376811594203, 
     -0.006666666666666667, 0.006153846153846154, -0.005698005698005698, 
     0.005291005291005291, -0.0049261083743842365, 0.004597701149425287, 
     -0.004301075268817204, 0.004032258064516129, -0.003787878787878788, 
     0.0035650623885918, -0.0033613445378151263, 0.0031746031746031746, 
     -0.003003003003003003, 0.002844950213371266, -0.002699055330634278, 
     0.002564102564102564, -0.0024390243902439024, 0.0023228803716608595, 
     -0.0022148394241417496, 0.0021141649048625794, -0.00202020202020202, 
     0.001932367149758454, -0.0018501387604070306, 0.0017730496453900709, 
     -0.0017006802721088435, 0.0016326530612244899, -0.001568627450980392, 
     0.0015082956259426848, -0.001451378809869376, 0.001397624039133473, 
     -0.0013468013468013469, 0.0012987012987012987, -0.0012531328320802004, 
     0.0012099213551119178, -0.0011689070718877848, 0.0011299435028248588, 
     -0.001092896174863388, 0.0010576414595452142, -0.0010240655401945725, 
     0.000992063492063492, -0.0009615384615384616, 0.0009324009324009324, 
     -0.0009045680687471732, 0.000877963125548727, -0.0008525149190110827, 
     0.0008281573498964803, -0.0008048289738430583, 0.000782472613458529, 
     -0.00076103500761035, 0.0007404664938911515, -0.0007207207207207207, 
     0.0007017543859649122, -0.000683526999316473, 0.000666000666000666, 
     -0.0006491398896462187, 0.0006329113924050633, -0.0006172839506172839, 
     0.0006022282445046673, -0.0005877167205406994, 0.0005737234652897303, 
     -0.0005602240896358543, 0.0005471956224350205, -0.0005346164127238706, 
     0.0005224660397074191, -0.0005107252298263534, 0.0004993757802746567, 
     -0.0004884004884004884, 0.00047778308647873863, -0.0004675081813931744, 
     0.0004575611988103409, -0.0004479283314669653, 0.0004385964912280702, 
     -0.000429553264604811, 0.00042078687144961075, -0.00041228612657184083, 
     0.00040404040404040404};
 
  TVIL_REAL Gx0yxytableD[] = 
     {0, 4.400271436338192, 1.9561832400899384, -0.6730239324642008, 
     0.34064619612793184, -0.20313505419333897, 0.13384353246948916, 
     -0.09436824234370672, 0.06987932513608862, -0.053702450439594714, 
     0.04248777201239899, -0.03440982071506609, 0.028407531197181948, 
     -0.023831216880717675, 0.020265648611118153, -0.017435725068048066, 
     0.015153517703255353, -0.013287216577980194, 0.011742224662652486, 
     -0.010449267985817065, 0.009356702115349313, -0.008425407100353074, 
     0.0076253232595554325, -0.006933052759749258, 0.006330168770229858, 
     -0.0058020037448660395, 0.00533676800811008, -0.004924899799981756, 
     0.004558579960121476, -0.004231365342926175, 0.003937908949697009, 
     -0.00367374414345217, 0.0034351167384288716, -0.003218853219897276, 
     0.0030222564899193794, -0.0028430227699514352, 0.002679174900136256, 
     -0.0025290084453433105, 0.0023910478774625344, -0.0022640107404814885, 
     0.002146778181133461, -0.0020383705868831483, 0.0019379273456898859, 
     -0.001844689950622519, 0.0017579878331433483, -0.0016772264335406207, 
     0.0016018771142746419, -0.001531468598376676, 0.001465579675338144, 
     -0.0014038329647922021, 0.0013458895664813068, -0.0012914444556286603, 
     0.0012402225075042585, -0.001191975054944511, 0.0011464768988155198, 
     -0.0011035237046586321, 0.0010629297296143318, -0.0010245258326527448, 
     0.0009881577285147107, -0.0009536844518794798, 0.0009209770033575749, 
     -0.0008899171531476702, 0.0008603963817453624, -0.0008323149400713281, 
     0.0008055810138953937, -0.0007801099795519184, 0.0007558237397362546, 
     -0.0007326501296957291, 0.0007105223854257662, -0.0006893786665889554, 
     0.0006691616278221601, -0.000649818032909214, 0.0006312984069951541, 
     -0.000613556722619635, 0.0005965501158666975, -0.000580238629377573, 
     0.0005645849793629466, -0.0005495543440896759, 0.000535114171611686, 
     -0.0005212340047717636, 0.000507885321725526, -0.0004950413904353676, 
     0.0004826771357544999, -0.00047076901787253234, 0.0004592949210271694, 
     -0.0004482340515039011, 0.00043756684404908276, -0.0004272748759132959, 
     0.0004173407878228752, -0.0004077482112492797, 0.0003984817014097259, 
     -0.0003895266754891575, 0.00038086935562406876, -0.00037249671623365143, 
     0.0003643964353238682, -0.00035655684942591123, 0.000348966911862592, 
     -0.00034161615406495463, 0.0003344946496871858, -0.0003275929812910447, 
     0.00032090220939185246};
 
  TVIL_REAL Gx0yxytableDL[] = 
     {0, 3.8280463806552705, -0.7186975871035137, 0.3784547512567268, 
     -0.21063650083781785, 0.1325539635215082, -0.0907812133818719, 
     0.06597504133110907, -0.050081017333548354, 0.03929906895301394, 
     -0.031654006962666355, 0.026038650728431183, -0.021793919644668546, 
     0.01850782208501398, -0.015912181191932946, 0.013826383874892694, 
     -0.0121252037034915, 0.010719611627940944, -0.009544914374832871, 
     0.008553190097519628, -0.007708330608154795, 0.006982712350921383, 
     -0.006354912279747046, 0.005808110049436949, -0.005328950626614264, 
     0.004906721737679481, -0.0045327503727606525, 0.004199954135742959, 
     -0.003902503650555804, 0.0036355656864668854, -0.003395105678392765, 
     0.0031777344518070915, -0.002980588196221255, 0.0028012336937385147, 
     -0.0026375929077417956, 0.0024878825406246504, -0.0023505652588650997, 
     0.002224310080932076, -0.0021079600124528928, 0.002000505452068514, 
     -0.0019010622214051575, 0.0018088533226398211, -0.001723193718035323, 
     0.0016434775726020692, -0.0015691675146693972, 0.0014997855576746758, 
     -0.001434905395870267, 0.0013741458413592603, -0.0013171652132462131, 
     0.001263656524259754, -0.0012133433378965835, 0.0011659761914268696, 
     -0.0011213294981262981, 0.0010791988567408946, -0.0010393987081332866, 
     0.0010017602888404014, -0.0009661298393152576, 0.0009323670312635057, 
     -0.0009003435839839178, 0.0008699420441926421, -0.0008410547076230891, 
     0.0008135826638830532, -0.0007874349487280155, 0.0007625277901636503, 
     -0.0007387839366938157, 0.000716132057641887, -0.0006945062068416174, 
     0.0006738453421585733, -0.0006540928942973769, 0.0006351963792006063, 
     -0.0006171070490747443, 0.0005997795777057031, -0.0005831717762667979, 
     0.0005672443362886056, -0.000551960596863884, 0.0005372863335107966, 
     -0.0005231895664218565, 0.0005096403860907904, -0.0004966107945404667, 
     0.00048407456057684257, -0.0004720070876705368, 0.00046038529322254743, 
     -0.0004491874981067135, 0.00043839332550124605, -0.0004279836081271753, 
     0.00041794030310469884, -0.0004082464137207558, 0.0003988859174740542, 
     -0.00038984369982842006, 0.0003811054931627323, -0.0003726578204567475, 
     0.0003644879432975588, -0.00035658381383195256, 0.00034893403032609674, 
     -0.00034152779602632884, 0.0003343548810437499, -0.0003274055870112622, 
     0.0003206707142849531, -0.0003141415314826255, 0.00030780974717106507, 
     -0.00030166748353055087};
 
  TVIL_REAL Gx0yxytableDL2[] = 
     {0, -2., 0.5, -0.16666666666666666, 0.08333333333333333, -0.05, 
     0.03333333333333333, -0.023809523809523808, 0.017857142857142856, 
     -0.013888888888888888, 0.011111111111111112, -0.00909090909090909, 
     0.007575757575757576, -0.00641025641025641, 0.005494505494505495, 
     -0.004761904761904762, 0.004166666666666667, -0.003676470588235294, 
     0.0032679738562091504, -0.0029239766081871343, 0.002631578947368421, 
     -0.002380952380952381, 0.0021645021645021645, -0.001976284584980237, 
     0.0018115942028985507, -0.0016666666666666668, 0.0015384615384615385, 
     -0.0014245014245014246, 0.0013227513227513227, -0.0012315270935960591, 
     0.0011494252873563218, -0.001075268817204301, 0.0010080645161290322, 
     -0.000946969696969697, 0.00089126559714795, -0.0008403361344537816, 
     0.0007936507936507937, -0.0007507507507507507, 0.0007112375533428165, 
     -0.0006747638326585695, 0.000641025641025641, -0.0006097560975609756, 
     0.0005807200929152149, -0.0005537098560354374, 0.0005285412262156448, 
     -0.000505050505050505, 0.0004830917874396135, -0.00046253469010175765, 
     0.0004432624113475177, -0.00042517006802721087, 0.00040816326530612246, 
     -0.000392156862745098, 0.0003770739064856712, -0.000362844702467344, 
     0.00034940600978336826, -0.0003367003367003367, 0.0003246753246753247, 
     -0.0003132832080200501, 0.00030248033877797946, -0.0002922267679719462, 
     0.0002824858757062147, -0.000273224043715847, 0.00026441036488630354, 
     -0.0002560163850486431, 0.000248015873015873, -0.0002403846153846154, 
     0.0002331002331002331, -0.0002261420171867933, 0.00021949078138718174, 
     -0.00021312872975277067, 0.00020703933747412008, 
     -0.00020120724346076458, 0.00019561815336463224, -0.0001902587519025875, 
     0.00018511662347278786, -0.00018018018018018018, 0.00017543859649122806, 
     -0.00017088174982911826, 0.0001665001665001665, -0.0001622849724115547, 
     0.00015822784810126583, -0.00015432098765432098, 0.00015055706112616682, 
     -0.00014692918013517486, 0.00014343086632243257, 
     -0.00014005602240896358, 0.00013679890560875513, 
     -0.00013365410318096765, 0.00013061650992685477, 
     -0.00012768130745658836, 0.00012484394506866417, -0.0001221001221001221, 
     0.00011944577161968466, -0.0001168770453482936, 0.00011439029970258523, 
     -0.00011198208286674133, 0.00010964912280701755, 
     -0.00010738831615120275, 0.00010519671786240269, 
     -0.00010307153164296021, 0.00010101010101010101};
 
  TVIL_REAL Gx0yxytableE[] = 
     {-18.70693688512331, -4.854553937928337, 1.707639005699074, 
     0.3753025778145237, -0.12768829157951597, 0.01885701196516894, 
     0.022309001672815812, -0.03695784549002777, 0.04089425239365959, 
     -0.040410493696452596, 0.03815605257702752, -0.0352921490638091, 
     0.03233544756382356, -0.029510844158004063, 0.02690738970095761, 
     -0.024550292060310792, 0.022435255309136454, -0.02054519125280379, 
     0.018858403064691085, -0.01735254138548563, 0.01600643244148591, 
     -0.014800830119532553, 0.013718629281027236, -0.012744818074722, 
     0.011866313370467138, -0.011071753533685818, 0.010351285829832423, 
     -0.009696366174688071, 0.009099578631184418, -0.008554476718701758, 
     0.008055445953126631, -0.007597585831932088, 0.007176609038941609, 
     -0.006788755596193653, 0.0064307198322554535, -0.006099588257729945, 
     0.005792786681722136, -0.005508035138574047, 0.0052433094089048594, 
     -0.004996808108065671, 0.00476692447811565, -0.004552222158075516, 
     0.004351414324144829, -0.004163345689649295, 0.003986976936481331, 
     -0.0038213712182252036, 0.0036656824322207336, -0.0035191450054066773, 
     0.0033810649784942436, -0.0032508122061914, 0.0031278135189438806, 
     -0.0030115467149032, 0.0029015352703397916, -0.002797343673122116, 
     0.0026985732977016, -0.002604858751709167, 0.0025158646341377905, 
     -0.0024312826534512266, 0.0023508290610656448, -0.0022742423617004865, 
     0.002201281267255421, -0.0021317228652815725, 0.0020653609768937022, 
     -0.002002004682213104, 0.0019414769942200044, -0.0018836136642975344, 
     0.0018282621048242077, -0.0017752804159665684, 0.0017245365053789757, 
     -0.0016759072908677716, 0.001629277977251458, -0.0015845413996716975, 
     0.0015415974265029456, -0.0015003524157892038, 0.0014607187198199954, 
     -0.001422614233057266, 0.0013859619791516248, -0.001350689733249788, 
     0.001316729676203436, -0.001284018077650083, 0.001252495005255032, 
     -0.0012221040576853642, 0.0011927921191367194, -0.001164509133455322, 
     0.0011372078960947267, -0.0011108438623220606, 0.001085374970244747, 
     -0.001060761477368025, 0.0010369658095180474, -0.001013952421076635, 
     0.0009916876655734197, -0.0009701396757704294, 0.0009492782524543313, 
     -0.0009290747612235609, 0.0009095020366223349, -0.0008905342930318593, 
     0.0008721470417816007, -0.0008543170139909091, 0.0008370220886941054, 
     -0.0008202412258408634, 0.0008039544037987487};
 
  TVIL_REAL Gx0yxytableEL[] = 
     {16.128233394887786, -0.2559561126456432, 2.5503065678940287, 
     0.6653600395183402, -0.6455812461002074, 0.49454227816751295, 
     -0.3765805067709882, 0.292759077888949, -0.2328905478200722, 
     0.18916275616404243, -0.15643929541046278, 0.13139232091386321, 
     -0.11183214508626159, 0.09628454847536712, -0.08373305214701497, 
     0.07346073417991551, -0.06495130685471918, 0.05782586682819009, 
     -0.05180153683189991, 0.046663835040257166, -0.042247841250622864, 
     0.03842511849533557, -0.035094474512582935, 0.032175332103291106, 
     -0.02960290218981144, 0.027324622133798594, -0.02529749504441682, 
     0.023486079345508223, -0.021860953524643498, 0.020397532168197174, 
     -0.019075144505706878, 0.01787631110619555, -0.016786171560843655, 
     0.0157920282313464, -0.014882979960652824, 0.014049626057522281, 
     -0.01328382557844866, 0.012578500423580507, -0.011927473375032254, 
     0.011325334174728247, -0.010767328234418715, 0.01024926371482709, 
     -0.009767433592574091, 0.009318550017333564, -0.008899688795343976, 
     0.008508242254381253, -0.008141879076112846, 0.007798509944372226, 
     -0.007476258067457547, 0.007173433800616291, -0.006888512730290293, 
     0.00662011669130085, -0.006366997277257126, 0.006128021477211071, 
     -0.0059021591312025425, 0.005688471946394517, -0.005486103856012115, 
     0.005294272536878086, -0.005112261929264392, 0.004939415626083162, 
     -0.004775131017948303, 0.004618854097020269, -0.0044700748363431355, 
     0.004328323073036612, -0.004193164833576317, 0.004064199047778911, 
     -0.003941054605247276, 0.0038233877141250266, -0.0037108795272249007, 
     0.0036032340050692817, -0.0035001759892276077, 0.003401449462650049, 
     -0.0033068159765593354, 0.003216053225939869, -0.003128953757811554, 
     0.0030453237983424425, -0.002964982186479487, 0.0028877594031942117, 
     -0.002813496686678872, 0.002742045224913063, -0.002673265417971696, 
     0.002607026203280619, -0.00254320443776113, 0.0024816843314524116, 
     -0.002422356927772642, 0.0023651196260850056, -0.0023098757426823022, 
     0.0022565341067006363, -0.0022050086878249615, 0.0021552182529624747, 
     -0.002107086049338764, 0.0020605395117202466, -0.0020155099916883664, 
     0.0019719325070894542, -0.001929745509961639, 0.001888890671399328, 
     -0.001849312681958448, 0.0018109590663338202, -0.0017737800111552802, 
     0.001737728204852884, -0.001702758688635017};
 
  TVIL_REAL Gx0yxytableEL2[] = 
     {-8.682233833280657, 0.317766166719343, 3., -1., 0.5, -0.3, 
     0.2, -0.14285714285714285, 0.10714285714285714, -0.08333333333333333, 
     0.06666666666666667, -0.05454545454545454, 0.045454545454545456, 
     -0.038461538461538464, 0.03296703296703297, -0.02857142857142857, 0.025, 
     -0.022058823529411766, 0.0196078431372549, -0.017543859649122806, 
     0.015789473684210527, -0.014285714285714285, 0.012987012987012988, 
     -0.011857707509881422, 0.010869565217391304, -0.01, 
     0.009230769230769232, -0.008547008547008548, 0.007936507936507936, 
     -0.007389162561576354, 0.006896551724137931, -0.0064516129032258064, 
     0.006048387096774193, -0.005681818181818182, 0.0053475935828877, 
     -0.005042016806722689, 0.004761904761904762, -0.0045045045045045045, 
     0.004267425320056899, -0.004048582995951417, 0.0038461538461538464, 
     -0.003658536585365854, 0.003484320557491289, -0.0033222591362126247, 
     0.003171247357293869, -0.0030303030303030303, 0.002898550724637681, 
     -0.0027752081406105457, 0.0026595744680851063, -0.002551020408163265, 
     0.0024489795918367346, -0.002352941176470588, 0.0022624434389140274, 
     -0.0021770682148040637, 0.0020964360587002098, -0.00202020202020202, 
     0.001948051948051948, -0.0018796992481203006, 0.0018148820326678765, 
     -0.0017533606078316774, 0.001694915254237288, -0.001639344262295082, 
     0.0015864621893178213, -0.0015360983102918587, 0.001488095238095238, 
     -0.0014423076923076924, 0.0013986013986013986, -0.0013568521031207597, 
     0.0013169446883230904, -0.0012787723785166241, 0.0012422360248447205, 
     -0.0012072434607645875, 0.0011737089201877935, -0.001141552511415525, 
     0.0011106997408367272, -0.001081081081081081, 0.0010526315789473684, 
     -0.0010252904989747095, 0.000999000999000999, -0.0009737098344693282, 
     0.0009493670886075949, -0.000925925925925926, 0.0009033423667570009, 
     -0.000881575080811049, 0.0008605851979345956, -0.0008403361344537816, 
     0.0008207934336525308, -0.0008019246190858059, 0.0007836990595611285, 
     -0.0007660878447395301, 0.000749063670411985, -0.0007326007326007326, 
     0.000716674629718108, -0.0007012622720897616, 0.0006863417982155113, 
     -0.0006718924972004479, 0.0006578947368421052, -0.0006443298969072165, 
     0.0006311803071744162, -0.0006184291898577613, 0.0006060606060606061};

  if (y < 0.1545 * x) {
    result = TVIL_Gx000x (x, qq);
    result += y * (-(2.L/3.L) * lnbarx3 + lnbarx2 * lnbary); 
    rn = r = 4.L * y/x;
    for (n=1; n < 100; n++) {
      result += x * rn * (Gx0yxytableA[n] +
        Gx0yxytableALx[n] * lnbarx +
        Gx0yxytableALy[n] * lnbary +
        Gx0yxytableALx2[n] * lnbarx2 + 
        Gx0yxytableALxLy[n] * lnbarx * lnbary + 
        Gx0yxytableALy2[n] * lnbary2); 
      rn *= r;
    }
  } 
  else if (y < 0.5 * x) {
    result = (x/2.L + y/3.L) * lnbary3;
    rn = 1.L;
    r = 0.25L * x/y - 1.L;
    for (n=0; n < 100; n++) {
      result += y * rn * (
        Gx0yxytableE[n] +
        Gx0yxytableEL[n] * lnbary +
        Gx0yxytableEL2[n] * lnbary2);
      rn *= r;
    }
  }
  else if (y < 1.6 * x) {
    result = TVIL_Gx0xxx (x, qq);
    result += (y-x) * lnbarx3/3.L;
    rn = r = y/x - 1.L;
    for (n=1; n < 100; n++) {
      result += x * rn * (
        Gx0yxytableD[n] +
        Gx0yxytableDL[n] * lnbarx +
        Gx0yxytableDL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else if (y < 6.47 * x) {
    result = (x/2.L + y/3.L) * lnbarx3;
    rn = 1.L;
    r = 0.25L * y/x - 1.L;
    for (n=0; n < 100; n++) {
      result += x * rn * (
        Gx0yxytableB[n] +
        Gx0yxytableBL[n] * lnbarx +
        Gx0yxytableBL2[n] * lnbarx2);
      rn *= r;
    }
  }
  else {
    result = TVIL_G00x0x (y, qq);
    rn = r = 4.L * x/y;
    for (n=1; n < 100; n++) {
      result += y * rn * (
        Gx0yxytableC[n] +
        Gx0yxytableCLx[n] * lnbarx +
        Gx0yxytableCLy[n] * lnbary +
        Gx0yxytableCLx2[n] * lnbarx2 +
        Gx0yxytableCLxLy[n] * lnbarx * lnbary +
        Gx0yxytableCLy2[n] * lnbary2 +
        Gx0yxytableCLx2Ly[n] * lnbarx2 * lnbary +
        Gx0yxytableCLxLy2[n] * lnbarx * lnbary2 +
        Gx0yxytableCLy3[n] * lnbary3);
      rn *= r;
    }
  }

  return result;
}

/* ****************************************************************** */

int TVIL_AnalyticGTYPE (TVIL_GTYPE *foo, TVIL_REAL qq)
{
  int retval;
  TVIL_REAL x, u, v, y, z;
  TVIL_COMPLEX Au, Av, Ay, Az;
  TVIL_COMPLEX FBARu, FBARv, FBARy, FBARz;

  x = foo->arg[0];
  u = foo->arg[1];
  v = foo->arg[2];
  y = foo->arg[3];
  z = foo->arg[4];

  retval = TVIL_Ganalytic (x, u, v, y, z, qq,  &(foo->value));

  if (0 == retval) {

    if (SAME2(0,x)) {

      Au = TVIL_A (u, qq);
      Av = TVIL_A (v, qq);
      Ay = TVIL_A (y, qq);
      Az = TVIL_A (z, qq);

      if (SAME2(0,u)) FBARu = 0; else FBARu = *(foo->fval[0]);
      if (SAME2(0,v)) FBARv = 0; else FBARv = *(foo->fval[1]);
      if (SAME2(0,y)) FBARy = 0; else FBARy = *(foo->fval[2]);
      if (SAME2(0,z)) FBARz = 0; else FBARz = *(foo->fval[3]);

      if (SAME2(u,v)) {
	  foo->value = 2.0L*(
	      z * FBARz - (Az + z) * TVIL_I2(y,u,u,qq)
            - y * FBARy + (Ay + y) * TVIL_I2(z,u,u,qq)
            + (Az - Ay) * TVIL_I2(0,u,u,qq) + 0.25L * (y * Ay - z * Az))/(y - z)
            - FBARu + (Au/u + 1.L) * (TVIL_I2(u,y,z,qq) - TVIL_I2(0,y,z,qq)) 
            - Ay - Az + 0.25L * Au; 
      } 
      else if (SAME2(y,z)) {
	  foo->value = 2.0L*(
	      v * FBARv - (Av + v) * TVIL_I2(u,y,y,qq)
            - u * FBARu + (Au + u) * TVIL_I2(v,y,y,qq)
            + (Av - Au) * TVIL_I2(0,y,y,qq) + 0.25L * (u * Au - v * Av))/(u - v)
            - FBARy + (Ay/y + 1.L) * (TVIL_I2(y,u,v,qq) - TVIL_I2(0,u,v,qq)) 
            - Au - Av + 0.25L * Ay; 
      }
      else {
        foo->value = 
          (v * FBARv - (Av + v) * TVIL_I2(u,y,z,qq)
          -u * FBARu + (Au + u) * TVIL_I2(v,y,z,qq) +
          (Av - Au) * TVIL_I2(0,y,z,qq) + 0.25L * (u * Au - v * Av))/(u - v)
         +(z * FBARz - (Az + z) * TVIL_I2(y,u,v,qq) 
          -y * FBARy + (Ay + y) * TVIL_I2(z,u,v,qq) +
          (Az - Ay) * TVIL_I2(0,u,v,qq) + 0.25L * (y * Ay - z * Az))/(y - z)
         - 2.L * (u + v + y + z)/3.L;
      }
    }
  }

  return retval;
}

/* ****************************************************************** */

int TVIL_Ganalytic (TVIL_REAL a1,
		    TVIL_REAL a2,
		    TVIL_REAL a3,
		    TVIL_REAL a4,
		    TVIL_REAL a5,
		    TVIL_REAL QQ,
		    TVIL_COMPLEX *result)
{
  int success = 1;

  if (SAME6(0,a1,a2,a3,a4,a5))
    *result = TVIL_G00000 ();

  else if (SAME5(0,a2,a3,a4,a5))
    *result = TVIL_Gx0000 (a1, QQ);

  else if (SAME5(0,a1,a2,a3,a4))
    *result = TVIL_G0000x (a5, QQ);
  else if (SAME5(0,a1,a2,a3,a5))
    *result = TVIL_G0000x (a4, QQ);
  else if (SAME5(0,a1,a2,a4,a5))
    *result = TVIL_G0000x (a3, QQ);
  else if (SAME5(0,a1,a3,a4,a5))
    *result = TVIL_G0000x (a2, QQ);

  else if (SAME4(0,a1,a2,a3) && SAME2(a4,a5))
    *result = TVIL_G000xx (a5, QQ);
  else if (SAME4(0,a1,a4,a5) && SAME2(a2,a3))
    *result = TVIL_G000xx (a3, QQ);

  else if (SAME4(0,a2,a3,a4) && SAME2(a1,a5))
    *result = TVIL_Gx000x (a1, QQ);
  else if (SAME4(0,a2,a3,a5) && SAME2(a1,a4))
    *result = TVIL_Gx000x (a1, QQ);
  else if (SAME4(0,a2,a4,a5) && SAME2(a1,a3))
    *result = TVIL_Gx000x (a1, QQ);
  else if (SAME4(0,a3,a4,a5) && SAME2(a1,a2))
    *result = TVIL_Gx000x (a1, QQ);

  else if (SAME4(0,a1,a2,a4) && SAME2(a3,a5))
    *result = TVIL_G00x0x (a5, QQ);
  else if (SAME4(0,a1,a3,a4) && SAME2(a2,a5))
    *result = TVIL_G00x0x (a5, QQ);
  else if (SAME4(0,a1,a2,a5) && SAME2(a3,a4))
    *result = TVIL_G00x0x (a4, QQ);
  else if (SAME4(0,a1,a3,a5) && SAME2(a2,a4))
    *result = TVIL_G00x0x (a4, QQ);

  else if (SAME3(0,a1,a2) && SAME3(a3,a4,a5))
    *result = TVIL_G00xxx (a5, QQ);
  else if (SAME3(0,a1,a3) && SAME3(a2,a4,a5))
    *result = TVIL_G00xxx (a5, QQ);
  else if (SAME3(0,a1,a4) && SAME3(a2,a3,a5))
    *result = TVIL_G00xxx (a5, QQ);
  else if (SAME3(0,a1,a5) && SAME3(a2,a3,a4))
    *result = TVIL_G00xxx (a4, QQ);

  else if (SAME3(0,a2,a3) && SAME3(a1,a4,a5))
    *result = TVIL_Gx00xx (a1, QQ);
  else if (SAME3(0,a4,a5) && SAME3(a1,a2,a3))
    *result = TVIL_Gx00xx (a1, QQ);

  else if (SAME3(0,a2,a4) && SAME3(a1,a3,a5))
    *result = TVIL_Gx0x0x (a1, QQ);
  else if (SAME3(0,a3,a4) && SAME3(a1,a2,a5))
    *result = TVIL_Gx0x0x (a1, QQ);
  else if (SAME3(0,a2,a5) && SAME3(a1,a3,a4))
    *result = TVIL_Gx0x0x (a1, QQ);
  else if (SAME3(0,a3,a5) && SAME3(a1,a2,a4))
    *result = TVIL_Gx0x0x (a1, QQ);

  else if (SAME2(0,a2) && SAME4(a1,a3,a4,a5))
    *result = TVIL_Gx0xxx (a1, QQ);
  else if (SAME2(0,a3) && SAME4(a1,a2,a4,a5))
    *result = TVIL_Gx0xxx (a1, QQ);
  else if (SAME2(0,a4) && SAME4(a1,a2,a3,a5))
    *result = TVIL_Gx0xxx (a1, QQ);
  else if (SAME2(0,a5) && SAME4(a1,a2,a3,a4))
    *result = TVIL_Gx0xxx (a1, QQ);

  else if (SAME2(0,a1) && SAME4(a2,a3,a4,a5))
    *result = TVIL_G0xxxx (a5, QQ);

  else if (SAME5(a1,a2,a3,a4,a5))
    *result = TVIL_Gxxxxx (a1, QQ);

  else if (SAME4(0,a1,a2,a3) && (a4>0) && (a5>0))
    *result = TVIL_G000xy (a4, a5, QQ);
  else if (SAME4(0,a1,a4,a5) && (a2>0) && (a3>0))
    *result = TVIL_G000xy (a2, a3, QQ);

  else if (SAME4(0,a1,a2,a4) && (a3>0) && (a5>0))
    *result = TVIL_G00x0y (a3, a5, QQ);
  else if (SAME4(0,a1,a2,a5) && (a3>0) && (a4>0))
    *result = TVIL_G00x0y (a3, a4, QQ);
  else if (SAME4(0,a1,a3,a4) && (a2>0) && (a5>0))
    *result = TVIL_G00x0y (a2, a5, QQ);
  else if (SAME4(0,a1,a3,a5) && (a2>0) && (a4>0))
    *result = TVIL_G00x0y (a2, a4, QQ);

  else if (SAME4(0,a2,a3,a4) && (a1>0) && (a5>0)) 
    *result = TVIL_Gx000y (a1, a5, QQ);
  else if (SAME4(0,a2,a3,a5) && (a1>0) && (a4>0)) 
    *result = TVIL_Gx000y (a1, a4, QQ);
  else if (SAME4(0,a2,a4,a5) && (a1>0) && (a3>0)) 
    *result = TVIL_Gx000y (a1, a3, QQ);
  else if (SAME4(0,a3,a4,a5) && (a1>0) && (a2>0)) 
    *result = TVIL_Gx000y (a1, a2, QQ);

  else if (SAME3(0,a2,a3) && SAME2(a4,a5) && (a1>0) && (a5>0))
    *result = TVIL_Gx00yy (a1, a5, QQ);
  else if (SAME3(0,a4,a5) && SAME2(a2,a3) && (a1>0) && (a3>0))
    *result = TVIL_Gx00yy (a1, a3, QQ);

  else if (SAME3(0,a2,a4) && SAME2(a1,a3) && (a1>0) && (a5>0))
    *result = TVIL_Gx0x0y (a1, a5, QQ);
  else if (SAME3(0,a3,a4) && SAME2(a1,a2) && (a1>0) && (a5>0))
    *result = TVIL_Gx0x0y (a1, a5, QQ);
  else if (SAME3(0,a2,a5) && SAME2(a1,a3) && (a1>0) && (a4>0))
    *result = TVIL_Gx0x0y (a1, a4, QQ);
  else if (SAME3(0,a3,a5) && SAME2(a1,a2) && (a1>0) && (a4>0))
    *result = TVIL_Gx0x0y (a1, a4, QQ);

  else if (SAME3(0,a2,a4) && SAME2(a3,a5) && (a1>0) && (a3>0))
    *result = TVIL_Gx0y0y (a1, a3, QQ);
  else if (SAME3(0,a2,a5) && SAME2(a3,a4) && (a1>0) && (a3>0))
    *result = TVIL_Gx0y0y (a1, a3, QQ);
  else if (SAME3(0,a3,a4) && SAME2(a2,a5) && (a1>0) && (a2>0))
    *result = TVIL_Gx0y0y (a1, a2, QQ);
  else if (SAME3(0,a3,a5) && SAME2(a2,a4) && (a1>0) && (a2>0))
    *result = TVIL_Gx0y0y (a1, a2, QQ);

  else if (SAME3(0,a2,a4) && SAME2(a1,a5) && (a1>0) && (a3>0))
    *result = TVIL_Gx0x0y (a1, a3, QQ);
  else if (SAME3(0,a3,a4) && SAME2(a1,a5) && (a1>0) && (a2>0))
    *result = TVIL_Gx0x0y (a1, a2, QQ);
  else if (SAME3(0,a2,a5) && SAME2(a1,a4) && (a1>0) && (a3>0))
    *result = TVIL_Gx0x0y (a1, a3, QQ);
  else if (SAME3(0,a3,a5) && SAME2(a1,a4) && (a1>0) && (a2>0))
    *result = TVIL_Gx0x0y (a1, a2, QQ);

  else if (SAME2(0,a1) && SAME2(a2,a3) && SAME2(a4,a5) && (a3>0) && (a5>0))
    *result = TVIL_G0xxyy (a3, a5, QQ);

  else if (SAME2(0,a1) && SAME2(a2,a4) && SAME2(a3,a5) && (a2>0) && (a3>0))
    *result = TVIL_G0xyxy (a2, a3, QQ);
  else if (SAME2(0,a1) && SAME2(a2,a5) && SAME2(a3,a4) && (a2>0) && (a3>0))
    *result = TVIL_G0xyxy (a2, a3, QQ);

  else if (SAME3(0,a1,a2) && SAME2(a4,a5) && (a3>0) && (a4>0))
    *result = TVIL_G00yxx (a4, a3, QQ);
  else if (SAME3(0,a1,a3) && SAME2(a4,a5) && (a2>0) && (a4>0))
    *result = TVIL_G00yxx (a4, a2, QQ);
  else if (SAME3(0,a1,a4) && SAME2(a2,a3) && (a2>0) && (a5>0))
    *result = TVIL_G00yxx (a2, a5, QQ);
  else if (SAME3(0,a1,a5) && SAME2(a2,a3) && (a2>0) && (a4>0))
    *result = TVIL_G00yxx (a2, a4, QQ);

  else if (SAME3(0,a1,a2) && SAME2(a3,a4) && (a3>0) && (a5>0))
    *result = TVIL_G00xxy (a3, a5, QQ);
  else if (SAME3(0,a1,a2) && SAME2(a3,a5) && (a3>0) && (a4>0))
    *result = TVIL_G00xxy (a3, a4, QQ);
  else if (SAME3(0,a1,a3) && SAME2(a2,a4) && (a2>0) && (a5>0))
    *result = TVIL_G00xxy (a2, a5, QQ);
  else if (SAME3(0,a1,a3) && SAME2(a2,a5) && (a2>0) && (a4>0))
    *result = TVIL_G00xxy (a2, a4, QQ);
  else if (SAME3(0,a1,a4) && SAME2(a2,a5) && (a2>0) && (a3>0))
    *result = TVIL_G00xxy (a2, a3, QQ);
  else if (SAME3(0,a1,a4) && SAME2(a3,a5) && (a3>0) && (a2>0))
    *result = TVIL_G00xxy (a3, a2, QQ);
  else if (SAME3(0,a1,a5) && SAME2(a2,a4) && (a2>0) && (a3>0))
    *result = TVIL_G00xxy (a2, a3, QQ);
  else if (SAME3(0,a1,a5) && SAME2(a3,a4) && (a3>0) && (a2>0))
    *result = TVIL_G00xxy (a3, a2, QQ);

  else if (SAME2(0,a2) && SAME3(a1,a3,a4) && (a1 > 0) && (a5 > 0))
    *result = TVIL_Gx0xxy (a1, a5, QQ);
  else if (SAME2(0,a2) && SAME3(a1,a3,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0xxy (a1, a4, QQ);
  else if (SAME2(0,a3) && SAME3(a1,a2,a4) && (a1 > 0) && (a5 > 0))
    *result = TVIL_Gx0xxy (a1, a5, QQ);
  else if (SAME2(0,a3) && SAME3(a1,a2,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0xxy (a1, a4, QQ);
  else if (SAME2(0,a4) && SAME3(a1,a2,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0xxy (a1, a3, QQ);
  else if (SAME2(0,a4) && SAME3(a1,a3,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0xxy (a1, a2, QQ);
  else if (SAME2(0,a5) && SAME3(a1,a2,a4) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0xxy (a1, a3, QQ);
  else if (SAME2(0,a5) && SAME3(a1,a3,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0xxy (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME2(a1,a3) && SAME2(a4,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0xyy (a1, a4, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a2) && SAME2(a4,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx0xyy (a1, a4, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a5) && SAME2(a2,a3) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0xyy (a1, a2, QQ);
  else if (SAME2(0,a5) && SAME2(a1,a4) && SAME2(a2,a3) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0xyy (a1, a2, QQ);

  else if (SAME4(a2,a3,a4,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gyxxxx (a2, a1, QQ);

  else if (SAME3(a1,a2,a4) && SAME2(a3,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gxxyxy (a1, a3, QQ);
  else if (SAME3(a1,a2,a5) && SAME2(a3,a4) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gxxyxy (a1, a3, QQ);
  else if (SAME3(a1,a3,a4) && SAME2(a2,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gxxyxy (a1, a2, QQ);
  else if (SAME3(a1,a3,a5) && SAME2(a2,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gxxyxy (a1, a2, QQ);

  else if (SAME3(0,a2,a3) && SAME2(a1,a4) && (a1 > 0) && (a5 > 0))
    *result = TVIL_Gx00xy (a1, a5, QQ);
  else if (SAME3(0,a2,a3) && SAME2(a1,a5) && (a1 > 0) && (a4 > 0))
    *result = TVIL_Gx00xy (a1, a4, QQ);
  else if (SAME3(0,a4,a5) && SAME2(a1,a2) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx00xy (a1, a3, QQ);
  else if (SAME3(0,a4,a5) && SAME2(a1,a3) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx00xy (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME3(a3,a4,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gy0xxx (a3, a1, QQ);
  else if (SAME2(0,a3) && SAME3(a2,a4,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gy0xxx (a2, a1, QQ);
  else if (SAME2(0,a4) && SAME3(a2,a3,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gy0xxx (a2, a1, QQ);
  else if (SAME2(0,a5) && SAME3(a2,a3,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gy0xxx (a2, a1, QQ);

  else if (SAME2(0,a2) && SAME2(a1,a4) && SAME2(a3,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxy (a1, a3, QQ);
  else if (SAME2(0,a2) && SAME2(a1,a5) && SAME2(a3,a4) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxy (a1, a3, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a4) && SAME2(a2,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxy (a1, a2, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a5) && SAME2(a2,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxy (a1, a2, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a2) && SAME2(a3,a5) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxy (a1, a3, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a3) && SAME2(a2,a5) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxy (a1, a2, QQ);
  else if (SAME2(0,a5) && SAME2(a1,a2) && SAME2(a3,a4) && (a1 > 0) && (a3 > 0))
    *result = TVIL_Gx0yxy (a1, a3, QQ);
  else if (SAME2(0,a5) && SAME2(a1,a3) && SAME2(a2,a4) && (a1 > 0) && (a2 > 0))
    *result = TVIL_Gx0yxy (a1, a2, QQ);

  else
    success = 0;

  return success;
}

/* ****************************************************************** */
/* Sets initial value for an G function at a point near t = 0. */

int TVIL_InitialG (TVIL_GTYPE  *foo, 
		   TVIL_REAL    qq,
		   TVIL_COMPLEX tinit)
{
  TVIL_REAL w = (foo->arg[0])/a;
  TVIL_REAL u = (foo->arg[1])/a;
  TVIL_REAL z = (foo->arg[2])/a;
  TVIL_REAL v = (foo->arg[3])/a;
  TVIL_REAL y = (foo->arg[4])/a;

  TVIL_REAL Gexp[9];
  TVIL_REAL w2, w3, w4, w5, w6, w7, w8;
  TVIL_REAL u2, u3, u4, u5, u6, u7, u8;
  TVIL_REAL z2, z3, z4, z5, z6, z7, z8;
  TVIL_REAL v2, v3, v4, v5, v6, v7, v8;
  TVIL_REAL y2, y3, y4, y5, y6, y7, y8;

  TVIL_REAL lnbara, lnbara2, lnbara3;
  TVIL_COMPLEX ttothei, result;
  int i, nTerms = 9;

  lnbara = TVIL_LOG (a/qq);
  lnbara2 = lnbara*lnbara;
  lnbara3 = lnbara2*lnbara;

  w2 = w*w;
  w3 = w2*w;
  w4 = w2*w2;
  w5 = w2*w3;
  w6 = w3*w3;
  w7 = w4*w3;
  w8 = w4*w4;

  u2 = u*u;
  u3 = u2*u;
  u4 = u2*u2;
  u5 = u2*u3;
  u6 = u3*u3;
  u7 = u4*u3;
  u8 = u4*u4;

  z2 = z*z;
  z3 = z2*z;
  z4 = z2*z2;
  z5 = z2*z3;
  z6 = z3*z3;
  z7 = z4*z3;
  z8 = z4*z4;

  v2 = v*v;
  v3 = v2*v;
  v4 = v2*v2;
  v5 = v2*v3;
  v6 = v3*v3;
  v7 = v4*v3;
  v8 = v4*v4;

  y2 = y*y;
  y3 = y2*y;
  y4 = y2*y2;
  y5 = y2*y3;
  y6 = y3*y3;
  y7 = y4*y3;
  y8 = y4*y4;

  Gexp[0] = -11.057548482239014 + 18.968278283931625*lnbara - 8.*lnbara2 + 
     lnbara3;
 
  Gexp[1] = -7.910729801692609 - 2.9682782839316233*lnbara + 5.*lnbara2 - 
     1.*lnbara3 + 2.7480210450086475*u + 1.3280463806552705*lnbara*u - 
     1.*lnbara2*u + 0.16666666666666666*lnbara3*u + 2.7480210450086475*v + 
     1.3280463806552705*lnbara*v - 1.*lnbara2*v + 
     0.16666666666666666*lnbara3*v - 3.081354378341981*w - 
     2.343907238689459*lnbara*w - 1.*lnbara2*w + 0.3333333333333333*lnbara3*
      w + 2.7480210450086475*y + 1.3280463806552705*lnbara*y - 
     1.*lnbara2*y + 0.16666666666666666*lnbara3*y + 2.7480210450086475*z + 
     1.3280463806552705*lnbara*z - 1.*lnbara2*z + 
     0.16666666666666666*lnbara3*z;
 
  Gexp[2] = 1.4841391419658116 - 5.*lnbara + 1.5*lnbara2 - 
     1.3280463806552705*u + 2.*lnbara*u - 0.5*lnbara2*u - 
     0.16399130575669638*u2 - 0.2186975871035137*lnbara*u2 + 
     0.25*lnbara2*u2 - 1.3280463806552705*v + 2.*lnbara*v - 
     0.5*lnbara2*v + 1.7363044156749696*u*v - 0.16399130575669638*v2 - 
     0.2186975871035137*lnbara*v2 + 0.25*lnbara2*v2 + 
     2.343907238689459*w + 2.*lnbara*w - 1.*lnbara2*w - 
     0.7813024128964863*u*w - 0.7813024128964863*lnbara*u*w - 
     0.7813024128964863*v*w - 0.7813024128964863*lnbara*v*w + 
     0.39065120644824314*w2 + 0.5626048257929726*lnbara*w2 + 
     0.5*lnbara2*w2 - 1.3280463806552705*y + 2.*lnbara*y - 0.5*lnbara2*y + 
     1.7363044156749696*u*y - 1.0352774262847895*v*y - 
     0.7813024128964863*lnbara*v*y - 0.7813024128964863*w*y - 
     0.7813024128964863*lnbara*w*y - 0.16399130575669638*y2 - 
     0.2186975871035137*lnbara*y2 + 0.25*lnbara2*y2 - 
     1.3280463806552705*z + 2.*lnbara*z - 0.5*lnbara2*z - 
     1.0352774262847895*u*z - 0.7813024128964863*lnbara*u*z + 
     1.7363044156749696*v*z - 0.7813024128964863*w*z - 
     0.7813024128964863*lnbara*w*z + 1.7363044156749696*y*z - 
     0.16399130575669638*z2 - 0.2186975871035137*lnbara*z2 + 
     0.25*lnbara2*z2;
 
  Gexp[3] = 2.161379713988604 - 2.6666666666666665*lnbara + 0.5*lnbara2 - 
     1.6640231903276352*u + 1.5*lnbara*u - 0.25*lnbara2*u + 
     0.05470628134681734*u2 - 0.7186975871035137*lnbara*u2 + 
     0.25*lnbara2*u2 + 0.09882698433854777*u3 + 0.12845475125672678*lnbara*
      u3 - 0.08333333333333333*lnbara2*u3 - 1.6640231903276352*v + 
     1.5*lnbara*v - 0.25*lnbara2*v + 1.7363044156749696*u*v - 
     0.30106209007612295*u2*v + 0.05470628134681734*v2 - 
     0.7186975871035137*lnbara*v2 + 0.25*lnbara2*v2 - 
     0.30106209007612295*u*v2 + 0.09882698433854777*v3 + 
     0.12845475125672678*lnbara*v3 - 0.08333333333333333*lnbara2*v3 + 
     0.17195361934472944*w + 2.*lnbara*w - 0.5*lnbara2*w - 
     0.7813024128964863*lnbara*u*w + 0.11844729853083825*u2*w + 
     0.16666666666666666*lnbara*u2*w - 0.7813024128964863*lnbara*v*w - 
     0.20253427433816312*u*v*w + 0.11844729853083825*v2*w + 
     0.16666666666666666*lnbara*v2*w - 0.17195361934472944*w2 - 
     0.4373951742070274*lnbara*w2 + 0.5*lnbara2*w2 + 
     0.057317873114909816*u*w2 + 0.16666666666666666*lnbara*u*w2 + 
     0.057317873114909816*v*w2 + 0.16666666666666666*lnbara*v*w2 - 
     0.01910595770496994*w3 - 0.07642383081987976*lnbara*w3 - 
     0.16666666666666666*lnbara2*w3 - 1.6640231903276352*y + 1.5*lnbara*y - 
     0.25*lnbara2*y + 1.7363044156749696*u*y - 0.30106209007612295*u2*y - 
     0.2539750133883032*v*y - 0.7813024128964863*lnbara*v*y - 
     0.16476089051615736*u*v*y + 0.13248964725894694*v2*y + 
     0.16666666666666666*lnbara*v2*y - 0.7813024128964863*lnbara*w*y - 
     0.20253427433816312*u*w*y + 0.053538205384830104*v*w*y + 
     0.11463574622981963*lnbara*v*w*y + 0.057317873114909816*w2*y + 
     0.16666666666666666*lnbara*w2*y + 0.05470628134681734*y2 - 
     0.7186975871035137*lnbara*y2 + 0.25*lnbara2*y2 - 
     0.30106209007612295*u*y2 + 0.13248964725894694*v*y2 + 
     0.16666666666666666*lnbara*v*y2 + 0.11844729853083825*w*y2 + 
     0.16666666666666666*lnbara*w*y2 + 0.09882698433854777*y3 + 
     0.12845475125672678*lnbara*y3 - 0.08333333333333333*lnbara2*y3 - 
     1.6640231903276352*z + 1.5*lnbara*z - 0.25*lnbara2*z - 
     0.2539750133883032*u*z - 0.7813024128964863*lnbara*u*z + 
     0.13248964725894694*u2*z + 0.16666666666666666*lnbara*u2*z + 
     1.7363044156749696*v*z - 0.16476089051615736*u*v*z - 
     0.30106209007612295*v2*z - 0.7813024128964863*lnbara*w*z + 
     0.053538205384830104*u*w*z + 0.11463574622981963*lnbara*u*w*z - 
     0.20253427433816312*v*w*z + 0.057317873114909816*w2*z + 
     0.16666666666666666*lnbara*w2*z + 1.7363044156749696*y*z - 
     0.16476089051615736*u*y*z - 0.16476089051615736*v*y*z - 
     0.20253427433816312*w*y*z - 0.30106209007612295*y2*z + 
     0.05470628134681734*z2 - 0.7186975871035137*lnbara*z2 + 
     0.25*lnbara2*z2 + 0.13248964725894694*u*z2 + 
     0.16666666666666666*lnbara*u*z2 - 0.30106209007612295*v*z2 + 
     0.11844729853083825*w*z2 + 0.16666666666666666*lnbara*w*z2 - 
     0.30106209007612295*y*z2 + 0.09882698433854777*z3 + 
     0.12845475125672678*lnbara*z3 - 0.08333333333333333*lnbara2*z3;
 
  Gexp[4] = 1.7473565236609687 - 1.5833333333333333*lnbara + 0.25*lnbara2 - 
     1.6093487935517568*u + 1.1666666666666667*lnbara*u - 
     0.16666666666666666*lnbara2*u + 0.4140550748985742*u2 - 
     0.9686975871035137*lnbara*u2 + 0.25*lnbara2*u2 + 
     0.06919921742036875*u3 + 0.42357616918012025*lnbara*u3 - 
     0.16666666666666666*lnbara2*u3 - 0.05265271615074063*u4 - 
     0.07174761194892897*lnbara*u4 + 0.041666666666666664*lnbara2*u4 - 
     1.6093487935517568*v + 1.1666666666666667*lnbara*v - 
     0.16666666666666666*lnbara2*v + 1.7363044156749696*u*v - 
     0.6021241801522459*u2*v + 0.11595103369494308*u3*v + 
     0.4140550748985742*v2 - 0.9686975871035137*lnbara*v2 + 
     0.25*lnbara2*v2 - 0.6021241801522459*u*v2 + 
     0.059716839228361955*u2*v2 + 0.06919921742036875*v3 + 
     0.42357616918012025*lnbara*v3 - 0.16666666666666666*lnbara2*v3 + 
     0.11595103369494308*u*v3 - 0.05265271615074063*v4 - 
     0.07174761194892897*lnbara*v4 + 0.041666666666666664*lnbara2*v4 - 
     0.552030920436847*w + 1.6666666666666667*lnbara*w - 
     0.3333333333333333*lnbara2*w + 0.39065120644824314*u*w - 
     0.7813024128964863*lnbara*u*w + 0.07022793039500985*u2*w + 
     0.3333333333333333*lnbara*u2*w - 0.04387086136102624*u3*w - 
     0.06829286069220218*lnbara*u3*w + 0.39065120644824314*v*w - 
     0.7813024128964863*lnbara*v*w - 0.40506854867632625*u*v*w + 
     0.050239513929349555*u2*v*w + 0.07022793039500985*v2*w + 
     0.3333333333333333*lnbara*v2*w + 0.050239513929349555*u*v2*w - 
     0.04387086136102624*v3*w - 0.06829286069220218*lnbara*v3*w + 
     0.046743967758784255*w2 - 0.9373951742070274*lnbara*w2 + 
     0.5*lnbara2*w2 - 0.05203092043684704*u*w2 + 
     0.3333333333333333*lnbara*u*w2 - 0.012964544309194878*u2*w2 - 
     0.045121417923393456*lnbara*u2*w2 - 0.05203092043684704*v*w2 + 
     0.3333333333333333*lnbara*v*w2 + 0.06270564403669335*u*v*w2 - 
     0.012964544309194878*v2*w2 - 0.045121417923393456*lnbara*v2*w2 + 
     0.03821191540993988*w3 + 0.18048567169357382*lnbara*w3 - 
     0.3333333333333333*lnbara2*w3 - 0.012737305136646625*u*w3 - 
     0.06829286069220218*lnbara*u*w3 - 0.012737305136646625*v*w3 - 
     0.06829286069220218*lnbara*v*w3 + 0.0031843262841616564*w4 + 
     0.023171442768808725*lnbara*w4 + 0.08333333333333333*lnbara2*w4 - 
     1.6093487935517568*y + 1.1666666666666667*lnbara*y - 
     0.16666666666666666*lnbara2*y + 1.7363044156749696*u*y - 
     0.6021241801522459*u2*y + 0.11595103369494308*u3*y + 
     0.13667619305993997*v*y - 0.7813024128964863*lnbara*v*y - 
     0.3295217810323147*u*v*y + 0.03780687567263677*u2*v*y + 
     0.09831262785122723*v2*y + 0.3333333333333333*lnbara*v2*y + 
     0.04679101100870634*u*v2*y - 0.04661955884626616*v3*y - 
     0.06829286069220218*lnbara*v3*y + 0.39065120644824314*w*y - 
     0.7813024128964863*lnbara*w*y - 0.40506854867632625*u*w*y + 
     0.050239513929349555*u2*w*y - 0.007559335460159426*v*w*y + 
     0.22927149245963926*lnbara*v*w*y + 0.03934960244277067*u*v*w*y - 
     0.013165285552240471*v2*w*y - 0.03821191540993988*lnbara*v2*w*y - 
     0.05203092043684704*w2*y + 0.3333333333333333*lnbara*w2*y + 
     0.06270564403669335*u*w2*y - 0.009239363608210014*v*w2*y - 
     0.03821191540993988*lnbara*v*w2*y - 0.012737305136646625*w3*y - 
     0.06829286069220218*lnbara*w3*y + 0.4140550748985742*y2 - 
     0.9686975871035137*lnbara*y2 + 0.25*lnbara2*y2 - 
     0.6021241801522459*u*y2 + 0.059716839228361955*u2*y2 + 
     0.09831262785122723*v*y2 + 0.3333333333333333*lnbara*v*y2 + 
     0.04679101100870634*u*v*y2 - 0.01943534388880048*v2*y2 - 
     0.045121417923393456*lnbara*v2*y2 + 0.07022793039500985*w*y2 + 
     0.3333333333333333*lnbara*w*y2 + 0.050239513929349555*u*w*y2 - 
     0.013165285552240471*v*w*y2 - 0.03821191540993988*lnbara*v*w*y2 - 
     0.012964544309194878*w2*y2 - 0.045121417923393456*lnbara*w2*y2 + 
     0.06919921742036875*y3 + 0.42357616918012025*lnbara*y3 - 
     0.16666666666666666*lnbara2*y3 + 0.11595103369494308*u*y3 - 
     0.04661955884626616*v*y3 - 0.06829286069220218*lnbara*v*y3 - 
     0.04387086136102624*w*y3 - 0.06829286069220218*lnbara*w*y3 - 
     0.05265271615074063*y4 - 0.07174761194892897*lnbara*y4 + 
     0.041666666666666664*lnbara2*y4 - 1.6093487935517568*z + 
     1.1666666666666667*lnbara*z - 0.16666666666666666*lnbara2*z + 
     0.13667619305993997*u*z - 0.7813024128964863*lnbara*u*z + 
     0.09831262785122723*u2*z + 0.3333333333333333*lnbara*u2*z - 
     0.04661955884626616*u3*z - 0.06829286069220218*lnbara*u3*z + 
     1.7363044156749696*v*z - 0.3295217810323147*u*v*z + 
     0.04679101100870634*u2*v*z - 0.6021241801522459*v2*z + 
     0.03780687567263677*u*v2*z + 0.11595103369494308*v3*z + 
     0.39065120644824314*w*z - 0.7813024128964863*lnbara*w*z - 
     0.007559335460159426*u*w*z + 0.22927149245963926*lnbara*u*w*z - 
     0.013165285552240471*u2*w*z - 0.03821191540993988*lnbara*u2*w*z - 
     0.40506854867632625*v*w*z + 0.03934960244277067*u*v*w*z + 
     0.050239513929349555*v2*w*z - 0.05203092043684704*w2*z + 
     0.3333333333333333*lnbara*w2*z - 0.009239363608210014*u*w2*z - 
     0.03821191540993988*lnbara*u*w2*z + 0.06270564403669335*v*w2*z - 
     0.012737305136646625*w3*z - 0.06829286069220218*lnbara*w3*z + 
     1.7363044156749696*y*z - 0.3295217810323147*u*y*z + 
     0.04679101100870634*u2*y*z - 0.3295217810323147*v*y*z + 
     0.02739438320944513*u*v*y*z + 0.04679101100870634*v2*y*z - 
     0.40506854867632625*w*y*z + 0.03934960244277067*u*w*y*z + 
     0.03934960244277067*v*w*y*z + 0.06270564403669335*w2*y*z - 
     0.6021241801522459*y2*z + 0.03780687567263677*u*y2*z + 
     0.04679101100870634*v*y2*z + 0.050239513929349555*w*y2*z + 
     0.11595103369494308*y3*z + 0.4140550748985742*z2 - 
     0.9686975871035137*lnbara*z2 + 0.25*lnbara2*z2 + 
     0.09831262785122723*u*z2 + 0.3333333333333333*lnbara*u*z2 - 
     0.01943534388880048*u2*z2 - 0.045121417923393456*lnbara*u2*z2 - 
     0.6021241801522459*v*z2 + 0.04679101100870634*u*v*z2 + 
     0.059716839228361955*v2*z2 + 0.07022793039500985*w*z2 + 
     0.3333333333333333*lnbara*w*z2 - 0.013165285552240471*u*w*z2 - 
     0.03821191540993988*lnbara*u*w*z2 + 0.050239513929349555*v*w*z2 - 
     0.012964544309194878*w2*z2 - 0.045121417923393456*lnbara*w2*z2 - 
     0.6021241801522459*y*z2 + 0.04679101100870634*u*y*z2 + 
     0.03780687567263677*v*y*z2 + 0.050239513929349555*w*y*z2 + 
     0.059716839228361955*y2*z2 + 0.06919921742036875*z3 + 
     0.42357616918012025*lnbara*z3 - 0.16666666666666666*lnbara2*z3 - 
     0.04661955884626616*u*z3 - 0.06829286069220218*lnbara*u*z3 + 
     0.11595103369494308*v*z3 - 0.04387086136102624*w*z3 - 
     0.06829286069220218*lnbara*w*z3 + 0.11595103369494308*y*z3 - 
     0.05265271615074063*z4 - 0.07174761194892897*lnbara*z4 + 
     0.041666666666666664*lnbara2*z4;
 
  Gexp[5] = 1.3650805808632478 - 1.05*lnbara + 0.15*lnbara2 - 
     1.4986782618304844*u + 0.9583333333333334*lnbara*u - 0.125*lnbara2*u + 
     0.7369542705997454*u2 - 1.1353642537701805*lnbara*u2 + 
     0.25*lnbara2*u2 - 0.107989258459507*u3 + 0.802030920436847*lnbara*
      u3 - 0.25*lnbara2*u3 - 0.08621053650329293*u4 - 
     0.29857616918012025*lnbara*u4 + 0.125*lnbara2*u4 + 
     0.03227341274192837*u5 + 0.0450539635215082*lnbara*u5 - 
     0.025*lnbara2*u5 - 1.4986782618304844*v + 0.9583333333333334*lnbara*
      v - 0.125*lnbara2*v + 1.7363044156749696*u*v - 
     0.9031862702283687*u2*v + 0.34785310108482925*u3*v - 
     0.06059652683278195*u4*v + 0.7369542705997454*v2 - 
     1.1353642537701805*lnbara*v2 + 0.25*lnbara2*v2 - 
     0.9031862702283687*u*v2 + 0.17915051768508586*u2*v2 - 
     0.0237971369540094*u3*v2 - 0.107989258459507*v3 + 
     0.802030920436847*lnbara*v3 - 0.25*lnbara2*v3 + 
     0.34785310108482925*u*v3 - 0.0237971369540094*u2*v3 - 
     0.08621053650329293*v4 - 0.29857616918012025*lnbara*v4 + 
     0.125*lnbara2*v4 - 0.06059652683278195*u*v4 + 
     0.03227341274192837*v5 + 0.0450539635215082*lnbara*v5 - 
     0.025*lnbara2*v5 - 0.830689856994302*w + 1.4166666666666667*lnbara*w - 
     0.25*lnbara2*w + 0.6510853440804052*u*w - 0.7813024128964863*lnbara*u*
      w - 0.0613247710741519*u2*w + 0.5*lnbara*u2*w - 
     0.06331972339087655*u3*w - 0.20487858207660653*lnbara*u3*w + 
     0.022557055760128716*u4*w + 0.03665317578628961*lnbara*u4*w + 
     0.6510853440804052*v*w - 0.7813024128964863*lnbara*v*w - 
     0.6076028230144893*u*v*w + 0.15071854178804867*u2*v*w - 
     0.02150184968349584*u3*v*w - 0.0613247710741519*v2*w + 
     0.5*lnbara*v2*w + 0.15071854178804867*u*v2*w - 
     0.013018552693696988*u2*v2*w - 0.06331972339087655*v3*w - 
     0.20487858207660653*lnbara*v3*w - 0.02150184968349584*u*v3*w + 
     0.022557055760128716*v4*w + 0.03665317578628961*lnbara*v4*w + 
     0.3592090258277934*w2 - 1.2707285075403607*lnbara*w2 + 
     0.5*lnbara2*w2 - 0.24471304732193722*u*w2 + 0.5*lnbara*u*w2 + 
     0.006227784995808821*u2*w2 - 0.13536425377018038*lnbara*u2*w2 + 
     0.005325806143638784*u3*w2 + 0.020053963521508202*lnbara*u3*w2 - 
     0.24471304732193722*v*w2 + 0.5*lnbara*v*w2 + 
     0.18811693211008002*u*v*w2 - 0.017655955408877412*u2*v*w2 + 
     0.006227784995808821*v2*w2 - 0.13536425377018038*lnbara*v2*w2 - 
     0.017655955408877412*u*v2*w2 + 0.005325806143638784*v3*w2 + 
     0.020053963521508202*lnbara*v3*w2 - 0.032924962731877096*w3 + 
     0.6040618408736941*lnbara*w3 - 0.5*lnbara2*w3 + 
     0.030080945282262305*u*w3 - 0.20487858207660653*lnbara*u*w3 + 
     0.0033646110897693924*u2*w3 + 0.020053963521508202*lnbara*u2*w3 + 
     0.030080945282262305*v*w3 - 0.20487858207660653*lnbara*v*w3 - 
     0.028872460828119215*u*v*w3 + 0.0033646110897693924*v2*w3 + 
     0.020053963521508202*lnbara*v2*w3 - 0.013618463916323756*w4 - 
     0.0971523383602405*lnbara*w4 + 0.25*lnbara2*w4 + 
     0.0045394879721079185*u*w4 + 0.03665317578628961*lnbara*u*w4 + 
     0.0045394879721079185*v*w4 + 0.03665317578628961*lnbara*v*w4 - 
     0.0009078975944215837*w5 - 0.009892072956983595*lnbara*w5 - 
     0.05*lnbara2*w5 - 1.4986782618304844*y + 0.9583333333333334*lnbara*y - 
     0.125*lnbara2*y + 1.7363044156749696*u*y - 0.9031862702283687*u2*y + 
     0.34785310108482925*u3*y - 0.06059652683278195*u4*y + 
     0.39711033069210205*v*y - 0.7813024128964863*lnbara*v*y - 
     0.49428267154847205*u*v*y + 0.11342062701791031*u2*v*y - 
     0.01565521245743462*u3*v*y - 0.019197724889825834*v2*y + 
     0.5*lnbara*v2*y + 0.14037303302611903*u*v2*y - 
     0.011674571633666243*u2*v2*y - 0.0715658158465963*v3*y - 
     0.20487858207660653*lnbara*v3*y - 0.02071565770475219*u*v3*y + 
     0.023479470699086277*v4*y + 0.03665317578628961*lnbara*v4*y + 
     0.6510853440804052*w*y - 0.7813024128964863*lnbara*w*y - 
     0.6076028230144893*u*w*y + 0.15071854178804867*u2*w*y - 
     0.02150184968349584*u3*w*y - 0.12597474942005876*v*w*y + 
     0.3439072386894589*lnbara*v*w*y + 0.11804880732831201*u*v*w*y - 
     0.01059794141127439*u2*v*w*y - 0.001283941246781538*v2*w*y - 
     0.11463574622981963*lnbara*v2*w*y - 0.01426603512113796*u*v2*w*y + 
     0.005443587430075787*v3*w*y + 0.018157951888431674*lnbara*v3*w*y - 
     0.24471304732193722*w2*y + 0.5*lnbara*w2*y + 
     0.18811693211008002*u*w2*y - 0.017655955408877412*u2*w2*y + 
     0.010493824585309836*v*w2*y - 0.11463574622981963*lnbara*v*w2*y - 
     0.015437863995106367*u*v*w2*y + 0.0030128741217214736*v2*w2*y + 
     0.015040472641131153*lnbara*v2*w2*y + 0.030080945282262305*w3*y - 
     0.20487858207660653*lnbara*w3*y - 0.028872460828119215*u*w3*y + 
     0.002776802306005667*v*w3*y + 0.018157951888431674*lnbara*v*w3*y + 
     0.0045394879721079185*w4*y + 0.03665317578628961*lnbara*w4*y + 
     0.7369542705997454*y2 - 1.1353642537701805*lnbara*y2 + 
     0.25*lnbara2*y2 - 0.9031862702283687*u*y2 + 
     0.17915051768508586*u2*y2 - 0.0237971369540094*u3*y2 - 
     0.019197724889825834*v*y2 + 0.5*lnbara*v*y2 + 
     0.14037303302611903*u*v*y2 - 0.011674571633666243*u2*v*y2 - 
     0.013184613743007976*v2*y2 - 0.13536425377018038*lnbara*v2*y2 - 
     0.015726059911862465*u*v2*y2 + 0.006817830514839888*v3*y2 + 
     0.020053963521508202*lnbara*v3*y2 - 0.0613247710741519*w*y2 + 
     0.5*lnbara*w*y2 + 0.15071854178804867*u*w*y2 - 
     0.013018552693696988*u2*w*y2 - 0.001283941246781538*v*w*y2 - 
     0.11463574622981963*lnbara*v*w*y2 - 0.01426603512113796*u*v*w*y2 + 
     0.0037297504776935757*v2*w*y2 + 0.015040472641131153*lnbara*v2*w*
      y2 + 0.006227784995808821*w2*y2 - 0.13536425377018038*lnbara*w2*
      y2 - 0.017655955408877412*u*w2*y2 + 0.0030128741217214736*v*w2*
      y2 + 0.015040472641131153*lnbara*v*w2*y2 + 
     0.0033646110897693924*w3*y2 + 0.020053963521508202*lnbara*w3*y2 - 
     0.107989258459507*y3 + 0.802030920436847*lnbara*y3 - 
     0.25*lnbara2*y3 + 0.34785310108482925*u*y3 - 
     0.0237971369540094*u2*y3 - 0.0715658158465963*v*y3 - 
     0.20487858207660653*lnbara*v*y3 - 0.02071565770475219*u*v*y3 + 
     0.006817830514839888*v2*y3 + 0.020053963521508202*lnbara*v2*y3 - 
     0.06331972339087655*w*y3 - 0.20487858207660653*lnbara*w*y3 - 
     0.02150184968349584*u*w*y3 + 0.005443587430075787*v*w*y3 + 
     0.018157951888431674*lnbara*v*w*y3 + 0.005325806143638784*w2*y3 + 
     0.020053963521508202*lnbara*w2*y3 - 0.08621053650329293*y4 - 
     0.29857616918012025*lnbara*y4 + 0.125*lnbara2*y4 - 
     0.06059652683278195*u*y4 + 0.023479470699086277*v*y4 + 
     0.03665317578628961*lnbara*v*y4 + 0.022557055760128716*w*y4 + 
     0.03665317578628961*lnbara*w*y4 + 0.03227341274192837*y5 + 
     0.0450539635215082*lnbara*y5 - 0.025*lnbara2*y5 - 
     1.4986782618304844*z + 0.9583333333333334*lnbara*z - 0.125*lnbara2*z + 
     0.39711033069210205*u*z - 0.7813024128964863*lnbara*u*z - 
     0.019197724889825834*u2*z + 0.5*lnbara*u2*z - 
     0.0715658158465963*u3*z - 0.20487858207660653*lnbara*u3*z + 
     0.023479470699086277*u4*z + 0.03665317578628961*lnbara*u4*z + 
     1.7363044156749696*v*z - 0.49428267154847205*u*v*z + 
     0.14037303302611903*u2*v*z - 0.02071565770475219*u3*v*z - 
     0.9031862702283687*v2*z + 0.11342062701791031*u*v2*z - 
     0.011674571633666243*u2*v2*z + 0.34785310108482925*v3*z - 
     0.01565521245743462*u*v3*z - 0.06059652683278195*v4*z + 
     0.6510853440804052*w*z - 0.7813024128964863*lnbara*w*z - 
     0.12597474942005876*u*w*z + 0.3439072386894589*lnbara*u*w*z - 
     0.001283941246781538*u2*w*z - 0.11463574622981963*lnbara*u2*w*z + 
     0.005443587430075787*u3*w*z + 0.018157951888431674*lnbara*u3*w*z - 
     0.6076028230144893*v*w*z + 0.11804880732831201*u*v*w*z - 
     0.01426603512113796*u2*v*w*z + 0.15071854178804867*v2*w*z - 
     0.01059794141127439*u*v2*w*z - 0.02150184968349584*v3*w*z - 
     0.24471304732193722*w2*z + 0.5*lnbara*w2*z + 
     0.010493824585309836*u*w2*z - 0.11463574622981963*lnbara*u*w2*z + 
     0.0030128741217214736*u2*w2*z + 0.015040472641131153*lnbara*u2*w2*
      z + 0.18811693211008002*v*w2*z - 0.015437863995106367*u*v*w2*z - 
     0.017655955408877412*v2*w2*z + 0.030080945282262305*w3*z - 
     0.20487858207660653*lnbara*w3*z + 0.002776802306005667*u*w3*z + 
     0.018157951888431674*lnbara*u*w3*z - 0.028872460828119215*v*w3*z + 
     0.0045394879721079185*w4*z + 0.03665317578628961*lnbara*w4*z + 
     1.7363044156749696*y*z - 0.49428267154847205*u*y*z + 
     0.14037303302611903*u2*y*z - 0.02071565770475219*u3*y*z - 
     0.49428267154847205*v*y*z + 0.08218314962833538*u*v*y*z - 
     0.009158761699667091*u2*v*y*z + 0.14037303302611903*v2*y*z - 
     0.009158761699667091*u*v2*y*z - 0.02071565770475219*v3*y*z - 
     0.6076028230144893*w*y*z + 0.11804880732831201*u*w*y*z - 
     0.01426603512113796*u2*w*y*z + 0.11804880732831201*v*w*y*z - 
     0.008913056030998658*u*v*w*y*z - 0.01426603512113796*v2*w*y*z + 
     0.18811693211008002*w2*y*z - 0.015437863995106367*u*w2*y*z - 
     0.015437863995106367*v*w2*y*z - 0.028872460828119215*w3*y*z - 
     0.9031862702283687*y2*z + 0.11342062701791031*u*y2*z - 
     0.011674571633666243*u2*y2*z + 0.14037303302611903*v*y2*z - 
     0.009158761699667091*u*v*y2*z - 0.015726059911862465*v2*y2*z + 
     0.15071854178804867*w*y2*z - 0.01059794141127439*u*w*y2*z - 
     0.01426603512113796*v*w*y2*z - 0.017655955408877412*w2*y2*z + 
     0.34785310108482925*y3*z - 0.01565521245743462*u*y3*z - 
     0.02071565770475219*v*y3*z - 0.02150184968349584*w*y3*z - 
     0.06059652683278195*y4*z + 0.7369542705997454*z2 - 
     1.1353642537701805*lnbara*z2 + 0.25*lnbara2*z2 - 
     0.019197724889825834*u*z2 + 0.5*lnbara*u*z2 - 
     0.013184613743007976*u2*z2 - 0.13536425377018038*lnbara*u2*z2 + 
     0.006817830514839888*u3*z2 + 0.020053963521508202*lnbara*u3*z2 - 
     0.9031862702283687*v*z2 + 0.14037303302611903*u*v*z2 - 
     0.015726059911862465*u2*v*z2 + 0.17915051768508586*v2*z2 - 
     0.011674571633666243*u*v2*z2 - 0.0237971369540094*v3*z2 - 
     0.0613247710741519*w*z2 + 0.5*lnbara*w*z2 - 0.001283941246781538*u*w*
      z2 - 0.11463574622981963*lnbara*u*w*z2 + 0.0037297504776935757*u2*w*
      z2 + 0.015040472641131153*lnbara*u2*w*z2 + 
     0.15071854178804867*v*w*z2 - 0.01426603512113796*u*v*w*z2 - 
     0.013018552693696988*v2*w*z2 + 0.006227784995808821*w2*z2 - 
     0.13536425377018038*lnbara*w2*z2 + 0.0030128741217214736*u*w2*z2 + 
     0.015040472641131153*lnbara*u*w2*z2 - 0.017655955408877412*v*w2*z2 + 
     0.0033646110897693924*w3*z2 + 0.020053963521508202*lnbara*w3*z2 - 
     0.9031862702283687*y*z2 + 0.14037303302611903*u*y*z2 - 
     0.015726059911862465*u2*y*z2 + 0.11342062701791031*v*y*z2 - 
     0.009158761699667091*u*v*y*z2 - 0.011674571633666243*v2*y*z2 + 
     0.15071854178804867*w*y*z2 - 0.01426603512113796*u*w*y*z2 - 
     0.01059794141127439*v*w*y*z2 - 0.017655955408877412*w2*y*z2 + 
     0.17915051768508586*y2*z2 - 0.011674571633666243*u*y2*z2 - 
     0.011674571633666243*v*y2*z2 - 0.013018552693696988*w*y2*z2 - 
     0.0237971369540094*y3*z2 - 0.107989258459507*z3 + 
     0.802030920436847*lnbara*z3 - 0.25*lnbara2*z3 - 
     0.0715658158465963*u*z3 - 0.20487858207660653*lnbara*u*z3 + 
     0.006817830514839888*u2*z3 + 0.020053963521508202*lnbara*u2*z3 + 
     0.34785310108482925*v*z3 - 0.02071565770475219*u*v*z3 - 
     0.0237971369540094*v2*z3 - 0.06331972339087655*w*z3 - 
     0.20487858207660653*lnbara*w*z3 + 0.005443587430075787*u*w*z3 + 
     0.018157951888431674*lnbara*u*w*z3 - 0.02150184968349584*v*w*z3 + 
     0.005325806143638784*w2*z3 + 0.020053963521508202*lnbara*w2*z3 + 
     0.34785310108482925*y*z3 - 0.02071565770475219*u*y*z3 - 
     0.01565521245743462*v*y*z3 - 0.02150184968349584*w*y*z3 - 
     0.0237971369540094*y2*z3 - 0.08621053650329293*z4 - 
     0.29857616918012025*lnbara*z4 + 0.125*lnbara2*z4 + 
     0.023479470699086277*u*z4 + 0.03665317578628961*lnbara*u*z4 - 
     0.06059652683278195*v*z4 + 0.022557055760128716*w*z4 + 
     0.03665317578628961*lnbara*w*z4 - 0.06059652683278195*y*z4 + 
     0.03227341274192837*z5 + 0.0450539635215082*lnbara*z5 - 
     0.025*lnbara2*z5;
 
  Gexp[6] = 1.0850537205754986 - 0.75*lnbara + 0.1*lnbara2 - 
     1.390609276131054*u + 0.8166666666666667*lnbara*u - 0.1*lnbara2*u + 
     1.0207953340422906*u2 - 1.2603642537701805*lnbara*u2 + 
     0.25*lnbara2*u2 - 0.411329318091625*u3 + 1.2360412272491295*lnbara*
      u3 - 0.3333333333333333*lnbara2*u3 - 0.02313298841652572*u4 - 
     0.7221523383602405*lnbara*u4 + 0.25*lnbara2*u4 + 
     0.08403968744620527*u5 + 0.23021585408603282*lnbara*u5 - 
     0.1*lnbara2*u5 - 0.021741522654166835*u6 - 0.030781213381871893*
      lnbara*u6 + 0.016666666666666666*lnbara2*u6 - 1.390609276131054*v + 
     0.8166666666666667*lnbara*v - 0.1*lnbara2*v + 1.7363044156749696*u*v - 
     1.2042483603044918*u2*v + 0.6957062021696585*u3*v - 
     0.2423861073311278*u4*v + 0.037105667100660746*u5*v + 
     1.0207953340422906*v2 - 1.2603642537701805*lnbara*v2 + 
     0.25*lnbara2*v2 - 1.2042483603044918*u*v2 + 
     0.3583010353701717*u2*v2 - 0.0951885478160376*u3*v2 + 
     0.012603690943738541*u4*v2 - 0.411329318091625*v3 + 
     1.2360412272491295*lnbara*v3 - 0.3333333333333333*lnbara2*v3 + 
     0.6957062021696585*u*v3 - 0.0951885478160376*u2*v3 + 
     0.009594503638373669*u3*v3 - 0.02313298841652572*v4 - 
     0.7221523383602405*lnbara*v4 + 0.25*lnbara2*v4 - 
     0.2423861073311278*u*v4 + 0.012603690943738541*u2*v4 + 
     0.08403968744620527*v5 + 0.23021585408603282*lnbara*v5 - 
     0.1*lnbara2*v5 + 0.037105667100660746*u*v5 - 
     0.021741522654166835*v6 - 0.030781213381871893*lnbara*v6 + 
     0.016666666666666666*lnbara2*v6 - 0.9478852189287749*w + 
     1.2333333333333334*lnbara*w - 0.2*lnbara2*w + 0.8464109473045268*u*w - 
     0.7813024128964863*lnbara*u*w - 0.2484330280988692*u2*w + 
     0.6666666666666666*lnbara*u2*w - 0.02420015574344982*u3*w - 
     0.40975716415321306*lnbara*u3*w + 0.05357504725422525*u4*w + 
     0.14661270314515845*lnbara*u4*w - 0.013695633713123625*u5*w - 
     0.02276428689740073*lnbara*u5*w + 0.8464109473045268*v*w - 
     0.7813024128964863*lnbara*v*w - 0.8101370973526525*u*v*w + 
     0.30143708357609733*u2*v*w - 0.08600739873398336*u3*v*w + 
     0.011755626833308665*u4*v*w - 0.2484330280988692*v2*w + 
     0.6666666666666666*lnbara*v2*w + 0.30143708357609733*u*v2*w - 
     0.05207421077478795*u2*v2*w + 0.005666397839155122*u3*v2*w - 
     0.02420015574344982*v3*w - 0.40975716415321306*lnbara*v3*w - 
     0.08600739873398336*u*v3*w + 0.005666397839155122*u2*v3*w + 
     0.05357504725422525*v4*w + 0.14661270314515845*lnbara*v4*w + 
     0.011755626833308665*u*v4*w - 0.013695633713123625*v5*w - 
     0.02276428689740073*lnbara*v5*w + 0.6768911527128836*w2 - 
     1.5207285075403607*lnbara*w2 + 0.5*lnbara2*w2 - 
     0.492950729762583*u*w2 + 0.6666666666666666*lnbara*u*w2 + 
     0.08013769687670783*u2*w2 - 0.27072850754036076*lnbara*u2*w2 + 
     0.0012492610530469332*u3*w2 + 0.08021585408603281*lnbara*u3*w2 - 
     0.0028504812172850903*u4*w2 - 0.011178565512996366*lnbara*u4*w2 - 
     0.492950729762583*v*w2 + 0.6666666666666666*lnbara*v*w2 + 
     0.37623386422016003*u*v*w2 - 0.07062382163550965*u2*v*w2 + 
     0.007977294501053117*u3*v*w2 + 0.08013769687670783*v2*w2 - 
     0.27072850754036076*lnbara*v2*w2 - 0.07062382163550965*u*v2*w2 + 
     0.005057271046160232*u2*v2*w2 + 0.0012492610530469332*v3*w2 + 
     0.08021585408603281*lnbara*v3*w2 + 0.007977294501053117*u*v3*w2 - 
     0.0028504812172850903*v4*w2 - 0.011178565512996366*lnbara*v4*w2 - 
     0.24525389726706748*w3 + 1.1387491211649254*lnbara*w3 - 
     0.6666666666666666*lnbara2*w3 + 0.16260118160282788*u*w3 - 
     0.40975716415321306*lnbara*u*w3 - 0.0065955191624306325*u2*w3 + 
     0.08021585408603281*lnbara*u2*w3 - 0.0014691525048179737*u3*w3 - 
     0.009259259259259259*lnbara*u3*w3 + 0.16260118160282788*v*w3 - 
     0.40975716415321306*lnbara*v*w3 - 0.11548984331247686*u*v*w3 + 
     0.008605527574636129*u2*v*w3 - 0.0065955191624306325*v2*w3 + 
     0.08021585408603281*lnbara*v2*w3 + 0.008605527574636129*u*v2*w3 - 
     0.0014691525048179737*v3*w3 - 0.009259259259259259*lnbara*v3*w3 + 
     0.021339241347472736*w4 - 0.44430467672048096*lnbara*w4 + 
     0.5*lnbara2*w4 - 0.018495223897857942*u*w4 + 
     0.14661270314515845*lnbara*u*w4 - 0.0012913080119257936*u2*w4 - 
     0.011178565512996366*lnbara*u2*w4 - 0.018495223897857942*v*w4 + 
     0.14661270314515845*lnbara*v*w4 + 0.016324459572189313*u*v*w4 - 
     0.0012913080119257936*v2*w4 - 0.011178565512996366*lnbara*v2*w4 + 
     0.006260482579297259*w5 + 0.060431708172065626*lnbara*w5 - 
     0.2*lnbara2*w5 - 0.0020868275264324197*u*w5 - 
     0.02276428689740073*lnbara*u*w5 - 0.0020868275264324197*v*w5 - 
     0.02276428689740073*lnbara*v*w5 + 0.00034780458773873665*w6 + 
     0.0051042399029228806*lnbara*w6 + 0.03333333333333333*lnbara2*w6 - 
     1.390609276131054*y + 0.8166666666666667*lnbara*y - 0.1*lnbara2*y + 
     1.7363044156749696*u*y - 1.2042483603044918*u2*y + 
     0.6957062021696585*u3*y - 0.2423861073311278*u4*y + 
     0.037105667100660746*u5*y + 0.5924359339162236*v*y - 
     0.7813024128964863*lnbara*v*y - 0.6590435620646294*u*v*y + 
     0.22684125403582062*u2*v*y - 0.06262084982973848*u3*v*y + 
     0.008419189235014828*u4*v*y - 0.19226363318643444*v2*y + 
     0.6666666666666666*lnbara*v2*y + 0.28074606605223806*u*v2*y - 
     0.04669828653466497*u2*v2*y + 0.004986373961111605*u3*v2*y - 
     0.040692340654889324*v3*y - 0.40975716415321306*lnbara*v3*y - 
     0.08286263081900876*u*v3*y + 0.0053375013256957*u2*v3*y + 
     0.057264707010055496*v4*y + 0.14661270314515845*lnbara*v4*y + 
     0.01147557387202353*u*v4*y - 0.014106252009402123*v5*y - 
     0.02276428689740073*lnbara*v5*y + 0.8464109473045268*w*y - 
     0.7813024128964863*lnbara*w*y - 0.8101370973526525*u*w*y + 
     0.30143708357609733*u2*w*y - 0.08600739873398336*u3*w*y + 
     0.011755626833308665*u4*w*y - 0.282602078789898*v*w*y + 
     0.45854298491927853*lnbara*v*w*y + 0.23609761465662402*u*v*w*y - 
     0.04239176564509756*u2*v*w*y + 0.004682895552936569*u3*v*w*y + 
     0.054749990621346736*v2*w*y - 0.22927149245963926*lnbara*v2*w*y - 
     0.05706414048455184*u*v2*w*y + 0.003980640823768378*u2*v2*w*y + 
     0.003616397831871475*v3*w*y + 0.0726318075537267*lnbara*v3*w*y + 
     0.007014611167395649*u*v3*w*y - 0.002907169920654274*v4*w*y - 
     0.010434137632162098*lnbara*v4*w*y - 0.492950729762583*w2*y + 
     0.6666666666666666*lnbara*w2*y + 0.37623386422016003*u*w2*y - 
     0.07062382163550965*u2*w2*y + 0.007977294501053117*u3*w2*y + 
     0.07830552228552949*v*w2*y - 0.22927149245963926*lnbara*v*w2*y - 
     0.06175145598042547*u*v*w2*y + 0.004484885221839508*u2*v*w2*y - 
     0.002988976154245258*v2*w2*y + 0.06016189056452461*lnbara*v2*w2*y + 
     0.006275928094281939*u*v2*w2*y - 0.0013944676715588855*v3*w2*y - 
     0.007723814256269575*lnbara*v3*w2*y + 0.16260118160282788*w3*y - 
     0.40975716415321306*lnbara*w3*y - 0.11548984331247686*u*w3*y + 
     0.008605527574636129*u2*w3*y - 0.007050742664409005*v*w3*y + 
     0.0726318075537267*lnbara*v*w3*y + 0.00788494736258755*u*v*w3*y - 
     0.0010428464246845287*v2*w3*y - 0.007723814256269575*lnbara*v2*w3*
      y - 0.018495223897857942*w4*y + 0.14661270314515845*lnbara*w4*y + 
     0.016324459572189313*u*w4*y - 0.001136941590506995*v*w4*y - 
     0.010434137632162098*lnbara*v*w4*y - 0.0020868275264324197*w5*y - 
     0.02276428689740073*lnbara*w5*y + 1.0207953340422906*y2 - 
     1.2603642537701805*lnbara*y2 + 0.25*lnbara2*y2 - 
     1.2042483603044918*u*y2 + 0.3583010353701717*u2*y2 - 
     0.0951885478160376*u3*y2 + 0.012603690943738541*u4*y2 - 
     0.19226363318643444*v*y2 + 0.6666666666666666*lnbara*v*y2 + 
     0.28074606605223806*u*v*y2 - 0.04669828653466497*u2*v*y2 + 
     0.004986373961111605*u3*v*y2 + 0.04131289939907423*v2*y2 - 
     0.27072850754036076*lnbara*v2*y2 - 0.06290423964744986*u*v2*y2 + 
     0.004230734800403052*u2*v2*y2 + 0.0072173585378513495*v3*y2 + 
     0.08021585408603281*lnbara*v3*y2 + 0.0074775100099156964*u*v3*y2 - 
     0.003388712393218835*v4*y2 - 0.011178565512996366*lnbara*v4*y2 - 
     0.2484330280988692*w*y2 + 0.6666666666666666*lnbara*w*y2 + 
     0.30143708357609733*u*w*y2 - 0.05207421077478795*u2*w*y2 + 
     0.005666397839155122*u3*w*y2 + 0.054749990621346736*v*w*y2 - 
     0.22927149245963926*lnbara*v*w*y2 - 0.05706414048455184*u*v*w*y2 + 
     0.003980640823768378*u2*v*w*y2 - 0.00012147073035684983*v2*w*y2 + 
     0.06016189056452461*lnbara*v2*w*y2 + 0.006028211949364472*u*v2*w*
      y2 - 0.0016140025704639528*v3*w*y2 - 0.007723814256269575*lnbara*v3*
      w*y2 + 0.08013769687670783*w2*y2 - 0.27072850754036076*lnbara*w2*
      y2 - 0.07062382163550965*u*w2*y2 + 0.005057271046160232*u2*w2*
      y2 - 0.002988976154245258*v*w2*y2 + 0.06016189056452461*lnbara*v*w2*
      y2 + 0.006275928094281939*u*v*w2*y2 - 0.0011254688727941888*v2*w2*
      y2 - 0.00690950251345358*lnbara*v2*w2*y2 - 
     0.0065955191624306325*w3*y2 + 0.08021585408603281*lnbara*w3*y2 + 
     0.008605527574636129*u*w3*y2 - 0.0010428464246845287*v*w3*y2 - 
     0.007723814256269575*lnbara*v*w3*y2 - 0.0012913080119257936*w4*y2 - 
     0.011178565512996366*lnbara*w4*y2 - 0.411329318091625*y3 + 
     1.2360412272491295*lnbara*y3 - 0.3333333333333333*lnbara2*y3 + 
     0.6957062021696585*u*y3 - 0.0951885478160376*u2*y3 + 
     0.009594503638373669*u3*y3 - 0.040692340654889324*v*y3 - 
     0.40975716415321306*lnbara*v*y3 - 0.08286263081900876*u*v*y3 + 
     0.0053375013256957*u2*v*y3 + 0.0072173585378513495*v2*y3 + 
     0.08021585408603281*lnbara*v2*y3 + 0.0074775100099156964*u*v2*y3 - 
     0.0023345088047811496*v3*y3 - 0.009259259259259259*lnbara*v3*y3 - 
     0.02420015574344982*w*y3 - 0.40975716415321306*lnbara*w*y3 - 
     0.08600739873398336*u*w*y3 + 0.005666397839155122*u2*w*y3 + 
     0.003616397831871475*v*w*y3 + 0.0726318075537267*lnbara*v*w*y3 + 
     0.007014611167395649*u*v*w*y3 - 0.0016140025704639528*v2*w*y3 - 
     0.007723814256269575*lnbara*v2*w*y3 + 0.0012492610530469332*w2*y3 + 
     0.08021585408603281*lnbara*w2*y3 + 0.007977294501053117*u*w2*y3 - 
     0.0013944676715588855*v*w2*y3 - 0.007723814256269575*lnbara*v*w2*
      y3 - 0.0014691525048179737*w3*y3 - 0.009259259259259259*lnbara*w3*
      y3 - 0.02313298841652572*y4 - 0.7221523383602405*lnbara*y4 + 
     0.25*lnbara2*y4 - 0.2423861073311278*u*y4 + 
     0.012603690943738541*u2*y4 + 0.057264707010055496*v*y4 + 
     0.14661270314515845*lnbara*v*y4 + 0.01147557387202353*u*v*y4 - 
     0.003388712393218835*v2*y4 - 0.011178565512996366*lnbara*v2*y4 + 
     0.05357504725422525*w*y4 + 0.14661270314515845*lnbara*w*y4 + 
     0.011755626833308665*u*w*y4 - 0.002907169920654274*v*w*y4 - 
     0.010434137632162098*lnbara*v*w*y4 - 0.0028504812172850903*w2*y4 - 
     0.011178565512996366*lnbara*w2*y4 + 0.08403968744620527*y5 + 
     0.23021585408603282*lnbara*y5 - 0.1*lnbara2*y5 + 
     0.037105667100660746*u*y5 - 0.014106252009402123*v*y5 - 
     0.02276428689740073*lnbara*v*y5 - 0.013695633713123625*w*y5 - 
     0.02276428689740073*lnbara*w*y5 - 0.021741522654166835*y6 - 
     0.030781213381871893*lnbara*y6 + 0.016666666666666666*lnbara2*y6 - 
     1.390609276131054*z + 0.8166666666666667*lnbara*z - 0.1*lnbara2*z + 
     0.5924359339162236*u*z - 0.7813024128964863*lnbara*u*z - 
     0.19226363318643444*u2*z + 0.6666666666666666*lnbara*u2*z - 
     0.040692340654889324*u3*z - 0.40975716415321306*lnbara*u3*z + 
     0.057264707010055496*u4*z + 0.14661270314515845*lnbara*u4*z - 
     0.014106252009402123*u5*z - 0.02276428689740073*lnbara*u5*z + 
     1.7363044156749696*v*z - 0.6590435620646294*u*v*z + 
     0.28074606605223806*u2*v*z - 0.08286263081900876*u3*v*z + 
     0.01147557387202353*u4*v*z - 1.2042483603044918*v2*z + 
     0.22684125403582062*u*v2*z - 0.04669828653466497*u2*v2*z + 
     0.0053375013256957*u3*v2*z + 0.6957062021696585*v3*z - 
     0.06262084982973848*u*v3*z + 0.004986373961111605*u2*v3*z - 
     0.2423861073311278*v4*z + 0.008419189235014828*u*v4*z + 
     0.037105667100660746*v5*z + 0.8464109473045268*w*z - 
     0.7813024128964863*lnbara*w*z - 0.282602078789898*u*w*z + 
     0.45854298491927853*lnbara*u*w*z + 0.054749990621346736*u2*w*z - 
     0.22927149245963926*lnbara*u2*w*z + 0.003616397831871475*u3*w*z + 
     0.0726318075537267*lnbara*u3*w*z - 0.002907169920654274*u4*w*z - 
     0.010434137632162098*lnbara*u4*w*z - 0.8101370973526525*v*w*z + 
     0.23609761465662402*u*v*w*z - 0.05706414048455184*u2*v*w*z + 
     0.007014611167395649*u3*v*w*z + 0.30143708357609733*v2*w*z - 
     0.04239176564509756*u*v2*w*z + 0.003980640823768378*u2*v2*w*z - 
     0.08600739873398336*v3*w*z + 0.004682895552936569*u*v3*w*z + 
     0.011755626833308665*v4*w*z - 0.492950729762583*w2*z + 
     0.6666666666666666*lnbara*w2*z + 0.07830552228552949*u*w2*z - 
     0.22927149245963926*lnbara*u*w2*z - 0.002988976154245258*u2*w2*z + 
     0.06016189056452461*lnbara*u2*w2*z - 0.0013944676715588855*u3*w2*z - 
     0.007723814256269575*lnbara*u3*w2*z + 0.37623386422016003*v*w2*z - 
     0.06175145598042547*u*v*w2*z + 0.006275928094281939*u2*v*w2*z - 
     0.07062382163550965*v2*w2*z + 0.004484885221839508*u*v2*w2*z + 
     0.007977294501053117*v3*w2*z + 0.16260118160282788*w3*z - 
     0.40975716415321306*lnbara*w3*z - 0.007050742664409005*u*w3*z + 
     0.0726318075537267*lnbara*u*w3*z - 0.0010428464246845287*u2*w3*z - 
     0.007723814256269575*lnbara*u2*w3*z - 0.11548984331247686*v*w3*z + 
     0.00788494736258755*u*v*w3*z + 0.008605527574636129*v2*w3*z - 
     0.018495223897857942*w4*z + 0.14661270314515845*lnbara*w4*z - 
     0.001136941590506995*u*w4*z - 0.010434137632162098*lnbara*u*w4*z + 
     0.016324459572189313*v*w4*z - 0.0020868275264324197*w5*z - 
     0.02276428689740073*lnbara*w5*z + 1.7363044156749696*y*z - 
     0.6590435620646294*u*y*z + 0.28074606605223806*u2*y*z - 
     0.08286263081900876*u3*y*z + 0.01147557387202353*u4*y*z - 
     0.6590435620646294*v*y*z + 0.16436629925667076*u*v*y*z - 
     0.036635046798668365*u2*v*y*z + 0.004315701492296185*u3*v*y*z + 
     0.28074606605223806*v2*y*z - 0.036635046798668365*u*v2*y*z + 
     0.003284550249668572*u2*v2*y*z - 0.08286263081900876*v3*y*z + 
     0.004315701492296185*u*v3*y*z + 0.01147557387202353*v4*y*z - 
     0.8101370973526525*w*y*z + 0.23609761465662402*u*w*y*z - 
     0.05706414048455184*u2*w*y*z + 0.007014611167395649*u3*w*y*z + 
     0.23609761465662402*v*w*y*z - 0.03565222412399463*u*v*w*y*z + 
     0.003450745247535318*u2*v*w*y*z - 0.05706414048455184*v2*w*y*z + 
     0.003450745247535318*u*v2*w*y*z + 0.007014611167395649*v3*w*y*z + 
     0.37623386422016003*w2*y*z - 0.06175145598042547*u*w2*y*z + 
     0.006275928094281939*u2*w2*y*z - 0.06175145598042547*v*w2*y*z + 
     0.004023131071856042*u*v*w2*y*z + 0.006275928094281939*v2*w2*y*z - 
     0.11548984331247686*w3*y*z + 0.00788494736258755*u*w3*y*z + 
     0.00788494736258755*v*w3*y*z + 0.016324459572189313*w4*y*z - 
     1.2042483603044918*y2*z + 0.22684125403582062*u*y2*z - 
     0.04669828653466497*u2*y2*z + 0.0053375013256957*u3*y2*z + 
     0.28074606605223806*v*y2*z - 0.036635046798668365*u*v*y2*z + 
     0.003284550249668572*u2*v*y2*z - 0.06290423964744986*v2*y2*z + 
     0.003549498037785102*u*v2*y2*z + 0.0074775100099156964*v3*y2*z + 
     0.30143708357609733*w*y2*z - 0.04239176564509756*u*w*y2*z + 
     0.003980640823768378*u2*w*y2*z - 0.05706414048455184*v*w*y2*z + 
     0.003450745247535318*u*v*w*y2*z + 0.006028211949364472*v2*w*y2*z - 
     0.07062382163550965*w2*y2*z + 0.004484885221839508*u*w2*y2*z + 
     0.006275928094281939*v*w2*y2*z + 0.008605527574636129*w3*y2*z + 
     0.6957062021696585*y3*z - 0.06262084982973848*u*y3*z + 
     0.004986373961111605*u2*y3*z - 0.08286263081900876*v*y3*z + 
     0.004315701492296185*u*v*y3*z + 0.0074775100099156964*v2*y3*z - 
     0.08600739873398336*w*y3*z + 0.004682895552936569*u*w*y3*z + 
     0.007014611167395649*v*w*y3*z + 0.007977294501053117*w2*y3*z - 
     0.2423861073311278*y4*z + 0.008419189235014828*u*y4*z + 
     0.01147557387202353*v*y4*z + 0.011755626833308665*w*y4*z + 
     0.037105667100660746*y5*z + 1.0207953340422906*z2 - 
     1.2603642537701805*lnbara*z2 + 0.25*lnbara2*z2 - 
     0.19226363318643444*u*z2 + 0.6666666666666666*lnbara*u*z2 + 
     0.04131289939907423*u2*z2 - 0.27072850754036076*lnbara*u2*z2 + 
     0.0072173585378513495*u3*z2 + 0.08021585408603281*lnbara*u3*z2 - 
     0.003388712393218835*u4*z2 - 0.011178565512996366*lnbara*u4*z2 - 
     1.2042483603044918*v*z2 + 0.28074606605223806*u*v*z2 - 
     0.06290423964744986*u2*v*z2 + 0.0074775100099156964*u3*v*z2 + 
     0.3583010353701717*v2*z2 - 0.04669828653466497*u*v2*z2 + 
     0.004230734800403052*u2*v2*z2 - 0.0951885478160376*v3*z2 + 
     0.004986373961111605*u*v3*z2 + 0.012603690943738541*v4*z2 - 
     0.2484330280988692*w*z2 + 0.6666666666666666*lnbara*w*z2 + 
     0.054749990621346736*u*w*z2 - 0.22927149245963926*lnbara*u*w*z2 - 
     0.00012147073035684983*u2*w*z2 + 0.06016189056452461*lnbara*u2*w*
      z2 - 0.0016140025704639528*u3*w*z2 - 0.007723814256269575*lnbara*u3*
      w*z2 + 0.30143708357609733*v*w*z2 - 0.05706414048455184*u*v*w*z2 + 
     0.006028211949364472*u2*v*w*z2 - 0.05207421077478795*v2*w*z2 + 
     0.003980640823768378*u*v2*w*z2 + 0.005666397839155122*v3*w*z2 + 
     0.08013769687670783*w2*z2 - 0.27072850754036076*lnbara*w2*z2 - 
     0.002988976154245258*u*w2*z2 + 0.06016189056452461*lnbara*u*w2*z2 - 
     0.0011254688727941888*u2*w2*z2 - 0.00690950251345358*lnbara*u2*w2*
      z2 - 0.07062382163550965*v*w2*z2 + 0.006275928094281939*u*v*w2*
      z2 + 0.005057271046160232*v2*w2*z2 - 0.0065955191624306325*w3*
      z2 + 0.08021585408603281*lnbara*w3*z2 - 0.0010428464246845287*u*w3*
      z2 - 0.007723814256269575*lnbara*u*w3*z2 + 
     0.008605527574636129*v*w3*z2 - 0.0012913080119257936*w4*z2 - 
     0.011178565512996366*lnbara*w4*z2 - 1.2042483603044918*y*z2 + 
     0.28074606605223806*u*y*z2 - 0.06290423964744986*u2*y*z2 + 
     0.0074775100099156964*u3*y*z2 + 0.22684125403582062*v*y*z2 - 
     0.036635046798668365*u*v*y*z2 + 0.003549498037785102*u2*v*y*z2 - 
     0.04669828653466497*v2*y*z2 + 0.003284550249668572*u*v2*y*z2 + 
     0.0053375013256957*v3*y*z2 + 0.30143708357609733*w*y*z2 - 
     0.05706414048455184*u*w*y*z2 + 0.006028211949364472*u2*w*y*z2 - 
     0.04239176564509756*v*w*y*z2 + 0.003450745247535318*u*v*w*y*z2 + 
     0.003980640823768378*v2*w*y*z2 - 0.07062382163550965*w2*y*z2 + 
     0.006275928094281939*u*w2*y*z2 + 0.004484885221839508*v*w2*y*z2 + 
     0.008605527574636129*w3*y*z2 + 0.3583010353701717*y2*z2 - 
     0.04669828653466497*u*y2*z2 + 0.004230734800403052*u2*y2*z2 - 
     0.04669828653466497*v*y2*z2 + 0.003284550249668572*u*v*y2*z2 + 
     0.004230734800403052*v2*y2*z2 - 0.05207421077478795*w*y2*z2 + 
     0.003980640823768378*u*w*y2*z2 + 0.003980640823768378*v*w*y2*z2 + 
     0.005057271046160232*w2*y2*z2 - 0.0951885478160376*y3*z2 + 
     0.004986373961111605*u*y3*z2 + 0.0053375013256957*v*y3*z2 + 
     0.005666397839155122*w*y3*z2 + 0.012603690943738541*y4*z2 - 
     0.411329318091625*z3 + 1.2360412272491295*lnbara*z3 - 
     0.3333333333333333*lnbara2*z3 - 0.040692340654889324*u*z3 - 
     0.40975716415321306*lnbara*u*z3 + 0.0072173585378513495*u2*z3 + 
     0.08021585408603281*lnbara*u2*z3 - 0.0023345088047811496*u3*z3 - 
     0.009259259259259259*lnbara*u3*z3 + 0.6957062021696585*v*z3 - 
     0.08286263081900876*u*v*z3 + 0.0074775100099156964*u2*v*z3 - 
     0.0951885478160376*v2*z3 + 0.0053375013256957*u*v2*z3 + 
     0.009594503638373669*v3*z3 - 0.02420015574344982*w*z3 - 
     0.40975716415321306*lnbara*w*z3 + 0.003616397831871475*u*w*z3 + 
     0.0726318075537267*lnbara*u*w*z3 - 0.0016140025704639528*u2*w*z3 - 
     0.007723814256269575*lnbara*u2*w*z3 - 0.08600739873398336*v*w*z3 + 
     0.007014611167395649*u*v*w*z3 + 0.005666397839155122*v2*w*z3 + 
     0.0012492610530469332*w2*z3 + 0.08021585408603281*lnbara*w2*z3 - 
     0.0013944676715588855*u*w2*z3 - 0.007723814256269575*lnbara*u*w2*
      z3 + 0.007977294501053117*v*w2*z3 - 0.0014691525048179737*w3*z3 - 
     0.009259259259259259*lnbara*w3*z3 + 0.6957062021696585*y*z3 - 
     0.08286263081900876*u*y*z3 + 0.0074775100099156964*u2*y*z3 - 
     0.06262084982973848*v*y*z3 + 0.004315701492296185*u*v*y*z3 + 
     0.004986373961111605*v2*y*z3 - 0.08600739873398336*w*y*z3 + 
     0.007014611167395649*u*w*y*z3 + 0.004682895552936569*v*w*y*z3 + 
     0.007977294501053117*w2*y*z3 - 0.0951885478160376*y2*z3 + 
     0.0053375013256957*u*y2*z3 + 0.004986373961111605*v*y2*z3 + 
     0.005666397839155122*w*y2*z3 + 0.009594503638373669*y3*z3 - 
     0.02313298841652572*z4 - 0.7221523383602405*lnbara*z4 + 
     0.25*lnbara2*z4 + 0.057264707010055496*u*z4 + 
     0.14661270314515845*lnbara*u*z4 - 0.003388712393218835*u2*z4 - 
     0.011178565512996366*lnbara*u2*z4 - 0.2423861073311278*v*z4 + 
     0.01147557387202353*u*v*z4 + 0.012603690943738541*v2*z4 + 
     0.05357504725422525*w*z4 + 0.14661270314515845*lnbara*w*z4 - 
     0.002907169920654274*u*w*z4 - 0.010434137632162098*lnbara*u*w*z4 + 
     0.011755626833308665*v*w*z4 - 0.0028504812172850903*w2*z4 - 
     0.011178565512996366*lnbara*w2*z4 - 0.2423861073311278*y*z4 + 
     0.01147557387202353*u*y*z4 + 0.008419189235014828*v*y*z4 + 
     0.011755626833308665*w*y*z4 + 0.012603690943738541*y2*z4 + 
     0.08403968744620527*z5 + 0.23021585408603282*lnbara*z5 - 
     0.1*lnbara2*z5 - 0.014106252009402123*u*z5 - 
     0.02276428689740073*lnbara*u*z5 + 0.037105667100660746*v*z5 - 
     0.013695633713123625*w*z5 - 0.02276428689740073*lnbara*w*z5 + 
     0.037105667100660746*y*z5 - 0.021741522654166835*z6 - 
     0.030781213381871893*lnbara*z6 + 0.016666666666666666*lnbara2*z6;
 
  Gexp[7] = 0.882181228982499 - 0.5642857142857143*lnbara + 
     0.07142857142857142*lnbara2 - 1.2949521745536563*u + 
     0.7138888888888889*lnbara*u - 0.08333333333333333*lnbara2*u + 
     1.2728681847963266*u2 - 1.3603642537701803*lnbara*u2 + 
     0.25*lnbara2*u2 - 0.8231719544268136*u3 + 1.7117182007280785*lnbara*
      u3 - 0.4166666666666667*lnbara2*u3 + 0.20216246542587063*u4 - 
     1.3702538972670675*lnbara*u4 + 0.4166666666666667*lnbara2*u4 + 
     0.09499129157249676*u5 + 0.675539635215082*lnbara*u5 - 
     0.25*lnbara2*u5 - 0.07792639988896227*u6 - 0.1872394002426928*lnbara*
      u6 + 0.08333333333333333*lnbara2*u6 + 0.01562557344501031*u7 + 
     0.02232424768031541*lnbara*u7 - 0.011904761904761904*lnbara2*u7 - 
     1.2949521745536563*v + 0.7138888888888889*lnbara*v - 
     0.08333333333333333*lnbara2*v + 1.7363044156749696*u*v - 
     1.5053104503806145*u2*v + 1.1595103369494308*u3*v - 
     0.6059652683278195*u4*v + 0.18552833550330372*u5*v - 
     0.02502340865562592*u6*v + 1.2728681847963266*v2 - 
     1.3603642537701803*lnbara*v2 + 0.25*lnbara2*v2 - 
     1.5053104503806145*u*v2 + 0.5971683922836196*u2*v2 - 
     0.23797136954009399*u3*v2 + 0.0630184547186927*u4*v2 - 
     0.007769887708739977*u5*v2 - 0.8231719544268136*v3 + 
     1.7117182007280785*lnbara*v3 - 0.4166666666666667*lnbara2*v3 + 
     1.1595103369494308*u*v3 - 0.23797136954009399*u2*v3 + 
     0.04797251819186834*u3*v3 - 0.005107942897122393*u4*v3 + 
     0.20216246542587063*v4 - 1.3702538972670675*lnbara*v4 + 
     0.4166666666666667*lnbara2*v4 - 0.6059652683278195*u*v4 + 
     0.0630184547186927*u2*v4 - 0.005107942897122393*u3*v4 + 
     0.09499129157249676*v5 + 0.675539635215082*lnbara*v5 - 
     0.25*lnbara2*v5 + 0.18552833550330372*u*v5 - 
     0.007769887708739977*u2*v5 - 0.07792639988896227*v6 - 
     0.1872394002426928*lnbara*v6 + 0.08333333333333333*lnbara2*v6 - 
     0.02502340865562592*u*v6 + 0.01562557344501031*v7 + 
     0.02232424768031541*lnbara*v7 - 0.011904761904761904*lnbara2*v7 - 
     0.9954599046628679*w + 1.0944444444444446*lnbara*w - 
     0.16666666666666666*lnbara2*w + 1.0026714298838242*u*w - 
     0.7813024128964863*lnbara*u*w - 0.47720795179025316*u2*w + 
     0.8333333333333334*lnbara*u2*w + 0.09625212847865466*u3*w - 
     0.6829286069220218*lnbara*u3*w + 0.0606312665629839*u4*w + 
     0.36653175786289616*lnbara*u4*w - 0.0457138816682174*u5*w - 
     0.11382143448700363*lnbara*u5*w + 0.009188839992349455*u6*w + 
     0.01548483324024246*lnbara*u6*w + 1.0026714298838242*v*w - 
     0.7813024128964863*lnbara*v*w - 1.0126713716908156*u*v*w + 
     0.5023951392934956*u2*v*w - 0.21501849683495838*u3*v*w + 
     0.058778134166543324*u4*v*w - 0.007372846802421446*u5*v*w - 
     0.47720795179025316*v2*w + 0.8333333333333334*lnbara*v2*w + 
     0.5023951392934956*u*v2*w - 0.1301855269369699*u2*v2*w + 
     0.02833198919577561*u3*v2*w - 0.0031230558273987455*u4*v2*w + 
     0.09625212847865466*v3*w - 0.6829286069220218*lnbara*v3*w - 
     0.21501849683495838*u*v3*w + 0.02833198919577561*u2*v3*w - 
     0.002484679216493939*u3*v3*w + 0.0606312665629839*v4*w + 
     0.36653175786289616*lnbara*v4*w + 0.058778134166543324*u*v4*w - 
     0.0031230558273987455*u2*v4*w - 0.0457138816682174*v5*w - 
     0.11382143448700363*lnbara*v5*w - 0.007372846802421446*u*v5*w + 
     0.009188839992349455*v6*w + 0.01548483324024246*lnbara*v6*w + 
     0.9810368542209558*w2 - 1.7207285075403607*lnbara*w2 + 
     0.5*lnbara2*w2 - 0.7828550788698954*u*w2 + 0.8333333333333334*lnbara*
      u*w2 + 0.22380566397463328*u2*w2 - 0.4512141792339346*lnbara*u2*
      w2 - 0.036984774410399074*u3*w2 + 0.20053963521508203*lnbara*u3*
      w2 - 0.003073840573429086*u4*w2 - 0.055892827564981824*lnbara*u4*
      w2 + 0.0017654969488961178*u5*w2 + 0.00709100055854524*lnbara*u5*
      w2 - 0.7828550788698954*v*w2 + 0.8333333333333334*lnbara*v*w2 + 
     0.6270564403669334*u*v*w2 - 0.17655955408877413*u2*v*w2 + 
     0.039886472505265586*u3*v*w2 - 0.004483995136656385*u4*v*w2 + 
     0.22380566397463328*v2*w2 - 0.4512141792339346*lnbara*v2*w2 - 
     0.17655955408877413*u*v2*w2 + 0.02528635523080116*u2*v2*w2 - 
     0.0023037031758568953*u3*v2*w2 - 0.036984774410399074*v3*w2 + 
     0.20053963521508203*lnbara*v3*w2 + 0.039886472505265586*u*v3*w2 - 
     0.0023037031758568953*u2*v3*w2 - 0.003073840573429086*v4*w2 - 
     0.055892827564981824*lnbara*v4*w2 - 0.004483995136656385*u*v4*w2 + 
     0.0017654969488961178*v5*w2 + 0.00709100055854524*lnbara*v5*w2 - 
     0.5912546518750658*w3 + 1.7567697347894902*lnbara*w3 - 
     0.8333333333333334*lnbara2*w3 + 0.4075876907224508*u*w3 - 
     0.6829286069220218*lnbara*u*w3 - 0.056596724949092986*u2*w3 + 
     0.20053963521508203*lnbara*u2*w3 + 0.0019134967351693904*u3*w3 - 
     0.046296296296296294*lnbara*u3*w3 + 0.000809549773107401*u4*w3 + 
     0.005269398380875331*lnbara*u4*w3 + 0.4075876907224508*v*w3 - 
     0.6829286069220218*lnbara*v*w3 - 0.2887246082811922*u*v*w3 + 
     0.043027637873180646*u2*v*w3 - 0.004003458840761125*u3*v*w3 - 
     0.056596724949092986*v2*w3 + 0.20053963521508203*lnbara*v2*w3 + 
     0.043027637873180646*u*v2*w3 - 0.0025854864042796264*u2*v2*w3 + 
     0.0019134967351693904*v3*w3 - 0.046296296296296294*lnbara*v3*w3 - 
     0.004003458840761125*u*v3*w3 + 0.000809549773107401*v4*w3 + 
     0.005269398380875331*lnbara*v4*w3 + 0.18366696115261488*w4 - 
     1.0738411278674682*lnbara*w4 + 0.8333333333333334*lnbara2*w4 - 
     0.11954441131722408*u*w4 + 0.36653175786289616*lnbara*u*w4 + 
     0.004722025453367396*u2*w4 - 0.055892827564981824*lnbara*u2*w4 + 
     0.0005843696903917379*u3*w4 + 0.005269398380875331*lnbara*u3*w4 - 
     0.11954441131722408*v*w4 + 0.36653175786289616*lnbara*v*w4 + 
     0.08162229786094656*u*v*w4 - 0.005014303821094131*u2*v*w4 + 
     0.004722025453367396*v2*w4 - 0.055892827564981824*lnbara*v2*w4 - 
     0.005014303821094131*u*v2*w4 + 0.0005843696903917379*v3*w4 + 
     0.005269398380875331*lnbara*v3*w4 - 0.014564647637789663*w5 + 
     0.35107927043016407*lnbara*w5 - 0.5*lnbara2*w5 + 
     0.012330149265238628*u*w5 - 0.11382143448700363*lnbara*u*w5 + 
     0.0006183344116792466*u2*w5 + 0.00709100055854524*lnbara*u2*w5 + 
     0.012330149265238628*v*w5 - 0.11382143448700363*lnbara*v*w5 - 
     0.010430313916348187*u*v*w5 + 0.0006183344116792466*v2*w5 + 
     0.00709100055854524*lnbara*v2*w5 - 0.0033652169642291977*w6 - 
     0.041145467152052265*lnbara*w6 + 0.16666666666666666*lnbara2*w6 + 
     0.0011217389880763993*u*w6 + 0.01548483324024246*lnbara*u*w6 + 
     0.0011217389880763993*v*w6 + 0.01548483324024246*lnbara*v*w6 - 
     0.00016024842686805703*w7 - 0.0029705522584167966*lnbara*w7 - 
     0.023809523809523808*lnbara2*w7 - 1.2949521745536563*y + 
     0.7138888888888889*lnbara*y - 0.08333333333333333*lnbara2*y + 
     1.7363044156749696*u*y - 1.5053104503806145*u2*y + 
     1.1595103369494308*u3*y - 0.6059652683278195*u4*y + 
     0.18552833550330372*u5*y - 0.02502340865562592*u6*y + 
     0.7486964164955209*v*y - 0.7813024128964863*lnbara*v*y - 
     0.8238044525807867*u*v*y + 0.3780687567263677*u2*v*y - 
     0.1565521245743462*u3*v*y + 0.04209594617507414*u4*v*y - 
     0.005230685402774597*u5*v*y - 0.4069962081497097*v2*y + 
     0.8333333333333334*lnbara*v2*y + 0.4679101100870634*u*v2*y - 
     0.11674571633666242*u2*v2*y + 0.024931869805558025*u3*v2*y - 
     0.002720137747628636*u4*v2*y + 0.06876515362625549*v3*y - 
     0.6829286069220218*lnbara*v3*y - 0.20715657704752188*u*v3*y + 
     0.0266875066284785*u2*v3*y - 0.00231214789919763*u3*v3*y + 
     0.06985541595255951*v4*y + 0.36653175786289616*lnbara*v4*y + 
     0.057377869360117656*u*v4*y - 0.0030019939085982657*u2*v4*y - 
     0.047766973149609884*v5*y - 0.11382143448700363*lnbara*v5*y - 
     0.007244575946872198*u*v5*y + 0.0094053630927925*v6*y + 
     0.01548483324024246*lnbara*v6*y + 1.0026714298838242*w*y - 
     0.7813024128964863*lnbara*w*y - 1.0126713716908156*u*w*y + 
     0.5023951392934956*u2*w*y - 0.21501849683495838*u3*w*y + 
     0.058778134166543324*u4*w*y - 0.007372846802421446*u5*w*y - 
     0.4678883447171921*v*w*y + 0.5731787311490981*lnbara*v*w*y + 
     0.3934960244277067*u*v*w*y - 0.10597941411274388*u2*v*w*y + 
     0.023414477764682844*u3*v*w*y - 0.0025998411220075207*u4*v*w*y + 
     0.167673815188791*v2*w*y - 0.3821191540993988*lnbara*v2*w*y - 
     0.1426603512113796*u*v2*w*y + 0.019903204118841892*u2*v2*w*y - 
     0.0017876398103266954*u3*v2*w*y - 0.02727490919718466*v3*w*y + 
     0.18157951888431673*lnbara*v3*w*y + 0.03507305583697824*u*v3*w*y - 
     0.0019906820746583257*u2*v3*w*y - 0.004101711971109271*v4*w*y - 
     0.0521706881608105*lnbara*v4*w*y - 0.004099957104318314*u*v4*w*y + 
     0.0017955414211713314*v5*w*y + 0.006730433928458395*lnbara*v5*w*y - 
     0.7828550788698954*w2*y + 0.8333333333333334*lnbara*w2*y + 
     0.6270564403669334*u*w2*y - 0.17655955408877413*u2*w2*y + 
     0.039886472505265586*u3*w2*y - 0.004483995136656385*u4*w2*y + 
     0.20693303462909557*v*w2*y - 0.3821191540993988*lnbara*v*w2*y - 
     0.15437863995106366*u*v*w2*y + 0.02242442610919754*u2*v*w2*y - 
     0.002056880745742084*u3*v*w2*y - 0.03755338566787545*v2*w2*y + 
     0.15040472641131153*lnbara*v2*w2*y + 0.031379640471409696*u*v2*w2*
      y - 0.001853838481410454*u2*v2*w2*y + 0.0007514758984751476*v3*w2*
      y - 0.03861907128134787*lnbara*v3*w2*y - 0.003275828338900795*u*v3*
      w2*y + 0.0007856967829390636*v4*w2*y + 0.004629629629629629*lnbara*
      v4*w2*y + 0.4075876907224508*w3*y - 0.6829286069220218*lnbara*w3*
      y - 0.2887246082811922*u*w3*y + 0.043027637873180646*u2*w3*y - 
     0.004003458840761125*u3*w3*y - 0.05394276043788586*v*w3*y + 
     0.18157951888431673*lnbara*v*w3*y + 0.03942473681293775*u*v*w3*y - 
     0.002384224310314243*u2*v*w3*y + 0.002509582132846931*v2*w3*y - 
     0.03861907128134787*lnbara*v2*w3*y - 0.0034048489476472465*u*v2*w3*
      y + 0.0005177430923563043*v3*w3*y + 0.004141109249293644*lnbara*v3*
      w3*y - 0.11954441131722408*w4*y + 0.36653175786289616*lnbara*w4*y + 
     0.08162229786094656*u*w4*y - 0.005014303821094131*u2*w4*y + 
     0.004749429679627125*v*w4*y - 0.0521706881608105*lnbara*v*w4*y - 
     0.004706756497414547*u*v*w4*y + 0.00046180105924941995*v2*w4*y + 
     0.004629629629629629*lnbara*v2*w4*y + 0.012330149265238628*w5*y - 
     0.11382143448700363*lnbara*w5*y - 0.010430313916348187*u*w5*y + 
     0.0005633758156408582*v*w5*y + 0.006730433928458395*lnbara*v*w5*y + 
     0.0011217389880763993*w6*y + 0.01548483324024246*lnbara*w6*y + 
     1.2728681847963266*y2 - 1.3603642537701803*lnbara*y2 + 
     0.25*lnbara2*y2 - 1.5053104503806145*u*y2 + 
     0.5971683922836196*u2*y2 - 0.23797136954009399*u3*y2 + 
     0.0630184547186927*u4*y2 - 0.007769887708739977*u5*y2 - 
     0.4069962081497097*v*y2 + 0.8333333333333334*lnbara*v*y2 + 
     0.4679101100870634*u*v*y2 - 0.11674571633666242*u2*v*y2 + 
     0.024931869805558025*u3*v*y2 - 0.002720137747628636*u4*v*y2 + 
     0.1590976681785773*v2*y2 - 0.4512141792339346*lnbara*v2*y2 - 
     0.15726059911862464*u*v2*y2 + 0.02115367400201526*u2*v2*y2 - 
     0.0018641464676133518*u3*v2*y2 - 0.022064530698388034*v3*y2 + 
     0.20053963521508203*lnbara*v3*y2 + 0.03738755004957848*u*v3*y2 - 
     0.0020767314249685157*u2*v3*y2 - 0.005764996453097809*v4*y2 - 
     0.055892827564981824*lnbara*v4*y2 - 0.004294458827781368*u*v4*y2 + 
     0.0020142025327139768*v5*y2 + 0.00709100055854524*lnbara*v5*y2 - 
     0.47720795179025316*w*y2 + 0.8333333333333334*lnbara*w*y2 + 
     0.5023951392934956*u*w*y2 - 0.1301855269369699*u2*w*y2 + 
     0.02833198919577561*u3*w*y2 - 0.0031230558273987455*u4*w*y2 + 
     0.167673815188791*v*w*y2 - 0.3821191540993988*lnbara*v*w*y2 - 
     0.1426603512113796*u*v*w*y2 + 0.019903204118841892*u2*v*w*y2 - 
     0.0017876398103266954*u3*v*w*y2 - 0.03038462210815443*v2*w*y2 + 
     0.15040472641131153*lnbara*v2*w*y2 + 0.030141059746822362*u*v2*w*
      y2 - 0.001739141446927106*u2*v2*w*y2 - 0.0003461985960501892*v3*w*
      y2 - 0.03861907128134787*lnbara*v3*w*y2 - 0.003194707024362469*u*v3*
      w*y2 + 0.000876262754005557*v4*w*y2 + 0.004629629629629629*lnbara*
      v4*w*y2 + 0.22380566397463328*w2*y2 - 0.4512141792339346*lnbara*w2*
      y2 - 0.17655955408877413*u*w2*y2 + 0.02528635523080116*u2*w2*y2 - 
     0.0023037031758568953*u3*w2*y2 - 0.03755338566787545*v*w2*y2 + 
     0.15040472641131153*lnbara*v*w2*y2 + 0.031379640471409696*u*v*w2*
      y2 - 0.001853838481410454*u2*v*w2*y2 + 0.0012821581494826362*v2*
      w2*y2 - 0.0345475125672679*lnbara*v2*w2*y2 - 
     0.002972087316778959*u*v2*w2*y2 + 0.0005520821852506379*v3*w2*y2 + 
     0.003838612507474211*lnbara*v3*w2*y2 - 0.056596724949092986*w3*y2 + 
     0.20053963521508203*lnbara*w3*y2 + 0.043027637873180646*u*w3*y2 - 
     0.0025854864042796264*u2*w3*y2 + 0.002509582132846931*v*w3*y2 - 
     0.03861907128134787*lnbara*v*w3*y2 - 0.0034048489476472465*u*v*w3*
      y2 + 0.0004498411241904846*v2*w3*y2 + 0.003838612507474211*lnbara*
      v2*w3*y2 + 0.004722025453367396*w4*y2 - 0.055892827564981824*
      lnbara*w4*y2 - 0.005014303821094131*u*w4*y2 + 
     0.00046180105924941995*v*w4*y2 + 0.004629629629629629*lnbara*v*w4*
      y2 + 0.0006183344116792466*w5*y2 + 0.00709100055854524*lnbara*w5*
      y2 - 0.8231719544268136*y3 + 1.7117182007280785*lnbara*y3 - 
     0.4166666666666667*lnbara2*y3 + 1.1595103369494308*u*y3 - 
     0.23797136954009399*u2*y3 + 0.04797251819186834*u3*y3 - 
     0.005107942897122393*u4*y3 + 0.06876515362625549*v*y3 - 
     0.6829286069220218*lnbara*v*y3 - 0.20715657704752188*u*v*y3 + 
     0.0266875066284785*u2*v*y3 - 0.00231214789919763*u3*v*y3 - 
     0.022064530698388034*v2*y3 + 0.20053963521508203*lnbara*v2*y3 + 
     0.03738755004957848*u*v2*y3 - 0.0020767314249685157*u2*v2*y3 - 
     0.0024132847646464893*v3*y3 - 0.046296296296296294*lnbara*v3*y3 - 
     0.0036899420821654982*u*v3*y3 + 0.0011355462303617014*v4*y3 + 
     0.005269398380875331*lnbara*v4*y3 + 0.09625212847865466*w*y3 - 
     0.6829286069220218*lnbara*w*y3 - 0.21501849683495838*u*w*y3 + 
     0.02833198919577561*u2*w*y3 - 0.002484679216493939*u3*w*y3 - 
     0.02727490919718466*v*w*y3 + 0.18157951888431673*lnbara*v*w*y3 + 
     0.03507305583697824*u*v*w*y3 - 0.0019906820746583257*u2*v*w*y3 - 
     0.0003461985960501892*v2*w*y3 - 0.03861907128134787*lnbara*v2*w*y3 - 
     0.003194707024362469*u*v2*w*y3 + 0.0007087990860838744*v3*w*y3 + 
     0.004141109249293644*lnbara*v3*w*y3 - 0.036984774410399074*w2*y3 + 
     0.20053963521508203*lnbara*w2*y3 + 0.039886472505265586*u*w2*y3 - 
     0.0023037031758568953*u2*w2*y3 + 0.0007514758984751476*v*w2*y3 - 
     0.03861907128134787*lnbara*v*w2*y3 - 0.003275828338900795*u*v*w2*
      y3 + 0.0005520821852506379*v2*w2*y3 + 0.003838612507474211*lnbara*
      v2*w2*y3 + 0.0019134967351693904*w3*y3 - 
     0.046296296296296294*lnbara*w3*y3 - 0.004003458840761125*u*w3*y3 + 
     0.0005177430923563043*v*w3*y3 + 0.004141109249293644*lnbara*v*w3*
      y3 + 0.0005843696903917379*w4*y3 + 0.005269398380875331*lnbara*w4*
      y3 + 0.20216246542587063*y4 - 1.3702538972670675*lnbara*y4 + 
     0.4166666666666667*lnbara2*y4 - 0.6059652683278195*u*y4 + 
     0.0630184547186927*u2*y4 - 0.005107942897122393*u3*y4 + 
     0.06985541595255951*v*y4 + 0.36653175786289616*lnbara*v*y4 + 
     0.057377869360117656*u*v*y4 - 0.0030019939085982657*u2*v*y4 - 
     0.005764996453097809*v2*y4 - 0.055892827564981824*lnbara*v2*y4 - 
     0.004294458827781368*u*v2*y4 + 0.0011355462303617014*v3*y4 + 
     0.005269398380875331*lnbara*v3*y4 + 0.0606312665629839*w*y4 + 
     0.36653175786289616*lnbara*w*y4 + 0.058778134166543324*u*w*y4 - 
     0.0031230558273987455*u2*w*y4 - 0.004101711971109271*v*w*y4 - 
     0.0521706881608105*lnbara*v*w*y4 - 0.004099957104318314*u*v*w*y4 + 
     0.000876262754005557*v2*w*y4 + 0.004629629629629629*lnbara*v2*w*y4 - 
     0.003073840573429086*w2*y4 - 0.055892827564981824*lnbara*w2*y4 - 
     0.004483995136656385*u*w2*y4 + 0.0007856967829390636*v*w2*y4 + 
     0.004629629629629629*lnbara*v*w2*y4 + 0.000809549773107401*w3*y4 + 
     0.005269398380875331*lnbara*w3*y4 + 0.09499129157249676*y5 + 
     0.675539635215082*lnbara*y5 - 0.25*lnbara2*y5 + 
     0.18552833550330372*u*y5 - 0.007769887708739977*u2*y5 - 
     0.047766973149609884*v*y5 - 0.11382143448700363*lnbara*v*y5 - 
     0.007244575946872198*u*v*y5 + 0.0020142025327139768*v2*y5 + 
     0.00709100055854524*lnbara*v2*y5 - 0.0457138816682174*w*y5 - 
     0.11382143448700363*lnbara*w*y5 - 0.007372846802421446*u*w*y5 + 
     0.0017955414211713314*v*w*y5 + 0.006730433928458395*lnbara*v*w*y5 + 
     0.0017654969488961178*w2*y5 + 0.00709100055854524*lnbara*w2*y5 - 
     0.07792639988896227*y6 - 0.1872394002426928*lnbara*y6 + 
     0.08333333333333333*lnbara2*y6 - 0.02502340865562592*u*y6 + 
     0.0094053630927925*v*y6 + 0.01548483324024246*lnbara*v*y6 + 
     0.009188839992349455*w*y6 + 0.01548483324024246*lnbara*w*y6 + 
     0.01562557344501031*y7 + 0.02232424768031541*lnbara*y7 - 
     0.011904761904761904*lnbara2*y7 - 1.2949521745536563*z + 
     0.7138888888888889*lnbara*z - 0.08333333333333333*lnbara2*z + 
     0.7486964164955209*u*z - 0.7813024128964863*lnbara*u*z - 
     0.4069962081497097*u2*z + 0.8333333333333334*lnbara*u2*z + 
     0.06876515362625549*u3*z - 0.6829286069220218*lnbara*u3*z + 
     0.06985541595255951*u4*z + 0.36653175786289616*lnbara*u4*z - 
     0.047766973149609884*u5*z - 0.11382143448700363*lnbara*u5*z + 
     0.0094053630927925*u6*z + 0.01548483324024246*lnbara*u6*z + 
     1.7363044156749696*v*z - 0.8238044525807867*u*v*z + 
     0.4679101100870634*u2*v*z - 0.20715657704752188*u3*v*z + 
     0.057377869360117656*u4*v*z - 0.007244575946872198*u5*v*z - 
     1.5053104503806145*v2*z + 0.3780687567263677*u*v2*z - 
     0.11674571633666242*u2*v2*z + 0.0266875066284785*u3*v2*z - 
     0.0030019939085982657*u4*v2*z + 1.1595103369494308*v3*z - 
     0.1565521245743462*u*v3*z + 0.024931869805558025*u2*v3*z - 
     0.00231214789919763*u3*v3*z - 0.6059652683278195*v4*z + 
     0.04209594617507414*u*v4*z - 0.002720137747628636*u2*v4*z + 
     0.18552833550330372*v5*z - 0.005230685402774597*u*v5*z - 
     0.02502340865562592*v6*z + 1.0026714298838242*w*z - 
     0.7813024128964863*lnbara*w*z - 0.4678883447171921*u*w*z + 
     0.5731787311490981*lnbara*u*w*z + 0.167673815188791*u2*w*z - 
     0.3821191540993988*lnbara*u2*w*z - 0.02727490919718466*u3*w*z + 
     0.18157951888431673*lnbara*u3*w*z - 0.004101711971109271*u4*w*z - 
     0.0521706881608105*lnbara*u4*w*z + 0.0017955414211713314*u5*w*z + 
     0.006730433928458395*lnbara*u5*w*z - 1.0126713716908156*v*w*z + 
     0.3934960244277067*u*v*w*z - 0.1426603512113796*u2*v*w*z + 
     0.03507305583697824*u3*v*w*z - 0.004099957104318314*u4*v*w*z + 
     0.5023951392934956*v2*w*z - 0.10597941411274388*u*v2*w*z + 
     0.019903204118841892*u2*v2*w*z - 0.0019906820746583257*u3*v2*w*z - 
     0.21501849683495838*v3*w*z + 0.023414477764682844*u*v3*w*z - 
     0.0017876398103266954*u2*v3*w*z + 0.058778134166543324*v4*w*z - 
     0.0025998411220075207*u*v4*w*z - 0.007372846802421446*v5*w*z - 
     0.7828550788698954*w2*z + 0.8333333333333334*lnbara*w2*z + 
     0.20693303462909557*u*w2*z - 0.3821191540993988*lnbara*u*w2*z - 
     0.03755338566787545*u2*w2*z + 0.15040472641131153*lnbara*u2*w2*z + 
     0.0007514758984751476*u3*w2*z - 0.03861907128134787*lnbara*u3*w2*z + 
     0.0007856967829390636*u4*w2*z + 0.004629629629629629*lnbara*u4*w2*
      z + 0.6270564403669334*v*w2*z - 0.15437863995106366*u*v*w2*z + 
     0.031379640471409696*u2*v*w2*z - 0.003275828338900795*u3*v*w2*z - 
     0.17655955408877413*v2*w2*z + 0.02242442610919754*u*v2*w2*z - 
     0.001853838481410454*u2*v2*w2*z + 0.039886472505265586*v3*w2*z - 
     0.002056880745742084*u*v3*w2*z - 0.004483995136656385*v4*w2*z + 
     0.4075876907224508*w3*z - 0.6829286069220218*lnbara*w3*z - 
     0.05394276043788586*u*w3*z + 0.18157951888431673*lnbara*u*w3*z + 
     0.002509582132846931*u2*w3*z - 0.03861907128134787*lnbara*u2*w3*z + 
     0.0005177430923563043*u3*w3*z + 0.004141109249293644*lnbara*u3*w3*
      z - 0.2887246082811922*v*w3*z + 0.03942473681293775*u*v*w3*z - 
     0.0034048489476472465*u2*v*w3*z + 0.043027637873180646*v2*w3*z - 
     0.002384224310314243*u*v2*w3*z - 0.004003458840761125*v3*w3*z - 
     0.11954441131722408*w4*z + 0.36653175786289616*lnbara*w4*z + 
     0.004749429679627125*u*w4*z - 0.0521706881608105*lnbara*u*w4*z + 
     0.00046180105924941995*u2*w4*z + 0.004629629629629629*lnbara*u2*w4*
      z + 0.08162229786094656*v*w4*z - 0.004706756497414547*u*v*w4*z - 
     0.005014303821094131*v2*w4*z + 0.012330149265238628*w5*z - 
     0.11382143448700363*lnbara*w5*z + 0.0005633758156408582*u*w5*z + 
     0.006730433928458395*lnbara*u*w5*z - 0.010430313916348187*v*w5*z + 
     0.0011217389880763993*w6*z + 0.01548483324024246*lnbara*w6*z + 
     1.7363044156749696*y*z - 0.8238044525807867*u*y*z + 
     0.4679101100870634*u2*y*z - 0.20715657704752188*u3*y*z + 
     0.057377869360117656*u4*y*z - 0.007244575946872198*u5*y*z - 
     0.8238044525807867*v*y*z + 0.2739438320944513*u*v*y*z - 
     0.09158761699667091*u2*v*y*z + 0.021578507461480923*u3*v*y*z - 
     0.0024621270486790818*u4*v*y*z + 0.4679101100870634*v2*y*z - 
     0.09158761699667091*u*v2*y*z + 0.01642275124834286*u2*v2*y*z - 
     0.0015989423718971896*u3*v2*y*z - 0.20715657704752188*v3*y*z + 
     0.021578507461480923*u*v3*y*z - 0.0015989423718971896*u2*v3*y*z + 
     0.057377869360117656*v4*y*z - 0.0024621270486790818*u*v4*y*z - 
     0.007244575946872198*v5*y*z - 1.0126713716908156*w*y*z + 
     0.3934960244277067*u*w*y*z - 0.1426603512113796*u2*w*y*z + 
     0.03507305583697824*u3*w*y*z - 0.004099957104318314*u4*w*y*z + 
     0.3934960244277067*v*w*y*z - 0.08913056030998658*u*v*w*y*z + 
     0.01725372623767659*u2*v*w*y*z - 0.0017507925438618114*u3*v*w*y*z - 
     0.1426603512113796*v2*w*y*z + 0.01725372623767659*u*v2*w*y*z - 
     0.001382278607211708*u2*v2*w*y*z + 0.03507305583697824*v3*w*y*z - 
     0.0017507925438618114*u*v3*w*y*z - 0.004099957104318314*v4*w*y*z + 
     0.6270564403669334*w2*y*z - 0.15437863995106366*u*w2*y*z + 
     0.031379640471409696*u2*w2*y*z - 0.003275828338900795*u3*w2*y*z - 
     0.15437863995106366*v*w2*y*z + 0.02011565535928021*u*v*w2*y*z - 
     0.001685757015386744*u2*v*w2*y*z + 0.031379640471409696*v2*w2*y*z - 
     0.001685757015386744*u*v2*w2*y*z - 0.003275828338900795*v3*w2*y*z - 
     0.2887246082811922*w3*y*z + 0.03942473681293775*u*w3*y*z - 
     0.0034048489476472465*u2*w3*y*z + 0.03942473681293775*v*w3*y*z - 
     0.002209866412062086*u*v*w3*y*z - 0.0034048489476472465*v2*w3*y*z + 
     0.08162229786094656*w4*y*z - 0.004706756497414547*u*w4*y*z - 
     0.004706756497414547*v*w4*y*z - 0.010430313916348187*w5*y*z - 
     1.5053104503806145*y2*z + 0.3780687567263677*u*y2*z - 
     0.11674571633666242*u2*y2*z + 0.0266875066284785*u3*y2*z - 
     0.0030019939085982657*u4*y2*z + 0.4679101100870634*v*y2*z - 
     0.09158761699667091*u*v*y2*z + 0.01642275124834286*u2*v*y2*z - 
     0.0015989423718971896*u3*v*y2*z - 0.15726059911862464*v2*y2*z + 
     0.017747490188925512*u*v2*y2*z - 0.0013617046024370035*u2*v2*y2*z + 
     0.03738755004957848*v3*y2*z - 0.001791718617657013*u*v3*y2*z - 
     0.004294458827781368*v4*y2*z + 0.5023951392934956*w*y2*z - 
     0.10597941411274388*u*w*y2*z + 0.019903204118841892*u2*w*y2*z - 
     0.0019906820746583257*u3*w*y2*z - 0.1426603512113796*v*w*y2*z + 
     0.01725372623767659*u*v*w*y2*z - 0.001382278607211708*u2*v*w*y2*z + 
     0.030141059746822362*v2*w*y2*z - 0.0015503600732354181*u*v2*w*y2*z - 
     0.003194707024362469*v3*w*y2*z - 0.17655955408877413*w2*y2*z + 
     0.02242442610919754*u*w2*y2*z - 0.001853838481410454*u2*w2*y2*z + 
     0.031379640471409696*v*w2*y2*z - 0.001685757015386744*u*v*w2*y2*z - 
     0.002972087316778959*v2*w2*y2*z + 0.043027637873180646*w3*y2*z - 
     0.002384224310314243*u*w3*y2*z - 0.0034048489476472465*v*w3*y2*z - 
     0.005014303821094131*w4*y2*z + 1.1595103369494308*y3*z - 
     0.1565521245743462*u*y3*z + 0.024931869805558025*u2*y3*z - 
     0.00231214789919763*u3*y3*z - 0.20715657704752188*v*y3*z + 
     0.021578507461480923*u*v*y3*z - 0.0015989423718971896*u2*v*y3*z + 
     0.03738755004957848*v2*y3*z - 0.001791718617657013*u*v2*y3*z - 
     0.0036899420821654982*v3*y3*z - 0.21501849683495838*w*y3*z + 
     0.023414477764682844*u*w*y3*z - 0.0017876398103266954*u2*w*y3*z + 
     0.03507305583697824*v*w*y3*z - 0.0017507925438618114*u*v*w*y3*z - 
     0.003194707024362469*v2*w*y3*z + 0.039886472505265586*w2*y3*z - 
     0.002056880745742084*u*w2*y3*z - 0.003275828338900795*v*w2*y3*z - 
     0.004003458840761125*w3*y3*z - 0.6059652683278195*y4*z + 
     0.04209594617507414*u*y4*z - 0.002720137747628636*u2*y4*z + 
     0.057377869360117656*v*y4*z - 0.0024621270486790818*u*v*y4*z - 
     0.004294458827781368*v2*y4*z + 0.058778134166543324*w*y4*z - 
     0.0025998411220075207*u*w*y4*z - 0.004099957104318314*v*w*y4*z - 
     0.004483995136656385*w2*y4*z + 0.18552833550330372*y5*z - 
     0.005230685402774597*u*y5*z - 0.007244575946872198*v*y5*z - 
     0.007372846802421446*w*y5*z - 0.02502340865562592*y6*z + 
     1.2728681847963266*z2 - 1.3603642537701803*lnbara*z2 + 
     0.25*lnbara2*z2 - 0.4069962081497097*u*z2 + 
     0.8333333333333334*lnbara*u*z2 + 0.1590976681785773*u2*z2 - 
     0.4512141792339346*lnbara*u2*z2 - 0.022064530698388034*u3*z2 + 
     0.20053963521508203*lnbara*u3*z2 - 0.005764996453097809*u4*z2 - 
     0.055892827564981824*lnbara*u4*z2 + 0.0020142025327139768*u5*z2 + 
     0.00709100055854524*lnbara*u5*z2 - 1.5053104503806145*v*z2 + 
     0.4679101100870634*u*v*z2 - 0.15726059911862464*u2*v*z2 + 
     0.03738755004957848*u3*v*z2 - 0.004294458827781368*u4*v*z2 + 
     0.5971683922836196*v2*z2 - 0.11674571633666242*u*v2*z2 + 
     0.02115367400201526*u2*v2*z2 - 0.0020767314249685157*u3*v2*z2 - 
     0.23797136954009399*v3*z2 + 0.024931869805558025*u*v3*z2 - 
     0.0018641464676133518*u2*v3*z2 + 0.0630184547186927*v4*z2 - 
     0.002720137747628636*u*v4*z2 - 0.007769887708739977*v5*z2 - 
     0.47720795179025316*w*z2 + 0.8333333333333334*lnbara*w*z2 + 
     0.167673815188791*u*w*z2 - 0.3821191540993988*lnbara*u*w*z2 - 
     0.03038462210815443*u2*w*z2 + 0.15040472641131153*lnbara*u2*w*z2 - 
     0.0003461985960501892*u3*w*z2 - 0.03861907128134787*lnbara*u3*w*z2 + 
     0.000876262754005557*u4*w*z2 + 0.004629629629629629*lnbara*u4*w*z2 + 
     0.5023951392934956*v*w*z2 - 0.1426603512113796*u*v*w*z2 + 
     0.030141059746822362*u2*v*w*z2 - 0.003194707024362469*u3*v*w*z2 - 
     0.1301855269369699*v2*w*z2 + 0.019903204118841892*u*v2*w*z2 - 
     0.001739141446927106*u2*v2*w*z2 + 0.02833198919577561*v3*w*z2 - 
     0.0017876398103266954*u*v3*w*z2 - 0.0031230558273987455*v4*w*z2 + 
     0.22380566397463328*w2*z2 - 0.4512141792339346*lnbara*w2*z2 - 
     0.03755338566787545*u*w2*z2 + 0.15040472641131153*lnbara*u*w2*z2 + 
     0.0012821581494826362*u2*w2*z2 - 0.0345475125672679*lnbara*u2*w2*
      z2 + 0.0005520821852506379*u3*w2*z2 + 0.003838612507474211*lnbara*
      u3*w2*z2 - 0.17655955408877413*v*w2*z2 + 
     0.031379640471409696*u*v*w2*z2 - 0.002972087316778959*u2*v*w2*z2 + 
     0.02528635523080116*v2*w2*z2 - 0.001853838481410454*u*v2*w2*z2 - 
     0.0023037031758568953*v3*w2*z2 - 0.056596724949092986*w3*z2 + 
     0.20053963521508203*lnbara*w3*z2 + 0.002509582132846931*u*w3*z2 - 
     0.03861907128134787*lnbara*u*w3*z2 + 0.0004498411241904846*u2*w3*
      z2 + 0.003838612507474211*lnbara*u2*w3*z2 + 
     0.043027637873180646*v*w3*z2 - 0.0034048489476472465*u*v*w3*z2 - 
     0.0025854864042796264*v2*w3*z2 + 0.004722025453367396*w4*z2 - 
     0.055892827564981824*lnbara*w4*z2 + 0.00046180105924941995*u*w4*z2 + 
     0.004629629629629629*lnbara*u*w4*z2 - 0.005014303821094131*v*w4*z2 + 
     0.0006183344116792466*w5*z2 + 0.00709100055854524*lnbara*w5*z2 - 
     1.5053104503806145*y*z2 + 0.4679101100870634*u*y*z2 - 
     0.15726059911862464*u2*y*z2 + 0.03738755004957848*u3*y*z2 - 
     0.004294458827781368*u4*y*z2 + 0.3780687567263677*v*y*z2 - 
     0.09158761699667091*u*v*y*z2 + 0.017747490188925512*u2*v*y*z2 - 
     0.001791718617657013*u3*v*y*z2 - 0.11674571633666242*v2*y*z2 + 
     0.01642275124834286*u*v2*y*z2 - 0.0013617046024370035*u2*v2*y*z2 + 
     0.0266875066284785*v3*y*z2 - 0.0015989423718971896*u*v3*y*z2 - 
     0.0030019939085982657*v4*y*z2 + 0.5023951392934956*w*y*z2 - 
     0.1426603512113796*u*w*y*z2 + 0.030141059746822362*u2*w*y*z2 - 
     0.003194707024362469*u3*w*y*z2 - 0.10597941411274388*v*w*y*z2 + 
     0.01725372623767659*u*v*w*y*z2 - 0.0015503600732354181*u2*v*w*y*z2 + 
     0.019903204118841892*v2*w*y*z2 - 0.001382278607211708*u*v2*w*y*z2 - 
     0.0019906820746583257*v3*w*y*z2 - 0.17655955408877413*w2*y*z2 + 
     0.031379640471409696*u*w2*y*z2 - 0.002972087316778959*u2*w2*y*z2 + 
     0.02242442610919754*v*w2*y*z2 - 0.001685757015386744*u*v*w2*y*z2 - 
     0.001853838481410454*v2*w2*y*z2 + 0.043027637873180646*w3*y*z2 - 
     0.0034048489476472465*u*w3*y*z2 - 0.002384224310314243*v*w3*y*z2 - 
     0.005014303821094131*w4*y*z2 + 0.5971683922836196*y2*z2 - 
     0.11674571633666242*u*y2*z2 + 0.02115367400201526*u2*y2*z2 - 
     0.0020767314249685157*u3*y2*z2 - 0.11674571633666242*v*y2*z2 + 
     0.01642275124834286*u*v*y2*z2 - 0.0013617046024370035*u2*v*y2*z2 + 
     0.02115367400201526*v2*y2*z2 - 0.0013617046024370035*u*v2*y2*z2 - 
     0.0020767314249685157*v3*y2*z2 - 0.1301855269369699*w*y2*z2 + 
     0.019903204118841892*u*w*y2*z2 - 0.001739141446927106*u2*w*y2*z2 + 
     0.019903204118841892*v*w*y2*z2 - 0.001382278607211708*u*v*w*y2*z2 - 
     0.001739141446927106*v2*w*y2*z2 + 0.02528635523080116*w2*y2*z2 - 
     0.001853838481410454*u*w2*y2*z2 - 0.001853838481410454*v*w2*y2*
      z2 - 0.0025854864042796264*w3*y2*z2 - 0.23797136954009399*y3*z2 + 
     0.024931869805558025*u*y3*z2 - 0.0018641464676133518*u2*y3*z2 + 
     0.0266875066284785*v*y3*z2 - 0.0015989423718971896*u*v*y3*z2 - 
     0.0020767314249685157*v2*y3*z2 + 0.02833198919577561*w*y3*z2 - 
     0.0017876398103266954*u*w*y3*z2 - 0.0019906820746583257*v*w*y3*z2 - 
     0.0023037031758568953*w2*y3*z2 + 0.0630184547186927*y4*z2 - 
     0.002720137747628636*u*y4*z2 - 0.0030019939085982657*v*y4*z2 - 
     0.0031230558273987455*w*y4*z2 - 0.007769887708739977*y5*z2 - 
     0.8231719544268136*z3 + 1.7117182007280785*lnbara*z3 - 
     0.4166666666666667*lnbara2*z3 + 0.06876515362625549*u*z3 - 
     0.6829286069220218*lnbara*u*z3 - 0.022064530698388034*u2*z3 + 
     0.20053963521508203*lnbara*u2*z3 - 0.0024132847646464893*u3*z3 - 
     0.046296296296296294*lnbara*u3*z3 + 0.0011355462303617014*u4*z3 + 
     0.005269398380875331*lnbara*u4*z3 + 1.1595103369494308*v*z3 - 
     0.20715657704752188*u*v*z3 + 0.03738755004957848*u2*v*z3 - 
     0.0036899420821654982*u3*v*z3 - 0.23797136954009399*v2*z3 + 
     0.0266875066284785*u*v2*z3 - 0.0020767314249685157*u2*v2*z3 + 
     0.04797251819186834*v3*z3 - 0.00231214789919763*u*v3*z3 - 
     0.005107942897122393*v4*z3 + 0.09625212847865466*w*z3 - 
     0.6829286069220218*lnbara*w*z3 - 0.02727490919718466*u*w*z3 + 
     0.18157951888431673*lnbara*u*w*z3 - 0.0003461985960501892*u2*w*z3 - 
     0.03861907128134787*lnbara*u2*w*z3 + 0.0007087990860838744*u3*w*z3 + 
     0.004141109249293644*lnbara*u3*w*z3 - 0.21501849683495838*v*w*z3 + 
     0.03507305583697824*u*v*w*z3 - 0.003194707024362469*u2*v*w*z3 + 
     0.02833198919577561*v2*w*z3 - 0.0019906820746583257*u*v2*w*z3 - 
     0.002484679216493939*v3*w*z3 - 0.036984774410399074*w2*z3 + 
     0.20053963521508203*lnbara*w2*z3 + 0.0007514758984751476*u*w2*z3 - 
     0.03861907128134787*lnbara*u*w2*z3 + 0.0005520821852506379*u2*w2*
      z3 + 0.003838612507474211*lnbara*u2*w2*z3 + 
     0.039886472505265586*v*w2*z3 - 0.003275828338900795*u*v*w2*z3 - 
     0.0023037031758568953*v2*w2*z3 + 0.0019134967351693904*w3*z3 - 
     0.046296296296296294*lnbara*w3*z3 + 0.0005177430923563043*u*w3*z3 + 
     0.004141109249293644*lnbara*u*w3*z3 - 0.004003458840761125*v*w3*z3 + 
     0.0005843696903917379*w4*z3 + 0.005269398380875331*lnbara*w4*z3 + 
     1.1595103369494308*y*z3 - 0.20715657704752188*u*y*z3 + 
     0.03738755004957848*u2*y*z3 - 0.0036899420821654982*u3*y*z3 - 
     0.1565521245743462*v*y*z3 + 0.021578507461480923*u*v*y*z3 - 
     0.001791718617657013*u2*v*y*z3 + 0.024931869805558025*v2*y*z3 - 
     0.0015989423718971896*u*v2*y*z3 - 0.00231214789919763*v3*y*z3 - 
     0.21501849683495838*w*y*z3 + 0.03507305583697824*u*w*y*z3 - 
     0.003194707024362469*u2*w*y*z3 + 0.023414477764682844*v*w*y*z3 - 
     0.0017507925438618114*u*v*w*y*z3 - 0.0017876398103266954*v2*w*y*z3 + 
     0.039886472505265586*w2*y*z3 - 0.003275828338900795*u*w2*y*z3 - 
     0.002056880745742084*v*w2*y*z3 - 0.004003458840761125*w3*y*z3 - 
     0.23797136954009399*y2*z3 + 0.0266875066284785*u*y2*z3 - 
     0.0020767314249685157*u2*y2*z3 + 0.024931869805558025*v*y2*z3 - 
     0.0015989423718971896*u*v*y2*z3 - 0.0018641464676133518*v2*y2*z3 + 
     0.02833198919577561*w*y2*z3 - 0.0019906820746583257*u*w*y2*z3 - 
     0.0017876398103266954*v*w*y2*z3 - 0.0023037031758568953*w2*y2*z3 + 
     0.04797251819186834*y3*z3 - 0.00231214789919763*u*y3*z3 - 
     0.00231214789919763*v*y3*z3 - 0.002484679216493939*w*y3*z3 - 
     0.005107942897122393*y4*z3 + 0.20216246542587063*z4 - 
     1.3702538972670675*lnbara*z4 + 0.4166666666666667*lnbara2*z4 + 
     0.06985541595255951*u*z4 + 0.36653175786289616*lnbara*u*z4 - 
     0.005764996453097809*u2*z4 - 0.055892827564981824*lnbara*u2*z4 + 
     0.0011355462303617014*u3*z4 + 0.005269398380875331*lnbara*u3*z4 - 
     0.6059652683278195*v*z4 + 0.057377869360117656*u*v*z4 - 
     0.004294458827781368*u2*v*z4 + 0.0630184547186927*v2*z4 - 
     0.0030019939085982657*u*v2*z4 - 0.005107942897122393*v3*z4 + 
     0.0606312665629839*w*z4 + 0.36653175786289616*lnbara*w*z4 - 
     0.004101711971109271*u*w*z4 - 0.0521706881608105*lnbara*u*w*z4 + 
     0.000876262754005557*u2*w*z4 + 0.004629629629629629*lnbara*u2*w*z4 + 
     0.058778134166543324*v*w*z4 - 0.004099957104318314*u*v*w*z4 - 
     0.0031230558273987455*v2*w*z4 - 0.003073840573429086*w2*z4 - 
     0.055892827564981824*lnbara*w2*z4 + 0.0007856967829390636*u*w2*z4 + 
     0.004629629629629629*lnbara*u*w2*z4 - 0.004483995136656385*v*w2*z4 + 
     0.000809549773107401*w3*z4 + 0.005269398380875331*lnbara*w3*z4 - 
     0.6059652683278195*y*z4 + 0.057377869360117656*u*y*z4 - 
     0.004294458827781368*u2*y*z4 + 0.04209594617507414*v*y*z4 - 
     0.0024621270486790818*u*v*y*z4 - 0.002720137747628636*v2*y*z4 + 
     0.058778134166543324*w*y*z4 - 0.004099957104318314*u*w*y*z4 - 
     0.0025998411220075207*v*w*y*z4 - 0.004483995136656385*w2*y*z4 + 
     0.0630184547186927*y2*z4 - 0.0030019939085982657*u*y2*z4 - 
     0.002720137747628636*v*y2*z4 - 0.0031230558273987455*w*y2*z4 - 
     0.005107942897122393*y3*z4 + 0.09499129157249676*z5 + 
     0.675539635215082*lnbara*z5 - 0.25*lnbara2*z5 - 
     0.047766973149609884*u*z5 - 0.11382143448700363*lnbara*u*z5 + 
     0.0020142025327139768*u2*z5 + 0.00709100055854524*lnbara*u2*z5 + 
     0.18552833550330372*v*z5 - 0.007244575946872198*u*v*z5 - 
     0.007769887708739977*v2*z5 - 0.0457138816682174*w*z5 - 
     0.11382143448700363*lnbara*w*z5 + 0.0017955414211713314*u*w*z5 + 
     0.006730433928458395*lnbara*u*w*z5 - 0.007372846802421446*v*w*z5 + 
     0.0017654969488961178*w2*z5 + 0.00709100055854524*lnbara*w2*z5 + 
     0.18552833550330372*y*z5 - 0.007244575946872198*u*y*z5 - 
     0.005230685402774597*v*y*z5 - 0.007372846802421446*w*y*z5 - 
     0.007769887708739977*y2*z5 - 0.07792639988896227*z6 - 
     0.1872394002426928*lnbara*z6 + 0.08333333333333333*lnbara2*z6 + 
     0.0094053630927925*u*z6 + 0.01548483324024246*lnbara*u*z6 - 
     0.02502340865562592*v*z6 + 0.009188839992349455*w*z6 + 
     0.01548483324024246*lnbara*w*z6 - 0.02502340865562592*y*z6 + 
     0.01562557344501031*z7 + 0.02232424768031541*lnbara*z7 - 
     0.011904761904761904*lnbara2*z7;
 
  Gexp[8] = 0.7321716360225885 - 0.44107142857142856*lnbara + 
     0.05357142857142857*lnbara2 - 1.2119431337444038*u + 
     0.6357142857142857*lnbara*u - 0.07142857142857142*lnbara2*u + 
     1.49959556042469*u2 - 1.4436975871035138*lnbara*u2 + 
     0.25*lnbara2*u2 - 1.330149985457792*u3 + 2.2207285075403607*lnbara*
      u3 - 0.5*lnbara2*u3 + 0.6458071724555728*u4 - 
     2.2637141792339346*lnbara*u4 + 0.625*lnbara2*u4 - 
     0.035197295260033824*u5 + 1.5177459370968307*lnbara*u5 - 
     0.5*lnbara2*u5 - 0.14015949954554044*u6 - 0.6450515340614117*lnbara*
      u6 + 0.25*lnbara2*u6 + 0.07142919298974644*u7 + 
     0.15775500989141628*lnbara*u7 - 0.07142857142857142*lnbara2*u7 - 
     0.011766764554686482*u8 - 0.016917752027425906*lnbara*u8 + 
     0.008928571428571428*lnbara2*u8 - 1.2119431337444038*v + 
     0.6357142857142857*lnbara*v - 0.07142857142857142*lnbara2*v + 
     1.7363044156749696*u*v - 1.8063725404567375*u2*v + 
     1.7392655054241464*u3*v - 1.211930536655639*u4*v + 
     0.5565850065099112*u5*v - 0.15014045193375553*u6*v + 
     0.01800569050603713*u7*v + 1.49959556042469*v2 - 
     1.4436975871035138*lnbara*v2 + 0.25*lnbara2*v2 - 
     1.8063725404567375*u*v2 + 0.8957525884254294*u2*v2 - 
     0.47594273908018797*u3*v2 + 0.18905536415607813*u4*v2 - 
     0.04661932625243986*u5*v2 + 0.005260726475147424*u6*v2 - 
     1.330149985457792*v3 + 2.2207285075403607*lnbara*v3 - 
     0.5*lnbara2*v3 + 1.7392655054241464*u*v3 - 0.47594273908018797*u2*
      v3 + 0.143917554575605*u3*v3 - 0.030647657382734356*u4*v3 + 
     0.0031576827739003242*u5*v3 + 0.6458071724555728*v4 - 
     2.2637141792339346*lnbara*v4 + 0.625*lnbara2*v4 - 
     1.211930536655639*u*v4 + 0.18905536415607813*u2*v4 - 
     0.030647657382734356*u3*v4 + 0.002726070724998416*u4*v4 - 
     0.035197295260033824*v5 + 1.5177459370968307*lnbara*v5 - 
     0.5*lnbara2*v5 + 0.5565850065099112*u*v5 - 0.04661932625243986*u2*
      v5 + 0.0031576827739003242*u3*v5 - 0.14015949954554044*v6 - 
     0.6450515340614117*lnbara*v6 + 0.25*lnbara2*v6 - 
     0.15014045193375553*u*v6 + 0.005260726475147424*u2*v6 + 
     0.07142919298974644*v7 + 0.15775500989141628*lnbara*v7 - 
     0.07142857142857142*lnbara2*v7 + 0.01800569050603713*u*v7 - 
     0.011766764554686482*v8 - 0.016917752027425906*lnbara*v8 + 
     0.008928571428571428*lnbara2*v8 - 1.0096005532030932*w + 
     0.9857142857142858*lnbara*w - 0.14285714285714285*lnbara2*w + 
     1.132888498699905*u*w - 0.7813024128964863*lnbara*u*w - 
     0.7393162088149705*u2*w + lnbara*u2*w + 0.31511034444848746*u3*w - 
     1.0243929103830327*lnbara*u3*w - 0.0009147194949975854*u4*w + 
     0.7330635157257923*lnbara*u4*w - 0.08023092776115039*u5*w - 
     0.3414643034610109*lnbara*u5*w + 0.039648206713854266*u6*w + 
     0.09290899944145475*lnbara*u6*w - 0.00658939908338011*u7*w - 
     0.011206496836004519*lnbara*u7*w + 1.132888498699905*v*w - 
     0.7813024128964863*lnbara*v*w - 1.2152056460289786*u*v*w + 
     0.7535927089402433*u2*v*w - 0.43003699366991677*u3*v*w + 
     0.17633440249962998*u4*v*w - 0.04423708081452867*u5*v*w + 
     0.005045032605736152*u6*v*w - 0.7393162088149705*v2*w + lnbara*v2*w + 
     0.7535927089402433*u*v2*w - 0.2603710538739398*u2*v2*w + 
     0.08499596758732683*u3*v2*w - 0.01873833496439247*u4*v2*w + 
     0.001967584154035969*u5*v2*w + 0.31511034444848746*v3*w - 
     1.0243929103830327*lnbara*v3*w - 0.43003699366991677*u*v3*w + 
     0.08499596758732683*u2*v3*w - 0.014908075298963635*u3*v3*w + 
     0.0013746585204415407*u4*v3*w - 0.0009147194949975854*v4*w + 
     0.7330635157257923*lnbara*v4*w + 0.17633440249962998*u*v4*w - 
     0.01873833496439247*u2*v4*w + 0.0013746585204415407*u3*v4*w - 
     0.08023092776115039*v5*w - 0.3414643034610109*lnbara*v5*w - 
     0.04423708081452867*u*v5*w + 0.001967584154035969*u2*v5*w + 
     0.039648206713854266*v6*w + 0.09290899944145475*lnbara*v6*w + 
     0.005045032605736152*u*v6*w - 0.00658939908338011*v7*w - 
     0.011206496836004519*lnbara*v7*w + 1.2678249388110159*w2 - 
     1.8873951742070274*lnbara*w2 + 0.5*lnbara2*w2 - 
     1.1060927613105411*u*w2 + lnbara*u*w2 + 0.44851204077043355*u2*w2 - 
     0.6768212688509019*lnbara*u2*w2 - 0.14081609389249217*u3*w2 + 
     0.40107927043016406*lnbara*u3*w2 + 0.018724892062203655*u4*w2 - 
     0.16767848269494548*lnbara*u4*w2 + 0.0035019811348314675*u5*w2 + 
     0.04254600335127144*lnbara*u5*w2 - 0.0011983236323822545*u6*w2 - 
     0.004887855481301699*lnbara*u6*w2 - 1.1060927613105411*v*w2 + 
     lnbara*v*w2 + 0.9405846605504001*u*v*w2 - 0.35311910817754827*u2*v*
      w2 + 0.11965941751579676*u3*v*w2 - 0.02690397081993831*u4*v*w2 + 
     0.0028582170878550506*u5*v*w2 + 0.44851204077043355*v2*w2 - 
     0.6768212688509019*lnbara*v2*w2 - 0.35311910817754827*u*v2*w2 + 
     0.07585906569240349*u2*v2*w2 - 0.013822219055141373*u3*v2*w2 + 
     0.0013006407407352707*u4*v2*w2 - 0.14081609389249217*v3*w2 + 
     0.40107927043016406*lnbara*v3*w2 + 0.11965941751579676*u*v3*w2 - 
     0.013822219055141373*u2*v3*w2 + 0.0010537837376492188*u3*v3*w2 + 
     0.018724892062203655*v4*w2 - 0.16767848269494548*lnbara*v4*w2 - 
     0.02690397081993831*u*v4*w2 + 0.0013006407407352707*u2*v4*w2 + 
     0.0035019811348314675*v5*w2 + 0.04254600335127144*lnbara*v5*w2 + 
     0.0028582170878550506*u*v5*w2 - 0.0011983236323822545*v6*w2 - 
     0.004887855481301699*lnbara*v6*w2 - 1.060859529207977*w3 + 
     2.4414570150807213*lnbara*w3 - 1.*lnbara2*w3 + 
     0.7821136878141817*u*w3 - 1.0243929103830327*lnbara*u*w3 - 
     0.18003999496988*u2*w3 + 0.40107927043016406*lnbara*u2*w3 + 
     0.02888863835365632*u3*w3 - 0.1388888888888889*lnbara*u3*w3 - 
     0.0004120997422309256*u4*w3 + 0.03161639028525199*lnbara*u4*w3 - 
     0.0005095764010007675*u5*w3 - 0.003384978503667747*lnbara*u5*w3 + 
     0.7821136878141817*v*w3 - 1.0243929103830327*lnbara*v*w3 - 
     0.5774492165623843*u*v*w3 + 0.12908291361954194*u2*v*w3 - 
     0.024020753044566752*u3*v*w3 + 0.002288117132733893*u4*v*w3 - 
     0.18003999496988*v2*w3 + 0.40107927043016406*lnbara*v2*w3 + 
     0.12908291361954194*u*v2*w3 - 0.01551291842567776*u2*v2*w3 + 
     0.0012080368273358105*u3*v2*w3 + 0.02888863835365632*v3*w3 - 
     0.1388888888888889*lnbara*v3*w3 - 0.024020753044566752*u*v3*w3 + 
     0.0012080368273358105*u2*v3*w3 - 0.0004120997422309256*v4*w3 + 
     0.03161639028525199*lnbara*v4*w3 + 0.002288117132733893*u*v4*w3 - 
     0.0005095764010007675*v5*w3 - 0.003384978503667747*lnbara*v5*w3 + 
     0.5439607236957894*w4 - 2.027428358467869*lnbara*w4 + 
     1.25*lnbara2*w4 - 0.36126607525541354*u*w4 + 
     0.7330635157257923*lnbara*u*w4 + 0.0421124901425931*u2*w4 - 
     0.16767848269494548*lnbara*u2*w4 - 0.0017631802385249043*u3*w4 + 
     0.03161639028525199*lnbara*u3*w4 - 0.00032828045176791254*u4*w4 - 
     0.0030360036294498475*lnbara*u4*w4 - 0.36126607525541354*v*w4 + 
     0.7330635157257923*lnbara*v*w4 + 0.24486689358283967*u*v*w4 - 
     0.03008582292656479*u2*v*w4 + 0.002373235870460425*u3*v*w4 + 
     0.0421124901425931*v2*w4 - 0.16767848269494548*lnbara*v2*w4 - 
     0.03008582292656479*u*v2*w4 + 0.0015468623265518214*u2*v2*w4 - 
     0.0017631802385249043*v3*w4 + 0.03161639028525199*lnbara*v3*w4 + 
     0.002373235870460425*u*v3*w4 - 0.00032828045176791254*v4*w4 - 
     0.0030360036294498475*lnbara*v4*w4 - 0.14615571875230068*w5 + 
     1.0354918741936614*lnbara*w5 - 1.*lnbara2*w5 + 
     0.09390116503921771*u*w5 - 0.3414643034610109*lnbara*u*w5 - 
     0.00338099408846976*u2*w5 + 0.04254600335127144*lnbara*u2*w5 - 
     0.0002861013781231583*u3*w5 - 0.003384978503667747*lnbara*u3*w5 + 
     0.09390116503921771*v*w5 - 0.3414643034610109*lnbara*v*w5 - 
     0.06258188349808913*u*v*w5 + 0.0032620105692251983*u2*v*w5 - 
     0.00338099408846976*v2*w5 + 0.04254600335127144*lnbara*v2*w5 + 
     0.0032620105692251983*u*v2*w5 - 0.0002861013781231583*v3*w5 - 
     0.003384978503667747*lnbara*v3*w5 + 0.010477082683338539*w6 - 
     0.29010306812282344*lnbara*w6 + 0.5*lnbara2*w6 - 
     0.008754399311784065*u*w6 + 0.09290899944145475*lnbara*u*w6 - 
     0.0003407921988201555*u2*w6 - 0.004887855481301699*lnbara*u2*w6 - 
     0.008754399311784065*v*w6 + 0.09290899944145475*lnbara*v*w6 + 
     0.007220363850737711*u*v*w6 - 0.0003407921988201555*v2*w6 - 
     0.004887855481301699*lnbara*v2*w6 + 0.0020090616972084545*w7 + 
     0.02979573406854684*lnbara*w7 - 0.14285714285714285*lnbara2*w7 - 
     0.0006696872324028182*u*w7 - 0.011206496836004519*lnbara*u*w7 - 
     0.0006696872324028182*v*w7 - 0.011206496836004519*lnbara*v*w7 + 
     0.00008371090405035228*w8 + 0.0018787816594339048*lnbara*w8 + 
     0.017857142857142856*lnbara2*w8 - 1.2119431337444038*y + 
     0.6357142857142857*lnbara*y - 0.07142857142857142*lnbara2*y + 
     1.7363044156749696*u*y - 1.8063725404567375*u2*y + 
     1.7392655054241464*u3*y - 1.211930536655639*u4*y + 
     0.5565850065099112*u5*y - 0.15014045193375553*u6*y + 
     0.01800569050603713*u7*y + 0.878913485311602*v*y - 
     0.7813024128964863*lnbara*v*y - 0.9885653430969441*u*v*y + 
     0.5671031350895516*u2*v*y - 0.3131042491486924*u3*v*y + 
     0.1262878385252224*u4*v*y - 0.03138411241664758*u5*v*y + 
     0.003557820085944631*u6*v*y - 0.6550621164463183*v2*y + lnbara*v2*y + 
     0.7018651651305952*u*v2*y - 0.23349143267332484*u2*v2*y + 
     0.07479560941667407*u3*v2*y - 0.01632082648577182*u4*v2*y + 
     0.0017031606129609958*u5*v2*y + 0.2738798821698887*v3*y - 
     1.0243929103830327*lnbara*v3*y - 0.41431315409504377*u*v3*y + 
     0.0800625198854355*u2*v3*y - 0.01387288739518578*u3*v3*y + 
     0.001270334042999831*u4*v3*y + 0.01753357928415362*v4*y + 
     0.7330635157257923*lnbara*v4*y + 0.17213360808035297*u*v4*y - 
     0.018011963451589594*u2*v4*y + 0.0013099680497976988*u3*v4*y - 
     0.08639020220532784*v5*y - 0.3414643034610109*lnbara*v5*y - 
     0.04346745568123319*u*v5*y + 0.001911174312857377*u2*v5*y + 
     0.04094734531651254*v6*y + 0.09290899944145475*lnbara*v6*y + 
     0.00497631274951997*u*v6*y - 0.006717058480948745*v7*y - 
     0.011206496836004519*lnbara*v7*y + 1.132888498699905*w*y - 
     0.7813024128964863*lnbara*w*y - 1.2152056460289786*u*w*y + 
     0.7535927089402433*u2*w*y - 0.43003699366991677*u3*w*y + 
     0.17633440249962998*u4*w*y - 0.04423708081452867*u5*w*y + 
     0.005045032605736152*u6*w*y - 0.6761017598904502*v*w*y + 
     0.6878144773789178*lnbara*v*w*y + 0.59024403664156*u*v*w*y - 
     0.21195882822548776*u2*v*w*y + 0.07024343329404853*u3*v*w*y - 
     0.015599046732045124*u4*v*w*y + 0.0016446715859244178*u5*v*w*y + 
     0.34704051130803615*v2*w*y - 0.5731787311490981*lnbara*v2*w*y - 
     0.2853207024227592*u*v2*w*y + 0.05970961235652567*u2*v2*w*y - 
     0.010725838861960173*u3*v2*w*y + 0.0010009197339258765*u4*v2*w*y - 
     0.11507632468914157*v3*w*y + 0.36315903776863345*lnbara*v3*w*y + 
     0.10521916751093474*u*v3*w*y - 0.011944092447949953*u2*v3*w*y + 
     0.0009016198300664359*u3*v3*w*y + 0.013780208167077434*v4*w*y - 
     0.1565120644824315*lnbara*v4*w*y - 0.02459974262590988*u*v4*w*y + 
     0.0011742374174915872*u2*v4*w*y + 0.004042814598569594*v5*w*y + 
     0.040382603570750374*lnbara*v5*w*y + 0.002670611110405308*u*v5*w*y - 
     0.0012158310769012908*v6*w*y - 0.004687810626819727*lnbara*v6*w*y - 
     1.1060927613105411*w2*y + lnbara*w2*y + 0.9405846605504001*u*w2*y - 
     0.35311910817754827*u2*w2*y + 0.11965941751579676*u3*w2*y - 
     0.02690397081993831*u4*w2*y + 0.0028582170878550506*u5*w2*y + 
     0.40592934046849305*v*w2*y - 0.5731787311490981*lnbara*v*w2*y - 
     0.3087572799021273*u*v*w2*y + 0.06727327832759263*u2*v*w2*y - 
     0.012341284474452504*u3*v*w2*y + 0.0011655861883641662*u4*v*w2*y - 
     0.12524168013952142*v2*w2*y + 0.30080945282262306*lnbara*v2*w2*y + 
     0.09413892141422908*u*v2*w2*y - 0.011123030888462724*u2*v2*w2*y + 
     0.0008576480370907614*u3*v2*w2*y + 0.02156396333609938*v3*w2*y - 
     0.11585721384404363*lnbara*v3*w2*y - 0.019654970033404773*u*v3*w2*
      y + 0.0009765463601544392*u2*v3*w2*y + 0.00008455106800475184*v4*
      w2*y + 0.027777777777777776*lnbara*v4*w2*y + 
     0.0019816663126266698*u*v4*w2*y - 0.0004997443132457395*v5*w2*y - 
     0.0030639349524580017*lnbara*v5*w2*y + 0.7821136878141817*w3*y - 
     1.0243929103830327*lnbara*w3*y - 0.5774492165623843*u*w3*y + 
     0.12908291361954194*u2*w3*y - 0.024020753044566752*u3*w3*y + 
     0.002288117132733893*u4*w3*y - 0.16841202717054396*v*w3*y + 
     0.36315903776863345*lnbara*v*w3*y + 0.11827421043881324*u*v*w3*y - 
     0.014305345861885458*u2*v*w3*y + 0.0011178896264369238*u3*v*w3*y + 
     0.02683828203921473*v2*w3*y - 0.11585721384404363*lnbara*v2*w3*y - 
     0.020429093685883477*u*v2*w3*y + 0.0010386240777278052*u2*v2*w3*y - 
     0.0010346506951558188*v3*w3*y + 0.024846655495761868*lnbara*v3*w3*
      y + 0.0018413777506809327*u*v3*w3*y - 0.0003031307111613726*v4*w3*
      y - 0.0025474832491138625*lnbara*v4*w3*y - 0.36126607525541354*w4*
      y + 0.7330635157257923*lnbara*w4*y + 0.24486689358283967*u*w4*y - 
     0.03008582292656479*u2*w4*y + 0.002373235870460425*u3*w4*y + 
     0.04033363311928662*v*w4*y - 0.1565120644824315*lnbara*v*w4*y - 
     0.028240538984487286*u*v*w4*y + 0.0014569340256667344*u2*v*w4*y - 
     0.00185882327413311*v2*w4*y + 0.027777777777777776*lnbara*v2*w4*y + 
     0.0021054037902871444*u*v2*w4*y - 0.0002396628047085045*v3*w4*y - 
     0.0025474832491138625*lnbara*v3*w4*y + 0.09390116503921771*w5*y - 
     0.3414643034610109*lnbara*w5*y - 0.06258188349808913*u*w5*y + 
     0.0032620105692251983*u2*w5*y - 0.003350179034613246*v*w5*y + 
     0.040382603570750374*lnbara*v*w5*y + 0.0031058290583810336*u*v*w5*y - 
     0.0002399697226902283*v2*w5*y - 0.0030639349524580017*lnbara*v2*w5*
      y - 0.008754399311784065*w6*y + 0.09290899944145475*lnbara*w6*y + 
     0.007220363850737711*u*w6*y - 0.00031693336523131804*v*w6*y - 
     0.004687810626819727*lnbara*v*w6*y - 0.0006696872324028182*w7*y - 
     0.011206496836004519*lnbara*w7*y + 1.49959556042469*y2 - 
     1.4436975871035138*lnbara*y2 + 0.25*lnbara2*y2 - 
     1.8063725404567375*u*y2 + 0.8957525884254294*u2*y2 - 
     0.47594273908018797*u3*y2 + 0.18905536415607813*u4*y2 - 
     0.04661932625243986*u5*y2 + 0.005260726475147424*u6*y2 - 
     0.6550621164463183*v*y2 + lnbara*v*y2 + 0.7018651651305952*u*v*y2 - 
     0.23349143267332484*u2*v*y2 + 0.07479560941667407*u3*v*y2 - 
     0.01632082648577182*u4*v*y2 + 0.0017031606129609958*u5*v*y2 + 
     0.3514500470763496*v2*y2 - 0.6768212688509019*lnbara*v2*y2 - 
     0.3145211982372493*u*v2*y2 + 0.06346102200604578*u2*v2*y2 - 
     0.011184878805680112*u3*v2*y2 + 0.0010325956586233194*u4*v2*y2 - 
     0.11097560646847007*v3*y2 + 0.40107927043016406*lnbara*v3*y2 + 
     0.11216265014873544*u*v3*y2 - 0.012460388549811095*u2*v3*y2 + 
     0.000929170356268885*u3*v3*y2 + 0.010651424423197484*v4*y2 - 
     0.16767848269494548*lnbara*v4*y2 - 0.02576675296668821*u*v4*y2 + 
     0.0012120200398115979*u2*v4*y2 + 0.004994214637738621*v5*y2 + 
     0.04254600335127144*lnbara*v5*y2 + 0.0027683707923909567*u*v5*y2 - 
     0.001332365186004987*v6*y2 - 0.004887855481301699*lnbara*v6*y2 - 
     0.7393162088149705*w*y2 + lnbara*w*y2 + 0.7535927089402433*u*w*y2 - 
     0.2603710538739398*u2*w*y2 + 0.08499596758732683*u3*w*y2 - 
     0.01873833496439247*u4*w*y2 + 0.001967584154035969*u5*w*y2 + 
     0.34704051130803615*v*w*y2 - 0.5731787311490981*lnbara*v*w*y2 - 
     0.2853207024227592*u*v*w*y2 + 0.05970961235652567*u2*v*w*y2 - 
     0.010725838861960173*u3*v*w*y2 + 0.0010009197339258765*u4*v*w*y2 - 
     0.11090415302007936*v2*w*y2 + 0.30080945282262306*lnbara*v2*w*y2 + 
     0.09042317924046708*u*v2*w*y2 - 0.010434848681562636*u2*v2*w*y2 + 
     0.0007939134731674265*u3*v2*w*y2 + 0.018270939852523368*v3*w*y2 - 
     0.11585721384404363*lnbara*v3*w*y2 - 0.019168242146174814*u*v3*w*
      y2 + 0.0009375065759672177*u2*v3*w*y2 + 0.0006279468944037123*v4*w*
      y2 + 0.027777777777777776*lnbara*v4*w*y2 + 
     0.001947021061827816*u*v4*w*y2 - 0.0005447808657404928*v5*w*y2 - 
     0.0030639349524580017*lnbara*v5*w*y2 + 0.44851204077043355*w2*y2 - 
     0.6768212688509019*lnbara*w2*y2 - 0.35311910817754827*u*w2*y2 + 
     0.07585906569240349*u2*w2*y2 - 0.013822219055141373*u3*w2*y2 + 
     0.0013006407407352707*u4*w2*y2 - 0.12524168013952142*v*w2*y2 + 
     0.30080945282262306*lnbara*v*w2*y2 + 0.09413892141422908*u*v*w2*y2 - 
     0.011123030888462724*u2*v*w2*y2 + 0.0008576480370907614*u3*v*w2*
      y2 + 0.021120230732081857*v2*w2*y2 - 0.10364253770180369*lnbara*v2*
      w2*y2 - 0.017832523900673754*u*v2*w2*y2 + 
     0.0008927349168409385*u2*v2*w2*y2 - 0.0005261193959703832*v3*w2*
      y2 + 0.023031675044845268*lnbara*v3*w2*y2 + 
     0.001678200058612197*u*v3*w2*y2 - 0.00031988499677263827*v4*w2*
      y2 - 0.0024078266340730905*lnbara*v4*w2*y2 - 
     0.18003999496988*w3*y2 + 0.40107927043016406*lnbara*w3*y2 + 
     0.12908291361954194*u*w3*y2 - 0.01551291842567776*u2*w3*y2 + 
     0.0012080368273358105*u3*w3*y2 + 0.02683828203921473*v*w3*y2 - 
     0.11585721384404363*lnbara*v*w3*y2 - 0.020429093685883477*u*v*w3*
      y2 + 0.0010386240777278052*u2*v*w3*y2 - 0.0011395657623313037*v2*
      w3*y2 + 0.023031675044845268*lnbara*v2*w3*y2 + 
     0.0017183262741199826*u*v2*w3*y2 - 0.0002384653713632691*v3*w3*
      y2 - 0.002233394751425484*lnbara*v3*w3*y2 + 
     0.0421124901425931*w4*y2 - 0.16767848269494548*lnbara*w4*y2 - 
     0.03008582292656479*u*w4*y2 + 0.0015468623265518214*u2*w4*y2 - 
     0.00185882327413311*v*w4*y2 + 0.027777777777777776*lnbara*v*w4*y2 + 
     0.0021054037902871444*u*v*w4*y2 - 0.00021657363943226177*v2*w4*y2 - 
     0.0024078266340730905*lnbara*v2*w4*y2 - 0.00338099408846976*w5*y2 + 
     0.04254600335127144*lnbara*w5*y2 + 0.0032620105692251983*u*w5*y2 - 
     0.0002399697226902283*v*w5*y2 - 0.0030639349524580017*lnbara*v*w5*
      y2 - 0.0003407921988201555*w6*y2 - 0.004887855481301699*lnbara*w6*
      y2 - 1.330149985457792*y3 + 2.2207285075403607*lnbara*y3 - 
     0.5*lnbara2*y3 + 1.7392655054241464*u*y3 - 0.47594273908018797*u2*
      y3 + 0.143917554575605*u3*y3 - 0.030647657382734356*u4*y3 + 
     0.0031576827739003242*u5*y3 + 0.2738798821698887*v*y3 - 
     1.0243929103830327*lnbara*v*y3 - 0.41431315409504377*u*v*y3 + 
     0.0800625198854355*u2*v*y3 - 0.01387288739518578*u3*v*y3 + 
     0.001270334042999831*u4*v*y3 - 0.11097560646847007*v2*y3 + 
     0.40107927043016406*lnbara*v2*y3 + 0.11216265014873544*u*v2*y3 - 
     0.012460388549811095*u2*v2*y3 + 0.000929170356268885*u3*v2*y3 + 
     0.01590829385420868*v3*y3 - 0.1388888888888889*lnbara*v3*y3 - 
     0.02213965249299299*u*v3*y3 + 0.0010588370339842305*u2*v3*y3 + 
     0.0015438790012948771*v4*y3 + 0.03161639028525199*lnbara*v4*y3 + 
     0.0021644635339529753*u*v4*y3 - 0.0006639947469167062*v5*y3 - 
     0.003384978503667747*lnbara*v5*y3 + 0.31511034444848746*w*y3 - 
     1.0243929103830327*lnbara*w*y3 - 0.43003699366991677*u*w*y3 + 
     0.08499596758732683*u2*w*y3 - 0.014908075298963635*u3*w*y3 + 
     0.0013746585204415407*u4*w*y3 - 0.11507632468914157*v*w*y3 + 
     0.36315903776863345*lnbara*v*w*y3 + 0.10521916751093474*u*v*w*y3 - 
     0.011944092447949953*u2*v*w*y3 + 0.0009016198300664359*u3*v*w*y3 + 
     0.018270939852523368*v2*w*y3 - 0.11585721384404363*lnbara*v2*w*y3 - 
     0.019168242146174814*u*v2*w*y3 + 0.0009375065759672177*u2*v2*w*y3 + 
     0.00011168526720960141*v3*w*y3 + 0.024846655495761868*lnbara*v3*w*
      y3 + 0.0017670251675018884*u*v3*w*y3 - 0.0003861048986038681*v4*w*
      y3 - 0.0025474832491138625*lnbara*v4*w*y3 - 
     0.14081609389249217*w2*y3 + 0.40107927043016406*lnbara*w2*y3 + 
     0.11965941751579676*u*w2*y3 - 0.013822219055141373*u2*w2*y3 + 
     0.0010537837376492188*u3*w2*y3 + 0.02156396333609938*v*w2*y3 - 
     0.11585721384404363*lnbara*v*w2*y3 - 0.019654970033404773*u*v*w2*
      y3 + 0.0009765463601544392*u2*v*w2*y3 - 0.0005261193959703832*v2*
      w2*y3 + 0.023031675044845268*lnbara*v2*w2*y3 + 
     0.001678200058612197*u*v2*w2*y3 - 0.00027844820669121686*v3*w2*
      y3 - 0.002233394751425484*lnbara*v3*w2*y3 + 
     0.02888863835365632*w3*y3 - 0.1388888888888889*lnbara*w3*y3 - 
     0.024020753044566752*u*w3*y3 + 0.0012080368273358105*u2*w3*y3 - 
     0.0010346506951558188*v*w3*y3 + 0.024846655495761868*lnbara*v*w3*
      y3 + 0.0018413777506809327*u*v*w3*y3 - 0.0002384653713632691*v2*w3*
      y3 - 0.002233394751425484*lnbara*v2*w3*y3 - 
     0.0017631802385249043*w4*y3 + 0.03161639028525199*lnbara*w4*y3 + 
     0.002373235870460425*u*w4*y3 - 0.0002396628047085045*v*w4*y3 - 
     0.0025474832491138625*lnbara*v*w4*y3 - 0.0002861013781231583*w5*y3 - 
     0.003384978503667747*lnbara*w5*y3 + 0.6458071724555728*y4 - 
     2.2637141792339346*lnbara*y4 + 0.625*lnbara2*y4 - 
     1.211930536655639*u*y4 + 0.18905536415607813*u2*y4 - 
     0.030647657382734356*u3*y4 + 0.002726070724998416*u4*y4 + 
     0.01753357928415362*v*y4 + 0.7330635157257923*lnbara*v*y4 + 
     0.17213360808035297*u*v*y4 - 0.018011963451589594*u2*v*y4 + 
     0.0013099680497976988*u3*v*y4 + 0.010651424423197484*v2*y4 - 
     0.16767848269494548*lnbara*v2*y4 - 0.02576675296668821*u*v2*y4 + 
     0.0012120200398115979*u2*v2*y4 + 0.0015438790012948771*v3*y4 + 
     0.03161639028525199*lnbara*v3*y4 + 0.0021644635339529753*u*v3*y4 - 
     0.0005416818590033571*v4*y4 - 0.0030360036294498475*lnbara*v4*y4 - 
     0.0009147194949975854*w*y4 + 0.7330635157257923*lnbara*w*y4 + 
     0.17633440249962998*u*w*y4 - 0.01873833496439247*u2*w*y4 + 
     0.0013746585204415407*u3*w*y4 + 0.013780208167077434*v*w*y4 - 
     0.1565120644824315*lnbara*v*w*y4 - 0.02459974262590988*u*v*w*y4 + 
     0.0011742374174915872*u2*v*w*y4 + 0.0006279468944037123*v2*w*y4 + 
     0.027777777777777776*lnbara*v2*w*y4 + 0.001947021061827816*u*v2*w*
      y4 - 0.0003861048986038681*v3*w*y4 - 0.0025474832491138625*lnbara*
      v3*w*y4 + 0.018724892062203655*w2*y4 - 0.16767848269494548*lnbara*
      w2*y4 - 0.02690397081993831*u*w2*y4 + 0.0013006407407352707*u2*w2*
      y4 + 0.00008455106800475184*v*w2*y4 + 0.027777777777777776*lnbara*v*
      w2*y4 + 0.0019816663126266698*u*v*w2*y4 - 
     0.00031988499677263827*v2*w2*y4 - 0.0024078266340730905*lnbara*v2*
      w2*y4 - 0.0004120997422309256*w3*y4 + 0.03161639028525199*lnbara*
      w3*y4 + 0.002288117132733893*u*w3*y4 - 0.0003031307111613726*v*w3*
      y4 - 0.0025474832491138625*lnbara*v*w3*y4 - 
     0.00032828045176791254*w4*y4 - 0.0030360036294498475*lnbara*w4*y4 - 
     0.035197295260033824*y5 + 1.5177459370968307*lnbara*y5 - 
     0.5*lnbara2*y5 + 0.5565850065099112*u*y5 - 0.04661932625243986*u2*
      y5 + 0.0031576827739003242*u3*y5 - 0.08639020220532784*v*y5 - 
     0.3414643034610109*lnbara*v*y5 - 0.04346745568123319*u*v*y5 + 
     0.001911174312857377*u2*v*y5 + 0.004994214637738621*v2*y5 + 
     0.04254600335127144*lnbara*v2*y5 + 0.0027683707923909567*u*v2*y5 - 
     0.0006639947469167062*v3*y5 - 0.003384978503667747*lnbara*v3*y5 - 
     0.08023092776115039*w*y5 - 0.3414643034610109*lnbara*w*y5 - 
     0.04423708081452867*u*w*y5 + 0.001967584154035969*u2*w*y5 + 
     0.004042814598569594*v*w*y5 + 0.040382603570750374*lnbara*v*w*y5 + 
     0.002670611110405308*u*v*w*y5 - 0.0005447808657404928*v2*w*y5 - 
     0.0030639349524580017*lnbara*v2*w*y5 + 0.0035019811348314675*w2*y5 + 
     0.04254600335127144*lnbara*w2*y5 + 0.0028582170878550506*u*w2*y5 - 
     0.0004997443132457395*v*w2*y5 - 0.0030639349524580017*lnbara*v*w2*
      y5 - 0.0005095764010007675*w3*y5 - 0.003384978503667747*lnbara*w3*
      y5 - 0.14015949954554044*y6 - 0.6450515340614117*lnbara*y6 + 
     0.25*lnbara2*y6 - 0.15014045193375553*u*y6 + 
     0.005260726475147424*u2*y6 + 0.04094734531651254*v*y6 + 
     0.09290899944145475*lnbara*v*y6 + 0.00497631274951997*u*v*y6 - 
     0.001332365186004987*v2*y6 - 0.004887855481301699*lnbara*v2*y6 + 
     0.039648206713854266*w*y6 + 0.09290899944145475*lnbara*w*y6 + 
     0.005045032605736152*u*w*y6 - 0.0012158310769012908*v*w*y6 - 
     0.004687810626819727*lnbara*v*w*y6 - 0.0011983236323822545*w2*y6 - 
     0.004887855481301699*lnbara*w2*y6 + 0.07142919298974644*y7 + 
     0.15775500989141628*lnbara*y7 - 0.07142857142857142*lnbara2*y7 + 
     0.01800569050603713*u*y7 - 0.006717058480948745*v*y7 - 
     0.011206496836004519*lnbara*v*y7 - 0.00658939908338011*w*y7 - 
     0.011206496836004519*lnbara*w*y7 - 0.011766764554686482*y8 - 
     0.016917752027425906*lnbara*y8 + 0.008928571428571428*lnbara2*y8 - 
     1.2119431337444038*z + 0.6357142857142857*lnbara*z - 
     0.07142857142857142*lnbara2*z + 0.878913485311602*u*z - 
     0.7813024128964863*lnbara*u*z - 0.6550621164463183*u2*z + 
     lnbara*u2*z + 0.2738798821698887*u3*z - 1.0243929103830327*lnbara*u3*
      z + 0.01753357928415362*u4*z + 0.7330635157257923*lnbara*u4*z - 
     0.08639020220532784*u5*z - 0.3414643034610109*lnbara*u5*z + 
     0.04094734531651254*u6*z + 0.09290899944145475*lnbara*u6*z - 
     0.006717058480948745*u7*z - 0.011206496836004519*lnbara*u7*z + 
     1.7363044156749696*v*z - 0.9885653430969441*u*v*z + 
     0.7018651651305952*u2*v*z - 0.41431315409504377*u3*v*z + 
     0.17213360808035297*u4*v*z - 0.04346745568123319*u5*v*z + 
     0.00497631274951997*u6*v*z - 1.8063725404567375*v2*z + 
     0.5671031350895516*u*v2*z - 0.23349143267332484*u2*v2*z + 
     0.0800625198854355*u3*v2*z - 0.018011963451589594*u4*v2*z + 
     0.001911174312857377*u5*v2*z + 1.7392655054241464*v3*z - 
     0.3131042491486924*u*v3*z + 0.07479560941667407*u2*v3*z - 
     0.01387288739518578*u3*v3*z + 0.0013099680497976988*u4*v3*z - 
     1.211930536655639*v4*z + 0.1262878385252224*u*v4*z - 
     0.01632082648577182*u2*v4*z + 0.001270334042999831*u3*v4*z + 
     0.5565850065099112*v5*z - 0.03138411241664758*u*v5*z + 
     0.0017031606129609958*u2*v5*z - 0.15014045193375553*v6*z + 
     0.003557820085944631*u*v6*z + 0.01800569050603713*v7*z + 
     1.132888498699905*w*z - 0.7813024128964863*lnbara*w*z - 
     0.6761017598904502*u*w*z + 0.6878144773789178*lnbara*u*w*z + 
     0.34704051130803615*u2*w*z - 0.5731787311490981*lnbara*u2*w*z - 
     0.11507632468914157*u3*w*z + 0.36315903776863345*lnbara*u3*w*z + 
     0.013780208167077434*u4*w*z - 0.1565120644824315*lnbara*u4*w*z + 
     0.004042814598569594*u5*w*z + 0.040382603570750374*lnbara*u5*w*z - 
     0.0012158310769012908*u6*w*z - 0.004687810626819727*lnbara*u6*w*z - 
     1.2152056460289786*v*w*z + 0.59024403664156*u*v*w*z - 
     0.2853207024227592*u2*v*w*z + 0.10521916751093474*u3*v*w*z - 
     0.02459974262590988*u4*v*w*z + 0.002670611110405308*u5*v*w*z + 
     0.7535927089402433*v2*w*z - 0.21195882822548776*u*v2*w*z + 
     0.05970961235652567*u2*v2*w*z - 0.011944092447949953*u3*v2*w*z + 
     0.0011742374174915872*u4*v2*w*z - 0.43003699366991677*v3*w*z + 
     0.07024343329404853*u*v3*w*z - 0.010725838861960173*u2*v3*w*z + 
     0.0009016198300664359*u3*v3*w*z + 0.17633440249962998*v4*w*z - 
     0.015599046732045124*u*v4*w*z + 0.0010009197339258765*u2*v4*w*z - 
     0.04423708081452867*v5*w*z + 0.0016446715859244178*u*v5*w*z + 
     0.005045032605736152*v6*w*z - 1.1060927613105411*w2*z + lnbara*w2*z + 
     0.40592934046849305*u*w2*z - 0.5731787311490981*lnbara*u*w2*z - 
     0.12524168013952142*u2*w2*z + 0.30080945282262306*lnbara*u2*w2*z + 
     0.02156396333609938*u3*w2*z - 0.11585721384404363*lnbara*u3*w2*z + 
     0.00008455106800475184*u4*w2*z + 0.027777777777777776*lnbara*u4*w2*
      z - 0.0004997443132457395*u5*w2*z - 0.0030639349524580017*lnbara*u5*
      w2*z + 0.9405846605504001*v*w2*z - 0.3087572799021273*u*v*w2*z + 
     0.09413892141422908*u2*v*w2*z - 0.019654970033404773*u3*v*w2*z + 
     0.0019816663126266698*u4*v*w2*z - 0.35311910817754827*v2*w2*z + 
     0.06727327832759263*u*v2*w2*z - 0.011123030888462724*u2*v2*w2*z + 
     0.0009765463601544392*u3*v2*w2*z + 0.11965941751579676*v3*w2*z - 
     0.012341284474452504*u*v3*w2*z + 0.0008576480370907614*u2*v3*w2*z - 
     0.02690397081993831*v4*w2*z + 0.0011655861883641662*u*v4*w2*z + 
     0.0028582170878550506*v5*w2*z + 0.7821136878141817*w3*z - 
     1.0243929103830327*lnbara*w3*z - 0.16841202717054396*u*w3*z + 
     0.36315903776863345*lnbara*u*w3*z + 0.02683828203921473*u2*w3*z - 
     0.11585721384404363*lnbara*u2*w3*z - 0.0010346506951558188*u3*w3*z + 
     0.024846655495761868*lnbara*u3*w3*z - 0.0003031307111613726*u4*w3*
      z - 0.0025474832491138625*lnbara*u4*w3*z - 0.5774492165623843*v*w3*
      z + 0.11827421043881324*u*v*w3*z - 0.020429093685883477*u2*v*w3*z + 
     0.0018413777506809327*u3*v*w3*z + 0.12908291361954194*v2*w3*z - 
     0.014305345861885458*u*v2*w3*z + 0.0010386240777278052*u2*v2*w3*z - 
     0.024020753044566752*v3*w3*z + 0.0011178896264369238*u*v3*w3*z + 
     0.002288117132733893*v4*w3*z - 0.36126607525541354*w4*z + 
     0.7330635157257923*lnbara*w4*z + 0.04033363311928662*u*w4*z - 
     0.1565120644824315*lnbara*u*w4*z - 0.00185882327413311*u2*w4*z + 
     0.027777777777777776*lnbara*u2*w4*z - 0.0002396628047085045*u3*w4*
      z - 0.0025474832491138625*lnbara*u3*w4*z + 0.24486689358283967*v*w4*
      z - 0.028240538984487286*u*v*w4*z + 0.0021054037902871444*u2*v*w4*
      z - 0.03008582292656479*v2*w4*z + 0.0014569340256667344*u*v2*w4*z + 
     0.002373235870460425*v3*w4*z + 0.09390116503921771*w5*z - 
     0.3414643034610109*lnbara*w5*z - 0.003350179034613246*u*w5*z + 
     0.040382603570750374*lnbara*u*w5*z - 0.0002399697226902283*u2*w5*z - 
     0.0030639349524580017*lnbara*u2*w5*z - 0.06258188349808913*v*w5*z + 
     0.0031058290583810336*u*v*w5*z + 0.0032620105692251983*v2*w5*z - 
     0.008754399311784065*w6*z + 0.09290899944145475*lnbara*w6*z - 
     0.00031693336523131804*u*w6*z - 0.004687810626819727*lnbara*u*w6*z + 
     0.007220363850737711*v*w6*z - 0.0006696872324028182*w7*z - 
     0.011206496836004519*lnbara*w7*z + 1.7363044156749696*y*z - 
     0.9885653430969441*u*y*z + 0.7018651651305952*u2*y*z - 
     0.41431315409504377*u3*y*z + 0.17213360808035297*u4*y*z - 
     0.04346745568123319*u5*y*z + 0.00497631274951997*u6*y*z - 
     0.9885653430969441*v*y*z + 0.4109157481416769*u*v*y*z - 
     0.18317523399334182*u2*v*y*z + 0.06473552238444277*u3*v*y*z - 
     0.014772762292074491*u4*v*y*z + 0.0015798778632113992*u5*v*y*z + 
     0.7018651651305952*v2*y*z - 0.18317523399334182*u*v2*y*z + 
     0.04926825374502858*u2*v2*y*z - 0.009593654231383138*u3*v2*y*z + 
     0.0009279102407948306*u4*v2*y*z - 0.41431315409504377*v3*y*z + 
     0.06473552238444277*u*v3*y*z - 0.009593654231383138*u2*v3*y*z + 
     0.0007917184813914537*u3*v3*y*z + 0.17213360808035297*v4*y*z - 
     0.014772762292074491*u*v4*y*z + 0.0009279102407948306*u2*v4*y*z - 
     0.04346745568123319*v5*y*z + 0.0015798778632113992*u*v5*y*z + 
     0.00497631274951997*v6*y*z - 1.2152056460289786*w*y*z + 
     0.59024403664156*u*w*y*z - 0.2853207024227592*u2*w*y*z + 
     0.10521916751093474*u3*w*y*z - 0.02459974262590988*u4*w*y*z + 
     0.002670611110405308*u5*w*y*z + 0.59024403664156*v*w*y*z - 
     0.17826112061997315*u*v*w*y*z + 0.05176117871302977*u2*v*w*y*z - 
     0.010504755263170868*u3*v*w*y*z + 0.0010408374899911962*u4*v*w*y*z - 
     0.2853207024227592*v2*w*y*z + 0.05176117871302977*u*v2*w*y*z - 
     0.008293671643270249*u2*v2*w*y*z + 0.0007141774155409824*u3*v2*w*y*
      z + 0.10521916751093474*v3*w*y*z - 0.010504755263170868*u*v3*w*y*z + 
     0.0007141774155409824*u2*v3*w*y*z - 0.02459974262590988*v4*w*y*z + 
     0.0010408374899911962*u*v4*w*y*z + 0.002670611110405308*v5*w*y*z + 
     0.9405846605504001*w2*y*z - 0.3087572799021273*u*w2*y*z + 
     0.09413892141422908*u2*w2*y*z - 0.019654970033404773*u3*w2*y*z + 
     0.0019816663126266698*u4*w2*y*z - 0.3087572799021273*v*w2*y*z + 
     0.060346966077840625*u*v*w2*y*z - 0.010114542092320464*u2*v*w2*y*z + 
     0.0008946786933220228*u3*v*w2*y*z + 0.09413892141422908*v2*w2*y*z - 
     0.010114542092320464*u*v2*w2*y*z + 0.00071910562986183*u2*v2*w2*y*
      z - 0.019654970033404773*v3*w2*y*z + 0.0008946786933220228*u*v3*w2*
      y*z + 0.0019816663126266698*v4*w2*y*z - 0.5774492165623843*w3*y*z + 
     0.11827421043881324*u*w3*y*z - 0.020429093685883477*u2*w3*y*z + 
     0.0018413777506809327*u3*w3*y*z + 0.11827421043881324*v*w3*y*z - 
     0.013259198472372514*u*v*w3*y*z + 0.0009694445689965282*u2*v*w3*y*z - 
     0.020429093685883477*v2*w3*y*z + 0.0009694445689965282*u*v2*w3*y*z + 
     0.0018413777506809327*v3*w3*y*z + 0.24486689358283967*w4*y*z - 
     0.028240538984487286*u*w4*y*z + 0.0021054037902871444*u2*w4*y*z - 
     0.028240538984487286*v*w4*y*z + 0.0013759104801000723*u*v*w4*y*z + 
     0.0021054037902871444*v2*w4*y*z - 0.06258188349808913*w5*y*z + 
     0.0031058290583810336*u*w5*y*z + 0.0031058290583810336*v*w5*y*z + 
     0.007220363850737711*w6*y*z - 1.8063725404567375*y2*z + 
     0.5671031350895516*u*y2*z - 0.23349143267332484*u2*y2*z + 
     0.0800625198854355*u3*y2*z - 0.018011963451589594*u4*y2*z + 
     0.001911174312857377*u5*y2*z + 0.7018651651305952*v*y2*z - 
     0.18317523399334182*u*v*y2*z + 0.04926825374502858*u2*v*y2*z - 
     0.009593654231383138*u3*v*y2*z + 0.0009279102407948306*u4*v*y2*z - 
     0.3145211982372493*v2*y2*z + 0.05324247056677653*u*v2*y2*z - 
     0.00817022761462202*u2*v2*y2*z + 0.0006855605604060971*u3*v2*y2*
      z + 0.11216265014873544*v3*y2*z - 0.010750311705942078*u*v3*y2*z + 
     0.0007107796438381393*u2*v3*y2*z - 0.02576675296668821*v4*y2*z + 
     0.0010604472614234883*u*v4*y2*z + 0.0027683707923909567*v5*y2*z + 
     0.7535927089402433*w*y2*z - 0.21195882822548776*u*w*y2*z + 
     0.05970961235652567*u2*w*y2*z - 0.011944092447949953*u3*w*y2*z + 
     0.0011742374174915872*u4*w*y2*z - 0.2853207024227592*v*w*y2*z + 
     0.05176117871302977*u*v*w*y2*z - 0.008293671643270249*u2*v*w*y2*z + 
     0.0007141774155409824*u3*v*w*y2*z + 0.09042317924046708*v2*w*y2*z - 
     0.009302160439412508*u*v2*w*y2*z + 0.0006425989725751736*u2*v2*w*y2*
      z - 0.019168242146174814*v3*w*y2*z + 0.0008476691271990539*u*v3*w*
      y2*z + 0.001947021061827816*v4*w*y2*z - 0.35311910817754827*w2*y2*
      z + 0.06727327832759263*u*w2*y2*z - 0.011123030888462724*u2*w2*y2*
      z + 0.0009765463601544392*u3*w2*y2*z + 0.09413892141422908*v*w2*y2*
      z - 0.010114542092320464*u*v*w2*y2*z + 0.00071910562986183*u2*v*w2*
      y2*z - 0.017832523900673754*v2*w2*y2*z + 0.0008228748929587454*u*
      v2*w2*y2*z + 0.001678200058612197*v3*w2*y2*z + 
     0.12908291361954194*w3*y2*z - 0.014305345861885458*u*w3*y2*z + 
     0.0010386240777278052*u2*w3*y2*z - 0.020429093685883477*v*w3*y2*z + 
     0.0009694445689965282*u*v*w3*y2*z + 0.0017183262741199826*v2*w3*y2*
      z - 0.03008582292656479*w4*y2*z + 0.0014569340256667344*u*w4*y2*z + 
     0.0021054037902871444*v*w4*y2*z + 0.0032620105692251983*w5*y2*z + 
     1.7392655054241464*y3*z - 0.3131042491486924*u*y3*z + 
     0.07479560941667407*u2*y3*z - 0.01387288739518578*u3*y3*z + 
     0.0013099680497976988*u4*y3*z - 0.41431315409504377*v*y3*z + 
     0.06473552238444277*u*v*y3*z - 0.009593654231383138*u2*v*y3*z + 
     0.0007917184813914537*u3*v*y3*z + 0.11216265014873544*v2*y3*z - 
     0.010750311705942078*u*v2*y3*z + 0.0007107796438381393*u2*v2*y3*z - 
     0.02213965249299299*v3*y3*z + 0.0009392449858988379*u*v3*y3*z + 
     0.0021644635339529753*v4*y3*z - 0.43003699366991677*w*y3*z + 
     0.07024343329404853*u*w*y3*z - 0.010725838861960173*u2*w*y3*z + 
     0.0009016198300664359*u3*w*y3*z + 0.10521916751093474*v*w*y3*z - 
     0.010504755263170868*u*v*w*y3*z + 0.0007141774155409824*u2*v*w*y3*z - 
     0.019168242146174814*v2*w*y3*z + 0.0008476691271990539*u*v2*w*y3*z + 
     0.0017670251675018884*v3*w*y3*z + 0.11965941751579676*w2*y3*z - 
     0.012341284474452504*u*w2*y3*z + 0.0008576480370907614*u2*w2*y3*z - 
     0.019654970033404773*v*w2*y3*z + 0.0008946786933220228*u*v*w2*y3*z + 
     0.001678200058612197*v2*w2*y3*z - 0.024020753044566752*w3*y3*z + 
     0.0011178896264369238*u*w3*y3*z + 0.0018413777506809327*v*w3*y3*z + 
     0.002373235870460425*w4*y3*z - 1.211930536655639*y4*z + 
     0.1262878385252224*u*y4*z - 0.01632082648577182*u2*y4*z + 
     0.001270334042999831*u3*y4*z + 0.17213360808035297*v*y4*z - 
     0.014772762292074491*u*v*y4*z + 0.0009279102407948306*u2*v*y4*z - 
     0.02576675296668821*v2*y4*z + 0.0010604472614234883*u*v2*y4*z + 
     0.0021644635339529753*v3*y4*z + 0.17633440249962998*w*y4*z - 
     0.015599046732045124*u*w*y4*z + 0.0010009197339258765*u2*w*y4*z - 
     0.02459974262590988*v*w*y4*z + 0.0010408374899911962*u*v*w*y4*z + 
     0.001947021061827816*v2*w*y4*z - 0.02690397081993831*w2*y4*z + 
     0.0011655861883641662*u*w2*y4*z + 0.0019816663126266698*v*w2*y4*z + 
     0.002288117132733893*w3*y4*z + 0.5565850065099112*y5*z - 
     0.03138411241664758*u*y5*z + 0.0017031606129609958*u2*y5*z - 
     0.04346745568123319*v*y5*z + 0.0015798778632113992*u*v*y5*z + 
     0.0027683707923909567*v2*y5*z - 0.04423708081452867*w*y5*z + 
     0.0016446715859244178*u*w*y5*z + 0.002670611110405308*v*w*y5*z + 
     0.0028582170878550506*w2*y5*z - 0.15014045193375553*y6*z + 
     0.003557820085944631*u*y6*z + 0.00497631274951997*v*y6*z + 
     0.005045032605736152*w*y6*z + 0.01800569050603713*y7*z + 
     1.49959556042469*z2 - 1.4436975871035138*lnbara*z2 + 
     0.25*lnbara2*z2 - 0.6550621164463183*u*z2 + lnbara*u*z2 + 
     0.3514500470763496*u2*z2 - 0.6768212688509019*lnbara*u2*z2 - 
     0.11097560646847007*u3*z2 + 0.40107927043016406*lnbara*u3*z2 + 
     0.010651424423197484*u4*z2 - 0.16767848269494548*lnbara*u4*z2 + 
     0.004994214637738621*u5*z2 + 0.04254600335127144*lnbara*u5*z2 - 
     0.001332365186004987*u6*z2 - 0.004887855481301699*lnbara*u6*z2 - 
     1.8063725404567375*v*z2 + 0.7018651651305952*u*v*z2 - 
     0.3145211982372493*u2*v*z2 + 0.11216265014873544*u3*v*z2 - 
     0.02576675296668821*u4*v*z2 + 0.0027683707923909567*u5*v*z2 + 
     0.8957525884254294*v2*z2 - 0.23349143267332484*u*v2*z2 + 
     0.06346102200604578*u2*v2*z2 - 0.012460388549811095*u3*v2*z2 + 
     0.0012120200398115979*u4*v2*z2 - 0.47594273908018797*v3*z2 + 
     0.07479560941667407*u*v3*z2 - 0.011184878805680112*u2*v3*z2 + 
     0.000929170356268885*u3*v3*z2 + 0.18905536415607813*v4*z2 - 
     0.01632082648577182*u*v4*z2 + 0.0010325956586233194*u2*v4*z2 - 
     0.04661932625243986*v5*z2 + 0.0017031606129609958*u*v5*z2 + 
     0.005260726475147424*v6*z2 - 0.7393162088149705*w*z2 + lnbara*w*z2 + 
     0.34704051130803615*u*w*z2 - 0.5731787311490981*lnbara*u*w*z2 - 
     0.11090415302007936*u2*w*z2 + 0.30080945282262306*lnbara*u2*w*z2 + 
     0.018270939852523368*u3*w*z2 - 0.11585721384404363*lnbara*u3*w*z2 + 
     0.0006279468944037123*u4*w*z2 + 0.027777777777777776*lnbara*u4*w*
      z2 - 0.0005447808657404928*u5*w*z2 - 0.0030639349524580017*lnbara*
      u5*w*z2 + 0.7535927089402433*v*w*z2 - 0.2853207024227592*u*v*w*z2 + 
     0.09042317924046708*u2*v*w*z2 - 0.019168242146174814*u3*v*w*z2 + 
     0.001947021061827816*u4*v*w*z2 - 0.2603710538739398*v2*w*z2 + 
     0.05970961235652567*u*v2*w*z2 - 0.010434848681562636*u2*v2*w*z2 + 
     0.0009375065759672177*u3*v2*w*z2 + 0.08499596758732683*v3*w*z2 - 
     0.010725838861960173*u*v3*w*z2 + 0.0007939134731674265*u2*v3*w*z2 - 
     0.01873833496439247*v4*w*z2 + 0.0010009197339258765*u*v4*w*z2 + 
     0.001967584154035969*v5*w*z2 + 0.44851204077043355*w2*z2 - 
     0.6768212688509019*lnbara*w2*z2 - 0.12524168013952142*u*w2*z2 + 
     0.30080945282262306*lnbara*u*w2*z2 + 0.021120230732081857*u2*w2*
      z2 - 0.10364253770180369*lnbara*u2*w2*z2 - 
     0.0005261193959703832*u3*w2*z2 + 0.023031675044845268*lnbara*u3*w2*
      z2 - 0.00031988499677263827*u4*w2*z2 - 0.0024078266340730905*lnbara*
      u4*w2*z2 - 0.35311910817754827*v*w2*z2 + 
     0.09413892141422908*u*v*w2*z2 - 0.017832523900673754*u2*v*w2*z2 + 
     0.001678200058612197*u3*v*w2*z2 + 0.07585906569240349*v2*w2*z2 - 
     0.011123030888462724*u*v2*w2*z2 + 0.0008927349168409385*u2*v2*w2*
      z2 - 0.013822219055141373*v3*w2*z2 + 0.0008576480370907614*u*v3*
      w2*z2 + 0.0013006407407352707*v4*w2*z2 - 
     0.18003999496988*w3*z2 + 0.40107927043016406*lnbara*w3*z2 + 
     0.02683828203921473*u*w3*z2 - 0.11585721384404363*lnbara*u*w3*z2 - 
     0.0011395657623313037*u2*w3*z2 + 0.023031675044845268*lnbara*u2*w3*
      z2 - 0.0002384653713632691*u3*w3*z2 - 0.002233394751425484*lnbara*
      u3*w3*z2 + 0.12908291361954194*v*w3*z2 - 
     0.020429093685883477*u*v*w3*z2 + 0.0017183262741199826*u2*v*w3*z2 - 
     0.01551291842567776*v2*w3*z2 + 0.0010386240777278052*u*v2*w3*z2 + 
     0.0012080368273358105*v3*w3*z2 + 0.0421124901425931*w4*z2 - 
     0.16767848269494548*lnbara*w4*z2 - 0.00185882327413311*u*w4*z2 + 
     0.027777777777777776*lnbara*u*w4*z2 - 0.00021657363943226177*u2*w4*
      z2 - 0.0024078266340730905*lnbara*u2*w4*z2 - 
     0.03008582292656479*v*w4*z2 + 0.0021054037902871444*u*v*w4*z2 + 
     0.0015468623265518214*v2*w4*z2 - 0.00338099408846976*w5*z2 + 
     0.04254600335127144*lnbara*w5*z2 - 0.0002399697226902283*u*w5*z2 - 
     0.0030639349524580017*lnbara*u*w5*z2 + 0.0032620105692251983*v*w5*
      z2 - 0.0003407921988201555*w6*z2 - 0.004887855481301699*lnbara*w6*
      z2 - 1.8063725404567375*y*z2 + 0.7018651651305952*u*y*z2 - 
     0.3145211982372493*u2*y*z2 + 0.11216265014873544*u3*y*z2 - 
     0.02576675296668821*u4*y*z2 + 0.0027683707923909567*u5*y*z2 + 
     0.5671031350895516*v*y*z2 - 0.18317523399334182*u*v*y*z2 + 
     0.05324247056677653*u2*v*y*z2 - 0.010750311705942078*u3*v*y*z2 + 
     0.0010604472614234883*u4*v*y*z2 - 0.23349143267332484*v2*y*z2 + 
     0.04926825374502858*u*v2*y*z2 - 0.00817022761462202*u2*v2*y*z2 + 
     0.0007107796438381393*u3*v2*y*z2 + 0.0800625198854355*v3*y*z2 - 
     0.009593654231383138*u*v3*y*z2 + 0.0006855605604060971*u2*v3*y*z2 - 
     0.018011963451589594*v4*y*z2 + 0.0009279102407948306*u*v4*y*z2 + 
     0.001911174312857377*v5*y*z2 + 0.7535927089402433*w*y*z2 - 
     0.2853207024227592*u*w*y*z2 + 0.09042317924046708*u2*w*y*z2 - 
     0.019168242146174814*u3*w*y*z2 + 0.001947021061827816*u4*w*y*z2 - 
     0.21195882822548776*v*w*y*z2 + 0.05176117871302977*u*v*w*y*z2 - 
     0.009302160439412508*u2*v*w*y*z2 + 0.0008476691271990539*u3*v*w*y*
      z2 + 0.05970961235652567*v2*w*y*z2 - 0.008293671643270249*u*v2*w*y*
      z2 + 0.0006425989725751736*u2*v2*w*y*z2 - 
     0.011944092447949953*v3*w*y*z2 + 0.0007141774155409824*u*v3*w*y*z2 + 
     0.0011742374174915872*v4*w*y*z2 - 0.35311910817754827*w2*y*z2 + 
     0.09413892141422908*u*w2*y*z2 - 0.017832523900673754*u2*w2*y*z2 + 
     0.001678200058612197*u3*w2*y*z2 + 0.06727327832759263*v*w2*y*z2 - 
     0.010114542092320464*u*v*w2*y*z2 + 0.0008228748929587454*u2*v*w2*y*
      z2 - 0.011123030888462724*v2*w2*y*z2 + 0.00071910562986183*u*v2*
      w2*y*z2 + 0.0009765463601544392*v3*w2*y*z2 + 
     0.12908291361954194*w3*y*z2 - 0.020429093685883477*u*w3*y*z2 + 
     0.0017183262741199826*u2*w3*y*z2 - 0.014305345861885458*v*w3*y*z2 + 
     0.0009694445689965282*u*v*w3*y*z2 + 0.0010386240777278052*v2*w3*y*
      z2 - 0.03008582292656479*w4*y*z2 + 0.0021054037902871444*u*w4*y*
      z2 + 0.0014569340256667344*v*w4*y*z2 + 0.0032620105692251983*w5*y*
      z2 + 0.8957525884254294*y2*z2 - 0.23349143267332484*u*y2*z2 + 
     0.06346102200604578*u2*y2*z2 - 0.012460388549811095*u3*y2*z2 + 
     0.0012120200398115979*u4*y2*z2 - 0.23349143267332484*v*y2*z2 + 
     0.04926825374502858*u*v*y2*z2 - 0.00817022761462202*u2*v*y2*z2 + 
     0.0007107796438381393*u3*v*y2*z2 + 0.06346102200604578*v2*y2*z2 - 
     0.00817022761462202*u*v2*y2*z2 + 0.0006031345488998603*u2*v2*y2*
      z2 - 0.012460388549811095*v3*y2*z2 + 0.0007107796438381393*u*v3*
      y2*z2 + 0.0012120200398115979*v4*y2*z2 - 
     0.2603710538739398*w*y2*z2 + 0.05970961235652567*u*w*y2*z2 - 
     0.010434848681562636*u2*w*y2*z2 + 0.0009375065759672177*u3*w*y2*
      z2 + 0.05970961235652567*v*w*y2*z2 - 0.008293671643270249*u*v*w*y2*
      z2 + 0.0006425989725751736*u2*v*w*y2*z2 - 
     0.010434848681562636*v2*w*y2*z2 + 0.0006425989725751736*u*v2*w*y2*
      z2 + 0.0009375065759672177*v3*w*y2*z2 + 0.07585906569240349*w2*y2*
      z2 - 0.011123030888462724*u*w2*y2*z2 + 0.0008927349168409385*u2*
      w2*y2*z2 - 0.011123030888462724*v*w2*y2*z2 + 
     0.00071910562986183*u*v*w2*y2*z2 + 0.0008927349168409385*v2*w2*y2*
      z2 - 0.01551291842567776*w3*y2*z2 + 0.0010386240777278052*u*w3*y2*
      z2 + 0.0010386240777278052*v*w3*y2*z2 + 0.0015468623265518214*w4*
      y2*z2 - 0.47594273908018797*y3*z2 + 0.07479560941667407*u*y3*z2 - 
     0.011184878805680112*u2*y3*z2 + 0.000929170356268885*u3*y3*z2 + 
     0.0800625198854355*v*y3*z2 - 0.009593654231383138*u*v*y3*z2 + 
     0.0006855605604060971*u2*v*y3*z2 - 0.012460388549811095*v2*y3*z2 + 
     0.0007107796438381393*u*v2*y3*z2 + 0.0010588370339842305*v3*y3*
      z2 + 0.08499596758732683*w*y3*z2 - 0.010725838861960173*u*w*y3*
      z2 + 0.0007939134731674265*u2*w*y3*z2 - 0.011944092447949953*v*w*
      y3*z2 + 0.0007141774155409824*u*v*w*y3*z2 + 
     0.0009375065759672177*v2*w*y3*z2 - 0.013822219055141373*w2*y3*z2 + 
     0.0008576480370907614*u*w2*y3*z2 + 0.0009765463601544392*v*w2*y3*
      z2 + 0.0012080368273358105*w3*y3*z2 + 0.18905536415607813*y4*z2 - 
     0.01632082648577182*u*y4*z2 + 0.0010325956586233194*u2*y4*z2 - 
     0.018011963451589594*v*y4*z2 + 0.0009279102407948306*u*v*y4*z2 + 
     0.0012120200398115979*v2*y4*z2 - 0.01873833496439247*w*y4*z2 + 
     0.0010009197339258765*u*w*y4*z2 + 0.0011742374174915872*v*w*y4*z2 + 
     0.0013006407407352707*w2*y4*z2 - 0.04661932625243986*y5*z2 + 
     0.0017031606129609958*u*y5*z2 + 0.001911174312857377*v*y5*z2 + 
     0.001967584154035969*w*y5*z2 + 0.005260726475147424*y6*z2 - 
     1.330149985457792*z3 + 2.2207285075403607*lnbara*z3 - 
     0.5*lnbara2*z3 + 0.2738798821698887*u*z3 - 1.0243929103830327*lnbara*
      u*z3 - 0.11097560646847007*u2*z3 + 0.40107927043016406*lnbara*u2*
      z3 + 0.01590829385420868*u3*z3 - 0.1388888888888889*lnbara*u3*z3 + 
     0.0015438790012948771*u4*z3 + 0.03161639028525199*lnbara*u4*z3 - 
     0.0006639947469167062*u5*z3 - 0.003384978503667747*lnbara*u5*z3 + 
     1.7392655054241464*v*z3 - 0.41431315409504377*u*v*z3 + 
     0.11216265014873544*u2*v*z3 - 0.02213965249299299*u3*v*z3 + 
     0.0021644635339529753*u4*v*z3 - 0.47594273908018797*v2*z3 + 
     0.0800625198854355*u*v2*z3 - 0.012460388549811095*u2*v2*z3 + 
     0.0010588370339842305*u3*v2*z3 + 0.143917554575605*v3*z3 - 
     0.01387288739518578*u*v3*z3 + 0.000929170356268885*u2*v3*z3 - 
     0.030647657382734356*v4*z3 + 0.001270334042999831*u*v4*z3 + 
     0.0031576827739003242*v5*z3 + 0.31511034444848746*w*z3 - 
     1.0243929103830327*lnbara*w*z3 - 0.11507632468914157*u*w*z3 + 
     0.36315903776863345*lnbara*u*w*z3 + 0.018270939852523368*u2*w*z3 - 
     0.11585721384404363*lnbara*u2*w*z3 + 0.00011168526720960141*u3*w*
      z3 + 0.024846655495761868*lnbara*u3*w*z3 - 
     0.0003861048986038681*u4*w*z3 - 0.0025474832491138625*lnbara*u4*w*
      z3 - 0.43003699366991677*v*w*z3 + 0.10521916751093474*u*v*w*z3 - 
     0.019168242146174814*u2*v*w*z3 + 0.0017670251675018884*u3*v*w*z3 + 
     0.08499596758732683*v2*w*z3 - 0.011944092447949953*u*v2*w*z3 + 
     0.0009375065759672177*u2*v2*w*z3 - 0.014908075298963635*v3*w*z3 + 
     0.0009016198300664359*u*v3*w*z3 + 0.0013746585204415407*v4*w*z3 - 
     0.14081609389249217*w2*z3 + 0.40107927043016406*lnbara*w2*z3 + 
     0.02156396333609938*u*w2*z3 - 0.11585721384404363*lnbara*u*w2*z3 - 
     0.0005261193959703832*u2*w2*z3 + 0.023031675044845268*lnbara*u2*w2*
      z3 - 0.00027844820669121686*u3*w2*z3 - 0.002233394751425484*lnbara*
      u3*w2*z3 + 0.11965941751579676*v*w2*z3 - 
     0.019654970033404773*u*v*w2*z3 + 0.001678200058612197*u2*v*w2*z3 - 
     0.013822219055141373*v2*w2*z3 + 0.0009765463601544392*u*v2*w2*z3 + 
     0.0010537837376492188*v3*w2*z3 + 0.02888863835365632*w3*z3 - 
     0.1388888888888889*lnbara*w3*z3 - 0.0010346506951558188*u*w3*z3 + 
     0.024846655495761868*lnbara*u*w3*z3 - 0.0002384653713632691*u2*w3*
      z3 - 0.002233394751425484*lnbara*u2*w3*z3 - 
     0.024020753044566752*v*w3*z3 + 0.0018413777506809327*u*v*w3*z3 + 
     0.0012080368273358105*v2*w3*z3 - 0.0017631802385249043*w4*z3 + 
     0.03161639028525199*lnbara*w4*z3 - 0.0002396628047085045*u*w4*z3 - 
     0.0025474832491138625*lnbara*u*w4*z3 + 0.002373235870460425*v*w4*
      z3 - 0.0002861013781231583*w5*z3 - 0.003384978503667747*lnbara*w5*
      z3 + 1.7392655054241464*y*z3 - 0.41431315409504377*u*y*z3 + 
     0.11216265014873544*u2*y*z3 - 0.02213965249299299*u3*y*z3 + 
     0.0021644635339529753*u4*y*z3 - 0.3131042491486924*v*y*z3 + 
     0.06473552238444277*u*v*y*z3 - 0.010750311705942078*u2*v*y*z3 + 
     0.0009392449858988379*u3*v*y*z3 + 0.07479560941667407*v2*y*z3 - 
     0.009593654231383138*u*v2*y*z3 + 0.0007107796438381393*u2*v2*y*z3 - 
     0.01387288739518578*v3*y*z3 + 0.0007917184813914537*u*v3*y*z3 + 
     0.0013099680497976988*v4*y*z3 - 0.43003699366991677*w*y*z3 + 
     0.10521916751093474*u*w*y*z3 - 0.019168242146174814*u2*w*y*z3 + 
     0.0017670251675018884*u3*w*y*z3 + 0.07024343329404853*v*w*y*z3 - 
     0.010504755263170868*u*v*w*y*z3 + 0.0008476691271990539*u2*v*w*y*z3 - 
     0.010725838861960173*v2*w*y*z3 + 0.0007141774155409824*u*v2*w*y*z3 + 
     0.0009016198300664359*v3*w*y*z3 + 0.11965941751579676*w2*y*z3 - 
     0.019654970033404773*u*w2*y*z3 + 0.001678200058612197*u2*w2*y*z3 - 
     0.012341284474452504*v*w2*y*z3 + 0.0008946786933220228*u*v*w2*y*z3 + 
     0.0008576480370907614*v2*w2*y*z3 - 0.024020753044566752*w3*y*z3 + 
     0.0018413777506809327*u*w3*y*z3 + 0.0011178896264369238*v*w3*y*z3 + 
     0.002373235870460425*w4*y*z3 - 0.47594273908018797*y2*z3 + 
     0.0800625198854355*u*y2*z3 - 0.012460388549811095*u2*y2*z3 + 
     0.0010588370339842305*u3*y2*z3 + 0.07479560941667407*v*y2*z3 - 
     0.009593654231383138*u*v*y2*z3 + 0.0007107796438381393*u2*v*y2*z3 - 
     0.011184878805680112*v2*y2*z3 + 0.0006855605604060971*u*v2*y2*z3 + 
     0.000929170356268885*v3*y2*z3 + 0.08499596758732683*w*y2*z3 - 
     0.011944092447949953*u*w*y2*z3 + 0.0009375065759672177*u2*w*y2*z3 - 
     0.010725838861960173*v*w*y2*z3 + 0.0007141774155409824*u*v*w*y2*z3 + 
     0.0007939134731674265*v2*w*y2*z3 - 0.013822219055141373*w2*y2*z3 + 
     0.0009765463601544392*u*w2*y2*z3 + 0.0008576480370907614*v*w2*y2*
      z3 + 0.0012080368273358105*w3*y2*z3 + 0.143917554575605*y3*z3 - 
     0.01387288739518578*u*y3*z3 + 0.000929170356268885*u2*y3*z3 - 
     0.01387288739518578*v*y3*z3 + 0.0007917184813914537*u*v*y3*z3 + 
     0.000929170356268885*v2*y3*z3 - 0.014908075298963635*w*y3*z3 + 
     0.0009016198300664359*u*w*y3*z3 + 0.0009016198300664359*v*w*y3*z3 + 
     0.0010537837376492188*w2*y3*z3 - 0.030647657382734356*y4*z3 + 
     0.001270334042999831*u*y4*z3 + 0.0013099680497976988*v*y4*z3 + 
     0.0013746585204415407*w*y4*z3 + 0.0031576827739003242*y5*z3 + 
     0.6458071724555728*z4 - 2.2637141792339346*lnbara*z4 + 
     0.625*lnbara2*z4 + 0.01753357928415362*u*z4 + 
     0.7330635157257923*lnbara*u*z4 + 0.010651424423197484*u2*z4 - 
     0.16767848269494548*lnbara*u2*z4 + 0.0015438790012948771*u3*z4 + 
     0.03161639028525199*lnbara*u3*z4 - 0.0005416818590033571*u4*z4 - 
     0.0030360036294498475*lnbara*u4*z4 - 1.211930536655639*v*z4 + 
     0.17213360808035297*u*v*z4 - 0.02576675296668821*u2*v*z4 + 
     0.0021644635339529753*u3*v*z4 + 0.18905536415607813*v2*z4 - 
     0.018011963451589594*u*v2*z4 + 0.0012120200398115979*u2*v2*z4 - 
     0.030647657382734356*v3*z4 + 0.0013099680497976988*u*v3*z4 + 
     0.002726070724998416*v4*z4 - 0.0009147194949975854*w*z4 + 
     0.7330635157257923*lnbara*w*z4 + 0.013780208167077434*u*w*z4 - 
     0.1565120644824315*lnbara*u*w*z4 + 0.0006279468944037123*u2*w*z4 + 
     0.027777777777777776*lnbara*u2*w*z4 - 0.0003861048986038681*u3*w*
      z4 - 0.0025474832491138625*lnbara*u3*w*z4 + 
     0.17633440249962998*v*w*z4 - 0.02459974262590988*u*v*w*z4 + 
     0.001947021061827816*u2*v*w*z4 - 0.01873833496439247*v2*w*z4 + 
     0.0011742374174915872*u*v2*w*z4 + 0.0013746585204415407*v3*w*z4 + 
     0.018724892062203655*w2*z4 - 0.16767848269494548*lnbara*w2*z4 + 
     0.00008455106800475184*u*w2*z4 + 0.027777777777777776*lnbara*u*w2*
      z4 - 0.00031988499677263827*u2*w2*z4 - 0.0024078266340730905*lnbara*
      u2*w2*z4 - 0.02690397081993831*v*w2*z4 + 
     0.0019816663126266698*u*v*w2*z4 + 0.0013006407407352707*v2*w2*z4 - 
     0.0004120997422309256*w3*z4 + 0.03161639028525199*lnbara*w3*z4 - 
     0.0003031307111613726*u*w3*z4 - 0.0025474832491138625*lnbara*u*w3*
      z4 + 0.002288117132733893*v*w3*z4 - 0.00032828045176791254*w4*z4 - 
     0.0030360036294498475*lnbara*w4*z4 - 1.211930536655639*y*z4 + 
     0.17213360808035297*u*y*z4 - 0.02576675296668821*u2*y*z4 + 
     0.0021644635339529753*u3*y*z4 + 0.1262878385252224*v*y*z4 - 
     0.014772762292074491*u*v*y*z4 + 0.0010604472614234883*u2*v*y*z4 - 
     0.01632082648577182*v2*y*z4 + 0.0009279102407948306*u*v2*y*z4 + 
     0.001270334042999831*v3*y*z4 + 0.17633440249962998*w*y*z4 - 
     0.02459974262590988*u*w*y*z4 + 0.001947021061827816*u2*w*y*z4 - 
     0.015599046732045124*v*w*y*z4 + 0.0010408374899911962*u*v*w*y*z4 + 
     0.0010009197339258765*v2*w*y*z4 - 0.02690397081993831*w2*y*z4 + 
     0.0019816663126266698*u*w2*y*z4 + 0.0011655861883641662*v*w2*y*z4 + 
     0.002288117132733893*w3*y*z4 + 0.18905536415607813*y2*z4 - 
     0.018011963451589594*u*y2*z4 + 0.0012120200398115979*u2*y2*z4 - 
     0.01632082648577182*v*y2*z4 + 0.0009279102407948306*u*v*y2*z4 + 
     0.0010325956586233194*v2*y2*z4 - 0.01873833496439247*w*y2*z4 + 
     0.0011742374174915872*u*w*y2*z4 + 0.0010009197339258765*v*w*y2*z4 + 
     0.0013006407407352707*w2*y2*z4 - 0.030647657382734356*y3*z4 + 
     0.0013099680497976988*u*y3*z4 + 0.001270334042999831*v*y3*z4 + 
     0.0013746585204415407*w*y3*z4 + 0.002726070724998416*y4*z4 - 
     0.035197295260033824*z5 + 1.5177459370968307*lnbara*z5 - 
     0.5*lnbara2*z5 - 0.08639020220532784*u*z5 - 
     0.3414643034610109*lnbara*u*z5 + 0.004994214637738621*u2*z5 + 
     0.04254600335127144*lnbara*u2*z5 - 0.0006639947469167062*u3*z5 - 
     0.003384978503667747*lnbara*u3*z5 + 0.5565850065099112*v*z5 - 
     0.04346745568123319*u*v*z5 + 0.0027683707923909567*u2*v*z5 - 
     0.04661932625243986*v2*z5 + 0.001911174312857377*u*v2*z5 + 
     0.0031576827739003242*v3*z5 - 0.08023092776115039*w*z5 - 
     0.3414643034610109*lnbara*w*z5 + 0.004042814598569594*u*w*z5 + 
     0.040382603570750374*lnbara*u*w*z5 - 0.0005447808657404928*u2*w*z5 - 
     0.0030639349524580017*lnbara*u2*w*z5 - 0.04423708081452867*v*w*z5 + 
     0.002670611110405308*u*v*w*z5 + 0.001967584154035969*v2*w*z5 + 
     0.0035019811348314675*w2*z5 + 0.04254600335127144*lnbara*w2*z5 - 
     0.0004997443132457395*u*w2*z5 - 0.0030639349524580017*lnbara*u*w2*
      z5 + 0.0028582170878550506*v*w2*z5 - 0.0005095764010007675*w3*z5 - 
     0.003384978503667747*lnbara*w3*z5 + 0.5565850065099112*y*z5 - 
     0.04346745568123319*u*y*z5 + 0.0027683707923909567*u2*y*z5 - 
     0.03138411241664758*v*y*z5 + 0.0015798778632113992*u*v*y*z5 + 
     0.0017031606129609958*v2*y*z5 - 0.04423708081452867*w*y*z5 + 
     0.002670611110405308*u*w*y*z5 + 0.0016446715859244178*v*w*y*z5 + 
     0.0028582170878550506*w2*y*z5 - 0.04661932625243986*y2*z5 + 
     0.001911174312857377*u*y2*z5 + 0.0017031606129609958*v*y2*z5 + 
     0.001967584154035969*w*y2*z5 + 0.0031576827739003242*y3*z5 - 
     0.14015949954554044*z6 - 0.6450515340614117*lnbara*z6 + 
     0.25*lnbara2*z6 + 0.04094734531651254*u*z6 + 
     0.09290899944145475*lnbara*u*z6 - 0.001332365186004987*u2*z6 - 
     0.004887855481301699*lnbara*u2*z6 - 0.15014045193375553*v*z6 + 
     0.00497631274951997*u*v*z6 + 0.005260726475147424*v2*z6 + 
     0.039648206713854266*w*z6 + 0.09290899944145475*lnbara*w*z6 - 
     0.0012158310769012908*u*w*z6 - 0.004687810626819727*lnbara*u*w*z6 + 
     0.005045032605736152*v*w*z6 - 0.0011983236323822545*w2*z6 - 
     0.004887855481301699*lnbara*w2*z6 - 0.15014045193375553*y*z6 + 
     0.00497631274951997*u*y*z6 + 0.003557820085944631*v*y*z6 + 
     0.005045032605736152*w*y*z6 + 0.005260726475147424*y2*z6 + 
     0.07142919298974644*z7 + 0.15775500989141628*lnbara*z7 - 
     0.07142857142857142*lnbara2*z7 - 0.006717058480948745*u*z7 - 
     0.011206496836004519*lnbara*u*z7 + 0.01800569050603713*v*z7 - 
     0.00658939908338011*w*z7 - 0.011206496836004519*lnbara*w*z7 + 
     0.01800569050603713*y*z7 - 0.011766764554686482*z8 - 
     0.016917752027425906*lnbara*z8 + 0.008928571428571428*lnbara2*z8;
 
  ttothei = 1.0L;
  result = Gexp[0];

  for (i=1; i<nTerms; i++) {
    ttothei *= tinit;
    result += Gexp[i]*ttothei;
  }
  foo->value = a * result;

  ttothei = 1.0L;
  result = Gexp[1];

  for (i=2; i<nTerms; i++) {
    ttothei *= tinit;
    result += i*Gexp[i]*ttothei;
  }
  foo->deriv = a * result;

  return 0;
}
