/* Analytic results for FBAR and F-type functions */

#include "internal.h"

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx0yy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX k, lnk, lnk2, result;
  TVIL_REAL lnbarx, lnbary, lnbary2;

  k = (1 - TVIL_CSQRT(1-4.L*y/x))/(1 + TVIL_CSQRT(1-4.L*y/x));

  /* This shouldn't be necessary, but just in case... */
  if (TVIL_CIMAG(k) > 0) k = TVIL_CONJ(k);

  lnk = TVIL_CLOG (k);
  lnk2 = lnk*lnk;
  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = 4*y*TVIL_Trilog(-k) + TVIL_CSQRT(x*(x-4*y))*(2*TVIL_Dilog(-k) 
      + 0.5L*lnk2 + PI2/6.) 
      + (y/3)*(lnk*lnk2 + PI2*lnk - lnbary*lnbary2 + 1 - 4*Zeta3 + 
    3*lnbarx*lnbary2 - 3*lnbary) + (y-x/2.)*lnbary2 + (x-4*y)*lnbarx*lnbary + 
    (5*y-11*x/4.)*lnbarx + 47.*x/12.;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fy0xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX k, lnk, lnk2, sqrt, result;
  TVIL_REAL lnbarx, lnbary, lnbary2;

  k = (1 - TVIL_CSQRT(1-4*y/x))/(1 + TVIL_CSQRT(1-4*y/x));

  /* This shouldn't be necessary, but just in case... */
  if (TVIL_CIMAG(k) > 0) k = TVIL_CONJ(k);

  lnk = TVIL_CLOG (k);
  lnk2 = lnk*lnk;
  sqrt = x * (1.L - k)/(1.L + k);

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbary2 = lnbary*lnbary;

  result = (x - 2*y)*(2*TVIL_Trilog(-k) + (1./6.)*lnk*lnk2 
   - (1./6.)*lnbary*lnbary2 + 
   (PI2/6)*lnk - (2./3.)*Zeta3) 
   + sqrt*(2*TVIL_Dilog(-k) + 0.5L*lnk2 + 
    PI2/6) + (x/2)*lnbarx*lnbary2 - x*lnbarx*lnbary - (y + x/2)*lnbary2 +
    - (x/2)*lnbarx + (5*x/2. - 3*y/4.)*lnbary + x/6. + 49.*y/12.;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fxxyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2, lnyox;

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary2 = lnbary*lnbary;
  lnyox = TVIL_LOG (y/x);

  result = 2*(x-y)*(TVIL_Trilog(1-x/y) + TVIL_Trilog(1-y/x) 
    + lnyox*TVIL_Dilog(1-x/y) +
    (1./3.)*lnbary*lnbary2 - lnbarx*lnbary2 - (1./6.)*lnbarx*lnbarx2 
    - (7./3.)*Zeta3) +
  (49*x + 4*y)/12 + ((-3*x + 20*y)*lnbarx)/4 - x*lnbarx2 - y*lnbary +
  - 4*y*lnbarx*lnbary + (2*x - y)*lnbarx2*lnbary + y*lnbary2;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx00y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2, lnyox;

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary2 = lnbary*lnbary;
  lnyox = lnbary - lnbarx;

  result = 2*y*TVIL_Trilog(1-x/y) + 2*y*TVIL_Trilog(1-y/x) + 
    (y*lnyox - x + y)*TVIL_Dilog(1-x/y) +
  (47*x + 2*y)/12 + ((-11*x + 10*y)*lnbarx)/4 - (y*lnbarx*lnbarx2)/3 
  - (y*lnbary)/2 + 
  (x - 2*y)*lnbarx*lnbary + y*lnbarx2*lnbary + ((-x + y)*lnbary2)/2 - 
  (y*lnbarx*lnbary2)/2 + (y*lnbary*lnbary2)/6 - (8*y*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx000 (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return (47*x)/12 + (PI2*x)/6 - (11*x*lnbarx)/4 + (x*lnbarx*lnbarx)/2;
} 

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx00x (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
 
  lnbarx2 = lnbarx*lnbarx;

  return (49*x)/12 - (3*x*lnbarx)/4 - x*lnbarx2 + (x*lnbarx*lnbarx2)/3 - 
    (8*x*Zeta3)/3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fx0xx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  lnbarx2 = lnbarx*lnbarx;

  return (17*x)/4 + (5*x*lnbarx)/4 -
    (5*x*lnbarx2)/2 + (2*x*lnbarx*lnbarx2)/3 - 3*TVIL_SQRT(3)*LS2*x;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_Fxxxx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  lnbarx2 = lnbarx*lnbarx;

  return (53*x)/12 + (13*x*lnbarx)/4 - 4*x*lnbarx2 + x*lnbarx*lnbarx2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARxxyy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return TVIL_Fxxyy (x, y, qq) + lnbarx*TVIL_I2(x, y, y, qq);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx0xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return TVIL_Fy0xy (y, x, qq) + lnbarx*TVIL_I2(0, x, y, qq);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx0yy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return TVIL_Fx0yy (x, y, qq) + lnbarx*TVIL_I2(0, y, y, qq);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx00y (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  return TVIL_Fx00y (x, y, qq) + lnbarx*TVIL_I2(0, 0, y, qq);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR00xy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_COMPLEX result;
  TVIL_REAL lnbarx, lnbarx2, lnbary, lnbary2;

  lnbarx = TVIL_LOG (x/qq);
  lnbary = TVIL_LOG (y/qq);
  lnbarx2 = lnbarx*lnbarx;
  lnbary2 = lnbary*lnbary;

  result = -2*x*TVIL_Trilog(1-y/x) - 2*y*TVIL_Trilog(1-x/y) +
    (x*lnbarx - x - y*lnbary + y)*TVIL_Dilog(1-x/y) +
    (x + y)/6 - (x*lnbarx)/2 + (x*lnbarx*lnbarx2)/3 - (y*lnbary)/2 + x*lnbarx*lnbary +
    - x*lnbarx2*lnbary + ((-x + y)*lnbary2)/2 + (x*lnbarx*lnbary2)/2 +
    - (y*lnbary*lnbary2)/6 + (4*(x + y)*Zeta3)/3;

  return result;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR0xxy (TVIL_REAL x, TVIL_REAL y, TVIL_REAL qq)
{
  TVIL_REAL r, rn;
  TVIL_COMPLEX lnbarx, lnbary, lnbarx2, lnbary2, lnyox;
  TVIL_COMPLEX result;
  int n;

  TVIL_REAL Fbar0xxytableA[] = 
     {0, 0, -7.037037037037037, 1.7327407407407407, 1.9337073750134974, 
     1.6596918179382276, 1.3978865512096648, 1.1894023285507445, 
     1.0264758824059403, 0.897854589350033, 0.7946651108145208, 
     0.710510968151481, 0.6408356611657425, 0.5823633669545625, 
     0.5327021270694172, 0.49007550685022, 0.45314213945320814, 
     0.420873282041491, 0.39246854511459206, 0.3672969657560077, 
     0.34485513826423037, 0.3247370016952336, 0.30661171823851513, 
     0.29020725281135085, 0.2752980283857671, 0.2616955349427729, 
     0.24924110640055255, 0.2378003079844564, 0.22725853333199988, 
     0.21751751987341075, 0.2084925680938096, 0.20011030529692037, 
     0.1923068742055669, 0.18502645571070864, 0.17822005643452615, 
     0.1718445076585136, 0.16586163409076304, 0.16023755997157546, 
     0.15494212690234874, 0.14994840307617138, 0.1452322676871227, 
     0.14077205749027663, 0.13654826499113282, 0.13254327972201538, 
     0.12874116563420335, 0.12512746888909612, 0.12168905133873012, 
     0.11841394579838511, 0.11529122987263861, 0.11231091563263074, 
     0.10946385288111506, 0.10674164410237251, 0.1041365694914414, 
     0.10164152070338055, 0.09924994216798709, 0.09695577898616416, 
     0.09475343056709616, 0.09263770928547055, 0.09060380353917329, 
     0.08864724467341618, 0.08676387730976927, 0.08494983268022856, 
     0.08320150461902061, 0.08151552790979084, 0.07988875872434871, 
     0.07831825692225045, 0.07680127000901957, 0.07533521857543193, 
     0.0739176830616056, 0.0725463917081219, 0.0712192095724745, 
     0.06993412850314065, 0.06868925797578662, 0.06748281670680531, 
     0.06631312496874588, 0.06517859754041559, 0.06407773723166159, 
     0.06300912892920964, 0.061971434115556376, 0.06096338581787975, 
     0.059983783948331725, 0.0590314910009776, 0.05810542807411153, 
     0.05720457118975968, 0.05632794788492786, 0.055474634051599775, 
     0.05464375100468, 0.0538344627590329, 0.05304597349852208, 
     0.05227752522152706, 0.05152839554882622, 0.05079789568100448, 
     0.050085368493687235, 0.04939018675993217, 0.04871175149004014, 
     0.04804949037988574, 0.04740285635962818, 0.04677132623534958, 
     0.0461543994167918, 0.04555159672492749, 0.04496245927361466};
 
  TVIL_REAL Fbar0xxytableALx[] = 
     {0, 0, -7.555555555555555, -0.8533333333333334, 
     0.1291609977324263, 0.35926429831191736, 0.4099420092493686, 
     0.40668765011089353, 0.3861874837832214, 0.36095030752857354, 
     0.3355622636742313, 0.31169472316394137, 0.28987056108877113, 
     0.2701478715517435, 0.2524016816883294, 0.23644428588260602, 
     0.22207702755200412, 0.20911182592735142, 0.19737908051539305, 
     0.18672945552436918, 0.17703301386893588, 0.16817732302673874, 
     0.16006528572513998, 0.1526130323846955, 0.14574801203590226, 
     0.13940732305744027, 0.13353628124026343, 0.12808720420735498, 
     0.12301838508987253, 0.11829322803884124, 0.11387952035706159, 
     0.10974881914299874, 0.10587593356710204, 0.10223848690229793, 
     0.09881654507226885, 0.09559230073747572, 0.09254980383216209, 
     0.08967473103753072, 0.08695418797342591, 0.08437653895765672, 
     0.08193126005819797, 0.07960881188288361, 0.07740052914234488, 
     0.07529852450837324, 0.07329560469089143, 0.07138519698800377, 
     0.06956128483794054, 0.06781835112946753, 0.06615132821690886, 
     0.06455555374414687, 0.06302673151436353, 0.06156089675338424, 
     0.060154385207954825, 0.058803805599133445, 0.05750601501767243, 
     0.05625809690482053, 0.05505734131005821, 0.05390122715825818, 
     0.05278740629377559, 0.051713689098957044, 0.05067803151029828, 
     0.04967852327762612, 0.04871337733077835, 0.04778092013475824, 
     0.04687958292863389, 0.046007893755856, 0.0451644702044537, 
     0.044348012784966855, 0.04355729888217683, 0.04279117722387427, 
     0.04204856281618964, 0.04132843230053173, 0.04062981969203296, 
     0.03995181246367466, 0.0392935479440377, 0.03865420999995688, 
     0.03803302597830774, 0.03742926388376967, 0.03684222977173164, 
     0.036271265337570704, 0.0357157456853726, 0.0351750772608022, 
     0.03464869593429555, 0.03413606522205385, 0.03363667463349099, 
     0.033150038134836635, 0.03267569271953954, 0.03221319707696229, 
     0.03176213035162164, 0.031322090985914035, 0.030892695639886007, 
     0.03047357818216721, 0.03006438874668963, 0.029664792850273236, 
     0.02927447056657243, 0.028893115752253035, 0.02852043532161032, 
     0.028156148566147905, 0.027799986515919025, 0.02745169133968777, 
     0.02711101578120148};
 
  TVIL_REAL Fbar0xxytableALy[] = 
     {0, 0, 0.4444444444444444, -1.3511111111111112, 
     -1.2582312925170067, -1.0668279163517258, -0.9043841840378637, 
     -0.7765357125330485, -0.6760038476588593, -0.5958469134497719, 
     -0.5308806932854904, -0.4773945823001134, -0.43273126196223843, 
     -0.3949628543161166, -0.3626674843343662, -0.33477867974403835, 
     -0.3104835876503626, -0.2891533538202688, -0.2702947701199098, 
     -0.253516150423707, -0.2385028657027399, -0.22499953869728348, 
     -0.21279690114971142, -0.20172196404387147, -0.19163057514050824, 
     -0.18240171957803264, -0.1739331089643999, -0.1661377339881321, 
     -0.15894114534829926, -0.15227929079270905, -0.1460967807941808, 
     -0.14034548754252582, -0.13498340528221167, -0.12997371716424086, 
     -0.1252840264814824, -0.12088571965521318, -0.11675343550597257, 
     -0.11286462079146403, -0.1091991561711446, -0.10573903998209454, 
     -0.10246811971807039, -0.09937186306590376, -0.09643716189875527, 
     -0.09365216385002256, -0.09100612706715855, -0.08848929452607104, 
     -0.08609278491599126, -0.0838084976138613, -0.08162902968125973, 
     -0.07954760315497363, -0.07755800117964376, -0.07565451175932364, 
     -0.07383187809367568, -0.0720852546213195, -0.07041016802347723, 
     -0.06880248255027967, -0.06725836912372403, -0.06577427774839495, 
     -0.06434691282617674, -0.06297321102633069, -0.06165032140915359, 
     -0.06037558754133183, -0.05914653137518477, -0.0579608386931758, 
     -0.056816345944126656, -0.05571102831913768, -0.05464298893382408, 
     -0.05361044899956852, -0.052611738880437776, -0.05164528994452347, 
     -0.050709627129012814, -0.0498033621474909, -0.04892518727601503, 
     -0.048073869661539696, -0.04724824610244549, -0.046447218256352965, 
     -0.04566974823518066, -0.044914854551620934, -0.04418160838493127, 
     -0.04346913013723352, -0.04277658625443401, -0.04210318628847046, 
     -0.04144818017989622, -0.0408108557418652, -0.040190536328410374, 
     -0.03958657867154315, -0.03899837087316186, -0.038425330539065605, 
     -0.03786690304354272, -0.03732255991405555, -0.03679179732648974, 
     -0.03627413470228721, -0.03576911339954956, -0.0352762954908901, 
     -0.03479526262143766, -0.03432561494096026, -0.03386697010458763, 
     -0.033418962337074885, -0.03298124155596945, -0.032553472549424776, 
     -0.0321353342047507};
 
  TVIL_REAL Fbar0xxytableAL2[] = 
     {0, 0, 2.6666666666666665, 1.0666666666666667, 
     0.6095238095238096, 0.40634920634920635, 0.2955266955266955, 
     0.22732822732822733, 0.18186258186258186, 0.14976918506330272, 
     0.12612141900067597, 0.10810407342915083, 0.09400354211230506, 
     0.08272311705882845, 0.07353165960784752, 0.06592493620013916, 
     0.059545103664641816, 0.05413191242240165, 0.04949203421476723, 
     0.04547916657573205, 0.04198076914682958, 0.0389090055507201, 
     0.036194423768111716, 0.03378146218357094, 0.03162519863993875, 
     0.02968896198851393, 0.027942552459777815, 0.026360898546960203, 
     0.024923031353489646, 0.023611292861200717, 0.022410718647919325, 
     0.021308552157038047, 0.020293859197179093, 0.019357219541924674, 
     0.018490478368405658, 0.017686544526301064, 0.01693922574349961, 
     0.016243093178698258, 0.015593369451550326, 0.0149858355768146, 
     0.014416753213138097, 0.013882799390429279, 0.013381011460654724, 
     0.012908740467925735, 0.012463611486273124, 0.012043489750780772, 
     0.011646451627128658, 0.011270759639156766, 0.01091484091370971, 
     0.010577268514316625, 0.010256745226004001, 0.009952089427211803, 
     0.009662222744865829, 0.009386159237869661, 0.009122995894751821, 
     0.008871904264621037, 0.008632123068279927, 0.00840295165938754, 
     0.008183744224794821, 0.007973904629287262, 0.007772881823506911, 
     0.007580165745238144, 0.007395283653890872, 0.007217796846197491, 
     0.007047297708098339, 0.006883407063723958, 0.006725771787455471, 
     0.006574062649392565, 0.006427972368294952, 0.006287213849281194, 
     0.006151518586347068, 0.006020635212169471, 0.005894328179746336, 
     0.0057723765622343425, 0.005654572958923437, 0.005540722496663234, 
     0.005430641917259328, 0.005324158742411106, 0.005221110508687021, 
     0.005121344065845867, 0.0050247149325280205, 0.0049310867039715975, 
     0.004840330506965986, 0.004752324497748422, 0.004666953398986475, 
     0.004584108072377247, 0.00450368512373905, 0.004425586537778257, 
     0.0043497193399877725, 0.00427599528337781, 0.00420433055795807, 
     0.004134645521085838, 0.0040668644469696764, 0.004000915293775573, 
     0.003936729486923559, 0.0038742417172898513, 0.0038133897531439373, 
     0.003754114264753099, 0.0036963586606799746, 0.0036400689348828176, 
     0.0035851935238041823};
 
  TVIL_REAL Fbar0xxytableC[] = 
     {0, 0, -0.016969290922157987, -0.1071041892356652, 
     -0.091549467875236, -0.0778124515340627, -0.06712924599891806, 
     -0.05871867000670852, -0.05197016217862003, -0.04646005194719721, 
     -0.04189177452558616, -0.038053386192670687, -0.0347902371828175, 
     -0.03198729927513923, -0.029557512652350064, -0.02743393969485649, 
     -0.02556437525099403, -0.023907574503936525, -0.022430566887997487, 
     -0.021106712568224863, -0.01991427532388426, -0.018835360272001403, 
     -0.017855113160271684, -0.01696110976385888, -0.0161428852081664, 
     -0.01539156750572108, -0.014699589567034918, -0.014060460911684482, 
     -0.013468585234225332, -0.012919113507568799, -0.012407824860184843, 
     -0.011931029331409652, -0.011485487988910633, -0.011068346921052703, 
     -0.01067708239058807, -0.010309455022805962, -0.00996347134970239, 
     -0.009637351377006225, -0.009329501108627148, -0.00903848917207779, 
     -0.00876302685259318, -0.008501950973414829, -0.00825420916283496, 
     -0.00801884713101771, -0.007794997645832191, -0.007581870950397677, 
     -0.00737874640841743, -0.007184965198728731, -0.006999923909434368, 
     -0.006823068905767813, -0.0066538913654763466, -0.00649192289177194, 
     -0.006336731627426206, -0.00618791880487457, -0.006045115676648845, 
     -0.005907980778400601, -0.005776197483473531, -0.0056494718136440615, 
     -0.005527530475450174, -0.00541011909561143, -0.005297000632524867, 
     -0.005187953943798879, -0.005082772492339647, -0.004981263175698485, 
     -0.004883245265278389, -0.004788549443630384, -0.00469701692948282, 
     -0.004608498681372305, -0.004522854671810168, -0.004439953224846392, 
     -0.004359670410702946, -0.004281889491856777, -0.0042065004155736555, 
     -0.004133399348438785, -0.004062488248909519, -0.003993674474337636, 
     -0.00392687041928123, -0.0038619931822556786, -0.0037989642583647213, 
     -0.003737709255511305, -0.0036781576321174656, -0.0036202424544868987, 
     -0.0035639001721257204, -0.0035090704094993415, -0.0034556957728482936, 
     -0.0034037216708156168, -0.0033530961477545103, -0.0033037697286891834, 
     -0.003255695274995372, -0.003208827849951053, -0.0031631245933836723, 
     -0.0031185446047083346, -0.0030750488337130785, -0.003032599978502793, 
     -0.0029911623900638067, -0.002950701982956525, -0.002911186151684834, 
     -0.002872583692328358, -0.002834864729057652, -0.002798000645183259, 
     -0.0027619640184176923};
 
  TVIL_REAL Fbar0xxytableCLx[] = 
     {0, 0, -0.34873351671205655, -0.19520009168936162, 
     -0.15455214063918435, -0.12830368594742905, -0.10896647973834955, 
     -0.094140321567731, -0.08247772873138623, -0.07311049206018763, 
     -0.06545181133815298, -0.059093051022286694, -0.053742538620351665, 
     -0.0491874836939689, -0.04526956355297516, -0.04186887850629249, 
     -0.03889316804992415, -0.03627041111800133, -0.033943650223626755, 
     -0.03186730661479441, -0.0300045139241542, -0.028325159718034284, 
     -0.026804427052181924, -0.02542169450337586, -0.02415969678630207, 
     -0.0230038772418792, -0.021941883295182363, -0.020963169631152124, 
     -0.020058683369882646, -0.019220612267385265, -0.018442181795949555, 
     -0.01771749045386129, -0.017041375211904082, -0.016409300894095515, 
     -0.015817268699864672, -0.015261740135698466, -0.014739573429192448, 
     -0.014247970113987048, -0.013784429948311396, -0.013346712697812292, 
     -0.01293280560074878, -0.01254089555954556, -0.01216934528135142, 
     -0.011816672732341507, -0.011481533384136966, -0.011162704822066681, 
     -0.010859073358800844, -0.01056962235679925, -0.010293422011876, 
     -0.010029620390200281, -0.009777435543967379, -0.009536148558154895, 
     -0.009305097403311553, -0.009083671488074485, -0.008871306820766412, 
     -0.008667481702541696, -0.00847171288557796, -0.008283552139109755, 
     -0.008102583173967993, -0.007928418882963487, -0.007760698860132226, 
     -0.0075990871667055305, -0.007443270315813568, -0.007292955451486093, 
     -0.007147868700571315, -0.007007753678828757, -0.006872370134728253, 
     -0.006741492716458449, -0.006614909849358573, -0.00649242271247485, 
     -0.00637384430423923, -0.006258998588400008, -0.006147719712324293, 
     -0.006039851290660379, -0.0059352457481103675, -0.005833763715734117, 
     -0.005735273475796636, -0.005639650450692808, -0.005546776731944716, 
     -0.0054565406456754915, -0.00536883635132604, -0.005283563470703069, 
     -0.005200626744733334, -0.0051199357155543345, -0.005041404431799467, 
     -0.004964951175139212, -0.004890498206322026, -0.004817971529121774, 
     -0.004747300670744895, -0.004678418477381974, -0.004611260923706586, 
     -0.004545766935230742, -0.004481878222522205, -0.004419539126375532, 
     -0.004358696473106953, -0.004299299439213927, -0.004241299424704291, 
     -0.004184649934458014, -0.004129306467037189, -0.0040752264104078565, 
     -0.004022368944080618};
 
  TVIL_REAL Fbar0xxytableCLy[] = 
     {0, 0, 0.3981002750680849, 0.223355693089598, 
     0.1755673602643321, 0.14485027718503246, 0.12240452646516323, 
     0.10531511736966623, 0.09194946931895889, 0.08126576503526918, 
     0.07256620356173257, 0.0653685120710643, 0.05933061727378977, 
     0.05420428021111144, 0.049805642431278906, 0.045996016379548726, 
     0.04266905678157087, 0.03974200560899767, 0.03714959704261386, 
     0.03483973613244347, 0.03277038331906701, 0.030907273596028288, 
     0.029222223017881716, 0.027691854901294725, 0.02629663019343985, 
     0.025020101186949896, 0.02384833123843466, 0.0227694392686874, 
     0.02177323904769387, 0.020850951185879287, 0.01999497140727135, 
     0.019198682764162492, 0.018456302434315987, 0.017762755940396013, 
     0.017113573268073896, 0.01650480258866875, 0.015932938223407325, 
     0.015394860197381035, 0.014887783278217173, 0.014409213818224742, 
     0.013956913049295576, 0.013528865739304431, 0.01312325332367836, 
     0.012738430788599724, 0.012372906712347087, 0.012025325975702855, 
     0.01169445473663413, 0.011379167332798576, 0.011078434831107391, 
     0.01079131498913996, 0.010516943430645204, 0.010254525868256025, 
     0.010003331232129882, 0.009762685584500948, 0.009531966717878149, 
     0.009310599349483684, 0.0090980508370099, 0.0088938273512923, 
     0.008697470450389374, 0.008508554007099893, 0.008326681448359375, 
     0.008151483270423966, 0.00798261479842357, 0.007819754162872117, 
     0.007662600469165355, 0.007510872139061941, 0.007364305405704126, 
     0.0072226529459501684, 0.007085682635712475, 0.006953176415666009, 
     0.006824929256146433, 0.00670074821132741, 0.006580451553876859, 
     0.006463867982264959, 0.006350835893750685, 0.006241202716824623, 
     0.006134824297547362, 0.006031564334806488, 0.005931293860031102, 
     0.00583389075735964, 0.005739239320661673, 0.005647229844174078, 
     0.0055577582438318795, 0.005470725706658881, 0.0053860383658374325, 
     0.0053036069993035884, 0.005223346749916945, 0.005145176865436269, 
     0.0050690204566950494, 0.0049948042725175106, 0.004922458490047201, 
     0.004851916519278761, 0.004783114820690155, 0.004715992734969001, 
     0.004650492323913571, 0.00458655822166768, 0.004524137495519867, 
     0.0044631795155617585, 0.0044036358325590195, 0.004345460063441389, 
     0.004288607783866624};
 
  TVIL_REAL Fbar0xxytableCLx2[] = 
     {0, 0, -0.0625, -0.078125, -0.06510416666666667, 
     -0.053548177083333336, -0.044775390625, -0.038134765625, 
     -0.033010646275111605, -0.028970037187848772, -0.0257193232339526, 
     -0.023057532688928028, -0.020844271026476464, -0.01897924819377938, 
     -0.017389269841952545, -0.016019852150912648, -0.01482970745482535, 
     -0.013787040127735, -0.012867006660465493, -0.012049939957523884, 
     -0.011320085427943228, -0.010664686369091505, -0.010073311987896821, 
     -0.0095373567567299, -0.00904966260408374, -0.00860423041355491, 
     -0.008195997304123882, -0.007820662949206697, -0.007474552863856036, 
     -0.00715450985155927, -0.006857807109476927, -0.006582078142995986, 
     -0.006325259836790156, -0.006085545905167072, -0.005861348591765891, 
     -0.005651266971696096, -0.005454060572865488, -0.0052686273093263325, 
     -0.005093984930721501, -0.004929255354768495, -0.004773651376154545, 
     -0.004626465344034205, -0.004487059478046047, -0.004354857554269565, 
     -0.00422933774149248, -0.004110026407328888, -0.003996492745237672, 
     -0.0038883440989630627, -0.0037852218816100307, -0.00368679800345042, 
     -0.003592771736392319, -0.0035028669544322623, -0.00341682969881866, 
     -0.003334426024459108, -0.003255440090601347, -0.003179672464245924, 
     -0.003106938609299322, -0.003037067538303931, -0.002969900606810857, 
     -0.00290529043319495, -0.002843099929031633, -0.002783201427130262, 
     -0.0027254758960046995, -0.0026698122310047675, -0.002616106613570449, 
     -0.0025642619311357874, -0.0025141872511278574, -0.0024657973432999675, 
     -0.002419012245325848, -0.0023737568671785324, -0.002329960630336954, 
     -0.002287557138316057, -0.0022464838754116564, -0.002206681930897469, 
     -0.0021680957462152243, -0.0021306728829654144, -0.002094363809740911, 
     -0.0020591217060525295, -0.0020249022817783184, -0.0019916636107299456, 
     -0.0019593659770726904, -0.0019279717334626076, -0.0018974451698773025, 
     -0.0018677523922172356, -0.001838861209844012, -0.001810741031302061, 
     -0.001783362767541518, -0.0017566987420240814, -0.001730722607150891, 
     -0.0017054092665028972, -0.001680734802430372, -0.0016566764085697578, 
     -0.0016332123269034743, -0.0016103217890120294, -0.0015879849611982442, 
     -0.0015661828931909146, -0.0015448974701601293, -0.0015241113677990196, 
     -0.0015038080102471464, -0.0014839715306492873, -0.0014645867341602397};
 
  TVIL_REAL Fbar0xxytableCLxLy[] = 
     {0, 0, 0.1875, 0.20833333333333334, 0.16861979166666666, 
     0.136328125, 0.11261393229166666, 0.09501836867559524, 
     0.08163237798781622, 0.07119175744435144, 0.06286622758895632, 
     0.05609930108635973, 0.05050817493236426, 0.045822679058655155, 
     0.04184757452303078, 0.03843873589920811, 0.035487725962901395, 
     0.032911560302307304, 0.030645759727439725, 0.028639534818498718, 
     0.026852383937588938, 0.02525164758281112, 0.023810722073903393, 
     0.02250773572198117, 0.02132455459855659, 0.020246026658469463, 
     0.019259400569279567, 0.018353874198926458, 0.01752024044419551, 
     0.016750606923083996, 0.01603817227634532, 0.015377046258039064, 
     0.014762103992633148, 0.014188867107445425, 0.013653406166295592, 
     0.01315226010720508, 0.012682369345283084, 0.012241019927255382, 
     0.011825796677506783, 0.011434543700981941, 0.011065330937761447, 
     0.010716425721005614, 0.010386268491531975, 0.010073451981443653, 
     0.009776703305618346, 0.009494868500803699, 0.009226899133099787, 
     0.008971840659996812, 0.008728822286152647, 0.008497048095280174, 
     0.008275789275847097, 0.00806437728732179, 0.007862197837648546, 
     0.007668685562470895, 0.007483319313110826, 0.007305617974068597, 
     0.007135136742324973, 0.006971463810401845, 0.0068142174032894106, 
     0.006663043126239041, 0.006517611586263229, 0.006377616255151393, 
     0.0062427715460455935, 0.00611281107924113, 0.005987486115980449, 
     0.005866564141675724, 0.005749827582292632, 0.005637072639611307, 
     0.005528108232796908, 0.005422755035200883, 0.005320844596608006, 
     0.005222218542271152, 0.005126727841059409, 0.005034232135905145, 
     0.004944599130489251, 0.0048577040267651144, 0.00477342900850356, 
     0.00469166276655327, 0.004612300061963278, 0.004535241323513657, 
     0.004460392276554276, 0.004387663600365106, 0.004316970611530048, 
     0.004248232971063999, 0.004181374413253451, 0.004116322494367692, 
     0.004053008359573471, 0.003991366526543111, 0.003931334684386882, 
     0.0038728535066666543, 0.003815866477361194, 0.003760319728755351, 
     0.003706161890317096, 0.0036533439477089923, 0.003601819111155243, 
     0.003551542692452776, 0.003502471989975704, 0.0034545661810776187, 
     0.0034077862213460607, 0.0033620947502088546, 0.0033174560024330406};
 
  TVIL_REAL Fbar0xxytableCLy2[] = 
      {0, 0, -0.125, -0.13020833333333334, -0.103515625, 
     -0.08277994791666667, -0.06783854166666667, -0.05688360305059524, 
     -0.04862173171270461, -0.042221720256502664, -0.03714690435500372, 
     -0.0330417683974317, -0.029663903905887797, -0.02684343086487578, 
     -0.024458304681078232, -0.022418883748295464, -0.020658018508076043, 
     -0.019124520174572304, -0.01777875306697423, -0.016589594860974836, 
     -0.015532298509645708, -0.014586961213719614, -0.01373741008600657, 
     -0.01297037896525127, -0.012274891994472851, -0.011641796244914553, 
     -0.011063403265155683, -0.010533211249719763, -0.010045687580339472, 
     -0.009596097071524727, -0.009180365166868393, -0.008794968115043078, 
     -0.008436844155842992, -0.008103321202278352, -0.0077920575745297005, 
     -0.007500993135508984, -0.007228308772417596, -0.00697239261792905, 
     -0.00673181174678528, -0.006505288346213444, -0.006291679561606901, 
     -0.00608996037697141, -0.005899209013485929, -0.0057185944271740865, 
     -0.005547365564125866, -0.00538484209347481, -0.005230406387862116, 
     -0.005083496561033748, -0.004943600404542617, -0.004810250091829755, 
     -0.004683017539454778, -0.004561510332889527, -0.004445368138829885, 
     -0.004334259538011788, -0.004227879222509479, -0.004125945509822673, 
     -0.00402819813302565, -0.003934396272097914, -0.003844316796478554, 
     -0.00375775269304409, -0.003674511657231597, -0.003594414828021131, 
     -0.0035172956500408945, -0.0034429988482363627, -0.0033713795024100006, 
     -0.003302302210539937, -0.0032356403311647746, -0.0031712752963113404, 
     -0.003109095987471059, -0.0030489981680223506, -0.0029908839662710516, 
     -0.0029346614039550954, -0.0028802439656477525, -0.0028275502050076765, 
     -0.0027765033842740276, -0.0027270311437997, -0.002679065198762648, 
     -0.0026325410605007415, -0.00258739778018496, -0.00254357771278371, 
     -0.002501026299481585, -0.0024596918669024977, -0.0024195254416527453, 
     -0.0023804805788467643, -0.002342513203409439, -0.0023055814630656315, 
     -0.002269645592031954, -0.0022346677845190297, -0.002200612077235991, 
     -0.002167444240163757, -0.002135131674930822, -0.002103643320185593, 
     -0.0020729495634136215, -0.002043022158696963, -0.0020138341499569986, 
     -0.001985359799261861, -0.0019575745198155753, -0.0019304548132785988, 
     -0.0019039782110989148, -0.0018781232195595673, -0.0018528692682728014};
 
  TVIL_REAL Fbar0xxytableCL3[] = 
     {0, 0, 0.0625, 0.03125, 0.01953125, 0.013671875, 0.01025390625, 
     0.008056640625, 0.0065460205078125, 0.00545501708984375, 
     0.0046367645263671875, 0.004004478454589844, 0.0035039186477661133, 
     0.0030996203422546387, 0.002767518162727356, 0.0024907663464546204, 
     0.0022572570014744997, 0.002058087266050279, 0.0018865799938794225, 
     0.0017376394680468366, 0.0016073165079433238, 0.0014925081859473721, 
     0.001390746264178233, 0.0013000454208622614, 0.00121879258205837, 
     0.0011456650271348678, 0.001079568967877087, 0.0010195929141061377, 
     0.0009649718651361661, 0.0009150595272842954, 0.0008693065509200806, 
     0.0008272433307142703, 0.0007884662995870388, 0.0007526269223330826, 
     0.000719422793406623, 0.0006885903879749107, 0.0006598991218092894, 
     0.0006331464547089128, 0.0006081538314967189, 0.0005847632995160758, 
     0.000562834675784223, 0.0005422431632555319, 0.0005228773359964058, 
     0.0005046374289267636, 0.00048743388021335127, 0.00047118608420623954, 
     0.0004558213205908187, 0.00044127383163579257, 0.00042748402439717406, 
     0.0004143977787523626, 0.0004019658453897917, 0.0003901433205253861, 
     0.0003788891862794615, 0.0003681659074224956, 0.0003579390766607596, 
     0.0003481771018427389, 0.00033885092947195125, 0.00032993379974900517, 
     0.0003214010290658412, 0.0003132298164624724, 0.0003053990710509106, 
     0.0002978892578283472, 0.00029068225965508075, 0.0002837612534728169, 
     0.00027711059909454774, 0.0002707157391154428, 0.00026456310868100093, 
     0.0002586400540090382, 0.0002529347587000153, 0.0002474361769891454, 
     0.00024213397319652088, 0.00023701846672053806, 0.0002320805819971935, 
     0.0002273118029150594, 0.00022270413123434872, 0.00021825004860966175, 
     0.00021394248186078685, 0.0002097747711751871, 0.00020574064096027966, 
     0.00020183417309394523, 0.00019804978234843376, 0.00019438219378642573, 
     0.00019082642194886916, 0.00018737775167268478, 0.00018403172039281542, 
     0.00018078410179764808, 0.00017763089071978213, 0.00017456828915564794, 
     0.0001715926933177676, 0.00016870068163263668, 0.00016588900360542605, 
     0.0001631545694800619, 0.0001604944406298435, 0.00015790582061968474, 
     0.00015538604688639188, 0.00015293258298818569, 0.0001505430113789953, 
     0.00014821502666694897, 0.00014594642932000588, 0.00014373511978485427, 
     0.00014157909298808148};
 
  TVIL_REAL Fbar0xxytableB[] = 
     {0, 0, -6.666327987697243, 1.3780980721093787, 
     -0.5962190418585888, 0.3360537734035998, -0.2167957009720997, 
     0.15185666722133911, -0.11245888672944566, 0.08670719018544441, 
     -0.06892895168980347, 0.05612973261090299, -0.046603702017221665, 
     0.039319607375414865, -0.03362352336198361, 0.02908419045961301, 
     -0.02540768897449584, 0.0223880204955734, -0.01987728714162622, 
     0.01776705325140905, -0.01597633607172145, 0.014443658691766578, 
     -0.013121665851344121, 0.011973398868764801, -0.010969669589587436, 
     0.010087177508406748, -0.009307138878548421, 0.008614274551860516, 
     -0.007996053069456558, 0.007442117954516633, -0.006943849670014726, 
     0.006494027211241769, -0.006086564236212801, 0.005716301534882823, 
     -0.0053788424910013325, 0.005070421646320982, -0.004787798965902231, 
     0.00452817421497528, -0.004289117189666525, 0.004068510532119721, 
     -0.0038645026002406286, 0.003675468420551335, -0.003499977177254409, 
     0.003336765015956863, -0.003184712191538369, 0.003042823784627837, 
     -0.0029102133635476876, 0.0027860890884103978, -0.0026697418488056453, 
     0.002560535101851763, -0.0024578961375926857, 0.002361308547077722, 
     -0.0022703057074830555, 0.0021844651302661685, -0.0021034035440978664, 
     0.002026772605371725, -0.0019542551463732918, 0.0018855618854324197, 
     -0.0018204285351594253, 0.0017586132546417294, -0.0016998943996184494, 
     0.0016440685314535973, -0.0015909486514307648, 0.001540362631687216, 
     -0.0014921518181488355, 0.0014461697842473, -0.0014022812171013111, 
     0.0013603609203101594, -0.0013202929196107058, 0.0012819696594462823, 
     -0.0012452912800359475, 0.0012101649658552963, -0.001176504357578266, 
     0.0011442290205118683, -0.0011132639634048238, 0.0010835392022467325, 
     -0.0010549893643133697, 0.001027553328269081, -0.0010011738966216337, 
     0.0009757974972476034, -0.0009513739110763393, 0.0009278560233446421, 
     -0.0009051995961187448, 0.0008833630600304899, -0.0008623073233948786, 
     0.0008419955970705108, -0.0008223932335962943, 0.0008034675792896116, 
     -0.0007851878381259452, 0.0007675249463394039, -0.0007504514567897747, 
     0.0007339414322363671, -0.0007179703467430101, 0.0007025149945138273, 
     -0.0006875534055265158, 0.0006730647673899741, -0.000659029352906861, 
     0.0006454284528700405, -0.0006322443136650321, 0.0006194600792897019, 
     -0.0006070597374373047};
 
  TVIL_REAL Fbar0xxytableBL[] = 
     {0, 0, -4.363451629653041, 1.07871398519455, -0.4735508486826, 
     0.26384871393654813, -0.16764754952961072, 0.11577284029750277, 
     -0.0846817643014943, 0.0646025360540784, -0.050893363694662505, 
     0.04112168066565108, -0.033913450908207785, 0.02844523540062145, 
     -0.024199319270773536, 0.020837030211437492, -0.018129299177150913, 
     0.01591671285861016, -0.014085569776985125, 0.012553013189204583, 
     -0.011257512249624138, 0.010152601059282427, -0.009202661208876436, 
     0.008380019817704752, -0.007662914300228969, 0.007034040221510426, 
     -0.006479498891235554, 0.0059880237349451155, -0.005550404147493448, 
     0.005159051258895086, -0.004807667032182737, 0.004490989521910908, 
     -0.00420459490224661, 0.003944742255355942, -0.003708250882919619, 
     0.003492402580193135, -0.0032948632331282583, 0.0031136194927777368, 
     -0.002946927302498164, 0.002793269808944881, -0.0026513227516790534, 
     0.0025199258505309227, -0.0023980590317306816, 0.002284822579796895, 
     -0.0021794204914887157, 0.0020811464548146814, -0.001989371990473037, 
     0.001903536382832938, -0.0018231380983705931, 0.0017477274456511784, 
     -0.0016769002757527317, 0.0016102925579435535, -0.0015475756943527878, 
     0.001488452460780651, -0.0014326534798185294, 0.0013799341479752147, 
     -0.001330071951229023, 0.0012828641138926573, -0.0012381255343211217, 
     0.0011956869681561694, -0.0011553934257576889, 0.0011171027554431473, 
     -0.0010806843883170419, 0.0010460182239662667, -0.0010129936392400916, 
     0.000981508604819093, -0.0009514688963829596, 0.0009227873889754157, 
     -0.000895383424687474, 0.0008691822450805492, -0.0008441144808836619, 
     0.0008201156924538692, -0.0007971259553098894, 0.0007750894857565353, 
     -0.0007539543022286486, 0.000733671918512222, -0.0007141970654591543, 
     0.0006954874382108494, -0.0006775034662930115, 0.0006602081042469329, 
     -0.0006435666407272594, 0.0006275465242280382, -0.0006121172038021858, 
     0.0005972499833180938, -0.000582917887954346, 0.0005690955417720581, 
     -0.0005557590553267192, 0.0005428859223895726, -0.0005304549249443777, 
     0.000518446045710357, -0.000506840387517569, 0.0004956200989280598, 
     -0.0004847683055558922, 0.0004742690465924758, -0.00046410721609112075, 
     0.00045426850860737916, -0.00044473936882974494, 0.00043550694486943226, 
     -0.00042655904490856815, 0.000417884096933681, -0.0004094711113060206};
 
  TVIL_REAL Fbar0xxytableBL2[] = 
     {0, 0, -1., 0.3333333333333333, -0.16666666666666666, 0.1, 
     -0.06666666666666667, 0.047619047619047616, -0.03571428571428571, 
     0.027777777777777776, -0.022222222222222223, 0.01818181818181818, 
     -0.015151515151515152, 0.01282051282051282, -0.01098901098901099, 
     0.009523809523809525, -0.008333333333333333, 0.007352941176470588, 
     -0.006535947712418301, 0.005847953216374269, -0.005263157894736842, 
     0.004761904761904762, -0.004329004329004329, 0.003952569169960474, 
     -0.0036231884057971015, 0.0033333333333333335, -0.003076923076923077, 
     0.002849002849002849, -0.0026455026455026454, 0.0024630541871921183, 
     -0.0022988505747126436, 0.002150537634408602, -0.0020161290322580645, 
     0.001893939393939394, -0.0017825311942959, 0.0016806722689075631, 
     -0.0015873015873015873, 0.0015015015015015015, -0.001422475106685633, 
     0.001349527665317139, -0.001282051282051282, 0.0012195121951219512, 
     -0.0011614401858304297, 0.0011074197120708748, -0.0010570824524312897, 
     0.00101010101010101, -0.000966183574879227, 0.0009250693802035153, 
     -0.0008865248226950354, 0.0008503401360544217, -0.0008163265306122449, 
     0.000784313725490196, -0.0007541478129713424, 0.000725689404934688, 
     -0.0006988120195667365, 0.0006734006734006734, -0.0006493506493506494, 
     0.0006265664160401002, -0.0006049606775559589, 0.0005844535359438924, 
     -0.0005649717514124294, 0.000546448087431694, -0.0005288207297726071, 
     0.0005120327700972862, -0.000496031746031746, 0.0004807692307692308, 
     -0.0004662004662004662, 0.0004522840343735866, -0.0004389815627743635, 
     0.00042625745950554135, -0.00041407867494824016, 0.00040241448692152917, 
     -0.0003912363067292645, 0.000380517503805175, -0.00037023324694557573, 
     0.00036036036036036037, -0.0003508771929824561, 0.0003417634996582365, 
     -0.000333000333000333, 0.0003245699448231094, -0.00031645569620253165, 
     0.00030864197530864197, -0.00030111412225233364, 0.0002938583602703497, 
     -0.00028686173264486515, 0.00028011204481792715, 
     -0.00027359781121751026, 0.0002673082063619353, -0.00026123301985370953, 
     0.0002553626149131767, -0.00024968789013732833, 0.0002442002442002442, 
     -0.00023889154323936931, 0.0002337540906965872, -0.00022878059940517045, 
     0.00022396416573348266, -0.0002192982456140351, 0.0002147766323024055, 
     -0.00021039343572480537, 0.00020614306328592042, -0.00020202020202020202};

  if (SAME2(0,x)) return TVIL_FBAR000x(y,qq);
  if (SAME2(0,y)) return TVIL_FBAR00xx(x,qq);

  lnbarx = TVIL_Ap(x,qq);
  lnbary = TVIL_Ap(y,qq);
  lnbarx2 = lnbarx * lnbarx;
  lnbary2 = lnbary * lnbary;
  lnyox = lnbary - lnbarx;

  if (y < 2. * x) {

    result = x * (1./3.L - lnbarx + lnbarx2 - lnbarx2*lnbarx/3.L + 
             8.L*Zeta3/3.L);

    result += y * (55.L/6.L + 5.L*lnbarx + 1.5L*lnbarx2 + 
              lnbarx2 * lnbarx/3.L - 1.5L * lnbary - lnbarx * lnbary 
              - 0.5L * lnbarx2 * lnbary - 8.L*Zeta3/3.L);

    rn = r = 0.25L * y/x;

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Fbar0xxytableA[n] + 
        Fbar0xxytableALx[n] * lnbarx + 
        Fbar0xxytableALy[n] * lnbary +
        Fbar0xxytableAL2[n] * lnbarx * lnyox); 
    }
  }
  else if (y > 6.47 * x) {
    result = y * (1/6.L + Zeta2 - 0.5L * lnbary - Zeta2 * lnbary + 
     0.5L * lnbary2 -lnbary2 * lnbary/6.L - 2.L * Zeta3/3.L);

    result += x * (-5.L/3.L + 2.L * Zeta2 + lnbarx - 2.L * Zeta2 * lnbarx 
              + 4.L * Zeta2 * lnbary + lnbary2 - lnbarx * lnbary2 
              + 2.L * lnbary2 * lnbary/3.L + 8.L * Zeta3/3.L);

    rn = r = 4.L * x/y;

    for (n=2; n < 100; n++) {
      rn *= r;
      result += y * rn * (Fbar0xxytableC[n] + 
        Fbar0xxytableCLx[n] * lnbarx + 
        Fbar0xxytableCLy[n] * lnbary +
        Fbar0xxytableCLx2[n] * lnbarx2 +
        Fbar0xxytableCLy2[n] * lnbary2 +
        Fbar0xxytableCLxLy[n] * lnbarx * lnbary +
        Fbar0xxytableCL3[n] * lnbary * lnyox * lnyox); 
    }
  }
  else {
    result = x * (1 - 4.L * LN2 - 3.L * lnbarx + 8.L * LN2 * lnbarx +
             3.L * lnbarx2 - 4.L * LN2 * lnbarx2 - lnbarx2 * lnbarx +
             13.L * Zeta3);

    result += (y - 4.L * x) * (-2.L - 42.L * LN2 + 3.L * lnbarx - 
              12.L * LN2 * lnbarx - 6 * LN2 * lnbarx2 - lnbarx2 * lnbarx +
              26.L * Zeta3)/6.L;
 
    rn = r = 0.25L * y/x - 1.L; 

    for (n=2; n < 100; n++) {
      rn *= r;
      result += x * rn * (Fbar0xxytableB[n] + 
        Fbar0xxytableBL[n] * lnbarx + 
        Fbar0xxytableBL2[n] * lnbarx2);
    }

  }

  return result;
};

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR0000 ()
{
  return 0.0L;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR000x (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;

  lnbarx2 = lnbarx*lnbarx;

  return x/6 + (PI2*x)/6 - (x*lnbarx)/2 - (PI2*x*lnbarx)/6 +
    (x*lnbarx2)/2 - (x*lnbarx*lnbarx2)/6 - (2*x*Zeta3)/3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR00xx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return x/3 - x*lnbarx + x*lnbarx2 - (x*lnbarx*lnbarx2)/3 +
    (8*x*Zeta3)/3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx000 (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return (47*x)/12 + (PI2*x)/6 - (11*x*lnbarx)/4 + (x*lnbarx2)/2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx00x (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return (49*x)/12 - (13*x*lnbarx)/4 - (PI2*x*lnbarx)/6 +
    x*lnbarx2 - (x*lnbarx*lnbarx2)/6 - (8*x*Zeta3)/3;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARx0xx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return (17*x)/4 - (15*x*lnbarx)/4 + (3*x*lnbarx2)/2 -
    (x*lnbarx*lnbarx2)/3 - 3*TVIL_SQRT(3)*x*LS2;
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBAR0xxx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return x*(9.0968675372632776795L + (3.*SQRT3*LS2 - 1.5)*lnbarx
	    + 1.5L*lnbarx2 - 0.5*lnbarx2*lnbarx);
}

/* ****************************************************************** */

TVIL_COMPLEX TVIL_FBARxxxx (TVIL_REAL x, TVIL_REAL qq)
{
  TVIL_COMPLEX lnbarx2;
  TVIL_COMPLEX lnbarx = TVIL_LOG (TVIL_FABS(x)/qq);
  if (x<0) lnbarx = lnbarx - I * PI;
  lnbarx2 = lnbarx*lnbarx;

  return (53*x)/12 - (17*x*lnbarx)/4 + 2*x*lnbarx2 -
    (x*lnbarx*lnbarx2)/2 + 3*TVIL_SQRT(3)*x*lnbarx*LS2;
}

/* ****************************************************************** */

int TVIL_AnalyticFBARTYPE (TVIL_FBARTYPE *foo, TVIL_REAL qq)
{
  int retval;

  retval = TVIL_FBARanalytic (foo->arg[0],
			      foo->arg[1],
			      foo->arg[2],
			      foo->arg[3],
			      qq,
			      &(foo->value));

  return retval;
}

/* ****************************************************************** */


int TVIL_FBARanalytic (TVIL_REAL a1,
		       TVIL_REAL a2,
		       TVIL_REAL a3,
		       TVIL_REAL a4,
		       TVIL_REAL QQ,
		       TVIL_COMPLEX *result)
{
  int success = 1;

  if (SAME5(0,a1,a2,a3,a4))
    *result = TVIL_FBAR0000 ();

  else if (SAME4(0,a1,a2,a3))
    *result = TVIL_FBAR000x (a4, QQ);
  else if (SAME4(0,a1,a2,a4))
    *result = TVIL_FBAR000x (a3, QQ);
  else if (SAME4(0,a1,a3,a4))
    *result = TVIL_FBAR000x (a2, QQ);

  else if (SAME4(0,a2,a3,a4))
    *result = TVIL_FBARx000 (a1, QQ);

  else if (SAME3(0,a1,a2) && SAME2(a3,a4))
    *result = TVIL_FBAR00xx (a4, QQ);
  else if (SAME3(0,a1,a3) && SAME2(a2,a4))
    *result = TVIL_FBAR00xx (a4, QQ);
  else if (SAME3(0,a1,a4) && SAME2(a2,a3))
    *result = TVIL_FBAR00xx (a3, QQ);

  else if (SAME3(0,a2,a3) && SAME2(a1,a4))
    *result = TVIL_FBARx00x (a1, QQ);
  else if (SAME3(0,a2,a4) && SAME2(a1,a3))
    *result = TVIL_FBARx00x (a1, QQ);
  else if (SAME3(0,a3,a4) && SAME2(a1,a2))
    *result = TVIL_FBARx00x (a1, QQ);

  else if (SAME2(0,a2) && SAME3(a1,a3,a4))
    *result = TVIL_FBARx0xx (a1, QQ);
  else if (SAME2(0,a3) && SAME3(a1,a2,a4))
    *result = TVIL_FBARx0xx (a1, QQ);
  else if (SAME2(0,a4) && SAME3(a1,a2,a3))
    *result = TVIL_FBARx0xx (a1, QQ);

  else if (SAME2(0,a1) && SAME3(a2,a3,a4))
    *result = TVIL_FBAR0xxx (a4, QQ);

  else if (SAME4(a1,a2,a3,a4))
    *result = TVIL_FBARxxxx (a1, QQ);

  else if (SAME3(0,a1,a2) && (a3>0) && (a4>0))
    *result = TVIL_FBAR00xy (a3, a4, QQ);
  else if (SAME3(0,a1,a3) && (a2>0) && (a4>0))
    *result = TVIL_FBAR00xy (a2, a4, QQ);
  else if (SAME3(0,a1,a4) && (a2>0) && (a3>0))
    *result = TVIL_FBAR00xy (a2, a3, QQ);

  else if ((SAME3(0,a2,a3)) && (a1>0) && (a4>0))
    *result = TVIL_FBARx00y (a1, a4, QQ);
  else if ((SAME3(0,a2,a4)) && (a1>0) && (a3>0))
    *result = TVIL_FBARx00y (a1, a3, QQ);
  else if ((SAME3(0,a3,a4)) && (a1>0) && (a2>0))
    *result = TVIL_FBARx00y (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME2(a1,a3) && (a1>0) && (a4>0))
    *result = TVIL_FBARx0xy (a1, a4, QQ);
  else if (SAME2(0,a2) && SAME2(a1,a4) && (a1>0) && (a3>0))
    *result = TVIL_FBARx0xy (a1, a3, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a2) && (a1>0) && (a4>0))
    *result = TVIL_FBARx0xy (a1, a4, QQ);
  else if (SAME2(0,a3) && SAME2(a1,a4) && (a1>0) && (a2>0))
    *result = TVIL_FBARx0xy (a1, a2, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a2) && (a1>0) && (a3>0))
    *result = TVIL_FBARx0xy (a1, a3, QQ);
  else if (SAME2(0,a4) && SAME2(a1,a3) && (a1>0) && (a2>0))
    *result = TVIL_FBARx0xy (a1, a2, QQ);

  else if (SAME2(0,a2) && SAME2(a3,a4) && (a1>0) && (a4>0))
    *result = TVIL_FBARx0yy (a1, a4, QQ);
  else if (SAME2(0,a3) && SAME2(a2,a4) && (a1>0) && (a4>0))
    *result = TVIL_FBARx0yy (a1, a4, QQ);
  else if (SAME2(0,a4) && SAME2(a2,a3) && (a1>0) && (a3>0))
    *result = TVIL_FBARx0yy (a1, a3, QQ);

  else if (SAME2(0,a1) && SAME2(a2,a3) && (a2>0) && (a4>0))
    *result = TVIL_FBAR0xxy (a2, a4, QQ);
  else if (SAME2(0,a1) && SAME2(a2,a4) && (a2>0) && (a3>0))
    *result = TVIL_FBAR0xxy (a2, a3, QQ);
  else if (SAME2(0,a1) && SAME2(a3,a4) && (a3>0) && (a2>0))
    *result = TVIL_FBAR0xxy (a3, a2, QQ);

  else if (SAME2(a1,a2) && SAME2(a3,a4) && (a1>0) && (a3>0))
    *result = TVIL_FBARxxyy (a1, a3, QQ);
  else if (SAME2(a1,a3) && SAME2(a2,a4) && (a1>0) && (a2>0))
    *result = TVIL_FBARxxyy (a1, a2, QQ);
  else if (SAME2(a1,a4) && SAME2(a2,a3) && (a1>0) && (a2>0))
    *result = TVIL_FBARxxyy (a1, a2, QQ);

  else
    success = 0;

  return success;
}


/* ****************************************************************** */

int TVIL_SetF (TVIL_FBARTYPE *foo, TVIL_REAL qq)
{
  /* For readability: */
  TVIL_REAL u = foo->arg[0];
  TVIL_REAL v = foo->arg[1];
  TVIL_REAL y = foo->arg[2];
  TVIL_REAL z = foo->arg[3];
  TVIL_COMPLEX lnbaru;

/*
  if (SAME2(0,u)) return TVIL_ComplexInfinity;
*/

  lnbaru = TVIL_LOG (TVIL_FABS(u)/qq);  
  if (u<0) lnbaru = lnbaru - I * PI;

  (foo->fValue) = (foo->value) - lnbaru*TVIL_I2 (v, y, z, qq);

  /* Make this meaningful eventually... */
  return 0;
}

/* ****************************************************************** */

int TVIL_SetAllFs (TVIL_DATA *foo)
{
  int i;
  for (i=0; i<NUM_F_FUNCS; i++)
    TVIL_SetF (&(foo->FBAR[i]), foo->qq);

  /* Make this meaningful eventually... */
  return 0;
}

/* ****************************************************************** */
/* Sets initial value for an FBAR function at a point near t = 0. */

int TVIL_InitialFBAR (TVIL_FBARTYPE *foo, 
		      TVIL_REAL qq,
		      TVIL_COMPLEX tinit)
{
  TVIL_REAL x = (foo->arg[0])/a;
  TVIL_REAL y = (foo->arg[1])/a;
  TVIL_REAL z = (foo->arg[2])/a;
  TVIL_REAL u = (foo->arg[3])/a;

  TVIL_REAL Fbarexp[9];
  TVIL_REAL x2, x3, x4, x5, x6, x7, x8;
  TVIL_REAL y2, y3, y4, y5, y6, y7, y8;
  TVIL_REAL z2, z3, z4, z5, z6, z7, z8;
  TVIL_REAL u2, u3, u4, u5, u6, u7, u8;
  TVIL_REAL lnbara, lnbara2, lnbara3;
  TVIL_COMPLEX ttothei, result;
  int i, nTerms = 9;

  lnbara = TVIL_LOG (a/qq);
  lnbara2 = lnbara*lnbara;
  lnbara3 = lnbara2*lnbara;

  x2 = x*x;
  x3 = x2*x;
  x4 = x2*x2;
  x5 = x2*x3;
  x6 = x3*x3;
  x7 = x4*x3;
  x8 = x4*x4;

  y2 = y*y;
  y3 = y2*y;
  y4 = y2*y2;
  y5 = y2*y3;
  y6 = y3*y3;
  y7 = y4*y3;
  y8 = y4*y4;

  z2 = z*z;
  z3 = z2*z;
  z4 = z2*z2;
  z5 = z2*z3;
  z6 = z3*z3;
  z7 = z4*z3;
  z8 = z4*z4;

  u2 = u*u;
  u3 = u2*u;
  u4 = u2*u2;
  u5 = u2*u3;
  u6 = u3*u3;
  u7 = u4*u3;
  u8 = u4*u4;

  Fbarexp[0] = 4.416666666666667 - 0.7341391419658116*lnbara + 2.*lnbara2 - 
     0.5*lnbara3;
 
  Fbarexp[1] = -3.682527524700855 - 3.265860858034188*lnbara - 0.5*lnbara2 + 
     0.5*lnbara3 + 2.4714661073723865*u + 1.6719536193447295*lnbara*u - 
     0.16666666666666666*lnbara3*u - 3.731870797416305*x - 1.75*lnbara*x + 
     0.5*lnbara2*x + 2.4714661073723865*y + 1.6719536193447295*lnbara*y - 
     0.16666666666666666*lnbara3*y + 2.4714661073723865*z + 
     1.6719536193447295*lnbara*z - 0.16666666666666666*lnbara3*z;
 
  Fbarexp[2] = 1.632930429017094 + 0.5*lnbara - 0.75*lnbara2 - 
     1.6719536193447295*u + 0.5*lnbara2*u - 0.801799790264645*u2 - 
     0.7813024128964863*lnbara*u2 - 0.25*lnbara2*u2 + 1.75*x - 
     1.*lnbara*x - 0.9316459611845606*u*x + 0.5224689417768408*x2 + 
     0.5*lnbara*x2 - 1.6719536193447295*y + 0.5*lnbara2*y + 
     2.10359958052929*u*y + 0.7813024128964863*lnbara*u*y - 
     0.9316459611845606*x*y - 0.801799790264645*y2 - 
     0.7813024128964863*lnbara*y2 - 0.25*lnbara2*y2 - 
     1.6719536193447295*z + 0.5*lnbara2*z + 2.10359958052929*u*z + 
     0.7813024128964863*lnbara*u*z - 0.9316459611845606*x*z + 
     2.10359958052929*y*z + 0.7813024128964863*lnbara*y*z - 
     0.801799790264645*z2 - 0.7813024128964863*lnbara*z2 - 0.25*lnbara2*z2;
 
  Fbarexp[3] = 0.3776434763390314 + 0.6666666666666666*lnbara - 0.25*lnbara2 - 
     0.8359768096723648*u - 0.5*lnbara*u + 0.25*lnbara2*u - 
     0.020497377368158702*u2 - 0.2813024128964863*lnbara*u2 - 
     0.25*lnbara2*u2 + 0.1587832808994946*u3 + 0.20487858207660653*lnbara*
      u3 + 0.08333333333333333*lnbara2*u3 + 1.375*x - 0.5*lnbara*x - 
     0.9316459611845606*u*x + 0.19504742980199746*u2*x + 
     0.02246894177684083*x2 + 0.5*lnbara*x2 + 0.14037303302611903*u*x2 - 
     0.14786268028506597*x3 - 0.16666666666666666*lnbara*x3 - 
     0.8359768096723648*y - 0.5*lnbara*y + 0.25*lnbara2*y + 
     1.3222971676328037*u*y + 0.7813024128964863*lnbara*u*y - 
     0.32544994756616125*u2*y - 0.16666666666666666*lnbara*u2*y - 
     0.9316459611845606*x*y + 0.13040251776416378*u*x*y + 
     0.14037303302611903*x2*y - 0.020497377368158702*y2 - 
     0.2813024128964863*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.32544994756616125*u*y2 - 0.16666666666666666*lnbara*u*y2 + 
     0.19504742980199746*x*y2 + 0.1587832808994946*y3 + 
     0.20487858207660653*lnbara*y3 + 0.08333333333333333*lnbara2*y3 - 
     0.8359768096723648*z - 0.5*lnbara*z + 0.25*lnbara2*z + 
     1.3222971676328037*u*z + 0.7813024128964863*lnbara*u*z - 
     0.32544994756616125*u2*z - 0.16666666666666666*lnbara*u2*z - 
     0.9316459611845606*x*z + 0.13040251776416378*u*x*z + 
     0.14037303302611903*x2*z + 1.3222971676328037*y*z + 
     0.7813024128964863*lnbara*y*z - 0.1508998951323225*u*y*z - 
     0.11463574622981963*lnbara*u*y*z + 0.13040251776416378*x*y*z - 
     0.32544994756616125*y2*z - 0.16666666666666666*lnbara*y2*z - 
     0.020497377368158702*z2 - 0.2813024128964863*lnbara*z2 - 
     0.25*lnbara2*z2 - 0.32544994756616125*u*z2 - 
     0.16666666666666666*lnbara*u*z2 + 0.19504742980199746*x*z2 - 
     0.32544994756616125*y*z2 - 0.16666666666666666*lnbara*y*z2 + 
     0.1587832808994946*z3 + 0.20487858207660653*lnbara*z3 + 
     0.08333333333333333*lnbara2*z3;
 
  Fbarexp[4] = 0.022155071502849028 + 0.4583333333333333*lnbara - 
     0.125*lnbara2 - 0.39065120644824314*u - 0.5*lnbara*u + 
     0.16666666666666666*lnbara2*u + 0.12015382908008444*u2 - 
     0.0313024128964863*lnbara*u2 - 0.25*lnbara2*u2 + 
     0.11268797972238262*u3 + 0.24309049748654643*lnbara*u3 + 
     0.16666666666666666*lnbara2*u3 - 0.06897497378308062*u4 - 
     0.09491905471773769*lnbara*u4 - 0.041666666666666664*lnbara2*u4 + 
     1.0833333333333333*x - 0.3333333333333333*lnbara*x - 
     0.9316459611845606*u*x + 0.3900948596039949*u2*x - 
     0.07890469882288804*u3*x - 0.22753105822315917*x2 + 0.5*lnbara*x2 + 
     0.28074606605223806*u*x2 - 0.035023714900998724*u2*x2 - 
     0.12905869390346528*x3 - 0.3333333333333333*lnbara*x3 - 
     0.05191535535074602*u*x3 + 0.07120118998892583*x4 + 
     0.08333333333333333*lnbara*x4 - 0.39065120644824314*y - 0.5*lnbara*y + 
     0.16666666666666666*lnbara2*y + 0.9316459611845606*u*y + 
     0.7813024128964863*lnbara*u*y - 0.4842332284656558*u2*y - 
     0.3333333333333333*lnbara*u2*y + 0.12105830711641395*u3*y + 
     0.06829286069220218*lnbara*u3*y - 0.9316459611845606*x*y + 
     0.26080503552832757*u*x*y - 0.041666666666666664*u2*x*y + 
     0.28074606605223806*x2*y - 0.027476285099001272*u*x2*y - 
     0.05191535535074602*x3*y + 0.12015382908008444*y2 - 
     0.0313024128964863*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.4842332284656558*u*y2 - 0.3333333333333333*lnbara*u*y2 + 
     0.0625*u2*y2 + 0.045121417923393456*lnbara*u2*y2 + 
     0.3900948596039949*x*y2 - 0.041666666666666664*u*x*y2 - 
     0.035023714900998724*x2*y2 + 0.11268797972238262*y3 + 
     0.24309049748654643*lnbara*y3 + 0.16666666666666666*lnbara2*y3 + 
     0.12105830711641395*u*y3 + 0.06829286069220218*lnbara*u*y3 - 
     0.07890469882288804*x*y3 - 0.06897497378308062*y4 - 
     0.09491905471773769*lnbara*y4 - 0.041666666666666664*lnbara2*y4 - 
     0.39065120644824314*z - 0.5*lnbara*z + 0.16666666666666666*lnbara2*z + 
     0.9316459611845606*u*z + 0.7813024128964863*lnbara*u*z - 
     0.4842332284656558*u2*z - 0.3333333333333333*lnbara*u2*z + 
     0.12105830711641395*u3*z + 0.06829286069220218*lnbara*u3*z - 
     0.9316459611845606*x*z + 0.26080503552832757*u*x*z - 
     0.041666666666666664*u2*x*z + 0.28074606605223806*x2*z - 
     0.027476285099001272*u*x2*z - 0.05191535535074602*x3*z + 
     0.9316459611845606*y*z + 0.7813024128964863*lnbara*y*z - 
     0.18716404403482537*u*y*z - 0.22927149245963926*lnbara*u*y*z + 
     0.03772497378308062*u2*y*z + 0.03821191540993988*lnbara*u2*y*z + 
     0.26080503552832757*x*y*z - 0.03918579866365838*u*x*y*z - 
     0.027476285099001272*x2*y*z - 0.4842332284656558*y2*z - 
     0.3333333333333333*lnbara*y2*z + 0.03772497378308062*u*y2*z + 
     0.03821191540993988*lnbara*u*y2*z - 0.041666666666666664*x*y2*z + 
     0.12105830711641395*y3*z + 0.06829286069220218*lnbara*y3*z + 
     0.12015382908008444*z2 - 0.0313024128964863*lnbara*z2 - 
     0.25*lnbara2*z2 - 0.4842332284656558*u*z2 - 
     0.3333333333333333*lnbara*u*z2 + 0.0625*u2*z2 + 
     0.045121417923393456*lnbara*u2*z2 + 0.3900948596039949*x*z2 - 
     0.041666666666666664*u*x*z2 - 0.035023714900998724*x2*z2 - 
     0.4842332284656558*y*z2 - 0.3333333333333333*lnbara*y*z2 + 
     0.03772497378308062*u*y*z2 + 0.03821191540993988*lnbara*u*y*z2 - 
     0.041666666666666664*x*y*z2 + 0.0625*y2*z2 + 
     0.045121417923393456*lnbara*y2*z2 + 0.11268797972238262*z3 + 
     0.24309049748654643*lnbara*z3 + 0.16666666666666666*lnbara2*z3 + 
     0.12105830711641395*u*z3 + 0.06829286069220218*lnbara*u*z3 - 
     0.07890469882288804*x*z3 + 0.12105830711641395*y*z3 + 
     0.06829286069220218*lnbara*y*z3 - 0.06897497378308062*z4 - 
     0.09491905471773769*lnbara*z4 - 0.041666666666666664*lnbara2*z4;
 
  Fbarexp[5] = -0.07837362376495725 + 0.325*lnbara - 0.075*lnbara2 - 
     0.16798840483618235*u - 0.4583333333333333*lnbara*u + 0.125*lnbara2*u + 
     0.13058796671224654*u2 + 0.13536425377018038*lnbara*u2 - 
     0.25*lnbara2*u2 + 0.04748672084030073*u3 + 0.19796907956315296*lnbara*
      u3 + 0.25*lnbara2*u3 - 0.11200586663150418*u4 - 
     0.20142383081987975*lnbara*u4 - 0.125*lnbara2*u4 + 
     0.03893566151703746*u5 + 0.0549460364784918*lnbara*u5 + 
     0.025*lnbara2*u5 + 0.8958333333333334*x - 0.25*lnbara*x - 
     0.9316459611845606*u*x + 0.5851422894059923*u2*x - 
     0.23671409646866412*u3*x + 0.04204576035750674*u4*x - 
     0.39419772488982585*x2 + 0.5*lnbara*x2 + 0.4211190990783571*u*x2 - 
     0.10507114470299618*u2*x2 + 0.014959121883334814*u3*x2 - 
     0.026921374188531248*x3 - 0.5*lnbara*x3 - 0.15574606605223806*u*x3 + 
     0.013495492518326768*u2*x3 + 0.13027023663344417*x4 + 
     0.25*lnbara*x4 + 0.02668990274900491*u*x4 - 0.04206798897609178*x5 - 
     0.05*lnbara*x5 - 0.16798840483618235*y - 0.4583333333333333*lnbara*y + 
     0.125*lnbara2*y + 0.6712118235523985*u*y + 0.7813024128964863*lnbara*u*
      y - 0.559683176031817*u2*y - 0.5*lnbara*u2*y + 
     0.2948820606570397*u3*y + 0.20487858207660653*lnbara*u3*y - 
     0.06235910065559491*u4*y - 0.03665317578628961*lnbara*u4*y - 
     0.9316459611845606*x*y + 0.3912075532924914*u*x*y - 0.125*u2*x*y + 
     0.01930640563598377*u3*x*y + 0.4211190990783571*x2*y - 
     0.08242885529700382*u*x2*y + 0.009853650749005715*u2*x2*y - 
     0.15574606605223806*x3*y + 0.010997735009782437*u*x3*y + 
     0.02668990274900491*x4*y + 0.13058796671224654*y2 + 
     0.13536425377018038*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.559683176031817*u*y2 - 0.5*lnbara*u*y2 + 0.14237858207660653*u2*
      y2 + 0.13536425377018038*lnbara*u2*y2 - 0.024493227528109205*u3*
      y2 - 0.020053963521508202*lnbara*u3*y2 + 0.5851422894059923*x*y2 - 
     0.125*u*x*y2 + 0.015560465676376308*u2*x*y2 - 
     0.10507114470299618*x2*y2 + 0.009853650749005715*u*x2*y2 + 
     0.013495492518326768*x3*y2 + 0.04748672084030073*y3 + 
     0.19796907956315296*lnbara*y3 + 0.25*lnbara2*y3 + 
     0.2948820606570397*u*y3 + 0.20487858207660653*lnbara*u*y3 - 
     0.024493227528109205*u2*y3 - 0.020053963521508202*lnbara*u2*y3 - 
     0.23671409646866412*x*y3 + 0.01930640563598377*u*x*y3 + 
     0.014959121883334814*x2*y3 - 0.11200586663150418*y4 - 
     0.20142383081987975*lnbara*y4 - 0.125*lnbara2*y4 - 
     0.06235910065559491*u*y4 - 0.03665317578628961*lnbara*u*y4 + 
     0.04204576035750674*x*y4 + 0.03893566151703746*y5 + 
     0.0549460364784918*lnbara*y5 + 0.025*lnbara2*y5 - 
     0.16798840483618235*z - 0.4583333333333333*lnbara*z + 0.125*lnbara2*z + 
     0.6712118235523985*u*z + 0.7813024128964863*lnbara*u*z - 
     0.559683176031817*u2*z - 0.5*lnbara*u2*z + 0.2948820606570397*u3*z + 
     0.20487858207660653*lnbara*u3*z - 0.06235910065559491*u4*z - 
     0.03665317578628961*lnbara*u4*z - 0.9316459611845606*x*z + 
     0.3912075532924914*u*x*z - 0.125*u2*x*z + 0.01930640563598377*u3*x*z + 
     0.4211190990783571*x2*z - 0.08242885529700382*u*x2*z + 
     0.009853650749005715*u2*x2*z - 0.15574606605223806*x3*z + 
     0.010997735009782437*u*x3*z + 0.02668990274900491*x4*z + 
     0.6712118235523985*y*z + 0.7813024128964863*lnbara*y*z - 
     0.16611031982241842*u*y*z - 0.3439072386894589*lnbara*u*y*z + 
     0.074963005939302*u2*y*z + 0.11463574622981963*lnbara*u2*y*z - 
     0.01576560861442539*u3*y*z - 0.018157951888431674*lnbara*u3*y*z + 
     0.3912075532924914*x*y*z - 0.11755739599097514*u*x*y*z + 
     0.016252550241284643*u2*x*y*z - 0.08242885529700382*x2*y*z + 
     0.010021047271633643*u*x2*y*z + 0.010997735009782437*x3*y*z - 
     0.559683176031817*y2*z - 0.5*lnbara*y2*z + 0.074963005939302*u*y2*z + 
     0.11463574622981963*lnbara*u*y2*z - 0.010979682584327617*u2*y2*z - 
     0.015040472641131153*lnbara*u2*y2*z - 0.125*x*y2*z + 
     0.016252550241284643*u*x*y2*z + 0.009853650749005715*x2*y2*z + 
     0.2948820606570397*y3*z + 0.20487858207660653*lnbara*y3*z - 
     0.01576560861442539*u*y3*z - 0.018157951888431674*lnbara*u*y3*z + 
     0.01930640563598377*x*y3*z - 0.06235910065559491*y4*z - 
     0.03665317578628961*lnbara*y4*z + 0.13058796671224654*z2 + 
     0.13536425377018038*lnbara*z2 - 0.25*lnbara2*z2 - 
     0.559683176031817*u*z2 - 0.5*lnbara*u*z2 + 0.14237858207660653*u2*
      z2 + 0.13536425377018038*lnbara*u2*z2 - 0.024493227528109205*u3*
      z2 - 0.020053963521508202*lnbara*u3*z2 + 0.5851422894059923*x*z2 - 
     0.125*u*x*z2 + 0.015560465676376308*u2*x*z2 - 
     0.10507114470299618*x2*z2 + 0.009853650749005715*u*x2*z2 + 
     0.013495492518326768*x3*z2 - 0.559683176031817*y*z2 - 
     0.5*lnbara*y*z2 + 0.074963005939302*u*y*z2 + 
     0.11463574622981963*lnbara*u*y*z2 - 0.010979682584327617*u2*y*z2 - 
     0.015040472641131153*lnbara*u2*y*z2 - 0.125*x*y*z2 + 
     0.016252550241284643*u*x*y*z2 + 0.009853650749005715*x2*y*z2 + 
     0.14237858207660653*y2*z2 + 0.13536425377018038*lnbara*y2*z2 - 
     0.010979682584327617*u*y2*z2 - 0.015040472641131153*lnbara*u*y2*z2 + 
     0.015560465676376308*x*y2*z2 - 0.024493227528109205*y3*z2 - 
     0.020053963521508202*lnbara*y3*z2 + 0.04748672084030073*z3 + 
     0.19796907956315296*lnbara*z3 + 0.25*lnbara2*z3 + 
     0.2948820606570397*u*z3 + 0.20487858207660653*lnbara*u*z3 - 
     0.024493227528109205*u2*z3 - 0.020053963521508202*lnbara*u2*z3 - 
     0.23671409646866412*x*z3 + 0.01930640563598377*u*x*z3 + 
     0.014959121883334814*x2*z3 + 0.2948820606570397*y*z3 + 
     0.20487858207660653*lnbara*y*z3 - 0.01576560861442539*u*y*z3 - 
     0.018157951888431674*lnbara*u*y*z3 + 0.01930640563598377*x*y*z3 - 
     0.024493227528109205*y2*z3 - 0.020053963521508202*lnbara*y2*z3 - 
     0.11200586663150418*z4 - 0.20142383081987975*lnbara*z4 - 
     0.125*lnbara2*z4 - 0.06235910065559491*u*z4 - 
     0.03665317578628961*lnbara*u*z4 + 0.04204576035750674*x*z4 - 
     0.06235910065559491*y*z4 - 0.03665317578628961*lnbara*y*z4 + 
     0.03893566151703746*z5 + 0.0549460364784918*lnbara*z5 + 
     0.025*lnbara2*z5;
 
  Fbarexp[6] = -0.10641574917663817 + 0.24166666666666667*lnbara - 
     0.05*lnbara2 - 0.042724057202279224*u - 0.4166666666666667*lnbara*u + 
     0.1*lnbara2*u + 0.09674690326970145*u2 + 0.26036425377018035*lnbara*
      u2 - 0.25*lnbara2*u2 - 0.0026740654006500216*u3 + 
     0.09729210608420395*lnbara*u3 + 0.3333333333333333*lnbara2*u3 - 
     0.12329981785306848*u4 - 0.2778476616397595*lnbara*u4 - 
     0.25*lnbara2*u4 + 0.10079660958965803*u5 + 0.16978414591396718*lnbara*
      u5 + 0.1*lnbara2*u5 - 0.02509960988230047*u6 - 
     0.035885453284794776*lnbara*u6 - 0.016666666666666666*lnbara2*u6 + 
     0.7666666666666667*x - 0.2*lnbara*x - 0.9316459611845606*u*x + 
     0.7801897192079899*u2*x - 0.47342819293732824*u3*x + 
     0.16818304143002696*u4*x - 0.02600114622302915*u5*x - 
     0.5191977248898259*x2 + 0.5*lnbara*x2 + 0.5614921321044761*u*x2 - 
     0.21014228940599236*u2*x2 + 0.059836487533339255*u3*x2 - 
     0.00816041324288591*u4*x2 + 0.13077150108195834*x3 - 
     0.6666666666666666*lnbara*x3 - 0.3114921321044761*u*x3 + 
     0.05398197007330707*u2*x3 - 0.005867060110137494*u3*x3 + 
     0.13554047326688834*x4 + 0.5*lnbara*x4 + 0.10675961099601965*u*x4 - 
     0.00704235352968079*u2*x4 - 0.11827195590436712*x5 - 0.2*lnbara*x5 - 
     0.016206935424856943*u*x5 + 0.027815460363156325*x6 + 
     0.03333333333333333*lnbara*x6 - 0.042724057202279224*y - 
     0.4166666666666667*lnbara*y + 0.1*lnbara2*y + 0.4758862203282769*u*y + 
     0.7813024128964863*lnbara*u*y - 0.5795775680424228*u2*y - 
     0.6666666666666666*lnbara*u2*y + 0.4873248302757761*u3*y + 
     0.40975716415321306*lnbara*u3*y - 0.21278322683609005*u4*y - 
     0.14661270314515845*lnbara*u4*y + 0.03790109796358698*u5*y + 
     0.02276428689740073*lnbara*u5*y - 0.9316459611845606*x*y + 
     0.5216100710566551*u*x*y - 0.25*u2*x*y + 0.07722562254393509*u3*x*y - 
     0.010928241914554696*u4*x*y + 0.5614921321044761*x2*y - 
     0.16485771059400764*u*x2*y + 0.03941460299602286*u2*x2*y - 
     0.004796827115691569*u3*x2*y - 0.3114921321044761*x3*y + 
     0.04399094003912975*u*x3*y - 0.004105687812085715*u2*x3*y + 
     0.10675961099601965*x4*y - 0.00582011340618667*u*x4*y - 
     0.016206935424856943*x5*y + 0.09674690326970145*y2 + 
     0.26036425377018035*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.5795775680424228*u*y2 - 0.6666666666666666*lnbara*u*y2 + 
     0.2170750372681229*u2*y2 + 0.27072850754036076*lnbara*u2*y2 - 
     0.07791894659092861*u3*y2 - 0.08021585408603281*lnbara*u3*y2 + 
     0.01286246693586746*u4*y2 + 0.011178565512996366*lnbara*u4*y2 + 
     0.7801897192079899*x*y2 - 0.25*u*x*y2 + 0.06224186270550523*u2*x*
      y2 - 0.007736900085251058*u3*x*y2 - 0.21014228940599236*x2*y2 + 
     0.03941460299602286*u*x2*y2 - 0.00408511380731101*u2*x2*y2 + 
     0.05398197007330707*x3*y2 - 0.004105687812085715*u*x3*y2 - 
     0.00704235352968079*x4*y2 - 0.0026740654006500216*y3 + 
     0.09729210608420395*lnbara*y3 + 0.3333333333333333*lnbara2*y3 + 
     0.4873248302757761*u*y3 + 0.40975716415321306*lnbara*u*y3 - 
     0.07791894659092861*u2*y3 - 0.08021585408603281*lnbara*u2*y3 + 
     0.009783201076803173*u3*y3 + 0.009259259259259259*lnbara*u3*y3 - 
     0.47342819293732824*x*y3 + 0.07722562254393509*u*x*y3 - 
     0.007736900085251058*u2*x*y3 + 0.059836487533339255*x2*y3 - 
     0.004796827115691569*u*x2*y3 - 0.005867060110137494*x3*y3 - 
     0.12329981785306848*y4 - 0.2778476616397595*lnbara*y4 - 
     0.25*lnbara2*y4 - 0.21278322683609005*u*y4 - 
     0.14661270314515845*lnbara*u*y4 + 0.01286246693586746*u2*y4 + 
     0.011178565512996366*lnbara*u2*y4 + 0.16818304143002696*x*y4 - 
     0.010928241914554696*u*x*y4 - 0.00816041324288591*x2*y4 + 
     0.10079660958965803*y5 + 0.16978414591396718*lnbara*y5 + 
     0.1*lnbara2*y5 + 0.03790109796358698*u*y5 + 
     0.02276428689740073*lnbara*u*y5 - 0.02600114622302915*x*y5 - 
     0.02509960988230047*y6 - 0.035885453284794776*lnbara*y6 - 
     0.016666666666666666*lnbara2*y6 - 0.042724057202279224*z - 
     0.4166666666666667*lnbara*z + 0.1*lnbara2*z + 0.4758862203282769*u*z + 
     0.7813024128964863*lnbara*u*z - 0.5795775680424228*u2*z - 
     0.6666666666666666*lnbara*u2*z + 0.4873248302757761*u3*z + 
     0.40975716415321306*lnbara*u3*z - 0.21278322683609005*u4*z - 
     0.14661270314515845*lnbara*u4*z + 0.03790109796358698*u5*z + 
     0.02276428689740073*lnbara*u5*z - 0.9316459611845606*x*z + 
     0.5216100710566551*u*x*z - 0.25*u2*x*z + 0.07722562254393509*u3*x*z - 
     0.010928241914554696*u4*x*z + 0.5614921321044761*x2*z - 
     0.16485771059400764*u*x2*z + 0.03941460299602286*u2*x2*z - 
     0.004796827115691569*u3*x2*z - 0.3114921321044761*x3*z + 
     0.04399094003912975*u*x3*z - 0.004105687812085715*u2*x3*z + 
     0.10675961099601965*x4*z - 0.00582011340618667*u*x4*z - 
     0.016206935424856943*x5*z + 0.4758862203282769*y*z + 
     0.7813024128964863*lnbara*y*z - 0.1068446802000716*u*y*z - 
     0.45854298491927853*lnbara*u*y*z + 0.09260813876369418*u2*y*z + 
     0.22927149245963926*lnbara*u2*y*z - 0.04490448256926989*u3*y*z - 
     0.0726318075537267*lnbara*u3*y*z + 0.008481045060974917*u4*y*z + 
     0.010434137632162098*lnbara*u4*y*z + 0.5216100710566551*x*y*z - 
     0.2351147919819503*u*x*y*z + 0.06501020096513857*u2*x*y*z - 
     0.008445200483831043*u3*x*y*z - 0.16485771059400764*x2*y*z + 
     0.04008418908653457*u*x2*y*z - 0.004536830598068991*u2*x2*y*z + 
     0.04399094003912975*x3*y*z - 0.0042877351660402085*u*x3*y*z - 
     0.00582011340618667*x4*y*z - 0.5795775680424228*y2*z - 
     0.6666666666666666*lnbara*y2*z + 0.09260813876369418*u*y2*z + 
     0.22927149245963926*lnbara*u*y2*z - 0.028878257696179317*u2*y2*z - 
     0.06016189056452461*lnbara*u2*y2*z + 0.004856375702300316*u3*y2*z + 
     0.007723814256269575*lnbara*u3*y2*z - 0.25*x*y2*z + 
     0.06501020096513857*u*x*y2*z - 0.007650234579376865*u2*x*y2*z + 
     0.03941460299602286*x2*y2*z - 0.004536830598068991*u*x2*y2*z - 
     0.004105687812085715*x3*y2*z + 0.4873248302757761*y3*z + 
     0.40975716415321306*lnbara*y3*z - 0.04490448256926989*u*y3*z - 
     0.0726318075537267*lnbara*u*y3*z + 0.004856375702300316*u2*y3*z + 
     0.007723814256269575*lnbara*u2*y3*z + 0.07722562254393509*x*y3*z - 
     0.008445200483831043*u*x*y3*z - 0.004796827115691569*x2*y3*z - 
     0.21278322683609005*y4*z - 0.14661270314515845*lnbara*y4*z + 
     0.008481045060974917*u*y4*z + 0.010434137632162098*lnbara*u*y4*z - 
     0.010928241914554696*x*y4*z + 0.03790109796358698*y5*z + 
     0.02276428689740073*lnbara*y5*z + 0.09674690326970145*z2 + 
     0.26036425377018035*lnbara*z2 - 0.25*lnbara2*z2 - 
     0.5795775680424228*u*z2 - 0.6666666666666666*lnbara*u*z2 + 
     0.2170750372681229*u2*z2 + 0.27072850754036076*lnbara*u2*z2 - 
     0.07791894659092861*u3*z2 - 0.08021585408603281*lnbara*u3*z2 + 
     0.01286246693586746*u4*z2 + 0.011178565512996366*lnbara*u4*z2 + 
     0.7801897192079899*x*z2 - 0.25*u*x*z2 + 0.06224186270550523*u2*x*
      z2 - 0.007736900085251058*u3*x*z2 - 0.21014228940599236*x2*z2 + 
     0.03941460299602286*u*x2*z2 - 0.00408511380731101*u2*x2*z2 + 
     0.05398197007330707*x3*z2 - 0.004105687812085715*u*x3*z2 - 
     0.00704235352968079*x4*z2 - 0.5795775680424228*y*z2 - 
     0.6666666666666666*lnbara*y*z2 + 0.09260813876369418*u*y*z2 + 
     0.22927149245963926*lnbara*u*y*z2 - 0.028878257696179317*u2*y*z2 - 
     0.06016189056452461*lnbara*u2*y*z2 + 0.004856375702300316*u3*y*z2 + 
     0.007723814256269575*lnbara*u3*y*z2 - 0.25*x*y*z2 + 
     0.06501020096513857*u*x*y*z2 - 0.007650234579376865*u2*x*y*z2 + 
     0.03941460299602286*x2*y*z2 - 0.004536830598068991*u*x2*y*z2 - 
     0.004105687812085715*x3*y*z2 + 0.2170750372681229*y2*z2 + 
     0.27072850754036076*lnbara*y2*z2 - 0.028878257696179317*u*y2*z2 - 
     0.06016189056452461*lnbara*u*y2*z2 + 0.0036951190308771435*u2*y2*
      z2 + 0.00690950251345358*lnbara*u2*y2*z2 + 
     0.06224186270550523*x*y2*z2 - 0.007650234579376865*u*x*y2*z2 - 
     0.00408511380731101*x2*y2*z2 - 0.07791894659092861*y3*z2 - 
     0.08021585408603281*lnbara*y3*z2 + 0.004856375702300316*u*y3*z2 + 
     0.007723814256269575*lnbara*u*y3*z2 - 0.007736900085251058*x*y3*z2 + 
     0.01286246693586746*y4*z2 + 0.011178565512996366*lnbara*y4*z2 - 
     0.0026740654006500216*z3 + 0.09729210608420395*lnbara*z3 + 
     0.3333333333333333*lnbara2*z3 + 0.4873248302757761*u*z3 + 
     0.40975716415321306*lnbara*u*z3 - 0.07791894659092861*u2*z3 - 
     0.08021585408603281*lnbara*u2*z3 + 0.009783201076803173*u3*z3 + 
     0.009259259259259259*lnbara*u3*z3 - 0.47342819293732824*x*z3 + 
     0.07722562254393509*u*x*z3 - 0.007736900085251058*u2*x*z3 + 
     0.059836487533339255*x2*z3 - 0.004796827115691569*u*x2*z3 - 
     0.005867060110137494*x3*z3 + 0.4873248302757761*y*z3 + 
     0.40975716415321306*lnbara*y*z3 - 0.04490448256926989*u*y*z3 - 
     0.0726318075537267*lnbara*u*y*z3 + 0.004856375702300316*u2*y*z3 + 
     0.007723814256269575*lnbara*u2*y*z3 + 0.07722562254393509*x*y*z3 - 
     0.008445200483831043*u*x*y*z3 - 0.004796827115691569*x2*y*z3 - 
     0.07791894659092861*y2*z3 - 0.08021585408603281*lnbara*y2*z3 + 
     0.004856375702300316*u*y2*z3 + 0.007723814256269575*lnbara*u*y2*z3 - 
     0.007736900085251058*x*y2*z3 + 0.009783201076803173*y3*z3 + 
     0.009259259259259259*lnbara*y3*z3 - 0.12329981785306848*z4 - 
     0.2778476616397595*lnbara*z4 - 0.25*lnbara2*z4 - 
     0.21278322683609005*u*z4 - 0.14661270314515845*lnbara*u*z4 + 
     0.01286246693586746*u2*z4 + 0.011178565512996366*lnbara*u2*z4 + 
     0.16818304143002696*x*z4 - 0.010928241914554696*u*x*z4 - 
     0.00816041324288591*x2*z4 - 0.21278322683609005*y*z4 - 
     0.14661270314515845*lnbara*y*z4 + 0.008481045060974917*u*y*z4 + 
     0.010434137632162098*lnbara*u*y*z4 - 0.010928241914554696*x*y*z4 + 
     0.01286246693586746*y2*z4 + 0.011178565512996366*lnbara*y2*z4 + 
     0.10079660958965803*z5 + 0.16978414591396718*lnbara*z5 + 
     0.1*lnbara2*z5 + 0.03790109796358698*u*z5 + 
     0.02276428689740073*lnbara*u*z5 - 0.02600114622302915*x*z5 + 
     0.03790109796358698*y*z5 + 0.02276428689740073*lnbara*y*z5 - 
     0.02509960988230047*z6 - 0.035885453284794776*lnbara*z6 - 
     0.016666666666666666*lnbara2*z6;
 
  Fbarexp[7] = -0.11053505893569393 + 0.1869047619047619*lnbara - 
     0.03571428571428571*lnbara2 + 0.033841063442545095*u - 
     0.38055555555555554*lnbara*u + 0.08333333333333333*lnbara2*u + 
     0.04467405251566538*u2 + 0.3603642537701804*lnbara*u2 - 
     0.25*lnbara2*u2 - 0.027665608271863516*u3 - 
     0.04505153406141173*lnbara*u3 + 0.4166666666666667*lnbara2*u3 - 
     0.11288380920852763*u4 - 0.29641276939959915*lnbara*u4 - 
     0.4166666666666667*lnbara2*u4 + 0.16709945101716145*u5 + 
     0.32446036478491797*lnbara*u5 + 0.25*lnbara2*u5 - 
     0.08961259612670759*u6 - 0.14609393309064053*lnbara*u6 - 
     0.08333333333333333*lnbara2*u6 + 0.017552526521994072*u7 + 
     0.025294799938732206*lnbara*u7 + 0.011904761904761904*lnbara2*u7 + 
     0.6722222222222223*x - 0.16666666666666666*lnbara*x - 
     0.9316459611845606*u*x + 0.9752371490099873*u2*x - 
     0.7890469882288804*u3*x + 0.4204576035750674*u4*x - 
     0.13000573111514574*u5*x + 0.01763709312218411*u6*x - 
     0.6191977248898258*x2 + 0.5*lnbara*x2 + 0.7018651651305952*u*x2 - 
     0.35023714900998726*u2*x2 + 0.14959121883334814*u3*x2 - 
     0.04080206621442954*u4*x2 + 0.005109481838882987*u5*x2 + 
     0.3301310430191146*x3 - 0.8333333333333334*lnbara*x3 - 
     0.5191535535074602*u*x3 + 0.13495492518326768*u2*x3 - 
     0.029335300550687473*u3*x3 + 0.0032290651917485417*u4*x3 + 
     0.05923412211148055*x4 + 0.8333333333333334*lnbara*x4 + 
     0.2668990274900491*u*x4 - 0.03521176764840395*u2*x4 + 
     0.0030845212777298402*u3*x4 - 0.1956798897609178*x5 - 
     0.5*lnbara*x5 - 0.08103467712428472*u*x5 + 0.004307156641639393*u2*
      x5 + 0.1057439684824483*x6 + 0.16666666666666666*lnbara*x6 + 
     0.010875415763170257*u*x6 - 0.01976717368170844*x7 - 
     0.023809523809523808*lnbara*x7 + 0.033841063442545095*y - 
     0.38055555555555554*lnbara*y + 0.08333333333333333*lnbara2*y + 
     0.3196257377489796*u*y + 0.7813024128964863*lnbara*u*y - 
     0.5578052933863618*u2*y - 0.8333333333333334*lnbara*u2*y + 
     0.6756223290752225*u3*y + 0.6829286069220218*lnbara*u3*y - 
     0.4586517155176459*u4*y - 0.36653175786289616*lnbara*u4*y + 
     0.16674120292053418*u5*y + 0.11382143448700363*lnbara*u5*y - 
     0.02544609132471751*u6*y - 0.01548483324024246*lnbara*u6*y - 
     0.9316459611845606*x*y + 0.652012588820819*u*x*y - 
     0.4166666666666667*u2*x*y + 0.1930640563598377*u3*x*y - 
     0.05464120957277348*u4*x*y + 0.006982104352137553*u5*x*y + 
     0.7018651651305952*x2*y - 0.27476285099001274*u*x2*y + 
     0.09853650749005716*u2*x2*y - 0.023984135578457844*u3*x2*y + 
     0.0027837307223844915*u4*x2*y - 0.5191535535074602*x3*y + 
     0.10997735009782438*u*x3*y - 0.020528439060428574*u2*x3*y + 
     0.002040477336386972*u3*x3*y + 0.2668990274900491*x4*y - 
     0.02910056703093335*u*x4*y + 0.0022112103035087306*u2*x4*y - 
     0.08103467712428472*x5*y + 0.003583934630992194*u*x5*y + 
     0.010875415763170257*x6*y + 0.04467405251566538*y2 + 
     0.3603642537701804*lnbara*y2 - 0.25*lnbara2*y2 - 
     0.5578052933863618*u*y2 - 0.8333333333333334*lnbara*u*y2 + 
     0.27154889293341794*u2*y2 + 0.4512141792339346*lnbara*u2*y2 - 
     0.15468943943430513*u3*y2 - 0.20053963521508203*lnbara*u3*y2 + 
     0.05313376916634094*u4*y2 + 0.055892827564981824*lnbara*u4*y2 - 
     0.007891091272631587*u5*y2 - 0.00709100055854524*lnbara*u5*y2 + 
     0.9752371490099873*x*y2 - 0.4166666666666667*u*x*y2 + 
     0.1556046567637631*u2*x*y2 - 0.03868450042625529*u3*x*y2 + 
     0.004544934602470172*u4*x*y2 - 0.35023714900998726*x2*y2 + 
     0.09853650749005716*u*x2*y2 - 0.02042556903655505*u2*x2*y2 + 
     0.002132338931514418*u3*x2*y2 + 0.13495492518326768*x3*y2 - 
     0.020528439060428574*u*x3*y2 + 0.0017732108200787678*u2*x3*y2 - 
     0.03521176764840395*x4*y2 + 0.0022112103035087306*u*x4*y2 + 
     0.004307156641639393*x5*y2 - 0.027665608271863516*y3 - 
     0.04505153406141173*lnbara*y3 + 0.4166666666666667*lnbara2*y3 + 
     0.6756223290752225*u*y3 + 0.6829286069220218*lnbara*u*y3 - 
     0.15468943943430513*u2*y3 - 0.20053963521508203*lnbara*u2*y3 + 
     0.03965674612475661*u3*y3 + 0.046296296296296294*lnbara*u3*y3 - 
     0.005180952390253439*u4*y3 - 0.005269398380875331*lnbara*u4*y3 - 
     0.7890469882288804*x*y3 + 0.1930640563598377*u*x*y3 - 
     0.03868450042625529*u2*x*y3 + 0.0039961640397661365*u3*x*y3 + 
     0.14959121883334814*x2*y3 - 0.023984135578457844*u*x2*y3 + 
     0.002132338931514418*u2*x2*y3 - 0.029335300550687473*x3*y3 + 
     0.002040477336386972*u*x3*y3 + 0.0030845212777298402*x4*y3 - 
     0.11288380920852763*y4 - 0.29641276939959915*lnbara*y4 - 
     0.4166666666666667*lnbara2*y4 - 0.4586517155176459*u*y4 - 
     0.36653175786289616*lnbara*u*y4 + 0.05313376916634094*u2*y4 + 
     0.055892827564981824*lnbara*u2*y4 - 0.005180952390253439*u3*y4 - 
     0.005269398380875331*lnbara*u3*y4 + 0.4204576035750674*x*y4 - 
     0.05464120957277348*u*x*y4 + 0.004544934602470172*u2*x*y4 - 
     0.04080206621442954*x2*y4 + 0.0027837307223844915*u*x2*y4 + 
     0.0032290651917485417*x3*y4 + 0.16709945101716145*y5 + 
     0.32446036478491797*lnbara*y5 + 0.25*lnbara2*y5 + 
     0.16674120292053418*u*y5 + 0.11382143448700363*lnbara*u*y5 - 
     0.007891091272631587*u2*y5 - 0.00709100055854524*lnbara*u2*y5 - 
     0.13000573111514574*x*y5 + 0.006982104352137553*u*x*y5 + 
     0.005109481838882987*x2*y5 - 0.08961259612670759*y6 - 
     0.14609393309064053*lnbara*y6 - 0.08333333333333333*lnbara2*y6 - 
     0.02544609132471751*u*y6 - 0.01548483324024246*lnbara*u*y6 + 
     0.01763709312218411*x*y6 + 0.017552526521994072*y7 + 
     0.025294799938732206*lnbara*y7 + 0.011904761904761904*lnbara2*y7 + 
     0.033841063442545095*z - 0.38055555555555554*lnbara*z + 
     0.08333333333333333*lnbara2*z + 0.3196257377489796*u*z + 
     0.7813024128964863*lnbara*u*z - 0.5578052933863618*u2*z - 
     0.8333333333333334*lnbara*u2*z + 0.6756223290752225*u3*z + 
     0.6829286069220218*lnbara*u3*z - 0.4586517155176459*u4*z - 
     0.36653175786289616*lnbara*u4*z + 0.16674120292053418*u5*z + 
     0.11382143448700363*lnbara*u5*z - 0.02544609132471751*u6*z - 
     0.01548483324024246*lnbara*u6*z - 0.9316459611845606*x*z + 
     0.652012588820819*u*x*z - 0.4166666666666667*u2*x*z + 
     0.1930640563598377*u3*x*z - 0.05464120957277348*u4*x*z + 
     0.006982104352137553*u5*x*z + 0.7018651651305952*x2*z - 
     0.27476285099001274*u*x2*z + 0.09853650749005716*u2*x2*z - 
     0.023984135578457844*u3*x2*z + 0.0027837307223844915*u4*x2*z - 
     0.5191535535074602*x3*z + 0.10997735009782438*u*x3*z - 
     0.020528439060428574*u2*x3*z + 0.002040477336386972*u3*x3*z + 
     0.2668990274900491*x4*z - 0.02910056703093335*u*x4*z + 
     0.0022112103035087306*u2*x4*z - 0.08103467712428472*x5*z + 
     0.003583934630992194*u*x5*z + 0.010875415763170257*x6*z + 
     0.3196257377489796*y*z + 0.7813024128964863*lnbara*y*z - 
     0.018920104020269873*u*y*z - 0.5731787311490981*lnbara*u*y*z + 
     0.07792306711961054*u2*y*z + 0.3821191540993988*lnbara*u2*y*z - 
     0.07594530264631137*u3*y*z - 0.18157951888431673*lnbara*u3*y*z + 
     0.031971087672712485*u4*y*z + 0.0521706881608105*lnbara*u4*y*z - 
     0.005264576779103489*u5*y*z - 0.006730433928458395*lnbara*u5*y*z + 
     0.652012588820819*x*y*z - 0.3918579866365838*u*x*y*z + 
     0.1625255024128464*u2*x*y*z - 0.04222600241915521*u3*x*y*z + 
     0.005073357162376386*u4*x*y*z - 0.27476285099001274*x2*y*z + 
     0.10021047271633643*u*x2*y*z - 0.022684152990344954*u2*x2*y*z + 
     0.002463102816730127*u3*x2*y*z + 0.10997735009782438*x3*y*z - 
     0.021438675830201044*u*x3*y*z + 0.002015744197075201*u2*x3*y*z - 
     0.02910056703093335*x4*y*z + 0.0023360526619374596*u*x4*y*z + 
     0.003583934630992194*x5*y*z - 0.5578052933863618*y2*z - 
     0.8333333333333334*lnbara*y2*z + 0.07792306711961054*u*y2*z + 
     0.3821191540993988*lnbara*u*y2*z - 0.04211469895818599*u2*y2*z - 
     0.15040472641131153*lnbara*u2*y2*z + 0.016558064255232003*u3*y2*z + 
     0.03861907128134787*lnbara*u3*y2*z - 0.002680390234892856*u4*y2*z - 
     0.004629629629629629*lnbara*u4*y2*z - 0.4166666666666667*x*y2*z + 
     0.1625255024128464*u*x*y2*z - 0.038251172896884324*u2*x*y2*z + 
     0.004251592034047353*u3*x*y2*z + 0.09853650749005716*x2*y2*z - 
     0.022684152990344954*u*x2*y2*z + 0.002311902987232243*u2*x2*y2*z - 
     0.020528439060428574*x3*y2*z + 0.002015744197075201*u*x3*y2*z + 
     0.0022112103035087306*x4*y2*z + 0.6756223290752225*y3*z + 
     0.6829286069220218*lnbara*y3*z - 0.07594530264631137*u*y3*z - 
     0.18157951888431673*lnbara*u*y3*z + 0.016558064255232003*u2*y3*z + 
     0.03861907128134787*lnbara*u2*y3*z - 0.0022052910424952363*u3*y3*z - 
     0.004141109249293644*lnbara*u3*y3*z + 0.1930640563598377*x*y3*z - 
     0.04222600241915521*u*x*y3*z + 0.004251592034047353*u2*x*y3*z - 
     0.023984135578457844*x2*y3*z + 0.002463102816730127*u*x2*y3*z + 
     0.002040477336386972*x3*y3*z - 0.4586517155176459*y4*z - 
     0.36653175786289616*lnbara*y4*z + 0.031971087672712485*u*y4*z + 
     0.0521706881608105*lnbara*u*y4*z - 0.002680390234892856*u2*y4*z - 
     0.004629629629629629*lnbara*u2*y4*z - 0.05464120957277348*x*y4*z + 
     0.005073357162376386*u*x*y4*z + 0.0027837307223844915*x2*y4*z + 
     0.16674120292053418*y5*z + 0.11382143448700363*lnbara*y5*z - 
     0.005264576779103489*u*y5*z - 0.006730433928458395*lnbara*u*y5*z + 
     0.006982104352137553*x*y5*z - 0.02544609132471751*y6*z - 
     0.01548483324024246*lnbara*y6*z + 0.04467405251566538*z2 + 
     0.3603642537701804*lnbara*z2 - 0.25*lnbara2*z2 - 
     0.5578052933863618*u*z2 - 0.8333333333333334*lnbara*u*z2 + 
     0.27154889293341794*u2*z2 + 0.4512141792339346*lnbara*u2*z2 - 
     0.15468943943430513*u3*z2 - 0.20053963521508203*lnbara*u3*z2 + 
     0.05313376916634094*u4*z2 + 0.055892827564981824*lnbara*u4*z2 - 
     0.007891091272631587*u5*z2 - 0.00709100055854524*lnbara*u5*z2 + 
     0.9752371490099873*x*z2 - 0.4166666666666667*u*x*z2 + 
     0.1556046567637631*u2*x*z2 - 0.03868450042625529*u3*x*z2 + 
     0.004544934602470172*u4*x*z2 - 0.35023714900998726*x2*z2 + 
     0.09853650749005716*u*x2*z2 - 0.02042556903655505*u2*x2*z2 + 
     0.002132338931514418*u3*x2*z2 + 0.13495492518326768*x3*z2 - 
     0.020528439060428574*u*x3*z2 + 0.0017732108200787678*u2*x3*z2 - 
     0.03521176764840395*x4*z2 + 0.0022112103035087306*u*x4*z2 + 
     0.004307156641639393*x5*z2 - 0.5578052933863618*y*z2 - 
     0.8333333333333334*lnbara*y*z2 + 0.07792306711961054*u*y*z2 + 
     0.3821191540993988*lnbara*u*y*z2 - 0.04211469895818599*u2*y*z2 - 
     0.15040472641131153*lnbara*u2*y*z2 + 0.016558064255232003*u3*y*z2 + 
     0.03861907128134787*lnbara*u3*y*z2 - 0.002680390234892856*u4*y*z2 - 
     0.004629629629629629*lnbara*u4*y*z2 - 0.4166666666666667*x*y*z2 + 
     0.1625255024128464*u*x*y*z2 - 0.038251172896884324*u2*x*y*z2 + 
     0.004251592034047353*u3*x*y*z2 + 0.09853650749005716*x2*y*z2 - 
     0.022684152990344954*u*x2*y*z2 + 0.002311902987232243*u2*x2*y*z2 - 
     0.020528439060428574*x3*y*z2 + 0.002015744197075201*u*x3*y*z2 + 
     0.0022112103035087306*x4*y*z2 + 0.27154889293341794*y2*z2 + 
     0.4512141792339346*lnbara*y2*z2 - 0.04211469895818599*u*y2*z2 - 
     0.15040472641131153*lnbara*u*y2*z2 + 0.011566092640932137*u2*y2*
      z2 + 0.0345475125672679*lnbara*u2*y2*z2 - 
     0.001736111111111111*u3*y2*z2 - 0.003838612507474211*lnbara*u3*y2*
      z2 + 0.1556046567637631*x*y2*z2 - 0.038251172896884324*u*x*y2*z2 + 
     0.004058907359067862*u2*x*y2*z2 - 0.02042556903655505*x2*y2*z2 + 
     0.002311902987232243*u*x2*y2*z2 + 0.0017732108200787678*x3*y2*z2 - 
     0.15468943943430513*y3*z2 - 0.20053963521508203*lnbara*y3*z2 + 
     0.016558064255232003*u*y3*z2 + 0.03861907128134787*lnbara*u*y3*z2 - 
     0.001736111111111111*u2*y3*z2 - 0.003838612507474211*lnbara*u2*y3*
      z2 - 0.03868450042625529*x*y3*z2 + 0.004251592034047353*u*x*y3*
      z2 + 0.002132338931514418*x2*y3*z2 + 0.05313376916634094*y4*z2 + 
     0.055892827564981824*lnbara*y4*z2 - 0.002680390234892856*u*y4*z2 - 
     0.004629629629629629*lnbara*u*y4*z2 + 0.004544934602470172*x*y4*z2 - 
     0.007891091272631587*y5*z2 - 0.00709100055854524*lnbara*y5*z2 - 
     0.027665608271863516*z3 - 0.04505153406141173*lnbara*z3 + 
     0.4166666666666667*lnbara2*z3 + 0.6756223290752225*u*z3 + 
     0.6829286069220218*lnbara*u*z3 - 0.15468943943430513*u2*z3 - 
     0.20053963521508203*lnbara*u2*z3 + 0.03965674612475661*u3*z3 + 
     0.046296296296296294*lnbara*u3*z3 - 0.005180952390253439*u4*z3 - 
     0.005269398380875331*lnbara*u4*z3 - 0.7890469882288804*x*z3 + 
     0.1930640563598377*u*x*z3 - 0.03868450042625529*u2*x*z3 + 
     0.0039961640397661365*u3*x*z3 + 0.14959121883334814*x2*z3 - 
     0.023984135578457844*u*x2*z3 + 0.002132338931514418*u2*x2*z3 - 
     0.029335300550687473*x3*z3 + 0.002040477336386972*u*x3*z3 + 
     0.0030845212777298402*x4*z3 + 0.6756223290752225*y*z3 + 
     0.6829286069220218*lnbara*y*z3 - 0.07594530264631137*u*y*z3 - 
     0.18157951888431673*lnbara*u*y*z3 + 0.016558064255232003*u2*y*z3 + 
     0.03861907128134787*lnbara*u2*y*z3 - 0.0022052910424952363*u3*y*z3 - 
     0.004141109249293644*lnbara*u3*y*z3 + 0.1930640563598377*x*y*z3 - 
     0.04222600241915521*u*x*y*z3 + 0.004251592034047353*u2*x*y*z3 - 
     0.023984135578457844*x2*y*z3 + 0.002463102816730127*u*x2*y*z3 + 
     0.002040477336386972*x3*y*z3 - 0.15468943943430513*y2*z3 - 
     0.20053963521508203*lnbara*y2*z3 + 0.016558064255232003*u*y2*z3 + 
     0.03861907128134787*lnbara*u*y2*z3 - 0.001736111111111111*u2*y2*
      z3 - 0.003838612507474211*lnbara*u2*y2*z3 - 
     0.03868450042625529*x*y2*z3 + 0.004251592034047353*u*x*y2*z3 + 
     0.002132338931514418*x2*y2*z3 + 0.03965674612475661*y3*z3 + 
     0.046296296296296294*lnbara*y3*z3 - 0.0022052910424952363*u*y3*z3 - 
     0.004141109249293644*lnbara*u*y3*z3 + 0.0039961640397661365*x*y3*
      z3 - 0.005180952390253439*y4*z3 - 0.005269398380875331*lnbara*y4*
      z3 - 0.11288380920852763*z4 - 0.29641276939959915*lnbara*z4 - 
     0.4166666666666667*lnbara2*z4 - 0.4586517155176459*u*z4 - 
     0.36653175786289616*lnbara*u*z4 + 0.05313376916634094*u2*z4 + 
     0.055892827564981824*lnbara*u2*z4 - 0.005180952390253439*u3*z4 - 
     0.005269398380875331*lnbara*u3*z4 + 0.4204576035750674*x*z4 - 
     0.05464120957277348*u*x*z4 + 0.004544934602470172*u2*x*z4 - 
     0.04080206621442954*x2*z4 + 0.0027837307223844915*u*x2*z4 + 
     0.0032290651917485417*x3*z4 - 0.4586517155176459*y*z4 - 
     0.36653175786289616*lnbara*y*z4 + 0.031971087672712485*u*y*z4 + 
     0.0521706881608105*lnbara*u*y*z4 - 0.002680390234892856*u2*y*z4 - 
     0.004629629629629629*lnbara*u2*y*z4 - 0.05464120957277348*x*y*z4 + 
     0.005073357162376386*u*x*y*z4 + 0.0027837307223844915*x2*y*z4 + 
     0.05313376916634094*y2*z4 + 0.055892827564981824*lnbara*y2*z4 - 
     0.002680390234892856*u*y2*z4 - 0.004629629629629629*lnbara*u*y2*z4 + 
     0.004544934602470172*x*y2*z4 - 0.005180952390253439*y3*z4 - 
     0.005269398380875331*lnbara*y3*z4 + 0.16709945101716145*z5 + 
     0.32446036478491797*lnbara*z5 + 0.25*lnbara2*z5 + 
     0.16674120292053418*u*z5 + 0.11382143448700363*lnbara*u*z5 - 
     0.007891091272631587*u2*z5 - 0.00709100055854524*lnbara*u2*z5 - 
     0.13000573111514574*x*z5 + 0.006982104352137553*u*x*z5 + 
     0.005109481838882987*x2*z5 + 0.16674120292053418*y*z5 + 
     0.11382143448700363*lnbara*y*z5 - 0.005264576779103489*u*y*z5 - 
     0.006730433928458395*lnbara*u*y*z5 + 0.006982104352137553*x*y*z5 - 
     0.007891091272631587*y2*z5 - 0.00709100055854524*lnbara*y2*z5 - 
     0.08961259612670759*z6 - 0.14609393309064053*lnbara*z6 - 
     0.08333333333333333*lnbara2*z6 - 0.02544609132471751*u*z6 - 
     0.01548483324024246*lnbara*u*z6 + 0.01763709312218411*x*z6 - 
     0.02544609132471751*y*z6 - 0.01548483324024246*lnbara*y*z6 + 
     0.017552526521994072*z7 + 0.025294799938732206*lnbara*z7 + 
     0.011904761904761904*lnbara2*z7;
 
  Fbarexp[8] = -0.10626438943986569 + 0.14910714285714285*lnbara - 
     0.026785714285714284*lnbara2 + 0.08337170517297515*u - 0.35*lnbara*u + 
     0.07142857142857142*lnbara2*u - 0.015386656446031351*u2 + 
     0.4436975871035137*lnbara*u2 - 0.25*lnbara2*u2 - 
     0.02418842311395387*u3 - 0.22072850754036075*lnbara*u3 + 
     0.5*lnbara2*u3 - 0.09522252146289166*u4 - 0.23628582076606544*lnbara*
      u4 - 0.625*lnbara2*u4 + 0.22604544710601693*u5 + 
     0.4822540629031693*lnbara*u5 + 0.5*lnbara2*u5 - 
     0.1957908218348025*u6 - 0.35494846593858825*lnbara*u6 - 
     0.25*lnbara2*u6 + 0.08002035919323222*u7 + 0.12795927582286945*lnbara*
      u7 + 0.07142857142857142*lnbara2*u7 - 0.012974162169876576*u8 - 
     0.01879653368685981*lnbara*u8 - 0.008928571428571428*lnbara2*u8 + 
     0.6*x - 0.14285714285714285*lnbara*x - 0.9316459611845606*u*x + 
     1.1702845788119847*u2*x - 1.1835704823433206*u3*x + 
     0.8409152071501348*u4*x - 0.3900171933454372*u5*x + 
     0.10582255873310466*u6*x - 0.012739270908917709*u7*x - 
     0.7025310582231592*x2 + 0.5*lnbara*x2 + 0.8422381981567142*u*x2 - 
     0.5253557235149809*u2*x2 + 0.2991824376666963*u3*x2 - 
     0.12240619864328864*u4*x2 + 0.030656891033297922*u5*x2 - 
     0.0034920303557606663*u6*x2 + 0.5628239182896042*x3 - 1.*lnbara*x3 - 
     0.7787303302611903*u*x3 + 0.26990985036653536*u2*x3 - 
     0.08800590165206242*u3*x3 + 0.019374391150491253*u4*x3 - 
     0.002032085124576991*u5*x3 - 0.11948215016611251*x4 + 
     1.25*lnbara*x4 + 0.5337980549800982*u*x4 - 0.10563530294521185*u2*
      x4 + 0.01850712766637904*u3*x4 - 0.0017045245923250636*u4*x4 - 
     0.2246931128551689*x5 - 1.*lnbara*x5 - 0.24310403137285416*u*x5 + 
     0.02584293984983636*u2*x5 - 0.0018937975809947979*u3*x5 + 
     0.23389857211401155*x6 + 0.5*lnbara*x6 + 0.06525249457902155*u*x6 - 
     0.002902179150693661*u2*x6 - 0.09479351828072682*x7 - 
     0.14285714285714285*lnbara*x7 - 0.007799923166908395*u*x7 + 
     0.014774160972681501*x8 + 0.017857142857142856*lnbara*x8 + 
     0.08337170517297515*y - 0.35*lnbara*y + 0.07142857142857142*lnbara2*y + 
     0.18940866893289857*u*y + 0.7813024128964863*lnbara*u*y - 
     0.5026996853969675*u2*y - 1.*lnbara*u2*y + 0.8427013418823283*u3*y + 
     1.0243929103830327*lnbara*u3*y - 0.7951261784143264*u4*y - 
     0.7330635157257923*lnbara*u4*y + 0.4433128915181007*u5*y + 
     0.3414643034610109*lnbara*u5*y - 0.1371917147080626*u6*y - 
     0.09290899944145475*lnbara*u6*y + 0.018256104537349046*u7*y + 
     0.011206496836004519*lnbara*u7*y - 0.9316459611845606*x*y + 
     0.7824151065849828*u*x*y - 0.625*u2*x*y + 0.3861281127196754*u3*x*y - 
     0.16392362871832045*u4*x*y + 0.041892626112825314*u5*x*y - 
     0.0048318008295796825*u6*x*y + 0.8422381981567142*x2*y - 
     0.4121442764850191*u*x2*y + 0.1970730149801143*u2*x2*y - 
     0.07195240673537354*u3*x2*y + 0.01670238433430695*u4*x2*y - 
     0.0018042267625014755*u5*x2*y - 0.7787303302611903*x3*y + 
     0.21995470019564875*u*x3*y - 0.06158531718128572*u2*x3*y + 
     0.012242864018321833*u3*x3*y - 0.0011979335791530209*u4*x3*y + 
     0.5337980549800982*x4*y - 0.08730170109280005*u*x4*y + 
     0.013267261821052385*u2*x4*y - 0.0011100206960523984*u3*x4*y - 
     0.24310403137285416*x5*y + 0.02150360778595316*u*x5*y - 
     0.0013742361013450004*u2*x5*y + 0.06525249457902155*x6*y - 
     0.002424337054637728*u*x6*y - 0.007799923166908395*x7*y - 
     0.015386656446031351*y2 + 0.4436975871035137*lnbara*y2 - 
     0.25*lnbara2*y2 - 0.5026996853969675*u*y2 - 1.*lnbara*u*y2 + 
     0.29451979459164324*u2*y2 + 0.6768212688509019*lnbara*u2*y2 - 
     0.24253233379691627*u3*y2 - 0.40107927043016406*lnbara*u3*y2 + 
     0.1314548937165319*u4*y2 + 0.16767848269494548*lnbara*u4*y2 - 
     0.04025554707724428*u5*y2 - 0.04254600335127144*lnbara*u5*y2 + 
     0.005326516205331389*u6*y2 + 0.004887855481301699*lnbara*u6*y2 + 
     1.1702845788119847*x*y2 - 0.625*u*x*y2 + 0.3112093135275262*u2*x*
      y2 - 0.11605350127876586*u3*x*y2 + 0.027269607614821036*u4*x*y2 - 
     0.002968292254510239*u5*x*y2 - 0.5253557235149809*x2*y2 + 
     0.1970730149801143*u*x2*y2 - 0.06127670710966516*u2*x2*y2 + 
     0.012794033589086507*u3*x2*y2 - 0.0012856369475801259*u4*x2*y2 + 
     0.26990985036653536*x3*y2 - 0.06158531718128572*u*x3*y2 + 
     0.010639264920472607*u2*x3*y2 - 0.0009464600952786589*u3*x3*y2 - 
     0.10563530294521185*x4*y2 + 0.013267261821052385*u*x4*y2 - 
     0.0009735837207608611*u2*x4*y2 + 0.02584293984983636*x5*y2 - 
     0.0013742361013450004*u*x5*y2 - 0.002902179150693661*x6*y2 - 
     0.02418842311395387*y3 - 0.22072850754036075*lnbara*y3 + 
     0.5*lnbara2*y3 + 0.8427013418823283*u*y3 + 1.0243929103830327*lnbara*
      u*y3 - 0.24253233379691627*u2*y3 - 0.40107927043016406*lnbara*u2*
      y3 + 0.09582209022612168*u3*y3 + 0.1388888888888889*lnbara*u3*y3 - 
     0.025816315960645302*u4*y3 - 0.03161639028525199*lnbara*u4*y3 + 
     0.0031926388953996293*u5*y3 + 0.003384978503667747*lnbara*u5*y3 - 
     1.1835704823433206*x*y3 + 0.3861281127196754*u*x*y3 - 
     0.11605350127876586*u2*x*y3 + 0.02397698423859682*u3*x*y3 - 
     0.0024003011749299604*u4*x*y3 + 0.2991824376666963*x2*y3 - 
     0.07195240673537354*u*x2*y3 + 0.012794033589086507*u2*x2*y3 - 
     0.0011574074074074073*u3*x2*y3 - 0.08800590165206242*x3*y3 + 
     0.012242864018321833*u*x3*y3 - 0.0009464600952786589*u2*x3*y3 + 
     0.01850712766637904*x4*y3 - 0.0011100206960523984*u*x4*y3 - 
     0.0018937975809947979*x5*y3 - 0.09522252146289166*y4 - 
     0.23628582076606544*lnbara*y4 - 0.625*lnbara2*y4 - 
     0.7951261784143264*u*y4 - 0.7330635157257923*lnbara*u*y4 + 
     0.1314548937165319*u2*y4 + 0.16767848269494548*lnbara*u2*y4 - 
     0.025816315960645302*u3*y4 - 0.03161639028525199*lnbara*u3*y4 + 
     0.0027549479207358792*u4*y4 + 0.0030360036294498475*lnbara*u4*y4 + 
     0.8409152071501348*x*y4 - 0.16392362871832045*u*x*y4 + 
     0.027269607614821036*u2*x*y4 - 0.0024003011749299604*u3*x*y4 - 
     0.12240619864328864*x2*y4 + 0.01670238433430695*u*x2*y4 - 
     0.0012856369475801259*u2*x2*y4 + 0.019374391150491253*x3*y4 - 
     0.0011979335791530209*u*x3*y4 - 0.0017045245923250636*x4*y4 + 
     0.22604544710601693*y5 + 0.4822540629031693*lnbara*y5 + 
     0.5*lnbara2*y5 + 0.4433128915181007*u*y5 + 0.3414643034610109*lnbara*
      u*y5 - 0.04025554707724428*u2*y5 - 0.04254600335127144*lnbara*u2*
      y5 + 0.0031926388953996293*u3*y5 + 0.003384978503667747*lnbara*u3*
      y5 - 0.3900171933454372*x*y5 + 0.041892626112825314*u*x*y5 - 
     0.002968292254510239*u2*x*y5 + 0.030656891033297922*x2*y5 - 
     0.0018042267625014755*u*x2*y5 - 0.002032085124576991*x3*y5 - 
     0.1957908218348025*y6 - 0.35494846593858825*lnbara*y6 - 
     0.25*lnbara2*y6 - 0.1371917147080626*u*y6 - 
     0.09290899944145475*lnbara*u*y6 + 0.005326516205331389*u2*y6 + 
     0.004887855481301699*lnbara*u2*y6 + 0.10582255873310466*x*y6 - 
     0.0048318008295796825*u*x*y6 - 0.0034920303557606663*x2*y6 + 
     0.08002035919323222*y7 + 0.12795927582286945*lnbara*y7 + 
     0.07142857142857142*lnbara2*y7 + 0.018256104537349046*u*y7 + 
     0.011206496836004519*lnbara*u*y7 - 0.012739270908917709*x*y7 - 
     0.012974162169876576*y8 - 0.01879653368685981*lnbara*y8 - 
     0.008928571428571428*lnbara2*y8 + 0.08337170517297515*z - 
     0.35*lnbara*z + 0.07142857142857142*lnbara2*z + 
     0.18940866893289857*u*z + 0.7813024128964863*lnbara*u*z - 
     0.5026996853969675*u2*z - 1.*lnbara*u2*z + 0.8427013418823283*u3*z + 
     1.0243929103830327*lnbara*u3*z - 0.7951261784143264*u4*z - 
     0.7330635157257923*lnbara*u4*z + 0.4433128915181007*u5*z + 
     0.3414643034610109*lnbara*u5*z - 0.1371917147080626*u6*z - 
     0.09290899944145475*lnbara*u6*z + 0.018256104537349046*u7*z + 
     0.011206496836004519*lnbara*u7*z - 0.9316459611845606*x*z + 
     0.7824151065849828*u*x*z - 0.625*u2*x*z + 0.3861281127196754*u3*x*z - 
     0.16392362871832045*u4*x*z + 0.041892626112825314*u5*x*z - 
     0.0048318008295796825*u6*x*z + 0.8422381981567142*x2*z - 
     0.4121442764850191*u*x2*z + 0.1970730149801143*u2*x2*z - 
     0.07195240673537354*u3*x2*z + 0.01670238433430695*u4*x2*z - 
     0.0018042267625014755*u5*x2*z - 0.7787303302611903*x3*z + 
     0.21995470019564875*u*x3*z - 0.06158531718128572*u2*x3*z + 
     0.012242864018321833*u3*x3*z - 0.0011979335791530209*u4*x3*z + 
     0.5337980549800982*x4*z - 0.08730170109280005*u*x4*z + 
     0.013267261821052385*u2*x4*z - 0.0011100206960523984*u3*x4*z - 
     0.24310403137285416*x5*z + 0.02150360778595316*u*x5*z - 
     0.0013742361013450004*u2*x5*z + 0.06525249457902155*x6*z - 
     0.002424337054637728*u*x6*z - 0.007799923166908395*x7*z + 
     0.18940866893289857*y*z + 0.7813024128964863*lnbara*y*z + 
     0.09193162140549578*u*y*z - 0.6878144773789178*lnbara*u*y*z + 
     0.02135481215456613*u2*y*z + 0.5731787311490981*lnbara*u2*y*z - 
     0.0913640989978505*u3*y*z - 0.36315903776863345*lnbara*u3*y*z + 
     0.06982791893773221*u4*y*z + 0.1565120644824315*lnbara*u4*y*z - 
     0.024857026746162542*u5*y*z - 0.040382603570750374*lnbara*u5*y*z + 
     0.0035777513655361887*u6*y*z + 0.004687810626819727*lnbara*u6*y*z + 
     0.7824151065849828*x*y*z - 0.5877869799548757*u*x*y*z + 
     0.3250510048256928*u2*x*y*z - 0.12667800725746564*u3*x*y*z + 
     0.03044014297425832*u4*x*y*z - 0.0033567831013237934*u5*x*y*z - 
     0.4121442764850191*x2*y*z + 0.20042094543267286*u*x2*y*z - 
     0.06805245897103486*u2*x2*y*z + 0.014778616900380764*u3*x2*y*z - 
     0.0015161758891802588*u4*x2*y*z + 0.21995470019564875*x3*y*z - 
     0.06431602749060313*u*x3*y*z + 0.012094465182451206*u2*x3*y*z - 
     0.001118126726942837*u3*x3*y*z - 0.08730170109280005*x4*y*z + 
     0.014016315971624758*u*x4*y*z - 0.0011188517846484648*u2*x4*y*z + 
     0.02150360778595316*x5*y*z - 0.0014606410527467938*u*x5*y*z - 
     0.002424337054637728*x6*y*z - 0.5026996853969675*y2*z - 
     1.*lnbara*y2*z + 0.02135481215456613*u*y2*z + 
     0.5731787311490981*lnbara*u*y2*z - 0.03409448911260147*u2*y2*z - 
     0.30080945282262306*lnbara*u2*y2*z + 0.030364657125022076*u3*y2*z + 
     0.11585721384404363*lnbara*u3*y2*z - 0.011452711779727507*u4*y2*z - 
     0.027777777777777776*lnbara*u4*y2*z + 0.001686825413567301*u5*y2*z + 
     0.0030639349524580017*lnbara*u5*y2*z - 0.625*x*y2*z + 
     0.3250510048256928*u*x*y2*z - 0.11475351869065298*u2*x*y2*z + 
     0.025509552204284115*u3*x*y2*z - 0.0026559689223197088*u4*x*y2*z + 
     0.1970730149801143*x2*y2*z - 0.06805245897103486*u*x2*y2*z + 
     0.013871417923393456*u2*x2*y2*z - 0.0013398832907078044*u3*x2*y2*
      z - 0.06158531718128572*x3*y2*z + 0.012094465182451206*u*x3*y2*z - 
     0.001066169465757209*u2*x3*y2*z + 0.013267261821052385*x4*y2*z - 
     0.0011188517846484648*u*x4*y2*z - 0.0013742361013450004*x5*y2*z + 
     0.8427013418823283*y3*z + 1.0243929103830327*lnbara*y3*z - 
     0.0913640989978505*u*y3*z - 0.36315903776863345*lnbara*u*y3*z + 
     0.030364657125022076*u2*y3*z + 0.11585721384404363*lnbara*u2*y3*z - 
     0.009090637005677775*u3*y3*z - 0.024846655495761868*lnbara*u3*y3*z + 
     0.001233630975633597*u4*y3*z + 0.0025474832491138625*lnbara*u4*y3*
      z + 0.3861281127196754*x*y3*z - 0.12667800725746564*u*x*y3*z + 
     0.025509552204284115*u2*x*y3*z - 0.0024597600243423225*u3*x*y3*z - 
     0.07195240673537354*x2*y3*z + 0.014778616900380764*u*x2*y3*z - 
     0.0013398832907078044*u2*x2*y3*z + 0.012242864018321833*x3*y3*z - 
     0.001118126726942837*u*x3*y3*z - 0.0011100206960523984*x4*y3*z - 
     0.7951261784143264*y4*z - 0.7330635157257923*lnbara*y4*z + 
     0.06982791893773221*u*y4*z + 0.1565120644824315*lnbara*u*y4*z - 
     0.011452711779727507*u2*y4*z - 0.027777777777777776*lnbara*u2*y4*z + 
     0.001233630975633597*u3*y4*z + 0.0025474832491138625*lnbara*u3*y4*
      z - 0.16392362871832045*x*y4*z + 0.03044014297425832*u*x*y4*z - 
     0.0026559689223197088*u2*x*y4*z + 0.01670238433430695*x2*y4*z - 
     0.0015161758891802588*u*x2*y4*z - 0.0011979335791530209*x3*y4*z + 
     0.4433128915181007*y5*z + 0.3414643034610109*lnbara*y5*z - 
     0.024857026746162542*u*y5*z - 0.040382603570750374*lnbara*u*y5*z + 
     0.001686825413567301*u2*y5*z + 0.0030639349524580017*lnbara*u2*y5*
      z + 0.041892626112825314*x*y5*z - 0.0033567831013237934*u*x*y5*z - 
     0.0018042267625014755*x2*y5*z - 0.1371917147080626*y6*z - 
     0.09290899944145475*lnbara*y6*z + 0.0035777513655361887*u*y6*z + 
     0.004687810626819727*lnbara*u*y6*z - 0.0048318008295796825*x*y6*z + 
     0.018256104537349046*y7*z + 0.011206496836004519*lnbara*y7*z - 
     0.015386656446031351*z2 + 0.4436975871035137*lnbara*z2 - 
     0.25*lnbara2*z2 - 0.5026996853969675*u*z2 - 1.*lnbara*u*z2 + 
     0.29451979459164324*u2*z2 + 0.6768212688509019*lnbara*u2*z2 - 
     0.24253233379691627*u3*z2 - 0.40107927043016406*lnbara*u3*z2 + 
     0.1314548937165319*u4*z2 + 0.16767848269494548*lnbara*u4*z2 - 
     0.04025554707724428*u5*z2 - 0.04254600335127144*lnbara*u5*z2 + 
     0.005326516205331389*u6*z2 + 0.004887855481301699*lnbara*u6*z2 + 
     1.1702845788119847*x*z2 - 0.625*u*x*z2 + 0.3112093135275262*u2*x*
      z2 - 0.11605350127876586*u3*x*z2 + 0.027269607614821036*u4*x*z2 - 
     0.002968292254510239*u5*x*z2 - 0.5253557235149809*x2*z2 + 
     0.1970730149801143*u*x2*z2 - 0.06127670710966516*u2*x2*z2 + 
     0.012794033589086507*u3*x2*z2 - 0.0012856369475801259*u4*x2*z2 + 
     0.26990985036653536*x3*z2 - 0.06158531718128572*u*x3*z2 + 
     0.010639264920472607*u2*x3*z2 - 0.0009464600952786589*u3*x3*z2 - 
     0.10563530294521185*x4*z2 + 0.013267261821052385*u*x4*z2 - 
     0.0009735837207608611*u2*x4*z2 + 0.02584293984983636*x5*z2 - 
     0.0013742361013450004*u*x5*z2 - 0.002902179150693661*x6*z2 - 
     0.5026996853969675*y*z2 - 1.*lnbara*y*z2 + 0.02135481215456613*u*y*
      z2 + 0.5731787311490981*lnbara*u*y*z2 - 0.03409448911260147*u2*y*
      z2 - 0.30080945282262306*lnbara*u2*y*z2 + 0.030364657125022076*u3*y*
      z2 + 0.11585721384404363*lnbara*u3*y*z2 - 0.011452711779727507*u4*y*
      z2 - 0.027777777777777776*lnbara*u4*y*z2 + 
     0.001686825413567301*u5*y*z2 + 0.0030639349524580017*lnbara*u5*y*
      z2 - 0.625*x*y*z2 + 0.3250510048256928*u*x*y*z2 - 
     0.11475351869065298*u2*x*y*z2 + 0.025509552204284115*u3*x*y*z2 - 
     0.0026559689223197088*u4*x*y*z2 + 0.1970730149801143*x2*y*z2 - 
     0.06805245897103486*u*x2*y*z2 + 0.013871417923393456*u2*x2*y*z2 - 
     0.0013398832907078044*u3*x2*y*z2 - 0.06158531718128572*x3*y*z2 + 
     0.012094465182451206*u*x3*y*z2 - 0.001066169465757209*u2*x3*y*z2 + 
     0.013267261821052385*x4*y*z2 - 0.0011188517846484648*u*x4*y*z2 - 
     0.0013742361013450004*x5*y*z2 + 0.29451979459164324*y2*z2 + 
     0.6768212688509019*lnbara*y2*z2 - 0.03409448911260147*u*y2*z2 - 
     0.30080945282262306*lnbara*u*y2*z2 + 0.017424521639162464*u2*y2*
      z2 + 0.10364253770180369*lnbara*u2*y2*z2 - 
     0.006578054159192456*u3*y2*z2 - 0.023031675044845268*lnbara*u3*y2*
      z2 + 0.0009868303536549605*u4*y2*z2 + 0.0024078266340730905*lnbara*
      u4*y2*z2 + 0.3112093135275262*x*y2*z2 - 0.11475351869065298*u*x*
      y2*z2 + 0.024353444154407173*u2*x*y2*z2 - 
     0.002413314930281352*u3*x*y2*z2 - 0.06127670710966516*x2*y2*z2 + 
     0.013871417923393456*u*x2*y2*z2 - 0.0013168048909375015*u2*x2*y2*
      z2 + 0.010639264920472607*x3*y2*z2 - 0.001066169465757209*u*x3*y2*
      z2 - 0.0009735837207608611*x4*y2*z2 - 0.24253233379691627*y3*z2 - 
     0.40107927043016406*lnbara*y3*z2 + 0.030364657125022076*u*y3*z2 + 
     0.11585721384404363*lnbara*u*y3*z2 - 0.006578054159192456*u2*y3*
      z2 - 0.023031675044845268*lnbara*u2*y3*z2 + 
     0.000840674612475661*u3*y3*z2 + 0.002233394751425484*lnbara*u3*y3*
      z2 - 0.11605350127876586*x*y3*z2 + 0.025509552204284115*u*x*y3*
      z2 - 0.002413314930281352*u2*x*y3*z2 + 0.012794033589086507*x2*y3*
      z2 - 0.0013398832907078044*u*x2*y3*z2 - 0.0009464600952786589*x3*
      y3*z2 + 0.1314548937165319*y4*z2 + 0.16767848269494548*lnbara*y4*
      z2 - 0.011452711779727507*u*y4*z2 - 0.027777777777777776*lnbara*u*
      y4*z2 + 0.0009868303536549605*u2*y4*z2 + 
     0.0024078266340730905*lnbara*u2*y4*z2 + 0.027269607614821036*x*y4*
      z2 - 0.0026559689223197088*u*x*y4*z2 - 0.0012856369475801259*x2*y4*
      z2 - 0.04025554707724428*y5*z2 - 0.04254600335127144*lnbara*y5*
      z2 + 0.001686825413567301*u*y5*z2 + 0.0030639349524580017*lnbara*u*
      y5*z2 - 0.002968292254510239*x*y5*z2 + 0.005326516205331389*y6*
      z2 + 0.004887855481301699*lnbara*y6*z2 - 0.02418842311395387*z3 - 
     0.22072850754036075*lnbara*z3 + 0.5*lnbara2*z3 + 
     0.8427013418823283*u*z3 + 1.0243929103830327*lnbara*u*z3 - 
     0.24253233379691627*u2*z3 - 0.40107927043016406*lnbara*u2*z3 + 
     0.09582209022612168*u3*z3 + 0.1388888888888889*lnbara*u3*z3 - 
     0.025816315960645302*u4*z3 - 0.03161639028525199*lnbara*u4*z3 + 
     0.0031926388953996293*u5*z3 + 0.003384978503667747*lnbara*u5*z3 - 
     1.1835704823433206*x*z3 + 0.3861281127196754*u*x*z3 - 
     0.11605350127876586*u2*x*z3 + 0.02397698423859682*u3*x*z3 - 
     0.0024003011749299604*u4*x*z3 + 0.2991824376666963*x2*z3 - 
     0.07195240673537354*u*x2*z3 + 0.012794033589086507*u2*x2*z3 - 
     0.0011574074074074073*u3*x2*z3 - 0.08800590165206242*x3*z3 + 
     0.012242864018321833*u*x3*z3 - 0.0009464600952786589*u2*x3*z3 + 
     0.01850712766637904*x4*z3 - 0.0011100206960523984*u*x4*z3 - 
     0.0018937975809947979*x5*z3 + 0.8427013418823283*y*z3 + 
     1.0243929103830327*lnbara*y*z3 - 0.0913640989978505*u*y*z3 - 
     0.36315903776863345*lnbara*u*y*z3 + 0.030364657125022076*u2*y*z3 + 
     0.11585721384404363*lnbara*u2*y*z3 - 0.009090637005677775*u3*y*z3 - 
     0.024846655495761868*lnbara*u3*y*z3 + 0.001233630975633597*u4*y*z3 + 
     0.0025474832491138625*lnbara*u4*y*z3 + 0.3861281127196754*x*y*z3 - 
     0.12667800725746564*u*x*y*z3 + 0.025509552204284115*u2*x*y*z3 - 
     0.0024597600243423225*u3*x*y*z3 - 0.07195240673537354*x2*y*z3 + 
     0.014778616900380764*u*x2*y*z3 - 0.0013398832907078044*u2*x2*y*z3 + 
     0.012242864018321833*x3*y*z3 - 0.001118126726942837*u*x3*y*z3 - 
     0.0011100206960523984*x4*y*z3 - 0.24253233379691627*y2*z3 - 
     0.40107927043016406*lnbara*y2*z3 + 0.030364657125022076*u*y2*z3 + 
     0.11585721384404363*lnbara*u*y2*z3 - 0.006578054159192456*u2*y2*
      z3 - 0.023031675044845268*lnbara*u2*y2*z3 + 
     0.000840674612475661*u3*y2*z3 + 0.002233394751425484*lnbara*u3*y2*
      z3 - 0.11605350127876586*x*y2*z3 + 0.025509552204284115*u*x*y2*
      z3 - 0.002413314930281352*u2*x*y2*z3 + 0.012794033589086507*x2*y2*
      z3 - 0.0013398832907078044*u*x2*y2*z3 - 0.0009464600952786589*x3*
      y2*z3 + 0.09582209022612168*y3*z3 + 0.1388888888888889*lnbara*y3*
      z3 - 0.009090637005677775*u*y3*z3 - 0.024846655495761868*lnbara*u*
      y3*z3 + 0.000840674612475661*u2*y3*z3 + 0.002233394751425484*
      lnbara*u2*y3*z3 + 0.02397698423859682*x*y3*z3 - 
     0.0024597600243423225*u*x*y3*z3 - 0.0011574074074074073*x2*y3*z3 - 
     0.025816315960645302*y4*z3 - 0.03161639028525199*lnbara*y4*z3 + 
     0.001233630975633597*u*y4*z3 + 0.0025474832491138625*lnbara*u*y4*
      z3 - 0.0024003011749299604*x*y4*z3 + 0.0031926388953996293*y5*z3 + 
     0.003384978503667747*lnbara*y5*z3 - 0.09522252146289166*z4 - 
     0.23628582076606544*lnbara*z4 - 0.625*lnbara2*z4 - 
     0.7951261784143264*u*z4 - 0.7330635157257923*lnbara*u*z4 + 
     0.1314548937165319*u2*z4 + 0.16767848269494548*lnbara*u2*z4 - 
     0.025816315960645302*u3*z4 - 0.03161639028525199*lnbara*u3*z4 + 
     0.0027549479207358792*u4*z4 + 0.0030360036294498475*lnbara*u4*z4 + 
     0.8409152071501348*x*z4 - 0.16392362871832045*u*x*z4 + 
     0.027269607614821036*u2*x*z4 - 0.0024003011749299604*u3*x*z4 - 
     0.12240619864328864*x2*z4 + 0.01670238433430695*u*x2*z4 - 
     0.0012856369475801259*u2*x2*z4 + 0.019374391150491253*x3*z4 - 
     0.0011979335791530209*u*x3*z4 - 0.0017045245923250636*x4*z4 - 
     0.7951261784143264*y*z4 - 0.7330635157257923*lnbara*y*z4 + 
     0.06982791893773221*u*y*z4 + 0.1565120644824315*lnbara*u*y*z4 - 
     0.011452711779727507*u2*y*z4 - 0.027777777777777776*lnbara*u2*y*z4 + 
     0.001233630975633597*u3*y*z4 + 0.0025474832491138625*lnbara*u3*y*
      z4 - 0.16392362871832045*x*y*z4 + 0.03044014297425832*u*x*y*z4 - 
     0.0026559689223197088*u2*x*y*z4 + 0.01670238433430695*x2*y*z4 - 
     0.0015161758891802588*u*x2*y*z4 - 0.0011979335791530209*x3*y*z4 + 
     0.1314548937165319*y2*z4 + 0.16767848269494548*lnbara*y2*z4 - 
     0.011452711779727507*u*y2*z4 - 0.027777777777777776*lnbara*u*y2*z4 + 
     0.0009868303536549605*u2*y2*z4 + 0.0024078266340730905*lnbara*u2*y2*
      z4 + 0.027269607614821036*x*y2*z4 - 0.0026559689223197088*u*x*y2*
      z4 - 0.0012856369475801259*x2*y2*z4 - 0.025816315960645302*y3*
      z4 - 0.03161639028525199*lnbara*y3*z4 + 0.001233630975633597*u*y3*
      z4 + 0.0025474832491138625*lnbara*u*y3*z4 - 
     0.0024003011749299604*x*y3*z4 + 0.0027549479207358792*y4*z4 + 
     0.0030360036294498475*lnbara*y4*z4 + 0.22604544710601693*z5 + 
     0.4822540629031693*lnbara*z5 + 0.5*lnbara2*z5 + 
     0.4433128915181007*u*z5 + 0.3414643034610109*lnbara*u*z5 - 
     0.04025554707724428*u2*z5 - 0.04254600335127144*lnbara*u2*z5 + 
     0.0031926388953996293*u3*z5 + 0.003384978503667747*lnbara*u3*z5 - 
     0.3900171933454372*x*z5 + 0.041892626112825314*u*x*z5 - 
     0.002968292254510239*u2*x*z5 + 0.030656891033297922*x2*z5 - 
     0.0018042267625014755*u*x2*z5 - 0.002032085124576991*x3*z5 + 
     0.4433128915181007*y*z5 + 0.3414643034610109*lnbara*y*z5 - 
     0.024857026746162542*u*y*z5 - 0.040382603570750374*lnbara*u*y*z5 + 
     0.001686825413567301*u2*y*z5 + 0.0030639349524580017*lnbara*u2*y*
      z5 + 0.041892626112825314*x*y*z5 - 0.0033567831013237934*u*x*y*z5 - 
     0.0018042267625014755*x2*y*z5 - 0.04025554707724428*y2*z5 - 
     0.04254600335127144*lnbara*y2*z5 + 0.001686825413567301*u*y2*z5 + 
     0.0030639349524580017*lnbara*u*y2*z5 - 0.002968292254510239*x*y2*
      z5 + 0.0031926388953996293*y3*z5 + 0.003384978503667747*lnbara*y3*
      z5 - 0.1957908218348025*z6 - 0.35494846593858825*lnbara*z6 - 
     0.25*lnbara2*z6 - 0.1371917147080626*u*z6 - 
     0.09290899944145475*lnbara*u*z6 + 0.005326516205331389*u2*z6 + 
     0.004887855481301699*lnbara*u2*z6 + 0.10582255873310466*x*z6 - 
     0.0048318008295796825*u*x*z6 - 0.0034920303557606663*x2*z6 - 
     0.1371917147080626*y*z6 - 0.09290899944145475*lnbara*y*z6 + 
     0.0035777513655361887*u*y*z6 + 0.004687810626819727*lnbara*u*y*z6 - 
     0.0048318008295796825*x*y*z6 + 0.005326516205331389*y2*z6 + 
     0.004887855481301699*lnbara*y2*z6 + 0.08002035919323222*z7 + 
     0.12795927582286945*lnbara*z7 + 0.07142857142857142*lnbara2*z7 + 
     0.018256104537349046*u*z7 + 0.011206496836004519*lnbara*u*z7 - 
     0.012739270908917709*x*z7 + 0.018256104537349046*y*z7 + 
     0.011206496836004519*lnbara*y*z7 - 0.012974162169876576*z8 - 
     0.01879653368685981*lnbara*z8 - 0.008928571428571428*lnbara2*z8;

  ttothei = 1.0L;
  result = Fbarexp[0];

  for (i=1; i<nTerms; i++) {
    ttothei *= tinit;
    result += Fbarexp[i]*ttothei;
  }
  foo->value = a * result;

  ttothei = 1.0L;
  result = Fbarexp[1];

  for (i=2; i<nTerms; i++) {
    ttothei *= tinit;
    result += i*Fbarexp[i]*ttothei;
  }
  foo->deriv = a * result;

  return 0;
}


