/* Analytic evaluations where possible. */

#include "internal.h"

/* ******************************************************************* */

int TVIL_CaseSpecial (TVIL_DATA *foo)
{
  int success = 1;
  int i, tmpWarns;

  /* Temporarily disable WARNs */
  tmpWarns = printWarns;
  printWarns = NO;

  for (i=0; i<NUM_I_FUNCS; i++)
    success *= TVIL_AnalyticITYPE (&(foo->II[i]), foo->qq);

  for (i=0; i<NUM_F_FUNCS; i++)
    success *= TVIL_AnalyticFBARTYPE (&(foo->FBAR[i]), foo->qq);

  for (i=0; i<NUM_G_FUNCS; i++)
    success *= TVIL_AnalyticGTYPE (&(foo->G[i]), foo->qq);

  /* Don't need this either: H has already been evaluated any time we
     call this routine, or else it is already known not to be
     analytic. */
  /* success *= TVIL_AnalyticHTYPE (&(foo->H), foo->qq); */

  /* Restore previous warnings setting: */
  printWarns = tmpWarns;

  return success;
}
