/* Routines for setup and initialization of I-type functions */

#include "internal.h"

/* **************************************************************** */

void TVIL_SetParamsI (TVIL_ITYPE *foo,
		      int whichfun,
		      TVIL_REAL x,
		      TVIL_REAL y,
		      TVIL_REAL z)
{
  foo->which = whichfun;
  foo->arg[0] = x;
  foo->arg[1] = y;
  foo->arg[2] = z;

  return;
}

/* **************************************************************** */

void TVIL_ConstructI (TVIL_ITYPE *foo)
{
  int i;
  TVIL_REAL x, y, z;

  x = foo->arg[0];
  y = foo->arg[1];
  z = foo->arg[2];

  /* 
     For these arrays, the indices mean: 
     0 <-> +
     1 <-> -
     2 <-> 0
  */

  foo->p[0] = TVIL_Rplus (x, y, z);
  foo->p[1] = TVIL_Rminus (x, y, z);

  foo->cII[0] = foo->cII[1] = 0.5L;

  for (i=0; i<2; i++) {
    foo->cILL_012[i] = 0.25L*(a + (foo->arg[0] + foo->arg[1] - foo->arg[2] - a)*foo->p[i]);
    foo->cILL_021[i] = 0.25L*(a + (foo->arg[0] + foo->arg[2] - foo->arg[1] - a)*foo->p[i]);
    foo->cILL_120[i] = 0.25L*(a + (foo->arg[1] + foo->arg[2] - foo->arg[0] - a)*foo->p[i]);
  }

  for (i=0; i<2; i++) {
    foo->cIL_012[i] = (a - foo->arg[0])*(foo->p[i]) - a;
    foo->cIL_102[i] = (a - foo->arg[1])*(foo->p[i]) - a;
    foo->cIL_201[i] = (a - foo->arg[2])*(foo->p[i]) - a;
  }

  foo->cIL_012[2] = a - foo->arg[0];
  foo->cIL_102[2] = a - foo->arg[1];
  foo->cIL_201[2] = a - foo->arg[2];

  for (i=0; i<2; i++)
    foo->cI[i] = 5.L*(3.L*a + (foo->arg[0] + foo->arg[1] + foo->arg[2] - 3.L*a)*foo->p[i])/4.L;

  foo->cI[2] = 2.L*(foo->arg[0] + foo->arg[1] + foo->arg[2]) - 6.0L*a;

  return;
}

/* **************************************************************** */
