/* Routines for setup and initialization of G-type functions */

#include "internal.h"

TVIL_REAL TVIL_cGF1 (TVIL_REAL w, TVIL_REAL u, TVIL_REAL z)
{
  if (TVIL_NonZero (u - z))
    return -(u - w)/(u - z);
  else
    return 0.0L;
}

/* **************************************************************** */

TVIL_REAL TVIL_cGF4 (TVIL_REAL w, TVIL_REAL u, TVIL_REAL z)
{
  if (TVIL_NonZero (u - z))
    return (u - w + TVIL_SQRT(u*u + w*w + z*z - u*w - u*z - w*z))/(2*(u - z));
  else
    return TVIL_Sign (w - u)/4.0L;
}

/* **************************************************************** */

TVIL_REAL TVIL_cGF5 (TVIL_REAL w, TVIL_REAL u, TVIL_REAL z)
{
  if (TVIL_NonZero (u - z))
    return (u - w - TVIL_SQRT(u*u + w*w + z*z - u*w - u*z - w*z))/(2*(u - z));
  else
    return -TVIL_Sign (w - u)/4.0L;
}

/* **************************************************************** */
/* **************************************************************** */

void TVIL_SetParamsG (TVIL_GTYPE *foo,
		      int         whichfun,
		      TVIL_REAL   w, 
		      TVIL_REAL   u, 
		      TVIL_REAL   z,
		      TVIL_REAL   x,
		      TVIL_REAL   y)
{
  foo->which = whichfun;
  foo->arg[0] = w;
  foo->arg[1] = u;
  foo->arg[2] = z;
  foo->arg[3] = x;
  foo->arg[4] = y;

  if (w < 0.0 || u < 0.0 || z < 0.0 || x < 0.0 || y < 0.0)
    foo->hasNegativeArg = YES;
  else
    foo->hasNegativeArg = NO;

  return;
}

/* **************************************************************** */

void TVIL_ConstructG (TVIL_GTYPE *foo)
{
  TVIL_REAL w, u, z, x, y;

  w = foo->arg[0];
  u = foo->arg[1];
  z = foo->arg[2];
  x = foo->arg[3];
  y = foo->arg[4];

  foo->p1 = a/(a - w);
  foo->p2 = TVIL_Rplus (x,y,w);
  foo->p3 = TVIL_Rminus (x,y,w);
  foo->p4 = TVIL_Rplus (u,z,w);
  foo->p5 = TVIL_Rminus (u,z,w);

  /* GF */
  /* Tolerable redundancy here... */
  foo->cGF1[0] = TVIL_cGF1 (w,u,z);
  foo->cGF4[0] = TVIL_cGF4 (w,u,z);
  foo->cGF5[0] = TVIL_cGF5 (w,u,z);
  foo->cGF_p4[0] = foo->p4;
  foo->cGF_p5[0] = foo->p5;

  foo->cGF1[1] = TVIL_cGF1 (w,z,u);
  foo->cGF4[1] = TVIL_cGF4 (w,z,u);
  foo->cGF5[1] = TVIL_cGF5 (w,z,u);
  foo->cGF_p4[1] = foo->p4; 
  foo->cGF_p5[1] = foo->p5;

  foo->cGF1[2] = TVIL_cGF1 (w,x,y);
  foo->cGF4[2] = TVIL_cGF4 (w,x,y);
  foo->cGF5[2] = TVIL_cGF5 (w,x,y);
  foo->cGF_p4[2] = foo->p2;
  foo->cGF_p5[2] = foo->p3;

  foo->cGF1[3] = TVIL_cGF1 (w,y,x);
  foo->cGF4[3] = TVIL_cGF4 (w,y,x);
  foo->cGF5[3] = TVIL_cGF5 (w,y,x);
  foo->cGF_p4[3] = foo->p2;
  foo->cGF_p5[3] = foo->p3;

  /* GI */
  foo->cGI_p2[0] = foo->p2;
  foo->cGI_p3[0] = foo->p3;

  foo->cGI_p2[1] = foo->p4;
  foo->cGI_p3[1] = foo->p5;

  /* GL */
  foo->cGL_p2[0] = foo->p2;
  foo->cGL_p3[0] = foo->p3;

  foo->cGL_p2[1] = foo->p2;
  foo->cGL_p3[1] = foo->p3;

  foo->cGL_p2[2] = foo->p4;
  foo->cGL_p3[2] = foo->p5;

  foo->cGL_p2[3] = foo->p4;
  foo->cGL_p3[3] = foo->p5;

  /* G */
  foo->cG0 = -11*a - w + 3*u + 3*x + 3*y + 3*z;
  foo->cG1 = 11*a*(4*w - u - x - y - z)/(12*(a - w));
  foo->cG2 = 175*a/48 + (foo->p2)*(-175*a - 19*w + 56*u + 56*z + 41*x + 41*y)/48;
  foo->cG3 = 175*a/48 + (foo->p3)*(-175*a - 19*w + 56*u + 56*z + 41*x + 41*y)/48;
  foo->cG4 = 175*a/48 + (foo->p4)*(-175*a - 19*w + 56*x + 56*y + 41*u + 41*z)/48;
  foo->cG5 = 175*a/48 + (foo->p5)*(-175*a - 19*w + 56*x + 56*y + 41*u + 41*z)/48;

  return;
}

/* **************************************************************** */
