/* ******************************************************************* */
/*              EVALUATION DRIVER PROGRAM                              */
/* ******************************************************************* */

#include "internal.h"
#include "3vil_params.h"

/* ******************************************************************* */

int TVIL_Evaluate (TVIL_DATA *foo)
{
  int status = 1;
  int isAnalytic = 0;
  int tmpWarns;

  if (foo->isInitialized != YES)
    TVIL_Error("TVIL_Evaluate",
	       "You must first set parameter values using TVIL_SetParameters!", 3);

  /* Decide if this is a special case known analytically, or a generic
     case that requires Runge-Kutta evaluation: */

  /* Temporarily disable WARNs */
  tmpWarns = printWarns;
  printWarns = NO;

  if (foo->doAnalytic == TRUE) {
    isAnalytic = TVIL_AnalyticHTYPE (&(foo->H), foo->qq);
  }
  else isAnalytic = FALSE;

  if (isAnalytic == TRUE) {
    if (0 == TVIL_CaseSpecial (foo))
      TVIL_Error("TVIL_Evaluate",
   		 "This can't happen! TVIL_CaseSpecial returned 0 when isAnalytic is TRUE.", 1);
    foo->status = ANALYTIC;
  }
  else {
    /* Generic evaluation by integration: */
    TVIL_CaseGeneric (foo);

    if (foo->doAnalytic) {
      /* The following puts in the analytic results for I, FBAR, G,
	 and H, if available. But leaving it out allows debugging of
	 the RK evaluation of analytic cases, which is quite
	 useful. */
      TVIL_CaseSpecial (foo);
    }
  }

  /* Set additional functions: */
  /* TVIL_SetAllFs (foo); */
  TVIL_SetAllEs (foo);
  TVIL_SetBold (foo);

  /* This is now done in CaseSpecial: */
  /* TVIL_SetAllIs (foo); */

  /* Restore initial warning status */
  printWarns = tmpWarns;

  /* Implement status codes eventually */
  return status;
}
