/* Derivative of an H function with respect to t. */

#include "internal.h"

/* **************************************************************** */

TVIL_COMPLEX TVIL_dHdt (TVIL_HTYPE foo, TVIL_COMPLEX t, TVIL_REAL Q2)
{
  int i, j;
  TVIL_COMPLEX result = 0.0L + 0.0L*I;
  TVIL_COMPLEX U, V, W, X, Y, Z;
  TVIL_COMPLEX lnbarU, lnbarV, lnbarW, lnbarX, lnbarY, lnbarZ;
  TVIL_COMPLEX temp1[6], temp2[6], fac1[6], fac2[6];
  TVIL_COMPLEX tToThe[8];
  TVIL_COMPLEX numHG, numH, denHG, denH;

  tToThe[0] = 1.0;
  for (j=1; j<8; j++)
    tToThe[j] = tToThe[j-1]*t;

  U = a + t*(foo.arg[0] - a);
  V = a + t*(foo.arg[1] - a);
  W = a + t*(foo.arg[2] - a);
  X = a + t*(foo.arg[3] - a);
  Y = a + t*(foo.arg[4] - a);
  Z = a + t*(foo.arg[5] - a);

  lnbarU = TVIL_CLOG (U/Q2);
  lnbarV = TVIL_CLOG (V/Q2);
  lnbarW = TVIL_CLOG (W/Q2);
  lnbarX = TVIL_CLOG (X/Q2);
  lnbarY = TVIL_CLOG (Y/Q2);
  lnbarZ = TVIL_CLOG (Z/Q2);

  temp1[0] = lnbarX; temp2[0] = lnbarW;
  temp1[1] = lnbarW; temp2[1] = lnbarX;
  temp1[2] = lnbarZ; temp2[2] = lnbarV;
  temp1[3] = lnbarV; temp2[3] = lnbarZ;
  temp1[4] = lnbarY; temp2[4] = lnbarU;
  temp1[5] = lnbarU; temp2[5] = lnbarY;

  fac1[0] = X; fac2[0] = W;
  fac1[1] = W; fac2[1] = X;
  fac1[2] = Z; fac2[2] = V;
  fac1[3] = V; fac2[3] = Z;
  fac1[4] = Y; fac2[4] = U;
  fac1[5] = U; fac2[5] = Y;

  for (i=0; i<6; i++) {

    numHG = foo.cHGnum[i][0];
    denHG = foo.cHGden[i][0];

    for (j=1; j<5; j++) {
      numHG += (foo.cHGnum[i][j]) * tToThe[j];
      denHG += (foo.cHGden[i][j]) * tToThe[j];
    }

    for (j=5; j<8; j++)
      denHG += (foo.cHGden[i][j]) * tToThe[j];

    result += (numHG/denHG) *
      (*(foo.gval[i]) - 
       (*(foo.fval[i][0]) - *(foo.ival[i][0]) * temp1[i]) - 
       (*(foo.fval[i][1]) - *(foo.ival[i][1]) * temp1[i]) +
       (2 - temp1[i]) * (*(foo.ival[i][2]) + *(foo.ival[i][3])) +
       fac2[i]*temp2[i] + fac1[i]*temp1[i]/2 - 5*fac1[i]/2 - 7*fac2[i]/3);
  }

  numH  = foo.cHnum[0];
  denH  = foo.cHden[0];

  for (j=1; j<3; j++) {
    numH += foo.cHnum[j]*tToThe[j];
    denH += foo.cHden[j]*tToThe[j];
  }

  denH += foo.cHden[3]*tToThe[3];

  result += Zeta3*numH/denH;

  return result;
}
