/* Miscellaneous useful constants.  Users who #include this file
   should be careful to insure that there are no name conflicts with
   their own variables or functions. */

#ifndef TSIL_GLOBAL_H
#define TSIL_GLOBAL_H

/* Status codes (status) */
enum {UNEVALUATED, ANALYTIC, REAXIS, CONTOUR};

/* Number of each type of function (could just be hardwired) */
#define NUM_I_FUNCS 16
#define NUM_F_FUNCS 12
#define NUM_E_FUNCS 3
#define NUM_G_FUNCS 6

/* Maximum number of posible poles on Re t axis: */
/* So far this is poles associated with I functions (32) and FBAR
   functions (24) and the H function (3). */
#define NUM_POLES 59

/* Enums for indexing */
enum {Iuvx, Ixyz, Iuxy, Ivxz, Iuwz, Ivwy, Iuwy, Ivwz, Ivyz, Iwxy, 
      Iuvz, Iuwx, Iuyz, Iwxz, Iuvy, Ivwx};
enum {uvx, xyz, uxy, vxz, uwz, vwy, uwy, vwz, vyz, wxy, 
      uvz, uwx, uyz, wxz, uvy, vwx};
enum {_124, _456, _145, _246, _136, _235, _135, _236, _256, _345,
      _126, _134, _156, _346, _125, _234};

enum {Fwuxy, Fwvxz, Fxuwy, Fxvwz, Fuvyz, Fuwxy, 
      Fyuvz, Fyuwx, Fvuyz, Fvwxz, Fzuvy, Fzvwx};
enum {wuxy, wvxz, xuwy, xvwz, uvyz, uwxy, 
      yuvz, yuwx, vuyz, vwxz, zuvy, zvwx};
enum {_3145, _3246, _4135, _4236, _1256, _1345, 
      _5126, _5134, _2156, _2346, _6125, _6234};

enum {Gwuzvy, Gxuvyz, Guvxwz, Gyvwxz, Gvuxwy, Gzuwxy};
enum {wuzvy, xuvyz, uvxwz, yvwxz, vuxwy, zuwxy};
enum {_31625, _41256, _12436, _52346, _21435, _61345};

#endif /* tsil_global.h */
