/* Prototypes for functions not in the user API */

#ifndef TVIL_FUNCS_H
#define TVIL_FUNCS_H

#include "3vil.h"
#include "internal.h"

/* 3scale.c: */
int TVIL_NumZeroArgs (void);
int TVIL_IsThreeScaleCase (int *, int *);
void TVIL_CaseGeneric_3s (void);

/* 3scaleA.c: */
TVIL_COMPLEX TVIL_dFBARdt_3sA (TVIL_FBARTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dGdt_3sA (TVIL_GTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dHdt_3sA (TVIL_HTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dIdt_3sA (TVIL_ITYPE *, TVIL_COMPLEX, TVIL_REAL);
int TVIL_InitialFBAR_3sA (TVIL_FBARTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialG_3sA (TVIL_GTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialH_3sA (TVIL_HTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialI_3sA (TVIL_ITYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_SetupFunctions_3sA (void);
void TVIL_CaseGeneric_3sA (void);
void TVIL_SetupFBAR_3sA (TVIL_FBARTYPE *);
void TVIL_SetupG_3sA (TVIL_GTYPE *);
void TVIL_SetupH_3sA (TVIL_HTYPE *);
void TVIL_SetupI_3sA (TVIL_ITYPE *);

/* 3scaleB.c: */
TVIL_COMPLEX TVIL_dFBARdt_3sB (TVIL_FBARTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dGdt_3sB (TVIL_GTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dHdt_3sB (TVIL_HTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dIdt_3sB (TVIL_ITYPE *, TVIL_COMPLEX, TVIL_REAL);
int TVIL_InitialFBAR_3sB (TVIL_FBARTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialG_3sB (TVIL_GTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialH_3sB (TVIL_HTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialI_3sB (TVIL_ITYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_SetupFunctions_3sB (void);
void TVIL_CaseGeneric_3sB (void);
void TVIL_SetupFBAR_3sB (TVIL_FBARTYPE *);
void TVIL_SetupG_3sB (TVIL_GTYPE *);
void TVIL_SetupH_3sB (TVIL_HTYPE *);
void TVIL_SetupI_3sB (TVIL_ITYPE *);

/* 3scaleC.c: */
TVIL_COMPLEX TVIL_dFBARdt_3sC (TVIL_FBARTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dGdt_3sC (TVIL_GTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dHdt_3sC (TVIL_HTYPE *, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_dIdt_3sC (TVIL_ITYPE *, TVIL_COMPLEX, TVIL_REAL);
int TVIL_InitialFBAR_3sC (TVIL_FBARTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialG_3sC (TVIL_GTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialH_3sC (TVIL_HTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_InitialI_3sC (TVIL_ITYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_SetupFunctions_3sC (void);
void TVIL_CaseGeneric_3sC (void);
void TVIL_SetupFBAR_3sC (TVIL_FBARTYPE *);
void TVIL_SetupG_3sC (TVIL_GTYPE *);
void TVIL_SetupH_3sC (TVIL_HTYPE *);
void TVIL_SetupI_3sC (TVIL_ITYPE *);

/* analyticA.c: */
TVIL_COMPLEX TVIL_A (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Ap (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Aeps (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Aeps2 (TVIL_REAL, TVIL_REAL);

/* analyticE.c: */
TVIL_COMPLEX TVIL_E00xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_E0xyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Exxyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
int TVIL_SetE (TVIL_ETYPE *, TVIL_REAL);
int TVIL_SetAllEs (TVIL_RESULT *);

/* analyticF.c: */
TVIL_COMPLEX TVIL_Fx000 (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Fx00x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Fx0xx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Fxxxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Fx0yy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Fy0xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Fxxyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Fx00y (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBAR0000 ();
TVIL_COMPLEX TVIL_FBAR000x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBAR00xx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARx000 (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARx00x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARx0xx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBAR0xxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARxxxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARxxyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARx0xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARx0yy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARx00y (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBAR00xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBAR0xxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARxxxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_FBARyxxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
int TVIL_AnalyticFBARTYPE (TVIL_FBARTYPE *, TVIL_REAL);
int TVIL_FBARanalytic (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_COMPLEX *);
int TVIL_Fanalytic (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_COMPLEX *);
int TVIL_InitialFBAR (TVIL_FBARTYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_SetAllFs (TVIL_RESULT *);
int TVIL_SetF (TVIL_FBARTYPE *, TVIL_REAL);

/* analyticG.c: */
TVIL_COMPLEX TVIL_G00000 (void);
TVIL_COMPLEX TVIL_G0000x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G000xx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G00x0x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G00xxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G0xxxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0000 (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx000x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx00xx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0x0x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0xxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gxxxxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G000xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G00x0y (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx000y (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx00yy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0x0y (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0y0y (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G0xxyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G0xyxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G00yxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G00xxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_G0xxxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0xxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0xyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gyxxxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gxxyxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx00xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gy0xxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0yxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gx0yxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gyxxyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gxxxxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Gyxxxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
int TVIL_AnalyticGTYPE (TVIL_GTYPE *, TVIL_REAL);
int TVIL_Ganalytic (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_COMPLEX *);
int TVIL_InitialG (TVIL_GTYPE *, TVIL_REAL, TVIL_COMPLEX);

/* analyticH.c: */
TVIL_COMPLEX TVIL_H00000x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0000xx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00xx00 (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H000xxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00x0xx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00xx0x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00xxxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xxx0x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xxxxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Hxxxxxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0000xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00xy00 (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Hxx00yy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Hxx0yxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00xyxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00xxxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00y0xx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00xx0y (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00xy0x (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xyxxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00yxyx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H000yxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00yyxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H00yxxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xxx0y (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xxyyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xxxxy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xxxyy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xyyxx (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_H0xyy0x (TVIL_REAL, TVIL_REAL, TVIL_REAL);

int TVIL_AnalyticHTYPE (TVIL_HTYPE *, TVIL_REAL);
int TVIL_Hanalytic (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_COMPLEX *);
int TVIL_InitialH (TVIL_HTYPE *, TVIL_REAL, TVIL_COMPLEX);

/* analyticI.c: */
TVIL_COMPLEX TVIL_I2 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_I200x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_I20xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_I2_complex_args (TVIL_COMPLEX, TVIL_COMPLEX, TVIL_COMPLEX, TVIL_REAL);
TVIL_COMPLEX TVIL_II0 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_II1 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_II2 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Ieps (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Ieps00x (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Ieps0xx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Ieps0xy (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_Iepsxxx (TVIL_REAL, TVIL_REAL);
TVIL_COMPLEX TVIL_TestI (TVIL_ITYPE *, TVIL_REAL);
TVIL_COMPLEX TVIL_TestI_complex (TVIL_ITYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_AnalyticITYPE (TVIL_ITYPE *, TVIL_REAL);
int TVIL_InitialI (TVIL_ITYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_SetAllIs (void);
int TVIL_SetAllIs_complex (TVIL_COMPLEX);
int TVIL_SetI_complex (TVIL_ITYPE *, TVIL_REAL, TVIL_COMPLEX);
int TVIL_TestAllIs (void);
int TVIL_TestAllIs_complex (TVIL_COMPLEX);

/* dFBARdt.c: */
TVIL_COMPLEX TVIL_dFBARdt (TVIL_FBARTYPE *, TVIL_COMPLEX, TVIL_REAL);

/* dGdt.c: */
TVIL_COMPLEX TVIL_dGdt (TVIL_GTYPE *, TVIL_COMPLEX, TVIL_REAL);

/* dHdt.c: */
TVIL_COMPLEX TVIL_dHdt (TVIL_HTYPE *, TVIL_COMPLEX, TVIL_REAL);

/* dIdt.c: */
TVIL_COMPLEX TVIL_dIdt (TVIL_ITYPE *, TVIL_COMPLEX, TVIL_REAL);

/* dilog.c: */
TVIL_COMPLEX TVIL_Dilog (TVIL_COMPLEX);
TVIL_REAL TVIL_dilog_CLZseries_real (TVIL_REAL);
TVIL_REAL TVIL_dilog_largeabs_real (TVIL_REAL);
TVIL_REAL TVIL_dilog_neg_real (TVIL_REAL);
TVIL_REAL TVIL_dilog_real (TVIL_REAL);
TVIL_REAL TVIL_dilog_series_real (TVIL_REAL);

/* functions.c: */
TVIL_REAL TVIL_Delta (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
int TVIL_TestDelta (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_Kappa (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_Lambda (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_Phi (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_R4 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_Rminus (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_Rplus (TVIL_REAL, TVIL_REAL, TVIL_REAL);
int TVIL_Compare (const void *, const void *);
int TVIL_NonZero (TVIL_REAL);
int TVIL_Sign (TVIL_REAL);
int TVIL_NearPole (TVIL_REAL *, TVIL_REAL);
int TVIL_ValidIdentifier (const char *);
int TVIL_IsNumeric (const char *);
void TVIL_SetGlobalVars (TVIL_COMPLEX);

void TVIL_Backup (TVIL_RESULT *);
void TVIL_Restore (TVIL_RESULT *);

TVIL_REAL TVIL_ImMagnitude (const char *);

TVIL_REAL TVIL_ImMagnitudeH (void);
TVIL_REAL TVIL_ImMagnitudeG (int);
TVIL_REAL TVIL_ImMagnitudeFBAR (int);
TVIL_REAL TVIL_ImMagnitudeI (int);

TVIL_REAL TVIL_MaxImMagnitudeG (void);
TVIL_REAL TVIL_MaxImMagnitudeFBAR (void);
TVIL_REAL TVIL_MaxImMagnitudeI (void);
TVIL_REAL TVIL_MaxImMagnitudeGFBARI (void);

TVIL_REAL TVIL_ImMagnitudeHr (TVIL_RESULT *);
TVIL_REAL TVIL_ImMagnitudeGr (TVIL_RESULT *, int);
TVIL_REAL TVIL_ImMagnitudeFBARr (TVIL_RESULT *, int);
TVIL_REAL TVIL_ImMagnitudeIr (TVIL_RESULT *, int);

TVIL_REAL TVIL_MaxImMagnitudeGr (TVIL_RESULT *);
TVIL_REAL TVIL_MaxImMagnitudeFBARr (TVIL_RESULT *);
TVIL_REAL TVIL_MaxImMagnitudeIr (TVIL_RESULT *);

void TVIL_EvaluateAllFunctions (TVIL_RESULT *, int);
void TVIL_IntegrateAllFunctions (TVIL_RESULT *, int);
void TVIL_SetArguments (TVIL_RESULT *);

/* generic.c: */
int TVIL_Integrate (TVIL_COMPLEX, TVIL_COMPLEX, TVIL_REAL *);
int TVIL_MaxSteps (TVIL_COMPLEX);
void TVIL_CaseGeneric (void);
void TVIL_InitialValue (TVIL_COMPLEX);

/* initE.c: */
TVIL_ETYPE *TVIL_SetParamsE (TVIL_ETYPE *, int, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);

/* initFBAR.c: */
TVIL_REAL TVIL_cF0 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cF2 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cF3 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFF22 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFF23 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFL10 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFL13 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFL14 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFL15 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFL20 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFL22 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFL23 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLL12 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLL13 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLL23 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLL24 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLL25 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLLL12 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLLL13 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLLL23 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLLL24 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cFLLL25 (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_FBARTYPE *TVIL_SetupFBAR (TVIL_FBARTYPE *);
TVIL_FBARTYPE *TVIL_SetParamsFBAR (TVIL_FBARTYPE *, int, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_FBARTYPE *TVIL_SetParamsFBAR_3sA (TVIL_FBARTYPE *, int, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);

/* initG.c: */
TVIL_REAL TVIL_cGF1 (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cGF4 (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_REAL TVIL_cGF5 (TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_GTYPE *TVIL_SetupG (TVIL_GTYPE *);
TVIL_GTYPE *TVIL_SetParamsG (TVIL_GTYPE *, int, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_GTYPE *TVIL_SetParamsG_3sA (TVIL_GTYPE *, int, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);

/* initH.c: */
TVIL_HTYPE *TVIL_SetupH (TVIL_HTYPE *);
TVIL_HTYPE *TVIL_SetParamsH (TVIL_HTYPE *, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_HTYPE *TVIL_SetParamsH_3sA (TVIL_HTYPE *, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
void TVIL_cHd1Roots (TVIL_HTYPE *, TVIL_REAL *);
void TVIL_cHGnum (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL,
		  TVIL_REAL, TVIL_REAL *);
void TVIL_cHGden (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL,
		  TVIL_REAL, TVIL_REAL *);
void TVIL_cHnum (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL,
		 TVIL_REAL, TVIL_REAL *);
void TVIL_cHden (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL,
		 TVIL_REAL, TVIL_REAL *);

/* initI.c: */
TVIL_ITYPE *TVIL_SetupI (TVIL_ITYPE *);
TVIL_ITYPE *TVIL_SetParamsI (TVIL_ITYPE *, int, TVIL_REAL, TVIL_REAL, TVIL_REAL);
TVIL_ITYPE *TVIL_SetParamsI_3sA (TVIL_ITYPE *, int, TVIL_REAL, TVIL_REAL, TVIL_REAL);

/* initialize.c: */
int TVIL_SetupFunctions (void);
void TVIL_Setup (void);
int TVIL_Atest (TVIL_REAL, TVIL_REAL, TVIL_REAL, TVIL_REAL);
void TVIL_SetDefault_a (void);

/* perms.c: */
void TVIL_PermuteArgs (TVIL_REAL *, int perm, TVIL_REAL *);

/* rk5.c: */
void TVIL_rk5 (int, TVIL_COMPLEX *, TVIL_COMPLEX);

/* rk6.c: */
int TVIL_rk6 (int, TVIL_COMPLEX *, TVIL_COMPLEX *, TVIL_REAL, int);

/* setbold.c: */
void TVIL_SetBold (TVIL_RESULT *);
void TVIL_SetBoldE (TVIL_ETYPE *);
void TVIL_SetBoldF (TVIL_FBARTYPE *);
void TVIL_SetBoldG (TVIL_GTYPE *);
void TVIL_SetBoldH (TVIL_HTYPE *);
void TVIL_SetBoldI (TVIL_ITYPE *);

/* special.c */
int TVIL_CaseSpecial (TVIL_RESULT *);

/* trilog.c: */
TVIL_COMPLEX TVIL_Trilog (TVIL_COMPLEX);
TVIL_COMPLEX TVIL_Trilogoutofunitdisk (TVIL_COMPLEX);
TVIL_COMPLEX TVIL_TrilogregionA (TVIL_COMPLEX);
TVIL_COMPLEX TVIL_TrilogregionB (TVIL_COMPLEX);
TVIL_COMPLEX TVIL_Trilogseries (TVIL_COMPLEX);
TVIL_COMPLEX TVIL_Trilogunitdisk (TVIL_COMPLEX);

#endif /* TVIL_FUNCS_H */
